# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by lib/unicore/mktables from the Unicode
# database, Version 8.0.0.  Any changes made here will be lost!

use strict;
use warnings;

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

# loc_tools.pl requires this function to be defined
sub ok($@) {
    my ($pass, @msg) = @_;
    print "not " unless $pass;
    print "ok ";
    print ++$Tests;
    print " - ", join "", @msg if @msg;
    print "\n";
}

sub Expect($$$$) {
    my $expected = shift;
    my $ord = shift;
    my $regex  = shift;
    my $warning_type = shift;   # Type of warning message, like 'deprecated'
                                # or empty if none
    my $line   = (caller)[2];

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parens in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($) {
    my $regex  = shift;
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# Break test files (e.g. GCBTest.txt) character that break allowed here
my $breakable_utf8 = my $breakable = chr(utf8::unicode_to_native(0xF7));
utf8::upgrade($breakable_utf8);

# Break test files (e.g. GCBTest.txt) character that indicates can't break
# here
my $nobreak_utf8 = my $nobreak = chr(utf8::unicode_to_native(0xD7));
utf8::upgrade($nobreak_utf8);

my $are_ctype_locales_available;
my $utf8_locale;
chdir 't' if -d 't';
eval { require "./loc_tools.pl" };
if (defined &locales_enabled) {
    $are_ctype_locales_available = locales_enabled('LC_CTYPE');
    if ($are_ctype_locales_available) {
        $utf8_locale = &find_utf8_ctype_locale;
    }
}

# Eval'd so can run on versions earlier than the property is available in
my $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}]/';

sub _test_break($$) {
    # Test various break property matches.  The 2nd parameter gives the
    # property name.  The input is a line from auxiliary/*Test.txt for the
    # given property.  Each such line is a sequence of Unicode (not native)
    # code points given by their hex numbers, separated by the two characters
    # defined just before this subroutine that indicate that either there can
    # or cannot be a break between the adjacent code points.  All these are
    # tested.
    #
    # For the gcb property extra tests are made.  if there isn't a break, that
    # means the sequence forms an extended grapheme cluster, which means that
    # \X should match the whole thing.  If there is a break, \X should stop
    # there.  This is all converted by this routine into a match: $string =~
    # /(\X)/, Each \X should match the next cluster; and that is what is
    # checked.

    my $template = shift;
    my $break_type = shift;

    my $line   = (caller 1)[2];   # Line number

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # Perl customizes wb.  So change the official tests accordingly
    if ($break_type eq 'wb' && $WB_Extend_or_Format_re) {

        # Split into elements that alternate between code point and
        # break/no-break
        my @line = split / +/, $template;

        # Look at each code point and its following one
        for (my $i = 1; $i <  @line - 1 - 1; $i+=2) {

            # The customization only involves changing some breaks to
            # non-breaks.
            next if $line[$i+1] =~ /$nobreak/;

            my $lhs = chr utf8::unicode_to_native(hex $line[$i]);
            my $rhs = chr utf8::unicode_to_native(hex $line[$i+2]);

            # And it only affects adjacent space characters.
            next if $lhs !~ /\s/u;

            # But, we want to make sure to test spaces followed by a Extend
            # or Format.
            next if $rhs !~ /\s|$WB_Extend_or_Format_re/;

            # To test the customization, add some white-space before this to
            # create a span.  The $lhs white space may or may not be bound to
            # that span, and also with the $rhs.  If the $rhs is a binding
            # character, the $lhs is bound to it and not to the span, unless
            # $lhs is vertical space.  In all other cases, the $lhs is bound
            # to the span.  If the $rhs is white space, it is bound to the
            # $lhs
            my $bound;
            my $span;
            if ($rhs =~ /$WB_Extend_or_Format_re/) {
                if ($lhs =~ /\v/) {
                    $bound = $breakable;
                    $span = $nobreak;
                }
                else {
                    $bound = $nobreak;
                    $span = $breakable;
                }
            }
            else {
                $span = $nobreak;
                $bound = $nobreak;
            }

            splice @line, $i, 0, ( '0020', $nobreak, '0020', $span);
            $i += 4;
            $line[$i+1] = $bound;
        }
        $template = join " ", @line;
    }

    # The input is just the break/no-break symbols and sequences of Unicode
    # code points as hex digits separated by spaces for legibility. e.g.:
    # ÷ 0020 × 0308 ÷ 0020 ÷
    # Convert to native \x format
    $template =~ s/ \s* ( [[:xdigit:]]+ ) \s* /sprintf("\\x{%02X}", utf8::unicode_to_native(hex $1))/gex;
    $template =~ s/ \s* //gx;   # Probably the line above removed all spaces;
                                # but be sure

    # Make a copy of the input with the symbols replaced by \b{} and \B{} as
    # appropriate
    my $break_pattern = $template =~ s/ $breakable /\\b{$break_type}/grx;
    $break_pattern =~ s/ $nobreak /\\B{$break_type}/gx;

    my $display_string = $template =~ s/[$breakable$nobreak]//gr;
    my $string = eval "\"$display_string\"";

    # The remaining massaging of the input is for the \X tests.  Get rid of
    # the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # Delete no-breaks
    $template =~ s/ \s* $nobreak \s* //xg;

    # Split the input into segments that are breakable between them.
    my @should_display = split /\s*$breakable\s*/, $template;
    my @should_match = map { eval "\"$_\"" } @should_display;

    # If a string can be represented in both non-ut8 and utf8, test both cases
    my $display_upgrade = "";
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
            $display_upgrade = " (utf8-upgraded)";
        }

        my @modifiers = qw(a aa d u i);
        if ($are_ctype_locales_available) {
            push @modifiers, "l$utf8_locale" if defined $utf8_locale;

            # The /l modifier has C after it to indicate the locale to try
            push @modifiers, "lC";
        }

        # Test for each of the regex modifiers.
        for my $modifier (@modifiers) {
            my $display_locale = "";

            # For /l, set the locale to what it says to.
            if ($modifier =~ / ^ l (.*) /x) {
                my $locale = $1;
                $display_locale = "(locale = $locale)";
                POSIX::setlocale(&POSIX::LC_CTYPE, $locale);
                $modifier = 'l';
            }

            no warnings qw(locale regexp surrogate);
            my $pattern = "(?$modifier:$break_pattern)";

            # Actually do the test
            my $matched = $string =~ qr/$pattern/;
            print "not " unless $matched;

            # Fancy display of test results
            $matched = ($matched) ? "matched" : "failed to match";
            print "ok ", ++$Tests, " - \"$display_string\" $matched /$pattern/$display_upgrade; line $line $display_locale\n";

            # Repeat with the first \B{} in the pattern.  This makes sure the
            # code in regexec.c:find_byclass() for \B gets executed
            if ($pattern =~ / ( .*? : ) .* ( \\B\{ .* ) /x) {
                my $B_pattern = "$1$2";
                $matched = $string =~ qr/$B_pattern/;
                print "not " unless $matched;
                $matched = ($matched) ? "matched" : "failed to match";
                print "ok ", ++$Tests, " - \"$display_string\" $matched /$B_pattern/$display_upgrade; line $line $display_locale\n";
            }
        }

        next if $break_type ne 'gcb';

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", ord $_ }
                                                    split "", $matches[$i]);
                print "not ok $Tests - In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line\n";
        }
    }

    return;
}

sub Test_GCB($) {
    _test_break(shift, 'gcb');
}

sub Test_LB($) {
    _test_break(shift, 'lb');
}

sub Test_SB($) {
    _test_break(shift, 'sb');
}

sub Test_WB($) {
    _test_break(shift, 'wb');
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

Error('\p{Script=InGreek}');    # Bug #69018
Test_GCB("1100 $nobreak 1161");  # Bug #70940
Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726

# Make sure this gets tested; it was not part of the official test suite at
# the time this was addded.  Note that this is as it would appear in the
# official suite, and gets modified to check for the perl tailoring by
# Test_WB()
Test_WB("$breakable 0020 $breakable 0020 $breakable 0308 $breakable");
Test_LB("$nobreak 200B $nobreak 0020 $nobreak 0020 $breakable 2060 $breakable");
Error('\p{ASCII_Hex_Digit=:=	No}');
Error('\P{ASCII_Hex_Digit=:=	No}');
Expect(1, 103, '\p{ASCII_Hex_Digit=no}', "");
Expect(0, 103, '\p{^ASCII_Hex_Digit=no}', "");
Expect(0, 103, '\P{ASCII_Hex_Digit=no}', "");
Expect(1, 103, '\P{^ASCII_Hex_Digit=no}', "");
Expect(0, 102, '\p{ASCII_Hex_Digit=no}', "");
Expect(1, 102, '\p{^ASCII_Hex_Digit=no}', "");
Expect(1, 102, '\P{ASCII_Hex_Digit=no}', "");
Expect(0, 102, '\P{^ASCII_Hex_Digit=no}', "");
Expect(1, 103, '\p{ASCII_Hex_Digit=--No}', "");
Expect(0, 103, '\p{^ASCII_Hex_Digit=--No}', "");
Expect(0, 103, '\P{ASCII_Hex_Digit=--No}', "");
Expect(1, 103, '\P{^ASCII_Hex_Digit=--No}', "");
Expect(0, 102, '\p{ASCII_Hex_Digit=--No}', "");
Expect(1, 102, '\p{^ASCII_Hex_Digit=--No}', "");
Expect(1, 102, '\P{ASCII_Hex_Digit=--No}', "");
Expect(0, 102, '\P{^ASCII_Hex_Digit=--No}', "");
Error('\p{AHex=		N:=}');
Error('\P{AHex=		N:=}');
Expect(1, 103, '\p{AHex=n}', "");
Expect(0, 103, '\p{^AHex=n}', "");
Expect(0, 103, '\P{AHex=n}', "");
Expect(1, 103, '\P{^AHex=n}', "");
Expect(0, 102, '\p{AHex=n}', "");
Expect(1, 102, '\p{^AHex=n}', "");
Expect(1, 102, '\P{AHex=n}', "");
Expect(0, 102, '\P{^AHex=n}', "");
Expect(1, 103, '\p{AHex:	N}', "");
Expect(0, 103, '\p{^AHex:	N}', "");
Expect(0, 103, '\P{AHex:	N}', "");
Expect(1, 103, '\P{^AHex:	N}', "");
Expect(0, 102, '\p{AHex:	N}', "");
Expect(1, 102, '\p{^AHex:	N}', "");
Expect(1, 102, '\P{AHex:	N}', "");
Expect(0, 102, '\P{^AHex:	N}', "");
Error('\p{Is_ASCII_Hex_Digit=/a/		F}');
Error('\P{Is_ASCII_Hex_Digit=/a/		F}');
Expect(1, 103, '\p{Is_ASCII_Hex_Digit=f}', "");
Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=f}', "");
Expect(0, 103, '\P{Is_ASCII_Hex_Digit=f}', "");
Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=f}', "");
Expect(0, 102, '\p{Is_ASCII_Hex_Digit=f}', "");
Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=f}', "");
Expect(1, 102, '\P{Is_ASCII_Hex_Digit=f}', "");
Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=f}', "");
Expect(1, 103, '\p{Is_ASCII_Hex_Digit=-F}', "");
Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=-F}', "");
Expect(0, 103, '\P{Is_ASCII_Hex_Digit=-F}', "");
Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=-F}', "");
Expect(0, 102, '\p{Is_ASCII_Hex_Digit=-F}', "");
Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=-F}', "");
Expect(1, 102, '\P{Is_ASCII_Hex_Digit=-F}', "");
Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=-F}', "");
Error('\p{Is_AHex=		False/a/}');
Error('\P{Is_AHex=		False/a/}');
Expect(1, 103, '\p{Is_AHex=false}', "");
Expect(0, 103, '\p{^Is_AHex=false}', "");
Expect(0, 103, '\P{Is_AHex=false}', "");
Expect(1, 103, '\P{^Is_AHex=false}', "");
Expect(0, 102, '\p{Is_AHex=false}', "");
Expect(1, 102, '\p{^Is_AHex=false}', "");
Expect(1, 102, '\P{Is_AHex=false}', "");
Expect(0, 102, '\P{^Is_AHex=false}', "");
Expect(1, 103, '\p{Is_AHex=_-false}', "");
Expect(0, 103, '\p{^Is_AHex=_-false}', "");
Expect(0, 103, '\P{Is_AHex=_-false}', "");
Expect(1, 103, '\P{^Is_AHex=_-false}', "");
Expect(0, 102, '\p{Is_AHex=_-false}', "");
Expect(1, 102, '\p{^Is_AHex=_-false}', "");
Expect(1, 102, '\P{Is_AHex=_-false}', "");
Expect(0, 102, '\P{^Is_AHex=_-false}', "");
Error('\p{ASCII_Hex_Digit=_ YES:=}');
Error('\P{ASCII_Hex_Digit=_ YES:=}');
Expect(1, 102, '\p{ASCII_Hex_Digit=yes}', "");
Expect(0, 102, '\p{^ASCII_Hex_Digit=yes}', "");
Expect(0, 102, '\P{ASCII_Hex_Digit=yes}', "");
Expect(1, 102, '\P{^ASCII_Hex_Digit=yes}', "");
Expect(0, 103, '\p{ASCII_Hex_Digit=yes}', "");
Expect(1, 103, '\p{^ASCII_Hex_Digit=yes}', "");
Expect(1, 103, '\P{ASCII_Hex_Digit=yes}', "");
Expect(0, 103, '\P{^ASCII_Hex_Digit=yes}', "");
Expect(1, 102, '\p{ASCII_Hex_Digit=_	yes}', "");
Expect(0, 102, '\p{^ASCII_Hex_Digit=_	yes}', "");
Expect(0, 102, '\P{ASCII_Hex_Digit=_	yes}', "");
Expect(1, 102, '\P{^ASCII_Hex_Digit=_	yes}', "");
Expect(0, 103, '\p{ASCII_Hex_Digit=_	yes}', "");
Expect(1, 103, '\p{^ASCII_Hex_Digit=_	yes}', "");
Expect(1, 103, '\P{ASCII_Hex_Digit=_	yes}', "");
Expect(0, 103, '\P{^ASCII_Hex_Digit=_	yes}', "");
Error('\p{AHex:   /a/	Y}');
Error('\P{AHex:   /a/	Y}');
Expect(1, 102, '\p{AHex=y}', "");
Expect(0, 102, '\p{^AHex=y}', "");
Expect(0, 102, '\P{AHex=y}', "");
Expect(1, 102, '\P{^AHex=y}', "");
Expect(0, 103, '\p{AHex=y}', "");
Expect(1, 103, '\p{^AHex=y}', "");
Expect(1, 103, '\P{AHex=y}', "");
Expect(0, 103, '\P{^AHex=y}', "");
Expect(1, 102, '\p{AHex= y}', "");
Expect(0, 102, '\p{^AHex= y}', "");
Expect(0, 102, '\P{AHex= y}', "");
Expect(1, 102, '\P{^AHex= y}', "");
Expect(0, 103, '\p{AHex= y}', "");
Expect(1, 103, '\p{^AHex= y}', "");
Expect(1, 103, '\P{AHex= y}', "");
Expect(0, 103, '\P{^AHex= y}', "");
Error('\p{Is_ASCII_Hex_Digit::=-	T}');
Error('\P{Is_ASCII_Hex_Digit::=-	T}');
Expect(1, 102, '\p{Is_ASCII_Hex_Digit=t}', "");
Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=t}', "");
Expect(0, 102, '\P{Is_ASCII_Hex_Digit=t}', "");
Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=t}', "");
Expect(0, 103, '\p{Is_ASCII_Hex_Digit=t}', "");
Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=t}', "");
Expect(1, 103, '\P{Is_ASCII_Hex_Digit=t}', "");
Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=t}', "");
Expect(1, 102, '\p{Is_ASCII_Hex_Digit:  T}', "");
Expect(0, 102, '\p{^Is_ASCII_Hex_Digit:  T}', "");
Expect(0, 102, '\P{Is_ASCII_Hex_Digit:  T}', "");
Expect(1, 102, '\P{^Is_ASCII_Hex_Digit:  T}', "");
Expect(0, 103, '\p{Is_ASCII_Hex_Digit:  T}', "");
Expect(1, 103, '\p{^Is_ASCII_Hex_Digit:  T}', "");
Expect(1, 103, '\P{Is_ASCII_Hex_Digit:  T}', "");
Expect(0, 103, '\P{^Is_ASCII_Hex_Digit:  T}', "");
Error('\p{Is_AHex=	:=True}');
Error('\P{Is_AHex=	:=True}');
Expect(1, 102, '\p{Is_AHex=true}', "");
Expect(0, 102, '\p{^Is_AHex=true}', "");
Expect(0, 102, '\P{Is_AHex=true}', "");
Expect(1, 102, '\P{^Is_AHex=true}', "");
Expect(0, 103, '\p{Is_AHex=true}', "");
Expect(1, 103, '\p{^Is_AHex=true}', "");
Expect(1, 103, '\P{Is_AHex=true}', "");
Expect(0, 103, '\P{^Is_AHex=true}', "");
Expect(1, 102, '\p{Is_AHex=_	True}', "");
Expect(0, 102, '\p{^Is_AHex=_	True}', "");
Expect(0, 102, '\P{Is_AHex=_	True}', "");
Expect(1, 102, '\P{^Is_AHex=_	True}', "");
Expect(0, 103, '\p{Is_AHex=_	True}', "");
Expect(1, 103, '\p{^Is_AHex=_	True}', "");
Expect(1, 103, '\P{Is_AHex=_	True}', "");
Expect(0, 103, '\P{^Is_AHex=_	True}', "");
Error('\p{Alphabetic= No:=}');
Error('\P{Alphabetic= No:=}');
Expect(1, 195102, '\p{Alphabetic=no}', "");
Expect(0, 195102, '\p{^Alphabetic=no}', "");
Expect(0, 195102, '\P{Alphabetic=no}', "");
Expect(1, 195102, '\P{^Alphabetic=no}', "");
Expect(0, 195101, '\p{Alphabetic=no}', "");
Expect(1, 195101, '\p{^Alphabetic=no}', "");
Expect(1, 195101, '\P{Alphabetic=no}', "");
Expect(0, 195101, '\P{^Alphabetic=no}', "");
Expect(1, 195102, '\p{Alphabetic:   -_No}', "");
Expect(0, 195102, '\p{^Alphabetic:   -_No}', "");
Expect(0, 195102, '\P{Alphabetic:   -_No}', "");
Expect(1, 195102, '\P{^Alphabetic:   -_No}', "");
Expect(0, 195101, '\p{Alphabetic:   -_No}', "");
Expect(1, 195101, '\p{^Alphabetic:   -_No}', "");
Expect(1, 195101, '\P{Alphabetic:   -_No}', "");
Expect(0, 195101, '\P{^Alphabetic:   -_No}', "");
Error('\p{Alpha=-_n/a/}');
Error('\P{Alpha=-_n/a/}');
Expect(1, 195102, '\p{Alpha=n}', "");
Expect(0, 195102, '\p{^Alpha=n}', "");
Expect(0, 195102, '\P{Alpha=n}', "");
Expect(1, 195102, '\P{^Alpha=n}', "");
Expect(0, 195101, '\p{Alpha=n}', "");
Expect(1, 195101, '\p{^Alpha=n}', "");
Expect(1, 195101, '\P{Alpha=n}', "");
Expect(0, 195101, '\P{^Alpha=n}', "");
Expect(1, 195102, '\p{Alpha=	 N}', "");
Expect(0, 195102, '\p{^Alpha=	 N}', "");
Expect(0, 195102, '\P{Alpha=	 N}', "");
Expect(1, 195102, '\P{^Alpha=	 N}', "");
Expect(0, 195101, '\p{Alpha=	 N}', "");
Expect(1, 195101, '\p{^Alpha=	 N}', "");
Expect(1, 195101, '\P{Alpha=	 N}', "");
Expect(0, 195101, '\P{^Alpha=	 N}', "");
Error('\p{Is_Alphabetic:	:=_F}');
Error('\P{Is_Alphabetic:	:=_F}');
Expect(1, 195102, '\p{Is_Alphabetic=f}', "");
Expect(0, 195102, '\p{^Is_Alphabetic=f}', "");
Expect(0, 195102, '\P{Is_Alphabetic=f}', "");
Expect(1, 195102, '\P{^Is_Alphabetic=f}', "");
Expect(0, 195101, '\p{Is_Alphabetic=f}', "");
Expect(1, 195101, '\p{^Is_Alphabetic=f}', "");
Expect(1, 195101, '\P{Is_Alphabetic=f}', "");
Expect(0, 195101, '\P{^Is_Alphabetic=f}', "");
Expect(1, 195102, '\p{Is_Alphabetic= F}', "");
Expect(0, 195102, '\p{^Is_Alphabetic= F}', "");
Expect(0, 195102, '\P{Is_Alphabetic= F}', "");
Expect(1, 195102, '\P{^Is_Alphabetic= F}', "");
Expect(0, 195101, '\p{Is_Alphabetic= F}', "");
Expect(1, 195101, '\p{^Is_Alphabetic= F}', "");
Expect(1, 195101, '\P{Is_Alphabetic= F}', "");
Expect(0, 195101, '\P{^Is_Alphabetic= F}', "");
Error('\p{Is_Alpha=/a/--false}');
Error('\P{Is_Alpha=/a/--false}');
Expect(1, 195102, '\p{Is_Alpha=false}', "");
Expect(0, 195102, '\p{^Is_Alpha=false}', "");
Expect(0, 195102, '\P{Is_Alpha=false}', "");
Expect(1, 195102, '\P{^Is_Alpha=false}', "");
Expect(0, 195101, '\p{Is_Alpha=false}', "");
Expect(1, 195101, '\p{^Is_Alpha=false}', "");
Expect(1, 195101, '\P{Is_Alpha=false}', "");
Expect(0, 195101, '\P{^Is_Alpha=false}', "");
Expect(1, 195102, '\p{Is_Alpha: false}', "");
Expect(0, 195102, '\p{^Is_Alpha: false}', "");
Expect(0, 195102, '\P{Is_Alpha: false}', "");
Expect(1, 195102, '\P{^Is_Alpha: false}', "");
Expect(0, 195101, '\p{Is_Alpha: false}', "");
Expect(1, 195101, '\p{^Is_Alpha: false}', "");
Expect(1, 195101, '\P{Is_Alpha: false}', "");
Expect(0, 195101, '\P{^Is_Alpha: false}', "");
Error('\p{Alphabetic= Yes/a/}');
Error('\P{Alphabetic= Yes/a/}');
Expect(1, 195101, '\p{Alphabetic=yes}', "");
Expect(0, 195101, '\p{^Alphabetic=yes}', "");
Expect(0, 195101, '\P{Alphabetic=yes}', "");
Expect(1, 195101, '\P{^Alphabetic=yes}', "");
Expect(0, 195102, '\p{Alphabetic=yes}', "");
Expect(1, 195102, '\p{^Alphabetic=yes}', "");
Expect(1, 195102, '\P{Alphabetic=yes}', "");
Expect(0, 195102, '\P{^Alphabetic=yes}', "");
Expect(1, 195101, '\p{Alphabetic=-	yes}', "");
Expect(0, 195101, '\p{^Alphabetic=-	yes}', "");
Expect(0, 195101, '\P{Alphabetic=-	yes}', "");
Expect(1, 195101, '\P{^Alphabetic=-	yes}', "");
Expect(0, 195102, '\p{Alphabetic=-	yes}', "");
Expect(1, 195102, '\p{^Alphabetic=-	yes}', "");
Expect(1, 195102, '\P{Alphabetic=-	yes}', "");
Expect(0, 195102, '\P{^Alphabetic=-	yes}', "");
Error('\p{Alpha=:=Y}');
Error('\P{Alpha=:=Y}');
Expect(1, 195101, '\p{Alpha=y}', "");
Expect(0, 195101, '\p{^Alpha=y}', "");
Expect(0, 195101, '\P{Alpha=y}', "");
Expect(1, 195101, '\P{^Alpha=y}', "");
Expect(0, 195102, '\p{Alpha=y}', "");
Expect(1, 195102, '\p{^Alpha=y}', "");
Expect(1, 195102, '\P{Alpha=y}', "");
Expect(0, 195102, '\P{^Alpha=y}', "");
Expect(1, 195101, '\p{Alpha=__Y}', "");
Expect(0, 195101, '\p{^Alpha=__Y}', "");
Expect(0, 195101, '\P{Alpha=__Y}', "");
Expect(1, 195101, '\P{^Alpha=__Y}', "");
Expect(0, 195102, '\p{Alpha=__Y}', "");
Expect(1, 195102, '\p{^Alpha=__Y}', "");
Expect(1, 195102, '\P{Alpha=__Y}', "");
Expect(0, 195102, '\P{^Alpha=__Y}', "");
Error('\p{Is_Alphabetic=	T/a/}');
Error('\P{Is_Alphabetic=	T/a/}');
Expect(1, 195101, '\p{Is_Alphabetic:t}', "");
Expect(0, 195101, '\p{^Is_Alphabetic:t}', "");
Expect(0, 195101, '\P{Is_Alphabetic:t}', "");
Expect(1, 195101, '\P{^Is_Alphabetic:t}', "");
Expect(0, 195102, '\p{Is_Alphabetic:t}', "");
Expect(1, 195102, '\p{^Is_Alphabetic:t}', "");
Expect(1, 195102, '\P{Is_Alphabetic:t}', "");
Expect(0, 195102, '\P{^Is_Alphabetic:t}', "");
Expect(1, 195101, '\p{Is_Alphabetic=_-T}', "");
Expect(0, 195101, '\p{^Is_Alphabetic=_-T}', "");
Expect(0, 195101, '\P{Is_Alphabetic=_-T}', "");
Expect(1, 195101, '\P{^Is_Alphabetic=_-T}', "");
Expect(0, 195102, '\p{Is_Alphabetic=_-T}', "");
Expect(1, 195102, '\p{^Is_Alphabetic=_-T}', "");
Expect(1, 195102, '\P{Is_Alphabetic=_-T}', "");
Expect(0, 195102, '\P{^Is_Alphabetic=_-T}', "");
Error('\p{Is_Alpha=/a/		True}');
Error('\P{Is_Alpha=/a/		True}');
Expect(1, 195101, '\p{Is_Alpha=true}', "");
Expect(0, 195101, '\p{^Is_Alpha=true}', "");
Expect(0, 195101, '\P{Is_Alpha=true}', "");
Expect(1, 195101, '\P{^Is_Alpha=true}', "");
Expect(0, 195102, '\p{Is_Alpha=true}', "");
Expect(1, 195102, '\p{^Is_Alpha=true}', "");
Expect(1, 195102, '\P{Is_Alpha=true}', "");
Expect(0, 195102, '\P{^Is_Alpha=true}', "");
Expect(1, 195101, '\p{Is_Alpha=	-TRUE}', "");
Expect(0, 195101, '\p{^Is_Alpha=	-TRUE}', "");
Expect(0, 195101, '\P{Is_Alpha=	-TRUE}', "");
Expect(1, 195101, '\P{^Is_Alpha=	-TRUE}', "");
Expect(0, 195102, '\p{Is_Alpha=	-TRUE}', "");
Expect(1, 195102, '\p{^Is_Alpha=	-TRUE}', "");
Expect(1, 195102, '\P{Is_Alpha=	-TRUE}', "");
Expect(0, 195102, '\P{^Is_Alpha=	-TRUE}', "");
Error('\p{Bidi_Control=-no:=}');
Error('\P{Bidi_Control=-no:=}');
Expect(1, 8298, '\p{Bidi_Control=no}', "");
Expect(0, 8298, '\p{^Bidi_Control=no}', "");
Expect(0, 8298, '\P{Bidi_Control=no}', "");
Expect(1, 8298, '\P{^Bidi_Control=no}', "");
Expect(0, 8297, '\p{Bidi_Control=no}', "");
Expect(1, 8297, '\p{^Bidi_Control=no}', "");
Expect(1, 8297, '\P{Bidi_Control=no}', "");
Expect(0, 8297, '\P{^Bidi_Control=no}', "");
Expect(1, 8298, '\p{Bidi_Control= NO}', "");
Expect(0, 8298, '\p{^Bidi_Control= NO}', "");
Expect(0, 8298, '\P{Bidi_Control= NO}', "");
Expect(1, 8298, '\P{^Bidi_Control= NO}', "");
Expect(0, 8297, '\p{Bidi_Control= NO}', "");
Expect(1, 8297, '\p{^Bidi_Control= NO}', "");
Expect(1, 8297, '\P{Bidi_Control= NO}', "");
Expect(0, 8297, '\P{^Bidi_Control= NO}', "");
Error('\p{Bidi_C=/a/	-N}');
Error('\P{Bidi_C=/a/	-N}');
Expect(1, 8298, '\p{Bidi_C=n}', "");
Expect(0, 8298, '\p{^Bidi_C=n}', "");
Expect(0, 8298, '\P{Bidi_C=n}', "");
Expect(1, 8298, '\P{^Bidi_C=n}', "");
Expect(0, 8297, '\p{Bidi_C=n}', "");
Expect(1, 8297, '\p{^Bidi_C=n}', "");
Expect(1, 8297, '\P{Bidi_C=n}', "");
Expect(0, 8297, '\P{^Bidi_C=n}', "");
Expect(1, 8298, '\p{Bidi_C=-n}', "");
Expect(0, 8298, '\p{^Bidi_C=-n}', "");
Expect(0, 8298, '\P{Bidi_C=-n}', "");
Expect(1, 8298, '\P{^Bidi_C=-n}', "");
Expect(0, 8297, '\p{Bidi_C=-n}', "");
Expect(1, 8297, '\p{^Bidi_C=-n}', "");
Expect(1, 8297, '\P{Bidi_C=-n}', "");
Expect(0, 8297, '\P{^Bidi_C=-n}', "");
Error('\p{Is_Bidi_Control=	 F:=}');
Error('\P{Is_Bidi_Control=	 F:=}');
Expect(1, 8298, '\p{Is_Bidi_Control=f}', "");
Expect(0, 8298, '\p{^Is_Bidi_Control=f}', "");
Expect(0, 8298, '\P{Is_Bidi_Control=f}', "");
Expect(1, 8298, '\P{^Is_Bidi_Control=f}', "");
Expect(0, 8297, '\p{Is_Bidi_Control=f}', "");
Expect(1, 8297, '\p{^Is_Bidi_Control=f}', "");
Expect(1, 8297, '\P{Is_Bidi_Control=f}', "");
Expect(0, 8297, '\P{^Is_Bidi_Control=f}', "");
Expect(1, 8298, '\p{Is_Bidi_Control=  F}', "");
Expect(0, 8298, '\p{^Is_Bidi_Control=  F}', "");
Expect(0, 8298, '\P{Is_Bidi_Control=  F}', "");
Expect(1, 8298, '\P{^Is_Bidi_Control=  F}', "");
Expect(0, 8297, '\p{Is_Bidi_Control=  F}', "");
Expect(1, 8297, '\p{^Is_Bidi_Control=  F}', "");
Expect(1, 8297, '\P{Is_Bidi_Control=  F}', "");
Expect(0, 8297, '\P{^Is_Bidi_Control=  F}', "");
Error('\p{Is_Bidi_C=-False/a/}');
Error('\P{Is_Bidi_C=-False/a/}');
Expect(1, 8298, '\p{Is_Bidi_C=false}', "");
Expect(0, 8298, '\p{^Is_Bidi_C=false}', "");
Expect(0, 8298, '\P{Is_Bidi_C=false}', "");
Expect(1, 8298, '\P{^Is_Bidi_C=false}', "");
Expect(0, 8297, '\p{Is_Bidi_C=false}', "");
Expect(1, 8297, '\p{^Is_Bidi_C=false}', "");
Expect(1, 8297, '\P{Is_Bidi_C=false}', "");
Expect(0, 8297, '\P{^Is_Bidi_C=false}', "");
Expect(1, 8298, '\p{Is_Bidi_C=FALSE}', "");
Expect(0, 8298, '\p{^Is_Bidi_C=FALSE}', "");
Expect(0, 8298, '\P{Is_Bidi_C=FALSE}', "");
Expect(1, 8298, '\P{^Is_Bidi_C=FALSE}', "");
Expect(0, 8297, '\p{Is_Bidi_C=FALSE}', "");
Expect(1, 8297, '\p{^Is_Bidi_C=FALSE}', "");
Expect(1, 8297, '\P{Is_Bidi_C=FALSE}', "");
Expect(0, 8297, '\P{^Is_Bidi_C=FALSE}', "");
Error('\p{Bidi_Control=--Yes/a/}');
Error('\P{Bidi_Control=--Yes/a/}');
Expect(1, 8297, '\p{Bidi_Control=yes}', "");
Expect(0, 8297, '\p{^Bidi_Control=yes}', "");
Expect(0, 8297, '\P{Bidi_Control=yes}', "");
Expect(1, 8297, '\P{^Bidi_Control=yes}', "");
Expect(0, 8298, '\p{Bidi_Control=yes}', "");
Expect(1, 8298, '\p{^Bidi_Control=yes}', "");
Expect(1, 8298, '\P{Bidi_Control=yes}', "");
Expect(0, 8298, '\P{^Bidi_Control=yes}', "");
Expect(1, 8297, '\p{Bidi_Control=	_Yes}', "");
Expect(0, 8297, '\p{^Bidi_Control=	_Yes}', "");
Expect(0, 8297, '\P{Bidi_Control=	_Yes}', "");
Expect(1, 8297, '\P{^Bidi_Control=	_Yes}', "");
Expect(0, 8298, '\p{Bidi_Control=	_Yes}', "");
Expect(1, 8298, '\p{^Bidi_Control=	_Yes}', "");
Expect(1, 8298, '\P{Bidi_Control=	_Yes}', "");
Expect(0, 8298, '\P{^Bidi_Control=	_Yes}', "");
Error('\p{Bidi_C=:= _Y}');
Error('\P{Bidi_C=:= _Y}');
Expect(1, 8297, '\p{Bidi_C=y}', "");
Expect(0, 8297, '\p{^Bidi_C=y}', "");
Expect(0, 8297, '\P{Bidi_C=y}', "");
Expect(1, 8297, '\P{^Bidi_C=y}', "");
Expect(0, 8298, '\p{Bidi_C=y}', "");
Expect(1, 8298, '\p{^Bidi_C=y}', "");
Expect(1, 8298, '\P{Bidi_C=y}', "");
Expect(0, 8298, '\P{^Bidi_C=y}', "");
Expect(1, 8297, '\p{Bidi_C=_Y}', "");
Expect(0, 8297, '\p{^Bidi_C=_Y}', "");
Expect(0, 8297, '\P{Bidi_C=_Y}', "");
Expect(1, 8297, '\P{^Bidi_C=_Y}', "");
Expect(0, 8298, '\p{Bidi_C=_Y}', "");
Expect(1, 8298, '\p{^Bidi_C=_Y}', "");
Expect(1, 8298, '\P{Bidi_C=_Y}', "");
Expect(0, 8298, '\P{^Bidi_C=_Y}', "");
Error('\p{Is_Bidi_Control= -T/a/}');
Error('\P{Is_Bidi_Control= -T/a/}');
Expect(1, 8297, '\p{Is_Bidi_Control=t}', "");
Expect(0, 8297, '\p{^Is_Bidi_Control=t}', "");
Expect(0, 8297, '\P{Is_Bidi_Control=t}', "");
Expect(1, 8297, '\P{^Is_Bidi_Control=t}', "");
Expect(0, 8298, '\p{Is_Bidi_Control=t}', "");
Expect(1, 8298, '\p{^Is_Bidi_Control=t}', "");
Expect(1, 8298, '\P{Is_Bidi_Control=t}', "");
Expect(0, 8298, '\P{^Is_Bidi_Control=t}', "");
Expect(1, 8297, '\p{Is_Bidi_Control= -T}', "");
Expect(0, 8297, '\p{^Is_Bidi_Control= -T}', "");
Expect(0, 8297, '\P{Is_Bidi_Control= -T}', "");
Expect(1, 8297, '\P{^Is_Bidi_Control= -T}', "");
Expect(0, 8298, '\p{Is_Bidi_Control= -T}', "");
Expect(1, 8298, '\p{^Is_Bidi_Control= -T}', "");
Expect(1, 8298, '\P{Is_Bidi_Control= -T}', "");
Expect(0, 8298, '\P{^Is_Bidi_Control= -T}', "");
Error('\p{Is_Bidi_C=		TRUE/a/}');
Error('\P{Is_Bidi_C=		TRUE/a/}');
Expect(1, 8297, '\p{Is_Bidi_C=true}', "");
Expect(0, 8297, '\p{^Is_Bidi_C=true}', "");
Expect(0, 8297, '\P{Is_Bidi_C=true}', "");
Expect(1, 8297, '\P{^Is_Bidi_C=true}', "");
Expect(0, 8298, '\p{Is_Bidi_C=true}', "");
Expect(1, 8298, '\p{^Is_Bidi_C=true}', "");
Expect(1, 8298, '\P{Is_Bidi_C=true}', "");
Expect(0, 8298, '\P{^Is_Bidi_C=true}', "");
Expect(1, 8297, '\p{Is_Bidi_C=  true}', "");
Expect(0, 8297, '\p{^Is_Bidi_C=  true}', "");
Expect(0, 8297, '\P{Is_Bidi_C=  true}', "");
Expect(1, 8297, '\P{^Is_Bidi_C=  true}', "");
Expect(0, 8298, '\p{Is_Bidi_C=  true}', "");
Expect(1, 8298, '\p{^Is_Bidi_C=  true}', "");
Expect(1, 8298, '\P{Is_Bidi_C=  true}', "");
Expect(0, 8298, '\P{^Is_Bidi_C=  true}', "");
Error('\p{Bidi_Mirrored=		No:=}');
Error('\P{Bidi_Mirrored=		No:=}');
Expect(1, 120772, '\p{Bidi_Mirrored=no}', "");
Expect(0, 120772, '\p{^Bidi_Mirrored=no}', "");
Expect(0, 120772, '\P{Bidi_Mirrored=no}', "");
Expect(1, 120772, '\P{^Bidi_Mirrored=no}', "");
Expect(0, 120771, '\p{Bidi_Mirrored=no}', "");
Expect(1, 120771, '\p{^Bidi_Mirrored=no}', "");
Expect(1, 120771, '\P{Bidi_Mirrored=no}', "");
Expect(0, 120771, '\P{^Bidi_Mirrored=no}', "");
Expect(1, 120772, '\p{Bidi_Mirrored=No}', "");
Expect(0, 120772, '\p{^Bidi_Mirrored=No}', "");
Expect(0, 120772, '\P{Bidi_Mirrored=No}', "");
Expect(1, 120772, '\P{^Bidi_Mirrored=No}', "");
Expect(0, 120771, '\p{Bidi_Mirrored=No}', "");
Expect(1, 120771, '\p{^Bidi_Mirrored=No}', "");
Expect(1, 120771, '\P{Bidi_Mirrored=No}', "");
Expect(0, 120771, '\P{^Bidi_Mirrored=No}', "");
Error('\p{Bidi_M= :=N}');
Error('\P{Bidi_M= :=N}');
Expect(1, 120772, '\p{Bidi_M=n}', "");
Expect(0, 120772, '\p{^Bidi_M=n}', "");
Expect(0, 120772, '\P{Bidi_M=n}', "");
Expect(1, 120772, '\P{^Bidi_M=n}', "");
Expect(0, 120771, '\p{Bidi_M=n}', "");
Expect(1, 120771, '\p{^Bidi_M=n}', "");
Expect(1, 120771, '\P{Bidi_M=n}', "");
Expect(0, 120771, '\P{^Bidi_M=n}', "");
Expect(1, 120772, '\p{Bidi_M=  N}', "");
Expect(0, 120772, '\p{^Bidi_M=  N}', "");
Expect(0, 120772, '\P{Bidi_M=  N}', "");
Expect(1, 120772, '\P{^Bidi_M=  N}', "");
Expect(0, 120771, '\p{Bidi_M=  N}', "");
Expect(1, 120771, '\p{^Bidi_M=  N}', "");
Expect(1, 120771, '\P{Bidi_M=  N}', "");
Expect(0, 120771, '\P{^Bidi_M=  N}', "");
Error('\p{Is_Bidi_Mirrored=/a/-F}');
Error('\P{Is_Bidi_Mirrored=/a/-F}');
Expect(1, 120772, '\p{Is_Bidi_Mirrored=f}', "");
Expect(0, 120772, '\p{^Is_Bidi_Mirrored=f}', "");
Expect(0, 120772, '\P{Is_Bidi_Mirrored=f}', "");
Expect(1, 120772, '\P{^Is_Bidi_Mirrored=f}', "");
Expect(0, 120771, '\p{Is_Bidi_Mirrored=f}', "");
Expect(1, 120771, '\p{^Is_Bidi_Mirrored=f}', "");
Expect(1, 120771, '\P{Is_Bidi_Mirrored=f}', "");
Expect(0, 120771, '\P{^Is_Bidi_Mirrored=f}', "");
Expect(1, 120772, '\p{Is_Bidi_Mirrored=	 F}', "");
Expect(0, 120772, '\p{^Is_Bidi_Mirrored=	 F}', "");
Expect(0, 120772, '\P{Is_Bidi_Mirrored=	 F}', "");
Expect(1, 120772, '\P{^Is_Bidi_Mirrored=	 F}', "");
Expect(0, 120771, '\p{Is_Bidi_Mirrored=	 F}', "");
Expect(1, 120771, '\p{^Is_Bidi_Mirrored=	 F}', "");
Expect(1, 120771, '\P{Is_Bidi_Mirrored=	 F}', "");
Expect(0, 120771, '\P{^Is_Bidi_Mirrored=	 F}', "");
Error('\p{Is_Bidi_M: _-false/a/}');
Error('\P{Is_Bidi_M: _-false/a/}');
Expect(1, 120772, '\p{Is_Bidi_M=false}', "");
Expect(0, 120772, '\p{^Is_Bidi_M=false}', "");
Expect(0, 120772, '\P{Is_Bidi_M=false}', "");
Expect(1, 120772, '\P{^Is_Bidi_M=false}', "");
Expect(0, 120771, '\p{Is_Bidi_M=false}', "");
Expect(1, 120771, '\p{^Is_Bidi_M=false}', "");
Expect(1, 120771, '\P{Is_Bidi_M=false}', "");
Expect(0, 120771, '\P{^Is_Bidi_M=false}', "");
Expect(1, 120772, '\p{Is_Bidi_M= 	False}', "");
Expect(0, 120772, '\p{^Is_Bidi_M= 	False}', "");
Expect(0, 120772, '\P{Is_Bidi_M= 	False}', "");
Expect(1, 120772, '\P{^Is_Bidi_M= 	False}', "");
Expect(0, 120771, '\p{Is_Bidi_M= 	False}', "");
Expect(1, 120771, '\p{^Is_Bidi_M= 	False}', "");
Expect(1, 120771, '\P{Is_Bidi_M= 	False}', "");
Expect(0, 120771, '\P{^Is_Bidi_M= 	False}', "");
Error('\p{Bidi_Mirrored:	/a/	-YES}');
Error('\P{Bidi_Mirrored:	/a/	-YES}');
Expect(1, 120771, '\p{Bidi_Mirrored=yes}', "");
Expect(0, 120771, '\p{^Bidi_Mirrored=yes}', "");
Expect(0, 120771, '\P{Bidi_Mirrored=yes}', "");
Expect(1, 120771, '\P{^Bidi_Mirrored=yes}', "");
Expect(0, 120772, '\p{Bidi_Mirrored=yes}', "");
Expect(1, 120772, '\p{^Bidi_Mirrored=yes}', "");
Expect(1, 120772, '\P{Bidi_Mirrored=yes}', "");
Expect(0, 120772, '\P{^Bidi_Mirrored=yes}', "");
Expect(1, 120771, '\p{Bidi_Mirrored=  Yes}', "");
Expect(0, 120771, '\p{^Bidi_Mirrored=  Yes}', "");
Expect(0, 120771, '\P{Bidi_Mirrored=  Yes}', "");
Expect(1, 120771, '\P{^Bidi_Mirrored=  Yes}', "");
Expect(0, 120772, '\p{Bidi_Mirrored=  Yes}', "");
Expect(1, 120772, '\p{^Bidi_Mirrored=  Yes}', "");
Expect(1, 120772, '\P{Bidi_Mirrored=  Yes}', "");
Expect(0, 120772, '\P{^Bidi_Mirrored=  Yes}', "");
Error('\p{Bidi_M=-	y:=}');
Error('\P{Bidi_M=-	y:=}');
Expect(1, 120771, '\p{Bidi_M=y}', "");
Expect(0, 120771, '\p{^Bidi_M=y}', "");
Expect(0, 120771, '\P{Bidi_M=y}', "");
Expect(1, 120771, '\P{^Bidi_M=y}', "");
Expect(0, 120772, '\p{Bidi_M=y}', "");
Expect(1, 120772, '\p{^Bidi_M=y}', "");
Expect(1, 120772, '\P{Bidi_M=y}', "");
Expect(0, 120772, '\P{^Bidi_M=y}', "");
Expect(1, 120771, '\p{Bidi_M=	_y}', "");
Expect(0, 120771, '\p{^Bidi_M=	_y}', "");
Expect(0, 120771, '\P{Bidi_M=	_y}', "");
Expect(1, 120771, '\P{^Bidi_M=	_y}', "");
Expect(0, 120772, '\p{Bidi_M=	_y}', "");
Expect(1, 120772, '\p{^Bidi_M=	_y}', "");
Expect(1, 120772, '\P{Bidi_M=	_y}', "");
Expect(0, 120772, '\P{^Bidi_M=	_y}', "");
Error('\p{Is_Bidi_Mirrored=_	T/a/}');
Error('\P{Is_Bidi_Mirrored=_	T/a/}');
Expect(1, 120771, '\p{Is_Bidi_Mirrored=t}', "");
Expect(0, 120771, '\p{^Is_Bidi_Mirrored=t}', "");
Expect(0, 120771, '\P{Is_Bidi_Mirrored=t}', "");
Expect(1, 120771, '\P{^Is_Bidi_Mirrored=t}', "");
Expect(0, 120772, '\p{Is_Bidi_Mirrored=t}', "");
Expect(1, 120772, '\p{^Is_Bidi_Mirrored=t}', "");
Expect(1, 120772, '\P{Is_Bidi_Mirrored=t}', "");
Expect(0, 120772, '\P{^Is_Bidi_Mirrored=t}', "");
Expect(1, 120771, '\p{Is_Bidi_Mirrored=-t}', "");
Expect(0, 120771, '\p{^Is_Bidi_Mirrored=-t}', "");
Expect(0, 120771, '\P{Is_Bidi_Mirrored=-t}', "");
Expect(1, 120771, '\P{^Is_Bidi_Mirrored=-t}', "");
Expect(0, 120772, '\p{Is_Bidi_Mirrored=-t}', "");
Expect(1, 120772, '\p{^Is_Bidi_Mirrored=-t}', "");
Expect(1, 120772, '\P{Is_Bidi_Mirrored=-t}', "");
Expect(0, 120772, '\P{^Is_Bidi_Mirrored=-t}', "");
Error('\p{Is_Bidi_M=	/a/TRUE}');
Error('\P{Is_Bidi_M=	/a/TRUE}');
Expect(1, 120771, '\p{Is_Bidi_M=true}', "");
Expect(0, 120771, '\p{^Is_Bidi_M=true}', "");
Expect(0, 120771, '\P{Is_Bidi_M=true}', "");
Expect(1, 120771, '\P{^Is_Bidi_M=true}', "");
Expect(0, 120772, '\p{Is_Bidi_M=true}', "");
Expect(1, 120772, '\p{^Is_Bidi_M=true}', "");
Expect(1, 120772, '\P{Is_Bidi_M=true}', "");
Expect(0, 120772, '\P{^Is_Bidi_M=true}', "");
Expect(1, 120771, '\p{Is_Bidi_M:	-_True}', "");
Expect(0, 120771, '\p{^Is_Bidi_M:	-_True}', "");
Expect(0, 120771, '\P{Is_Bidi_M:	-_True}', "");
Expect(1, 120771, '\P{^Is_Bidi_M:	-_True}', "");
Expect(0, 120772, '\p{Is_Bidi_M:	-_True}', "");
Expect(1, 120772, '\p{^Is_Bidi_M:	-_True}', "");
Expect(1, 120772, '\P{Is_Bidi_M:	-_True}', "");
Expect(0, 120772, '\P{^Is_Bidi_M:	-_True}', "");
Error('\p{Composition_Exclusion=:=-_NO}');
Error('\P{Composition_Exclusion=:=-_NO}');
Expect(1, 119233, '\p{Composition_Exclusion:no}', "");
Expect(0, 119233, '\p{^Composition_Exclusion:no}', "");
Expect(0, 119233, '\P{Composition_Exclusion:no}', "");
Expect(1, 119233, '\P{^Composition_Exclusion:no}', "");
Expect(0, 119232, '\p{Composition_Exclusion:no}', "");
Expect(1, 119232, '\p{^Composition_Exclusion:no}', "");
Expect(1, 119232, '\P{Composition_Exclusion:no}', "");
Expect(0, 119232, '\P{^Composition_Exclusion:no}', "");
Expect(1, 119233, '\p{Composition_Exclusion=_	NO}', "");
Expect(0, 119233, '\p{^Composition_Exclusion=_	NO}', "");
Expect(0, 119233, '\P{Composition_Exclusion=_	NO}', "");
Expect(1, 119233, '\P{^Composition_Exclusion=_	NO}', "");
Expect(0, 119232, '\p{Composition_Exclusion=_	NO}', "");
Expect(1, 119232, '\p{^Composition_Exclusion=_	NO}', "");
Expect(1, 119232, '\P{Composition_Exclusion=_	NO}', "");
Expect(0, 119232, '\P{^Composition_Exclusion=_	NO}', "");
Error('\p{CE=_/a/N}');
Error('\P{CE=_/a/N}');
Expect(1, 119233, '\p{CE=n}', "");
Expect(0, 119233, '\p{^CE=n}', "");
Expect(0, 119233, '\P{CE=n}', "");
Expect(1, 119233, '\P{^CE=n}', "");
Expect(0, 119232, '\p{CE=n}', "");
Expect(1, 119232, '\p{^CE=n}', "");
Expect(1, 119232, '\P{CE=n}', "");
Expect(0, 119232, '\P{^CE=n}', "");
Expect(1, 119233, '\p{CE=N}', "");
Expect(0, 119233, '\p{^CE=N}', "");
Expect(0, 119233, '\P{CE=N}', "");
Expect(1, 119233, '\P{^CE=N}', "");
Expect(0, 119232, '\p{CE=N}', "");
Expect(1, 119232, '\p{^CE=N}', "");
Expect(1, 119232, '\P{CE=N}', "");
Expect(0, 119232, '\P{^CE=N}', "");
Error('\p{Is_Composition_Exclusion=__F:=}');
Error('\P{Is_Composition_Exclusion=__F:=}');
Expect(1, 119233, '\p{Is_Composition_Exclusion=f}', "");
Expect(0, 119233, '\p{^Is_Composition_Exclusion=f}', "");
Expect(0, 119233, '\P{Is_Composition_Exclusion=f}', "");
Expect(1, 119233, '\P{^Is_Composition_Exclusion=f}', "");
Expect(0, 119232, '\p{Is_Composition_Exclusion=f}', "");
Expect(1, 119232, '\p{^Is_Composition_Exclusion=f}', "");
Expect(1, 119232, '\P{Is_Composition_Exclusion=f}', "");
Expect(0, 119232, '\P{^Is_Composition_Exclusion=f}', "");
Expect(1, 119233, '\p{Is_Composition_Exclusion=_-F}', "");
Expect(0, 119233, '\p{^Is_Composition_Exclusion=_-F}', "");
Expect(0, 119233, '\P{Is_Composition_Exclusion=_-F}', "");
Expect(1, 119233, '\P{^Is_Composition_Exclusion=_-F}', "");
Expect(0, 119232, '\p{Is_Composition_Exclusion=_-F}', "");
Expect(1, 119232, '\p{^Is_Composition_Exclusion=_-F}', "");
Expect(1, 119232, '\P{Is_Composition_Exclusion=_-F}', "");
Expect(0, 119232, '\P{^Is_Composition_Exclusion=_-F}', "");
Error('\p{Is_CE=--false/a/}');
Error('\P{Is_CE=--false/a/}');
Expect(1, 119233, '\p{Is_CE=false}', "");
Expect(0, 119233, '\p{^Is_CE=false}', "");
Expect(0, 119233, '\P{Is_CE=false}', "");
Expect(1, 119233, '\P{^Is_CE=false}', "");
Expect(0, 119232, '\p{Is_CE=false}', "");
Expect(1, 119232, '\p{^Is_CE=false}', "");
Expect(1, 119232, '\P{Is_CE=false}', "");
Expect(0, 119232, '\P{^Is_CE=false}', "");
Expect(1, 119233, '\p{Is_CE:    false}', "");
Expect(0, 119233, '\p{^Is_CE:    false}', "");
Expect(0, 119233, '\P{Is_CE:    false}', "");
Expect(1, 119233, '\P{^Is_CE:    false}', "");
Expect(0, 119232, '\p{Is_CE:    false}', "");
Expect(1, 119232, '\p{^Is_CE:    false}', "");
Expect(1, 119232, '\P{Is_CE:    false}', "");
Expect(0, 119232, '\P{^Is_CE:    false}', "");
Error('\p{Composition_Exclusion=:=_yes}');
Error('\P{Composition_Exclusion=:=_yes}');
Expect(1, 119232, '\p{Composition_Exclusion:yes}', "");
Expect(0, 119232, '\p{^Composition_Exclusion:yes}', "");
Expect(0, 119232, '\P{Composition_Exclusion:yes}', "");
Expect(1, 119232, '\P{^Composition_Exclusion:yes}', "");
Expect(0, 119233, '\p{Composition_Exclusion:yes}', "");
Expect(1, 119233, '\p{^Composition_Exclusion:yes}', "");
Expect(1, 119233, '\P{Composition_Exclusion:yes}', "");
Expect(0, 119233, '\P{^Composition_Exclusion:yes}', "");
Expect(1, 119232, '\p{Composition_Exclusion=_	Yes}', "");
Expect(0, 119232, '\p{^Composition_Exclusion=_	Yes}', "");
Expect(0, 119232, '\P{Composition_Exclusion=_	Yes}', "");
Expect(1, 119232, '\P{^Composition_Exclusion=_	Yes}', "");
Expect(0, 119233, '\p{Composition_Exclusion=_	Yes}', "");
Expect(1, 119233, '\p{^Composition_Exclusion=_	Yes}', "");
Expect(1, 119233, '\P{Composition_Exclusion=_	Yes}', "");
Expect(0, 119233, '\P{^Composition_Exclusion=_	Yes}', "");
Error('\p{CE=--y:=}');
Error('\P{CE=--y:=}');
Expect(1, 119232, '\p{CE=y}', "");
Expect(0, 119232, '\p{^CE=y}', "");
Expect(0, 119232, '\P{CE=y}', "");
Expect(1, 119232, '\P{^CE=y}', "");
Expect(0, 119233, '\p{CE=y}', "");
Expect(1, 119233, '\p{^CE=y}', "");
Expect(1, 119233, '\P{CE=y}', "");
Expect(0, 119233, '\P{^CE=y}', "");
Expect(1, 119232, '\p{CE=__y}', "");
Expect(0, 119232, '\p{^CE=__y}', "");
Expect(0, 119232, '\P{CE=__y}', "");
Expect(1, 119232, '\P{^CE=__y}', "");
Expect(0, 119233, '\p{CE=__y}', "");
Expect(1, 119233, '\p{^CE=__y}', "");
Expect(1, 119233, '\P{CE=__y}', "");
Expect(0, 119233, '\P{^CE=__y}', "");
Error('\p{Is_Composition_Exclusion=:=		T}');
Error('\P{Is_Composition_Exclusion=:=		T}');
Expect(1, 119232, '\p{Is_Composition_Exclusion=t}', "");
Expect(0, 119232, '\p{^Is_Composition_Exclusion=t}', "");
Expect(0, 119232, '\P{Is_Composition_Exclusion=t}', "");
Expect(1, 119232, '\P{^Is_Composition_Exclusion=t}', "");
Expect(0, 119233, '\p{Is_Composition_Exclusion=t}', "");
Expect(1, 119233, '\p{^Is_Composition_Exclusion=t}', "");
Expect(1, 119233, '\P{Is_Composition_Exclusion=t}', "");
Expect(0, 119233, '\P{^Is_Composition_Exclusion=t}', "");
Expect(1, 119232, '\p{Is_Composition_Exclusion=__t}', "");
Expect(0, 119232, '\p{^Is_Composition_Exclusion=__t}', "");
Expect(0, 119232, '\P{Is_Composition_Exclusion=__t}', "");
Expect(1, 119232, '\P{^Is_Composition_Exclusion=__t}', "");
Expect(0, 119233, '\p{Is_Composition_Exclusion=__t}', "");
Expect(1, 119233, '\p{^Is_Composition_Exclusion=__t}', "");
Expect(1, 119233, '\P{Is_Composition_Exclusion=__t}', "");
Expect(0, 119233, '\P{^Is_Composition_Exclusion=__t}', "");
Error('\p{Is_CE=_:=true}');
Error('\P{Is_CE=_:=true}');
Expect(1, 119232, '\p{Is_CE=true}', "");
Expect(0, 119232, '\p{^Is_CE=true}', "");
Expect(0, 119232, '\P{Is_CE=true}', "");
Expect(1, 119232, '\P{^Is_CE=true}', "");
Expect(0, 119233, '\p{Is_CE=true}', "");
Expect(1, 119233, '\p{^Is_CE=true}', "");
Expect(1, 119233, '\P{Is_CE=true}', "");
Expect(0, 119233, '\P{^Is_CE=true}', "");
Expect(1, 119232, '\p{Is_CE=_true}', "");
Expect(0, 119232, '\p{^Is_CE=_true}', "");
Expect(0, 119232, '\P{Is_CE=_true}', "");
Expect(1, 119232, '\P{^Is_CE=_true}', "");
Expect(0, 119233, '\p{Is_CE=_true}', "");
Expect(1, 119233, '\p{^Is_CE=_true}', "");
Expect(1, 119233, '\P{Is_CE=_true}', "");
Expect(0, 119233, '\P{^Is_CE=_true}', "");
Error('\p{Case_Ignorable=/a/no}');
Error('\P{Case_Ignorable=/a/no}');
Expect(1, 918000, '\p{Case_Ignorable=no}', "");
Expect(0, 918000, '\p{^Case_Ignorable=no}', "");
Expect(0, 918000, '\P{Case_Ignorable=no}', "");
Expect(1, 918000, '\P{^Case_Ignorable=no}', "");
Expect(0, 917999, '\p{Case_Ignorable=no}', "");
Expect(1, 917999, '\p{^Case_Ignorable=no}', "");
Expect(1, 917999, '\P{Case_Ignorable=no}', "");
Expect(0, 917999, '\P{^Case_Ignorable=no}', "");
Expect(1, 918000, '\p{Case_Ignorable=__No}', "");
Expect(0, 918000, '\p{^Case_Ignorable=__No}', "");
Expect(0, 918000, '\P{Case_Ignorable=__No}', "");
Expect(1, 918000, '\P{^Case_Ignorable=__No}', "");
Expect(0, 917999, '\p{Case_Ignorable=__No}', "");
Expect(1, 917999, '\p{^Case_Ignorable=__No}', "");
Expect(1, 917999, '\P{Case_Ignorable=__No}', "");
Expect(0, 917999, '\P{^Case_Ignorable=__No}', "");
Error('\p{CI:/a/		N}');
Error('\P{CI:/a/		N}');
Expect(1, 918000, '\p{CI=n}', "");
Expect(0, 918000, '\p{^CI=n}', "");
Expect(0, 918000, '\P{CI=n}', "");
Expect(1, 918000, '\P{^CI=n}', "");
Expect(0, 917999, '\p{CI=n}', "");
Expect(1, 917999, '\p{^CI=n}', "");
Expect(1, 917999, '\P{CI=n}', "");
Expect(0, 917999, '\P{^CI=n}', "");
Expect(1, 918000, '\p{CI:   _N}', "");
Expect(0, 918000, '\p{^CI:   _N}', "");
Expect(0, 918000, '\P{CI:   _N}', "");
Expect(1, 918000, '\P{^CI:   _N}', "");
Expect(0, 917999, '\p{CI:   _N}', "");
Expect(1, 917999, '\p{^CI:   _N}', "");
Expect(1, 917999, '\P{CI:   _N}', "");
Expect(0, 917999, '\P{^CI:   _N}', "");
Error('\p{Is_Case_Ignorable=-/a/F}');
Error('\P{Is_Case_Ignorable=-/a/F}');
Expect(1, 918000, '\p{Is_Case_Ignorable=f}', "");
Expect(0, 918000, '\p{^Is_Case_Ignorable=f}', "");
Expect(0, 918000, '\P{Is_Case_Ignorable=f}', "");
Expect(1, 918000, '\P{^Is_Case_Ignorable=f}', "");
Expect(0, 917999, '\p{Is_Case_Ignorable=f}', "");
Expect(1, 917999, '\p{^Is_Case_Ignorable=f}', "");
Expect(1, 917999, '\P{Is_Case_Ignorable=f}', "");
Expect(0, 917999, '\P{^Is_Case_Ignorable=f}', "");
Expect(1, 918000, '\p{Is_Case_Ignorable= -F}', "");
Expect(0, 918000, '\p{^Is_Case_Ignorable= -F}', "");
Expect(0, 918000, '\P{Is_Case_Ignorable= -F}', "");
Expect(1, 918000, '\P{^Is_Case_Ignorable= -F}', "");
Expect(0, 917999, '\p{Is_Case_Ignorable= -F}', "");
Expect(1, 917999, '\p{^Is_Case_Ignorable= -F}', "");
Expect(1, 917999, '\P{Is_Case_Ignorable= -F}', "");
Expect(0, 917999, '\P{^Is_Case_Ignorable= -F}', "");
Error('\p{Is_CI=	 False/a/}');
Error('\P{Is_CI=	 False/a/}');
Expect(1, 918000, '\p{Is_CI=false}', "");
Expect(0, 918000, '\p{^Is_CI=false}', "");
Expect(0, 918000, '\P{Is_CI=false}', "");
Expect(1, 918000, '\P{^Is_CI=false}', "");
Expect(0, 917999, '\p{Is_CI=false}', "");
Expect(1, 917999, '\p{^Is_CI=false}', "");
Expect(1, 917999, '\P{Is_CI=false}', "");
Expect(0, 917999, '\P{^Is_CI=false}', "");
Expect(1, 918000, '\p{Is_CI=- FALSE}', "");
Expect(0, 918000, '\p{^Is_CI=- FALSE}', "");
Expect(0, 918000, '\P{Is_CI=- FALSE}', "");
Expect(1, 918000, '\P{^Is_CI=- FALSE}', "");
Expect(0, 917999, '\p{Is_CI=- FALSE}', "");
Expect(1, 917999, '\p{^Is_CI=- FALSE}', "");
Expect(1, 917999, '\P{Is_CI=- FALSE}', "");
Expect(0, 917999, '\P{^Is_CI=- FALSE}', "");
Error('\p{Case_Ignorable=:= Yes}');
Error('\P{Case_Ignorable=:= Yes}');
Expect(1, 917999, '\p{Case_Ignorable:yes}', "");
Expect(0, 917999, '\p{^Case_Ignorable:yes}', "");
Expect(0, 917999, '\P{Case_Ignorable:yes}', "");
Expect(1, 917999, '\P{^Case_Ignorable:yes}', "");
Expect(0, 918000, '\p{Case_Ignorable:yes}', "");
Expect(1, 918000, '\p{^Case_Ignorable:yes}', "");
Expect(1, 918000, '\P{Case_Ignorable:yes}', "");
Expect(0, 918000, '\P{^Case_Ignorable:yes}', "");
Expect(1, 917999, '\p{Case_Ignorable:	_-yes}', "");
Expect(0, 917999, '\p{^Case_Ignorable:	_-yes}', "");
Expect(0, 917999, '\P{Case_Ignorable:	_-yes}', "");
Expect(1, 917999, '\P{^Case_Ignorable:	_-yes}', "");
Expect(0, 918000, '\p{Case_Ignorable:	_-yes}', "");
Expect(1, 918000, '\p{^Case_Ignorable:	_-yes}', "");
Expect(1, 918000, '\P{Case_Ignorable:	_-yes}', "");
Expect(0, 918000, '\P{^Case_Ignorable:	_-yes}', "");
Error('\p{CI:  :=y}');
Error('\P{CI:  :=y}');
Expect(1, 917999, '\p{CI=y}', "");
Expect(0, 917999, '\p{^CI=y}', "");
Expect(0, 917999, '\P{CI=y}', "");
Expect(1, 917999, '\P{^CI=y}', "");
Expect(0, 918000, '\p{CI=y}', "");
Expect(1, 918000, '\p{^CI=y}', "");
Expect(1, 918000, '\P{CI=y}', "");
Expect(0, 918000, '\P{^CI=y}', "");
Expect(1, 917999, '\p{CI=__Y}', "");
Expect(0, 917999, '\p{^CI=__Y}', "");
Expect(0, 917999, '\P{CI=__Y}', "");
Expect(1, 917999, '\P{^CI=__Y}', "");
Expect(0, 918000, '\p{CI=__Y}', "");
Expect(1, 918000, '\p{^CI=__Y}', "");
Expect(1, 918000, '\P{CI=__Y}', "");
Expect(0, 918000, '\P{^CI=__Y}', "");
Error('\p{Is_Case_Ignorable:   -:=T}');
Error('\P{Is_Case_Ignorable:   -:=T}');
Expect(1, 917999, '\p{Is_Case_Ignorable=t}', "");
Expect(0, 917999, '\p{^Is_Case_Ignorable=t}', "");
Expect(0, 917999, '\P{Is_Case_Ignorable=t}', "");
Expect(1, 917999, '\P{^Is_Case_Ignorable=t}', "");
Expect(0, 918000, '\p{Is_Case_Ignorable=t}', "");
Expect(1, 918000, '\p{^Is_Case_Ignorable=t}', "");
Expect(1, 918000, '\P{Is_Case_Ignorable=t}', "");
Expect(0, 918000, '\P{^Is_Case_Ignorable=t}', "");
Expect(1, 917999, '\p{Is_Case_Ignorable= T}', "");
Expect(0, 917999, '\p{^Is_Case_Ignorable= T}', "");
Expect(0, 917999, '\P{Is_Case_Ignorable= T}', "");
Expect(1, 917999, '\P{^Is_Case_Ignorable= T}', "");
Expect(0, 918000, '\p{Is_Case_Ignorable= T}', "");
Expect(1, 918000, '\p{^Is_Case_Ignorable= T}', "");
Expect(1, 918000, '\P{Is_Case_Ignorable= T}', "");
Expect(0, 918000, '\P{^Is_Case_Ignorable= T}', "");
Error('\p{Is_CI=/a/TRUE}');
Error('\P{Is_CI=/a/TRUE}');
Expect(1, 917999, '\p{Is_CI:	true}', "");
Expect(0, 917999, '\p{^Is_CI:	true}', "");
Expect(0, 917999, '\P{Is_CI:	true}', "");
Expect(1, 917999, '\P{^Is_CI:	true}', "");
Expect(0, 918000, '\p{Is_CI:	true}', "");
Expect(1, 918000, '\p{^Is_CI:	true}', "");
Expect(1, 918000, '\P{Is_CI:	true}', "");
Expect(0, 918000, '\P{^Is_CI:	true}', "");
Expect(1, 917999, '\p{Is_CI= -True}', "");
Expect(0, 917999, '\p{^Is_CI= -True}', "");
Expect(0, 917999, '\P{Is_CI= -True}', "");
Expect(1, 917999, '\P{^Is_CI= -True}', "");
Expect(0, 918000, '\p{Is_CI= -True}', "");
Expect(1, 918000, '\p{^Is_CI= -True}', "");
Expect(1, 918000, '\P{Is_CI= -True}', "");
Expect(0, 918000, '\P{^Is_CI= -True}', "");
Error('\p{Changes_When_Casefolded=:=_	no}');
Error('\P{Changes_When_Casefolded=:=_	no}');
Expect(1, 71872, '\p{Changes_When_Casefolded=no}', "");
Expect(0, 71872, '\p{^Changes_When_Casefolded=no}', "");
Expect(0, 71872, '\P{Changes_When_Casefolded=no}', "");
Expect(1, 71872, '\P{^Changes_When_Casefolded=no}', "");
Expect(0, 71871, '\p{Changes_When_Casefolded=no}', "");
Expect(1, 71871, '\p{^Changes_When_Casefolded=no}', "");
Expect(1, 71871, '\P{Changes_When_Casefolded=no}', "");
Expect(0, 71871, '\P{^Changes_When_Casefolded=no}', "");
Expect(1, 71872, '\p{Changes_When_Casefolded:--No}', "");
Expect(0, 71872, '\p{^Changes_When_Casefolded:--No}', "");
Expect(0, 71872, '\P{Changes_When_Casefolded:--No}', "");
Expect(1, 71872, '\P{^Changes_When_Casefolded:--No}', "");
Expect(0, 71871, '\p{Changes_When_Casefolded:--No}', "");
Expect(1, 71871, '\p{^Changes_When_Casefolded:--No}', "");
Expect(1, 71871, '\P{Changes_When_Casefolded:--No}', "");
Expect(0, 71871, '\P{^Changes_When_Casefolded:--No}', "");
Error('\p{CWCF=_/a/N}');
Error('\P{CWCF=_/a/N}');
Expect(1, 71872, '\p{CWCF=n}', "");
Expect(0, 71872, '\p{^CWCF=n}', "");
Expect(0, 71872, '\P{CWCF=n}', "");
Expect(1, 71872, '\P{^CWCF=n}', "");
Expect(0, 71871, '\p{CWCF=n}', "");
Expect(1, 71871, '\p{^CWCF=n}', "");
Expect(1, 71871, '\P{CWCF=n}', "");
Expect(0, 71871, '\P{^CWCF=n}', "");
Expect(1, 71872, '\p{CWCF:   N}', "");
Expect(0, 71872, '\p{^CWCF:   N}', "");
Expect(0, 71872, '\P{CWCF:   N}', "");
Expect(1, 71872, '\P{^CWCF:   N}', "");
Expect(0, 71871, '\p{CWCF:   N}', "");
Expect(1, 71871, '\p{^CWCF:   N}', "");
Expect(1, 71871, '\P{CWCF:   N}', "");
Expect(0, 71871, '\P{^CWCF:   N}', "");
Error('\p{Is_Changes_When_Casefolded=	/a/F}');
Error('\P{Is_Changes_When_Casefolded=	/a/F}');
Expect(1, 71872, '\p{Is_Changes_When_Casefolded=f}', "");
Expect(0, 71872, '\p{^Is_Changes_When_Casefolded=f}', "");
Expect(0, 71872, '\P{Is_Changes_When_Casefolded=f}', "");
Expect(1, 71872, '\P{^Is_Changes_When_Casefolded=f}', "");
Expect(0, 71871, '\p{Is_Changes_When_Casefolded=f}', "");
Expect(1, 71871, '\p{^Is_Changes_When_Casefolded=f}', "");
Expect(1, 71871, '\P{Is_Changes_When_Casefolded=f}', "");
Expect(0, 71871, '\P{^Is_Changes_When_Casefolded=f}', "");
Expect(1, 71872, '\p{Is_Changes_When_Casefolded= -f}', "");
Expect(0, 71872, '\p{^Is_Changes_When_Casefolded= -f}', "");
Expect(0, 71872, '\P{Is_Changes_When_Casefolded= -f}', "");
Expect(1, 71872, '\P{^Is_Changes_When_Casefolded= -f}', "");
Expect(0, 71871, '\p{Is_Changes_When_Casefolded= -f}', "");
Expect(1, 71871, '\p{^Is_Changes_When_Casefolded= -f}', "");
Expect(1, 71871, '\P{Is_Changes_When_Casefolded= -f}', "");
Expect(0, 71871, '\P{^Is_Changes_When_Casefolded= -f}', "");
Error('\p{Is_CWCF= :=False}');
Error('\P{Is_CWCF= :=False}');
Expect(1, 71872, '\p{Is_CWCF=false}', "");
Expect(0, 71872, '\p{^Is_CWCF=false}', "");
Expect(0, 71872, '\P{Is_CWCF=false}', "");
Expect(1, 71872, '\P{^Is_CWCF=false}', "");
Expect(0, 71871, '\p{Is_CWCF=false}', "");
Expect(1, 71871, '\p{^Is_CWCF=false}', "");
Expect(1, 71871, '\P{Is_CWCF=false}', "");
Expect(0, 71871, '\P{^Is_CWCF=false}', "");
Expect(1, 71872, '\p{Is_CWCF=	_false}', "");
Expect(0, 71872, '\p{^Is_CWCF=	_false}', "");
Expect(0, 71872, '\P{Is_CWCF=	_false}', "");
Expect(1, 71872, '\P{^Is_CWCF=	_false}', "");
Expect(0, 71871, '\p{Is_CWCF=	_false}', "");
Expect(1, 71871, '\p{^Is_CWCF=	_false}', "");
Expect(1, 71871, '\P{Is_CWCF=	_false}', "");
Expect(0, 71871, '\P{^Is_CWCF=	_false}', "");
Error('\p{Changes_When_Casefolded= -Yes:=}');
Error('\P{Changes_When_Casefolded= -Yes:=}');
Expect(1, 71871, '\p{Changes_When_Casefolded=yes}', "");
Expect(0, 71871, '\p{^Changes_When_Casefolded=yes}', "");
Expect(0, 71871, '\P{Changes_When_Casefolded=yes}', "");
Expect(1, 71871, '\P{^Changes_When_Casefolded=yes}', "");
Expect(0, 71872, '\p{Changes_When_Casefolded=yes}', "");
Expect(1, 71872, '\p{^Changes_When_Casefolded=yes}', "");
Expect(1, 71872, '\P{Changes_When_Casefolded=yes}', "");
Expect(0, 71872, '\P{^Changes_When_Casefolded=yes}', "");
Expect(1, 71871, '\p{Changes_When_Casefolded=_Yes}', "");
Expect(0, 71871, '\p{^Changes_When_Casefolded=_Yes}', "");
Expect(0, 71871, '\P{Changes_When_Casefolded=_Yes}', "");
Expect(1, 71871, '\P{^Changes_When_Casefolded=_Yes}', "");
Expect(0, 71872, '\p{Changes_When_Casefolded=_Yes}', "");
Expect(1, 71872, '\p{^Changes_When_Casefolded=_Yes}', "");
Expect(1, 71872, '\P{Changes_When_Casefolded=_Yes}', "");
Expect(0, 71872, '\P{^Changes_When_Casefolded=_Yes}', "");
Error('\p{CWCF=/a/ 	Y}');
Error('\P{CWCF=/a/ 	Y}');
Expect(1, 71871, '\p{CWCF:y}', "");
Expect(0, 71871, '\p{^CWCF:y}', "");
Expect(0, 71871, '\P{CWCF:y}', "");
Expect(1, 71871, '\P{^CWCF:y}', "");
Expect(0, 71872, '\p{CWCF:y}', "");
Expect(1, 71872, '\p{^CWCF:y}', "");
Expect(1, 71872, '\P{CWCF:y}', "");
Expect(0, 71872, '\P{^CWCF:y}', "");
Expect(1, 71871, '\p{CWCF=-y}', "");
Expect(0, 71871, '\p{^CWCF=-y}', "");
Expect(0, 71871, '\P{CWCF=-y}', "");
Expect(1, 71871, '\P{^CWCF=-y}', "");
Expect(0, 71872, '\p{CWCF=-y}', "");
Expect(1, 71872, '\p{^CWCF=-y}', "");
Expect(1, 71872, '\P{CWCF=-y}', "");
Expect(0, 71872, '\P{^CWCF=-y}', "");
Error('\p{Is_Changes_When_Casefolded= :=T}');
Error('\P{Is_Changes_When_Casefolded= :=T}');
Expect(1, 71871, '\p{Is_Changes_When_Casefolded:   t}', "");
Expect(0, 71871, '\p{^Is_Changes_When_Casefolded:   t}', "");
Expect(0, 71871, '\P{Is_Changes_When_Casefolded:   t}', "");
Expect(1, 71871, '\P{^Is_Changes_When_Casefolded:   t}', "");
Expect(0, 71872, '\p{Is_Changes_When_Casefolded:   t}', "");
Expect(1, 71872, '\p{^Is_Changes_When_Casefolded:   t}', "");
Expect(1, 71872, '\P{Is_Changes_When_Casefolded:   t}', "");
Expect(0, 71872, '\P{^Is_Changes_When_Casefolded:   t}', "");
Expect(1, 71871, '\p{Is_Changes_When_Casefolded=_-T}', "");
Expect(0, 71871, '\p{^Is_Changes_When_Casefolded=_-T}', "");
Expect(0, 71871, '\P{Is_Changes_When_Casefolded=_-T}', "");
Expect(1, 71871, '\P{^Is_Changes_When_Casefolded=_-T}', "");
Expect(0, 71872, '\p{Is_Changes_When_Casefolded=_-T}', "");
Expect(1, 71872, '\p{^Is_Changes_When_Casefolded=_-T}', "");
Expect(1, 71872, '\P{Is_Changes_When_Casefolded=_-T}', "");
Expect(0, 71872, '\P{^Is_Changes_When_Casefolded=_-T}', "");
Error('\p{Is_CWCF=TRUE/a/}');
Error('\P{Is_CWCF=TRUE/a/}');
Expect(1, 71871, '\p{Is_CWCF=true}', "");
Expect(0, 71871, '\p{^Is_CWCF=true}', "");
Expect(0, 71871, '\P{Is_CWCF=true}', "");
Expect(1, 71871, '\P{^Is_CWCF=true}', "");
Expect(0, 71872, '\p{Is_CWCF=true}', "");
Expect(1, 71872, '\p{^Is_CWCF=true}', "");
Expect(1, 71872, '\P{Is_CWCF=true}', "");
Expect(0, 71872, '\P{^Is_CWCF=true}', "");
Expect(1, 71871, '\p{Is_CWCF=-True}', "");
Expect(0, 71871, '\p{^Is_CWCF=-True}', "");
Expect(0, 71871, '\P{Is_CWCF=-True}', "");
Expect(1, 71871, '\P{^Is_CWCF=-True}', "");
Expect(0, 71872, '\p{Is_CWCF=-True}', "");
Expect(1, 71872, '\p{^Is_CWCF=-True}', "");
Expect(1, 71872, '\P{Is_CWCF=-True}', "");
Expect(0, 71872, '\P{^Is_CWCF=-True}', "");
Error('\p{Changes_When_Casemapped= /a/No}');
Error('\P{Changes_When_Casemapped= /a/No}');
Expect(1, 71904, '\p{Changes_When_Casemapped=no}', "");
Expect(0, 71904, '\p{^Changes_When_Casemapped=no}', "");
Expect(0, 71904, '\P{Changes_When_Casemapped=no}', "");
Expect(1, 71904, '\P{^Changes_When_Casemapped=no}', "");
Expect(0, 71903, '\p{Changes_When_Casemapped=no}', "");
Expect(1, 71903, '\p{^Changes_When_Casemapped=no}', "");
Expect(1, 71903, '\P{Changes_When_Casemapped=no}', "");
Expect(0, 71903, '\P{^Changes_When_Casemapped=no}', "");
Expect(1, 71904, '\p{Changes_When_Casemapped=	-no}', "");
Expect(0, 71904, '\p{^Changes_When_Casemapped=	-no}', "");
Expect(0, 71904, '\P{Changes_When_Casemapped=	-no}', "");
Expect(1, 71904, '\P{^Changes_When_Casemapped=	-no}', "");
Expect(0, 71903, '\p{Changes_When_Casemapped=	-no}', "");
Expect(1, 71903, '\p{^Changes_When_Casemapped=	-no}', "");
Expect(1, 71903, '\P{Changes_When_Casemapped=	-no}', "");
Expect(0, 71903, '\P{^Changes_When_Casemapped=	-no}', "");
Error('\p{CWCM:-N/a/}');
Error('\P{CWCM:-N/a/}');
Expect(1, 71904, '\p{CWCM=n}', "");
Expect(0, 71904, '\p{^CWCM=n}', "");
Expect(0, 71904, '\P{CWCM=n}', "");
Expect(1, 71904, '\P{^CWCM=n}', "");
Expect(0, 71903, '\p{CWCM=n}', "");
Expect(1, 71903, '\p{^CWCM=n}', "");
Expect(1, 71903, '\P{CWCM=n}', "");
Expect(0, 71903, '\P{^CWCM=n}', "");
Expect(1, 71904, '\p{CWCM=_	n}', "");
Expect(0, 71904, '\p{^CWCM=_	n}', "");
Expect(0, 71904, '\P{CWCM=_	n}', "");
Expect(1, 71904, '\P{^CWCM=_	n}', "");
Expect(0, 71903, '\p{CWCM=_	n}', "");
Expect(1, 71903, '\p{^CWCM=_	n}', "");
Expect(1, 71903, '\P{CWCM=_	n}', "");
Expect(0, 71903, '\P{^CWCM=_	n}', "");
Error('\p{Is_Changes_When_Casemapped=/a/-F}');
Error('\P{Is_Changes_When_Casemapped=/a/-F}');
Expect(1, 71904, '\p{Is_Changes_When_Casemapped=f}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Casemapped=f}', "");
Expect(0, 71904, '\P{Is_Changes_When_Casemapped=f}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Casemapped=f}', "");
Expect(0, 71903, '\p{Is_Changes_When_Casemapped=f}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Casemapped=f}', "");
Expect(1, 71903, '\P{Is_Changes_When_Casemapped=f}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Casemapped=f}', "");
Expect(1, 71904, '\p{Is_Changes_When_Casemapped=--F}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Casemapped=--F}', "");
Expect(0, 71904, '\P{Is_Changes_When_Casemapped=--F}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Casemapped=--F}', "");
Expect(0, 71903, '\p{Is_Changes_When_Casemapped=--F}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Casemapped=--F}', "");
Expect(1, 71903, '\P{Is_Changes_When_Casemapped=--F}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Casemapped=--F}', "");
Error('\p{Is_CWCM=	/a/False}');
Error('\P{Is_CWCM=	/a/False}');
Expect(1, 71904, '\p{Is_CWCM=false}', "");
Expect(0, 71904, '\p{^Is_CWCM=false}', "");
Expect(0, 71904, '\P{Is_CWCM=false}', "");
Expect(1, 71904, '\P{^Is_CWCM=false}', "");
Expect(0, 71903, '\p{Is_CWCM=false}', "");
Expect(1, 71903, '\p{^Is_CWCM=false}', "");
Expect(1, 71903, '\P{Is_CWCM=false}', "");
Expect(0, 71903, '\P{^Is_CWCM=false}', "");
Expect(1, 71904, '\p{Is_CWCM=-_false}', "");
Expect(0, 71904, '\p{^Is_CWCM=-_false}', "");
Expect(0, 71904, '\P{Is_CWCM=-_false}', "");
Expect(1, 71904, '\P{^Is_CWCM=-_false}', "");
Expect(0, 71903, '\p{Is_CWCM=-_false}', "");
Expect(1, 71903, '\p{^Is_CWCM=-_false}', "");
Expect(1, 71903, '\P{Is_CWCM=-_false}', "");
Expect(0, 71903, '\P{^Is_CWCM=-_false}', "");
Error('\p{Changes_When_Casemapped=_/a/YES}');
Error('\P{Changes_When_Casemapped=_/a/YES}');
Expect(1, 71903, '\p{Changes_When_Casemapped=yes}', "");
Expect(0, 71903, '\p{^Changes_When_Casemapped=yes}', "");
Expect(0, 71903, '\P{Changes_When_Casemapped=yes}', "");
Expect(1, 71903, '\P{^Changes_When_Casemapped=yes}', "");
Expect(0, 71904, '\p{Changes_When_Casemapped=yes}', "");
Expect(1, 71904, '\p{^Changes_When_Casemapped=yes}', "");
Expect(1, 71904, '\P{Changes_When_Casemapped=yes}', "");
Expect(0, 71904, '\P{^Changes_When_Casemapped=yes}', "");
Expect(1, 71903, '\p{Changes_When_Casemapped=-	yes}', "");
Expect(0, 71903, '\p{^Changes_When_Casemapped=-	yes}', "");
Expect(0, 71903, '\P{Changes_When_Casemapped=-	yes}', "");
Expect(1, 71903, '\P{^Changes_When_Casemapped=-	yes}', "");
Expect(0, 71904, '\p{Changes_When_Casemapped=-	yes}', "");
Expect(1, 71904, '\p{^Changes_When_Casemapped=-	yes}', "");
Expect(1, 71904, '\P{Changes_When_Casemapped=-	yes}', "");
Expect(0, 71904, '\P{^Changes_When_Casemapped=-	yes}', "");
Error('\p{CWCM=-:=Y}');
Error('\P{CWCM=-:=Y}');
Expect(1, 71903, '\p{CWCM=y}', "");
Expect(0, 71903, '\p{^CWCM=y}', "");
Expect(0, 71903, '\P{CWCM=y}', "");
Expect(1, 71903, '\P{^CWCM=y}', "");
Expect(0, 71904, '\p{CWCM=y}', "");
Expect(1, 71904, '\p{^CWCM=y}', "");
Expect(1, 71904, '\P{CWCM=y}', "");
Expect(0, 71904, '\P{^CWCM=y}', "");
Expect(1, 71903, '\p{CWCM=_ Y}', "");
Expect(0, 71903, '\p{^CWCM=_ Y}', "");
Expect(0, 71903, '\P{CWCM=_ Y}', "");
Expect(1, 71903, '\P{^CWCM=_ Y}', "");
Expect(0, 71904, '\p{CWCM=_ Y}', "");
Expect(1, 71904, '\p{^CWCM=_ Y}', "");
Expect(1, 71904, '\P{CWCM=_ Y}', "");
Expect(0, 71904, '\P{^CWCM=_ Y}', "");
Error('\p{Is_Changes_When_Casemapped=	 T/a/}');
Error('\P{Is_Changes_When_Casemapped=	 T/a/}');
Expect(1, 71903, '\p{Is_Changes_When_Casemapped=t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Casemapped=t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Casemapped=t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Casemapped=t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Casemapped=t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Casemapped=t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Casemapped=t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Casemapped=t}', "");
Expect(1, 71903, '\p{Is_Changes_When_Casemapped:	 t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Casemapped:	 t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Casemapped:	 t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Casemapped:	 t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Casemapped:	 t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Casemapped:	 t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Casemapped:	 t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Casemapped:	 t}', "");
Error('\p{Is_CWCM=:=True}');
Error('\P{Is_CWCM=:=True}');
Expect(1, 71903, '\p{Is_CWCM=true}', "");
Expect(0, 71903, '\p{^Is_CWCM=true}', "");
Expect(0, 71903, '\P{Is_CWCM=true}', "");
Expect(1, 71903, '\P{^Is_CWCM=true}', "");
Expect(0, 71904, '\p{Is_CWCM=true}', "");
Expect(1, 71904, '\p{^Is_CWCM=true}', "");
Expect(1, 71904, '\P{Is_CWCM=true}', "");
Expect(0, 71904, '\P{^Is_CWCM=true}', "");
Expect(1, 71903, '\p{Is_CWCM=_-TRUE}', "");
Expect(0, 71903, '\p{^Is_CWCM=_-TRUE}', "");
Expect(0, 71903, '\P{Is_CWCM=_-TRUE}', "");
Expect(1, 71903, '\P{^Is_CWCM=_-TRUE}', "");
Expect(0, 71904, '\p{Is_CWCM=_-TRUE}', "");
Expect(1, 71904, '\p{^Is_CWCM=_-TRUE}', "");
Expect(1, 71904, '\P{Is_CWCM=_-TRUE}', "");
Expect(0, 71904, '\P{^Is_CWCM=_-TRUE}', "");
Error('\p{Changes_When_NFKC_Casefolded=-_NO/a/}');
Error('\P{Changes_When_NFKC_Casefolded=-_NO/a/}');
Expect(1, 921600, '\p{Changes_When_NFKC_Casefolded:   no}', "");
Expect(0, 921600, '\p{^Changes_When_NFKC_Casefolded:   no}', "");
Expect(0, 921600, '\P{Changes_When_NFKC_Casefolded:   no}', "");
Expect(1, 921600, '\P{^Changes_When_NFKC_Casefolded:   no}', "");
Expect(0, 921599, '\p{Changes_When_NFKC_Casefolded:   no}', "");
Expect(1, 921599, '\p{^Changes_When_NFKC_Casefolded:   no}', "");
Expect(1, 921599, '\P{Changes_When_NFKC_Casefolded:   no}', "");
Expect(0, 921599, '\P{^Changes_When_NFKC_Casefolded:   no}', "");
Expect(1, 921600, '\p{Changes_When_NFKC_Casefolded=	-no}', "");
Expect(0, 921600, '\p{^Changes_When_NFKC_Casefolded=	-no}', "");
Expect(0, 921600, '\P{Changes_When_NFKC_Casefolded=	-no}', "");
Expect(1, 921600, '\P{^Changes_When_NFKC_Casefolded=	-no}', "");
Expect(0, 921599, '\p{Changes_When_NFKC_Casefolded=	-no}', "");
Expect(1, 921599, '\p{^Changes_When_NFKC_Casefolded=	-no}', "");
Expect(1, 921599, '\P{Changes_When_NFKC_Casefolded=	-no}', "");
Expect(0, 921599, '\P{^Changes_When_NFKC_Casefolded=	-no}', "");
Error('\p{CWKCF=/a/	n}');
Error('\P{CWKCF=/a/	n}');
Expect(1, 921600, '\p{CWKCF=n}', "");
Expect(0, 921600, '\p{^CWKCF=n}', "");
Expect(0, 921600, '\P{CWKCF=n}', "");
Expect(1, 921600, '\P{^CWKCF=n}', "");
Expect(0, 921599, '\p{CWKCF=n}', "");
Expect(1, 921599, '\p{^CWKCF=n}', "");
Expect(1, 921599, '\P{CWKCF=n}', "");
Expect(0, 921599, '\P{^CWKCF=n}', "");
Expect(1, 921600, '\p{CWKCF:   -N}', "");
Expect(0, 921600, '\p{^CWKCF:   -N}', "");
Expect(0, 921600, '\P{CWKCF:   -N}', "");
Expect(1, 921600, '\P{^CWKCF:   -N}', "");
Expect(0, 921599, '\p{CWKCF:   -N}', "");
Expect(1, 921599, '\p{^CWKCF:   -N}', "");
Expect(1, 921599, '\P{CWKCF:   -N}', "");
Expect(0, 921599, '\P{^CWKCF:   -N}', "");
Error('\p{Is_Changes_When_NFKC_Casefolded=/a/  F}');
Error('\P{Is_Changes_When_NFKC_Casefolded=/a/  F}');
Expect(1, 921600, '\p{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 921600, '\p{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 921600, '\P{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 921600, '\P{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 921599, '\p{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 921599, '\p{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 921599, '\P{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 921599, '\P{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 921600, '\p{Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(0, 921600, '\p{^Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(0, 921600, '\P{Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(1, 921600, '\P{^Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(0, 921599, '\p{Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(1, 921599, '\p{^Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(1, 921599, '\P{Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(0, 921599, '\P{^Is_Changes_When_NFKC_Casefolded:    	f}', "");
Error('\p{Is_CWKCF=	 False:=}');
Error('\P{Is_CWKCF=	 False:=}');
Expect(1, 921600, '\p{Is_CWKCF=false}', "");
Expect(0, 921600, '\p{^Is_CWKCF=false}', "");
Expect(0, 921600, '\P{Is_CWKCF=false}', "");
Expect(1, 921600, '\P{^Is_CWKCF=false}', "");
Expect(0, 921599, '\p{Is_CWKCF=false}', "");
Expect(1, 921599, '\p{^Is_CWKCF=false}', "");
Expect(1, 921599, '\P{Is_CWKCF=false}', "");
Expect(0, 921599, '\P{^Is_CWKCF=false}', "");
Expect(1, 921600, '\p{Is_CWKCF=_-FALSE}', "");
Expect(0, 921600, '\p{^Is_CWKCF=_-FALSE}', "");
Expect(0, 921600, '\P{Is_CWKCF=_-FALSE}', "");
Expect(1, 921600, '\P{^Is_CWKCF=_-FALSE}', "");
Expect(0, 921599, '\p{Is_CWKCF=_-FALSE}', "");
Expect(1, 921599, '\p{^Is_CWKCF=_-FALSE}', "");
Expect(1, 921599, '\P{Is_CWKCF=_-FALSE}', "");
Expect(0, 921599, '\P{^Is_CWKCF=_-FALSE}', "");
Error('\p{Changes_When_NFKC_Casefolded=/a/		Yes}');
Error('\P{Changes_When_NFKC_Casefolded=/a/		Yes}');
Expect(1, 921599, '\p{Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 921599, '\p{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 921599, '\P{Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 921599, '\P{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 921600, '\p{Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 921600, '\p{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 921600, '\P{Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 921600, '\P{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 921599, '\p{Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(0, 921599, '\p{^Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(0, 921599, '\P{Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(1, 921599, '\P{^Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(0, 921600, '\p{Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(1, 921600, '\p{^Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(1, 921600, '\P{Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(0, 921600, '\P{^Changes_When_NFKC_Casefolded=	-yes}', "");
Error('\p{CWKCF=		Y:=}');
Error('\P{CWKCF=		Y:=}');
Expect(1, 921599, '\p{CWKCF=y}', "");
Expect(0, 921599, '\p{^CWKCF=y}', "");
Expect(0, 921599, '\P{CWKCF=y}', "");
Expect(1, 921599, '\P{^CWKCF=y}', "");
Expect(0, 921600, '\p{CWKCF=y}', "");
Expect(1, 921600, '\p{^CWKCF=y}', "");
Expect(1, 921600, '\P{CWKCF=y}', "");
Expect(0, 921600, '\P{^CWKCF=y}', "");
Expect(1, 921599, '\p{CWKCF=-Y}', "");
Expect(0, 921599, '\p{^CWKCF=-Y}', "");
Expect(0, 921599, '\P{CWKCF=-Y}', "");
Expect(1, 921599, '\P{^CWKCF=-Y}', "");
Expect(0, 921600, '\p{CWKCF=-Y}', "");
Expect(1, 921600, '\p{^CWKCF=-Y}', "");
Expect(1, 921600, '\P{CWKCF=-Y}', "");
Expect(0, 921600, '\P{^CWKCF=-Y}', "");
Error('\p{Is_Changes_When_NFKC_Casefolded= 	t:=}');
Error('\P{Is_Changes_When_NFKC_Casefolded= 	t:=}');
Expect(1, 921599, '\p{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 921599, '\p{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 921599, '\P{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 921599, '\P{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 921600, '\p{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 921600, '\p{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 921600, '\P{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 921600, '\P{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 921599, '\p{Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(0, 921599, '\p{^Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(0, 921599, '\P{Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(1, 921599, '\P{^Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(0, 921600, '\p{Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(1, 921600, '\p{^Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(1, 921600, '\P{Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(0, 921600, '\P{^Is_Changes_When_NFKC_Casefolded= _T}', "");
Error('\p{Is_CWKCF=:=	true}');
Error('\P{Is_CWKCF=:=	true}');
Expect(1, 921599, '\p{Is_CWKCF=true}', "");
Expect(0, 921599, '\p{^Is_CWKCF=true}', "");
Expect(0, 921599, '\P{Is_CWKCF=true}', "");
Expect(1, 921599, '\P{^Is_CWKCF=true}', "");
Expect(0, 921600, '\p{Is_CWKCF=true}', "");
Expect(1, 921600, '\p{^Is_CWKCF=true}', "");
Expect(1, 921600, '\P{Is_CWKCF=true}', "");
Expect(0, 921600, '\P{^Is_CWKCF=true}', "");
Expect(1, 921599, '\p{Is_CWKCF=- True}', "");
Expect(0, 921599, '\p{^Is_CWKCF=- True}', "");
Expect(0, 921599, '\P{Is_CWKCF=- True}', "");
Expect(1, 921599, '\P{^Is_CWKCF=- True}', "");
Expect(0, 921600, '\p{Is_CWKCF=- True}', "");
Expect(1, 921600, '\p{^Is_CWKCF=- True}', "");
Expect(1, 921600, '\P{Is_CWKCF=- True}', "");
Expect(0, 921600, '\P{^Is_CWKCF=- True}', "");
Error('\p{Changes_When_Lowercased=_No/a/}');
Error('\P{Changes_When_Lowercased=_No/a/}');
Expect(1, 71872, '\p{Changes_When_Lowercased=no}', "");
Expect(0, 71872, '\p{^Changes_When_Lowercased=no}', "");
Expect(0, 71872, '\P{Changes_When_Lowercased=no}', "");
Expect(1, 71872, '\P{^Changes_When_Lowercased=no}', "");
Expect(0, 71871, '\p{Changes_When_Lowercased=no}', "");
Expect(1, 71871, '\p{^Changes_When_Lowercased=no}', "");
Expect(1, 71871, '\P{Changes_When_Lowercased=no}', "");
Expect(0, 71871, '\P{^Changes_When_Lowercased=no}', "");
Expect(1, 71872, '\p{Changes_When_Lowercased=-	No}', "");
Expect(0, 71872, '\p{^Changes_When_Lowercased=-	No}', "");
Expect(0, 71872, '\P{Changes_When_Lowercased=-	No}', "");
Expect(1, 71872, '\P{^Changes_When_Lowercased=-	No}', "");
Expect(0, 71871, '\p{Changes_When_Lowercased=-	No}', "");
Expect(1, 71871, '\p{^Changes_When_Lowercased=-	No}', "");
Expect(1, 71871, '\P{Changes_When_Lowercased=-	No}', "");
Expect(0, 71871, '\P{^Changes_When_Lowercased=-	No}', "");
Error('\p{CWL=-/a/N}');
Error('\P{CWL=-/a/N}');
Expect(1, 71872, '\p{CWL=n}', "");
Expect(0, 71872, '\p{^CWL=n}', "");
Expect(0, 71872, '\P{CWL=n}', "");
Expect(1, 71872, '\P{^CWL=n}', "");
Expect(0, 71871, '\p{CWL=n}', "");
Expect(1, 71871, '\p{^CWL=n}', "");
Expect(1, 71871, '\P{CWL=n}', "");
Expect(0, 71871, '\P{^CWL=n}', "");
Expect(1, 71872, '\p{CWL:	_N}', "");
Expect(0, 71872, '\p{^CWL:	_N}', "");
Expect(0, 71872, '\P{CWL:	_N}', "");
Expect(1, 71872, '\P{^CWL:	_N}', "");
Expect(0, 71871, '\p{CWL:	_N}', "");
Expect(1, 71871, '\p{^CWL:	_N}', "");
Expect(1, 71871, '\P{CWL:	_N}', "");
Expect(0, 71871, '\P{^CWL:	_N}', "");
Error('\p{Is_Changes_When_Lowercased=/a/f}');
Error('\P{Is_Changes_When_Lowercased=/a/f}');
Expect(1, 71872, '\p{Is_Changes_When_Lowercased:	f}', "");
Expect(0, 71872, '\p{^Is_Changes_When_Lowercased:	f}', "");
Expect(0, 71872, '\P{Is_Changes_When_Lowercased:	f}', "");
Expect(1, 71872, '\P{^Is_Changes_When_Lowercased:	f}', "");
Expect(0, 71871, '\p{Is_Changes_When_Lowercased:	f}', "");
Expect(1, 71871, '\p{^Is_Changes_When_Lowercased:	f}', "");
Expect(1, 71871, '\P{Is_Changes_When_Lowercased:	f}', "");
Expect(0, 71871, '\P{^Is_Changes_When_Lowercased:	f}', "");
Expect(1, 71872, '\p{Is_Changes_When_Lowercased=_-F}', "");
Expect(0, 71872, '\p{^Is_Changes_When_Lowercased=_-F}', "");
Expect(0, 71872, '\P{Is_Changes_When_Lowercased=_-F}', "");
Expect(1, 71872, '\P{^Is_Changes_When_Lowercased=_-F}', "");
Expect(0, 71871, '\p{Is_Changes_When_Lowercased=_-F}', "");
Expect(1, 71871, '\p{^Is_Changes_When_Lowercased=_-F}', "");
Expect(1, 71871, '\P{Is_Changes_When_Lowercased=_-F}', "");
Expect(0, 71871, '\P{^Is_Changes_When_Lowercased=_-F}', "");
Error('\p{Is_CWL=_-False:=}');
Error('\P{Is_CWL=_-False:=}');
Expect(1, 71872, '\p{Is_CWL=false}', "");
Expect(0, 71872, '\p{^Is_CWL=false}', "");
Expect(0, 71872, '\P{Is_CWL=false}', "");
Expect(1, 71872, '\P{^Is_CWL=false}', "");
Expect(0, 71871, '\p{Is_CWL=false}', "");
Expect(1, 71871, '\p{^Is_CWL=false}', "");
Expect(1, 71871, '\P{Is_CWL=false}', "");
Expect(0, 71871, '\P{^Is_CWL=false}', "");
Expect(1, 71872, '\p{Is_CWL=  false}', "");
Expect(0, 71872, '\p{^Is_CWL=  false}', "");
Expect(0, 71872, '\P{Is_CWL=  false}', "");
Expect(1, 71872, '\P{^Is_CWL=  false}', "");
Expect(0, 71871, '\p{Is_CWL=  false}', "");
Expect(1, 71871, '\p{^Is_CWL=  false}', "");
Expect(1, 71871, '\P{Is_CWL=  false}', "");
Expect(0, 71871, '\P{^Is_CWL=  false}', "");
Error('\p{Changes_When_Lowercased=_	Yes:=}');
Error('\P{Changes_When_Lowercased=_	Yes:=}');
Expect(1, 71871, '\p{Changes_When_Lowercased=yes}', "");
Expect(0, 71871, '\p{^Changes_When_Lowercased=yes}', "");
Expect(0, 71871, '\P{Changes_When_Lowercased=yes}', "");
Expect(1, 71871, '\P{^Changes_When_Lowercased=yes}', "");
Expect(0, 71872, '\p{Changes_When_Lowercased=yes}', "");
Expect(1, 71872, '\p{^Changes_When_Lowercased=yes}', "");
Expect(1, 71872, '\P{Changes_When_Lowercased=yes}', "");
Expect(0, 71872, '\P{^Changes_When_Lowercased=yes}', "");
Expect(1, 71871, '\p{Changes_When_Lowercased=	Yes}', "");
Expect(0, 71871, '\p{^Changes_When_Lowercased=	Yes}', "");
Expect(0, 71871, '\P{Changes_When_Lowercased=	Yes}', "");
Expect(1, 71871, '\P{^Changes_When_Lowercased=	Yes}', "");
Expect(0, 71872, '\p{Changes_When_Lowercased=	Yes}', "");
Expect(1, 71872, '\p{^Changes_When_Lowercased=	Yes}', "");
Expect(1, 71872, '\P{Changes_When_Lowercased=	Yes}', "");
Expect(0, 71872, '\P{^Changes_When_Lowercased=	Yes}', "");
Error('\p{CWL=	Y/a/}');
Error('\P{CWL=	Y/a/}');
Expect(1, 71871, '\p{CWL=y}', "");
Expect(0, 71871, '\p{^CWL=y}', "");
Expect(0, 71871, '\P{CWL=y}', "");
Expect(1, 71871, '\P{^CWL=y}', "");
Expect(0, 71872, '\p{CWL=y}', "");
Expect(1, 71872, '\p{^CWL=y}', "");
Expect(1, 71872, '\P{CWL=y}', "");
Expect(0, 71872, '\P{^CWL=y}', "");
Expect(1, 71871, '\p{CWL=_	Y}', "");
Expect(0, 71871, '\p{^CWL=_	Y}', "");
Expect(0, 71871, '\P{CWL=_	Y}', "");
Expect(1, 71871, '\P{^CWL=_	Y}', "");
Expect(0, 71872, '\p{CWL=_	Y}', "");
Expect(1, 71872, '\p{^CWL=_	Y}', "");
Expect(1, 71872, '\P{CWL=_	Y}', "");
Expect(0, 71872, '\P{^CWL=_	Y}', "");
Error('\p{Is_Changes_When_Lowercased= /a/T}');
Error('\P{Is_Changes_When_Lowercased= /a/T}');
Expect(1, 71871, '\p{Is_Changes_When_Lowercased=t}', "");
Expect(0, 71871, '\p{^Is_Changes_When_Lowercased=t}', "");
Expect(0, 71871, '\P{Is_Changes_When_Lowercased=t}', "");
Expect(1, 71871, '\P{^Is_Changes_When_Lowercased=t}', "");
Expect(0, 71872, '\p{Is_Changes_When_Lowercased=t}', "");
Expect(1, 71872, '\p{^Is_Changes_When_Lowercased=t}', "");
Expect(1, 71872, '\P{Is_Changes_When_Lowercased=t}', "");
Expect(0, 71872, '\P{^Is_Changes_When_Lowercased=t}', "");
Expect(1, 71871, '\p{Is_Changes_When_Lowercased=- T}', "");
Expect(0, 71871, '\p{^Is_Changes_When_Lowercased=- T}', "");
Expect(0, 71871, '\P{Is_Changes_When_Lowercased=- T}', "");
Expect(1, 71871, '\P{^Is_Changes_When_Lowercased=- T}', "");
Expect(0, 71872, '\p{Is_Changes_When_Lowercased=- T}', "");
Expect(1, 71872, '\p{^Is_Changes_When_Lowercased=- T}', "");
Expect(1, 71872, '\P{Is_Changes_When_Lowercased=- T}', "");
Expect(0, 71872, '\P{^Is_Changes_When_Lowercased=- T}', "");
Error('\p{Is_CWL:   :=	 True}');
Error('\P{Is_CWL:   :=	 True}');
Expect(1, 71871, '\p{Is_CWL=true}', "");
Expect(0, 71871, '\p{^Is_CWL=true}', "");
Expect(0, 71871, '\P{Is_CWL=true}', "");
Expect(1, 71871, '\P{^Is_CWL=true}', "");
Expect(0, 71872, '\p{Is_CWL=true}', "");
Expect(1, 71872, '\p{^Is_CWL=true}', "");
Expect(1, 71872, '\P{Is_CWL=true}', "");
Expect(0, 71872, '\P{^Is_CWL=true}', "");
Expect(1, 71871, '\p{Is_CWL=-True}', "");
Expect(0, 71871, '\p{^Is_CWL=-True}', "");
Expect(0, 71871, '\P{Is_CWL=-True}', "");
Expect(1, 71871, '\P{^Is_CWL=-True}', "");
Expect(0, 71872, '\p{Is_CWL=-True}', "");
Expect(1, 71872, '\p{^Is_CWL=-True}', "");
Expect(1, 71872, '\P{Is_CWL=-True}', "");
Expect(0, 71872, '\P{^Is_CWL=-True}', "");
Error('\p{Changes_When_Titlecased: -/a/No}');
Error('\P{Changes_When_Titlecased: -/a/No}');
Expect(1, 71904, '\p{Changes_When_Titlecased=no}', "");
Expect(0, 71904, '\p{^Changes_When_Titlecased=no}', "");
Expect(0, 71904, '\P{Changes_When_Titlecased=no}', "");
Expect(1, 71904, '\P{^Changes_When_Titlecased=no}', "");
Expect(0, 71903, '\p{Changes_When_Titlecased=no}', "");
Expect(1, 71903, '\p{^Changes_When_Titlecased=no}', "");
Expect(1, 71903, '\P{Changes_When_Titlecased=no}', "");
Expect(0, 71903, '\P{^Changes_When_Titlecased=no}', "");
Expect(1, 71904, '\p{Changes_When_Titlecased= _No}', "");
Expect(0, 71904, '\p{^Changes_When_Titlecased= _No}', "");
Expect(0, 71904, '\P{Changes_When_Titlecased= _No}', "");
Expect(1, 71904, '\P{^Changes_When_Titlecased= _No}', "");
Expect(0, 71903, '\p{Changes_When_Titlecased= _No}', "");
Expect(1, 71903, '\p{^Changes_When_Titlecased= _No}', "");
Expect(1, 71903, '\P{Changes_When_Titlecased= _No}', "");
Expect(0, 71903, '\P{^Changes_When_Titlecased= _No}', "");
Error('\p{CWT=/a/		N}');
Error('\P{CWT=/a/		N}');
Expect(1, 71904, '\p{CWT=n}', "");
Expect(0, 71904, '\p{^CWT=n}', "");
Expect(0, 71904, '\P{CWT=n}', "");
Expect(1, 71904, '\P{^CWT=n}', "");
Expect(0, 71903, '\p{CWT=n}', "");
Expect(1, 71903, '\p{^CWT=n}', "");
Expect(1, 71903, '\P{CWT=n}', "");
Expect(0, 71903, '\P{^CWT=n}', "");
Expect(1, 71904, '\p{CWT:	_n}', "");
Expect(0, 71904, '\p{^CWT:	_n}', "");
Expect(0, 71904, '\P{CWT:	_n}', "");
Expect(1, 71904, '\P{^CWT:	_n}', "");
Expect(0, 71903, '\p{CWT:	_n}', "");
Expect(1, 71903, '\p{^CWT:	_n}', "");
Expect(1, 71903, '\P{CWT:	_n}', "");
Expect(0, 71903, '\P{^CWT:	_n}', "");
Error('\p{Is_Changes_When_Titlecased=  F/a/}');
Error('\P{Is_Changes_When_Titlecased=  F/a/}');
Expect(1, 71904, '\p{Is_Changes_When_Titlecased=f}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Titlecased=f}', "");
Expect(0, 71904, '\P{Is_Changes_When_Titlecased=f}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Titlecased=f}', "");
Expect(0, 71903, '\p{Is_Changes_When_Titlecased=f}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Titlecased=f}', "");
Expect(1, 71903, '\P{Is_Changes_When_Titlecased=f}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Titlecased=f}', "");
Expect(1, 71904, '\p{Is_Changes_When_Titlecased=	_F}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Titlecased=	_F}', "");
Expect(0, 71904, '\P{Is_Changes_When_Titlecased=	_F}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Titlecased=	_F}', "");
Expect(0, 71903, '\p{Is_Changes_When_Titlecased=	_F}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Titlecased=	_F}', "");
Expect(1, 71903, '\P{Is_Changes_When_Titlecased=	_F}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Titlecased=	_F}', "");
Error('\p{Is_CWT=/a/	 FALSE}');
Error('\P{Is_CWT=/a/	 FALSE}');
Expect(1, 71904, '\p{Is_CWT=false}', "");
Expect(0, 71904, '\p{^Is_CWT=false}', "");
Expect(0, 71904, '\P{Is_CWT=false}', "");
Expect(1, 71904, '\P{^Is_CWT=false}', "");
Expect(0, 71903, '\p{Is_CWT=false}', "");
Expect(1, 71903, '\p{^Is_CWT=false}', "");
Expect(1, 71903, '\P{Is_CWT=false}', "");
Expect(0, 71903, '\P{^Is_CWT=false}', "");
Expect(1, 71904, '\p{Is_CWT=	false}', "");
Expect(0, 71904, '\p{^Is_CWT=	false}', "");
Expect(0, 71904, '\P{Is_CWT=	false}', "");
Expect(1, 71904, '\P{^Is_CWT=	false}', "");
Expect(0, 71903, '\p{Is_CWT=	false}', "");
Expect(1, 71903, '\p{^Is_CWT=	false}', "");
Expect(1, 71903, '\P{Is_CWT=	false}', "");
Expect(0, 71903, '\P{^Is_CWT=	false}', "");
Error('\p{Changes_When_Titlecased=:=	YES}');
Error('\P{Changes_When_Titlecased=:=	YES}');
Expect(1, 71903, '\p{Changes_When_Titlecased=yes}', "");
Expect(0, 71903, '\p{^Changes_When_Titlecased=yes}', "");
Expect(0, 71903, '\P{Changes_When_Titlecased=yes}', "");
Expect(1, 71903, '\P{^Changes_When_Titlecased=yes}', "");
Expect(0, 71904, '\p{Changes_When_Titlecased=yes}', "");
Expect(1, 71904, '\p{^Changes_When_Titlecased=yes}', "");
Expect(1, 71904, '\P{Changes_When_Titlecased=yes}', "");
Expect(0, 71904, '\P{^Changes_When_Titlecased=yes}', "");
Expect(1, 71903, '\p{Changes_When_Titlecased= 	yes}', "");
Expect(0, 71903, '\p{^Changes_When_Titlecased= 	yes}', "");
Expect(0, 71903, '\P{Changes_When_Titlecased= 	yes}', "");
Expect(1, 71903, '\P{^Changes_When_Titlecased= 	yes}', "");
Expect(0, 71904, '\p{Changes_When_Titlecased= 	yes}', "");
Expect(1, 71904, '\p{^Changes_When_Titlecased= 	yes}', "");
Expect(1, 71904, '\P{Changes_When_Titlecased= 	yes}', "");
Expect(0, 71904, '\P{^Changes_When_Titlecased= 	yes}', "");
Error('\p{CWT=:=Y}');
Error('\P{CWT=:=Y}');
Expect(1, 71903, '\p{CWT=y}', "");
Expect(0, 71903, '\p{^CWT=y}', "");
Expect(0, 71903, '\P{CWT=y}', "");
Expect(1, 71903, '\P{^CWT=y}', "");
Expect(0, 71904, '\p{CWT=y}', "");
Expect(1, 71904, '\p{^CWT=y}', "");
Expect(1, 71904, '\P{CWT=y}', "");
Expect(0, 71904, '\P{^CWT=y}', "");
Expect(1, 71903, '\p{CWT=_ Y}', "");
Expect(0, 71903, '\p{^CWT=_ Y}', "");
Expect(0, 71903, '\P{CWT=_ Y}', "");
Expect(1, 71903, '\P{^CWT=_ Y}', "");
Expect(0, 71904, '\p{CWT=_ Y}', "");
Expect(1, 71904, '\p{^CWT=_ Y}', "");
Expect(1, 71904, '\P{CWT=_ Y}', "");
Expect(0, 71904, '\P{^CWT=_ Y}', "");
Error('\p{Is_Changes_When_Titlecased=/a/_T}');
Error('\P{Is_Changes_When_Titlecased=/a/_T}');
Expect(1, 71903, '\p{Is_Changes_When_Titlecased:   t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Titlecased:   t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Titlecased:   t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Titlecased:   t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Titlecased:   t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Titlecased:   t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Titlecased:   t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Titlecased:   t}', "");
Expect(1, 71903, '\p{Is_Changes_When_Titlecased=- T}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Titlecased=- T}', "");
Expect(0, 71903, '\P{Is_Changes_When_Titlecased=- T}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Titlecased=- T}', "");
Expect(0, 71904, '\p{Is_Changes_When_Titlecased=- T}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Titlecased=- T}', "");
Expect(1, 71904, '\P{Is_Changes_When_Titlecased=- T}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Titlecased=- T}', "");
Error('\p{Is_CWT:   _-True/a/}');
Error('\P{Is_CWT:   _-True/a/}');
Expect(1, 71903, '\p{Is_CWT=true}', "");
Expect(0, 71903, '\p{^Is_CWT=true}', "");
Expect(0, 71903, '\P{Is_CWT=true}', "");
Expect(1, 71903, '\P{^Is_CWT=true}', "");
Expect(0, 71904, '\p{Is_CWT=true}', "");
Expect(1, 71904, '\p{^Is_CWT=true}', "");
Expect(1, 71904, '\P{Is_CWT=true}', "");
Expect(0, 71904, '\P{^Is_CWT=true}', "");
Expect(1, 71903, '\p{Is_CWT=_true}', "");
Expect(0, 71903, '\p{^Is_CWT=_true}', "");
Expect(0, 71903, '\P{Is_CWT=_true}', "");
Expect(1, 71903, '\P{^Is_CWT=_true}', "");
Expect(0, 71904, '\p{Is_CWT=_true}', "");
Expect(1, 71904, '\p{^Is_CWT=_true}', "");
Expect(1, 71904, '\P{Is_CWT=_true}', "");
Expect(0, 71904, '\P{^Is_CWT=_true}', "");
Error('\p{Changes_When_Uppercased=/a/_NO}');
Error('\P{Changes_When_Uppercased=/a/_NO}');
Expect(1, 71904, '\p{Changes_When_Uppercased=no}', "");
Expect(0, 71904, '\p{^Changes_When_Uppercased=no}', "");
Expect(0, 71904, '\P{Changes_When_Uppercased=no}', "");
Expect(1, 71904, '\P{^Changes_When_Uppercased=no}', "");
Expect(0, 71903, '\p{Changes_When_Uppercased=no}', "");
Expect(1, 71903, '\p{^Changes_When_Uppercased=no}', "");
Expect(1, 71903, '\P{Changes_When_Uppercased=no}', "");
Expect(0, 71903, '\P{^Changes_When_Uppercased=no}', "");
Expect(1, 71904, '\p{Changes_When_Uppercased=-No}', "");
Expect(0, 71904, '\p{^Changes_When_Uppercased=-No}', "");
Expect(0, 71904, '\P{Changes_When_Uppercased=-No}', "");
Expect(1, 71904, '\P{^Changes_When_Uppercased=-No}', "");
Expect(0, 71903, '\p{Changes_When_Uppercased=-No}', "");
Expect(1, 71903, '\p{^Changes_When_Uppercased=-No}', "");
Expect(1, 71903, '\P{Changes_When_Uppercased=-No}', "");
Expect(0, 71903, '\P{^Changes_When_Uppercased=-No}', "");
Error('\p{CWU=-N/a/}');
Error('\P{CWU=-N/a/}');
Expect(1, 71904, '\p{CWU=n}', "");
Expect(0, 71904, '\p{^CWU=n}', "");
Expect(0, 71904, '\P{CWU=n}', "");
Expect(1, 71904, '\P{^CWU=n}', "");
Expect(0, 71903, '\p{CWU=n}', "");
Expect(1, 71903, '\p{^CWU=n}', "");
Expect(1, 71903, '\P{CWU=n}', "");
Expect(0, 71903, '\P{^CWU=n}', "");
Expect(1, 71904, '\p{CWU=_-n}', "");
Expect(0, 71904, '\p{^CWU=_-n}', "");
Expect(0, 71904, '\P{CWU=_-n}', "");
Expect(1, 71904, '\P{^CWU=_-n}', "");
Expect(0, 71903, '\p{CWU=_-n}', "");
Expect(1, 71903, '\p{^CWU=_-n}', "");
Expect(1, 71903, '\P{CWU=_-n}', "");
Expect(0, 71903, '\P{^CWU=_-n}', "");
Error('\p{Is_Changes_When_Uppercased= _F/a/}');
Error('\P{Is_Changes_When_Uppercased= _F/a/}');
Expect(1, 71904, '\p{Is_Changes_When_Uppercased=f}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Uppercased=f}', "");
Expect(0, 71904, '\P{Is_Changes_When_Uppercased=f}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Uppercased=f}', "");
Expect(0, 71903, '\p{Is_Changes_When_Uppercased=f}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Uppercased=f}', "");
Expect(1, 71903, '\P{Is_Changes_When_Uppercased=f}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Uppercased=f}', "");
Expect(1, 71904, '\p{Is_Changes_When_Uppercased=  F}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Uppercased=  F}', "");
Expect(0, 71904, '\P{Is_Changes_When_Uppercased=  F}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Uppercased=  F}', "");
Expect(0, 71903, '\p{Is_Changes_When_Uppercased=  F}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Uppercased=  F}', "");
Expect(1, 71903, '\P{Is_Changes_When_Uppercased=  F}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Uppercased=  F}', "");
Error('\p{Is_CWU=	_False:=}');
Error('\P{Is_CWU=	_False:=}');
Expect(1, 71904, '\p{Is_CWU=false}', "");
Expect(0, 71904, '\p{^Is_CWU=false}', "");
Expect(0, 71904, '\P{Is_CWU=false}', "");
Expect(1, 71904, '\P{^Is_CWU=false}', "");
Expect(0, 71903, '\p{Is_CWU=false}', "");
Expect(1, 71903, '\p{^Is_CWU=false}', "");
Expect(1, 71903, '\P{Is_CWU=false}', "");
Expect(0, 71903, '\P{^Is_CWU=false}', "");
Expect(1, 71904, '\p{Is_CWU= -False}', "");
Expect(0, 71904, '\p{^Is_CWU= -False}', "");
Expect(0, 71904, '\P{Is_CWU= -False}', "");
Expect(1, 71904, '\P{^Is_CWU= -False}', "");
Expect(0, 71903, '\p{Is_CWU= -False}', "");
Expect(1, 71903, '\p{^Is_CWU= -False}', "");
Expect(1, 71903, '\P{Is_CWU= -False}', "");
Expect(0, 71903, '\P{^Is_CWU= -False}', "");
Error('\p{Changes_When_Uppercased=:=_Yes}');
Error('\P{Changes_When_Uppercased=:=_Yes}');
Expect(1, 71903, '\p{Changes_When_Uppercased=yes}', "");
Expect(0, 71903, '\p{^Changes_When_Uppercased=yes}', "");
Expect(0, 71903, '\P{Changes_When_Uppercased=yes}', "");
Expect(1, 71903, '\P{^Changes_When_Uppercased=yes}', "");
Expect(0, 71904, '\p{Changes_When_Uppercased=yes}', "");
Expect(1, 71904, '\p{^Changes_When_Uppercased=yes}', "");
Expect(1, 71904, '\P{Changes_When_Uppercased=yes}', "");
Expect(0, 71904, '\P{^Changes_When_Uppercased=yes}', "");
Expect(1, 71903, '\p{Changes_When_Uppercased=_YES}', "");
Expect(0, 71903, '\p{^Changes_When_Uppercased=_YES}', "");
Expect(0, 71903, '\P{Changes_When_Uppercased=_YES}', "");
Expect(1, 71903, '\P{^Changes_When_Uppercased=_YES}', "");
Expect(0, 71904, '\p{Changes_When_Uppercased=_YES}', "");
Expect(1, 71904, '\p{^Changes_When_Uppercased=_YES}', "");
Expect(1, 71904, '\P{Changes_When_Uppercased=_YES}', "");
Expect(0, 71904, '\P{^Changes_When_Uppercased=_YES}', "");
Error('\p{CWU=:= 	Y}');
Error('\P{CWU=:= 	Y}');
Expect(1, 71903, '\p{CWU=y}', "");
Expect(0, 71903, '\p{^CWU=y}', "");
Expect(0, 71903, '\P{CWU=y}', "");
Expect(1, 71903, '\P{^CWU=y}', "");
Expect(0, 71904, '\p{CWU=y}', "");
Expect(1, 71904, '\p{^CWU=y}', "");
Expect(1, 71904, '\P{CWU=y}', "");
Expect(0, 71904, '\P{^CWU=y}', "");
Expect(1, 71903, '\p{CWU=_ Y}', "");
Expect(0, 71903, '\p{^CWU=_ Y}', "");
Expect(0, 71903, '\P{CWU=_ Y}', "");
Expect(1, 71903, '\P{^CWU=_ Y}', "");
Expect(0, 71904, '\p{CWU=_ Y}', "");
Expect(1, 71904, '\p{^CWU=_ Y}', "");
Expect(1, 71904, '\P{CWU=_ Y}', "");
Expect(0, 71904, '\P{^CWU=_ Y}', "");
Error('\p{Is_Changes_When_Uppercased=/a/T}');
Error('\P{Is_Changes_When_Uppercased=/a/T}');
Expect(1, 71903, '\p{Is_Changes_When_Uppercased=t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Uppercased=t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Uppercased=t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Uppercased=t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Uppercased=t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Uppercased=t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Uppercased=t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Uppercased=t}', "");
Expect(1, 71903, '\p{Is_Changes_When_Uppercased=	t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Uppercased=	t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Uppercased=	t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Uppercased=	t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Uppercased=	t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Uppercased=	t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Uppercased=	t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Uppercased=	t}', "");
Error('\p{Is_CWU=	:=True}');
Error('\P{Is_CWU=	:=True}');
Expect(1, 71903, '\p{Is_CWU=true}', "");
Expect(0, 71903, '\p{^Is_CWU=true}', "");
Expect(0, 71903, '\P{Is_CWU=true}', "");
Expect(1, 71903, '\P{^Is_CWU=true}', "");
Expect(0, 71904, '\p{Is_CWU=true}', "");
Expect(1, 71904, '\p{^Is_CWU=true}', "");
Expect(1, 71904, '\P{Is_CWU=true}', "");
Expect(0, 71904, '\P{^Is_CWU=true}', "");
Expect(1, 71903, '\p{Is_CWU=_True}', "");
Expect(0, 71903, '\p{^Is_CWU=_True}', "");
Expect(0, 71903, '\P{Is_CWU=_True}', "");
Expect(1, 71903, '\P{^Is_CWU=_True}', "");
Expect(0, 71904, '\p{Is_CWU=_True}', "");
Expect(1, 71904, '\p{^Is_CWU=_True}', "");
Expect(1, 71904, '\P{Is_CWU=_True}', "");
Expect(0, 71904, '\P{^Is_CWU=_True}', "");
Error('\p{Cased=:= _no}');
Error('\P{Cased=:= _no}');
Expect(1, 127370, '\p{Cased=no}', "");
Expect(0, 127370, '\p{^Cased=no}', "");
Expect(0, 127370, '\P{Cased=no}', "");
Expect(1, 127370, '\P{^Cased=no}', "");
Expect(0, 127369, '\p{Cased=no}', "");
Expect(1, 127369, '\p{^Cased=no}', "");
Expect(1, 127369, '\P{Cased=no}', "");
Expect(0, 127369, '\P{^Cased=no}', "");
Expect(1, 127370, '\p{Cased=No}', "");
Expect(0, 127370, '\p{^Cased=No}', "");
Expect(0, 127370, '\P{Cased=No}', "");
Expect(1, 127370, '\P{^Cased=No}', "");
Expect(0, 127369, '\p{Cased=No}', "");
Expect(1, 127369, '\p{^Cased=No}', "");
Expect(1, 127369, '\P{Cased=No}', "");
Expect(0, 127369, '\P{^Cased=No}', "");
Error('\p{Is_Cased=:= -n}');
Error('\P{Is_Cased=:= -n}');
Expect(1, 127370, '\p{Is_Cased=n}', "");
Expect(0, 127370, '\p{^Is_Cased=n}', "");
Expect(0, 127370, '\P{Is_Cased=n}', "");
Expect(1, 127370, '\P{^Is_Cased=n}', "");
Expect(0, 127369, '\p{Is_Cased=n}', "");
Expect(1, 127369, '\p{^Is_Cased=n}', "");
Expect(1, 127369, '\P{Is_Cased=n}', "");
Expect(0, 127369, '\P{^Is_Cased=n}', "");
Expect(1, 127370, '\p{Is_Cased=- n}', "");
Expect(0, 127370, '\p{^Is_Cased=- n}', "");
Expect(0, 127370, '\P{Is_Cased=- n}', "");
Expect(1, 127370, '\P{^Is_Cased=- n}', "");
Expect(0, 127369, '\p{Is_Cased=- n}', "");
Expect(1, 127369, '\p{^Is_Cased=- n}', "");
Expect(1, 127369, '\P{Is_Cased=- n}', "");
Expect(0, 127369, '\P{^Is_Cased=- n}', "");
Error('\p{Cased=__f/a/}');
Error('\P{Cased=__f/a/}');
Expect(1, 127370, '\p{Cased=f}', "");
Expect(0, 127370, '\p{^Cased=f}', "");
Expect(0, 127370, '\P{Cased=f}', "");
Expect(1, 127370, '\P{^Cased=f}', "");
Expect(0, 127369, '\p{Cased=f}', "");
Expect(1, 127369, '\p{^Cased=f}', "");
Expect(1, 127369, '\P{Cased=f}', "");
Expect(0, 127369, '\P{^Cased=f}', "");
Expect(1, 127370, '\p{Cased=F}', "");
Expect(0, 127370, '\p{^Cased=F}', "");
Expect(0, 127370, '\P{Cased=F}', "");
Expect(1, 127370, '\P{^Cased=F}', "");
Expect(0, 127369, '\p{Cased=F}', "");
Expect(1, 127369, '\p{^Cased=F}', "");
Expect(1, 127369, '\P{Cased=F}', "");
Expect(0, 127369, '\P{^Cased=F}', "");
Error('\p{Is_Cased=_ False:=}');
Error('\P{Is_Cased=_ False:=}');
Expect(1, 127370, '\p{Is_Cased=false}', "");
Expect(0, 127370, '\p{^Is_Cased=false}', "");
Expect(0, 127370, '\P{Is_Cased=false}', "");
Expect(1, 127370, '\P{^Is_Cased=false}', "");
Expect(0, 127369, '\p{Is_Cased=false}', "");
Expect(1, 127369, '\p{^Is_Cased=false}', "");
Expect(1, 127369, '\P{Is_Cased=false}', "");
Expect(0, 127369, '\P{^Is_Cased=false}', "");
Expect(1, 127370, '\p{Is_Cased=- false}', "");
Expect(0, 127370, '\p{^Is_Cased=- false}', "");
Expect(0, 127370, '\P{Is_Cased=- false}', "");
Expect(1, 127370, '\P{^Is_Cased=- false}', "");
Expect(0, 127369, '\p{Is_Cased=- false}', "");
Expect(1, 127369, '\p{^Is_Cased=- false}', "");
Expect(1, 127369, '\P{Is_Cased=- false}', "");
Expect(0, 127369, '\P{^Is_Cased=- false}', "");
Error('\p{Cased=_Yes:=}');
Error('\P{Cased=_Yes:=}');
Expect(1, 127369, '\p{Cased=yes}', "");
Expect(0, 127369, '\p{^Cased=yes}', "");
Expect(0, 127369, '\P{Cased=yes}', "");
Expect(1, 127369, '\P{^Cased=yes}', "");
Expect(0, 127370, '\p{Cased=yes}', "");
Expect(1, 127370, '\p{^Cased=yes}', "");
Expect(1, 127370, '\P{Cased=yes}', "");
Expect(0, 127370, '\P{^Cased=yes}', "");
Expect(1, 127369, '\p{Cased=_yes}', "");
Expect(0, 127369, '\p{^Cased=_yes}', "");
Expect(0, 127369, '\P{Cased=_yes}', "");
Expect(1, 127369, '\P{^Cased=_yes}', "");
Expect(0, 127370, '\p{Cased=_yes}', "");
Expect(1, 127370, '\p{^Cased=_yes}', "");
Expect(1, 127370, '\P{Cased=_yes}', "");
Expect(0, 127370, '\P{^Cased=_yes}', "");
Error('\p{Is_Cased=_/a/Y}');
Error('\P{Is_Cased=_/a/Y}');
Expect(1, 127369, '\p{Is_Cased=y}', "");
Expect(0, 127369, '\p{^Is_Cased=y}', "");
Expect(0, 127369, '\P{Is_Cased=y}', "");
Expect(1, 127369, '\P{^Is_Cased=y}', "");
Expect(0, 127370, '\p{Is_Cased=y}', "");
Expect(1, 127370, '\p{^Is_Cased=y}', "");
Expect(1, 127370, '\P{Is_Cased=y}', "");
Expect(0, 127370, '\P{^Is_Cased=y}', "");
Expect(1, 127369, '\p{Is_Cased=_ Y}', "");
Expect(0, 127369, '\p{^Is_Cased=_ Y}', "");
Expect(0, 127369, '\P{Is_Cased=_ Y}', "");
Expect(1, 127369, '\P{^Is_Cased=_ Y}', "");
Expect(0, 127370, '\p{Is_Cased=_ Y}', "");
Expect(1, 127370, '\p{^Is_Cased=_ Y}', "");
Expect(1, 127370, '\P{Is_Cased=_ Y}', "");
Expect(0, 127370, '\P{^Is_Cased=_ Y}', "");
Error('\p{Cased=/a/-_T}');
Error('\P{Cased=/a/-_T}');
Expect(1, 127369, '\p{Cased=t}', "");
Expect(0, 127369, '\p{^Cased=t}', "");
Expect(0, 127369, '\P{Cased=t}', "");
Expect(1, 127369, '\P{^Cased=t}', "");
Expect(0, 127370, '\p{Cased=t}', "");
Expect(1, 127370, '\p{^Cased=t}', "");
Expect(1, 127370, '\P{Cased=t}', "");
Expect(0, 127370, '\P{^Cased=t}', "");
Expect(1, 127369, '\p{Cased=_ T}', "");
Expect(0, 127369, '\p{^Cased=_ T}', "");
Expect(0, 127369, '\P{Cased=_ T}', "");
Expect(1, 127369, '\P{^Cased=_ T}', "");
Expect(0, 127370, '\p{Cased=_ T}', "");
Expect(1, 127370, '\p{^Cased=_ T}', "");
Expect(1, 127370, '\P{Cased=_ T}', "");
Expect(0, 127370, '\P{^Cased=_ T}', "");
Error('\p{Is_Cased=__true:=}');
Error('\P{Is_Cased=__true:=}');
Expect(1, 127369, '\p{Is_Cased=true}', "");
Expect(0, 127369, '\p{^Is_Cased=true}', "");
Expect(0, 127369, '\P{Is_Cased=true}', "");
Expect(1, 127369, '\P{^Is_Cased=true}', "");
Expect(0, 127370, '\p{Is_Cased=true}', "");
Expect(1, 127370, '\p{^Is_Cased=true}', "");
Expect(1, 127370, '\P{Is_Cased=true}', "");
Expect(0, 127370, '\P{^Is_Cased=true}', "");
Expect(1, 127369, '\p{Is_Cased:_true}', "");
Expect(0, 127369, '\p{^Is_Cased:_true}', "");
Expect(0, 127369, '\P{Is_Cased:_true}', "");
Expect(1, 127369, '\P{^Is_Cased:_true}', "");
Expect(0, 127370, '\p{Is_Cased:_true}', "");
Expect(1, 127370, '\p{^Is_Cased:_true}', "");
Expect(1, 127370, '\P{Is_Cased:_true}', "");
Expect(0, 127370, '\P{^Is_Cased:_true}', "");
Error('\p{Full_Composition_Exclusion= :=NO}');
Error('\P{Full_Composition_Exclusion= :=NO}');
Expect(1, 195102, '\p{Full_Composition_Exclusion=no}', "");
Expect(0, 195102, '\p{^Full_Composition_Exclusion=no}', "");
Expect(0, 195102, '\P{Full_Composition_Exclusion=no}', "");
Expect(1, 195102, '\P{^Full_Composition_Exclusion=no}', "");
Expect(0, 195101, '\p{Full_Composition_Exclusion=no}', "");
Expect(1, 195101, '\p{^Full_Composition_Exclusion=no}', "");
Expect(1, 195101, '\P{Full_Composition_Exclusion=no}', "");
Expect(0, 195101, '\P{^Full_Composition_Exclusion=no}', "");
Expect(1, 195102, '\p{Full_Composition_Exclusion:	no}', "");
Expect(0, 195102, '\p{^Full_Composition_Exclusion:	no}', "");
Expect(0, 195102, '\P{Full_Composition_Exclusion:	no}', "");
Expect(1, 195102, '\P{^Full_Composition_Exclusion:	no}', "");
Expect(0, 195101, '\p{Full_Composition_Exclusion:	no}', "");
Expect(1, 195101, '\p{^Full_Composition_Exclusion:	no}', "");
Expect(1, 195101, '\P{Full_Composition_Exclusion:	no}', "");
Expect(0, 195101, '\P{^Full_Composition_Exclusion:	no}', "");
Error('\p{Comp_Ex:- N:=}');
Error('\P{Comp_Ex:- N:=}');
Expect(1, 195102, '\p{Comp_Ex=n}', "");
Expect(0, 195102, '\p{^Comp_Ex=n}', "");
Expect(0, 195102, '\P{Comp_Ex=n}', "");
Expect(1, 195102, '\P{^Comp_Ex=n}', "");
Expect(0, 195101, '\p{Comp_Ex=n}', "");
Expect(1, 195101, '\p{^Comp_Ex=n}', "");
Expect(1, 195101, '\P{Comp_Ex=n}', "");
Expect(0, 195101, '\P{^Comp_Ex=n}', "");
Expect(1, 195102, '\p{Comp_Ex=__n}', "");
Expect(0, 195102, '\p{^Comp_Ex=__n}', "");
Expect(0, 195102, '\P{Comp_Ex=__n}', "");
Expect(1, 195102, '\P{^Comp_Ex=__n}', "");
Expect(0, 195101, '\p{Comp_Ex=__n}', "");
Expect(1, 195101, '\p{^Comp_Ex=__n}', "");
Expect(1, 195101, '\P{Comp_Ex=__n}', "");
Expect(0, 195101, '\P{^Comp_Ex=__n}', "");
Error('\p{Is_Full_Composition_Exclusion:	-	f/a/}');
Error('\P{Is_Full_Composition_Exclusion:	-	f/a/}');
Expect(1, 195102, '\p{Is_Full_Composition_Exclusion=f}', "");
Expect(0, 195102, '\p{^Is_Full_Composition_Exclusion=f}', "");
Expect(0, 195102, '\P{Is_Full_Composition_Exclusion=f}', "");
Expect(1, 195102, '\P{^Is_Full_Composition_Exclusion=f}', "");
Expect(0, 195101, '\p{Is_Full_Composition_Exclusion=f}', "");
Expect(1, 195101, '\p{^Is_Full_Composition_Exclusion=f}', "");
Expect(1, 195101, '\P{Is_Full_Composition_Exclusion=f}', "");
Expect(0, 195101, '\P{^Is_Full_Composition_Exclusion=f}', "");
Expect(1, 195102, '\p{Is_Full_Composition_Exclusion= F}', "");
Expect(0, 195102, '\p{^Is_Full_Composition_Exclusion= F}', "");
Expect(0, 195102, '\P{Is_Full_Composition_Exclusion= F}', "");
Expect(1, 195102, '\P{^Is_Full_Composition_Exclusion= F}', "");
Expect(0, 195101, '\p{Is_Full_Composition_Exclusion= F}', "");
Expect(1, 195101, '\p{^Is_Full_Composition_Exclusion= F}', "");
Expect(1, 195101, '\P{Is_Full_Composition_Exclusion= F}', "");
Expect(0, 195101, '\P{^Is_Full_Composition_Exclusion= F}', "");
Error('\p{Is_Comp_Ex=/a/__FALSE}');
Error('\P{Is_Comp_Ex=/a/__FALSE}');
Expect(1, 195102, '\p{Is_Comp_Ex=false}', "");
Expect(0, 195102, '\p{^Is_Comp_Ex=false}', "");
Expect(0, 195102, '\P{Is_Comp_Ex=false}', "");
Expect(1, 195102, '\P{^Is_Comp_Ex=false}', "");
Expect(0, 195101, '\p{Is_Comp_Ex=false}', "");
Expect(1, 195101, '\p{^Is_Comp_Ex=false}', "");
Expect(1, 195101, '\P{Is_Comp_Ex=false}', "");
Expect(0, 195101, '\P{^Is_Comp_Ex=false}', "");
Expect(1, 195102, '\p{Is_Comp_Ex= FALSE}', "");
Expect(0, 195102, '\p{^Is_Comp_Ex= FALSE}', "");
Expect(0, 195102, '\P{Is_Comp_Ex= FALSE}', "");
Expect(1, 195102, '\P{^Is_Comp_Ex= FALSE}', "");
Expect(0, 195101, '\p{Is_Comp_Ex= FALSE}', "");
Expect(1, 195101, '\p{^Is_Comp_Ex= FALSE}', "");
Expect(1, 195101, '\P{Is_Comp_Ex= FALSE}', "");
Expect(0, 195101, '\P{^Is_Comp_Ex= FALSE}', "");
Error('\p{Full_Composition_Exclusion=	/a/Yes}');
Error('\P{Full_Composition_Exclusion=	/a/Yes}');
Expect(1, 195101, '\p{Full_Composition_Exclusion: yes}', "");
Expect(0, 195101, '\p{^Full_Composition_Exclusion: yes}', "");
Expect(0, 195101, '\P{Full_Composition_Exclusion: yes}', "");
Expect(1, 195101, '\P{^Full_Composition_Exclusion: yes}', "");
Expect(0, 195102, '\p{Full_Composition_Exclusion: yes}', "");
Expect(1, 195102, '\p{^Full_Composition_Exclusion: yes}', "");
Expect(1, 195102, '\P{Full_Composition_Exclusion: yes}', "");
Expect(0, 195102, '\P{^Full_Composition_Exclusion: yes}', "");
Expect(1, 195101, '\p{Full_Composition_Exclusion=_	YES}', "");
Expect(0, 195101, '\p{^Full_Composition_Exclusion=_	YES}', "");
Expect(0, 195101, '\P{Full_Composition_Exclusion=_	YES}', "");
Expect(1, 195101, '\P{^Full_Composition_Exclusion=_	YES}', "");
Expect(0, 195102, '\p{Full_Composition_Exclusion=_	YES}', "");
Expect(1, 195102, '\p{^Full_Composition_Exclusion=_	YES}', "");
Expect(1, 195102, '\P{Full_Composition_Exclusion=_	YES}', "");
Expect(0, 195102, '\P{^Full_Composition_Exclusion=_	YES}', "");
Error('\p{Comp_Ex:		:=Y}');
Error('\P{Comp_Ex:		:=Y}');
Expect(1, 195101, '\p{Comp_Ex=y}', "");
Expect(0, 195101, '\p{^Comp_Ex=y}', "");
Expect(0, 195101, '\P{Comp_Ex=y}', "");
Expect(1, 195101, '\P{^Comp_Ex=y}', "");
Expect(0, 195102, '\p{Comp_Ex=y}', "");
Expect(1, 195102, '\p{^Comp_Ex=y}', "");
Expect(1, 195102, '\P{Comp_Ex=y}', "");
Expect(0, 195102, '\P{^Comp_Ex=y}', "");
Expect(1, 195101, '\p{Comp_Ex=--Y}', "");
Expect(0, 195101, '\p{^Comp_Ex=--Y}', "");
Expect(0, 195101, '\P{Comp_Ex=--Y}', "");
Expect(1, 195101, '\P{^Comp_Ex=--Y}', "");
Expect(0, 195102, '\p{Comp_Ex=--Y}', "");
Expect(1, 195102, '\p{^Comp_Ex=--Y}', "");
Expect(1, 195102, '\P{Comp_Ex=--Y}', "");
Expect(0, 195102, '\P{^Comp_Ex=--Y}', "");
Error('\p{Is_Full_Composition_Exclusion= :=t}');
Error('\P{Is_Full_Composition_Exclusion= :=t}');
Expect(1, 195101, '\p{Is_Full_Composition_Exclusion=t}', "");
Expect(0, 195101, '\p{^Is_Full_Composition_Exclusion=t}', "");
Expect(0, 195101, '\P{Is_Full_Composition_Exclusion=t}', "");
Expect(1, 195101, '\P{^Is_Full_Composition_Exclusion=t}', "");
Expect(0, 195102, '\p{Is_Full_Composition_Exclusion=t}', "");
Expect(1, 195102, '\p{^Is_Full_Composition_Exclusion=t}', "");
Expect(1, 195102, '\P{Is_Full_Composition_Exclusion=t}', "");
Expect(0, 195102, '\P{^Is_Full_Composition_Exclusion=t}', "");
Expect(1, 195101, '\p{Is_Full_Composition_Exclusion= _T}', "");
Expect(0, 195101, '\p{^Is_Full_Composition_Exclusion= _T}', "");
Expect(0, 195101, '\P{Is_Full_Composition_Exclusion= _T}', "");
Expect(1, 195101, '\P{^Is_Full_Composition_Exclusion= _T}', "");
Expect(0, 195102, '\p{Is_Full_Composition_Exclusion= _T}', "");
Expect(1, 195102, '\p{^Is_Full_Composition_Exclusion= _T}', "");
Expect(1, 195102, '\P{Is_Full_Composition_Exclusion= _T}', "");
Expect(0, 195102, '\P{^Is_Full_Composition_Exclusion= _T}', "");
Error('\p{Is_Comp_Ex:	True:=}');
Error('\P{Is_Comp_Ex:	True:=}');
Expect(1, 195101, '\p{Is_Comp_Ex=true}', "");
Expect(0, 195101, '\p{^Is_Comp_Ex=true}', "");
Expect(0, 195101, '\P{Is_Comp_Ex=true}', "");
Expect(1, 195101, '\P{^Is_Comp_Ex=true}', "");
Expect(0, 195102, '\p{Is_Comp_Ex=true}', "");
Expect(1, 195102, '\p{^Is_Comp_Ex=true}', "");
Expect(1, 195102, '\P{Is_Comp_Ex=true}', "");
Expect(0, 195102, '\P{^Is_Comp_Ex=true}', "");
Expect(1, 195101, '\p{Is_Comp_Ex:	True}', "");
Expect(0, 195101, '\p{^Is_Comp_Ex:	True}', "");
Expect(0, 195101, '\P{Is_Comp_Ex:	True}', "");
Expect(1, 195101, '\P{^Is_Comp_Ex:	True}', "");
Expect(0, 195102, '\p{Is_Comp_Ex:	True}', "");
Expect(1, 195102, '\p{^Is_Comp_Ex:	True}', "");
Expect(1, 195102, '\P{Is_Comp_Ex:	True}', "");
Expect(0, 195102, '\P{^Is_Comp_Ex:	True}', "");
Error('\p{Default_Ignorable_Code_Point=	-NO:=}');
Error('\P{Default_Ignorable_Code_Point=	-NO:=}');
Expect(1, 921600, '\p{Default_Ignorable_Code_Point=no}', "");
Expect(0, 921600, '\p{^Default_Ignorable_Code_Point=no}', "");
Expect(0, 921600, '\P{Default_Ignorable_Code_Point=no}', "");
Expect(1, 921600, '\P{^Default_Ignorable_Code_Point=no}', "");
Expect(0, 921599, '\p{Default_Ignorable_Code_Point=no}', "");
Expect(1, 921599, '\p{^Default_Ignorable_Code_Point=no}', "");
Expect(1, 921599, '\P{Default_Ignorable_Code_Point=no}', "");
Expect(0, 921599, '\P{^Default_Ignorable_Code_Point=no}', "");
Expect(1, 921600, '\p{Default_Ignorable_Code_Point=_No}', "");
Expect(0, 921600, '\p{^Default_Ignorable_Code_Point=_No}', "");
Expect(0, 921600, '\P{Default_Ignorable_Code_Point=_No}', "");
Expect(1, 921600, '\P{^Default_Ignorable_Code_Point=_No}', "");
Expect(0, 921599, '\p{Default_Ignorable_Code_Point=_No}', "");
Expect(1, 921599, '\p{^Default_Ignorable_Code_Point=_No}', "");
Expect(1, 921599, '\P{Default_Ignorable_Code_Point=_No}', "");
Expect(0, 921599, '\P{^Default_Ignorable_Code_Point=_No}', "");
Error('\p{DI=	:=N}');
Error('\P{DI=	:=N}');
Expect(1, 921600, '\p{DI=n}', "");
Expect(0, 921600, '\p{^DI=n}', "");
Expect(0, 921600, '\P{DI=n}', "");
Expect(1, 921600, '\P{^DI=n}', "");
Expect(0, 921599, '\p{DI=n}', "");
Expect(1, 921599, '\p{^DI=n}', "");
Expect(1, 921599, '\P{DI=n}', "");
Expect(0, 921599, '\P{^DI=n}', "");
Expect(1, 921600, '\p{DI:_	N}', "");
Expect(0, 921600, '\p{^DI:_	N}', "");
Expect(0, 921600, '\P{DI:_	N}', "");
Expect(1, 921600, '\P{^DI:_	N}', "");
Expect(0, 921599, '\p{DI:_	N}', "");
Expect(1, 921599, '\p{^DI:_	N}', "");
Expect(1, 921599, '\P{DI:_	N}', "");
Expect(0, 921599, '\P{^DI:_	N}', "");
Error('\p{Is_Default_Ignorable_Code_Point=:=  f}');
Error('\P{Is_Default_Ignorable_Code_Point=:=  f}');
Expect(1, 921600, '\p{Is_Default_Ignorable_Code_Point=f}', "");
Expect(0, 921600, '\p{^Is_Default_Ignorable_Code_Point=f}', "");
Expect(0, 921600, '\P{Is_Default_Ignorable_Code_Point=f}', "");
Expect(1, 921600, '\P{^Is_Default_Ignorable_Code_Point=f}', "");
Expect(0, 921599, '\p{Is_Default_Ignorable_Code_Point=f}', "");
Expect(1, 921599, '\p{^Is_Default_Ignorable_Code_Point=f}', "");
Expect(1, 921599, '\P{Is_Default_Ignorable_Code_Point=f}', "");
Expect(0, 921599, '\P{^Is_Default_Ignorable_Code_Point=f}', "");
Expect(1, 921600, '\p{Is_Default_Ignorable_Code_Point= F}', "");
Expect(0, 921600, '\p{^Is_Default_Ignorable_Code_Point= F}', "");
Expect(0, 921600, '\P{Is_Default_Ignorable_Code_Point= F}', "");
Expect(1, 921600, '\P{^Is_Default_Ignorable_Code_Point= F}', "");
Expect(0, 921599, '\p{Is_Default_Ignorable_Code_Point= F}', "");
Expect(1, 921599, '\p{^Is_Default_Ignorable_Code_Point= F}', "");
Expect(1, 921599, '\P{Is_Default_Ignorable_Code_Point= F}', "");
Expect(0, 921599, '\P{^Is_Default_Ignorable_Code_Point= F}', "");
Error('\p{Is_DI= 	False:=}');
Error('\P{Is_DI= 	False:=}');
Expect(1, 921600, '\p{Is_DI=false}', "");
Expect(0, 921600, '\p{^Is_DI=false}', "");
Expect(0, 921600, '\P{Is_DI=false}', "");
Expect(1, 921600, '\P{^Is_DI=false}', "");
Expect(0, 921599, '\p{Is_DI=false}', "");
Expect(1, 921599, '\p{^Is_DI=false}', "");
Expect(1, 921599, '\P{Is_DI=false}', "");
Expect(0, 921599, '\P{^Is_DI=false}', "");
Expect(1, 921600, '\p{Is_DI=_-False}', "");
Expect(0, 921600, '\p{^Is_DI=_-False}', "");
Expect(0, 921600, '\P{Is_DI=_-False}', "");
Expect(1, 921600, '\P{^Is_DI=_-False}', "");
Expect(0, 921599, '\p{Is_DI=_-False}', "");
Expect(1, 921599, '\p{^Is_DI=_-False}', "");
Expect(1, 921599, '\P{Is_DI=_-False}', "");
Expect(0, 921599, '\P{^Is_DI=_-False}', "");
Error('\p{Default_Ignorable_Code_Point:	yes:=}');
Error('\P{Default_Ignorable_Code_Point:	yes:=}');
Expect(1, 921599, '\p{Default_Ignorable_Code_Point=yes}', "");
Expect(0, 921599, '\p{^Default_Ignorable_Code_Point=yes}', "");
Expect(0, 921599, '\P{Default_Ignorable_Code_Point=yes}', "");
Expect(1, 921599, '\P{^Default_Ignorable_Code_Point=yes}', "");
Expect(0, 921600, '\p{Default_Ignorable_Code_Point=yes}', "");
Expect(1, 921600, '\p{^Default_Ignorable_Code_Point=yes}', "");
Expect(1, 921600, '\P{Default_Ignorable_Code_Point=yes}', "");
Expect(0, 921600, '\P{^Default_Ignorable_Code_Point=yes}', "");
Expect(1, 921599, '\p{Default_Ignorable_Code_Point=_	yes}', "");
Expect(0, 921599, '\p{^Default_Ignorable_Code_Point=_	yes}', "");
Expect(0, 921599, '\P{Default_Ignorable_Code_Point=_	yes}', "");
Expect(1, 921599, '\P{^Default_Ignorable_Code_Point=_	yes}', "");
Expect(0, 921600, '\p{Default_Ignorable_Code_Point=_	yes}', "");
Expect(1, 921600, '\p{^Default_Ignorable_Code_Point=_	yes}', "");
Expect(1, 921600, '\P{Default_Ignorable_Code_Point=_	yes}', "");
Expect(0, 921600, '\P{^Default_Ignorable_Code_Point=_	yes}', "");
Error('\p{DI= 	Y/a/}');
Error('\P{DI= 	Y/a/}');
Expect(1, 921599, '\p{DI=y}', "");
Expect(0, 921599, '\p{^DI=y}', "");
Expect(0, 921599, '\P{DI=y}', "");
Expect(1, 921599, '\P{^DI=y}', "");
Expect(0, 921600, '\p{DI=y}', "");
Expect(1, 921600, '\p{^DI=y}', "");
Expect(1, 921600, '\P{DI=y}', "");
Expect(0, 921600, '\P{^DI=y}', "");
Expect(1, 921599, '\p{DI=-Y}', "");
Expect(0, 921599, '\p{^DI=-Y}', "");
Expect(0, 921599, '\P{DI=-Y}', "");
Expect(1, 921599, '\P{^DI=-Y}', "");
Expect(0, 921600, '\p{DI=-Y}', "");
Expect(1, 921600, '\p{^DI=-Y}', "");
Expect(1, 921600, '\P{DI=-Y}', "");
Expect(0, 921600, '\P{^DI=-Y}', "");
Error('\p{Is_Default_Ignorable_Code_Point=	T:=}');
Error('\P{Is_Default_Ignorable_Code_Point=	T:=}');
Expect(1, 921599, '\p{Is_Default_Ignorable_Code_Point=t}', "");
Expect(0, 921599, '\p{^Is_Default_Ignorable_Code_Point=t}', "");
Expect(0, 921599, '\P{Is_Default_Ignorable_Code_Point=t}', "");
Expect(1, 921599, '\P{^Is_Default_Ignorable_Code_Point=t}', "");
Expect(0, 921600, '\p{Is_Default_Ignorable_Code_Point=t}', "");
Expect(1, 921600, '\p{^Is_Default_Ignorable_Code_Point=t}', "");
Expect(1, 921600, '\P{Is_Default_Ignorable_Code_Point=t}', "");
Expect(0, 921600, '\P{^Is_Default_Ignorable_Code_Point=t}', "");
Expect(1, 921599, '\p{Is_Default_Ignorable_Code_Point=	T}', "");
Expect(0, 921599, '\p{^Is_Default_Ignorable_Code_Point=	T}', "");
Expect(0, 921599, '\P{Is_Default_Ignorable_Code_Point=	T}', "");
Expect(1, 921599, '\P{^Is_Default_Ignorable_Code_Point=	T}', "");
Expect(0, 921600, '\p{Is_Default_Ignorable_Code_Point=	T}', "");
Expect(1, 921600, '\p{^Is_Default_Ignorable_Code_Point=	T}', "");
Expect(1, 921600, '\P{Is_Default_Ignorable_Code_Point=	T}', "");
Expect(0, 921600, '\P{^Is_Default_Ignorable_Code_Point=	T}', "");
Error('\p{Is_DI: -_TRUE:=}');
Error('\P{Is_DI: -_TRUE:=}');
Expect(1, 921599, '\p{Is_DI=true}', "");
Expect(0, 921599, '\p{^Is_DI=true}', "");
Expect(0, 921599, '\P{Is_DI=true}', "");
Expect(1, 921599, '\P{^Is_DI=true}', "");
Expect(0, 921600, '\p{Is_DI=true}', "");
Expect(1, 921600, '\p{^Is_DI=true}', "");
Expect(1, 921600, '\P{Is_DI=true}', "");
Expect(0, 921600, '\P{^Is_DI=true}', "");
Expect(1, 921599, '\p{Is_DI: 	_TRUE}', "");
Expect(0, 921599, '\p{^Is_DI: 	_TRUE}', "");
Expect(0, 921599, '\P{Is_DI: 	_TRUE}', "");
Expect(1, 921599, '\P{^Is_DI: 	_TRUE}', "");
Expect(0, 921600, '\p{Is_DI: 	_TRUE}', "");
Expect(1, 921600, '\p{^Is_DI: 	_TRUE}', "");
Expect(1, 921600, '\P{Is_DI: 	_TRUE}', "");
Expect(0, 921600, '\P{^Is_DI: 	_TRUE}', "");
Error('\p{Dash=_-No/a/}');
Error('\P{Dash=_-No/a/}');
Expect(1, 65294, '\p{Dash: no}', "");
Expect(0, 65294, '\p{^Dash: no}', "");
Expect(0, 65294, '\P{Dash: no}', "");
Expect(1, 65294, '\P{^Dash: no}', "");
Expect(0, 65293, '\p{Dash: no}', "");
Expect(1, 65293, '\p{^Dash: no}', "");
Expect(1, 65293, '\P{Dash: no}', "");
Expect(0, 65293, '\P{^Dash: no}', "");
Expect(1, 65294, '\p{Dash= _NO}', "");
Expect(0, 65294, '\p{^Dash= _NO}', "");
Expect(0, 65294, '\P{Dash= _NO}', "");
Expect(1, 65294, '\P{^Dash= _NO}', "");
Expect(0, 65293, '\p{Dash= _NO}', "");
Expect(1, 65293, '\p{^Dash= _NO}', "");
Expect(1, 65293, '\P{Dash= _NO}', "");
Expect(0, 65293, '\P{^Dash= _NO}', "");
Error('\p{Is_Dash=	:=N}');
Error('\P{Is_Dash=	:=N}');
Expect(1, 65294, '\p{Is_Dash=n}', "");
Expect(0, 65294, '\p{^Is_Dash=n}', "");
Expect(0, 65294, '\P{Is_Dash=n}', "");
Expect(1, 65294, '\P{^Is_Dash=n}', "");
Expect(0, 65293, '\p{Is_Dash=n}', "");
Expect(1, 65293, '\p{^Is_Dash=n}', "");
Expect(1, 65293, '\P{Is_Dash=n}', "");
Expect(0, 65293, '\P{^Is_Dash=n}', "");
Expect(1, 65294, '\p{Is_Dash= 	N}', "");
Expect(0, 65294, '\p{^Is_Dash= 	N}', "");
Expect(0, 65294, '\P{Is_Dash= 	N}', "");
Expect(1, 65294, '\P{^Is_Dash= 	N}', "");
Expect(0, 65293, '\p{Is_Dash= 	N}', "");
Expect(1, 65293, '\p{^Is_Dash= 	N}', "");
Expect(1, 65293, '\P{Is_Dash= 	N}', "");
Expect(0, 65293, '\P{^Is_Dash= 	N}', "");
Error('\p{Dash= /a/F}');
Error('\P{Dash= /a/F}');
Expect(1, 65294, '\p{Dash=f}', "");
Expect(0, 65294, '\p{^Dash=f}', "");
Expect(0, 65294, '\P{Dash=f}', "");
Expect(1, 65294, '\P{^Dash=f}', "");
Expect(0, 65293, '\p{Dash=f}', "");
Expect(1, 65293, '\p{^Dash=f}', "");
Expect(1, 65293, '\P{Dash=f}', "");
Expect(0, 65293, '\P{^Dash=f}', "");
Expect(1, 65294, '\p{Dash=	 f}', "");
Expect(0, 65294, '\p{^Dash=	 f}', "");
Expect(0, 65294, '\P{Dash=	 f}', "");
Expect(1, 65294, '\P{^Dash=	 f}', "");
Expect(0, 65293, '\p{Dash=	 f}', "");
Expect(1, 65293, '\p{^Dash=	 f}', "");
Expect(1, 65293, '\P{Dash=	 f}', "");
Expect(0, 65293, '\P{^Dash=	 f}', "");
Error('\p{Is_Dash=:=_-False}');
Error('\P{Is_Dash=:=_-False}');
Expect(1, 65294, '\p{Is_Dash: false}', "");
Expect(0, 65294, '\p{^Is_Dash: false}', "");
Expect(0, 65294, '\P{Is_Dash: false}', "");
Expect(1, 65294, '\P{^Is_Dash: false}', "");
Expect(0, 65293, '\p{Is_Dash: false}', "");
Expect(1, 65293, '\p{^Is_Dash: false}', "");
Expect(1, 65293, '\P{Is_Dash: false}', "");
Expect(0, 65293, '\P{^Is_Dash: false}', "");
Expect(1, 65294, '\p{Is_Dash=-false}', "");
Expect(0, 65294, '\p{^Is_Dash=-false}', "");
Expect(0, 65294, '\P{Is_Dash=-false}', "");
Expect(1, 65294, '\P{^Is_Dash=-false}', "");
Expect(0, 65293, '\p{Is_Dash=-false}', "");
Expect(1, 65293, '\p{^Is_Dash=-false}', "");
Expect(1, 65293, '\P{Is_Dash=-false}', "");
Expect(0, 65293, '\P{^Is_Dash=-false}', "");
Error('\p{Dash:  :=yes}');
Error('\P{Dash:  :=yes}');
Expect(1, 65293, '\p{Dash=yes}', "");
Expect(0, 65293, '\p{^Dash=yes}', "");
Expect(0, 65293, '\P{Dash=yes}', "");
Expect(1, 65293, '\P{^Dash=yes}', "");
Expect(0, 65294, '\p{Dash=yes}', "");
Expect(1, 65294, '\p{^Dash=yes}', "");
Expect(1, 65294, '\P{Dash=yes}', "");
Expect(0, 65294, '\P{^Dash=yes}', "");
Expect(1, 65293, '\p{Dash=--Yes}', "");
Expect(0, 65293, '\p{^Dash=--Yes}', "");
Expect(0, 65293, '\P{Dash=--Yes}', "");
Expect(1, 65293, '\P{^Dash=--Yes}', "");
Expect(0, 65294, '\p{Dash=--Yes}', "");
Expect(1, 65294, '\p{^Dash=--Yes}', "");
Expect(1, 65294, '\P{Dash=--Yes}', "");
Expect(0, 65294, '\P{^Dash=--Yes}', "");
Error('\p{Is_Dash=	/a/Y}');
Error('\P{Is_Dash=	/a/Y}');
Expect(1, 65293, '\p{Is_Dash=y}', "");
Expect(0, 65293, '\p{^Is_Dash=y}', "");
Expect(0, 65293, '\P{Is_Dash=y}', "");
Expect(1, 65293, '\P{^Is_Dash=y}', "");
Expect(0, 65294, '\p{Is_Dash=y}', "");
Expect(1, 65294, '\p{^Is_Dash=y}', "");
Expect(1, 65294, '\P{Is_Dash=y}', "");
Expect(0, 65294, '\P{^Is_Dash=y}', "");
Expect(1, 65293, '\p{Is_Dash=	-y}', "");
Expect(0, 65293, '\p{^Is_Dash=	-y}', "");
Expect(0, 65293, '\P{Is_Dash=	-y}', "");
Expect(1, 65293, '\P{^Is_Dash=	-y}', "");
Expect(0, 65294, '\p{Is_Dash=	-y}', "");
Expect(1, 65294, '\p{^Is_Dash=	-y}', "");
Expect(1, 65294, '\P{Is_Dash=	-y}', "");
Expect(0, 65294, '\P{^Is_Dash=	-y}', "");
Error('\p{Dash= T/a/}');
Error('\P{Dash= T/a/}');
Expect(1, 65293, '\p{Dash=t}', "");
Expect(0, 65293, '\p{^Dash=t}', "");
Expect(0, 65293, '\P{Dash=t}', "");
Expect(1, 65293, '\P{^Dash=t}', "");
Expect(0, 65294, '\p{Dash=t}', "");
Expect(1, 65294, '\p{^Dash=t}', "");
Expect(1, 65294, '\P{Dash=t}', "");
Expect(0, 65294, '\P{^Dash=t}', "");
Expect(1, 65293, '\p{Dash=-T}', "");
Expect(0, 65293, '\p{^Dash=-T}', "");
Expect(0, 65293, '\P{Dash=-T}', "");
Expect(1, 65293, '\P{^Dash=-T}', "");
Expect(0, 65294, '\p{Dash=-T}', "");
Expect(1, 65294, '\p{^Dash=-T}', "");
Expect(1, 65294, '\P{Dash=-T}', "");
Expect(0, 65294, '\P{^Dash=-T}', "");
Error('\p{Is_Dash=-:=TRUE}');
Error('\P{Is_Dash=-:=TRUE}');
Expect(1, 65293, '\p{Is_Dash=true}', "");
Expect(0, 65293, '\p{^Is_Dash=true}', "");
Expect(0, 65293, '\P{Is_Dash=true}', "");
Expect(1, 65293, '\P{^Is_Dash=true}', "");
Expect(0, 65294, '\p{Is_Dash=true}', "");
Expect(1, 65294, '\p{^Is_Dash=true}', "");
Expect(1, 65294, '\P{Is_Dash=true}', "");
Expect(0, 65294, '\P{^Is_Dash=true}', "");
Expect(1, 65293, '\p{Is_Dash= _True}', "");
Expect(0, 65293, '\p{^Is_Dash= _True}', "");
Expect(0, 65293, '\P{Is_Dash= _True}', "");
Expect(1, 65293, '\P{^Is_Dash= _True}', "");
Expect(0, 65294, '\p{Is_Dash= _True}', "");
Expect(1, 65294, '\p{^Is_Dash= _True}', "");
Expect(1, 65294, '\P{Is_Dash= _True}', "");
Expect(0, 65294, '\P{^Is_Dash= _True}', "");
Error('\p{Deprecated=-/a/NO}');
Error('\P{Deprecated=-/a/NO}');
Expect(1, 917632, '\p{Deprecated=no}', "");
Expect(0, 917632, '\p{^Deprecated=no}', "");
Expect(0, 917632, '\P{Deprecated=no}', "");
Expect(1, 917632, '\P{^Deprecated=no}', "");
Expect(0, 917631, '\p{Deprecated=no}', "");
Expect(1, 917631, '\p{^Deprecated=no}', "");
Expect(1, 917631, '\P{Deprecated=no}', "");
Expect(0, 917631, '\P{^Deprecated=no}', "");
Expect(1, 917632, '\p{Deprecated:   - No}', "");
Expect(0, 917632, '\p{^Deprecated:   - No}', "");
Expect(0, 917632, '\P{Deprecated:   - No}', "");
Expect(1, 917632, '\P{^Deprecated:   - No}', "");
Expect(0, 917631, '\p{Deprecated:   - No}', "");
Expect(1, 917631, '\p{^Deprecated:   - No}', "");
Expect(1, 917631, '\P{Deprecated:   - No}', "");
Expect(0, 917631, '\P{^Deprecated:   - No}', "");
Error('\p{Dep=_:=N}');
Error('\P{Dep=_:=N}');
Expect(1, 917632, '\p{Dep=n}', "");
Expect(0, 917632, '\p{^Dep=n}', "");
Expect(0, 917632, '\P{Dep=n}', "");
Expect(1, 917632, '\P{^Dep=n}', "");
Expect(0, 917631, '\p{Dep=n}', "");
Expect(1, 917631, '\p{^Dep=n}', "");
Expect(1, 917631, '\P{Dep=n}', "");
Expect(0, 917631, '\P{^Dep=n}', "");
Expect(1, 917632, '\p{Dep= N}', "");
Expect(0, 917632, '\p{^Dep= N}', "");
Expect(0, 917632, '\P{Dep= N}', "");
Expect(1, 917632, '\P{^Dep= N}', "");
Expect(0, 917631, '\p{Dep= N}', "");
Expect(1, 917631, '\p{^Dep= N}', "");
Expect(1, 917631, '\P{Dep= N}', "");
Expect(0, 917631, '\P{^Dep= N}', "");
Error('\p{Is_Deprecated= /a/F}');
Error('\P{Is_Deprecated= /a/F}');
Expect(1, 917632, '\p{Is_Deprecated=f}', "");
Expect(0, 917632, '\p{^Is_Deprecated=f}', "");
Expect(0, 917632, '\P{Is_Deprecated=f}', "");
Expect(1, 917632, '\P{^Is_Deprecated=f}', "");
Expect(0, 917631, '\p{Is_Deprecated=f}', "");
Expect(1, 917631, '\p{^Is_Deprecated=f}', "");
Expect(1, 917631, '\P{Is_Deprecated=f}', "");
Expect(0, 917631, '\P{^Is_Deprecated=f}', "");
Expect(1, 917632, '\p{Is_Deprecated=-_F}', "");
Expect(0, 917632, '\p{^Is_Deprecated=-_F}', "");
Expect(0, 917632, '\P{Is_Deprecated=-_F}', "");
Expect(1, 917632, '\P{^Is_Deprecated=-_F}', "");
Expect(0, 917631, '\p{Is_Deprecated=-_F}', "");
Expect(1, 917631, '\p{^Is_Deprecated=-_F}', "");
Expect(1, 917631, '\P{Is_Deprecated=-_F}', "");
Expect(0, 917631, '\P{^Is_Deprecated=-_F}', "");
Error('\p{Is_Dep:		:=FALSE}');
Error('\P{Is_Dep:		:=FALSE}');
Expect(1, 917632, '\p{Is_Dep: false}', "");
Expect(0, 917632, '\p{^Is_Dep: false}', "");
Expect(0, 917632, '\P{Is_Dep: false}', "");
Expect(1, 917632, '\P{^Is_Dep: false}', "");
Expect(0, 917631, '\p{Is_Dep: false}', "");
Expect(1, 917631, '\p{^Is_Dep: false}', "");
Expect(1, 917631, '\P{Is_Dep: false}', "");
Expect(0, 917631, '\P{^Is_Dep: false}', "");
Expect(1, 917632, '\p{Is_Dep=		False}', "");
Expect(0, 917632, '\p{^Is_Dep=		False}', "");
Expect(0, 917632, '\P{Is_Dep=		False}', "");
Expect(1, 917632, '\P{^Is_Dep=		False}', "");
Expect(0, 917631, '\p{Is_Dep=		False}', "");
Expect(1, 917631, '\p{^Is_Dep=		False}', "");
Expect(1, 917631, '\P{Is_Dep=		False}', "");
Expect(0, 917631, '\P{^Is_Dep=		False}', "");
Error('\p{Deprecated=/a/	-yes}');
Error('\P{Deprecated=/a/	-yes}');
Expect(1, 917631, '\p{Deprecated=yes}', "");
Expect(0, 917631, '\p{^Deprecated=yes}', "");
Expect(0, 917631, '\P{Deprecated=yes}', "");
Expect(1, 917631, '\P{^Deprecated=yes}', "");
Expect(0, 917632, '\p{Deprecated=yes}', "");
Expect(1, 917632, '\p{^Deprecated=yes}', "");
Expect(1, 917632, '\P{Deprecated=yes}', "");
Expect(0, 917632, '\P{^Deprecated=yes}', "");
Expect(1, 917631, '\p{Deprecated=__Yes}', "");
Expect(0, 917631, '\p{^Deprecated=__Yes}', "");
Expect(0, 917631, '\P{Deprecated=__Yes}', "");
Expect(1, 917631, '\P{^Deprecated=__Yes}', "");
Expect(0, 917632, '\p{Deprecated=__Yes}', "");
Expect(1, 917632, '\p{^Deprecated=__Yes}', "");
Expect(1, 917632, '\P{Deprecated=__Yes}', "");
Expect(0, 917632, '\P{^Deprecated=__Yes}', "");
Error('\p{Dep=_/a/Y}');
Error('\P{Dep=_/a/Y}');
Expect(1, 917631, '\p{Dep=y}', "");
Expect(0, 917631, '\p{^Dep=y}', "");
Expect(0, 917631, '\P{Dep=y}', "");
Expect(1, 917631, '\P{^Dep=y}', "");
Expect(0, 917632, '\p{Dep=y}', "");
Expect(1, 917632, '\p{^Dep=y}', "");
Expect(1, 917632, '\P{Dep=y}', "");
Expect(0, 917632, '\P{^Dep=y}', "");
Expect(1, 917631, '\p{Dep= y}', "");
Expect(0, 917631, '\p{^Dep= y}', "");
Expect(0, 917631, '\P{Dep= y}', "");
Expect(1, 917631, '\P{^Dep= y}', "");
Expect(0, 917632, '\p{Dep= y}', "");
Expect(1, 917632, '\p{^Dep= y}', "");
Expect(1, 917632, '\P{Dep= y}', "");
Expect(0, 917632, '\P{^Dep= y}', "");
Error('\p{Is_Deprecated:   	/a/t}');
Error('\P{Is_Deprecated:   	/a/t}');
Expect(1, 917631, '\p{Is_Deprecated=t}', "");
Expect(0, 917631, '\p{^Is_Deprecated=t}', "");
Expect(0, 917631, '\P{Is_Deprecated=t}', "");
Expect(1, 917631, '\P{^Is_Deprecated=t}', "");
Expect(0, 917632, '\p{Is_Deprecated=t}', "");
Expect(1, 917632, '\p{^Is_Deprecated=t}', "");
Expect(1, 917632, '\P{Is_Deprecated=t}', "");
Expect(0, 917632, '\P{^Is_Deprecated=t}', "");
Expect(1, 917631, '\p{Is_Deprecated=--T}', "");
Expect(0, 917631, '\p{^Is_Deprecated=--T}', "");
Expect(0, 917631, '\P{Is_Deprecated=--T}', "");
Expect(1, 917631, '\P{^Is_Deprecated=--T}', "");
Expect(0, 917632, '\p{Is_Deprecated=--T}', "");
Expect(1, 917632, '\p{^Is_Deprecated=--T}', "");
Expect(1, 917632, '\P{Is_Deprecated=--T}', "");
Expect(0, 917632, '\P{^Is_Deprecated=--T}', "");
Error('\p{Is_Dep=True/a/}');
Error('\P{Is_Dep=True/a/}');
Expect(1, 917631, '\p{Is_Dep=true}', "");
Expect(0, 917631, '\p{^Is_Dep=true}', "");
Expect(0, 917631, '\P{Is_Dep=true}', "");
Expect(1, 917631, '\P{^Is_Dep=true}', "");
Expect(0, 917632, '\p{Is_Dep=true}', "");
Expect(1, 917632, '\p{^Is_Dep=true}', "");
Expect(1, 917632, '\P{Is_Dep=true}', "");
Expect(0, 917632, '\P{^Is_Dep=true}', "");
Expect(1, 917631, '\p{Is_Dep=--True}', "");
Expect(0, 917631, '\p{^Is_Dep=--True}', "");
Expect(0, 917631, '\P{Is_Dep=--True}', "");
Expect(1, 917631, '\P{^Is_Dep=--True}', "");
Expect(0, 917632, '\p{Is_Dep=--True}', "");
Expect(1, 917632, '\p{^Is_Dep=--True}', "");
Expect(1, 917632, '\P{Is_Dep=--True}', "");
Expect(0, 917632, '\P{^Is_Dep=--True}', "");
Error('\p{Diacritic:		/a/NO}');
Error('\P{Diacritic:		/a/NO}');
Expect(1, 125143, '\p{Diacritic=no}', "");
Expect(0, 125143, '\p{^Diacritic=no}', "");
Expect(0, 125143, '\P{Diacritic=no}', "");
Expect(1, 125143, '\P{^Diacritic=no}', "");
Expect(0, 125142, '\p{Diacritic=no}', "");
Expect(1, 125142, '\p{^Diacritic=no}', "");
Expect(1, 125142, '\P{Diacritic=no}', "");
Expect(0, 125142, '\P{^Diacritic=no}', "");
Expect(1, 125143, '\p{Diacritic=- NO}', "");
Expect(0, 125143, '\p{^Diacritic=- NO}', "");
Expect(0, 125143, '\P{Diacritic=- NO}', "");
Expect(1, 125143, '\P{^Diacritic=- NO}', "");
Expect(0, 125142, '\p{Diacritic=- NO}', "");
Expect(1, 125142, '\p{^Diacritic=- NO}', "");
Expect(1, 125142, '\P{Diacritic=- NO}', "");
Expect(0, 125142, '\P{^Diacritic=- NO}', "");
Error('\p{Dia=/a/  N}');
Error('\P{Dia=/a/  N}');
Expect(1, 125143, '\p{Dia=n}', "");
Expect(0, 125143, '\p{^Dia=n}', "");
Expect(0, 125143, '\P{Dia=n}', "");
Expect(1, 125143, '\P{^Dia=n}', "");
Expect(0, 125142, '\p{Dia=n}', "");
Expect(1, 125142, '\p{^Dia=n}', "");
Expect(1, 125142, '\P{Dia=n}', "");
Expect(0, 125142, '\P{^Dia=n}', "");
Expect(1, 125143, '\p{Dia=-_N}', "");
Expect(0, 125143, '\p{^Dia=-_N}', "");
Expect(0, 125143, '\P{Dia=-_N}', "");
Expect(1, 125143, '\P{^Dia=-_N}', "");
Expect(0, 125142, '\p{Dia=-_N}', "");
Expect(1, 125142, '\p{^Dia=-_N}', "");
Expect(1, 125142, '\P{Dia=-_N}', "");
Expect(0, 125142, '\P{^Dia=-_N}', "");
Error('\p{Is_Diacritic=F:=}');
Error('\P{Is_Diacritic=F:=}');
Expect(1, 125143, '\p{Is_Diacritic=f}', "");
Expect(0, 125143, '\p{^Is_Diacritic=f}', "");
Expect(0, 125143, '\P{Is_Diacritic=f}', "");
Expect(1, 125143, '\P{^Is_Diacritic=f}', "");
Expect(0, 125142, '\p{Is_Diacritic=f}', "");
Expect(1, 125142, '\p{^Is_Diacritic=f}', "");
Expect(1, 125142, '\P{Is_Diacritic=f}', "");
Expect(0, 125142, '\P{^Is_Diacritic=f}', "");
Expect(1, 125143, '\p{Is_Diacritic= 	F}', "");
Expect(0, 125143, '\p{^Is_Diacritic= 	F}', "");
Expect(0, 125143, '\P{Is_Diacritic= 	F}', "");
Expect(1, 125143, '\P{^Is_Diacritic= 	F}', "");
Expect(0, 125142, '\p{Is_Diacritic= 	F}', "");
Expect(1, 125142, '\p{^Is_Diacritic= 	F}', "");
Expect(1, 125142, '\P{Is_Diacritic= 	F}', "");
Expect(0, 125142, '\P{^Is_Diacritic= 	F}', "");
Error('\p{Is_Dia= -False:=}');
Error('\P{Is_Dia= -False:=}');
Expect(1, 125143, '\p{Is_Dia=false}', "");
Expect(0, 125143, '\p{^Is_Dia=false}', "");
Expect(0, 125143, '\P{Is_Dia=false}', "");
Expect(1, 125143, '\P{^Is_Dia=false}', "");
Expect(0, 125142, '\p{Is_Dia=false}', "");
Expect(1, 125142, '\p{^Is_Dia=false}', "");
Expect(1, 125142, '\P{Is_Dia=false}', "");
Expect(0, 125142, '\P{^Is_Dia=false}', "");
Expect(1, 125143, '\p{Is_Dia=- False}', "");
Expect(0, 125143, '\p{^Is_Dia=- False}', "");
Expect(0, 125143, '\P{Is_Dia=- False}', "");
Expect(1, 125143, '\P{^Is_Dia=- False}', "");
Expect(0, 125142, '\p{Is_Dia=- False}', "");
Expect(1, 125142, '\p{^Is_Dia=- False}', "");
Expect(1, 125142, '\P{Is_Dia=- False}', "");
Expect(0, 125142, '\P{^Is_Dia=- False}', "");
Error('\p{Diacritic=-:=Yes}');
Error('\P{Diacritic=-:=Yes}');
Expect(1, 125142, '\p{Diacritic:	yes}', "");
Expect(0, 125142, '\p{^Diacritic:	yes}', "");
Expect(0, 125142, '\P{Diacritic:	yes}', "");
Expect(1, 125142, '\P{^Diacritic:	yes}', "");
Expect(0, 125143, '\p{Diacritic:	yes}', "");
Expect(1, 125143, '\p{^Diacritic:	yes}', "");
Expect(1, 125143, '\P{Diacritic:	yes}', "");
Expect(0, 125143, '\P{^Diacritic:	yes}', "");
Expect(1, 125142, '\p{Diacritic= 	yes}', "");
Expect(0, 125142, '\p{^Diacritic= 	yes}', "");
Expect(0, 125142, '\P{Diacritic= 	yes}', "");
Expect(1, 125142, '\P{^Diacritic= 	yes}', "");
Expect(0, 125143, '\p{Diacritic= 	yes}', "");
Expect(1, 125143, '\p{^Diacritic= 	yes}', "");
Expect(1, 125143, '\P{Diacritic= 	yes}', "");
Expect(0, 125143, '\P{^Diacritic= 	yes}', "");
Error('\p{Dia=_:=Y}');
Error('\P{Dia=_:=Y}');
Expect(1, 125142, '\p{Dia=y}', "");
Expect(0, 125142, '\p{^Dia=y}', "");
Expect(0, 125142, '\P{Dia=y}', "");
Expect(1, 125142, '\P{^Dia=y}', "");
Expect(0, 125143, '\p{Dia=y}', "");
Expect(1, 125143, '\p{^Dia=y}', "");
Expect(1, 125143, '\P{Dia=y}', "");
Expect(0, 125143, '\P{^Dia=y}', "");
Expect(1, 125142, '\p{Dia=	Y}', "");
Expect(0, 125142, '\p{^Dia=	Y}', "");
Expect(0, 125142, '\P{Dia=	Y}', "");
Expect(1, 125142, '\P{^Dia=	Y}', "");
Expect(0, 125143, '\p{Dia=	Y}', "");
Expect(1, 125143, '\p{^Dia=	Y}', "");
Expect(1, 125143, '\P{Dia=	Y}', "");
Expect(0, 125143, '\P{^Dia=	Y}', "");
Error('\p{Is_Diacritic:/a/_T}');
Error('\P{Is_Diacritic:/a/_T}');
Expect(1, 125142, '\p{Is_Diacritic=t}', "");
Expect(0, 125142, '\p{^Is_Diacritic=t}', "");
Expect(0, 125142, '\P{Is_Diacritic=t}', "");
Expect(1, 125142, '\P{^Is_Diacritic=t}', "");
Expect(0, 125143, '\p{Is_Diacritic=t}', "");
Expect(1, 125143, '\p{^Is_Diacritic=t}', "");
Expect(1, 125143, '\P{Is_Diacritic=t}', "");
Expect(0, 125143, '\P{^Is_Diacritic=t}', "");
Expect(1, 125142, '\p{Is_Diacritic=_	T}', "");
Expect(0, 125142, '\p{^Is_Diacritic=_	T}', "");
Expect(0, 125142, '\P{Is_Diacritic=_	T}', "");
Expect(1, 125142, '\P{^Is_Diacritic=_	T}', "");
Expect(0, 125143, '\p{Is_Diacritic=_	T}', "");
Expect(1, 125143, '\p{^Is_Diacritic=_	T}', "");
Expect(1, 125143, '\P{Is_Diacritic=_	T}', "");
Expect(0, 125143, '\P{^Is_Diacritic=_	T}', "");
Error('\p{Is_Dia=:=_TRUE}');
Error('\P{Is_Dia=:=_TRUE}');
Expect(1, 125142, '\p{Is_Dia:   true}', "");
Expect(0, 125142, '\p{^Is_Dia:   true}', "");
Expect(0, 125142, '\P{Is_Dia:   true}', "");
Expect(1, 125142, '\P{^Is_Dia:   true}', "");
Expect(0, 125143, '\p{Is_Dia:   true}', "");
Expect(1, 125143, '\p{^Is_Dia:   true}', "");
Expect(1, 125143, '\P{Is_Dia:   true}', "");
Expect(0, 125143, '\P{^Is_Dia:   true}', "");
Expect(1, 125142, '\p{Is_Dia:	-TRUE}', "");
Expect(0, 125142, '\p{^Is_Dia:	-TRUE}', "");
Expect(0, 125142, '\P{Is_Dia:	-TRUE}', "");
Expect(1, 125142, '\P{^Is_Dia:	-TRUE}', "");
Expect(0, 125143, '\p{Is_Dia:	-TRUE}', "");
Expect(1, 125143, '\p{^Is_Dia:	-TRUE}', "");
Expect(1, 125143, '\P{Is_Dia:	-TRUE}', "");
Expect(0, 125143, '\P{^Is_Dia:	-TRUE}', "");
Error('\p{Extender=:= 	no}');
Error('\P{Extender=:= 	no}');
Expect(1, 92996, '\p{Extender=no}', "");
Expect(0, 92996, '\p{^Extender=no}', "");
Expect(0, 92996, '\P{Extender=no}', "");
Expect(1, 92996, '\P{^Extender=no}', "");
Expect(0, 92995, '\p{Extender=no}', "");
Expect(1, 92995, '\p{^Extender=no}', "");
Expect(1, 92995, '\P{Extender=no}', "");
Expect(0, 92995, '\P{^Extender=no}', "");
Expect(1, 92996, '\p{Extender= no}', "");
Expect(0, 92996, '\p{^Extender= no}', "");
Expect(0, 92996, '\P{Extender= no}', "");
Expect(1, 92996, '\P{^Extender= no}', "");
Expect(0, 92995, '\p{Extender= no}', "");
Expect(1, 92995, '\p{^Extender= no}', "");
Expect(1, 92995, '\P{Extender= no}', "");
Expect(0, 92995, '\P{^Extender= no}', "");
Error('\p{Ext= /a/N}');
Error('\P{Ext= /a/N}');
Expect(1, 92996, '\p{Ext=n}', "");
Expect(0, 92996, '\p{^Ext=n}', "");
Expect(0, 92996, '\P{Ext=n}', "");
Expect(1, 92996, '\P{^Ext=n}', "");
Expect(0, 92995, '\p{Ext=n}', "");
Expect(1, 92995, '\p{^Ext=n}', "");
Expect(1, 92995, '\P{Ext=n}', "");
Expect(0, 92995, '\P{^Ext=n}', "");
Expect(1, 92996, '\p{Ext= n}', "");
Expect(0, 92996, '\p{^Ext= n}', "");
Expect(0, 92996, '\P{Ext= n}', "");
Expect(1, 92996, '\P{^Ext= n}', "");
Expect(0, 92995, '\p{Ext= n}', "");
Expect(1, 92995, '\p{^Ext= n}', "");
Expect(1, 92995, '\P{Ext= n}', "");
Expect(0, 92995, '\P{^Ext= n}', "");
Error('\p{Is_Extender=:= _F}');
Error('\P{Is_Extender=:= _F}');
Expect(1, 92996, '\p{Is_Extender=f}', "");
Expect(0, 92996, '\p{^Is_Extender=f}', "");
Expect(0, 92996, '\P{Is_Extender=f}', "");
Expect(1, 92996, '\P{^Is_Extender=f}', "");
Expect(0, 92995, '\p{Is_Extender=f}', "");
Expect(1, 92995, '\p{^Is_Extender=f}', "");
Expect(1, 92995, '\P{Is_Extender=f}', "");
Expect(0, 92995, '\P{^Is_Extender=f}', "");
Expect(1, 92996, '\p{Is_Extender=-F}', "");
Expect(0, 92996, '\p{^Is_Extender=-F}', "");
Expect(0, 92996, '\P{Is_Extender=-F}', "");
Expect(1, 92996, '\P{^Is_Extender=-F}', "");
Expect(0, 92995, '\p{Is_Extender=-F}', "");
Expect(1, 92995, '\p{^Is_Extender=-F}', "");
Expect(1, 92995, '\P{Is_Extender=-F}', "");
Expect(0, 92995, '\P{^Is_Extender=-F}', "");
Error('\p{Is_Ext=/a/-False}');
Error('\P{Is_Ext=/a/-False}');
Expect(1, 92996, '\p{Is_Ext=false}', "");
Expect(0, 92996, '\p{^Is_Ext=false}', "");
Expect(0, 92996, '\P{Is_Ext=false}', "");
Expect(1, 92996, '\P{^Is_Ext=false}', "");
Expect(0, 92995, '\p{Is_Ext=false}', "");
Expect(1, 92995, '\p{^Is_Ext=false}', "");
Expect(1, 92995, '\P{Is_Ext=false}', "");
Expect(0, 92995, '\P{^Is_Ext=false}', "");
Expect(1, 92996, '\p{Is_Ext=		False}', "");
Expect(0, 92996, '\p{^Is_Ext=		False}', "");
Expect(0, 92996, '\P{Is_Ext=		False}', "");
Expect(1, 92996, '\P{^Is_Ext=		False}', "");
Expect(0, 92995, '\p{Is_Ext=		False}', "");
Expect(1, 92995, '\p{^Is_Ext=		False}', "");
Expect(1, 92995, '\P{Is_Ext=		False}', "");
Expect(0, 92995, '\P{^Is_Ext=		False}', "");
Error('\p{Extender=	 Yes:=}');
Error('\P{Extender=	 Yes:=}');
Expect(1, 92995, '\p{Extender=yes}', "");
Expect(0, 92995, '\p{^Extender=yes}', "");
Expect(0, 92995, '\P{Extender=yes}', "");
Expect(1, 92995, '\P{^Extender=yes}', "");
Expect(0, 92996, '\p{Extender=yes}', "");
Expect(1, 92996, '\p{^Extender=yes}', "");
Expect(1, 92996, '\P{Extender=yes}', "");
Expect(0, 92996, '\P{^Extender=yes}', "");
Expect(1, 92995, '\p{Extender= yes}', "");
Expect(0, 92995, '\p{^Extender= yes}', "");
Expect(0, 92995, '\P{Extender= yes}', "");
Expect(1, 92995, '\P{^Extender= yes}', "");
Expect(0, 92996, '\p{Extender= yes}', "");
Expect(1, 92996, '\p{^Extender= yes}', "");
Expect(1, 92996, '\P{Extender= yes}', "");
Expect(0, 92996, '\P{^Extender= yes}', "");
Error('\p{Ext= _Y:=}');
Error('\P{Ext= _Y:=}');
Expect(1, 92995, '\p{Ext:   y}', "");
Expect(0, 92995, '\p{^Ext:   y}', "");
Expect(0, 92995, '\P{Ext:   y}', "");
Expect(1, 92995, '\P{^Ext:   y}', "");
Expect(0, 92996, '\p{Ext:   y}', "");
Expect(1, 92996, '\p{^Ext:   y}', "");
Expect(1, 92996, '\P{Ext:   y}', "");
Expect(0, 92996, '\P{^Ext:   y}', "");
Expect(1, 92995, '\p{Ext=	_y}', "");
Expect(0, 92995, '\p{^Ext=	_y}', "");
Expect(0, 92995, '\P{Ext=	_y}', "");
Expect(1, 92995, '\P{^Ext=	_y}', "");
Expect(0, 92996, '\p{Ext=	_y}', "");
Expect(1, 92996, '\p{^Ext=	_y}', "");
Expect(1, 92996, '\P{Ext=	_y}', "");
Expect(0, 92996, '\P{^Ext=	_y}', "");
Error('\p{Is_Extender=	:=T}');
Error('\P{Is_Extender=	:=T}');
Expect(1, 92995, '\p{Is_Extender=t}', "");
Expect(0, 92995, '\p{^Is_Extender=t}', "");
Expect(0, 92995, '\P{Is_Extender=t}', "");
Expect(1, 92995, '\P{^Is_Extender=t}', "");
Expect(0, 92996, '\p{Is_Extender=t}', "");
Expect(1, 92996, '\p{^Is_Extender=t}', "");
Expect(1, 92996, '\P{Is_Extender=t}', "");
Expect(0, 92996, '\P{^Is_Extender=t}', "");
Expect(1, 92995, '\p{Is_Extender= T}', "");
Expect(0, 92995, '\p{^Is_Extender= T}', "");
Expect(0, 92995, '\P{Is_Extender= T}', "");
Expect(1, 92995, '\P{^Is_Extender= T}', "");
Expect(0, 92996, '\p{Is_Extender= T}', "");
Expect(1, 92996, '\p{^Is_Extender= T}', "");
Expect(1, 92996, '\P{Is_Extender= T}', "");
Expect(0, 92996, '\P{^Is_Extender= T}', "");
Error('\p{Is_Ext=/a/		True}');
Error('\P{Is_Ext=/a/		True}');
Expect(1, 92995, '\p{Is_Ext:	true}', "");
Expect(0, 92995, '\p{^Is_Ext:	true}', "");
Expect(0, 92995, '\P{Is_Ext:	true}', "");
Expect(1, 92995, '\P{^Is_Ext:	true}', "");
Expect(0, 92996, '\p{Is_Ext:	true}', "");
Expect(1, 92996, '\p{^Is_Ext:	true}', "");
Expect(1, 92996, '\P{Is_Ext:	true}', "");
Expect(0, 92996, '\P{^Is_Ext:	true}', "");
Expect(1, 92995, '\p{Is_Ext=		true}', "");
Expect(0, 92995, '\p{^Is_Ext=		true}', "");
Expect(0, 92995, '\P{Is_Ext=		true}', "");
Expect(1, 92995, '\P{^Is_Ext=		true}', "");
Expect(0, 92996, '\p{Is_Ext=		true}', "");
Expect(1, 92996, '\p{^Is_Ext=		true}', "");
Expect(1, 92996, '\P{Is_Ext=		true}', "");
Expect(0, 92996, '\P{^Is_Ext=		true}', "");
Error('\p{Grapheme_Cluster_Break=/a/	-Control}');
Error('\P{Grapheme_Cluster_Break=/a/	-Control}');
Expect(1, 921599, '\p{Grapheme_Cluster_Break=control}', "");
Expect(0, 921599, '\p{^Grapheme_Cluster_Break=control}', "");
Expect(0, 921599, '\P{Grapheme_Cluster_Break=control}', "");
Expect(1, 921599, '\P{^Grapheme_Cluster_Break=control}', "");
Expect(0, 921600, '\p{Grapheme_Cluster_Break=control}', "");
Expect(1, 921600, '\p{^Grapheme_Cluster_Break=control}', "");
Expect(1, 921600, '\P{Grapheme_Cluster_Break=control}', "");
Expect(0, 921600, '\P{^Grapheme_Cluster_Break=control}', "");
Expect(1, 921599, '\p{Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(0, 921599, '\p{^Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(0, 921599, '\P{Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(1, 921599, '\P{^Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(0, 921600, '\p{Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(1, 921600, '\p{^Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(1, 921600, '\P{Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(0, 921600, '\P{^Grapheme_Cluster_Break=_-CONTROL}', "");
Error('\p{GCB=_/a/CN}');
Error('\P{GCB=_/a/CN}');
Expect(1, 921599, '\p{GCB:cn}', "");
Expect(0, 921599, '\p{^GCB:cn}', "");
Expect(0, 921599, '\P{GCB:cn}', "");
Expect(1, 921599, '\P{^GCB:cn}', "");
Expect(0, 921600, '\p{GCB:cn}', "");
Expect(1, 921600, '\p{^GCB:cn}', "");
Expect(1, 921600, '\P{GCB:cn}', "");
Expect(0, 921600, '\P{^GCB:cn}', "");
Expect(1, 921599, '\p{GCB=		CN}', "");
Expect(0, 921599, '\p{^GCB=		CN}', "");
Expect(0, 921599, '\P{GCB=		CN}', "");
Expect(1, 921599, '\P{^GCB=		CN}', "");
Expect(0, 921600, '\p{GCB=		CN}', "");
Expect(1, 921600, '\p{^GCB=		CN}', "");
Expect(1, 921600, '\P{GCB=		CN}', "");
Expect(0, 921600, '\P{^GCB=		CN}', "");
Error('\p{Is_Grapheme_Cluster_Break=-/a/Control}');
Error('\P{Is_Grapheme_Cluster_Break=-/a/Control}');
Expect(1, 921599, '\p{Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 921599, '\p{^Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 921599, '\P{Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 921599, '\P{^Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 921600, '\p{Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 921600, '\p{^Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 921600, '\P{Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 921600, '\P{^Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 921599, '\p{Is_Grapheme_Cluster_Break=	control}', "");
Expect(0, 921599, '\p{^Is_Grapheme_Cluster_Break=	control}', "");
Expect(0, 921599, '\P{Is_Grapheme_Cluster_Break=	control}', "");
Expect(1, 921599, '\P{^Is_Grapheme_Cluster_Break=	control}', "");
Expect(0, 921600, '\p{Is_Grapheme_Cluster_Break=	control}', "");
Expect(1, 921600, '\p{^Is_Grapheme_Cluster_Break=	control}', "");
Expect(1, 921600, '\P{Is_Grapheme_Cluster_Break=	control}', "");
Expect(0, 921600, '\P{^Is_Grapheme_Cluster_Break=	control}', "");
Error('\p{Is_GCB:	- CN/a/}');
Error('\P{Is_GCB:	- CN/a/}');
Expect(1, 921599, '\p{Is_GCB=cn}', "");
Expect(0, 921599, '\p{^Is_GCB=cn}', "");
Expect(0, 921599, '\P{Is_GCB=cn}', "");
Expect(1, 921599, '\P{^Is_GCB=cn}', "");
Expect(0, 921600, '\p{Is_GCB=cn}', "");
Expect(1, 921600, '\p{^Is_GCB=cn}', "");
Expect(1, 921600, '\P{Is_GCB=cn}', "");
Expect(0, 921600, '\P{^Is_GCB=cn}', "");
Expect(1, 921599, '\p{Is_GCB=	cn}', "");
Expect(0, 921599, '\p{^Is_GCB=	cn}', "");
Expect(0, 921599, '\P{Is_GCB=	cn}', "");
Expect(1, 921599, '\P{^Is_GCB=	cn}', "");
Expect(0, 921600, '\p{Is_GCB=	cn}', "");
Expect(1, 921600, '\p{^Is_GCB=	cn}', "");
Expect(1, 921600, '\P{Is_GCB=	cn}', "");
Expect(0, 921600, '\P{^Is_GCB=	cn}', "");
Error('\p{Grapheme_Cluster_Break=/a/ _CR}');
Error('\P{Grapheme_Cluster_Break=/a/ _CR}');
Expect(1, 13, '\p{Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\p{^Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\P{Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\P{^Grapheme_Cluster_Break=cr}', "");
Expect(0, 14, '\p{Grapheme_Cluster_Break=cr}', "");
Expect(1, 14, '\p{^Grapheme_Cluster_Break=cr}', "");
Expect(1, 14, '\P{Grapheme_Cluster_Break=cr}', "");
Expect(0, 14, '\P{^Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\p{Grapheme_Cluster_Break= CR}', "");
Expect(0, 13, '\p{^Grapheme_Cluster_Break= CR}', "");
Expect(0, 13, '\P{Grapheme_Cluster_Break= CR}', "");
Expect(1, 13, '\P{^Grapheme_Cluster_Break= CR}', "");
Expect(0, 14, '\p{Grapheme_Cluster_Break= CR}', "");
Expect(1, 14, '\p{^Grapheme_Cluster_Break= CR}', "");
Expect(1, 14, '\P{Grapheme_Cluster_Break= CR}', "");
Expect(0, 14, '\P{^Grapheme_Cluster_Break= CR}', "");
Error('\p{GCB=:=	 CR}');
Error('\P{GCB=:=	 CR}');
Expect(1, 13, '\p{GCB=cr}', "");
Expect(0, 13, '\p{^GCB=cr}', "");
Expect(0, 13, '\P{GCB=cr}', "");
Expect(1, 13, '\P{^GCB=cr}', "");
Expect(0, 14, '\p{GCB=cr}', "");
Expect(1, 14, '\p{^GCB=cr}', "");
Expect(1, 14, '\P{GCB=cr}', "");
Expect(0, 14, '\P{^GCB=cr}', "");
Expect(1, 13, '\p{GCB= 	CR}', "");
Expect(0, 13, '\p{^GCB= 	CR}', "");
Expect(0, 13, '\P{GCB= 	CR}', "");
Expect(1, 13, '\P{^GCB= 	CR}', "");
Expect(0, 14, '\p{GCB= 	CR}', "");
Expect(1, 14, '\p{^GCB= 	CR}', "");
Expect(1, 14, '\P{GCB= 	CR}', "");
Expect(0, 14, '\P{^GCB= 	CR}', "");
Error('\p{Is_Grapheme_Cluster_Break=	-cr/a/}');
Error('\P{Is_Grapheme_Cluster_Break=	-cr/a/}');
Expect(1, 13, '\p{Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\p{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\P{Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\P{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 14, '\p{Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 14, '\p{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 14, '\P{Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 14, '\P{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\p{Is_Grapheme_Cluster_Break=-CR}', "");
Expect(0, 13, '\p{^Is_Grapheme_Cluster_Break=-CR}', "");
Expect(0, 13, '\P{Is_Grapheme_Cluster_Break=-CR}', "");
Expect(1, 13, '\P{^Is_Grapheme_Cluster_Break=-CR}', "");
Expect(0, 14, '\p{Is_Grapheme_Cluster_Break=-CR}', "");
Expect(1, 14, '\p{^Is_Grapheme_Cluster_Break=-CR}', "");
Expect(1, 14, '\P{Is_Grapheme_Cluster_Break=-CR}', "");
Expect(0, 14, '\P{^Is_Grapheme_Cluster_Break=-CR}', "");
Error('\p{Is_GCB= -cr/a/}');
Error('\P{Is_GCB= -cr/a/}');
Expect(1, 13, '\p{Is_GCB=cr}', "");
Expect(0, 13, '\p{^Is_GCB=cr}', "");
Expect(0, 13, '\P{Is_GCB=cr}', "");
Expect(1, 13, '\P{^Is_GCB=cr}', "");
Expect(0, 14, '\p{Is_GCB=cr}', "");
Expect(1, 14, '\p{^Is_GCB=cr}', "");
Expect(1, 14, '\P{Is_GCB=cr}', "");
Expect(0, 14, '\P{^Is_GCB=cr}', "");
Expect(1, 13, '\p{Is_GCB= 	cr}', "");
Expect(0, 13, '\p{^Is_GCB= 	cr}', "");
Expect(0, 13, '\P{Is_GCB= 	cr}', "");
Expect(1, 13, '\P{^Is_GCB= 	cr}', "");
Expect(0, 14, '\p{Is_GCB= 	cr}', "");
Expect(1, 14, '\p{^Is_GCB= 	cr}', "");
Expect(1, 14, '\P{Is_GCB= 	cr}', "");
Expect(0, 14, '\P{^Is_GCB= 	cr}', "");
Error('\p{Grapheme_Cluster_Break=_extend:=}');
Error('\P{Grapheme_Cluster_Break=_extend:=}');
Expect(1, 917999, '\p{Grapheme_Cluster_Break:	extend}', "");
Expect(0, 917999, '\p{^Grapheme_Cluster_Break:	extend}', "");
Expect(0, 917999, '\P{Grapheme_Cluster_Break:	extend}', "");
Expect(1, 917999, '\P{^Grapheme_Cluster_Break:	extend}', "");
Expect(0, 918000, '\p{Grapheme_Cluster_Break:	extend}', "");
Expect(1, 918000, '\p{^Grapheme_Cluster_Break:	extend}', "");
Expect(1, 918000, '\P{Grapheme_Cluster_Break:	extend}', "");
Expect(0, 918000, '\P{^Grapheme_Cluster_Break:	extend}', "");
Expect(1, 917999, '\p{Grapheme_Cluster_Break=  EXTEND}', "");
Expect(0, 917999, '\p{^Grapheme_Cluster_Break=  EXTEND}', "");
Expect(0, 917999, '\P{Grapheme_Cluster_Break=  EXTEND}', "");
Expect(1, 917999, '\P{^Grapheme_Cluster_Break=  EXTEND}', "");
Expect(0, 918000, '\p{Grapheme_Cluster_Break=  EXTEND}', "");
Expect(1, 918000, '\p{^Grapheme_Cluster_Break=  EXTEND}', "");
Expect(1, 918000, '\P{Grapheme_Cluster_Break=  EXTEND}', "");
Expect(0, 918000, '\P{^Grapheme_Cluster_Break=  EXTEND}', "");
Error('\p{GCB=:= EX}');
Error('\P{GCB=:= EX}');
Expect(1, 917999, '\p{GCB=ex}', "");
Expect(0, 917999, '\p{^GCB=ex}', "");
Expect(0, 917999, '\P{GCB=ex}', "");
Expect(1, 917999, '\P{^GCB=ex}', "");
Expect(0, 918000, '\p{GCB=ex}', "");
Expect(1, 918000, '\p{^GCB=ex}', "");
Expect(1, 918000, '\P{GCB=ex}', "");
Expect(0, 918000, '\P{^GCB=ex}', "");
Expect(1, 917999, '\p{GCB:	 EX}', "");
Expect(0, 917999, '\p{^GCB:	 EX}', "");
Expect(0, 917999, '\P{GCB:	 EX}', "");
Expect(1, 917999, '\P{^GCB:	 EX}', "");
Expect(0, 918000, '\p{GCB:	 EX}', "");
Expect(1, 918000, '\p{^GCB:	 EX}', "");
Expect(1, 918000, '\P{GCB:	 EX}', "");
Expect(0, 918000, '\P{^GCB:	 EX}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=	_extend}');
Error('\P{Is_Grapheme_Cluster_Break=:=	_extend}');
Expect(1, 917999, '\p{Is_Grapheme_Cluster_Break:	extend}', "");
Expect(0, 917999, '\p{^Is_Grapheme_Cluster_Break:	extend}', "");
Expect(0, 917999, '\P{Is_Grapheme_Cluster_Break:	extend}', "");
Expect(1, 917999, '\P{^Is_Grapheme_Cluster_Break:	extend}', "");
Expect(0, 918000, '\p{Is_Grapheme_Cluster_Break:	extend}', "");
Expect(1, 918000, '\p{^Is_Grapheme_Cluster_Break:	extend}', "");
Expect(1, 918000, '\P{Is_Grapheme_Cluster_Break:	extend}', "");
Expect(0, 918000, '\P{^Is_Grapheme_Cluster_Break:	extend}', "");
Expect(1, 917999, '\p{Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(0, 917999, '\p{^Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(0, 917999, '\P{Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(1, 917999, '\P{^Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(0, 918000, '\p{Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(1, 918000, '\p{^Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(1, 918000, '\P{Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(0, 918000, '\P{^Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Error('\p{Is_GCB=:= 	EX}');
Error('\P{Is_GCB=:= 	EX}');
Expect(1, 917999, '\p{Is_GCB=ex}', "");
Expect(0, 917999, '\p{^Is_GCB=ex}', "");
Expect(0, 917999, '\P{Is_GCB=ex}', "");
Expect(1, 917999, '\P{^Is_GCB=ex}', "");
Expect(0, 918000, '\p{Is_GCB=ex}', "");
Expect(1, 918000, '\p{^Is_GCB=ex}', "");
Expect(1, 918000, '\P{Is_GCB=ex}', "");
Expect(0, 918000, '\P{^Is_GCB=ex}', "");
Expect(1, 917999, '\p{Is_GCB=- EX}', "");
Expect(0, 917999, '\p{^Is_GCB=- EX}', "");
Expect(0, 917999, '\P{Is_GCB=- EX}', "");
Expect(1, 917999, '\P{^Is_GCB=- EX}', "");
Expect(0, 918000, '\p{Is_GCB=- EX}', "");
Expect(1, 918000, '\p{^Is_GCB=- EX}', "");
Expect(1, 918000, '\P{Is_GCB=- EX}', "");
Expect(0, 918000, '\P{^Is_GCB=- EX}', "");
Error('\p{Grapheme_Cluster_Break=	l/a/}');
Error('\P{Grapheme_Cluster_Break=	l/a/}');
Expect(1, 43388, '\p{Grapheme_Cluster_Break=l}', "");
Expect(0, 43388, '\p{^Grapheme_Cluster_Break=l}', "");
Expect(0, 43388, '\P{Grapheme_Cluster_Break=l}', "");
Expect(1, 43388, '\P{^Grapheme_Cluster_Break=l}', "");
Expect(0, 43389, '\p{Grapheme_Cluster_Break=l}', "");
Expect(1, 43389, '\p{^Grapheme_Cluster_Break=l}', "");
Expect(1, 43389, '\P{Grapheme_Cluster_Break=l}', "");
Expect(0, 43389, '\P{^Grapheme_Cluster_Break=l}', "");
Expect(1, 43388, '\p{Grapheme_Cluster_Break=__L}', "");
Expect(0, 43388, '\p{^Grapheme_Cluster_Break=__L}', "");
Expect(0, 43388, '\P{Grapheme_Cluster_Break=__L}', "");
Expect(1, 43388, '\P{^Grapheme_Cluster_Break=__L}', "");
Expect(0, 43389, '\p{Grapheme_Cluster_Break=__L}', "");
Expect(1, 43389, '\p{^Grapheme_Cluster_Break=__L}', "");
Expect(1, 43389, '\P{Grapheme_Cluster_Break=__L}', "");
Expect(0, 43389, '\P{^Grapheme_Cluster_Break=__L}', "");
Error('\p{GCB=  L:=}');
Error('\P{GCB=  L:=}');
Expect(1, 43388, '\p{GCB=l}', "");
Expect(0, 43388, '\p{^GCB=l}', "");
Expect(0, 43388, '\P{GCB=l}', "");
Expect(1, 43388, '\P{^GCB=l}', "");
Expect(0, 43389, '\p{GCB=l}', "");
Expect(1, 43389, '\p{^GCB=l}', "");
Expect(1, 43389, '\P{GCB=l}', "");
Expect(0, 43389, '\P{^GCB=l}', "");
Expect(1, 43388, '\p{GCB= -L}', "");
Expect(0, 43388, '\p{^GCB= -L}', "");
Expect(0, 43388, '\P{GCB= -L}', "");
Expect(1, 43388, '\P{^GCB= -L}', "");
Expect(0, 43389, '\p{GCB= -L}', "");
Expect(1, 43389, '\p{^GCB= -L}', "");
Expect(1, 43389, '\P{GCB= -L}', "");
Expect(0, 43389, '\P{^GCB= -L}', "");
Error('\p{Is_Grapheme_Cluster_Break:	  l:=}');
Error('\P{Is_Grapheme_Cluster_Break:	  l:=}');
Expect(1, 43388, '\p{Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 43388, '\p{^Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 43388, '\P{Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 43388, '\P{^Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 43389, '\p{Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 43389, '\p{^Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 43389, '\P{Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 43389, '\P{^Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 43388, '\p{Is_Grapheme_Cluster_Break=L}', "");
Expect(0, 43388, '\p{^Is_Grapheme_Cluster_Break=L}', "");
Expect(0, 43388, '\P{Is_Grapheme_Cluster_Break=L}', "");
Expect(1, 43388, '\P{^Is_Grapheme_Cluster_Break=L}', "");
Expect(0, 43389, '\p{Is_Grapheme_Cluster_Break=L}', "");
Expect(1, 43389, '\p{^Is_Grapheme_Cluster_Break=L}', "");
Expect(1, 43389, '\P{Is_Grapheme_Cluster_Break=L}', "");
Expect(0, 43389, '\P{^Is_Grapheme_Cluster_Break=L}', "");
Error('\p{Is_GCB=	_L:=}');
Error('\P{Is_GCB=	_L:=}');
Expect(1, 43388, '\p{Is_GCB=l}', "");
Expect(0, 43388, '\p{^Is_GCB=l}', "");
Expect(0, 43388, '\P{Is_GCB=l}', "");
Expect(1, 43388, '\P{^Is_GCB=l}', "");
Expect(0, 43389, '\p{Is_GCB=l}', "");
Expect(1, 43389, '\p{^Is_GCB=l}', "");
Expect(1, 43389, '\P{Is_GCB=l}', "");
Expect(0, 43389, '\P{^Is_GCB=l}', "");
Expect(1, 43388, '\p{Is_GCB=-_L}', "");
Expect(0, 43388, '\p{^Is_GCB=-_L}', "");
Expect(0, 43388, '\P{Is_GCB=-_L}', "");
Expect(1, 43388, '\P{^Is_GCB=-_L}', "");
Expect(0, 43389, '\p{Is_GCB=-_L}', "");
Expect(1, 43389, '\p{^Is_GCB=-_L}', "");
Expect(1, 43389, '\P{Is_GCB=-_L}', "");
Expect(0, 43389, '\P{^Is_GCB=-_L}', "");
Error('\p{Grapheme_Cluster_Break:  LF:=}');
Error('\P{Grapheme_Cluster_Break:  LF:=}');
Expect(1, 10, '\p{Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\p{^Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\P{Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\P{^Grapheme_Cluster_Break=lf}', "");
Expect(0, 11, '\p{Grapheme_Cluster_Break=lf}', "");
Expect(1, 11, '\p{^Grapheme_Cluster_Break=lf}', "");
Expect(1, 11, '\P{Grapheme_Cluster_Break=lf}', "");
Expect(0, 11, '\P{^Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\p{Grapheme_Cluster_Break=__LF}', "");
Expect(0, 10, '\p{^Grapheme_Cluster_Break=__LF}', "");
Expect(0, 10, '\P{Grapheme_Cluster_Break=__LF}', "");
Expect(1, 10, '\P{^Grapheme_Cluster_Break=__LF}', "");
Expect(0, 11, '\p{Grapheme_Cluster_Break=__LF}', "");
Expect(1, 11, '\p{^Grapheme_Cluster_Break=__LF}', "");
Expect(1, 11, '\P{Grapheme_Cluster_Break=__LF}', "");
Expect(0, 11, '\P{^Grapheme_Cluster_Break=__LF}', "");
Error('\p{GCB= :=lf}');
Error('\P{GCB= :=lf}');
Expect(1, 10, '\p{GCB:   lf}', "");
Expect(0, 10, '\p{^GCB:   lf}', "");
Expect(0, 10, '\P{GCB:   lf}', "");
Expect(1, 10, '\P{^GCB:   lf}', "");
Expect(0, 11, '\p{GCB:   lf}', "");
Expect(1, 11, '\p{^GCB:   lf}', "");
Expect(1, 11, '\P{GCB:   lf}', "");
Expect(0, 11, '\P{^GCB:   lf}', "");
Expect(1, 10, '\p{GCB=	_LF}', "");
Expect(0, 10, '\p{^GCB=	_LF}', "");
Expect(0, 10, '\P{GCB=	_LF}', "");
Expect(1, 10, '\P{^GCB=	_LF}', "");
Expect(0, 11, '\p{GCB=	_LF}', "");
Expect(1, 11, '\p{^GCB=	_LF}', "");
Expect(1, 11, '\P{GCB=	_LF}', "");
Expect(0, 11, '\P{^GCB=	_LF}', "");
Error('\p{Is_Grapheme_Cluster_Break=	-LF/a/}');
Error('\P{Is_Grapheme_Cluster_Break=	-LF/a/}');
Expect(1, 10, '\p{Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\p{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\P{Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\P{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 11, '\p{Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 11, '\p{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 11, '\P{Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 11, '\P{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\p{Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(0, 10, '\p{^Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(0, 10, '\P{Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(1, 10, '\P{^Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(0, 11, '\p{Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(1, 11, '\p{^Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(1, 11, '\P{Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(0, 11, '\P{^Is_Grapheme_Cluster_Break=	_LF}', "");
Error('\p{Is_GCB::=	lf}');
Error('\P{Is_GCB::=	lf}');
Expect(1, 10, '\p{Is_GCB: lf}', "");
Expect(0, 10, '\p{^Is_GCB: lf}', "");
Expect(0, 10, '\P{Is_GCB: lf}', "");
Expect(1, 10, '\P{^Is_GCB: lf}', "");
Expect(0, 11, '\p{Is_GCB: lf}', "");
Expect(1, 11, '\p{^Is_GCB: lf}', "");
Expect(1, 11, '\P{Is_GCB: lf}', "");
Expect(0, 11, '\P{^Is_GCB: lf}', "");
Expect(1, 10, '\p{Is_GCB= LF}', "");
Expect(0, 10, '\p{^Is_GCB= LF}', "");
Expect(0, 10, '\P{Is_GCB= LF}', "");
Expect(1, 10, '\P{^Is_GCB= LF}', "");
Expect(0, 11, '\p{Is_GCB= LF}', "");
Expect(1, 11, '\p{^Is_GCB= LF}', "");
Expect(1, 11, '\P{Is_GCB= LF}', "");
Expect(0, 11, '\P{^Is_GCB= LF}', "");
Error('\p{Grapheme_Cluster_Break=  lv/a/}');
Error('\P{Grapheme_Cluster_Break=  lv/a/}');
Expect(1, 55176, '\p{Grapheme_Cluster_Break=lv}', "");
Expect(0, 55176, '\p{^Grapheme_Cluster_Break=lv}', "");
Expect(0, 55176, '\P{Grapheme_Cluster_Break=lv}', "");
Expect(1, 55176, '\P{^Grapheme_Cluster_Break=lv}', "");
Expect(0, 55177, '\p{Grapheme_Cluster_Break=lv}', "");
Expect(1, 55177, '\p{^Grapheme_Cluster_Break=lv}', "");
Expect(1, 55177, '\P{Grapheme_Cluster_Break=lv}', "");
Expect(0, 55177, '\P{^Grapheme_Cluster_Break=lv}', "");
Expect(1, 55176, '\p{Grapheme_Cluster_Break:	-LV}', "");
Expect(0, 55176, '\p{^Grapheme_Cluster_Break:	-LV}', "");
Expect(0, 55176, '\P{Grapheme_Cluster_Break:	-LV}', "");
Expect(1, 55176, '\P{^Grapheme_Cluster_Break:	-LV}', "");
Expect(0, 55177, '\p{Grapheme_Cluster_Break:	-LV}', "");
Expect(1, 55177, '\p{^Grapheme_Cluster_Break:	-LV}', "");
Expect(1, 55177, '\P{Grapheme_Cluster_Break:	-LV}', "");
Expect(0, 55177, '\P{^Grapheme_Cluster_Break:	-LV}', "");
Error('\p{GCB=	LV:=}');
Error('\P{GCB=	LV:=}');
Expect(1, 55176, '\p{GCB: lv}', "");
Expect(0, 55176, '\p{^GCB: lv}', "");
Expect(0, 55176, '\P{GCB: lv}', "");
Expect(1, 55176, '\P{^GCB: lv}', "");
Expect(0, 55177, '\p{GCB: lv}', "");
Expect(1, 55177, '\p{^GCB: lv}', "");
Expect(1, 55177, '\P{GCB: lv}', "");
Expect(0, 55177, '\P{^GCB: lv}', "");
Expect(1, 55176, '\p{GCB=_ lv}', "");
Expect(0, 55176, '\p{^GCB=_ lv}', "");
Expect(0, 55176, '\P{GCB=_ lv}', "");
Expect(1, 55176, '\P{^GCB=_ lv}', "");
Expect(0, 55177, '\p{GCB=_ lv}', "");
Expect(1, 55177, '\p{^GCB=_ lv}', "");
Expect(1, 55177, '\P{GCB=_ lv}', "");
Expect(0, 55177, '\P{^GCB=_ lv}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=- LV}');
Error('\P{Is_Grapheme_Cluster_Break=:=- LV}');
Expect(1, 55176, '\p{Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 55176, '\p{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 55176, '\P{Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 55176, '\P{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 55177, '\p{Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 55177, '\p{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 55177, '\P{Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 55177, '\P{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 55176, '\p{Is_Grapheme_Cluster_Break=-LV}', "");
Expect(0, 55176, '\p{^Is_Grapheme_Cluster_Break=-LV}', "");
Expect(0, 55176, '\P{Is_Grapheme_Cluster_Break=-LV}', "");
Expect(1, 55176, '\P{^Is_Grapheme_Cluster_Break=-LV}', "");
Expect(0, 55177, '\p{Is_Grapheme_Cluster_Break=-LV}', "");
Expect(1, 55177, '\p{^Is_Grapheme_Cluster_Break=-LV}', "");
Expect(1, 55177, '\P{Is_Grapheme_Cluster_Break=-LV}', "");
Expect(0, 55177, '\P{^Is_Grapheme_Cluster_Break=-LV}', "");
Error('\p{Is_GCB=_	LV:=}');
Error('\P{Is_GCB=_	LV:=}');
Expect(1, 55176, '\p{Is_GCB=lv}', "");
Expect(0, 55176, '\p{^Is_GCB=lv}', "");
Expect(0, 55176, '\P{Is_GCB=lv}', "");
Expect(1, 55176, '\P{^Is_GCB=lv}', "");
Expect(0, 55177, '\p{Is_GCB=lv}', "");
Expect(1, 55177, '\p{^Is_GCB=lv}', "");
Expect(1, 55177, '\P{Is_GCB=lv}', "");
Expect(0, 55177, '\P{^Is_GCB=lv}', "");
Expect(1, 55176, '\p{Is_GCB=	_lv}', "");
Expect(0, 55176, '\p{^Is_GCB=	_lv}', "");
Expect(0, 55176, '\P{Is_GCB=	_lv}', "");
Expect(1, 55176, '\P{^Is_GCB=	_lv}', "");
Expect(0, 55177, '\p{Is_GCB=	_lv}', "");
Expect(1, 55177, '\p{^Is_GCB=	_lv}', "");
Expect(1, 55177, '\P{Is_GCB=	_lv}', "");
Expect(0, 55177, '\P{^Is_GCB=	_lv}', "");
Error('\p{Grapheme_Cluster_Break=__lvt/a/}');
Error('\P{Grapheme_Cluster_Break=__lvt/a/}');
Expect(1, 55203, '\p{Grapheme_Cluster_Break=lvt}', "");
Expect(0, 55203, '\p{^Grapheme_Cluster_Break=lvt}', "");
Expect(0, 55203, '\P{Grapheme_Cluster_Break=lvt}', "");
Expect(1, 55203, '\P{^Grapheme_Cluster_Break=lvt}', "");
Expect(0, 55204, '\p{Grapheme_Cluster_Break=lvt}', "");
Expect(1, 55204, '\p{^Grapheme_Cluster_Break=lvt}', "");
Expect(1, 55204, '\P{Grapheme_Cluster_Break=lvt}', "");
Expect(0, 55204, '\P{^Grapheme_Cluster_Break=lvt}', "");
Expect(1, 55203, '\p{Grapheme_Cluster_Break=	 lvt}', "");
Expect(0, 55203, '\p{^Grapheme_Cluster_Break=	 lvt}', "");
Expect(0, 55203, '\P{Grapheme_Cluster_Break=	 lvt}', "");
Expect(1, 55203, '\P{^Grapheme_Cluster_Break=	 lvt}', "");
Expect(0, 55204, '\p{Grapheme_Cluster_Break=	 lvt}', "");
Expect(1, 55204, '\p{^Grapheme_Cluster_Break=	 lvt}', "");
Expect(1, 55204, '\P{Grapheme_Cluster_Break=	 lvt}', "");
Expect(0, 55204, '\P{^Grapheme_Cluster_Break=	 lvt}', "");
Error('\p{GCB= LVT/a/}');
Error('\P{GCB= LVT/a/}');
Expect(1, 55203, '\p{GCB=lvt}', "");
Expect(0, 55203, '\p{^GCB=lvt}', "");
Expect(0, 55203, '\P{GCB=lvt}', "");
Expect(1, 55203, '\P{^GCB=lvt}', "");
Expect(0, 55204, '\p{GCB=lvt}', "");
Expect(1, 55204, '\p{^GCB=lvt}', "");
Expect(1, 55204, '\P{GCB=lvt}', "");
Expect(0, 55204, '\P{^GCB=lvt}', "");
Expect(1, 55203, '\p{GCB=_ LVT}', "");
Expect(0, 55203, '\p{^GCB=_ LVT}', "");
Expect(0, 55203, '\P{GCB=_ LVT}', "");
Expect(1, 55203, '\P{^GCB=_ LVT}', "");
Expect(0, 55204, '\p{GCB=_ LVT}', "");
Expect(1, 55204, '\p{^GCB=_ LVT}', "");
Expect(1, 55204, '\P{GCB=_ LVT}', "");
Expect(0, 55204, '\P{^GCB=_ LVT}', "");
Error('\p{Is_Grapheme_Cluster_Break=--LVT/a/}');
Error('\P{Is_Grapheme_Cluster_Break=--LVT/a/}');
Expect(1, 55203, '\p{Is_Grapheme_Cluster_Break: lvt}', "");
Expect(0, 55203, '\p{^Is_Grapheme_Cluster_Break: lvt}', "");
Expect(0, 55203, '\P{Is_Grapheme_Cluster_Break: lvt}', "");
Expect(1, 55203, '\P{^Is_Grapheme_Cluster_Break: lvt}', "");
Expect(0, 55204, '\p{Is_Grapheme_Cluster_Break: lvt}', "");
Expect(1, 55204, '\p{^Is_Grapheme_Cluster_Break: lvt}', "");
Expect(1, 55204, '\P{Is_Grapheme_Cluster_Break: lvt}', "");
Expect(0, 55204, '\P{^Is_Grapheme_Cluster_Break: lvt}', "");
Expect(1, 55203, '\p{Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(0, 55203, '\p{^Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(0, 55203, '\P{Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(1, 55203, '\P{^Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(0, 55204, '\p{Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(1, 55204, '\p{^Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(1, 55204, '\P{Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(0, 55204, '\P{^Is_Grapheme_Cluster_Break:   - LVT}', "");
Error('\p{Is_GCB=-:=LVT}');
Error('\P{Is_GCB=-:=LVT}');
Expect(1, 55203, '\p{Is_GCB=lvt}', "");
Expect(0, 55203, '\p{^Is_GCB=lvt}', "");
Expect(0, 55203, '\P{Is_GCB=lvt}', "");
Expect(1, 55203, '\P{^Is_GCB=lvt}', "");
Expect(0, 55204, '\p{Is_GCB=lvt}', "");
Expect(1, 55204, '\p{^Is_GCB=lvt}', "");
Expect(1, 55204, '\P{Is_GCB=lvt}', "");
Expect(0, 55204, '\P{^Is_GCB=lvt}', "");
Expect(1, 55203, '\p{Is_GCB=-_lvt}', "");
Expect(0, 55203, '\p{^Is_GCB=-_lvt}', "");
Expect(0, 55203, '\P{Is_GCB=-_lvt}', "");
Expect(1, 55203, '\P{^Is_GCB=-_lvt}', "");
Expect(0, 55204, '\p{Is_GCB=-_lvt}', "");
Expect(1, 55204, '\p{^Is_GCB=-_lvt}', "");
Expect(1, 55204, '\P{Is_GCB=-_lvt}', "");
Expect(0, 55204, '\P{^Is_GCB=-_lvt}', "");
Error('\p{Grapheme_Cluster_Break=:=_ Prepend}');
Error('\P{Grapheme_Cluster_Break=:=_ Prepend}');
Expect(0, 1, '\p{Grapheme_Cluster_Break=prepend}', "");
Expect(1, 1, '\p{^Grapheme_Cluster_Break=prepend}', "");
Expect(1, 1, '\P{Grapheme_Cluster_Break=prepend}', "");
Expect(0, 1, '\P{^Grapheme_Cluster_Break=prepend}', "");
Expect(0, 1, '\p{Grapheme_Cluster_Break= 	PREPEND}', "");
Expect(1, 1, '\p{^Grapheme_Cluster_Break= 	PREPEND}', "");
Expect(1, 1, '\P{Grapheme_Cluster_Break= 	PREPEND}', "");
Expect(0, 1, '\P{^Grapheme_Cluster_Break= 	PREPEND}', "");
Error('\p{GCB:- PP/a/}');
Error('\P{GCB:- PP/a/}');
Expect(0, 1, '\p{GCB=pp}', "");
Expect(1, 1, '\p{^GCB=pp}', "");
Expect(1, 1, '\P{GCB=pp}', "");
Expect(0, 1, '\P{^GCB=pp}', "");
Expect(0, 1, '\p{GCB=_PP}', "");
Expect(1, 1, '\p{^GCB=_PP}', "");
Expect(1, 1, '\P{GCB=_PP}', "");
Expect(0, 1, '\P{^GCB=_PP}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=-_prepend}');
Error('\P{Is_Grapheme_Cluster_Break=:=-_prepend}');
Expect(0, 1, '\p{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 1, '\p{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 1, '\P{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 1, '\P{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 1, '\p{Is_Grapheme_Cluster_Break=-_Prepend}', "");
Expect(1, 1, '\p{^Is_Grapheme_Cluster_Break=-_Prepend}', "");
Expect(1, 1, '\P{Is_Grapheme_Cluster_Break=-_Prepend}', "");
Expect(0, 1, '\P{^Is_Grapheme_Cluster_Break=-_Prepend}', "");
Error('\p{Is_GCB=/a/__PP}');
Error('\P{Is_GCB=/a/__PP}');
Expect(0, 1, '\p{Is_GCB=pp}', "");
Expect(1, 1, '\p{^Is_GCB=pp}', "");
Expect(1, 1, '\P{Is_GCB=pp}', "");
Expect(0, 1, '\P{^Is_GCB=pp}', "");
Expect(0, 1, '\p{Is_GCB=_PP}', "");
Expect(1, 1, '\p{^Is_GCB=_PP}', "");
Expect(1, 1, '\P{Is_GCB=_PP}', "");
Expect(0, 1, '\P{^Is_GCB=_PP}', "");
Error('\p{Grapheme_Cluster_Break=:= regional_indicator}');
Error('\P{Grapheme_Cluster_Break=:= regional_indicator}');
Expect(1, 127487, '\p{Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127487, '\p{^Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127487, '\P{Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127487, '\P{^Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127488, '\p{Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127488, '\p{^Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127488, '\P{Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127488, '\P{^Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127487, '\p{Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(0, 127487, '\p{^Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(0, 127487, '\P{Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(1, 127487, '\P{^Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(0, 127488, '\p{Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(1, 127488, '\p{^Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(1, 127488, '\P{Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(0, 127488, '\P{^Grapheme_Cluster_Break= -Regional_Indicator}', "");
Error('\p{GCB=__RI/a/}');
Error('\P{GCB=__RI/a/}');
Expect(1, 127487, '\p{GCB=ri}', "");
Expect(0, 127487, '\p{^GCB=ri}', "");
Expect(0, 127487, '\P{GCB=ri}', "");
Expect(1, 127487, '\P{^GCB=ri}', "");
Expect(0, 127488, '\p{GCB=ri}', "");
Expect(1, 127488, '\p{^GCB=ri}', "");
Expect(1, 127488, '\P{GCB=ri}', "");
Expect(0, 127488, '\P{^GCB=ri}', "");
Expect(1, 127487, '\p{GCB:    ri}', "");
Expect(0, 127487, '\p{^GCB:    ri}', "");
Expect(0, 127487, '\P{GCB:    ri}', "");
Expect(1, 127487, '\P{^GCB:    ri}', "");
Expect(0, 127488, '\p{GCB:    ri}', "");
Expect(1, 127488, '\p{^GCB:    ri}', "");
Expect(1, 127488, '\P{GCB:    ri}', "");
Expect(0, 127488, '\P{^GCB:    ri}', "");
Error('\p{Is_Grapheme_Cluster_Break= 	regional_indicator/a/}');
Error('\P{Is_Grapheme_Cluster_Break= 	regional_indicator/a/}');
Expect(1, 127487, '\p{Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127487, '\p{^Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127487, '\P{Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127487, '\P{^Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127488, '\p{Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127488, '\p{^Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127488, '\P{Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127488, '\P{^Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127487, '\p{Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(0, 127487, '\p{^Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(0, 127487, '\P{Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(1, 127487, '\P{^Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(0, 127488, '\p{Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(1, 127488, '\p{^Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(1, 127488, '\P{Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(0, 127488, '\P{^Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Error('\p{Is_GCB=-:=RI}');
Error('\P{Is_GCB=-:=RI}');
Expect(1, 127487, '\p{Is_GCB=ri}', "");
Expect(0, 127487, '\p{^Is_GCB=ri}', "");
Expect(0, 127487, '\P{Is_GCB=ri}', "");
Expect(1, 127487, '\P{^Is_GCB=ri}', "");
Expect(0, 127488, '\p{Is_GCB=ri}', "");
Expect(1, 127488, '\p{^Is_GCB=ri}', "");
Expect(1, 127488, '\P{Is_GCB=ri}', "");
Expect(0, 127488, '\P{^Is_GCB=ri}', "");
Expect(1, 127487, '\p{Is_GCB= RI}', "");
Expect(0, 127487, '\p{^Is_GCB= RI}', "");
Expect(0, 127487, '\P{Is_GCB= RI}', "");
Expect(1, 127487, '\P{^Is_GCB= RI}', "");
Expect(0, 127488, '\p{Is_GCB= RI}', "");
Expect(1, 127488, '\p{^Is_GCB= RI}', "");
Expect(1, 127488, '\P{Is_GCB= RI}', "");
Expect(0, 127488, '\P{^Is_GCB= RI}', "");
Error('\p{Grapheme_Cluster_Break=:=--SPACINGMARK}');
Error('\P{Grapheme_Cluster_Break=:=--SPACINGMARK}');
Expect(1, 119149, '\p{Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119149, '\p{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119149, '\P{Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119149, '\P{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119150, '\p{Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119150, '\p{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119150, '\P{Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119150, '\P{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119149, '\p{Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(0, 119149, '\p{^Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(0, 119149, '\P{Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(1, 119149, '\P{^Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(0, 119150, '\p{Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(1, 119150, '\p{^Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(1, 119150, '\P{Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(0, 119150, '\P{^Grapheme_Cluster_Break= SPACINGMARK}', "");
Error('\p{GCB= SM:=}');
Error('\P{GCB= SM:=}');
Expect(1, 119149, '\p{GCB:sm}', "");
Expect(0, 119149, '\p{^GCB:sm}', "");
Expect(0, 119149, '\P{GCB:sm}', "");
Expect(1, 119149, '\P{^GCB:sm}', "");
Expect(0, 119150, '\p{GCB:sm}', "");
Expect(1, 119150, '\p{^GCB:sm}', "");
Expect(1, 119150, '\P{GCB:sm}', "");
Expect(0, 119150, '\P{^GCB:sm}', "");
Expect(1, 119149, '\p{GCB=-_sm}', "");
Expect(0, 119149, '\p{^GCB=-_sm}', "");
Expect(0, 119149, '\P{GCB=-_sm}', "");
Expect(1, 119149, '\P{^GCB=-_sm}', "");
Expect(0, 119150, '\p{GCB=-_sm}', "");
Expect(1, 119150, '\p{^GCB=-_sm}', "");
Expect(1, 119150, '\P{GCB=-_sm}', "");
Expect(0, 119150, '\P{^GCB=-_sm}', "");
Error('\p{Is_Grapheme_Cluster_Break= -SpacingMark/a/}');
Error('\P{Is_Grapheme_Cluster_Break= -SpacingMark/a/}');
Expect(1, 119149, '\p{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119149, '\p{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119149, '\P{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119149, '\P{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119150, '\p{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119150, '\p{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119150, '\P{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119150, '\P{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119149, '\p{Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(0, 119149, '\p{^Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(0, 119149, '\P{Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(1, 119149, '\P{^Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(0, 119150, '\p{Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(1, 119150, '\p{^Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(1, 119150, '\P{Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(0, 119150, '\P{^Is_Grapheme_Cluster_Break=__spacingmark}', "");
Error('\p{Is_GCB=  SM/a/}');
Error('\P{Is_GCB=  SM/a/}');
Expect(1, 119149, '\p{Is_GCB=sm}', "");
Expect(0, 119149, '\p{^Is_GCB=sm}', "");
Expect(0, 119149, '\P{Is_GCB=sm}', "");
Expect(1, 119149, '\P{^Is_GCB=sm}', "");
Expect(0, 119150, '\p{Is_GCB=sm}', "");
Expect(1, 119150, '\p{^Is_GCB=sm}', "");
Expect(1, 119150, '\P{Is_GCB=sm}', "");
Expect(0, 119150, '\P{^Is_GCB=sm}', "");
Expect(1, 119149, '\p{Is_GCB= -SM}', "");
Expect(0, 119149, '\p{^Is_GCB= -SM}', "");
Expect(0, 119149, '\P{Is_GCB= -SM}', "");
Expect(1, 119149, '\P{^Is_GCB= -SM}', "");
Expect(0, 119150, '\p{Is_GCB= -SM}', "");
Expect(1, 119150, '\p{^Is_GCB= -SM}', "");
Expect(1, 119150, '\P{Is_GCB= -SM}', "");
Expect(0, 119150, '\P{^Is_GCB= -SM}', "");
Error('\p{Grapheme_Cluster_Break=/a/_-t}');
Error('\P{Grapheme_Cluster_Break=/a/_-t}');
Expect(1, 55291, '\p{Grapheme_Cluster_Break=t}', "");
Expect(0, 55291, '\p{^Grapheme_Cluster_Break=t}', "");
Expect(0, 55291, '\P{Grapheme_Cluster_Break=t}', "");
Expect(1, 55291, '\P{^Grapheme_Cluster_Break=t}', "");
Expect(0, 55292, '\p{Grapheme_Cluster_Break=t}', "");
Expect(1, 55292, '\p{^Grapheme_Cluster_Break=t}', "");
Expect(1, 55292, '\P{Grapheme_Cluster_Break=t}', "");
Expect(0, 55292, '\P{^Grapheme_Cluster_Break=t}', "");
Expect(1, 55291, '\p{Grapheme_Cluster_Break= T}', "");
Expect(0, 55291, '\p{^Grapheme_Cluster_Break= T}', "");
Expect(0, 55291, '\P{Grapheme_Cluster_Break= T}', "");
Expect(1, 55291, '\P{^Grapheme_Cluster_Break= T}', "");
Expect(0, 55292, '\p{Grapheme_Cluster_Break= T}', "");
Expect(1, 55292, '\p{^Grapheme_Cluster_Break= T}', "");
Expect(1, 55292, '\P{Grapheme_Cluster_Break= T}', "");
Expect(0, 55292, '\P{^Grapheme_Cluster_Break= T}', "");
Error('\p{GCB=:=-T}');
Error('\P{GCB=:=-T}');
Expect(1, 55291, '\p{GCB:   t}', "");
Expect(0, 55291, '\p{^GCB:   t}', "");
Expect(0, 55291, '\P{GCB:   t}', "");
Expect(1, 55291, '\P{^GCB:   t}', "");
Expect(0, 55292, '\p{GCB:   t}', "");
Expect(1, 55292, '\p{^GCB:   t}', "");
Expect(1, 55292, '\P{GCB:   t}', "");
Expect(0, 55292, '\P{^GCB:   t}', "");
Expect(1, 55291, '\p{GCB=_-t}', "");
Expect(0, 55291, '\p{^GCB=_-t}', "");
Expect(0, 55291, '\P{GCB=_-t}', "");
Expect(1, 55291, '\P{^GCB=_-t}', "");
Expect(0, 55292, '\p{GCB=_-t}', "");
Expect(1, 55292, '\p{^GCB=_-t}', "");
Expect(1, 55292, '\P{GCB=_-t}', "");
Expect(0, 55292, '\P{^GCB=_-t}', "");
Error('\p{Is_Grapheme_Cluster_Break=-/a/T}');
Error('\P{Is_Grapheme_Cluster_Break=-/a/T}');
Expect(1, 55291, '\p{Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 55291, '\p{^Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 55291, '\P{Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 55291, '\P{^Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 55292, '\p{Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 55292, '\p{^Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 55292, '\P{Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 55292, '\P{^Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 55291, '\p{Is_Grapheme_Cluster_Break=_T}', "");
Expect(0, 55291, '\p{^Is_Grapheme_Cluster_Break=_T}', "");
Expect(0, 55291, '\P{Is_Grapheme_Cluster_Break=_T}', "");
Expect(1, 55291, '\P{^Is_Grapheme_Cluster_Break=_T}', "");
Expect(0, 55292, '\p{Is_Grapheme_Cluster_Break=_T}', "");
Expect(1, 55292, '\p{^Is_Grapheme_Cluster_Break=_T}', "");
Expect(1, 55292, '\P{Is_Grapheme_Cluster_Break=_T}', "");
Expect(0, 55292, '\P{^Is_Grapheme_Cluster_Break=_T}', "");
Error('\p{Is_GCB=	T/a/}');
Error('\P{Is_GCB=	T/a/}');
Expect(1, 55291, '\p{Is_GCB=t}', "");
Expect(0, 55291, '\p{^Is_GCB=t}', "");
Expect(0, 55291, '\P{Is_GCB=t}', "");
Expect(1, 55291, '\P{^Is_GCB=t}', "");
Expect(0, 55292, '\p{Is_GCB=t}', "");
Expect(1, 55292, '\p{^Is_GCB=t}', "");
Expect(1, 55292, '\P{Is_GCB=t}', "");
Expect(0, 55292, '\P{^Is_GCB=t}', "");
Expect(1, 55291, '\p{Is_GCB=	t}', "");
Expect(0, 55291, '\p{^Is_GCB=	t}', "");
Expect(0, 55291, '\P{Is_GCB=	t}', "");
Expect(1, 55291, '\P{^Is_GCB=	t}', "");
Expect(0, 55292, '\p{Is_GCB=	t}', "");
Expect(1, 55292, '\p{^Is_GCB=	t}', "");
Expect(1, 55292, '\P{Is_GCB=	t}', "");
Expect(0, 55292, '\P{^Is_GCB=	t}', "");
Error('\p{Grapheme_Cluster_Break=--V:=}');
Error('\P{Grapheme_Cluster_Break=--V:=}');
Expect(1, 55238, '\p{Grapheme_Cluster_Break:	v}', "");
Expect(0, 55238, '\p{^Grapheme_Cluster_Break:	v}', "");
Expect(0, 55238, '\P{Grapheme_Cluster_Break:	v}', "");
Expect(1, 55238, '\P{^Grapheme_Cluster_Break:	v}', "");
Expect(0, 55239, '\p{Grapheme_Cluster_Break:	v}', "");
Expect(1, 55239, '\p{^Grapheme_Cluster_Break:	v}', "");
Expect(1, 55239, '\P{Grapheme_Cluster_Break:	v}', "");
Expect(0, 55239, '\P{^Grapheme_Cluster_Break:	v}', "");
Expect(1, 55238, '\p{Grapheme_Cluster_Break=_ V}', "");
Expect(0, 55238, '\p{^Grapheme_Cluster_Break=_ V}', "");
Expect(0, 55238, '\P{Grapheme_Cluster_Break=_ V}', "");
Expect(1, 55238, '\P{^Grapheme_Cluster_Break=_ V}', "");
Expect(0, 55239, '\p{Grapheme_Cluster_Break=_ V}', "");
Expect(1, 55239, '\p{^Grapheme_Cluster_Break=_ V}', "");
Expect(1, 55239, '\P{Grapheme_Cluster_Break=_ V}', "");
Expect(0, 55239, '\P{^Grapheme_Cluster_Break=_ V}', "");
Error('\p{GCB=/a/-_V}');
Error('\P{GCB=/a/-_V}');
Expect(1, 55238, '\p{GCB=v}', "");
Expect(0, 55238, '\p{^GCB=v}', "");
Expect(0, 55238, '\P{GCB=v}', "");
Expect(1, 55238, '\P{^GCB=v}', "");
Expect(0, 55239, '\p{GCB=v}', "");
Expect(1, 55239, '\p{^GCB=v}', "");
Expect(1, 55239, '\P{GCB=v}', "");
Expect(0, 55239, '\P{^GCB=v}', "");
Expect(1, 55238, '\p{GCB=	 V}', "");
Expect(0, 55238, '\p{^GCB=	 V}', "");
Expect(0, 55238, '\P{GCB=	 V}', "");
Expect(1, 55238, '\P{^GCB=	 V}', "");
Expect(0, 55239, '\p{GCB=	 V}', "");
Expect(1, 55239, '\p{^GCB=	 V}', "");
Expect(1, 55239, '\P{GCB=	 V}', "");
Expect(0, 55239, '\P{^GCB=	 V}', "");
Error('\p{Is_Grapheme_Cluster_Break=/a/V}');
Error('\P{Is_Grapheme_Cluster_Break=/a/V}');
Expect(1, 55238, '\p{Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 55238, '\p{^Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 55238, '\P{Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 55238, '\P{^Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 55239, '\p{Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 55239, '\p{^Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 55239, '\P{Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 55239, '\P{^Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 55238, '\p{Is_Grapheme_Cluster_Break=__V}', "");
Expect(0, 55238, '\p{^Is_Grapheme_Cluster_Break=__V}', "");
Expect(0, 55238, '\P{Is_Grapheme_Cluster_Break=__V}', "");
Expect(1, 55238, '\P{^Is_Grapheme_Cluster_Break=__V}', "");
Expect(0, 55239, '\p{Is_Grapheme_Cluster_Break=__V}', "");
Expect(1, 55239, '\p{^Is_Grapheme_Cluster_Break=__V}', "");
Expect(1, 55239, '\P{Is_Grapheme_Cluster_Break=__V}', "");
Expect(0, 55239, '\P{^Is_Grapheme_Cluster_Break=__V}', "");
Error('\p{Is_GCB=:= V}');
Error('\P{Is_GCB=:= V}');
Expect(1, 55238, '\p{Is_GCB:v}', "");
Expect(0, 55238, '\p{^Is_GCB:v}', "");
Expect(0, 55238, '\P{Is_GCB:v}', "");
Expect(1, 55238, '\P{^Is_GCB:v}', "");
Expect(0, 55239, '\p{Is_GCB:v}', "");
Expect(1, 55239, '\p{^Is_GCB:v}', "");
Expect(1, 55239, '\P{Is_GCB:v}', "");
Expect(0, 55239, '\P{^Is_GCB:v}', "");
Expect(1, 55238, '\p{Is_GCB=_v}', "");
Expect(0, 55238, '\p{^Is_GCB=_v}', "");
Expect(0, 55238, '\P{Is_GCB=_v}', "");
Expect(1, 55238, '\P{^Is_GCB=_v}', "");
Expect(0, 55239, '\p{Is_GCB=_v}', "");
Expect(1, 55239, '\p{^Is_GCB=_v}', "");
Expect(1, 55239, '\P{Is_GCB=_v}', "");
Expect(0, 55239, '\P{^Is_GCB=_v}', "");
Error('\p{Grapheme_Cluster_Break=/a/ 	Other}');
Error('\P{Grapheme_Cluster_Break=/a/ 	Other}');
Expect(1, 921600, '\p{Grapheme_Cluster_Break=other}', "");
Expect(0, 921600, '\p{^Grapheme_Cluster_Break=other}', "");
Expect(0, 921600, '\P{Grapheme_Cluster_Break=other}', "");
Expect(1, 921600, '\P{^Grapheme_Cluster_Break=other}', "");
Expect(0, 921599, '\p{Grapheme_Cluster_Break=other}', "");
Expect(1, 921599, '\p{^Grapheme_Cluster_Break=other}', "");
Expect(1, 921599, '\P{Grapheme_Cluster_Break=other}', "");
Expect(0, 921599, '\P{^Grapheme_Cluster_Break=other}', "");
Expect(1, 921600, '\p{Grapheme_Cluster_Break=	Other}', "");
Expect(0, 921600, '\p{^Grapheme_Cluster_Break=	Other}', "");
Expect(0, 921600, '\P{Grapheme_Cluster_Break=	Other}', "");
Expect(1, 921600, '\P{^Grapheme_Cluster_Break=	Other}', "");
Expect(0, 921599, '\p{Grapheme_Cluster_Break=	Other}', "");
Expect(1, 921599, '\p{^Grapheme_Cluster_Break=	Other}', "");
Expect(1, 921599, '\P{Grapheme_Cluster_Break=	Other}', "");
Expect(0, 921599, '\P{^Grapheme_Cluster_Break=	Other}', "");
Error('\p{GCB:	-/a/xx}');
Error('\P{GCB:	-/a/xx}');
Expect(1, 921600, '\p{GCB=xx}', "");
Expect(0, 921600, '\p{^GCB=xx}', "");
Expect(0, 921600, '\P{GCB=xx}', "");
Expect(1, 921600, '\P{^GCB=xx}', "");
Expect(0, 921599, '\p{GCB=xx}', "");
Expect(1, 921599, '\p{^GCB=xx}', "");
Expect(1, 921599, '\P{GCB=xx}', "");
Expect(0, 921599, '\P{^GCB=xx}', "");
Expect(1, 921600, '\p{GCB=XX}', "");
Expect(0, 921600, '\p{^GCB=XX}', "");
Expect(0, 921600, '\P{GCB=XX}', "");
Expect(1, 921600, '\P{^GCB=XX}', "");
Expect(0, 921599, '\p{GCB=XX}', "");
Expect(1, 921599, '\p{^GCB=XX}', "");
Expect(1, 921599, '\P{GCB=XX}', "");
Expect(0, 921599, '\P{^GCB=XX}', "");
Error('\p{Is_Grapheme_Cluster_Break:	-_Other:=}');
Error('\P{Is_Grapheme_Cluster_Break:	-_Other:=}');
Expect(1, 921600, '\p{Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 921600, '\p{^Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 921600, '\P{Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 921600, '\P{^Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 921599, '\p{Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 921599, '\p{^Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 921599, '\P{Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 921599, '\P{^Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 921600, '\p{Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(0, 921600, '\p{^Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(0, 921600, '\P{Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(1, 921600, '\P{^Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(0, 921599, '\p{Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(1, 921599, '\p{^Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(1, 921599, '\P{Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(0, 921599, '\P{^Is_Grapheme_Cluster_Break=_	Other}', "");
Error('\p{Is_GCB=:=		xx}');
Error('\P{Is_GCB=:=		xx}');
Expect(1, 921600, '\p{Is_GCB=xx}', "");
Expect(0, 921600, '\p{^Is_GCB=xx}', "");
Expect(0, 921600, '\P{Is_GCB=xx}', "");
Expect(1, 921600, '\P{^Is_GCB=xx}', "");
Expect(0, 921599, '\p{Is_GCB=xx}', "");
Expect(1, 921599, '\p{^Is_GCB=xx}', "");
Expect(1, 921599, '\P{Is_GCB=xx}', "");
Expect(0, 921599, '\P{^Is_GCB=xx}', "");
Expect(1, 921600, '\p{Is_GCB=_	XX}', "");
Expect(0, 921600, '\p{^Is_GCB=_	XX}', "");
Expect(0, 921600, '\P{Is_GCB=_	XX}', "");
Expect(1, 921600, '\P{^Is_GCB=_	XX}', "");
Expect(0, 921599, '\p{Is_GCB=_	XX}', "");
Expect(1, 921599, '\p{^Is_GCB=_	XX}', "");
Expect(1, 921599, '\P{Is_GCB=_	XX}', "");
Expect(0, 921599, '\P{^Is_GCB=_	XX}', "");
Error('\p{Grapheme_Base:/a/		no}');
Error('\P{Grapheme_Base:/a/		no}');
Expect(1, 195102, '\p{Grapheme_Base:no}', "");
Expect(0, 195102, '\p{^Grapheme_Base:no}', "");
Expect(0, 195102, '\P{Grapheme_Base:no}', "");
Expect(1, 195102, '\P{^Grapheme_Base:no}', "");
Expect(0, 195101, '\p{Grapheme_Base:no}', "");
Expect(1, 195101, '\p{^Grapheme_Base:no}', "");
Expect(1, 195101, '\P{Grapheme_Base:no}', "");
Expect(0, 195101, '\P{^Grapheme_Base:no}', "");
Expect(1, 195102, '\p{Grapheme_Base=__No}', "");
Expect(0, 195102, '\p{^Grapheme_Base=__No}', "");
Expect(0, 195102, '\P{Grapheme_Base=__No}', "");
Expect(1, 195102, '\P{^Grapheme_Base=__No}', "");
Expect(0, 195101, '\p{Grapheme_Base=__No}', "");
Expect(1, 195101, '\p{^Grapheme_Base=__No}', "");
Expect(1, 195101, '\P{Grapheme_Base=__No}', "");
Expect(0, 195101, '\P{^Grapheme_Base=__No}', "");
Error('\p{Gr_Base=:=_ n}');
Error('\P{Gr_Base=:=_ n}');
Expect(1, 195102, '\p{Gr_Base=n}', "");
Expect(0, 195102, '\p{^Gr_Base=n}', "");
Expect(0, 195102, '\P{Gr_Base=n}', "");
Expect(1, 195102, '\P{^Gr_Base=n}', "");
Expect(0, 195101, '\p{Gr_Base=n}', "");
Expect(1, 195101, '\p{^Gr_Base=n}', "");
Expect(1, 195101, '\P{Gr_Base=n}', "");
Expect(0, 195101, '\P{^Gr_Base=n}', "");
Expect(1, 195102, '\p{Gr_Base=	_N}', "");
Expect(0, 195102, '\p{^Gr_Base=	_N}', "");
Expect(0, 195102, '\P{Gr_Base=	_N}', "");
Expect(1, 195102, '\P{^Gr_Base=	_N}', "");
Expect(0, 195101, '\p{Gr_Base=	_N}', "");
Expect(1, 195101, '\p{^Gr_Base=	_N}', "");
Expect(1, 195101, '\P{Gr_Base=	_N}', "");
Expect(0, 195101, '\P{^Gr_Base=	_N}', "");
Error('\p{Is_Grapheme_Base:   -	f/a/}');
Error('\P{Is_Grapheme_Base:   -	f/a/}');
Expect(1, 195102, '\p{Is_Grapheme_Base=f}', "");
Expect(0, 195102, '\p{^Is_Grapheme_Base=f}', "");
Expect(0, 195102, '\P{Is_Grapheme_Base=f}', "");
Expect(1, 195102, '\P{^Is_Grapheme_Base=f}', "");
Expect(0, 195101, '\p{Is_Grapheme_Base=f}', "");
Expect(1, 195101, '\p{^Is_Grapheme_Base=f}', "");
Expect(1, 195101, '\P{Is_Grapheme_Base=f}', "");
Expect(0, 195101, '\P{^Is_Grapheme_Base=f}', "");
Expect(1, 195102, '\p{Is_Grapheme_Base=	f}', "");
Expect(0, 195102, '\p{^Is_Grapheme_Base=	f}', "");
Expect(0, 195102, '\P{Is_Grapheme_Base=	f}', "");
Expect(1, 195102, '\P{^Is_Grapheme_Base=	f}', "");
Expect(0, 195101, '\p{Is_Grapheme_Base=	f}', "");
Expect(1, 195101, '\p{^Is_Grapheme_Base=	f}', "");
Expect(1, 195101, '\P{Is_Grapheme_Base=	f}', "");
Expect(0, 195101, '\P{^Is_Grapheme_Base=	f}', "");
Error('\p{Is_Gr_Base= _False:=}');
Error('\P{Is_Gr_Base= _False:=}');
Expect(1, 195102, '\p{Is_Gr_Base=false}', "");
Expect(0, 195102, '\p{^Is_Gr_Base=false}', "");
Expect(0, 195102, '\P{Is_Gr_Base=false}', "");
Expect(1, 195102, '\P{^Is_Gr_Base=false}', "");
Expect(0, 195101, '\p{Is_Gr_Base=false}', "");
Expect(1, 195101, '\p{^Is_Gr_Base=false}', "");
Expect(1, 195101, '\P{Is_Gr_Base=false}', "");
Expect(0, 195101, '\P{^Is_Gr_Base=false}', "");
Expect(1, 195102, '\p{Is_Gr_Base=_-False}', "");
Expect(0, 195102, '\p{^Is_Gr_Base=_-False}', "");
Expect(0, 195102, '\P{Is_Gr_Base=_-False}', "");
Expect(1, 195102, '\P{^Is_Gr_Base=_-False}', "");
Expect(0, 195101, '\p{Is_Gr_Base=_-False}', "");
Expect(1, 195101, '\p{^Is_Gr_Base=_-False}', "");
Expect(1, 195101, '\P{Is_Gr_Base=_-False}', "");
Expect(0, 195101, '\P{^Is_Gr_Base=_-False}', "");
Error('\p{Grapheme_Base=- YES/a/}');
Error('\P{Grapheme_Base=- YES/a/}');
Expect(1, 195101, '\p{Grapheme_Base=yes}', "");
Expect(0, 195101, '\p{^Grapheme_Base=yes}', "");
Expect(0, 195101, '\P{Grapheme_Base=yes}', "");
Expect(1, 195101, '\P{^Grapheme_Base=yes}', "");
Expect(0, 195102, '\p{Grapheme_Base=yes}', "");
Expect(1, 195102, '\p{^Grapheme_Base=yes}', "");
Expect(1, 195102, '\P{Grapheme_Base=yes}', "");
Expect(0, 195102, '\P{^Grapheme_Base=yes}', "");
Expect(1, 195101, '\p{Grapheme_Base=-Yes}', "");
Expect(0, 195101, '\p{^Grapheme_Base=-Yes}', "");
Expect(0, 195101, '\P{Grapheme_Base=-Yes}', "");
Expect(1, 195101, '\P{^Grapheme_Base=-Yes}', "");
Expect(0, 195102, '\p{Grapheme_Base=-Yes}', "");
Expect(1, 195102, '\p{^Grapheme_Base=-Yes}', "");
Expect(1, 195102, '\P{Grapheme_Base=-Yes}', "");
Expect(0, 195102, '\P{^Grapheme_Base=-Yes}', "");
Error('\p{Gr_Base=-/a/y}');
Error('\P{Gr_Base=-/a/y}');
Expect(1, 195101, '\p{Gr_Base=y}', "");
Expect(0, 195101, '\p{^Gr_Base=y}', "");
Expect(0, 195101, '\P{Gr_Base=y}', "");
Expect(1, 195101, '\P{^Gr_Base=y}', "");
Expect(0, 195102, '\p{Gr_Base=y}', "");
Expect(1, 195102, '\p{^Gr_Base=y}', "");
Expect(1, 195102, '\P{Gr_Base=y}', "");
Expect(0, 195102, '\P{^Gr_Base=y}', "");
Expect(1, 195101, '\p{Gr_Base= _Y}', "");
Expect(0, 195101, '\p{^Gr_Base= _Y}', "");
Expect(0, 195101, '\P{Gr_Base= _Y}', "");
Expect(1, 195101, '\P{^Gr_Base= _Y}', "");
Expect(0, 195102, '\p{Gr_Base= _Y}', "");
Expect(1, 195102, '\p{^Gr_Base= _Y}', "");
Expect(1, 195102, '\P{Gr_Base= _Y}', "");
Expect(0, 195102, '\P{^Gr_Base= _Y}', "");
Error('\p{Is_Grapheme_Base=:=T}');
Error('\P{Is_Grapheme_Base=:=T}');
Expect(1, 195101, '\p{Is_Grapheme_Base=t}', "");
Expect(0, 195101, '\p{^Is_Grapheme_Base=t}', "");
Expect(0, 195101, '\P{Is_Grapheme_Base=t}', "");
Expect(1, 195101, '\P{^Is_Grapheme_Base=t}', "");
Expect(0, 195102, '\p{Is_Grapheme_Base=t}', "");
Expect(1, 195102, '\p{^Is_Grapheme_Base=t}', "");
Expect(1, 195102, '\P{Is_Grapheme_Base=t}', "");
Expect(0, 195102, '\P{^Is_Grapheme_Base=t}', "");
Expect(1, 195101, '\p{Is_Grapheme_Base:   	_T}', "");
Expect(0, 195101, '\p{^Is_Grapheme_Base:   	_T}', "");
Expect(0, 195101, '\P{Is_Grapheme_Base:   	_T}', "");
Expect(1, 195101, '\P{^Is_Grapheme_Base:   	_T}', "");
Expect(0, 195102, '\p{Is_Grapheme_Base:   	_T}', "");
Expect(1, 195102, '\p{^Is_Grapheme_Base:   	_T}', "");
Expect(1, 195102, '\P{Is_Grapheme_Base:   	_T}', "");
Expect(0, 195102, '\P{^Is_Grapheme_Base:   	_T}', "");
Error('\p{Is_Gr_Base=-:=TRUE}');
Error('\P{Is_Gr_Base=-:=TRUE}');
Expect(1, 195101, '\p{Is_Gr_Base=true}', "");
Expect(0, 195101, '\p{^Is_Gr_Base=true}', "");
Expect(0, 195101, '\P{Is_Gr_Base=true}', "");
Expect(1, 195101, '\P{^Is_Gr_Base=true}', "");
Expect(0, 195102, '\p{Is_Gr_Base=true}', "");
Expect(1, 195102, '\p{^Is_Gr_Base=true}', "");
Expect(1, 195102, '\P{Is_Gr_Base=true}', "");
Expect(0, 195102, '\P{^Is_Gr_Base=true}', "");
Expect(1, 195101, '\p{Is_Gr_Base=_TRUE}', "");
Expect(0, 195101, '\p{^Is_Gr_Base=_TRUE}', "");
Expect(0, 195101, '\P{Is_Gr_Base=_TRUE}', "");
Expect(1, 195101, '\P{^Is_Gr_Base=_TRUE}', "");
Expect(0, 195102, '\p{Is_Gr_Base=_TRUE}', "");
Expect(1, 195102, '\p{^Is_Gr_Base=_TRUE}', "");
Expect(1, 195102, '\P{Is_Gr_Base=_TRUE}', "");
Expect(0, 195102, '\P{^Is_Gr_Base=_TRUE}', "");
Error('\p{Grapheme_Extend=-_No/a/}');
Error('\P{Grapheme_Extend=-_No/a/}');
Expect(1, 918000, '\p{Grapheme_Extend=no}', "");
Expect(0, 918000, '\p{^Grapheme_Extend=no}', "");
Expect(0, 918000, '\P{Grapheme_Extend=no}', "");
Expect(1, 918000, '\P{^Grapheme_Extend=no}', "");
Expect(0, 917999, '\p{Grapheme_Extend=no}', "");
Expect(1, 917999, '\p{^Grapheme_Extend=no}', "");
Expect(1, 917999, '\P{Grapheme_Extend=no}', "");
Expect(0, 917999, '\P{^Grapheme_Extend=no}', "");
Expect(1, 918000, '\p{Grapheme_Extend=	 No}', "");
Expect(0, 918000, '\p{^Grapheme_Extend=	 No}', "");
Expect(0, 918000, '\P{Grapheme_Extend=	 No}', "");
Expect(1, 918000, '\P{^Grapheme_Extend=	 No}', "");
Expect(0, 917999, '\p{Grapheme_Extend=	 No}', "");
Expect(1, 917999, '\p{^Grapheme_Extend=	 No}', "");
Expect(1, 917999, '\P{Grapheme_Extend=	 No}', "");
Expect(0, 917999, '\P{^Grapheme_Extend=	 No}', "");
Error('\p{Gr_Ext=_/a/N}');
Error('\P{Gr_Ext=_/a/N}');
Expect(1, 918000, '\p{Gr_Ext=n}', "");
Expect(0, 918000, '\p{^Gr_Ext=n}', "");
Expect(0, 918000, '\P{Gr_Ext=n}', "");
Expect(1, 918000, '\P{^Gr_Ext=n}', "");
Expect(0, 917999, '\p{Gr_Ext=n}', "");
Expect(1, 917999, '\p{^Gr_Ext=n}', "");
Expect(1, 917999, '\P{Gr_Ext=n}', "");
Expect(0, 917999, '\P{^Gr_Ext=n}', "");
Expect(1, 918000, '\p{Gr_Ext=_-N}', "");
Expect(0, 918000, '\p{^Gr_Ext=_-N}', "");
Expect(0, 918000, '\P{Gr_Ext=_-N}', "");
Expect(1, 918000, '\P{^Gr_Ext=_-N}', "");
Expect(0, 917999, '\p{Gr_Ext=_-N}', "");
Expect(1, 917999, '\p{^Gr_Ext=_-N}', "");
Expect(1, 917999, '\P{Gr_Ext=_-N}', "");
Expect(0, 917999, '\P{^Gr_Ext=_-N}', "");
Error('\p{Is_Grapheme_Extend=-:=F}');
Error('\P{Is_Grapheme_Extend=-:=F}');
Expect(1, 918000, '\p{Is_Grapheme_Extend=f}', "");
Expect(0, 918000, '\p{^Is_Grapheme_Extend=f}', "");
Expect(0, 918000, '\P{Is_Grapheme_Extend=f}', "");
Expect(1, 918000, '\P{^Is_Grapheme_Extend=f}', "");
Expect(0, 917999, '\p{Is_Grapheme_Extend=f}', "");
Expect(1, 917999, '\p{^Is_Grapheme_Extend=f}', "");
Expect(1, 917999, '\P{Is_Grapheme_Extend=f}', "");
Expect(0, 917999, '\P{^Is_Grapheme_Extend=f}', "");
Expect(1, 918000, '\p{Is_Grapheme_Extend=-f}', "");
Expect(0, 918000, '\p{^Is_Grapheme_Extend=-f}', "");
Expect(0, 918000, '\P{Is_Grapheme_Extend=-f}', "");
Expect(1, 918000, '\P{^Is_Grapheme_Extend=-f}', "");
Expect(0, 917999, '\p{Is_Grapheme_Extend=-f}', "");
Expect(1, 917999, '\p{^Is_Grapheme_Extend=-f}', "");
Expect(1, 917999, '\P{Is_Grapheme_Extend=-f}', "");
Expect(0, 917999, '\P{^Is_Grapheme_Extend=-f}', "");
Error('\p{Is_Gr_Ext= False/a/}');
Error('\P{Is_Gr_Ext= False/a/}');
Expect(1, 918000, '\p{Is_Gr_Ext=false}', "");
Expect(0, 918000, '\p{^Is_Gr_Ext=false}', "");
Expect(0, 918000, '\P{Is_Gr_Ext=false}', "");
Expect(1, 918000, '\P{^Is_Gr_Ext=false}', "");
Expect(0, 917999, '\p{Is_Gr_Ext=false}', "");
Expect(1, 917999, '\p{^Is_Gr_Ext=false}', "");
Expect(1, 917999, '\P{Is_Gr_Ext=false}', "");
Expect(0, 917999, '\P{^Is_Gr_Ext=false}', "");
Expect(1, 918000, '\p{Is_Gr_Ext=	 False}', "");
Expect(0, 918000, '\p{^Is_Gr_Ext=	 False}', "");
Expect(0, 918000, '\P{Is_Gr_Ext=	 False}', "");
Expect(1, 918000, '\P{^Is_Gr_Ext=	 False}', "");
Expect(0, 917999, '\p{Is_Gr_Ext=	 False}', "");
Expect(1, 917999, '\p{^Is_Gr_Ext=	 False}', "");
Expect(1, 917999, '\P{Is_Gr_Ext=	 False}', "");
Expect(0, 917999, '\P{^Is_Gr_Ext=	 False}', "");
Error('\p{Grapheme_Extend= yes/a/}');
Error('\P{Grapheme_Extend= yes/a/}');
Expect(1, 917999, '\p{Grapheme_Extend=yes}', "");
Expect(0, 917999, '\p{^Grapheme_Extend=yes}', "");
Expect(0, 917999, '\P{Grapheme_Extend=yes}', "");
Expect(1, 917999, '\P{^Grapheme_Extend=yes}', "");
Expect(0, 918000, '\p{Grapheme_Extend=yes}', "");
Expect(1, 918000, '\p{^Grapheme_Extend=yes}', "");
Expect(1, 918000, '\P{Grapheme_Extend=yes}', "");
Expect(0, 918000, '\P{^Grapheme_Extend=yes}', "");
Expect(1, 917999, '\p{Grapheme_Extend=--Yes}', "");
Expect(0, 917999, '\p{^Grapheme_Extend=--Yes}', "");
Expect(0, 917999, '\P{Grapheme_Extend=--Yes}', "");
Expect(1, 917999, '\P{^Grapheme_Extend=--Yes}', "");
Expect(0, 918000, '\p{Grapheme_Extend=--Yes}', "");
Expect(1, 918000, '\p{^Grapheme_Extend=--Yes}', "");
Expect(1, 918000, '\P{Grapheme_Extend=--Yes}', "");
Expect(0, 918000, '\P{^Grapheme_Extend=--Yes}', "");
Error('\p{Gr_Ext=	:=y}');
Error('\P{Gr_Ext=	:=y}');
Expect(1, 917999, '\p{Gr_Ext=y}', "");
Expect(0, 917999, '\p{^Gr_Ext=y}', "");
Expect(0, 917999, '\P{Gr_Ext=y}', "");
Expect(1, 917999, '\P{^Gr_Ext=y}', "");
Expect(0, 918000, '\p{Gr_Ext=y}', "");
Expect(1, 918000, '\p{^Gr_Ext=y}', "");
Expect(1, 918000, '\P{Gr_Ext=y}', "");
Expect(0, 918000, '\P{^Gr_Ext=y}', "");
Expect(1, 917999, '\p{Gr_Ext= 	Y}', "");
Expect(0, 917999, '\p{^Gr_Ext= 	Y}', "");
Expect(0, 917999, '\P{Gr_Ext= 	Y}', "");
Expect(1, 917999, '\P{^Gr_Ext= 	Y}', "");
Expect(0, 918000, '\p{Gr_Ext= 	Y}', "");
Expect(1, 918000, '\p{^Gr_Ext= 	Y}', "");
Expect(1, 918000, '\P{Gr_Ext= 	Y}', "");
Expect(0, 918000, '\P{^Gr_Ext= 	Y}', "");
Error('\p{Is_Grapheme_Extend: - T:=}');
Error('\P{Is_Grapheme_Extend: - T:=}');
Expect(1, 917999, '\p{Is_Grapheme_Extend=t}', "");
Expect(0, 917999, '\p{^Is_Grapheme_Extend=t}', "");
Expect(0, 917999, '\P{Is_Grapheme_Extend=t}', "");
Expect(1, 917999, '\P{^Is_Grapheme_Extend=t}', "");
Expect(0, 918000, '\p{Is_Grapheme_Extend=t}', "");
Expect(1, 918000, '\p{^Is_Grapheme_Extend=t}', "");
Expect(1, 918000, '\P{Is_Grapheme_Extend=t}', "");
Expect(0, 918000, '\P{^Is_Grapheme_Extend=t}', "");
Expect(1, 917999, '\p{Is_Grapheme_Extend=--t}', "");
Expect(0, 917999, '\p{^Is_Grapheme_Extend=--t}', "");
Expect(0, 917999, '\P{Is_Grapheme_Extend=--t}', "");
Expect(1, 917999, '\P{^Is_Grapheme_Extend=--t}', "");
Expect(0, 918000, '\p{Is_Grapheme_Extend=--t}', "");
Expect(1, 918000, '\p{^Is_Grapheme_Extend=--t}', "");
Expect(1, 918000, '\P{Is_Grapheme_Extend=--t}', "");
Expect(0, 918000, '\P{^Is_Grapheme_Extend=--t}', "");
Error('\p{Is_Gr_Ext=/a/ -TRUE}');
Error('\P{Is_Gr_Ext=/a/ -TRUE}');
Expect(1, 917999, '\p{Is_Gr_Ext=true}', "");
Expect(0, 917999, '\p{^Is_Gr_Ext=true}', "");
Expect(0, 917999, '\P{Is_Gr_Ext=true}', "");
Expect(1, 917999, '\P{^Is_Gr_Ext=true}', "");
Expect(0, 918000, '\p{Is_Gr_Ext=true}', "");
Expect(1, 918000, '\p{^Is_Gr_Ext=true}', "");
Expect(1, 918000, '\P{Is_Gr_Ext=true}', "");
Expect(0, 918000, '\P{^Is_Gr_Ext=true}', "");
Expect(1, 917999, '\p{Is_Gr_Ext=_true}', "");
Expect(0, 917999, '\p{^Is_Gr_Ext=_true}', "");
Expect(0, 917999, '\P{Is_Gr_Ext=_true}', "");
Expect(1, 917999, '\P{^Is_Gr_Ext=_true}', "");
Expect(0, 918000, '\p{Is_Gr_Ext=_true}', "");
Expect(1, 918000, '\p{^Is_Gr_Ext=_true}', "");
Expect(1, 918000, '\P{Is_Gr_Ext=_true}', "");
Expect(0, 918000, '\P{^Is_Gr_Ext=_true}', "");
Error('\p{Grapheme_Link=No}');
Error('\P{Grapheme_Link=No}');
Error('\p{Gr_Link=N}');
Error('\P{Gr_Link=N}');
Error('\p{Is_Grapheme_Link=F}');
Error('\P{Is_Grapheme_Link=F}');
Error('\p{Is_Gr_Link=False}');
Error('\P{Is_Gr_Link=False}');
Error('\p{Grapheme_Link:	Yes}');
Error('\P{Grapheme_Link:	Yes}');
Error('\p{Gr_Link=Y}');
Error('\P{Gr_Link=Y}');
Error('\p{Is_Grapheme_Link=T}');
Error('\P{Is_Grapheme_Link=T}');
Error('\p{Is_Gr_Link=True}');
Error('\P{Is_Gr_Link=True}');
Error('\p{Hex_Digit:   := NO}');
Error('\P{Hex_Digit:   := NO}');
Expect(1, 65351, '\p{Hex_Digit=no}', "");
Expect(0, 65351, '\p{^Hex_Digit=no}', "");
Expect(0, 65351, '\P{Hex_Digit=no}', "");
Expect(1, 65351, '\P{^Hex_Digit=no}', "");
Expect(0, 65350, '\p{Hex_Digit=no}', "");
Expect(1, 65350, '\p{^Hex_Digit=no}', "");
Expect(1, 65350, '\P{Hex_Digit=no}', "");
Expect(0, 65350, '\P{^Hex_Digit=no}', "");
Expect(1, 65351, '\p{Hex_Digit=--No}', "");
Expect(0, 65351, '\p{^Hex_Digit=--No}', "");
Expect(0, 65351, '\P{Hex_Digit=--No}', "");
Expect(1, 65351, '\P{^Hex_Digit=--No}', "");
Expect(0, 65350, '\p{Hex_Digit=--No}', "");
Expect(1, 65350, '\p{^Hex_Digit=--No}', "");
Expect(1, 65350, '\P{Hex_Digit=--No}', "");
Expect(0, 65350, '\P{^Hex_Digit=--No}', "");
Error('\p{Hex=- N/a/}');
Error('\P{Hex=- N/a/}');
Expect(1, 65351, '\p{Hex=n}', "");
Expect(0, 65351, '\p{^Hex=n}', "");
Expect(0, 65351, '\P{Hex=n}', "");
Expect(1, 65351, '\P{^Hex=n}', "");
Expect(0, 65350, '\p{Hex=n}', "");
Expect(1, 65350, '\p{^Hex=n}', "");
Expect(1, 65350, '\P{Hex=n}', "");
Expect(0, 65350, '\P{^Hex=n}', "");
Expect(1, 65351, '\p{Hex= -N}', "");
Expect(0, 65351, '\p{^Hex= -N}', "");
Expect(0, 65351, '\P{Hex= -N}', "");
Expect(1, 65351, '\P{^Hex= -N}', "");
Expect(0, 65350, '\p{Hex= -N}', "");
Expect(1, 65350, '\p{^Hex= -N}', "");
Expect(1, 65350, '\P{Hex= -N}', "");
Expect(0, 65350, '\P{^Hex= -N}', "");
Error('\p{Is_Hex_Digit=-F:=}');
Error('\P{Is_Hex_Digit=-F:=}');
Expect(1, 65351, '\p{Is_Hex_Digit=f}', "");
Expect(0, 65351, '\p{^Is_Hex_Digit=f}', "");
Expect(0, 65351, '\P{Is_Hex_Digit=f}', "");
Expect(1, 65351, '\P{^Is_Hex_Digit=f}', "");
Expect(0, 65350, '\p{Is_Hex_Digit=f}', "");
Expect(1, 65350, '\p{^Is_Hex_Digit=f}', "");
Expect(1, 65350, '\P{Is_Hex_Digit=f}', "");
Expect(0, 65350, '\P{^Is_Hex_Digit=f}', "");
Expect(1, 65351, '\p{Is_Hex_Digit=	 f}', "");
Expect(0, 65351, '\p{^Is_Hex_Digit=	 f}', "");
Expect(0, 65351, '\P{Is_Hex_Digit=	 f}', "");
Expect(1, 65351, '\P{^Is_Hex_Digit=	 f}', "");
Expect(0, 65350, '\p{Is_Hex_Digit=	 f}', "");
Expect(1, 65350, '\p{^Is_Hex_Digit=	 f}', "");
Expect(1, 65350, '\P{Is_Hex_Digit=	 f}', "");
Expect(0, 65350, '\P{^Is_Hex_Digit=	 f}', "");
Error('\p{Is_Hex=:= False}');
Error('\P{Is_Hex=:= False}');
Expect(1, 65351, '\p{Is_Hex=false}', "");
Expect(0, 65351, '\p{^Is_Hex=false}', "");
Expect(0, 65351, '\P{Is_Hex=false}', "");
Expect(1, 65351, '\P{^Is_Hex=false}', "");
Expect(0, 65350, '\p{Is_Hex=false}', "");
Expect(1, 65350, '\p{^Is_Hex=false}', "");
Expect(1, 65350, '\P{Is_Hex=false}', "");
Expect(0, 65350, '\P{^Is_Hex=false}', "");
Expect(1, 65351, '\p{Is_Hex=-false}', "");
Expect(0, 65351, '\p{^Is_Hex=-false}', "");
Expect(0, 65351, '\P{Is_Hex=-false}', "");
Expect(1, 65351, '\P{^Is_Hex=-false}', "");
Expect(0, 65350, '\p{Is_Hex=-false}', "");
Expect(1, 65350, '\p{^Is_Hex=-false}', "");
Expect(1, 65350, '\P{Is_Hex=-false}', "");
Expect(0, 65350, '\P{^Is_Hex=-false}', "");
Error('\p{Hex_Digit=:= Yes}');
Error('\P{Hex_Digit=:= Yes}');
Expect(1, 65350, '\p{Hex_Digit=yes}', "");
Expect(0, 65350, '\p{^Hex_Digit=yes}', "");
Expect(0, 65350, '\P{Hex_Digit=yes}', "");
Expect(1, 65350, '\P{^Hex_Digit=yes}', "");
Expect(0, 65351, '\p{Hex_Digit=yes}', "");
Expect(1, 65351, '\p{^Hex_Digit=yes}', "");
Expect(1, 65351, '\P{Hex_Digit=yes}', "");
Expect(0, 65351, '\P{^Hex_Digit=yes}', "");
Expect(1, 65350, '\p{Hex_Digit:	-Yes}', "");
Expect(0, 65350, '\p{^Hex_Digit:	-Yes}', "");
Expect(0, 65350, '\P{Hex_Digit:	-Yes}', "");
Expect(1, 65350, '\P{^Hex_Digit:	-Yes}', "");
Expect(0, 65351, '\p{Hex_Digit:	-Yes}', "");
Expect(1, 65351, '\p{^Hex_Digit:	-Yes}', "");
Expect(1, 65351, '\P{Hex_Digit:	-Yes}', "");
Expect(0, 65351, '\P{^Hex_Digit:	-Yes}', "");
Error('\p{Hex=_/a/Y}');
Error('\P{Hex=_/a/Y}');
Expect(1, 65350, '\p{Hex=y}', "");
Expect(0, 65350, '\p{^Hex=y}', "");
Expect(0, 65350, '\P{Hex=y}', "");
Expect(1, 65350, '\P{^Hex=y}', "");
Expect(0, 65351, '\p{Hex=y}', "");
Expect(1, 65351, '\p{^Hex=y}', "");
Expect(1, 65351, '\P{Hex=y}', "");
Expect(0, 65351, '\P{^Hex=y}', "");
Expect(1, 65350, '\p{Hex=-	y}', "");
Expect(0, 65350, '\p{^Hex=-	y}', "");
Expect(0, 65350, '\P{Hex=-	y}', "");
Expect(1, 65350, '\P{^Hex=-	y}', "");
Expect(0, 65351, '\p{Hex=-	y}', "");
Expect(1, 65351, '\p{^Hex=-	y}', "");
Expect(1, 65351, '\P{Hex=-	y}', "");
Expect(0, 65351, '\P{^Hex=-	y}', "");
Error('\p{Is_Hex_Digit=/a/-T}');
Error('\P{Is_Hex_Digit=/a/-T}');
Expect(1, 65350, '\p{Is_Hex_Digit=t}', "");
Expect(0, 65350, '\p{^Is_Hex_Digit=t}', "");
Expect(0, 65350, '\P{Is_Hex_Digit=t}', "");
Expect(1, 65350, '\P{^Is_Hex_Digit=t}', "");
Expect(0, 65351, '\p{Is_Hex_Digit=t}', "");
Expect(1, 65351, '\p{^Is_Hex_Digit=t}', "");
Expect(1, 65351, '\P{Is_Hex_Digit=t}', "");
Expect(0, 65351, '\P{^Is_Hex_Digit=t}', "");
Expect(1, 65350, '\p{Is_Hex_Digit=_	T}', "");
Expect(0, 65350, '\p{^Is_Hex_Digit=_	T}', "");
Expect(0, 65350, '\P{Is_Hex_Digit=_	T}', "");
Expect(1, 65350, '\P{^Is_Hex_Digit=_	T}', "");
Expect(0, 65351, '\p{Is_Hex_Digit=_	T}', "");
Expect(1, 65351, '\p{^Is_Hex_Digit=_	T}', "");
Expect(1, 65351, '\P{Is_Hex_Digit=_	T}', "");
Expect(0, 65351, '\P{^Is_Hex_Digit=_	T}', "");
Error('\p{Is_Hex=-TRUE:=}');
Error('\P{Is_Hex=-TRUE:=}');
Expect(1, 65350, '\p{Is_Hex=true}', "");
Expect(0, 65350, '\p{^Is_Hex=true}', "");
Expect(0, 65350, '\P{Is_Hex=true}', "");
Expect(1, 65350, '\P{^Is_Hex=true}', "");
Expect(0, 65351, '\p{Is_Hex=true}', "");
Expect(1, 65351, '\p{^Is_Hex=true}', "");
Expect(1, 65351, '\P{Is_Hex=true}', "");
Expect(0, 65351, '\P{^Is_Hex=true}', "");
Expect(1, 65350, '\p{Is_Hex= _True}', "");
Expect(0, 65350, '\p{^Is_Hex= _True}', "");
Expect(0, 65350, '\P{Is_Hex= _True}', "");
Expect(1, 65350, '\P{^Is_Hex= _True}', "");
Expect(0, 65351, '\p{Is_Hex= _True}', "");
Expect(1, 65351, '\p{^Is_Hex= _True}', "");
Expect(1, 65351, '\P{Is_Hex= _True}', "");
Expect(0, 65351, '\P{^Is_Hex= _True}', "");
Error('\p{Hyphen=:=_No}');
Error('\P{Hyphen=:=_No}');
Expect(1, 65382, '\p{Hyphen=no}', 'deprecated');
Expect(0, 65382, '\p{^Hyphen=no}', 'deprecated');
Expect(0, 65382, '\P{Hyphen=no}', 'deprecated');
Expect(1, 65382, '\P{^Hyphen=no}', 'deprecated');
Expect(0, 65381, '\p{Hyphen=no}', 'deprecated');
Expect(1, 65381, '\p{^Hyphen=no}', 'deprecated');
Expect(1, 65381, '\P{Hyphen=no}', 'deprecated');
Expect(0, 65381, '\P{^Hyphen=no}', 'deprecated');
Expect(1, 65382, '\p{Hyphen= No}', 'deprecated');
Expect(0, 65382, '\p{^Hyphen= No}', 'deprecated');
Expect(0, 65382, '\P{Hyphen= No}', 'deprecated');
Expect(1, 65382, '\P{^Hyphen= No}', 'deprecated');
Expect(0, 65381, '\p{Hyphen= No}', 'deprecated');
Expect(1, 65381, '\p{^Hyphen= No}', 'deprecated');
Expect(1, 65381, '\P{Hyphen= No}', 'deprecated');
Expect(0, 65381, '\P{^Hyphen= No}', 'deprecated');
Error('\p{Is_Hyphen=_:=N}');
Error('\P{Is_Hyphen=_:=N}');
Expect(1, 65382, '\p{Is_Hyphen=n}', 'deprecated');
Expect(0, 65382, '\p{^Is_Hyphen=n}', 'deprecated');
Expect(0, 65382, '\P{Is_Hyphen=n}', 'deprecated');
Expect(1, 65382, '\P{^Is_Hyphen=n}', 'deprecated');
Expect(0, 65381, '\p{Is_Hyphen=n}', 'deprecated');
Expect(1, 65381, '\p{^Is_Hyphen=n}', 'deprecated');
Expect(1, 65381, '\P{Is_Hyphen=n}', 'deprecated');
Expect(0, 65381, '\P{^Is_Hyphen=n}', 'deprecated');
Expect(1, 65382, '\p{Is_Hyphen=	-N}', 'deprecated');
Expect(0, 65382, '\p{^Is_Hyphen=	-N}', 'deprecated');
Expect(0, 65382, '\P{Is_Hyphen=	-N}', 'deprecated');
Expect(1, 65382, '\P{^Is_Hyphen=	-N}', 'deprecated');
Expect(0, 65381, '\p{Is_Hyphen=	-N}', 'deprecated');
Expect(1, 65381, '\p{^Is_Hyphen=	-N}', 'deprecated');
Expect(1, 65381, '\P{Is_Hyphen=	-N}', 'deprecated');
Expect(0, 65381, '\P{^Is_Hyphen=	-N}', 'deprecated');
Error('\p{Hyphen=	_F/a/}');
Error('\P{Hyphen=	_F/a/}');
Expect(1, 65382, '\p{Hyphen=f}', 'deprecated');
Expect(0, 65382, '\p{^Hyphen=f}', 'deprecated');
Expect(0, 65382, '\P{Hyphen=f}', 'deprecated');
Expect(1, 65382, '\P{^Hyphen=f}', 'deprecated');
Expect(0, 65381, '\p{Hyphen=f}', 'deprecated');
Expect(1, 65381, '\p{^Hyphen=f}', 'deprecated');
Expect(1, 65381, '\P{Hyphen=f}', 'deprecated');
Expect(0, 65381, '\P{^Hyphen=f}', 'deprecated');
Expect(1, 65382, '\p{Hyphen=		F}', 'deprecated');
Expect(0, 65382, '\p{^Hyphen=		F}', 'deprecated');
Expect(0, 65382, '\P{Hyphen=		F}', 'deprecated');
Expect(1, 65382, '\P{^Hyphen=		F}', 'deprecated');
Expect(0, 65381, '\p{Hyphen=		F}', 'deprecated');
Expect(1, 65381, '\p{^Hyphen=		F}', 'deprecated');
Expect(1, 65381, '\P{Hyphen=		F}', 'deprecated');
Expect(0, 65381, '\P{^Hyphen=		F}', 'deprecated');
Error('\p{Is_Hyphen=-	FALSE/a/}');
Error('\P{Is_Hyphen=-	FALSE/a/}');
Expect(1, 65382, '\p{Is_Hyphen=false}', 'deprecated');
Expect(0, 65382, '\p{^Is_Hyphen=false}', 'deprecated');
Expect(0, 65382, '\P{Is_Hyphen=false}', 'deprecated');
Expect(1, 65382, '\P{^Is_Hyphen=false}', 'deprecated');
Expect(0, 65381, '\p{Is_Hyphen=false}', 'deprecated');
Expect(1, 65381, '\p{^Is_Hyphen=false}', 'deprecated');
Expect(1, 65381, '\P{Is_Hyphen=false}', 'deprecated');
Expect(0, 65381, '\P{^Is_Hyphen=false}', 'deprecated');
Expect(1, 65382, '\p{Is_Hyphen=--False}', 'deprecated');
Expect(0, 65382, '\p{^Is_Hyphen=--False}', 'deprecated');
Expect(0, 65382, '\P{Is_Hyphen=--False}', 'deprecated');
Expect(1, 65382, '\P{^Is_Hyphen=--False}', 'deprecated');
Expect(0, 65381, '\p{Is_Hyphen=--False}', 'deprecated');
Expect(1, 65381, '\p{^Is_Hyphen=--False}', 'deprecated');
Expect(1, 65381, '\P{Is_Hyphen=--False}', 'deprecated');
Expect(0, 65381, '\P{^Is_Hyphen=--False}', 'deprecated');
Error('\p{Hyphen: /a/YES}');
Error('\P{Hyphen: /a/YES}');
Expect(1, 65381, '\p{Hyphen=yes}', 'deprecated');
Expect(0, 65381, '\p{^Hyphen=yes}', 'deprecated');
Expect(0, 65381, '\P{Hyphen=yes}', 'deprecated');
Expect(1, 65381, '\P{^Hyphen=yes}', 'deprecated');
Expect(0, 65382, '\p{Hyphen=yes}', 'deprecated');
Expect(1, 65382, '\p{^Hyphen=yes}', 'deprecated');
Expect(1, 65382, '\P{Hyphen=yes}', 'deprecated');
Expect(0, 65382, '\P{^Hyphen=yes}', 'deprecated');
Expect(1, 65381, '\p{Hyphen=	-yes}', 'deprecated');
Expect(0, 65381, '\p{^Hyphen=	-yes}', 'deprecated');
Expect(0, 65381, '\P{Hyphen=	-yes}', 'deprecated');
Expect(1, 65381, '\P{^Hyphen=	-yes}', 'deprecated');
Expect(0, 65382, '\p{Hyphen=	-yes}', 'deprecated');
Expect(1, 65382, '\p{^Hyphen=	-yes}', 'deprecated');
Expect(1, 65382, '\P{Hyphen=	-yes}', 'deprecated');
Expect(0, 65382, '\P{^Hyphen=	-yes}', 'deprecated');
Error('\p{Is_Hyphen=:=	Y}');
Error('\P{Is_Hyphen=:=	Y}');
Expect(1, 65381, '\p{Is_Hyphen=y}', 'deprecated');
Expect(0, 65381, '\p{^Is_Hyphen=y}', 'deprecated');
Expect(0, 65381, '\P{Is_Hyphen=y}', 'deprecated');
Expect(1, 65381, '\P{^Is_Hyphen=y}', 'deprecated');
Expect(0, 65382, '\p{Is_Hyphen=y}', 'deprecated');
Expect(1, 65382, '\p{^Is_Hyphen=y}', 'deprecated');
Expect(1, 65382, '\P{Is_Hyphen=y}', 'deprecated');
Expect(0, 65382, '\P{^Is_Hyphen=y}', 'deprecated');
Expect(1, 65381, '\p{Is_Hyphen=-y}', 'deprecated');
Expect(0, 65381, '\p{^Is_Hyphen=-y}', 'deprecated');
Expect(0, 65381, '\P{Is_Hyphen=-y}', 'deprecated');
Expect(1, 65381, '\P{^Is_Hyphen=-y}', 'deprecated');
Expect(0, 65382, '\p{Is_Hyphen=-y}', 'deprecated');
Expect(1, 65382, '\p{^Is_Hyphen=-y}', 'deprecated');
Expect(1, 65382, '\P{Is_Hyphen=-y}', 'deprecated');
Expect(0, 65382, '\P{^Is_Hyphen=-y}', 'deprecated');
Error('\p{Hyphen=/a/_T}');
Error('\P{Hyphen=/a/_T}');
Expect(1, 65381, '\p{Hyphen=t}', 'deprecated');
Expect(0, 65381, '\p{^Hyphen=t}', 'deprecated');
Expect(0, 65381, '\P{Hyphen=t}', 'deprecated');
Expect(1, 65381, '\P{^Hyphen=t}', 'deprecated');
Expect(0, 65382, '\p{Hyphen=t}', 'deprecated');
Expect(1, 65382, '\p{^Hyphen=t}', 'deprecated');
Expect(1, 65382, '\P{Hyphen=t}', 'deprecated');
Expect(0, 65382, '\P{^Hyphen=t}', 'deprecated');
Expect(1, 65381, '\p{Hyphen=_	t}', 'deprecated');
Expect(0, 65381, '\p{^Hyphen=_	t}', 'deprecated');
Expect(0, 65381, '\P{Hyphen=_	t}', 'deprecated');
Expect(1, 65381, '\P{^Hyphen=_	t}', 'deprecated');
Expect(0, 65382, '\p{Hyphen=_	t}', 'deprecated');
Expect(1, 65382, '\p{^Hyphen=_	t}', 'deprecated');
Expect(1, 65382, '\P{Hyphen=_	t}', 'deprecated');
Expect(0, 65382, '\P{^Hyphen=_	t}', 'deprecated');
Error('\p{Is_Hyphen=-/a/true}');
Error('\P{Is_Hyphen=-/a/true}');
Expect(1, 65381, '\p{Is_Hyphen=true}', 'deprecated');
Expect(0, 65381, '\p{^Is_Hyphen=true}', 'deprecated');
Expect(0, 65381, '\P{Is_Hyphen=true}', 'deprecated');
Expect(1, 65381, '\P{^Is_Hyphen=true}', 'deprecated');
Expect(0, 65382, '\p{Is_Hyphen=true}', 'deprecated');
Expect(1, 65382, '\p{^Is_Hyphen=true}', 'deprecated');
Expect(1, 65382, '\P{Is_Hyphen=true}', 'deprecated');
Expect(0, 65382, '\P{^Is_Hyphen=true}', 'deprecated');
Expect(1, 65381, '\p{Is_Hyphen=	True}', 'deprecated');
Expect(0, 65381, '\p{^Is_Hyphen=	True}', 'deprecated');
Expect(0, 65381, '\P{Is_Hyphen=	True}', 'deprecated');
Expect(1, 65381, '\P{^Is_Hyphen=	True}', 'deprecated');
Expect(0, 65382, '\p{Is_Hyphen=	True}', 'deprecated');
Expect(1, 65382, '\p{^Is_Hyphen=	True}', 'deprecated');
Expect(1, 65382, '\P{Is_Hyphen=	True}', 'deprecated');
Expect(0, 65382, '\P{^Is_Hyphen=	True}', 'deprecated');
Error('\p{ID_Continue= /a/no}');
Error('\P{ID_Continue= /a/no}');
Expect(1, 918000, '\p{ID_Continue=no}', "");
Expect(0, 918000, '\p{^ID_Continue=no}', "");
Expect(0, 918000, '\P{ID_Continue=no}', "");
Expect(1, 918000, '\P{^ID_Continue=no}', "");
Expect(0, 917999, '\p{ID_Continue=no}', "");
Expect(1, 917999, '\p{^ID_Continue=no}', "");
Expect(1, 917999, '\P{ID_Continue=no}', "");
Expect(0, 917999, '\P{^ID_Continue=no}', "");
Expect(1, 918000, '\p{ID_Continue=-	No}', "");
Expect(0, 918000, '\p{^ID_Continue=-	No}', "");
Expect(0, 918000, '\P{ID_Continue=-	No}', "");
Expect(1, 918000, '\P{^ID_Continue=-	No}', "");
Expect(0, 917999, '\p{ID_Continue=-	No}', "");
Expect(1, 917999, '\p{^ID_Continue=-	No}', "");
Expect(1, 917999, '\P{ID_Continue=-	No}', "");
Expect(0, 917999, '\P{^ID_Continue=-	No}', "");
Error('\p{IDC:  N:=}');
Error('\P{IDC:  N:=}');
Expect(1, 918000, '\p{IDC:	n}', "");
Expect(0, 918000, '\p{^IDC:	n}', "");
Expect(0, 918000, '\P{IDC:	n}', "");
Expect(1, 918000, '\P{^IDC:	n}', "");
Expect(0, 917999, '\p{IDC:	n}', "");
Expect(1, 917999, '\p{^IDC:	n}', "");
Expect(1, 917999, '\P{IDC:	n}', "");
Expect(0, 917999, '\P{^IDC:	n}', "");
Expect(1, 918000, '\p{IDC=_ n}', "");
Expect(0, 918000, '\p{^IDC=_ n}', "");
Expect(0, 918000, '\P{IDC=_ n}', "");
Expect(1, 918000, '\P{^IDC=_ n}', "");
Expect(0, 917999, '\p{IDC=_ n}', "");
Expect(1, 917999, '\p{^IDC=_ n}', "");
Expect(1, 917999, '\P{IDC=_ n}', "");
Expect(0, 917999, '\P{^IDC=_ n}', "");
Error('\p{Is_ID_Continue= F:=}');
Error('\P{Is_ID_Continue= F:=}');
Expect(1, 918000, '\p{Is_ID_Continue=f}', "");
Expect(0, 918000, '\p{^Is_ID_Continue=f}', "");
Expect(0, 918000, '\P{Is_ID_Continue=f}', "");
Expect(1, 918000, '\P{^Is_ID_Continue=f}', "");
Expect(0, 917999, '\p{Is_ID_Continue=f}', "");
Expect(1, 917999, '\p{^Is_ID_Continue=f}', "");
Expect(1, 917999, '\P{Is_ID_Continue=f}', "");
Expect(0, 917999, '\P{^Is_ID_Continue=f}', "");
Expect(1, 918000, '\p{Is_ID_Continue=--F}', "");
Expect(0, 918000, '\p{^Is_ID_Continue=--F}', "");
Expect(0, 918000, '\P{Is_ID_Continue=--F}', "");
Expect(1, 918000, '\P{^Is_ID_Continue=--F}', "");
Expect(0, 917999, '\p{Is_ID_Continue=--F}', "");
Expect(1, 917999, '\p{^Is_ID_Continue=--F}', "");
Expect(1, 917999, '\P{Is_ID_Continue=--F}', "");
Expect(0, 917999, '\P{^Is_ID_Continue=--F}', "");
Error('\p{Is_IDC=_:=false}');
Error('\P{Is_IDC=_:=false}');
Expect(1, 918000, '\p{Is_IDC=false}', "");
Expect(0, 918000, '\p{^Is_IDC=false}', "");
Expect(0, 918000, '\P{Is_IDC=false}', "");
Expect(1, 918000, '\P{^Is_IDC=false}', "");
Expect(0, 917999, '\p{Is_IDC=false}', "");
Expect(1, 917999, '\p{^Is_IDC=false}', "");
Expect(1, 917999, '\P{Is_IDC=false}', "");
Expect(0, 917999, '\P{^Is_IDC=false}', "");
Expect(1, 918000, '\p{Is_IDC= _False}', "");
Expect(0, 918000, '\p{^Is_IDC= _False}', "");
Expect(0, 918000, '\P{Is_IDC= _False}', "");
Expect(1, 918000, '\P{^Is_IDC= _False}', "");
Expect(0, 917999, '\p{Is_IDC= _False}', "");
Expect(1, 917999, '\p{^Is_IDC= _False}', "");
Expect(1, 917999, '\P{Is_IDC= _False}', "");
Expect(0, 917999, '\P{^Is_IDC= _False}', "");
Error('\p{ID_Continue=:=  Yes}');
Error('\P{ID_Continue=:=  Yes}');
Expect(1, 917999, '\p{ID_Continue=yes}', "");
Expect(0, 917999, '\p{^ID_Continue=yes}', "");
Expect(0, 917999, '\P{ID_Continue=yes}', "");
Expect(1, 917999, '\P{^ID_Continue=yes}', "");
Expect(0, 918000, '\p{ID_Continue=yes}', "");
Expect(1, 918000, '\p{^ID_Continue=yes}', "");
Expect(1, 918000, '\P{ID_Continue=yes}', "");
Expect(0, 918000, '\P{^ID_Continue=yes}', "");
Expect(1, 917999, '\p{ID_Continue=__yes}', "");
Expect(0, 917999, '\p{^ID_Continue=__yes}', "");
Expect(0, 917999, '\P{ID_Continue=__yes}', "");
Expect(1, 917999, '\P{^ID_Continue=__yes}', "");
Expect(0, 918000, '\p{ID_Continue=__yes}', "");
Expect(1, 918000, '\p{^ID_Continue=__yes}', "");
Expect(1, 918000, '\P{ID_Continue=__yes}', "");
Expect(0, 918000, '\P{^ID_Continue=__yes}', "");
Error('\p{IDC=:=Y}');
Error('\P{IDC=:=Y}');
Expect(1, 917999, '\p{IDC=y}', "");
Expect(0, 917999, '\p{^IDC=y}', "");
Expect(0, 917999, '\P{IDC=y}', "");
Expect(1, 917999, '\P{^IDC=y}', "");
Expect(0, 918000, '\p{IDC=y}', "");
Expect(1, 918000, '\p{^IDC=y}', "");
Expect(1, 918000, '\P{IDC=y}', "");
Expect(0, 918000, '\P{^IDC=y}', "");
Expect(1, 917999, '\p{IDC=-_Y}', "");
Expect(0, 917999, '\p{^IDC=-_Y}', "");
Expect(0, 917999, '\P{IDC=-_Y}', "");
Expect(1, 917999, '\P{^IDC=-_Y}', "");
Expect(0, 918000, '\p{IDC=-_Y}', "");
Expect(1, 918000, '\p{^IDC=-_Y}', "");
Expect(1, 918000, '\P{IDC=-_Y}', "");
Expect(0, 918000, '\P{^IDC=-_Y}', "");
Error('\p{Is_ID_Continue=	-T/a/}');
Error('\P{Is_ID_Continue=	-T/a/}');
Expect(1, 917999, '\p{Is_ID_Continue=t}', "");
Expect(0, 917999, '\p{^Is_ID_Continue=t}', "");
Expect(0, 917999, '\P{Is_ID_Continue=t}', "");
Expect(1, 917999, '\P{^Is_ID_Continue=t}', "");
Expect(0, 918000, '\p{Is_ID_Continue=t}', "");
Expect(1, 918000, '\p{^Is_ID_Continue=t}', "");
Expect(1, 918000, '\P{Is_ID_Continue=t}', "");
Expect(0, 918000, '\P{^Is_ID_Continue=t}', "");
Expect(1, 917999, '\p{Is_ID_Continue:_T}', "");
Expect(0, 917999, '\p{^Is_ID_Continue:_T}', "");
Expect(0, 917999, '\P{Is_ID_Continue:_T}', "");
Expect(1, 917999, '\P{^Is_ID_Continue:_T}', "");
Expect(0, 918000, '\p{Is_ID_Continue:_T}', "");
Expect(1, 918000, '\p{^Is_ID_Continue:_T}', "");
Expect(1, 918000, '\P{Is_ID_Continue:_T}', "");
Expect(0, 918000, '\P{^Is_ID_Continue:_T}', "");
Error('\p{Is_IDC=_:=true}');
Error('\P{Is_IDC=_:=true}');
Expect(1, 917999, '\p{Is_IDC=true}', "");
Expect(0, 917999, '\p{^Is_IDC=true}', "");
Expect(0, 917999, '\P{Is_IDC=true}', "");
Expect(1, 917999, '\P{^Is_IDC=true}', "");
Expect(0, 918000, '\p{Is_IDC=true}', "");
Expect(1, 918000, '\p{^Is_IDC=true}', "");
Expect(1, 918000, '\P{Is_IDC=true}', "");
Expect(0, 918000, '\P{^Is_IDC=true}', "");
Expect(1, 917999, '\p{Is_IDC=True}', "");
Expect(0, 917999, '\p{^Is_IDC=True}', "");
Expect(0, 917999, '\P{Is_IDC=True}', "");
Expect(1, 917999, '\P{^Is_IDC=True}', "");
Expect(0, 918000, '\p{Is_IDC=True}', "");
Expect(1, 918000, '\p{^Is_IDC=True}', "");
Expect(1, 918000, '\P{Is_IDC=True}', "");
Expect(0, 918000, '\P{^Is_IDC=True}', "");
Error('\p{ID_Start=/a/- No}');
Error('\P{ID_Start=/a/- No}');
Expect(1, 195102, '\p{ID_Start=no}', "");
Expect(0, 195102, '\p{^ID_Start=no}', "");
Expect(0, 195102, '\P{ID_Start=no}', "");
Expect(1, 195102, '\P{^ID_Start=no}', "");
Expect(0, 195101, '\p{ID_Start=no}', "");
Expect(1, 195101, '\p{^ID_Start=no}', "");
Expect(1, 195101, '\P{ID_Start=no}', "");
Expect(0, 195101, '\P{^ID_Start=no}', "");
Expect(1, 195102, '\p{ID_Start=--NO}', "");
Expect(0, 195102, '\p{^ID_Start=--NO}', "");
Expect(0, 195102, '\P{ID_Start=--NO}', "");
Expect(1, 195102, '\P{^ID_Start=--NO}', "");
Expect(0, 195101, '\p{ID_Start=--NO}', "");
Expect(1, 195101, '\p{^ID_Start=--NO}', "");
Expect(1, 195101, '\P{ID_Start=--NO}', "");
Expect(0, 195101, '\P{^ID_Start=--NO}', "");
Error('\p{IDS=	:=N}');
Error('\P{IDS=	:=N}');
Expect(1, 195102, '\p{IDS=n}', "");
Expect(0, 195102, '\p{^IDS=n}', "");
Expect(0, 195102, '\P{IDS=n}', "");
Expect(1, 195102, '\P{^IDS=n}', "");
Expect(0, 195101, '\p{IDS=n}', "");
Expect(1, 195101, '\p{^IDS=n}', "");
Expect(1, 195101, '\P{IDS=n}', "");
Expect(0, 195101, '\P{^IDS=n}', "");
Expect(1, 195102, '\p{IDS=-N}', "");
Expect(0, 195102, '\p{^IDS=-N}', "");
Expect(0, 195102, '\P{IDS=-N}', "");
Expect(1, 195102, '\P{^IDS=-N}', "");
Expect(0, 195101, '\p{IDS=-N}', "");
Expect(1, 195101, '\p{^IDS=-N}', "");
Expect(1, 195101, '\P{IDS=-N}', "");
Expect(0, 195101, '\P{^IDS=-N}', "");
Error('\p{Is_ID_Start= _F/a/}');
Error('\P{Is_ID_Start= _F/a/}');
Expect(1, 195102, '\p{Is_ID_Start=f}', "");
Expect(0, 195102, '\p{^Is_ID_Start=f}', "");
Expect(0, 195102, '\P{Is_ID_Start=f}', "");
Expect(1, 195102, '\P{^Is_ID_Start=f}', "");
Expect(0, 195101, '\p{Is_ID_Start=f}', "");
Expect(1, 195101, '\p{^Is_ID_Start=f}', "");
Expect(1, 195101, '\P{Is_ID_Start=f}', "");
Expect(0, 195101, '\P{^Is_ID_Start=f}', "");
Expect(1, 195102, '\p{Is_ID_Start=-	F}', "");
Expect(0, 195102, '\p{^Is_ID_Start=-	F}', "");
Expect(0, 195102, '\P{Is_ID_Start=-	F}', "");
Expect(1, 195102, '\P{^Is_ID_Start=-	F}', "");
Expect(0, 195101, '\p{Is_ID_Start=-	F}', "");
Expect(1, 195101, '\p{^Is_ID_Start=-	F}', "");
Expect(1, 195101, '\P{Is_ID_Start=-	F}', "");
Expect(0, 195101, '\P{^Is_ID_Start=-	F}', "");
Error('\p{Is_IDS= 	False:=}');
Error('\P{Is_IDS= 	False:=}');
Expect(1, 195102, '\p{Is_IDS=false}', "");
Expect(0, 195102, '\p{^Is_IDS=false}', "");
Expect(0, 195102, '\P{Is_IDS=false}', "");
Expect(1, 195102, '\P{^Is_IDS=false}', "");
Expect(0, 195101, '\p{Is_IDS=false}', "");
Expect(1, 195101, '\p{^Is_IDS=false}', "");
Expect(1, 195101, '\P{Is_IDS=false}', "");
Expect(0, 195101, '\P{^Is_IDS=false}', "");
Expect(1, 195102, '\p{Is_IDS= FALSE}', "");
Expect(0, 195102, '\p{^Is_IDS= FALSE}', "");
Expect(0, 195102, '\P{Is_IDS= FALSE}', "");
Expect(1, 195102, '\P{^Is_IDS= FALSE}', "");
Expect(0, 195101, '\p{Is_IDS= FALSE}', "");
Expect(1, 195101, '\p{^Is_IDS= FALSE}', "");
Expect(1, 195101, '\P{Is_IDS= FALSE}', "");
Expect(0, 195101, '\P{^Is_IDS= FALSE}', "");
Error('\p{ID_Start=:=		YES}');
Error('\P{ID_Start=:=		YES}');
Expect(1, 195101, '\p{ID_Start=yes}', "");
Expect(0, 195101, '\p{^ID_Start=yes}', "");
Expect(0, 195101, '\P{ID_Start=yes}', "");
Expect(1, 195101, '\P{^ID_Start=yes}', "");
Expect(0, 195102, '\p{ID_Start=yes}', "");
Expect(1, 195102, '\p{^ID_Start=yes}', "");
Expect(1, 195102, '\P{ID_Start=yes}', "");
Expect(0, 195102, '\P{^ID_Start=yes}', "");
Expect(1, 195101, '\p{ID_Start= _YES}', "");
Expect(0, 195101, '\p{^ID_Start= _YES}', "");
Expect(0, 195101, '\P{ID_Start= _YES}', "");
Expect(1, 195101, '\P{^ID_Start= _YES}', "");
Expect(0, 195102, '\p{ID_Start= _YES}', "");
Expect(1, 195102, '\p{^ID_Start= _YES}', "");
Expect(1, 195102, '\P{ID_Start= _YES}', "");
Expect(0, 195102, '\P{^ID_Start= _YES}', "");
Error('\p{IDS=-	y:=}');
Error('\P{IDS=-	y:=}');
Expect(1, 195101, '\p{IDS=y}', "");
Expect(0, 195101, '\p{^IDS=y}', "");
Expect(0, 195101, '\P{IDS=y}', "");
Expect(1, 195101, '\P{^IDS=y}', "");
Expect(0, 195102, '\p{IDS=y}', "");
Expect(1, 195102, '\p{^IDS=y}', "");
Expect(1, 195102, '\P{IDS=y}', "");
Expect(0, 195102, '\P{^IDS=y}', "");
Expect(1, 195101, '\p{IDS=_-Y}', "");
Expect(0, 195101, '\p{^IDS=_-Y}', "");
Expect(0, 195101, '\P{IDS=_-Y}', "");
Expect(1, 195101, '\P{^IDS=_-Y}', "");
Expect(0, 195102, '\p{IDS=_-Y}', "");
Expect(1, 195102, '\p{^IDS=_-Y}', "");
Expect(1, 195102, '\P{IDS=_-Y}', "");
Expect(0, 195102, '\P{^IDS=_-Y}', "");
Error('\p{Is_ID_Start=	/a/T}');
Error('\P{Is_ID_Start=	/a/T}');
Expect(1, 195101, '\p{Is_ID_Start:	t}', "");
Expect(0, 195101, '\p{^Is_ID_Start:	t}', "");
Expect(0, 195101, '\P{Is_ID_Start:	t}', "");
Expect(1, 195101, '\P{^Is_ID_Start:	t}', "");
Expect(0, 195102, '\p{Is_ID_Start:	t}', "");
Expect(1, 195102, '\p{^Is_ID_Start:	t}', "");
Expect(1, 195102, '\P{Is_ID_Start:	t}', "");
Expect(0, 195102, '\P{^Is_ID_Start:	t}', "");
Expect(1, 195101, '\p{Is_ID_Start=_ T}', "");
Expect(0, 195101, '\p{^Is_ID_Start=_ T}', "");
Expect(0, 195101, '\P{Is_ID_Start=_ T}', "");
Expect(1, 195101, '\P{^Is_ID_Start=_ T}', "");
Expect(0, 195102, '\p{Is_ID_Start=_ T}', "");
Expect(1, 195102, '\p{^Is_ID_Start=_ T}', "");
Expect(1, 195102, '\P{Is_ID_Start=_ T}', "");
Expect(0, 195102, '\P{^Is_ID_Start=_ T}', "");
Error('\p{Is_IDS:	_True/a/}');
Error('\P{Is_IDS:	_True/a/}');
Expect(1, 195101, '\p{Is_IDS:	true}', "");
Expect(0, 195101, '\p{^Is_IDS:	true}', "");
Expect(0, 195101, '\P{Is_IDS:	true}', "");
Expect(1, 195101, '\P{^Is_IDS:	true}', "");
Expect(0, 195102, '\p{Is_IDS:	true}', "");
Expect(1, 195102, '\p{^Is_IDS:	true}', "");
Expect(1, 195102, '\P{Is_IDS:	true}', "");
Expect(0, 195102, '\P{^Is_IDS:	true}', "");
Expect(1, 195101, '\p{Is_IDS:	_True}', "");
Expect(0, 195101, '\p{^Is_IDS:	_True}', "");
Expect(0, 195101, '\P{Is_IDS:	_True}', "");
Expect(1, 195101, '\P{^Is_IDS:	_True}', "");
Expect(0, 195102, '\p{Is_IDS:	_True}', "");
Expect(1, 195102, '\p{^Is_IDS:	_True}', "");
Expect(1, 195102, '\P{Is_IDS:	_True}', "");
Expect(0, 195102, '\P{^Is_IDS:	_True}', "");
Error('\p{IDS_Binary_Operator=	NO/a/}');
Error('\P{IDS_Binary_Operator=	NO/a/}');
Expect(1, 12284, '\p{IDS_Binary_Operator=no}', "");
Expect(0, 12284, '\p{^IDS_Binary_Operator=no}', "");
Expect(0, 12284, '\P{IDS_Binary_Operator=no}', "");
Expect(1, 12284, '\P{^IDS_Binary_Operator=no}', "");
Expect(0, 12283, '\p{IDS_Binary_Operator=no}', "");
Expect(1, 12283, '\p{^IDS_Binary_Operator=no}', "");
Expect(1, 12283, '\P{IDS_Binary_Operator=no}', "");
Expect(0, 12283, '\P{^IDS_Binary_Operator=no}', "");
Expect(1, 12284, '\p{IDS_Binary_Operator=-NO}', "");
Expect(0, 12284, '\p{^IDS_Binary_Operator=-NO}', "");
Expect(0, 12284, '\P{IDS_Binary_Operator=-NO}', "");
Expect(1, 12284, '\P{^IDS_Binary_Operator=-NO}', "");
Expect(0, 12283, '\p{IDS_Binary_Operator=-NO}', "");
Expect(1, 12283, '\p{^IDS_Binary_Operator=-NO}', "");
Expect(1, 12283, '\P{IDS_Binary_Operator=-NO}', "");
Expect(0, 12283, '\P{^IDS_Binary_Operator=-NO}', "");
Error('\p{IDSB:   --N/a/}');
Error('\P{IDSB:   --N/a/}');
Expect(1, 12284, '\p{IDSB:n}', "");
Expect(0, 12284, '\p{^IDSB:n}', "");
Expect(0, 12284, '\P{IDSB:n}', "");
Expect(1, 12284, '\P{^IDSB:n}', "");
Expect(0, 12283, '\p{IDSB:n}', "");
Expect(1, 12283, '\p{^IDSB:n}', "");
Expect(1, 12283, '\P{IDSB:n}', "");
Expect(0, 12283, '\P{^IDSB:n}', "");
Expect(1, 12284, '\p{IDSB=	-n}', "");
Expect(0, 12284, '\p{^IDSB=	-n}', "");
Expect(0, 12284, '\P{IDSB=	-n}', "");
Expect(1, 12284, '\P{^IDSB=	-n}', "");
Expect(0, 12283, '\p{IDSB=	-n}', "");
Expect(1, 12283, '\p{^IDSB=	-n}', "");
Expect(1, 12283, '\P{IDSB=	-n}', "");
Expect(0, 12283, '\P{^IDSB=	-n}', "");
Error('\p{Is_IDS_Binary_Operator= _F/a/}');
Error('\P{Is_IDS_Binary_Operator= _F/a/}');
Expect(1, 12284, '\p{Is_IDS_Binary_Operator=f}', "");
Expect(0, 12284, '\p{^Is_IDS_Binary_Operator=f}', "");
Expect(0, 12284, '\P{Is_IDS_Binary_Operator=f}', "");
Expect(1, 12284, '\P{^Is_IDS_Binary_Operator=f}', "");
Expect(0, 12283, '\p{Is_IDS_Binary_Operator=f}', "");
Expect(1, 12283, '\p{^Is_IDS_Binary_Operator=f}', "");
Expect(1, 12283, '\P{Is_IDS_Binary_Operator=f}', "");
Expect(0, 12283, '\P{^Is_IDS_Binary_Operator=f}', "");
Expect(1, 12284, '\p{Is_IDS_Binary_Operator:   -	f}', "");
Expect(0, 12284, '\p{^Is_IDS_Binary_Operator:   -	f}', "");
Expect(0, 12284, '\P{Is_IDS_Binary_Operator:   -	f}', "");
Expect(1, 12284, '\P{^Is_IDS_Binary_Operator:   -	f}', "");
Expect(0, 12283, '\p{Is_IDS_Binary_Operator:   -	f}', "");
Expect(1, 12283, '\p{^Is_IDS_Binary_Operator:   -	f}', "");
Expect(1, 12283, '\P{Is_IDS_Binary_Operator:   -	f}', "");
Expect(0, 12283, '\P{^Is_IDS_Binary_Operator:   -	f}', "");
Error('\p{Is_IDSB=	/a/False}');
Error('\P{Is_IDSB=	/a/False}');
Expect(1, 12284, '\p{Is_IDSB=false}', "");
Expect(0, 12284, '\p{^Is_IDSB=false}', "");
Expect(0, 12284, '\P{Is_IDSB=false}', "");
Expect(1, 12284, '\P{^Is_IDSB=false}', "");
Expect(0, 12283, '\p{Is_IDSB=false}', "");
Expect(1, 12283, '\p{^Is_IDSB=false}', "");
Expect(1, 12283, '\P{Is_IDSB=false}', "");
Expect(0, 12283, '\P{^Is_IDSB=false}', "");
Expect(1, 12284, '\p{Is_IDSB=FALSE}', "");
Expect(0, 12284, '\p{^Is_IDSB=FALSE}', "");
Expect(0, 12284, '\P{Is_IDSB=FALSE}', "");
Expect(1, 12284, '\P{^Is_IDSB=FALSE}', "");
Expect(0, 12283, '\p{Is_IDSB=FALSE}', "");
Expect(1, 12283, '\p{^Is_IDSB=FALSE}', "");
Expect(1, 12283, '\P{Is_IDSB=FALSE}', "");
Expect(0, 12283, '\P{^Is_IDSB=FALSE}', "");
Error('\p{IDS_Binary_Operator= _Yes:=}');
Error('\P{IDS_Binary_Operator= _Yes:=}');
Expect(1, 12283, '\p{IDS_Binary_Operator=yes}', "");
Expect(0, 12283, '\p{^IDS_Binary_Operator=yes}', "");
Expect(0, 12283, '\P{IDS_Binary_Operator=yes}', "");
Expect(1, 12283, '\P{^IDS_Binary_Operator=yes}', "");
Expect(0, 12284, '\p{IDS_Binary_Operator=yes}', "");
Expect(1, 12284, '\p{^IDS_Binary_Operator=yes}', "");
Expect(1, 12284, '\P{IDS_Binary_Operator=yes}', "");
Expect(0, 12284, '\P{^IDS_Binary_Operator=yes}', "");
Expect(1, 12283, '\p{IDS_Binary_Operator=Yes}', "");
Expect(0, 12283, '\p{^IDS_Binary_Operator=Yes}', "");
Expect(0, 12283, '\P{IDS_Binary_Operator=Yes}', "");
Expect(1, 12283, '\P{^IDS_Binary_Operator=Yes}', "");
Expect(0, 12284, '\p{IDS_Binary_Operator=Yes}', "");
Expect(1, 12284, '\p{^IDS_Binary_Operator=Yes}', "");
Expect(1, 12284, '\P{IDS_Binary_Operator=Yes}', "");
Expect(0, 12284, '\P{^IDS_Binary_Operator=Yes}', "");
Error('\p{IDSB=- Y:=}');
Error('\P{IDSB=- Y:=}');
Expect(1, 12283, '\p{IDSB=y}', "");
Expect(0, 12283, '\p{^IDSB=y}', "");
Expect(0, 12283, '\P{IDSB=y}', "");
Expect(1, 12283, '\P{^IDSB=y}', "");
Expect(0, 12284, '\p{IDSB=y}', "");
Expect(1, 12284, '\p{^IDSB=y}', "");
Expect(1, 12284, '\P{IDSB=y}', "");
Expect(0, 12284, '\P{^IDSB=y}', "");
Expect(1, 12283, '\p{IDSB=_y}', "");
Expect(0, 12283, '\p{^IDSB=_y}', "");
Expect(0, 12283, '\P{IDSB=_y}', "");
Expect(1, 12283, '\P{^IDSB=_y}', "");
Expect(0, 12284, '\p{IDSB=_y}', "");
Expect(1, 12284, '\p{^IDSB=_y}', "");
Expect(1, 12284, '\P{IDSB=_y}', "");
Expect(0, 12284, '\P{^IDSB=_y}', "");
Error('\p{Is_IDS_Binary_Operator= :=T}');
Error('\P{Is_IDS_Binary_Operator= :=T}');
Expect(1, 12283, '\p{Is_IDS_Binary_Operator:	t}', "");
Expect(0, 12283, '\p{^Is_IDS_Binary_Operator:	t}', "");
Expect(0, 12283, '\P{Is_IDS_Binary_Operator:	t}', "");
Expect(1, 12283, '\P{^Is_IDS_Binary_Operator:	t}', "");
Expect(0, 12284, '\p{Is_IDS_Binary_Operator:	t}', "");
Expect(1, 12284, '\p{^Is_IDS_Binary_Operator:	t}', "");
Expect(1, 12284, '\P{Is_IDS_Binary_Operator:	t}', "");
Expect(0, 12284, '\P{^Is_IDS_Binary_Operator:	t}', "");
Expect(1, 12283, '\p{Is_IDS_Binary_Operator=__T}', "");
Expect(0, 12283, '\p{^Is_IDS_Binary_Operator=__T}', "");
Expect(0, 12283, '\P{Is_IDS_Binary_Operator=__T}', "");
Expect(1, 12283, '\P{^Is_IDS_Binary_Operator=__T}', "");
Expect(0, 12284, '\p{Is_IDS_Binary_Operator=__T}', "");
Expect(1, 12284, '\p{^Is_IDS_Binary_Operator=__T}', "");
Expect(1, 12284, '\P{Is_IDS_Binary_Operator=__T}', "");
Expect(0, 12284, '\P{^Is_IDS_Binary_Operator=__T}', "");
Error('\p{Is_IDSB=- true/a/}');
Error('\P{Is_IDSB=- true/a/}');
Expect(1, 12283, '\p{Is_IDSB=true}', "");
Expect(0, 12283, '\p{^Is_IDSB=true}', "");
Expect(0, 12283, '\P{Is_IDSB=true}', "");
Expect(1, 12283, '\P{^Is_IDSB=true}', "");
Expect(0, 12284, '\p{Is_IDSB=true}', "");
Expect(1, 12284, '\p{^Is_IDSB=true}', "");
Expect(1, 12284, '\P{Is_IDSB=true}', "");
Expect(0, 12284, '\P{^Is_IDSB=true}', "");
Expect(1, 12283, '\p{Is_IDSB: -TRUE}', "");
Expect(0, 12283, '\p{^Is_IDSB: -TRUE}', "");
Expect(0, 12283, '\P{Is_IDSB: -TRUE}', "");
Expect(1, 12283, '\P{^Is_IDSB: -TRUE}', "");
Expect(0, 12284, '\p{Is_IDSB: -TRUE}', "");
Expect(1, 12284, '\p{^Is_IDSB: -TRUE}', "");
Expect(1, 12284, '\P{Is_IDSB: -TRUE}', "");
Expect(0, 12284, '\P{^Is_IDSB: -TRUE}', "");
Error('\p{IDS_Trinary_Operator=	:=No}');
Error('\P{IDS_Trinary_Operator=	:=No}');
Expect(1, 12276, '\p{IDS_Trinary_Operator=no}', "");
Expect(0, 12276, '\p{^IDS_Trinary_Operator=no}', "");
Expect(0, 12276, '\P{IDS_Trinary_Operator=no}', "");
Expect(1, 12276, '\P{^IDS_Trinary_Operator=no}', "");
Expect(0, 12275, '\p{IDS_Trinary_Operator=no}', "");
Expect(1, 12275, '\p{^IDS_Trinary_Operator=no}', "");
Expect(1, 12275, '\P{IDS_Trinary_Operator=no}', "");
Expect(0, 12275, '\P{^IDS_Trinary_Operator=no}', "");
Expect(1, 12276, '\p{IDS_Trinary_Operator=	No}', "");
Expect(0, 12276, '\p{^IDS_Trinary_Operator=	No}', "");
Expect(0, 12276, '\P{IDS_Trinary_Operator=	No}', "");
Expect(1, 12276, '\P{^IDS_Trinary_Operator=	No}', "");
Expect(0, 12275, '\p{IDS_Trinary_Operator=	No}', "");
Expect(1, 12275, '\p{^IDS_Trinary_Operator=	No}', "");
Expect(1, 12275, '\P{IDS_Trinary_Operator=	No}', "");
Expect(0, 12275, '\P{^IDS_Trinary_Operator=	No}', "");
Error('\p{IDST=/a/__N}');
Error('\P{IDST=/a/__N}');
Expect(1, 12276, '\p{IDST=n}', "");
Expect(0, 12276, '\p{^IDST=n}', "");
Expect(0, 12276, '\P{IDST=n}', "");
Expect(1, 12276, '\P{^IDST=n}', "");
Expect(0, 12275, '\p{IDST=n}', "");
Expect(1, 12275, '\p{^IDST=n}', "");
Expect(1, 12275, '\P{IDST=n}', "");
Expect(0, 12275, '\P{^IDST=n}', "");
Expect(1, 12276, '\p{IDST=_	N}', "");
Expect(0, 12276, '\p{^IDST=_	N}', "");
Expect(0, 12276, '\P{IDST=_	N}', "");
Expect(1, 12276, '\P{^IDST=_	N}', "");
Expect(0, 12275, '\p{IDST=_	N}', "");
Expect(1, 12275, '\p{^IDST=_	N}', "");
Expect(1, 12275, '\P{IDST=_	N}', "");
Expect(0, 12275, '\P{^IDST=_	N}', "");
Error('\p{Is_IDS_Trinary_Operator=-:=F}');
Error('\P{Is_IDS_Trinary_Operator=-:=F}');
Expect(1, 12276, '\p{Is_IDS_Trinary_Operator=f}', "");
Expect(0, 12276, '\p{^Is_IDS_Trinary_Operator=f}', "");
Expect(0, 12276, '\P{Is_IDS_Trinary_Operator=f}', "");
Expect(1, 12276, '\P{^Is_IDS_Trinary_Operator=f}', "");
Expect(0, 12275, '\p{Is_IDS_Trinary_Operator=f}', "");
Expect(1, 12275, '\p{^Is_IDS_Trinary_Operator=f}', "");
Expect(1, 12275, '\P{Is_IDS_Trinary_Operator=f}', "");
Expect(0, 12275, '\P{^Is_IDS_Trinary_Operator=f}', "");
Expect(1, 12276, '\p{Is_IDS_Trinary_Operator=_F}', "");
Expect(0, 12276, '\p{^Is_IDS_Trinary_Operator=_F}', "");
Expect(0, 12276, '\P{Is_IDS_Trinary_Operator=_F}', "");
Expect(1, 12276, '\P{^Is_IDS_Trinary_Operator=_F}', "");
Expect(0, 12275, '\p{Is_IDS_Trinary_Operator=_F}', "");
Expect(1, 12275, '\p{^Is_IDS_Trinary_Operator=_F}', "");
Expect(1, 12275, '\P{Is_IDS_Trinary_Operator=_F}', "");
Expect(0, 12275, '\P{^Is_IDS_Trinary_Operator=_F}', "");
Error('\p{Is_IDST=:=--False}');
Error('\P{Is_IDST=:=--False}');
Expect(1, 12276, '\p{Is_IDST=false}', "");
Expect(0, 12276, '\p{^Is_IDST=false}', "");
Expect(0, 12276, '\P{Is_IDST=false}', "");
Expect(1, 12276, '\P{^Is_IDST=false}', "");
Expect(0, 12275, '\p{Is_IDST=false}', "");
Expect(1, 12275, '\p{^Is_IDST=false}', "");
Expect(1, 12275, '\P{Is_IDST=false}', "");
Expect(0, 12275, '\P{^Is_IDST=false}', "");
Expect(1, 12276, '\p{Is_IDST=_-False}', "");
Expect(0, 12276, '\p{^Is_IDST=_-False}', "");
Expect(0, 12276, '\P{Is_IDST=_-False}', "");
Expect(1, 12276, '\P{^Is_IDST=_-False}', "");
Expect(0, 12275, '\p{Is_IDST=_-False}', "");
Expect(1, 12275, '\p{^Is_IDST=_-False}', "");
Expect(1, 12275, '\P{Is_IDST=_-False}', "");
Expect(0, 12275, '\P{^Is_IDST=_-False}', "");
Error('\p{IDS_Trinary_Operator=/a/-Yes}');
Error('\P{IDS_Trinary_Operator=/a/-Yes}');
Expect(1, 12275, '\p{IDS_Trinary_Operator:	yes}', "");
Expect(0, 12275, '\p{^IDS_Trinary_Operator:	yes}', "");
Expect(0, 12275, '\P{IDS_Trinary_Operator:	yes}', "");
Expect(1, 12275, '\P{^IDS_Trinary_Operator:	yes}', "");
Expect(0, 12276, '\p{IDS_Trinary_Operator:	yes}', "");
Expect(1, 12276, '\p{^IDS_Trinary_Operator:	yes}', "");
Expect(1, 12276, '\P{IDS_Trinary_Operator:	yes}', "");
Expect(0, 12276, '\P{^IDS_Trinary_Operator:	yes}', "");
Expect(1, 12275, '\p{IDS_Trinary_Operator=-Yes}', "");
Expect(0, 12275, '\p{^IDS_Trinary_Operator=-Yes}', "");
Expect(0, 12275, '\P{IDS_Trinary_Operator=-Yes}', "");
Expect(1, 12275, '\P{^IDS_Trinary_Operator=-Yes}', "");
Expect(0, 12276, '\p{IDS_Trinary_Operator=-Yes}', "");
Expect(1, 12276, '\p{^IDS_Trinary_Operator=-Yes}', "");
Expect(1, 12276, '\P{IDS_Trinary_Operator=-Yes}', "");
Expect(0, 12276, '\P{^IDS_Trinary_Operator=-Yes}', "");
Error('\p{IDST= /a/Y}');
Error('\P{IDST= /a/Y}');
Expect(1, 12275, '\p{IDST=y}', "");
Expect(0, 12275, '\p{^IDST=y}', "");
Expect(0, 12275, '\P{IDST=y}', "");
Expect(1, 12275, '\P{^IDST=y}', "");
Expect(0, 12276, '\p{IDST=y}', "");
Expect(1, 12276, '\p{^IDST=y}', "");
Expect(1, 12276, '\P{IDST=y}', "");
Expect(0, 12276, '\P{^IDST=y}', "");
Expect(1, 12275, '\p{IDST=-_Y}', "");
Expect(0, 12275, '\p{^IDST=-_Y}', "");
Expect(0, 12275, '\P{IDST=-_Y}', "");
Expect(1, 12275, '\P{^IDST=-_Y}', "");
Expect(0, 12276, '\p{IDST=-_Y}', "");
Expect(1, 12276, '\p{^IDST=-_Y}', "");
Expect(1, 12276, '\P{IDST=-_Y}', "");
Expect(0, 12276, '\P{^IDST=-_Y}', "");
Error('\p{Is_IDS_Trinary_Operator: 	/a/T}');
Error('\P{Is_IDS_Trinary_Operator: 	/a/T}');
Expect(1, 12275, '\p{Is_IDS_Trinary_Operator=t}', "");
Expect(0, 12275, '\p{^Is_IDS_Trinary_Operator=t}', "");
Expect(0, 12275, '\P{Is_IDS_Trinary_Operator=t}', "");
Expect(1, 12275, '\P{^Is_IDS_Trinary_Operator=t}', "");
Expect(0, 12276, '\p{Is_IDS_Trinary_Operator=t}', "");
Expect(1, 12276, '\p{^Is_IDS_Trinary_Operator=t}', "");
Expect(1, 12276, '\P{Is_IDS_Trinary_Operator=t}', "");
Expect(0, 12276, '\P{^Is_IDS_Trinary_Operator=t}', "");
Expect(1, 12275, '\p{Is_IDS_Trinary_Operator=- T}', "");
Expect(0, 12275, '\p{^Is_IDS_Trinary_Operator=- T}', "");
Expect(0, 12275, '\P{Is_IDS_Trinary_Operator=- T}', "");
Expect(1, 12275, '\P{^Is_IDS_Trinary_Operator=- T}', "");
Expect(0, 12276, '\p{Is_IDS_Trinary_Operator=- T}', "");
Expect(1, 12276, '\p{^Is_IDS_Trinary_Operator=- T}', "");
Expect(1, 12276, '\P{Is_IDS_Trinary_Operator=- T}', "");
Expect(0, 12276, '\P{^Is_IDS_Trinary_Operator=- T}', "");
Error('\p{Is_IDST=:=-true}');
Error('\P{Is_IDST=:=-true}');
Expect(1, 12275, '\p{Is_IDST=true}', "");
Expect(0, 12275, '\p{^Is_IDST=true}', "");
Expect(0, 12275, '\P{Is_IDST=true}', "");
Expect(1, 12275, '\P{^Is_IDST=true}', "");
Expect(0, 12276, '\p{Is_IDST=true}', "");
Expect(1, 12276, '\p{^Is_IDST=true}', "");
Expect(1, 12276, '\P{Is_IDST=true}', "");
Expect(0, 12276, '\P{^Is_IDST=true}', "");
Expect(1, 12275, '\p{Is_IDST=	-true}', "");
Expect(0, 12275, '\p{^Is_IDST=	-true}', "");
Expect(0, 12275, '\P{Is_IDST=	-true}', "");
Expect(1, 12275, '\P{^Is_IDST=	-true}', "");
Expect(0, 12276, '\p{Is_IDST=	-true}', "");
Expect(1, 12276, '\p{^Is_IDST=	-true}', "");
Expect(1, 12276, '\P{Is_IDST=	-true}', "");
Expect(0, 12276, '\P{^Is_IDST=	-true}', "");
Error('\p{Ideographic= _No/a/}');
Error('\P{Ideographic= _No/a/}');
Expect(1, 195102, '\p{Ideographic=no}', "");
Expect(0, 195102, '\p{^Ideographic=no}', "");
Expect(0, 195102, '\P{Ideographic=no}', "");
Expect(1, 195102, '\P{^Ideographic=no}', "");
Expect(0, 195101, '\p{Ideographic=no}', "");
Expect(1, 195101, '\p{^Ideographic=no}', "");
Expect(1, 195101, '\P{Ideographic=no}', "");
Expect(0, 195101, '\P{^Ideographic=no}', "");
Expect(1, 195102, '\p{Ideographic=-_no}', "");
Expect(0, 195102, '\p{^Ideographic=-_no}', "");
Expect(0, 195102, '\P{Ideographic=-_no}', "");
Expect(1, 195102, '\P{^Ideographic=-_no}', "");
Expect(0, 195101, '\p{Ideographic=-_no}', "");
Expect(1, 195101, '\p{^Ideographic=-_no}', "");
Expect(1, 195101, '\P{Ideographic=-_no}', "");
Expect(0, 195101, '\P{^Ideographic=-_no}', "");
Error('\p{Ideo= N/a/}');
Error('\P{Ideo= N/a/}');
Expect(1, 195102, '\p{Ideo=n}', "");
Expect(0, 195102, '\p{^Ideo=n}', "");
Expect(0, 195102, '\P{Ideo=n}', "");
Expect(1, 195102, '\P{^Ideo=n}', "");
Expect(0, 195101, '\p{Ideo=n}', "");
Expect(1, 195101, '\p{^Ideo=n}', "");
Expect(1, 195101, '\P{Ideo=n}', "");
Expect(0, 195101, '\P{^Ideo=n}', "");
Expect(1, 195102, '\p{Ideo= 	N}', "");
Expect(0, 195102, '\p{^Ideo= 	N}', "");
Expect(0, 195102, '\P{Ideo= 	N}', "");
Expect(1, 195102, '\P{^Ideo= 	N}', "");
Expect(0, 195101, '\p{Ideo= 	N}', "");
Expect(1, 195101, '\p{^Ideo= 	N}', "");
Expect(1, 195101, '\P{Ideo= 	N}', "");
Expect(0, 195101, '\P{^Ideo= 	N}', "");
Error('\p{Is_Ideographic=/a/f}');
Error('\P{Is_Ideographic=/a/f}');
Expect(1, 195102, '\p{Is_Ideographic=f}', "");
Expect(0, 195102, '\p{^Is_Ideographic=f}', "");
Expect(0, 195102, '\P{Is_Ideographic=f}', "");
Expect(1, 195102, '\P{^Is_Ideographic=f}', "");
Expect(0, 195101, '\p{Is_Ideographic=f}', "");
Expect(1, 195101, '\p{^Is_Ideographic=f}', "");
Expect(1, 195101, '\P{Is_Ideographic=f}', "");
Expect(0, 195101, '\P{^Is_Ideographic=f}', "");
Expect(1, 195102, '\p{Is_Ideographic=- F}', "");
Expect(0, 195102, '\p{^Is_Ideographic=- F}', "");
Expect(0, 195102, '\P{Is_Ideographic=- F}', "");
Expect(1, 195102, '\P{^Is_Ideographic=- F}', "");
Expect(0, 195101, '\p{Is_Ideographic=- F}', "");
Expect(1, 195101, '\p{^Is_Ideographic=- F}', "");
Expect(1, 195101, '\P{Is_Ideographic=- F}', "");
Expect(0, 195101, '\P{^Is_Ideographic=- F}', "");
Error('\p{Is_Ideo=__False/a/}');
Error('\P{Is_Ideo=__False/a/}');
Expect(1, 195102, '\p{Is_Ideo=false}', "");
Expect(0, 195102, '\p{^Is_Ideo=false}', "");
Expect(0, 195102, '\P{Is_Ideo=false}', "");
Expect(1, 195102, '\P{^Is_Ideo=false}', "");
Expect(0, 195101, '\p{Is_Ideo=false}', "");
Expect(1, 195101, '\p{^Is_Ideo=false}', "");
Expect(1, 195101, '\P{Is_Ideo=false}', "");
Expect(0, 195101, '\P{^Is_Ideo=false}', "");
Expect(1, 195102, '\p{Is_Ideo=_	False}', "");
Expect(0, 195102, '\p{^Is_Ideo=_	False}', "");
Expect(0, 195102, '\P{Is_Ideo=_	False}', "");
Expect(1, 195102, '\P{^Is_Ideo=_	False}', "");
Expect(0, 195101, '\p{Is_Ideo=_	False}', "");
Expect(1, 195101, '\p{^Is_Ideo=_	False}', "");
Expect(1, 195101, '\P{Is_Ideo=_	False}', "");
Expect(0, 195101, '\P{^Is_Ideo=_	False}', "");
Error('\p{Ideographic=/a/	-YES}');
Error('\P{Ideographic=/a/	-YES}');
Expect(1, 195101, '\p{Ideographic=yes}', "");
Expect(0, 195101, '\p{^Ideographic=yes}', "");
Expect(0, 195101, '\P{Ideographic=yes}', "");
Expect(1, 195101, '\P{^Ideographic=yes}', "");
Expect(0, 195102, '\p{Ideographic=yes}', "");
Expect(1, 195102, '\p{^Ideographic=yes}', "");
Expect(1, 195102, '\P{Ideographic=yes}', "");
Expect(0, 195102, '\P{^Ideographic=yes}', "");
Expect(1, 195101, '\p{Ideographic=--yes}', "");
Expect(0, 195101, '\p{^Ideographic=--yes}', "");
Expect(0, 195101, '\P{Ideographic=--yes}', "");
Expect(1, 195101, '\P{^Ideographic=--yes}', "");
Expect(0, 195102, '\p{Ideographic=--yes}', "");
Expect(1, 195102, '\p{^Ideographic=--yes}', "");
Expect(1, 195102, '\P{Ideographic=--yes}', "");
Expect(0, 195102, '\P{^Ideographic=--yes}', "");
Error('\p{Ideo=_Y/a/}');
Error('\P{Ideo=_Y/a/}');
Expect(1, 195101, '\p{Ideo:	y}', "");
Expect(0, 195101, '\p{^Ideo:	y}', "");
Expect(0, 195101, '\P{Ideo:	y}', "");
Expect(1, 195101, '\P{^Ideo:	y}', "");
Expect(0, 195102, '\p{Ideo:	y}', "");
Expect(1, 195102, '\p{^Ideo:	y}', "");
Expect(1, 195102, '\P{Ideo:	y}', "");
Expect(0, 195102, '\P{^Ideo:	y}', "");
Expect(1, 195101, '\p{Ideo=_Y}', "");
Expect(0, 195101, '\p{^Ideo=_Y}', "");
Expect(0, 195101, '\P{Ideo=_Y}', "");
Expect(1, 195101, '\P{^Ideo=_Y}', "");
Expect(0, 195102, '\p{Ideo=_Y}', "");
Expect(1, 195102, '\p{^Ideo=_Y}', "");
Expect(1, 195102, '\P{Ideo=_Y}', "");
Expect(0, 195102, '\P{^Ideo=_Y}', "");
Error('\p{Is_Ideographic=_/a/T}');
Error('\P{Is_Ideographic=_/a/T}');
Expect(1, 195101, '\p{Is_Ideographic=t}', "");
Expect(0, 195101, '\p{^Is_Ideographic=t}', "");
Expect(0, 195101, '\P{Is_Ideographic=t}', "");
Expect(1, 195101, '\P{^Is_Ideographic=t}', "");
Expect(0, 195102, '\p{Is_Ideographic=t}', "");
Expect(1, 195102, '\p{^Is_Ideographic=t}', "");
Expect(1, 195102, '\P{Is_Ideographic=t}', "");
Expect(0, 195102, '\P{^Is_Ideographic=t}', "");
Expect(1, 195101, '\p{Is_Ideographic=- t}', "");
Expect(0, 195101, '\p{^Is_Ideographic=- t}', "");
Expect(0, 195101, '\P{Is_Ideographic=- t}', "");
Expect(1, 195101, '\P{^Is_Ideographic=- t}', "");
Expect(0, 195102, '\p{Is_Ideographic=- t}', "");
Expect(1, 195102, '\p{^Is_Ideographic=- t}', "");
Expect(1, 195102, '\P{Is_Ideographic=- t}', "");
Expect(0, 195102, '\P{^Is_Ideographic=- t}', "");
Error('\p{Is_Ideo=:= True}');
Error('\P{Is_Ideo=:= True}');
Expect(1, 195101, '\p{Is_Ideo=true}', "");
Expect(0, 195101, '\p{^Is_Ideo=true}', "");
Expect(0, 195101, '\P{Is_Ideo=true}', "");
Expect(1, 195101, '\P{^Is_Ideo=true}', "");
Expect(0, 195102, '\p{Is_Ideo=true}', "");
Expect(1, 195102, '\p{^Is_Ideo=true}', "");
Expect(1, 195102, '\P{Is_Ideo=true}', "");
Expect(0, 195102, '\P{^Is_Ideo=true}', "");
Expect(1, 195101, '\p{Is_Ideo:  True}', "");
Expect(0, 195101, '\p{^Is_Ideo:  True}', "");
Expect(0, 195101, '\P{Is_Ideo:  True}', "");
Expect(1, 195101, '\P{^Is_Ideo:  True}', "");
Expect(0, 195102, '\p{Is_Ideo:  True}', "");
Expect(1, 195102, '\p{^Is_Ideo:  True}', "");
Expect(1, 195102, '\P{Is_Ideo:  True}', "");
Expect(0, 195102, '\P{^Is_Ideo:  True}', "");
Error('\p{Present_In=	:=00001.1}');
Error('\P{Present_In=	:=00001.1}');
Expect(1, 65533, '\p{Present_In=+00001.1}', "");
Expect(0, 65533, '\p{^Present_In=+00001.1}', "");
Expect(0, 65533, '\P{Present_In=+00001.1}', "");
Expect(1, 65533, '\P{^Present_In=+00001.1}', "");
Expect(0, 65536, '\p{Present_In=+00001.1}', "");
Expect(1, 65536, '\p{^Present_In=+00001.1}', "");
Expect(1, 65536, '\P{Present_In=+00001.1}', "");
Expect(0, 65536, '\P{^Present_In=+00001.1}', "");
Error('\p{In= 1.1/a/}');
Error('\P{In= 1.1/a/}');
Expect(1, 65533, '\p{In=0000_0000_1.1}', "");
Expect(0, 65533, '\p{^In=0000_0000_1.1}', "");
Expect(0, 65533, '\P{In=0000_0000_1.1}', "");
Expect(1, 65533, '\P{^In=0000_0000_1.1}', "");
Expect(0, 65536, '\p{In=0000_0000_1.1}', "");
Expect(1, 65536, '\p{^In=0000_0000_1.1}', "");
Expect(1, 65536, '\P{In=0000_0000_1.1}', "");
Expect(0, 65536, '\P{^In=0000_0000_1.1}', "");
Error('\p{Is_Present_In=- +00_1.1/a/}');
Error('\P{Is_Present_In=- +00_1.1/a/}');
Expect(1, 65533, '\p{Is_Present_In=+000001.1}', "");
Expect(0, 65533, '\p{^Is_Present_In=+000001.1}', "");
Expect(0, 65533, '\P{Is_Present_In=+000001.1}', "");
Expect(1, 65533, '\P{^Is_Present_In=+000001.1}', "");
Expect(0, 65536, '\p{Is_Present_In=+000001.1}', "");
Expect(1, 65536, '\p{^Is_Present_In=+000001.1}', "");
Expect(1, 65536, '\P{Is_Present_In=+000001.1}', "");
Expect(0, 65536, '\P{^Is_Present_In=+000001.1}', "");
Error('\p{Is_In=-/a/+00000001.1}');
Error('\P{Is_In=-/a/+00000001.1}');
Expect(1, 65533, '\p{Is_In=0_1.1}', "");
Expect(0, 65533, '\p{^Is_In=0_1.1}', "");
Expect(0, 65533, '\P{Is_In=0_1.1}', "");
Expect(1, 65533, '\P{^Is_In=0_1.1}', "");
Expect(0, 65536, '\p{Is_In=0_1.1}', "");
Expect(1, 65536, '\p{^Is_In=0_1.1}', "");
Expect(1, 65536, '\P{Is_In=0_1.1}', "");
Expect(0, 65536, '\P{^Is_In=0_1.1}', "");
Error('\p{Present_In=/a/ -2.0}');
Error('\P{Present_In=/a/ -2.0}');
Expect(1, 983040, '\p{Present_In:+00000002.0}', "");
Expect(0, 983040, '\p{^Present_In:+00000002.0}', "");
Expect(0, 983040, '\P{Present_In:+00000002.0}', "");
Expect(1, 983040, '\P{^Present_In:+00000002.0}', "");
Expect(0, 983037, '\p{Present_In:+00000002.0}', "");
Expect(1, 983037, '\p{^Present_In:+00000002.0}', "");
Expect(1, 983037, '\P{Present_In:+00000002.0}', "");
Expect(0, 983037, '\P{^Present_In:+00000002.0}', "");
Error('\p{In: _ 0002.0:=}');
Error('\P{In: _ 0002.0:=}');
Expect(1, 983040, '\p{In=+0000002.0}', "");
Expect(0, 983040, '\p{^In=+0000002.0}', "");
Expect(0, 983040, '\P{In=+0000002.0}', "");
Expect(1, 983040, '\P{^In=+0000002.0}', "");
Expect(0, 983037, '\p{In=+0000002.0}', "");
Expect(1, 983037, '\p{^In=+0000002.0}', "");
Expect(1, 983037, '\P{In=+0000002.0}', "");
Expect(0, 983037, '\P{^In=+0000002.0}', "");
Error('\p{Is_Present_In= -0000000002.0/a/}');
Error('\P{Is_Present_In= -0000000002.0/a/}');
Expect(1, 983040, '\p{Is_Present_In=+000_000_2.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=+000_000_2.0}', "");
Expect(0, 983040, '\P{Is_Present_In=+000_000_2.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=+000_000_2.0}', "");
Expect(0, 983037, '\p{Is_Present_In=+000_000_2.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=+000_000_2.0}', "");
Expect(1, 983037, '\P{Is_Present_In=+000_000_2.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=+000_000_2.0}', "");
Error('\p{Is_In=:= _0_2.0}');
Error('\P{Is_In=:= _0_2.0}');
Expect(1, 983040, '\p{Is_In=000002.0}', "");
Expect(0, 983040, '\p{^Is_In=000002.0}', "");
Expect(0, 983040, '\P{Is_In=000002.0}', "");
Expect(1, 983040, '\P{^Is_In=000002.0}', "");
Expect(0, 983037, '\p{Is_In=000002.0}', "");
Expect(1, 983037, '\p{^Is_In=000002.0}', "");
Expect(1, 983037, '\P{Is_In=000002.0}', "");
Expect(0, 983037, '\P{^Is_In=000002.0}', "");
Error('\p{Present_In=- 000_000_000_2.1/a/}');
Error('\P{Present_In=- 000_000_000_2.1/a/}');
Expect(1, 983040, '\p{Present_In=00_00_2.1}', "");
Expect(0, 983040, '\p{^Present_In=00_00_2.1}', "");
Expect(0, 983040, '\P{Present_In=00_00_2.1}', "");
Expect(1, 983040, '\P{^Present_In=00_00_2.1}', "");
Expect(0, 983037, '\p{Present_In=00_00_2.1}', "");
Expect(1, 983037, '\p{^Present_In=00_00_2.1}', "");
Expect(1, 983037, '\P{Present_In=00_00_2.1}', "");
Expect(0, 983037, '\P{^Present_In=00_00_2.1}', "");
Error('\p{In=:=000002.1}');
Error('\P{In=:=000002.1}');
Expect(1, 983040, '\p{In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(0, 983040, '\p{^In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(0, 983040, '\P{In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(1, 983040, '\P{^In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(0, 983037, '\p{In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(1, 983037, '\p{^In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(1, 983037, '\P{In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(0, 983037, '\P{^In=+0_0_0_0_0_0_0_0_02.1}', "");
Error('\p{Is_Present_In=-:=0_0_0_0_002.1}');
Error('\P{Is_Present_In=-:=0_0_0_0_002.1}');
Expect(1, 983040, '\p{Is_Present_In=+0000002.1}', "");
Expect(0, 983040, '\p{^Is_Present_In=+0000002.1}', "");
Expect(0, 983040, '\P{Is_Present_In=+0000002.1}', "");
Expect(1, 983040, '\P{^Is_Present_In=+0000002.1}', "");
Expect(0, 983037, '\p{Is_Present_In=+0000002.1}', "");
Expect(1, 983037, '\p{^Is_Present_In=+0000002.1}', "");
Expect(1, 983037, '\P{Is_Present_In=+0000002.1}', "");
Expect(0, 983037, '\P{^Is_Present_In=+0000002.1}', "");
Error('\p{Is_In=_/a/+000_000_000_2.1}');
Error('\P{Is_In=_/a/+000_000_000_2.1}');
Expect(1, 983040, '\p{Is_In=0_0_0_0_0002.1}', "");
Expect(0, 983040, '\p{^Is_In=0_0_0_0_0002.1}', "");
Expect(0, 983040, '\P{Is_In=0_0_0_0_0002.1}', "");
Expect(1, 983040, '\P{^Is_In=0_0_0_0_0002.1}', "");
Expect(0, 983037, '\p{Is_In=0_0_0_0_0002.1}', "");
Expect(1, 983037, '\p{^Is_In=0_0_0_0_0002.1}', "");
Expect(1, 983037, '\P{Is_In=0_0_0_0_0002.1}', "");
Expect(0, 983037, '\P{^Is_In=0_0_0_0_0002.1}', "");
Error('\p{Present_In=	-+0003.0:=}');
Error('\P{Present_In=	-+0003.0:=}');
Expect(1, 983040, '\p{Present_In=000003.0}', "");
Expect(0, 983040, '\p{^Present_In=000003.0}', "");
Expect(0, 983040, '\P{Present_In=000003.0}', "");
Expect(1, 983040, '\P{^Present_In=000003.0}', "");
Expect(0, 983037, '\p{Present_In=000003.0}', "");
Expect(1, 983037, '\p{^Present_In=000003.0}', "");
Expect(1, 983037, '\P{Present_In=000003.0}', "");
Expect(0, 983037, '\P{^Present_In=000003.0}', "");
Error('\p{In=/a/+0_0_0_0_0003.0}');
Error('\P{In=/a/+0_0_0_0_0003.0}');
Expect(1, 983040, '\p{In=000_3.0}', "");
Expect(0, 983040, '\p{^In=000_3.0}', "");
Expect(0, 983040, '\P{In=000_3.0}', "");
Expect(1, 983040, '\P{^In=000_3.0}', "");
Expect(0, 983037, '\p{In=000_3.0}', "");
Expect(1, 983037, '\p{^In=000_3.0}', "");
Expect(1, 983037, '\P{In=000_3.0}', "");
Expect(0, 983037, '\P{^In=000_3.0}', "");
Error('\p{Is_Present_In=:= +0_3.0}');
Error('\P{Is_Present_In=:= +0_3.0}');
Expect(1, 983040, '\p{Is_Present_In:   3.0}', "");
Expect(0, 983040, '\p{^Is_Present_In:   3.0}', "");
Expect(0, 983040, '\P{Is_Present_In:   3.0}', "");
Expect(1, 983040, '\P{^Is_Present_In:   3.0}', "");
Expect(0, 983037, '\p{Is_Present_In:   3.0}', "");
Expect(1, 983037, '\p{^Is_Present_In:   3.0}', "");
Expect(1, 983037, '\P{Is_Present_In:   3.0}', "");
Expect(0, 983037, '\P{^Is_Present_In:   3.0}', "");
Error('\p{Is_In=	:=0000_0000_3.0}');
Error('\P{Is_In=	:=0000_0000_3.0}');
Expect(1, 983040, '\p{Is_In=+03.0}', "");
Expect(0, 983040, '\p{^Is_In=+03.0}', "");
Expect(0, 983040, '\P{Is_In=+03.0}', "");
Expect(1, 983040, '\P{^Is_In=+03.0}', "");
Expect(0, 983037, '\p{Is_In=+03.0}', "");
Expect(1, 983037, '\p{^Is_In=+03.0}', "");
Expect(1, 983037, '\P{Is_In=+03.0}', "");
Expect(0, 983037, '\P{^Is_In=+03.0}', "");
Error('\p{Present_In=/a/	_+0000000003.1}');
Error('\P{Present_In=/a/	_+0000000003.1}');
Expect(1, 983040, '\p{Present_In=003.1}', "");
Expect(0, 983040, '\p{^Present_In=003.1}', "");
Expect(0, 983040, '\P{Present_In=003.1}', "");
Expect(1, 983040, '\P{^Present_In=003.1}', "");
Expect(0, 983037, '\p{Present_In=003.1}', "");
Expect(1, 983037, '\p{^Present_In=003.1}', "");
Expect(1, 983037, '\P{Present_In=003.1}', "");
Expect(0, 983037, '\P{^Present_In=003.1}', "");
Error('\p{In=_ +00_00_3.1/a/}');
Error('\P{In=_ +00_00_3.1/a/}');
Expect(1, 983040, '\p{In=+0000000003.1}', "");
Expect(0, 983040, '\p{^In=+0000000003.1}', "");
Expect(0, 983040, '\P{In=+0000000003.1}', "");
Expect(1, 983040, '\P{^In=+0000000003.1}', "");
Expect(0, 983037, '\p{In=+0000000003.1}', "");
Expect(1, 983037, '\p{^In=+0000000003.1}', "");
Expect(1, 983037, '\P{In=+0000000003.1}', "");
Expect(0, 983037, '\P{^In=+0000000003.1}', "");
Error('\p{Is_Present_In=	_0000000003.1:=}');
Error('\P{Is_Present_In=	_0000000003.1:=}');
Expect(1, 983040, '\p{Is_Present_In=3.1}', "");
Expect(0, 983040, '\p{^Is_Present_In=3.1}', "");
Expect(0, 983040, '\P{Is_Present_In=3.1}', "");
Expect(1, 983040, '\P{^Is_Present_In=3.1}', "");
Expect(0, 983037, '\p{Is_Present_In=3.1}', "");
Expect(1, 983037, '\p{^Is_Present_In=3.1}', "");
Expect(1, 983037, '\P{Is_Present_In=3.1}', "");
Expect(0, 983037, '\P{^Is_Present_In=3.1}', "");
Error('\p{Is_In=:=_+000_000_03.1}');
Error('\P{Is_In=:=_+000_000_03.1}');
Expect(1, 983040, '\p{Is_In:0000003.1}', "");
Expect(0, 983040, '\p{^Is_In:0000003.1}', "");
Expect(0, 983040, '\P{Is_In:0000003.1}', "");
Expect(1, 983040, '\P{^Is_In:0000003.1}', "");
Expect(0, 983037, '\p{Is_In:0000003.1}', "");
Expect(1, 983037, '\p{^Is_In:0000003.1}', "");
Expect(1, 983037, '\P{Is_In:0000003.1}', "");
Expect(0, 983037, '\P{^Is_In:0000003.1}', "");
Error('\p{Present_In=:= 	+03.2}');
Error('\P{Present_In=:= 	+03.2}');
Expect(1, 983040, '\p{Present_In=+0000000_3.2}', "");
Expect(0, 983040, '\p{^Present_In=+0000000_3.2}', "");
Expect(0, 983040, '\P{Present_In=+0000000_3.2}', "");
Expect(1, 983040, '\P{^Present_In=+0000000_3.2}', "");
Expect(0, 983037, '\p{Present_In=+0000000_3.2}', "");
Expect(1, 983037, '\p{^Present_In=+0000000_3.2}', "");
Expect(1, 983037, '\P{Present_In=+0000000_3.2}', "");
Expect(0, 983037, '\P{^Present_In=+0000000_3.2}', "");
Error('\p{In=_/a/00000_3.2}');
Error('\P{In=_/a/00000_3.2}');
Expect(1, 983040, '\p{In=00000000_3.2}', "");
Expect(0, 983040, '\p{^In=00000000_3.2}', "");
Expect(0, 983040, '\P{In=00000000_3.2}', "");
Expect(1, 983040, '\P{^In=00000000_3.2}', "");
Expect(0, 983037, '\p{In=00000000_3.2}', "");
Expect(1, 983037, '\p{^In=00000000_3.2}', "");
Expect(1, 983037, '\P{In=00000000_3.2}', "");
Expect(0, 983037, '\P{^In=00000000_3.2}', "");
Error('\p{Is_Present_In:	:=--000000000_3.2}');
Error('\P{Is_Present_In:	:=--000000000_3.2}');
Expect(1, 983040, '\p{Is_Present_In=0003.2}', "");
Expect(0, 983040, '\p{^Is_Present_In=0003.2}', "");
Expect(0, 983040, '\P{Is_Present_In=0003.2}', "");
Expect(1, 983040, '\P{^Is_Present_In=0003.2}', "");
Expect(0, 983037, '\p{Is_Present_In=0003.2}', "");
Expect(1, 983037, '\p{^Is_Present_In=0003.2}', "");
Expect(1, 983037, '\P{Is_Present_In=0003.2}', "");
Expect(0, 983037, '\P{^Is_Present_In=0003.2}', "");
Error('\p{Is_In=	/a/+3.2}');
Error('\P{Is_In=	/a/+3.2}');
Expect(1, 983040, '\p{Is_In:	+000_000_03.2}', "");
Expect(0, 983040, '\p{^Is_In:	+000_000_03.2}', "");
Expect(0, 983040, '\P{Is_In:	+000_000_03.2}', "");
Expect(1, 983040, '\P{^Is_In:	+000_000_03.2}', "");
Expect(0, 983037, '\p{Is_In:	+000_000_03.2}', "");
Expect(1, 983037, '\p{^Is_In:	+000_000_03.2}', "");
Expect(1, 983037, '\P{Is_In:	+000_000_03.2}', "");
Expect(0, 983037, '\P{^Is_In:	+000_000_03.2}', "");
Error('\p{Present_In=-+0_0_0_004.0:=}');
Error('\P{Present_In=-+0_0_0_004.0:=}');
Expect(1, 983040, '\p{Present_In=0004.0}', "");
Expect(0, 983040, '\p{^Present_In=0004.0}', "");
Expect(0, 983040, '\P{Present_In=0004.0}', "");
Expect(1, 983040, '\P{^Present_In=0004.0}', "");
Expect(0, 983037, '\p{Present_In=0004.0}', "");
Expect(1, 983037, '\p{^Present_In=0004.0}', "");
Expect(1, 983037, '\P{Present_In=0004.0}', "");
Expect(0, 983037, '\P{^Present_In=0004.0}', "");
Error('\p{In=- +0000000004.0:=}');
Error('\P{In=- +0000000004.0:=}');
Expect(1, 983040, '\p{In=+4.0}', "");
Expect(0, 983040, '\p{^In=+4.0}', "");
Expect(0, 983040, '\P{In=+4.0}', "");
Expect(1, 983040, '\P{^In=+4.0}', "");
Expect(0, 983037, '\p{In=+4.0}', "");
Expect(1, 983037, '\p{^In=+4.0}', "");
Expect(1, 983037, '\P{In=+4.0}', "");
Expect(0, 983037, '\P{^In=+4.0}', "");
Error('\p{Is_Present_In=:=000_000_4.0}');
Error('\P{Is_Present_In=:=000_000_4.0}');
Expect(1, 983040, '\p{Is_Present_In=+0004.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=+0004.0}', "");
Expect(0, 983040, '\P{Is_Present_In=+0004.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=+0004.0}', "");
Expect(0, 983037, '\p{Is_Present_In=+0004.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=+0004.0}', "");
Expect(1, 983037, '\P{Is_Present_In=+0004.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=+0004.0}', "");
Error('\p{Is_In=/a/	-004.0}');
Error('\P{Is_In=/a/	-004.0}');
Expect(1, 983040, '\p{Is_In=0004.0}', "");
Expect(0, 983040, '\p{^Is_In=0004.0}', "");
Expect(0, 983040, '\P{Is_In=0004.0}', "");
Expect(1, 983040, '\P{^Is_In=0004.0}', "");
Expect(0, 983037, '\p{Is_In=0004.0}', "");
Expect(1, 983037, '\p{^Is_In=0004.0}', "");
Expect(1, 983037, '\P{Is_In=0004.0}', "");
Expect(0, 983037, '\P{^Is_In=0004.0}', "");
Error('\p{Present_In:	 /a/4.1}');
Error('\P{Present_In:	 /a/4.1}');
Expect(1, 983040, '\p{Present_In=0000004.1}', "");
Expect(0, 983040, '\p{^Present_In=0000004.1}', "");
Expect(0, 983040, '\P{Present_In=0000004.1}', "");
Expect(1, 983040, '\P{^Present_In=0000004.1}', "");
Expect(0, 983037, '\p{Present_In=0000004.1}', "");
Expect(1, 983037, '\p{^Present_In=0000004.1}', "");
Expect(1, 983037, '\P{Present_In=0000004.1}', "");
Expect(0, 983037, '\P{^Present_In=0000004.1}', "");
Error('\p{In=:=4.1}');
Error('\P{In=:=4.1}');
Expect(1, 983040, '\p{In:   +004.1}', "");
Expect(0, 983040, '\p{^In:   +004.1}', "");
Expect(0, 983040, '\P{In:   +004.1}', "");
Expect(1, 983040, '\P{^In:   +004.1}', "");
Expect(0, 983037, '\p{In:   +004.1}', "");
Expect(1, 983037, '\p{^In:   +004.1}', "");
Expect(1, 983037, '\P{In:   +004.1}', "");
Expect(0, 983037, '\P{^In:   +004.1}', "");
Error('\p{Is_Present_In=/a/+00000004.1}');
Error('\P{Is_Present_In=/a/+00000004.1}');
Expect(1, 983040, '\p{Is_Present_In=00000004.1}', "");
Expect(0, 983040, '\p{^Is_Present_In=00000004.1}', "");
Expect(0, 983040, '\P{Is_Present_In=00000004.1}', "");
Expect(1, 983040, '\P{^Is_Present_In=00000004.1}', "");
Expect(0, 983037, '\p{Is_Present_In=00000004.1}', "");
Expect(1, 983037, '\p{^Is_Present_In=00000004.1}', "");
Expect(1, 983037, '\P{Is_Present_In=00000004.1}', "");
Expect(0, 983037, '\P{^Is_Present_In=00000004.1}', "");
Error('\p{Is_In=/a/  +0004.1}');
Error('\P{Is_In=/a/  +0004.1}');
Expect(1, 983040, '\p{Is_In=0004.1}', "");
Expect(0, 983040, '\p{^Is_In=0004.1}', "");
Expect(0, 983040, '\P{Is_In=0004.1}', "");
Expect(1, 983040, '\P{^Is_In=0004.1}', "");
Expect(0, 983037, '\p{Is_In=0004.1}', "");
Expect(1, 983037, '\p{^Is_In=0004.1}', "");
Expect(1, 983037, '\P{Is_In=0004.1}', "");
Expect(0, 983037, '\P{^Is_In=0004.1}', "");
Error('\p{Present_In=:=_0000005.0}');
Error('\P{Present_In=:=_0000005.0}');
Expect(1, 983040, '\p{Present_In=005.0}', "");
Expect(0, 983040, '\p{^Present_In=005.0}', "");
Expect(0, 983040, '\P{Present_In=005.0}', "");
Expect(1, 983040, '\P{^Present_In=005.0}', "");
Expect(0, 983037, '\p{Present_In=005.0}', "");
Expect(1, 983037, '\p{^Present_In=005.0}', "");
Expect(1, 983037, '\P{Present_In=005.0}', "");
Expect(0, 983037, '\P{^Present_In=005.0}', "");
Error('\p{In:	/a/00000000_5.0}');
Error('\P{In:	/a/00000000_5.0}');
Expect(1, 983040, '\p{In=+00_00_5.0}', "");
Expect(0, 983040, '\p{^In=+00_00_5.0}', "");
Expect(0, 983040, '\P{In=+00_00_5.0}', "");
Expect(1, 983040, '\P{^In=+00_00_5.0}', "");
Expect(0, 983037, '\p{In=+00_00_5.0}', "");
Expect(1, 983037, '\p{^In=+00_00_5.0}', "");
Expect(1, 983037, '\P{In=+00_00_5.0}', "");
Expect(0, 983037, '\P{^In=+00_00_5.0}', "");
Error('\p{Is_Present_In=:=	-00000005.0}');
Error('\P{Is_Present_In=:=	-00000005.0}');
Expect(1, 983040, '\p{Is_Present_In=0_0_0_05.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=0_0_0_05.0}', "");
Expect(0, 983040, '\P{Is_Present_In=0_0_0_05.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=0_0_0_05.0}', "");
Expect(0, 983037, '\p{Is_Present_In=0_0_0_05.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=0_0_0_05.0}', "");
Expect(1, 983037, '\P{Is_Present_In=0_0_0_05.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=0_0_0_05.0}', "");
Error('\p{Is_In=/a/	-5.0}');
Error('\P{Is_In=/a/	-5.0}');
Expect(1, 983040, '\p{Is_In=000000005.0}', "");
Expect(0, 983040, '\p{^Is_In=000000005.0}', "");
Expect(0, 983040, '\P{Is_In=000000005.0}', "");
Expect(1, 983040, '\P{^Is_In=000000005.0}', "");
Expect(0, 983037, '\p{Is_In=000000005.0}', "");
Expect(1, 983037, '\p{^Is_In=000000005.0}', "");
Expect(1, 983037, '\P{Is_In=000000005.0}', "");
Expect(0, 983037, '\P{^Is_In=000000005.0}', "");
Error('\p{Present_In=__00000_5.1:=}');
Error('\P{Present_In=__00000_5.1:=}');
Expect(1, 983040, '\p{Present_In=0_0_0_05.1}', "");
Expect(0, 983040, '\p{^Present_In=0_0_0_05.1}', "");
Expect(0, 983040, '\P{Present_In=0_0_0_05.1}', "");
Expect(1, 983040, '\P{^Present_In=0_0_0_05.1}', "");
Expect(0, 983037, '\p{Present_In=0_0_0_05.1}', "");
Expect(1, 983037, '\p{^Present_In=0_0_0_05.1}', "");
Expect(1, 983037, '\P{Present_In=0_0_0_05.1}', "");
Expect(0, 983037, '\P{^Present_In=0_0_0_05.1}', "");
Error('\p{In::=-+0_0_0_0_0_05.1}');
Error('\P{In::=-+0_0_0_0_0_05.1}');
Expect(1, 983040, '\p{In=0000000005.1}', "");
Expect(0, 983040, '\p{^In=0000000005.1}', "");
Expect(0, 983040, '\P{In=0000000005.1}', "");
Expect(1, 983040, '\P{^In=0000000005.1}', "");
Expect(0, 983037, '\p{In=0000000005.1}', "");
Expect(1, 983037, '\p{^In=0000000005.1}', "");
Expect(1, 983037, '\P{In=0000000005.1}', "");
Expect(0, 983037, '\P{^In=0000000005.1}', "");
Error('\p{Is_Present_In=	:=00000_5.1}');
Error('\P{Is_Present_In=	:=00000_5.1}');
Expect(1, 983040, '\p{Is_Present_In=0_0_0_0_05.1}', "");
Expect(0, 983040, '\p{^Is_Present_In=0_0_0_0_05.1}', "");
Expect(0, 983040, '\P{Is_Present_In=0_0_0_0_05.1}', "");
Expect(1, 983040, '\P{^Is_Present_In=0_0_0_0_05.1}', "");
Expect(0, 983037, '\p{Is_Present_In=0_0_0_0_05.1}', "");
Expect(1, 983037, '\p{^Is_Present_In=0_0_0_0_05.1}', "");
Expect(1, 983037, '\P{Is_Present_In=0_0_0_0_05.1}', "");
Expect(0, 983037, '\P{^Is_Present_In=0_0_0_0_05.1}', "");
Error('\p{Is_In: 	-0_5.1:=}');
Error('\P{Is_In: 	-0_5.1:=}');
Expect(1, 983040, '\p{Is_In=0_0_0_0_005.1}', "");
Expect(0, 983040, '\p{^Is_In=0_0_0_0_005.1}', "");
Expect(0, 983040, '\P{Is_In=0_0_0_0_005.1}', "");
Expect(1, 983040, '\P{^Is_In=0_0_0_0_005.1}', "");
Expect(0, 983037, '\p{Is_In=0_0_0_0_005.1}', "");
Expect(1, 983037, '\p{^Is_In=0_0_0_0_005.1}', "");
Expect(1, 983037, '\P{Is_In=0_0_0_0_005.1}', "");
Expect(0, 983037, '\P{^Is_In=0_0_0_0_005.1}', "");
Error('\p{Present_In:		/a/0_0_05.2}');
Error('\P{Present_In:		/a/0_0_05.2}');
Expect(1, 983040, '\p{Present_In=0_0_0_0_0_00005.2}', "");
Expect(0, 983040, '\p{^Present_In=0_0_0_0_0_00005.2}', "");
Expect(0, 983040, '\P{Present_In=0_0_0_0_0_00005.2}', "");
Expect(1, 983040, '\P{^Present_In=0_0_0_0_0_00005.2}', "");
Expect(0, 983037, '\p{Present_In=0_0_0_0_0_00005.2}', "");
Expect(1, 983037, '\p{^Present_In=0_0_0_0_0_00005.2}', "");
Expect(1, 983037, '\P{Present_In=0_0_0_0_0_00005.2}', "");
Expect(0, 983037, '\P{^Present_In=0_0_0_0_0_00005.2}', "");
Error('\p{In=-:=+005.2}');
Error('\P{In=-:=+005.2}');
Expect(1, 983040, '\p{In:	00000005.2}', "");
Expect(0, 983040, '\p{^In:	00000005.2}', "");
Expect(0, 983040, '\P{In:	00000005.2}', "");
Expect(1, 983040, '\P{^In:	00000005.2}', "");
Expect(0, 983037, '\p{In:	00000005.2}', "");
Expect(1, 983037, '\p{^In:	00000005.2}', "");
Expect(1, 983037, '\P{In:	00000005.2}', "");
Expect(0, 983037, '\P{^In:	00000005.2}', "");
Error('\p{Is_Present_In=	:=+0_0_0_0_0_0_0_05.2}');
Error('\P{Is_Present_In=	:=+0_0_0_0_0_0_0_05.2}');
Expect(1, 983040, '\p{Is_Present_In=+00005.2}', "");
Expect(0, 983040, '\p{^Is_Present_In=+00005.2}', "");
Expect(0, 983040, '\P{Is_Present_In=+00005.2}', "");
Expect(1, 983040, '\P{^Is_Present_In=+00005.2}', "");
Expect(0, 983037, '\p{Is_Present_In=+00005.2}', "");
Expect(1, 983037, '\p{^Is_Present_In=+00005.2}', "");
Expect(1, 983037, '\P{Is_Present_In=+00005.2}', "");
Expect(0, 983037, '\P{^Is_Present_In=+00005.2}', "");
Error('\p{Is_In: := 	+00000005.2}');
Error('\P{Is_In: := 	+00000005.2}');
Expect(1, 983040, '\p{Is_In=0_5.2}', "");
Expect(0, 983040, '\p{^Is_In=0_5.2}', "");
Expect(0, 983040, '\P{Is_In=0_5.2}', "");
Expect(1, 983040, '\P{^Is_In=0_5.2}', "");
Expect(0, 983037, '\p{Is_In=0_5.2}', "");
Expect(1, 983037, '\p{^Is_In=0_5.2}', "");
Expect(1, 983037, '\P{Is_In=0_5.2}', "");
Expect(0, 983037, '\P{^Is_In=0_5.2}', "");
Error('\p{Present_In::=_-+00_00_06.0}');
Error('\P{Present_In::=_-+00_00_06.0}');
Expect(1, 983040, '\p{Present_In=06.0}', "");
Expect(0, 983040, '\p{^Present_In=06.0}', "");
Expect(0, 983040, '\P{Present_In=06.0}', "");
Expect(1, 983040, '\P{^Present_In=06.0}', "");
Expect(0, 983037, '\p{Present_In=06.0}', "");
Expect(1, 983037, '\p{^Present_In=06.0}', "");
Expect(1, 983037, '\P{Present_In=06.0}', "");
Expect(0, 983037, '\P{^Present_In=06.0}', "");
Error('\p{In=:=	 006.0}');
Error('\P{In=:=	 006.0}');
Expect(1, 983040, '\p{In=+0006.0}', "");
Expect(0, 983040, '\p{^In=+0006.0}', "");
Expect(0, 983040, '\P{In=+0006.0}', "");
Expect(1, 983040, '\P{^In=+0006.0}', "");
Expect(0, 983037, '\p{In=+0006.0}', "");
Expect(1, 983037, '\p{^In=+0006.0}', "");
Expect(1, 983037, '\P{In=+0006.0}', "");
Expect(0, 983037, '\P{^In=+0006.0}', "");
Error('\p{Is_Present_In=/a/ 0_0_06.0}');
Error('\P{Is_Present_In=/a/ 0_0_06.0}');
Expect(1, 983040, '\p{Is_Present_In=000000_6.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=000000_6.0}', "");
Expect(0, 983040, '\P{Is_Present_In=000000_6.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=000000_6.0}', "");
Expect(0, 983037, '\p{Is_Present_In=000000_6.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=000000_6.0}', "");
Expect(1, 983037, '\P{Is_Present_In=000000_6.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=000000_6.0}', "");
Error('\p{Is_In=__0006.0:=}');
Error('\P{Is_In=__0006.0:=}');
Expect(1, 983040, '\p{Is_In=6.0}', "");
Expect(0, 983040, '\p{^Is_In=6.0}', "");
Expect(0, 983040, '\P{Is_In=6.0}', "");
Expect(1, 983040, '\P{^Is_In=6.0}', "");
Expect(0, 983037, '\p{Is_In=6.0}', "");
Expect(1, 983037, '\p{^Is_In=6.0}', "");
Expect(1, 983037, '\P{Is_In=6.0}', "");
Expect(0, 983037, '\P{^Is_In=6.0}', "");
Error('\p{Present_In=:=00000006.1}');
Error('\P{Present_In=:=00000006.1}');
Expect(1, 983040, '\p{Present_In=+000_000_06.1}', "");
Expect(0, 983040, '\p{^Present_In=+000_000_06.1}', "");
Expect(0, 983040, '\P{Present_In=+000_000_06.1}', "");
Expect(1, 983040, '\P{^Present_In=+000_000_06.1}', "");
Expect(0, 983037, '\p{Present_In=+000_000_06.1}', "");
Expect(1, 983037, '\p{^Present_In=+000_000_06.1}', "");
Expect(1, 983037, '\P{Present_In=+000_000_06.1}', "");
Expect(0, 983037, '\P{^Present_In=+000_000_06.1}', "");
Error('\p{In=	/a/+6.1}');
Error('\P{In=	/a/+6.1}');
Expect(1, 983040, '\p{In=+00_6.1}', "");
Expect(0, 983040, '\p{^In=+00_6.1}', "");
Expect(0, 983040, '\P{In=+00_6.1}', "");
Expect(1, 983040, '\P{^In=+00_6.1}', "");
Expect(0, 983037, '\p{In=+00_6.1}', "");
Expect(1, 983037, '\p{^In=+00_6.1}', "");
Expect(1, 983037, '\P{In=+00_6.1}', "");
Expect(0, 983037, '\P{^In=+00_6.1}', "");
Error('\p{Is_Present_In=/a/	6.1}');
Error('\P{Is_Present_In=/a/	6.1}');
Expect(1, 983040, '\p{Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(0, 983040, '\p{^Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(0, 983040, '\P{Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(1, 983040, '\P{^Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(0, 983037, '\p{Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(1, 983037, '\p{^Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(1, 983037, '\P{Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(0, 983037, '\P{^Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Error('\p{Is_In:	:=-	+0_0_0_0_0_006.1}');
Error('\P{Is_In:	:=-	+0_0_0_0_0_006.1}');
Expect(1, 983040, '\p{Is_In=0000000006.1}', "");
Expect(0, 983040, '\p{^Is_In=0000000006.1}', "");
Expect(0, 983040, '\P{Is_In=0000000006.1}', "");
Expect(1, 983040, '\P{^Is_In=0000000006.1}', "");
Expect(0, 983037, '\p{Is_In=0000000006.1}', "");
Expect(1, 983037, '\p{^Is_In=0000000006.1}', "");
Expect(1, 983037, '\P{Is_In=0000000006.1}', "");
Expect(0, 983037, '\P{^Is_In=0000000006.1}', "");
Error('\p{Present_In=:=		000006.2}');
Error('\P{Present_In=:=		000006.2}');
Expect(1, 983040, '\p{Present_In=+000006.2}', "");
Expect(0, 983040, '\p{^Present_In=+000006.2}', "");
Expect(0, 983040, '\P{Present_In=+000006.2}', "");
Expect(1, 983040, '\P{^Present_In=+000006.2}', "");
Expect(0, 983037, '\p{Present_In=+000006.2}', "");
Expect(1, 983037, '\p{^Present_In=+000006.2}', "");
Expect(1, 983037, '\P{Present_In=+000006.2}', "");
Expect(0, 983037, '\P{^Present_In=+000006.2}', "");
Error('\p{In=_/a/0000_6.2}');
Error('\P{In=_/a/0000_6.2}');
Expect(1, 983040, '\p{In=000000_6.2}', "");
Expect(0, 983040, '\p{^In=000000_6.2}', "");
Expect(0, 983040, '\P{In=000000_6.2}', "");
Expect(1, 983040, '\P{^In=000000_6.2}', "");
Expect(0, 983037, '\p{In=000000_6.2}', "");
Expect(1, 983037, '\p{^In=000000_6.2}', "");
Expect(1, 983037, '\P{In=000000_6.2}', "");
Expect(0, 983037, '\P{^In=000000_6.2}', "");
Error('\p{Is_Present_In=:=	 +00_00_6.2}');
Error('\P{Is_Present_In=:=	 +00_00_6.2}');
Expect(1, 983040, '\p{Is_Present_In=0000006.2}', "");
Expect(0, 983040, '\p{^Is_Present_In=0000006.2}', "");
Expect(0, 983040, '\P{Is_Present_In=0000006.2}', "");
Expect(1, 983040, '\P{^Is_Present_In=0000006.2}', "");
Expect(0, 983037, '\p{Is_Present_In=0000006.2}', "");
Expect(1, 983037, '\p{^Is_Present_In=0000006.2}', "");
Expect(1, 983037, '\P{Is_Present_In=0000006.2}', "");
Expect(0, 983037, '\P{^Is_Present_In=0000006.2}', "");
Error('\p{Is_In=/a/_ 000000006.2}');
Error('\P{Is_In=/a/_ 000000006.2}');
Expect(1, 983040, '\p{Is_In=6.2}', "");
Expect(0, 983040, '\p{^Is_In=6.2}', "");
Expect(0, 983040, '\P{Is_In=6.2}', "");
Expect(1, 983040, '\P{^Is_In=6.2}', "");
Expect(0, 983037, '\p{Is_In=6.2}', "");
Expect(1, 983037, '\p{^Is_In=6.2}', "");
Expect(1, 983037, '\P{Is_In=6.2}', "");
Expect(0, 983037, '\P{^Is_In=6.2}', "");
Error('\p{Present_In= +006.3/a/}');
Error('\P{Present_In= +006.3/a/}');
Expect(1, 983040, '\p{Present_In=000_000_06.3}', "");
Expect(0, 983040, '\p{^Present_In=000_000_06.3}', "");
Expect(0, 983040, '\P{Present_In=000_000_06.3}', "");
Expect(1, 983040, '\P{^Present_In=000_000_06.3}', "");
Expect(0, 983037, '\p{Present_In=000_000_06.3}', "");
Expect(1, 983037, '\p{^Present_In=000_000_06.3}', "");
Expect(1, 983037, '\P{Present_In=000_000_06.3}', "");
Expect(0, 983037, '\P{^Present_In=000_000_06.3}', "");
Error('\p{In=--+00_00_00_006.3/a/}');
Error('\P{In=--+00_00_00_006.3/a/}');
Expect(1, 983040, '\p{In=000006.3}', "");
Expect(0, 983040, '\p{^In=000006.3}', "");
Expect(0, 983040, '\P{In=000006.3}', "");
Expect(1, 983040, '\P{^In=000006.3}', "");
Expect(0, 983037, '\p{In=000006.3}', "");
Expect(1, 983037, '\p{^In=000006.3}', "");
Expect(1, 983037, '\P{In=000006.3}', "");
Expect(0, 983037, '\P{^In=000006.3}', "");
Error('\p{Is_Present_In=-000000006.3/a/}');
Error('\P{Is_Present_In=-000000006.3/a/}');
Expect(1, 983040, '\p{Is_Present_In=000006.3}', "");
Expect(0, 983040, '\p{^Is_Present_In=000006.3}', "");
Expect(0, 983040, '\P{Is_Present_In=000006.3}', "");
Expect(1, 983040, '\P{^Is_Present_In=000006.3}', "");
Expect(0, 983037, '\p{Is_Present_In=000006.3}', "");
Expect(1, 983037, '\p{^Is_Present_In=000006.3}', "");
Expect(1, 983037, '\P{Is_Present_In=000006.3}', "");
Expect(0, 983037, '\P{^Is_Present_In=000006.3}', "");
Error('\p{Is_In=_/a/06.3}');
Error('\P{Is_In=_/a/06.3}');
Expect(1, 983040, '\p{Is_In=+000000006.3}', "");
Expect(0, 983040, '\p{^Is_In=+000000006.3}', "");
Expect(0, 983040, '\P{Is_In=+000000006.3}', "");
Expect(1, 983040, '\P{^Is_In=+000000006.3}', "");
Expect(0, 983037, '\p{Is_In=+000000006.3}', "");
Expect(1, 983037, '\p{^Is_In=+000000006.3}', "");
Expect(1, 983037, '\P{Is_In=+000000006.3}', "");
Expect(0, 983037, '\P{^Is_In=+000000006.3}', "");
Error('\p{Present_In=_:=+0_0_0_0_0_0_0_007.0}');
Error('\P{Present_In=_:=+0_0_0_0_0_0_0_007.0}');
Expect(1, 983040, '\p{Present_In=00007.0}', "");
Expect(0, 983040, '\p{^Present_In=00007.0}', "");
Expect(0, 983040, '\P{Present_In=00007.0}', "");
Expect(1, 983040, '\P{^Present_In=00007.0}', "");
Expect(0, 983037, '\p{Present_In=00007.0}', "");
Expect(1, 983037, '\p{^Present_In=00007.0}', "");
Expect(1, 983037, '\P{Present_In=00007.0}', "");
Expect(0, 983037, '\P{^Present_In=00007.0}', "");
Error('\p{In=/a/000_7.0}');
Error('\P{In=/a/000_7.0}');
Expect(1, 983040, '\p{In=00_00_07.0}', "");
Expect(0, 983040, '\p{^In=00_00_07.0}', "");
Expect(0, 983040, '\P{In=00_00_07.0}', "");
Expect(1, 983040, '\P{^In=00_00_07.0}', "");
Expect(0, 983037, '\p{In=00_00_07.0}', "");
Expect(1, 983037, '\p{^In=00_00_07.0}', "");
Expect(1, 983037, '\P{In=00_00_07.0}', "");
Expect(0, 983037, '\P{^In=00_00_07.0}', "");
Error('\p{Is_Present_In=	:=0_0_0_0_0_07.0}');
Error('\P{Is_Present_In=	:=0_0_0_0_0_07.0}');
Expect(1, 983040, '\p{Is_Present_In=000007.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=000007.0}', "");
Expect(0, 983040, '\P{Is_Present_In=000007.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=000007.0}', "");
Expect(0, 983037, '\p{Is_Present_In=000007.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=000007.0}', "");
Expect(1, 983037, '\P{Is_Present_In=000007.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=000007.0}', "");
Error('\p{Is_In= 	00007.0/a/}');
Error('\P{Is_In= 	00007.0/a/}');
Expect(1, 983040, '\p{Is_In=00_00_7.0}', "");
Expect(0, 983040, '\p{^Is_In=00_00_7.0}', "");
Expect(0, 983040, '\P{Is_In=00_00_7.0}', "");
Expect(1, 983040, '\P{^Is_In=00_00_7.0}', "");
Expect(0, 983037, '\p{Is_In=00_00_7.0}', "");
Expect(1, 983037, '\p{^Is_In=00_00_7.0}', "");
Expect(1, 983037, '\P{Is_In=00_00_7.0}', "");
Expect(0, 983037, '\P{^Is_In=00_00_7.0}', "");
Error('\p{Present_In=:= 	0_0_0_008.0}');
Error('\P{Present_In=:= 	0_0_0_008.0}');
Expect(1, 983040, '\p{Present_In=08.0}', "");
Expect(0, 983040, '\p{^Present_In=08.0}', "");
Expect(0, 983040, '\P{Present_In=08.0}', "");
Expect(1, 983040, '\P{^Present_In=08.0}', "");
Expect(0, 983037, '\p{Present_In=08.0}', "");
Expect(1, 983037, '\p{^Present_In=08.0}', "");
Expect(1, 983037, '\P{Present_In=08.0}', "");
Expect(0, 983037, '\P{^Present_In=08.0}', "");
Error('\p{In=/a/000000008.0}');
Error('\P{In=/a/000000008.0}');
Expect(1, 983040, '\p{In=+0000000008.0}', "");
Expect(0, 983040, '\p{^In=+0000000008.0}', "");
Expect(0, 983040, '\P{In=+0000000008.0}', "");
Expect(1, 983040, '\P{^In=+0000000008.0}', "");
Expect(0, 983037, '\p{In=+0000000008.0}', "");
Expect(1, 983037, '\p{^In=+0000000008.0}', "");
Expect(1, 983037, '\P{In=+0000000008.0}', "");
Expect(0, 983037, '\P{^In=+0000000008.0}', "");
Error('\p{Is_Present_In=	+8.0:=}');
Error('\P{Is_Present_In=	+8.0:=}');
Expect(1, 983040, '\p{Is_Present_In=00008.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=00008.0}', "");
Expect(0, 983040, '\P{Is_Present_In=00008.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=00008.0}', "");
Expect(0, 983037, '\p{Is_Present_In=00008.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=00008.0}', "");
Expect(1, 983037, '\P{Is_Present_In=00008.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=00008.0}', "");
Error('\p{Is_In=-:=0008.0}');
Error('\P{Is_In=-:=0008.0}');
Expect(1, 983040, '\p{Is_In=+00_8.0}', "");
Expect(0, 983040, '\p{^Is_In=+00_8.0}', "");
Expect(0, 983040, '\P{Is_In=+00_8.0}', "");
Expect(1, 983040, '\P{^Is_In=+00_8.0}', "");
Expect(0, 983037, '\p{Is_In=+00_8.0}', "");
Expect(1, 983037, '\p{^Is_In=+00_8.0}', "");
Expect(1, 983037, '\P{Is_In=+00_8.0}', "");
Expect(0, 983037, '\P{^Is_In=+00_8.0}', "");
Error('\p{Present_In=:= UNASSIGNED}');
Error('\P{Present_In=:= UNASSIGNED}');
Expect(1, 983037, '\p{Present_In=unassigned}', "");
Expect(0, 983037, '\p{^Present_In=unassigned}', "");
Expect(0, 983037, '\P{Present_In=unassigned}', "");
Expect(1, 983037, '\P{^Present_In=unassigned}', "");
Expect(0, 983040, '\p{Present_In=unassigned}', "");
Expect(1, 983040, '\p{^Present_In=unassigned}', "");
Expect(1, 983040, '\P{Present_In=unassigned}', "");
Expect(0, 983040, '\P{^Present_In=unassigned}', "");
Expect(1, 983037, '\p{Present_In=- unassigned}', "");
Expect(0, 983037, '\p{^Present_In=- unassigned}', "");
Expect(0, 983037, '\P{Present_In=- unassigned}', "");
Expect(1, 983037, '\P{^Present_In=- unassigned}', "");
Expect(0, 983040, '\p{Present_In=- unassigned}', "");
Expect(1, 983040, '\p{^Present_In=- unassigned}', "");
Expect(1, 983040, '\P{Present_In=- unassigned}', "");
Expect(0, 983040, '\P{^Present_In=- unassigned}', "");
Error('\p{In=/a/-Unassigned}');
Error('\P{In=/a/-Unassigned}');
Expect(1, 983037, '\p{In=unassigned}', "");
Expect(0, 983037, '\p{^In=unassigned}', "");
Expect(0, 983037, '\P{In=unassigned}', "");
Expect(1, 983037, '\P{^In=unassigned}', "");
Expect(0, 983040, '\p{In=unassigned}', "");
Expect(1, 983040, '\p{^In=unassigned}', "");
Expect(1, 983040, '\P{In=unassigned}', "");
Expect(0, 983040, '\P{^In=unassigned}', "");
Expect(1, 983037, '\p{In=	_Unassigned}', "");
Expect(0, 983037, '\p{^In=	_Unassigned}', "");
Expect(0, 983037, '\P{In=	_Unassigned}', "");
Expect(1, 983037, '\P{^In=	_Unassigned}', "");
Expect(0, 983040, '\p{In=	_Unassigned}', "");
Expect(1, 983040, '\p{^In=	_Unassigned}', "");
Expect(1, 983040, '\P{In=	_Unassigned}', "");
Expect(0, 983040, '\P{^In=	_Unassigned}', "");
Error('\p{Is_Present_In:	/a/_	Unassigned}');
Error('\P{Is_Present_In:	/a/_	Unassigned}');
Expect(1, 983037, '\p{Is_Present_In=unassigned}', "");
Expect(0, 983037, '\p{^Is_Present_In=unassigned}', "");
Expect(0, 983037, '\P{Is_Present_In=unassigned}', "");
Expect(1, 983037, '\P{^Is_Present_In=unassigned}', "");
Expect(0, 983040, '\p{Is_Present_In=unassigned}', "");
Expect(1, 983040, '\p{^Is_Present_In=unassigned}', "");
Expect(1, 983040, '\P{Is_Present_In=unassigned}', "");
Expect(0, 983040, '\P{^Is_Present_In=unassigned}', "");
Expect(1, 983037, '\p{Is_Present_In=__Unassigned}', "");
Expect(0, 983037, '\p{^Is_Present_In=__Unassigned}', "");
Expect(0, 983037, '\P{Is_Present_In=__Unassigned}', "");
Expect(1, 983037, '\P{^Is_Present_In=__Unassigned}', "");
Expect(0, 983040, '\p{Is_Present_In=__Unassigned}', "");
Expect(1, 983040, '\p{^Is_Present_In=__Unassigned}', "");
Expect(1, 983040, '\P{Is_Present_In=__Unassigned}', "");
Expect(0, 983040, '\P{^Is_Present_In=__Unassigned}', "");
Error('\p{Is_In=:=-Unassigned}');
Error('\P{Is_In=:=-Unassigned}');
Expect(1, 983037, '\p{Is_In=unassigned}', "");
Expect(0, 983037, '\p{^Is_In=unassigned}', "");
Expect(0, 983037, '\P{Is_In=unassigned}', "");
Expect(1, 983037, '\P{^Is_In=unassigned}', "");
Expect(0, 983040, '\p{Is_In=unassigned}', "");
Expect(1, 983040, '\p{^Is_In=unassigned}', "");
Expect(1, 983040, '\P{Is_In=unassigned}', "");
Expect(0, 983040, '\P{^Is_In=unassigned}', "");
Expect(1, 983037, '\p{Is_In:    Unassigned}', "");
Expect(0, 983037, '\p{^Is_In:    Unassigned}', "");
Expect(0, 983037, '\P{Is_In:    Unassigned}', "");
Expect(1, 983037, '\P{^Is_In:    Unassigned}', "");
Expect(0, 983040, '\p{Is_In:    Unassigned}', "");
Expect(1, 983040, '\p{^Is_In:    Unassigned}', "");
Expect(1, 983040, '\P{Is_In:    Unassigned}', "");
Expect(0, 983040, '\P{^Is_In:    Unassigned}', "");
Error('\p{Indic_Positional_Category=:=- bottom}');
Error('\P{Indic_Positional_Category=:=- bottom}');
Expect(1, 71464, '\p{Indic_Positional_Category=bottom}', "");
Expect(0, 71464, '\p{^Indic_Positional_Category=bottom}', "");
Expect(0, 71464, '\P{Indic_Positional_Category=bottom}', "");
Expect(1, 71464, '\P{^Indic_Positional_Category=bottom}', "");
Expect(0, 71465, '\p{Indic_Positional_Category=bottom}', "");
Expect(1, 71465, '\p{^Indic_Positional_Category=bottom}', "");
Expect(1, 71465, '\P{Indic_Positional_Category=bottom}', "");
Expect(0, 71465, '\P{^Indic_Positional_Category=bottom}', "");
Expect(1, 71464, '\p{Indic_Positional_Category:-_BOTTOM}', "");
Expect(0, 71464, '\p{^Indic_Positional_Category:-_BOTTOM}', "");
Expect(0, 71464, '\P{Indic_Positional_Category:-_BOTTOM}', "");
Expect(1, 71464, '\P{^Indic_Positional_Category:-_BOTTOM}', "");
Expect(0, 71465, '\p{Indic_Positional_Category:-_BOTTOM}', "");
Expect(1, 71465, '\p{^Indic_Positional_Category:-_BOTTOM}', "");
Expect(1, 71465, '\P{Indic_Positional_Category:-_BOTTOM}', "");
Expect(0, 71465, '\P{^Indic_Positional_Category:-_BOTTOM}', "");
Error('\p{InPC=/a/_bottom}');
Error('\P{InPC=/a/_bottom}');
Expect(1, 71464, '\p{InPC=bottom}', "");
Expect(0, 71464, '\p{^InPC=bottom}', "");
Expect(0, 71464, '\P{InPC=bottom}', "");
Expect(1, 71464, '\P{^InPC=bottom}', "");
Expect(0, 71465, '\p{InPC=bottom}', "");
Expect(1, 71465, '\p{^InPC=bottom}', "");
Expect(1, 71465, '\P{InPC=bottom}', "");
Expect(0, 71465, '\P{^InPC=bottom}', "");
Expect(1, 71464, '\p{InPC=- Bottom}', "");
Expect(0, 71464, '\p{^InPC=- Bottom}', "");
Expect(0, 71464, '\P{InPC=- Bottom}', "");
Expect(1, 71464, '\P{^InPC=- Bottom}', "");
Expect(0, 71465, '\p{InPC=- Bottom}', "");
Expect(1, 71465, '\p{^InPC=- Bottom}', "");
Expect(1, 71465, '\P{InPC=- Bottom}', "");
Expect(0, 71465, '\P{^InPC=- Bottom}', "");
Error('\p{Is_Indic_Positional_Category=BOTTOM/a/}');
Error('\P{Is_Indic_Positional_Category=BOTTOM/a/}');
Expect(1, 71464, '\p{Is_Indic_Positional_Category=bottom}', "");
Expect(0, 71464, '\p{^Is_Indic_Positional_Category=bottom}', "");
Expect(0, 71464, '\P{Is_Indic_Positional_Category=bottom}', "");
Expect(1, 71464, '\P{^Is_Indic_Positional_Category=bottom}', "");
Expect(0, 71465, '\p{Is_Indic_Positional_Category=bottom}', "");
Expect(1, 71465, '\p{^Is_Indic_Positional_Category=bottom}', "");
Expect(1, 71465, '\P{Is_Indic_Positional_Category=bottom}', "");
Expect(0, 71465, '\P{^Is_Indic_Positional_Category=bottom}', "");
Expect(1, 71464, '\p{Is_Indic_Positional_Category=	 BOTTOM}', "");
Expect(0, 71464, '\p{^Is_Indic_Positional_Category=	 BOTTOM}', "");
Expect(0, 71464, '\P{Is_Indic_Positional_Category=	 BOTTOM}', "");
Expect(1, 71464, '\P{^Is_Indic_Positional_Category=	 BOTTOM}', "");
Expect(0, 71465, '\p{Is_Indic_Positional_Category=	 BOTTOM}', "");
Expect(1, 71465, '\p{^Is_Indic_Positional_Category=	 BOTTOM}', "");
Expect(1, 71465, '\P{Is_Indic_Positional_Category=	 BOTTOM}', "");
Expect(0, 71465, '\P{^Is_Indic_Positional_Category=	 BOTTOM}', "");
Error('\p{Is_InPC=_bottom/a/}');
Error('\P{Is_InPC=_bottom/a/}');
Expect(1, 71464, '\p{Is_InPC=bottom}', "");
Expect(0, 71464, '\p{^Is_InPC=bottom}', "");
Expect(0, 71464, '\P{Is_InPC=bottom}', "");
Expect(1, 71464, '\P{^Is_InPC=bottom}', "");
Expect(0, 71465, '\p{Is_InPC=bottom}', "");
Expect(1, 71465, '\p{^Is_InPC=bottom}', "");
Expect(1, 71465, '\P{Is_InPC=bottom}', "");
Expect(0, 71465, '\P{^Is_InPC=bottom}', "");
Expect(1, 71464, '\p{Is_InPC:   BOTTOM}', "");
Expect(0, 71464, '\p{^Is_InPC:   BOTTOM}', "");
Expect(0, 71464, '\P{Is_InPC:   BOTTOM}', "");
Expect(1, 71464, '\P{^Is_InPC:   BOTTOM}', "");
Expect(0, 71465, '\p{Is_InPC:   BOTTOM}', "");
Expect(1, 71465, '\p{^Is_InPC:   BOTTOM}', "");
Expect(1, 71465, '\P{Is_InPC:   BOTTOM}', "");
Expect(0, 71465, '\P{^Is_InPC:   BOTTOM}', "");
Error('\p{Indic_Positional_Category=/a/ 	bottom_and_right}');
Error('\P{Indic_Positional_Category=/a/ 	bottom_and_right}');
Expect(1, 43456, '\p{Indic_Positional_Category=bottomandright}', "");
Expect(0, 43456, '\p{^Indic_Positional_Category=bottomandright}', "");
Expect(0, 43456, '\P{Indic_Positional_Category=bottomandright}', "");
Expect(1, 43456, '\P{^Indic_Positional_Category=bottomandright}', "");
Expect(0, 43457, '\p{Indic_Positional_Category=bottomandright}', "");
Expect(1, 43457, '\p{^Indic_Positional_Category=bottomandright}', "");
Expect(1, 43457, '\P{Indic_Positional_Category=bottomandright}', "");
Expect(0, 43457, '\P{^Indic_Positional_Category=bottomandright}', "");
Expect(1, 43456, '\p{Indic_Positional_Category=		Bottom_and_right}', "");
Expect(0, 43456, '\p{^Indic_Positional_Category=		Bottom_and_right}', "");
Expect(0, 43456, '\P{Indic_Positional_Category=		Bottom_and_right}', "");
Expect(1, 43456, '\P{^Indic_Positional_Category=		Bottom_and_right}', "");
Expect(0, 43457, '\p{Indic_Positional_Category=		Bottom_and_right}', "");
Expect(1, 43457, '\p{^Indic_Positional_Category=		Bottom_and_right}', "");
Expect(1, 43457, '\P{Indic_Positional_Category=		Bottom_and_right}', "");
Expect(0, 43457, '\P{^Indic_Positional_Category=		Bottom_and_right}', "");
Error('\p{InPC= /a/Bottom_AND_Right}');
Error('\P{InPC= /a/Bottom_AND_Right}');
Expect(1, 43456, '\p{InPC=bottomandright}', "");
Expect(0, 43456, '\p{^InPC=bottomandright}', "");
Expect(0, 43456, '\P{InPC=bottomandright}', "");
Expect(1, 43456, '\P{^InPC=bottomandright}', "");
Expect(0, 43457, '\p{InPC=bottomandright}', "");
Expect(1, 43457, '\p{^InPC=bottomandright}', "");
Expect(1, 43457, '\P{InPC=bottomandright}', "");
Expect(0, 43457, '\P{^InPC=bottomandright}', "");
Expect(1, 43456, '\p{InPC= bottom_And_Right}', "");
Expect(0, 43456, '\p{^InPC= bottom_And_Right}', "");
Expect(0, 43456, '\P{InPC= bottom_And_Right}', "");
Expect(1, 43456, '\P{^InPC= bottom_And_Right}', "");
Expect(0, 43457, '\p{InPC= bottom_And_Right}', "");
Expect(1, 43457, '\p{^InPC= bottom_And_Right}', "");
Expect(1, 43457, '\P{InPC= bottom_And_Right}', "");
Expect(0, 43457, '\P{^InPC= bottom_And_Right}', "");
Error('\p{Is_Indic_Positional_Category=/a/-BOTTOM_AND_RIGHT}');
Error('\P{Is_Indic_Positional_Category=/a/-BOTTOM_AND_RIGHT}');
Expect(1, 43456, '\p{Is_Indic_Positional_Category=bottomandright}', "");
Expect(0, 43456, '\p{^Is_Indic_Positional_Category=bottomandright}', "");
Expect(0, 43456, '\P{Is_Indic_Positional_Category=bottomandright}', "");
Expect(1, 43456, '\P{^Is_Indic_Positional_Category=bottomandright}', "");
Expect(0, 43457, '\p{Is_Indic_Positional_Category=bottomandright}', "");
Expect(1, 43457, '\p{^Is_Indic_Positional_Category=bottomandright}', "");
Expect(1, 43457, '\P{Is_Indic_Positional_Category=bottomandright}', "");
Expect(0, 43457, '\P{^Is_Indic_Positional_Category=bottomandright}', "");
Expect(1, 43456, '\p{Is_Indic_Positional_Category=--Bottom_and_Right}', "");
Expect(0, 43456, '\p{^Is_Indic_Positional_Category=--Bottom_and_Right}', "");
Expect(0, 43456, '\P{Is_Indic_Positional_Category=--Bottom_and_Right}', "");
Expect(1, 43456, '\P{^Is_Indic_Positional_Category=--Bottom_and_Right}', "");
Expect(0, 43457, '\p{Is_Indic_Positional_Category=--Bottom_and_Right}', "");
Expect(1, 43457, '\p{^Is_Indic_Positional_Category=--Bottom_and_Right}', "");
Expect(1, 43457, '\P{Is_Indic_Positional_Category=--Bottom_and_Right}', "");
Expect(0, 43457, '\P{^Is_Indic_Positional_Category=--Bottom_and_Right}', "");
Error('\p{Is_InPC=	-Bottom_And_Right/a/}');
Error('\P{Is_InPC=	-Bottom_And_Right/a/}');
Expect(1, 43456, '\p{Is_InPC=bottomandright}', "");
Expect(0, 43456, '\p{^Is_InPC=bottomandright}', "");
Expect(0, 43456, '\P{Is_InPC=bottomandright}', "");
Expect(1, 43456, '\P{^Is_InPC=bottomandright}', "");
Expect(0, 43457, '\p{Is_InPC=bottomandright}', "");
Expect(1, 43457, '\p{^Is_InPC=bottomandright}', "");
Expect(1, 43457, '\P{Is_InPC=bottomandright}', "");
Expect(0, 43457, '\P{^Is_InPC=bottomandright}', "");
Expect(1, 43456, '\p{Is_InPC=_bottom_and_RIGHT}', "");
Expect(0, 43456, '\p{^Is_InPC=_bottom_and_RIGHT}', "");
Expect(0, 43456, '\P{Is_InPC=_bottom_and_RIGHT}', "");
Expect(1, 43456, '\P{^Is_InPC=_bottom_and_RIGHT}', "");
Expect(0, 43457, '\p{Is_InPC=_bottom_and_RIGHT}', "");
Expect(1, 43457, '\p{^Is_InPC=_bottom_and_RIGHT}', "");
Expect(1, 43457, '\P{Is_InPC=_bottom_and_RIGHT}', "");
Expect(0, 43457, '\P{^Is_InPC=_bottom_and_RIGHT}', "");
Error('\p{Indic_Positional_Category=/a/ 	Left}');
Error('\P{Indic_Positional_Category=/a/ 	Left}');
Expect(1, 71462, '\p{Indic_Positional_Category=left}', "");
Expect(0, 71462, '\p{^Indic_Positional_Category=left}', "");
Expect(0, 71462, '\P{Indic_Positional_Category=left}', "");
Expect(1, 71462, '\P{^Indic_Positional_Category=left}', "");
Expect(0, 71463, '\p{Indic_Positional_Category=left}', "");
Expect(1, 71463, '\p{^Indic_Positional_Category=left}', "");
Expect(1, 71463, '\P{Indic_Positional_Category=left}', "");
Expect(0, 71463, '\P{^Indic_Positional_Category=left}', "");
Expect(1, 71462, '\p{Indic_Positional_Category=_Left}', "");
Expect(0, 71462, '\p{^Indic_Positional_Category=_Left}', "");
Expect(0, 71462, '\P{Indic_Positional_Category=_Left}', "");
Expect(1, 71462, '\P{^Indic_Positional_Category=_Left}', "");
Expect(0, 71463, '\p{Indic_Positional_Category=_Left}', "");
Expect(1, 71463, '\p{^Indic_Positional_Category=_Left}', "");
Expect(1, 71463, '\P{Indic_Positional_Category=_Left}', "");
Expect(0, 71463, '\P{^Indic_Positional_Category=_Left}', "");
Error('\p{InPC=/a/-	Left}');
Error('\P{InPC=/a/-	Left}');
Expect(1, 71462, '\p{InPC=left}', "");
Expect(0, 71462, '\p{^InPC=left}', "");
Expect(0, 71462, '\P{InPC=left}', "");
Expect(1, 71462, '\P{^InPC=left}', "");
Expect(0, 71463, '\p{InPC=left}', "");
Expect(1, 71463, '\p{^InPC=left}', "");
Expect(1, 71463, '\P{InPC=left}', "");
Expect(0, 71463, '\P{^InPC=left}', "");
Expect(1, 71462, '\p{InPC= left}', "");
Expect(0, 71462, '\p{^InPC= left}', "");
Expect(0, 71462, '\P{InPC= left}', "");
Expect(1, 71462, '\P{^InPC= left}', "");
Expect(0, 71463, '\p{InPC= left}', "");
Expect(1, 71463, '\p{^InPC= left}', "");
Expect(1, 71463, '\P{InPC= left}', "");
Expect(0, 71463, '\P{^InPC= left}', "");
Error('\p{Is_Indic_Positional_Category=-_Left/a/}');
Error('\P{Is_Indic_Positional_Category=-_Left/a/}');
Expect(1, 71462, '\p{Is_Indic_Positional_Category=left}', "");
Expect(0, 71462, '\p{^Is_Indic_Positional_Category=left}', "");
Expect(0, 71462, '\P{Is_Indic_Positional_Category=left}', "");
Expect(1, 71462, '\P{^Is_Indic_Positional_Category=left}', "");
Expect(0, 71463, '\p{Is_Indic_Positional_Category=left}', "");
Expect(1, 71463, '\p{^Is_Indic_Positional_Category=left}', "");
Expect(1, 71463, '\P{Is_Indic_Positional_Category=left}', "");
Expect(0, 71463, '\P{^Is_Indic_Positional_Category=left}', "");
Expect(1, 71462, '\p{Is_Indic_Positional_Category= -left}', "");
Expect(0, 71462, '\p{^Is_Indic_Positional_Category= -left}', "");
Expect(0, 71462, '\P{Is_Indic_Positional_Category= -left}', "");
Expect(1, 71462, '\P{^Is_Indic_Positional_Category= -left}', "");
Expect(0, 71463, '\p{Is_Indic_Positional_Category= -left}', "");
Expect(1, 71463, '\p{^Is_Indic_Positional_Category= -left}', "");
Expect(1, 71463, '\P{Is_Indic_Positional_Category= -left}', "");
Expect(0, 71463, '\P{^Is_Indic_Positional_Category= -left}', "");
Error('\p{Is_InPC=-:=Left}');
Error('\P{Is_InPC=-:=Left}');
Expect(1, 71462, '\p{Is_InPC=left}', "");
Expect(0, 71462, '\p{^Is_InPC=left}', "");
Expect(0, 71462, '\P{Is_InPC=left}', "");
Expect(1, 71462, '\P{^Is_InPC=left}', "");
Expect(0, 71463, '\p{Is_InPC=left}', "");
Expect(1, 71463, '\p{^Is_InPC=left}', "");
Expect(1, 71463, '\P{Is_InPC=left}', "");
Expect(0, 71463, '\P{^Is_InPC=left}', "");
Expect(1, 71462, '\p{Is_InPC=	_Left}', "");
Expect(0, 71462, '\p{^Is_InPC=	_Left}', "");
Expect(0, 71462, '\P{Is_InPC=	_Left}', "");
Expect(1, 71462, '\P{^Is_InPC=	_Left}', "");
Expect(0, 71463, '\p{Is_InPC=	_Left}', "");
Expect(1, 71463, '\p{^Is_InPC=	_Left}', "");
Expect(1, 71463, '\P{Is_InPC=	_Left}', "");
Expect(0, 71463, '\P{^Is_InPC=	_Left}', "");
Error('\p{Indic_Positional_Category= -Left_And_right:=}');
Error('\P{Indic_Positional_Category= -Left_And_right:=}');
Expect(1, 71098, '\p{Indic_Positional_Category=leftandright}', "");
Expect(0, 71098, '\p{^Indic_Positional_Category=leftandright}', "");
Expect(0, 71098, '\P{Indic_Positional_Category=leftandright}', "");
Expect(1, 71098, '\P{^Indic_Positional_Category=leftandright}', "");
Expect(0, 71099, '\p{Indic_Positional_Category=leftandright}', "");
Expect(1, 71099, '\p{^Indic_Positional_Category=leftandright}', "");
Expect(1, 71099, '\P{Indic_Positional_Category=leftandright}', "");
Expect(0, 71099, '\P{^Indic_Positional_Category=leftandright}', "");
Expect(1, 71098, '\p{Indic_Positional_Category=_Left_AND_RIGHT}', "");
Expect(0, 71098, '\p{^Indic_Positional_Category=_Left_AND_RIGHT}', "");
Expect(0, 71098, '\P{Indic_Positional_Category=_Left_AND_RIGHT}', "");
Expect(1, 71098, '\P{^Indic_Positional_Category=_Left_AND_RIGHT}', "");
Expect(0, 71099, '\p{Indic_Positional_Category=_Left_AND_RIGHT}', "");
Expect(1, 71099, '\p{^Indic_Positional_Category=_Left_AND_RIGHT}', "");
Expect(1, 71099, '\P{Indic_Positional_Category=_Left_AND_RIGHT}', "");
Expect(0, 71099, '\P{^Indic_Positional_Category=_Left_AND_RIGHT}', "");
Error('\p{InPC=/a/Left_AND_RIGHT}');
Error('\P{InPC=/a/Left_AND_RIGHT}');
Expect(1, 71098, '\p{InPC=leftandright}', "");
Expect(0, 71098, '\p{^InPC=leftandright}', "");
Expect(0, 71098, '\P{InPC=leftandright}', "");
Expect(1, 71098, '\P{^InPC=leftandright}', "");
Expect(0, 71099, '\p{InPC=leftandright}', "");
Expect(1, 71099, '\p{^InPC=leftandright}', "");
Expect(1, 71099, '\P{InPC=leftandright}', "");
Expect(0, 71099, '\P{^InPC=leftandright}', "");
Expect(1, 71098, '\p{InPC=_LEFT_AND_RIGHT}', "");
Expect(0, 71098, '\p{^InPC=_LEFT_AND_RIGHT}', "");
Expect(0, 71098, '\P{InPC=_LEFT_AND_RIGHT}', "");
Expect(1, 71098, '\P{^InPC=_LEFT_AND_RIGHT}', "");
Expect(0, 71099, '\p{InPC=_LEFT_AND_RIGHT}', "");
Expect(1, 71099, '\p{^InPC=_LEFT_AND_RIGHT}', "");
Expect(1, 71099, '\P{InPC=_LEFT_AND_RIGHT}', "");
Expect(0, 71099, '\P{^InPC=_LEFT_AND_RIGHT}', "");
Error('\p{Is_Indic_Positional_Category:   	/a/left_And_Right}');
Error('\P{Is_Indic_Positional_Category:   	/a/left_And_Right}');
Expect(1, 71098, '\p{Is_Indic_Positional_Category:leftandright}', "");
Expect(0, 71098, '\p{^Is_Indic_Positional_Category:leftandright}', "");
Expect(0, 71098, '\P{Is_Indic_Positional_Category:leftandright}', "");
Expect(1, 71098, '\P{^Is_Indic_Positional_Category:leftandright}', "");
Expect(0, 71099, '\p{Is_Indic_Positional_Category:leftandright}', "");
Expect(1, 71099, '\p{^Is_Indic_Positional_Category:leftandright}', "");
Expect(1, 71099, '\P{Is_Indic_Positional_Category:leftandright}', "");
Expect(0, 71099, '\P{^Is_Indic_Positional_Category:leftandright}', "");
Expect(1, 71098, '\p{Is_Indic_Positional_Category=	-Left_AND_Right}', "");
Expect(0, 71098, '\p{^Is_Indic_Positional_Category=	-Left_AND_Right}', "");
Expect(0, 71098, '\P{Is_Indic_Positional_Category=	-Left_AND_Right}', "");
Expect(1, 71098, '\P{^Is_Indic_Positional_Category=	-Left_AND_Right}', "");
Expect(0, 71099, '\p{Is_Indic_Positional_Category=	-Left_AND_Right}', "");
Expect(1, 71099, '\p{^Is_Indic_Positional_Category=	-Left_AND_Right}', "");
Expect(1, 71099, '\P{Is_Indic_Positional_Category=	-Left_AND_Right}', "");
Expect(0, 71099, '\P{^Is_Indic_Positional_Category=	-Left_AND_Right}', "");
Error('\p{Is_InPC=:= -LEFT_and_Right}');
Error('\P{Is_InPC=:= -LEFT_and_Right}');
Expect(1, 71098, '\p{Is_InPC=leftandright}', "");
Expect(0, 71098, '\p{^Is_InPC=leftandright}', "");
Expect(0, 71098, '\P{Is_InPC=leftandright}', "");
Expect(1, 71098, '\P{^Is_InPC=leftandright}', "");
Expect(0, 71099, '\p{Is_InPC=leftandright}', "");
Expect(1, 71099, '\p{^Is_InPC=leftandright}', "");
Expect(1, 71099, '\P{Is_InPC=leftandright}', "");
Expect(0, 71099, '\P{^Is_InPC=leftandright}', "");
Expect(1, 71098, '\p{Is_InPC=_Left_AND_RIGHT}', "");
Expect(0, 71098, '\p{^Is_InPC=_Left_AND_RIGHT}', "");
Expect(0, 71098, '\P{Is_InPC=_Left_AND_RIGHT}', "");
Expect(1, 71098, '\P{^Is_InPC=_Left_AND_RIGHT}', "");
Expect(0, 71099, '\p{Is_InPC=_Left_AND_RIGHT}', "");
Expect(1, 71099, '\p{^Is_InPC=_Left_AND_RIGHT}', "");
Expect(1, 71099, '\P{Is_InPC=_Left_AND_RIGHT}', "");
Expect(0, 71099, '\P{^Is_InPC=_Left_AND_RIGHT}', "");
Error('\p{Indic_Positional_Category=__NA:=}');
Error('\P{Indic_Positional_Category=__NA:=}');
Expect(1, 71468, '\p{Indic_Positional_Category=na}', "");
Expect(0, 71468, '\p{^Indic_Positional_Category=na}', "");
Expect(0, 71468, '\P{Indic_Positional_Category=na}', "");
Expect(1, 71468, '\P{^Indic_Positional_Category=na}', "");
Expect(0, 71467, '\p{Indic_Positional_Category=na}', "");
Expect(1, 71467, '\p{^Indic_Positional_Category=na}', "");
Expect(1, 71467, '\P{Indic_Positional_Category=na}', "");
Expect(0, 71467, '\P{^Indic_Positional_Category=na}', "");
Expect(1, 71468, '\p{Indic_Positional_Category=	_NA}', "");
Expect(0, 71468, '\p{^Indic_Positional_Category=	_NA}', "");
Expect(0, 71468, '\P{Indic_Positional_Category=	_NA}', "");
Expect(1, 71468, '\P{^Indic_Positional_Category=	_NA}', "");
Expect(0, 71467, '\p{Indic_Positional_Category=	_NA}', "");
Expect(1, 71467, '\p{^Indic_Positional_Category=	_NA}', "");
Expect(1, 71467, '\P{Indic_Positional_Category=	_NA}', "");
Expect(0, 71467, '\P{^Indic_Positional_Category=	_NA}', "");
Error('\p{InPC=	na/a/}');
Error('\P{InPC=	na/a/}');
Expect(1, 71468, '\p{InPC: na}', "");
Expect(0, 71468, '\p{^InPC: na}', "");
Expect(0, 71468, '\P{InPC: na}', "");
Expect(1, 71468, '\P{^InPC: na}', "");
Expect(0, 71467, '\p{InPC: na}', "");
Expect(1, 71467, '\p{^InPC: na}', "");
Expect(1, 71467, '\P{InPC: na}', "");
Expect(0, 71467, '\P{^InPC: na}', "");
Expect(1, 71468, '\p{InPC=_NA}', "");
Expect(0, 71468, '\p{^InPC=_NA}', "");
Expect(0, 71468, '\P{InPC=_NA}', "");
Expect(1, 71468, '\P{^InPC=_NA}', "");
Expect(0, 71467, '\p{InPC=_NA}', "");
Expect(1, 71467, '\p{^InPC=_NA}', "");
Expect(1, 71467, '\P{InPC=_NA}', "");
Expect(0, 71467, '\P{^InPC=_NA}', "");
Error('\p{Is_Indic_Positional_Category=	/a/na}');
Error('\P{Is_Indic_Positional_Category=	/a/na}');
Expect(1, 71468, '\p{Is_Indic_Positional_Category=na}', "");
Expect(0, 71468, '\p{^Is_Indic_Positional_Category=na}', "");
Expect(0, 71468, '\P{Is_Indic_Positional_Category=na}', "");
Expect(1, 71468, '\P{^Is_Indic_Positional_Category=na}', "");
Expect(0, 71467, '\p{Is_Indic_Positional_Category=na}', "");
Expect(1, 71467, '\p{^Is_Indic_Positional_Category=na}', "");
Expect(1, 71467, '\P{Is_Indic_Positional_Category=na}', "");
Expect(0, 71467, '\P{^Is_Indic_Positional_Category=na}', "");
Expect(1, 71468, '\p{Is_Indic_Positional_Category=	-NA}', "");
Expect(0, 71468, '\p{^Is_Indic_Positional_Category=	-NA}', "");
Expect(0, 71468, '\P{Is_Indic_Positional_Category=	-NA}', "");
Expect(1, 71468, '\P{^Is_Indic_Positional_Category=	-NA}', "");
Expect(0, 71467, '\p{Is_Indic_Positional_Category=	-NA}', "");
Expect(1, 71467, '\p{^Is_Indic_Positional_Category=	-NA}', "");
Expect(1, 71467, '\P{Is_Indic_Positional_Category=	-NA}', "");
Expect(0, 71467, '\P{^Is_Indic_Positional_Category=	-NA}', "");
Error('\p{Is_InPC= -NA/a/}');
Error('\P{Is_InPC= -NA/a/}');
Expect(1, 71468, '\p{Is_InPC=na}', "");
Expect(0, 71468, '\p{^Is_InPC=na}', "");
Expect(0, 71468, '\P{Is_InPC=na}', "");
Expect(1, 71468, '\P{^Is_InPC=na}', "");
Expect(0, 71467, '\p{Is_InPC=na}', "");
Expect(1, 71467, '\p{^Is_InPC=na}', "");
Expect(1, 71467, '\P{Is_InPC=na}', "");
Expect(0, 71467, '\P{^Is_InPC=na}', "");
Expect(1, 71468, '\p{Is_InPC=	NA}', "");
Expect(0, 71468, '\p{^Is_InPC=	NA}', "");
Expect(0, 71468, '\P{Is_InPC=	NA}', "");
Expect(1, 71468, '\P{^Is_InPC=	NA}', "");
Expect(0, 71467, '\p{Is_InPC=	NA}', "");
Expect(1, 71467, '\p{^Is_InPC=	NA}', "");
Expect(1, 71467, '\P{Is_InPC=	NA}', "");
Expect(0, 71467, '\P{^Is_InPC=	NA}', "");
Error('\p{Indic_Positional_Category=:= 	Overstruck}');
Error('\P{Indic_Positional_Category=:= 	Overstruck}');
Expect(1, 68102, '\p{Indic_Positional_Category=overstruck}', "");
Expect(0, 68102, '\p{^Indic_Positional_Category=overstruck}', "");
Expect(0, 68102, '\P{Indic_Positional_Category=overstruck}', "");
Expect(1, 68102, '\P{^Indic_Positional_Category=overstruck}', "");
Expect(0, 68103, '\p{Indic_Positional_Category=overstruck}', "");
Expect(1, 68103, '\p{^Indic_Positional_Category=overstruck}', "");
Expect(1, 68103, '\P{Indic_Positional_Category=overstruck}', "");
Expect(0, 68103, '\P{^Indic_Positional_Category=overstruck}', "");
Expect(1, 68102, '\p{Indic_Positional_Category= -overstruck}', "");
Expect(0, 68102, '\p{^Indic_Positional_Category= -overstruck}', "");
Expect(0, 68102, '\P{Indic_Positional_Category= -overstruck}', "");
Expect(1, 68102, '\P{^Indic_Positional_Category= -overstruck}', "");
Expect(0, 68103, '\p{Indic_Positional_Category= -overstruck}', "");
Expect(1, 68103, '\p{^Indic_Positional_Category= -overstruck}', "");
Expect(1, 68103, '\P{Indic_Positional_Category= -overstruck}', "");
Expect(0, 68103, '\P{^Indic_Positional_Category= -overstruck}', "");
Error('\p{InPC=:=	_overstruck}');
Error('\P{InPC=:=	_overstruck}');
Expect(1, 68102, '\p{InPC=overstruck}', "");
Expect(0, 68102, '\p{^InPC=overstruck}', "");
Expect(0, 68102, '\P{InPC=overstruck}', "");
Expect(1, 68102, '\P{^InPC=overstruck}', "");
Expect(0, 68103, '\p{InPC=overstruck}', "");
Expect(1, 68103, '\p{^InPC=overstruck}', "");
Expect(1, 68103, '\P{InPC=overstruck}', "");
Expect(0, 68103, '\P{^InPC=overstruck}', "");
Expect(1, 68102, '\p{InPC=		overstruck}', "");
Expect(0, 68102, '\p{^InPC=		overstruck}', "");
Expect(0, 68102, '\P{InPC=		overstruck}', "");
Expect(1, 68102, '\P{^InPC=		overstruck}', "");
Expect(0, 68103, '\p{InPC=		overstruck}', "");
Expect(1, 68103, '\p{^InPC=		overstruck}', "");
Expect(1, 68103, '\P{InPC=		overstruck}', "");
Expect(0, 68103, '\P{^InPC=		overstruck}', "");
Error('\p{Is_Indic_Positional_Category=/a/OVERSTRUCK}');
Error('\P{Is_Indic_Positional_Category=/a/OVERSTRUCK}');
Expect(1, 68102, '\p{Is_Indic_Positional_Category=overstruck}', "");
Expect(0, 68102, '\p{^Is_Indic_Positional_Category=overstruck}', "");
Expect(0, 68102, '\P{Is_Indic_Positional_Category=overstruck}', "");
Expect(1, 68102, '\P{^Is_Indic_Positional_Category=overstruck}', "");
Expect(0, 68103, '\p{Is_Indic_Positional_Category=overstruck}', "");
Expect(1, 68103, '\p{^Is_Indic_Positional_Category=overstruck}', "");
Expect(1, 68103, '\P{Is_Indic_Positional_Category=overstruck}', "");
Expect(0, 68103, '\P{^Is_Indic_Positional_Category=overstruck}', "");
Expect(1, 68102, '\p{Is_Indic_Positional_Category=_Overstruck}', "");
Expect(0, 68102, '\p{^Is_Indic_Positional_Category=_Overstruck}', "");
Expect(0, 68102, '\P{Is_Indic_Positional_Category=_Overstruck}', "");
Expect(1, 68102, '\P{^Is_Indic_Positional_Category=_Overstruck}', "");
Expect(0, 68103, '\p{Is_Indic_Positional_Category=_Overstruck}', "");
Expect(1, 68103, '\p{^Is_Indic_Positional_Category=_Overstruck}', "");
Expect(1, 68103, '\P{Is_Indic_Positional_Category=_Overstruck}', "");
Expect(0, 68103, '\P{^Is_Indic_Positional_Category=_Overstruck}', "");
Error('\p{Is_InPC=	/a/overstruck}');
Error('\P{Is_InPC=	/a/overstruck}');
Expect(1, 68102, '\p{Is_InPC=overstruck}', "");
Expect(0, 68102, '\p{^Is_InPC=overstruck}', "");
Expect(0, 68102, '\P{Is_InPC=overstruck}', "");
Expect(1, 68102, '\P{^Is_InPC=overstruck}', "");
Expect(0, 68103, '\p{Is_InPC=overstruck}', "");
Expect(1, 68103, '\p{^Is_InPC=overstruck}', "");
Expect(1, 68103, '\P{Is_InPC=overstruck}', "");
Expect(0, 68103, '\P{^Is_InPC=overstruck}', "");
Expect(1, 68102, '\p{Is_InPC=_Overstruck}', "");
Expect(0, 68102, '\p{^Is_InPC=_Overstruck}', "");
Expect(0, 68102, '\P{Is_InPC=_Overstruck}', "");
Expect(1, 68102, '\P{^Is_InPC=_Overstruck}', "");
Expect(0, 68103, '\p{Is_InPC=_Overstruck}', "");
Expect(1, 68103, '\p{^Is_InPC=_Overstruck}', "");
Expect(1, 68103, '\P{Is_InPC=_Overstruck}', "");
Expect(0, 68103, '\P{^Is_InPC=_Overstruck}', "");
Error('\p{Indic_Positional_Category=_-RIGHT/a/}');
Error('\P{Indic_Positional_Category=_-RIGHT/a/}');
Expect(1, 71457, '\p{Indic_Positional_Category=right}', "");
Expect(0, 71457, '\p{^Indic_Positional_Category=right}', "");
Expect(0, 71457, '\P{Indic_Positional_Category=right}', "");
Expect(1, 71457, '\P{^Indic_Positional_Category=right}', "");
Expect(0, 71458, '\p{Indic_Positional_Category=right}', "");
Expect(1, 71458, '\p{^Indic_Positional_Category=right}', "");
Expect(1, 71458, '\P{Indic_Positional_Category=right}', "");
Expect(0, 71458, '\P{^Indic_Positional_Category=right}', "");
Expect(1, 71457, '\p{Indic_Positional_Category:    _RIGHT}', "");
Expect(0, 71457, '\p{^Indic_Positional_Category:    _RIGHT}', "");
Expect(0, 71457, '\P{Indic_Positional_Category:    _RIGHT}', "");
Expect(1, 71457, '\P{^Indic_Positional_Category:    _RIGHT}', "");
Expect(0, 71458, '\p{Indic_Positional_Category:    _RIGHT}', "");
Expect(1, 71458, '\p{^Indic_Positional_Category:    _RIGHT}', "");
Expect(1, 71458, '\P{Indic_Positional_Category:    _RIGHT}', "");
Expect(0, 71458, '\P{^Indic_Positional_Category:    _RIGHT}', "");
Error('\p{InPC:- Right:=}');
Error('\P{InPC:- Right:=}');
Expect(1, 71457, '\p{InPC:	right}', "");
Expect(0, 71457, '\p{^InPC:	right}', "");
Expect(0, 71457, '\P{InPC:	right}', "");
Expect(1, 71457, '\P{^InPC:	right}', "");
Expect(0, 71458, '\p{InPC:	right}', "");
Expect(1, 71458, '\p{^InPC:	right}', "");
Expect(1, 71458, '\P{InPC:	right}', "");
Expect(0, 71458, '\P{^InPC:	right}', "");
Expect(1, 71457, '\p{InPC: _Right}', "");
Expect(0, 71457, '\p{^InPC: _Right}', "");
Expect(0, 71457, '\P{InPC: _Right}', "");
Expect(1, 71457, '\P{^InPC: _Right}', "");
Expect(0, 71458, '\p{InPC: _Right}', "");
Expect(1, 71458, '\p{^InPC: _Right}', "");
Expect(1, 71458, '\P{InPC: _Right}', "");
Expect(0, 71458, '\P{^InPC: _Right}', "");
Error('\p{Is_Indic_Positional_Category= -Right/a/}');
Error('\P{Is_Indic_Positional_Category= -Right/a/}');
Expect(1, 71457, '\p{Is_Indic_Positional_Category=right}', "");
Expect(0, 71457, '\p{^Is_Indic_Positional_Category=right}', "");
Expect(0, 71457, '\P{Is_Indic_Positional_Category=right}', "");
Expect(1, 71457, '\P{^Is_Indic_Positional_Category=right}', "");
Expect(0, 71458, '\p{Is_Indic_Positional_Category=right}', "");
Expect(1, 71458, '\p{^Is_Indic_Positional_Category=right}', "");
Expect(1, 71458, '\P{Is_Indic_Positional_Category=right}', "");
Expect(0, 71458, '\P{^Is_Indic_Positional_Category=right}', "");
Expect(1, 71457, '\p{Is_Indic_Positional_Category=	-RIGHT}', "");
Expect(0, 71457, '\p{^Is_Indic_Positional_Category=	-RIGHT}', "");
Expect(0, 71457, '\P{Is_Indic_Positional_Category=	-RIGHT}', "");
Expect(1, 71457, '\P{^Is_Indic_Positional_Category=	-RIGHT}', "");
Expect(0, 71458, '\p{Is_Indic_Positional_Category=	-RIGHT}', "");
Expect(1, 71458, '\p{^Is_Indic_Positional_Category=	-RIGHT}', "");
Expect(1, 71458, '\P{Is_Indic_Positional_Category=	-RIGHT}', "");
Expect(0, 71458, '\P{^Is_Indic_Positional_Category=	-RIGHT}', "");
Error('\p{Is_InPC=/a/--right}');
Error('\P{Is_InPC=/a/--right}');
Expect(1, 71457, '\p{Is_InPC:right}', "");
Expect(0, 71457, '\p{^Is_InPC:right}', "");
Expect(0, 71457, '\P{Is_InPC:right}', "");
Expect(1, 71457, '\P{^Is_InPC:right}', "");
Expect(0, 71458, '\p{Is_InPC:right}', "");
Expect(1, 71458, '\p{^Is_InPC:right}', "");
Expect(1, 71458, '\P{Is_InPC:right}', "");
Expect(0, 71458, '\P{^Is_InPC:right}', "");
Expect(1, 71457, '\p{Is_InPC:-_right}', "");
Expect(0, 71457, '\p{^Is_InPC:-_right}', "");
Expect(0, 71457, '\P{Is_InPC:-_right}', "");
Expect(1, 71457, '\P{^Is_InPC:-_right}', "");
Expect(0, 71458, '\p{Is_InPC:-_right}', "");
Expect(1, 71458, '\p{^Is_InPC:-_right}', "");
Expect(1, 71458, '\P{Is_InPC:-_right}', "");
Expect(0, 71458, '\P{^Is_InPC:-_right}', "");
Error('\p{Indic_Positional_Category=/a/ -TOP}');
Error('\P{Indic_Positional_Category=/a/ -TOP}');
Expect(1, 71467, '\p{Indic_Positional_Category=top}', "");
Expect(0, 71467, '\p{^Indic_Positional_Category=top}', "");
Expect(0, 71467, '\P{Indic_Positional_Category=top}', "");
Expect(1, 71467, '\P{^Indic_Positional_Category=top}', "");
Expect(0, 71468, '\p{Indic_Positional_Category=top}', "");
Expect(1, 71468, '\p{^Indic_Positional_Category=top}', "");
Expect(1, 71468, '\P{Indic_Positional_Category=top}', "");
Expect(0, 71468, '\P{^Indic_Positional_Category=top}', "");
Expect(1, 71467, '\p{Indic_Positional_Category=__top}', "");
Expect(0, 71467, '\p{^Indic_Positional_Category=__top}', "");
Expect(0, 71467, '\P{Indic_Positional_Category=__top}', "");
Expect(1, 71467, '\P{^Indic_Positional_Category=__top}', "");
Expect(0, 71468, '\p{Indic_Positional_Category=__top}', "");
Expect(1, 71468, '\p{^Indic_Positional_Category=__top}', "");
Expect(1, 71468, '\P{Indic_Positional_Category=__top}', "");
Expect(0, 71468, '\P{^Indic_Positional_Category=__top}', "");
Error('\p{InPC=_/a/TOP}');
Error('\P{InPC=_/a/TOP}');
Expect(1, 71467, '\p{InPC=top}', "");
Expect(0, 71467, '\p{^InPC=top}', "");
Expect(0, 71467, '\P{InPC=top}', "");
Expect(1, 71467, '\P{^InPC=top}', "");
Expect(0, 71468, '\p{InPC=top}', "");
Expect(1, 71468, '\p{^InPC=top}', "");
Expect(1, 71468, '\P{InPC=top}', "");
Expect(0, 71468, '\P{^InPC=top}', "");
Expect(1, 71467, '\p{InPC=	_TOP}', "");
Expect(0, 71467, '\p{^InPC=	_TOP}', "");
Expect(0, 71467, '\P{InPC=	_TOP}', "");
Expect(1, 71467, '\P{^InPC=	_TOP}', "");
Expect(0, 71468, '\p{InPC=	_TOP}', "");
Expect(1, 71468, '\p{^InPC=	_TOP}', "");
Expect(1, 71468, '\P{InPC=	_TOP}', "");
Expect(0, 71468, '\P{^InPC=	_TOP}', "");
Error('\p{Is_Indic_Positional_Category=:= _Top}');
Error('\P{Is_Indic_Positional_Category=:= _Top}');
Expect(1, 71467, '\p{Is_Indic_Positional_Category=top}', "");
Expect(0, 71467, '\p{^Is_Indic_Positional_Category=top}', "");
Expect(0, 71467, '\P{Is_Indic_Positional_Category=top}', "");
Expect(1, 71467, '\P{^Is_Indic_Positional_Category=top}', "");
Expect(0, 71468, '\p{Is_Indic_Positional_Category=top}', "");
Expect(1, 71468, '\p{^Is_Indic_Positional_Category=top}', "");
Expect(1, 71468, '\P{Is_Indic_Positional_Category=top}', "");
Expect(0, 71468, '\P{^Is_Indic_Positional_Category=top}', "");
Expect(1, 71467, '\p{Is_Indic_Positional_Category=	TOP}', "");
Expect(0, 71467, '\p{^Is_Indic_Positional_Category=	TOP}', "");
Expect(0, 71467, '\P{Is_Indic_Positional_Category=	TOP}', "");
Expect(1, 71467, '\P{^Is_Indic_Positional_Category=	TOP}', "");
Expect(0, 71468, '\p{Is_Indic_Positional_Category=	TOP}', "");
Expect(1, 71468, '\p{^Is_Indic_Positional_Category=	TOP}', "");
Expect(1, 71468, '\P{Is_Indic_Positional_Category=	TOP}', "");
Expect(0, 71468, '\P{^Is_Indic_Positional_Category=	TOP}', "");
Error('\p{Is_InPC=_ Top/a/}');
Error('\P{Is_InPC=_ Top/a/}');
Expect(1, 71467, '\p{Is_InPC=top}', "");
Expect(0, 71467, '\p{^Is_InPC=top}', "");
Expect(0, 71467, '\P{Is_InPC=top}', "");
Expect(1, 71467, '\P{^Is_InPC=top}', "");
Expect(0, 71468, '\p{Is_InPC=top}', "");
Expect(1, 71468, '\p{^Is_InPC=top}', "");
Expect(1, 71468, '\P{Is_InPC=top}', "");
Expect(0, 71468, '\P{^Is_InPC=top}', "");
Expect(1, 71467, '\p{Is_InPC: Top}', "");
Expect(0, 71467, '\p{^Is_InPC: Top}', "");
Expect(0, 71467, '\P{Is_InPC: Top}', "");
Expect(1, 71467, '\P{^Is_InPC: Top}', "");
Expect(0, 71468, '\p{Is_InPC: Top}', "");
Expect(1, 71468, '\p{^Is_InPC: Top}', "");
Expect(1, 71468, '\P{Is_InPC: Top}', "");
Expect(0, 71468, '\P{^Is_InPC: Top}', "");
Error('\p{Indic_Positional_Category=:=-TOP_AND_BOTTOM}');
Error('\P{Indic_Positional_Category=:=-TOP_AND_BOTTOM}');
Expect(1, 69935, '\p{Indic_Positional_Category=topandbottom}', "");
Expect(0, 69935, '\p{^Indic_Positional_Category=topandbottom}', "");
Expect(0, 69935, '\P{Indic_Positional_Category=topandbottom}', "");
Expect(1, 69935, '\P{^Indic_Positional_Category=topandbottom}', "");
Expect(0, 69936, '\p{Indic_Positional_Category=topandbottom}', "");
Expect(1, 69936, '\p{^Indic_Positional_Category=topandbottom}', "");
Expect(1, 69936, '\P{Indic_Positional_Category=topandbottom}', "");
Expect(0, 69936, '\P{^Indic_Positional_Category=topandbottom}', "");
Expect(1, 69935, '\p{Indic_Positional_Category= 	top_AND_BOTTOM}', "");
Expect(0, 69935, '\p{^Indic_Positional_Category= 	top_AND_BOTTOM}', "");
Expect(0, 69935, '\P{Indic_Positional_Category= 	top_AND_BOTTOM}', "");
Expect(1, 69935, '\P{^Indic_Positional_Category= 	top_AND_BOTTOM}', "");
Expect(0, 69936, '\p{Indic_Positional_Category= 	top_AND_BOTTOM}', "");
Expect(1, 69936, '\p{^Indic_Positional_Category= 	top_AND_BOTTOM}', "");
Expect(1, 69936, '\P{Indic_Positional_Category= 	top_AND_BOTTOM}', "");
Expect(0, 69936, '\P{^Indic_Positional_Category= 	top_AND_BOTTOM}', "");
Error('\p{InPC:   	:=TOP_AND_bottom}');
Error('\P{InPC:   	:=TOP_AND_bottom}');
Expect(1, 69935, '\p{InPC=topandbottom}', "");
Expect(0, 69935, '\p{^InPC=topandbottom}', "");
Expect(0, 69935, '\P{InPC=topandbottom}', "");
Expect(1, 69935, '\P{^InPC=topandbottom}', "");
Expect(0, 69936, '\p{InPC=topandbottom}', "");
Expect(1, 69936, '\p{^InPC=topandbottom}', "");
Expect(1, 69936, '\P{InPC=topandbottom}', "");
Expect(0, 69936, '\P{^InPC=topandbottom}', "");
Expect(1, 69935, '\p{InPC=_	Top_AND_Bottom}', "");
Expect(0, 69935, '\p{^InPC=_	Top_AND_Bottom}', "");
Expect(0, 69935, '\P{InPC=_	Top_AND_Bottom}', "");
Expect(1, 69935, '\P{^InPC=_	Top_AND_Bottom}', "");
Expect(0, 69936, '\p{InPC=_	Top_AND_Bottom}', "");
Expect(1, 69936, '\p{^InPC=_	Top_AND_Bottom}', "");
Expect(1, 69936, '\P{InPC=_	Top_AND_Bottom}', "");
Expect(0, 69936, '\P{^InPC=_	Top_AND_Bottom}', "");
Error('\p{Is_Indic_Positional_Category=-/a/Top_AND_Bottom}');
Error('\P{Is_Indic_Positional_Category=-/a/Top_AND_Bottom}');
Expect(1, 69935, '\p{Is_Indic_Positional_Category=topandbottom}', "");
Expect(0, 69935, '\p{^Is_Indic_Positional_Category=topandbottom}', "");
Expect(0, 69935, '\P{Is_Indic_Positional_Category=topandbottom}', "");
Expect(1, 69935, '\P{^Is_Indic_Positional_Category=topandbottom}', "");
Expect(0, 69936, '\p{Is_Indic_Positional_Category=topandbottom}', "");
Expect(1, 69936, '\p{^Is_Indic_Positional_Category=topandbottom}', "");
Expect(1, 69936, '\P{Is_Indic_Positional_Category=topandbottom}', "");
Expect(0, 69936, '\P{^Is_Indic_Positional_Category=topandbottom}', "");
Expect(1, 69935, '\p{Is_Indic_Positional_Category= _Top_And_bottom}', "");
Expect(0, 69935, '\p{^Is_Indic_Positional_Category= _Top_And_bottom}', "");
Expect(0, 69935, '\P{Is_Indic_Positional_Category= _Top_And_bottom}', "");
Expect(1, 69935, '\P{^Is_Indic_Positional_Category= _Top_And_bottom}', "");
Expect(0, 69936, '\p{Is_Indic_Positional_Category= _Top_And_bottom}', "");
Expect(1, 69936, '\p{^Is_Indic_Positional_Category= _Top_And_bottom}', "");
Expect(1, 69936, '\P{Is_Indic_Positional_Category= _Top_And_bottom}', "");
Expect(0, 69936, '\P{^Is_Indic_Positional_Category= _Top_And_bottom}', "");
Error('\p{Is_InPC= /a/Top_And_Bottom}');
Error('\P{Is_InPC= /a/Top_And_Bottom}');
Expect(1, 69935, '\p{Is_InPC=topandbottom}', "");
Expect(0, 69935, '\p{^Is_InPC=topandbottom}', "");
Expect(0, 69935, '\P{Is_InPC=topandbottom}', "");
Expect(1, 69935, '\P{^Is_InPC=topandbottom}', "");
Expect(0, 69936, '\p{Is_InPC=topandbottom}', "");
Expect(1, 69936, '\p{^Is_InPC=topandbottom}', "");
Expect(1, 69936, '\P{Is_InPC=topandbottom}', "");
Expect(0, 69936, '\P{^Is_InPC=topandbottom}', "");
Expect(1, 69935, '\p{Is_InPC=_ Top_AND_Bottom}', "");
Expect(0, 69935, '\p{^Is_InPC=_ Top_AND_Bottom}', "");
Expect(0, 69935, '\P{Is_InPC=_ Top_AND_Bottom}', "");
Expect(1, 69935, '\P{^Is_InPC=_ Top_AND_Bottom}', "");
Expect(0, 69936, '\p{Is_InPC=_ Top_AND_Bottom}', "");
Expect(1, 69936, '\p{^Is_InPC=_ Top_AND_Bottom}', "");
Expect(1, 69936, '\P{Is_InPC=_ Top_AND_Bottom}', "");
Expect(0, 69936, '\P{^Is_InPC=_ Top_AND_Bottom}', "");
Error('\p{Indic_Positional_Category=/a/	_Top_and_bottom_AND_Right}');
Error('\P{Indic_Positional_Category=/a/	_Top_and_bottom_AND_Right}');
Expect(1, 6973, '\p{Indic_Positional_Category=topandbottomandright}', "");
Expect(0, 6973, '\p{^Indic_Positional_Category=topandbottomandright}', "");
Expect(0, 6973, '\P{Indic_Positional_Category=topandbottomandright}', "");
Expect(1, 6973, '\P{^Indic_Positional_Category=topandbottomandright}', "");
Expect(0, 6974, '\p{Indic_Positional_Category=topandbottomandright}', "");
Expect(1, 6974, '\p{^Indic_Positional_Category=topandbottomandright}', "");
Expect(1, 6974, '\P{Indic_Positional_Category=topandbottomandright}', "");
Expect(0, 6974, '\P{^Indic_Positional_Category=topandbottomandright}', "");
Expect(1, 6973, '\p{Indic_Positional_Category=_	top_And_Bottom_AND_Right}', "");
Expect(0, 6973, '\p{^Indic_Positional_Category=_	top_And_Bottom_AND_Right}', "");
Expect(0, 6973, '\P{Indic_Positional_Category=_	top_And_Bottom_AND_Right}', "");
Expect(1, 6973, '\P{^Indic_Positional_Category=_	top_And_Bottom_AND_Right}', "");
Expect(0, 6974, '\p{Indic_Positional_Category=_	top_And_Bottom_AND_Right}', "");
Expect(1, 6974, '\p{^Indic_Positional_Category=_	top_And_Bottom_AND_Right}', "");
Expect(1, 6974, '\P{Indic_Positional_Category=_	top_And_Bottom_AND_Right}', "");
Expect(0, 6974, '\P{^Indic_Positional_Category=_	top_And_Bottom_AND_Right}', "");
Error('\p{InPC=:=-_Top_And_bottom_And_right}');
Error('\P{InPC=:=-_Top_And_bottom_And_right}');
Expect(1, 6973, '\p{InPC=topandbottomandright}', "");
Expect(0, 6973, '\p{^InPC=topandbottomandright}', "");
Expect(0, 6973, '\P{InPC=topandbottomandright}', "");
Expect(1, 6973, '\P{^InPC=topandbottomandright}', "");
Expect(0, 6974, '\p{InPC=topandbottomandright}', "");
Expect(1, 6974, '\p{^InPC=topandbottomandright}', "");
Expect(1, 6974, '\P{InPC=topandbottomandright}', "");
Expect(0, 6974, '\P{^InPC=topandbottomandright}', "");
Expect(1, 6973, '\p{InPC=-	TOP_And_Bottom_AND_right}', "");
Expect(0, 6973, '\p{^InPC=-	TOP_And_Bottom_AND_right}', "");
Expect(0, 6973, '\P{InPC=-	TOP_And_Bottom_AND_right}', "");
Expect(1, 6973, '\P{^InPC=-	TOP_And_Bottom_AND_right}', "");
Expect(0, 6974, '\p{InPC=-	TOP_And_Bottom_AND_right}', "");
Expect(1, 6974, '\p{^InPC=-	TOP_And_Bottom_AND_right}', "");
Expect(1, 6974, '\P{InPC=-	TOP_And_Bottom_AND_right}', "");
Expect(0, 6974, '\P{^InPC=-	TOP_And_Bottom_AND_right}', "");
Error('\p{Is_Indic_Positional_Category:  top_And_Bottom_AND_right:=}');
Error('\P{Is_Indic_Positional_Category:  top_And_Bottom_AND_right:=}');
Expect(1, 6973, '\p{Is_Indic_Positional_Category=topandbottomandright}', "");
Expect(0, 6973, '\p{^Is_Indic_Positional_Category=topandbottomandright}', "");
Expect(0, 6973, '\P{Is_Indic_Positional_Category=topandbottomandright}', "");
Expect(1, 6973, '\P{^Is_Indic_Positional_Category=topandbottomandright}', "");
Expect(0, 6974, '\p{Is_Indic_Positional_Category=topandbottomandright}', "");
Expect(1, 6974, '\p{^Is_Indic_Positional_Category=topandbottomandright}', "");
Expect(1, 6974, '\P{Is_Indic_Positional_Category=topandbottomandright}', "");
Expect(0, 6974, '\P{^Is_Indic_Positional_Category=topandbottomandright}', "");
Expect(1, 6973, '\p{Is_Indic_Positional_Category:   -Top_and_Bottom_And_Right}', "");
Expect(0, 6973, '\p{^Is_Indic_Positional_Category:   -Top_and_Bottom_And_Right}', "");
Expect(0, 6973, '\P{Is_Indic_Positional_Category:   -Top_and_Bottom_And_Right}', "");
Expect(1, 6973, '\P{^Is_Indic_Positional_Category:   -Top_and_Bottom_And_Right}', "");
Expect(0, 6974, '\p{Is_Indic_Positional_Category:   -Top_and_Bottom_And_Right}', "");
Expect(1, 6974, '\p{^Is_Indic_Positional_Category:   -Top_and_Bottom_And_Right}', "");
Expect(1, 6974, '\P{Is_Indic_Positional_Category:   -Top_and_Bottom_And_Right}', "");
Expect(0, 6974, '\P{^Is_Indic_Positional_Category:   -Top_and_Bottom_And_Right}', "");
Error('\p{Is_InPC=:=top_and_bottom_AND_RIGHT}');
Error('\P{Is_InPC=:=top_and_bottom_AND_RIGHT}');
Expect(1, 6973, '\p{Is_InPC=topandbottomandright}', "");
Expect(0, 6973, '\p{^Is_InPC=topandbottomandright}', "");
Expect(0, 6973, '\P{Is_InPC=topandbottomandright}', "");
Expect(1, 6973, '\P{^Is_InPC=topandbottomandright}', "");
Expect(0, 6974, '\p{Is_InPC=topandbottomandright}', "");
Expect(1, 6974, '\p{^Is_InPC=topandbottomandright}', "");
Expect(1, 6974, '\P{Is_InPC=topandbottomandright}', "");
Expect(0, 6974, '\P{^Is_InPC=topandbottomandright}', "");
Expect(1, 6973, '\p{Is_InPC=__Top_AND_Bottom_And_Right}', "");
Expect(0, 6973, '\p{^Is_InPC=__Top_AND_Bottom_And_Right}', "");
Expect(0, 6973, '\P{Is_InPC=__Top_AND_Bottom_And_Right}', "");
Expect(1, 6973, '\P{^Is_InPC=__Top_AND_Bottom_And_Right}', "");
Expect(0, 6974, '\p{Is_InPC=__Top_AND_Bottom_And_Right}', "");
Expect(1, 6974, '\p{^Is_InPC=__Top_AND_Bottom_And_Right}', "");
Expect(1, 6974, '\P{Is_InPC=__Top_AND_Bottom_And_Right}', "");
Expect(0, 6974, '\P{^Is_InPC=__Top_AND_Bottom_And_Right}', "");
Error('\p{Indic_Positional_Category=_/a/Top_And_LEFT}');
Error('\P{Indic_Positional_Category=_/a/Top_And_LEFT}');
Expect(1, 71097, '\p{Indic_Positional_Category=topandleft}', "");
Expect(0, 71097, '\p{^Indic_Positional_Category=topandleft}', "");
Expect(0, 71097, '\P{Indic_Positional_Category=topandleft}', "");
Expect(1, 71097, '\P{^Indic_Positional_Category=topandleft}', "");
Expect(0, 71098, '\p{Indic_Positional_Category=topandleft}', "");
Expect(1, 71098, '\p{^Indic_Positional_Category=topandleft}', "");
Expect(1, 71098, '\P{Indic_Positional_Category=topandleft}', "");
Expect(0, 71098, '\P{^Indic_Positional_Category=topandleft}', "");
Expect(1, 71097, '\p{Indic_Positional_Category=--Top_And_LEFT}', "");
Expect(0, 71097, '\p{^Indic_Positional_Category=--Top_And_LEFT}', "");
Expect(0, 71097, '\P{Indic_Positional_Category=--Top_And_LEFT}', "");
Expect(1, 71097, '\P{^Indic_Positional_Category=--Top_And_LEFT}', "");
Expect(0, 71098, '\p{Indic_Positional_Category=--Top_And_LEFT}', "");
Expect(1, 71098, '\p{^Indic_Positional_Category=--Top_And_LEFT}', "");
Expect(1, 71098, '\P{Indic_Positional_Category=--Top_And_LEFT}', "");
Expect(0, 71098, '\P{^Indic_Positional_Category=--Top_And_LEFT}', "");
Error('\p{InPC=/a/_ Top_and_Left}');
Error('\P{InPC=/a/_ Top_and_Left}');
Expect(1, 71097, '\p{InPC=topandleft}', "");
Expect(0, 71097, '\p{^InPC=topandleft}', "");
Expect(0, 71097, '\P{InPC=topandleft}', "");
Expect(1, 71097, '\P{^InPC=topandleft}', "");
Expect(0, 71098, '\p{InPC=topandleft}', "");
Expect(1, 71098, '\p{^InPC=topandleft}', "");
Expect(1, 71098, '\P{InPC=topandleft}', "");
Expect(0, 71098, '\P{^InPC=topandleft}', "");
Expect(1, 71097, '\p{InPC=__top_And_Left}', "");
Expect(0, 71097, '\p{^InPC=__top_And_Left}', "");
Expect(0, 71097, '\P{InPC=__top_And_Left}', "");
Expect(1, 71097, '\P{^InPC=__top_And_Left}', "");
Expect(0, 71098, '\p{InPC=__top_And_Left}', "");
Expect(1, 71098, '\p{^InPC=__top_And_Left}', "");
Expect(1, 71098, '\P{InPC=__top_And_Left}', "");
Expect(0, 71098, '\P{^InPC=__top_And_Left}', "");
Error('\p{Is_Indic_Positional_Category=:=-_top_and_LEFT}');
Error('\P{Is_Indic_Positional_Category=:=-_top_and_LEFT}');
Expect(1, 71097, '\p{Is_Indic_Positional_Category=topandleft}', "");
Expect(0, 71097, '\p{^Is_Indic_Positional_Category=topandleft}', "");
Expect(0, 71097, '\P{Is_Indic_Positional_Category=topandleft}', "");
Expect(1, 71097, '\P{^Is_Indic_Positional_Category=topandleft}', "");
Expect(0, 71098, '\p{Is_Indic_Positional_Category=topandleft}', "");
Expect(1, 71098, '\p{^Is_Indic_Positional_Category=topandleft}', "");
Expect(1, 71098, '\P{Is_Indic_Positional_Category=topandleft}', "");
Expect(0, 71098, '\P{^Is_Indic_Positional_Category=topandleft}', "");
Expect(1, 71097, '\p{Is_Indic_Positional_Category=_ Top_and_LEFT}', "");
Expect(0, 71097, '\p{^Is_Indic_Positional_Category=_ Top_and_LEFT}', "");
Expect(0, 71097, '\P{Is_Indic_Positional_Category=_ Top_and_LEFT}', "");
Expect(1, 71097, '\P{^Is_Indic_Positional_Category=_ Top_and_LEFT}', "");
Expect(0, 71098, '\p{Is_Indic_Positional_Category=_ Top_and_LEFT}', "");
Expect(1, 71098, '\p{^Is_Indic_Positional_Category=_ Top_and_LEFT}', "");
Expect(1, 71098, '\P{Is_Indic_Positional_Category=_ Top_and_LEFT}', "");
Expect(0, 71098, '\P{^Is_Indic_Positional_Category=_ Top_and_LEFT}', "");
Error('\p{Is_InPC= 	TOP_And_Left/a/}');
Error('\P{Is_InPC= 	TOP_And_Left/a/}');
Expect(1, 71097, '\p{Is_InPC=topandleft}', "");
Expect(0, 71097, '\p{^Is_InPC=topandleft}', "");
Expect(0, 71097, '\P{Is_InPC=topandleft}', "");
Expect(1, 71097, '\P{^Is_InPC=topandleft}', "");
Expect(0, 71098, '\p{Is_InPC=topandleft}', "");
Expect(1, 71098, '\p{^Is_InPC=topandleft}', "");
Expect(1, 71098, '\P{Is_InPC=topandleft}', "");
Expect(0, 71098, '\P{^Is_InPC=topandleft}', "");
Expect(1, 71097, '\p{Is_InPC=--top_And_Left}', "");
Expect(0, 71097, '\p{^Is_InPC=--top_And_Left}', "");
Expect(0, 71097, '\P{Is_InPC=--top_And_Left}', "");
Expect(1, 71097, '\P{^Is_InPC=--top_And_Left}', "");
Expect(0, 71098, '\p{Is_InPC=--top_And_Left}', "");
Expect(1, 71098, '\p{^Is_InPC=--top_And_Left}', "");
Expect(1, 71098, '\P{Is_InPC=--top_And_Left}', "");
Expect(0, 71098, '\P{^Is_InPC=--top_And_Left}', "");
Error('\p{Indic_Positional_Category=:= -TOP_AND_Left_and_Right}');
Error('\P{Indic_Positional_Category=:= -TOP_AND_Left_and_Right}');
Expect(1, 71099, '\p{Indic_Positional_Category=topandleftandright}', "");
Expect(0, 71099, '\p{^Indic_Positional_Category=topandleftandright}', "");
Expect(0, 71099, '\P{Indic_Positional_Category=topandleftandright}', "");
Expect(1, 71099, '\P{^Indic_Positional_Category=topandleftandright}', "");
Expect(0, 71100, '\p{Indic_Positional_Category=topandleftandright}', "");
Expect(1, 71100, '\p{^Indic_Positional_Category=topandleftandright}', "");
Expect(1, 71100, '\P{Indic_Positional_Category=topandleftandright}', "");
Expect(0, 71100, '\P{^Indic_Positional_Category=topandleftandright}', "");
Expect(1, 71099, '\p{Indic_Positional_Category=-	TOP_And_Left_and_Right}', "");
Expect(0, 71099, '\p{^Indic_Positional_Category=-	TOP_And_Left_and_Right}', "");
Expect(0, 71099, '\P{Indic_Positional_Category=-	TOP_And_Left_and_Right}', "");
Expect(1, 71099, '\P{^Indic_Positional_Category=-	TOP_And_Left_and_Right}', "");
Expect(0, 71100, '\p{Indic_Positional_Category=-	TOP_And_Left_and_Right}', "");
Expect(1, 71100, '\p{^Indic_Positional_Category=-	TOP_And_Left_and_Right}', "");
Expect(1, 71100, '\P{Indic_Positional_Category=-	TOP_And_Left_and_Right}', "");
Expect(0, 71100, '\P{^Indic_Positional_Category=-	TOP_And_Left_and_Right}', "");
Error('\p{InPC=/a/_	TOP_AND_Left_and_Right}');
Error('\P{InPC=/a/_	TOP_AND_Left_and_Right}');
Expect(1, 71099, '\p{InPC=topandleftandright}', "");
Expect(0, 71099, '\p{^InPC=topandleftandright}', "");
Expect(0, 71099, '\P{InPC=topandleftandright}', "");
Expect(1, 71099, '\P{^InPC=topandleftandright}', "");
Expect(0, 71100, '\p{InPC=topandleftandright}', "");
Expect(1, 71100, '\p{^InPC=topandleftandright}', "");
Expect(1, 71100, '\P{InPC=topandleftandright}', "");
Expect(0, 71100, '\P{^InPC=topandleftandright}', "");
Expect(1, 71099, '\p{InPC=-Top_And_left_AND_right}', "");
Expect(0, 71099, '\p{^InPC=-Top_And_left_AND_right}', "");
Expect(0, 71099, '\P{InPC=-Top_And_left_AND_right}', "");
Expect(1, 71099, '\P{^InPC=-Top_And_left_AND_right}', "");
Expect(0, 71100, '\p{InPC=-Top_And_left_AND_right}', "");
Expect(1, 71100, '\p{^InPC=-Top_And_left_AND_right}', "");
Expect(1, 71100, '\P{InPC=-Top_And_left_AND_right}', "");
Expect(0, 71100, '\P{^InPC=-Top_And_left_AND_right}', "");
Error('\p{Is_Indic_Positional_Category=_:=Top_And_left_AND_right}');
Error('\P{Is_Indic_Positional_Category=_:=Top_And_left_AND_right}');
Expect(1, 71099, '\p{Is_Indic_Positional_Category=topandleftandright}', "");
Expect(0, 71099, '\p{^Is_Indic_Positional_Category=topandleftandright}', "");
Expect(0, 71099, '\P{Is_Indic_Positional_Category=topandleftandright}', "");
Expect(1, 71099, '\P{^Is_Indic_Positional_Category=topandleftandright}', "");
Expect(0, 71100, '\p{Is_Indic_Positional_Category=topandleftandright}', "");
Expect(1, 71100, '\p{^Is_Indic_Positional_Category=topandleftandright}', "");
Expect(1, 71100, '\P{Is_Indic_Positional_Category=topandleftandright}', "");
Expect(0, 71100, '\P{^Is_Indic_Positional_Category=topandleftandright}', "");
Expect(1, 71099, '\p{Is_Indic_Positional_Category= -TOP_And_left_and_Right}', "");
Expect(0, 71099, '\p{^Is_Indic_Positional_Category= -TOP_And_left_and_Right}', "");
Expect(0, 71099, '\P{Is_Indic_Positional_Category= -TOP_And_left_and_Right}', "");
Expect(1, 71099, '\P{^Is_Indic_Positional_Category= -TOP_And_left_and_Right}', "");
Expect(0, 71100, '\p{Is_Indic_Positional_Category= -TOP_And_left_and_Right}', "");
Expect(1, 71100, '\p{^Is_Indic_Positional_Category= -TOP_And_left_and_Right}', "");
Expect(1, 71100, '\P{Is_Indic_Positional_Category= -TOP_And_left_and_Right}', "");
Expect(0, 71100, '\P{^Is_Indic_Positional_Category= -TOP_And_left_and_Right}', "");
Error('\p{Is_InPC:-/a/TOP_and_LEFT_and_RIGHT}');
Error('\P{Is_InPC:-/a/TOP_and_LEFT_and_RIGHT}');
Expect(1, 71099, '\p{Is_InPC=topandleftandright}', "");
Expect(0, 71099, '\p{^Is_InPC=topandleftandright}', "");
Expect(0, 71099, '\P{Is_InPC=topandleftandright}', "");
Expect(1, 71099, '\P{^Is_InPC=topandleftandright}', "");
Expect(0, 71100, '\p{Is_InPC=topandleftandright}', "");
Expect(1, 71100, '\p{^Is_InPC=topandleftandright}', "");
Expect(1, 71100, '\P{Is_InPC=topandleftandright}', "");
Expect(0, 71100, '\P{^Is_InPC=topandleftandright}', "");
Expect(1, 71099, '\p{Is_InPC=- TOP_AND_left_AND_Right}', "");
Expect(0, 71099, '\p{^Is_InPC=- TOP_AND_left_AND_Right}', "");
Expect(0, 71099, '\P{Is_InPC=- TOP_AND_left_AND_Right}', "");
Expect(1, 71099, '\P{^Is_InPC=- TOP_AND_left_AND_Right}', "");
Expect(0, 71100, '\p{Is_InPC=- TOP_AND_left_AND_Right}', "");
Expect(1, 71100, '\p{^Is_InPC=- TOP_AND_left_AND_Right}', "");
Expect(1, 71100, '\P{Is_InPC=- TOP_AND_left_AND_Right}', "");
Expect(0, 71100, '\P{^Is_InPC=- TOP_AND_left_AND_Right}', "");
Error('\p{Indic_Positional_Category=_ top_And_right:=}');
Error('\P{Indic_Positional_Category=_ top_And_right:=}');
Expect(1, 70195, '\p{Indic_Positional_Category:   topandright}', "");
Expect(0, 70195, '\p{^Indic_Positional_Category:   topandright}', "");
Expect(0, 70195, '\P{Indic_Positional_Category:   topandright}', "");
Expect(1, 70195, '\P{^Indic_Positional_Category:   topandright}', "");
Expect(0, 70196, '\p{Indic_Positional_Category:   topandright}', "");
Expect(1, 70196, '\p{^Indic_Positional_Category:   topandright}', "");
Expect(1, 70196, '\P{Indic_Positional_Category:   topandright}', "");
Expect(0, 70196, '\P{^Indic_Positional_Category:   topandright}', "");
Expect(1, 70195, '\p{Indic_Positional_Category:  _Top_AND_RIGHT}', "");
Expect(0, 70195, '\p{^Indic_Positional_Category:  _Top_AND_RIGHT}', "");
Expect(0, 70195, '\P{Indic_Positional_Category:  _Top_AND_RIGHT}', "");
Expect(1, 70195, '\P{^Indic_Positional_Category:  _Top_AND_RIGHT}', "");
Expect(0, 70196, '\p{Indic_Positional_Category:  _Top_AND_RIGHT}', "");
Expect(1, 70196, '\p{^Indic_Positional_Category:  _Top_AND_RIGHT}', "");
Expect(1, 70196, '\P{Indic_Positional_Category:  _Top_AND_RIGHT}', "");
Expect(0, 70196, '\P{^Indic_Positional_Category:  _Top_AND_RIGHT}', "");
Error('\p{InPC=/a/-Top_AND_Right}');
Error('\P{InPC=/a/-Top_AND_Right}');
Expect(1, 70195, '\p{InPC=topandright}', "");
Expect(0, 70195, '\p{^InPC=topandright}', "");
Expect(0, 70195, '\P{InPC=topandright}', "");
Expect(1, 70195, '\P{^InPC=topandright}', "");
Expect(0, 70196, '\p{InPC=topandright}', "");
Expect(1, 70196, '\p{^InPC=topandright}', "");
Expect(1, 70196, '\P{InPC=topandright}', "");
Expect(0, 70196, '\P{^InPC=topandright}', "");
Expect(1, 70195, '\p{InPC=  top_And_right}', "");
Expect(0, 70195, '\p{^InPC=  top_And_right}', "");
Expect(0, 70195, '\P{InPC=  top_And_right}', "");
Expect(1, 70195, '\P{^InPC=  top_And_right}', "");
Expect(0, 70196, '\p{InPC=  top_And_right}', "");
Expect(1, 70196, '\p{^InPC=  top_And_right}', "");
Expect(1, 70196, '\P{InPC=  top_And_right}', "");
Expect(0, 70196, '\P{^InPC=  top_And_right}', "");
Error('\p{Is_Indic_Positional_Category=-:=top_AND_Right}');
Error('\P{Is_Indic_Positional_Category=-:=top_AND_Right}');
Expect(1, 70195, '\p{Is_Indic_Positional_Category=topandright}', "");
Expect(0, 70195, '\p{^Is_Indic_Positional_Category=topandright}', "");
Expect(0, 70195, '\P{Is_Indic_Positional_Category=topandright}', "");
Expect(1, 70195, '\P{^Is_Indic_Positional_Category=topandright}', "");
Expect(0, 70196, '\p{Is_Indic_Positional_Category=topandright}', "");
Expect(1, 70196, '\p{^Is_Indic_Positional_Category=topandright}', "");
Expect(1, 70196, '\P{Is_Indic_Positional_Category=topandright}', "");
Expect(0, 70196, '\P{^Is_Indic_Positional_Category=topandright}', "");
Expect(1, 70195, '\p{Is_Indic_Positional_Category=  Top_And_right}', "");
Expect(0, 70195, '\p{^Is_Indic_Positional_Category=  Top_And_right}', "");
Expect(0, 70195, '\P{Is_Indic_Positional_Category=  Top_And_right}', "");
Expect(1, 70195, '\P{^Is_Indic_Positional_Category=  Top_And_right}', "");
Expect(0, 70196, '\p{Is_Indic_Positional_Category=  Top_And_right}', "");
Expect(1, 70196, '\p{^Is_Indic_Positional_Category=  Top_And_right}', "");
Expect(1, 70196, '\P{Is_Indic_Positional_Category=  Top_And_right}', "");
Expect(0, 70196, '\P{^Is_Indic_Positional_Category=  Top_And_right}', "");
Error('\p{Is_InPC=:=-top_and_RIGHT}');
Error('\P{Is_InPC=:=-top_and_RIGHT}');
Expect(1, 70195, '\p{Is_InPC=topandright}', "");
Expect(0, 70195, '\p{^Is_InPC=topandright}', "");
Expect(0, 70195, '\P{Is_InPC=topandright}', "");
Expect(1, 70195, '\P{^Is_InPC=topandright}', "");
Expect(0, 70196, '\p{Is_InPC=topandright}', "");
Expect(1, 70196, '\p{^Is_InPC=topandright}', "");
Expect(1, 70196, '\P{Is_InPC=topandright}', "");
Expect(0, 70196, '\P{^Is_InPC=topandright}', "");
Expect(1, 70195, '\p{Is_InPC= _top_and_Right}', "");
Expect(0, 70195, '\p{^Is_InPC= _top_and_Right}', "");
Expect(0, 70195, '\P{Is_InPC= _top_and_Right}', "");
Expect(1, 70195, '\P{^Is_InPC= _top_and_Right}', "");
Expect(0, 70196, '\p{Is_InPC= _top_and_Right}', "");
Expect(1, 70196, '\p{^Is_InPC= _top_and_Right}', "");
Expect(1, 70196, '\P{Is_InPC= _top_and_Right}', "");
Expect(0, 70196, '\P{^Is_InPC= _top_and_Right}', "");
Error('\p{Indic_Positional_Category=:=_	VISUAL_Order_Left}');
Error('\P{Indic_Positional_Category=:=_	VISUAL_Order_Left}');
Expect(1, 43708, '\p{Indic_Positional_Category=visualorderleft}', "");
Expect(0, 43708, '\p{^Indic_Positional_Category=visualorderleft}', "");
Expect(0, 43708, '\P{Indic_Positional_Category=visualorderleft}', "");
Expect(1, 43708, '\P{^Indic_Positional_Category=visualorderleft}', "");
Expect(0, 43709, '\p{Indic_Positional_Category=visualorderleft}', "");
Expect(1, 43709, '\p{^Indic_Positional_Category=visualorderleft}', "");
Expect(1, 43709, '\P{Indic_Positional_Category=visualorderleft}', "");
Expect(0, 43709, '\P{^Indic_Positional_Category=visualorderleft}', "");
Expect(1, 43708, '\p{Indic_Positional_Category=_-VISUAL_Order_Left}', "");
Expect(0, 43708, '\p{^Indic_Positional_Category=_-VISUAL_Order_Left}', "");
Expect(0, 43708, '\P{Indic_Positional_Category=_-VISUAL_Order_Left}', "");
Expect(1, 43708, '\P{^Indic_Positional_Category=_-VISUAL_Order_Left}', "");
Expect(0, 43709, '\p{Indic_Positional_Category=_-VISUAL_Order_Left}', "");
Expect(1, 43709, '\p{^Indic_Positional_Category=_-VISUAL_Order_Left}', "");
Expect(1, 43709, '\P{Indic_Positional_Category=_-VISUAL_Order_Left}', "");
Expect(0, 43709, '\P{^Indic_Positional_Category=_-VISUAL_Order_Left}', "");
Error('\p{InPC=--Visual_Order_Left/a/}');
Error('\P{InPC=--Visual_Order_Left/a/}');
Expect(1, 43708, '\p{InPC=visualorderleft}', "");
Expect(0, 43708, '\p{^InPC=visualorderleft}', "");
Expect(0, 43708, '\P{InPC=visualorderleft}', "");
Expect(1, 43708, '\P{^InPC=visualorderleft}', "");
Expect(0, 43709, '\p{InPC=visualorderleft}', "");
Expect(1, 43709, '\p{^InPC=visualorderleft}', "");
Expect(1, 43709, '\P{InPC=visualorderleft}', "");
Expect(0, 43709, '\P{^InPC=visualorderleft}', "");
Expect(1, 43708, '\p{InPC=-visual_Order_LEFT}', "");
Expect(0, 43708, '\p{^InPC=-visual_Order_LEFT}', "");
Expect(0, 43708, '\P{InPC=-visual_Order_LEFT}', "");
Expect(1, 43708, '\P{^InPC=-visual_Order_LEFT}', "");
Expect(0, 43709, '\p{InPC=-visual_Order_LEFT}', "");
Expect(1, 43709, '\p{^InPC=-visual_Order_LEFT}', "");
Expect(1, 43709, '\P{InPC=-visual_Order_LEFT}', "");
Expect(0, 43709, '\P{^InPC=-visual_Order_LEFT}', "");
Error('\p{Is_Indic_Positional_Category=/a/	_Visual_Order_Left}');
Error('\P{Is_Indic_Positional_Category=/a/	_Visual_Order_Left}');
Expect(1, 43708, '\p{Is_Indic_Positional_Category=visualorderleft}', "");
Expect(0, 43708, '\p{^Is_Indic_Positional_Category=visualorderleft}', "");
Expect(0, 43708, '\P{Is_Indic_Positional_Category=visualorderleft}', "");
Expect(1, 43708, '\P{^Is_Indic_Positional_Category=visualorderleft}', "");
Expect(0, 43709, '\p{Is_Indic_Positional_Category=visualorderleft}', "");
Expect(1, 43709, '\p{^Is_Indic_Positional_Category=visualorderleft}', "");
Expect(1, 43709, '\P{Is_Indic_Positional_Category=visualorderleft}', "");
Expect(0, 43709, '\P{^Is_Indic_Positional_Category=visualorderleft}', "");
Expect(1, 43708, '\p{Is_Indic_Positional_Category=	_VISUAL_ORDER_left}', "");
Expect(0, 43708, '\p{^Is_Indic_Positional_Category=	_VISUAL_ORDER_left}', "");
Expect(0, 43708, '\P{Is_Indic_Positional_Category=	_VISUAL_ORDER_left}', "");
Expect(1, 43708, '\P{^Is_Indic_Positional_Category=	_VISUAL_ORDER_left}', "");
Expect(0, 43709, '\p{Is_Indic_Positional_Category=	_VISUAL_ORDER_left}', "");
Expect(1, 43709, '\p{^Is_Indic_Positional_Category=	_VISUAL_ORDER_left}', "");
Expect(1, 43709, '\P{Is_Indic_Positional_Category=	_VISUAL_ORDER_left}', "");
Expect(0, 43709, '\P{^Is_Indic_Positional_Category=	_VISUAL_ORDER_left}', "");
Error('\p{Is_InPC=-	VISUAL_order_Left:=}');
Error('\P{Is_InPC=-	VISUAL_order_Left:=}');
Expect(1, 43708, '\p{Is_InPC=visualorderleft}', "");
Expect(0, 43708, '\p{^Is_InPC=visualorderleft}', "");
Expect(0, 43708, '\P{Is_InPC=visualorderleft}', "");
Expect(1, 43708, '\P{^Is_InPC=visualorderleft}', "");
Expect(0, 43709, '\p{Is_InPC=visualorderleft}', "");
Expect(1, 43709, '\p{^Is_InPC=visualorderleft}', "");
Expect(1, 43709, '\P{Is_InPC=visualorderleft}', "");
Expect(0, 43709, '\P{^Is_InPC=visualorderleft}', "");
Expect(1, 43708, '\p{Is_InPC=_visual_Order_Left}', "");
Expect(0, 43708, '\p{^Is_InPC=_visual_Order_Left}', "");
Expect(0, 43708, '\P{Is_InPC=_visual_Order_Left}', "");
Expect(1, 43708, '\P{^Is_InPC=_visual_Order_Left}', "");
Expect(0, 43709, '\p{Is_InPC=_visual_Order_Left}', "");
Expect(1, 43709, '\p{^Is_InPC=_visual_Order_Left}', "");
Expect(1, 43709, '\P{Is_InPC=_visual_Order_Left}', "");
Expect(0, 43709, '\P{^Is_InPC=_visual_Order_Left}', "");
Error('\p{Indic_Syllabic_Category= 	Avagraha:=}');
Error('\P{Indic_Syllabic_Category= 	Avagraha:=}');
Expect(1, 70852, '\p{Indic_Syllabic_Category=avagraha}', "");
Expect(0, 70852, '\p{^Indic_Syllabic_Category=avagraha}', "");
Expect(0, 70852, '\P{Indic_Syllabic_Category=avagraha}', "");
Expect(1, 70852, '\P{^Indic_Syllabic_Category=avagraha}', "");
Expect(0, 70853, '\p{Indic_Syllabic_Category=avagraha}', "");
Expect(1, 70853, '\p{^Indic_Syllabic_Category=avagraha}', "");
Expect(1, 70853, '\P{Indic_Syllabic_Category=avagraha}', "");
Expect(0, 70853, '\P{^Indic_Syllabic_Category=avagraha}', "");
Expect(1, 70852, '\p{Indic_Syllabic_Category: _-Avagraha}', "");
Expect(0, 70852, '\p{^Indic_Syllabic_Category: _-Avagraha}', "");
Expect(0, 70852, '\P{Indic_Syllabic_Category: _-Avagraha}', "");
Expect(1, 70852, '\P{^Indic_Syllabic_Category: _-Avagraha}', "");
Expect(0, 70853, '\p{Indic_Syllabic_Category: _-Avagraha}', "");
Expect(1, 70853, '\p{^Indic_Syllabic_Category: _-Avagraha}', "");
Expect(1, 70853, '\P{Indic_Syllabic_Category: _-Avagraha}', "");
Expect(0, 70853, '\P{^Indic_Syllabic_Category: _-Avagraha}', "");
Error('\p{InSC=:= Avagraha}');
Error('\P{InSC=:= Avagraha}');
Expect(1, 70852, '\p{InSC=avagraha}', "");
Expect(0, 70852, '\p{^InSC=avagraha}', "");
Expect(0, 70852, '\P{InSC=avagraha}', "");
Expect(1, 70852, '\P{^InSC=avagraha}', "");
Expect(0, 70853, '\p{InSC=avagraha}', "");
Expect(1, 70853, '\p{^InSC=avagraha}', "");
Expect(1, 70853, '\P{InSC=avagraha}', "");
Expect(0, 70853, '\P{^InSC=avagraha}', "");
Expect(1, 70852, '\p{InSC= -Avagraha}', "");
Expect(0, 70852, '\p{^InSC= -Avagraha}', "");
Expect(0, 70852, '\P{InSC= -Avagraha}', "");
Expect(1, 70852, '\P{^InSC= -Avagraha}', "");
Expect(0, 70853, '\p{InSC= -Avagraha}', "");
Expect(1, 70853, '\p{^InSC= -Avagraha}', "");
Expect(1, 70853, '\P{InSC= -Avagraha}', "");
Expect(0, 70853, '\P{^InSC= -Avagraha}', "");
Error('\p{Is_Indic_Syllabic_Category=	:=Avagraha}');
Error('\P{Is_Indic_Syllabic_Category=	:=Avagraha}');
Expect(1, 70852, '\p{Is_Indic_Syllabic_Category=avagraha}', "");
Expect(0, 70852, '\p{^Is_Indic_Syllabic_Category=avagraha}', "");
Expect(0, 70852, '\P{Is_Indic_Syllabic_Category=avagraha}', "");
Expect(1, 70852, '\P{^Is_Indic_Syllabic_Category=avagraha}', "");
Expect(0, 70853, '\p{Is_Indic_Syllabic_Category=avagraha}', "");
Expect(1, 70853, '\p{^Is_Indic_Syllabic_Category=avagraha}', "");
Expect(1, 70853, '\P{Is_Indic_Syllabic_Category=avagraha}', "");
Expect(0, 70853, '\P{^Is_Indic_Syllabic_Category=avagraha}', "");
Expect(1, 70852, '\p{Is_Indic_Syllabic_Category=-avagraha}', "");
Expect(0, 70852, '\p{^Is_Indic_Syllabic_Category=-avagraha}', "");
Expect(0, 70852, '\P{Is_Indic_Syllabic_Category=-avagraha}', "");
Expect(1, 70852, '\P{^Is_Indic_Syllabic_Category=-avagraha}', "");
Expect(0, 70853, '\p{Is_Indic_Syllabic_Category=-avagraha}', "");
Expect(1, 70853, '\p{^Is_Indic_Syllabic_Category=-avagraha}', "");
Expect(1, 70853, '\P{Is_Indic_Syllabic_Category=-avagraha}', "");
Expect(0, 70853, '\P{^Is_Indic_Syllabic_Category=-avagraha}', "");
Error('\p{Is_InSC=	:=Avagraha}');
Error('\P{Is_InSC=	:=Avagraha}');
Expect(1, 70852, '\p{Is_InSC=avagraha}', "");
Expect(0, 70852, '\p{^Is_InSC=avagraha}', "");
Expect(0, 70852, '\P{Is_InSC=avagraha}', "");
Expect(1, 70852, '\P{^Is_InSC=avagraha}', "");
Expect(0, 70853, '\p{Is_InSC=avagraha}', "");
Expect(1, 70853, '\p{^Is_InSC=avagraha}', "");
Expect(1, 70853, '\P{Is_InSC=avagraha}', "");
Expect(0, 70853, '\P{^Is_InSC=avagraha}', "");
Expect(1, 70852, '\p{Is_InSC=	AVAGRAHA}', "");
Expect(0, 70852, '\p{^Is_InSC=	AVAGRAHA}', "");
Expect(0, 70852, '\P{Is_InSC=	AVAGRAHA}', "");
Expect(1, 70852, '\P{^Is_InSC=	AVAGRAHA}', "");
Expect(0, 70853, '\p{Is_InSC=	AVAGRAHA}', "");
Expect(1, 70853, '\p{^Is_InSC=	AVAGRAHA}', "");
Expect(1, 70853, '\P{Is_InSC=	AVAGRAHA}', "");
Expect(0, 70853, '\P{^Is_InSC=	AVAGRAHA}', "");
Error('\p{Indic_Syllabic_Category= :=Bindu}');
Error('\P{Indic_Syllabic_Category= :=Bindu}');
Expect(1, 71339, '\p{Indic_Syllabic_Category=bindu}', "");
Expect(0, 71339, '\p{^Indic_Syllabic_Category=bindu}', "");
Expect(0, 71339, '\P{Indic_Syllabic_Category=bindu}', "");
Expect(1, 71339, '\P{^Indic_Syllabic_Category=bindu}', "");
Expect(0, 71340, '\p{Indic_Syllabic_Category=bindu}', "");
Expect(1, 71340, '\p{^Indic_Syllabic_Category=bindu}', "");
Expect(1, 71340, '\P{Indic_Syllabic_Category=bindu}', "");
Expect(0, 71340, '\P{^Indic_Syllabic_Category=bindu}', "");
Expect(1, 71339, '\p{Indic_Syllabic_Category=_ bindu}', "");
Expect(0, 71339, '\p{^Indic_Syllabic_Category=_ bindu}', "");
Expect(0, 71339, '\P{Indic_Syllabic_Category=_ bindu}', "");
Expect(1, 71339, '\P{^Indic_Syllabic_Category=_ bindu}', "");
Expect(0, 71340, '\p{Indic_Syllabic_Category=_ bindu}', "");
Expect(1, 71340, '\p{^Indic_Syllabic_Category=_ bindu}', "");
Expect(1, 71340, '\P{Indic_Syllabic_Category=_ bindu}', "");
Expect(0, 71340, '\P{^Indic_Syllabic_Category=_ bindu}', "");
Error('\p{InSC=-/a/bindu}');
Error('\P{InSC=-/a/bindu}');
Expect(1, 71339, '\p{InSC=bindu}', "");
Expect(0, 71339, '\p{^InSC=bindu}', "");
Expect(0, 71339, '\P{InSC=bindu}', "");
Expect(1, 71339, '\P{^InSC=bindu}', "");
Expect(0, 71340, '\p{InSC=bindu}', "");
Expect(1, 71340, '\p{^InSC=bindu}', "");
Expect(1, 71340, '\P{InSC=bindu}', "");
Expect(0, 71340, '\P{^InSC=bindu}', "");
Expect(1, 71339, '\p{InSC=		bindu}', "");
Expect(0, 71339, '\p{^InSC=		bindu}', "");
Expect(0, 71339, '\P{InSC=		bindu}', "");
Expect(1, 71339, '\P{^InSC=		bindu}', "");
Expect(0, 71340, '\p{InSC=		bindu}', "");
Expect(1, 71340, '\p{^InSC=		bindu}', "");
Expect(1, 71340, '\P{InSC=		bindu}', "");
Expect(0, 71340, '\P{^InSC=		bindu}', "");
Error('\p{Is_Indic_Syllabic_Category=-/a/BINDU}');
Error('\P{Is_Indic_Syllabic_Category=-/a/BINDU}');
Expect(1, 71339, '\p{Is_Indic_Syllabic_Category=bindu}', "");
Expect(0, 71339, '\p{^Is_Indic_Syllabic_Category=bindu}', "");
Expect(0, 71339, '\P{Is_Indic_Syllabic_Category=bindu}', "");
Expect(1, 71339, '\P{^Is_Indic_Syllabic_Category=bindu}', "");
Expect(0, 71340, '\p{Is_Indic_Syllabic_Category=bindu}', "");
Expect(1, 71340, '\p{^Is_Indic_Syllabic_Category=bindu}', "");
Expect(1, 71340, '\P{Is_Indic_Syllabic_Category=bindu}', "");
Expect(0, 71340, '\P{^Is_Indic_Syllabic_Category=bindu}', "");
Expect(1, 71339, '\p{Is_Indic_Syllabic_Category=		Bindu}', "");
Expect(0, 71339, '\p{^Is_Indic_Syllabic_Category=		Bindu}', "");
Expect(0, 71339, '\P{Is_Indic_Syllabic_Category=		Bindu}', "");
Expect(1, 71339, '\P{^Is_Indic_Syllabic_Category=		Bindu}', "");
Expect(0, 71340, '\p{Is_Indic_Syllabic_Category=		Bindu}', "");
Expect(1, 71340, '\p{^Is_Indic_Syllabic_Category=		Bindu}', "");
Expect(1, 71340, '\P{Is_Indic_Syllabic_Category=		Bindu}', "");
Expect(0, 71340, '\P{^Is_Indic_Syllabic_Category=		Bindu}', "");
Error('\p{Is_InSC= /a/Bindu}');
Error('\P{Is_InSC= /a/Bindu}');
Expect(1, 71339, '\p{Is_InSC=bindu}', "");
Expect(0, 71339, '\p{^Is_InSC=bindu}', "");
Expect(0, 71339, '\P{Is_InSC=bindu}', "");
Expect(1, 71339, '\P{^Is_InSC=bindu}', "");
Expect(0, 71340, '\p{Is_InSC=bindu}', "");
Expect(1, 71340, '\p{^Is_InSC=bindu}', "");
Expect(1, 71340, '\P{Is_InSC=bindu}', "");
Expect(0, 71340, '\P{^Is_InSC=bindu}', "");
Expect(1, 71339, '\p{Is_InSC= _BINDU}', "");
Expect(0, 71339, '\p{^Is_InSC= _BINDU}', "");
Expect(0, 71339, '\P{Is_InSC= _BINDU}', "");
Expect(1, 71339, '\P{^Is_InSC= _BINDU}', "");
Expect(0, 71340, '\p{Is_InSC= _BINDU}', "");
Expect(1, 71340, '\p{^Is_InSC= _BINDU}', "");
Expect(1, 71340, '\P{Is_InSC= _BINDU}', "");
Expect(0, 71340, '\P{^Is_InSC= _BINDU}', "");
Error('\p{Indic_Syllabic_Category=  BRAHMI_Joining_Number:=}');
Error('\P{Indic_Syllabic_Category=  BRAHMI_Joining_Number:=}');
Expect(1, 69733, '\p{Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(0, 69733, '\p{^Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(0, 69733, '\P{Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(1, 69733, '\P{^Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(0, 69734, '\p{Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(1, 69734, '\p{^Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(1, 69734, '\P{Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(0, 69734, '\P{^Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(1, 69733, '\p{Indic_Syllabic_Category:  _BRAHMI_Joining_Number}', "");
Expect(0, 69733, '\p{^Indic_Syllabic_Category:  _BRAHMI_Joining_Number}', "");
Expect(0, 69733, '\P{Indic_Syllabic_Category:  _BRAHMI_Joining_Number}', "");
Expect(1, 69733, '\P{^Indic_Syllabic_Category:  _BRAHMI_Joining_Number}', "");
Expect(0, 69734, '\p{Indic_Syllabic_Category:  _BRAHMI_Joining_Number}', "");
Expect(1, 69734, '\p{^Indic_Syllabic_Category:  _BRAHMI_Joining_Number}', "");
Expect(1, 69734, '\P{Indic_Syllabic_Category:  _BRAHMI_Joining_Number}', "");
Expect(0, 69734, '\P{^Indic_Syllabic_Category:  _BRAHMI_Joining_Number}', "");
Error('\p{InSC=/a/	 Brahmi_JOINING_number}');
Error('\P{InSC=/a/	 Brahmi_JOINING_number}');
Expect(1, 69733, '\p{InSC=brahmijoiningnumber}', "");
Expect(0, 69733, '\p{^InSC=brahmijoiningnumber}', "");
Expect(0, 69733, '\P{InSC=brahmijoiningnumber}', "");
Expect(1, 69733, '\P{^InSC=brahmijoiningnumber}', "");
Expect(0, 69734, '\p{InSC=brahmijoiningnumber}', "");
Expect(1, 69734, '\p{^InSC=brahmijoiningnumber}', "");
Expect(1, 69734, '\P{InSC=brahmijoiningnumber}', "");
Expect(0, 69734, '\P{^InSC=brahmijoiningnumber}', "");
Expect(1, 69733, '\p{InSC=--Brahmi_JOINING_Number}', "");
Expect(0, 69733, '\p{^InSC=--Brahmi_JOINING_Number}', "");
Expect(0, 69733, '\P{InSC=--Brahmi_JOINING_Number}', "");
Expect(1, 69733, '\P{^InSC=--Brahmi_JOINING_Number}', "");
Expect(0, 69734, '\p{InSC=--Brahmi_JOINING_Number}', "");
Expect(1, 69734, '\p{^InSC=--Brahmi_JOINING_Number}', "");
Expect(1, 69734, '\P{InSC=--Brahmi_JOINING_Number}', "");
Expect(0, 69734, '\P{^InSC=--Brahmi_JOINING_Number}', "");
Error('\p{Is_Indic_Syllabic_Category= :=Brahmi_Joining_NUMBER}');
Error('\P{Is_Indic_Syllabic_Category= :=Brahmi_Joining_NUMBER}');
Expect(1, 69733, '\p{Is_Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(0, 69733, '\p{^Is_Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(0, 69733, '\P{Is_Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(1, 69733, '\P{^Is_Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(0, 69734, '\p{Is_Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(1, 69734, '\p{^Is_Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(1, 69734, '\P{Is_Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(0, 69734, '\P{^Is_Indic_Syllabic_Category=brahmijoiningnumber}', "");
Expect(1, 69733, '\p{Is_Indic_Syllabic_Category=_ Brahmi_Joining_NUMBER}', "");
Expect(0, 69733, '\p{^Is_Indic_Syllabic_Category=_ Brahmi_Joining_NUMBER}', "");
Expect(0, 69733, '\P{Is_Indic_Syllabic_Category=_ Brahmi_Joining_NUMBER}', "");
Expect(1, 69733, '\P{^Is_Indic_Syllabic_Category=_ Brahmi_Joining_NUMBER}', "");
Expect(0, 69734, '\p{Is_Indic_Syllabic_Category=_ Brahmi_Joining_NUMBER}', "");
Expect(1, 69734, '\p{^Is_Indic_Syllabic_Category=_ Brahmi_Joining_NUMBER}', "");
Expect(1, 69734, '\P{Is_Indic_Syllabic_Category=_ Brahmi_Joining_NUMBER}', "");
Expect(0, 69734, '\P{^Is_Indic_Syllabic_Category=_ Brahmi_Joining_NUMBER}', "");
Error('\p{Is_InSC=_Brahmi_joining_number/a/}');
Error('\P{Is_InSC=_Brahmi_joining_number/a/}');
Expect(1, 69733, '\p{Is_InSC=brahmijoiningnumber}', "");
Expect(0, 69733, '\p{^Is_InSC=brahmijoiningnumber}', "");
Expect(0, 69733, '\P{Is_InSC=brahmijoiningnumber}', "");
Expect(1, 69733, '\P{^Is_InSC=brahmijoiningnumber}', "");
Expect(0, 69734, '\p{Is_InSC=brahmijoiningnumber}', "");
Expect(1, 69734, '\p{^Is_InSC=brahmijoiningnumber}', "");
Expect(1, 69734, '\P{Is_InSC=brahmijoiningnumber}', "");
Expect(0, 69734, '\P{^Is_InSC=brahmijoiningnumber}', "");
Expect(1, 69733, '\p{Is_InSC=	_BRAHMI_JOINING_number}', "");
Expect(0, 69733, '\p{^Is_InSC=	_BRAHMI_JOINING_number}', "");
Expect(0, 69733, '\P{Is_InSC=	_BRAHMI_JOINING_number}', "");
Expect(1, 69733, '\P{^Is_InSC=	_BRAHMI_JOINING_number}', "");
Expect(0, 69734, '\p{Is_InSC=	_BRAHMI_JOINING_number}', "");
Expect(1, 69734, '\p{^Is_InSC=	_BRAHMI_JOINING_number}', "");
Expect(1, 69734, '\P{Is_InSC=	_BRAHMI_JOINING_number}', "");
Expect(0, 69734, '\P{^Is_InSC=	_BRAHMI_JOINING_number}', "");
Error('\p{Indic_Syllabic_Category= :=CANTILLATION_MARK}');
Error('\P{Indic_Syllabic_Category= :=CANTILLATION_MARK}');
Expect(1, 70516, '\p{Indic_Syllabic_Category=cantillationmark}', "");
Expect(0, 70516, '\p{^Indic_Syllabic_Category=cantillationmark}', "");
Expect(0, 70516, '\P{Indic_Syllabic_Category=cantillationmark}', "");
Expect(1, 70516, '\P{^Indic_Syllabic_Category=cantillationmark}', "");
Expect(0, 70517, '\p{Indic_Syllabic_Category=cantillationmark}', "");
Expect(1, 70517, '\p{^Indic_Syllabic_Category=cantillationmark}', "");
Expect(1, 70517, '\P{Indic_Syllabic_Category=cantillationmark}', "");
Expect(0, 70517, '\P{^Indic_Syllabic_Category=cantillationmark}', "");
Expect(1, 70516, '\p{Indic_Syllabic_Category=	-Cantillation_MARK}', "");
Expect(0, 70516, '\p{^Indic_Syllabic_Category=	-Cantillation_MARK}', "");
Expect(0, 70516, '\P{Indic_Syllabic_Category=	-Cantillation_MARK}', "");
Expect(1, 70516, '\P{^Indic_Syllabic_Category=	-Cantillation_MARK}', "");
Expect(0, 70517, '\p{Indic_Syllabic_Category=	-Cantillation_MARK}', "");
Expect(1, 70517, '\p{^Indic_Syllabic_Category=	-Cantillation_MARK}', "");
Expect(1, 70517, '\P{Indic_Syllabic_Category=	-Cantillation_MARK}', "");
Expect(0, 70517, '\P{^Indic_Syllabic_Category=	-Cantillation_MARK}', "");
Error('\p{InSC: _:=Cantillation_Mark}');
Error('\P{InSC: _:=Cantillation_Mark}');
Expect(1, 70516, '\p{InSC=cantillationmark}', "");
Expect(0, 70516, '\p{^InSC=cantillationmark}', "");
Expect(0, 70516, '\P{InSC=cantillationmark}', "");
Expect(1, 70516, '\P{^InSC=cantillationmark}', "");
Expect(0, 70517, '\p{InSC=cantillationmark}', "");
Expect(1, 70517, '\p{^InSC=cantillationmark}', "");
Expect(1, 70517, '\P{InSC=cantillationmark}', "");
Expect(0, 70517, '\P{^InSC=cantillationmark}', "");
Expect(1, 70516, '\p{InSC= -cantillation_Mark}', "");
Expect(0, 70516, '\p{^InSC= -cantillation_Mark}', "");
Expect(0, 70516, '\P{InSC= -cantillation_Mark}', "");
Expect(1, 70516, '\P{^InSC= -cantillation_Mark}', "");
Expect(0, 70517, '\p{InSC= -cantillation_Mark}', "");
Expect(1, 70517, '\p{^InSC= -cantillation_Mark}', "");
Expect(1, 70517, '\P{InSC= -cantillation_Mark}', "");
Expect(0, 70517, '\P{^InSC= -cantillation_Mark}', "");
Error('\p{Is_Indic_Syllabic_Category=:= CANTILLATION_mark}');
Error('\P{Is_Indic_Syllabic_Category=:= CANTILLATION_mark}');
Expect(1, 70516, '\p{Is_Indic_Syllabic_Category:   cantillationmark}', "");
Expect(0, 70516, '\p{^Is_Indic_Syllabic_Category:   cantillationmark}', "");
Expect(0, 70516, '\P{Is_Indic_Syllabic_Category:   cantillationmark}', "");
Expect(1, 70516, '\P{^Is_Indic_Syllabic_Category:   cantillationmark}', "");
Expect(0, 70517, '\p{Is_Indic_Syllabic_Category:   cantillationmark}', "");
Expect(1, 70517, '\p{^Is_Indic_Syllabic_Category:   cantillationmark}', "");
Expect(1, 70517, '\P{Is_Indic_Syllabic_Category:   cantillationmark}', "");
Expect(0, 70517, '\P{^Is_Indic_Syllabic_Category:   cantillationmark}', "");
Expect(1, 70516, '\p{Is_Indic_Syllabic_Category=	_CANTILLATION_Mark}', "");
Expect(0, 70516, '\p{^Is_Indic_Syllabic_Category=	_CANTILLATION_Mark}', "");
Expect(0, 70516, '\P{Is_Indic_Syllabic_Category=	_CANTILLATION_Mark}', "");
Expect(1, 70516, '\P{^Is_Indic_Syllabic_Category=	_CANTILLATION_Mark}', "");
Expect(0, 70517, '\p{Is_Indic_Syllabic_Category=	_CANTILLATION_Mark}', "");
Expect(1, 70517, '\p{^Is_Indic_Syllabic_Category=	_CANTILLATION_Mark}', "");
Expect(1, 70517, '\P{Is_Indic_Syllabic_Category=	_CANTILLATION_Mark}', "");
Expect(0, 70517, '\P{^Is_Indic_Syllabic_Category=	_CANTILLATION_Mark}', "");
Error('\p{Is_InSC=		Cantillation_mark:=}');
Error('\P{Is_InSC=		Cantillation_mark:=}');
Expect(1, 70516, '\p{Is_InSC=cantillationmark}', "");
Expect(0, 70516, '\p{^Is_InSC=cantillationmark}', "");
Expect(0, 70516, '\P{Is_InSC=cantillationmark}', "");
Expect(1, 70516, '\P{^Is_InSC=cantillationmark}', "");
Expect(0, 70517, '\p{Is_InSC=cantillationmark}', "");
Expect(1, 70517, '\p{^Is_InSC=cantillationmark}', "");
Expect(1, 70517, '\P{Is_InSC=cantillationmark}', "");
Expect(0, 70517, '\P{^Is_InSC=cantillationmark}', "");
Expect(1, 70516, '\p{Is_InSC=-Cantillation_MARK}', "");
Expect(0, 70516, '\p{^Is_InSC=-Cantillation_MARK}', "");
Expect(0, 70516, '\P{Is_InSC=-Cantillation_MARK}', "");
Expect(1, 70516, '\P{^Is_InSC=-Cantillation_MARK}', "");
Expect(0, 70517, '\p{Is_InSC=-Cantillation_MARK}', "");
Expect(1, 70517, '\p{^Is_InSC=-Cantillation_MARK}', "");
Expect(1, 70517, '\P{Is_InSC=-Cantillation_MARK}', "");
Expect(0, 70517, '\P{^Is_InSC=-Cantillation_MARK}', "");
Error('\p{Indic_Syllabic_Category=:=-	CONSONANT}');
Error('\P{Indic_Syllabic_Category=:=-	CONSONANT}');
Expect(1, 71449, '\p{Indic_Syllabic_Category=consonant}', "");
Expect(0, 71449, '\p{^Indic_Syllabic_Category=consonant}', "");
Expect(0, 71449, '\P{Indic_Syllabic_Category=consonant}', "");
Expect(1, 71449, '\P{^Indic_Syllabic_Category=consonant}', "");
Expect(0, 71450, '\p{Indic_Syllabic_Category=consonant}', "");
Expect(1, 71450, '\p{^Indic_Syllabic_Category=consonant}', "");
Expect(1, 71450, '\P{Indic_Syllabic_Category=consonant}', "");
Expect(0, 71450, '\P{^Indic_Syllabic_Category=consonant}', "");
Expect(1, 71449, '\p{Indic_Syllabic_Category= _Consonant}', "");
Expect(0, 71449, '\p{^Indic_Syllabic_Category= _Consonant}', "");
Expect(0, 71449, '\P{Indic_Syllabic_Category= _Consonant}', "");
Expect(1, 71449, '\P{^Indic_Syllabic_Category= _Consonant}', "");
Expect(0, 71450, '\p{Indic_Syllabic_Category= _Consonant}', "");
Expect(1, 71450, '\p{^Indic_Syllabic_Category= _Consonant}', "");
Expect(1, 71450, '\P{Indic_Syllabic_Category= _Consonant}', "");
Expect(0, 71450, '\P{^Indic_Syllabic_Category= _Consonant}', "");
Error('\p{InSC=-_Consonant:=}');
Error('\P{InSC=-_Consonant:=}');
Expect(1, 71449, '\p{InSC:	consonant}', "");
Expect(0, 71449, '\p{^InSC:	consonant}', "");
Expect(0, 71449, '\P{InSC:	consonant}', "");
Expect(1, 71449, '\P{^InSC:	consonant}', "");
Expect(0, 71450, '\p{InSC:	consonant}', "");
Expect(1, 71450, '\p{^InSC:	consonant}', "");
Expect(1, 71450, '\P{InSC:	consonant}', "");
Expect(0, 71450, '\P{^InSC:	consonant}', "");
Expect(1, 71449, '\p{InSC=_	Consonant}', "");
Expect(0, 71449, '\p{^InSC=_	Consonant}', "");
Expect(0, 71449, '\P{InSC=_	Consonant}', "");
Expect(1, 71449, '\P{^InSC=_	Consonant}', "");
Expect(0, 71450, '\p{InSC=_	Consonant}', "");
Expect(1, 71450, '\p{^InSC=_	Consonant}', "");
Expect(1, 71450, '\P{InSC=_	Consonant}', "");
Expect(0, 71450, '\P{^InSC=_	Consonant}', "");
Error('\p{Is_Indic_Syllabic_Category=:= -CONSONANT}');
Error('\P{Is_Indic_Syllabic_Category=:= -CONSONANT}');
Expect(1, 71449, '\p{Is_Indic_Syllabic_Category=consonant}', "");
Expect(0, 71449, '\p{^Is_Indic_Syllabic_Category=consonant}', "");
Expect(0, 71449, '\P{Is_Indic_Syllabic_Category=consonant}', "");
Expect(1, 71449, '\P{^Is_Indic_Syllabic_Category=consonant}', "");
Expect(0, 71450, '\p{Is_Indic_Syllabic_Category=consonant}', "");
Expect(1, 71450, '\p{^Is_Indic_Syllabic_Category=consonant}', "");
Expect(1, 71450, '\P{Is_Indic_Syllabic_Category=consonant}', "");
Expect(0, 71450, '\P{^Is_Indic_Syllabic_Category=consonant}', "");
Expect(1, 71449, '\p{Is_Indic_Syllabic_Category=-_consonant}', "");
Expect(0, 71449, '\p{^Is_Indic_Syllabic_Category=-_consonant}', "");
Expect(0, 71449, '\P{Is_Indic_Syllabic_Category=-_consonant}', "");
Expect(1, 71449, '\P{^Is_Indic_Syllabic_Category=-_consonant}', "");
Expect(0, 71450, '\p{Is_Indic_Syllabic_Category=-_consonant}', "");
Expect(1, 71450, '\p{^Is_Indic_Syllabic_Category=-_consonant}', "");
Expect(1, 71450, '\P{Is_Indic_Syllabic_Category=-_consonant}', "");
Expect(0, 71450, '\P{^Is_Indic_Syllabic_Category=-_consonant}', "");
Error('\p{Is_InSC=	:=Consonant}');
Error('\P{Is_InSC=	:=Consonant}');
Expect(1, 71449, '\p{Is_InSC=consonant}', "");
Expect(0, 71449, '\p{^Is_InSC=consonant}', "");
Expect(0, 71449, '\P{Is_InSC=consonant}', "");
Expect(1, 71449, '\P{^Is_InSC=consonant}', "");
Expect(0, 71450, '\p{Is_InSC=consonant}', "");
Expect(1, 71450, '\p{^Is_InSC=consonant}', "");
Expect(1, 71450, '\P{Is_InSC=consonant}', "");
Expect(0, 71450, '\P{^Is_InSC=consonant}', "");
Expect(1, 71449, '\p{Is_InSC=-CONSONANT}', "");
Expect(0, 71449, '\p{^Is_InSC=-CONSONANT}', "");
Expect(0, 71449, '\P{Is_InSC=-CONSONANT}', "");
Expect(1, 71449, '\P{^Is_InSC=-CONSONANT}', "");
Expect(0, 71450, '\p{Is_InSC=-CONSONANT}', "");
Expect(1, 71450, '\p{^Is_InSC=-CONSONANT}', "");
Expect(1, 71450, '\P{Is_InSC=-CONSONANT}', "");
Expect(0, 71450, '\P{^Is_InSC=-CONSONANT}', "");
Error('\p{Indic_Syllabic_Category= CONSONANT_Dead/a/}');
Error('\P{Indic_Syllabic_Category= CONSONANT_Dead/a/}');
Expect(1, 3455, '\p{Indic_Syllabic_Category=consonantdead}', "");
Expect(0, 3455, '\p{^Indic_Syllabic_Category=consonantdead}', "");
Expect(0, 3455, '\P{Indic_Syllabic_Category=consonantdead}', "");
Expect(1, 3455, '\P{^Indic_Syllabic_Category=consonantdead}', "");
Expect(0, 3456, '\p{Indic_Syllabic_Category=consonantdead}', "");
Expect(1, 3456, '\p{^Indic_Syllabic_Category=consonantdead}', "");
Expect(1, 3456, '\P{Indic_Syllabic_Category=consonantdead}', "");
Expect(0, 3456, '\P{^Indic_Syllabic_Category=consonantdead}', "");
Expect(1, 3455, '\p{Indic_Syllabic_Category=--Consonant_Dead}', "");
Expect(0, 3455, '\p{^Indic_Syllabic_Category=--Consonant_Dead}', "");
Expect(0, 3455, '\P{Indic_Syllabic_Category=--Consonant_Dead}', "");
Expect(1, 3455, '\P{^Indic_Syllabic_Category=--Consonant_Dead}', "");
Expect(0, 3456, '\p{Indic_Syllabic_Category=--Consonant_Dead}', "");
Expect(1, 3456, '\p{^Indic_Syllabic_Category=--Consonant_Dead}', "");
Expect(1, 3456, '\P{Indic_Syllabic_Category=--Consonant_Dead}', "");
Expect(0, 3456, '\P{^Indic_Syllabic_Category=--Consonant_Dead}', "");
Error('\p{InSC=- CONSONANT_dead/a/}');
Error('\P{InSC=- CONSONANT_dead/a/}');
Expect(1, 3455, '\p{InSC=consonantdead}', "");
Expect(0, 3455, '\p{^InSC=consonantdead}', "");
Expect(0, 3455, '\P{InSC=consonantdead}', "");
Expect(1, 3455, '\P{^InSC=consonantdead}', "");
Expect(0, 3456, '\p{InSC=consonantdead}', "");
Expect(1, 3456, '\p{^InSC=consonantdead}', "");
Expect(1, 3456, '\P{InSC=consonantdead}', "");
Expect(0, 3456, '\P{^InSC=consonantdead}', "");
Expect(1, 3455, '\p{InSC= consonant_Dead}', "");
Expect(0, 3455, '\p{^InSC= consonant_Dead}', "");
Expect(0, 3455, '\P{InSC= consonant_Dead}', "");
Expect(1, 3455, '\P{^InSC= consonant_Dead}', "");
Expect(0, 3456, '\p{InSC= consonant_Dead}', "");
Expect(1, 3456, '\p{^InSC= consonant_Dead}', "");
Expect(1, 3456, '\P{InSC= consonant_Dead}', "");
Expect(0, 3456, '\P{^InSC= consonant_Dead}', "");
Error('\p{Is_Indic_Syllabic_Category= 	Consonant_Dead:=}');
Error('\P{Is_Indic_Syllabic_Category= 	Consonant_Dead:=}');
Expect(1, 3455, '\p{Is_Indic_Syllabic_Category=consonantdead}', "");
Expect(0, 3455, '\p{^Is_Indic_Syllabic_Category=consonantdead}', "");
Expect(0, 3455, '\P{Is_Indic_Syllabic_Category=consonantdead}', "");
Expect(1, 3455, '\P{^Is_Indic_Syllabic_Category=consonantdead}', "");
Expect(0, 3456, '\p{Is_Indic_Syllabic_Category=consonantdead}', "");
Expect(1, 3456, '\p{^Is_Indic_Syllabic_Category=consonantdead}', "");
Expect(1, 3456, '\P{Is_Indic_Syllabic_Category=consonantdead}', "");
Expect(0, 3456, '\P{^Is_Indic_Syllabic_Category=consonantdead}', "");
Expect(1, 3455, '\p{Is_Indic_Syllabic_Category= Consonant_Dead}', "");
Expect(0, 3455, '\p{^Is_Indic_Syllabic_Category= Consonant_Dead}', "");
Expect(0, 3455, '\P{Is_Indic_Syllabic_Category= Consonant_Dead}', "");
Expect(1, 3455, '\P{^Is_Indic_Syllabic_Category= Consonant_Dead}', "");
Expect(0, 3456, '\p{Is_Indic_Syllabic_Category= Consonant_Dead}', "");
Expect(1, 3456, '\p{^Is_Indic_Syllabic_Category= Consonant_Dead}', "");
Expect(1, 3456, '\P{Is_Indic_Syllabic_Category= Consonant_Dead}', "");
Expect(0, 3456, '\P{^Is_Indic_Syllabic_Category= Consonant_Dead}', "");
Error('\p{Is_InSC=/a/-Consonant_Dead}');
Error('\P{Is_InSC=/a/-Consonant_Dead}');
Expect(1, 3455, '\p{Is_InSC=consonantdead}', "");
Expect(0, 3455, '\p{^Is_InSC=consonantdead}', "");
Expect(0, 3455, '\P{Is_InSC=consonantdead}', "");
Expect(1, 3455, '\P{^Is_InSC=consonantdead}', "");
Expect(0, 3456, '\p{Is_InSC=consonantdead}', "");
Expect(1, 3456, '\p{^Is_InSC=consonantdead}', "");
Expect(1, 3456, '\P{Is_InSC=consonantdead}', "");
Expect(0, 3456, '\P{^Is_InSC=consonantdead}', "");
Expect(1, 3455, '\p{Is_InSC=	-consonant_dead}', "");
Expect(0, 3455, '\p{^Is_InSC=	-consonant_dead}', "");
Expect(0, 3455, '\P{Is_InSC=	-consonant_dead}', "");
Expect(1, 3455, '\P{^Is_InSC=	-consonant_dead}', "");
Expect(0, 3456, '\p{Is_InSC=	-consonant_dead}', "");
Expect(1, 3456, '\p{^Is_InSC=	-consonant_dead}', "");
Expect(1, 3456, '\P{Is_InSC=	-consonant_dead}', "");
Expect(0, 3456, '\P{^Is_InSC=	-consonant_dead}', "");
Error('\p{Indic_Syllabic_Category:    CONSONANT_final:=}');
Error('\P{Indic_Syllabic_Category:    CONSONANT_final:=}');
Expect(1, 44002, '\p{Indic_Syllabic_Category: consonantfinal}', "");
Expect(0, 44002, '\p{^Indic_Syllabic_Category: consonantfinal}', "");
Expect(0, 44002, '\P{Indic_Syllabic_Category: consonantfinal}', "");
Expect(1, 44002, '\P{^Indic_Syllabic_Category: consonantfinal}', "");
Expect(0, 44003, '\p{Indic_Syllabic_Category: consonantfinal}', "");
Expect(1, 44003, '\p{^Indic_Syllabic_Category: consonantfinal}', "");
Expect(1, 44003, '\P{Indic_Syllabic_Category: consonantfinal}', "");
Expect(0, 44003, '\P{^Indic_Syllabic_Category: consonantfinal}', "");
Expect(1, 44002, '\p{Indic_Syllabic_Category=_	Consonant_Final}', "");
Expect(0, 44002, '\p{^Indic_Syllabic_Category=_	Consonant_Final}', "");
Expect(0, 44002, '\P{Indic_Syllabic_Category=_	Consonant_Final}', "");
Expect(1, 44002, '\P{^Indic_Syllabic_Category=_	Consonant_Final}', "");
Expect(0, 44003, '\p{Indic_Syllabic_Category=_	Consonant_Final}', "");
Expect(1, 44003, '\p{^Indic_Syllabic_Category=_	Consonant_Final}', "");
Expect(1, 44003, '\P{Indic_Syllabic_Category=_	Consonant_Final}', "");
Expect(0, 44003, '\P{^Indic_Syllabic_Category=_	Consonant_Final}', "");
Error('\p{InSC=__consonant_Final:=}');
Error('\P{InSC=__consonant_Final:=}');
Expect(1, 44002, '\p{InSC=consonantfinal}', "");
Expect(0, 44002, '\p{^InSC=consonantfinal}', "");
Expect(0, 44002, '\P{InSC=consonantfinal}', "");
Expect(1, 44002, '\P{^InSC=consonantfinal}', "");
Expect(0, 44003, '\p{InSC=consonantfinal}', "");
Expect(1, 44003, '\p{^InSC=consonantfinal}', "");
Expect(1, 44003, '\P{InSC=consonantfinal}', "");
Expect(0, 44003, '\P{^InSC=consonantfinal}', "");
Expect(1, 44002, '\p{InSC=  Consonant_Final}', "");
Expect(0, 44002, '\p{^InSC=  Consonant_Final}', "");
Expect(0, 44002, '\P{InSC=  Consonant_Final}', "");
Expect(1, 44002, '\P{^InSC=  Consonant_Final}', "");
Expect(0, 44003, '\p{InSC=  Consonant_Final}', "");
Expect(1, 44003, '\p{^InSC=  Consonant_Final}', "");
Expect(1, 44003, '\P{InSC=  Consonant_Final}', "");
Expect(0, 44003, '\P{^InSC=  Consonant_Final}', "");
Error('\p{Is_Indic_Syllabic_Category=__consonant_final/a/}');
Error('\P{Is_Indic_Syllabic_Category=__consonant_final/a/}');
Expect(1, 44002, '\p{Is_Indic_Syllabic_Category=consonantfinal}', "");
Expect(0, 44002, '\p{^Is_Indic_Syllabic_Category=consonantfinal}', "");
Expect(0, 44002, '\P{Is_Indic_Syllabic_Category=consonantfinal}', "");
Expect(1, 44002, '\P{^Is_Indic_Syllabic_Category=consonantfinal}', "");
Expect(0, 44003, '\p{Is_Indic_Syllabic_Category=consonantfinal}', "");
Expect(1, 44003, '\p{^Is_Indic_Syllabic_Category=consonantfinal}', "");
Expect(1, 44003, '\P{Is_Indic_Syllabic_Category=consonantfinal}', "");
Expect(0, 44003, '\P{^Is_Indic_Syllabic_Category=consonantfinal}', "");
Expect(1, 44002, '\p{Is_Indic_Syllabic_Category=	_Consonant_final}', "");
Expect(0, 44002, '\p{^Is_Indic_Syllabic_Category=	_Consonant_final}', "");
Expect(0, 44002, '\P{Is_Indic_Syllabic_Category=	_Consonant_final}', "");
Expect(1, 44002, '\P{^Is_Indic_Syllabic_Category=	_Consonant_final}', "");
Expect(0, 44003, '\p{Is_Indic_Syllabic_Category=	_Consonant_final}', "");
Expect(1, 44003, '\p{^Is_Indic_Syllabic_Category=	_Consonant_final}', "");
Expect(1, 44003, '\P{Is_Indic_Syllabic_Category=	_Consonant_final}', "");
Expect(0, 44003, '\P{^Is_Indic_Syllabic_Category=	_Consonant_final}', "");
Error('\p{Is_InSC=:= 	CONSONANT_final}');
Error('\P{Is_InSC=:= 	CONSONANT_final}');
Expect(1, 44002, '\p{Is_InSC=consonantfinal}', "");
Expect(0, 44002, '\p{^Is_InSC=consonantfinal}', "");
Expect(0, 44002, '\P{Is_InSC=consonantfinal}', "");
Expect(1, 44002, '\P{^Is_InSC=consonantfinal}', "");
Expect(0, 44003, '\p{Is_InSC=consonantfinal}', "");
Expect(1, 44003, '\p{^Is_InSC=consonantfinal}', "");
Expect(1, 44003, '\P{Is_InSC=consonantfinal}', "");
Expect(0, 44003, '\P{^Is_InSC=consonantfinal}', "");
Expect(1, 44002, '\p{Is_InSC=-	Consonant_final}', "");
Expect(0, 44002, '\p{^Is_InSC=-	Consonant_final}', "");
Expect(0, 44002, '\P{Is_InSC=-	Consonant_final}', "");
Expect(1, 44002, '\P{^Is_InSC=-	Consonant_final}', "");
Expect(0, 44003, '\p{Is_InSC=-	Consonant_final}', "");
Expect(1, 44003, '\p{^Is_InSC=-	Consonant_final}', "");
Expect(1, 44003, '\P{Is_InSC=-	Consonant_final}', "");
Expect(0, 44003, '\P{^Is_InSC=-	Consonant_final}', "");
Error('\p{Indic_Syllabic_Category=/a/_consonant_Head_Letter}');
Error('\P{Indic_Syllabic_Category=/a/_consonant_Head_Letter}');
Expect(1, 3980, '\p{Indic_Syllabic_Category=consonantheadletter}', "");
Expect(0, 3980, '\p{^Indic_Syllabic_Category=consonantheadletter}', "");
Expect(0, 3980, '\P{Indic_Syllabic_Category=consonantheadletter}', "");
Expect(1, 3980, '\P{^Indic_Syllabic_Category=consonantheadletter}', "");
Expect(0, 3981, '\p{Indic_Syllabic_Category=consonantheadletter}', "");
Expect(1, 3981, '\p{^Indic_Syllabic_Category=consonantheadletter}', "");
Expect(1, 3981, '\P{Indic_Syllabic_Category=consonantheadletter}', "");
Expect(0, 3981, '\P{^Indic_Syllabic_Category=consonantheadletter}', "");
Expect(1, 3980, '\p{Indic_Syllabic_Category=-Consonant_Head_Letter}', "");
Expect(0, 3980, '\p{^Indic_Syllabic_Category=-Consonant_Head_Letter}', "");
Expect(0, 3980, '\P{Indic_Syllabic_Category=-Consonant_Head_Letter}', "");
Expect(1, 3980, '\P{^Indic_Syllabic_Category=-Consonant_Head_Letter}', "");
Expect(0, 3981, '\p{Indic_Syllabic_Category=-Consonant_Head_Letter}', "");
Expect(1, 3981, '\p{^Indic_Syllabic_Category=-Consonant_Head_Letter}', "");
Expect(1, 3981, '\P{Indic_Syllabic_Category=-Consonant_Head_Letter}', "");
Expect(0, 3981, '\P{^Indic_Syllabic_Category=-Consonant_Head_Letter}', "");
Error('\p{InSC=-Consonant_head_letter/a/}');
Error('\P{InSC=-Consonant_head_letter/a/}');
Expect(1, 3980, '\p{InSC=consonantheadletter}', "");
Expect(0, 3980, '\p{^InSC=consonantheadletter}', "");
Expect(0, 3980, '\P{InSC=consonantheadletter}', "");
Expect(1, 3980, '\P{^InSC=consonantheadletter}', "");
Expect(0, 3981, '\p{InSC=consonantheadletter}', "");
Expect(1, 3981, '\p{^InSC=consonantheadletter}', "");
Expect(1, 3981, '\P{InSC=consonantheadletter}', "");
Expect(0, 3981, '\P{^InSC=consonantheadletter}', "");
Expect(1, 3980, '\p{InSC=_Consonant_HEAD_Letter}', "");
Expect(0, 3980, '\p{^InSC=_Consonant_HEAD_Letter}', "");
Expect(0, 3980, '\P{InSC=_Consonant_HEAD_Letter}', "");
Expect(1, 3980, '\P{^InSC=_Consonant_HEAD_Letter}', "");
Expect(0, 3981, '\p{InSC=_Consonant_HEAD_Letter}', "");
Expect(1, 3981, '\p{^InSC=_Consonant_HEAD_Letter}', "");
Expect(1, 3981, '\P{InSC=_Consonant_HEAD_Letter}', "");
Expect(0, 3981, '\P{^InSC=_Consonant_HEAD_Letter}', "");
Error('\p{Is_Indic_Syllabic_Category=_:=Consonant_Head_LETTER}');
Error('\P{Is_Indic_Syllabic_Category=_:=Consonant_Head_LETTER}');
Expect(1, 3980, '\p{Is_Indic_Syllabic_Category=consonantheadletter}', "");
Expect(0, 3980, '\p{^Is_Indic_Syllabic_Category=consonantheadletter}', "");
Expect(0, 3980, '\P{Is_Indic_Syllabic_Category=consonantheadletter}', "");
Expect(1, 3980, '\P{^Is_Indic_Syllabic_Category=consonantheadletter}', "");
Expect(0, 3981, '\p{Is_Indic_Syllabic_Category=consonantheadletter}', "");
Expect(1, 3981, '\p{^Is_Indic_Syllabic_Category=consonantheadletter}', "");
Expect(1, 3981, '\P{Is_Indic_Syllabic_Category=consonantheadletter}', "");
Expect(0, 3981, '\P{^Is_Indic_Syllabic_Category=consonantheadletter}', "");
Expect(1, 3980, '\p{Is_Indic_Syllabic_Category=	Consonant_Head_Letter}', "");
Expect(0, 3980, '\p{^Is_Indic_Syllabic_Category=	Consonant_Head_Letter}', "");
Expect(0, 3980, '\P{Is_Indic_Syllabic_Category=	Consonant_Head_Letter}', "");
Expect(1, 3980, '\P{^Is_Indic_Syllabic_Category=	Consonant_Head_Letter}', "");
Expect(0, 3981, '\p{Is_Indic_Syllabic_Category=	Consonant_Head_Letter}', "");
Expect(1, 3981, '\p{^Is_Indic_Syllabic_Category=	Consonant_Head_Letter}', "");
Expect(1, 3981, '\P{Is_Indic_Syllabic_Category=	Consonant_Head_Letter}', "");
Expect(0, 3981, '\P{^Is_Indic_Syllabic_Category=	Consonant_Head_Letter}', "");
Error('\p{Is_InSC: 	CONSONANT_Head_Letter/a/}');
Error('\P{Is_InSC: 	CONSONANT_Head_Letter/a/}');
Expect(1, 3980, '\p{Is_InSC: consonantheadletter}', "");
Expect(0, 3980, '\p{^Is_InSC: consonantheadletter}', "");
Expect(0, 3980, '\P{Is_InSC: consonantheadletter}', "");
Expect(1, 3980, '\P{^Is_InSC: consonantheadletter}', "");
Expect(0, 3981, '\p{Is_InSC: consonantheadletter}', "");
Expect(1, 3981, '\p{^Is_InSC: consonantheadletter}', "");
Expect(1, 3981, '\P{Is_InSC: consonantheadletter}', "");
Expect(0, 3981, '\P{^Is_InSC: consonantheadletter}', "");
Expect(1, 3980, '\p{Is_InSC=	Consonant_head_Letter}', "");
Expect(0, 3980, '\p{^Is_InSC=	Consonant_head_Letter}', "");
Expect(0, 3980, '\P{Is_InSC=	Consonant_head_Letter}', "");
Expect(1, 3980, '\P{^Is_InSC=	Consonant_head_Letter}', "");
Expect(0, 3981, '\p{Is_InSC=	Consonant_head_Letter}', "");
Expect(1, 3981, '\p{^Is_InSC=	Consonant_head_Letter}', "");
Expect(1, 3981, '\P{Is_InSC=	Consonant_head_Letter}', "");
Expect(0, 3981, '\P{^Is_InSC=	Consonant_head_Letter}', "");
Error('\p{Indic_Syllabic_Category=_/a/Consonant_Killer}');
Error('\P{Indic_Syllabic_Category=_/a/Consonant_Killer}');
Expect(1, 6093, '\p{Indic_Syllabic_Category=consonantkiller}', "");
Expect(0, 6093, '\p{^Indic_Syllabic_Category=consonantkiller}', "");
Expect(0, 6093, '\P{Indic_Syllabic_Category=consonantkiller}', "");
Expect(1, 6093, '\P{^Indic_Syllabic_Category=consonantkiller}', "");
Expect(0, 6094, '\p{Indic_Syllabic_Category=consonantkiller}', "");
Expect(1, 6094, '\p{^Indic_Syllabic_Category=consonantkiller}', "");
Expect(1, 6094, '\P{Indic_Syllabic_Category=consonantkiller}', "");
Expect(0, 6094, '\P{^Indic_Syllabic_Category=consonantkiller}', "");
Expect(1, 6093, '\p{Indic_Syllabic_Category=_	Consonant_Killer}', "");
Expect(0, 6093, '\p{^Indic_Syllabic_Category=_	Consonant_Killer}', "");
Expect(0, 6093, '\P{Indic_Syllabic_Category=_	Consonant_Killer}', "");
Expect(1, 6093, '\P{^Indic_Syllabic_Category=_	Consonant_Killer}', "");
Expect(0, 6094, '\p{Indic_Syllabic_Category=_	Consonant_Killer}', "");
Expect(1, 6094, '\p{^Indic_Syllabic_Category=_	Consonant_Killer}', "");
Expect(1, 6094, '\P{Indic_Syllabic_Category=_	Consonant_Killer}', "");
Expect(0, 6094, '\P{^Indic_Syllabic_Category=_	Consonant_Killer}', "");
Error('\p{InSC=-Consonant_KILLER/a/}');
Error('\P{InSC=-Consonant_KILLER/a/}');
Expect(1, 6093, '\p{InSC=consonantkiller}', "");
Expect(0, 6093, '\p{^InSC=consonantkiller}', "");
Expect(0, 6093, '\P{InSC=consonantkiller}', "");
Expect(1, 6093, '\P{^InSC=consonantkiller}', "");
Expect(0, 6094, '\p{InSC=consonantkiller}', "");
Expect(1, 6094, '\p{^InSC=consonantkiller}', "");
Expect(1, 6094, '\P{InSC=consonantkiller}', "");
Expect(0, 6094, '\P{^InSC=consonantkiller}', "");
Expect(1, 6093, '\p{InSC= _CONSONANT_killer}', "");
Expect(0, 6093, '\p{^InSC= _CONSONANT_killer}', "");
Expect(0, 6093, '\P{InSC= _CONSONANT_killer}', "");
Expect(1, 6093, '\P{^InSC= _CONSONANT_killer}', "");
Expect(0, 6094, '\p{InSC= _CONSONANT_killer}', "");
Expect(1, 6094, '\p{^InSC= _CONSONANT_killer}', "");
Expect(1, 6094, '\P{InSC= _CONSONANT_killer}', "");
Expect(0, 6094, '\P{^InSC= _CONSONANT_killer}', "");
Error('\p{Is_Indic_Syllabic_Category:   :=_Consonant_Killer}');
Error('\P{Is_Indic_Syllabic_Category:   :=_Consonant_Killer}');
Expect(1, 6093, '\p{Is_Indic_Syllabic_Category=consonantkiller}', "");
Expect(0, 6093, '\p{^Is_Indic_Syllabic_Category=consonantkiller}', "");
Expect(0, 6093, '\P{Is_Indic_Syllabic_Category=consonantkiller}', "");
Expect(1, 6093, '\P{^Is_Indic_Syllabic_Category=consonantkiller}', "");
Expect(0, 6094, '\p{Is_Indic_Syllabic_Category=consonantkiller}', "");
Expect(1, 6094, '\p{^Is_Indic_Syllabic_Category=consonantkiller}', "");
Expect(1, 6094, '\P{Is_Indic_Syllabic_Category=consonantkiller}', "");
Expect(0, 6094, '\P{^Is_Indic_Syllabic_Category=consonantkiller}', "");
Expect(1, 6093, '\p{Is_Indic_Syllabic_Category=	CONSONANT_Killer}', "");
Expect(0, 6093, '\p{^Is_Indic_Syllabic_Category=	CONSONANT_Killer}', "");
Expect(0, 6093, '\P{Is_Indic_Syllabic_Category=	CONSONANT_Killer}', "");
Expect(1, 6093, '\P{^Is_Indic_Syllabic_Category=	CONSONANT_Killer}', "");
Expect(0, 6094, '\p{Is_Indic_Syllabic_Category=	CONSONANT_Killer}', "");
Expect(1, 6094, '\p{^Is_Indic_Syllabic_Category=	CONSONANT_Killer}', "");
Expect(1, 6094, '\P{Is_Indic_Syllabic_Category=	CONSONANT_Killer}', "");
Expect(0, 6094, '\P{^Is_Indic_Syllabic_Category=	CONSONANT_Killer}', "");
Error('\p{Is_InSC:--Consonant_Killer:=}');
Error('\P{Is_InSC:--Consonant_Killer:=}');
Expect(1, 6093, '\p{Is_InSC=consonantkiller}', "");
Expect(0, 6093, '\p{^Is_InSC=consonantkiller}', "");
Expect(0, 6093, '\P{Is_InSC=consonantkiller}', "");
Expect(1, 6093, '\P{^Is_InSC=consonantkiller}', "");
Expect(0, 6094, '\p{Is_InSC=consonantkiller}', "");
Expect(1, 6094, '\p{^Is_InSC=consonantkiller}', "");
Expect(1, 6094, '\P{Is_InSC=consonantkiller}', "");
Expect(0, 6094, '\P{^Is_InSC=consonantkiller}', "");
Expect(1, 6093, '\p{Is_InSC:	- CONSONANT_killer}', "");
Expect(0, 6093, '\p{^Is_InSC:	- CONSONANT_killer}', "");
Expect(0, 6093, '\P{Is_InSC:	- CONSONANT_killer}', "");
Expect(1, 6093, '\P{^Is_InSC:	- CONSONANT_killer}', "");
Expect(0, 6094, '\p{Is_InSC:	- CONSONANT_killer}', "");
Expect(1, 6094, '\p{^Is_InSC:	- CONSONANT_killer}', "");
Expect(1, 6094, '\P{Is_InSC:	- CONSONANT_killer}', "");
Expect(0, 6094, '\P{^Is_InSC:	- CONSONANT_killer}', "");
Error('\p{Indic_Syllabic_Category=/a/	_Consonant_Medial}');
Error('\P{Indic_Syllabic_Category=/a/	_Consonant_Medial}');
Expect(1, 71455, '\p{Indic_Syllabic_Category=consonantmedial}', "");
Expect(0, 71455, '\p{^Indic_Syllabic_Category=consonantmedial}', "");
Expect(0, 71455, '\P{Indic_Syllabic_Category=consonantmedial}', "");
Expect(1, 71455, '\P{^Indic_Syllabic_Category=consonantmedial}', "");
Expect(0, 71456, '\p{Indic_Syllabic_Category=consonantmedial}', "");
Expect(1, 71456, '\p{^Indic_Syllabic_Category=consonantmedial}', "");
Expect(1, 71456, '\P{Indic_Syllabic_Category=consonantmedial}', "");
Expect(0, 71456, '\P{^Indic_Syllabic_Category=consonantmedial}', "");
Expect(1, 71455, '\p{Indic_Syllabic_Category=	-Consonant_Medial}', "");
Expect(0, 71455, '\p{^Indic_Syllabic_Category=	-Consonant_Medial}', "");
Expect(0, 71455, '\P{Indic_Syllabic_Category=	-Consonant_Medial}', "");
Expect(1, 71455, '\P{^Indic_Syllabic_Category=	-Consonant_Medial}', "");
Expect(0, 71456, '\p{Indic_Syllabic_Category=	-Consonant_Medial}', "");
Expect(1, 71456, '\p{^Indic_Syllabic_Category=	-Consonant_Medial}', "");
Expect(1, 71456, '\P{Indic_Syllabic_Category=	-Consonant_Medial}', "");
Expect(0, 71456, '\P{^Indic_Syllabic_Category=	-Consonant_Medial}', "");
Error('\p{InSC=_-Consonant_medial:=}');
Error('\P{InSC=_-Consonant_medial:=}');
Expect(1, 71455, '\p{InSC=consonantmedial}', "");
Expect(0, 71455, '\p{^InSC=consonantmedial}', "");
Expect(0, 71455, '\P{InSC=consonantmedial}', "");
Expect(1, 71455, '\P{^InSC=consonantmedial}', "");
Expect(0, 71456, '\p{InSC=consonantmedial}', "");
Expect(1, 71456, '\p{^InSC=consonantmedial}', "");
Expect(1, 71456, '\P{InSC=consonantmedial}', "");
Expect(0, 71456, '\P{^InSC=consonantmedial}', "");
Expect(1, 71455, '\p{InSC=_Consonant_medial}', "");
Expect(0, 71455, '\p{^InSC=_Consonant_medial}', "");
Expect(0, 71455, '\P{InSC=_Consonant_medial}', "");
Expect(1, 71455, '\P{^InSC=_Consonant_medial}', "");
Expect(0, 71456, '\p{InSC=_Consonant_medial}', "");
Expect(1, 71456, '\p{^InSC=_Consonant_medial}', "");
Expect(1, 71456, '\P{InSC=_Consonant_medial}', "");
Expect(0, 71456, '\P{^InSC=_Consonant_medial}', "");
Error('\p{Is_Indic_Syllabic_Category=:=-	CONSONANT_medial}');
Error('\P{Is_Indic_Syllabic_Category=:=-	CONSONANT_medial}');
Expect(1, 71455, '\p{Is_Indic_Syllabic_Category=consonantmedial}', "");
Expect(0, 71455, '\p{^Is_Indic_Syllabic_Category=consonantmedial}', "");
Expect(0, 71455, '\P{Is_Indic_Syllabic_Category=consonantmedial}', "");
Expect(1, 71455, '\P{^Is_Indic_Syllabic_Category=consonantmedial}', "");
Expect(0, 71456, '\p{Is_Indic_Syllabic_Category=consonantmedial}', "");
Expect(1, 71456, '\p{^Is_Indic_Syllabic_Category=consonantmedial}', "");
Expect(1, 71456, '\P{Is_Indic_Syllabic_Category=consonantmedial}', "");
Expect(0, 71456, '\P{^Is_Indic_Syllabic_Category=consonantmedial}', "");
Expect(1, 71455, '\p{Is_Indic_Syllabic_Category= -consonant_medial}', "");
Expect(0, 71455, '\p{^Is_Indic_Syllabic_Category= -consonant_medial}', "");
Expect(0, 71455, '\P{Is_Indic_Syllabic_Category= -consonant_medial}', "");
Expect(1, 71455, '\P{^Is_Indic_Syllabic_Category= -consonant_medial}', "");
Expect(0, 71456, '\p{Is_Indic_Syllabic_Category= -consonant_medial}', "");
Expect(1, 71456, '\p{^Is_Indic_Syllabic_Category= -consonant_medial}', "");
Expect(1, 71456, '\P{Is_Indic_Syllabic_Category= -consonant_medial}', "");
Expect(0, 71456, '\P{^Is_Indic_Syllabic_Category= -consonant_medial}', "");
Error('\p{Is_InSC=/a/ consonant_MEDIAL}');
Error('\P{Is_InSC=/a/ consonant_MEDIAL}');
Expect(1, 71455, '\p{Is_InSC=consonantmedial}', "");
Expect(0, 71455, '\p{^Is_InSC=consonantmedial}', "");
Expect(0, 71455, '\P{Is_InSC=consonantmedial}', "");
Expect(1, 71455, '\P{^Is_InSC=consonantmedial}', "");
Expect(0, 71456, '\p{Is_InSC=consonantmedial}', "");
Expect(1, 71456, '\p{^Is_InSC=consonantmedial}', "");
Expect(1, 71456, '\P{Is_InSC=consonantmedial}', "");
Expect(0, 71456, '\P{^Is_InSC=consonantmedial}', "");
Expect(1, 71455, '\p{Is_InSC=CONSONANT_medial}', "");
Expect(0, 71455, '\p{^Is_InSC=CONSONANT_medial}', "");
Expect(0, 71455, '\P{Is_InSC=CONSONANT_medial}', "");
Expect(1, 71455, '\P{^Is_InSC=CONSONANT_medial}', "");
Expect(0, 71456, '\p{Is_InSC=CONSONANT_medial}', "");
Expect(1, 71456, '\p{^Is_InSC=CONSONANT_medial}', "");
Expect(1, 71456, '\P{Is_InSC=CONSONANT_medial}', "");
Expect(0, 71456, '\P{^Is_InSC=CONSONANT_medial}', "");
Error('\p{Indic_Syllabic_Category=	-consonant_placeholder:=}');
Error('\P{Indic_Syllabic_Category=	-consonant_placeholder:=}');
Expect(1, 9676, '\p{Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(0, 9676, '\p{^Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(0, 9676, '\P{Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(1, 9676, '\P{^Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(0, 9677, '\p{Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(1, 9677, '\p{^Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(1, 9677, '\P{Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(0, 9677, '\P{^Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(1, 9676, '\p{Indic_Syllabic_Category=__CONSONANT_placeholder}', "");
Expect(0, 9676, '\p{^Indic_Syllabic_Category=__CONSONANT_placeholder}', "");
Expect(0, 9676, '\P{Indic_Syllabic_Category=__CONSONANT_placeholder}', "");
Expect(1, 9676, '\P{^Indic_Syllabic_Category=__CONSONANT_placeholder}', "");
Expect(0, 9677, '\p{Indic_Syllabic_Category=__CONSONANT_placeholder}', "");
Expect(1, 9677, '\p{^Indic_Syllabic_Category=__CONSONANT_placeholder}', "");
Expect(1, 9677, '\P{Indic_Syllabic_Category=__CONSONANT_placeholder}', "");
Expect(0, 9677, '\P{^Indic_Syllabic_Category=__CONSONANT_placeholder}', "");
Error('\p{InSC=__CONSONANT_PLACEHOLDER:=}');
Error('\P{InSC=__CONSONANT_PLACEHOLDER:=}');
Expect(1, 9676, '\p{InSC=consonantplaceholder}', "");
Expect(0, 9676, '\p{^InSC=consonantplaceholder}', "");
Expect(0, 9676, '\P{InSC=consonantplaceholder}', "");
Expect(1, 9676, '\P{^InSC=consonantplaceholder}', "");
Expect(0, 9677, '\p{InSC=consonantplaceholder}', "");
Expect(1, 9677, '\p{^InSC=consonantplaceholder}', "");
Expect(1, 9677, '\P{InSC=consonantplaceholder}', "");
Expect(0, 9677, '\P{^InSC=consonantplaceholder}', "");
Expect(1, 9676, '\p{InSC=	-CONSONANT_Placeholder}', "");
Expect(0, 9676, '\p{^InSC=	-CONSONANT_Placeholder}', "");
Expect(0, 9676, '\P{InSC=	-CONSONANT_Placeholder}', "");
Expect(1, 9676, '\P{^InSC=	-CONSONANT_Placeholder}', "");
Expect(0, 9677, '\p{InSC=	-CONSONANT_Placeholder}', "");
Expect(1, 9677, '\p{^InSC=	-CONSONANT_Placeholder}', "");
Expect(1, 9677, '\P{InSC=	-CONSONANT_Placeholder}', "");
Expect(0, 9677, '\P{^InSC=	-CONSONANT_Placeholder}', "");
Error('\p{Is_Indic_Syllabic_Category=	:=consonant_Placeholder}');
Error('\P{Is_Indic_Syllabic_Category=	:=consonant_Placeholder}');
Expect(1, 9676, '\p{Is_Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(0, 9676, '\p{^Is_Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(0, 9676, '\P{Is_Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(1, 9676, '\P{^Is_Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(0, 9677, '\p{Is_Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(1, 9677, '\p{^Is_Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(1, 9677, '\P{Is_Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(0, 9677, '\P{^Is_Indic_Syllabic_Category=consonantplaceholder}', "");
Expect(1, 9676, '\p{Is_Indic_Syllabic_Category=__Consonant_PLACEHOLDER}', "");
Expect(0, 9676, '\p{^Is_Indic_Syllabic_Category=__Consonant_PLACEHOLDER}', "");
Expect(0, 9676, '\P{Is_Indic_Syllabic_Category=__Consonant_PLACEHOLDER}', "");
Expect(1, 9676, '\P{^Is_Indic_Syllabic_Category=__Consonant_PLACEHOLDER}', "");
Expect(0, 9677, '\p{Is_Indic_Syllabic_Category=__Consonant_PLACEHOLDER}', "");
Expect(1, 9677, '\p{^Is_Indic_Syllabic_Category=__Consonant_PLACEHOLDER}', "");
Expect(1, 9677, '\P{Is_Indic_Syllabic_Category=__Consonant_PLACEHOLDER}', "");
Expect(0, 9677, '\P{^Is_Indic_Syllabic_Category=__Consonant_PLACEHOLDER}', "");
Error('\p{Is_InSC: /a/Consonant_Placeholder}');
Error('\P{Is_InSC: /a/Consonant_Placeholder}');
Expect(1, 9676, '\p{Is_InSC=consonantplaceholder}', "");
Expect(0, 9676, '\p{^Is_InSC=consonantplaceholder}', "");
Expect(0, 9676, '\P{Is_InSC=consonantplaceholder}', "");
Expect(1, 9676, '\P{^Is_InSC=consonantplaceholder}', "");
Expect(0, 9677, '\p{Is_InSC=consonantplaceholder}', "");
Expect(1, 9677, '\p{^Is_InSC=consonantplaceholder}', "");
Expect(1, 9677, '\P{Is_InSC=consonantplaceholder}', "");
Expect(0, 9677, '\P{^Is_InSC=consonantplaceholder}', "");
Expect(1, 9676, '\p{Is_InSC=-	Consonant_Placeholder}', "");
Expect(0, 9676, '\p{^Is_InSC=-	Consonant_Placeholder}', "");
Expect(0, 9676, '\P{Is_InSC=-	Consonant_Placeholder}', "");
Expect(1, 9676, '\P{^Is_InSC=-	Consonant_Placeholder}', "");
Expect(0, 9677, '\p{Is_InSC=-	Consonant_Placeholder}', "");
Expect(1, 9677, '\p{^Is_InSC=-	Consonant_Placeholder}', "");
Expect(1, 9677, '\P{Is_InSC=-	Consonant_Placeholder}', "");
Expect(0, 9677, '\P{^Is_InSC=-	Consonant_Placeholder}', "");
Error('\p{Indic_Syllabic_Category=__Consonant_preceding_Repha:=}');
Error('\P{Indic_Syllabic_Category=__Consonant_preceding_Repha:=}');
Expect(1, 3406, '\p{Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(0, 3406, '\p{^Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(0, 3406, '\P{Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(1, 3406, '\P{^Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(0, 3407, '\p{Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(1, 3407, '\p{^Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(1, 3407, '\P{Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(0, 3407, '\P{^Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(1, 3406, '\p{Indic_Syllabic_Category= _Consonant_Preceding_Repha}', "");
Expect(0, 3406, '\p{^Indic_Syllabic_Category= _Consonant_Preceding_Repha}', "");
Expect(0, 3406, '\P{Indic_Syllabic_Category= _Consonant_Preceding_Repha}', "");
Expect(1, 3406, '\P{^Indic_Syllabic_Category= _Consonant_Preceding_Repha}', "");
Expect(0, 3407, '\p{Indic_Syllabic_Category= _Consonant_Preceding_Repha}', "");
Expect(1, 3407, '\p{^Indic_Syllabic_Category= _Consonant_Preceding_Repha}', "");
Expect(1, 3407, '\P{Indic_Syllabic_Category= _Consonant_Preceding_Repha}', "");
Expect(0, 3407, '\P{^Indic_Syllabic_Category= _Consonant_Preceding_Repha}', "");
Error('\p{InSC=:=Consonant_Preceding_Repha}');
Error('\P{InSC=:=Consonant_Preceding_Repha}');
Expect(1, 3406, '\p{InSC=consonantprecedingrepha}', "");
Expect(0, 3406, '\p{^InSC=consonantprecedingrepha}', "");
Expect(0, 3406, '\P{InSC=consonantprecedingrepha}', "");
Expect(1, 3406, '\P{^InSC=consonantprecedingrepha}', "");
Expect(0, 3407, '\p{InSC=consonantprecedingrepha}', "");
Expect(1, 3407, '\p{^InSC=consonantprecedingrepha}', "");
Expect(1, 3407, '\P{InSC=consonantprecedingrepha}', "");
Expect(0, 3407, '\P{^InSC=consonantprecedingrepha}', "");
Expect(1, 3406, '\p{InSC=	_Consonant_preceding_Repha}', "");
Expect(0, 3406, '\p{^InSC=	_Consonant_preceding_Repha}', "");
Expect(0, 3406, '\P{InSC=	_Consonant_preceding_Repha}', "");
Expect(1, 3406, '\P{^InSC=	_Consonant_preceding_Repha}', "");
Expect(0, 3407, '\p{InSC=	_Consonant_preceding_Repha}', "");
Expect(1, 3407, '\p{^InSC=	_Consonant_preceding_Repha}', "");
Expect(1, 3407, '\P{InSC=	_Consonant_preceding_Repha}', "");
Expect(0, 3407, '\P{^InSC=	_Consonant_preceding_Repha}', "");
Error('\p{Is_Indic_Syllabic_Category:   _-Consonant_preceding_repha/a/}');
Error('\P{Is_Indic_Syllabic_Category:   _-Consonant_preceding_repha/a/}');
Expect(1, 3406, '\p{Is_Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(0, 3406, '\p{^Is_Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(0, 3406, '\P{Is_Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(1, 3406, '\P{^Is_Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(0, 3407, '\p{Is_Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(1, 3407, '\p{^Is_Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(1, 3407, '\P{Is_Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(0, 3407, '\P{^Is_Indic_Syllabic_Category=consonantprecedingrepha}', "");
Expect(1, 3406, '\p{Is_Indic_Syllabic_Category=	 Consonant_Preceding_Repha}', "");
Expect(0, 3406, '\p{^Is_Indic_Syllabic_Category=	 Consonant_Preceding_Repha}', "");
Expect(0, 3406, '\P{Is_Indic_Syllabic_Category=	 Consonant_Preceding_Repha}', "");
Expect(1, 3406, '\P{^Is_Indic_Syllabic_Category=	 Consonant_Preceding_Repha}', "");
Expect(0, 3407, '\p{Is_Indic_Syllabic_Category=	 Consonant_Preceding_Repha}', "");
Expect(1, 3407, '\p{^Is_Indic_Syllabic_Category=	 Consonant_Preceding_Repha}', "");
Expect(1, 3407, '\P{Is_Indic_Syllabic_Category=	 Consonant_Preceding_Repha}', "");
Expect(0, 3407, '\P{^Is_Indic_Syllabic_Category=	 Consonant_Preceding_Repha}', "");
Error('\p{Is_InSC=:=_Consonant_preceding_repha}');
Error('\P{Is_InSC=:=_Consonant_preceding_repha}');
Expect(1, 3406, '\p{Is_InSC:   consonantprecedingrepha}', "");
Expect(0, 3406, '\p{^Is_InSC:   consonantprecedingrepha}', "");
Expect(0, 3406, '\P{Is_InSC:   consonantprecedingrepha}', "");
Expect(1, 3406, '\P{^Is_InSC:   consonantprecedingrepha}', "");
Expect(0, 3407, '\p{Is_InSC:   consonantprecedingrepha}', "");
Expect(1, 3407, '\p{^Is_InSC:   consonantprecedingrepha}', "");
Expect(1, 3407, '\P{Is_InSC:   consonantprecedingrepha}', "");
Expect(0, 3407, '\P{^Is_InSC:   consonantprecedingrepha}', "");
Expect(1, 3406, '\p{Is_InSC: 	Consonant_preceding_Repha}', "");
Expect(0, 3406, '\p{^Is_InSC: 	Consonant_preceding_Repha}', "");
Expect(0, 3406, '\P{Is_InSC: 	Consonant_preceding_Repha}', "");
Expect(1, 3406, '\P{^Is_InSC: 	Consonant_preceding_Repha}', "");
Expect(0, 3407, '\p{Is_InSC: 	Consonant_preceding_Repha}', "");
Expect(1, 3407, '\p{^Is_InSC: 	Consonant_preceding_Repha}', "");
Expect(1, 3407, '\P{Is_InSC: 	Consonant_preceding_Repha}', "");
Expect(0, 3407, '\P{^Is_InSC: 	Consonant_preceding_Repha}', "");
Error('\p{Indic_Syllabic_Category= /a/Consonant_Prefixed}');
Error('\P{Indic_Syllabic_Category= /a/Consonant_Prefixed}');
Expect(1, 70083, '\p{Indic_Syllabic_Category=consonantprefixed}', "");
Expect(0, 70083, '\p{^Indic_Syllabic_Category=consonantprefixed}', "");
Expect(0, 70083, '\P{Indic_Syllabic_Category=consonantprefixed}', "");
Expect(1, 70083, '\P{^Indic_Syllabic_Category=consonantprefixed}', "");
Expect(0, 70084, '\p{Indic_Syllabic_Category=consonantprefixed}', "");
Expect(1, 70084, '\p{^Indic_Syllabic_Category=consonantprefixed}', "");
Expect(1, 70084, '\P{Indic_Syllabic_Category=consonantprefixed}', "");
Expect(0, 70084, '\P{^Indic_Syllabic_Category=consonantprefixed}', "");
Expect(1, 70083, '\p{Indic_Syllabic_Category= -Consonant_Prefixed}', "");
Expect(0, 70083, '\p{^Indic_Syllabic_Category= -Consonant_Prefixed}', "");
Expect(0, 70083, '\P{Indic_Syllabic_Category= -Consonant_Prefixed}', "");
Expect(1, 70083, '\P{^Indic_Syllabic_Category= -Consonant_Prefixed}', "");
Expect(0, 70084, '\p{Indic_Syllabic_Category= -Consonant_Prefixed}', "");
Expect(1, 70084, '\p{^Indic_Syllabic_Category= -Consonant_Prefixed}', "");
Expect(1, 70084, '\P{Indic_Syllabic_Category= -Consonant_Prefixed}', "");
Expect(0, 70084, '\P{^Indic_Syllabic_Category= -Consonant_Prefixed}', "");
Error('\p{InSC=		consonant_Prefixed:=}');
Error('\P{InSC=		consonant_Prefixed:=}');
Expect(1, 70083, '\p{InSC=consonantprefixed}', "");
Expect(0, 70083, '\p{^InSC=consonantprefixed}', "");
Expect(0, 70083, '\P{InSC=consonantprefixed}', "");
Expect(1, 70083, '\P{^InSC=consonantprefixed}', "");
Expect(0, 70084, '\p{InSC=consonantprefixed}', "");
Expect(1, 70084, '\p{^InSC=consonantprefixed}', "");
Expect(1, 70084, '\P{InSC=consonantprefixed}', "");
Expect(0, 70084, '\P{^InSC=consonantprefixed}', "");
Expect(1, 70083, '\p{InSC=-Consonant_Prefixed}', "");
Expect(0, 70083, '\p{^InSC=-Consonant_Prefixed}', "");
Expect(0, 70083, '\P{InSC=-Consonant_Prefixed}', "");
Expect(1, 70083, '\P{^InSC=-Consonant_Prefixed}', "");
Expect(0, 70084, '\p{InSC=-Consonant_Prefixed}', "");
Expect(1, 70084, '\p{^InSC=-Consonant_Prefixed}', "");
Expect(1, 70084, '\P{InSC=-Consonant_Prefixed}', "");
Expect(0, 70084, '\P{^InSC=-Consonant_Prefixed}', "");
Error('\p{Is_Indic_Syllabic_Category=-consonant_Prefixed:=}');
Error('\P{Is_Indic_Syllabic_Category=-consonant_Prefixed:=}');
Expect(1, 70083, '\p{Is_Indic_Syllabic_Category: consonantprefixed}', "");
Expect(0, 70083, '\p{^Is_Indic_Syllabic_Category: consonantprefixed}', "");
Expect(0, 70083, '\P{Is_Indic_Syllabic_Category: consonantprefixed}', "");
Expect(1, 70083, '\P{^Is_Indic_Syllabic_Category: consonantprefixed}', "");
Expect(0, 70084, '\p{Is_Indic_Syllabic_Category: consonantprefixed}', "");
Expect(1, 70084, '\p{^Is_Indic_Syllabic_Category: consonantprefixed}', "");
Expect(1, 70084, '\P{Is_Indic_Syllabic_Category: consonantprefixed}', "");
Expect(0, 70084, '\P{^Is_Indic_Syllabic_Category: consonantprefixed}', "");
Expect(1, 70083, '\p{Is_Indic_Syllabic_Category= 	consonant_Prefixed}', "");
Expect(0, 70083, '\p{^Is_Indic_Syllabic_Category= 	consonant_Prefixed}', "");
Expect(0, 70083, '\P{Is_Indic_Syllabic_Category= 	consonant_Prefixed}', "");
Expect(1, 70083, '\P{^Is_Indic_Syllabic_Category= 	consonant_Prefixed}', "");
Expect(0, 70084, '\p{Is_Indic_Syllabic_Category= 	consonant_Prefixed}', "");
Expect(1, 70084, '\p{^Is_Indic_Syllabic_Category= 	consonant_Prefixed}', "");
Expect(1, 70084, '\P{Is_Indic_Syllabic_Category= 	consonant_Prefixed}', "");
Expect(0, 70084, '\P{^Is_Indic_Syllabic_Category= 	consonant_Prefixed}', "");
Error('\p{Is_InSC=:=_-Consonant_Prefixed}');
Error('\P{Is_InSC=:=_-Consonant_Prefixed}');
Expect(1, 70083, '\p{Is_InSC=consonantprefixed}', "");
Expect(0, 70083, '\p{^Is_InSC=consonantprefixed}', "");
Expect(0, 70083, '\P{Is_InSC=consonantprefixed}', "");
Expect(1, 70083, '\P{^Is_InSC=consonantprefixed}', "");
Expect(0, 70084, '\p{Is_InSC=consonantprefixed}', "");
Expect(1, 70084, '\p{^Is_InSC=consonantprefixed}', "");
Expect(1, 70084, '\P{Is_InSC=consonantprefixed}', "");
Expect(0, 70084, '\P{^Is_InSC=consonantprefixed}', "");
Expect(1, 70083, '\p{Is_InSC= 	CONSONANT_PREFIXED}', "");
Expect(0, 70083, '\p{^Is_InSC= 	CONSONANT_PREFIXED}', "");
Expect(0, 70083, '\P{Is_InSC= 	CONSONANT_PREFIXED}', "");
Expect(1, 70083, '\P{^Is_InSC= 	CONSONANT_PREFIXED}', "");
Expect(0, 70084, '\p{Is_InSC= 	CONSONANT_PREFIXED}', "");
Expect(1, 70084, '\p{^Is_InSC= 	CONSONANT_PREFIXED}', "");
Expect(1, 70084, '\P{Is_InSC= 	CONSONANT_PREFIXED}', "");
Expect(0, 70084, '\P{^Is_InSC= 	CONSONANT_PREFIXED}', "");
Error('\p{Indic_Syllabic_Category=/a/	Consonant_Subjoined}');
Error('\P{Indic_Syllabic_Category=/a/	Consonant_Subjoined}');
Expect(1, 43453, '\p{Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(0, 43453, '\p{^Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(0, 43453, '\P{Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(1, 43453, '\P{^Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(0, 43454, '\p{Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(1, 43454, '\p{^Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(1, 43454, '\P{Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(0, 43454, '\P{^Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(1, 43453, '\p{Indic_Syllabic_Category= -CONSONANT_SUBJOINED}', "");
Expect(0, 43453, '\p{^Indic_Syllabic_Category= -CONSONANT_SUBJOINED}', "");
Expect(0, 43453, '\P{Indic_Syllabic_Category= -CONSONANT_SUBJOINED}', "");
Expect(1, 43453, '\P{^Indic_Syllabic_Category= -CONSONANT_SUBJOINED}', "");
Expect(0, 43454, '\p{Indic_Syllabic_Category= -CONSONANT_SUBJOINED}', "");
Expect(1, 43454, '\p{^Indic_Syllabic_Category= -CONSONANT_SUBJOINED}', "");
Expect(1, 43454, '\P{Indic_Syllabic_Category= -CONSONANT_SUBJOINED}', "");
Expect(0, 43454, '\P{^Indic_Syllabic_Category= -CONSONANT_SUBJOINED}', "");
Error('\p{InSC=:= -Consonant_subjoined}');
Error('\P{InSC=:= -Consonant_subjoined}');
Expect(1, 43453, '\p{InSC:   consonantsubjoined}', "");
Expect(0, 43453, '\p{^InSC:   consonantsubjoined}', "");
Expect(0, 43453, '\P{InSC:   consonantsubjoined}', "");
Expect(1, 43453, '\P{^InSC:   consonantsubjoined}', "");
Expect(0, 43454, '\p{InSC:   consonantsubjoined}', "");
Expect(1, 43454, '\p{^InSC:   consonantsubjoined}', "");
Expect(1, 43454, '\P{InSC:   consonantsubjoined}', "");
Expect(0, 43454, '\P{^InSC:   consonantsubjoined}', "");
Expect(1, 43453, '\p{InSC= Consonant_Subjoined}', "");
Expect(0, 43453, '\p{^InSC= Consonant_Subjoined}', "");
Expect(0, 43453, '\P{InSC= Consonant_Subjoined}', "");
Expect(1, 43453, '\P{^InSC= Consonant_Subjoined}', "");
Expect(0, 43454, '\p{InSC= Consonant_Subjoined}', "");
Expect(1, 43454, '\p{^InSC= Consonant_Subjoined}', "");
Expect(1, 43454, '\P{InSC= Consonant_Subjoined}', "");
Expect(0, 43454, '\P{^InSC= Consonant_Subjoined}', "");
Error('\p{Is_Indic_Syllabic_Category=/a/ Consonant_Subjoined}');
Error('\P{Is_Indic_Syllabic_Category=/a/ Consonant_Subjoined}');
Expect(1, 43453, '\p{Is_Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(0, 43453, '\p{^Is_Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(0, 43453, '\P{Is_Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(1, 43453, '\P{^Is_Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(0, 43454, '\p{Is_Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(1, 43454, '\p{^Is_Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(1, 43454, '\P{Is_Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(0, 43454, '\P{^Is_Indic_Syllabic_Category=consonantsubjoined}', "");
Expect(1, 43453, '\p{Is_Indic_Syllabic_Category=	Consonant_Subjoined}', "");
Expect(0, 43453, '\p{^Is_Indic_Syllabic_Category=	Consonant_Subjoined}', "");
Expect(0, 43453, '\P{Is_Indic_Syllabic_Category=	Consonant_Subjoined}', "");
Expect(1, 43453, '\P{^Is_Indic_Syllabic_Category=	Consonant_Subjoined}', "");
Expect(0, 43454, '\p{Is_Indic_Syllabic_Category=	Consonant_Subjoined}', "");
Expect(1, 43454, '\p{^Is_Indic_Syllabic_Category=	Consonant_Subjoined}', "");
Expect(1, 43454, '\P{Is_Indic_Syllabic_Category=	Consonant_Subjoined}', "");
Expect(0, 43454, '\P{^Is_Indic_Syllabic_Category=	Consonant_Subjoined}', "");
Error('\p{Is_InSC=-:=CONSONANT_subjoined}');
Error('\P{Is_InSC=-:=CONSONANT_subjoined}');
Expect(1, 43453, '\p{Is_InSC=consonantsubjoined}', "");
Expect(0, 43453, '\p{^Is_InSC=consonantsubjoined}', "");
Expect(0, 43453, '\P{Is_InSC=consonantsubjoined}', "");
Expect(1, 43453, '\P{^Is_InSC=consonantsubjoined}', "");
Expect(0, 43454, '\p{Is_InSC=consonantsubjoined}', "");
Expect(1, 43454, '\p{^Is_InSC=consonantsubjoined}', "");
Expect(1, 43454, '\P{Is_InSC=consonantsubjoined}', "");
Expect(0, 43454, '\P{^Is_InSC=consonantsubjoined}', "");
Expect(1, 43453, '\p{Is_InSC=_consonant_Subjoined}', "");
Expect(0, 43453, '\p{^Is_InSC=_consonant_Subjoined}', "");
Expect(0, 43453, '\P{Is_InSC=_consonant_Subjoined}', "");
Expect(1, 43453, '\P{^Is_InSC=_consonant_Subjoined}', "");
Expect(0, 43454, '\p{Is_InSC=_consonant_Subjoined}', "");
Expect(1, 43454, '\p{^Is_InSC=_consonant_Subjoined}', "");
Expect(1, 43454, '\P{Is_InSC=_consonant_Subjoined}', "");
Expect(0, 43454, '\P{^Is_InSC=_consonant_Subjoined}', "");
Error('\p{Indic_Syllabic_Category=-:=Consonant_Succeeding_REPHA}');
Error('\P{Indic_Syllabic_Category=-:=Consonant_Succeeding_REPHA}');
Expect(1, 43394, '\p{Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(0, 43394, '\p{^Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(0, 43394, '\P{Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(1, 43394, '\P{^Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(0, 43395, '\p{Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(1, 43395, '\p{^Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(1, 43395, '\P{Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(0, 43395, '\P{^Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(1, 43394, '\p{Indic_Syllabic_Category=	 Consonant_SUCCEEDING_repha}', "");
Expect(0, 43394, '\p{^Indic_Syllabic_Category=	 Consonant_SUCCEEDING_repha}', "");
Expect(0, 43394, '\P{Indic_Syllabic_Category=	 Consonant_SUCCEEDING_repha}', "");
Expect(1, 43394, '\P{^Indic_Syllabic_Category=	 Consonant_SUCCEEDING_repha}', "");
Expect(0, 43395, '\p{Indic_Syllabic_Category=	 Consonant_SUCCEEDING_repha}', "");
Expect(1, 43395, '\p{^Indic_Syllabic_Category=	 Consonant_SUCCEEDING_repha}', "");
Expect(1, 43395, '\P{Indic_Syllabic_Category=	 Consonant_SUCCEEDING_repha}', "");
Expect(0, 43395, '\P{^Indic_Syllabic_Category=	 Consonant_SUCCEEDING_repha}', "");
Error('\p{InSC=:=		CONSONANT_succeeding_REPHA}');
Error('\P{InSC=:=		CONSONANT_succeeding_REPHA}');
Expect(1, 43394, '\p{InSC=consonantsucceedingrepha}', "");
Expect(0, 43394, '\p{^InSC=consonantsucceedingrepha}', "");
Expect(0, 43394, '\P{InSC=consonantsucceedingrepha}', "");
Expect(1, 43394, '\P{^InSC=consonantsucceedingrepha}', "");
Expect(0, 43395, '\p{InSC=consonantsucceedingrepha}', "");
Expect(1, 43395, '\p{^InSC=consonantsucceedingrepha}', "");
Expect(1, 43395, '\P{InSC=consonantsucceedingrepha}', "");
Expect(0, 43395, '\P{^InSC=consonantsucceedingrepha}', "");
Expect(1, 43394, '\p{InSC= Consonant_SUCCEEDING_Repha}', "");
Expect(0, 43394, '\p{^InSC= Consonant_SUCCEEDING_Repha}', "");
Expect(0, 43394, '\P{InSC= Consonant_SUCCEEDING_Repha}', "");
Expect(1, 43394, '\P{^InSC= Consonant_SUCCEEDING_Repha}', "");
Expect(0, 43395, '\p{InSC= Consonant_SUCCEEDING_Repha}', "");
Expect(1, 43395, '\p{^InSC= Consonant_SUCCEEDING_Repha}', "");
Expect(1, 43395, '\P{InSC= Consonant_SUCCEEDING_Repha}', "");
Expect(0, 43395, '\P{^InSC= Consonant_SUCCEEDING_Repha}', "");
Error('\p{Is_Indic_Syllabic_Category=_/a/consonant_SUCCEEDING_Repha}');
Error('\P{Is_Indic_Syllabic_Category=_/a/consonant_SUCCEEDING_Repha}');
Expect(1, 43394, '\p{Is_Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(0, 43394, '\p{^Is_Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(0, 43394, '\P{Is_Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(1, 43394, '\P{^Is_Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(0, 43395, '\p{Is_Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(1, 43395, '\p{^Is_Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(1, 43395, '\P{Is_Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(0, 43395, '\P{^Is_Indic_Syllabic_Category=consonantsucceedingrepha}', "");
Expect(1, 43394, '\p{Is_Indic_Syllabic_Category=CONSONANT_Succeeding_REPHA}', "");
Expect(0, 43394, '\p{^Is_Indic_Syllabic_Category=CONSONANT_Succeeding_REPHA}', "");
Expect(0, 43394, '\P{Is_Indic_Syllabic_Category=CONSONANT_Succeeding_REPHA}', "");
Expect(1, 43394, '\P{^Is_Indic_Syllabic_Category=CONSONANT_Succeeding_REPHA}', "");
Expect(0, 43395, '\p{Is_Indic_Syllabic_Category=CONSONANT_Succeeding_REPHA}', "");
Expect(1, 43395, '\p{^Is_Indic_Syllabic_Category=CONSONANT_Succeeding_REPHA}', "");
Expect(1, 43395, '\P{Is_Indic_Syllabic_Category=CONSONANT_Succeeding_REPHA}', "");
Expect(0, 43395, '\P{^Is_Indic_Syllabic_Category=CONSONANT_Succeeding_REPHA}', "");
Error('\p{Is_InSC: /a/CONSONANT_succeeding_repha}');
Error('\P{Is_InSC: /a/CONSONANT_succeeding_repha}');
Expect(1, 43394, '\p{Is_InSC=consonantsucceedingrepha}', "");
Expect(0, 43394, '\p{^Is_InSC=consonantsucceedingrepha}', "");
Expect(0, 43394, '\P{Is_InSC=consonantsucceedingrepha}', "");
Expect(1, 43394, '\P{^Is_InSC=consonantsucceedingrepha}', "");
Expect(0, 43395, '\p{Is_InSC=consonantsucceedingrepha}', "");
Expect(1, 43395, '\p{^Is_InSC=consonantsucceedingrepha}', "");
Expect(1, 43395, '\P{Is_InSC=consonantsucceedingrepha}', "");
Expect(0, 43395, '\P{^Is_InSC=consonantsucceedingrepha}', "");
Expect(1, 43394, '\p{Is_InSC=_	consonant_SUCCEEDING_Repha}', "");
Expect(0, 43394, '\p{^Is_InSC=_	consonant_SUCCEEDING_Repha}', "");
Expect(0, 43394, '\P{Is_InSC=_	consonant_SUCCEEDING_Repha}', "");
Expect(1, 43394, '\P{^Is_InSC=_	consonant_SUCCEEDING_Repha}', "");
Expect(0, 43395, '\p{Is_InSC=_	consonant_SUCCEEDING_Repha}', "");
Expect(1, 43395, '\p{^Is_InSC=_	consonant_SUCCEEDING_Repha}', "");
Expect(1, 43395, '\P{Is_InSC=_	consonant_SUCCEEDING_Repha}', "");
Expect(0, 43395, '\P{^Is_InSC=_	consonant_SUCCEEDING_Repha}', "");
Error('\p{Indic_Syllabic_Category=__CONSONANT_With_Stacker/a/}');
Error('\P{Indic_Syllabic_Category=__CONSONANT_With_Stacker/a/}');
Expect(1, 69636, '\p{Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(0, 69636, '\p{^Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(0, 69636, '\P{Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(1, 69636, '\P{^Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(0, 69637, '\p{Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(1, 69637, '\p{^Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(1, 69637, '\P{Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(0, 69637, '\P{^Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(1, 69636, '\p{Indic_Syllabic_Category:  _Consonant_WITH_STACKER}', "");
Expect(0, 69636, '\p{^Indic_Syllabic_Category:  _Consonant_WITH_STACKER}', "");
Expect(0, 69636, '\P{Indic_Syllabic_Category:  _Consonant_WITH_STACKER}', "");
Expect(1, 69636, '\P{^Indic_Syllabic_Category:  _Consonant_WITH_STACKER}', "");
Expect(0, 69637, '\p{Indic_Syllabic_Category:  _Consonant_WITH_STACKER}', "");
Expect(1, 69637, '\p{^Indic_Syllabic_Category:  _Consonant_WITH_STACKER}', "");
Expect(1, 69637, '\P{Indic_Syllabic_Category:  _Consonant_WITH_STACKER}', "");
Expect(0, 69637, '\P{^Indic_Syllabic_Category:  _Consonant_WITH_STACKER}', "");
Error('\p{InSC=:=_Consonant_With_STACKER}');
Error('\P{InSC=:=_Consonant_With_STACKER}');
Expect(1, 69636, '\p{InSC=consonantwithstacker}', "");
Expect(0, 69636, '\p{^InSC=consonantwithstacker}', "");
Expect(0, 69636, '\P{InSC=consonantwithstacker}', "");
Expect(1, 69636, '\P{^InSC=consonantwithstacker}', "");
Expect(0, 69637, '\p{InSC=consonantwithstacker}', "");
Expect(1, 69637, '\p{^InSC=consonantwithstacker}', "");
Expect(1, 69637, '\P{InSC=consonantwithstacker}', "");
Expect(0, 69637, '\P{^InSC=consonantwithstacker}', "");
Expect(1, 69636, '\p{InSC=-consonant_WITH_Stacker}', "");
Expect(0, 69636, '\p{^InSC=-consonant_WITH_Stacker}', "");
Expect(0, 69636, '\P{InSC=-consonant_WITH_Stacker}', "");
Expect(1, 69636, '\P{^InSC=-consonant_WITH_Stacker}', "");
Expect(0, 69637, '\p{InSC=-consonant_WITH_Stacker}', "");
Expect(1, 69637, '\p{^InSC=-consonant_WITH_Stacker}', "");
Expect(1, 69637, '\P{InSC=-consonant_WITH_Stacker}', "");
Expect(0, 69637, '\P{^InSC=-consonant_WITH_Stacker}', "");
Error('\p{Is_Indic_Syllabic_Category:	/a/-	CONSONANT_With_STACKER}');
Error('\P{Is_Indic_Syllabic_Category:	/a/-	CONSONANT_With_STACKER}');
Expect(1, 69636, '\p{Is_Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(0, 69636, '\p{^Is_Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(0, 69636, '\P{Is_Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(1, 69636, '\P{^Is_Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(0, 69637, '\p{Is_Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(1, 69637, '\p{^Is_Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(1, 69637, '\P{Is_Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(0, 69637, '\P{^Is_Indic_Syllabic_Category=consonantwithstacker}', "");
Expect(1, 69636, '\p{Is_Indic_Syllabic_Category=_-Consonant_With_STACKER}', "");
Expect(0, 69636, '\p{^Is_Indic_Syllabic_Category=_-Consonant_With_STACKER}', "");
Expect(0, 69636, '\P{Is_Indic_Syllabic_Category=_-Consonant_With_STACKER}', "");
Expect(1, 69636, '\P{^Is_Indic_Syllabic_Category=_-Consonant_With_STACKER}', "");
Expect(0, 69637, '\p{Is_Indic_Syllabic_Category=_-Consonant_With_STACKER}', "");
Expect(1, 69637, '\p{^Is_Indic_Syllabic_Category=_-Consonant_With_STACKER}', "");
Expect(1, 69637, '\P{Is_Indic_Syllabic_Category=_-Consonant_With_STACKER}', "");
Expect(0, 69637, '\P{^Is_Indic_Syllabic_Category=_-Consonant_With_STACKER}', "");
Error('\p{Is_InSC=-/a/Consonant_With_STACKER}');
Error('\P{Is_InSC=-/a/Consonant_With_STACKER}');
Expect(1, 69636, '\p{Is_InSC=consonantwithstacker}', "");
Expect(0, 69636, '\p{^Is_InSC=consonantwithstacker}', "");
Expect(0, 69636, '\P{Is_InSC=consonantwithstacker}', "");
Expect(1, 69636, '\P{^Is_InSC=consonantwithstacker}', "");
Expect(0, 69637, '\p{Is_InSC=consonantwithstacker}', "");
Expect(1, 69637, '\p{^Is_InSC=consonantwithstacker}', "");
Expect(1, 69637, '\P{Is_InSC=consonantwithstacker}', "");
Expect(0, 69637, '\P{^Is_InSC=consonantwithstacker}', "");
Expect(1, 69636, '\p{Is_InSC=-_consonant_with_STACKER}', "");
Expect(0, 69636, '\p{^Is_InSC=-_consonant_with_STACKER}', "");
Expect(0, 69636, '\P{Is_InSC=-_consonant_with_STACKER}', "");
Expect(1, 69636, '\P{^Is_InSC=-_consonant_with_STACKER}', "");
Expect(0, 69637, '\p{Is_InSC=-_consonant_with_STACKER}', "");
Expect(1, 69637, '\p{^Is_InSC=-_consonant_with_STACKER}', "");
Expect(1, 69637, '\P{Is_InSC=-_consonant_with_STACKER}', "");
Expect(0, 69637, '\P{^Is_InSC=-_consonant_with_STACKER}', "");
Error('\p{Indic_Syllabic_Category=	:=Gemination_MARK}');
Error('\P{Indic_Syllabic_Category=	:=Gemination_MARK}');
Expect(1, 70199, '\p{Indic_Syllabic_Category=geminationmark}', "");
Expect(0, 70199, '\p{^Indic_Syllabic_Category=geminationmark}', "");
Expect(0, 70199, '\P{Indic_Syllabic_Category=geminationmark}', "");
Expect(1, 70199, '\P{^Indic_Syllabic_Category=geminationmark}', "");
Expect(0, 70200, '\p{Indic_Syllabic_Category=geminationmark}', "");
Expect(1, 70200, '\p{^Indic_Syllabic_Category=geminationmark}', "");
Expect(1, 70200, '\P{Indic_Syllabic_Category=geminationmark}', "");
Expect(0, 70200, '\P{^Indic_Syllabic_Category=geminationmark}', "");
Expect(1, 70199, '\p{Indic_Syllabic_Category=_	Gemination_MARK}', "");
Expect(0, 70199, '\p{^Indic_Syllabic_Category=_	Gemination_MARK}', "");
Expect(0, 70199, '\P{Indic_Syllabic_Category=_	Gemination_MARK}', "");
Expect(1, 70199, '\P{^Indic_Syllabic_Category=_	Gemination_MARK}', "");
Expect(0, 70200, '\p{Indic_Syllabic_Category=_	Gemination_MARK}', "");
Expect(1, 70200, '\p{^Indic_Syllabic_Category=_	Gemination_MARK}', "");
Expect(1, 70200, '\P{Indic_Syllabic_Category=_	Gemination_MARK}', "");
Expect(0, 70200, '\P{^Indic_Syllabic_Category=_	Gemination_MARK}', "");
Error('\p{InSC=/a/Gemination_Mark}');
Error('\P{InSC=/a/Gemination_Mark}');
Expect(1, 70199, '\p{InSC=geminationmark}', "");
Expect(0, 70199, '\p{^InSC=geminationmark}', "");
Expect(0, 70199, '\P{InSC=geminationmark}', "");
Expect(1, 70199, '\P{^InSC=geminationmark}', "");
Expect(0, 70200, '\p{InSC=geminationmark}', "");
Expect(1, 70200, '\p{^InSC=geminationmark}', "");
Expect(1, 70200, '\P{InSC=geminationmark}', "");
Expect(0, 70200, '\P{^InSC=geminationmark}', "");
Expect(1, 70199, '\p{InSC:   Gemination_MARK}', "");
Expect(0, 70199, '\p{^InSC:   Gemination_MARK}', "");
Expect(0, 70199, '\P{InSC:   Gemination_MARK}', "");
Expect(1, 70199, '\P{^InSC:   Gemination_MARK}', "");
Expect(0, 70200, '\p{InSC:   Gemination_MARK}', "");
Expect(1, 70200, '\p{^InSC:   Gemination_MARK}', "");
Expect(1, 70200, '\P{InSC:   Gemination_MARK}', "");
Expect(0, 70200, '\P{^InSC:   Gemination_MARK}', "");
Error('\p{Is_Indic_Syllabic_Category=:=GEMINATION_mark}');
Error('\P{Is_Indic_Syllabic_Category=:=GEMINATION_mark}');
Expect(1, 70199, '\p{Is_Indic_Syllabic_Category=geminationmark}', "");
Expect(0, 70199, '\p{^Is_Indic_Syllabic_Category=geminationmark}', "");
Expect(0, 70199, '\P{Is_Indic_Syllabic_Category=geminationmark}', "");
Expect(1, 70199, '\P{^Is_Indic_Syllabic_Category=geminationmark}', "");
Expect(0, 70200, '\p{Is_Indic_Syllabic_Category=geminationmark}', "");
Expect(1, 70200, '\p{^Is_Indic_Syllabic_Category=geminationmark}', "");
Expect(1, 70200, '\P{Is_Indic_Syllabic_Category=geminationmark}', "");
Expect(0, 70200, '\P{^Is_Indic_Syllabic_Category=geminationmark}', "");
Expect(1, 70199, '\p{Is_Indic_Syllabic_Category=__GEMINATION_Mark}', "");
Expect(0, 70199, '\p{^Is_Indic_Syllabic_Category=__GEMINATION_Mark}', "");
Expect(0, 70199, '\P{Is_Indic_Syllabic_Category=__GEMINATION_Mark}', "");
Expect(1, 70199, '\P{^Is_Indic_Syllabic_Category=__GEMINATION_Mark}', "");
Expect(0, 70200, '\p{Is_Indic_Syllabic_Category=__GEMINATION_Mark}', "");
Expect(1, 70200, '\p{^Is_Indic_Syllabic_Category=__GEMINATION_Mark}', "");
Expect(1, 70200, '\P{Is_Indic_Syllabic_Category=__GEMINATION_Mark}', "");
Expect(0, 70200, '\P{^Is_Indic_Syllabic_Category=__GEMINATION_Mark}', "");
Error('\p{Is_InSC=:=Gemination_Mark}');
Error('\P{Is_InSC=:=Gemination_Mark}');
Expect(1, 70199, '\p{Is_InSC=geminationmark}', "");
Expect(0, 70199, '\p{^Is_InSC=geminationmark}', "");
Expect(0, 70199, '\P{Is_InSC=geminationmark}', "");
Expect(1, 70199, '\P{^Is_InSC=geminationmark}', "");
Expect(0, 70200, '\p{Is_InSC=geminationmark}', "");
Expect(1, 70200, '\p{^Is_InSC=geminationmark}', "");
Expect(1, 70200, '\P{Is_InSC=geminationmark}', "");
Expect(0, 70200, '\P{^Is_InSC=geminationmark}', "");
Expect(1, 70199, '\p{Is_InSC=__gemination_Mark}', "");
Expect(0, 70199, '\p{^Is_InSC=__gemination_Mark}', "");
Expect(0, 70199, '\P{Is_InSC=__gemination_Mark}', "");
Expect(1, 70199, '\P{^Is_InSC=__gemination_Mark}', "");
Expect(0, 70200, '\p{Is_InSC=__gemination_Mark}', "");
Expect(1, 70200, '\p{^Is_InSC=__gemination_Mark}', "");
Expect(1, 70200, '\P{Is_InSC=__gemination_Mark}', "");
Expect(0, 70200, '\P{^Is_InSC=__gemination_Mark}', "");
Error('\p{Indic_Syllabic_Category:	 	Invisible_STACKER:=}');
Error('\P{Indic_Syllabic_Category:	 	Invisible_STACKER:=}');
Expect(1, 69939, '\p{Indic_Syllabic_Category=invisiblestacker}', "");
Expect(0, 69939, '\p{^Indic_Syllabic_Category=invisiblestacker}', "");
Expect(0, 69939, '\P{Indic_Syllabic_Category=invisiblestacker}', "");
Expect(1, 69939, '\P{^Indic_Syllabic_Category=invisiblestacker}', "");
Expect(0, 69940, '\p{Indic_Syllabic_Category=invisiblestacker}', "");
Expect(1, 69940, '\p{^Indic_Syllabic_Category=invisiblestacker}', "");
Expect(1, 69940, '\P{Indic_Syllabic_Category=invisiblestacker}', "");
Expect(0, 69940, '\P{^Indic_Syllabic_Category=invisiblestacker}', "");
Expect(1, 69939, '\p{Indic_Syllabic_Category=--Invisible_stacker}', "");
Expect(0, 69939, '\p{^Indic_Syllabic_Category=--Invisible_stacker}', "");
Expect(0, 69939, '\P{Indic_Syllabic_Category=--Invisible_stacker}', "");
Expect(1, 69939, '\P{^Indic_Syllabic_Category=--Invisible_stacker}', "");
Expect(0, 69940, '\p{Indic_Syllabic_Category=--Invisible_stacker}', "");
Expect(1, 69940, '\p{^Indic_Syllabic_Category=--Invisible_stacker}', "");
Expect(1, 69940, '\P{Indic_Syllabic_Category=--Invisible_stacker}', "");
Expect(0, 69940, '\P{^Indic_Syllabic_Category=--Invisible_stacker}', "");
Error('\p{InSC= -Invisible_Stacker/a/}');
Error('\P{InSC= -Invisible_Stacker/a/}');
Expect(1, 69939, '\p{InSC: invisiblestacker}', "");
Expect(0, 69939, '\p{^InSC: invisiblestacker}', "");
Expect(0, 69939, '\P{InSC: invisiblestacker}', "");
Expect(1, 69939, '\P{^InSC: invisiblestacker}', "");
Expect(0, 69940, '\p{InSC: invisiblestacker}', "");
Expect(1, 69940, '\p{^InSC: invisiblestacker}', "");
Expect(1, 69940, '\P{InSC: invisiblestacker}', "");
Expect(0, 69940, '\P{^InSC: invisiblestacker}', "");
Expect(1, 69939, '\p{InSC=	-Invisible_stacker}', "");
Expect(0, 69939, '\p{^InSC=	-Invisible_stacker}', "");
Expect(0, 69939, '\P{InSC=	-Invisible_stacker}', "");
Expect(1, 69939, '\P{^InSC=	-Invisible_stacker}', "");
Expect(0, 69940, '\p{InSC=	-Invisible_stacker}', "");
Expect(1, 69940, '\p{^InSC=	-Invisible_stacker}', "");
Expect(1, 69940, '\P{InSC=	-Invisible_stacker}', "");
Expect(0, 69940, '\P{^InSC=	-Invisible_stacker}', "");
Error('\p{Is_Indic_Syllabic_Category=/a/_ INVISIBLE_Stacker}');
Error('\P{Is_Indic_Syllabic_Category=/a/_ INVISIBLE_Stacker}');
Expect(1, 69939, '\p{Is_Indic_Syllabic_Category=invisiblestacker}', "");
Expect(0, 69939, '\p{^Is_Indic_Syllabic_Category=invisiblestacker}', "");
Expect(0, 69939, '\P{Is_Indic_Syllabic_Category=invisiblestacker}', "");
Expect(1, 69939, '\P{^Is_Indic_Syllabic_Category=invisiblestacker}', "");
Expect(0, 69940, '\p{Is_Indic_Syllabic_Category=invisiblestacker}', "");
Expect(1, 69940, '\p{^Is_Indic_Syllabic_Category=invisiblestacker}', "");
Expect(1, 69940, '\P{Is_Indic_Syllabic_Category=invisiblestacker}', "");
Expect(0, 69940, '\P{^Is_Indic_Syllabic_Category=invisiblestacker}', "");
Expect(1, 69939, '\p{Is_Indic_Syllabic_Category=  Invisible_Stacker}', "");
Expect(0, 69939, '\p{^Is_Indic_Syllabic_Category=  Invisible_Stacker}', "");
Expect(0, 69939, '\P{Is_Indic_Syllabic_Category=  Invisible_Stacker}', "");
Expect(1, 69939, '\P{^Is_Indic_Syllabic_Category=  Invisible_Stacker}', "");
Expect(0, 69940, '\p{Is_Indic_Syllabic_Category=  Invisible_Stacker}', "");
Expect(1, 69940, '\p{^Is_Indic_Syllabic_Category=  Invisible_Stacker}', "");
Expect(1, 69940, '\P{Is_Indic_Syllabic_Category=  Invisible_Stacker}', "");
Expect(0, 69940, '\P{^Is_Indic_Syllabic_Category=  Invisible_Stacker}', "");
Error('\p{Is_InSC=:=- invisible_STACKER}');
Error('\P{Is_InSC=:=- invisible_STACKER}');
Expect(1, 69939, '\p{Is_InSC: invisiblestacker}', "");
Expect(0, 69939, '\p{^Is_InSC: invisiblestacker}', "");
Expect(0, 69939, '\P{Is_InSC: invisiblestacker}', "");
Expect(1, 69939, '\P{^Is_InSC: invisiblestacker}', "");
Expect(0, 69940, '\p{Is_InSC: invisiblestacker}', "");
Expect(1, 69940, '\p{^Is_InSC: invisiblestacker}', "");
Expect(1, 69940, '\P{Is_InSC: invisiblestacker}', "");
Expect(0, 69940, '\P{^Is_InSC: invisiblestacker}', "");
Expect(1, 69939, '\p{Is_InSC=_ Invisible_STACKER}', "");
Expect(0, 69939, '\p{^Is_InSC=_ Invisible_STACKER}', "");
Expect(0, 69939, '\P{Is_InSC=_ Invisible_STACKER}', "");
Expect(1, 69939, '\P{^Is_InSC=_ Invisible_STACKER}', "");
Expect(0, 69940, '\p{Is_InSC=_ Invisible_STACKER}', "");
Expect(1, 69940, '\p{^Is_InSC=_ Invisible_STACKER}', "");
Expect(1, 69940, '\P{Is_InSC=_ Invisible_STACKER}', "");
Expect(0, 69940, '\P{^Is_InSC=_ Invisible_STACKER}', "");
Error('\p{Indic_Syllabic_Category=_JOINER:=}');
Error('\P{Indic_Syllabic_Category=_JOINER:=}');
Expect(1, 8205, '\p{Indic_Syllabic_Category=joiner}', "");
Expect(0, 8205, '\p{^Indic_Syllabic_Category=joiner}', "");
Expect(0, 8205, '\P{Indic_Syllabic_Category=joiner}', "");
Expect(1, 8205, '\P{^Indic_Syllabic_Category=joiner}', "");
Expect(0, 8206, '\p{Indic_Syllabic_Category=joiner}', "");
Expect(1, 8206, '\p{^Indic_Syllabic_Category=joiner}', "");
Expect(1, 8206, '\P{Indic_Syllabic_Category=joiner}', "");
Expect(0, 8206, '\P{^Indic_Syllabic_Category=joiner}', "");
Expect(1, 8205, '\p{Indic_Syllabic_Category=- Joiner}', "");
Expect(0, 8205, '\p{^Indic_Syllabic_Category=- Joiner}', "");
Expect(0, 8205, '\P{Indic_Syllabic_Category=- Joiner}', "");
Expect(1, 8205, '\P{^Indic_Syllabic_Category=- Joiner}', "");
Expect(0, 8206, '\p{Indic_Syllabic_Category=- Joiner}', "");
Expect(1, 8206, '\p{^Indic_Syllabic_Category=- Joiner}', "");
Expect(1, 8206, '\P{Indic_Syllabic_Category=- Joiner}', "");
Expect(0, 8206, '\P{^Indic_Syllabic_Category=- Joiner}', "");
Error('\p{InSC=:=	 joiner}');
Error('\P{InSC=:=	 joiner}');
Expect(1, 8205, '\p{InSC=joiner}', "");
Expect(0, 8205, '\p{^InSC=joiner}', "");
Expect(0, 8205, '\P{InSC=joiner}', "");
Expect(1, 8205, '\P{^InSC=joiner}', "");
Expect(0, 8206, '\p{InSC=joiner}', "");
Expect(1, 8206, '\p{^InSC=joiner}', "");
Expect(1, 8206, '\P{InSC=joiner}', "");
Expect(0, 8206, '\P{^InSC=joiner}', "");
Expect(1, 8205, '\p{InSC=	Joiner}', "");
Expect(0, 8205, '\p{^InSC=	Joiner}', "");
Expect(0, 8205, '\P{InSC=	Joiner}', "");
Expect(1, 8205, '\P{^InSC=	Joiner}', "");
Expect(0, 8206, '\p{InSC=	Joiner}', "");
Expect(1, 8206, '\p{^InSC=	Joiner}', "");
Expect(1, 8206, '\P{InSC=	Joiner}', "");
Expect(0, 8206, '\P{^InSC=	Joiner}', "");
Error('\p{Is_Indic_Syllabic_Category=	-Joiner/a/}');
Error('\P{Is_Indic_Syllabic_Category=	-Joiner/a/}');
Expect(1, 8205, '\p{Is_Indic_Syllabic_Category=joiner}', "");
Expect(0, 8205, '\p{^Is_Indic_Syllabic_Category=joiner}', "");
Expect(0, 8205, '\P{Is_Indic_Syllabic_Category=joiner}', "");
Expect(1, 8205, '\P{^Is_Indic_Syllabic_Category=joiner}', "");
Expect(0, 8206, '\p{Is_Indic_Syllabic_Category=joiner}', "");
Expect(1, 8206, '\p{^Is_Indic_Syllabic_Category=joiner}', "");
Expect(1, 8206, '\P{Is_Indic_Syllabic_Category=joiner}', "");
Expect(0, 8206, '\P{^Is_Indic_Syllabic_Category=joiner}', "");
Expect(1, 8205, '\p{Is_Indic_Syllabic_Category=-	Joiner}', "");
Expect(0, 8205, '\p{^Is_Indic_Syllabic_Category=-	Joiner}', "");
Expect(0, 8205, '\P{Is_Indic_Syllabic_Category=-	Joiner}', "");
Expect(1, 8205, '\P{^Is_Indic_Syllabic_Category=-	Joiner}', "");
Expect(0, 8206, '\p{Is_Indic_Syllabic_Category=-	Joiner}', "");
Expect(1, 8206, '\p{^Is_Indic_Syllabic_Category=-	Joiner}', "");
Expect(1, 8206, '\P{Is_Indic_Syllabic_Category=-	Joiner}', "");
Expect(0, 8206, '\P{^Is_Indic_Syllabic_Category=-	Joiner}', "");
Error('\p{Is_InSC=	/a/joiner}');
Error('\P{Is_InSC=	/a/joiner}');
Expect(1, 8205, '\p{Is_InSC=joiner}', "");
Expect(0, 8205, '\p{^Is_InSC=joiner}', "");
Expect(0, 8205, '\P{Is_InSC=joiner}', "");
Expect(1, 8205, '\P{^Is_InSC=joiner}', "");
Expect(0, 8206, '\p{Is_InSC=joiner}', "");
Expect(1, 8206, '\p{^Is_InSC=joiner}', "");
Expect(1, 8206, '\P{Is_InSC=joiner}', "");
Expect(0, 8206, '\P{^Is_InSC=joiner}', "");
Expect(1, 8205, '\p{Is_InSC=- Joiner}', "");
Expect(0, 8205, '\p{^Is_InSC=- Joiner}', "");
Expect(0, 8205, '\P{Is_InSC=- Joiner}', "");
Expect(1, 8205, '\P{^Is_InSC=- Joiner}', "");
Expect(0, 8206, '\p{Is_InSC=- Joiner}', "");
Expect(1, 8206, '\p{^Is_InSC=- Joiner}', "");
Expect(1, 8206, '\P{Is_InSC=- Joiner}', "");
Expect(0, 8206, '\P{^Is_InSC=- Joiner}', "");
Error('\p{Indic_Syllabic_Category=/a/__Modifying_Letter}');
Error('\P{Indic_Syllabic_Category=/a/__Modifying_Letter}');
Expect(1, 2947, '\p{Indic_Syllabic_Category=modifyingletter}', "");
Expect(0, 2947, '\p{^Indic_Syllabic_Category=modifyingletter}', "");
Expect(0, 2947, '\P{Indic_Syllabic_Category=modifyingletter}', "");
Expect(1, 2947, '\P{^Indic_Syllabic_Category=modifyingletter}', "");
Expect(0, 2948, '\p{Indic_Syllabic_Category=modifyingletter}', "");
Expect(1, 2948, '\p{^Indic_Syllabic_Category=modifyingletter}', "");
Expect(1, 2948, '\P{Indic_Syllabic_Category=modifyingletter}', "");
Expect(0, 2948, '\P{^Indic_Syllabic_Category=modifyingletter}', "");
Expect(1, 2947, '\p{Indic_Syllabic_Category=_modifying_Letter}', "");
Expect(0, 2947, '\p{^Indic_Syllabic_Category=_modifying_Letter}', "");
Expect(0, 2947, '\P{Indic_Syllabic_Category=_modifying_Letter}', "");
Expect(1, 2947, '\P{^Indic_Syllabic_Category=_modifying_Letter}', "");
Expect(0, 2948, '\p{Indic_Syllabic_Category=_modifying_Letter}', "");
Expect(1, 2948, '\p{^Indic_Syllabic_Category=_modifying_Letter}', "");
Expect(1, 2948, '\P{Indic_Syllabic_Category=_modifying_Letter}', "");
Expect(0, 2948, '\P{^Indic_Syllabic_Category=_modifying_Letter}', "");
Error('\p{InSC:   := _Modifying_letter}');
Error('\P{InSC:   := _Modifying_letter}');
Expect(1, 2947, '\p{InSC=modifyingletter}', "");
Expect(0, 2947, '\p{^InSC=modifyingletter}', "");
Expect(0, 2947, '\P{InSC=modifyingletter}', "");
Expect(1, 2947, '\P{^InSC=modifyingletter}', "");
Expect(0, 2948, '\p{InSC=modifyingletter}', "");
Expect(1, 2948, '\p{^InSC=modifyingletter}', "");
Expect(1, 2948, '\P{InSC=modifyingletter}', "");
Expect(0, 2948, '\P{^InSC=modifyingletter}', "");
Expect(1, 2947, '\p{InSC=	Modifying_Letter}', "");
Expect(0, 2947, '\p{^InSC=	Modifying_Letter}', "");
Expect(0, 2947, '\P{InSC=	Modifying_Letter}', "");
Expect(1, 2947, '\P{^InSC=	Modifying_Letter}', "");
Expect(0, 2948, '\p{InSC=	Modifying_Letter}', "");
Expect(1, 2948, '\p{^InSC=	Modifying_Letter}', "");
Expect(1, 2948, '\P{InSC=	Modifying_Letter}', "");
Expect(0, 2948, '\P{^InSC=	Modifying_Letter}', "");
Error('\p{Is_Indic_Syllabic_Category=-/a/MODIFYING_Letter}');
Error('\P{Is_Indic_Syllabic_Category=-/a/MODIFYING_Letter}');
Expect(1, 2947, '\p{Is_Indic_Syllabic_Category=modifyingletter}', "");
Expect(0, 2947, '\p{^Is_Indic_Syllabic_Category=modifyingletter}', "");
Expect(0, 2947, '\P{Is_Indic_Syllabic_Category=modifyingletter}', "");
Expect(1, 2947, '\P{^Is_Indic_Syllabic_Category=modifyingletter}', "");
Expect(0, 2948, '\p{Is_Indic_Syllabic_Category=modifyingletter}', "");
Expect(1, 2948, '\p{^Is_Indic_Syllabic_Category=modifyingletter}', "");
Expect(1, 2948, '\P{Is_Indic_Syllabic_Category=modifyingletter}', "");
Expect(0, 2948, '\P{^Is_Indic_Syllabic_Category=modifyingletter}', "");
Expect(1, 2947, '\p{Is_Indic_Syllabic_Category=--Modifying_Letter}', "");
Expect(0, 2947, '\p{^Is_Indic_Syllabic_Category=--Modifying_Letter}', "");
Expect(0, 2947, '\P{Is_Indic_Syllabic_Category=--Modifying_Letter}', "");
Expect(1, 2947, '\P{^Is_Indic_Syllabic_Category=--Modifying_Letter}', "");
Expect(0, 2948, '\p{Is_Indic_Syllabic_Category=--Modifying_Letter}', "");
Expect(1, 2948, '\p{^Is_Indic_Syllabic_Category=--Modifying_Letter}', "");
Expect(1, 2948, '\P{Is_Indic_Syllabic_Category=--Modifying_Letter}', "");
Expect(0, 2948, '\P{^Is_Indic_Syllabic_Category=--Modifying_Letter}', "");
Error('\p{Is_InSC=--modifying_Letter:=}');
Error('\P{Is_InSC=--modifying_Letter:=}');
Expect(1, 2947, '\p{Is_InSC=modifyingletter}', "");
Expect(0, 2947, '\p{^Is_InSC=modifyingletter}', "");
Expect(0, 2947, '\P{Is_InSC=modifyingletter}', "");
Expect(1, 2947, '\P{^Is_InSC=modifyingletter}', "");
Expect(0, 2948, '\p{Is_InSC=modifyingletter}', "");
Expect(1, 2948, '\p{^Is_InSC=modifyingletter}', "");
Expect(1, 2948, '\P{Is_InSC=modifyingletter}', "");
Expect(0, 2948, '\P{^Is_InSC=modifyingletter}', "");
Expect(1, 2947, '\p{Is_InSC=	modifying_letter}', "");
Expect(0, 2947, '\p{^Is_InSC=	modifying_letter}', "");
Expect(0, 2947, '\P{Is_InSC=	modifying_letter}', "");
Expect(1, 2947, '\P{^Is_InSC=	modifying_letter}', "");
Expect(0, 2948, '\p{Is_InSC=	modifying_letter}', "");
Expect(1, 2948, '\p{^Is_InSC=	modifying_letter}', "");
Expect(1, 2948, '\P{Is_InSC=	modifying_letter}', "");
Expect(0, 2948, '\P{^Is_InSC=	modifying_letter}', "");
Error('\p{Indic_Syllabic_Category=/a/ _NON_Joiner}');
Error('\P{Indic_Syllabic_Category=/a/ _NON_Joiner}');
Expect(1, 8204, '\p{Indic_Syllabic_Category:   nonjoiner}', "");
Expect(0, 8204, '\p{^Indic_Syllabic_Category:   nonjoiner}', "");
Expect(0, 8204, '\P{Indic_Syllabic_Category:   nonjoiner}', "");
Expect(1, 8204, '\P{^Indic_Syllabic_Category:   nonjoiner}', "");
Expect(0, 8205, '\p{Indic_Syllabic_Category:   nonjoiner}', "");
Expect(1, 8205, '\p{^Indic_Syllabic_Category:   nonjoiner}', "");
Expect(1, 8205, '\P{Indic_Syllabic_Category:   nonjoiner}', "");
Expect(0, 8205, '\P{^Indic_Syllabic_Category:   nonjoiner}', "");
Expect(1, 8204, '\p{Indic_Syllabic_Category=_Non_JOINER}', "");
Expect(0, 8204, '\p{^Indic_Syllabic_Category=_Non_JOINER}', "");
Expect(0, 8204, '\P{Indic_Syllabic_Category=_Non_JOINER}', "");
Expect(1, 8204, '\P{^Indic_Syllabic_Category=_Non_JOINER}', "");
Expect(0, 8205, '\p{Indic_Syllabic_Category=_Non_JOINER}', "");
Expect(1, 8205, '\p{^Indic_Syllabic_Category=_Non_JOINER}', "");
Expect(1, 8205, '\P{Indic_Syllabic_Category=_Non_JOINER}', "");
Expect(0, 8205, '\P{^Indic_Syllabic_Category=_Non_JOINER}', "");
Error('\p{InSC=	NON_Joiner/a/}');
Error('\P{InSC=	NON_Joiner/a/}');
Expect(1, 8204, '\p{InSC=nonjoiner}', "");
Expect(0, 8204, '\p{^InSC=nonjoiner}', "");
Expect(0, 8204, '\P{InSC=nonjoiner}', "");
Expect(1, 8204, '\P{^InSC=nonjoiner}', "");
Expect(0, 8205, '\p{InSC=nonjoiner}', "");
Expect(1, 8205, '\p{^InSC=nonjoiner}', "");
Expect(1, 8205, '\P{InSC=nonjoiner}', "");
Expect(0, 8205, '\P{^InSC=nonjoiner}', "");
Expect(1, 8204, '\p{InSC= 	non_joiner}', "");
Expect(0, 8204, '\p{^InSC= 	non_joiner}', "");
Expect(0, 8204, '\P{InSC= 	non_joiner}', "");
Expect(1, 8204, '\P{^InSC= 	non_joiner}', "");
Expect(0, 8205, '\p{InSC= 	non_joiner}', "");
Expect(1, 8205, '\p{^InSC= 	non_joiner}', "");
Expect(1, 8205, '\P{InSC= 	non_joiner}', "");
Expect(0, 8205, '\P{^InSC= 	non_joiner}', "");
Error('\p{Is_Indic_Syllabic_Category=/a/	-Non_Joiner}');
Error('\P{Is_Indic_Syllabic_Category=/a/	-Non_Joiner}');
Expect(1, 8204, '\p{Is_Indic_Syllabic_Category=nonjoiner}', "");
Expect(0, 8204, '\p{^Is_Indic_Syllabic_Category=nonjoiner}', "");
Expect(0, 8204, '\P{Is_Indic_Syllabic_Category=nonjoiner}', "");
Expect(1, 8204, '\P{^Is_Indic_Syllabic_Category=nonjoiner}', "");
Expect(0, 8205, '\p{Is_Indic_Syllabic_Category=nonjoiner}', "");
Expect(1, 8205, '\p{^Is_Indic_Syllabic_Category=nonjoiner}', "");
Expect(1, 8205, '\P{Is_Indic_Syllabic_Category=nonjoiner}', "");
Expect(0, 8205, '\P{^Is_Indic_Syllabic_Category=nonjoiner}', "");
Expect(1, 8204, '\p{Is_Indic_Syllabic_Category=_ Non_Joiner}', "");
Expect(0, 8204, '\p{^Is_Indic_Syllabic_Category=_ Non_Joiner}', "");
Expect(0, 8204, '\P{Is_Indic_Syllabic_Category=_ Non_Joiner}', "");
Expect(1, 8204, '\P{^Is_Indic_Syllabic_Category=_ Non_Joiner}', "");
Expect(0, 8205, '\p{Is_Indic_Syllabic_Category=_ Non_Joiner}', "");
Expect(1, 8205, '\p{^Is_Indic_Syllabic_Category=_ Non_Joiner}', "");
Expect(1, 8205, '\P{Is_Indic_Syllabic_Category=_ Non_Joiner}', "");
Expect(0, 8205, '\P{^Is_Indic_Syllabic_Category=_ Non_Joiner}', "");
Error('\p{Is_InSC=:=	Non_joiner}');
Error('\P{Is_InSC=:=	Non_joiner}');
Expect(1, 8204, '\p{Is_InSC=nonjoiner}', "");
Expect(0, 8204, '\p{^Is_InSC=nonjoiner}', "");
Expect(0, 8204, '\P{Is_InSC=nonjoiner}', "");
Expect(1, 8204, '\P{^Is_InSC=nonjoiner}', "");
Expect(0, 8205, '\p{Is_InSC=nonjoiner}', "");
Expect(1, 8205, '\p{^Is_InSC=nonjoiner}', "");
Expect(1, 8205, '\P{Is_InSC=nonjoiner}', "");
Expect(0, 8205, '\P{^Is_InSC=nonjoiner}', "");
Expect(1, 8204, '\p{Is_InSC= 	Non_JOINER}', "");
Expect(0, 8204, '\p{^Is_InSC= 	Non_JOINER}', "");
Expect(0, 8204, '\P{Is_InSC= 	Non_JOINER}', "");
Expect(1, 8204, '\P{^Is_InSC= 	Non_JOINER}', "");
Expect(0, 8205, '\p{Is_InSC= 	Non_JOINER}', "");
Expect(1, 8205, '\p{^Is_InSC= 	Non_JOINER}', "");
Expect(1, 8205, '\P{Is_InSC= 	Non_JOINER}', "");
Expect(0, 8205, '\P{^Is_InSC= 	Non_JOINER}', "");
Error('\p{Indic_Syllabic_Category=	_nukta/a/}');
Error('\P{Indic_Syllabic_Category=	_nukta/a/}');
Expect(1, 71351, '\p{Indic_Syllabic_Category=nukta}', "");
Expect(0, 71351, '\p{^Indic_Syllabic_Category=nukta}', "");
Expect(0, 71351, '\P{Indic_Syllabic_Category=nukta}', "");
Expect(1, 71351, '\P{^Indic_Syllabic_Category=nukta}', "");
Expect(0, 71352, '\p{Indic_Syllabic_Category=nukta}', "");
Expect(1, 71352, '\p{^Indic_Syllabic_Category=nukta}', "");
Expect(1, 71352, '\P{Indic_Syllabic_Category=nukta}', "");
Expect(0, 71352, '\P{^Indic_Syllabic_Category=nukta}', "");
Expect(1, 71351, '\p{Indic_Syllabic_Category:   Nukta}', "");
Expect(0, 71351, '\p{^Indic_Syllabic_Category:   Nukta}', "");
Expect(0, 71351, '\P{Indic_Syllabic_Category:   Nukta}', "");
Expect(1, 71351, '\P{^Indic_Syllabic_Category:   Nukta}', "");
Expect(0, 71352, '\p{Indic_Syllabic_Category:   Nukta}', "");
Expect(1, 71352, '\p{^Indic_Syllabic_Category:   Nukta}', "");
Expect(1, 71352, '\P{Indic_Syllabic_Category:   Nukta}', "");
Expect(0, 71352, '\P{^Indic_Syllabic_Category:   Nukta}', "");
Error('\p{InSC=:=-_nukta}');
Error('\P{InSC=:=-_nukta}');
Expect(1, 71351, '\p{InSC=nukta}', "");
Expect(0, 71351, '\p{^InSC=nukta}', "");
Expect(0, 71351, '\P{InSC=nukta}', "");
Expect(1, 71351, '\P{^InSC=nukta}', "");
Expect(0, 71352, '\p{InSC=nukta}', "");
Expect(1, 71352, '\p{^InSC=nukta}', "");
Expect(1, 71352, '\P{InSC=nukta}', "");
Expect(0, 71352, '\P{^InSC=nukta}', "");
Expect(1, 71351, '\p{InSC=-NUKTA}', "");
Expect(0, 71351, '\p{^InSC=-NUKTA}', "");
Expect(0, 71351, '\P{InSC=-NUKTA}', "");
Expect(1, 71351, '\P{^InSC=-NUKTA}', "");
Expect(0, 71352, '\p{InSC=-NUKTA}', "");
Expect(1, 71352, '\p{^InSC=-NUKTA}', "");
Expect(1, 71352, '\P{InSC=-NUKTA}', "");
Expect(0, 71352, '\P{^InSC=-NUKTA}', "");
Error('\p{Is_Indic_Syllabic_Category=:=-Nukta}');
Error('\P{Is_Indic_Syllabic_Category=:=-Nukta}');
Expect(1, 71351, '\p{Is_Indic_Syllabic_Category=nukta}', "");
Expect(0, 71351, '\p{^Is_Indic_Syllabic_Category=nukta}', "");
Expect(0, 71351, '\P{Is_Indic_Syllabic_Category=nukta}', "");
Expect(1, 71351, '\P{^Is_Indic_Syllabic_Category=nukta}', "");
Expect(0, 71352, '\p{Is_Indic_Syllabic_Category=nukta}', "");
Expect(1, 71352, '\p{^Is_Indic_Syllabic_Category=nukta}', "");
Expect(1, 71352, '\P{Is_Indic_Syllabic_Category=nukta}', "");
Expect(0, 71352, '\P{^Is_Indic_Syllabic_Category=nukta}', "");
Expect(1, 71351, '\p{Is_Indic_Syllabic_Category=- NUKTA}', "");
Expect(0, 71351, '\p{^Is_Indic_Syllabic_Category=- NUKTA}', "");
Expect(0, 71351, '\P{Is_Indic_Syllabic_Category=- NUKTA}', "");
Expect(1, 71351, '\P{^Is_Indic_Syllabic_Category=- NUKTA}', "");
Expect(0, 71352, '\p{Is_Indic_Syllabic_Category=- NUKTA}', "");
Expect(1, 71352, '\p{^Is_Indic_Syllabic_Category=- NUKTA}', "");
Expect(1, 71352, '\P{Is_Indic_Syllabic_Category=- NUKTA}', "");
Expect(0, 71352, '\P{^Is_Indic_Syllabic_Category=- NUKTA}', "");
Error('\p{Is_InSC=		Nukta:=}');
Error('\P{Is_InSC=		Nukta:=}');
Expect(1, 71351, '\p{Is_InSC=nukta}', "");
Expect(0, 71351, '\p{^Is_InSC=nukta}', "");
Expect(0, 71351, '\P{Is_InSC=nukta}', "");
Expect(1, 71351, '\P{^Is_InSC=nukta}', "");
Expect(0, 71352, '\p{Is_InSC=nukta}', "");
Expect(1, 71352, '\p{^Is_InSC=nukta}', "");
Expect(1, 71352, '\P{Is_InSC=nukta}', "");
Expect(0, 71352, '\P{^Is_InSC=nukta}', "");
Expect(1, 71351, '\p{Is_InSC=	-NUKTA}', "");
Expect(0, 71351, '\p{^Is_InSC=	-NUKTA}', "");
Expect(0, 71351, '\P{Is_InSC=	-NUKTA}', "");
Expect(1, 71351, '\P{^Is_InSC=	-NUKTA}', "");
Expect(0, 71352, '\p{Is_InSC=	-NUKTA}', "");
Expect(1, 71352, '\p{^Is_InSC=	-NUKTA}', "");
Expect(1, 71352, '\P{Is_InSC=	-NUKTA}', "");
Expect(0, 71352, '\P{^Is_InSC=	-NUKTA}', "");
Error('\p{Indic_Syllabic_Category=-/a/number}');
Error('\P{Indic_Syllabic_Category=-/a/number}');
Expect(1, 71483, '\p{Indic_Syllabic_Category=number}', "");
Expect(0, 71483, '\p{^Indic_Syllabic_Category=number}', "");
Expect(0, 71483, '\P{Indic_Syllabic_Category=number}', "");
Expect(1, 71483, '\P{^Indic_Syllabic_Category=number}', "");
Expect(0, 71484, '\p{Indic_Syllabic_Category=number}', "");
Expect(1, 71484, '\p{^Indic_Syllabic_Category=number}', "");
Expect(1, 71484, '\P{Indic_Syllabic_Category=number}', "");
Expect(0, 71484, '\P{^Indic_Syllabic_Category=number}', "");
Expect(1, 71483, '\p{Indic_Syllabic_Category= NUMBER}', "");
Expect(0, 71483, '\p{^Indic_Syllabic_Category= NUMBER}', "");
Expect(0, 71483, '\P{Indic_Syllabic_Category= NUMBER}', "");
Expect(1, 71483, '\P{^Indic_Syllabic_Category= NUMBER}', "");
Expect(0, 71484, '\p{Indic_Syllabic_Category= NUMBER}', "");
Expect(1, 71484, '\p{^Indic_Syllabic_Category= NUMBER}', "");
Expect(1, 71484, '\P{Indic_Syllabic_Category= NUMBER}', "");
Expect(0, 71484, '\P{^Indic_Syllabic_Category= NUMBER}', "");
Error('\p{InSC=-:=Number}');
Error('\P{InSC=-:=Number}');
Expect(1, 71483, '\p{InSC=number}', "");
Expect(0, 71483, '\p{^InSC=number}', "");
Expect(0, 71483, '\P{InSC=number}', "");
Expect(1, 71483, '\P{^InSC=number}', "");
Expect(0, 71484, '\p{InSC=number}', "");
Expect(1, 71484, '\p{^InSC=number}', "");
Expect(1, 71484, '\P{InSC=number}', "");
Expect(0, 71484, '\P{^InSC=number}', "");
Expect(1, 71483, '\p{InSC=	Number}', "");
Expect(0, 71483, '\p{^InSC=	Number}', "");
Expect(0, 71483, '\P{InSC=	Number}', "");
Expect(1, 71483, '\P{^InSC=	Number}', "");
Expect(0, 71484, '\p{InSC=	Number}', "");
Expect(1, 71484, '\p{^InSC=	Number}', "");
Expect(1, 71484, '\P{InSC=	Number}', "");
Expect(0, 71484, '\P{^InSC=	Number}', "");
Error('\p{Is_Indic_Syllabic_Category:/a/-_NUMBER}');
Error('\P{Is_Indic_Syllabic_Category:/a/-_NUMBER}');
Expect(1, 71483, '\p{Is_Indic_Syllabic_Category=number}', "");
Expect(0, 71483, '\p{^Is_Indic_Syllabic_Category=number}', "");
Expect(0, 71483, '\P{Is_Indic_Syllabic_Category=number}', "");
Expect(1, 71483, '\P{^Is_Indic_Syllabic_Category=number}', "");
Expect(0, 71484, '\p{Is_Indic_Syllabic_Category=number}', "");
Expect(1, 71484, '\p{^Is_Indic_Syllabic_Category=number}', "");
Expect(1, 71484, '\P{Is_Indic_Syllabic_Category=number}', "");
Expect(0, 71484, '\P{^Is_Indic_Syllabic_Category=number}', "");
Expect(1, 71483, '\p{Is_Indic_Syllabic_Category: _-NUMBER}', "");
Expect(0, 71483, '\p{^Is_Indic_Syllabic_Category: _-NUMBER}', "");
Expect(0, 71483, '\P{Is_Indic_Syllabic_Category: _-NUMBER}', "");
Expect(1, 71483, '\P{^Is_Indic_Syllabic_Category: _-NUMBER}', "");
Expect(0, 71484, '\p{Is_Indic_Syllabic_Category: _-NUMBER}', "");
Expect(1, 71484, '\p{^Is_Indic_Syllabic_Category: _-NUMBER}', "");
Expect(1, 71484, '\P{Is_Indic_Syllabic_Category: _-NUMBER}', "");
Expect(0, 71484, '\P{^Is_Indic_Syllabic_Category: _-NUMBER}', "");
Error('\p{Is_InSC=_NUMBER/a/}');
Error('\P{Is_InSC=_NUMBER/a/}');
Expect(1, 71483, '\p{Is_InSC=number}', "");
Expect(0, 71483, '\p{^Is_InSC=number}', "");
Expect(0, 71483, '\P{Is_InSC=number}', "");
Expect(1, 71483, '\P{^Is_InSC=number}', "");
Expect(0, 71484, '\p{Is_InSC=number}', "");
Expect(1, 71484, '\p{^Is_InSC=number}', "");
Expect(1, 71484, '\P{Is_InSC=number}', "");
Expect(0, 71484, '\P{^Is_InSC=number}', "");
Expect(1, 71483, '\p{Is_InSC=_ NUMBER}', "");
Expect(0, 71483, '\p{^Is_InSC=_ NUMBER}', "");
Expect(0, 71483, '\P{Is_InSC=_ NUMBER}', "");
Expect(1, 71483, '\P{^Is_InSC=_ NUMBER}', "");
Expect(0, 71484, '\p{Is_InSC=_ NUMBER}', "");
Expect(1, 71484, '\p{^Is_InSC=_ NUMBER}', "");
Expect(1, 71484, '\P{Is_InSC=_ NUMBER}', "");
Expect(0, 71484, '\P{^Is_InSC=_ NUMBER}', "");
Error('\p{Indic_Syllabic_Category=:=- NUMBER_Joiner}');
Error('\P{Indic_Syllabic_Category=:=- NUMBER_Joiner}');
Expect(1, 69759, '\p{Indic_Syllabic_Category=numberjoiner}', "");
Expect(0, 69759, '\p{^Indic_Syllabic_Category=numberjoiner}', "");
Expect(0, 69759, '\P{Indic_Syllabic_Category=numberjoiner}', "");
Expect(1, 69759, '\P{^Indic_Syllabic_Category=numberjoiner}', "");
Expect(0, 69760, '\p{Indic_Syllabic_Category=numberjoiner}', "");
Expect(1, 69760, '\p{^Indic_Syllabic_Category=numberjoiner}', "");
Expect(1, 69760, '\P{Indic_Syllabic_Category=numberjoiner}', "");
Expect(0, 69760, '\P{^Indic_Syllabic_Category=numberjoiner}', "");
Expect(1, 69759, '\p{Indic_Syllabic_Category=_-number_JOINER}', "");
Expect(0, 69759, '\p{^Indic_Syllabic_Category=_-number_JOINER}', "");
Expect(0, 69759, '\P{Indic_Syllabic_Category=_-number_JOINER}', "");
Expect(1, 69759, '\P{^Indic_Syllabic_Category=_-number_JOINER}', "");
Expect(0, 69760, '\p{Indic_Syllabic_Category=_-number_JOINER}', "");
Expect(1, 69760, '\p{^Indic_Syllabic_Category=_-number_JOINER}', "");
Expect(1, 69760, '\P{Indic_Syllabic_Category=_-number_JOINER}', "");
Expect(0, 69760, '\P{^Indic_Syllabic_Category=_-number_JOINER}', "");
Error('\p{InSC=-_number_joiner:=}');
Error('\P{InSC=-_number_joiner:=}');
Expect(1, 69759, '\p{InSC=numberjoiner}', "");
Expect(0, 69759, '\p{^InSC=numberjoiner}', "");
Expect(0, 69759, '\P{InSC=numberjoiner}', "");
Expect(1, 69759, '\P{^InSC=numberjoiner}', "");
Expect(0, 69760, '\p{InSC=numberjoiner}', "");
Expect(1, 69760, '\p{^InSC=numberjoiner}', "");
Expect(1, 69760, '\P{InSC=numberjoiner}', "");
Expect(0, 69760, '\P{^InSC=numberjoiner}', "");
Expect(1, 69759, '\p{InSC=-Number_joiner}', "");
Expect(0, 69759, '\p{^InSC=-Number_joiner}', "");
Expect(0, 69759, '\P{InSC=-Number_joiner}', "");
Expect(1, 69759, '\P{^InSC=-Number_joiner}', "");
Expect(0, 69760, '\p{InSC=-Number_joiner}', "");
Expect(1, 69760, '\p{^InSC=-Number_joiner}', "");
Expect(1, 69760, '\P{InSC=-Number_joiner}', "");
Expect(0, 69760, '\P{^InSC=-Number_joiner}', "");
Error('\p{Is_Indic_Syllabic_Category=	-Number_joiner:=}');
Error('\P{Is_Indic_Syllabic_Category=	-Number_joiner:=}');
Expect(1, 69759, '\p{Is_Indic_Syllabic_Category=numberjoiner}', "");
Expect(0, 69759, '\p{^Is_Indic_Syllabic_Category=numberjoiner}', "");
Expect(0, 69759, '\P{Is_Indic_Syllabic_Category=numberjoiner}', "");
Expect(1, 69759, '\P{^Is_Indic_Syllabic_Category=numberjoiner}', "");
Expect(0, 69760, '\p{Is_Indic_Syllabic_Category=numberjoiner}', "");
Expect(1, 69760, '\p{^Is_Indic_Syllabic_Category=numberjoiner}', "");
Expect(1, 69760, '\P{Is_Indic_Syllabic_Category=numberjoiner}', "");
Expect(0, 69760, '\P{^Is_Indic_Syllabic_Category=numberjoiner}', "");
Expect(1, 69759, '\p{Is_Indic_Syllabic_Category= -number_JOINER}', "");
Expect(0, 69759, '\p{^Is_Indic_Syllabic_Category= -number_JOINER}', "");
Expect(0, 69759, '\P{Is_Indic_Syllabic_Category= -number_JOINER}', "");
Expect(1, 69759, '\P{^Is_Indic_Syllabic_Category= -number_JOINER}', "");
Expect(0, 69760, '\p{Is_Indic_Syllabic_Category= -number_JOINER}', "");
Expect(1, 69760, '\p{^Is_Indic_Syllabic_Category= -number_JOINER}', "");
Expect(1, 69760, '\P{Is_Indic_Syllabic_Category= -number_JOINER}', "");
Expect(0, 69760, '\P{^Is_Indic_Syllabic_Category= -number_JOINER}', "");
Error('\p{Is_InSC=:=_number_JOINER}');
Error('\P{Is_InSC=:=_number_JOINER}');
Expect(1, 69759, '\p{Is_InSC=numberjoiner}', "");
Expect(0, 69759, '\p{^Is_InSC=numberjoiner}', "");
Expect(0, 69759, '\P{Is_InSC=numberjoiner}', "");
Expect(1, 69759, '\P{^Is_InSC=numberjoiner}', "");
Expect(0, 69760, '\p{Is_InSC=numberjoiner}', "");
Expect(1, 69760, '\p{^Is_InSC=numberjoiner}', "");
Expect(1, 69760, '\P{Is_InSC=numberjoiner}', "");
Expect(0, 69760, '\P{^Is_InSC=numberjoiner}', "");
Expect(1, 69759, '\p{Is_InSC=-Number_Joiner}', "");
Expect(0, 69759, '\p{^Is_InSC=-Number_Joiner}', "");
Expect(0, 69759, '\P{Is_InSC=-Number_Joiner}', "");
Expect(1, 69759, '\P{^Is_InSC=-Number_Joiner}', "");
Expect(0, 69760, '\p{Is_InSC=-Number_Joiner}', "");
Expect(1, 69760, '\p{^Is_InSC=-Number_Joiner}', "");
Expect(1, 69760, '\P{Is_InSC=-Number_Joiner}', "");
Expect(0, 69760, '\P{^Is_InSC=-Number_Joiner}', "");
Error('\p{Indic_Syllabic_Category=--Other:=}');
Error('\P{Indic_Syllabic_Category=--Other:=}');
Expect(1, 71484, '\p{Indic_Syllabic_Category=other}', "");
Expect(0, 71484, '\p{^Indic_Syllabic_Category=other}', "");
Expect(0, 71484, '\P{Indic_Syllabic_Category=other}', "");
Expect(1, 71484, '\P{^Indic_Syllabic_Category=other}', "");
Expect(0, 71483, '\p{Indic_Syllabic_Category=other}', "");
Expect(1, 71483, '\p{^Indic_Syllabic_Category=other}', "");
Expect(1, 71483, '\P{Indic_Syllabic_Category=other}', "");
Expect(0, 71483, '\P{^Indic_Syllabic_Category=other}', "");
Expect(1, 71484, '\p{Indic_Syllabic_Category=-_Other}', "");
Expect(0, 71484, '\p{^Indic_Syllabic_Category=-_Other}', "");
Expect(0, 71484, '\P{Indic_Syllabic_Category=-_Other}', "");
Expect(1, 71484, '\P{^Indic_Syllabic_Category=-_Other}', "");
Expect(0, 71483, '\p{Indic_Syllabic_Category=-_Other}', "");
Expect(1, 71483, '\p{^Indic_Syllabic_Category=-_Other}', "");
Expect(1, 71483, '\P{Indic_Syllabic_Category=-_Other}', "");
Expect(0, 71483, '\P{^Indic_Syllabic_Category=-_Other}', "");
Error('\p{InSC=:=OTHER}');
Error('\P{InSC=:=OTHER}');
Expect(1, 71484, '\p{InSC=other}', "");
Expect(0, 71484, '\p{^InSC=other}', "");
Expect(0, 71484, '\P{InSC=other}', "");
Expect(1, 71484, '\P{^InSC=other}', "");
Expect(0, 71483, '\p{InSC=other}', "");
Expect(1, 71483, '\p{^InSC=other}', "");
Expect(1, 71483, '\P{InSC=other}', "");
Expect(0, 71483, '\P{^InSC=other}', "");
Expect(1, 71484, '\p{InSC=		other}', "");
Expect(0, 71484, '\p{^InSC=		other}', "");
Expect(0, 71484, '\P{InSC=		other}', "");
Expect(1, 71484, '\P{^InSC=		other}', "");
Expect(0, 71483, '\p{InSC=		other}', "");
Expect(1, 71483, '\p{^InSC=		other}', "");
Expect(1, 71483, '\P{InSC=		other}', "");
Expect(0, 71483, '\P{^InSC=		other}', "");
Error('\p{Is_Indic_Syllabic_Category:   :=- Other}');
Error('\P{Is_Indic_Syllabic_Category:   :=- Other}');
Expect(1, 71484, '\p{Is_Indic_Syllabic_Category=other}', "");
Expect(0, 71484, '\p{^Is_Indic_Syllabic_Category=other}', "");
Expect(0, 71484, '\P{Is_Indic_Syllabic_Category=other}', "");
Expect(1, 71484, '\P{^Is_Indic_Syllabic_Category=other}', "");
Expect(0, 71483, '\p{Is_Indic_Syllabic_Category=other}', "");
Expect(1, 71483, '\p{^Is_Indic_Syllabic_Category=other}', "");
Expect(1, 71483, '\P{Is_Indic_Syllabic_Category=other}', "");
Expect(0, 71483, '\P{^Is_Indic_Syllabic_Category=other}', "");
Expect(1, 71484, '\p{Is_Indic_Syllabic_Category=-Other}', "");
Expect(0, 71484, '\p{^Is_Indic_Syllabic_Category=-Other}', "");
Expect(0, 71484, '\P{Is_Indic_Syllabic_Category=-Other}', "");
Expect(1, 71484, '\P{^Is_Indic_Syllabic_Category=-Other}', "");
Expect(0, 71483, '\p{Is_Indic_Syllabic_Category=-Other}', "");
Expect(1, 71483, '\p{^Is_Indic_Syllabic_Category=-Other}', "");
Expect(1, 71483, '\P{Is_Indic_Syllabic_Category=-Other}', "");
Expect(0, 71483, '\P{^Is_Indic_Syllabic_Category=-Other}', "");
Error('\p{Is_InSC=_	Other/a/}');
Error('\P{Is_InSC=_	Other/a/}');
Expect(1, 71484, '\p{Is_InSC=other}', "");
Expect(0, 71484, '\p{^Is_InSC=other}', "");
Expect(0, 71484, '\P{Is_InSC=other}', "");
Expect(1, 71484, '\P{^Is_InSC=other}', "");
Expect(0, 71483, '\p{Is_InSC=other}', "");
Expect(1, 71483, '\p{^Is_InSC=other}', "");
Expect(1, 71483, '\P{Is_InSC=other}', "");
Expect(0, 71483, '\P{^Is_InSC=other}', "");
Expect(1, 71484, '\p{Is_InSC=	 Other}', "");
Expect(0, 71484, '\p{^Is_InSC=	 Other}', "");
Expect(0, 71484, '\P{Is_InSC=	 Other}', "");
Expect(1, 71484, '\P{^Is_InSC=	 Other}', "");
Expect(0, 71483, '\p{Is_InSC=	 Other}', "");
Expect(1, 71483, '\p{^Is_InSC=	 Other}', "");
Expect(1, 71483, '\P{Is_InSC=	 Other}', "");
Expect(0, 71483, '\P{^Is_InSC=	 Other}', "");
Error('\p{Indic_Syllabic_Category=/a/-	Pure_Killer}');
Error('\P{Indic_Syllabic_Category=/a/-	Pure_Killer}');
Expect(1, 71467, '\p{Indic_Syllabic_Category=purekiller}', "");
Expect(0, 71467, '\p{^Indic_Syllabic_Category=purekiller}', "");
Expect(0, 71467, '\P{Indic_Syllabic_Category=purekiller}', "");
Expect(1, 71467, '\P{^Indic_Syllabic_Category=purekiller}', "");
Expect(0, 71468, '\p{Indic_Syllabic_Category=purekiller}', "");
Expect(1, 71468, '\p{^Indic_Syllabic_Category=purekiller}', "");
Expect(1, 71468, '\P{Indic_Syllabic_Category=purekiller}', "");
Expect(0, 71468, '\P{^Indic_Syllabic_Category=purekiller}', "");
Expect(1, 71467, '\p{Indic_Syllabic_Category=__Pure_Killer}', "");
Expect(0, 71467, '\p{^Indic_Syllabic_Category=__Pure_Killer}', "");
Expect(0, 71467, '\P{Indic_Syllabic_Category=__Pure_Killer}', "");
Expect(1, 71467, '\P{^Indic_Syllabic_Category=__Pure_Killer}', "");
Expect(0, 71468, '\p{Indic_Syllabic_Category=__Pure_Killer}', "");
Expect(1, 71468, '\p{^Indic_Syllabic_Category=__Pure_Killer}', "");
Expect(1, 71468, '\P{Indic_Syllabic_Category=__Pure_Killer}', "");
Expect(0, 71468, '\P{^Indic_Syllabic_Category=__Pure_Killer}', "");
Error('\p{InSC=/a/ _PURE_Killer}');
Error('\P{InSC=/a/ _PURE_Killer}');
Expect(1, 71467, '\p{InSC=purekiller}', "");
Expect(0, 71467, '\p{^InSC=purekiller}', "");
Expect(0, 71467, '\P{InSC=purekiller}', "");
Expect(1, 71467, '\P{^InSC=purekiller}', "");
Expect(0, 71468, '\p{InSC=purekiller}', "");
Expect(1, 71468, '\p{^InSC=purekiller}', "");
Expect(1, 71468, '\P{InSC=purekiller}', "");
Expect(0, 71468, '\P{^InSC=purekiller}', "");
Expect(1, 71467, '\p{InSC:Pure_Killer}', "");
Expect(0, 71467, '\p{^InSC:Pure_Killer}', "");
Expect(0, 71467, '\P{InSC:Pure_Killer}', "");
Expect(1, 71467, '\P{^InSC:Pure_Killer}', "");
Expect(0, 71468, '\p{InSC:Pure_Killer}', "");
Expect(1, 71468, '\p{^InSC:Pure_Killer}', "");
Expect(1, 71468, '\P{InSC:Pure_Killer}', "");
Expect(0, 71468, '\P{^InSC:Pure_Killer}', "");
Error('\p{Is_Indic_Syllabic_Category=_Pure_Killer:=}');
Error('\P{Is_Indic_Syllabic_Category=_Pure_Killer:=}');
Expect(1, 71467, '\p{Is_Indic_Syllabic_Category:purekiller}', "");
Expect(0, 71467, '\p{^Is_Indic_Syllabic_Category:purekiller}', "");
Expect(0, 71467, '\P{Is_Indic_Syllabic_Category:purekiller}', "");
Expect(1, 71467, '\P{^Is_Indic_Syllabic_Category:purekiller}', "");
Expect(0, 71468, '\p{Is_Indic_Syllabic_Category:purekiller}', "");
Expect(1, 71468, '\p{^Is_Indic_Syllabic_Category:purekiller}', "");
Expect(1, 71468, '\P{Is_Indic_Syllabic_Category:purekiller}', "");
Expect(0, 71468, '\P{^Is_Indic_Syllabic_Category:purekiller}', "");
Expect(1, 71467, '\p{Is_Indic_Syllabic_Category=_-pure_KILLER}', "");
Expect(0, 71467, '\p{^Is_Indic_Syllabic_Category=_-pure_KILLER}', "");
Expect(0, 71467, '\P{Is_Indic_Syllabic_Category=_-pure_KILLER}', "");
Expect(1, 71467, '\P{^Is_Indic_Syllabic_Category=_-pure_KILLER}', "");
Expect(0, 71468, '\p{Is_Indic_Syllabic_Category=_-pure_KILLER}', "");
Expect(1, 71468, '\p{^Is_Indic_Syllabic_Category=_-pure_KILLER}', "");
Expect(1, 71468, '\P{Is_Indic_Syllabic_Category=_-pure_KILLER}', "");
Expect(0, 71468, '\P{^Is_Indic_Syllabic_Category=_-pure_KILLER}', "");
Error('\p{Is_InSC=-/a/pure_killer}');
Error('\P{Is_InSC=-/a/pure_killer}');
Expect(1, 71467, '\p{Is_InSC=purekiller}', "");
Expect(0, 71467, '\p{^Is_InSC=purekiller}', "");
Expect(0, 71467, '\P{Is_InSC=purekiller}', "");
Expect(1, 71467, '\P{^Is_InSC=purekiller}', "");
Expect(0, 71468, '\p{Is_InSC=purekiller}', "");
Expect(1, 71468, '\p{^Is_InSC=purekiller}', "");
Expect(1, 71468, '\P{Is_InSC=purekiller}', "");
Expect(0, 71468, '\P{^Is_InSC=purekiller}', "");
Expect(1, 71467, '\p{Is_InSC=	 pure_Killer}', "");
Expect(0, 71467, '\p{^Is_InSC=	 pure_Killer}', "");
Expect(0, 71467, '\P{Is_InSC=	 pure_Killer}', "");
Expect(1, 71467, '\P{^Is_InSC=	 pure_Killer}', "");
Expect(0, 71468, '\p{Is_InSC=	 pure_Killer}', "");
Expect(1, 71468, '\p{^Is_InSC=	 pure_Killer}', "");
Expect(1, 71468, '\P{Is_InSC=	 pure_Killer}', "");
Expect(0, 71468, '\P{^Is_InSC=	 pure_Killer}', "");
Error('\p{Indic_Syllabic_Category=:=	_register_shifter}');
Error('\P{Indic_Syllabic_Category=:=	_register_shifter}');
Expect(1, 6090, '\p{Indic_Syllabic_Category:registershifter}', "");
Expect(0, 6090, '\p{^Indic_Syllabic_Category:registershifter}', "");
Expect(0, 6090, '\P{Indic_Syllabic_Category:registershifter}', "");
Expect(1, 6090, '\P{^Indic_Syllabic_Category:registershifter}', "");
Expect(0, 6091, '\p{Indic_Syllabic_Category:registershifter}', "");
Expect(1, 6091, '\p{^Indic_Syllabic_Category:registershifter}', "");
Expect(1, 6091, '\P{Indic_Syllabic_Category:registershifter}', "");
Expect(0, 6091, '\P{^Indic_Syllabic_Category:registershifter}', "");
Expect(1, 6090, '\p{Indic_Syllabic_Category= REGISTER_SHIFTER}', "");
Expect(0, 6090, '\p{^Indic_Syllabic_Category= REGISTER_SHIFTER}', "");
Expect(0, 6090, '\P{Indic_Syllabic_Category= REGISTER_SHIFTER}', "");
Expect(1, 6090, '\P{^Indic_Syllabic_Category= REGISTER_SHIFTER}', "");
Expect(0, 6091, '\p{Indic_Syllabic_Category= REGISTER_SHIFTER}', "");
Expect(1, 6091, '\p{^Indic_Syllabic_Category= REGISTER_SHIFTER}', "");
Expect(1, 6091, '\P{Indic_Syllabic_Category= REGISTER_SHIFTER}', "");
Expect(0, 6091, '\P{^Indic_Syllabic_Category= REGISTER_SHIFTER}', "");
Error('\p{InSC=:=register_SHIFTER}');
Error('\P{InSC=:=register_SHIFTER}');
Expect(1, 6090, '\p{InSC=registershifter}', "");
Expect(0, 6090, '\p{^InSC=registershifter}', "");
Expect(0, 6090, '\P{InSC=registershifter}', "");
Expect(1, 6090, '\P{^InSC=registershifter}', "");
Expect(0, 6091, '\p{InSC=registershifter}', "");
Expect(1, 6091, '\p{^InSC=registershifter}', "");
Expect(1, 6091, '\P{InSC=registershifter}', "");
Expect(0, 6091, '\P{^InSC=registershifter}', "");
Expect(1, 6090, '\p{InSC=	_register_shifter}', "");
Expect(0, 6090, '\p{^InSC=	_register_shifter}', "");
Expect(0, 6090, '\P{InSC=	_register_shifter}', "");
Expect(1, 6090, '\P{^InSC=	_register_shifter}', "");
Expect(0, 6091, '\p{InSC=	_register_shifter}', "");
Expect(1, 6091, '\p{^InSC=	_register_shifter}', "");
Expect(1, 6091, '\P{InSC=	_register_shifter}', "");
Expect(0, 6091, '\P{^InSC=	_register_shifter}', "");
Error('\p{Is_Indic_Syllabic_Category:	:=REGISTER_SHIFTER}');
Error('\P{Is_Indic_Syllabic_Category:	:=REGISTER_SHIFTER}');
Expect(1, 6090, '\p{Is_Indic_Syllabic_Category: registershifter}', "");
Expect(0, 6090, '\p{^Is_Indic_Syllabic_Category: registershifter}', "");
Expect(0, 6090, '\P{Is_Indic_Syllabic_Category: registershifter}', "");
Expect(1, 6090, '\P{^Is_Indic_Syllabic_Category: registershifter}', "");
Expect(0, 6091, '\p{Is_Indic_Syllabic_Category: registershifter}', "");
Expect(1, 6091, '\p{^Is_Indic_Syllabic_Category: registershifter}', "");
Expect(1, 6091, '\P{Is_Indic_Syllabic_Category: registershifter}', "");
Expect(0, 6091, '\P{^Is_Indic_Syllabic_Category: registershifter}', "");
Expect(1, 6090, '\p{Is_Indic_Syllabic_Category=-_Register_Shifter}', "");
Expect(0, 6090, '\p{^Is_Indic_Syllabic_Category=-_Register_Shifter}', "");
Expect(0, 6090, '\P{Is_Indic_Syllabic_Category=-_Register_Shifter}', "");
Expect(1, 6090, '\P{^Is_Indic_Syllabic_Category=-_Register_Shifter}', "");
Expect(0, 6091, '\p{Is_Indic_Syllabic_Category=-_Register_Shifter}', "");
Expect(1, 6091, '\p{^Is_Indic_Syllabic_Category=-_Register_Shifter}', "");
Expect(1, 6091, '\P{Is_Indic_Syllabic_Category=-_Register_Shifter}', "");
Expect(0, 6091, '\P{^Is_Indic_Syllabic_Category=-_Register_Shifter}', "");
Error('\p{Is_InSC= -Register_Shifter/a/}');
Error('\P{Is_InSC= -Register_Shifter/a/}');
Expect(1, 6090, '\p{Is_InSC=registershifter}', "");
Expect(0, 6090, '\p{^Is_InSC=registershifter}', "");
Expect(0, 6090, '\P{Is_InSC=registershifter}', "");
Expect(1, 6090, '\P{^Is_InSC=registershifter}', "");
Expect(0, 6091, '\p{Is_InSC=registershifter}', "");
Expect(1, 6091, '\p{^Is_InSC=registershifter}', "");
Expect(1, 6091, '\P{Is_InSC=registershifter}', "");
Expect(0, 6091, '\P{^Is_InSC=registershifter}', "");
Expect(1, 6090, '\p{Is_InSC=  register_Shifter}', "");
Expect(0, 6090, '\p{^Is_InSC=  register_Shifter}', "");
Expect(0, 6090, '\P{Is_InSC=  register_Shifter}', "");
Expect(1, 6090, '\P{^Is_InSC=  register_Shifter}', "");
Expect(0, 6091, '\p{Is_InSC=  register_Shifter}', "");
Expect(1, 6091, '\p{^Is_InSC=  register_Shifter}', "");
Expect(1, 6091, '\P{Is_InSC=  register_Shifter}', "");
Expect(0, 6091, '\P{^Is_InSC=  register_Shifter}', "");
Error('\p{Indic_Syllabic_Category=-:=Syllable_Modifier}');
Error('\P{Indic_Syllabic_Category=-:=Syllable_Modifier}');
Expect(1, 8324, '\p{Indic_Syllabic_Category=syllablemodifier}', "");
Expect(0, 8324, '\p{^Indic_Syllabic_Category=syllablemodifier}', "");
Expect(0, 8324, '\P{Indic_Syllabic_Category=syllablemodifier}', "");
Expect(1, 8324, '\P{^Indic_Syllabic_Category=syllablemodifier}', "");
Expect(0, 8325, '\p{Indic_Syllabic_Category=syllablemodifier}', "");
Expect(1, 8325, '\p{^Indic_Syllabic_Category=syllablemodifier}', "");
Expect(1, 8325, '\P{Indic_Syllabic_Category=syllablemodifier}', "");
Expect(0, 8325, '\P{^Indic_Syllabic_Category=syllablemodifier}', "");
Expect(1, 8324, '\p{Indic_Syllabic_Category=-syllable_Modifier}', "");
Expect(0, 8324, '\p{^Indic_Syllabic_Category=-syllable_Modifier}', "");
Expect(0, 8324, '\P{Indic_Syllabic_Category=-syllable_Modifier}', "");
Expect(1, 8324, '\P{^Indic_Syllabic_Category=-syllable_Modifier}', "");
Expect(0, 8325, '\p{Indic_Syllabic_Category=-syllable_Modifier}', "");
Expect(1, 8325, '\p{^Indic_Syllabic_Category=-syllable_Modifier}', "");
Expect(1, 8325, '\P{Indic_Syllabic_Category=-syllable_Modifier}', "");
Expect(0, 8325, '\P{^Indic_Syllabic_Category=-syllable_Modifier}', "");
Error('\p{InSC= 	Syllable_Modifier:=}');
Error('\P{InSC= 	Syllable_Modifier:=}');
Expect(1, 8324, '\p{InSC=syllablemodifier}', "");
Expect(0, 8324, '\p{^InSC=syllablemodifier}', "");
Expect(0, 8324, '\P{InSC=syllablemodifier}', "");
Expect(1, 8324, '\P{^InSC=syllablemodifier}', "");
Expect(0, 8325, '\p{InSC=syllablemodifier}', "");
Expect(1, 8325, '\p{^InSC=syllablemodifier}', "");
Expect(1, 8325, '\P{InSC=syllablemodifier}', "");
Expect(0, 8325, '\P{^InSC=syllablemodifier}', "");
Expect(1, 8324, '\p{InSC=	Syllable_Modifier}', "");
Expect(0, 8324, '\p{^InSC=	Syllable_Modifier}', "");
Expect(0, 8324, '\P{InSC=	Syllable_Modifier}', "");
Expect(1, 8324, '\P{^InSC=	Syllable_Modifier}', "");
Expect(0, 8325, '\p{InSC=	Syllable_Modifier}', "");
Expect(1, 8325, '\p{^InSC=	Syllable_Modifier}', "");
Expect(1, 8325, '\P{InSC=	Syllable_Modifier}', "");
Expect(0, 8325, '\P{^InSC=	Syllable_Modifier}', "");
Error('\p{Is_Indic_Syllabic_Category= 	SYLLABLE_modifier/a/}');
Error('\P{Is_Indic_Syllabic_Category= 	SYLLABLE_modifier/a/}');
Expect(1, 8324, '\p{Is_Indic_Syllabic_Category=syllablemodifier}', "");
Expect(0, 8324, '\p{^Is_Indic_Syllabic_Category=syllablemodifier}', "");
Expect(0, 8324, '\P{Is_Indic_Syllabic_Category=syllablemodifier}', "");
Expect(1, 8324, '\P{^Is_Indic_Syllabic_Category=syllablemodifier}', "");
Expect(0, 8325, '\p{Is_Indic_Syllabic_Category=syllablemodifier}', "");
Expect(1, 8325, '\p{^Is_Indic_Syllabic_Category=syllablemodifier}', "");
Expect(1, 8325, '\P{Is_Indic_Syllabic_Category=syllablemodifier}', "");
Expect(0, 8325, '\P{^Is_Indic_Syllabic_Category=syllablemodifier}', "");
Expect(1, 8324, '\p{Is_Indic_Syllabic_Category=  Syllable_Modifier}', "");
Expect(0, 8324, '\p{^Is_Indic_Syllabic_Category=  Syllable_Modifier}', "");
Expect(0, 8324, '\P{Is_Indic_Syllabic_Category=  Syllable_Modifier}', "");
Expect(1, 8324, '\P{^Is_Indic_Syllabic_Category=  Syllable_Modifier}', "");
Expect(0, 8325, '\p{Is_Indic_Syllabic_Category=  Syllable_Modifier}', "");
Expect(1, 8325, '\p{^Is_Indic_Syllabic_Category=  Syllable_Modifier}', "");
Expect(1, 8325, '\P{Is_Indic_Syllabic_Category=  Syllable_Modifier}', "");
Expect(0, 8325, '\P{^Is_Indic_Syllabic_Category=  Syllable_Modifier}', "");
Error('\p{Is_InSC=:= 	Syllable_MODIFIER}');
Error('\P{Is_InSC=:= 	Syllable_MODIFIER}');
Expect(1, 8324, '\p{Is_InSC=syllablemodifier}', "");
Expect(0, 8324, '\p{^Is_InSC=syllablemodifier}', "");
Expect(0, 8324, '\P{Is_InSC=syllablemodifier}', "");
Expect(1, 8324, '\P{^Is_InSC=syllablemodifier}', "");
Expect(0, 8325, '\p{Is_InSC=syllablemodifier}', "");
Expect(1, 8325, '\p{^Is_InSC=syllablemodifier}', "");
Expect(1, 8325, '\P{Is_InSC=syllablemodifier}', "");
Expect(0, 8325, '\P{^Is_InSC=syllablemodifier}', "");
Expect(1, 8324, '\p{Is_InSC=_-SYLLABLE_Modifier}', "");
Expect(0, 8324, '\p{^Is_InSC=_-SYLLABLE_Modifier}', "");
Expect(0, 8324, '\P{Is_InSC=_-SYLLABLE_Modifier}', "");
Expect(1, 8324, '\P{^Is_InSC=_-SYLLABLE_Modifier}', "");
Expect(0, 8325, '\p{Is_InSC=_-SYLLABLE_Modifier}', "");
Expect(1, 8325, '\p{^Is_InSC=_-SYLLABLE_Modifier}', "");
Expect(1, 8325, '\P{Is_InSC=_-SYLLABLE_Modifier}', "");
Expect(0, 8325, '\P{^Is_InSC=_-SYLLABLE_Modifier}', "");
Error('\p{Indic_Syllabic_Category=_/a/tone_LETTER}');
Error('\P{Indic_Syllabic_Category=_/a/tone_LETTER}');
Expect(1, 43714, '\p{Indic_Syllabic_Category=toneletter}', "");
Expect(0, 43714, '\p{^Indic_Syllabic_Category=toneletter}', "");
Expect(0, 43714, '\P{Indic_Syllabic_Category=toneletter}', "");
Expect(1, 43714, '\P{^Indic_Syllabic_Category=toneletter}', "");
Expect(0, 43715, '\p{Indic_Syllabic_Category=toneletter}', "");
Expect(1, 43715, '\p{^Indic_Syllabic_Category=toneletter}', "");
Expect(1, 43715, '\P{Indic_Syllabic_Category=toneletter}', "");
Expect(0, 43715, '\P{^Indic_Syllabic_Category=toneletter}', "");
Expect(1, 43714, '\p{Indic_Syllabic_Category=-tone_LETTER}', "");
Expect(0, 43714, '\p{^Indic_Syllabic_Category=-tone_LETTER}', "");
Expect(0, 43714, '\P{Indic_Syllabic_Category=-tone_LETTER}', "");
Expect(1, 43714, '\P{^Indic_Syllabic_Category=-tone_LETTER}', "");
Expect(0, 43715, '\p{Indic_Syllabic_Category=-tone_LETTER}', "");
Expect(1, 43715, '\p{^Indic_Syllabic_Category=-tone_LETTER}', "");
Expect(1, 43715, '\P{Indic_Syllabic_Category=-tone_LETTER}', "");
Expect(0, 43715, '\P{^Indic_Syllabic_Category=-tone_LETTER}', "");
Error('\p{InSC=:=--Tone_LETTER}');
Error('\P{InSC=:=--Tone_LETTER}');
Expect(1, 43714, '\p{InSC: toneletter}', "");
Expect(0, 43714, '\p{^InSC: toneletter}', "");
Expect(0, 43714, '\P{InSC: toneletter}', "");
Expect(1, 43714, '\P{^InSC: toneletter}', "");
Expect(0, 43715, '\p{InSC: toneletter}', "");
Expect(1, 43715, '\p{^InSC: toneletter}', "");
Expect(1, 43715, '\P{InSC: toneletter}', "");
Expect(0, 43715, '\P{^InSC: toneletter}', "");
Expect(1, 43714, '\p{InSC=		TONE_Letter}', "");
Expect(0, 43714, '\p{^InSC=		TONE_Letter}', "");
Expect(0, 43714, '\P{InSC=		TONE_Letter}', "");
Expect(1, 43714, '\P{^InSC=		TONE_Letter}', "");
Expect(0, 43715, '\p{InSC=		TONE_Letter}', "");
Expect(1, 43715, '\p{^InSC=		TONE_Letter}', "");
Expect(1, 43715, '\P{InSC=		TONE_Letter}', "");
Expect(0, 43715, '\P{^InSC=		TONE_Letter}', "");
Error('\p{Is_Indic_Syllabic_Category=_:=TONE_Letter}');
Error('\P{Is_Indic_Syllabic_Category=_:=TONE_Letter}');
Expect(1, 43714, '\p{Is_Indic_Syllabic_Category=toneletter}', "");
Expect(0, 43714, '\p{^Is_Indic_Syllabic_Category=toneletter}', "");
Expect(0, 43714, '\P{Is_Indic_Syllabic_Category=toneletter}', "");
Expect(1, 43714, '\P{^Is_Indic_Syllabic_Category=toneletter}', "");
Expect(0, 43715, '\p{Is_Indic_Syllabic_Category=toneletter}', "");
Expect(1, 43715, '\p{^Is_Indic_Syllabic_Category=toneletter}', "");
Expect(1, 43715, '\P{Is_Indic_Syllabic_Category=toneletter}', "");
Expect(0, 43715, '\P{^Is_Indic_Syllabic_Category=toneletter}', "");
Expect(1, 43714, '\p{Is_Indic_Syllabic_Category=-	TONE_Letter}', "");
Expect(0, 43714, '\p{^Is_Indic_Syllabic_Category=-	TONE_Letter}', "");
Expect(0, 43714, '\P{Is_Indic_Syllabic_Category=-	TONE_Letter}', "");
Expect(1, 43714, '\P{^Is_Indic_Syllabic_Category=-	TONE_Letter}', "");
Expect(0, 43715, '\p{Is_Indic_Syllabic_Category=-	TONE_Letter}', "");
Expect(1, 43715, '\p{^Is_Indic_Syllabic_Category=-	TONE_Letter}', "");
Expect(1, 43715, '\P{Is_Indic_Syllabic_Category=-	TONE_Letter}', "");
Expect(0, 43715, '\P{^Is_Indic_Syllabic_Category=-	TONE_Letter}', "");
Error('\p{Is_InSC=/a/- tone_Letter}');
Error('\P{Is_InSC=/a/- tone_Letter}');
Expect(1, 43714, '\p{Is_InSC=toneletter}', "");
Expect(0, 43714, '\p{^Is_InSC=toneletter}', "");
Expect(0, 43714, '\P{Is_InSC=toneletter}', "");
Expect(1, 43714, '\P{^Is_InSC=toneletter}', "");
Expect(0, 43715, '\p{Is_InSC=toneletter}', "");
Expect(1, 43715, '\p{^Is_InSC=toneletter}', "");
Expect(1, 43715, '\P{Is_InSC=toneletter}', "");
Expect(0, 43715, '\P{^Is_InSC=toneletter}', "");
Expect(1, 43714, '\p{Is_InSC:	TONE_Letter}', "");
Expect(0, 43714, '\p{^Is_InSC:	TONE_Letter}', "");
Expect(0, 43714, '\P{Is_InSC:	TONE_Letter}', "");
Expect(1, 43714, '\P{^Is_InSC:	TONE_Letter}', "");
Expect(0, 43715, '\p{Is_InSC:	TONE_Letter}', "");
Expect(1, 43715, '\p{^Is_InSC:	TONE_Letter}', "");
Expect(1, 43715, '\P{Is_InSC:	TONE_Letter}', "");
Expect(0, 43715, '\P{^Is_InSC:	TONE_Letter}', "");
Error('\p{Indic_Syllabic_Category=	Tone_MARK/a/}');
Error('\P{Indic_Syllabic_Category=	Tone_MARK/a/}');
Expect(1, 44012, '\p{Indic_Syllabic_Category:tonemark}', "");
Expect(0, 44012, '\p{^Indic_Syllabic_Category:tonemark}', "");
Expect(0, 44012, '\P{Indic_Syllabic_Category:tonemark}', "");
Expect(1, 44012, '\P{^Indic_Syllabic_Category:tonemark}', "");
Expect(0, 44013, '\p{Indic_Syllabic_Category:tonemark}', "");
Expect(1, 44013, '\p{^Indic_Syllabic_Category:tonemark}', "");
Expect(1, 44013, '\P{Indic_Syllabic_Category:tonemark}', "");
Expect(0, 44013, '\P{^Indic_Syllabic_Category:tonemark}', "");
Expect(1, 44012, '\p{Indic_Syllabic_Category=  TONE_MARK}', "");
Expect(0, 44012, '\p{^Indic_Syllabic_Category=  TONE_MARK}', "");
Expect(0, 44012, '\P{Indic_Syllabic_Category=  TONE_MARK}', "");
Expect(1, 44012, '\P{^Indic_Syllabic_Category=  TONE_MARK}', "");
Expect(0, 44013, '\p{Indic_Syllabic_Category=  TONE_MARK}', "");
Expect(1, 44013, '\p{^Indic_Syllabic_Category=  TONE_MARK}', "");
Expect(1, 44013, '\P{Indic_Syllabic_Category=  TONE_MARK}', "");
Expect(0, 44013, '\P{^Indic_Syllabic_Category=  TONE_MARK}', "");
Error('\p{InSC= :=Tone_mark}');
Error('\P{InSC= :=Tone_mark}');
Expect(1, 44012, '\p{InSC=tonemark}', "");
Expect(0, 44012, '\p{^InSC=tonemark}', "");
Expect(0, 44012, '\P{InSC=tonemark}', "");
Expect(1, 44012, '\P{^InSC=tonemark}', "");
Expect(0, 44013, '\p{InSC=tonemark}', "");
Expect(1, 44013, '\p{^InSC=tonemark}', "");
Expect(1, 44013, '\P{InSC=tonemark}', "");
Expect(0, 44013, '\P{^InSC=tonemark}', "");
Expect(1, 44012, '\p{InSC=-tone_MARK}', "");
Expect(0, 44012, '\p{^InSC=-tone_MARK}', "");
Expect(0, 44012, '\P{InSC=-tone_MARK}', "");
Expect(1, 44012, '\P{^InSC=-tone_MARK}', "");
Expect(0, 44013, '\p{InSC=-tone_MARK}', "");
Expect(1, 44013, '\p{^InSC=-tone_MARK}', "");
Expect(1, 44013, '\P{InSC=-tone_MARK}', "");
Expect(0, 44013, '\P{^InSC=-tone_MARK}', "");
Error('\p{Is_Indic_Syllabic_Category=_Tone_mark/a/}');
Error('\P{Is_Indic_Syllabic_Category=_Tone_mark/a/}');
Expect(1, 44012, '\p{Is_Indic_Syllabic_Category=tonemark}', "");
Expect(0, 44012, '\p{^Is_Indic_Syllabic_Category=tonemark}', "");
Expect(0, 44012, '\P{Is_Indic_Syllabic_Category=tonemark}', "");
Expect(1, 44012, '\P{^Is_Indic_Syllabic_Category=tonemark}', "");
Expect(0, 44013, '\p{Is_Indic_Syllabic_Category=tonemark}', "");
Expect(1, 44013, '\p{^Is_Indic_Syllabic_Category=tonemark}', "");
Expect(1, 44013, '\P{Is_Indic_Syllabic_Category=tonemark}', "");
Expect(0, 44013, '\P{^Is_Indic_Syllabic_Category=tonemark}', "");
Expect(1, 44012, '\p{Is_Indic_Syllabic_Category=__Tone_Mark}', "");
Expect(0, 44012, '\p{^Is_Indic_Syllabic_Category=__Tone_Mark}', "");
Expect(0, 44012, '\P{Is_Indic_Syllabic_Category=__Tone_Mark}', "");
Expect(1, 44012, '\P{^Is_Indic_Syllabic_Category=__Tone_Mark}', "");
Expect(0, 44013, '\p{Is_Indic_Syllabic_Category=__Tone_Mark}', "");
Expect(1, 44013, '\p{^Is_Indic_Syllabic_Category=__Tone_Mark}', "");
Expect(1, 44013, '\P{Is_Indic_Syllabic_Category=__Tone_Mark}', "");
Expect(0, 44013, '\P{^Is_Indic_Syllabic_Category=__Tone_Mark}', "");
Error('\p{Is_InSC=	/a/TONE_mark}');
Error('\P{Is_InSC=	/a/TONE_mark}');
Expect(1, 44012, '\p{Is_InSC=tonemark}', "");
Expect(0, 44012, '\p{^Is_InSC=tonemark}', "");
Expect(0, 44012, '\P{Is_InSC=tonemark}', "");
Expect(1, 44012, '\P{^Is_InSC=tonemark}', "");
Expect(0, 44013, '\p{Is_InSC=tonemark}', "");
Expect(1, 44013, '\p{^Is_InSC=tonemark}', "");
Expect(1, 44013, '\P{Is_InSC=tonemark}', "");
Expect(0, 44013, '\P{^Is_InSC=tonemark}', "");
Expect(1, 44012, '\p{Is_InSC=-	Tone_mark}', "");
Expect(0, 44012, '\p{^Is_InSC=-	Tone_mark}', "");
Expect(0, 44012, '\P{Is_InSC=-	Tone_mark}', "");
Expect(1, 44012, '\P{^Is_InSC=-	Tone_mark}', "");
Expect(0, 44013, '\p{Is_InSC=-	Tone_mark}', "");
Expect(1, 44013, '\p{^Is_InSC=-	Tone_mark}', "");
Expect(1, 44013, '\P{Is_InSC=-	Tone_mark}', "");
Expect(0, 44013, '\P{^Is_InSC=-	Tone_mark}', "");
Error('\p{Indic_Syllabic_Category= Virama:=}');
Error('\P{Indic_Syllabic_Category= Virama:=}');
Expect(1, 71350, '\p{Indic_Syllabic_Category=virama}', "");
Expect(0, 71350, '\p{^Indic_Syllabic_Category=virama}', "");
Expect(0, 71350, '\P{Indic_Syllabic_Category=virama}', "");
Expect(1, 71350, '\P{^Indic_Syllabic_Category=virama}', "");
Expect(0, 71351, '\p{Indic_Syllabic_Category=virama}', "");
Expect(1, 71351, '\p{^Indic_Syllabic_Category=virama}', "");
Expect(1, 71351, '\P{Indic_Syllabic_Category=virama}', "");
Expect(0, 71351, '\P{^Indic_Syllabic_Category=virama}', "");
Expect(1, 71350, '\p{Indic_Syllabic_Category:   __VIRAMA}', "");
Expect(0, 71350, '\p{^Indic_Syllabic_Category:   __VIRAMA}', "");
Expect(0, 71350, '\P{Indic_Syllabic_Category:   __VIRAMA}', "");
Expect(1, 71350, '\P{^Indic_Syllabic_Category:   __VIRAMA}', "");
Expect(0, 71351, '\p{Indic_Syllabic_Category:   __VIRAMA}', "");
Expect(1, 71351, '\p{^Indic_Syllabic_Category:   __VIRAMA}', "");
Expect(1, 71351, '\P{Indic_Syllabic_Category:   __VIRAMA}', "");
Expect(0, 71351, '\P{^Indic_Syllabic_Category:   __VIRAMA}', "");
Error('\p{InSC=:=VIRAMA}');
Error('\P{InSC=:=VIRAMA}');
Expect(1, 71350, '\p{InSC=virama}', "");
Expect(0, 71350, '\p{^InSC=virama}', "");
Expect(0, 71350, '\P{InSC=virama}', "");
Expect(1, 71350, '\P{^InSC=virama}', "");
Expect(0, 71351, '\p{InSC=virama}', "");
Expect(1, 71351, '\p{^InSC=virama}', "");
Expect(1, 71351, '\P{InSC=virama}', "");
Expect(0, 71351, '\P{^InSC=virama}', "");
Expect(1, 71350, '\p{InSC=	 Virama}', "");
Expect(0, 71350, '\p{^InSC=	 Virama}', "");
Expect(0, 71350, '\P{InSC=	 Virama}', "");
Expect(1, 71350, '\P{^InSC=	 Virama}', "");
Expect(0, 71351, '\p{InSC=	 Virama}', "");
Expect(1, 71351, '\p{^InSC=	 Virama}', "");
Expect(1, 71351, '\P{InSC=	 Virama}', "");
Expect(0, 71351, '\P{^InSC=	 Virama}', "");
Error('\p{Is_Indic_Syllabic_Category:	:=	-VIRAMA}');
Error('\P{Is_Indic_Syllabic_Category:	:=	-VIRAMA}');
Expect(1, 71350, '\p{Is_Indic_Syllabic_Category=virama}', "");
Expect(0, 71350, '\p{^Is_Indic_Syllabic_Category=virama}', "");
Expect(0, 71350, '\P{Is_Indic_Syllabic_Category=virama}', "");
Expect(1, 71350, '\P{^Is_Indic_Syllabic_Category=virama}', "");
Expect(0, 71351, '\p{Is_Indic_Syllabic_Category=virama}', "");
Expect(1, 71351, '\p{^Is_Indic_Syllabic_Category=virama}', "");
Expect(1, 71351, '\P{Is_Indic_Syllabic_Category=virama}', "");
Expect(0, 71351, '\P{^Is_Indic_Syllabic_Category=virama}', "");
Expect(1, 71350, '\p{Is_Indic_Syllabic_Category: Virama}', "");
Expect(0, 71350, '\p{^Is_Indic_Syllabic_Category: Virama}', "");
Expect(0, 71350, '\P{Is_Indic_Syllabic_Category: Virama}', "");
Expect(1, 71350, '\P{^Is_Indic_Syllabic_Category: Virama}', "");
Expect(0, 71351, '\p{Is_Indic_Syllabic_Category: Virama}', "");
Expect(1, 71351, '\p{^Is_Indic_Syllabic_Category: Virama}', "");
Expect(1, 71351, '\P{Is_Indic_Syllabic_Category: Virama}', "");
Expect(0, 71351, '\P{^Is_Indic_Syllabic_Category: Virama}', "");
Error('\p{Is_InSC= /a/VIRAMA}');
Error('\P{Is_InSC= /a/VIRAMA}');
Expect(1, 71350, '\p{Is_InSC: virama}', "");
Expect(0, 71350, '\p{^Is_InSC: virama}', "");
Expect(0, 71350, '\P{Is_InSC: virama}', "");
Expect(1, 71350, '\P{^Is_InSC: virama}', "");
Expect(0, 71351, '\p{Is_InSC: virama}', "");
Expect(1, 71351, '\p{^Is_InSC: virama}', "");
Expect(1, 71351, '\P{Is_InSC: virama}', "");
Expect(0, 71351, '\P{^Is_InSC: virama}', "");
Error('\p{Indic_Syllabic_Category: __Visarga/a/}');
Error('\P{Indic_Syllabic_Category: __Visarga/a/}');
Expect(1, 71340, '\p{Indic_Syllabic_Category:visarga}', "");
Expect(0, 71340, '\p{^Indic_Syllabic_Category:visarga}', "");
Expect(0, 71340, '\P{Indic_Syllabic_Category:visarga}', "");
Expect(1, 71340, '\P{^Indic_Syllabic_Category:visarga}', "");
Expect(0, 71341, '\p{Indic_Syllabic_Category:visarga}', "");
Expect(1, 71341, '\p{^Indic_Syllabic_Category:visarga}', "");
Expect(1, 71341, '\P{Indic_Syllabic_Category:visarga}', "");
Expect(0, 71341, '\P{^Indic_Syllabic_Category:visarga}', "");
Expect(1, 71340, '\p{Indic_Syllabic_Category=_	Visarga}', "");
Expect(0, 71340, '\p{^Indic_Syllabic_Category=_	Visarga}', "");
Expect(0, 71340, '\P{Indic_Syllabic_Category=_	Visarga}', "");
Expect(1, 71340, '\P{^Indic_Syllabic_Category=_	Visarga}', "");
Expect(0, 71341, '\p{Indic_Syllabic_Category=_	Visarga}', "");
Expect(1, 71341, '\p{^Indic_Syllabic_Category=_	Visarga}', "");
Expect(1, 71341, '\P{Indic_Syllabic_Category=_	Visarga}', "");
Expect(0, 71341, '\P{^Indic_Syllabic_Category=_	Visarga}', "");
Error('\p{InSC=/a/ 	visarga}');
Error('\P{InSC=/a/ 	visarga}');
Expect(1, 71340, '\p{InSC=visarga}', "");
Expect(0, 71340, '\p{^InSC=visarga}', "");
Expect(0, 71340, '\P{InSC=visarga}', "");
Expect(1, 71340, '\P{^InSC=visarga}', "");
Expect(0, 71341, '\p{InSC=visarga}', "");
Expect(1, 71341, '\p{^InSC=visarga}', "");
Expect(1, 71341, '\P{InSC=visarga}', "");
Expect(0, 71341, '\P{^InSC=visarga}', "");
Expect(1, 71340, '\p{InSC=_Visarga}', "");
Expect(0, 71340, '\p{^InSC=_Visarga}', "");
Expect(0, 71340, '\P{InSC=_Visarga}', "");
Expect(1, 71340, '\P{^InSC=_Visarga}', "");
Expect(0, 71341, '\p{InSC=_Visarga}', "");
Expect(1, 71341, '\p{^InSC=_Visarga}', "");
Expect(1, 71341, '\P{InSC=_Visarga}', "");
Expect(0, 71341, '\P{^InSC=_Visarga}', "");
Error('\p{Is_Indic_Syllabic_Category=	visarga:=}');
Error('\P{Is_Indic_Syllabic_Category=	visarga:=}');
Expect(1, 71340, '\p{Is_Indic_Syllabic_Category=visarga}', "");
Expect(0, 71340, '\p{^Is_Indic_Syllabic_Category=visarga}', "");
Expect(0, 71340, '\P{Is_Indic_Syllabic_Category=visarga}', "");
Expect(1, 71340, '\P{^Is_Indic_Syllabic_Category=visarga}', "");
Expect(0, 71341, '\p{Is_Indic_Syllabic_Category=visarga}', "");
Expect(1, 71341, '\p{^Is_Indic_Syllabic_Category=visarga}', "");
Expect(1, 71341, '\P{Is_Indic_Syllabic_Category=visarga}', "");
Expect(0, 71341, '\P{^Is_Indic_Syllabic_Category=visarga}', "");
Expect(1, 71340, '\p{Is_Indic_Syllabic_Category= _VISARGA}', "");
Expect(0, 71340, '\p{^Is_Indic_Syllabic_Category= _VISARGA}', "");
Expect(0, 71340, '\P{Is_Indic_Syllabic_Category= _VISARGA}', "");
Expect(1, 71340, '\P{^Is_Indic_Syllabic_Category= _VISARGA}', "");
Expect(0, 71341, '\p{Is_Indic_Syllabic_Category= _VISARGA}', "");
Expect(1, 71341, '\p{^Is_Indic_Syllabic_Category= _VISARGA}', "");
Expect(1, 71341, '\P{Is_Indic_Syllabic_Category= _VISARGA}', "");
Expect(0, 71341, '\P{^Is_Indic_Syllabic_Category= _VISARGA}', "");
Error('\p{Is_InSC=:=	 visarga}');
Error('\P{Is_InSC=:=	 visarga}');
Expect(1, 71340, '\p{Is_InSC=visarga}', "");
Expect(0, 71340, '\p{^Is_InSC=visarga}', "");
Expect(0, 71340, '\P{Is_InSC=visarga}', "");
Expect(1, 71340, '\P{^Is_InSC=visarga}', "");
Expect(0, 71341, '\p{Is_InSC=visarga}', "");
Expect(1, 71341, '\p{^Is_InSC=visarga}', "");
Expect(1, 71341, '\P{Is_InSC=visarga}', "");
Expect(0, 71341, '\P{^Is_InSC=visarga}', "");
Expect(1, 71340, '\p{Is_InSC=- Visarga}', "");
Expect(0, 71340, '\p{^Is_InSC=- Visarga}', "");
Expect(0, 71340, '\P{Is_InSC=- Visarga}', "");
Expect(1, 71340, '\P{^Is_InSC=- Visarga}', "");
Expect(0, 71341, '\p{Is_InSC=- Visarga}', "");
Expect(1, 71341, '\p{^Is_InSC=- Visarga}', "");
Expect(1, 71341, '\P{Is_InSC=- Visarga}', "");
Expect(0, 71341, '\P{^Is_InSC=- Visarga}', "");
Error('\p{Indic_Syllabic_Category: 	vowel:=}');
Error('\P{Indic_Syllabic_Category: 	vowel:=}');
Expect(1, 69972, '\p{Indic_Syllabic_Category=vowel}', "");
Expect(0, 69972, '\p{^Indic_Syllabic_Category=vowel}', "");
Expect(0, 69972, '\P{Indic_Syllabic_Category=vowel}', "");
Expect(1, 69972, '\P{^Indic_Syllabic_Category=vowel}', "");
Expect(0, 69973, '\p{Indic_Syllabic_Category=vowel}', "");
Expect(1, 69973, '\p{^Indic_Syllabic_Category=vowel}', "");
Expect(1, 69973, '\P{Indic_Syllabic_Category=vowel}', "");
Expect(0, 69973, '\P{^Indic_Syllabic_Category=vowel}', "");
Expect(1, 69972, '\p{Indic_Syllabic_Category=	vowel}', "");
Expect(0, 69972, '\p{^Indic_Syllabic_Category=	vowel}', "");
Expect(0, 69972, '\P{Indic_Syllabic_Category=	vowel}', "");
Expect(1, 69972, '\P{^Indic_Syllabic_Category=	vowel}', "");
Expect(0, 69973, '\p{Indic_Syllabic_Category=	vowel}', "");
Expect(1, 69973, '\p{^Indic_Syllabic_Category=	vowel}', "");
Expect(1, 69973, '\P{Indic_Syllabic_Category=	vowel}', "");
Expect(0, 69973, '\P{^Indic_Syllabic_Category=	vowel}', "");
Error('\p{InSC=	:=Vowel}');
Error('\P{InSC=	:=Vowel}');
Expect(1, 69972, '\p{InSC=vowel}', "");
Expect(0, 69972, '\p{^InSC=vowel}', "");
Expect(0, 69972, '\P{InSC=vowel}', "");
Expect(1, 69972, '\P{^InSC=vowel}', "");
Expect(0, 69973, '\p{InSC=vowel}', "");
Expect(1, 69973, '\p{^InSC=vowel}', "");
Expect(1, 69973, '\P{InSC=vowel}', "");
Expect(0, 69973, '\P{^InSC=vowel}', "");
Expect(1, 69972, '\p{InSC=	Vowel}', "");
Expect(0, 69972, '\p{^InSC=	Vowel}', "");
Expect(0, 69972, '\P{InSC=	Vowel}', "");
Expect(1, 69972, '\P{^InSC=	Vowel}', "");
Expect(0, 69973, '\p{InSC=	Vowel}', "");
Expect(1, 69973, '\p{^InSC=	Vowel}', "");
Expect(1, 69973, '\P{InSC=	Vowel}', "");
Expect(0, 69973, '\P{^InSC=	Vowel}', "");
Error('\p{Is_Indic_Syllabic_Category=:=	Vowel}');
Error('\P{Is_Indic_Syllabic_Category=:=	Vowel}');
Expect(1, 69972, '\p{Is_Indic_Syllabic_Category=vowel}', "");
Expect(0, 69972, '\p{^Is_Indic_Syllabic_Category=vowel}', "");
Expect(0, 69972, '\P{Is_Indic_Syllabic_Category=vowel}', "");
Expect(1, 69972, '\P{^Is_Indic_Syllabic_Category=vowel}', "");
Expect(0, 69973, '\p{Is_Indic_Syllabic_Category=vowel}', "");
Expect(1, 69973, '\p{^Is_Indic_Syllabic_Category=vowel}', "");
Expect(1, 69973, '\P{Is_Indic_Syllabic_Category=vowel}', "");
Expect(0, 69973, '\P{^Is_Indic_Syllabic_Category=vowel}', "");
Expect(1, 69972, '\p{Is_Indic_Syllabic_Category=	 Vowel}', "");
Expect(0, 69972, '\p{^Is_Indic_Syllabic_Category=	 Vowel}', "");
Expect(0, 69972, '\P{Is_Indic_Syllabic_Category=	 Vowel}', "");
Expect(1, 69972, '\P{^Is_Indic_Syllabic_Category=	 Vowel}', "");
Expect(0, 69973, '\p{Is_Indic_Syllabic_Category=	 Vowel}', "");
Expect(1, 69973, '\p{^Is_Indic_Syllabic_Category=	 Vowel}', "");
Expect(1, 69973, '\P{Is_Indic_Syllabic_Category=	 Vowel}', "");
Expect(0, 69973, '\P{^Is_Indic_Syllabic_Category=	 Vowel}', "");
Error('\p{Is_InSC=:=	 Vowel}');
Error('\P{Is_InSC=:=	 Vowel}');
Expect(1, 69972, '\p{Is_InSC=vowel}', "");
Expect(0, 69972, '\p{^Is_InSC=vowel}', "");
Expect(0, 69972, '\P{Is_InSC=vowel}', "");
Expect(1, 69972, '\P{^Is_InSC=vowel}', "");
Expect(0, 69973, '\p{Is_InSC=vowel}', "");
Expect(1, 69973, '\p{^Is_InSC=vowel}', "");
Expect(1, 69973, '\P{Is_InSC=vowel}', "");
Expect(0, 69973, '\P{^Is_InSC=vowel}', "");
Expect(1, 69972, '\p{Is_InSC=	Vowel}', "");
Expect(0, 69972, '\p{^Is_InSC=	Vowel}', "");
Expect(0, 69972, '\P{Is_InSC=	Vowel}', "");
Expect(1, 69972, '\P{^Is_InSC=	Vowel}', "");
Expect(0, 69973, '\p{Is_InSC=	Vowel}', "");
Expect(1, 69973, '\p{^Is_InSC=	Vowel}', "");
Expect(1, 69973, '\P{Is_InSC=	Vowel}', "");
Expect(0, 69973, '\P{^Is_InSC=	Vowel}', "");
Error('\p{Indic_Syllabic_Category=-	VOWEL_Dependent/a/}');
Error('\P{Indic_Syllabic_Category=-	VOWEL_Dependent/a/}');
Expect(1, 71466, '\p{Indic_Syllabic_Category=voweldependent}', "");
Expect(0, 71466, '\p{^Indic_Syllabic_Category=voweldependent}', "");
Expect(0, 71466, '\P{Indic_Syllabic_Category=voweldependent}', "");
Expect(1, 71466, '\P{^Indic_Syllabic_Category=voweldependent}', "");
Expect(0, 71467, '\p{Indic_Syllabic_Category=voweldependent}', "");
Expect(1, 71467, '\p{^Indic_Syllabic_Category=voweldependent}', "");
Expect(1, 71467, '\P{Indic_Syllabic_Category=voweldependent}', "");
Expect(0, 71467, '\P{^Indic_Syllabic_Category=voweldependent}', "");
Expect(1, 71466, '\p{Indic_Syllabic_Category= vowel_Dependent}', "");
Expect(0, 71466, '\p{^Indic_Syllabic_Category= vowel_Dependent}', "");
Expect(0, 71466, '\P{Indic_Syllabic_Category= vowel_Dependent}', "");
Expect(1, 71466, '\P{^Indic_Syllabic_Category= vowel_Dependent}', "");
Expect(0, 71467, '\p{Indic_Syllabic_Category= vowel_Dependent}', "");
Expect(1, 71467, '\p{^Indic_Syllabic_Category= vowel_Dependent}', "");
Expect(1, 71467, '\P{Indic_Syllabic_Category= vowel_Dependent}', "");
Expect(0, 71467, '\P{^Indic_Syllabic_Category= vowel_Dependent}', "");
Error('\p{InSC=-:=VOWEL_dependent}');
Error('\P{InSC=-:=VOWEL_dependent}');
Expect(1, 71466, '\p{InSC=voweldependent}', "");
Expect(0, 71466, '\p{^InSC=voweldependent}', "");
Expect(0, 71466, '\P{InSC=voweldependent}', "");
Expect(1, 71466, '\P{^InSC=voweldependent}', "");
Expect(0, 71467, '\p{InSC=voweldependent}', "");
Expect(1, 71467, '\p{^InSC=voweldependent}', "");
Expect(1, 71467, '\P{InSC=voweldependent}', "");
Expect(0, 71467, '\P{^InSC=voweldependent}', "");
Expect(1, 71466, '\p{InSC= VOWEL_Dependent}', "");
Expect(0, 71466, '\p{^InSC= VOWEL_Dependent}', "");
Expect(0, 71466, '\P{InSC= VOWEL_Dependent}', "");
Expect(1, 71466, '\P{^InSC= VOWEL_Dependent}', "");
Expect(0, 71467, '\p{InSC= VOWEL_Dependent}', "");
Expect(1, 71467, '\p{^InSC= VOWEL_Dependent}', "");
Expect(1, 71467, '\P{InSC= VOWEL_Dependent}', "");
Expect(0, 71467, '\P{^InSC= VOWEL_Dependent}', "");
Error('\p{Is_Indic_Syllabic_Category=/a/-_vowel_DEPENDENT}');
Error('\P{Is_Indic_Syllabic_Category=/a/-_vowel_DEPENDENT}');
Expect(1, 71466, '\p{Is_Indic_Syllabic_Category=voweldependent}', "");
Expect(0, 71466, '\p{^Is_Indic_Syllabic_Category=voweldependent}', "");
Expect(0, 71466, '\P{Is_Indic_Syllabic_Category=voweldependent}', "");
Expect(1, 71466, '\P{^Is_Indic_Syllabic_Category=voweldependent}', "");
Expect(0, 71467, '\p{Is_Indic_Syllabic_Category=voweldependent}', "");
Expect(1, 71467, '\p{^Is_Indic_Syllabic_Category=voweldependent}', "");
Expect(1, 71467, '\P{Is_Indic_Syllabic_Category=voweldependent}', "");
Expect(0, 71467, '\P{^Is_Indic_Syllabic_Category=voweldependent}', "");
Expect(1, 71466, '\p{Is_Indic_Syllabic_Category=_vowel_DEPENDENT}', "");
Expect(0, 71466, '\p{^Is_Indic_Syllabic_Category=_vowel_DEPENDENT}', "");
Expect(0, 71466, '\P{Is_Indic_Syllabic_Category=_vowel_DEPENDENT}', "");
Expect(1, 71466, '\P{^Is_Indic_Syllabic_Category=_vowel_DEPENDENT}', "");
Expect(0, 71467, '\p{Is_Indic_Syllabic_Category=_vowel_DEPENDENT}', "");
Expect(1, 71467, '\p{^Is_Indic_Syllabic_Category=_vowel_DEPENDENT}', "");
Expect(1, 71467, '\P{Is_Indic_Syllabic_Category=_vowel_DEPENDENT}', "");
Expect(0, 71467, '\P{^Is_Indic_Syllabic_Category=_vowel_DEPENDENT}', "");
Error('\p{Is_InSC: _	vowel_dependent:=}');
Error('\P{Is_InSC: _	vowel_dependent:=}');
Expect(1, 71466, '\p{Is_InSC=voweldependent}', "");
Expect(0, 71466, '\p{^Is_InSC=voweldependent}', "");
Expect(0, 71466, '\P{Is_InSC=voweldependent}', "");
Expect(1, 71466, '\P{^Is_InSC=voweldependent}', "");
Expect(0, 71467, '\p{Is_InSC=voweldependent}', "");
Expect(1, 71467, '\p{^Is_InSC=voweldependent}', "");
Expect(1, 71467, '\P{Is_InSC=voweldependent}', "");
Expect(0, 71467, '\P{^Is_InSC=voweldependent}', "");
Expect(1, 71466, '\p{Is_InSC=_Vowel_DEPENDENT}', "");
Expect(0, 71466, '\p{^Is_InSC=_Vowel_DEPENDENT}', "");
Expect(0, 71466, '\P{Is_InSC=_Vowel_DEPENDENT}', "");
Expect(1, 71466, '\P{^Is_InSC=_Vowel_DEPENDENT}', "");
Expect(0, 71467, '\p{Is_InSC=_Vowel_DEPENDENT}', "");
Expect(1, 71467, '\p{^Is_InSC=_Vowel_DEPENDENT}', "");
Expect(1, 71467, '\P{Is_InSC=_Vowel_DEPENDENT}', "");
Expect(0, 71467, '\P{^Is_InSC=_Vowel_DEPENDENT}', "");
Error('\p{Indic_Syllabic_Category=/a/-Vowel_INDEPENDENT}');
Error('\P{Indic_Syllabic_Category=/a/-Vowel_INDEPENDENT}');
Expect(1, 71305, '\p{Indic_Syllabic_Category=vowelindependent}', "");
Expect(0, 71305, '\p{^Indic_Syllabic_Category=vowelindependent}', "");
Expect(0, 71305, '\P{Indic_Syllabic_Category=vowelindependent}', "");
Expect(1, 71305, '\P{^Indic_Syllabic_Category=vowelindependent}', "");
Expect(0, 71306, '\p{Indic_Syllabic_Category=vowelindependent}', "");
Expect(1, 71306, '\p{^Indic_Syllabic_Category=vowelindependent}', "");
Expect(1, 71306, '\P{Indic_Syllabic_Category=vowelindependent}', "");
Expect(0, 71306, '\P{^Indic_Syllabic_Category=vowelindependent}', "");
Expect(1, 71305, '\p{Indic_Syllabic_Category=	 Vowel_Independent}', "");
Expect(0, 71305, '\p{^Indic_Syllabic_Category=	 Vowel_Independent}', "");
Expect(0, 71305, '\P{Indic_Syllabic_Category=	 Vowel_Independent}', "");
Expect(1, 71305, '\P{^Indic_Syllabic_Category=	 Vowel_Independent}', "");
Expect(0, 71306, '\p{Indic_Syllabic_Category=	 Vowel_Independent}', "");
Expect(1, 71306, '\p{^Indic_Syllabic_Category=	 Vowel_Independent}', "");
Expect(1, 71306, '\P{Indic_Syllabic_Category=	 Vowel_Independent}', "");
Expect(0, 71306, '\P{^Indic_Syllabic_Category=	 Vowel_Independent}', "");
Error('\p{InSC:   /a/_ Vowel_Independent}');
Error('\P{InSC:   /a/_ Vowel_Independent}');
Expect(1, 71305, '\p{InSC=vowelindependent}', "");
Expect(0, 71305, '\p{^InSC=vowelindependent}', "");
Expect(0, 71305, '\P{InSC=vowelindependent}', "");
Expect(1, 71305, '\P{^InSC=vowelindependent}', "");
Expect(0, 71306, '\p{InSC=vowelindependent}', "");
Expect(1, 71306, '\p{^InSC=vowelindependent}', "");
Expect(1, 71306, '\P{InSC=vowelindependent}', "");
Expect(0, 71306, '\P{^InSC=vowelindependent}', "");
Expect(1, 71305, '\p{InSC=  vowel_independent}', "");
Expect(0, 71305, '\p{^InSC=  vowel_independent}', "");
Expect(0, 71305, '\P{InSC=  vowel_independent}', "");
Expect(1, 71305, '\P{^InSC=  vowel_independent}', "");
Expect(0, 71306, '\p{InSC=  vowel_independent}', "");
Expect(1, 71306, '\p{^InSC=  vowel_independent}', "");
Expect(1, 71306, '\P{InSC=  vowel_independent}', "");
Expect(0, 71306, '\P{^InSC=  vowel_independent}', "");
Error('\p{Is_Indic_Syllabic_Category=:=_Vowel_Independent}');
Error('\P{Is_Indic_Syllabic_Category=:=_Vowel_Independent}');
Expect(1, 71305, '\p{Is_Indic_Syllabic_Category=vowelindependent}', "");
Expect(0, 71305, '\p{^Is_Indic_Syllabic_Category=vowelindependent}', "");
Expect(0, 71305, '\P{Is_Indic_Syllabic_Category=vowelindependent}', "");
Expect(1, 71305, '\P{^Is_Indic_Syllabic_Category=vowelindependent}', "");
Expect(0, 71306, '\p{Is_Indic_Syllabic_Category=vowelindependent}', "");
Expect(1, 71306, '\p{^Is_Indic_Syllabic_Category=vowelindependent}', "");
Expect(1, 71306, '\P{Is_Indic_Syllabic_Category=vowelindependent}', "");
Expect(0, 71306, '\P{^Is_Indic_Syllabic_Category=vowelindependent}', "");
Expect(1, 71305, '\p{Is_Indic_Syllabic_Category=VOWEL_Independent}', "");
Expect(0, 71305, '\p{^Is_Indic_Syllabic_Category=VOWEL_Independent}', "");
Expect(0, 71305, '\P{Is_Indic_Syllabic_Category=VOWEL_Independent}', "");
Expect(1, 71305, '\P{^Is_Indic_Syllabic_Category=VOWEL_Independent}', "");
Expect(0, 71306, '\p{Is_Indic_Syllabic_Category=VOWEL_Independent}', "");
Expect(1, 71306, '\p{^Is_Indic_Syllabic_Category=VOWEL_Independent}', "");
Expect(1, 71306, '\P{Is_Indic_Syllabic_Category=VOWEL_Independent}', "");
Expect(0, 71306, '\P{^Is_Indic_Syllabic_Category=VOWEL_Independent}', "");
Error('\p{Is_InSC=	/a/Vowel_INDEPENDENT}');
Error('\P{Is_InSC=	/a/Vowel_INDEPENDENT}');
Expect(1, 71305, '\p{Is_InSC=vowelindependent}', "");
Expect(0, 71305, '\p{^Is_InSC=vowelindependent}', "");
Expect(0, 71305, '\P{Is_InSC=vowelindependent}', "");
Expect(1, 71305, '\P{^Is_InSC=vowelindependent}', "");
Expect(0, 71306, '\p{Is_InSC=vowelindependent}', "");
Expect(1, 71306, '\p{^Is_InSC=vowelindependent}', "");
Expect(1, 71306, '\P{Is_InSC=vowelindependent}', "");
Expect(0, 71306, '\P{^Is_InSC=vowelindependent}', "");
Expect(1, 71305, '\p{Is_InSC:  	Vowel_INDEPENDENT}', "");
Expect(0, 71305, '\p{^Is_InSC:  	Vowel_INDEPENDENT}', "");
Expect(0, 71305, '\P{Is_InSC:  	Vowel_INDEPENDENT}', "");
Expect(1, 71305, '\P{^Is_InSC:  	Vowel_INDEPENDENT}', "");
Expect(0, 71306, '\p{Is_InSC:  	Vowel_INDEPENDENT}', "");
Expect(1, 71306, '\p{^Is_InSC:  	Vowel_INDEPENDENT}', "");
Expect(1, 71306, '\P{Is_InSC:  	Vowel_INDEPENDENT}', "");
Expect(0, 71306, '\P{^Is_InSC:  	Vowel_INDEPENDENT}', "");
Error('\p{Jamo_Short_Name=A}');
Error('\P{Jamo_Short_Name=A}');
Error('\p{JSN:   A}');
Error('\P{JSN:   A}');
Error('\p{Is_Jamo_Short_Name=A}');
Error('\P{Is_Jamo_Short_Name=A}');
Error('\p{Is_JSN=A}');
Error('\P{Is_JSN=A}');
Error('\p{Jamo_Short_Name=AE}');
Error('\P{Jamo_Short_Name=AE}');
Error('\p{JSN=AE}');
Error('\P{JSN=AE}');
Error('\p{Is_Jamo_Short_Name=AE}');
Error('\P{Is_Jamo_Short_Name=AE}');
Error('\p{Is_JSN:AE}');
Error('\P{Is_JSN:AE}');
Error('\p{Jamo_Short_Name: B}');
Error('\P{Jamo_Short_Name: B}');
Error('\p{JSN: B}');
Error('\P{JSN: B}');
Error('\p{Is_Jamo_Short_Name=B}');
Error('\P{Is_Jamo_Short_Name=B}');
Error('\p{Is_JSN=B}');
Error('\P{Is_JSN=B}');
Error('\p{Jamo_Short_Name=BB}');
Error('\P{Jamo_Short_Name=BB}');
Error('\p{JSN=BB}');
Error('\P{JSN=BB}');
Error('\p{Is_Jamo_Short_Name=BB}');
Error('\P{Is_Jamo_Short_Name=BB}');
Error('\p{Is_JSN=BB}');
Error('\P{Is_JSN=BB}');
Error('\p{Jamo_Short_Name=BS}');
Error('\P{Jamo_Short_Name=BS}');
Error('\p{JSN=BS}');
Error('\P{JSN=BS}');
Error('\p{Is_Jamo_Short_Name=BS}');
Error('\P{Is_Jamo_Short_Name=BS}');
Error('\p{Is_JSN=BS}');
Error('\P{Is_JSN=BS}');
Error('\p{Jamo_Short_Name=C}');
Error('\P{Jamo_Short_Name=C}');
Error('\p{JSN:	C}');
Error('\P{JSN:	C}');
Error('\p{Is_Jamo_Short_Name=C}');
Error('\P{Is_Jamo_Short_Name=C}');
Error('\p{Is_JSN=C}');
Error('\P{Is_JSN=C}');
Error('\p{Jamo_Short_Name=D}');
Error('\P{Jamo_Short_Name=D}');
Error('\p{JSN: D}');
Error('\P{JSN: D}');
Error('\p{Is_Jamo_Short_Name=D}');
Error('\P{Is_Jamo_Short_Name=D}');
Error('\p{Is_JSN=D}');
Error('\P{Is_JSN=D}');
Error('\p{Jamo_Short_Name=DD}');
Error('\P{Jamo_Short_Name=DD}');
Error('\p{JSN=DD}');
Error('\P{JSN=DD}');
Error('\p{Is_Jamo_Short_Name=DD}');
Error('\P{Is_Jamo_Short_Name=DD}');
Error('\p{Is_JSN=DD}');
Error('\P{Is_JSN=DD}');
Error('\p{Jamo_Short_Name=E}');
Error('\P{Jamo_Short_Name=E}');
Error('\p{JSN=E}');
Error('\P{JSN=E}');
Error('\p{Is_Jamo_Short_Name:	E}');
Error('\P{Is_Jamo_Short_Name:	E}');
Error('\p{Is_JSN=E}');
Error('\P{Is_JSN=E}');
Error('\p{Jamo_Short_Name=EO}');
Error('\P{Jamo_Short_Name=EO}');
Error('\p{JSN=EO}');
Error('\P{JSN=EO}');
Error('\p{Is_Jamo_Short_Name=EO}');
Error('\P{Is_Jamo_Short_Name=EO}');
Error('\p{Is_JSN=EO}');
Error('\P{Is_JSN=EO}');
Error('\p{Jamo_Short_Name=EU}');
Error('\P{Jamo_Short_Name=EU}');
Error('\p{JSN=EU}');
Error('\P{JSN=EU}');
Error('\p{Is_Jamo_Short_Name=EU}');
Error('\P{Is_Jamo_Short_Name=EU}');
Error('\p{Is_JSN=EU}');
Error('\P{Is_JSN=EU}');
Error('\p{Jamo_Short_Name=G}');
Error('\P{Jamo_Short_Name=G}');
Error('\p{JSN=G}');
Error('\P{JSN=G}');
Error('\p{Is_Jamo_Short_Name=G}');
Error('\P{Is_Jamo_Short_Name=G}');
Error('\p{Is_JSN=G}');
Error('\P{Is_JSN=G}');
Error('\p{Jamo_Short_Name=GG}');
Error('\P{Jamo_Short_Name=GG}');
Error('\p{JSN=GG}');
Error('\P{JSN=GG}');
Error('\p{Is_Jamo_Short_Name=GG}');
Error('\P{Is_Jamo_Short_Name=GG}');
Error('\p{Is_JSN=GG}');
Error('\P{Is_JSN=GG}');
Error('\p{Jamo_Short_Name=GS}');
Error('\P{Jamo_Short_Name=GS}');
Error('\p{JSN=GS}');
Error('\P{JSN=GS}');
Error('\p{Is_Jamo_Short_Name=GS}');
Error('\P{Is_Jamo_Short_Name=GS}');
Error('\p{Is_JSN=GS}');
Error('\P{Is_JSN=GS}');
Error('\p{Jamo_Short_Name=H}');
Error('\P{Jamo_Short_Name=H}');
Error('\p{JSN=H}');
Error('\P{JSN=H}');
Error('\p{Is_Jamo_Short_Name=H}');
Error('\P{Is_Jamo_Short_Name=H}');
Error('\p{Is_JSN=H}');
Error('\P{Is_JSN=H}');
Error('\p{Jamo_Short_Name=I}');
Error('\P{Jamo_Short_Name=I}');
Error('\p{JSN=I}');
Error('\P{JSN=I}');
Error('\p{Is_Jamo_Short_Name:	I}');
Error('\P{Is_Jamo_Short_Name:	I}');
Error('\p{Is_JSN=I}');
Error('\P{Is_JSN=I}');
Error('\p{Jamo_Short_Name=J}');
Error('\P{Jamo_Short_Name=J}');
Error('\p{JSN=J}');
Error('\P{JSN=J}');
Error('\p{Is_Jamo_Short_Name=J}');
Error('\P{Is_Jamo_Short_Name=J}');
Error('\p{Is_JSN=J}');
Error('\P{Is_JSN=J}');
Error('\p{Jamo_Short_Name=JJ}');
Error('\P{Jamo_Short_Name=JJ}');
Error('\p{JSN: JJ}');
Error('\P{JSN: JJ}');
Error('\p{Is_Jamo_Short_Name=JJ}');
Error('\P{Is_Jamo_Short_Name=JJ}');
Error('\p{Is_JSN=JJ}');
Error('\P{Is_JSN=JJ}');
Error('\p{Jamo_Short_Name: K}');
Error('\P{Jamo_Short_Name: K}');
Error('\p{JSN=K}');
Error('\P{JSN=K}');
Error('\p{Is_Jamo_Short_Name=K}');
Error('\P{Is_Jamo_Short_Name=K}');
Error('\p{Is_JSN=K}');
Error('\P{Is_JSN=K}');
Error('\p{Jamo_Short_Name=L}');
Error('\P{Jamo_Short_Name=L}');
Error('\p{JSN=L}');
Error('\P{JSN=L}');
Error('\p{Is_Jamo_Short_Name=L}');
Error('\P{Is_Jamo_Short_Name=L}');
Error('\p{Is_JSN=L}');
Error('\P{Is_JSN=L}');
Error('\p{Jamo_Short_Name=LB}');
Error('\P{Jamo_Short_Name=LB}');
Error('\p{JSN=LB}');
Error('\P{JSN=LB}');
Error('\p{Is_Jamo_Short_Name=LB}');
Error('\P{Is_Jamo_Short_Name=LB}');
Error('\p{Is_JSN=LB}');
Error('\P{Is_JSN=LB}');
Error('\p{Jamo_Short_Name=LG}');
Error('\P{Jamo_Short_Name=LG}');
Error('\p{JSN=LG}');
Error('\P{JSN=LG}');
Error('\p{Is_Jamo_Short_Name=LG}');
Error('\P{Is_Jamo_Short_Name=LG}');
Error('\p{Is_JSN=LG}');
Error('\P{Is_JSN=LG}');
Error('\p{Jamo_Short_Name=LH}');
Error('\P{Jamo_Short_Name=LH}');
Error('\p{JSN=LH}');
Error('\P{JSN=LH}');
Error('\p{Is_Jamo_Short_Name=LH}');
Error('\P{Is_Jamo_Short_Name=LH}');
Error('\p{Is_JSN=LH}');
Error('\P{Is_JSN=LH}');
Error('\p{Jamo_Short_Name=LM}');
Error('\P{Jamo_Short_Name=LM}');
Error('\p{JSN=LM}');
Error('\P{JSN=LM}');
Error('\p{Is_Jamo_Short_Name: LM}');
Error('\P{Is_Jamo_Short_Name: LM}');
Error('\p{Is_JSN=LM}');
Error('\P{Is_JSN=LM}');
Error('\p{Jamo_Short_Name=LP}');
Error('\P{Jamo_Short_Name=LP}');
Error('\p{JSN=LP}');
Error('\P{JSN=LP}');
Error('\p{Is_Jamo_Short_Name=LP}');
Error('\P{Is_Jamo_Short_Name=LP}');
Error('\p{Is_JSN: LP}');
Error('\P{Is_JSN: LP}');
Error('\p{Jamo_Short_Name=LS}');
Error('\P{Jamo_Short_Name=LS}');
Error('\p{JSN=LS}');
Error('\P{JSN=LS}');
Error('\p{Is_Jamo_Short_Name=LS}');
Error('\P{Is_Jamo_Short_Name=LS}');
Error('\p{Is_JSN=LS}');
Error('\P{Is_JSN=LS}');
Error('\p{Jamo_Short_Name=LT}');
Error('\P{Jamo_Short_Name=LT}');
Error('\p{JSN=LT}');
Error('\P{JSN=LT}');
Error('\p{Is_Jamo_Short_Name=LT}');
Error('\P{Is_Jamo_Short_Name=LT}');
Error('\p{Is_JSN=LT}');
Error('\P{Is_JSN=LT}');
Error('\p{Jamo_Short_Name=M}');
Error('\P{Jamo_Short_Name=M}');
Error('\p{JSN=M}');
Error('\P{JSN=M}');
Error('\p{Is_Jamo_Short_Name=M}');
Error('\P{Is_Jamo_Short_Name=M}');
Error('\p{Is_JSN=M}');
Error('\P{Is_JSN=M}');
Error('\p{Jamo_Short_Name=N}');
Error('\P{Jamo_Short_Name=N}');
Error('\p{JSN=N}');
Error('\P{JSN=N}');
Error('\p{Is_Jamo_Short_Name:N}');
Error('\P{Is_Jamo_Short_Name:N}');
Error('\p{Is_JSN=N}');
Error('\P{Is_JSN=N}');
Error('\p{Jamo_Short_Name=NG}');
Error('\P{Jamo_Short_Name=NG}');
Error('\p{JSN=NG}');
Error('\P{JSN=NG}');
Error('\p{Is_Jamo_Short_Name=NG}');
Error('\P{Is_Jamo_Short_Name=NG}');
Error('\p{Is_JSN=NG}');
Error('\P{Is_JSN=NG}');
Error('\p{Jamo_Short_Name=NH}');
Error('\P{Jamo_Short_Name=NH}');
Error('\p{JSN=NH}');
Error('\P{JSN=NH}');
Error('\p{Is_Jamo_Short_Name=NH}');
Error('\P{Is_Jamo_Short_Name=NH}');
Error('\p{Is_JSN=NH}');
Error('\P{Is_JSN=NH}');
Error('\p{Jamo_Short_Name=NJ}');
Error('\P{Jamo_Short_Name=NJ}');
Error('\p{JSN=NJ}');
Error('\P{JSN=NJ}');
Error('\p{Is_Jamo_Short_Name:NJ}');
Error('\P{Is_Jamo_Short_Name:NJ}');
Error('\p{Is_JSN=NJ}');
Error('\P{Is_JSN=NJ}');
Error('\p{Jamo_Short_Name=O}');
Error('\P{Jamo_Short_Name=O}');
Error('\p{JSN=O}');
Error('\P{JSN=O}');
Error('\p{Is_Jamo_Short_Name=O}');
Error('\P{Is_Jamo_Short_Name=O}');
Error('\p{Is_JSN=O}');
Error('\P{Is_JSN=O}');
Error('\p{Jamo_Short_Name: OE}');
Error('\P{Jamo_Short_Name: OE}');
Error('\p{JSN=OE}');
Error('\P{JSN=OE}');
Error('\p{Is_Jamo_Short_Name=OE}');
Error('\P{Is_Jamo_Short_Name=OE}');
Error('\p{Is_JSN=OE}');
Error('\P{Is_JSN=OE}');
Error('\p{Jamo_Short_Name=P}');
Error('\P{Jamo_Short_Name=P}');
Error('\p{JSN=P}');
Error('\P{JSN=P}');
Error('\p{Is_Jamo_Short_Name=P}');
Error('\P{Is_Jamo_Short_Name=P}');
Error('\p{Is_JSN=P}');
Error('\P{Is_JSN=P}');
Error('\p{Jamo_Short_Name=R}');
Error('\P{Jamo_Short_Name=R}');
Error('\p{JSN=R}');
Error('\P{JSN=R}');
Error('\p{Is_Jamo_Short_Name=R}');
Error('\P{Is_Jamo_Short_Name=R}');
Error('\p{Is_JSN=R}');
Error('\P{Is_JSN=R}');
Error('\p{Jamo_Short_Name=S}');
Error('\P{Jamo_Short_Name=S}');
Error('\p{JSN:S}');
Error('\P{JSN:S}');
Error('\p{Is_Jamo_Short_Name=S}');
Error('\P{Is_Jamo_Short_Name=S}');
Error('\p{Is_JSN=S}');
Error('\P{Is_JSN=S}');
Error('\p{Jamo_Short_Name=SS}');
Error('\P{Jamo_Short_Name=SS}');
Error('\p{JSN=SS}');
Error('\P{JSN=SS}');
Error('\p{Is_Jamo_Short_Name: SS}');
Error('\P{Is_Jamo_Short_Name: SS}');
Error('\p{Is_JSN: SS}');
Error('\P{Is_JSN: SS}');
Error('\p{Jamo_Short_Name:	T}');
Error('\P{Jamo_Short_Name:	T}');
Error('\p{JSN=T}');
Error('\P{JSN=T}');
Error('\p{Is_Jamo_Short_Name=T}');
Error('\P{Is_Jamo_Short_Name=T}');
Error('\p{Is_JSN=T}');
Error('\P{Is_JSN=T}');
Error('\p{Jamo_Short_Name=U}');
Error('\P{Jamo_Short_Name=U}');
Error('\p{JSN:U}');
Error('\P{JSN:U}');
Error('\p{Is_Jamo_Short_Name=U}');
Error('\P{Is_Jamo_Short_Name=U}');
Error('\p{Is_JSN=U}');
Error('\P{Is_JSN=U}');
Error('\p{Jamo_Short_Name=WA}');
Error('\P{Jamo_Short_Name=WA}');
Error('\p{JSN=WA}');
Error('\P{JSN=WA}');
Error('\p{Is_Jamo_Short_Name: WA}');
Error('\P{Is_Jamo_Short_Name: WA}');
Error('\p{Is_JSN=WA}');
Error('\P{Is_JSN=WA}');
Error('\p{Jamo_Short_Name=WAE}');
Error('\P{Jamo_Short_Name=WAE}');
Error('\p{JSN=WAE}');
Error('\P{JSN=WAE}');
Error('\p{Is_Jamo_Short_Name=WAE}');
Error('\P{Is_Jamo_Short_Name=WAE}');
Error('\p{Is_JSN=WAE}');
Error('\P{Is_JSN=WAE}');
Error('\p{Jamo_Short_Name:	WE}');
Error('\P{Jamo_Short_Name:	WE}');
Error('\p{JSN=WE}');
Error('\P{JSN=WE}');
Error('\p{Is_Jamo_Short_Name=WE}');
Error('\P{Is_Jamo_Short_Name=WE}');
Error('\p{Is_JSN=WE}');
Error('\P{Is_JSN=WE}');
Error('\p{Jamo_Short_Name=WEO}');
Error('\P{Jamo_Short_Name=WEO}');
Error('\p{JSN=WEO}');
Error('\P{JSN=WEO}');
Error('\p{Is_Jamo_Short_Name:   WEO}');
Error('\P{Is_Jamo_Short_Name:   WEO}');
Error('\p{Is_JSN=WEO}');
Error('\P{Is_JSN=WEO}');
Error('\p{Jamo_Short_Name=WI}');
Error('\P{Jamo_Short_Name=WI}');
Error('\p{JSN=WI}');
Error('\P{JSN=WI}');
Error('\p{Is_Jamo_Short_Name=WI}');
Error('\P{Is_Jamo_Short_Name=WI}');
Error('\p{Is_JSN=WI}');
Error('\P{Is_JSN=WI}');
Error('\p{Jamo_Short_Name=YA}');
Error('\P{Jamo_Short_Name=YA}');
Error('\p{JSN=YA}');
Error('\P{JSN=YA}');
Error('\p{Is_Jamo_Short_Name:   YA}');
Error('\P{Is_Jamo_Short_Name:   YA}');
Error('\p{Is_JSN=YA}');
Error('\P{Is_JSN=YA}');
Error('\p{Jamo_Short_Name=YAE}');
Error('\P{Jamo_Short_Name=YAE}');
Error('\p{JSN=YAE}');
Error('\P{JSN=YAE}');
Error('\p{Is_Jamo_Short_Name=YAE}');
Error('\P{Is_Jamo_Short_Name=YAE}');
Error('\p{Is_JSN=YAE}');
Error('\P{Is_JSN=YAE}');
Error('\p{Jamo_Short_Name=YE}');
Error('\P{Jamo_Short_Name=YE}');
Error('\p{JSN=YE}');
Error('\P{JSN=YE}');
Error('\p{Is_Jamo_Short_Name=YE}');
Error('\P{Is_Jamo_Short_Name=YE}');
Error('\p{Is_JSN=YE}');
Error('\P{Is_JSN=YE}');
Error('\p{Jamo_Short_Name=YEO}');
Error('\P{Jamo_Short_Name=YEO}');
Error('\p{JSN=YEO}');
Error('\P{JSN=YEO}');
Error('\p{Is_Jamo_Short_Name=YEO}');
Error('\P{Is_Jamo_Short_Name=YEO}');
Error('\p{Is_JSN=YEO}');
Error('\P{Is_JSN=YEO}');
Error('\p{Jamo_Short_Name=YI}');
Error('\P{Jamo_Short_Name=YI}');
Error('\p{JSN=YI}');
Error('\P{JSN=YI}');
Error('\p{Is_Jamo_Short_Name=YI}');
Error('\P{Is_Jamo_Short_Name=YI}');
Error('\p{Is_JSN=YI}');
Error('\P{Is_JSN=YI}');
Error('\p{Jamo_Short_Name=YO}');
Error('\P{Jamo_Short_Name=YO}');
Error('\p{JSN=YO}');
Error('\P{JSN=YO}');
Error('\p{Is_Jamo_Short_Name=YO}');
Error('\P{Is_Jamo_Short_Name=YO}');
Error('\p{Is_JSN=YO}');
Error('\P{Is_JSN=YO}');
Error('\p{Jamo_Short_Name=YU}');
Error('\P{Jamo_Short_Name=YU}');
Error('\p{JSN=YU}');
Error('\P{JSN=YU}');
Error('\p{Is_Jamo_Short_Name=YU}');
Error('\P{Is_Jamo_Short_Name=YU}');
Error('\p{Is_JSN=YU}');
Error('\P{Is_JSN=YU}');
Error('\p{Join_Control=_/a/no}');
Error('\P{Join_Control=_/a/no}');
Expect(1, 8206, '\p{Join_Control=no}', "");
Expect(0, 8206, '\p{^Join_Control=no}', "");
Expect(0, 8206, '\P{Join_Control=no}', "");
Expect(1, 8206, '\P{^Join_Control=no}', "");
Expect(0, 8205, '\p{Join_Control=no}', "");
Expect(1, 8205, '\p{^Join_Control=no}', "");
Expect(1, 8205, '\P{Join_Control=no}', "");
Expect(0, 8205, '\P{^Join_Control=no}', "");
Expect(1, 8206, '\p{Join_Control=		No}', "");
Expect(0, 8206, '\p{^Join_Control=		No}', "");
Expect(0, 8206, '\P{Join_Control=		No}', "");
Expect(1, 8206, '\P{^Join_Control=		No}', "");
Expect(0, 8205, '\p{Join_Control=		No}', "");
Expect(1, 8205, '\p{^Join_Control=		No}', "");
Expect(1, 8205, '\P{Join_Control=		No}', "");
Expect(0, 8205, '\P{^Join_Control=		No}', "");
Error('\p{Join_C=	/a/N}');
Error('\P{Join_C=	/a/N}');
Expect(1, 8206, '\p{Join_C: n}', "");
Expect(0, 8206, '\p{^Join_C: n}', "");
Expect(0, 8206, '\P{Join_C: n}', "");
Expect(1, 8206, '\P{^Join_C: n}', "");
Expect(0, 8205, '\p{Join_C: n}', "");
Expect(1, 8205, '\p{^Join_C: n}', "");
Expect(1, 8205, '\P{Join_C: n}', "");
Expect(0, 8205, '\P{^Join_C: n}', "");
Expect(1, 8206, '\p{Join_C=--N}', "");
Expect(0, 8206, '\p{^Join_C=--N}', "");
Expect(0, 8206, '\P{Join_C=--N}', "");
Expect(1, 8206, '\P{^Join_C=--N}', "");
Expect(0, 8205, '\p{Join_C=--N}', "");
Expect(1, 8205, '\p{^Join_C=--N}', "");
Expect(1, 8205, '\P{Join_C=--N}', "");
Expect(0, 8205, '\P{^Join_C=--N}', "");
Error('\p{Is_Join_Control= /a/F}');
Error('\P{Is_Join_Control= /a/F}');
Expect(1, 8206, '\p{Is_Join_Control=f}', "");
Expect(0, 8206, '\p{^Is_Join_Control=f}', "");
Expect(0, 8206, '\P{Is_Join_Control=f}', "");
Expect(1, 8206, '\P{^Is_Join_Control=f}', "");
Expect(0, 8205, '\p{Is_Join_Control=f}', "");
Expect(1, 8205, '\p{^Is_Join_Control=f}', "");
Expect(1, 8205, '\P{Is_Join_Control=f}', "");
Expect(0, 8205, '\P{^Is_Join_Control=f}', "");
Expect(1, 8206, '\p{Is_Join_Control=--F}', "");
Expect(0, 8206, '\p{^Is_Join_Control=--F}', "");
Expect(0, 8206, '\P{Is_Join_Control=--F}', "");
Expect(1, 8206, '\P{^Is_Join_Control=--F}', "");
Expect(0, 8205, '\p{Is_Join_Control=--F}', "");
Expect(1, 8205, '\p{^Is_Join_Control=--F}', "");
Expect(1, 8205, '\P{Is_Join_Control=--F}', "");
Expect(0, 8205, '\P{^Is_Join_Control=--F}', "");
Error('\p{Is_Join_C=/a/	_False}');
Error('\P{Is_Join_C=/a/	_False}');
Expect(1, 8206, '\p{Is_Join_C: false}', "");
Expect(0, 8206, '\p{^Is_Join_C: false}', "");
Expect(0, 8206, '\P{Is_Join_C: false}', "");
Expect(1, 8206, '\P{^Is_Join_C: false}', "");
Expect(0, 8205, '\p{Is_Join_C: false}', "");
Expect(1, 8205, '\p{^Is_Join_C: false}', "");
Expect(1, 8205, '\P{Is_Join_C: false}', "");
Expect(0, 8205, '\P{^Is_Join_C: false}', "");
Expect(1, 8206, '\p{Is_Join_C=- False}', "");
Expect(0, 8206, '\p{^Is_Join_C=- False}', "");
Expect(0, 8206, '\P{Is_Join_C=- False}', "");
Expect(1, 8206, '\P{^Is_Join_C=- False}', "");
Expect(0, 8205, '\p{Is_Join_C=- False}', "");
Expect(1, 8205, '\p{^Is_Join_C=- False}', "");
Expect(1, 8205, '\P{Is_Join_C=- False}', "");
Expect(0, 8205, '\P{^Is_Join_C=- False}', "");
Error('\p{Join_Control=-	Yes/a/}');
Error('\P{Join_Control=-	Yes/a/}');
Expect(1, 8205, '\p{Join_Control=yes}', "");
Expect(0, 8205, '\p{^Join_Control=yes}', "");
Expect(0, 8205, '\P{Join_Control=yes}', "");
Expect(1, 8205, '\P{^Join_Control=yes}', "");
Expect(0, 8206, '\p{Join_Control=yes}', "");
Expect(1, 8206, '\p{^Join_Control=yes}', "");
Expect(1, 8206, '\P{Join_Control=yes}', "");
Expect(0, 8206, '\P{^Join_Control=yes}', "");
Expect(1, 8205, '\p{Join_Control=	-yes}', "");
Expect(0, 8205, '\p{^Join_Control=	-yes}', "");
Expect(0, 8205, '\P{Join_Control=	-yes}', "");
Expect(1, 8205, '\P{^Join_Control=	-yes}', "");
Expect(0, 8206, '\p{Join_Control=	-yes}', "");
Expect(1, 8206, '\p{^Join_Control=	-yes}', "");
Expect(1, 8206, '\P{Join_Control=	-yes}', "");
Expect(0, 8206, '\P{^Join_Control=	-yes}', "");
Error('\p{Join_C=/a/ y}');
Error('\P{Join_C=/a/ y}');
Expect(1, 8205, '\p{Join_C=y}', "");
Expect(0, 8205, '\p{^Join_C=y}', "");
Expect(0, 8205, '\P{Join_C=y}', "");
Expect(1, 8205, '\P{^Join_C=y}', "");
Expect(0, 8206, '\p{Join_C=y}', "");
Expect(1, 8206, '\p{^Join_C=y}', "");
Expect(1, 8206, '\P{Join_C=y}', "");
Expect(0, 8206, '\P{^Join_C=y}', "");
Expect(1, 8205, '\p{Join_C=Y}', "");
Expect(0, 8205, '\p{^Join_C=Y}', "");
Expect(0, 8205, '\P{Join_C=Y}', "");
Expect(1, 8205, '\P{^Join_C=Y}', "");
Expect(0, 8206, '\p{Join_C=Y}', "");
Expect(1, 8206, '\p{^Join_C=Y}', "");
Expect(1, 8206, '\P{Join_C=Y}', "");
Expect(0, 8206, '\P{^Join_C=Y}', "");
Error('\p{Is_Join_Control=/a/ 	T}');
Error('\P{Is_Join_Control=/a/ 	T}');
Expect(1, 8205, '\p{Is_Join_Control=t}', "");
Expect(0, 8205, '\p{^Is_Join_Control=t}', "");
Expect(0, 8205, '\P{Is_Join_Control=t}', "");
Expect(1, 8205, '\P{^Is_Join_Control=t}', "");
Expect(0, 8206, '\p{Is_Join_Control=t}', "");
Expect(1, 8206, '\p{^Is_Join_Control=t}', "");
Expect(1, 8206, '\P{Is_Join_Control=t}', "");
Expect(0, 8206, '\P{^Is_Join_Control=t}', "");
Expect(1, 8205, '\p{Is_Join_Control=_T}', "");
Expect(0, 8205, '\p{^Is_Join_Control=_T}', "");
Expect(0, 8205, '\P{Is_Join_Control=_T}', "");
Expect(1, 8205, '\P{^Is_Join_Control=_T}', "");
Expect(0, 8206, '\p{Is_Join_Control=_T}', "");
Expect(1, 8206, '\p{^Is_Join_Control=_T}', "");
Expect(1, 8206, '\P{Is_Join_Control=_T}', "");
Expect(0, 8206, '\P{^Is_Join_Control=_T}', "");
Error('\p{Is_Join_C=	:=True}');
Error('\P{Is_Join_C=	:=True}');
Expect(1, 8205, '\p{Is_Join_C=true}', "");
Expect(0, 8205, '\p{^Is_Join_C=true}', "");
Expect(0, 8205, '\P{Is_Join_C=true}', "");
Expect(1, 8205, '\P{^Is_Join_C=true}', "");
Expect(0, 8206, '\p{Is_Join_C=true}', "");
Expect(1, 8206, '\p{^Is_Join_C=true}', "");
Expect(1, 8206, '\P{Is_Join_C=true}', "");
Expect(0, 8206, '\P{^Is_Join_C=true}', "");
Expect(1, 8205, '\p{Is_Join_C=-TRUE}', "");
Expect(0, 8205, '\p{^Is_Join_C=-TRUE}', "");
Expect(0, 8205, '\P{Is_Join_C=-TRUE}', "");
Expect(1, 8205, '\P{^Is_Join_C=-TRUE}', "");
Expect(0, 8206, '\p{Is_Join_C=-TRUE}', "");
Expect(1, 8206, '\p{^Is_Join_C=-TRUE}', "");
Expect(1, 8206, '\P{Is_Join_C=-TRUE}', "");
Expect(0, 8206, '\P{^Is_Join_C=-TRUE}', "");
Error('\p{Logical_Order_Exception=- no:=}');
Error('\P{Logical_Order_Exception=- no:=}');
Expect(1, 43709, '\p{Logical_Order_Exception=no}', "");
Expect(0, 43709, '\p{^Logical_Order_Exception=no}', "");
Expect(0, 43709, '\P{Logical_Order_Exception=no}', "");
Expect(1, 43709, '\P{^Logical_Order_Exception=no}', "");
Expect(0, 43708, '\p{Logical_Order_Exception=no}', "");
Expect(1, 43708, '\p{^Logical_Order_Exception=no}', "");
Expect(1, 43708, '\P{Logical_Order_Exception=no}', "");
Expect(0, 43708, '\P{^Logical_Order_Exception=no}', "");
Expect(1, 43709, '\p{Logical_Order_Exception=_-No}', "");
Expect(0, 43709, '\p{^Logical_Order_Exception=_-No}', "");
Expect(0, 43709, '\P{Logical_Order_Exception=_-No}', "");
Expect(1, 43709, '\P{^Logical_Order_Exception=_-No}', "");
Expect(0, 43708, '\p{Logical_Order_Exception=_-No}', "");
Expect(1, 43708, '\p{^Logical_Order_Exception=_-No}', "");
Expect(1, 43708, '\P{Logical_Order_Exception=_-No}', "");
Expect(0, 43708, '\P{^Logical_Order_Exception=_-No}', "");
Error('\p{LOE:  _N/a/}');
Error('\P{LOE:  _N/a/}');
Expect(1, 43709, '\p{LOE=n}', "");
Expect(0, 43709, '\p{^LOE=n}', "");
Expect(0, 43709, '\P{LOE=n}', "");
Expect(1, 43709, '\P{^LOE=n}', "");
Expect(0, 43708, '\p{LOE=n}', "");
Expect(1, 43708, '\p{^LOE=n}', "");
Expect(1, 43708, '\P{LOE=n}', "");
Expect(0, 43708, '\P{^LOE=n}', "");
Expect(1, 43709, '\p{LOE= n}', "");
Expect(0, 43709, '\p{^LOE= n}', "");
Expect(0, 43709, '\P{LOE= n}', "");
Expect(1, 43709, '\P{^LOE= n}', "");
Expect(0, 43708, '\p{LOE= n}', "");
Expect(1, 43708, '\p{^LOE= n}', "");
Expect(1, 43708, '\P{LOE= n}', "");
Expect(0, 43708, '\P{^LOE= n}', "");
Error('\p{Is_Logical_Order_Exception=_-f/a/}');
Error('\P{Is_Logical_Order_Exception=_-f/a/}');
Expect(1, 43709, '\p{Is_Logical_Order_Exception=f}', "");
Expect(0, 43709, '\p{^Is_Logical_Order_Exception=f}', "");
Expect(0, 43709, '\P{Is_Logical_Order_Exception=f}', "");
Expect(1, 43709, '\P{^Is_Logical_Order_Exception=f}', "");
Expect(0, 43708, '\p{Is_Logical_Order_Exception=f}', "");
Expect(1, 43708, '\p{^Is_Logical_Order_Exception=f}', "");
Expect(1, 43708, '\P{Is_Logical_Order_Exception=f}', "");
Expect(0, 43708, '\P{^Is_Logical_Order_Exception=f}', "");
Expect(1, 43709, '\p{Is_Logical_Order_Exception=	F}', "");
Expect(0, 43709, '\p{^Is_Logical_Order_Exception=	F}', "");
Expect(0, 43709, '\P{Is_Logical_Order_Exception=	F}', "");
Expect(1, 43709, '\P{^Is_Logical_Order_Exception=	F}', "");
Expect(0, 43708, '\p{Is_Logical_Order_Exception=	F}', "");
Expect(1, 43708, '\p{^Is_Logical_Order_Exception=	F}', "");
Expect(1, 43708, '\P{Is_Logical_Order_Exception=	F}', "");
Expect(0, 43708, '\P{^Is_Logical_Order_Exception=	F}', "");
Error('\p{Is_LOE=_ false:=}');
Error('\P{Is_LOE=_ false:=}');
Expect(1, 43709, '\p{Is_LOE=false}', "");
Expect(0, 43709, '\p{^Is_LOE=false}', "");
Expect(0, 43709, '\P{Is_LOE=false}', "");
Expect(1, 43709, '\P{^Is_LOE=false}', "");
Expect(0, 43708, '\p{Is_LOE=false}', "");
Expect(1, 43708, '\p{^Is_LOE=false}', "");
Expect(1, 43708, '\P{Is_LOE=false}', "");
Expect(0, 43708, '\P{^Is_LOE=false}', "");
Expect(1, 43709, '\p{Is_LOE=-False}', "");
Expect(0, 43709, '\p{^Is_LOE=-False}', "");
Expect(0, 43709, '\P{Is_LOE=-False}', "");
Expect(1, 43709, '\P{^Is_LOE=-False}', "");
Expect(0, 43708, '\p{Is_LOE=-False}', "");
Expect(1, 43708, '\p{^Is_LOE=-False}', "");
Expect(1, 43708, '\P{Is_LOE=-False}', "");
Expect(0, 43708, '\P{^Is_LOE=-False}', "");
Error('\p{Logical_Order_Exception: -/a/yes}');
Error('\P{Logical_Order_Exception: -/a/yes}');
Expect(1, 43708, '\p{Logical_Order_Exception: yes}', "");
Expect(0, 43708, '\p{^Logical_Order_Exception: yes}', "");
Expect(0, 43708, '\P{Logical_Order_Exception: yes}', "");
Expect(1, 43708, '\P{^Logical_Order_Exception: yes}', "");
Expect(0, 43709, '\p{Logical_Order_Exception: yes}', "");
Expect(1, 43709, '\p{^Logical_Order_Exception: yes}', "");
Expect(1, 43709, '\P{Logical_Order_Exception: yes}', "");
Expect(0, 43709, '\P{^Logical_Order_Exception: yes}', "");
Expect(1, 43708, '\p{Logical_Order_Exception=_YES}', "");
Expect(0, 43708, '\p{^Logical_Order_Exception=_YES}', "");
Expect(0, 43708, '\P{Logical_Order_Exception=_YES}', "");
Expect(1, 43708, '\P{^Logical_Order_Exception=_YES}', "");
Expect(0, 43709, '\p{Logical_Order_Exception=_YES}', "");
Expect(1, 43709, '\p{^Logical_Order_Exception=_YES}', "");
Expect(1, 43709, '\P{Logical_Order_Exception=_YES}', "");
Expect(0, 43709, '\P{^Logical_Order_Exception=_YES}', "");
Error('\p{LOE:	/a/-	Y}');
Error('\P{LOE:	/a/-	Y}');
Expect(1, 43708, '\p{LOE=y}', "");
Expect(0, 43708, '\p{^LOE=y}', "");
Expect(0, 43708, '\P{LOE=y}', "");
Expect(1, 43708, '\P{^LOE=y}', "");
Expect(0, 43709, '\p{LOE=y}', "");
Expect(1, 43709, '\p{^LOE=y}', "");
Expect(1, 43709, '\P{LOE=y}', "");
Expect(0, 43709, '\P{^LOE=y}', "");
Expect(1, 43708, '\p{LOE= 	Y}', "");
Expect(0, 43708, '\p{^LOE= 	Y}', "");
Expect(0, 43708, '\P{LOE= 	Y}', "");
Expect(1, 43708, '\P{^LOE= 	Y}', "");
Expect(0, 43709, '\p{LOE= 	Y}', "");
Expect(1, 43709, '\p{^LOE= 	Y}', "");
Expect(1, 43709, '\P{LOE= 	Y}', "");
Expect(0, 43709, '\P{^LOE= 	Y}', "");
Error('\p{Is_Logical_Order_Exception=-/a/t}');
Error('\P{Is_Logical_Order_Exception=-/a/t}');
Expect(1, 43708, '\p{Is_Logical_Order_Exception=t}', "");
Expect(0, 43708, '\p{^Is_Logical_Order_Exception=t}', "");
Expect(0, 43708, '\P{Is_Logical_Order_Exception=t}', "");
Expect(1, 43708, '\P{^Is_Logical_Order_Exception=t}', "");
Expect(0, 43709, '\p{Is_Logical_Order_Exception=t}', "");
Expect(1, 43709, '\p{^Is_Logical_Order_Exception=t}', "");
Expect(1, 43709, '\P{Is_Logical_Order_Exception=t}', "");
Expect(0, 43709, '\P{^Is_Logical_Order_Exception=t}', "");
Expect(1, 43708, '\p{Is_Logical_Order_Exception=_T}', "");
Expect(0, 43708, '\p{^Is_Logical_Order_Exception=_T}', "");
Expect(0, 43708, '\P{Is_Logical_Order_Exception=_T}', "");
Expect(1, 43708, '\P{^Is_Logical_Order_Exception=_T}', "");
Expect(0, 43709, '\p{Is_Logical_Order_Exception=_T}', "");
Expect(1, 43709, '\p{^Is_Logical_Order_Exception=_T}', "");
Expect(1, 43709, '\P{Is_Logical_Order_Exception=_T}', "");
Expect(0, 43709, '\P{^Is_Logical_Order_Exception=_T}', "");
Error('\p{Is_LOE=:=-	True}');
Error('\P{Is_LOE=:=-	True}');
Expect(1, 43708, '\p{Is_LOE=true}', "");
Expect(0, 43708, '\p{^Is_LOE=true}', "");
Expect(0, 43708, '\P{Is_LOE=true}', "");
Expect(1, 43708, '\P{^Is_LOE=true}', "");
Expect(0, 43709, '\p{Is_LOE=true}', "");
Expect(1, 43709, '\p{^Is_LOE=true}', "");
Expect(1, 43709, '\P{Is_LOE=true}', "");
Expect(0, 43709, '\P{^Is_LOE=true}', "");
Expect(1, 43708, '\p{Is_LOE= 	TRUE}', "");
Expect(0, 43708, '\p{^Is_LOE= 	TRUE}', "");
Expect(0, 43708, '\P{Is_LOE= 	TRUE}', "");
Expect(1, 43708, '\P{^Is_LOE= 	TRUE}', "");
Expect(0, 43709, '\p{Is_LOE= 	TRUE}', "");
Expect(1, 43709, '\p{^Is_LOE= 	TRUE}', "");
Expect(1, 43709, '\P{Is_LOE= 	TRUE}', "");
Expect(0, 43709, '\P{^Is_LOE= 	TRUE}', "");
Error('\p{Lowercase=_:=no}');
Error('\P{Lowercase=_:=no}');
Expect(1, 120780, '\p{Lowercase=no}', "");
Expect(0, 120780, '\p{^Lowercase=no}', "");
Expect(0, 120780, '\P{Lowercase=no}', "");
Expect(1, 120780, '\P{^Lowercase=no}', "");
Expect(0, 120779, '\p{Lowercase=no}', "");
Expect(1, 120779, '\p{^Lowercase=no}', "");
Expect(1, 120779, '\P{Lowercase=no}', "");
Expect(0, 120779, '\P{^Lowercase=no}', "");
Expect(1, 120780, '\p{Lowercase:_	NO}', "");
Expect(0, 120780, '\p{^Lowercase:_	NO}', "");
Expect(0, 120780, '\P{Lowercase:_	NO}', "");
Expect(1, 120780, '\P{^Lowercase:_	NO}', "");
Expect(0, 120779, '\p{Lowercase:_	NO}', "");
Expect(1, 120779, '\p{^Lowercase:_	NO}', "");
Expect(1, 120779, '\P{Lowercase:_	NO}', "");
Expect(0, 120779, '\P{^Lowercase:_	NO}', "");
Error('\p{Lower:		:=N}');
Error('\P{Lower:		:=N}');
Expect(1, 120780, '\p{Lower:   n}', "");
Expect(0, 120780, '\p{^Lower:   n}', "");
Expect(0, 120780, '\P{Lower:   n}', "");
Expect(1, 120780, '\P{^Lower:   n}', "");
Expect(0, 120779, '\p{Lower:   n}', "");
Expect(1, 120779, '\p{^Lower:   n}', "");
Expect(1, 120779, '\P{Lower:   n}', "");
Expect(0, 120779, '\P{^Lower:   n}', "");
Expect(1, 120780, '\p{Lower:    -N}', "");
Expect(0, 120780, '\p{^Lower:    -N}', "");
Expect(0, 120780, '\P{Lower:    -N}', "");
Expect(1, 120780, '\P{^Lower:    -N}', "");
Expect(0, 120779, '\p{Lower:    -N}', "");
Expect(1, 120779, '\p{^Lower:    -N}', "");
Expect(1, 120779, '\P{Lower:    -N}', "");
Expect(0, 120779, '\P{^Lower:    -N}', "");
Error('\p{Is_Lowercase: :=	 F}');
Error('\P{Is_Lowercase: :=	 F}');
Expect(1, 120780, '\p{Is_Lowercase: f}', "");
Expect(0, 120780, '\p{^Is_Lowercase: f}', "");
Expect(0, 120780, '\P{Is_Lowercase: f}', "");
Expect(1, 120780, '\P{^Is_Lowercase: f}', "");
Expect(0, 120779, '\p{Is_Lowercase: f}', "");
Expect(1, 120779, '\p{^Is_Lowercase: f}', "");
Expect(1, 120779, '\P{Is_Lowercase: f}', "");
Expect(0, 120779, '\P{^Is_Lowercase: f}', "");
Expect(1, 120780, '\p{Is_Lowercase=_	F}', "");
Expect(0, 120780, '\p{^Is_Lowercase=_	F}', "");
Expect(0, 120780, '\P{Is_Lowercase=_	F}', "");
Expect(1, 120780, '\P{^Is_Lowercase=_	F}', "");
Expect(0, 120779, '\p{Is_Lowercase=_	F}', "");
Expect(1, 120779, '\p{^Is_Lowercase=_	F}', "");
Expect(1, 120779, '\P{Is_Lowercase=_	F}', "");
Expect(0, 120779, '\P{^Is_Lowercase=_	F}', "");
Error('\p{Is_Lower=:=--false}');
Error('\P{Is_Lower=:=--false}');
Expect(1, 120780, '\p{Is_Lower=false}', "");
Expect(0, 120780, '\p{^Is_Lower=false}', "");
Expect(0, 120780, '\P{Is_Lower=false}', "");
Expect(1, 120780, '\P{^Is_Lower=false}', "");
Expect(0, 120779, '\p{Is_Lower=false}', "");
Expect(1, 120779, '\p{^Is_Lower=false}', "");
Expect(1, 120779, '\P{Is_Lower=false}', "");
Expect(0, 120779, '\P{^Is_Lower=false}', "");
Expect(1, 120780, '\p{Is_Lower:   	False}', "");
Expect(0, 120780, '\p{^Is_Lower:   	False}', "");
Expect(0, 120780, '\P{Is_Lower:   	False}', "");
Expect(1, 120780, '\P{^Is_Lower:   	False}', "");
Expect(0, 120779, '\p{Is_Lower:   	False}', "");
Expect(1, 120779, '\p{^Is_Lower:   	False}', "");
Expect(1, 120779, '\P{Is_Lower:   	False}', "");
Expect(0, 120779, '\P{^Is_Lower:   	False}', "");
Error('\p{Lowercase=	_Yes:=}');
Error('\P{Lowercase=	_Yes:=}');
Expect(1, 120779, '\p{Lowercase=yes}', "");
Expect(0, 120779, '\p{^Lowercase=yes}', "");
Expect(0, 120779, '\P{Lowercase=yes}', "");
Expect(1, 120779, '\P{^Lowercase=yes}', "");
Expect(0, 120780, '\p{Lowercase=yes}', "");
Expect(1, 120780, '\p{^Lowercase=yes}', "");
Expect(1, 120780, '\P{Lowercase=yes}', "");
Expect(0, 120780, '\P{^Lowercase=yes}', "");
Expect(1, 120779, '\p{Lowercase=		yes}', "");
Expect(0, 120779, '\p{^Lowercase=		yes}', "");
Expect(0, 120779, '\P{Lowercase=		yes}', "");
Expect(1, 120779, '\P{^Lowercase=		yes}', "");
Expect(0, 120780, '\p{Lowercase=		yes}', "");
Expect(1, 120780, '\p{^Lowercase=		yes}', "");
Expect(1, 120780, '\P{Lowercase=		yes}', "");
Expect(0, 120780, '\P{^Lowercase=		yes}', "");
Error('\p{Lower=	:=Y}');
Error('\P{Lower=	:=Y}');
Expect(1, 120779, '\p{Lower=y}', "");
Expect(0, 120779, '\p{^Lower=y}', "");
Expect(0, 120779, '\P{Lower=y}', "");
Expect(1, 120779, '\P{^Lower=y}', "");
Expect(0, 120780, '\p{Lower=y}', "");
Expect(1, 120780, '\p{^Lower=y}', "");
Expect(1, 120780, '\P{Lower=y}', "");
Expect(0, 120780, '\P{^Lower=y}', "");
Expect(1, 120779, '\p{Lower=-y}', "");
Expect(0, 120779, '\p{^Lower=-y}', "");
Expect(0, 120779, '\P{Lower=-y}', "");
Expect(1, 120779, '\P{^Lower=-y}', "");
Expect(0, 120780, '\p{Lower=-y}', "");
Expect(1, 120780, '\p{^Lower=-y}', "");
Expect(1, 120780, '\P{Lower=-y}', "");
Expect(0, 120780, '\P{^Lower=-y}', "");
Error('\p{Is_Lowercase=	:=T}');
Error('\P{Is_Lowercase=	:=T}');
Expect(1, 120779, '\p{Is_Lowercase:t}', "");
Expect(0, 120779, '\p{^Is_Lowercase:t}', "");
Expect(0, 120779, '\P{Is_Lowercase:t}', "");
Expect(1, 120779, '\P{^Is_Lowercase:t}', "");
Expect(0, 120780, '\p{Is_Lowercase:t}', "");
Expect(1, 120780, '\p{^Is_Lowercase:t}', "");
Expect(1, 120780, '\P{Is_Lowercase:t}', "");
Expect(0, 120780, '\P{^Is_Lowercase:t}', "");
Expect(1, 120779, '\p{Is_Lowercase= _T}', "");
Expect(0, 120779, '\p{^Is_Lowercase= _T}', "");
Expect(0, 120779, '\P{Is_Lowercase= _T}', "");
Expect(1, 120779, '\P{^Is_Lowercase= _T}', "");
Expect(0, 120780, '\p{Is_Lowercase= _T}', "");
Expect(1, 120780, '\p{^Is_Lowercase= _T}', "");
Expect(1, 120780, '\P{Is_Lowercase= _T}', "");
Expect(0, 120780, '\P{^Is_Lowercase= _T}', "");
Error('\p{Is_Lower:  /a/true}');
Error('\P{Is_Lower:  /a/true}');
Expect(1, 120779, '\p{Is_Lower=true}', "");
Expect(0, 120779, '\p{^Is_Lower=true}', "");
Expect(0, 120779, '\P{Is_Lower=true}', "");
Expect(1, 120779, '\P{^Is_Lower=true}', "");
Expect(0, 120780, '\p{Is_Lower=true}', "");
Expect(1, 120780, '\p{^Is_Lower=true}', "");
Expect(1, 120780, '\P{Is_Lower=true}', "");
Expect(0, 120780, '\P{^Is_Lower=true}', "");
Expect(1, 120779, '\p{Is_Lower=-	true}', "");
Expect(0, 120779, '\p{^Is_Lower=-	true}', "");
Expect(0, 120779, '\P{Is_Lower=-	true}', "");
Expect(1, 120779, '\P{^Is_Lower=-	true}', "");
Expect(0, 120780, '\p{Is_Lower=-	true}', "");
Expect(1, 120780, '\p{^Is_Lower=-	true}', "");
Expect(1, 120780, '\P{Is_Lower=-	true}', "");
Expect(0, 120780, '\P{^Is_Lower=-	true}', "");
Error('\p{Math=:=__No}');
Error('\P{Math=:=__No}');
Expect(1, 126706, '\p{Math=no}', "");
Expect(0, 126706, '\p{^Math=no}', "");
Expect(0, 126706, '\P{Math=no}', "");
Expect(1, 126706, '\P{^Math=no}', "");
Expect(0, 126705, '\p{Math=no}', "");
Expect(1, 126705, '\p{^Math=no}', "");
Expect(1, 126705, '\P{Math=no}', "");
Expect(0, 126705, '\P{^Math=no}', "");
Expect(1, 126706, '\p{Math=-	NO}', "");
Expect(0, 126706, '\p{^Math=-	NO}', "");
Expect(0, 126706, '\P{Math=-	NO}', "");
Expect(1, 126706, '\P{^Math=-	NO}', "");
Expect(0, 126705, '\p{Math=-	NO}', "");
Expect(1, 126705, '\p{^Math=-	NO}', "");
Expect(1, 126705, '\P{Math=-	NO}', "");
Expect(0, 126705, '\P{^Math=-	NO}', "");
Error('\p{Is_Math= _N/a/}');
Error('\P{Is_Math= _N/a/}');
Expect(1, 126706, '\p{Is_Math:	n}', "");
Expect(0, 126706, '\p{^Is_Math:	n}', "");
Expect(0, 126706, '\P{Is_Math:	n}', "");
Expect(1, 126706, '\P{^Is_Math:	n}', "");
Expect(0, 126705, '\p{Is_Math:	n}', "");
Expect(1, 126705, '\p{^Is_Math:	n}', "");
Expect(1, 126705, '\P{Is_Math:	n}', "");
Expect(0, 126705, '\P{^Is_Math:	n}', "");
Expect(1, 126706, '\p{Is_Math=	-n}', "");
Expect(0, 126706, '\p{^Is_Math=	-n}', "");
Expect(0, 126706, '\P{Is_Math=	-n}', "");
Expect(1, 126706, '\P{^Is_Math=	-n}', "");
Expect(0, 126705, '\p{Is_Math=	-n}', "");
Expect(1, 126705, '\p{^Is_Math=	-n}', "");
Expect(1, 126705, '\P{Is_Math=	-n}', "");
Expect(0, 126705, '\P{^Is_Math=	-n}', "");
Error('\p{Math:  _F/a/}');
Error('\P{Math:  _F/a/}');
Expect(1, 126706, '\p{Math=f}', "");
Expect(0, 126706, '\p{^Math=f}', "");
Expect(0, 126706, '\P{Math=f}', "");
Expect(1, 126706, '\P{^Math=f}', "");
Expect(0, 126705, '\p{Math=f}', "");
Expect(1, 126705, '\p{^Math=f}', "");
Expect(1, 126705, '\P{Math=f}', "");
Expect(0, 126705, '\P{^Math=f}', "");
Expect(1, 126706, '\p{Math=- F}', "");
Expect(0, 126706, '\p{^Math=- F}', "");
Expect(0, 126706, '\P{Math=- F}', "");
Expect(1, 126706, '\P{^Math=- F}', "");
Expect(0, 126705, '\p{Math=- F}', "");
Expect(1, 126705, '\p{^Math=- F}', "");
Expect(1, 126705, '\P{Math=- F}', "");
Expect(0, 126705, '\P{^Math=- F}', "");
Error('\p{Is_Math=--False/a/}');
Error('\P{Is_Math=--False/a/}');
Expect(1, 126706, '\p{Is_Math=false}', "");
Expect(0, 126706, '\p{^Is_Math=false}', "");
Expect(0, 126706, '\P{Is_Math=false}', "");
Expect(1, 126706, '\P{^Is_Math=false}', "");
Expect(0, 126705, '\p{Is_Math=false}', "");
Expect(1, 126705, '\p{^Is_Math=false}', "");
Expect(1, 126705, '\P{Is_Math=false}', "");
Expect(0, 126705, '\P{^Is_Math=false}', "");
Expect(1, 126706, '\p{Is_Math:   	FALSE}', "");
Expect(0, 126706, '\p{^Is_Math:   	FALSE}', "");
Expect(0, 126706, '\P{Is_Math:   	FALSE}', "");
Expect(1, 126706, '\P{^Is_Math:   	FALSE}', "");
Expect(0, 126705, '\p{Is_Math:   	FALSE}', "");
Expect(1, 126705, '\p{^Is_Math:   	FALSE}', "");
Expect(1, 126705, '\P{Is_Math:   	FALSE}', "");
Expect(0, 126705, '\P{^Is_Math:   	FALSE}', "");
Error('\p{Math=-:=yes}');
Error('\P{Math=-:=yes}');
Expect(1, 126705, '\p{Math=yes}', "");
Expect(0, 126705, '\p{^Math=yes}', "");
Expect(0, 126705, '\P{Math=yes}', "");
Expect(1, 126705, '\P{^Math=yes}', "");
Expect(0, 126706, '\p{Math=yes}', "");
Expect(1, 126706, '\p{^Math=yes}', "");
Expect(1, 126706, '\P{Math=yes}', "");
Expect(0, 126706, '\P{^Math=yes}', "");
Expect(1, 126705, '\p{Math=- yes}', "");
Expect(0, 126705, '\p{^Math=- yes}', "");
Expect(0, 126705, '\P{Math=- yes}', "");
Expect(1, 126705, '\P{^Math=- yes}', "");
Expect(0, 126706, '\p{Math=- yes}', "");
Expect(1, 126706, '\p{^Math=- yes}', "");
Expect(1, 126706, '\P{Math=- yes}', "");
Expect(0, 126706, '\P{^Math=- yes}', "");
Error('\p{Is_Math=:= -Y}');
Error('\P{Is_Math=:= -Y}');
Expect(1, 126705, '\p{Is_Math=y}', "");
Expect(0, 126705, '\p{^Is_Math=y}', "");
Expect(0, 126705, '\P{Is_Math=y}', "");
Expect(1, 126705, '\P{^Is_Math=y}', "");
Expect(0, 126706, '\p{Is_Math=y}', "");
Expect(1, 126706, '\p{^Is_Math=y}', "");
Expect(1, 126706, '\P{Is_Math=y}', "");
Expect(0, 126706, '\P{^Is_Math=y}', "");
Expect(1, 126705, '\p{Is_Math=_	Y}', "");
Expect(0, 126705, '\p{^Is_Math=_	Y}', "");
Expect(0, 126705, '\P{Is_Math=_	Y}', "");
Expect(1, 126705, '\P{^Is_Math=_	Y}', "");
Expect(0, 126706, '\p{Is_Math=_	Y}', "");
Expect(1, 126706, '\p{^Is_Math=_	Y}', "");
Expect(1, 126706, '\P{Is_Math=_	Y}', "");
Expect(0, 126706, '\P{^Is_Math=_	Y}', "");
Error('\p{Math=:= _T}');
Error('\P{Math=:= _T}');
Expect(1, 126705, '\p{Math=t}', "");
Expect(0, 126705, '\p{^Math=t}', "");
Expect(0, 126705, '\P{Math=t}', "");
Expect(1, 126705, '\P{^Math=t}', "");
Expect(0, 126706, '\p{Math=t}', "");
Expect(1, 126706, '\p{^Math=t}', "");
Expect(1, 126706, '\P{Math=t}', "");
Expect(0, 126706, '\P{^Math=t}', "");
Expect(1, 126705, '\p{Math=_T}', "");
Expect(0, 126705, '\p{^Math=_T}', "");
Expect(0, 126705, '\P{Math=_T}', "");
Expect(1, 126705, '\P{^Math=_T}', "");
Expect(0, 126706, '\p{Math=_T}', "");
Expect(1, 126706, '\p{^Math=_T}', "");
Expect(1, 126706, '\P{Math=_T}', "");
Expect(0, 126706, '\P{^Math=_T}', "");
Error('\p{Is_Math:/a/		True}');
Error('\P{Is_Math:/a/		True}');
Expect(1, 126705, '\p{Is_Math=true}', "");
Expect(0, 126705, '\p{^Is_Math=true}', "");
Expect(0, 126705, '\P{Is_Math=true}', "");
Expect(1, 126705, '\P{^Is_Math=true}', "");
Expect(0, 126706, '\p{Is_Math=true}', "");
Expect(1, 126706, '\p{^Is_Math=true}', "");
Expect(1, 126706, '\P{Is_Math=true}', "");
Expect(0, 126706, '\P{^Is_Math=true}', "");
Expect(1, 126705, '\p{Is_Math=-_TRUE}', "");
Expect(0, 126705, '\p{^Is_Math=-_TRUE}', "");
Expect(0, 126705, '\P{Is_Math=-_TRUE}', "");
Expect(1, 126705, '\P{^Is_Math=-_TRUE}', "");
Expect(0, 126706, '\p{Is_Math=-_TRUE}', "");
Expect(1, 126706, '\p{^Is_Math=-_TRUE}', "");
Expect(1, 126706, '\P{Is_Math=-_TRUE}', "");
Expect(0, 126706, '\P{^Is_Math=-_TRUE}', "");
Error('\p{Noncharacter_Code_Point=_No/a/}');
Error('\P{Noncharacter_Code_Point=_No/a/}');
Expect(1, 1114109, '\p{Noncharacter_Code_Point=no}', "");
Expect(0, 1114109, '\p{^Noncharacter_Code_Point=no}', "");
Expect(0, 1114109, '\P{Noncharacter_Code_Point=no}', "");
Expect(1, 1114109, '\P{^Noncharacter_Code_Point=no}', "");
Expect(0, 1114111, '\p{Noncharacter_Code_Point=no}', "");
Expect(1, 1114111, '\p{^Noncharacter_Code_Point=no}', "");
Expect(1, 1114111, '\P{Noncharacter_Code_Point=no}', "");
Expect(0, 1114111, '\P{^Noncharacter_Code_Point=no}', "");
Expect(1, 1114109, '\p{Noncharacter_Code_Point:   -_NO}', "");
Expect(0, 1114109, '\p{^Noncharacter_Code_Point:   -_NO}', "");
Expect(0, 1114109, '\P{Noncharacter_Code_Point:   -_NO}', "");
Expect(1, 1114109, '\P{^Noncharacter_Code_Point:   -_NO}', "");
Expect(0, 1114111, '\p{Noncharacter_Code_Point:   -_NO}', "");
Expect(1, 1114111, '\p{^Noncharacter_Code_Point:   -_NO}', "");
Expect(1, 1114111, '\P{Noncharacter_Code_Point:   -_NO}', "");
Expect(0, 1114111, '\P{^Noncharacter_Code_Point:   -_NO}', "");
Error('\p{NChar= :=N}');
Error('\P{NChar= :=N}');
Expect(1, 1114109, '\p{NChar: n}', "");
Expect(0, 1114109, '\p{^NChar: n}', "");
Expect(0, 1114109, '\P{NChar: n}', "");
Expect(1, 1114109, '\P{^NChar: n}', "");
Expect(0, 1114111, '\p{NChar: n}', "");
Expect(1, 1114111, '\p{^NChar: n}', "");
Expect(1, 1114111, '\P{NChar: n}', "");
Expect(0, 1114111, '\P{^NChar: n}', "");
Expect(1, 1114109, '\p{NChar=--N}', "");
Expect(0, 1114109, '\p{^NChar=--N}', "");
Expect(0, 1114109, '\P{NChar=--N}', "");
Expect(1, 1114109, '\P{^NChar=--N}', "");
Expect(0, 1114111, '\p{NChar=--N}', "");
Expect(1, 1114111, '\p{^NChar=--N}', "");
Expect(1, 1114111, '\P{NChar=--N}', "");
Expect(0, 1114111, '\P{^NChar=--N}', "");
Error('\p{Is_Noncharacter_Code_Point=/a/-f}');
Error('\P{Is_Noncharacter_Code_Point=/a/-f}');
Expect(1, 1114109, '\p{Is_Noncharacter_Code_Point=f}', "");
Expect(0, 1114109, '\p{^Is_Noncharacter_Code_Point=f}', "");
Expect(0, 1114109, '\P{Is_Noncharacter_Code_Point=f}', "");
Expect(1, 1114109, '\P{^Is_Noncharacter_Code_Point=f}', "");
Expect(0, 1114111, '\p{Is_Noncharacter_Code_Point=f}', "");
Expect(1, 1114111, '\p{^Is_Noncharacter_Code_Point=f}', "");
Expect(1, 1114111, '\P{Is_Noncharacter_Code_Point=f}', "");
Expect(0, 1114111, '\P{^Is_Noncharacter_Code_Point=f}', "");
Expect(1, 1114109, '\p{Is_Noncharacter_Code_Point:__F}', "");
Expect(0, 1114109, '\p{^Is_Noncharacter_Code_Point:__F}', "");
Expect(0, 1114109, '\P{Is_Noncharacter_Code_Point:__F}', "");
Expect(1, 1114109, '\P{^Is_Noncharacter_Code_Point:__F}', "");
Expect(0, 1114111, '\p{Is_Noncharacter_Code_Point:__F}', "");
Expect(1, 1114111, '\p{^Is_Noncharacter_Code_Point:__F}', "");
Expect(1, 1114111, '\P{Is_Noncharacter_Code_Point:__F}', "");
Expect(0, 1114111, '\P{^Is_Noncharacter_Code_Point:__F}', "");
Error('\p{Is_NChar=/a/False}');
Error('\P{Is_NChar=/a/False}');
Expect(1, 1114109, '\p{Is_NChar=false}', "");
Expect(0, 1114109, '\p{^Is_NChar=false}', "");
Expect(0, 1114109, '\P{Is_NChar=false}', "");
Expect(1, 1114109, '\P{^Is_NChar=false}', "");
Expect(0, 1114111, '\p{Is_NChar=false}', "");
Expect(1, 1114111, '\p{^Is_NChar=false}', "");
Expect(1, 1114111, '\P{Is_NChar=false}', "");
Expect(0, 1114111, '\P{^Is_NChar=false}', "");
Expect(1, 1114109, '\p{Is_NChar= 	False}', "");
Expect(0, 1114109, '\p{^Is_NChar= 	False}', "");
Expect(0, 1114109, '\P{Is_NChar= 	False}', "");
Expect(1, 1114109, '\P{^Is_NChar= 	False}', "");
Expect(0, 1114111, '\p{Is_NChar= 	False}', "");
Expect(1, 1114111, '\p{^Is_NChar= 	False}', "");
Expect(1, 1114111, '\P{Is_NChar= 	False}', "");
Expect(0, 1114111, '\P{^Is_NChar= 	False}', "");
Error('\p{Noncharacter_Code_Point=:=- YES}');
Error('\P{Noncharacter_Code_Point=:=- YES}');
Expect(1, 1114111, '\p{Noncharacter_Code_Point=yes}', "");
Expect(0, 1114111, '\p{^Noncharacter_Code_Point=yes}', "");
Expect(0, 1114111, '\P{Noncharacter_Code_Point=yes}', "");
Expect(1, 1114111, '\P{^Noncharacter_Code_Point=yes}', "");
Expect(0, 1114109, '\p{Noncharacter_Code_Point=yes}', "");
Expect(1, 1114109, '\p{^Noncharacter_Code_Point=yes}', "");
Expect(1, 1114109, '\P{Noncharacter_Code_Point=yes}', "");
Expect(0, 1114109, '\P{^Noncharacter_Code_Point=yes}', "");
Expect(1, 1114111, '\p{Noncharacter_Code_Point=	_yes}', "");
Expect(0, 1114111, '\p{^Noncharacter_Code_Point=	_yes}', "");
Expect(0, 1114111, '\P{Noncharacter_Code_Point=	_yes}', "");
Expect(1, 1114111, '\P{^Noncharacter_Code_Point=	_yes}', "");
Expect(0, 1114109, '\p{Noncharacter_Code_Point=	_yes}', "");
Expect(1, 1114109, '\p{^Noncharacter_Code_Point=	_yes}', "");
Expect(1, 1114109, '\P{Noncharacter_Code_Point=	_yes}', "");
Expect(0, 1114109, '\P{^Noncharacter_Code_Point=	_yes}', "");
Error('\p{NChar=/a/_ y}');
Error('\P{NChar=/a/_ y}');
Expect(1, 1114111, '\p{NChar=y}', "");
Expect(0, 1114111, '\p{^NChar=y}', "");
Expect(0, 1114111, '\P{NChar=y}', "");
Expect(1, 1114111, '\P{^NChar=y}', "");
Expect(0, 1114109, '\p{NChar=y}', "");
Expect(1, 1114109, '\p{^NChar=y}', "");
Expect(1, 1114109, '\P{NChar=y}', "");
Expect(0, 1114109, '\P{^NChar=y}', "");
Expect(1, 1114111, '\p{NChar=	_Y}', "");
Expect(0, 1114111, '\p{^NChar=	_Y}', "");
Expect(0, 1114111, '\P{NChar=	_Y}', "");
Expect(1, 1114111, '\P{^NChar=	_Y}', "");
Expect(0, 1114109, '\p{NChar=	_Y}', "");
Expect(1, 1114109, '\p{^NChar=	_Y}', "");
Expect(1, 1114109, '\P{NChar=	_Y}', "");
Expect(0, 1114109, '\P{^NChar=	_Y}', "");
Error('\p{Is_Noncharacter_Code_Point=:=T}');
Error('\P{Is_Noncharacter_Code_Point=:=T}');
Expect(1, 1114111, '\p{Is_Noncharacter_Code_Point=t}', "");
Expect(0, 1114111, '\p{^Is_Noncharacter_Code_Point=t}', "");
Expect(0, 1114111, '\P{Is_Noncharacter_Code_Point=t}', "");
Expect(1, 1114111, '\P{^Is_Noncharacter_Code_Point=t}', "");
Expect(0, 1114109, '\p{Is_Noncharacter_Code_Point=t}', "");
Expect(1, 1114109, '\p{^Is_Noncharacter_Code_Point=t}', "");
Expect(1, 1114109, '\P{Is_Noncharacter_Code_Point=t}', "");
Expect(0, 1114109, '\P{^Is_Noncharacter_Code_Point=t}', "");
Expect(1, 1114111, '\p{Is_Noncharacter_Code_Point= -T}', "");
Expect(0, 1114111, '\p{^Is_Noncharacter_Code_Point= -T}', "");
Expect(0, 1114111, '\P{Is_Noncharacter_Code_Point= -T}', "");
Expect(1, 1114111, '\P{^Is_Noncharacter_Code_Point= -T}', "");
Expect(0, 1114109, '\p{Is_Noncharacter_Code_Point= -T}', "");
Expect(1, 1114109, '\p{^Is_Noncharacter_Code_Point= -T}', "");
Expect(1, 1114109, '\P{Is_Noncharacter_Code_Point= -T}', "");
Expect(0, 1114109, '\P{^Is_Noncharacter_Code_Point= -T}', "");
Error('\p{Is_NChar=:= TRUE}');
Error('\P{Is_NChar=:= TRUE}');
Expect(1, 1114111, '\p{Is_NChar=true}', "");
Expect(0, 1114111, '\p{^Is_NChar=true}', "");
Expect(0, 1114111, '\P{Is_NChar=true}', "");
Expect(1, 1114111, '\P{^Is_NChar=true}', "");
Expect(0, 1114109, '\p{Is_NChar=true}', "");
Expect(1, 1114109, '\p{^Is_NChar=true}', "");
Expect(1, 1114109, '\P{Is_NChar=true}', "");
Expect(0, 1114109, '\P{^Is_NChar=true}', "");
Expect(1, 1114111, '\p{Is_NChar=  TRUE}', "");
Expect(0, 1114111, '\p{^Is_NChar=  TRUE}', "");
Expect(0, 1114111, '\P{Is_NChar=  TRUE}', "");
Expect(1, 1114111, '\P{^Is_NChar=  TRUE}', "");
Expect(0, 1114109, '\p{Is_NChar=  TRUE}', "");
Expect(1, 1114109, '\p{^Is_NChar=  TRUE}', "");
Expect(1, 1114109, '\P{Is_NChar=  TRUE}', "");
Expect(0, 1114109, '\P{^Is_NChar=  TRUE}', "");
Error('\p{NFC_Quick_Check= MAYBE/a/}');
Error('\P{NFC_Quick_Check= MAYBE/a/}');
Expect(1, 71087, '\p{NFC_Quick_Check=maybe}', "");
Expect(0, 71087, '\p{^NFC_Quick_Check=maybe}', "");
Expect(0, 71087, '\P{NFC_Quick_Check=maybe}', "");
Expect(1, 71087, '\P{^NFC_Quick_Check=maybe}', "");
Expect(0, 71088, '\p{NFC_Quick_Check=maybe}', "");
Expect(1, 71088, '\p{^NFC_Quick_Check=maybe}', "");
Expect(1, 71088, '\P{NFC_Quick_Check=maybe}', "");
Expect(0, 71088, '\P{^NFC_Quick_Check=maybe}', "");
Expect(1, 71087, '\p{NFC_Quick_Check=-	maybe}', "");
Expect(0, 71087, '\p{^NFC_Quick_Check=-	maybe}', "");
Expect(0, 71087, '\P{NFC_Quick_Check=-	maybe}', "");
Expect(1, 71087, '\P{^NFC_Quick_Check=-	maybe}', "");
Expect(0, 71088, '\p{NFC_Quick_Check=-	maybe}', "");
Expect(1, 71088, '\p{^NFC_Quick_Check=-	maybe}', "");
Expect(1, 71088, '\P{NFC_Quick_Check=-	maybe}', "");
Expect(0, 71088, '\P{^NFC_Quick_Check=-	maybe}', "");
Error('\p{NFC_QC=:=_M}');
Error('\P{NFC_QC=:=_M}');
Expect(1, 71087, '\p{NFC_QC=m}', "");
Expect(0, 71087, '\p{^NFC_QC=m}', "");
Expect(0, 71087, '\P{NFC_QC=m}', "");
Expect(1, 71087, '\P{^NFC_QC=m}', "");
Expect(0, 71088, '\p{NFC_QC=m}', "");
Expect(1, 71088, '\p{^NFC_QC=m}', "");
Expect(1, 71088, '\P{NFC_QC=m}', "");
Expect(0, 71088, '\P{^NFC_QC=m}', "");
Expect(1, 71087, '\p{NFC_QC=__M}', "");
Expect(0, 71087, '\p{^NFC_QC=__M}', "");
Expect(0, 71087, '\P{NFC_QC=__M}', "");
Expect(1, 71087, '\P{^NFC_QC=__M}', "");
Expect(0, 71088, '\p{NFC_QC=__M}', "");
Expect(1, 71088, '\p{^NFC_QC=__M}', "");
Expect(1, 71088, '\P{NFC_QC=__M}', "");
Expect(0, 71088, '\P{^NFC_QC=__M}', "");
Error('\p{Is_NFC_Quick_Check:   _/a/MAYBE}');
Error('\P{Is_NFC_Quick_Check:   _/a/MAYBE}');
Expect(1, 71087, '\p{Is_NFC_Quick_Check=maybe}', "");
Expect(0, 71087, '\p{^Is_NFC_Quick_Check=maybe}', "");
Expect(0, 71087, '\P{Is_NFC_Quick_Check=maybe}', "");
Expect(1, 71087, '\P{^Is_NFC_Quick_Check=maybe}', "");
Expect(0, 71088, '\p{Is_NFC_Quick_Check=maybe}', "");
Expect(1, 71088, '\p{^Is_NFC_Quick_Check=maybe}', "");
Expect(1, 71088, '\P{Is_NFC_Quick_Check=maybe}', "");
Expect(0, 71088, '\P{^Is_NFC_Quick_Check=maybe}', "");
Expect(1, 71087, '\p{Is_NFC_Quick_Check= _maybe}', "");
Expect(0, 71087, '\p{^Is_NFC_Quick_Check= _maybe}', "");
Expect(0, 71087, '\P{Is_NFC_Quick_Check= _maybe}', "");
Expect(1, 71087, '\P{^Is_NFC_Quick_Check= _maybe}', "");
Expect(0, 71088, '\p{Is_NFC_Quick_Check= _maybe}', "");
Expect(1, 71088, '\p{^Is_NFC_Quick_Check= _maybe}', "");
Expect(1, 71088, '\P{Is_NFC_Quick_Check= _maybe}', "");
Expect(0, 71088, '\P{^Is_NFC_Quick_Check= _maybe}', "");
Error('\p{Is_NFC_QC=/a/M}');
Error('\P{Is_NFC_QC=/a/M}');
Expect(1, 71087, '\p{Is_NFC_QC=m}', "");
Expect(0, 71087, '\p{^Is_NFC_QC=m}', "");
Expect(0, 71087, '\P{Is_NFC_QC=m}', "");
Expect(1, 71087, '\P{^Is_NFC_QC=m}', "");
Expect(0, 71088, '\p{Is_NFC_QC=m}', "");
Expect(1, 71088, '\p{^Is_NFC_QC=m}', "");
Expect(1, 71088, '\P{Is_NFC_QC=m}', "");
Expect(0, 71088, '\P{^Is_NFC_QC=m}', "");
Expect(1, 71087, '\p{Is_NFC_QC=	_M}', "");
Expect(0, 71087, '\p{^Is_NFC_QC=	_M}', "");
Expect(0, 71087, '\P{Is_NFC_QC=	_M}', "");
Expect(1, 71087, '\P{^Is_NFC_QC=	_M}', "");
Expect(0, 71088, '\p{Is_NFC_QC=	_M}', "");
Expect(1, 71088, '\p{^Is_NFC_QC=	_M}', "");
Expect(1, 71088, '\P{Is_NFC_QC=	_M}', "");
Expect(0, 71088, '\P{^Is_NFC_QC=	_M}', "");
Error('\p{NFC_Quick_Check:   :=	-No}');
Error('\P{NFC_Quick_Check:   :=	-No}');
Expect(1, 195101, '\p{NFC_Quick_Check:no}', "");
Expect(0, 195101, '\p{^NFC_Quick_Check:no}', "");
Expect(0, 195101, '\P{NFC_Quick_Check:no}', "");
Expect(1, 195101, '\P{^NFC_Quick_Check:no}', "");
Expect(0, 195102, '\p{NFC_Quick_Check:no}', "");
Expect(1, 195102, '\p{^NFC_Quick_Check:no}', "");
Expect(1, 195102, '\P{NFC_Quick_Check:no}', "");
Expect(0, 195102, '\P{^NFC_Quick_Check:no}', "");
Expect(1, 195101, '\p{NFC_Quick_Check= NO}', "");
Expect(0, 195101, '\p{^NFC_Quick_Check= NO}', "");
Expect(0, 195101, '\P{NFC_Quick_Check= NO}', "");
Expect(1, 195101, '\P{^NFC_Quick_Check= NO}', "");
Expect(0, 195102, '\p{NFC_Quick_Check= NO}', "");
Expect(1, 195102, '\p{^NFC_Quick_Check= NO}', "");
Expect(1, 195102, '\P{NFC_Quick_Check= NO}', "");
Expect(0, 195102, '\P{^NFC_Quick_Check= NO}', "");
Error('\p{NFC_QC:	 N/a/}');
Error('\P{NFC_QC:	 N/a/}');
Expect(1, 195101, '\p{NFC_QC=n}', "");
Expect(0, 195101, '\p{^NFC_QC=n}', "");
Expect(0, 195101, '\P{NFC_QC=n}', "");
Expect(1, 195101, '\P{^NFC_QC=n}', "");
Expect(0, 195102, '\p{NFC_QC=n}', "");
Expect(1, 195102, '\p{^NFC_QC=n}', "");
Expect(1, 195102, '\P{NFC_QC=n}', "");
Expect(0, 195102, '\P{^NFC_QC=n}', "");
Error('\p{Is_NFC_Quick_Check=-:=no}');
Error('\P{Is_NFC_Quick_Check=-:=no}');
Expect(1, 195101, '\p{Is_NFC_Quick_Check=no}', "");
Expect(0, 195101, '\p{^Is_NFC_Quick_Check=no}', "");
Expect(0, 195101, '\P{Is_NFC_Quick_Check=no}', "");
Expect(1, 195101, '\P{^Is_NFC_Quick_Check=no}', "");
Expect(0, 195102, '\p{Is_NFC_Quick_Check=no}', "");
Expect(1, 195102, '\p{^Is_NFC_Quick_Check=no}', "");
Expect(1, 195102, '\P{Is_NFC_Quick_Check=no}', "");
Expect(0, 195102, '\P{^Is_NFC_Quick_Check=no}', "");
Expect(1, 195101, '\p{Is_NFC_Quick_Check=	NO}', "");
Expect(0, 195101, '\p{^Is_NFC_Quick_Check=	NO}', "");
Expect(0, 195101, '\P{Is_NFC_Quick_Check=	NO}', "");
Expect(1, 195101, '\P{^Is_NFC_Quick_Check=	NO}', "");
Expect(0, 195102, '\p{Is_NFC_Quick_Check=	NO}', "");
Expect(1, 195102, '\p{^Is_NFC_Quick_Check=	NO}', "");
Expect(1, 195102, '\P{Is_NFC_Quick_Check=	NO}', "");
Expect(0, 195102, '\P{^Is_NFC_Quick_Check=	NO}', "");
Error('\p{Is_NFC_QC= -n:=}');
Error('\P{Is_NFC_QC= -n:=}');
Expect(1, 195101, '\p{Is_NFC_QC=n}', "");
Expect(0, 195101, '\p{^Is_NFC_QC=n}', "");
Expect(0, 195101, '\P{Is_NFC_QC=n}', "");
Expect(1, 195101, '\P{^Is_NFC_QC=n}', "");
Expect(0, 195102, '\p{Is_NFC_QC=n}', "");
Expect(1, 195102, '\p{^Is_NFC_QC=n}', "");
Expect(1, 195102, '\P{Is_NFC_QC=n}', "");
Expect(0, 195102, '\P{^Is_NFC_QC=n}', "");
Expect(1, 195101, '\p{Is_NFC_QC=N}', "");
Expect(0, 195101, '\p{^Is_NFC_QC=N}', "");
Expect(0, 195101, '\P{Is_NFC_QC=N}', "");
Expect(1, 195101, '\P{^Is_NFC_QC=N}', "");
Expect(0, 195102, '\p{Is_NFC_QC=N}', "");
Expect(1, 195102, '\p{^Is_NFC_QC=N}', "");
Expect(1, 195102, '\P{Is_NFC_QC=N}', "");
Expect(0, 195102, '\P{^Is_NFC_QC=N}', "");
Error('\p{NFC_Quick_Check= :=Yes}');
Error('\P{NFC_Quick_Check= :=Yes}');
Expect(1, 195102, '\p{NFC_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^NFC_Quick_Check=yes}', "");
Expect(0, 195102, '\P{NFC_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^NFC_Quick_Check=yes}', "");
Expect(0, 195101, '\p{NFC_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^NFC_Quick_Check=yes}', "");
Expect(1, 195101, '\P{NFC_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^NFC_Quick_Check=yes}', "");
Expect(1, 195102, '\p{NFC_Quick_Check:_-Yes}', "");
Expect(0, 195102, '\p{^NFC_Quick_Check:_-Yes}', "");
Expect(0, 195102, '\P{NFC_Quick_Check:_-Yes}', "");
Expect(1, 195102, '\P{^NFC_Quick_Check:_-Yes}', "");
Expect(0, 195101, '\p{NFC_Quick_Check:_-Yes}', "");
Expect(1, 195101, '\p{^NFC_Quick_Check:_-Yes}', "");
Expect(1, 195101, '\P{NFC_Quick_Check:_-Yes}', "");
Expect(0, 195101, '\P{^NFC_Quick_Check:_-Yes}', "");
Error('\p{NFC_QC:_ y/a/}');
Error('\P{NFC_QC:_ y/a/}');
Expect(1, 195102, '\p{NFC_QC=y}', "");
Expect(0, 195102, '\p{^NFC_QC=y}', "");
Expect(0, 195102, '\P{NFC_QC=y}', "");
Expect(1, 195102, '\P{^NFC_QC=y}', "");
Expect(0, 195101, '\p{NFC_QC=y}', "");
Expect(1, 195101, '\p{^NFC_QC=y}', "");
Expect(1, 195101, '\P{NFC_QC=y}', "");
Expect(0, 195101, '\P{^NFC_QC=y}', "");
Expect(1, 195102, '\p{NFC_QC=_ Y}', "");
Expect(0, 195102, '\p{^NFC_QC=_ Y}', "");
Expect(0, 195102, '\P{NFC_QC=_ Y}', "");
Expect(1, 195102, '\P{^NFC_QC=_ Y}', "");
Expect(0, 195101, '\p{NFC_QC=_ Y}', "");
Expect(1, 195101, '\p{^NFC_QC=_ Y}', "");
Expect(1, 195101, '\P{NFC_QC=_ Y}', "");
Expect(0, 195101, '\P{^NFC_QC=_ Y}', "");
Error('\p{Is_NFC_Quick_Check=_-Yes:=}');
Error('\P{Is_NFC_Quick_Check=_-Yes:=}');
Expect(1, 195102, '\p{Is_NFC_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^Is_NFC_Quick_Check=yes}', "");
Expect(0, 195102, '\P{Is_NFC_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^Is_NFC_Quick_Check=yes}', "");
Expect(0, 195101, '\p{Is_NFC_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^Is_NFC_Quick_Check=yes}', "");
Expect(1, 195101, '\P{Is_NFC_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^Is_NFC_Quick_Check=yes}', "");
Expect(1, 195102, '\p{Is_NFC_Quick_Check=__Yes}', "");
Expect(0, 195102, '\p{^Is_NFC_Quick_Check=__Yes}', "");
Expect(0, 195102, '\P{Is_NFC_Quick_Check=__Yes}', "");
Expect(1, 195102, '\P{^Is_NFC_Quick_Check=__Yes}', "");
Expect(0, 195101, '\p{Is_NFC_Quick_Check=__Yes}', "");
Expect(1, 195101, '\p{^Is_NFC_Quick_Check=__Yes}', "");
Expect(1, 195101, '\P{Is_NFC_Quick_Check=__Yes}', "");
Expect(0, 195101, '\P{^Is_NFC_Quick_Check=__Yes}', "");
Error('\p{Is_NFC_QC= Y:=}');
Error('\P{Is_NFC_QC= Y:=}');
Expect(1, 195102, '\p{Is_NFC_QC=y}', "");
Expect(0, 195102, '\p{^Is_NFC_QC=y}', "");
Expect(0, 195102, '\P{Is_NFC_QC=y}', "");
Expect(1, 195102, '\P{^Is_NFC_QC=y}', "");
Expect(0, 195101, '\p{Is_NFC_QC=y}', "");
Expect(1, 195101, '\p{^Is_NFC_QC=y}', "");
Expect(1, 195101, '\P{Is_NFC_QC=y}', "");
Expect(0, 195101, '\P{^Is_NFC_QC=y}', "");
Expect(1, 195102, '\p{Is_NFC_QC:   	y}', "");
Expect(0, 195102, '\p{^Is_NFC_QC:   	y}', "");
Expect(0, 195102, '\P{Is_NFC_QC:   	y}', "");
Expect(1, 195102, '\P{^Is_NFC_QC:   	y}', "");
Expect(0, 195101, '\p{Is_NFC_QC:   	y}', "");
Expect(1, 195101, '\p{^Is_NFC_QC:   	y}', "");
Expect(1, 195101, '\P{Is_NFC_QC:   	y}', "");
Expect(0, 195101, '\P{^Is_NFC_QC:   	y}', "");
Error('\p{NFD_Quick_Check=/a/__No}');
Error('\P{NFD_Quick_Check=/a/__No}');
Expect(1, 195101, '\p{NFD_Quick_Check: no}', "");
Expect(0, 195101, '\p{^NFD_Quick_Check: no}', "");
Expect(0, 195101, '\P{NFD_Quick_Check: no}', "");
Expect(1, 195101, '\P{^NFD_Quick_Check: no}', "");
Expect(0, 195102, '\p{NFD_Quick_Check: no}', "");
Expect(1, 195102, '\p{^NFD_Quick_Check: no}', "");
Expect(1, 195102, '\P{NFD_Quick_Check: no}', "");
Expect(0, 195102, '\P{^NFD_Quick_Check: no}', "");
Expect(1, 195101, '\p{NFD_Quick_Check= -no}', "");
Expect(0, 195101, '\p{^NFD_Quick_Check= -no}', "");
Expect(0, 195101, '\P{NFD_Quick_Check= -no}', "");
Expect(1, 195101, '\P{^NFD_Quick_Check= -no}', "");
Expect(0, 195102, '\p{NFD_Quick_Check= -no}', "");
Expect(1, 195102, '\p{^NFD_Quick_Check= -no}', "");
Expect(1, 195102, '\P{NFD_Quick_Check= -no}', "");
Expect(0, 195102, '\P{^NFD_Quick_Check= -no}', "");
Error('\p{NFD_QC=/a/ 	N}');
Error('\P{NFD_QC=/a/ 	N}');
Expect(1, 195101, '\p{NFD_QC=n}', "");
Expect(0, 195101, '\p{^NFD_QC=n}', "");
Expect(0, 195101, '\P{NFD_QC=n}', "");
Expect(1, 195101, '\P{^NFD_QC=n}', "");
Expect(0, 195102, '\p{NFD_QC=n}', "");
Expect(1, 195102, '\p{^NFD_QC=n}', "");
Expect(1, 195102, '\P{NFD_QC=n}', "");
Expect(0, 195102, '\P{^NFD_QC=n}', "");
Expect(1, 195101, '\p{NFD_QC=-N}', "");
Expect(0, 195101, '\p{^NFD_QC=-N}', "");
Expect(0, 195101, '\P{NFD_QC=-N}', "");
Expect(1, 195101, '\P{^NFD_QC=-N}', "");
Expect(0, 195102, '\p{NFD_QC=-N}', "");
Expect(1, 195102, '\p{^NFD_QC=-N}', "");
Expect(1, 195102, '\P{NFD_QC=-N}', "");
Expect(0, 195102, '\P{^NFD_QC=-N}', "");
Error('\p{Is_NFD_Quick_Check=--no:=}');
Error('\P{Is_NFD_Quick_Check=--no:=}');
Expect(1, 195101, '\p{Is_NFD_Quick_Check=no}', "");
Expect(0, 195101, '\p{^Is_NFD_Quick_Check=no}', "");
Expect(0, 195101, '\P{Is_NFD_Quick_Check=no}', "");
Expect(1, 195101, '\P{^Is_NFD_Quick_Check=no}', "");
Expect(0, 195102, '\p{Is_NFD_Quick_Check=no}', "");
Expect(1, 195102, '\p{^Is_NFD_Quick_Check=no}', "");
Expect(1, 195102, '\P{Is_NFD_Quick_Check=no}', "");
Expect(0, 195102, '\P{^Is_NFD_Quick_Check=no}', "");
Error('\p{Is_NFD_QC=_n:=}');
Error('\P{Is_NFD_QC=_n:=}');
Expect(1, 195101, '\p{Is_NFD_QC=n}', "");
Expect(0, 195101, '\p{^Is_NFD_QC=n}', "");
Expect(0, 195101, '\P{Is_NFD_QC=n}', "");
Expect(1, 195101, '\P{^Is_NFD_QC=n}', "");
Expect(0, 195102, '\p{Is_NFD_QC=n}', "");
Expect(1, 195102, '\p{^Is_NFD_QC=n}', "");
Expect(1, 195102, '\P{Is_NFD_QC=n}', "");
Expect(0, 195102, '\P{^Is_NFD_QC=n}', "");
Expect(1, 195101, '\p{Is_NFD_QC=__n}', "");
Expect(0, 195101, '\p{^Is_NFD_QC=__n}', "");
Expect(0, 195101, '\P{Is_NFD_QC=__n}', "");
Expect(1, 195101, '\P{^Is_NFD_QC=__n}', "");
Expect(0, 195102, '\p{Is_NFD_QC=__n}', "");
Expect(1, 195102, '\p{^Is_NFD_QC=__n}', "");
Expect(1, 195102, '\P{Is_NFD_QC=__n}', "");
Expect(0, 195102, '\P{^Is_NFD_QC=__n}', "");
Error('\p{NFD_Quick_Check=_yes:=}');
Error('\P{NFD_Quick_Check=_yes:=}');
Expect(1, 195102, '\p{NFD_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^NFD_Quick_Check=yes}', "");
Expect(0, 195102, '\P{NFD_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^NFD_Quick_Check=yes}', "");
Expect(0, 195101, '\p{NFD_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^NFD_Quick_Check=yes}', "");
Expect(1, 195101, '\P{NFD_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^NFD_Quick_Check=yes}', "");
Expect(1, 195102, '\p{NFD_Quick_Check=	-Yes}', "");
Expect(0, 195102, '\p{^NFD_Quick_Check=	-Yes}', "");
Expect(0, 195102, '\P{NFD_Quick_Check=	-Yes}', "");
Expect(1, 195102, '\P{^NFD_Quick_Check=	-Yes}', "");
Expect(0, 195101, '\p{NFD_Quick_Check=	-Yes}', "");
Expect(1, 195101, '\p{^NFD_Quick_Check=	-Yes}', "");
Expect(1, 195101, '\P{NFD_Quick_Check=	-Yes}', "");
Expect(0, 195101, '\P{^NFD_Quick_Check=	-Yes}', "");
Error('\p{NFD_QC=Y:=}');
Error('\P{NFD_QC=Y:=}');
Expect(1, 195102, '\p{NFD_QC=y}', "");
Expect(0, 195102, '\p{^NFD_QC=y}', "");
Expect(0, 195102, '\P{NFD_QC=y}', "");
Expect(1, 195102, '\P{^NFD_QC=y}', "");
Expect(0, 195101, '\p{NFD_QC=y}', "");
Expect(1, 195101, '\p{^NFD_QC=y}', "");
Expect(1, 195101, '\P{NFD_QC=y}', "");
Expect(0, 195101, '\P{^NFD_QC=y}', "");
Expect(1, 195102, '\p{NFD_QC= y}', "");
Expect(0, 195102, '\p{^NFD_QC= y}', "");
Expect(0, 195102, '\P{NFD_QC= y}', "");
Expect(1, 195102, '\P{^NFD_QC= y}', "");
Expect(0, 195101, '\p{NFD_QC= y}', "");
Expect(1, 195101, '\p{^NFD_QC= y}', "");
Expect(1, 195101, '\P{NFD_QC= y}', "");
Expect(0, 195101, '\P{^NFD_QC= y}', "");
Error('\p{Is_NFD_Quick_Check=_/a/Yes}');
Error('\P{Is_NFD_Quick_Check=_/a/Yes}');
Expect(1, 195102, '\p{Is_NFD_Quick_Check:	yes}', "");
Expect(0, 195102, '\p{^Is_NFD_Quick_Check:	yes}', "");
Expect(0, 195102, '\P{Is_NFD_Quick_Check:	yes}', "");
Expect(1, 195102, '\P{^Is_NFD_Quick_Check:	yes}', "");
Expect(0, 195101, '\p{Is_NFD_Quick_Check:	yes}', "");
Expect(1, 195101, '\p{^Is_NFD_Quick_Check:	yes}', "");
Expect(1, 195101, '\P{Is_NFD_Quick_Check:	yes}', "");
Expect(0, 195101, '\P{^Is_NFD_Quick_Check:	yes}', "");
Expect(1, 195102, '\p{Is_NFD_Quick_Check=- Yes}', "");
Expect(0, 195102, '\p{^Is_NFD_Quick_Check=- Yes}', "");
Expect(0, 195102, '\P{Is_NFD_Quick_Check=- Yes}', "");
Expect(1, 195102, '\P{^Is_NFD_Quick_Check=- Yes}', "");
Expect(0, 195101, '\p{Is_NFD_Quick_Check=- Yes}', "");
Expect(1, 195101, '\p{^Is_NFD_Quick_Check=- Yes}', "");
Expect(1, 195101, '\P{Is_NFD_Quick_Check=- Yes}', "");
Expect(0, 195101, '\P{^Is_NFD_Quick_Check=- Yes}', "");
Error('\p{Is_NFD_QC=/a/-_Y}');
Error('\P{Is_NFD_QC=/a/-_Y}');
Expect(1, 195102, '\p{Is_NFD_QC: y}', "");
Expect(0, 195102, '\p{^Is_NFD_QC: y}', "");
Expect(0, 195102, '\P{Is_NFD_QC: y}', "");
Expect(1, 195102, '\P{^Is_NFD_QC: y}', "");
Expect(0, 195101, '\p{Is_NFD_QC: y}', "");
Expect(1, 195101, '\p{^Is_NFD_QC: y}', "");
Expect(1, 195101, '\P{Is_NFD_QC: y}', "");
Expect(0, 195101, '\P{^Is_NFD_QC: y}', "");
Expect(1, 195102, '\p{Is_NFD_QC=	Y}', "");
Expect(0, 195102, '\p{^Is_NFD_QC=	Y}', "");
Expect(0, 195102, '\P{Is_NFD_QC=	Y}', "");
Expect(1, 195102, '\P{^Is_NFD_QC=	Y}', "");
Expect(0, 195101, '\p{Is_NFD_QC=	Y}', "");
Expect(1, 195101, '\p{^Is_NFD_QC=	Y}', "");
Expect(1, 195101, '\P{Is_NFD_QC=	Y}', "");
Expect(0, 195101, '\P{^Is_NFD_QC=	Y}', "");
Error('\p{NFKC_Quick_Check:-Maybe:=}');
Error('\P{NFKC_Quick_Check:-Maybe:=}');
Expect(1, 71087, '\p{NFKC_Quick_Check:   maybe}', "");
Expect(0, 71087, '\p{^NFKC_Quick_Check:   maybe}', "");
Expect(0, 71087, '\P{NFKC_Quick_Check:   maybe}', "");
Expect(1, 71087, '\P{^NFKC_Quick_Check:   maybe}', "");
Expect(0, 71088, '\p{NFKC_Quick_Check:   maybe}', "");
Expect(1, 71088, '\p{^NFKC_Quick_Check:   maybe}', "");
Expect(1, 71088, '\P{NFKC_Quick_Check:   maybe}', "");
Expect(0, 71088, '\P{^NFKC_Quick_Check:   maybe}', "");
Expect(1, 71087, '\p{NFKC_Quick_Check:   -Maybe}', "");
Expect(0, 71087, '\p{^NFKC_Quick_Check:   -Maybe}', "");
Expect(0, 71087, '\P{NFKC_Quick_Check:   -Maybe}', "");
Expect(1, 71087, '\P{^NFKC_Quick_Check:   -Maybe}', "");
Expect(0, 71088, '\p{NFKC_Quick_Check:   -Maybe}', "");
Expect(1, 71088, '\p{^NFKC_Quick_Check:   -Maybe}', "");
Expect(1, 71088, '\P{NFKC_Quick_Check:   -Maybe}', "");
Expect(0, 71088, '\P{^NFKC_Quick_Check:   -Maybe}', "");
Error('\p{NFKC_QC=	_M/a/}');
Error('\P{NFKC_QC=	_M/a/}');
Expect(1, 71087, '\p{NFKC_QC=m}', "");
Expect(0, 71087, '\p{^NFKC_QC=m}', "");
Expect(0, 71087, '\P{NFKC_QC=m}', "");
Expect(1, 71087, '\P{^NFKC_QC=m}', "");
Expect(0, 71088, '\p{NFKC_QC=m}', "");
Expect(1, 71088, '\p{^NFKC_QC=m}', "");
Expect(1, 71088, '\P{NFKC_QC=m}', "");
Expect(0, 71088, '\P{^NFKC_QC=m}', "");
Expect(1, 71087, '\p{NFKC_QC=-_M}', "");
Expect(0, 71087, '\p{^NFKC_QC=-_M}', "");
Expect(0, 71087, '\P{NFKC_QC=-_M}', "");
Expect(1, 71087, '\P{^NFKC_QC=-_M}', "");
Expect(0, 71088, '\p{NFKC_QC=-_M}', "");
Expect(1, 71088, '\p{^NFKC_QC=-_M}', "");
Expect(1, 71088, '\P{NFKC_QC=-_M}', "");
Expect(0, 71088, '\P{^NFKC_QC=-_M}', "");
Error('\p{Is_NFKC_Quick_Check= Maybe:=}');
Error('\P{Is_NFKC_Quick_Check= Maybe:=}');
Expect(1, 71087, '\p{Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 71087, '\p{^Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 71087, '\P{Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 71087, '\P{^Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 71088, '\p{Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 71088, '\p{^Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 71088, '\P{Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 71088, '\P{^Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 71087, '\p{Is_NFKC_Quick_Check=_maybe}', "");
Expect(0, 71087, '\p{^Is_NFKC_Quick_Check=_maybe}', "");
Expect(0, 71087, '\P{Is_NFKC_Quick_Check=_maybe}', "");
Expect(1, 71087, '\P{^Is_NFKC_Quick_Check=_maybe}', "");
Expect(0, 71088, '\p{Is_NFKC_Quick_Check=_maybe}', "");
Expect(1, 71088, '\p{^Is_NFKC_Quick_Check=_maybe}', "");
Expect(1, 71088, '\P{Is_NFKC_Quick_Check=_maybe}', "");
Expect(0, 71088, '\P{^Is_NFKC_Quick_Check=_maybe}', "");
Error('\p{Is_NFKC_QC:	_m/a/}');
Error('\P{Is_NFKC_QC:	_m/a/}');
Expect(1, 71087, '\p{Is_NFKC_QC=m}', "");
Expect(0, 71087, '\p{^Is_NFKC_QC=m}', "");
Expect(0, 71087, '\P{Is_NFKC_QC=m}', "");
Expect(1, 71087, '\P{^Is_NFKC_QC=m}', "");
Expect(0, 71088, '\p{Is_NFKC_QC=m}', "");
Expect(1, 71088, '\p{^Is_NFKC_QC=m}', "");
Expect(1, 71088, '\P{Is_NFKC_QC=m}', "");
Expect(0, 71088, '\P{^Is_NFKC_QC=m}', "");
Expect(1, 71087, '\p{Is_NFKC_QC: _M}', "");
Expect(0, 71087, '\p{^Is_NFKC_QC: _M}', "");
Expect(0, 71087, '\P{Is_NFKC_QC: _M}', "");
Expect(1, 71087, '\P{^Is_NFKC_QC: _M}', "");
Expect(0, 71088, '\p{Is_NFKC_QC: _M}', "");
Expect(1, 71088, '\p{^Is_NFKC_QC: _M}', "");
Expect(1, 71088, '\P{Is_NFKC_QC: _M}', "");
Expect(0, 71088, '\P{^Is_NFKC_QC: _M}', "");
Error('\p{NFKC_Quick_Check=	_No:=}');
Error('\P{NFKC_Quick_Check=	_No:=}');
Expect(1, 195101, '\p{NFKC_Quick_Check:   no}', "");
Expect(0, 195101, '\p{^NFKC_Quick_Check:   no}', "");
Expect(0, 195101, '\P{NFKC_Quick_Check:   no}', "");
Expect(1, 195101, '\P{^NFKC_Quick_Check:   no}', "");
Expect(0, 195102, '\p{NFKC_Quick_Check:   no}', "");
Expect(1, 195102, '\p{^NFKC_Quick_Check:   no}', "");
Expect(1, 195102, '\P{NFKC_Quick_Check:   no}', "");
Expect(0, 195102, '\P{^NFKC_Quick_Check:   no}', "");
Expect(1, 195101, '\p{NFKC_Quick_Check=-no}', "");
Expect(0, 195101, '\p{^NFKC_Quick_Check=-no}', "");
Expect(0, 195101, '\P{NFKC_Quick_Check=-no}', "");
Expect(1, 195101, '\P{^NFKC_Quick_Check=-no}', "");
Expect(0, 195102, '\p{NFKC_Quick_Check=-no}', "");
Expect(1, 195102, '\p{^NFKC_Quick_Check=-no}', "");
Expect(1, 195102, '\P{NFKC_Quick_Check=-no}', "");
Expect(0, 195102, '\P{^NFKC_Quick_Check=-no}', "");
Error('\p{NFKC_QC=/a/_-N}');
Error('\P{NFKC_QC=/a/_-N}');
Expect(1, 195101, '\p{NFKC_QC=n}', "");
Expect(0, 195101, '\p{^NFKC_QC=n}', "");
Expect(0, 195101, '\P{NFKC_QC=n}', "");
Expect(1, 195101, '\P{^NFKC_QC=n}', "");
Expect(0, 195102, '\p{NFKC_QC=n}', "");
Expect(1, 195102, '\p{^NFKC_QC=n}', "");
Expect(1, 195102, '\P{NFKC_QC=n}', "");
Expect(0, 195102, '\P{^NFKC_QC=n}', "");
Expect(1, 195101, '\p{NFKC_QC: 	N}', "");
Expect(0, 195101, '\p{^NFKC_QC: 	N}', "");
Expect(0, 195101, '\P{NFKC_QC: 	N}', "");
Expect(1, 195101, '\P{^NFKC_QC: 	N}', "");
Expect(0, 195102, '\p{NFKC_QC: 	N}', "");
Expect(1, 195102, '\p{^NFKC_QC: 	N}', "");
Expect(1, 195102, '\P{NFKC_QC: 	N}', "");
Expect(0, 195102, '\P{^NFKC_QC: 	N}', "");
Error('\p{Is_NFKC_Quick_Check=	:=no}');
Error('\P{Is_NFKC_Quick_Check=	:=no}');
Expect(1, 195101, '\p{Is_NFKC_Quick_Check:	no}', "");
Expect(0, 195101, '\p{^Is_NFKC_Quick_Check:	no}', "");
Expect(0, 195101, '\P{Is_NFKC_Quick_Check:	no}', "");
Expect(1, 195101, '\P{^Is_NFKC_Quick_Check:	no}', "");
Expect(0, 195102, '\p{Is_NFKC_Quick_Check:	no}', "");
Expect(1, 195102, '\p{^Is_NFKC_Quick_Check:	no}', "");
Expect(1, 195102, '\P{Is_NFKC_Quick_Check:	no}', "");
Expect(0, 195102, '\P{^Is_NFKC_Quick_Check:	no}', "");
Expect(1, 195101, '\p{Is_NFKC_Quick_Check= NO}', "");
Expect(0, 195101, '\p{^Is_NFKC_Quick_Check= NO}', "");
Expect(0, 195101, '\P{Is_NFKC_Quick_Check= NO}', "");
Expect(1, 195101, '\P{^Is_NFKC_Quick_Check= NO}', "");
Expect(0, 195102, '\p{Is_NFKC_Quick_Check= NO}', "");
Expect(1, 195102, '\p{^Is_NFKC_Quick_Check= NO}', "");
Expect(1, 195102, '\P{Is_NFKC_Quick_Check= NO}', "");
Expect(0, 195102, '\P{^Is_NFKC_Quick_Check= NO}', "");
Error('\p{Is_NFKC_QC=/a/  N}');
Error('\P{Is_NFKC_QC=/a/  N}');
Expect(1, 195101, '\p{Is_NFKC_QC=n}', "");
Expect(0, 195101, '\p{^Is_NFKC_QC=n}', "");
Expect(0, 195101, '\P{Is_NFKC_QC=n}', "");
Expect(1, 195101, '\P{^Is_NFKC_QC=n}', "");
Expect(0, 195102, '\p{Is_NFKC_QC=n}', "");
Expect(1, 195102, '\p{^Is_NFKC_QC=n}', "");
Expect(1, 195102, '\P{Is_NFKC_QC=n}', "");
Expect(0, 195102, '\P{^Is_NFKC_QC=n}', "");
Expect(1, 195101, '\p{Is_NFKC_QC=-	N}', "");
Expect(0, 195101, '\p{^Is_NFKC_QC=-	N}', "");
Expect(0, 195101, '\P{Is_NFKC_QC=-	N}', "");
Expect(1, 195101, '\P{^Is_NFKC_QC=-	N}', "");
Expect(0, 195102, '\p{Is_NFKC_QC=-	N}', "");
Expect(1, 195102, '\p{^Is_NFKC_QC=-	N}', "");
Expect(1, 195102, '\P{Is_NFKC_QC=-	N}', "");
Expect(0, 195102, '\P{^Is_NFKC_QC=-	N}', "");
Error('\p{NFKC_Quick_Check=:=Yes}');
Error('\P{NFKC_Quick_Check=:=Yes}');
Expect(1, 195102, '\p{NFKC_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^NFKC_Quick_Check=yes}', "");
Expect(0, 195102, '\P{NFKC_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^NFKC_Quick_Check=yes}', "");
Expect(0, 195101, '\p{NFKC_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^NFKC_Quick_Check=yes}', "");
Expect(1, 195101, '\P{NFKC_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^NFKC_Quick_Check=yes}', "");
Expect(1, 195102, '\p{NFKC_Quick_Check= yes}', "");
Expect(0, 195102, '\p{^NFKC_Quick_Check= yes}', "");
Expect(0, 195102, '\P{NFKC_Quick_Check= yes}', "");
Expect(1, 195102, '\P{^NFKC_Quick_Check= yes}', "");
Expect(0, 195101, '\p{NFKC_Quick_Check= yes}', "");
Expect(1, 195101, '\p{^NFKC_Quick_Check= yes}', "");
Expect(1, 195101, '\P{NFKC_Quick_Check= yes}', "");
Expect(0, 195101, '\P{^NFKC_Quick_Check= yes}', "");
Error('\p{NFKC_QC=:=- Y}');
Error('\P{NFKC_QC=:=- Y}');
Expect(1, 195102, '\p{NFKC_QC=y}', "");
Expect(0, 195102, '\p{^NFKC_QC=y}', "");
Expect(0, 195102, '\P{NFKC_QC=y}', "");
Expect(1, 195102, '\P{^NFKC_QC=y}', "");
Expect(0, 195101, '\p{NFKC_QC=y}', "");
Expect(1, 195101, '\p{^NFKC_QC=y}', "");
Expect(1, 195101, '\P{NFKC_QC=y}', "");
Expect(0, 195101, '\P{^NFKC_QC=y}', "");
Expect(1, 195102, '\p{NFKC_QC= _Y}', "");
Expect(0, 195102, '\p{^NFKC_QC= _Y}', "");
Expect(0, 195102, '\P{NFKC_QC= _Y}', "");
Expect(1, 195102, '\P{^NFKC_QC= _Y}', "");
Expect(0, 195101, '\p{NFKC_QC= _Y}', "");
Expect(1, 195101, '\p{^NFKC_QC= _Y}', "");
Expect(1, 195101, '\P{NFKC_QC= _Y}', "");
Expect(0, 195101, '\P{^NFKC_QC= _Y}', "");
Error('\p{Is_NFKC_Quick_Check:/a/_-yes}');
Error('\P{Is_NFKC_Quick_Check:/a/_-yes}');
Expect(1, 195102, '\p{Is_NFKC_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^Is_NFKC_Quick_Check=yes}', "");
Expect(0, 195102, '\P{Is_NFKC_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^Is_NFKC_Quick_Check=yes}', "");
Expect(0, 195101, '\p{Is_NFKC_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^Is_NFKC_Quick_Check=yes}', "");
Expect(1, 195101, '\P{Is_NFKC_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^Is_NFKC_Quick_Check=yes}', "");
Expect(1, 195102, '\p{Is_NFKC_Quick_Check= -Yes}', "");
Expect(0, 195102, '\p{^Is_NFKC_Quick_Check= -Yes}', "");
Expect(0, 195102, '\P{Is_NFKC_Quick_Check= -Yes}', "");
Expect(1, 195102, '\P{^Is_NFKC_Quick_Check= -Yes}', "");
Expect(0, 195101, '\p{Is_NFKC_Quick_Check= -Yes}', "");
Expect(1, 195101, '\p{^Is_NFKC_Quick_Check= -Yes}', "");
Expect(1, 195101, '\P{Is_NFKC_Quick_Check= -Yes}', "");
Expect(0, 195101, '\P{^Is_NFKC_Quick_Check= -Yes}', "");
Error('\p{Is_NFKC_QC=--Y:=}');
Error('\P{Is_NFKC_QC=--Y:=}');
Expect(1, 195102, '\p{Is_NFKC_QC=y}', "");
Expect(0, 195102, '\p{^Is_NFKC_QC=y}', "");
Expect(0, 195102, '\P{Is_NFKC_QC=y}', "");
Expect(1, 195102, '\P{^Is_NFKC_QC=y}', "");
Expect(0, 195101, '\p{Is_NFKC_QC=y}', "");
Expect(1, 195101, '\p{^Is_NFKC_QC=y}', "");
Expect(1, 195101, '\P{Is_NFKC_QC=y}', "");
Expect(0, 195101, '\P{^Is_NFKC_QC=y}', "");
Expect(1, 195102, '\p{Is_NFKC_QC: _	y}', "");
Expect(0, 195102, '\p{^Is_NFKC_QC: _	y}', "");
Expect(0, 195102, '\P{Is_NFKC_QC: _	y}', "");
Expect(1, 195102, '\P{^Is_NFKC_QC: _	y}', "");
Expect(0, 195101, '\p{Is_NFKC_QC: _	y}', "");
Expect(1, 195101, '\p{^Is_NFKC_QC: _	y}', "");
Expect(1, 195101, '\P{Is_NFKC_QC: _	y}', "");
Expect(0, 195101, '\P{^Is_NFKC_QC: _	y}', "");
Error('\p{NFKD_Quick_Check= /a/No}');
Error('\P{NFKD_Quick_Check= /a/No}');
Expect(1, 195101, '\p{NFKD_Quick_Check=no}', "");
Expect(0, 195101, '\p{^NFKD_Quick_Check=no}', "");
Expect(0, 195101, '\P{NFKD_Quick_Check=no}', "");
Expect(1, 195101, '\P{^NFKD_Quick_Check=no}', "");
Expect(0, 195102, '\p{NFKD_Quick_Check=no}', "");
Expect(1, 195102, '\p{^NFKD_Quick_Check=no}', "");
Expect(1, 195102, '\P{NFKD_Quick_Check=no}', "");
Expect(0, 195102, '\P{^NFKD_Quick_Check=no}', "");
Expect(1, 195101, '\p{NFKD_Quick_Check:	  No}', "");
Expect(0, 195101, '\p{^NFKD_Quick_Check:	  No}', "");
Expect(0, 195101, '\P{NFKD_Quick_Check:	  No}', "");
Expect(1, 195101, '\P{^NFKD_Quick_Check:	  No}', "");
Expect(0, 195102, '\p{NFKD_Quick_Check:	  No}', "");
Expect(1, 195102, '\p{^NFKD_Quick_Check:	  No}', "");
Expect(1, 195102, '\P{NFKD_Quick_Check:	  No}', "");
Expect(0, 195102, '\P{^NFKD_Quick_Check:	  No}', "");
Error('\p{NFKD_QC=  N/a/}');
Error('\P{NFKD_QC=  N/a/}');
Expect(1, 195101, '\p{NFKD_QC=n}', "");
Expect(0, 195101, '\p{^NFKD_QC=n}', "");
Expect(0, 195101, '\P{NFKD_QC=n}', "");
Expect(1, 195101, '\P{^NFKD_QC=n}', "");
Expect(0, 195102, '\p{NFKD_QC=n}', "");
Expect(1, 195102, '\p{^NFKD_QC=n}', "");
Expect(1, 195102, '\P{NFKD_QC=n}', "");
Expect(0, 195102, '\P{^NFKD_QC=n}', "");
Expect(1, 195101, '\p{NFKD_QC=_ N}', "");
Expect(0, 195101, '\p{^NFKD_QC=_ N}', "");
Expect(0, 195101, '\P{NFKD_QC=_ N}', "");
Expect(1, 195101, '\P{^NFKD_QC=_ N}', "");
Expect(0, 195102, '\p{NFKD_QC=_ N}', "");
Expect(1, 195102, '\p{^NFKD_QC=_ N}', "");
Expect(1, 195102, '\P{NFKD_QC=_ N}', "");
Expect(0, 195102, '\P{^NFKD_QC=_ N}', "");
Error('\p{Is_NFKD_Quick_Check=-:=no}');
Error('\P{Is_NFKD_Quick_Check=-:=no}');
Expect(1, 195101, '\p{Is_NFKD_Quick_Check=no}', "");
Expect(0, 195101, '\p{^Is_NFKD_Quick_Check=no}', "");
Expect(0, 195101, '\P{Is_NFKD_Quick_Check=no}', "");
Expect(1, 195101, '\P{^Is_NFKD_Quick_Check=no}', "");
Expect(0, 195102, '\p{Is_NFKD_Quick_Check=no}', "");
Expect(1, 195102, '\p{^Is_NFKD_Quick_Check=no}', "");
Expect(1, 195102, '\P{Is_NFKD_Quick_Check=no}', "");
Expect(0, 195102, '\P{^Is_NFKD_Quick_Check=no}', "");
Expect(1, 195101, '\p{Is_NFKD_Quick_Check=_No}', "");
Expect(0, 195101, '\p{^Is_NFKD_Quick_Check=_No}', "");
Expect(0, 195101, '\P{Is_NFKD_Quick_Check=_No}', "");
Expect(1, 195101, '\P{^Is_NFKD_Quick_Check=_No}', "");
Expect(0, 195102, '\p{Is_NFKD_Quick_Check=_No}', "");
Expect(1, 195102, '\p{^Is_NFKD_Quick_Check=_No}', "");
Expect(1, 195102, '\P{Is_NFKD_Quick_Check=_No}', "");
Expect(0, 195102, '\P{^Is_NFKD_Quick_Check=_No}', "");
Error('\p{Is_NFKD_QC=:= n}');
Error('\P{Is_NFKD_QC=:= n}');
Expect(1, 195101, '\p{Is_NFKD_QC=n}', "");
Expect(0, 195101, '\p{^Is_NFKD_QC=n}', "");
Expect(0, 195101, '\P{Is_NFKD_QC=n}', "");
Expect(1, 195101, '\P{^Is_NFKD_QC=n}', "");
Expect(0, 195102, '\p{Is_NFKD_QC=n}', "");
Expect(1, 195102, '\p{^Is_NFKD_QC=n}', "");
Expect(1, 195102, '\P{Is_NFKD_QC=n}', "");
Expect(0, 195102, '\P{^Is_NFKD_QC=n}', "");
Expect(1, 195101, '\p{Is_NFKD_QC= -N}', "");
Expect(0, 195101, '\p{^Is_NFKD_QC= -N}', "");
Expect(0, 195101, '\P{Is_NFKD_QC= -N}', "");
Expect(1, 195101, '\P{^Is_NFKD_QC= -N}', "");
Expect(0, 195102, '\p{Is_NFKD_QC= -N}', "");
Expect(1, 195102, '\p{^Is_NFKD_QC= -N}', "");
Expect(1, 195102, '\P{Is_NFKD_QC= -N}', "");
Expect(0, 195102, '\P{^Is_NFKD_QC= -N}', "");
Error('\p{NFKD_Quick_Check= /a/YES}');
Error('\P{NFKD_Quick_Check= /a/YES}');
Expect(1, 195102, '\p{NFKD_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^NFKD_Quick_Check=yes}', "");
Expect(0, 195102, '\P{NFKD_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^NFKD_Quick_Check=yes}', "");
Expect(0, 195101, '\p{NFKD_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^NFKD_Quick_Check=yes}', "");
Expect(1, 195101, '\P{NFKD_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^NFKD_Quick_Check=yes}', "");
Expect(1, 195102, '\p{NFKD_Quick_Check=-YES}', "");
Expect(0, 195102, '\p{^NFKD_Quick_Check=-YES}', "");
Expect(0, 195102, '\P{NFKD_Quick_Check=-YES}', "");
Expect(1, 195102, '\P{^NFKD_Quick_Check=-YES}', "");
Expect(0, 195101, '\p{NFKD_Quick_Check=-YES}', "");
Expect(1, 195101, '\p{^NFKD_Quick_Check=-YES}', "");
Expect(1, 195101, '\P{NFKD_Quick_Check=-YES}', "");
Expect(0, 195101, '\P{^NFKD_Quick_Check=-YES}', "");
Error('\p{NFKD_QC=__Y:=}');
Error('\P{NFKD_QC=__Y:=}');
Expect(1, 195102, '\p{NFKD_QC=y}', "");
Expect(0, 195102, '\p{^NFKD_QC=y}', "");
Expect(0, 195102, '\P{NFKD_QC=y}', "");
Expect(1, 195102, '\P{^NFKD_QC=y}', "");
Expect(0, 195101, '\p{NFKD_QC=y}', "");
Expect(1, 195101, '\p{^NFKD_QC=y}', "");
Expect(1, 195101, '\P{NFKD_QC=y}', "");
Expect(0, 195101, '\P{^NFKD_QC=y}', "");
Expect(1, 195102, '\p{NFKD_QC=-Y}', "");
Expect(0, 195102, '\p{^NFKD_QC=-Y}', "");
Expect(0, 195102, '\P{NFKD_QC=-Y}', "");
Expect(1, 195102, '\P{^NFKD_QC=-Y}', "");
Expect(0, 195101, '\p{NFKD_QC=-Y}', "");
Expect(1, 195101, '\p{^NFKD_QC=-Y}', "");
Expect(1, 195101, '\P{NFKD_QC=-Y}', "");
Expect(0, 195101, '\P{^NFKD_QC=-Y}', "");
Error('\p{Is_NFKD_Quick_Check=:=yes}');
Error('\P{Is_NFKD_Quick_Check=:=yes}');
Expect(1, 195102, '\p{Is_NFKD_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^Is_NFKD_Quick_Check=yes}', "");
Expect(0, 195102, '\P{Is_NFKD_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^Is_NFKD_Quick_Check=yes}', "");
Expect(0, 195101, '\p{Is_NFKD_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^Is_NFKD_Quick_Check=yes}', "");
Expect(1, 195101, '\P{Is_NFKD_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^Is_NFKD_Quick_Check=yes}', "");
Expect(1, 195102, '\p{Is_NFKD_Quick_Check=	-YES}', "");
Expect(0, 195102, '\p{^Is_NFKD_Quick_Check=	-YES}', "");
Expect(0, 195102, '\P{Is_NFKD_Quick_Check=	-YES}', "");
Expect(1, 195102, '\P{^Is_NFKD_Quick_Check=	-YES}', "");
Expect(0, 195101, '\p{Is_NFKD_Quick_Check=	-YES}', "");
Expect(1, 195101, '\p{^Is_NFKD_Quick_Check=	-YES}', "");
Expect(1, 195101, '\P{Is_NFKD_Quick_Check=	-YES}', "");
Expect(0, 195101, '\P{^Is_NFKD_Quick_Check=	-YES}', "");
Error('\p{Is_NFKD_QC=- y/a/}');
Error('\P{Is_NFKD_QC=- y/a/}');
Expect(1, 195102, '\p{Is_NFKD_QC=y}', "");
Expect(0, 195102, '\p{^Is_NFKD_QC=y}', "");
Expect(0, 195102, '\P{Is_NFKD_QC=y}', "");
Expect(1, 195102, '\P{^Is_NFKD_QC=y}', "");
Expect(0, 195101, '\p{Is_NFKD_QC=y}', "");
Expect(1, 195101, '\p{^Is_NFKD_QC=y}', "");
Expect(1, 195101, '\P{Is_NFKD_QC=y}', "");
Expect(0, 195101, '\P{^Is_NFKD_QC=y}', "");
Expect(1, 195102, '\p{Is_NFKD_QC=	Y}', "");
Expect(0, 195102, '\p{^Is_NFKD_QC=	Y}', "");
Expect(0, 195102, '\P{Is_NFKD_QC=	Y}', "");
Expect(1, 195102, '\P{^Is_NFKD_QC=	Y}', "");
Expect(0, 195101, '\p{Is_NFKD_QC=	Y}', "");
Expect(1, 195101, '\p{^Is_NFKD_QC=	Y}', "");
Expect(1, 195101, '\P{Is_NFKD_QC=	Y}', "");
Expect(0, 195101, '\P{^Is_NFKD_QC=	Y}', "");
Error('\p{Other_Alphabetic=No}');
Error('\P{Other_Alphabetic=No}');
Error('\p{OAlpha=N}');
Error('\P{OAlpha=N}');
Error('\p{Is_Other_Alphabetic=F}');
Error('\P{Is_Other_Alphabetic=F}');
Error('\p{Is_OAlpha=False}');
Error('\P{Is_OAlpha=False}');
Error('\p{Other_Alphabetic=Yes}');
Error('\P{Other_Alphabetic=Yes}');
Error('\p{OAlpha=Y}');
Error('\P{OAlpha=Y}');
Error('\p{Is_Other_Alphabetic=T}');
Error('\P{Is_Other_Alphabetic=T}');
Error('\p{Is_OAlpha=True}');
Error('\P{Is_OAlpha=True}');
Error('\p{Other_Default_Ignorable_Code_Point=No}');
Error('\P{Other_Default_Ignorable_Code_Point=No}');
Error('\p{ODI=N}');
Error('\P{ODI=N}');
Error('\p{Is_Other_Default_Ignorable_Code_Point=F}');
Error('\P{Is_Other_Default_Ignorable_Code_Point=F}');
Error('\p{Is_ODI=False}');
Error('\P{Is_ODI=False}');
Error('\p{Other_Default_Ignorable_Code_Point=Yes}');
Error('\P{Other_Default_Ignorable_Code_Point=Yes}');
Error('\p{ODI=Y}');
Error('\P{ODI=Y}');
Error('\p{Is_Other_Default_Ignorable_Code_Point:   T}');
Error('\P{Is_Other_Default_Ignorable_Code_Point:   T}');
Error('\p{Is_ODI=True}');
Error('\P{Is_ODI=True}');
Error('\p{Other_Grapheme_Extend=No}');
Error('\P{Other_Grapheme_Extend=No}');
Error('\p{OGr_Ext=N}');
Error('\P{OGr_Ext=N}');
Error('\p{Is_Other_Grapheme_Extend=F}');
Error('\P{Is_Other_Grapheme_Extend=F}');
Error('\p{Is_OGr_Ext=False}');
Error('\P{Is_OGr_Ext=False}');
Error('\p{Other_Grapheme_Extend:   Yes}');
Error('\P{Other_Grapheme_Extend:   Yes}');
Error('\p{OGr_Ext=Y}');
Error('\P{OGr_Ext=Y}');
Error('\p{Is_Other_Grapheme_Extend=T}');
Error('\P{Is_Other_Grapheme_Extend=T}');
Error('\p{Is_OGr_Ext=True}');
Error('\P{Is_OGr_Ext=True}');
Error('\p{Other_ID_Continue=No}');
Error('\P{Other_ID_Continue=No}');
Error('\p{OIDC=N}');
Error('\P{OIDC=N}');
Error('\p{Is_Other_ID_Continue=F}');
Error('\P{Is_Other_ID_Continue=F}');
Error('\p{Is_OIDC=False}');
Error('\P{Is_OIDC=False}');
Error('\p{Other_ID_Continue=Yes}');
Error('\P{Other_ID_Continue=Yes}');
Error('\p{OIDC=Y}');
Error('\P{OIDC=Y}');
Error('\p{Is_Other_ID_Continue=T}');
Error('\P{Is_Other_ID_Continue=T}');
Error('\p{Is_OIDC=True}');
Error('\P{Is_OIDC=True}');
Error('\p{Other_ID_Start=No}');
Error('\P{Other_ID_Start=No}');
Error('\p{OIDS=N}');
Error('\P{OIDS=N}');
Error('\p{Is_Other_ID_Start=F}');
Error('\P{Is_Other_ID_Start=F}');
Error('\p{Is_OIDS=False}');
Error('\P{Is_OIDS=False}');
Error('\p{Other_ID_Start=Yes}');
Error('\P{Other_ID_Start=Yes}');
Error('\p{OIDS=Y}');
Error('\P{OIDS=Y}');
Error('\p{Is_Other_ID_Start=T}');
Error('\P{Is_Other_ID_Start=T}');
Error('\p{Is_OIDS=True}');
Error('\P{Is_OIDS=True}');
Error('\p{Other_Lowercase=No}');
Error('\P{Other_Lowercase=No}');
Error('\p{OLower=N}');
Error('\P{OLower=N}');
Error('\p{Is_Other_Lowercase=F}');
Error('\P{Is_Other_Lowercase=F}');
Error('\p{Is_OLower=False}');
Error('\P{Is_OLower=False}');
Error('\p{Other_Lowercase=Yes}');
Error('\P{Other_Lowercase=Yes}');
Error('\p{OLower=Y}');
Error('\P{OLower=Y}');
Error('\p{Is_Other_Lowercase=T}');
Error('\P{Is_Other_Lowercase=T}');
Error('\p{Is_OLower=True}');
Error('\P{Is_OLower=True}');
Error('\p{Other_Math=No}');
Error('\P{Other_Math=No}');
Error('\p{OMath=N}');
Error('\P{OMath=N}');
Error('\p{Is_Other_Math:   F}');
Error('\P{Is_Other_Math:   F}');
Error('\p{Is_OMath=False}');
Error('\P{Is_OMath=False}');
Error('\p{Other_Math=Yes}');
Error('\P{Other_Math=Yes}');
Error('\p{OMath=Y}');
Error('\P{OMath=Y}');
Error('\p{Is_Other_Math=T}');
Error('\P{Is_Other_Math=T}');
Error('\p{Is_OMath=True}');
Error('\P{Is_OMath=True}');
Error('\p{Other_Uppercase=No}');
Error('\P{Other_Uppercase=No}');
Error('\p{OUpper=N}');
Error('\P{OUpper=N}');
Error('\p{Is_Other_Uppercase=F}');
Error('\P{Is_Other_Uppercase=F}');
Error('\p{Is_OUpper=False}');
Error('\P{Is_OUpper=False}');
Error('\p{Other_Uppercase=Yes}');
Error('\P{Other_Uppercase=Yes}');
Error('\p{OUpper=Y}');
Error('\P{OUpper=Y}');
Error('\p{Is_Other_Uppercase=T}');
Error('\P{Is_Other_Uppercase=T}');
Error('\p{Is_OUpper=True}');
Error('\P{Is_OUpper=True}');
Error('\p{Pattern_Syntax=	no/a/}');
Error('\P{Pattern_Syntax=	no/a/}');
Expect(1, 65095, '\p{Pattern_Syntax=no}', "");
Expect(0, 65095, '\p{^Pattern_Syntax=no}', "");
Expect(0, 65095, '\P{Pattern_Syntax=no}', "");
Expect(1, 65095, '\P{^Pattern_Syntax=no}', "");
Expect(0, 65094, '\p{Pattern_Syntax=no}', "");
Expect(1, 65094, '\p{^Pattern_Syntax=no}', "");
Expect(1, 65094, '\P{Pattern_Syntax=no}', "");
Expect(0, 65094, '\P{^Pattern_Syntax=no}', "");
Expect(1, 65095, '\p{Pattern_Syntax=-No}', "");
Expect(0, 65095, '\p{^Pattern_Syntax=-No}', "");
Expect(0, 65095, '\P{Pattern_Syntax=-No}', "");
Expect(1, 65095, '\P{^Pattern_Syntax=-No}', "");
Expect(0, 65094, '\p{Pattern_Syntax=-No}', "");
Expect(1, 65094, '\p{^Pattern_Syntax=-No}', "");
Expect(1, 65094, '\P{Pattern_Syntax=-No}', "");
Expect(0, 65094, '\P{^Pattern_Syntax=-No}', "");
Error('\p{Pat_Syn=/a/_N}');
Error('\P{Pat_Syn=/a/_N}');
Expect(1, 65095, '\p{Pat_Syn=n}', "");
Expect(0, 65095, '\p{^Pat_Syn=n}', "");
Expect(0, 65095, '\P{Pat_Syn=n}', "");
Expect(1, 65095, '\P{^Pat_Syn=n}', "");
Expect(0, 65094, '\p{Pat_Syn=n}', "");
Expect(1, 65094, '\p{^Pat_Syn=n}', "");
Expect(1, 65094, '\P{Pat_Syn=n}', "");
Expect(0, 65094, '\P{^Pat_Syn=n}', "");
Expect(1, 65095, '\p{Pat_Syn=__N}', "");
Expect(0, 65095, '\p{^Pat_Syn=__N}', "");
Expect(0, 65095, '\P{Pat_Syn=__N}', "");
Expect(1, 65095, '\P{^Pat_Syn=__N}', "");
Expect(0, 65094, '\p{Pat_Syn=__N}', "");
Expect(1, 65094, '\p{^Pat_Syn=__N}', "");
Expect(1, 65094, '\P{Pat_Syn=__N}', "");
Expect(0, 65094, '\P{^Pat_Syn=__N}', "");
Error('\p{Is_Pattern_Syntax= F:=}');
Error('\P{Is_Pattern_Syntax= F:=}');
Expect(1, 65095, '\p{Is_Pattern_Syntax:f}', "");
Expect(0, 65095, '\p{^Is_Pattern_Syntax:f}', "");
Expect(0, 65095, '\P{Is_Pattern_Syntax:f}', "");
Expect(1, 65095, '\P{^Is_Pattern_Syntax:f}', "");
Expect(0, 65094, '\p{Is_Pattern_Syntax:f}', "");
Expect(1, 65094, '\p{^Is_Pattern_Syntax:f}', "");
Expect(1, 65094, '\P{Is_Pattern_Syntax:f}', "");
Expect(0, 65094, '\P{^Is_Pattern_Syntax:f}', "");
Expect(1, 65095, '\p{Is_Pattern_Syntax=	F}', "");
Expect(0, 65095, '\p{^Is_Pattern_Syntax=	F}', "");
Expect(0, 65095, '\P{Is_Pattern_Syntax=	F}', "");
Expect(1, 65095, '\P{^Is_Pattern_Syntax=	F}', "");
Expect(0, 65094, '\p{Is_Pattern_Syntax=	F}', "");
Expect(1, 65094, '\p{^Is_Pattern_Syntax=	F}', "");
Expect(1, 65094, '\P{Is_Pattern_Syntax=	F}', "");
Expect(0, 65094, '\P{^Is_Pattern_Syntax=	F}', "");
Error('\p{Is_Pat_Syn=:=	-false}');
Error('\P{Is_Pat_Syn=:=	-false}');
Expect(1, 65095, '\p{Is_Pat_Syn=false}', "");
Expect(0, 65095, '\p{^Is_Pat_Syn=false}', "");
Expect(0, 65095, '\P{Is_Pat_Syn=false}', "");
Expect(1, 65095, '\P{^Is_Pat_Syn=false}', "");
Expect(0, 65094, '\p{Is_Pat_Syn=false}', "");
Expect(1, 65094, '\p{^Is_Pat_Syn=false}', "");
Expect(1, 65094, '\P{Is_Pat_Syn=false}', "");
Expect(0, 65094, '\P{^Is_Pat_Syn=false}', "");
Expect(1, 65095, '\p{Is_Pat_Syn=	-False}', "");
Expect(0, 65095, '\p{^Is_Pat_Syn=	-False}', "");
Expect(0, 65095, '\P{Is_Pat_Syn=	-False}', "");
Expect(1, 65095, '\P{^Is_Pat_Syn=	-False}', "");
Expect(0, 65094, '\p{Is_Pat_Syn=	-False}', "");
Expect(1, 65094, '\p{^Is_Pat_Syn=	-False}', "");
Expect(1, 65094, '\P{Is_Pat_Syn=	-False}', "");
Expect(0, 65094, '\P{^Is_Pat_Syn=	-False}', "");
Error('\p{Pattern_Syntax=--YES:=}');
Error('\P{Pattern_Syntax=--YES:=}');
Expect(1, 65094, '\p{Pattern_Syntax=yes}', "");
Expect(0, 65094, '\p{^Pattern_Syntax=yes}', "");
Expect(0, 65094, '\P{Pattern_Syntax=yes}', "");
Expect(1, 65094, '\P{^Pattern_Syntax=yes}', "");
Expect(0, 65095, '\p{Pattern_Syntax=yes}', "");
Expect(1, 65095, '\p{^Pattern_Syntax=yes}', "");
Expect(1, 65095, '\P{Pattern_Syntax=yes}', "");
Expect(0, 65095, '\P{^Pattern_Syntax=yes}', "");
Expect(1, 65094, '\p{Pattern_Syntax= yes}', "");
Expect(0, 65094, '\p{^Pattern_Syntax= yes}', "");
Expect(0, 65094, '\P{Pattern_Syntax= yes}', "");
Expect(1, 65094, '\P{^Pattern_Syntax= yes}', "");
Expect(0, 65095, '\p{Pattern_Syntax= yes}', "");
Expect(1, 65095, '\p{^Pattern_Syntax= yes}', "");
Expect(1, 65095, '\P{Pattern_Syntax= yes}', "");
Expect(0, 65095, '\P{^Pattern_Syntax= yes}', "");
Error('\p{Pat_Syn=:=	-Y}');
Error('\P{Pat_Syn=:=	-Y}');
Expect(1, 65094, '\p{Pat_Syn=y}', "");
Expect(0, 65094, '\p{^Pat_Syn=y}', "");
Expect(0, 65094, '\P{Pat_Syn=y}', "");
Expect(1, 65094, '\P{^Pat_Syn=y}', "");
Expect(0, 65095, '\p{Pat_Syn=y}', "");
Expect(1, 65095, '\p{^Pat_Syn=y}', "");
Expect(1, 65095, '\P{Pat_Syn=y}', "");
Expect(0, 65095, '\P{^Pat_Syn=y}', "");
Expect(1, 65094, '\p{Pat_Syn=--y}', "");
Expect(0, 65094, '\p{^Pat_Syn=--y}', "");
Expect(0, 65094, '\P{Pat_Syn=--y}', "");
Expect(1, 65094, '\P{^Pat_Syn=--y}', "");
Expect(0, 65095, '\p{Pat_Syn=--y}', "");
Expect(1, 65095, '\p{^Pat_Syn=--y}', "");
Expect(1, 65095, '\P{Pat_Syn=--y}', "");
Expect(0, 65095, '\P{^Pat_Syn=--y}', "");
Error('\p{Is_Pattern_Syntax= _T/a/}');
Error('\P{Is_Pattern_Syntax= _T/a/}');
Expect(1, 65094, '\p{Is_Pattern_Syntax=t}', "");
Expect(0, 65094, '\p{^Is_Pattern_Syntax=t}', "");
Expect(0, 65094, '\P{Is_Pattern_Syntax=t}', "");
Expect(1, 65094, '\P{^Is_Pattern_Syntax=t}', "");
Expect(0, 65095, '\p{Is_Pattern_Syntax=t}', "");
Expect(1, 65095, '\p{^Is_Pattern_Syntax=t}', "");
Expect(1, 65095, '\P{Is_Pattern_Syntax=t}', "");
Expect(0, 65095, '\P{^Is_Pattern_Syntax=t}', "");
Expect(1, 65094, '\p{Is_Pattern_Syntax:		T}', "");
Expect(0, 65094, '\p{^Is_Pattern_Syntax:		T}', "");
Expect(0, 65094, '\P{Is_Pattern_Syntax:		T}', "");
Expect(1, 65094, '\P{^Is_Pattern_Syntax:		T}', "");
Expect(0, 65095, '\p{Is_Pattern_Syntax:		T}', "");
Expect(1, 65095, '\p{^Is_Pattern_Syntax:		T}', "");
Expect(1, 65095, '\P{Is_Pattern_Syntax:		T}', "");
Expect(0, 65095, '\P{^Is_Pattern_Syntax:		T}', "");
Error('\p{Is_Pat_Syn=/a/_True}');
Error('\P{Is_Pat_Syn=/a/_True}');
Expect(1, 65094, '\p{Is_Pat_Syn=true}', "");
Expect(0, 65094, '\p{^Is_Pat_Syn=true}', "");
Expect(0, 65094, '\P{Is_Pat_Syn=true}', "");
Expect(1, 65094, '\P{^Is_Pat_Syn=true}', "");
Expect(0, 65095, '\p{Is_Pat_Syn=true}', "");
Expect(1, 65095, '\p{^Is_Pat_Syn=true}', "");
Expect(1, 65095, '\P{Is_Pat_Syn=true}', "");
Expect(0, 65095, '\P{^Is_Pat_Syn=true}', "");
Expect(1, 65094, '\p{Is_Pat_Syn=	TRUE}', "");
Expect(0, 65094, '\p{^Is_Pat_Syn=	TRUE}', "");
Expect(0, 65094, '\P{Is_Pat_Syn=	TRUE}', "");
Expect(1, 65094, '\P{^Is_Pat_Syn=	TRUE}', "");
Expect(0, 65095, '\p{Is_Pat_Syn=	TRUE}', "");
Expect(1, 65095, '\p{^Is_Pat_Syn=	TRUE}', "");
Expect(1, 65095, '\P{Is_Pat_Syn=	TRUE}', "");
Expect(0, 65095, '\P{^Is_Pat_Syn=	TRUE}', "");
Error('\p{Pattern_White_Space=--NO:=}');
Error('\P{Pattern_White_Space=--NO:=}');
Expect(1, 8234, '\p{Pattern_White_Space=no}', "");
Expect(0, 8234, '\p{^Pattern_White_Space=no}', "");
Expect(0, 8234, '\P{Pattern_White_Space=no}', "");
Expect(1, 8234, '\P{^Pattern_White_Space=no}', "");
Expect(0, 8233, '\p{Pattern_White_Space=no}', "");
Expect(1, 8233, '\p{^Pattern_White_Space=no}', "");
Expect(1, 8233, '\P{Pattern_White_Space=no}', "");
Expect(0, 8233, '\P{^Pattern_White_Space=no}', "");
Expect(1, 8234, '\p{Pattern_White_Space= _NO}', "");
Expect(0, 8234, '\p{^Pattern_White_Space= _NO}', "");
Expect(0, 8234, '\P{Pattern_White_Space= _NO}', "");
Expect(1, 8234, '\P{^Pattern_White_Space= _NO}', "");
Expect(0, 8233, '\p{Pattern_White_Space= _NO}', "");
Expect(1, 8233, '\p{^Pattern_White_Space= _NO}', "");
Expect(1, 8233, '\P{Pattern_White_Space= _NO}', "");
Expect(0, 8233, '\P{^Pattern_White_Space= _NO}', "");
Error('\p{Pat_WS:N:=}');
Error('\P{Pat_WS:N:=}');
Expect(1, 8234, '\p{Pat_WS:	n}', "");
Expect(0, 8234, '\p{^Pat_WS:	n}', "");
Expect(0, 8234, '\P{Pat_WS:	n}', "");
Expect(1, 8234, '\P{^Pat_WS:	n}', "");
Expect(0, 8233, '\p{Pat_WS:	n}', "");
Expect(1, 8233, '\p{^Pat_WS:	n}', "");
Expect(1, 8233, '\P{Pat_WS:	n}', "");
Expect(0, 8233, '\P{^Pat_WS:	n}', "");
Expect(1, 8234, '\p{Pat_WS=-N}', "");
Expect(0, 8234, '\p{^Pat_WS=-N}', "");
Expect(0, 8234, '\P{Pat_WS=-N}', "");
Expect(1, 8234, '\P{^Pat_WS=-N}', "");
Expect(0, 8233, '\p{Pat_WS=-N}', "");
Expect(1, 8233, '\p{^Pat_WS=-N}', "");
Expect(1, 8233, '\P{Pat_WS=-N}', "");
Expect(0, 8233, '\P{^Pat_WS=-N}', "");
Error('\p{Is_Pattern_White_Space=-	F/a/}');
Error('\P{Is_Pattern_White_Space=-	F/a/}');
Expect(1, 8234, '\p{Is_Pattern_White_Space: f}', "");
Expect(0, 8234, '\p{^Is_Pattern_White_Space: f}', "");
Expect(0, 8234, '\P{Is_Pattern_White_Space: f}', "");
Expect(1, 8234, '\P{^Is_Pattern_White_Space: f}', "");
Expect(0, 8233, '\p{Is_Pattern_White_Space: f}', "");
Expect(1, 8233, '\p{^Is_Pattern_White_Space: f}', "");
Expect(1, 8233, '\P{Is_Pattern_White_Space: f}', "");
Expect(0, 8233, '\P{^Is_Pattern_White_Space: f}', "");
Expect(1, 8234, '\p{Is_Pattern_White_Space= F}', "");
Expect(0, 8234, '\p{^Is_Pattern_White_Space= F}', "");
Expect(0, 8234, '\P{Is_Pattern_White_Space= F}', "");
Expect(1, 8234, '\P{^Is_Pattern_White_Space= F}', "");
Expect(0, 8233, '\p{Is_Pattern_White_Space= F}', "");
Expect(1, 8233, '\p{^Is_Pattern_White_Space= F}', "");
Expect(1, 8233, '\P{Is_Pattern_White_Space= F}', "");
Expect(0, 8233, '\P{^Is_Pattern_White_Space= F}', "");
Error('\p{Is_Pat_WS=  FALSE:=}');
Error('\P{Is_Pat_WS=  FALSE:=}');
Expect(1, 8234, '\p{Is_Pat_WS=false}', "");
Expect(0, 8234, '\p{^Is_Pat_WS=false}', "");
Expect(0, 8234, '\P{Is_Pat_WS=false}', "");
Expect(1, 8234, '\P{^Is_Pat_WS=false}', "");
Expect(0, 8233, '\p{Is_Pat_WS=false}', "");
Expect(1, 8233, '\p{^Is_Pat_WS=false}', "");
Expect(1, 8233, '\P{Is_Pat_WS=false}', "");
Expect(0, 8233, '\P{^Is_Pat_WS=false}', "");
Expect(1, 8234, '\p{Is_Pat_WS=  FALSE}', "");
Expect(0, 8234, '\p{^Is_Pat_WS=  FALSE}', "");
Expect(0, 8234, '\P{Is_Pat_WS=  FALSE}', "");
Expect(1, 8234, '\P{^Is_Pat_WS=  FALSE}', "");
Expect(0, 8233, '\p{Is_Pat_WS=  FALSE}', "");
Expect(1, 8233, '\p{^Is_Pat_WS=  FALSE}', "");
Expect(1, 8233, '\P{Is_Pat_WS=  FALSE}', "");
Expect(0, 8233, '\P{^Is_Pat_WS=  FALSE}', "");
Error('\p{Pattern_White_Space= -Yes/a/}');
Error('\P{Pattern_White_Space= -Yes/a/}');
Expect(1, 8233, '\p{Pattern_White_Space=yes}', "");
Expect(0, 8233, '\p{^Pattern_White_Space=yes}', "");
Expect(0, 8233, '\P{Pattern_White_Space=yes}', "");
Expect(1, 8233, '\P{^Pattern_White_Space=yes}', "");
Expect(0, 8234, '\p{Pattern_White_Space=yes}', "");
Expect(1, 8234, '\p{^Pattern_White_Space=yes}', "");
Expect(1, 8234, '\P{Pattern_White_Space=yes}', "");
Expect(0, 8234, '\P{^Pattern_White_Space=yes}', "");
Expect(1, 8233, '\p{Pattern_White_Space=	_yes}', "");
Expect(0, 8233, '\p{^Pattern_White_Space=	_yes}', "");
Expect(0, 8233, '\P{Pattern_White_Space=	_yes}', "");
Expect(1, 8233, '\P{^Pattern_White_Space=	_yes}', "");
Expect(0, 8234, '\p{Pattern_White_Space=	_yes}', "");
Expect(1, 8234, '\p{^Pattern_White_Space=	_yes}', "");
Expect(1, 8234, '\P{Pattern_White_Space=	_yes}', "");
Expect(0, 8234, '\P{^Pattern_White_Space=	_yes}', "");
Error('\p{Pat_WS=:=_ Y}');
Error('\P{Pat_WS=:=_ Y}');
Expect(1, 8233, '\p{Pat_WS=y}', "");
Expect(0, 8233, '\p{^Pat_WS=y}', "");
Expect(0, 8233, '\P{Pat_WS=y}', "");
Expect(1, 8233, '\P{^Pat_WS=y}', "");
Expect(0, 8234, '\p{Pat_WS=y}', "");
Expect(1, 8234, '\p{^Pat_WS=y}', "");
Expect(1, 8234, '\P{Pat_WS=y}', "");
Expect(0, 8234, '\P{^Pat_WS=y}', "");
Expect(1, 8233, '\p{Pat_WS=_Y}', "");
Expect(0, 8233, '\p{^Pat_WS=_Y}', "");
Expect(0, 8233, '\P{Pat_WS=_Y}', "");
Expect(1, 8233, '\P{^Pat_WS=_Y}', "");
Expect(0, 8234, '\p{Pat_WS=_Y}', "");
Expect(1, 8234, '\p{^Pat_WS=_Y}', "");
Expect(1, 8234, '\P{Pat_WS=_Y}', "");
Expect(0, 8234, '\P{^Pat_WS=_Y}', "");
Error('\p{Is_Pattern_White_Space=/a/	 T}');
Error('\P{Is_Pattern_White_Space=/a/	 T}');
Expect(1, 8233, '\p{Is_Pattern_White_Space=t}', "");
Expect(0, 8233, '\p{^Is_Pattern_White_Space=t}', "");
Expect(0, 8233, '\P{Is_Pattern_White_Space=t}', "");
Expect(1, 8233, '\P{^Is_Pattern_White_Space=t}', "");
Expect(0, 8234, '\p{Is_Pattern_White_Space=t}', "");
Expect(1, 8234, '\p{^Is_Pattern_White_Space=t}', "");
Expect(1, 8234, '\P{Is_Pattern_White_Space=t}', "");
Expect(0, 8234, '\P{^Is_Pattern_White_Space=t}', "");
Expect(1, 8233, '\p{Is_Pattern_White_Space=_-T}', "");
Expect(0, 8233, '\p{^Is_Pattern_White_Space=_-T}', "");
Expect(0, 8233, '\P{Is_Pattern_White_Space=_-T}', "");
Expect(1, 8233, '\P{^Is_Pattern_White_Space=_-T}', "");
Expect(0, 8234, '\p{Is_Pattern_White_Space=_-T}', "");
Expect(1, 8234, '\p{^Is_Pattern_White_Space=_-T}', "");
Expect(1, 8234, '\P{Is_Pattern_White_Space=_-T}', "");
Expect(0, 8234, '\P{^Is_Pattern_White_Space=_-T}', "");
Error('\p{Is_Pat_WS=_/a/TRUE}');
Error('\P{Is_Pat_WS=_/a/TRUE}');
Expect(1, 8233, '\p{Is_Pat_WS=true}', "");
Expect(0, 8233, '\p{^Is_Pat_WS=true}', "");
Expect(0, 8233, '\P{Is_Pat_WS=true}', "");
Expect(1, 8233, '\P{^Is_Pat_WS=true}', "");
Expect(0, 8234, '\p{Is_Pat_WS=true}', "");
Expect(1, 8234, '\p{^Is_Pat_WS=true}', "");
Expect(1, 8234, '\P{Is_Pat_WS=true}', "");
Expect(0, 8234, '\P{^Is_Pat_WS=true}', "");
Expect(1, 8233, '\p{Is_Pat_WS=	TRUE}', "");
Expect(0, 8233, '\p{^Is_Pat_WS=	TRUE}', "");
Expect(0, 8233, '\P{Is_Pat_WS=	TRUE}', "");
Expect(1, 8233, '\P{^Is_Pat_WS=	TRUE}', "");
Expect(0, 8234, '\p{Is_Pat_WS=	TRUE}', "");
Expect(1, 8234, '\p{^Is_Pat_WS=	TRUE}', "");
Expect(1, 8234, '\P{Is_Pat_WS=	TRUE}', "");
Expect(0, 8234, '\P{^Is_Pat_WS=	TRUE}', "");
Error('\p{Quotation_Mark=--No:=}');
Error('\P{Quotation_Mark=--No:=}');
Expect(1, 65380, '\p{Quotation_Mark=no}', "");
Expect(0, 65380, '\p{^Quotation_Mark=no}', "");
Expect(0, 65380, '\P{Quotation_Mark=no}', "");
Expect(1, 65380, '\P{^Quotation_Mark=no}', "");
Expect(0, 65379, '\p{Quotation_Mark=no}', "");
Expect(1, 65379, '\p{^Quotation_Mark=no}', "");
Expect(1, 65379, '\P{Quotation_Mark=no}', "");
Expect(0, 65379, '\P{^Quotation_Mark=no}', "");
Expect(1, 65380, '\p{Quotation_Mark=__No}', "");
Expect(0, 65380, '\p{^Quotation_Mark=__No}', "");
Expect(0, 65380, '\P{Quotation_Mark=__No}', "");
Expect(1, 65380, '\P{^Quotation_Mark=__No}', "");
Expect(0, 65379, '\p{Quotation_Mark=__No}', "");
Expect(1, 65379, '\p{^Quotation_Mark=__No}', "");
Expect(1, 65379, '\P{Quotation_Mark=__No}', "");
Expect(0, 65379, '\P{^Quotation_Mark=__No}', "");
Error('\p{QMark= /a/n}');
Error('\P{QMark= /a/n}');
Expect(1, 65380, '\p{QMark=n}', "");
Expect(0, 65380, '\p{^QMark=n}', "");
Expect(0, 65380, '\P{QMark=n}', "");
Expect(1, 65380, '\P{^QMark=n}', "");
Expect(0, 65379, '\p{QMark=n}', "");
Expect(1, 65379, '\p{^QMark=n}', "");
Expect(1, 65379, '\P{QMark=n}', "");
Expect(0, 65379, '\P{^QMark=n}', "");
Expect(1, 65380, '\p{QMark=--N}', "");
Expect(0, 65380, '\p{^QMark=--N}', "");
Expect(0, 65380, '\P{QMark=--N}', "");
Expect(1, 65380, '\P{^QMark=--N}', "");
Expect(0, 65379, '\p{QMark=--N}', "");
Expect(1, 65379, '\p{^QMark=--N}', "");
Expect(1, 65379, '\P{QMark=--N}', "");
Expect(0, 65379, '\P{^QMark=--N}', "");
Error('\p{Is_Quotation_Mark=/a/_	F}');
Error('\P{Is_Quotation_Mark=/a/_	F}');
Expect(1, 65380, '\p{Is_Quotation_Mark=f}', "");
Expect(0, 65380, '\p{^Is_Quotation_Mark=f}', "");
Expect(0, 65380, '\P{Is_Quotation_Mark=f}', "");
Expect(1, 65380, '\P{^Is_Quotation_Mark=f}', "");
Expect(0, 65379, '\p{Is_Quotation_Mark=f}', "");
Expect(1, 65379, '\p{^Is_Quotation_Mark=f}', "");
Expect(1, 65379, '\P{Is_Quotation_Mark=f}', "");
Expect(0, 65379, '\P{^Is_Quotation_Mark=f}', "");
Expect(1, 65380, '\p{Is_Quotation_Mark=-	f}', "");
Expect(0, 65380, '\p{^Is_Quotation_Mark=-	f}', "");
Expect(0, 65380, '\P{Is_Quotation_Mark=-	f}', "");
Expect(1, 65380, '\P{^Is_Quotation_Mark=-	f}', "");
Expect(0, 65379, '\p{Is_Quotation_Mark=-	f}', "");
Expect(1, 65379, '\p{^Is_Quotation_Mark=-	f}', "");
Expect(1, 65379, '\P{Is_Quotation_Mark=-	f}', "");
Expect(0, 65379, '\P{^Is_Quotation_Mark=-	f}', "");
Error('\p{Is_QMark= /a/False}');
Error('\P{Is_QMark= /a/False}');
Expect(1, 65380, '\p{Is_QMark:   false}', "");
Expect(0, 65380, '\p{^Is_QMark:   false}', "");
Expect(0, 65380, '\P{Is_QMark:   false}', "");
Expect(1, 65380, '\P{^Is_QMark:   false}', "");
Expect(0, 65379, '\p{Is_QMark:   false}', "");
Expect(1, 65379, '\p{^Is_QMark:   false}', "");
Expect(1, 65379, '\P{Is_QMark:   false}', "");
Expect(0, 65379, '\P{^Is_QMark:   false}', "");
Expect(1, 65380, '\p{Is_QMark=_-False}', "");
Expect(0, 65380, '\p{^Is_QMark=_-False}', "");
Expect(0, 65380, '\P{Is_QMark=_-False}', "");
Expect(1, 65380, '\P{^Is_QMark=_-False}', "");
Expect(0, 65379, '\p{Is_QMark=_-False}', "");
Expect(1, 65379, '\p{^Is_QMark=_-False}', "");
Expect(1, 65379, '\P{Is_QMark=_-False}', "");
Expect(0, 65379, '\P{^Is_QMark=_-False}', "");
Error('\p{Quotation_Mark= YES:=}');
Error('\P{Quotation_Mark= YES:=}');
Expect(1, 65379, '\p{Quotation_Mark=yes}', "");
Expect(0, 65379, '\p{^Quotation_Mark=yes}', "");
Expect(0, 65379, '\P{Quotation_Mark=yes}', "");
Expect(1, 65379, '\P{^Quotation_Mark=yes}', "");
Expect(0, 65380, '\p{Quotation_Mark=yes}', "");
Expect(1, 65380, '\p{^Quotation_Mark=yes}', "");
Expect(1, 65380, '\P{Quotation_Mark=yes}', "");
Expect(0, 65380, '\P{^Quotation_Mark=yes}', "");
Expect(1, 65379, '\p{Quotation_Mark=-_yes}', "");
Expect(0, 65379, '\p{^Quotation_Mark=-_yes}', "");
Expect(0, 65379, '\P{Quotation_Mark=-_yes}', "");
Expect(1, 65379, '\P{^Quotation_Mark=-_yes}', "");
Expect(0, 65380, '\p{Quotation_Mark=-_yes}', "");
Expect(1, 65380, '\p{^Quotation_Mark=-_yes}', "");
Expect(1, 65380, '\P{Quotation_Mark=-_yes}', "");
Expect(0, 65380, '\P{^Quotation_Mark=-_yes}', "");
Error('\p{QMark=/a/		Y}');
Error('\P{QMark=/a/		Y}');
Expect(1, 65379, '\p{QMark=y}', "");
Expect(0, 65379, '\p{^QMark=y}', "");
Expect(0, 65379, '\P{QMark=y}', "");
Expect(1, 65379, '\P{^QMark=y}', "");
Expect(0, 65380, '\p{QMark=y}', "");
Expect(1, 65380, '\p{^QMark=y}', "");
Expect(1, 65380, '\P{QMark=y}', "");
Expect(0, 65380, '\P{^QMark=y}', "");
Expect(1, 65379, '\p{QMark=-Y}', "");
Expect(0, 65379, '\p{^QMark=-Y}', "");
Expect(0, 65379, '\P{QMark=-Y}', "");
Expect(1, 65379, '\P{^QMark=-Y}', "");
Expect(0, 65380, '\p{QMark=-Y}', "");
Expect(1, 65380, '\p{^QMark=-Y}', "");
Expect(1, 65380, '\P{QMark=-Y}', "");
Expect(0, 65380, '\P{^QMark=-Y}', "");
Error('\p{Is_Quotation_Mark= 	T:=}');
Error('\P{Is_Quotation_Mark= 	T:=}');
Expect(1, 65379, '\p{Is_Quotation_Mark=t}', "");
Expect(0, 65379, '\p{^Is_Quotation_Mark=t}', "");
Expect(0, 65379, '\P{Is_Quotation_Mark=t}', "");
Expect(1, 65379, '\P{^Is_Quotation_Mark=t}', "");
Expect(0, 65380, '\p{Is_Quotation_Mark=t}', "");
Expect(1, 65380, '\p{^Is_Quotation_Mark=t}', "");
Expect(1, 65380, '\P{Is_Quotation_Mark=t}', "");
Expect(0, 65380, '\P{^Is_Quotation_Mark=t}', "");
Expect(1, 65379, '\p{Is_Quotation_Mark=- T}', "");
Expect(0, 65379, '\p{^Is_Quotation_Mark=- T}', "");
Expect(0, 65379, '\P{Is_Quotation_Mark=- T}', "");
Expect(1, 65379, '\P{^Is_Quotation_Mark=- T}', "");
Expect(0, 65380, '\p{Is_Quotation_Mark=- T}', "");
Expect(1, 65380, '\p{^Is_Quotation_Mark=- T}', "");
Expect(1, 65380, '\P{Is_Quotation_Mark=- T}', "");
Expect(0, 65380, '\P{^Is_Quotation_Mark=- T}', "");
Error('\p{Is_QMark=_/a/True}');
Error('\P{Is_QMark=_/a/True}');
Expect(1, 65379, '\p{Is_QMark=true}', "");
Expect(0, 65379, '\p{^Is_QMark=true}', "");
Expect(0, 65379, '\P{Is_QMark=true}', "");
Expect(1, 65379, '\P{^Is_QMark=true}', "");
Expect(0, 65380, '\p{Is_QMark=true}', "");
Expect(1, 65380, '\p{^Is_QMark=true}', "");
Expect(1, 65380, '\P{Is_QMark=true}', "");
Expect(0, 65380, '\P{^Is_QMark=true}', "");
Expect(1, 65379, '\p{Is_QMark=_TRUE}', "");
Expect(0, 65379, '\p{^Is_QMark=_TRUE}', "");
Expect(0, 65379, '\P{Is_QMark=_TRUE}', "");
Expect(1, 65379, '\P{^Is_QMark=_TRUE}', "");
Expect(0, 65380, '\p{Is_QMark=_TRUE}', "");
Expect(1, 65380, '\p{^Is_QMark=_TRUE}', "");
Expect(1, 65380, '\P{Is_QMark=_TRUE}', "");
Expect(0, 65380, '\P{^Is_QMark=_TRUE}', "");
Error('\p{Radical= /a/No}');
Error('\P{Radical= /a/No}');
Expect(1, 12246, '\p{Radical: no}', "");
Expect(0, 12246, '\p{^Radical: no}', "");
Expect(0, 12246, '\P{Radical: no}', "");
Expect(1, 12246, '\P{^Radical: no}', "");
Expect(0, 12245, '\p{Radical: no}', "");
Expect(1, 12245, '\p{^Radical: no}', "");
Expect(1, 12245, '\P{Radical: no}', "");
Expect(0, 12245, '\P{^Radical: no}', "");
Expect(1, 12246, '\p{Radical:     No}', "");
Expect(0, 12246, '\p{^Radical:     No}', "");
Expect(0, 12246, '\P{Radical:     No}', "");
Expect(1, 12246, '\P{^Radical:     No}', "");
Expect(0, 12245, '\p{Radical:     No}', "");
Expect(1, 12245, '\p{^Radical:     No}', "");
Expect(1, 12245, '\P{Radical:     No}', "");
Expect(0, 12245, '\P{^Radical:     No}', "");
Error('\p{Is_Radical= N/a/}');
Error('\P{Is_Radical= N/a/}');
Expect(1, 12246, '\p{Is_Radical=n}', "");
Expect(0, 12246, '\p{^Is_Radical=n}', "");
Expect(0, 12246, '\P{Is_Radical=n}', "");
Expect(1, 12246, '\P{^Is_Radical=n}', "");
Expect(0, 12245, '\p{Is_Radical=n}', "");
Expect(1, 12245, '\p{^Is_Radical=n}', "");
Expect(1, 12245, '\P{Is_Radical=n}', "");
Expect(0, 12245, '\P{^Is_Radical=n}', "");
Expect(1, 12246, '\p{Is_Radical=-N}', "");
Expect(0, 12246, '\p{^Is_Radical=-N}', "");
Expect(0, 12246, '\P{Is_Radical=-N}', "");
Expect(1, 12246, '\P{^Is_Radical=-N}', "");
Expect(0, 12245, '\p{Is_Radical=-N}', "");
Expect(1, 12245, '\p{^Is_Radical=-N}', "");
Expect(1, 12245, '\P{Is_Radical=-N}', "");
Expect(0, 12245, '\P{^Is_Radical=-N}', "");
Error('\p{Radical=/a/ 	F}');
Error('\P{Radical=/a/ 	F}');
Expect(1, 12246, '\p{Radical=f}', "");
Expect(0, 12246, '\p{^Radical=f}', "");
Expect(0, 12246, '\P{Radical=f}', "");
Expect(1, 12246, '\P{^Radical=f}', "");
Expect(0, 12245, '\p{Radical=f}', "");
Expect(1, 12245, '\p{^Radical=f}', "");
Expect(1, 12245, '\P{Radical=f}', "");
Expect(0, 12245, '\P{^Radical=f}', "");
Expect(1, 12246, '\p{Radical=_F}', "");
Expect(0, 12246, '\p{^Radical=_F}', "");
Expect(0, 12246, '\P{Radical=_F}', "");
Expect(1, 12246, '\P{^Radical=_F}', "");
Expect(0, 12245, '\p{Radical=_F}', "");
Expect(1, 12245, '\p{^Radical=_F}', "");
Expect(1, 12245, '\P{Radical=_F}', "");
Expect(0, 12245, '\P{^Radical=_F}', "");
Error('\p{Is_Radical=-	FALSE/a/}');
Error('\P{Is_Radical=-	FALSE/a/}');
Expect(1, 12246, '\p{Is_Radical=false}', "");
Expect(0, 12246, '\p{^Is_Radical=false}', "");
Expect(0, 12246, '\P{Is_Radical=false}', "");
Expect(1, 12246, '\P{^Is_Radical=false}', "");
Expect(0, 12245, '\p{Is_Radical=false}', "");
Expect(1, 12245, '\p{^Is_Radical=false}', "");
Expect(1, 12245, '\P{Is_Radical=false}', "");
Expect(0, 12245, '\P{^Is_Radical=false}', "");
Error('\p{Radical=--Yes/a/}');
Error('\P{Radical=--Yes/a/}');
Expect(1, 12245, '\p{Radical=yes}', "");
Expect(0, 12245, '\p{^Radical=yes}', "");
Expect(0, 12245, '\P{Radical=yes}', "");
Expect(1, 12245, '\P{^Radical=yes}', "");
Expect(0, 12246, '\p{Radical=yes}', "");
Expect(1, 12246, '\p{^Radical=yes}', "");
Expect(1, 12246, '\P{Radical=yes}', "");
Expect(0, 12246, '\P{^Radical=yes}', "");
Expect(1, 12245, '\p{Radical=	 yes}', "");
Expect(0, 12245, '\p{^Radical=	 yes}', "");
Expect(0, 12245, '\P{Radical=	 yes}', "");
Expect(1, 12245, '\P{^Radical=	 yes}', "");
Expect(0, 12246, '\p{Radical=	 yes}', "");
Expect(1, 12246, '\p{^Radical=	 yes}', "");
Expect(1, 12246, '\P{Radical=	 yes}', "");
Expect(0, 12246, '\P{^Radical=	 yes}', "");
Error('\p{Is_Radical= _Y/a/}');
Error('\P{Is_Radical= _Y/a/}');
Expect(1, 12245, '\p{Is_Radical=y}', "");
Expect(0, 12245, '\p{^Is_Radical=y}', "");
Expect(0, 12245, '\P{Is_Radical=y}', "");
Expect(1, 12245, '\P{^Is_Radical=y}', "");
Expect(0, 12246, '\p{Is_Radical=y}', "");
Expect(1, 12246, '\p{^Is_Radical=y}', "");
Expect(1, 12246, '\P{Is_Radical=y}', "");
Expect(0, 12246, '\P{^Is_Radical=y}', "");
Expect(1, 12245, '\p{Is_Radical=_	y}', "");
Expect(0, 12245, '\p{^Is_Radical=_	y}', "");
Expect(0, 12245, '\P{Is_Radical=_	y}', "");
Expect(1, 12245, '\P{^Is_Radical=_	y}', "");
Expect(0, 12246, '\p{Is_Radical=_	y}', "");
Expect(1, 12246, '\p{^Is_Radical=_	y}', "");
Expect(1, 12246, '\P{Is_Radical=_	y}', "");
Expect(0, 12246, '\P{^Is_Radical=_	y}', "");
Error('\p{Radical=:=-T}');
Error('\P{Radical=:=-T}');
Expect(1, 12245, '\p{Radical=t}', "");
Expect(0, 12245, '\p{^Radical=t}', "");
Expect(0, 12245, '\P{Radical=t}', "");
Expect(1, 12245, '\P{^Radical=t}', "");
Expect(0, 12246, '\p{Radical=t}', "");
Expect(1, 12246, '\p{^Radical=t}', "");
Expect(1, 12246, '\P{Radical=t}', "");
Expect(0, 12246, '\P{^Radical=t}', "");
Expect(1, 12245, '\p{Radical=	t}', "");
Expect(0, 12245, '\p{^Radical=	t}', "");
Expect(0, 12245, '\P{Radical=	t}', "");
Expect(1, 12245, '\P{^Radical=	t}', "");
Expect(0, 12246, '\p{Radical=	t}', "");
Expect(1, 12246, '\p{^Radical=	t}', "");
Expect(1, 12246, '\P{Radical=	t}', "");
Expect(0, 12246, '\P{^Radical=	t}', "");
Error('\p{Is_Radical:		True/a/}');
Error('\P{Is_Radical:		True/a/}');
Expect(1, 12245, '\p{Is_Radical=true}', "");
Expect(0, 12245, '\p{^Is_Radical=true}', "");
Expect(0, 12245, '\P{Is_Radical=true}', "");
Expect(1, 12245, '\P{^Is_Radical=true}', "");
Expect(0, 12246, '\p{Is_Radical=true}', "");
Expect(1, 12246, '\p{^Is_Radical=true}', "");
Expect(1, 12246, '\P{Is_Radical=true}', "");
Expect(0, 12246, '\P{^Is_Radical=true}', "");
Expect(1, 12245, '\p{Is_Radical=_	True}', "");
Expect(0, 12245, '\p{^Is_Radical=_	True}', "");
Expect(0, 12245, '\P{Is_Radical=_	True}', "");
Expect(1, 12245, '\P{^Is_Radical=_	True}', "");
Expect(0, 12246, '\p{Is_Radical=_	True}', "");
Expect(1, 12246, '\p{^Is_Radical=_	True}', "");
Expect(1, 12246, '\P{Is_Radical=_	True}', "");
Expect(0, 12246, '\P{^Is_Radical=_	True}', "");
Error('\p{Sentence_Break=	:=aterm}');
Error('\P{Sentence_Break=	:=aterm}');
Expect(1, 65294, '\p{Sentence_Break=aterm}', "");
Expect(0, 65294, '\p{^Sentence_Break=aterm}', "");
Expect(0, 65294, '\P{Sentence_Break=aterm}', "");
Expect(1, 65294, '\P{^Sentence_Break=aterm}', "");
Expect(0, 65295, '\p{Sentence_Break=aterm}', "");
Expect(1, 65295, '\p{^Sentence_Break=aterm}', "");
Expect(1, 65295, '\P{Sentence_Break=aterm}', "");
Expect(0, 65295, '\P{^Sentence_Break=aterm}', "");
Expect(1, 65294, '\p{Sentence_Break:   - aterm}', "");
Expect(0, 65294, '\p{^Sentence_Break:   - aterm}', "");
Expect(0, 65294, '\P{Sentence_Break:   - aterm}', "");
Expect(1, 65294, '\P{^Sentence_Break:   - aterm}', "");
Expect(0, 65295, '\p{Sentence_Break:   - aterm}', "");
Expect(1, 65295, '\p{^Sentence_Break:   - aterm}', "");
Expect(1, 65295, '\P{Sentence_Break:   - aterm}', "");
Expect(0, 65295, '\P{^Sentence_Break:   - aterm}', "");
Error('\p{SB=- AT/a/}');
Error('\P{SB=- AT/a/}');
Expect(1, 65294, '\p{SB=at}', "");
Expect(0, 65294, '\p{^SB=at}', "");
Expect(0, 65294, '\P{SB=at}', "");
Expect(1, 65294, '\P{^SB=at}', "");
Expect(0, 65295, '\p{SB=at}', "");
Expect(1, 65295, '\p{^SB=at}', "");
Expect(1, 65295, '\P{SB=at}', "");
Expect(0, 65295, '\P{^SB=at}', "");
Expect(1, 65294, '\p{SB=	at}', "");
Expect(0, 65294, '\p{^SB=	at}', "");
Expect(0, 65294, '\P{SB=	at}', "");
Expect(1, 65294, '\P{^SB=	at}', "");
Expect(0, 65295, '\p{SB=	at}', "");
Expect(1, 65295, '\p{^SB=	at}', "");
Expect(1, 65295, '\P{SB=	at}', "");
Expect(0, 65295, '\P{^SB=	at}', "");
Error('\p{Is_Sentence_Break=/a/_ATerm}');
Error('\P{Is_Sentence_Break=/a/_ATerm}');
Expect(1, 65294, '\p{Is_Sentence_Break=aterm}', "");
Expect(0, 65294, '\p{^Is_Sentence_Break=aterm}', "");
Expect(0, 65294, '\P{Is_Sentence_Break=aterm}', "");
Expect(1, 65294, '\P{^Is_Sentence_Break=aterm}', "");
Expect(0, 65295, '\p{Is_Sentence_Break=aterm}', "");
Expect(1, 65295, '\p{^Is_Sentence_Break=aterm}', "");
Expect(1, 65295, '\P{Is_Sentence_Break=aterm}', "");
Expect(0, 65295, '\P{^Is_Sentence_Break=aterm}', "");
Expect(1, 65294, '\p{Is_Sentence_Break=_ATERM}', "");
Expect(0, 65294, '\p{^Is_Sentence_Break=_ATERM}', "");
Expect(0, 65294, '\P{Is_Sentence_Break=_ATERM}', "");
Expect(1, 65294, '\P{^Is_Sentence_Break=_ATERM}', "");
Expect(0, 65295, '\p{Is_Sentence_Break=_ATERM}', "");
Expect(1, 65295, '\p{^Is_Sentence_Break=_ATERM}', "");
Expect(1, 65295, '\P{Is_Sentence_Break=_ATERM}', "");
Expect(0, 65295, '\P{^Is_Sentence_Break=_ATERM}', "");
Error('\p{Is_SB: 	 AT/a/}');
Error('\P{Is_SB: 	 AT/a/}');
Expect(1, 65294, '\p{Is_SB=at}', "");
Expect(0, 65294, '\p{^Is_SB=at}', "");
Expect(0, 65294, '\P{Is_SB=at}', "");
Expect(1, 65294, '\P{^Is_SB=at}', "");
Expect(0, 65295, '\p{Is_SB=at}', "");
Expect(1, 65295, '\p{^Is_SB=at}', "");
Expect(1, 65295, '\P{Is_SB=at}', "");
Expect(0, 65295, '\P{^Is_SB=at}', "");
Expect(1, 65294, '\p{Is_SB=-AT}', "");
Expect(0, 65294, '\p{^Is_SB=-AT}', "");
Expect(0, 65294, '\P{Is_SB=-AT}', "");
Expect(1, 65294, '\P{^Is_SB=-AT}', "");
Expect(0, 65295, '\p{Is_SB=-AT}', "");
Expect(1, 65295, '\p{^Is_SB=-AT}', "");
Expect(1, 65295, '\P{Is_SB=-AT}', "");
Expect(0, 65295, '\P{^Is_SB=-AT}', "");
Error('\p{Sentence_Break=:=-close}');
Error('\P{Sentence_Break=:=-close}');
Expect(1, 128632, '\p{Sentence_Break=close}', "");
Expect(0, 128632, '\p{^Sentence_Break=close}', "");
Expect(0, 128632, '\P{Sentence_Break=close}', "");
Expect(1, 128632, '\P{^Sentence_Break=close}', "");
Expect(0, 128633, '\p{Sentence_Break=close}', "");
Expect(1, 128633, '\p{^Sentence_Break=close}', "");
Expect(1, 128633, '\P{Sentence_Break=close}', "");
Expect(0, 128633, '\P{^Sentence_Break=close}', "");
Expect(1, 128632, '\p{Sentence_Break= -Close}', "");
Expect(0, 128632, '\p{^Sentence_Break= -Close}', "");
Expect(0, 128632, '\P{Sentence_Break= -Close}', "");
Expect(1, 128632, '\P{^Sentence_Break= -Close}', "");
Expect(0, 128633, '\p{Sentence_Break= -Close}', "");
Expect(1, 128633, '\p{^Sentence_Break= -Close}', "");
Expect(1, 128633, '\P{Sentence_Break= -Close}', "");
Expect(0, 128633, '\P{^Sentence_Break= -Close}', "");
Error('\p{SB: -_CL/a/}');
Error('\P{SB: -_CL/a/}');
Expect(1, 128632, '\p{SB=cl}', "");
Expect(0, 128632, '\p{^SB=cl}', "");
Expect(0, 128632, '\P{SB=cl}', "");
Expect(1, 128632, '\P{^SB=cl}', "");
Expect(0, 128633, '\p{SB=cl}', "");
Expect(1, 128633, '\p{^SB=cl}', "");
Expect(1, 128633, '\P{SB=cl}', "");
Expect(0, 128633, '\P{^SB=cl}', "");
Expect(1, 128632, '\p{SB=_ CL}', "");
Expect(0, 128632, '\p{^SB=_ CL}', "");
Expect(0, 128632, '\P{SB=_ CL}', "");
Expect(1, 128632, '\P{^SB=_ CL}', "");
Expect(0, 128633, '\p{SB=_ CL}', "");
Expect(1, 128633, '\p{^SB=_ CL}', "");
Expect(1, 128633, '\P{SB=_ CL}', "");
Expect(0, 128633, '\P{^SB=_ CL}', "");
Error('\p{Is_Sentence_Break=_:=CLOSE}');
Error('\P{Is_Sentence_Break=_:=CLOSE}');
Expect(1, 128632, '\p{Is_Sentence_Break=close}', "");
Expect(0, 128632, '\p{^Is_Sentence_Break=close}', "");
Expect(0, 128632, '\P{Is_Sentence_Break=close}', "");
Expect(1, 128632, '\P{^Is_Sentence_Break=close}', "");
Expect(0, 128633, '\p{Is_Sentence_Break=close}', "");
Expect(1, 128633, '\p{^Is_Sentence_Break=close}', "");
Expect(1, 128633, '\P{Is_Sentence_Break=close}', "");
Expect(0, 128633, '\P{^Is_Sentence_Break=close}', "");
Expect(1, 128632, '\p{Is_Sentence_Break=	 CLOSE}', "");
Expect(0, 128632, '\p{^Is_Sentence_Break=	 CLOSE}', "");
Expect(0, 128632, '\P{Is_Sentence_Break=	 CLOSE}', "");
Expect(1, 128632, '\P{^Is_Sentence_Break=	 CLOSE}', "");
Expect(0, 128633, '\p{Is_Sentence_Break=	 CLOSE}', "");
Expect(1, 128633, '\p{^Is_Sentence_Break=	 CLOSE}', "");
Expect(1, 128633, '\P{Is_Sentence_Break=	 CLOSE}', "");
Expect(0, 128633, '\P{^Is_Sentence_Break=	 CLOSE}', "");
Error('\p{Is_SB=/a/CL}');
Error('\P{Is_SB=/a/CL}');
Expect(1, 128632, '\p{Is_SB=cl}', "");
Expect(0, 128632, '\p{^Is_SB=cl}', "");
Expect(0, 128632, '\P{Is_SB=cl}', "");
Expect(1, 128632, '\P{^Is_SB=cl}', "");
Expect(0, 128633, '\p{Is_SB=cl}', "");
Expect(1, 128633, '\p{^Is_SB=cl}', "");
Expect(1, 128633, '\P{Is_SB=cl}', "");
Expect(0, 128633, '\P{^Is_SB=cl}', "");
Expect(1, 128632, '\p{Is_SB:	 cl}', "");
Expect(0, 128632, '\p{^Is_SB:	 cl}', "");
Expect(0, 128632, '\P{Is_SB:	 cl}', "");
Expect(1, 128632, '\P{^Is_SB:	 cl}', "");
Expect(0, 128633, '\p{Is_SB:	 cl}', "");
Expect(1, 128633, '\p{^Is_SB:	 cl}', "");
Expect(1, 128633, '\P{Is_SB:	 cl}', "");
Expect(0, 128633, '\P{^Is_SB:	 cl}', "");
Error('\p{Sentence_Break=	/a/cr}');
Error('\P{Sentence_Break=	/a/cr}');
Expect(1, 13, '\p{Sentence_Break=cr}', "");
Expect(0, 13, '\p{^Sentence_Break=cr}', "");
Expect(0, 13, '\P{Sentence_Break=cr}', "");
Expect(1, 13, '\P{^Sentence_Break=cr}', "");
Expect(0, 14, '\p{Sentence_Break=cr}', "");
Expect(1, 14, '\p{^Sentence_Break=cr}', "");
Expect(1, 14, '\P{Sentence_Break=cr}', "");
Expect(0, 14, '\P{^Sentence_Break=cr}', "");
Expect(1, 13, '\p{Sentence_Break=	 CR}', "");
Expect(0, 13, '\p{^Sentence_Break=	 CR}', "");
Expect(0, 13, '\P{Sentence_Break=	 CR}', "");
Expect(1, 13, '\P{^Sentence_Break=	 CR}', "");
Expect(0, 14, '\p{Sentence_Break=	 CR}', "");
Expect(1, 14, '\p{^Sentence_Break=	 CR}', "");
Expect(1, 14, '\P{Sentence_Break=	 CR}', "");
Expect(0, 14, '\P{^Sentence_Break=	 CR}', "");
Error('\p{SB=__cr/a/}');
Error('\P{SB=__cr/a/}');
Expect(1, 13, '\p{SB=cr}', "");
Expect(0, 13, '\p{^SB=cr}', "");
Expect(0, 13, '\P{SB=cr}', "");
Expect(1, 13, '\P{^SB=cr}', "");
Expect(0, 14, '\p{SB=cr}', "");
Expect(1, 14, '\p{^SB=cr}', "");
Expect(1, 14, '\P{SB=cr}', "");
Expect(0, 14, '\P{^SB=cr}', "");
Expect(1, 13, '\p{SB=--CR}', "");
Expect(0, 13, '\p{^SB=--CR}', "");
Expect(0, 13, '\P{SB=--CR}', "");
Expect(1, 13, '\P{^SB=--CR}', "");
Expect(0, 14, '\p{SB=--CR}', "");
Expect(1, 14, '\p{^SB=--CR}', "");
Expect(1, 14, '\P{SB=--CR}', "");
Expect(0, 14, '\P{^SB=--CR}', "");
Error('\p{Is_Sentence_Break=	_cr/a/}');
Error('\P{Is_Sentence_Break=	_cr/a/}');
Expect(1, 13, '\p{Is_Sentence_Break=cr}', "");
Expect(0, 13, '\p{^Is_Sentence_Break=cr}', "");
Expect(0, 13, '\P{Is_Sentence_Break=cr}', "");
Expect(1, 13, '\P{^Is_Sentence_Break=cr}', "");
Expect(0, 14, '\p{Is_Sentence_Break=cr}', "");
Expect(1, 14, '\p{^Is_Sentence_Break=cr}', "");
Expect(1, 14, '\P{Is_Sentence_Break=cr}', "");
Expect(0, 14, '\P{^Is_Sentence_Break=cr}', "");
Expect(1, 13, '\p{Is_Sentence_Break=	_CR}', "");
Expect(0, 13, '\p{^Is_Sentence_Break=	_CR}', "");
Expect(0, 13, '\P{Is_Sentence_Break=	_CR}', "");
Expect(1, 13, '\P{^Is_Sentence_Break=	_CR}', "");
Expect(0, 14, '\p{Is_Sentence_Break=	_CR}', "");
Expect(1, 14, '\p{^Is_Sentence_Break=	_CR}', "");
Expect(1, 14, '\P{Is_Sentence_Break=	_CR}', "");
Expect(0, 14, '\P{^Is_Sentence_Break=	_CR}', "");
Error('\p{Is_SB=CR:=}');
Error('\P{Is_SB=CR:=}');
Expect(1, 13, '\p{Is_SB=cr}', "");
Expect(0, 13, '\p{^Is_SB=cr}', "");
Expect(0, 13, '\P{Is_SB=cr}', "");
Expect(1, 13, '\P{^Is_SB=cr}', "");
Expect(0, 14, '\p{Is_SB=cr}', "");
Expect(1, 14, '\p{^Is_SB=cr}', "");
Expect(1, 14, '\P{Is_SB=cr}', "");
Expect(0, 14, '\P{^Is_SB=cr}', "");
Expect(1, 13, '\p{Is_SB=	_cr}', "");
Expect(0, 13, '\p{^Is_SB=	_cr}', "");
Expect(0, 13, '\P{Is_SB=	_cr}', "");
Expect(1, 13, '\P{^Is_SB=	_cr}', "");
Expect(0, 14, '\p{Is_SB=	_cr}', "");
Expect(1, 14, '\p{^Is_SB=	_cr}', "");
Expect(1, 14, '\P{Is_SB=	_cr}', "");
Expect(0, 14, '\P{^Is_SB=	_cr}', "");
Error('\p{Sentence_Break=/a/-_Extend}');
Error('\P{Sentence_Break=/a/-_Extend}');
Expect(1, 917999, '\p{Sentence_Break:	extend}', "");
Expect(0, 917999, '\p{^Sentence_Break:	extend}', "");
Expect(0, 917999, '\P{Sentence_Break:	extend}', "");
Expect(1, 917999, '\P{^Sentence_Break:	extend}', "");
Expect(0, 918000, '\p{Sentence_Break:	extend}', "");
Expect(1, 918000, '\p{^Sentence_Break:	extend}', "");
Expect(1, 918000, '\P{Sentence_Break:	extend}', "");
Expect(0, 918000, '\P{^Sentence_Break:	extend}', "");
Expect(1, 917999, '\p{Sentence_Break=-	Extend}', "");
Expect(0, 917999, '\p{^Sentence_Break=-	Extend}', "");
Expect(0, 917999, '\P{Sentence_Break=-	Extend}', "");
Expect(1, 917999, '\P{^Sentence_Break=-	Extend}', "");
Expect(0, 918000, '\p{Sentence_Break=-	Extend}', "");
Expect(1, 918000, '\p{^Sentence_Break=-	Extend}', "");
Expect(1, 918000, '\P{Sentence_Break=-	Extend}', "");
Expect(0, 918000, '\P{^Sentence_Break=-	Extend}', "");
Error('\p{SB=_/a/EX}');
Error('\P{SB=_/a/EX}');
Expect(1, 917999, '\p{SB=ex}', "");
Expect(0, 917999, '\p{^SB=ex}', "");
Expect(0, 917999, '\P{SB=ex}', "");
Expect(1, 917999, '\P{^SB=ex}', "");
Expect(0, 918000, '\p{SB=ex}', "");
Expect(1, 918000, '\p{^SB=ex}', "");
Expect(1, 918000, '\P{SB=ex}', "");
Expect(0, 918000, '\P{^SB=ex}', "");
Expect(1, 917999, '\p{SB=_-EX}', "");
Expect(0, 917999, '\p{^SB=_-EX}', "");
Expect(0, 917999, '\P{SB=_-EX}', "");
Expect(1, 917999, '\P{^SB=_-EX}', "");
Expect(0, 918000, '\p{SB=_-EX}', "");
Expect(1, 918000, '\p{^SB=_-EX}', "");
Expect(1, 918000, '\P{SB=_-EX}', "");
Expect(0, 918000, '\P{^SB=_-EX}', "");
Error('\p{Is_Sentence_Break=:= extend}');
Error('\P{Is_Sentence_Break=:= extend}');
Expect(1, 917999, '\p{Is_Sentence_Break=extend}', "");
Expect(0, 917999, '\p{^Is_Sentence_Break=extend}', "");
Expect(0, 917999, '\P{Is_Sentence_Break=extend}', "");
Expect(1, 917999, '\P{^Is_Sentence_Break=extend}', "");
Expect(0, 918000, '\p{Is_Sentence_Break=extend}', "");
Expect(1, 918000, '\p{^Is_Sentence_Break=extend}', "");
Expect(1, 918000, '\P{Is_Sentence_Break=extend}', "");
Expect(0, 918000, '\P{^Is_Sentence_Break=extend}', "");
Expect(1, 917999, '\p{Is_Sentence_Break=-extend}', "");
Expect(0, 917999, '\p{^Is_Sentence_Break=-extend}', "");
Expect(0, 917999, '\P{Is_Sentence_Break=-extend}', "");
Expect(1, 917999, '\P{^Is_Sentence_Break=-extend}', "");
Expect(0, 918000, '\p{Is_Sentence_Break=-extend}', "");
Expect(1, 918000, '\p{^Is_Sentence_Break=-extend}', "");
Expect(1, 918000, '\P{Is_Sentence_Break=-extend}', "");
Expect(0, 918000, '\P{^Is_Sentence_Break=-extend}', "");
Error('\p{Is_SB=:= EX}');
Error('\P{Is_SB=:= EX}');
Expect(1, 917999, '\p{Is_SB=ex}', "");
Expect(0, 917999, '\p{^Is_SB=ex}', "");
Expect(0, 917999, '\P{Is_SB=ex}', "");
Expect(1, 917999, '\P{^Is_SB=ex}', "");
Expect(0, 918000, '\p{Is_SB=ex}', "");
Expect(1, 918000, '\p{^Is_SB=ex}', "");
Expect(1, 918000, '\P{Is_SB=ex}', "");
Expect(0, 918000, '\P{^Is_SB=ex}', "");
Expect(1, 917999, '\p{Is_SB= _ex}', "");
Expect(0, 917999, '\p{^Is_SB= _ex}', "");
Expect(0, 917999, '\P{Is_SB= _ex}', "");
Expect(1, 917999, '\P{^Is_SB= _ex}', "");
Expect(0, 918000, '\p{Is_SB= _ex}', "");
Expect(1, 918000, '\p{^Is_SB= _ex}', "");
Expect(1, 918000, '\P{Is_SB= _ex}', "");
Expect(0, 918000, '\P{^Is_SB= _ex}', "");
Error('\p{Sentence_Break=/a/-format}');
Error('\P{Sentence_Break=/a/-format}');
Expect(1, 917631, '\p{Sentence_Break=format}', "");
Expect(0, 917631, '\p{^Sentence_Break=format}', "");
Expect(0, 917631, '\P{Sentence_Break=format}', "");
Expect(1, 917631, '\P{^Sentence_Break=format}', "");
Expect(0, 917632, '\p{Sentence_Break=format}', "");
Expect(1, 917632, '\p{^Sentence_Break=format}', "");
Expect(1, 917632, '\P{Sentence_Break=format}', "");
Expect(0, 917632, '\P{^Sentence_Break=format}', "");
Expect(1, 917631, '\p{Sentence_Break=	Format}', "");
Expect(0, 917631, '\p{^Sentence_Break=	Format}', "");
Expect(0, 917631, '\P{Sentence_Break=	Format}', "");
Expect(1, 917631, '\P{^Sentence_Break=	Format}', "");
Expect(0, 917632, '\p{Sentence_Break=	Format}', "");
Expect(1, 917632, '\p{^Sentence_Break=	Format}', "");
Expect(1, 917632, '\P{Sentence_Break=	Format}', "");
Expect(0, 917632, '\P{^Sentence_Break=	Format}', "");
Error('\p{SB=-/a/FO}');
Error('\P{SB=-/a/FO}');
Expect(1, 917631, '\p{SB=fo}', "");
Expect(0, 917631, '\p{^SB=fo}', "");
Expect(0, 917631, '\P{SB=fo}', "");
Expect(1, 917631, '\P{^SB=fo}', "");
Expect(0, 917632, '\p{SB=fo}', "");
Expect(1, 917632, '\p{^SB=fo}', "");
Expect(1, 917632, '\P{SB=fo}', "");
Expect(0, 917632, '\P{^SB=fo}', "");
Expect(1, 917631, '\p{SB=_FO}', "");
Expect(0, 917631, '\p{^SB=_FO}', "");
Expect(0, 917631, '\P{SB=_FO}', "");
Expect(1, 917631, '\P{^SB=_FO}', "");
Expect(0, 917632, '\p{SB=_FO}', "");
Expect(1, 917632, '\p{^SB=_FO}', "");
Expect(1, 917632, '\P{SB=_FO}', "");
Expect(0, 917632, '\P{^SB=_FO}', "");
Error('\p{Is_Sentence_Break: _Format/a/}');
Error('\P{Is_Sentence_Break: _Format/a/}');
Expect(1, 917631, '\p{Is_Sentence_Break=format}', "");
Expect(0, 917631, '\p{^Is_Sentence_Break=format}', "");
Expect(0, 917631, '\P{Is_Sentence_Break=format}', "");
Expect(1, 917631, '\P{^Is_Sentence_Break=format}', "");
Expect(0, 917632, '\p{Is_Sentence_Break=format}', "");
Expect(1, 917632, '\p{^Is_Sentence_Break=format}', "");
Expect(1, 917632, '\P{Is_Sentence_Break=format}', "");
Expect(0, 917632, '\P{^Is_Sentence_Break=format}', "");
Expect(1, 917631, '\p{Is_Sentence_Break=__FORMAT}', "");
Expect(0, 917631, '\p{^Is_Sentence_Break=__FORMAT}', "");
Expect(0, 917631, '\P{Is_Sentence_Break=__FORMAT}', "");
Expect(1, 917631, '\P{^Is_Sentence_Break=__FORMAT}', "");
Expect(0, 917632, '\p{Is_Sentence_Break=__FORMAT}', "");
Expect(1, 917632, '\p{^Is_Sentence_Break=__FORMAT}', "");
Expect(1, 917632, '\P{Is_Sentence_Break=__FORMAT}', "");
Expect(0, 917632, '\P{^Is_Sentence_Break=__FORMAT}', "");
Error('\p{Is_SB=_-fo:=}');
Error('\P{Is_SB=_-fo:=}');
Expect(1, 917631, '\p{Is_SB=fo}', "");
Expect(0, 917631, '\p{^Is_SB=fo}', "");
Expect(0, 917631, '\P{Is_SB=fo}', "");
Expect(1, 917631, '\P{^Is_SB=fo}', "");
Expect(0, 917632, '\p{Is_SB=fo}', "");
Expect(1, 917632, '\p{^Is_SB=fo}', "");
Expect(1, 917632, '\P{Is_SB=fo}', "");
Expect(0, 917632, '\P{^Is_SB=fo}', "");
Expect(1, 917631, '\p{Is_SB=_-FO}', "");
Expect(0, 917631, '\p{^Is_SB=_-FO}', "");
Expect(0, 917631, '\P{Is_SB=_-FO}', "");
Expect(1, 917631, '\P{^Is_SB=_-FO}', "");
Expect(0, 917632, '\p{Is_SB=_-FO}', "");
Expect(1, 917632, '\p{^Is_SB=_-FO}', "");
Expect(1, 917632, '\P{Is_SB=_-FO}', "");
Expect(0, 917632, '\P{^Is_SB=_-FO}', "");
Error('\p{Sentence_Break=_/a/OLETTER}');
Error('\P{Sentence_Break=_/a/OLETTER}');
Expect(1, 195101, '\p{Sentence_Break=oletter}', "");
Expect(0, 195101, '\p{^Sentence_Break=oletter}', "");
Expect(0, 195101, '\P{Sentence_Break=oletter}', "");
Expect(1, 195101, '\P{^Sentence_Break=oletter}', "");
Expect(0, 195102, '\p{Sentence_Break=oletter}', "");
Expect(1, 195102, '\p{^Sentence_Break=oletter}', "");
Expect(1, 195102, '\P{Sentence_Break=oletter}', "");
Expect(0, 195102, '\P{^Sentence_Break=oletter}', "");
Expect(1, 195101, '\p{Sentence_Break=-	OLetter}', "");
Expect(0, 195101, '\p{^Sentence_Break=-	OLetter}', "");
Expect(0, 195101, '\P{Sentence_Break=-	OLetter}', "");
Expect(1, 195101, '\P{^Sentence_Break=-	OLetter}', "");
Expect(0, 195102, '\p{Sentence_Break=-	OLetter}', "");
Expect(1, 195102, '\p{^Sentence_Break=-	OLetter}', "");
Expect(1, 195102, '\P{Sentence_Break=-	OLetter}', "");
Expect(0, 195102, '\P{^Sentence_Break=-	OLetter}', "");
Error('\p{SB=_	LE:=}');
Error('\P{SB=_	LE:=}');
Expect(1, 195101, '\p{SB=le}', "");
Expect(0, 195101, '\p{^SB=le}', "");
Expect(0, 195101, '\P{SB=le}', "");
Expect(1, 195101, '\P{^SB=le}', "");
Expect(0, 195102, '\p{SB=le}', "");
Expect(1, 195102, '\p{^SB=le}', "");
Expect(1, 195102, '\P{SB=le}', "");
Expect(0, 195102, '\P{^SB=le}', "");
Expect(1, 195101, '\p{SB=-LE}', "");
Expect(0, 195101, '\p{^SB=-LE}', "");
Expect(0, 195101, '\P{SB=-LE}', "");
Expect(1, 195101, '\P{^SB=-LE}', "");
Expect(0, 195102, '\p{SB=-LE}', "");
Expect(1, 195102, '\p{^SB=-LE}', "");
Expect(1, 195102, '\P{SB=-LE}', "");
Expect(0, 195102, '\P{^SB=-LE}', "");
Error('\p{Is_Sentence_Break=	/a/OLetter}');
Error('\P{Is_Sentence_Break=	/a/OLetter}');
Expect(1, 195101, '\p{Is_Sentence_Break=oletter}', "");
Expect(0, 195101, '\p{^Is_Sentence_Break=oletter}', "");
Expect(0, 195101, '\P{Is_Sentence_Break=oletter}', "");
Expect(1, 195101, '\P{^Is_Sentence_Break=oletter}', "");
Expect(0, 195102, '\p{Is_Sentence_Break=oletter}', "");
Expect(1, 195102, '\p{^Is_Sentence_Break=oletter}', "");
Expect(1, 195102, '\P{Is_Sentence_Break=oletter}', "");
Expect(0, 195102, '\P{^Is_Sentence_Break=oletter}', "");
Expect(1, 195101, '\p{Is_Sentence_Break= oletter}', "");
Expect(0, 195101, '\p{^Is_Sentence_Break= oletter}', "");
Expect(0, 195101, '\P{Is_Sentence_Break= oletter}', "");
Expect(1, 195101, '\P{^Is_Sentence_Break= oletter}', "");
Expect(0, 195102, '\p{Is_Sentence_Break= oletter}', "");
Expect(1, 195102, '\p{^Is_Sentence_Break= oletter}', "");
Expect(1, 195102, '\P{Is_Sentence_Break= oletter}', "");
Expect(0, 195102, '\P{^Is_Sentence_Break= oletter}', "");
Error('\p{Is_SB=		LE/a/}');
Error('\P{Is_SB=		LE/a/}');
Expect(1, 195101, '\p{Is_SB=le}', "");
Expect(0, 195101, '\p{^Is_SB=le}', "");
Expect(0, 195101, '\P{Is_SB=le}', "");
Expect(1, 195101, '\P{^Is_SB=le}', "");
Expect(0, 195102, '\p{Is_SB=le}', "");
Expect(1, 195102, '\p{^Is_SB=le}', "");
Expect(1, 195102, '\P{Is_SB=le}', "");
Expect(0, 195102, '\P{^Is_SB=le}', "");
Expect(1, 195101, '\p{Is_SB=		LE}', "");
Expect(0, 195101, '\p{^Is_SB=		LE}', "");
Expect(0, 195101, '\P{Is_SB=		LE}', "");
Expect(1, 195101, '\P{^Is_SB=		LE}', "");
Expect(0, 195102, '\p{Is_SB=		LE}', "");
Expect(1, 195102, '\p{^Is_SB=		LE}', "");
Expect(1, 195102, '\P{Is_SB=		LE}', "");
Expect(0, 195102, '\P{^Is_SB=		LE}', "");
Error('\p{Sentence_Break=:=--LF}');
Error('\P{Sentence_Break=:=--LF}');
Expect(1, 10, '\p{Sentence_Break:   lf}', "");
Expect(0, 10, '\p{^Sentence_Break:   lf}', "");
Expect(0, 10, '\P{Sentence_Break:   lf}', "");
Expect(1, 10, '\P{^Sentence_Break:   lf}', "");
Expect(0, 11, '\p{Sentence_Break:   lf}', "");
Expect(1, 11, '\p{^Sentence_Break:   lf}', "");
Expect(1, 11, '\P{Sentence_Break:   lf}', "");
Expect(0, 11, '\P{^Sentence_Break:   lf}', "");
Expect(1, 10, '\p{Sentence_Break=	LF}', "");
Expect(0, 10, '\p{^Sentence_Break=	LF}', "");
Expect(0, 10, '\P{Sentence_Break=	LF}', "");
Expect(1, 10, '\P{^Sentence_Break=	LF}', "");
Expect(0, 11, '\p{Sentence_Break=	LF}', "");
Expect(1, 11, '\p{^Sentence_Break=	LF}', "");
Expect(1, 11, '\P{Sentence_Break=	LF}', "");
Expect(0, 11, '\P{^Sentence_Break=	LF}', "");
Error('\p{SB=:=		LF}');
Error('\P{SB=:=		LF}');
Expect(1, 10, '\p{SB=lf}', "");
Expect(0, 10, '\p{^SB=lf}', "");
Expect(0, 10, '\P{SB=lf}', "");
Expect(1, 10, '\P{^SB=lf}', "");
Expect(0, 11, '\p{SB=lf}', "");
Expect(1, 11, '\p{^SB=lf}', "");
Expect(1, 11, '\P{SB=lf}', "");
Expect(0, 11, '\P{^SB=lf}', "");
Expect(1, 10, '\p{SB=	LF}', "");
Expect(0, 10, '\p{^SB=	LF}', "");
Expect(0, 10, '\P{SB=	LF}', "");
Expect(1, 10, '\P{^SB=	LF}', "");
Expect(0, 11, '\p{SB=	LF}', "");
Expect(1, 11, '\p{^SB=	LF}', "");
Expect(1, 11, '\P{SB=	LF}', "");
Expect(0, 11, '\P{^SB=	LF}', "");
Error('\p{Is_Sentence_Break=-	LF/a/}');
Error('\P{Is_Sentence_Break=-	LF/a/}');
Expect(1, 10, '\p{Is_Sentence_Break=lf}', "");
Expect(0, 10, '\p{^Is_Sentence_Break=lf}', "");
Expect(0, 10, '\P{Is_Sentence_Break=lf}', "");
Expect(1, 10, '\P{^Is_Sentence_Break=lf}', "");
Expect(0, 11, '\p{Is_Sentence_Break=lf}', "");
Expect(1, 11, '\p{^Is_Sentence_Break=lf}', "");
Expect(1, 11, '\P{Is_Sentence_Break=lf}', "");
Expect(0, 11, '\P{^Is_Sentence_Break=lf}', "");
Expect(1, 10, '\p{Is_Sentence_Break=_	LF}', "");
Expect(0, 10, '\p{^Is_Sentence_Break=_	LF}', "");
Expect(0, 10, '\P{Is_Sentence_Break=_	LF}', "");
Expect(1, 10, '\P{^Is_Sentence_Break=_	LF}', "");
Expect(0, 11, '\p{Is_Sentence_Break=_	LF}', "");
Expect(1, 11, '\p{^Is_Sentence_Break=_	LF}', "");
Expect(1, 11, '\P{Is_Sentence_Break=_	LF}', "");
Expect(0, 11, '\P{^Is_Sentence_Break=_	LF}', "");
Error('\p{Is_SB: :=lf}');
Error('\P{Is_SB: :=lf}');
Expect(1, 10, '\p{Is_SB=lf}', "");
Expect(0, 10, '\p{^Is_SB=lf}', "");
Expect(0, 10, '\P{Is_SB=lf}', "");
Expect(1, 10, '\P{^Is_SB=lf}', "");
Expect(0, 11, '\p{Is_SB=lf}', "");
Expect(1, 11, '\p{^Is_SB=lf}', "");
Expect(1, 11, '\P{Is_SB=lf}', "");
Expect(0, 11, '\P{^Is_SB=lf}', "");
Expect(1, 10, '\p{Is_SB=	 LF}', "");
Expect(0, 10, '\p{^Is_SB=	 LF}', "");
Expect(0, 10, '\P{Is_SB=	 LF}', "");
Expect(1, 10, '\P{^Is_SB=	 LF}', "");
Expect(0, 11, '\p{Is_SB=	 LF}', "");
Expect(1, 11, '\p{^Is_SB=	 LF}', "");
Expect(1, 11, '\P{Is_SB=	 LF}', "");
Expect(0, 11, '\P{^Is_SB=	 LF}', "");
Error('\p{Sentence_Break=_Lower/a/}');
Error('\P{Sentence_Break=_Lower/a/}');
Expect(1, 120779, '\p{Sentence_Break=lower}', "");
Expect(0, 120779, '\p{^Sentence_Break=lower}', "");
Expect(0, 120779, '\P{Sentence_Break=lower}', "");
Expect(1, 120779, '\P{^Sentence_Break=lower}', "");
Expect(0, 120780, '\p{Sentence_Break=lower}', "");
Expect(1, 120780, '\p{^Sentence_Break=lower}', "");
Expect(1, 120780, '\P{Sentence_Break=lower}', "");
Expect(0, 120780, '\P{^Sentence_Break=lower}', "");
Expect(1, 120779, '\p{Sentence_Break= -LOWER}', "");
Expect(0, 120779, '\p{^Sentence_Break= -LOWER}', "");
Expect(0, 120779, '\P{Sentence_Break= -LOWER}', "");
Expect(1, 120779, '\P{^Sentence_Break= -LOWER}', "");
Expect(0, 120780, '\p{Sentence_Break= -LOWER}', "");
Expect(1, 120780, '\p{^Sentence_Break= -LOWER}', "");
Expect(1, 120780, '\P{Sentence_Break= -LOWER}', "");
Expect(0, 120780, '\P{^Sentence_Break= -LOWER}', "");
Error('\p{SB=/a/lo}');
Error('\P{SB=/a/lo}');
Expect(1, 120779, '\p{SB=lo}', "");
Expect(0, 120779, '\p{^SB=lo}', "");
Expect(0, 120779, '\P{SB=lo}', "");
Expect(1, 120779, '\P{^SB=lo}', "");
Expect(0, 120780, '\p{SB=lo}', "");
Expect(1, 120780, '\p{^SB=lo}', "");
Expect(1, 120780, '\P{SB=lo}', "");
Expect(0, 120780, '\P{^SB=lo}', "");
Expect(1, 120779, '\p{SB=- LO}', "");
Expect(0, 120779, '\p{^SB=- LO}', "");
Expect(0, 120779, '\P{SB=- LO}', "");
Expect(1, 120779, '\P{^SB=- LO}', "");
Expect(0, 120780, '\p{SB=- LO}', "");
Expect(1, 120780, '\p{^SB=- LO}', "");
Expect(1, 120780, '\P{SB=- LO}', "");
Expect(0, 120780, '\P{^SB=- LO}', "");
Error('\p{Is_Sentence_Break=:= Lower}');
Error('\P{Is_Sentence_Break=:= Lower}');
Expect(1, 120779, '\p{Is_Sentence_Break=lower}', "");
Expect(0, 120779, '\p{^Is_Sentence_Break=lower}', "");
Expect(0, 120779, '\P{Is_Sentence_Break=lower}', "");
Expect(1, 120779, '\P{^Is_Sentence_Break=lower}', "");
Expect(0, 120780, '\p{Is_Sentence_Break=lower}', "");
Expect(1, 120780, '\p{^Is_Sentence_Break=lower}', "");
Expect(1, 120780, '\P{Is_Sentence_Break=lower}', "");
Expect(0, 120780, '\P{^Is_Sentence_Break=lower}', "");
Expect(1, 120779, '\p{Is_Sentence_Break=_Lower}', "");
Expect(0, 120779, '\p{^Is_Sentence_Break=_Lower}', "");
Expect(0, 120779, '\P{Is_Sentence_Break=_Lower}', "");
Expect(1, 120779, '\P{^Is_Sentence_Break=_Lower}', "");
Expect(0, 120780, '\p{Is_Sentence_Break=_Lower}', "");
Expect(1, 120780, '\p{^Is_Sentence_Break=_Lower}', "");
Expect(1, 120780, '\P{Is_Sentence_Break=_Lower}', "");
Expect(0, 120780, '\P{^Is_Sentence_Break=_Lower}', "");
Error('\p{Is_SB: :=		LO}');
Error('\P{Is_SB: :=		LO}');
Expect(1, 120779, '\p{Is_SB=lo}', "");
Expect(0, 120779, '\p{^Is_SB=lo}', "");
Expect(0, 120779, '\P{Is_SB=lo}', "");
Expect(1, 120779, '\P{^Is_SB=lo}', "");
Expect(0, 120780, '\p{Is_SB=lo}', "");
Expect(1, 120780, '\p{^Is_SB=lo}', "");
Expect(1, 120780, '\P{Is_SB=lo}', "");
Expect(0, 120780, '\P{^Is_SB=lo}', "");
Expect(1, 120779, '\p{Is_SB=	 lo}', "");
Expect(0, 120779, '\p{^Is_SB=	 lo}', "");
Expect(0, 120779, '\P{Is_SB=	 lo}', "");
Expect(1, 120779, '\P{^Is_SB=	 lo}', "");
Expect(0, 120780, '\p{Is_SB=	 lo}', "");
Expect(1, 120780, '\p{^Is_SB=	 lo}', "");
Expect(1, 120780, '\P{Is_SB=	 lo}', "");
Expect(0, 120780, '\P{^Is_SB=	 lo}', "");
Error('\p{Sentence_Break= NUMERIC/a/}');
Error('\P{Sentence_Break= NUMERIC/a/}');
Expect(1, 120831, '\p{Sentence_Break=numeric}', "");
Expect(0, 120831, '\p{^Sentence_Break=numeric}', "");
Expect(0, 120831, '\P{Sentence_Break=numeric}', "");
Expect(1, 120831, '\P{^Sentence_Break=numeric}', "");
Expect(0, 120832, '\p{Sentence_Break=numeric}', "");
Expect(1, 120832, '\p{^Sentence_Break=numeric}', "");
Expect(1, 120832, '\P{Sentence_Break=numeric}', "");
Expect(0, 120832, '\P{^Sentence_Break=numeric}', "");
Expect(1, 120831, '\p{Sentence_Break=	 Numeric}', "");
Expect(0, 120831, '\p{^Sentence_Break=	 Numeric}', "");
Expect(0, 120831, '\P{Sentence_Break=	 Numeric}', "");
Expect(1, 120831, '\P{^Sentence_Break=	 Numeric}', "");
Expect(0, 120832, '\p{Sentence_Break=	 Numeric}', "");
Expect(1, 120832, '\p{^Sentence_Break=	 Numeric}', "");
Expect(1, 120832, '\P{Sentence_Break=	 Numeric}', "");
Expect(0, 120832, '\P{^Sentence_Break=	 Numeric}', "");
Error('\p{SB=-/a/nu}');
Error('\P{SB=-/a/nu}');
Expect(1, 120831, '\p{SB=nu}', "");
Expect(0, 120831, '\p{^SB=nu}', "");
Expect(0, 120831, '\P{SB=nu}', "");
Expect(1, 120831, '\P{^SB=nu}', "");
Expect(0, 120832, '\p{SB=nu}', "");
Expect(1, 120832, '\p{^SB=nu}', "");
Expect(1, 120832, '\P{SB=nu}', "");
Expect(0, 120832, '\P{^SB=nu}', "");
Expect(1, 120831, '\p{SB=_-NU}', "");
Expect(0, 120831, '\p{^SB=_-NU}', "");
Expect(0, 120831, '\P{SB=_-NU}', "");
Expect(1, 120831, '\P{^SB=_-NU}', "");
Expect(0, 120832, '\p{SB=_-NU}', "");
Expect(1, 120832, '\p{^SB=_-NU}', "");
Expect(1, 120832, '\P{SB=_-NU}', "");
Expect(0, 120832, '\P{^SB=_-NU}', "");
Error('\p{Is_Sentence_Break=	-Numeric:=}');
Error('\P{Is_Sentence_Break=	-Numeric:=}');
Expect(1, 120831, '\p{Is_Sentence_Break=numeric}', "");
Expect(0, 120831, '\p{^Is_Sentence_Break=numeric}', "");
Expect(0, 120831, '\P{Is_Sentence_Break=numeric}', "");
Expect(1, 120831, '\P{^Is_Sentence_Break=numeric}', "");
Expect(0, 120832, '\p{Is_Sentence_Break=numeric}', "");
Expect(1, 120832, '\p{^Is_Sentence_Break=numeric}', "");
Expect(1, 120832, '\P{Is_Sentence_Break=numeric}', "");
Expect(0, 120832, '\P{^Is_Sentence_Break=numeric}', "");
Expect(1, 120831, '\p{Is_Sentence_Break=	Numeric}', "");
Expect(0, 120831, '\p{^Is_Sentence_Break=	Numeric}', "");
Expect(0, 120831, '\P{Is_Sentence_Break=	Numeric}', "");
Expect(1, 120831, '\P{^Is_Sentence_Break=	Numeric}', "");
Expect(0, 120832, '\p{Is_Sentence_Break=	Numeric}', "");
Expect(1, 120832, '\p{^Is_Sentence_Break=	Numeric}', "");
Expect(1, 120832, '\P{Is_Sentence_Break=	Numeric}', "");
Expect(0, 120832, '\P{^Is_Sentence_Break=	Numeric}', "");
Error('\p{Is_SB=_-NU/a/}');
Error('\P{Is_SB=_-NU/a/}');
Expect(1, 120831, '\p{Is_SB=nu}', "");
Expect(0, 120831, '\p{^Is_SB=nu}', "");
Expect(0, 120831, '\P{Is_SB=nu}', "");
Expect(1, 120831, '\P{^Is_SB=nu}', "");
Expect(0, 120832, '\p{Is_SB=nu}', "");
Expect(1, 120832, '\p{^Is_SB=nu}', "");
Expect(1, 120832, '\P{Is_SB=nu}', "");
Expect(0, 120832, '\P{^Is_SB=nu}', "");
Expect(1, 120831, '\p{Is_SB=--nu}', "");
Expect(0, 120831, '\p{^Is_SB=--nu}', "");
Expect(0, 120831, '\P{Is_SB=--nu}', "");
Expect(1, 120831, '\P{^Is_SB=--nu}', "");
Expect(0, 120832, '\p{Is_SB=--nu}', "");
Expect(1, 120832, '\p{^Is_SB=--nu}', "");
Expect(1, 120832, '\P{Is_SB=--nu}', "");
Expect(0, 120832, '\P{^Is_SB=--nu}', "");
Error('\p{Sentence_Break=_	SContinue:=}');
Error('\P{Sentence_Break=_	SContinue:=}');
Expect(1, 65380, '\p{Sentence_Break=scontinue}', "");
Expect(0, 65380, '\p{^Sentence_Break=scontinue}', "");
Expect(0, 65380, '\P{Sentence_Break=scontinue}', "");
Expect(1, 65380, '\P{^Sentence_Break=scontinue}', "");
Expect(0, 65381, '\p{Sentence_Break=scontinue}', "");
Expect(1, 65381, '\p{^Sentence_Break=scontinue}', "");
Expect(1, 65381, '\P{Sentence_Break=scontinue}', "");
Expect(0, 65381, '\P{^Sentence_Break=scontinue}', "");
Expect(1, 65380, '\p{Sentence_Break=	SContinue}', "");
Expect(0, 65380, '\p{^Sentence_Break=	SContinue}', "");
Expect(0, 65380, '\P{Sentence_Break=	SContinue}', "");
Expect(1, 65380, '\P{^Sentence_Break=	SContinue}', "");
Expect(0, 65381, '\p{Sentence_Break=	SContinue}', "");
Expect(1, 65381, '\p{^Sentence_Break=	SContinue}', "");
Expect(1, 65381, '\P{Sentence_Break=	SContinue}', "");
Expect(0, 65381, '\P{^Sentence_Break=	SContinue}', "");
Error('\p{SB:	 _SC/a/}');
Error('\P{SB:	 _SC/a/}');
Expect(1, 65380, '\p{SB=sc}', "");
Expect(0, 65380, '\p{^SB=sc}', "");
Expect(0, 65380, '\P{SB=sc}', "");
Expect(1, 65380, '\P{^SB=sc}', "");
Expect(0, 65381, '\p{SB=sc}', "");
Expect(1, 65381, '\p{^SB=sc}', "");
Expect(1, 65381, '\P{SB=sc}', "");
Expect(0, 65381, '\P{^SB=sc}', "");
Expect(1, 65380, '\p{SB= 	SC}', "");
Expect(0, 65380, '\p{^SB= 	SC}', "");
Expect(0, 65380, '\P{SB= 	SC}', "");
Expect(1, 65380, '\P{^SB= 	SC}', "");
Expect(0, 65381, '\p{SB= 	SC}', "");
Expect(1, 65381, '\p{^SB= 	SC}', "");
Expect(1, 65381, '\P{SB= 	SC}', "");
Expect(0, 65381, '\P{^SB= 	SC}', "");
Error('\p{Is_Sentence_Break=-	SContinue/a/}');
Error('\P{Is_Sentence_Break=-	SContinue/a/}');
Expect(1, 65380, '\p{Is_Sentence_Break=scontinue}', "");
Expect(0, 65380, '\p{^Is_Sentence_Break=scontinue}', "");
Expect(0, 65380, '\P{Is_Sentence_Break=scontinue}', "");
Expect(1, 65380, '\P{^Is_Sentence_Break=scontinue}', "");
Expect(0, 65381, '\p{Is_Sentence_Break=scontinue}', "");
Expect(1, 65381, '\p{^Is_Sentence_Break=scontinue}', "");
Expect(1, 65381, '\P{Is_Sentence_Break=scontinue}', "");
Expect(0, 65381, '\P{^Is_Sentence_Break=scontinue}', "");
Expect(1, 65380, '\p{Is_Sentence_Break=_-scontinue}', "");
Expect(0, 65380, '\p{^Is_Sentence_Break=_-scontinue}', "");
Expect(0, 65380, '\P{Is_Sentence_Break=_-scontinue}', "");
Expect(1, 65380, '\P{^Is_Sentence_Break=_-scontinue}', "");
Expect(0, 65381, '\p{Is_Sentence_Break=_-scontinue}', "");
Expect(1, 65381, '\p{^Is_Sentence_Break=_-scontinue}', "");
Expect(1, 65381, '\P{Is_Sentence_Break=_-scontinue}', "");
Expect(0, 65381, '\P{^Is_Sentence_Break=_-scontinue}', "");
Error('\p{Is_SB= 	SC:=}');
Error('\P{Is_SB= 	SC:=}');
Expect(1, 65380, '\p{Is_SB=sc}', "");
Expect(0, 65380, '\p{^Is_SB=sc}', "");
Expect(0, 65380, '\P{Is_SB=sc}', "");
Expect(1, 65380, '\P{^Is_SB=sc}', "");
Expect(0, 65381, '\p{Is_SB=sc}', "");
Expect(1, 65381, '\p{^Is_SB=sc}', "");
Expect(1, 65381, '\P{Is_SB=sc}', "");
Expect(0, 65381, '\P{^Is_SB=sc}', "");
Expect(1, 65380, '\p{Is_SB=	SC}', "");
Expect(0, 65380, '\p{^Is_SB=	SC}', "");
Expect(0, 65380, '\P{Is_SB=	SC}', "");
Expect(1, 65380, '\P{^Is_SB=	SC}', "");
Expect(0, 65381, '\p{Is_SB=	SC}', "");
Expect(1, 65381, '\p{^Is_SB=	SC}', "");
Expect(1, 65381, '\P{Is_SB=	SC}', "");
Expect(0, 65381, '\P{^Is_SB=	SC}', "");
Error('\p{Sentence_Break=/a/Sep}');
Error('\P{Sentence_Break=/a/Sep}');
Expect(1, 8233, '\p{Sentence_Break=sep}', "");
Expect(0, 8233, '\p{^Sentence_Break=sep}', "");
Expect(0, 8233, '\P{Sentence_Break=sep}', "");
Expect(1, 8233, '\P{^Sentence_Break=sep}', "");
Expect(0, 8234, '\p{Sentence_Break=sep}', "");
Expect(1, 8234, '\p{^Sentence_Break=sep}', "");
Expect(1, 8234, '\P{Sentence_Break=sep}', "");
Expect(0, 8234, '\P{^Sentence_Break=sep}', "");
Expect(1, 8233, '\p{Sentence_Break=_sep}', "");
Expect(0, 8233, '\p{^Sentence_Break=_sep}', "");
Expect(0, 8233, '\P{Sentence_Break=_sep}', "");
Expect(1, 8233, '\P{^Sentence_Break=_sep}', "");
Expect(0, 8234, '\p{Sentence_Break=_sep}', "");
Expect(1, 8234, '\p{^Sentence_Break=_sep}', "");
Expect(1, 8234, '\P{Sentence_Break=_sep}', "");
Expect(0, 8234, '\P{^Sentence_Break=_sep}', "");
Error('\p{SB=	:=se}');
Error('\P{SB=	:=se}');
Expect(1, 8233, '\p{SB=se}', "");
Expect(0, 8233, '\p{^SB=se}', "");
Expect(0, 8233, '\P{SB=se}', "");
Expect(1, 8233, '\P{^SB=se}', "");
Expect(0, 8234, '\p{SB=se}', "");
Expect(1, 8234, '\p{^SB=se}', "");
Expect(1, 8234, '\P{SB=se}', "");
Expect(0, 8234, '\P{^SB=se}', "");
Expect(1, 8233, '\p{SB=-SE}', "");
Expect(0, 8233, '\p{^SB=-SE}', "");
Expect(0, 8233, '\P{SB=-SE}', "");
Expect(1, 8233, '\P{^SB=-SE}', "");
Expect(0, 8234, '\p{SB=-SE}', "");
Expect(1, 8234, '\p{^SB=-SE}', "");
Expect(1, 8234, '\P{SB=-SE}', "");
Expect(0, 8234, '\P{^SB=-SE}', "");
Error('\p{Is_Sentence_Break=	 SEP:=}');
Error('\P{Is_Sentence_Break=	 SEP:=}');
Expect(1, 8233, '\p{Is_Sentence_Break=sep}', "");
Expect(0, 8233, '\p{^Is_Sentence_Break=sep}', "");
Expect(0, 8233, '\P{Is_Sentence_Break=sep}', "");
Expect(1, 8233, '\P{^Is_Sentence_Break=sep}', "");
Expect(0, 8234, '\p{Is_Sentence_Break=sep}', "");
Expect(1, 8234, '\p{^Is_Sentence_Break=sep}', "");
Expect(1, 8234, '\P{Is_Sentence_Break=sep}', "");
Expect(0, 8234, '\P{^Is_Sentence_Break=sep}', "");
Expect(1, 8233, '\p{Is_Sentence_Break=- Sep}', "");
Expect(0, 8233, '\p{^Is_Sentence_Break=- Sep}', "");
Expect(0, 8233, '\P{Is_Sentence_Break=- Sep}', "");
Expect(1, 8233, '\P{^Is_Sentence_Break=- Sep}', "");
Expect(0, 8234, '\p{Is_Sentence_Break=- Sep}', "");
Expect(1, 8234, '\p{^Is_Sentence_Break=- Sep}', "");
Expect(1, 8234, '\P{Is_Sentence_Break=- Sep}', "");
Expect(0, 8234, '\P{^Is_Sentence_Break=- Sep}', "");
Error('\p{Is_SB=:= SE}');
Error('\P{Is_SB=:= SE}');
Expect(1, 8233, '\p{Is_SB=se}', "");
Expect(0, 8233, '\p{^Is_SB=se}', "");
Expect(0, 8233, '\P{Is_SB=se}', "");
Expect(1, 8233, '\P{^Is_SB=se}', "");
Expect(0, 8234, '\p{Is_SB=se}', "");
Expect(1, 8234, '\p{^Is_SB=se}', "");
Expect(1, 8234, '\P{Is_SB=se}', "");
Expect(0, 8234, '\P{^Is_SB=se}', "");
Expect(1, 8233, '\p{Is_SB=	_SE}', "");
Expect(0, 8233, '\p{^Is_SB=	_SE}', "");
Expect(0, 8233, '\P{Is_SB=	_SE}', "");
Expect(1, 8233, '\P{^Is_SB=	_SE}', "");
Expect(0, 8234, '\p{Is_SB=	_SE}', "");
Expect(1, 8234, '\p{^Is_SB=	_SE}', "");
Expect(1, 8234, '\P{Is_SB=	_SE}', "");
Expect(0, 8234, '\P{^Is_SB=	_SE}', "");
Error('\p{Sentence_Break= /a/sp}');
Error('\P{Sentence_Break= /a/sp}');
Expect(1, 12288, '\p{Sentence_Break=sp}', "");
Expect(0, 12288, '\p{^Sentence_Break=sp}', "");
Expect(0, 12288, '\P{Sentence_Break=sp}', "");
Expect(1, 12288, '\P{^Sentence_Break=sp}', "");
Expect(0, 12289, '\p{Sentence_Break=sp}', "");
Expect(1, 12289, '\p{^Sentence_Break=sp}', "");
Expect(1, 12289, '\P{Sentence_Break=sp}', "");
Expect(0, 12289, '\P{^Sentence_Break=sp}', "");
Expect(1, 12288, '\p{Sentence_Break=- sp}', "");
Expect(0, 12288, '\p{^Sentence_Break=- sp}', "");
Expect(0, 12288, '\P{Sentence_Break=- sp}', "");
Expect(1, 12288, '\P{^Sentence_Break=- sp}', "");
Expect(0, 12289, '\p{Sentence_Break=- sp}', "");
Expect(1, 12289, '\p{^Sentence_Break=- sp}', "");
Expect(1, 12289, '\P{Sentence_Break=- sp}', "");
Expect(0, 12289, '\P{^Sentence_Break=- sp}', "");
Error('\p{SB=:= -Sp}');
Error('\P{SB=:= -Sp}');
Expect(1, 12288, '\p{SB: sp}', "");
Expect(0, 12288, '\p{^SB: sp}', "");
Expect(0, 12288, '\P{SB: sp}', "");
Expect(1, 12288, '\P{^SB: sp}', "");
Expect(0, 12289, '\p{SB: sp}', "");
Expect(1, 12289, '\p{^SB: sp}', "");
Expect(1, 12289, '\P{SB: sp}', "");
Expect(0, 12289, '\P{^SB: sp}', "");
Expect(1, 12288, '\p{SB= 	sp}', "");
Expect(0, 12288, '\p{^SB= 	sp}', "");
Expect(0, 12288, '\P{SB= 	sp}', "");
Expect(1, 12288, '\P{^SB= 	sp}', "");
Expect(0, 12289, '\p{SB= 	sp}', "");
Expect(1, 12289, '\p{^SB= 	sp}', "");
Expect(1, 12289, '\P{SB= 	sp}', "");
Expect(0, 12289, '\P{^SB= 	sp}', "");
Error('\p{Is_Sentence_Break=-	sp:=}');
Error('\P{Is_Sentence_Break=-	sp:=}');
Expect(1, 12288, '\p{Is_Sentence_Break=sp}', "");
Expect(0, 12288, '\p{^Is_Sentence_Break=sp}', "");
Expect(0, 12288, '\P{Is_Sentence_Break=sp}', "");
Expect(1, 12288, '\P{^Is_Sentence_Break=sp}', "");
Expect(0, 12289, '\p{Is_Sentence_Break=sp}', "");
Expect(1, 12289, '\p{^Is_Sentence_Break=sp}', "");
Expect(1, 12289, '\P{Is_Sentence_Break=sp}', "");
Expect(0, 12289, '\P{^Is_Sentence_Break=sp}', "");
Expect(1, 12288, '\p{Is_Sentence_Break= 	Sp}', "");
Expect(0, 12288, '\p{^Is_Sentence_Break= 	Sp}', "");
Expect(0, 12288, '\P{Is_Sentence_Break= 	Sp}', "");
Expect(1, 12288, '\P{^Is_Sentence_Break= 	Sp}', "");
Expect(0, 12289, '\p{Is_Sentence_Break= 	Sp}', "");
Expect(1, 12289, '\p{^Is_Sentence_Break= 	Sp}', "");
Expect(1, 12289, '\P{Is_Sentence_Break= 	Sp}', "");
Expect(0, 12289, '\P{^Is_Sentence_Break= 	Sp}', "");
Error('\p{Is_SB=:=-Sp}');
Error('\P{Is_SB=:=-Sp}');
Expect(1, 12288, '\p{Is_SB=sp}', "");
Expect(0, 12288, '\p{^Is_SB=sp}', "");
Expect(0, 12288, '\P{Is_SB=sp}', "");
Expect(1, 12288, '\P{^Is_SB=sp}', "");
Expect(0, 12289, '\p{Is_SB=sp}', "");
Expect(1, 12289, '\p{^Is_SB=sp}', "");
Expect(1, 12289, '\P{Is_SB=sp}', "");
Expect(0, 12289, '\P{^Is_SB=sp}', "");
Expect(1, 12288, '\p{Is_SB=  sp}', "");
Expect(0, 12288, '\p{^Is_SB=  sp}', "");
Expect(0, 12288, '\P{Is_SB=  sp}', "");
Expect(1, 12288, '\P{^Is_SB=  sp}', "");
Expect(0, 12289, '\p{Is_SB=  sp}', "");
Expect(1, 12289, '\p{^Is_SB=  sp}', "");
Expect(1, 12289, '\P{Is_SB=  sp}', "");
Expect(0, 12289, '\P{^Is_SB=  sp}', "");
Error('\p{Sentence_Break=/a/sterm}');
Error('\P{Sentence_Break=/a/sterm}');
Expect(1, 121480, '\p{Sentence_Break=sterm}', "");
Expect(0, 121480, '\p{^Sentence_Break=sterm}', "");
Expect(0, 121480, '\P{Sentence_Break=sterm}', "");
Expect(1, 121480, '\P{^Sentence_Break=sterm}', "");
Expect(0, 121481, '\p{Sentence_Break=sterm}', "");
Expect(1, 121481, '\p{^Sentence_Break=sterm}', "");
Expect(1, 121481, '\P{Sentence_Break=sterm}', "");
Expect(0, 121481, '\P{^Sentence_Break=sterm}', "");
Expect(1, 121480, '\p{Sentence_Break=_ STERM}', "");
Expect(0, 121480, '\p{^Sentence_Break=_ STERM}', "");
Expect(0, 121480, '\P{Sentence_Break=_ STERM}', "");
Expect(1, 121480, '\P{^Sentence_Break=_ STERM}', "");
Expect(0, 121481, '\p{Sentence_Break=_ STERM}', "");
Expect(1, 121481, '\p{^Sentence_Break=_ STERM}', "");
Expect(1, 121481, '\P{Sentence_Break=_ STERM}', "");
Expect(0, 121481, '\P{^Sentence_Break=_ STERM}', "");
Error('\p{SB=:=st}');
Error('\P{SB=:=st}');
Expect(1, 121480, '\p{SB=st}', "");
Expect(0, 121480, '\p{^SB=st}', "");
Expect(0, 121480, '\P{SB=st}', "");
Expect(1, 121480, '\P{^SB=st}', "");
Expect(0, 121481, '\p{SB=st}', "");
Expect(1, 121481, '\p{^SB=st}', "");
Expect(1, 121481, '\P{SB=st}', "");
Expect(0, 121481, '\P{^SB=st}', "");
Expect(1, 121480, '\p{SB:-_st}', "");
Expect(0, 121480, '\p{^SB:-_st}', "");
Expect(0, 121480, '\P{SB:-_st}', "");
Expect(1, 121480, '\P{^SB:-_st}', "");
Expect(0, 121481, '\p{SB:-_st}', "");
Expect(1, 121481, '\p{^SB:-_st}', "");
Expect(1, 121481, '\P{SB:-_st}', "");
Expect(0, 121481, '\P{^SB:-_st}', "");
Error('\p{Is_Sentence_Break:/a/ 	STerm}');
Error('\P{Is_Sentence_Break:/a/ 	STerm}');
Expect(1, 121480, '\p{Is_Sentence_Break:	sterm}', "");
Expect(0, 121480, '\p{^Is_Sentence_Break:	sterm}', "");
Expect(0, 121480, '\P{Is_Sentence_Break:	sterm}', "");
Expect(1, 121480, '\P{^Is_Sentence_Break:	sterm}', "");
Expect(0, 121481, '\p{Is_Sentence_Break:	sterm}', "");
Expect(1, 121481, '\p{^Is_Sentence_Break:	sterm}', "");
Expect(1, 121481, '\P{Is_Sentence_Break:	sterm}', "");
Expect(0, 121481, '\P{^Is_Sentence_Break:	sterm}', "");
Expect(1, 121480, '\p{Is_Sentence_Break=-STerm}', "");
Expect(0, 121480, '\p{^Is_Sentence_Break=-STerm}', "");
Expect(0, 121480, '\P{Is_Sentence_Break=-STerm}', "");
Expect(1, 121480, '\P{^Is_Sentence_Break=-STerm}', "");
Expect(0, 121481, '\p{Is_Sentence_Break=-STerm}', "");
Expect(1, 121481, '\p{^Is_Sentence_Break=-STerm}', "");
Expect(1, 121481, '\P{Is_Sentence_Break=-STerm}', "");
Expect(0, 121481, '\P{^Is_Sentence_Break=-STerm}', "");
Error('\p{Is_SB:     st:=}');
Error('\P{Is_SB:     st:=}');
Expect(1, 121480, '\p{Is_SB=st}', "");
Expect(0, 121480, '\p{^Is_SB=st}', "");
Expect(0, 121480, '\P{Is_SB=st}', "");
Expect(1, 121480, '\P{^Is_SB=st}', "");
Expect(0, 121481, '\p{Is_SB=st}', "");
Expect(1, 121481, '\p{^Is_SB=st}', "");
Expect(1, 121481, '\P{Is_SB=st}', "");
Expect(0, 121481, '\P{^Is_SB=st}', "");
Expect(1, 121480, '\p{Is_SB=	 ST}', "");
Expect(0, 121480, '\p{^Is_SB=	 ST}', "");
Expect(0, 121480, '\P{Is_SB=	 ST}', "");
Expect(1, 121480, '\P{^Is_SB=	 ST}', "");
Expect(0, 121481, '\p{Is_SB=	 ST}', "");
Expect(1, 121481, '\p{^Is_SB=	 ST}', "");
Expect(1, 121481, '\P{Is_SB=	 ST}', "");
Expect(0, 121481, '\P{^Is_SB=	 ST}', "");
Error('\p{Sentence_Break=/a/	Upper}');
Error('\P{Sentence_Break=/a/	Upper}');
Expect(1, 127369, '\p{Sentence_Break=upper}', "");
Expect(0, 127369, '\p{^Sentence_Break=upper}', "");
Expect(0, 127369, '\P{Sentence_Break=upper}', "");
Expect(1, 127369, '\P{^Sentence_Break=upper}', "");
Expect(0, 127370, '\p{Sentence_Break=upper}', "");
Expect(1, 127370, '\p{^Sentence_Break=upper}', "");
Expect(1, 127370, '\P{Sentence_Break=upper}', "");
Expect(0, 127370, '\P{^Sentence_Break=upper}', "");
Expect(1, 127369, '\p{Sentence_Break=_	UPPER}', "");
Expect(0, 127369, '\p{^Sentence_Break=_	UPPER}', "");
Expect(0, 127369, '\P{Sentence_Break=_	UPPER}', "");
Expect(1, 127369, '\P{^Sentence_Break=_	UPPER}', "");
Expect(0, 127370, '\p{Sentence_Break=_	UPPER}', "");
Expect(1, 127370, '\p{^Sentence_Break=_	UPPER}', "");
Expect(1, 127370, '\P{Sentence_Break=_	UPPER}', "");
Expect(0, 127370, '\P{^Sentence_Break=_	UPPER}', "");
Error('\p{SB=:= up}');
Error('\P{SB=:= up}');
Expect(1, 127369, '\p{SB=up}', "");
Expect(0, 127369, '\p{^SB=up}', "");
Expect(0, 127369, '\P{SB=up}', "");
Expect(1, 127369, '\P{^SB=up}', "");
Expect(0, 127370, '\p{SB=up}', "");
Expect(1, 127370, '\p{^SB=up}', "");
Expect(1, 127370, '\P{SB=up}', "");
Expect(0, 127370, '\P{^SB=up}', "");
Expect(1, 127369, '\p{SB: _UP}', "");
Expect(0, 127369, '\p{^SB: _UP}', "");
Expect(0, 127369, '\P{SB: _UP}', "");
Expect(1, 127369, '\P{^SB: _UP}', "");
Expect(0, 127370, '\p{SB: _UP}', "");
Expect(1, 127370, '\p{^SB: _UP}', "");
Expect(1, 127370, '\P{SB: _UP}', "");
Expect(0, 127370, '\P{^SB: _UP}', "");
Error('\p{Is_Sentence_Break=_UPPER:=}');
Error('\P{Is_Sentence_Break=_UPPER:=}');
Expect(1, 127369, '\p{Is_Sentence_Break=upper}', "");
Expect(0, 127369, '\p{^Is_Sentence_Break=upper}', "");
Expect(0, 127369, '\P{Is_Sentence_Break=upper}', "");
Expect(1, 127369, '\P{^Is_Sentence_Break=upper}', "");
Expect(0, 127370, '\p{Is_Sentence_Break=upper}', "");
Expect(1, 127370, '\p{^Is_Sentence_Break=upper}', "");
Expect(1, 127370, '\P{Is_Sentence_Break=upper}', "");
Expect(0, 127370, '\P{^Is_Sentence_Break=upper}', "");
Expect(1, 127369, '\p{Is_Sentence_Break=-_UPPER}', "");
Expect(0, 127369, '\p{^Is_Sentence_Break=-_UPPER}', "");
Expect(0, 127369, '\P{Is_Sentence_Break=-_UPPER}', "");
Expect(1, 127369, '\P{^Is_Sentence_Break=-_UPPER}', "");
Expect(0, 127370, '\p{Is_Sentence_Break=-_UPPER}', "");
Expect(1, 127370, '\p{^Is_Sentence_Break=-_UPPER}', "");
Expect(1, 127370, '\P{Is_Sentence_Break=-_UPPER}', "");
Expect(0, 127370, '\P{^Is_Sentence_Break=-_UPPER}', "");
Error('\p{Is_SB=_UP/a/}');
Error('\P{Is_SB=_UP/a/}');
Expect(1, 127369, '\p{Is_SB=up}', "");
Expect(0, 127369, '\p{^Is_SB=up}', "");
Expect(0, 127369, '\P{Is_SB=up}', "");
Expect(1, 127369, '\P{^Is_SB=up}', "");
Expect(0, 127370, '\p{Is_SB=up}', "");
Expect(1, 127370, '\p{^Is_SB=up}', "");
Expect(1, 127370, '\P{Is_SB=up}', "");
Expect(0, 127370, '\P{^Is_SB=up}', "");
Expect(1, 127369, '\p{Is_SB=_-UP}', "");
Expect(0, 127369, '\p{^Is_SB=_-UP}', "");
Expect(0, 127369, '\P{Is_SB=_-UP}', "");
Expect(1, 127369, '\P{^Is_SB=_-UP}', "");
Expect(0, 127370, '\p{Is_SB=_-UP}', "");
Expect(1, 127370, '\p{^Is_SB=_-UP}', "");
Expect(1, 127370, '\P{Is_SB=_-UP}', "");
Expect(0, 127370, '\P{^Is_SB=_-UP}', "");
Error('\p{Sentence_Break= /a/OTHER}');
Error('\P{Sentence_Break= /a/OTHER}');
Expect(1, 918000, '\p{Sentence_Break=other}', "");
Expect(0, 918000, '\p{^Sentence_Break=other}', "");
Expect(0, 918000, '\P{Sentence_Break=other}', "");
Expect(1, 918000, '\P{^Sentence_Break=other}', "");
Expect(0, 917999, '\p{Sentence_Break=other}', "");
Expect(1, 917999, '\p{^Sentence_Break=other}', "");
Expect(1, 917999, '\P{Sentence_Break=other}', "");
Expect(0, 917999, '\P{^Sentence_Break=other}', "");
Expect(1, 918000, '\p{Sentence_Break=		Other}', "");
Expect(0, 918000, '\p{^Sentence_Break=		Other}', "");
Expect(0, 918000, '\P{Sentence_Break=		Other}', "");
Expect(1, 918000, '\P{^Sentence_Break=		Other}', "");
Expect(0, 917999, '\p{Sentence_Break=		Other}', "");
Expect(1, 917999, '\p{^Sentence_Break=		Other}', "");
Expect(1, 917999, '\P{Sentence_Break=		Other}', "");
Expect(0, 917999, '\P{^Sentence_Break=		Other}', "");
Error('\p{SB: -/a/XX}');
Error('\P{SB: -/a/XX}');
Expect(1, 918000, '\p{SB=xx}', "");
Expect(0, 918000, '\p{^SB=xx}', "");
Expect(0, 918000, '\P{SB=xx}', "");
Expect(1, 918000, '\P{^SB=xx}', "");
Expect(0, 917999, '\p{SB=xx}', "");
Expect(1, 917999, '\p{^SB=xx}', "");
Expect(1, 917999, '\P{SB=xx}', "");
Expect(0, 917999, '\P{^SB=xx}', "");
Expect(1, 918000, '\p{SB=	xx}', "");
Expect(0, 918000, '\p{^SB=	xx}', "");
Expect(0, 918000, '\P{SB=	xx}', "");
Expect(1, 918000, '\P{^SB=	xx}', "");
Expect(0, 917999, '\p{SB=	xx}', "");
Expect(1, 917999, '\p{^SB=	xx}', "");
Expect(1, 917999, '\P{SB=	xx}', "");
Expect(0, 917999, '\P{^SB=	xx}', "");
Error('\p{Is_Sentence_Break= /a/OTHER}');
Error('\P{Is_Sentence_Break= /a/OTHER}');
Expect(1, 918000, '\p{Is_Sentence_Break=other}', "");
Expect(0, 918000, '\p{^Is_Sentence_Break=other}', "");
Expect(0, 918000, '\P{Is_Sentence_Break=other}', "");
Expect(1, 918000, '\P{^Is_Sentence_Break=other}', "");
Expect(0, 917999, '\p{Is_Sentence_Break=other}', "");
Expect(1, 917999, '\p{^Is_Sentence_Break=other}', "");
Expect(1, 917999, '\P{Is_Sentence_Break=other}', "");
Expect(0, 917999, '\P{^Is_Sentence_Break=other}', "");
Expect(1, 918000, '\p{Is_Sentence_Break=	Other}', "");
Expect(0, 918000, '\p{^Is_Sentence_Break=	Other}', "");
Expect(0, 918000, '\P{Is_Sentence_Break=	Other}', "");
Expect(1, 918000, '\P{^Is_Sentence_Break=	Other}', "");
Expect(0, 917999, '\p{Is_Sentence_Break=	Other}', "");
Expect(1, 917999, '\p{^Is_Sentence_Break=	Other}', "");
Expect(1, 917999, '\P{Is_Sentence_Break=	Other}', "");
Expect(0, 917999, '\P{^Is_Sentence_Break=	Other}', "");
Error('\p{Is_SB=/a/ _XX}');
Error('\P{Is_SB=/a/ _XX}');
Expect(1, 918000, '\p{Is_SB: xx}', "");
Expect(0, 918000, '\p{^Is_SB: xx}', "");
Expect(0, 918000, '\P{Is_SB: xx}', "");
Expect(1, 918000, '\P{^Is_SB: xx}', "");
Expect(0, 917999, '\p{Is_SB: xx}', "");
Expect(1, 917999, '\p{^Is_SB: xx}', "");
Expect(1, 917999, '\P{Is_SB: xx}', "");
Expect(0, 917999, '\P{^Is_SB: xx}', "");
Expect(1, 918000, '\p{Is_SB=_ XX}', "");
Expect(0, 918000, '\p{^Is_SB=_ XX}', "");
Expect(0, 918000, '\P{Is_SB=_ XX}', "");
Expect(1, 918000, '\P{^Is_SB=_ XX}', "");
Expect(0, 917999, '\p{Is_SB=_ XX}', "");
Expect(1, 917999, '\p{^Is_SB=_ XX}', "");
Expect(1, 917999, '\P{Is_SB=_ XX}', "");
Expect(0, 917999, '\P{^Is_SB=_ XX}', "");
Error('\p{Soft_Dotted: _	no/a/}');
Error('\P{Soft_Dotted: _	no/a/}');
Expect(1, 120468, '\p{Soft_Dotted=no}', "");
Expect(0, 120468, '\p{^Soft_Dotted=no}', "");
Expect(0, 120468, '\P{Soft_Dotted=no}', "");
Expect(1, 120468, '\P{^Soft_Dotted=no}', "");
Expect(0, 120467, '\p{Soft_Dotted=no}', "");
Expect(1, 120467, '\p{^Soft_Dotted=no}', "");
Expect(1, 120467, '\P{Soft_Dotted=no}', "");
Expect(0, 120467, '\P{^Soft_Dotted=no}', "");
Expect(1, 120468, '\p{Soft_Dotted:__NO}', "");
Expect(0, 120468, '\p{^Soft_Dotted:__NO}', "");
Expect(0, 120468, '\P{Soft_Dotted:__NO}', "");
Expect(1, 120468, '\P{^Soft_Dotted:__NO}', "");
Expect(0, 120467, '\p{Soft_Dotted:__NO}', "");
Expect(1, 120467, '\p{^Soft_Dotted:__NO}', "");
Expect(1, 120467, '\P{Soft_Dotted:__NO}', "");
Expect(0, 120467, '\P{^Soft_Dotted:__NO}', "");
Error('\p{SD: /a/		N}');
Error('\P{SD: /a/		N}');
Expect(1, 120468, '\p{SD=n}', "");
Expect(0, 120468, '\p{^SD=n}', "");
Expect(0, 120468, '\P{SD=n}', "");
Expect(1, 120468, '\P{^SD=n}', "");
Expect(0, 120467, '\p{SD=n}', "");
Expect(1, 120467, '\p{^SD=n}', "");
Expect(1, 120467, '\P{SD=n}', "");
Expect(0, 120467, '\P{^SD=n}', "");
Expect(1, 120468, '\p{SD=- N}', "");
Expect(0, 120468, '\p{^SD=- N}', "");
Expect(0, 120468, '\P{SD=- N}', "");
Expect(1, 120468, '\P{^SD=- N}', "");
Expect(0, 120467, '\p{SD=- N}', "");
Expect(1, 120467, '\p{^SD=- N}', "");
Expect(1, 120467, '\P{SD=- N}', "");
Expect(0, 120467, '\P{^SD=- N}', "");
Error('\p{Is_Soft_Dotted= F:=}');
Error('\P{Is_Soft_Dotted= F:=}');
Expect(1, 120468, '\p{Is_Soft_Dotted=f}', "");
Expect(0, 120468, '\p{^Is_Soft_Dotted=f}', "");
Expect(0, 120468, '\P{Is_Soft_Dotted=f}', "");
Expect(1, 120468, '\P{^Is_Soft_Dotted=f}', "");
Expect(0, 120467, '\p{Is_Soft_Dotted=f}', "");
Expect(1, 120467, '\p{^Is_Soft_Dotted=f}', "");
Expect(1, 120467, '\P{Is_Soft_Dotted=f}', "");
Expect(0, 120467, '\P{^Is_Soft_Dotted=f}', "");
Expect(1, 120468, '\p{Is_Soft_Dotted:_-F}', "");
Expect(0, 120468, '\p{^Is_Soft_Dotted:_-F}', "");
Expect(0, 120468, '\P{Is_Soft_Dotted:_-F}', "");
Expect(1, 120468, '\P{^Is_Soft_Dotted:_-F}', "");
Expect(0, 120467, '\p{Is_Soft_Dotted:_-F}', "");
Expect(1, 120467, '\p{^Is_Soft_Dotted:_-F}', "");
Expect(1, 120467, '\P{Is_Soft_Dotted:_-F}', "");
Expect(0, 120467, '\P{^Is_Soft_Dotted:_-F}', "");
Error('\p{Is_SD= 	False/a/}');
Error('\P{Is_SD= 	False/a/}');
Expect(1, 120468, '\p{Is_SD:	false}', "");
Expect(0, 120468, '\p{^Is_SD:	false}', "");
Expect(0, 120468, '\P{Is_SD:	false}', "");
Expect(1, 120468, '\P{^Is_SD:	false}', "");
Expect(0, 120467, '\p{Is_SD:	false}', "");
Expect(1, 120467, '\p{^Is_SD:	false}', "");
Expect(1, 120467, '\P{Is_SD:	false}', "");
Expect(0, 120467, '\P{^Is_SD:	false}', "");
Expect(1, 120468, '\p{Is_SD=	_False}', "");
Expect(0, 120468, '\p{^Is_SD=	_False}', "");
Expect(0, 120468, '\P{Is_SD=	_False}', "");
Expect(1, 120468, '\P{^Is_SD=	_False}', "");
Expect(0, 120467, '\p{Is_SD=	_False}', "");
Expect(1, 120467, '\p{^Is_SD=	_False}', "");
Expect(1, 120467, '\P{Is_SD=	_False}', "");
Expect(0, 120467, '\P{^Is_SD=	_False}', "");
Error('\p{Soft_Dotted=  Yes:=}');
Error('\P{Soft_Dotted=  Yes:=}');
Expect(1, 120467, '\p{Soft_Dotted=yes}', "");
Expect(0, 120467, '\p{^Soft_Dotted=yes}', "");
Expect(0, 120467, '\P{Soft_Dotted=yes}', "");
Expect(1, 120467, '\P{^Soft_Dotted=yes}', "");
Expect(0, 120468, '\p{Soft_Dotted=yes}', "");
Expect(1, 120468, '\p{^Soft_Dotted=yes}', "");
Expect(1, 120468, '\P{Soft_Dotted=yes}', "");
Expect(0, 120468, '\P{^Soft_Dotted=yes}', "");
Expect(1, 120467, '\p{Soft_Dotted=	YES}', "");
Expect(0, 120467, '\p{^Soft_Dotted=	YES}', "");
Expect(0, 120467, '\P{Soft_Dotted=	YES}', "");
Expect(1, 120467, '\P{^Soft_Dotted=	YES}', "");
Expect(0, 120468, '\p{Soft_Dotted=	YES}', "");
Expect(1, 120468, '\p{^Soft_Dotted=	YES}', "");
Expect(1, 120468, '\P{Soft_Dotted=	YES}', "");
Expect(0, 120468, '\P{^Soft_Dotted=	YES}', "");
Error('\p{SD=	/a/y}');
Error('\P{SD=	/a/y}');
Expect(1, 120467, '\p{SD=y}', "");
Expect(0, 120467, '\p{^SD=y}', "");
Expect(0, 120467, '\P{SD=y}', "");
Expect(1, 120467, '\P{^SD=y}', "");
Expect(0, 120468, '\p{SD=y}', "");
Expect(1, 120468, '\p{^SD=y}', "");
Expect(1, 120468, '\P{SD=y}', "");
Expect(0, 120468, '\P{^SD=y}', "");
Expect(1, 120467, '\p{SD=_y}', "");
Expect(0, 120467, '\p{^SD=_y}', "");
Expect(0, 120467, '\P{SD=_y}', "");
Expect(1, 120467, '\P{^SD=_y}', "");
Expect(0, 120468, '\p{SD=_y}', "");
Expect(1, 120468, '\p{^SD=_y}', "");
Expect(1, 120468, '\P{SD=_y}', "");
Expect(0, 120468, '\P{^SD=_y}', "");
Error('\p{Is_Soft_Dotted= :=t}');
Error('\P{Is_Soft_Dotted= :=t}');
Expect(1, 120467, '\p{Is_Soft_Dotted=t}', "");
Expect(0, 120467, '\p{^Is_Soft_Dotted=t}', "");
Expect(0, 120467, '\P{Is_Soft_Dotted=t}', "");
Expect(1, 120467, '\P{^Is_Soft_Dotted=t}', "");
Expect(0, 120468, '\p{Is_Soft_Dotted=t}', "");
Expect(1, 120468, '\p{^Is_Soft_Dotted=t}', "");
Expect(1, 120468, '\P{Is_Soft_Dotted=t}', "");
Expect(0, 120468, '\P{^Is_Soft_Dotted=t}', "");
Expect(1, 120467, '\p{Is_Soft_Dotted= T}', "");
Expect(0, 120467, '\p{^Is_Soft_Dotted= T}', "");
Expect(0, 120467, '\P{Is_Soft_Dotted= T}', "");
Expect(1, 120467, '\P{^Is_Soft_Dotted= T}', "");
Expect(0, 120468, '\p{Is_Soft_Dotted= T}', "");
Expect(1, 120468, '\p{^Is_Soft_Dotted= T}', "");
Expect(1, 120468, '\P{Is_Soft_Dotted= T}', "");
Expect(0, 120468, '\P{^Is_Soft_Dotted= T}', "");
Error('\p{Is_SD=/a/- true}');
Error('\P{Is_SD=/a/- true}');
Expect(1, 120467, '\p{Is_SD=true}', "");
Expect(0, 120467, '\p{^Is_SD=true}', "");
Expect(0, 120467, '\P{Is_SD=true}', "");
Expect(1, 120467, '\P{^Is_SD=true}', "");
Expect(0, 120468, '\p{Is_SD=true}', "");
Expect(1, 120468, '\p{^Is_SD=true}', "");
Expect(1, 120468, '\P{Is_SD=true}', "");
Expect(0, 120468, '\P{^Is_SD=true}', "");
Expect(1, 120467, '\p{Is_SD=-_true}', "");
Expect(0, 120467, '\p{^Is_SD=-_true}', "");
Expect(0, 120467, '\P{Is_SD=-_true}', "");
Expect(1, 120467, '\P{^Is_SD=-_true}', "");
Expect(0, 120468, '\p{Is_SD=-_true}', "");
Expect(1, 120468, '\p{^Is_SD=-_true}', "");
Expect(1, 120468, '\P{Is_SD=-_true}', "");
Expect(0, 120468, '\P{^Is_SD=-_true}', "");
Error('\p{STerm=-:=No}');
Error('\P{STerm=-:=No}');
Expect(1, 121481, '\p{STerm:   no}', "");
Expect(0, 121481, '\p{^STerm:   no}', "");
Expect(0, 121481, '\P{STerm:   no}', "");
Expect(1, 121481, '\P{^STerm:   no}', "");
Expect(0, 121480, '\p{STerm:   no}', "");
Expect(1, 121480, '\p{^STerm:   no}', "");
Expect(1, 121480, '\P{STerm:   no}', "");
Expect(0, 121480, '\P{^STerm:   no}', "");
Expect(1, 121481, '\p{STerm=-	No}', "");
Expect(0, 121481, '\p{^STerm=-	No}', "");
Expect(0, 121481, '\P{STerm=-	No}', "");
Expect(1, 121481, '\P{^STerm=-	No}', "");
Expect(0, 121480, '\p{STerm=-	No}', "");
Expect(1, 121480, '\p{^STerm=-	No}', "");
Expect(1, 121480, '\P{STerm=-	No}', "");
Expect(0, 121480, '\P{^STerm=-	No}', "");
Error('\p{Is_STerm=/a/ N}');
Error('\P{Is_STerm=/a/ N}');
Expect(1, 121481, '\p{Is_STerm=n}', "");
Expect(0, 121481, '\p{^Is_STerm=n}', "");
Expect(0, 121481, '\P{Is_STerm=n}', "");
Expect(1, 121481, '\P{^Is_STerm=n}', "");
Expect(0, 121480, '\p{Is_STerm=n}', "");
Expect(1, 121480, '\p{^Is_STerm=n}', "");
Expect(1, 121480, '\P{Is_STerm=n}', "");
Expect(0, 121480, '\P{^Is_STerm=n}', "");
Expect(1, 121481, '\p{Is_STerm=	_n}', "");
Expect(0, 121481, '\p{^Is_STerm=	_n}', "");
Expect(0, 121481, '\P{Is_STerm=	_n}', "");
Expect(1, 121481, '\P{^Is_STerm=	_n}', "");
Expect(0, 121480, '\p{Is_STerm=	_n}', "");
Expect(1, 121480, '\p{^Is_STerm=	_n}', "");
Expect(1, 121480, '\P{Is_STerm=	_n}', "");
Expect(0, 121480, '\P{^Is_STerm=	_n}', "");
Error('\p{STerm:   /a/ F}');
Error('\P{STerm:   /a/ F}');
Expect(1, 121481, '\p{STerm=f}', "");
Expect(0, 121481, '\p{^STerm=f}', "");
Expect(0, 121481, '\P{STerm=f}', "");
Expect(1, 121481, '\P{^STerm=f}', "");
Expect(0, 121480, '\p{STerm=f}', "");
Expect(1, 121480, '\p{^STerm=f}', "");
Expect(1, 121480, '\P{STerm=f}', "");
Expect(0, 121480, '\P{^STerm=f}', "");
Expect(1, 121481, '\p{STerm=	 F}', "");
Expect(0, 121481, '\p{^STerm=	 F}', "");
Expect(0, 121481, '\P{STerm=	 F}', "");
Expect(1, 121481, '\P{^STerm=	 F}', "");
Expect(0, 121480, '\p{STerm=	 F}', "");
Expect(1, 121480, '\p{^STerm=	 F}', "");
Expect(1, 121480, '\P{STerm=	 F}', "");
Expect(0, 121480, '\P{^STerm=	 F}', "");
Error('\p{Is_STerm=/a/_FALSE}');
Error('\P{Is_STerm=/a/_FALSE}');
Expect(1, 121481, '\p{Is_STerm=false}', "");
Expect(0, 121481, '\p{^Is_STerm=false}', "");
Expect(0, 121481, '\P{Is_STerm=false}', "");
Expect(1, 121481, '\P{^Is_STerm=false}', "");
Expect(0, 121480, '\p{Is_STerm=false}', "");
Expect(1, 121480, '\p{^Is_STerm=false}', "");
Expect(1, 121480, '\P{Is_STerm=false}', "");
Expect(0, 121480, '\P{^Is_STerm=false}', "");
Expect(1, 121481, '\p{Is_STerm= FALSE}', "");
Expect(0, 121481, '\p{^Is_STerm= FALSE}', "");
Expect(0, 121481, '\P{Is_STerm= FALSE}', "");
Expect(1, 121481, '\P{^Is_STerm= FALSE}', "");
Expect(0, 121480, '\p{Is_STerm= FALSE}', "");
Expect(1, 121480, '\p{^Is_STerm= FALSE}', "");
Expect(1, 121480, '\P{Is_STerm= FALSE}', "");
Expect(0, 121480, '\P{^Is_STerm= FALSE}', "");
Error('\p{STerm:	- YES:=}');
Error('\P{STerm:	- YES:=}');
Expect(1, 121480, '\p{STerm=yes}', "");
Expect(0, 121480, '\p{^STerm=yes}', "");
Expect(0, 121480, '\P{STerm=yes}', "");
Expect(1, 121480, '\P{^STerm=yes}', "");
Expect(0, 121481, '\p{STerm=yes}', "");
Expect(1, 121481, '\p{^STerm=yes}', "");
Expect(1, 121481, '\P{STerm=yes}', "");
Expect(0, 121481, '\P{^STerm=yes}', "");
Expect(1, 121480, '\p{STerm=Yes}', "");
Expect(0, 121480, '\p{^STerm=Yes}', "");
Expect(0, 121480, '\P{STerm=Yes}', "");
Expect(1, 121480, '\P{^STerm=Yes}', "");
Expect(0, 121481, '\p{STerm=Yes}', "");
Expect(1, 121481, '\p{^STerm=Yes}', "");
Expect(1, 121481, '\P{STerm=Yes}', "");
Expect(0, 121481, '\P{^STerm=Yes}', "");
Error('\p{Is_STerm=:=_y}');
Error('\P{Is_STerm=:=_y}');
Expect(1, 121480, '\p{Is_STerm=y}', "");
Expect(0, 121480, '\p{^Is_STerm=y}', "");
Expect(0, 121480, '\P{Is_STerm=y}', "");
Expect(1, 121480, '\P{^Is_STerm=y}', "");
Expect(0, 121481, '\p{Is_STerm=y}', "");
Expect(1, 121481, '\p{^Is_STerm=y}', "");
Expect(1, 121481, '\P{Is_STerm=y}', "");
Expect(0, 121481, '\P{^Is_STerm=y}', "");
Expect(1, 121480, '\p{Is_STerm=_	Y}', "");
Expect(0, 121480, '\p{^Is_STerm=_	Y}', "");
Expect(0, 121480, '\P{Is_STerm=_	Y}', "");
Expect(1, 121480, '\P{^Is_STerm=_	Y}', "");
Expect(0, 121481, '\p{Is_STerm=_	Y}', "");
Expect(1, 121481, '\p{^Is_STerm=_	Y}', "");
Expect(1, 121481, '\P{Is_STerm=_	Y}', "");
Expect(0, 121481, '\P{^Is_STerm=_	Y}', "");
Error('\p{STerm=_:=T}');
Error('\P{STerm=_:=T}');
Expect(1, 121480, '\p{STerm=t}', "");
Expect(0, 121480, '\p{^STerm=t}', "");
Expect(0, 121480, '\P{STerm=t}', "");
Expect(1, 121480, '\P{^STerm=t}', "");
Expect(0, 121481, '\p{STerm=t}', "");
Expect(1, 121481, '\p{^STerm=t}', "");
Expect(1, 121481, '\P{STerm=t}', "");
Expect(0, 121481, '\P{^STerm=t}', "");
Expect(1, 121480, '\p{STerm:   --T}', "");
Expect(0, 121480, '\p{^STerm:   --T}', "");
Expect(0, 121480, '\P{STerm:   --T}', "");
Expect(1, 121480, '\P{^STerm:   --T}', "");
Expect(0, 121481, '\p{STerm:   --T}', "");
Expect(1, 121481, '\p{^STerm:   --T}', "");
Expect(1, 121481, '\P{STerm:   --T}', "");
Expect(0, 121481, '\P{^STerm:   --T}', "");
Error('\p{Is_STerm= True:=}');
Error('\P{Is_STerm= True:=}');
Expect(1, 121480, '\p{Is_STerm=true}', "");
Expect(0, 121480, '\p{^Is_STerm=true}', "");
Expect(0, 121480, '\P{Is_STerm=true}', "");
Expect(1, 121480, '\P{^Is_STerm=true}', "");
Expect(0, 121481, '\p{Is_STerm=true}', "");
Expect(1, 121481, '\p{^Is_STerm=true}', "");
Expect(1, 121481, '\P{Is_STerm=true}', "");
Expect(0, 121481, '\P{^Is_STerm=true}', "");
Expect(1, 121480, '\p{Is_STerm=-true}', "");
Expect(0, 121480, '\p{^Is_STerm=-true}', "");
Expect(0, 121480, '\P{Is_STerm=-true}', "");
Expect(1, 121480, '\P{^Is_STerm=-true}', "");
Expect(0, 121481, '\p{Is_STerm=-true}', "");
Expect(1, 121481, '\p{^Is_STerm=-true}', "");
Expect(1, 121481, '\P{Is_STerm=-true}', "");
Expect(0, 121481, '\P{^Is_STerm=-true}', "");
Error('\p{Terminal_Punctuation=/a/- No}');
Error('\P{Terminal_Punctuation=/a/- No}');
Expect(1, 121483, '\p{Terminal_Punctuation:no}', "");
Expect(0, 121483, '\p{^Terminal_Punctuation:no}', "");
Expect(0, 121483, '\P{Terminal_Punctuation:no}', "");
Expect(1, 121483, '\P{^Terminal_Punctuation:no}', "");
Expect(0, 121482, '\p{Terminal_Punctuation:no}', "");
Expect(1, 121482, '\p{^Terminal_Punctuation:no}', "");
Expect(1, 121482, '\P{Terminal_Punctuation:no}', "");
Expect(0, 121482, '\P{^Terminal_Punctuation:no}', "");
Expect(1, 121483, '\p{Terminal_Punctuation=-_No}', "");
Expect(0, 121483, '\p{^Terminal_Punctuation=-_No}', "");
Expect(0, 121483, '\P{Terminal_Punctuation=-_No}', "");
Expect(1, 121483, '\P{^Terminal_Punctuation=-_No}', "");
Expect(0, 121482, '\p{Terminal_Punctuation=-_No}', "");
Expect(1, 121482, '\p{^Terminal_Punctuation=-_No}', "");
Expect(1, 121482, '\P{Terminal_Punctuation=-_No}', "");
Expect(0, 121482, '\P{^Terminal_Punctuation=-_No}', "");
Error('\p{Term=	/a/n}');
Error('\P{Term=	/a/n}');
Expect(1, 121483, '\p{Term=n}', "");
Expect(0, 121483, '\p{^Term=n}', "");
Expect(0, 121483, '\P{Term=n}', "");
Expect(1, 121483, '\P{^Term=n}', "");
Expect(0, 121482, '\p{Term=n}', "");
Expect(1, 121482, '\p{^Term=n}', "");
Expect(1, 121482, '\P{Term=n}', "");
Expect(0, 121482, '\P{^Term=n}', "");
Expect(1, 121483, '\p{Term=_	n}', "");
Expect(0, 121483, '\p{^Term=_	n}', "");
Expect(0, 121483, '\P{Term=_	n}', "");
Expect(1, 121483, '\P{^Term=_	n}', "");
Expect(0, 121482, '\p{Term=_	n}', "");
Expect(1, 121482, '\p{^Term=_	n}', "");
Expect(1, 121482, '\P{Term=_	n}', "");
Expect(0, 121482, '\P{^Term=_	n}', "");
Error('\p{Is_Terminal_Punctuation=	/a/F}');
Error('\P{Is_Terminal_Punctuation=	/a/F}');
Expect(1, 121483, '\p{Is_Terminal_Punctuation: f}', "");
Expect(0, 121483, '\p{^Is_Terminal_Punctuation: f}', "");
Expect(0, 121483, '\P{Is_Terminal_Punctuation: f}', "");
Expect(1, 121483, '\P{^Is_Terminal_Punctuation: f}', "");
Expect(0, 121482, '\p{Is_Terminal_Punctuation: f}', "");
Expect(1, 121482, '\p{^Is_Terminal_Punctuation: f}', "");
Expect(1, 121482, '\P{Is_Terminal_Punctuation: f}', "");
Expect(0, 121482, '\P{^Is_Terminal_Punctuation: f}', "");
Expect(1, 121483, '\p{Is_Terminal_Punctuation:- F}', "");
Expect(0, 121483, '\p{^Is_Terminal_Punctuation:- F}', "");
Expect(0, 121483, '\P{Is_Terminal_Punctuation:- F}', "");
Expect(1, 121483, '\P{^Is_Terminal_Punctuation:- F}', "");
Expect(0, 121482, '\p{Is_Terminal_Punctuation:- F}', "");
Expect(1, 121482, '\p{^Is_Terminal_Punctuation:- F}', "");
Expect(1, 121482, '\P{Is_Terminal_Punctuation:- F}', "");
Expect(0, 121482, '\P{^Is_Terminal_Punctuation:- F}', "");
Error('\p{Is_Term=:=-False}');
Error('\P{Is_Term=:=-False}');
Expect(1, 121483, '\p{Is_Term=false}', "");
Expect(0, 121483, '\p{^Is_Term=false}', "");
Expect(0, 121483, '\P{Is_Term=false}', "");
Expect(1, 121483, '\P{^Is_Term=false}', "");
Expect(0, 121482, '\p{Is_Term=false}', "");
Expect(1, 121482, '\p{^Is_Term=false}', "");
Expect(1, 121482, '\P{Is_Term=false}', "");
Expect(0, 121482, '\P{^Is_Term=false}', "");
Expect(1, 121483, '\p{Is_Term:-	False}', "");
Expect(0, 121483, '\p{^Is_Term:-	False}', "");
Expect(0, 121483, '\P{Is_Term:-	False}', "");
Expect(1, 121483, '\P{^Is_Term:-	False}', "");
Expect(0, 121482, '\p{Is_Term:-	False}', "");
Expect(1, 121482, '\p{^Is_Term:-	False}', "");
Expect(1, 121482, '\P{Is_Term:-	False}', "");
Expect(0, 121482, '\P{^Is_Term:-	False}', "");
Error('\p{Terminal_Punctuation: 	/a/YES}');
Error('\P{Terminal_Punctuation: 	/a/YES}');
Expect(1, 121482, '\p{Terminal_Punctuation=yes}', "");
Expect(0, 121482, '\p{^Terminal_Punctuation=yes}', "");
Expect(0, 121482, '\P{Terminal_Punctuation=yes}', "");
Expect(1, 121482, '\P{^Terminal_Punctuation=yes}', "");
Expect(0, 121483, '\p{Terminal_Punctuation=yes}', "");
Expect(1, 121483, '\p{^Terminal_Punctuation=yes}', "");
Expect(1, 121483, '\P{Terminal_Punctuation=yes}', "");
Expect(0, 121483, '\P{^Terminal_Punctuation=yes}', "");
Expect(1, 121482, '\p{Terminal_Punctuation=-_Yes}', "");
Expect(0, 121482, '\p{^Terminal_Punctuation=-_Yes}', "");
Expect(0, 121482, '\P{Terminal_Punctuation=-_Yes}', "");
Expect(1, 121482, '\P{^Terminal_Punctuation=-_Yes}', "");
Expect(0, 121483, '\p{Terminal_Punctuation=-_Yes}', "");
Expect(1, 121483, '\p{^Terminal_Punctuation=-_Yes}', "");
Expect(1, 121483, '\P{Terminal_Punctuation=-_Yes}', "");
Expect(0, 121483, '\P{^Terminal_Punctuation=-_Yes}', "");
Error('\p{Term=:=	Y}');
Error('\P{Term=:=	Y}');
Expect(1, 121482, '\p{Term=y}', "");
Expect(0, 121482, '\p{^Term=y}', "");
Expect(0, 121482, '\P{Term=y}', "");
Expect(1, 121482, '\P{^Term=y}', "");
Expect(0, 121483, '\p{Term=y}', "");
Expect(1, 121483, '\p{^Term=y}', "");
Expect(1, 121483, '\P{Term=y}', "");
Expect(0, 121483, '\P{^Term=y}', "");
Expect(1, 121482, '\p{Term=_Y}', "");
Expect(0, 121482, '\p{^Term=_Y}', "");
Expect(0, 121482, '\P{Term=_Y}', "");
Expect(1, 121482, '\P{^Term=_Y}', "");
Expect(0, 121483, '\p{Term=_Y}', "");
Expect(1, 121483, '\p{^Term=_Y}', "");
Expect(1, 121483, '\P{Term=_Y}', "");
Expect(0, 121483, '\P{^Term=_Y}', "");
Error('\p{Is_Terminal_Punctuation:	:=T}');
Error('\P{Is_Terminal_Punctuation:	:=T}');
Expect(1, 121482, '\p{Is_Terminal_Punctuation=t}', "");
Expect(0, 121482, '\p{^Is_Terminal_Punctuation=t}', "");
Expect(0, 121482, '\P{Is_Terminal_Punctuation=t}', "");
Expect(1, 121482, '\P{^Is_Terminal_Punctuation=t}', "");
Expect(0, 121483, '\p{Is_Terminal_Punctuation=t}', "");
Expect(1, 121483, '\p{^Is_Terminal_Punctuation=t}', "");
Expect(1, 121483, '\P{Is_Terminal_Punctuation=t}', "");
Expect(0, 121483, '\P{^Is_Terminal_Punctuation=t}', "");
Expect(1, 121482, '\p{Is_Terminal_Punctuation=--T}', "");
Expect(0, 121482, '\p{^Is_Terminal_Punctuation=--T}', "");
Expect(0, 121482, '\P{Is_Terminal_Punctuation=--T}', "");
Expect(1, 121482, '\P{^Is_Terminal_Punctuation=--T}', "");
Expect(0, 121483, '\p{Is_Terminal_Punctuation=--T}', "");
Expect(1, 121483, '\p{^Is_Terminal_Punctuation=--T}', "");
Expect(1, 121483, '\P{Is_Terminal_Punctuation=--T}', "");
Expect(0, 121483, '\P{^Is_Terminal_Punctuation=--T}', "");
Error('\p{Is_Term=:=  TRUE}');
Error('\P{Is_Term=:=  TRUE}');
Expect(1, 121482, '\p{Is_Term=true}', "");
Expect(0, 121482, '\p{^Is_Term=true}', "");
Expect(0, 121482, '\P{Is_Term=true}', "");
Expect(1, 121482, '\P{^Is_Term=true}', "");
Expect(0, 121483, '\p{Is_Term=true}', "");
Expect(1, 121483, '\p{^Is_Term=true}', "");
Expect(1, 121483, '\P{Is_Term=true}', "");
Expect(0, 121483, '\P{^Is_Term=true}', "");
Expect(1, 121482, '\p{Is_Term=	True}', "");
Expect(0, 121482, '\p{^Is_Term=	True}', "");
Expect(0, 121482, '\P{Is_Term=	True}', "");
Expect(1, 121482, '\P{^Is_Term=	True}', "");
Expect(0, 121483, '\p{Is_Term=	True}', "");
Expect(1, 121483, '\p{^Is_Term=	True}', "");
Expect(1, 121483, '\P{Is_Term=	True}', "");
Expect(0, 121483, '\P{^Is_Term=	True}', "");
Error('\p{Unified_Ideograph=:=	-No}');
Error('\P{Unified_Ideograph=:=	-No}');
Expect(1, 183970, '\p{Unified_Ideograph=no}', "");
Expect(0, 183970, '\p{^Unified_Ideograph=no}', "");
Expect(0, 183970, '\P{Unified_Ideograph=no}', "");
Expect(1, 183970, '\P{^Unified_Ideograph=no}', "");
Expect(0, 183969, '\p{Unified_Ideograph=no}', "");
Expect(1, 183969, '\p{^Unified_Ideograph=no}', "");
Expect(1, 183969, '\P{Unified_Ideograph=no}', "");
Expect(0, 183969, '\P{^Unified_Ideograph=no}', "");
Expect(1, 183970, '\p{Unified_Ideograph: 	No}', "");
Expect(0, 183970, '\p{^Unified_Ideograph: 	No}', "");
Expect(0, 183970, '\P{Unified_Ideograph: 	No}', "");
Expect(1, 183970, '\P{^Unified_Ideograph: 	No}', "");
Expect(0, 183969, '\p{Unified_Ideograph: 	No}', "");
Expect(1, 183969, '\p{^Unified_Ideograph: 	No}', "");
Expect(1, 183969, '\P{Unified_Ideograph: 	No}', "");
Expect(0, 183969, '\P{^Unified_Ideograph: 	No}', "");
Error('\p{UIdeo=N/a/}');
Error('\P{UIdeo=N/a/}');
Expect(1, 183970, '\p{UIdeo=n}', "");
Expect(0, 183970, '\p{^UIdeo=n}', "");
Expect(0, 183970, '\P{UIdeo=n}', "");
Expect(1, 183970, '\P{^UIdeo=n}', "");
Expect(0, 183969, '\p{UIdeo=n}', "");
Expect(1, 183969, '\p{^UIdeo=n}', "");
Expect(1, 183969, '\P{UIdeo=n}', "");
Expect(0, 183969, '\P{^UIdeo=n}', "");
Expect(1, 183970, '\p{UIdeo= _n}', "");
Expect(0, 183970, '\p{^UIdeo= _n}', "");
Expect(0, 183970, '\P{UIdeo= _n}', "");
Expect(1, 183970, '\P{^UIdeo= _n}', "");
Expect(0, 183969, '\p{UIdeo= _n}', "");
Expect(1, 183969, '\p{^UIdeo= _n}', "");
Expect(1, 183969, '\P{UIdeo= _n}', "");
Expect(0, 183969, '\P{^UIdeo= _n}', "");
Error('\p{Is_Unified_Ideograph=  f:=}');
Error('\P{Is_Unified_Ideograph=  f:=}');
Expect(1, 183970, '\p{Is_Unified_Ideograph=f}', "");
Expect(0, 183970, '\p{^Is_Unified_Ideograph=f}', "");
Expect(0, 183970, '\P{Is_Unified_Ideograph=f}', "");
Expect(1, 183970, '\P{^Is_Unified_Ideograph=f}', "");
Expect(0, 183969, '\p{Is_Unified_Ideograph=f}', "");
Expect(1, 183969, '\p{^Is_Unified_Ideograph=f}', "");
Expect(1, 183969, '\P{Is_Unified_Ideograph=f}', "");
Expect(0, 183969, '\P{^Is_Unified_Ideograph=f}', "");
Expect(1, 183970, '\p{Is_Unified_Ideograph= F}', "");
Expect(0, 183970, '\p{^Is_Unified_Ideograph= F}', "");
Expect(0, 183970, '\P{Is_Unified_Ideograph= F}', "");
Expect(1, 183970, '\P{^Is_Unified_Ideograph= F}', "");
Expect(0, 183969, '\p{Is_Unified_Ideograph= F}', "");
Expect(1, 183969, '\p{^Is_Unified_Ideograph= F}', "");
Expect(1, 183969, '\P{Is_Unified_Ideograph= F}', "");
Expect(0, 183969, '\P{^Is_Unified_Ideograph= F}', "");
Error('\p{Is_UIdeo:-False:=}');
Error('\P{Is_UIdeo:-False:=}');
Expect(1, 183970, '\p{Is_UIdeo=false}', "");
Expect(0, 183970, '\p{^Is_UIdeo=false}', "");
Expect(0, 183970, '\P{Is_UIdeo=false}', "");
Expect(1, 183970, '\P{^Is_UIdeo=false}', "");
Expect(0, 183969, '\p{Is_UIdeo=false}', "");
Expect(1, 183969, '\p{^Is_UIdeo=false}', "");
Expect(1, 183969, '\P{Is_UIdeo=false}', "");
Expect(0, 183969, '\P{^Is_UIdeo=false}', "");
Expect(1, 183970, '\p{Is_UIdeo:	_	false}', "");
Expect(0, 183970, '\p{^Is_UIdeo:	_	false}', "");
Expect(0, 183970, '\P{Is_UIdeo:	_	false}', "");
Expect(1, 183970, '\P{^Is_UIdeo:	_	false}', "");
Expect(0, 183969, '\p{Is_UIdeo:	_	false}', "");
Expect(1, 183969, '\p{^Is_UIdeo:	_	false}', "");
Expect(1, 183969, '\P{Is_UIdeo:	_	false}', "");
Expect(0, 183969, '\P{^Is_UIdeo:	_	false}', "");
Error('\p{Unified_Ideograph=- Yes/a/}');
Error('\P{Unified_Ideograph=- Yes/a/}');
Expect(1, 183969, '\p{Unified_Ideograph=yes}', "");
Expect(0, 183969, '\p{^Unified_Ideograph=yes}', "");
Expect(0, 183969, '\P{Unified_Ideograph=yes}', "");
Expect(1, 183969, '\P{^Unified_Ideograph=yes}', "");
Expect(0, 183970, '\p{Unified_Ideograph=yes}', "");
Expect(1, 183970, '\p{^Unified_Ideograph=yes}', "");
Expect(1, 183970, '\P{Unified_Ideograph=yes}', "");
Expect(0, 183970, '\P{^Unified_Ideograph=yes}', "");
Expect(1, 183969, '\p{Unified_Ideograph:	YES}', "");
Expect(0, 183969, '\p{^Unified_Ideograph:	YES}', "");
Expect(0, 183969, '\P{Unified_Ideograph:	YES}', "");
Expect(1, 183969, '\P{^Unified_Ideograph:	YES}', "");
Expect(0, 183970, '\p{Unified_Ideograph:	YES}', "");
Expect(1, 183970, '\p{^Unified_Ideograph:	YES}', "");
Expect(1, 183970, '\P{Unified_Ideograph:	YES}', "");
Expect(0, 183970, '\P{^Unified_Ideograph:	YES}', "");
Error('\p{UIdeo=/a/-	Y}');
Error('\P{UIdeo=/a/-	Y}');
Expect(1, 183969, '\p{UIdeo=y}', "");
Expect(0, 183969, '\p{^UIdeo=y}', "");
Expect(0, 183969, '\P{UIdeo=y}', "");
Expect(1, 183969, '\P{^UIdeo=y}', "");
Expect(0, 183970, '\p{UIdeo=y}', "");
Expect(1, 183970, '\p{^UIdeo=y}', "");
Expect(1, 183970, '\P{UIdeo=y}', "");
Expect(0, 183970, '\P{^UIdeo=y}', "");
Expect(1, 183969, '\p{UIdeo=--Y}', "");
Expect(0, 183969, '\p{^UIdeo=--Y}', "");
Expect(0, 183969, '\P{UIdeo=--Y}', "");
Expect(1, 183969, '\P{^UIdeo=--Y}', "");
Expect(0, 183970, '\p{UIdeo=--Y}', "");
Expect(1, 183970, '\p{^UIdeo=--Y}', "");
Expect(1, 183970, '\P{UIdeo=--Y}', "");
Expect(0, 183970, '\P{^UIdeo=--Y}', "");
Error('\p{Is_Unified_Ideograph=:=	T}');
Error('\P{Is_Unified_Ideograph=:=	T}');
Expect(1, 183969, '\p{Is_Unified_Ideograph=t}', "");
Expect(0, 183969, '\p{^Is_Unified_Ideograph=t}', "");
Expect(0, 183969, '\P{Is_Unified_Ideograph=t}', "");
Expect(1, 183969, '\P{^Is_Unified_Ideograph=t}', "");
Expect(0, 183970, '\p{Is_Unified_Ideograph=t}', "");
Expect(1, 183970, '\p{^Is_Unified_Ideograph=t}', "");
Expect(1, 183970, '\P{Is_Unified_Ideograph=t}', "");
Expect(0, 183970, '\P{^Is_Unified_Ideograph=t}', "");
Expect(1, 183969, '\p{Is_Unified_Ideograph= T}', "");
Expect(0, 183969, '\p{^Is_Unified_Ideograph= T}', "");
Expect(0, 183969, '\P{Is_Unified_Ideograph= T}', "");
Expect(1, 183969, '\P{^Is_Unified_Ideograph= T}', "");
Expect(0, 183970, '\p{Is_Unified_Ideograph= T}', "");
Expect(1, 183970, '\p{^Is_Unified_Ideograph= T}', "");
Expect(1, 183970, '\P{Is_Unified_Ideograph= T}', "");
Expect(0, 183970, '\P{^Is_Unified_Ideograph= T}', "");
Error('\p{Is_UIdeo=-True:=}');
Error('\P{Is_UIdeo=-True:=}');
Expect(1, 183969, '\p{Is_UIdeo: true}', "");
Expect(0, 183969, '\p{^Is_UIdeo: true}', "");
Expect(0, 183969, '\P{Is_UIdeo: true}', "");
Expect(1, 183969, '\P{^Is_UIdeo: true}', "");
Expect(0, 183970, '\p{Is_UIdeo: true}', "");
Expect(1, 183970, '\p{^Is_UIdeo: true}', "");
Expect(1, 183970, '\P{Is_UIdeo: true}', "");
Expect(0, 183970, '\P{^Is_UIdeo: true}', "");
Expect(1, 183969, '\p{Is_UIdeo=_TRUE}', "");
Expect(0, 183969, '\p{^Is_UIdeo=_TRUE}', "");
Expect(0, 183969, '\P{Is_UIdeo=_TRUE}', "");
Expect(1, 183969, '\P{^Is_UIdeo=_TRUE}', "");
Expect(0, 183970, '\p{Is_UIdeo=_TRUE}', "");
Expect(1, 183970, '\p{^Is_UIdeo=_TRUE}', "");
Expect(1, 183970, '\P{Is_UIdeo=_TRUE}', "");
Expect(0, 183970, '\P{^Is_UIdeo=_TRUE}', "");
Error('\p{Uppercase=-	No:=}');
Error('\P{Uppercase=-	No:=}');
Expect(1, 127370, '\p{Uppercase=no}', "");
Expect(0, 127370, '\p{^Uppercase=no}', "");
Expect(0, 127370, '\P{Uppercase=no}', "");
Expect(1, 127370, '\P{^Uppercase=no}', "");
Expect(0, 127369, '\p{Uppercase=no}', "");
Expect(1, 127369, '\p{^Uppercase=no}', "");
Expect(1, 127369, '\P{Uppercase=no}', "");
Expect(0, 127369, '\P{^Uppercase=no}', "");
Expect(1, 127370, '\p{Uppercase:	_-No}', "");
Expect(0, 127370, '\p{^Uppercase:	_-No}', "");
Expect(0, 127370, '\P{Uppercase:	_-No}', "");
Expect(1, 127370, '\P{^Uppercase:	_-No}', "");
Expect(0, 127369, '\p{Uppercase:	_-No}', "");
Expect(1, 127369, '\p{^Uppercase:	_-No}', "");
Expect(1, 127369, '\P{Uppercase:	_-No}', "");
Expect(0, 127369, '\P{^Uppercase:	_-No}', "");
Error('\p{Upper=:=-_N}');
Error('\P{Upper=:=-_N}');
Expect(1, 127370, '\p{Upper=n}', "");
Expect(0, 127370, '\p{^Upper=n}', "");
Expect(0, 127370, '\P{Upper=n}', "");
Expect(1, 127370, '\P{^Upper=n}', "");
Expect(0, 127369, '\p{Upper=n}', "");
Expect(1, 127369, '\p{^Upper=n}', "");
Expect(1, 127369, '\P{Upper=n}', "");
Expect(0, 127369, '\P{^Upper=n}', "");
Expect(1, 127370, '\p{Upper=	N}', "");
Expect(0, 127370, '\p{^Upper=	N}', "");
Expect(0, 127370, '\P{Upper=	N}', "");
Expect(1, 127370, '\P{^Upper=	N}', "");
Expect(0, 127369, '\p{Upper=	N}', "");
Expect(1, 127369, '\p{^Upper=	N}', "");
Expect(1, 127369, '\P{Upper=	N}', "");
Expect(0, 127369, '\P{^Upper=	N}', "");
Error('\p{Is_Uppercase:	/a/_ F}');
Error('\P{Is_Uppercase:	/a/_ F}');
Expect(1, 127370, '\p{Is_Uppercase=f}', "");
Expect(0, 127370, '\p{^Is_Uppercase=f}', "");
Expect(0, 127370, '\P{Is_Uppercase=f}', "");
Expect(1, 127370, '\P{^Is_Uppercase=f}', "");
Expect(0, 127369, '\p{Is_Uppercase=f}', "");
Expect(1, 127369, '\p{^Is_Uppercase=f}', "");
Expect(1, 127369, '\P{Is_Uppercase=f}', "");
Expect(0, 127369, '\P{^Is_Uppercase=f}', "");
Expect(1, 127370, '\p{Is_Uppercase=		F}', "");
Expect(0, 127370, '\p{^Is_Uppercase=		F}', "");
Expect(0, 127370, '\P{Is_Uppercase=		F}', "");
Expect(1, 127370, '\P{^Is_Uppercase=		F}', "");
Expect(0, 127369, '\p{Is_Uppercase=		F}', "");
Expect(1, 127369, '\p{^Is_Uppercase=		F}', "");
Expect(1, 127369, '\P{Is_Uppercase=		F}', "");
Expect(0, 127369, '\P{^Is_Uppercase=		F}', "");
Error('\p{Is_Upper=_ False:=}');
Error('\P{Is_Upper=_ False:=}');
Expect(1, 127370, '\p{Is_Upper:	false}', "");
Expect(0, 127370, '\p{^Is_Upper:	false}', "");
Expect(0, 127370, '\P{Is_Upper:	false}', "");
Expect(1, 127370, '\P{^Is_Upper:	false}', "");
Expect(0, 127369, '\p{Is_Upper:	false}', "");
Expect(1, 127369, '\p{^Is_Upper:	false}', "");
Expect(1, 127369, '\P{Is_Upper:	false}', "");
Expect(0, 127369, '\P{^Is_Upper:	false}', "");
Expect(1, 127370, '\p{Is_Upper=-False}', "");
Expect(0, 127370, '\p{^Is_Upper=-False}', "");
Expect(0, 127370, '\P{Is_Upper=-False}', "");
Expect(1, 127370, '\P{^Is_Upper=-False}', "");
Expect(0, 127369, '\p{Is_Upper=-False}', "");
Expect(1, 127369, '\p{^Is_Upper=-False}', "");
Expect(1, 127369, '\P{Is_Upper=-False}', "");
Expect(0, 127369, '\P{^Is_Upper=-False}', "");
Error('\p{Uppercase=/a/-_YES}');
Error('\P{Uppercase=/a/-_YES}');
Expect(1, 127369, '\p{Uppercase=yes}', "");
Expect(0, 127369, '\p{^Uppercase=yes}', "");
Expect(0, 127369, '\P{Uppercase=yes}', "");
Expect(1, 127369, '\P{^Uppercase=yes}', "");
Expect(0, 127370, '\p{Uppercase=yes}', "");
Expect(1, 127370, '\p{^Uppercase=yes}', "");
Expect(1, 127370, '\P{Uppercase=yes}', "");
Expect(0, 127370, '\P{^Uppercase=yes}', "");
Expect(1, 127369, '\p{Uppercase=	YES}', "");
Expect(0, 127369, '\p{^Uppercase=	YES}', "");
Expect(0, 127369, '\P{Uppercase=	YES}', "");
Expect(1, 127369, '\P{^Uppercase=	YES}', "");
Expect(0, 127370, '\p{Uppercase=	YES}', "");
Expect(1, 127370, '\p{^Uppercase=	YES}', "");
Expect(1, 127370, '\P{Uppercase=	YES}', "");
Expect(0, 127370, '\P{^Uppercase=	YES}', "");
Error('\p{Upper:	/a/__Y}');
Error('\P{Upper:	/a/__Y}');
Expect(1, 127369, '\p{Upper=y}', "");
Expect(0, 127369, '\p{^Upper=y}', "");
Expect(0, 127369, '\P{Upper=y}', "");
Expect(1, 127369, '\P{^Upper=y}', "");
Expect(0, 127370, '\p{Upper=y}', "");
Expect(1, 127370, '\p{^Upper=y}', "");
Expect(1, 127370, '\P{Upper=y}', "");
Expect(0, 127370, '\P{^Upper=y}', "");
Expect(1, 127369, '\p{Upper=	_Y}', "");
Expect(0, 127369, '\p{^Upper=	_Y}', "");
Expect(0, 127369, '\P{Upper=	_Y}', "");
Expect(1, 127369, '\P{^Upper=	_Y}', "");
Expect(0, 127370, '\p{Upper=	_Y}', "");
Expect(1, 127370, '\p{^Upper=	_Y}', "");
Expect(1, 127370, '\P{Upper=	_Y}', "");
Expect(0, 127370, '\P{^Upper=	_Y}', "");
Error('\p{Is_Uppercase: :=T}');
Error('\P{Is_Uppercase: :=T}');
Expect(1, 127369, '\p{Is_Uppercase=t}', "");
Expect(0, 127369, '\p{^Is_Uppercase=t}', "");
Expect(0, 127369, '\P{Is_Uppercase=t}', "");
Expect(1, 127369, '\P{^Is_Uppercase=t}', "");
Expect(0, 127370, '\p{Is_Uppercase=t}', "");
Expect(1, 127370, '\p{^Is_Uppercase=t}', "");
Expect(1, 127370, '\P{Is_Uppercase=t}', "");
Expect(0, 127370, '\P{^Is_Uppercase=t}', "");
Expect(1, 127369, '\p{Is_Uppercase=	-t}', "");
Expect(0, 127369, '\p{^Is_Uppercase=	-t}', "");
Expect(0, 127369, '\P{Is_Uppercase=	-t}', "");
Expect(1, 127369, '\P{^Is_Uppercase=	-t}', "");
Expect(0, 127370, '\p{Is_Uppercase=	-t}', "");
Expect(1, 127370, '\p{^Is_Uppercase=	-t}', "");
Expect(1, 127370, '\P{Is_Uppercase=	-t}', "");
Expect(0, 127370, '\P{^Is_Uppercase=	-t}', "");
Error('\p{Is_Upper=/a/-	True}');
Error('\P{Is_Upper=/a/-	True}');
Expect(1, 127369, '\p{Is_Upper=true}', "");
Expect(0, 127369, '\p{^Is_Upper=true}', "");
Expect(0, 127369, '\P{Is_Upper=true}', "");
Expect(1, 127369, '\P{^Is_Upper=true}', "");
Expect(0, 127370, '\p{Is_Upper=true}', "");
Expect(1, 127370, '\p{^Is_Upper=true}', "");
Expect(1, 127370, '\P{Is_Upper=true}', "");
Expect(0, 127370, '\P{^Is_Upper=true}', "");
Expect(1, 127369, '\p{Is_Upper=  True}', "");
Expect(0, 127369, '\p{^Is_Upper=  True}', "");
Expect(0, 127369, '\P{Is_Upper=  True}', "");
Expect(1, 127369, '\P{^Is_Upper=  True}', "");
Expect(0, 127370, '\p{Is_Upper=  True}', "");
Expect(1, 127370, '\p{^Is_Upper=  True}', "");
Expect(1, 127370, '\P{Is_Upper=  True}', "");
Expect(0, 127370, '\P{^Is_Upper=  True}', "");
Error('\p{Variation_Selector:	 _No:=}');
Error('\P{Variation_Selector:	 _No:=}');
Expect(1, 918000, '\p{Variation_Selector=no}', "");
Expect(0, 918000, '\p{^Variation_Selector=no}', "");
Expect(0, 918000, '\P{Variation_Selector=no}', "");
Expect(1, 918000, '\P{^Variation_Selector=no}', "");
Expect(0, 917999, '\p{Variation_Selector=no}', "");
Expect(1, 917999, '\p{^Variation_Selector=no}', "");
Expect(1, 917999, '\P{Variation_Selector=no}', "");
Expect(0, 917999, '\P{^Variation_Selector=no}', "");
Expect(1, 918000, '\p{Variation_Selector=  No}', "");
Expect(0, 918000, '\p{^Variation_Selector=  No}', "");
Expect(0, 918000, '\P{Variation_Selector=  No}', "");
Expect(1, 918000, '\P{^Variation_Selector=  No}', "");
Expect(0, 917999, '\p{Variation_Selector=  No}', "");
Expect(1, 917999, '\p{^Variation_Selector=  No}', "");
Expect(1, 917999, '\P{Variation_Selector=  No}', "");
Expect(0, 917999, '\P{^Variation_Selector=  No}', "");
Error('\p{VS=	/a/N}');
Error('\P{VS=	/a/N}');
Expect(1, 918000, '\p{VS=n}', "");
Expect(0, 918000, '\p{^VS=n}', "");
Expect(0, 918000, '\P{VS=n}', "");
Expect(1, 918000, '\P{^VS=n}', "");
Expect(0, 917999, '\p{VS=n}', "");
Expect(1, 917999, '\p{^VS=n}', "");
Expect(1, 917999, '\P{VS=n}', "");
Expect(0, 917999, '\P{^VS=n}', "");
Expect(1, 918000, '\p{VS=	-n}', "");
Expect(0, 918000, '\p{^VS=	-n}', "");
Expect(0, 918000, '\P{VS=	-n}', "");
Expect(1, 918000, '\P{^VS=	-n}', "");
Expect(0, 917999, '\p{VS=	-n}', "");
Expect(1, 917999, '\p{^VS=	-n}', "");
Expect(1, 917999, '\P{VS=	-n}', "");
Expect(0, 917999, '\P{^VS=	-n}', "");
Error('\p{Is_Variation_Selector:   :=_F}');
Error('\P{Is_Variation_Selector:   :=_F}');
Expect(1, 918000, '\p{Is_Variation_Selector:f}', "");
Expect(0, 918000, '\p{^Is_Variation_Selector:f}', "");
Expect(0, 918000, '\P{Is_Variation_Selector:f}', "");
Expect(1, 918000, '\P{^Is_Variation_Selector:f}', "");
Expect(0, 917999, '\p{Is_Variation_Selector:f}', "");
Expect(1, 917999, '\p{^Is_Variation_Selector:f}', "");
Expect(1, 917999, '\P{Is_Variation_Selector:f}', "");
Expect(0, 917999, '\P{^Is_Variation_Selector:f}', "");
Expect(1, 918000, '\p{Is_Variation_Selector=-F}', "");
Expect(0, 918000, '\p{^Is_Variation_Selector=-F}', "");
Expect(0, 918000, '\P{Is_Variation_Selector=-F}', "");
Expect(1, 918000, '\P{^Is_Variation_Selector=-F}', "");
Expect(0, 917999, '\p{Is_Variation_Selector=-F}', "");
Expect(1, 917999, '\p{^Is_Variation_Selector=-F}', "");
Expect(1, 917999, '\P{Is_Variation_Selector=-F}', "");
Expect(0, 917999, '\P{^Is_Variation_Selector=-F}', "");
Error('\p{Is_VS:	_:=FALSE}');
Error('\P{Is_VS:	_:=FALSE}');
Expect(1, 918000, '\p{Is_VS=false}', "");
Expect(0, 918000, '\p{^Is_VS=false}', "");
Expect(0, 918000, '\P{Is_VS=false}', "");
Expect(1, 918000, '\P{^Is_VS=false}', "");
Expect(0, 917999, '\p{Is_VS=false}', "");
Expect(1, 917999, '\p{^Is_VS=false}', "");
Expect(1, 917999, '\P{Is_VS=false}', "");
Expect(0, 917999, '\P{^Is_VS=false}', "");
Expect(1, 918000, '\p{Is_VS:		_False}', "");
Expect(0, 918000, '\p{^Is_VS:		_False}', "");
Expect(0, 918000, '\P{Is_VS:		_False}', "");
Expect(1, 918000, '\P{^Is_VS:		_False}', "");
Expect(0, 917999, '\p{Is_VS:		_False}', "");
Expect(1, 917999, '\p{^Is_VS:		_False}', "");
Expect(1, 917999, '\P{Is_VS:		_False}', "");
Expect(0, 917999, '\P{^Is_VS:		_False}', "");
Error('\p{Variation_Selector=_	yes/a/}');
Error('\P{Variation_Selector=_	yes/a/}');
Expect(1, 917999, '\p{Variation_Selector=yes}', "");
Expect(0, 917999, '\p{^Variation_Selector=yes}', "");
Expect(0, 917999, '\P{Variation_Selector=yes}', "");
Expect(1, 917999, '\P{^Variation_Selector=yes}', "");
Expect(0, 918000, '\p{Variation_Selector=yes}', "");
Expect(1, 918000, '\p{^Variation_Selector=yes}', "");
Expect(1, 918000, '\P{Variation_Selector=yes}', "");
Expect(0, 918000, '\P{^Variation_Selector=yes}', "");
Expect(1, 917999, '\p{Variation_Selector=-Yes}', "");
Expect(0, 917999, '\p{^Variation_Selector=-Yes}', "");
Expect(0, 917999, '\P{Variation_Selector=-Yes}', "");
Expect(1, 917999, '\P{^Variation_Selector=-Yes}', "");
Expect(0, 918000, '\p{Variation_Selector=-Yes}', "");
Expect(1, 918000, '\p{^Variation_Selector=-Yes}', "");
Expect(1, 918000, '\P{Variation_Selector=-Yes}', "");
Expect(0, 918000, '\P{^Variation_Selector=-Yes}', "");
Error('\p{VS=/a/_y}');
Error('\P{VS=/a/_y}');
Expect(1, 917999, '\p{VS=y}', "");
Expect(0, 917999, '\p{^VS=y}', "");
Expect(0, 917999, '\P{VS=y}', "");
Expect(1, 917999, '\P{^VS=y}', "");
Expect(0, 918000, '\p{VS=y}', "");
Expect(1, 918000, '\p{^VS=y}', "");
Expect(1, 918000, '\P{VS=y}', "");
Expect(0, 918000, '\P{^VS=y}', "");
Expect(1, 917999, '\p{VS=		y}', "");
Expect(0, 917999, '\p{^VS=		y}', "");
Expect(0, 917999, '\P{VS=		y}', "");
Expect(1, 917999, '\P{^VS=		y}', "");
Expect(0, 918000, '\p{VS=		y}', "");
Expect(1, 918000, '\p{^VS=		y}', "");
Expect(1, 918000, '\P{VS=		y}', "");
Expect(0, 918000, '\P{^VS=		y}', "");
Error('\p{Is_Variation_Selector=_/a/T}');
Error('\P{Is_Variation_Selector=_/a/T}');
Expect(1, 917999, '\p{Is_Variation_Selector=t}', "");
Expect(0, 917999, '\p{^Is_Variation_Selector=t}', "");
Expect(0, 917999, '\P{Is_Variation_Selector=t}', "");
Expect(1, 917999, '\P{^Is_Variation_Selector=t}', "");
Expect(0, 918000, '\p{Is_Variation_Selector=t}', "");
Expect(1, 918000, '\p{^Is_Variation_Selector=t}', "");
Expect(1, 918000, '\P{Is_Variation_Selector=t}', "");
Expect(0, 918000, '\P{^Is_Variation_Selector=t}', "");
Expect(1, 917999, '\p{Is_Variation_Selector= t}', "");
Expect(0, 917999, '\p{^Is_Variation_Selector= t}', "");
Expect(0, 917999, '\P{Is_Variation_Selector= t}', "");
Expect(1, 917999, '\P{^Is_Variation_Selector= t}', "");
Expect(0, 918000, '\p{Is_Variation_Selector= t}', "");
Expect(1, 918000, '\p{^Is_Variation_Selector= t}', "");
Expect(1, 918000, '\P{Is_Variation_Selector= t}', "");
Expect(0, 918000, '\P{^Is_Variation_Selector= t}', "");
Error('\p{Is_VS=/a/_ true}');
Error('\P{Is_VS=/a/_ true}');
Expect(1, 917999, '\p{Is_VS:	true}', "");
Expect(0, 917999, '\p{^Is_VS:	true}', "");
Expect(0, 917999, '\P{Is_VS:	true}', "");
Expect(1, 917999, '\P{^Is_VS:	true}', "");
Expect(0, 918000, '\p{Is_VS:	true}', "");
Expect(1, 918000, '\p{^Is_VS:	true}', "");
Expect(1, 918000, '\P{Is_VS:	true}', "");
Expect(0, 918000, '\P{^Is_VS:	true}', "");
Expect(1, 917999, '\p{Is_VS=True}', "");
Expect(0, 917999, '\p{^Is_VS=True}', "");
Expect(0, 917999, '\P{Is_VS=True}', "");
Expect(1, 917999, '\P{^Is_VS=True}', "");
Expect(0, 918000, '\p{Is_VS=True}', "");
Expect(1, 918000, '\p{^Is_VS=True}', "");
Expect(1, 918000, '\P{Is_VS=True}', "");
Expect(0, 918000, '\P{^Is_VS=True}', "");
Error('\p{Word_Break=:=_-CR}');
Error('\P{Word_Break=:=_-CR}');
Expect(1, 13, '\p{Word_Break=cr}', "");
Expect(0, 13, '\p{^Word_Break=cr}', "");
Expect(0, 13, '\P{Word_Break=cr}', "");
Expect(1, 13, '\P{^Word_Break=cr}', "");
Expect(0, 14, '\p{Word_Break=cr}', "");
Expect(1, 14, '\p{^Word_Break=cr}', "");
Expect(1, 14, '\P{Word_Break=cr}', "");
Expect(0, 14, '\P{^Word_Break=cr}', "");
Expect(1, 13, '\p{Word_Break=_CR}', "");
Expect(0, 13, '\p{^Word_Break=_CR}', "");
Expect(0, 13, '\P{Word_Break=_CR}', "");
Expect(1, 13, '\P{^Word_Break=_CR}', "");
Expect(0, 14, '\p{Word_Break=_CR}', "");
Expect(1, 14, '\p{^Word_Break=_CR}', "");
Expect(1, 14, '\P{Word_Break=_CR}', "");
Expect(0, 14, '\P{^Word_Break=_CR}', "");
Error('\p{WB=/a/cr}');
Error('\P{WB=/a/cr}');
Expect(1, 13, '\p{WB=cr}', "");
Expect(0, 13, '\p{^WB=cr}', "");
Expect(0, 13, '\P{WB=cr}', "");
Expect(1, 13, '\P{^WB=cr}', "");
Expect(0, 14, '\p{WB=cr}', "");
Expect(1, 14, '\p{^WB=cr}', "");
Expect(1, 14, '\P{WB=cr}', "");
Expect(0, 14, '\P{^WB=cr}', "");
Expect(1, 13, '\p{WB=		CR}', "");
Expect(0, 13, '\p{^WB=		CR}', "");
Expect(0, 13, '\P{WB=		CR}', "");
Expect(1, 13, '\P{^WB=		CR}', "");
Expect(0, 14, '\p{WB=		CR}', "");
Expect(1, 14, '\p{^WB=		CR}', "");
Expect(1, 14, '\P{WB=		CR}', "");
Expect(0, 14, '\P{^WB=		CR}', "");
Error('\p{Is_Word_Break:  _cr:=}');
Error('\P{Is_Word_Break:  _cr:=}');
Expect(1, 13, '\p{Is_Word_Break=cr}', "");
Expect(0, 13, '\p{^Is_Word_Break=cr}', "");
Expect(0, 13, '\P{Is_Word_Break=cr}', "");
Expect(1, 13, '\P{^Is_Word_Break=cr}', "");
Expect(0, 14, '\p{Is_Word_Break=cr}', "");
Expect(1, 14, '\p{^Is_Word_Break=cr}', "");
Expect(1, 14, '\P{Is_Word_Break=cr}', "");
Expect(0, 14, '\P{^Is_Word_Break=cr}', "");
Expect(1, 13, '\p{Is_Word_Break=	_cr}', "");
Expect(0, 13, '\p{^Is_Word_Break=	_cr}', "");
Expect(0, 13, '\P{Is_Word_Break=	_cr}', "");
Expect(1, 13, '\P{^Is_Word_Break=	_cr}', "");
Expect(0, 14, '\p{Is_Word_Break=	_cr}', "");
Expect(1, 14, '\p{^Is_Word_Break=	_cr}', "");
Expect(1, 14, '\P{Is_Word_Break=	_cr}', "");
Expect(0, 14, '\P{^Is_Word_Break=	_cr}', "");
Error('\p{Is_WB=:=CR}');
Error('\P{Is_WB=:=CR}');
Expect(1, 13, '\p{Is_WB=cr}', "");
Expect(0, 13, '\p{^Is_WB=cr}', "");
Expect(0, 13, '\P{Is_WB=cr}', "");
Expect(1, 13, '\P{^Is_WB=cr}', "");
Expect(0, 14, '\p{Is_WB=cr}', "");
Expect(1, 14, '\p{^Is_WB=cr}', "");
Expect(1, 14, '\P{Is_WB=cr}', "");
Expect(0, 14, '\P{^Is_WB=cr}', "");
Expect(1, 13, '\p{Is_WB=_CR}', "");
Expect(0, 13, '\p{^Is_WB=_CR}', "");
Expect(0, 13, '\P{Is_WB=_CR}', "");
Expect(1, 13, '\P{^Is_WB=_CR}', "");
Expect(0, 14, '\p{Is_WB=_CR}', "");
Expect(1, 14, '\p{^Is_WB=_CR}', "");
Expect(1, 14, '\P{Is_WB=_CR}', "");
Expect(0, 14, '\P{^Is_WB=_CR}', "");
Error('\p{Word_Break=	_DOUBLE_Quote:=}');
Error('\P{Word_Break=	_DOUBLE_Quote:=}');
Expect(1, 34, '\p{Word_Break=doublequote}', "");
Expect(0, 34, '\p{^Word_Break=doublequote}', "");
Expect(0, 34, '\P{Word_Break=doublequote}', "");
Expect(1, 34, '\P{^Word_Break=doublequote}', "");
Expect(0, 35, '\p{Word_Break=doublequote}', "");
Expect(1, 35, '\p{^Word_Break=doublequote}', "");
Expect(1, 35, '\P{Word_Break=doublequote}', "");
Expect(0, 35, '\P{^Word_Break=doublequote}', "");
Expect(1, 34, '\p{Word_Break=	-Double_Quote}', "");
Expect(0, 34, '\p{^Word_Break=	-Double_Quote}', "");
Expect(0, 34, '\P{Word_Break=	-Double_Quote}', "");
Expect(1, 34, '\P{^Word_Break=	-Double_Quote}', "");
Expect(0, 35, '\p{Word_Break=	-Double_Quote}', "");
Expect(1, 35, '\p{^Word_Break=	-Double_Quote}', "");
Expect(1, 35, '\P{Word_Break=	-Double_Quote}', "");
Expect(0, 35, '\P{^Word_Break=	-Double_Quote}', "");
Error('\p{WB=/a/ -DQ}');
Error('\P{WB=/a/ -DQ}');
Expect(1, 34, '\p{WB=dq}', "");
Expect(0, 34, '\p{^WB=dq}', "");
Expect(0, 34, '\P{WB=dq}', "");
Expect(1, 34, '\P{^WB=dq}', "");
Expect(0, 35, '\p{WB=dq}', "");
Expect(1, 35, '\p{^WB=dq}', "");
Expect(1, 35, '\P{WB=dq}', "");
Expect(0, 35, '\P{^WB=dq}', "");
Expect(1, 34, '\p{WB=__DQ}', "");
Expect(0, 34, '\p{^WB=__DQ}', "");
Expect(0, 34, '\P{WB=__DQ}', "");
Expect(1, 34, '\P{^WB=__DQ}', "");
Expect(0, 35, '\p{WB=__DQ}', "");
Expect(1, 35, '\p{^WB=__DQ}', "");
Expect(1, 35, '\P{WB=__DQ}', "");
Expect(0, 35, '\P{^WB=__DQ}', "");
Error('\p{Is_Word_Break=-/a/Double_QUOTE}');
Error('\P{Is_Word_Break=-/a/Double_QUOTE}');
Expect(1, 34, '\p{Is_Word_Break=doublequote}', "");
Expect(0, 34, '\p{^Is_Word_Break=doublequote}', "");
Expect(0, 34, '\P{Is_Word_Break=doublequote}', "");
Expect(1, 34, '\P{^Is_Word_Break=doublequote}', "");
Expect(0, 35, '\p{Is_Word_Break=doublequote}', "");
Expect(1, 35, '\p{^Is_Word_Break=doublequote}', "");
Expect(1, 35, '\P{Is_Word_Break=doublequote}', "");
Expect(0, 35, '\P{^Is_Word_Break=doublequote}', "");
Expect(1, 34, '\p{Is_Word_Break=	 double_QUOTE}', "");
Expect(0, 34, '\p{^Is_Word_Break=	 double_QUOTE}', "");
Expect(0, 34, '\P{Is_Word_Break=	 double_QUOTE}', "");
Expect(1, 34, '\P{^Is_Word_Break=	 double_QUOTE}', "");
Expect(0, 35, '\p{Is_Word_Break=	 double_QUOTE}', "");
Expect(1, 35, '\p{^Is_Word_Break=	 double_QUOTE}', "");
Expect(1, 35, '\P{Is_Word_Break=	 double_QUOTE}', "");
Expect(0, 35, '\P{^Is_Word_Break=	 double_QUOTE}', "");
Error('\p{Is_WB=  dq/a/}');
Error('\P{Is_WB=  dq/a/}');
Expect(1, 34, '\p{Is_WB=dq}', "");
Expect(0, 34, '\p{^Is_WB=dq}', "");
Expect(0, 34, '\P{Is_WB=dq}', "");
Expect(1, 34, '\P{^Is_WB=dq}', "");
Expect(0, 35, '\p{Is_WB=dq}', "");
Expect(1, 35, '\p{^Is_WB=dq}', "");
Expect(1, 35, '\P{Is_WB=dq}', "");
Expect(0, 35, '\P{^Is_WB=dq}', "");
Expect(1, 34, '\p{Is_WB=-DQ}', "");
Expect(0, 34, '\p{^Is_WB=-DQ}', "");
Expect(0, 34, '\P{Is_WB=-DQ}', "");
Expect(1, 34, '\P{^Is_WB=-DQ}', "");
Expect(0, 35, '\p{Is_WB=-DQ}', "");
Expect(1, 35, '\p{^Is_WB=-DQ}', "");
Expect(1, 35, '\P{Is_WB=-DQ}', "");
Expect(0, 35, '\P{^Is_WB=-DQ}', "");
Error('\p{Word_Break=__EXTENDNUMLET:=}');
Error('\P{Word_Break=__EXTENDNUMLET:=}');
Expect(1, 65343, '\p{Word_Break=extendnumlet}', "");
Expect(0, 65343, '\p{^Word_Break=extendnumlet}', "");
Expect(0, 65343, '\P{Word_Break=extendnumlet}', "");
Expect(1, 65343, '\P{^Word_Break=extendnumlet}', "");
Expect(0, 65344, '\p{Word_Break=extendnumlet}', "");
Expect(1, 65344, '\p{^Word_Break=extendnumlet}', "");
Expect(1, 65344, '\P{Word_Break=extendnumlet}', "");
Expect(0, 65344, '\P{^Word_Break=extendnumlet}', "");
Expect(1, 65343, '\p{Word_Break=- extendnumlet}', "");
Expect(0, 65343, '\p{^Word_Break=- extendnumlet}', "");
Expect(0, 65343, '\P{Word_Break=- extendnumlet}', "");
Expect(1, 65343, '\P{^Word_Break=- extendnumlet}', "");
Expect(0, 65344, '\p{Word_Break=- extendnumlet}', "");
Expect(1, 65344, '\p{^Word_Break=- extendnumlet}', "");
Expect(1, 65344, '\P{Word_Break=- extendnumlet}', "");
Expect(0, 65344, '\P{^Word_Break=- extendnumlet}', "");
Error('\p{WB=_:=EX}');
Error('\P{WB=_:=EX}');
Expect(1, 65343, '\p{WB: ex}', "");
Expect(0, 65343, '\p{^WB: ex}', "");
Expect(0, 65343, '\P{WB: ex}', "");
Expect(1, 65343, '\P{^WB: ex}', "");
Expect(0, 65344, '\p{WB: ex}', "");
Expect(1, 65344, '\p{^WB: ex}', "");
Expect(1, 65344, '\P{WB: ex}', "");
Expect(0, 65344, '\P{^WB: ex}', "");
Expect(1, 65343, '\p{WB= 	EX}', "");
Expect(0, 65343, '\p{^WB= 	EX}', "");
Expect(0, 65343, '\P{WB= 	EX}', "");
Expect(1, 65343, '\P{^WB= 	EX}', "");
Expect(0, 65344, '\p{WB= 	EX}', "");
Expect(1, 65344, '\p{^WB= 	EX}', "");
Expect(1, 65344, '\P{WB= 	EX}', "");
Expect(0, 65344, '\P{^WB= 	EX}', "");
Error('\p{Is_Word_Break:   _/a/ExtendNumLet}');
Error('\P{Is_Word_Break:   _/a/ExtendNumLet}');
Expect(1, 65343, '\p{Is_Word_Break=extendnumlet}', "");
Expect(0, 65343, '\p{^Is_Word_Break=extendnumlet}', "");
Expect(0, 65343, '\P{Is_Word_Break=extendnumlet}', "");
Expect(1, 65343, '\P{^Is_Word_Break=extendnumlet}', "");
Expect(0, 65344, '\p{Is_Word_Break=extendnumlet}', "");
Expect(1, 65344, '\p{^Is_Word_Break=extendnumlet}', "");
Expect(1, 65344, '\P{Is_Word_Break=extendnumlet}', "");
Expect(0, 65344, '\P{^Is_Word_Break=extendnumlet}', "");
Expect(1, 65343, '\p{Is_Word_Break:	-_extendnumlet}', "");
Expect(0, 65343, '\p{^Is_Word_Break:	-_extendnumlet}', "");
Expect(0, 65343, '\P{Is_Word_Break:	-_extendnumlet}', "");
Expect(1, 65343, '\P{^Is_Word_Break:	-_extendnumlet}', "");
Expect(0, 65344, '\p{Is_Word_Break:	-_extendnumlet}', "");
Expect(1, 65344, '\p{^Is_Word_Break:	-_extendnumlet}', "");
Expect(1, 65344, '\P{Is_Word_Break:	-_extendnumlet}', "");
Expect(0, 65344, '\P{^Is_Word_Break:	-_extendnumlet}', "");
Error('\p{Is_WB=	EX/a/}');
Error('\P{Is_WB=	EX/a/}');
Expect(1, 65343, '\p{Is_WB=ex}', "");
Expect(0, 65343, '\p{^Is_WB=ex}', "");
Expect(0, 65343, '\P{Is_WB=ex}', "");
Expect(1, 65343, '\P{^Is_WB=ex}', "");
Expect(0, 65344, '\p{Is_WB=ex}', "");
Expect(1, 65344, '\p{^Is_WB=ex}', "");
Expect(1, 65344, '\P{Is_WB=ex}', "");
Expect(0, 65344, '\P{^Is_WB=ex}', "");
Expect(1, 65343, '\p{Is_WB=-_ex}', "");
Expect(0, 65343, '\p{^Is_WB=-_ex}', "");
Expect(0, 65343, '\P{Is_WB=-_ex}', "");
Expect(1, 65343, '\P{^Is_WB=-_ex}', "");
Expect(0, 65344, '\p{Is_WB=-_ex}', "");
Expect(1, 65344, '\p{^Is_WB=-_ex}', "");
Expect(1, 65344, '\P{Is_WB=-_ex}', "");
Expect(0, 65344, '\P{^Is_WB=-_ex}', "");
Error('\p{Word_Break=:=	extend}');
Error('\P{Word_Break=:=	extend}');
Expect(1, 917999, '\p{Word_Break=extend}', "");
Expect(0, 917999, '\p{^Word_Break=extend}', "");
Expect(0, 917999, '\P{Word_Break=extend}', "");
Expect(1, 917999, '\P{^Word_Break=extend}', "");
Expect(0, 918000, '\p{Word_Break=extend}', "");
Expect(1, 918000, '\p{^Word_Break=extend}', "");
Expect(1, 918000, '\P{Word_Break=extend}', "");
Expect(0, 918000, '\P{^Word_Break=extend}', "");
Expect(1, 917999, '\p{Word_Break=--EXTEND}', "");
Expect(0, 917999, '\p{^Word_Break=--EXTEND}', "");
Expect(0, 917999, '\P{Word_Break=--EXTEND}', "");
Expect(1, 917999, '\P{^Word_Break=--EXTEND}', "");
Expect(0, 918000, '\p{Word_Break=--EXTEND}', "");
Expect(1, 918000, '\p{^Word_Break=--EXTEND}', "");
Expect(1, 918000, '\P{Word_Break=--EXTEND}', "");
Expect(0, 918000, '\P{^Word_Break=--EXTEND}', "");
Error('\p{WB=:=-EXTEND}');
Error('\P{WB=:=-EXTEND}');
Expect(1, 917999, '\p{WB=extend}', "");
Expect(0, 917999, '\p{^WB=extend}', "");
Expect(0, 917999, '\P{WB=extend}', "");
Expect(1, 917999, '\P{^WB=extend}', "");
Expect(0, 918000, '\p{WB=extend}', "");
Expect(1, 918000, '\p{^WB=extend}', "");
Expect(1, 918000, '\P{WB=extend}', "");
Expect(0, 918000, '\P{^WB=extend}', "");
Expect(1, 917999, '\p{WB=_ Extend}', "");
Expect(0, 917999, '\p{^WB=_ Extend}', "");
Expect(0, 917999, '\P{WB=_ Extend}', "");
Expect(1, 917999, '\P{^WB=_ Extend}', "");
Expect(0, 918000, '\p{WB=_ Extend}', "");
Expect(1, 918000, '\p{^WB=_ Extend}', "");
Expect(1, 918000, '\P{WB=_ Extend}', "");
Expect(0, 918000, '\P{^WB=_ Extend}', "");
Error('\p{Is_Word_Break=/a/ _Extend}');
Error('\P{Is_Word_Break=/a/ _Extend}');
Expect(1, 917999, '\p{Is_Word_Break:   extend}', "");
Expect(0, 917999, '\p{^Is_Word_Break:   extend}', "");
Expect(0, 917999, '\P{Is_Word_Break:   extend}', "");
Expect(1, 917999, '\P{^Is_Word_Break:   extend}', "");
Expect(0, 918000, '\p{Is_Word_Break:   extend}', "");
Expect(1, 918000, '\p{^Is_Word_Break:   extend}', "");
Expect(1, 918000, '\P{Is_Word_Break:   extend}', "");
Expect(0, 918000, '\P{^Is_Word_Break:   extend}', "");
Expect(1, 917999, '\p{Is_Word_Break=-EXTEND}', "");
Expect(0, 917999, '\p{^Is_Word_Break=-EXTEND}', "");
Expect(0, 917999, '\P{Is_Word_Break=-EXTEND}', "");
Expect(1, 917999, '\P{^Is_Word_Break=-EXTEND}', "");
Expect(0, 918000, '\p{Is_Word_Break=-EXTEND}', "");
Expect(1, 918000, '\p{^Is_Word_Break=-EXTEND}', "");
Expect(1, 918000, '\P{Is_Word_Break=-EXTEND}', "");
Expect(0, 918000, '\P{^Is_Word_Break=-EXTEND}', "");
Error('\p{Is_WB=-:=Extend}');
Error('\P{Is_WB=-:=Extend}');
Expect(1, 917999, '\p{Is_WB=extend}', "");
Expect(0, 917999, '\p{^Is_WB=extend}', "");
Expect(0, 917999, '\P{Is_WB=extend}', "");
Expect(1, 917999, '\P{^Is_WB=extend}', "");
Expect(0, 918000, '\p{Is_WB=extend}', "");
Expect(1, 918000, '\p{^Is_WB=extend}', "");
Expect(1, 918000, '\P{Is_WB=extend}', "");
Expect(0, 918000, '\P{^Is_WB=extend}', "");
Expect(1, 917999, '\p{Is_WB:	 _Extend}', "");
Expect(0, 917999, '\p{^Is_WB:	 _Extend}', "");
Expect(0, 917999, '\P{Is_WB:	 _Extend}', "");
Expect(1, 917999, '\P{^Is_WB:	 _Extend}', "");
Expect(0, 918000, '\p{Is_WB:	 _Extend}', "");
Expect(1, 918000, '\p{^Is_WB:	 _Extend}', "");
Expect(1, 918000, '\P{Is_WB:	 _Extend}', "");
Expect(0, 918000, '\P{^Is_WB:	 _Extend}', "");
Error('\p{Word_Break=:= format}');
Error('\P{Word_Break=:= format}');
Expect(1, 917631, '\p{Word_Break=format}', "");
Expect(0, 917631, '\p{^Word_Break=format}', "");
Expect(0, 917631, '\P{Word_Break=format}', "");
Expect(1, 917631, '\P{^Word_Break=format}', "");
Expect(0, 917632, '\p{Word_Break=format}', "");
Expect(1, 917632, '\p{^Word_Break=format}', "");
Expect(1, 917632, '\P{Word_Break=format}', "");
Expect(0, 917632, '\P{^Word_Break=format}', "");
Error('\p{WB=	/a/FO}');
Error('\P{WB=	/a/FO}');
Expect(1, 917631, '\p{WB=fo}', "");
Expect(0, 917631, '\p{^WB=fo}', "");
Expect(0, 917631, '\P{WB=fo}', "");
Expect(1, 917631, '\P{^WB=fo}', "");
Expect(0, 917632, '\p{WB=fo}', "");
Expect(1, 917632, '\p{^WB=fo}', "");
Expect(1, 917632, '\P{WB=fo}', "");
Expect(0, 917632, '\P{^WB=fo}', "");
Expect(1, 917631, '\p{WB:   fo}', "");
Expect(0, 917631, '\p{^WB:   fo}', "");
Expect(0, 917631, '\P{WB:   fo}', "");
Expect(1, 917631, '\P{^WB:   fo}', "");
Expect(0, 917632, '\p{WB:   fo}', "");
Expect(1, 917632, '\p{^WB:   fo}', "");
Expect(1, 917632, '\P{WB:   fo}', "");
Expect(0, 917632, '\P{^WB:   fo}', "");
Error('\p{Is_Word_Break=:=	_format}');
Error('\P{Is_Word_Break=:=	_format}');
Expect(1, 917631, '\p{Is_Word_Break=format}', "");
Expect(0, 917631, '\p{^Is_Word_Break=format}', "");
Expect(0, 917631, '\P{Is_Word_Break=format}', "");
Expect(1, 917631, '\P{^Is_Word_Break=format}', "");
Expect(0, 917632, '\p{Is_Word_Break=format}', "");
Expect(1, 917632, '\p{^Is_Word_Break=format}', "");
Expect(1, 917632, '\P{Is_Word_Break=format}', "");
Expect(0, 917632, '\P{^Is_Word_Break=format}', "");
Expect(1, 917631, '\p{Is_Word_Break= Format}', "");
Expect(0, 917631, '\p{^Is_Word_Break= Format}', "");
Expect(0, 917631, '\P{Is_Word_Break= Format}', "");
Expect(1, 917631, '\P{^Is_Word_Break= Format}', "");
Expect(0, 917632, '\p{Is_Word_Break= Format}', "");
Expect(1, 917632, '\p{^Is_Word_Break= Format}', "");
Expect(1, 917632, '\P{Is_Word_Break= Format}', "");
Expect(0, 917632, '\P{^Is_Word_Break= Format}', "");
Error('\p{Is_WB=_/a/FO}');
Error('\P{Is_WB=_/a/FO}');
Expect(1, 917631, '\p{Is_WB: fo}', "");
Expect(0, 917631, '\p{^Is_WB: fo}', "");
Expect(0, 917631, '\P{Is_WB: fo}', "");
Expect(1, 917631, '\P{^Is_WB: fo}', "");
Expect(0, 917632, '\p{Is_WB: fo}', "");
Expect(1, 917632, '\p{^Is_WB: fo}', "");
Expect(1, 917632, '\P{Is_WB: fo}', "");
Expect(0, 917632, '\P{^Is_WB: fo}', "");
Expect(1, 917631, '\p{Is_WB=	 FO}', "");
Expect(0, 917631, '\p{^Is_WB=	 FO}', "");
Expect(0, 917631, '\P{Is_WB=	 FO}', "");
Expect(1, 917631, '\P{^Is_WB=	 FO}', "");
Expect(0, 917632, '\p{Is_WB=	 FO}', "");
Expect(1, 917632, '\p{^Is_WB=	 FO}', "");
Expect(1, 917632, '\P{Is_WB=	 FO}', "");
Expect(0, 917632, '\P{^Is_WB=	 FO}', "");
Error('\p{Word_Break=-:=hebrew_Letter}');
Error('\P{Word_Break=-:=hebrew_Letter}');
Expect(1, 64335, '\p{Word_Break:	hebrewletter}', "");
Expect(0, 64335, '\p{^Word_Break:	hebrewletter}', "");
Expect(0, 64335, '\P{Word_Break:	hebrewletter}', "");
Expect(1, 64335, '\P{^Word_Break:	hebrewletter}', "");
Expect(0, 64336, '\p{Word_Break:	hebrewletter}', "");
Expect(1, 64336, '\p{^Word_Break:	hebrewletter}', "");
Expect(1, 64336, '\P{Word_Break:	hebrewletter}', "");
Expect(0, 64336, '\P{^Word_Break:	hebrewletter}', "");
Expect(1, 64335, '\p{Word_Break=Hebrew_LETTER}', "");
Expect(0, 64335, '\p{^Word_Break=Hebrew_LETTER}', "");
Expect(0, 64335, '\P{Word_Break=Hebrew_LETTER}', "");
Expect(1, 64335, '\P{^Word_Break=Hebrew_LETTER}', "");
Expect(0, 64336, '\p{Word_Break=Hebrew_LETTER}', "");
Expect(1, 64336, '\p{^Word_Break=Hebrew_LETTER}', "");
Expect(1, 64336, '\P{Word_Break=Hebrew_LETTER}', "");
Expect(0, 64336, '\P{^Word_Break=Hebrew_LETTER}', "");
Error('\p{WB=/a/ -HL}');
Error('\P{WB=/a/ -HL}');
Expect(1, 64335, '\p{WB:   hl}', "");
Expect(0, 64335, '\p{^WB:   hl}', "");
Expect(0, 64335, '\P{WB:   hl}', "");
Expect(1, 64335, '\P{^WB:   hl}', "");
Expect(0, 64336, '\p{WB:   hl}', "");
Expect(1, 64336, '\p{^WB:   hl}', "");
Expect(1, 64336, '\P{WB:   hl}', "");
Expect(0, 64336, '\P{^WB:   hl}', "");
Expect(1, 64335, '\p{WB=_	hl}', "");
Expect(0, 64335, '\p{^WB=_	hl}', "");
Expect(0, 64335, '\P{WB=_	hl}', "");
Expect(1, 64335, '\P{^WB=_	hl}', "");
Expect(0, 64336, '\p{WB=_	hl}', "");
Expect(1, 64336, '\p{^WB=_	hl}', "");
Expect(1, 64336, '\P{WB=_	hl}', "");
Expect(0, 64336, '\P{^WB=_	hl}', "");
Error('\p{Is_Word_Break=	/a/Hebrew_LETTER}');
Error('\P{Is_Word_Break=	/a/Hebrew_LETTER}');
Expect(1, 64335, '\p{Is_Word_Break=hebrewletter}', "");
Expect(0, 64335, '\p{^Is_Word_Break=hebrewletter}', "");
Expect(0, 64335, '\P{Is_Word_Break=hebrewletter}', "");
Expect(1, 64335, '\P{^Is_Word_Break=hebrewletter}', "");
Expect(0, 64336, '\p{Is_Word_Break=hebrewletter}', "");
Expect(1, 64336, '\p{^Is_Word_Break=hebrewletter}', "");
Expect(1, 64336, '\P{Is_Word_Break=hebrewletter}', "");
Expect(0, 64336, '\P{^Is_Word_Break=hebrewletter}', "");
Expect(1, 64335, '\p{Is_Word_Break=--HEBREW_letter}', "");
Expect(0, 64335, '\p{^Is_Word_Break=--HEBREW_letter}', "");
Expect(0, 64335, '\P{Is_Word_Break=--HEBREW_letter}', "");
Expect(1, 64335, '\P{^Is_Word_Break=--HEBREW_letter}', "");
Expect(0, 64336, '\p{Is_Word_Break=--HEBREW_letter}', "");
Expect(1, 64336, '\p{^Is_Word_Break=--HEBREW_letter}', "");
Expect(1, 64336, '\P{Is_Word_Break=--HEBREW_letter}', "");
Expect(0, 64336, '\P{^Is_Word_Break=--HEBREW_letter}', "");
Error('\p{Is_WB=:=  hl}');
Error('\P{Is_WB=:=  hl}');
Expect(1, 64335, '\p{Is_WB=hl}', "");
Expect(0, 64335, '\p{^Is_WB=hl}', "");
Expect(0, 64335, '\P{Is_WB=hl}', "");
Expect(1, 64335, '\P{^Is_WB=hl}', "");
Expect(0, 64336, '\p{Is_WB=hl}', "");
Expect(1, 64336, '\p{^Is_WB=hl}', "");
Expect(1, 64336, '\P{Is_WB=hl}', "");
Expect(0, 64336, '\P{^Is_WB=hl}', "");
Expect(1, 64335, '\p{Is_WB=-_hl}', "");
Expect(0, 64335, '\p{^Is_WB=-_hl}', "");
Expect(0, 64335, '\P{Is_WB=-_hl}', "");
Expect(1, 64335, '\P{^Is_WB=-_hl}', "");
Expect(0, 64336, '\p{Is_WB=-_hl}', "");
Expect(1, 64336, '\p{^Is_WB=-_hl}', "");
Expect(1, 64336, '\P{Is_WB=-_hl}', "");
Expect(0, 64336, '\P{^Is_WB=-_hl}', "");
Error('\p{Word_Break=	-Katakana/a/}');
Error('\P{Word_Break=	-Katakana/a/}');
Expect(1, 110592, '\p{Word_Break:katakana}', "");
Expect(0, 110592, '\p{^Word_Break:katakana}', "");
Expect(0, 110592, '\P{Word_Break:katakana}', "");
Expect(1, 110592, '\P{^Word_Break:katakana}', "");
Expect(0, 110593, '\p{Word_Break:katakana}', "");
Expect(1, 110593, '\p{^Word_Break:katakana}', "");
Expect(1, 110593, '\P{Word_Break:katakana}', "");
Expect(0, 110593, '\P{^Word_Break:katakana}', "");
Expect(1, 110592, '\p{Word_Break=	-KATAKANA}', "");
Expect(0, 110592, '\p{^Word_Break=	-KATAKANA}', "");
Expect(0, 110592, '\P{Word_Break=	-KATAKANA}', "");
Expect(1, 110592, '\P{^Word_Break=	-KATAKANA}', "");
Expect(0, 110593, '\p{Word_Break=	-KATAKANA}', "");
Expect(1, 110593, '\p{^Word_Break=	-KATAKANA}', "");
Expect(1, 110593, '\P{Word_Break=	-KATAKANA}', "");
Expect(0, 110593, '\P{^Word_Break=	-KATAKANA}', "");
Error('\p{WB= :=KA}');
Error('\P{WB= :=KA}');
Expect(1, 110592, '\p{WB=ka}', "");
Expect(0, 110592, '\p{^WB=ka}', "");
Expect(0, 110592, '\P{WB=ka}', "");
Expect(1, 110592, '\P{^WB=ka}', "");
Expect(0, 110593, '\p{WB=ka}', "");
Expect(1, 110593, '\p{^WB=ka}', "");
Expect(1, 110593, '\P{WB=ka}', "");
Expect(0, 110593, '\P{^WB=ka}', "");
Expect(1, 110592, '\p{WB=	 KA}', "");
Expect(0, 110592, '\p{^WB=	 KA}', "");
Expect(0, 110592, '\P{WB=	 KA}', "");
Expect(1, 110592, '\P{^WB=	 KA}', "");
Expect(0, 110593, '\p{WB=	 KA}', "");
Expect(1, 110593, '\p{^WB=	 KA}', "");
Expect(1, 110593, '\P{WB=	 KA}', "");
Expect(0, 110593, '\P{^WB=	 KA}', "");
Error('\p{Is_Word_Break=katakana:=}');
Error('\P{Is_Word_Break=katakana:=}');
Expect(1, 110592, '\p{Is_Word_Break:	katakana}', "");
Expect(0, 110592, '\p{^Is_Word_Break:	katakana}', "");
Expect(0, 110592, '\P{Is_Word_Break:	katakana}', "");
Expect(1, 110592, '\P{^Is_Word_Break:	katakana}', "");
Expect(0, 110593, '\p{Is_Word_Break:	katakana}', "");
Expect(1, 110593, '\p{^Is_Word_Break:	katakana}', "");
Expect(1, 110593, '\P{Is_Word_Break:	katakana}', "");
Expect(0, 110593, '\P{^Is_Word_Break:	katakana}', "");
Expect(1, 110592, '\p{Is_Word_Break=_Katakana}', "");
Expect(0, 110592, '\p{^Is_Word_Break=_Katakana}', "");
Expect(0, 110592, '\P{Is_Word_Break=_Katakana}', "");
Expect(1, 110592, '\P{^Is_Word_Break=_Katakana}', "");
Expect(0, 110593, '\p{Is_Word_Break=_Katakana}', "");
Expect(1, 110593, '\p{^Is_Word_Break=_Katakana}', "");
Expect(1, 110593, '\P{Is_Word_Break=_Katakana}', "");
Expect(0, 110593, '\P{^Is_Word_Break=_Katakana}', "");
Error('\p{Is_WB=- KA/a/}');
Error('\P{Is_WB=- KA/a/}');
Expect(1, 110592, '\p{Is_WB=ka}', "");
Expect(0, 110592, '\p{^Is_WB=ka}', "");
Expect(0, 110592, '\P{Is_WB=ka}', "");
Expect(1, 110592, '\P{^Is_WB=ka}', "");
Expect(0, 110593, '\p{Is_WB=ka}', "");
Expect(1, 110593, '\p{^Is_WB=ka}', "");
Expect(1, 110593, '\P{Is_WB=ka}', "");
Expect(0, 110593, '\P{^Is_WB=ka}', "");
Expect(1, 110592, '\p{Is_WB=KA}', "");
Expect(0, 110592, '\p{^Is_WB=KA}', "");
Expect(0, 110592, '\P{Is_WB=KA}', "");
Expect(1, 110592, '\P{^Is_WB=KA}', "");
Expect(0, 110593, '\p{Is_WB=KA}', "");
Expect(1, 110593, '\p{^Is_WB=KA}', "");
Expect(1, 110593, '\P{Is_WB=KA}', "");
Expect(0, 110593, '\P{^Is_WB=KA}', "");
Error('\p{Word_Break=-	ALETTER/a/}');
Error('\P{Word_Break=-	ALETTER/a/}');
Expect(1, 127369, '\p{Word_Break=aletter}', "");
Expect(0, 127369, '\p{^Word_Break=aletter}', "");
Expect(0, 127369, '\P{Word_Break=aletter}', "");
Expect(1, 127369, '\P{^Word_Break=aletter}', "");
Expect(0, 127370, '\p{Word_Break=aletter}', "");
Expect(1, 127370, '\p{^Word_Break=aletter}', "");
Expect(1, 127370, '\P{Word_Break=aletter}', "");
Expect(0, 127370, '\P{^Word_Break=aletter}', "");
Expect(1, 127369, '\p{Word_Break=_ALetter}', "");
Expect(0, 127369, '\p{^Word_Break=_ALetter}', "");
Expect(0, 127369, '\P{Word_Break=_ALetter}', "");
Expect(1, 127369, '\P{^Word_Break=_ALetter}', "");
Expect(0, 127370, '\p{Word_Break=_ALetter}', "");
Expect(1, 127370, '\p{^Word_Break=_ALetter}', "");
Expect(1, 127370, '\P{Word_Break=_ALetter}', "");
Expect(0, 127370, '\P{^Word_Break=_ALetter}', "");
Error('\p{WB=	_LE/a/}');
Error('\P{WB=	_LE/a/}');
Expect(1, 127369, '\p{WB=le}', "");
Expect(0, 127369, '\p{^WB=le}', "");
Expect(0, 127369, '\P{WB=le}', "");
Expect(1, 127369, '\P{^WB=le}', "");
Expect(0, 127370, '\p{WB=le}', "");
Expect(1, 127370, '\p{^WB=le}', "");
Expect(1, 127370, '\P{WB=le}', "");
Expect(0, 127370, '\P{^WB=le}', "");
Expect(1, 127369, '\p{WB=_	LE}', "");
Expect(0, 127369, '\p{^WB=_	LE}', "");
Expect(0, 127369, '\P{WB=_	LE}', "");
Expect(1, 127369, '\P{^WB=_	LE}', "");
Expect(0, 127370, '\p{WB=_	LE}', "");
Expect(1, 127370, '\p{^WB=_	LE}', "");
Expect(1, 127370, '\P{WB=_	LE}', "");
Expect(0, 127370, '\P{^WB=_	LE}', "");
Error('\p{Is_Word_Break=:= -ALETTER}');
Error('\P{Is_Word_Break=:= -ALETTER}');
Expect(1, 127369, '\p{Is_Word_Break=aletter}', "");
Expect(0, 127369, '\p{^Is_Word_Break=aletter}', "");
Expect(0, 127369, '\P{Is_Word_Break=aletter}', "");
Expect(1, 127369, '\P{^Is_Word_Break=aletter}', "");
Expect(0, 127370, '\p{Is_Word_Break=aletter}', "");
Expect(1, 127370, '\p{^Is_Word_Break=aletter}', "");
Expect(1, 127370, '\P{Is_Word_Break=aletter}', "");
Expect(0, 127370, '\P{^Is_Word_Break=aletter}', "");
Expect(1, 127369, '\p{Is_Word_Break= ALetter}', "");
Expect(0, 127369, '\p{^Is_Word_Break= ALetter}', "");
Expect(0, 127369, '\P{Is_Word_Break= ALetter}', "");
Expect(1, 127369, '\P{^Is_Word_Break= ALetter}', "");
Expect(0, 127370, '\p{Is_Word_Break= ALetter}', "");
Expect(1, 127370, '\p{^Is_Word_Break= ALetter}', "");
Expect(1, 127370, '\P{Is_Word_Break= ALetter}', "");
Expect(0, 127370, '\P{^Is_Word_Break= ALetter}', "");
Error('\p{Is_WB= :=LE}');
Error('\P{Is_WB= :=LE}');
Expect(1, 127369, '\p{Is_WB=le}', "");
Expect(0, 127369, '\p{^Is_WB=le}', "");
Expect(0, 127369, '\P{Is_WB=le}', "");
Expect(1, 127369, '\P{^Is_WB=le}', "");
Expect(0, 127370, '\p{Is_WB=le}', "");
Expect(1, 127370, '\p{^Is_WB=le}', "");
Expect(1, 127370, '\P{Is_WB=le}', "");
Expect(0, 127370, '\P{^Is_WB=le}', "");
Expect(1, 127369, '\p{Is_WB= _LE}', "");
Expect(0, 127369, '\p{^Is_WB= _LE}', "");
Expect(0, 127369, '\P{Is_WB= _LE}', "");
Expect(1, 127369, '\P{^Is_WB= _LE}', "");
Expect(0, 127370, '\p{Is_WB= _LE}', "");
Expect(1, 127370, '\p{^Is_WB= _LE}', "");
Expect(1, 127370, '\P{Is_WB= _LE}', "");
Expect(0, 127370, '\P{^Is_WB= _LE}', "");
Error('\p{Word_Break=/a/	_LF}');
Error('\P{Word_Break=/a/	_LF}');
Expect(1, 10, '\p{Word_Break=lf}', "");
Expect(0, 10, '\p{^Word_Break=lf}', "");
Expect(0, 10, '\P{Word_Break=lf}', "");
Expect(1, 10, '\P{^Word_Break=lf}', "");
Expect(0, 11, '\p{Word_Break=lf}', "");
Expect(1, 11, '\p{^Word_Break=lf}', "");
Expect(1, 11, '\P{Word_Break=lf}', "");
Expect(0, 11, '\P{^Word_Break=lf}', "");
Expect(1, 10, '\p{Word_Break=_	LF}', "");
Expect(0, 10, '\p{^Word_Break=_	LF}', "");
Expect(0, 10, '\P{Word_Break=_	LF}', "");
Expect(1, 10, '\P{^Word_Break=_	LF}', "");
Expect(0, 11, '\p{Word_Break=_	LF}', "");
Expect(1, 11, '\p{^Word_Break=_	LF}', "");
Expect(1, 11, '\P{Word_Break=_	LF}', "");
Expect(0, 11, '\P{^Word_Break=_	LF}', "");
Error('\p{WB=	:=LF}');
Error('\P{WB=	:=LF}');
Expect(1, 10, '\p{WB=lf}', "");
Expect(0, 10, '\p{^WB=lf}', "");
Expect(0, 10, '\P{WB=lf}', "");
Expect(1, 10, '\P{^WB=lf}', "");
Expect(0, 11, '\p{WB=lf}', "");
Expect(1, 11, '\p{^WB=lf}', "");
Expect(1, 11, '\P{WB=lf}', "");
Expect(0, 11, '\P{^WB=lf}', "");
Expect(1, 10, '\p{WB:__LF}', "");
Expect(0, 10, '\p{^WB:__LF}', "");
Expect(0, 10, '\P{WB:__LF}', "");
Expect(1, 10, '\P{^WB:__LF}', "");
Expect(0, 11, '\p{WB:__LF}', "");
Expect(1, 11, '\p{^WB:__LF}', "");
Expect(1, 11, '\P{WB:__LF}', "");
Expect(0, 11, '\P{^WB:__LF}', "");
Error('\p{Is_Word_Break=-/a/lf}');
Error('\P{Is_Word_Break=-/a/lf}');
Expect(1, 10, '\p{Is_Word_Break=lf}', "");
Expect(0, 10, '\p{^Is_Word_Break=lf}', "");
Expect(0, 10, '\P{Is_Word_Break=lf}', "");
Expect(1, 10, '\P{^Is_Word_Break=lf}', "");
Expect(0, 11, '\p{Is_Word_Break=lf}', "");
Expect(1, 11, '\p{^Is_Word_Break=lf}', "");
Expect(1, 11, '\P{Is_Word_Break=lf}', "");
Expect(0, 11, '\P{^Is_Word_Break=lf}', "");
Expect(1, 10, '\p{Is_Word_Break=-lf}', "");
Expect(0, 10, '\p{^Is_Word_Break=-lf}', "");
Expect(0, 10, '\P{Is_Word_Break=-lf}', "");
Expect(1, 10, '\P{^Is_Word_Break=-lf}', "");
Expect(0, 11, '\p{Is_Word_Break=-lf}', "");
Expect(1, 11, '\p{^Is_Word_Break=-lf}', "");
Expect(1, 11, '\P{Is_Word_Break=-lf}', "");
Expect(0, 11, '\P{^Is_Word_Break=-lf}', "");
Error('\p{Is_WB= 	lf:=}');
Error('\P{Is_WB= 	lf:=}');
Expect(1, 10, '\p{Is_WB=lf}', "");
Expect(0, 10, '\p{^Is_WB=lf}', "");
Expect(0, 10, '\P{Is_WB=lf}', "");
Expect(1, 10, '\P{^Is_WB=lf}', "");
Expect(0, 11, '\p{Is_WB=lf}', "");
Expect(1, 11, '\p{^Is_WB=lf}', "");
Expect(1, 11, '\P{Is_WB=lf}', "");
Expect(0, 11, '\P{^Is_WB=lf}', "");
Expect(1, 10, '\p{Is_WB= 	LF}', "");
Expect(0, 10, '\p{^Is_WB= 	LF}', "");
Expect(0, 10, '\P{Is_WB= 	LF}', "");
Expect(1, 10, '\P{^Is_WB= 	LF}', "");
Expect(0, 11, '\p{Is_WB= 	LF}', "");
Expect(1, 11, '\p{^Is_WB= 	LF}', "");
Expect(1, 11, '\P{Is_WB= 	LF}', "");
Expect(0, 11, '\P{^Is_WB= 	LF}', "");
Error('\p{Word_Break=/a/__MidNumLet}');
Error('\P{Word_Break=/a/__MidNumLet}');
Expect(1, 65294, '\p{Word_Break=midnumlet}', "");
Expect(0, 65294, '\p{^Word_Break=midnumlet}', "");
Expect(0, 65294, '\P{Word_Break=midnumlet}', "");
Expect(1, 65294, '\P{^Word_Break=midnumlet}', "");
Expect(0, 65295, '\p{Word_Break=midnumlet}', "");
Expect(1, 65295, '\p{^Word_Break=midnumlet}', "");
Expect(1, 65295, '\P{Word_Break=midnumlet}', "");
Expect(0, 65295, '\P{^Word_Break=midnumlet}', "");
Expect(1, 65294, '\p{Word_Break=_MidNumLet}', "");
Expect(0, 65294, '\p{^Word_Break=_MidNumLet}', "");
Expect(0, 65294, '\P{Word_Break=_MidNumLet}', "");
Expect(1, 65294, '\P{^Word_Break=_MidNumLet}', "");
Expect(0, 65295, '\p{Word_Break=_MidNumLet}', "");
Expect(1, 65295, '\p{^Word_Break=_MidNumLet}', "");
Expect(1, 65295, '\P{Word_Break=_MidNumLet}', "");
Expect(0, 65295, '\P{^Word_Break=_MidNumLet}', "");
Error('\p{WB:	  mb/a/}');
Error('\P{WB:	  mb/a/}');
Expect(1, 65294, '\p{WB=mb}', "");
Expect(0, 65294, '\p{^WB=mb}', "");
Expect(0, 65294, '\P{WB=mb}', "");
Expect(1, 65294, '\P{^WB=mb}', "");
Expect(0, 65295, '\p{WB=mb}', "");
Expect(1, 65295, '\p{^WB=mb}', "");
Expect(1, 65295, '\P{WB=mb}', "");
Expect(0, 65295, '\P{^WB=mb}', "");
Expect(1, 65294, '\p{WB=	_MB}', "");
Expect(0, 65294, '\p{^WB=	_MB}', "");
Expect(0, 65294, '\P{WB=	_MB}', "");
Expect(1, 65294, '\P{^WB=	_MB}', "");
Expect(0, 65295, '\p{WB=	_MB}', "");
Expect(1, 65295, '\p{^WB=	_MB}', "");
Expect(1, 65295, '\P{WB=	_MB}', "");
Expect(0, 65295, '\P{^WB=	_MB}', "");
Error('\p{Is_Word_Break=	-MidNumLet:=}');
Error('\P{Is_Word_Break=	-MidNumLet:=}');
Expect(1, 65294, '\p{Is_Word_Break=midnumlet}', "");
Expect(0, 65294, '\p{^Is_Word_Break=midnumlet}', "");
Expect(0, 65294, '\P{Is_Word_Break=midnumlet}', "");
Expect(1, 65294, '\P{^Is_Word_Break=midnumlet}', "");
Expect(0, 65295, '\p{Is_Word_Break=midnumlet}', "");
Expect(1, 65295, '\p{^Is_Word_Break=midnumlet}', "");
Expect(1, 65295, '\P{Is_Word_Break=midnumlet}', "");
Expect(0, 65295, '\P{^Is_Word_Break=midnumlet}', "");
Expect(1, 65294, '\p{Is_Word_Break=_	MidNumLet}', "");
Expect(0, 65294, '\p{^Is_Word_Break=_	MidNumLet}', "");
Expect(0, 65294, '\P{Is_Word_Break=_	MidNumLet}', "");
Expect(1, 65294, '\P{^Is_Word_Break=_	MidNumLet}', "");
Expect(0, 65295, '\p{Is_Word_Break=_	MidNumLet}', "");
Expect(1, 65295, '\p{^Is_Word_Break=_	MidNumLet}', "");
Expect(1, 65295, '\P{Is_Word_Break=_	MidNumLet}', "");
Expect(0, 65295, '\P{^Is_Word_Break=_	MidNumLet}', "");
Error('\p{Is_WB=	:=mb}');
Error('\P{Is_WB=	:=mb}');
Expect(1, 65294, '\p{Is_WB=mb}', "");
Expect(0, 65294, '\p{^Is_WB=mb}', "");
Expect(0, 65294, '\P{Is_WB=mb}', "");
Expect(1, 65294, '\P{^Is_WB=mb}', "");
Expect(0, 65295, '\p{Is_WB=mb}', "");
Expect(1, 65295, '\p{^Is_WB=mb}', "");
Expect(1, 65295, '\P{Is_WB=mb}', "");
Expect(0, 65295, '\P{^Is_WB=mb}', "");
Expect(1, 65294, '\p{Is_WB=__MB}', "");
Expect(0, 65294, '\p{^Is_WB=__MB}', "");
Expect(0, 65294, '\P{Is_WB=__MB}', "");
Expect(1, 65294, '\P{^Is_WB=__MB}', "");
Expect(0, 65295, '\p{Is_WB=__MB}', "");
Expect(1, 65295, '\p{^Is_WB=__MB}', "");
Expect(1, 65295, '\P{Is_WB=__MB}', "");
Expect(0, 65295, '\P{^Is_WB=__MB}', "");
Error('\p{Word_Break=_ MidLetter:=}');
Error('\P{Word_Break=_ MidLetter:=}');
Expect(1, 65306, '\p{Word_Break=midletter}', "");
Expect(0, 65306, '\p{^Word_Break=midletter}', "");
Expect(0, 65306, '\P{Word_Break=midletter}', "");
Expect(1, 65306, '\P{^Word_Break=midletter}', "");
Expect(0, 65307, '\p{Word_Break=midletter}', "");
Expect(1, 65307, '\p{^Word_Break=midletter}', "");
Expect(1, 65307, '\P{Word_Break=midletter}', "");
Expect(0, 65307, '\P{^Word_Break=midletter}', "");
Expect(1, 65306, '\p{Word_Break=	_MIDLETTER}', "");
Expect(0, 65306, '\p{^Word_Break=	_MIDLETTER}', "");
Expect(0, 65306, '\P{Word_Break=	_MIDLETTER}', "");
Expect(1, 65306, '\P{^Word_Break=	_MIDLETTER}', "");
Expect(0, 65307, '\p{Word_Break=	_MIDLETTER}', "");
Expect(1, 65307, '\p{^Word_Break=	_MIDLETTER}', "");
Expect(1, 65307, '\P{Word_Break=	_MIDLETTER}', "");
Expect(0, 65307, '\P{^Word_Break=	_MIDLETTER}', "");
Error('\p{WB=-_ML:=}');
Error('\P{WB=-_ML:=}');
Expect(1, 65306, '\p{WB:ml}', "");
Expect(0, 65306, '\p{^WB:ml}', "");
Expect(0, 65306, '\P{WB:ml}', "");
Expect(1, 65306, '\P{^WB:ml}', "");
Expect(0, 65307, '\p{WB:ml}', "");
Expect(1, 65307, '\p{^WB:ml}', "");
Expect(1, 65307, '\P{WB:ml}', "");
Expect(0, 65307, '\P{^WB:ml}', "");
Expect(1, 65306, '\p{WB=  ML}', "");
Expect(0, 65306, '\p{^WB=  ML}', "");
Expect(0, 65306, '\P{WB=  ML}', "");
Expect(1, 65306, '\P{^WB=  ML}', "");
Expect(0, 65307, '\p{WB=  ML}', "");
Expect(1, 65307, '\p{^WB=  ML}', "");
Expect(1, 65307, '\P{WB=  ML}', "");
Expect(0, 65307, '\P{^WB=  ML}', "");
Error('\p{Is_Word_Break=:=		MidLetter}');
Error('\P{Is_Word_Break=:=		MidLetter}');
Expect(1, 65306, '\p{Is_Word_Break=midletter}', "");
Expect(0, 65306, '\p{^Is_Word_Break=midletter}', "");
Expect(0, 65306, '\P{Is_Word_Break=midletter}', "");
Expect(1, 65306, '\P{^Is_Word_Break=midletter}', "");
Expect(0, 65307, '\p{Is_Word_Break=midletter}', "");
Expect(1, 65307, '\p{^Is_Word_Break=midletter}', "");
Expect(1, 65307, '\P{Is_Word_Break=midletter}', "");
Expect(0, 65307, '\P{^Is_Word_Break=midletter}', "");
Error('\p{Is_WB= ML:=}');
Error('\P{Is_WB= ML:=}');
Expect(1, 65306, '\p{Is_WB: ml}', "");
Expect(0, 65306, '\p{^Is_WB: ml}', "");
Expect(0, 65306, '\P{Is_WB: ml}', "");
Expect(1, 65306, '\P{^Is_WB: ml}', "");
Expect(0, 65307, '\p{Is_WB: ml}', "");
Expect(1, 65307, '\p{^Is_WB: ml}', "");
Expect(1, 65307, '\P{Is_WB: ml}', "");
Expect(0, 65307, '\P{^Is_WB: ml}', "");
Expect(1, 65306, '\p{Is_WB:	ML}', "");
Expect(0, 65306, '\p{^Is_WB:	ML}', "");
Expect(0, 65306, '\P{Is_WB:	ML}', "");
Expect(1, 65306, '\P{^Is_WB:	ML}', "");
Expect(0, 65307, '\p{Is_WB:	ML}', "");
Expect(1, 65307, '\p{^Is_WB:	ML}', "");
Expect(1, 65307, '\P{Is_WB:	ML}', "");
Expect(0, 65307, '\P{^Is_WB:	ML}', "");
Error('\p{Word_Break=--MidNum:=}');
Error('\P{Word_Break=--MidNum:=}');
Expect(1, 65307, '\p{Word_Break=midnum}', "");
Expect(0, 65307, '\p{^Word_Break=midnum}', "");
Expect(0, 65307, '\P{Word_Break=midnum}', "");
Expect(1, 65307, '\P{^Word_Break=midnum}', "");
Expect(0, 65308, '\p{Word_Break=midnum}', "");
Expect(1, 65308, '\p{^Word_Break=midnum}', "");
Expect(1, 65308, '\P{Word_Break=midnum}', "");
Expect(0, 65308, '\P{^Word_Break=midnum}', "");
Expect(1, 65307, '\p{Word_Break=-	MIDNUM}', "");
Expect(0, 65307, '\p{^Word_Break=-	MIDNUM}', "");
Expect(0, 65307, '\P{Word_Break=-	MIDNUM}', "");
Expect(1, 65307, '\P{^Word_Break=-	MIDNUM}', "");
Expect(0, 65308, '\p{Word_Break=-	MIDNUM}', "");
Expect(1, 65308, '\p{^Word_Break=-	MIDNUM}', "");
Expect(1, 65308, '\P{Word_Break=-	MIDNUM}', "");
Expect(0, 65308, '\P{^Word_Break=-	MIDNUM}', "");
Error('\p{WB=:=MN}');
Error('\P{WB=:=MN}');
Expect(1, 65307, '\p{WB=mn}', "");
Expect(0, 65307, '\p{^WB=mn}', "");
Expect(0, 65307, '\P{WB=mn}', "");
Expect(1, 65307, '\P{^WB=mn}', "");
Expect(0, 65308, '\p{WB=mn}', "");
Expect(1, 65308, '\p{^WB=mn}', "");
Expect(1, 65308, '\P{WB=mn}', "");
Expect(0, 65308, '\P{^WB=mn}', "");
Expect(1, 65307, '\p{WB=_ mn}', "");
Expect(0, 65307, '\p{^WB=_ mn}', "");
Expect(0, 65307, '\P{WB=_ mn}', "");
Expect(1, 65307, '\P{^WB=_ mn}', "");
Expect(0, 65308, '\p{WB=_ mn}', "");
Expect(1, 65308, '\p{^WB=_ mn}', "");
Expect(1, 65308, '\P{WB=_ mn}', "");
Expect(0, 65308, '\P{^WB=_ mn}', "");
Error('\p{Is_Word_Break=	_MIDNUM/a/}');
Error('\P{Is_Word_Break=	_MIDNUM/a/}');
Expect(1, 65307, '\p{Is_Word_Break=midnum}', "");
Expect(0, 65307, '\p{^Is_Word_Break=midnum}', "");
Expect(0, 65307, '\P{Is_Word_Break=midnum}', "");
Expect(1, 65307, '\P{^Is_Word_Break=midnum}', "");
Expect(0, 65308, '\p{Is_Word_Break=midnum}', "");
Expect(1, 65308, '\p{^Is_Word_Break=midnum}', "");
Expect(1, 65308, '\P{Is_Word_Break=midnum}', "");
Expect(0, 65308, '\P{^Is_Word_Break=midnum}', "");
Expect(1, 65307, '\p{Is_Word_Break=-midnum}', "");
Expect(0, 65307, '\p{^Is_Word_Break=-midnum}', "");
Expect(0, 65307, '\P{Is_Word_Break=-midnum}', "");
Expect(1, 65307, '\P{^Is_Word_Break=-midnum}', "");
Expect(0, 65308, '\p{Is_Word_Break=-midnum}', "");
Expect(1, 65308, '\p{^Is_Word_Break=-midnum}', "");
Expect(1, 65308, '\P{Is_Word_Break=-midnum}', "");
Expect(0, 65308, '\P{^Is_Word_Break=-midnum}', "");
Error('\p{Is_WB:   := MN}');
Error('\P{Is_WB:   := MN}');
Expect(1, 65307, '\p{Is_WB=mn}', "");
Expect(0, 65307, '\p{^Is_WB=mn}', "");
Expect(0, 65307, '\P{Is_WB=mn}', "");
Expect(1, 65307, '\P{^Is_WB=mn}', "");
Expect(0, 65308, '\p{Is_WB=mn}', "");
Expect(1, 65308, '\p{^Is_WB=mn}', "");
Expect(1, 65308, '\P{Is_WB=mn}', "");
Expect(0, 65308, '\P{^Is_WB=mn}', "");
Expect(1, 65307, '\p{Is_WB: MN}', "");
Expect(0, 65307, '\p{^Is_WB: MN}', "");
Expect(0, 65307, '\P{Is_WB: MN}', "");
Expect(1, 65307, '\P{^Is_WB: MN}', "");
Expect(0, 65308, '\p{Is_WB: MN}', "");
Expect(1, 65308, '\p{^Is_WB: MN}', "");
Expect(1, 65308, '\P{Is_WB: MN}', "");
Expect(0, 65308, '\P{^Is_WB: MN}', "");
Error('\p{Word_Break:   /a/ Newline}');
Error('\P{Word_Break:   /a/ Newline}');
Expect(1, 8233, '\p{Word_Break=newline}', "");
Expect(0, 8233, '\p{^Word_Break=newline}', "");
Expect(0, 8233, '\P{Word_Break=newline}', "");
Expect(1, 8233, '\P{^Word_Break=newline}', "");
Expect(0, 8234, '\p{Word_Break=newline}', "");
Expect(1, 8234, '\p{^Word_Break=newline}', "");
Expect(1, 8234, '\P{Word_Break=newline}', "");
Expect(0, 8234, '\P{^Word_Break=newline}', "");
Expect(1, 8233, '\p{Word_Break=_-NEWLINE}', "");
Expect(0, 8233, '\p{^Word_Break=_-NEWLINE}', "");
Expect(0, 8233, '\P{Word_Break=_-NEWLINE}', "");
Expect(1, 8233, '\P{^Word_Break=_-NEWLINE}', "");
Expect(0, 8234, '\p{Word_Break=_-NEWLINE}', "");
Expect(1, 8234, '\p{^Word_Break=_-NEWLINE}', "");
Expect(1, 8234, '\P{Word_Break=_-NEWLINE}', "");
Expect(0, 8234, '\P{^Word_Break=_-NEWLINE}', "");
Error('\p{WB=	NL:=}');
Error('\P{WB=	NL:=}');
Expect(1, 8233, '\p{WB=nl}', "");
Expect(0, 8233, '\p{^WB=nl}', "");
Expect(0, 8233, '\P{WB=nl}', "");
Expect(1, 8233, '\P{^WB=nl}', "");
Expect(0, 8234, '\p{WB=nl}', "");
Expect(1, 8234, '\p{^WB=nl}', "");
Expect(1, 8234, '\P{WB=nl}', "");
Expect(0, 8234, '\P{^WB=nl}', "");
Expect(1, 8233, '\p{WB=	NL}', "");
Expect(0, 8233, '\p{^WB=	NL}', "");
Expect(0, 8233, '\P{WB=	NL}', "");
Expect(1, 8233, '\P{^WB=	NL}', "");
Expect(0, 8234, '\p{WB=	NL}', "");
Expect(1, 8234, '\p{^WB=	NL}', "");
Expect(1, 8234, '\P{WB=	NL}', "");
Expect(0, 8234, '\P{^WB=	NL}', "");
Error('\p{Is_Word_Break=:= _newline}');
Error('\P{Is_Word_Break=:= _newline}');
Expect(1, 8233, '\p{Is_Word_Break:   newline}', "");
Expect(0, 8233, '\p{^Is_Word_Break:   newline}', "");
Expect(0, 8233, '\P{Is_Word_Break:   newline}', "");
Expect(1, 8233, '\P{^Is_Word_Break:   newline}', "");
Expect(0, 8234, '\p{Is_Word_Break:   newline}', "");
Expect(1, 8234, '\p{^Is_Word_Break:   newline}', "");
Expect(1, 8234, '\P{Is_Word_Break:   newline}', "");
Expect(0, 8234, '\P{^Is_Word_Break:   newline}', "");
Expect(1, 8233, '\p{Is_Word_Break=Newline}', "");
Expect(0, 8233, '\p{^Is_Word_Break=Newline}', "");
Expect(0, 8233, '\P{Is_Word_Break=Newline}', "");
Expect(1, 8233, '\P{^Is_Word_Break=Newline}', "");
Expect(0, 8234, '\p{Is_Word_Break=Newline}', "");
Expect(1, 8234, '\p{^Is_Word_Break=Newline}', "");
Expect(1, 8234, '\P{Is_Word_Break=Newline}', "");
Expect(0, 8234, '\P{^Is_Word_Break=Newline}', "");
Error('\p{Is_WB=		NL/a/}');
Error('\P{Is_WB=		NL/a/}');
Expect(1, 8233, '\p{Is_WB=nl}', "");
Expect(0, 8233, '\p{^Is_WB=nl}', "");
Expect(0, 8233, '\P{Is_WB=nl}', "");
Expect(1, 8233, '\P{^Is_WB=nl}', "");
Expect(0, 8234, '\p{Is_WB=nl}', "");
Expect(1, 8234, '\p{^Is_WB=nl}', "");
Expect(1, 8234, '\P{Is_WB=nl}', "");
Expect(0, 8234, '\P{^Is_WB=nl}', "");
Expect(1, 8233, '\p{Is_WB=	-NL}', "");
Expect(0, 8233, '\p{^Is_WB=	-NL}', "");
Expect(0, 8233, '\P{Is_WB=	-NL}', "");
Expect(1, 8233, '\P{^Is_WB=	-NL}', "");
Expect(0, 8234, '\p{Is_WB=	-NL}', "");
Expect(1, 8234, '\p{^Is_WB=	-NL}', "");
Expect(1, 8234, '\P{Is_WB=	-NL}', "");
Expect(0, 8234, '\P{^Is_WB=	-NL}', "");
Error('\p{Word_Break=-NUMERIC/a/}');
Error('\P{Word_Break=-NUMERIC/a/}');
Expect(1, 120831, '\p{Word_Break=numeric}', "");
Expect(0, 120831, '\p{^Word_Break=numeric}', "");
Expect(0, 120831, '\P{Word_Break=numeric}', "");
Expect(1, 120831, '\P{^Word_Break=numeric}', "");
Expect(0, 120832, '\p{Word_Break=numeric}', "");
Expect(1, 120832, '\p{^Word_Break=numeric}', "");
Expect(1, 120832, '\P{Word_Break=numeric}', "");
Expect(0, 120832, '\P{^Word_Break=numeric}', "");
Expect(1, 120831, '\p{Word_Break=	numeric}', "");
Expect(0, 120831, '\p{^Word_Break=	numeric}', "");
Expect(0, 120831, '\P{Word_Break=	numeric}', "");
Expect(1, 120831, '\P{^Word_Break=	numeric}', "");
Expect(0, 120832, '\p{Word_Break=	numeric}', "");
Expect(1, 120832, '\p{^Word_Break=	numeric}', "");
Expect(1, 120832, '\P{Word_Break=	numeric}', "");
Expect(0, 120832, '\P{^Word_Break=	numeric}', "");
Error('\p{WB: _:=NU}');
Error('\P{WB: _:=NU}');
Expect(1, 120831, '\p{WB=nu}', "");
Expect(0, 120831, '\p{^WB=nu}', "");
Expect(0, 120831, '\P{WB=nu}', "");
Expect(1, 120831, '\P{^WB=nu}', "");
Expect(0, 120832, '\p{WB=nu}', "");
Expect(1, 120832, '\p{^WB=nu}', "");
Expect(1, 120832, '\P{WB=nu}', "");
Expect(0, 120832, '\P{^WB=nu}', "");
Expect(1, 120831, '\p{WB= NU}', "");
Expect(0, 120831, '\p{^WB= NU}', "");
Expect(0, 120831, '\P{WB= NU}', "");
Expect(1, 120831, '\P{^WB= NU}', "");
Expect(0, 120832, '\p{WB= NU}', "");
Expect(1, 120832, '\p{^WB= NU}', "");
Expect(1, 120832, '\P{WB= NU}', "");
Expect(0, 120832, '\P{^WB= NU}', "");
Error('\p{Is_Word_Break:   _/a/Numeric}');
Error('\P{Is_Word_Break:   _/a/Numeric}');
Expect(1, 120831, '\p{Is_Word_Break=numeric}', "");
Expect(0, 120831, '\p{^Is_Word_Break=numeric}', "");
Expect(0, 120831, '\P{Is_Word_Break=numeric}', "");
Expect(1, 120831, '\P{^Is_Word_Break=numeric}', "");
Expect(0, 120832, '\p{Is_Word_Break=numeric}', "");
Expect(1, 120832, '\p{^Is_Word_Break=numeric}', "");
Expect(1, 120832, '\P{Is_Word_Break=numeric}', "");
Expect(0, 120832, '\P{^Is_Word_Break=numeric}', "");
Expect(1, 120831, '\p{Is_Word_Break=-NUMERIC}', "");
Expect(0, 120831, '\p{^Is_Word_Break=-NUMERIC}', "");
Expect(0, 120831, '\P{Is_Word_Break=-NUMERIC}', "");
Expect(1, 120831, '\P{^Is_Word_Break=-NUMERIC}', "");
Expect(0, 120832, '\p{Is_Word_Break=-NUMERIC}', "");
Expect(1, 120832, '\p{^Is_Word_Break=-NUMERIC}', "");
Expect(1, 120832, '\P{Is_Word_Break=-NUMERIC}', "");
Expect(0, 120832, '\P{^Is_Word_Break=-NUMERIC}', "");
Error('\p{Is_WB=/a/--NU}');
Error('\P{Is_WB=/a/--NU}');
Expect(1, 120831, '\p{Is_WB=nu}', "");
Expect(0, 120831, '\p{^Is_WB=nu}', "");
Expect(0, 120831, '\P{Is_WB=nu}', "");
Expect(1, 120831, '\P{^Is_WB=nu}', "");
Expect(0, 120832, '\p{Is_WB=nu}', "");
Expect(1, 120832, '\p{^Is_WB=nu}', "");
Expect(1, 120832, '\P{Is_WB=nu}', "");
Expect(0, 120832, '\P{^Is_WB=nu}', "");
Expect(1, 120831, '\p{Is_WB=-	NU}', "");
Expect(0, 120831, '\p{^Is_WB=-	NU}', "");
Expect(0, 120831, '\P{Is_WB=-	NU}', "");
Expect(1, 120831, '\P{^Is_WB=-	NU}', "");
Expect(0, 120832, '\p{Is_WB=-	NU}', "");
Expect(1, 120832, '\p{^Is_WB=-	NU}', "");
Expect(1, 120832, '\P{Is_WB=-	NU}', "");
Expect(0, 120832, '\P{^Is_WB=-	NU}', "");
Error('\p{Word_Break= Regional_indicator/a/}');
Error('\P{Word_Break= Regional_indicator/a/}');
Expect(1, 127487, '\p{Word_Break=regionalindicator}', "");
Expect(0, 127487, '\p{^Word_Break=regionalindicator}', "");
Expect(0, 127487, '\P{Word_Break=regionalindicator}', "");
Expect(1, 127487, '\P{^Word_Break=regionalindicator}', "");
Expect(0, 127488, '\p{Word_Break=regionalindicator}', "");
Expect(1, 127488, '\p{^Word_Break=regionalindicator}', "");
Expect(1, 127488, '\P{Word_Break=regionalindicator}', "");
Expect(0, 127488, '\P{^Word_Break=regionalindicator}', "");
Expect(1, 127487, '\p{Word_Break= -Regional_Indicator}', "");
Expect(0, 127487, '\p{^Word_Break= -Regional_Indicator}', "");
Expect(0, 127487, '\P{Word_Break= -Regional_Indicator}', "");
Expect(1, 127487, '\P{^Word_Break= -Regional_Indicator}', "");
Expect(0, 127488, '\p{Word_Break= -Regional_Indicator}', "");
Expect(1, 127488, '\p{^Word_Break= -Regional_Indicator}', "");
Expect(1, 127488, '\P{Word_Break= -Regional_Indicator}', "");
Expect(0, 127488, '\P{^Word_Break= -Regional_Indicator}', "");
Error('\p{WB:			ri/a/}');
Error('\P{WB:			ri/a/}');
Expect(1, 127487, '\p{WB=ri}', "");
Expect(0, 127487, '\p{^WB=ri}', "");
Expect(0, 127487, '\P{WB=ri}', "");
Expect(1, 127487, '\P{^WB=ri}', "");
Expect(0, 127488, '\p{WB=ri}', "");
Expect(1, 127488, '\p{^WB=ri}', "");
Expect(1, 127488, '\P{WB=ri}', "");
Expect(0, 127488, '\P{^WB=ri}', "");
Expect(1, 127487, '\p{WB= -RI}', "");
Expect(0, 127487, '\p{^WB= -RI}', "");
Expect(0, 127487, '\P{WB= -RI}', "");
Expect(1, 127487, '\P{^WB= -RI}', "");
Expect(0, 127488, '\p{WB= -RI}', "");
Expect(1, 127488, '\p{^WB= -RI}', "");
Expect(1, 127488, '\P{WB= -RI}', "");
Expect(0, 127488, '\P{^WB= -RI}', "");
Error('\p{Is_Word_Break=/a/REGIONAL_Indicator}');
Error('\P{Is_Word_Break=/a/REGIONAL_Indicator}');
Expect(1, 127487, '\p{Is_Word_Break=regionalindicator}', "");
Expect(0, 127487, '\p{^Is_Word_Break=regionalindicator}', "");
Expect(0, 127487, '\P{Is_Word_Break=regionalindicator}', "");
Expect(1, 127487, '\P{^Is_Word_Break=regionalindicator}', "");
Expect(0, 127488, '\p{Is_Word_Break=regionalindicator}', "");
Expect(1, 127488, '\p{^Is_Word_Break=regionalindicator}', "");
Expect(1, 127488, '\P{Is_Word_Break=regionalindicator}', "");
Expect(0, 127488, '\P{^Is_Word_Break=regionalindicator}', "");
Expect(1, 127487, '\p{Is_Word_Break=	REGIONAL_Indicator}', "");
Expect(0, 127487, '\p{^Is_Word_Break=	REGIONAL_Indicator}', "");
Expect(0, 127487, '\P{Is_Word_Break=	REGIONAL_Indicator}', "");
Expect(1, 127487, '\P{^Is_Word_Break=	REGIONAL_Indicator}', "");
Expect(0, 127488, '\p{Is_Word_Break=	REGIONAL_Indicator}', "");
Expect(1, 127488, '\p{^Is_Word_Break=	REGIONAL_Indicator}', "");
Expect(1, 127488, '\P{Is_Word_Break=	REGIONAL_Indicator}', "");
Expect(0, 127488, '\P{^Is_Word_Break=	REGIONAL_Indicator}', "");
Error('\p{Is_WB=-/a/RI}');
Error('\P{Is_WB=-/a/RI}');
Expect(1, 127487, '\p{Is_WB=ri}', "");
Expect(0, 127487, '\p{^Is_WB=ri}', "");
Expect(0, 127487, '\P{Is_WB=ri}', "");
Expect(1, 127487, '\P{^Is_WB=ri}', "");
Expect(0, 127488, '\p{Is_WB=ri}', "");
Expect(1, 127488, '\p{^Is_WB=ri}', "");
Expect(1, 127488, '\P{Is_WB=ri}', "");
Expect(0, 127488, '\P{^Is_WB=ri}', "");
Expect(1, 127487, '\p{Is_WB=_-RI}', "");
Expect(0, 127487, '\p{^Is_WB=_-RI}', "");
Expect(0, 127487, '\P{Is_WB=_-RI}', "");
Expect(1, 127487, '\P{^Is_WB=_-RI}', "");
Expect(0, 127488, '\p{Is_WB=_-RI}', "");
Expect(1, 127488, '\p{^Is_WB=_-RI}', "");
Expect(1, 127488, '\P{Is_WB=_-RI}', "");
Expect(0, 127488, '\P{^Is_WB=_-RI}', "");
Error('\p{Word_Break=	 Single_Quote/a/}');
Error('\P{Word_Break=	 Single_Quote/a/}');
Expect(1, 39, '\p{Word_Break=singlequote}', "");
Expect(0, 39, '\p{^Word_Break=singlequote}', "");
Expect(0, 39, '\P{Word_Break=singlequote}', "");
Expect(1, 39, '\P{^Word_Break=singlequote}', "");
Expect(0, 40, '\p{Word_Break=singlequote}', "");
Expect(1, 40, '\p{^Word_Break=singlequote}', "");
Expect(1, 40, '\P{Word_Break=singlequote}', "");
Expect(0, 40, '\P{^Word_Break=singlequote}', "");
Expect(1, 39, '\p{Word_Break=-	single_Quote}', "");
Expect(0, 39, '\p{^Word_Break=-	single_Quote}', "");
Expect(0, 39, '\P{Word_Break=-	single_Quote}', "");
Expect(1, 39, '\P{^Word_Break=-	single_Quote}', "");
Expect(0, 40, '\p{Word_Break=-	single_Quote}', "");
Expect(1, 40, '\p{^Word_Break=-	single_Quote}', "");
Expect(1, 40, '\P{Word_Break=-	single_Quote}', "");
Expect(0, 40, '\P{^Word_Break=-	single_Quote}', "");
Error('\p{WB= _sq/a/}');
Error('\P{WB= _sq/a/}');
Expect(1, 39, '\p{WB: sq}', "");
Expect(0, 39, '\p{^WB: sq}', "");
Expect(0, 39, '\P{WB: sq}', "");
Expect(1, 39, '\P{^WB: sq}', "");
Expect(0, 40, '\p{WB: sq}', "");
Expect(1, 40, '\p{^WB: sq}', "");
Expect(1, 40, '\P{WB: sq}', "");
Expect(0, 40, '\P{^WB: sq}', "");
Expect(1, 39, '\p{WB=	_SQ}', "");
Expect(0, 39, '\p{^WB=	_SQ}', "");
Expect(0, 39, '\P{WB=	_SQ}', "");
Expect(1, 39, '\P{^WB=	_SQ}', "");
Expect(0, 40, '\p{WB=	_SQ}', "");
Expect(1, 40, '\p{^WB=	_SQ}', "");
Expect(1, 40, '\P{WB=	_SQ}', "");
Expect(0, 40, '\P{^WB=	_SQ}', "");
Error('\p{Is_Word_Break=/a/ _SINGLE_Quote}');
Error('\P{Is_Word_Break=/a/ _SINGLE_Quote}');
Expect(1, 39, '\p{Is_Word_Break=singlequote}', "");
Expect(0, 39, '\p{^Is_Word_Break=singlequote}', "");
Expect(0, 39, '\P{Is_Word_Break=singlequote}', "");
Expect(1, 39, '\P{^Is_Word_Break=singlequote}', "");
Expect(0, 40, '\p{Is_Word_Break=singlequote}', "");
Expect(1, 40, '\p{^Is_Word_Break=singlequote}', "");
Expect(1, 40, '\P{Is_Word_Break=singlequote}', "");
Expect(0, 40, '\P{^Is_Word_Break=singlequote}', "");
Expect(1, 39, '\p{Is_Word_Break=	 Single_quote}', "");
Expect(0, 39, '\p{^Is_Word_Break=	 Single_quote}', "");
Expect(0, 39, '\P{Is_Word_Break=	 Single_quote}', "");
Expect(1, 39, '\P{^Is_Word_Break=	 Single_quote}', "");
Expect(0, 40, '\p{Is_Word_Break=	 Single_quote}', "");
Expect(1, 40, '\p{^Is_Word_Break=	 Single_quote}', "");
Expect(1, 40, '\P{Is_Word_Break=	 Single_quote}', "");
Expect(0, 40, '\P{^Is_Word_Break=	 Single_quote}', "");
Error('\p{Is_WB=--SQ/a/}');
Error('\P{Is_WB=--SQ/a/}');
Expect(1, 39, '\p{Is_WB=sq}', "");
Expect(0, 39, '\p{^Is_WB=sq}', "");
Expect(0, 39, '\P{Is_WB=sq}', "");
Expect(1, 39, '\P{^Is_WB=sq}', "");
Expect(0, 40, '\p{Is_WB=sq}', "");
Expect(1, 40, '\p{^Is_WB=sq}', "");
Expect(1, 40, '\P{Is_WB=sq}', "");
Expect(0, 40, '\P{^Is_WB=sq}', "");
Expect(1, 39, '\p{Is_WB= 	SQ}', "");
Expect(0, 39, '\p{^Is_WB= 	SQ}', "");
Expect(0, 39, '\P{Is_WB= 	SQ}', "");
Expect(1, 39, '\P{^Is_WB= 	SQ}', "");
Expect(0, 40, '\p{Is_WB= 	SQ}', "");
Expect(1, 40, '\p{^Is_WB= 	SQ}', "");
Expect(1, 40, '\P{Is_WB= 	SQ}', "");
Expect(0, 40, '\P{^Is_WB= 	SQ}', "");
Error('\p{Word_Break:/a/		Other}');
Error('\P{Word_Break:/a/		Other}');
Expect(1, 918000, '\p{Word_Break=other}', "");
Expect(0, 918000, '\p{^Word_Break=other}', "");
Expect(0, 918000, '\P{Word_Break=other}', "");
Expect(1, 918000, '\P{^Word_Break=other}', "");
Expect(0, 917999, '\p{Word_Break=other}', "");
Expect(1, 917999, '\p{^Word_Break=other}', "");
Expect(1, 917999, '\P{Word_Break=other}', "");
Expect(0, 917999, '\P{^Word_Break=other}', "");
Expect(1, 918000, '\p{Word_Break=Other}', "");
Expect(0, 918000, '\p{^Word_Break=Other}', "");
Expect(0, 918000, '\P{Word_Break=Other}', "");
Expect(1, 918000, '\P{^Word_Break=Other}', "");
Expect(0, 917999, '\p{Word_Break=Other}', "");
Expect(1, 917999, '\p{^Word_Break=Other}', "");
Expect(1, 917999, '\P{Word_Break=Other}', "");
Expect(0, 917999, '\P{^Word_Break=Other}', "");
Error('\p{WB=-/a/XX}');
Error('\P{WB=-/a/XX}');
Expect(1, 918000, '\p{WB=xx}', "");
Expect(0, 918000, '\p{^WB=xx}', "");
Expect(0, 918000, '\P{WB=xx}', "");
Expect(1, 918000, '\P{^WB=xx}', "");
Expect(0, 917999, '\p{WB=xx}', "");
Expect(1, 917999, '\p{^WB=xx}', "");
Expect(1, 917999, '\P{WB=xx}', "");
Expect(0, 917999, '\P{^WB=xx}', "");
Expect(1, 918000, '\p{WB=- XX}', "");
Expect(0, 918000, '\p{^WB=- XX}', "");
Expect(0, 918000, '\P{WB=- XX}', "");
Expect(1, 918000, '\P{^WB=- XX}', "");
Expect(0, 917999, '\p{WB=- XX}', "");
Expect(1, 917999, '\p{^WB=- XX}', "");
Expect(1, 917999, '\P{WB=- XX}', "");
Expect(0, 917999, '\P{^WB=- XX}', "");
Error('\p{Is_Word_Break: 	:=OTHER}');
Error('\P{Is_Word_Break: 	:=OTHER}');
Expect(1, 918000, '\p{Is_Word_Break: other}', "");
Expect(0, 918000, '\p{^Is_Word_Break: other}', "");
Expect(0, 918000, '\P{Is_Word_Break: other}', "");
Expect(1, 918000, '\P{^Is_Word_Break: other}', "");
Expect(0, 917999, '\p{Is_Word_Break: other}', "");
Expect(1, 917999, '\p{^Is_Word_Break: other}', "");
Expect(1, 917999, '\P{Is_Word_Break: other}', "");
Expect(0, 917999, '\P{^Is_Word_Break: other}', "");
Expect(1, 918000, '\p{Is_Word_Break= 	Other}', "");
Expect(0, 918000, '\p{^Is_Word_Break= 	Other}', "");
Expect(0, 918000, '\P{Is_Word_Break= 	Other}', "");
Expect(1, 918000, '\P{^Is_Word_Break= 	Other}', "");
Expect(0, 917999, '\p{Is_Word_Break= 	Other}', "");
Expect(1, 917999, '\p{^Is_Word_Break= 	Other}', "");
Expect(1, 917999, '\P{Is_Word_Break= 	Other}', "");
Expect(0, 917999, '\P{^Is_Word_Break= 	Other}', "");
Error('\p{Is_WB=/a/xx}');
Error('\P{Is_WB=/a/xx}');
Expect(1, 918000, '\p{Is_WB=xx}', "");
Expect(0, 918000, '\p{^Is_WB=xx}', "");
Expect(0, 918000, '\P{Is_WB=xx}', "");
Expect(1, 918000, '\P{^Is_WB=xx}', "");
Expect(0, 917999, '\p{Is_WB=xx}', "");
Expect(1, 917999, '\p{^Is_WB=xx}', "");
Expect(1, 917999, '\P{Is_WB=xx}', "");
Expect(0, 917999, '\P{^Is_WB=xx}', "");
Expect(1, 918000, '\p{Is_WB=	XX}', "");
Expect(0, 918000, '\p{^Is_WB=	XX}', "");
Expect(0, 918000, '\P{Is_WB=	XX}', "");
Expect(1, 918000, '\P{^Is_WB=	XX}', "");
Expect(0, 917999, '\p{Is_WB=	XX}', "");
Expect(1, 917999, '\p{^Is_WB=	XX}', "");
Expect(1, 917999, '\P{Is_WB=	XX}', "");
Expect(0, 917999, '\P{^Is_WB=	XX}', "");
Error('\p{White_Space=:=_No}');
Error('\P{White_Space=:=_No}');
Expect(1, 12289, '\p{White_Space=no}', "");
Expect(0, 12289, '\p{^White_Space=no}', "");
Expect(0, 12289, '\P{White_Space=no}', "");
Expect(1, 12289, '\P{^White_Space=no}', "");
Expect(0, 12288, '\p{White_Space=no}', "");
Expect(1, 12288, '\p{^White_Space=no}', "");
Expect(1, 12288, '\P{White_Space=no}', "");
Expect(0, 12288, '\P{^White_Space=no}', "");
Expect(1, 12289, '\p{White_Space=_-No}', "");
Expect(0, 12289, '\p{^White_Space=_-No}', "");
Expect(0, 12289, '\P{White_Space=_-No}', "");
Expect(1, 12289, '\P{^White_Space=_-No}', "");
Expect(0, 12288, '\p{White_Space=_-No}', "");
Expect(1, 12288, '\p{^White_Space=_-No}', "");
Expect(1, 12288, '\P{White_Space=_-No}', "");
Expect(0, 12288, '\P{^White_Space=_-No}', "");
Error('\p{WSpace=/a/_N}');
Error('\P{WSpace=/a/_N}');
Expect(1, 12289, '\p{WSpace=n}', "");
Expect(0, 12289, '\p{^WSpace=n}', "");
Expect(0, 12289, '\P{WSpace=n}', "");
Expect(1, 12289, '\P{^WSpace=n}', "");
Expect(0, 12288, '\p{WSpace=n}', "");
Expect(1, 12288, '\p{^WSpace=n}', "");
Expect(1, 12288, '\P{WSpace=n}', "");
Expect(0, 12288, '\P{^WSpace=n}', "");
Expect(1, 12289, '\p{WSpace:	 N}', "");
Expect(0, 12289, '\p{^WSpace:	 N}', "");
Expect(0, 12289, '\P{WSpace:	 N}', "");
Expect(1, 12289, '\P{^WSpace:	 N}', "");
Expect(0, 12288, '\p{WSpace:	 N}', "");
Expect(1, 12288, '\p{^WSpace:	 N}', "");
Expect(1, 12288, '\P{WSpace:	 N}', "");
Expect(0, 12288, '\P{^WSpace:	 N}', "");
Error('\p{Space=:=--f}');
Error('\P{Space=:=--f}');
Expect(1, 12289, '\p{Space=f}', "");
Expect(0, 12289, '\p{^Space=f}', "");
Expect(0, 12289, '\P{Space=f}', "");
Expect(1, 12289, '\P{^Space=f}', "");
Expect(0, 12288, '\p{Space=f}', "");
Expect(1, 12288, '\p{^Space=f}', "");
Expect(1, 12288, '\P{Space=f}', "");
Expect(0, 12288, '\P{^Space=f}', "");
Expect(1, 12289, '\p{Space=	f}', "");
Expect(0, 12289, '\p{^Space=	f}', "");
Expect(0, 12289, '\P{Space=	f}', "");
Expect(1, 12289, '\P{^Space=	f}', "");
Expect(0, 12288, '\p{Space=	f}', "");
Expect(1, 12288, '\p{^Space=	f}', "");
Expect(1, 12288, '\P{Space=	f}', "");
Expect(0, 12288, '\P{^Space=	f}', "");
Error('\p{Is_White_Space=	False/a/}');
Error('\P{Is_White_Space=	False/a/}');
Expect(1, 12289, '\p{Is_White_Space: false}', "");
Expect(0, 12289, '\p{^Is_White_Space: false}', "");
Expect(0, 12289, '\P{Is_White_Space: false}', "");
Expect(1, 12289, '\P{^Is_White_Space: false}', "");
Expect(0, 12288, '\p{Is_White_Space: false}', "");
Expect(1, 12288, '\p{^Is_White_Space: false}', "");
Expect(1, 12288, '\P{Is_White_Space: false}', "");
Expect(0, 12288, '\P{^Is_White_Space: false}', "");
Expect(1, 12289, '\p{Is_White_Space= _false}', "");
Expect(0, 12289, '\p{^Is_White_Space= _false}', "");
Expect(0, 12289, '\P{Is_White_Space= _false}', "");
Expect(1, 12289, '\P{^Is_White_Space= _false}', "");
Expect(0, 12288, '\p{Is_White_Space= _false}', "");
Expect(1, 12288, '\p{^Is_White_Space= _false}', "");
Expect(1, 12288, '\P{Is_White_Space= _false}', "");
Expect(0, 12288, '\P{^Is_White_Space= _false}', "");
Error('\p{Is_WSpace=/a/ NO}');
Error('\P{Is_WSpace=/a/ NO}');
Expect(1, 12289, '\p{Is_WSpace:	no}', "");
Expect(0, 12289, '\p{^Is_WSpace:	no}', "");
Expect(0, 12289, '\P{Is_WSpace:	no}', "");
Expect(1, 12289, '\P{^Is_WSpace:	no}', "");
Expect(0, 12288, '\p{Is_WSpace:	no}', "");
Expect(1, 12288, '\p{^Is_WSpace:	no}', "");
Expect(1, 12288, '\P{Is_WSpace:	no}', "");
Expect(0, 12288, '\P{^Is_WSpace:	no}', "");
Expect(1, 12289, '\p{Is_WSpace=_No}', "");
Expect(0, 12289, '\p{^Is_WSpace=_No}', "");
Expect(0, 12289, '\P{Is_WSpace=_No}', "");
Expect(1, 12289, '\P{^Is_WSpace=_No}', "");
Expect(0, 12288, '\p{Is_WSpace=_No}', "");
Expect(1, 12288, '\p{^Is_WSpace=_No}', "");
Expect(1, 12288, '\P{Is_WSpace=_No}', "");
Expect(0, 12288, '\P{^Is_WSpace=_No}', "");
Error('\p{Is_Space=	_N/a/}');
Error('\P{Is_Space=	_N/a/}');
Expect(1, 12289, '\p{Is_Space=n}', "");
Expect(0, 12289, '\p{^Is_Space=n}', "");
Expect(0, 12289, '\P{Is_Space=n}', "");
Expect(1, 12289, '\P{^Is_Space=n}', "");
Expect(0, 12288, '\p{Is_Space=n}', "");
Expect(1, 12288, '\p{^Is_Space=n}', "");
Expect(1, 12288, '\P{Is_Space=n}', "");
Expect(0, 12288, '\P{^Is_Space=n}', "");
Expect(1, 12289, '\p{Is_Space=	_N}', "");
Expect(0, 12289, '\p{^Is_Space=	_N}', "");
Expect(0, 12289, '\P{Is_Space=	_N}', "");
Expect(1, 12289, '\P{^Is_Space=	_N}', "");
Expect(0, 12288, '\p{Is_Space=	_N}', "");
Expect(1, 12288, '\p{^Is_Space=	_N}', "");
Expect(1, 12288, '\P{Is_Space=	_N}', "");
Expect(0, 12288, '\P{^Is_Space=	_N}', "");
Error('\p{White_Space=/a/	yes}');
Error('\P{White_Space=/a/	yes}');
Expect(1, 12288, '\p{White_Space=yes}', "");
Expect(0, 12288, '\p{^White_Space=yes}', "");
Expect(0, 12288, '\P{White_Space=yes}', "");
Expect(1, 12288, '\P{^White_Space=yes}', "");
Expect(0, 12289, '\p{White_Space=yes}', "");
Expect(1, 12289, '\p{^White_Space=yes}', "");
Expect(1, 12289, '\P{White_Space=yes}', "");
Expect(0, 12289, '\P{^White_Space=yes}', "");
Expect(1, 12288, '\p{White_Space=		YES}', "");
Expect(0, 12288, '\p{^White_Space=		YES}', "");
Expect(0, 12288, '\P{White_Space=		YES}', "");
Expect(1, 12288, '\P{^White_Space=		YES}', "");
Expect(0, 12289, '\p{White_Space=		YES}', "");
Expect(1, 12289, '\p{^White_Space=		YES}', "");
Expect(1, 12289, '\P{White_Space=		YES}', "");
Expect(0, 12289, '\P{^White_Space=		YES}', "");
Error('\p{WSpace=/a/	_Y}');
Error('\P{WSpace=/a/	_Y}');
Expect(1, 12288, '\p{WSpace=y}', "");
Expect(0, 12288, '\p{^WSpace=y}', "");
Expect(0, 12288, '\P{WSpace=y}', "");
Expect(1, 12288, '\P{^WSpace=y}', "");
Expect(0, 12289, '\p{WSpace=y}', "");
Expect(1, 12289, '\p{^WSpace=y}', "");
Expect(1, 12289, '\P{WSpace=y}', "");
Expect(0, 12289, '\P{^WSpace=y}', "");
Expect(1, 12288, '\p{WSpace= -Y}', "");
Expect(0, 12288, '\p{^WSpace= -Y}', "");
Expect(0, 12288, '\P{WSpace= -Y}', "");
Expect(1, 12288, '\P{^WSpace= -Y}', "");
Expect(0, 12289, '\p{WSpace= -Y}', "");
Expect(1, 12289, '\p{^WSpace= -Y}', "");
Expect(1, 12289, '\P{WSpace= -Y}', "");
Expect(0, 12289, '\P{^WSpace= -Y}', "");
Error('\p{Space:   _/a/T}');
Error('\P{Space:   _/a/T}');
Expect(1, 12288, '\p{Space=t}', "");
Expect(0, 12288, '\p{^Space=t}', "");
Expect(0, 12288, '\P{Space=t}', "");
Expect(1, 12288, '\P{^Space=t}', "");
Expect(0, 12289, '\p{Space=t}', "");
Expect(1, 12289, '\p{^Space=t}', "");
Expect(1, 12289, '\P{Space=t}', "");
Expect(0, 12289, '\P{^Space=t}', "");
Expect(1, 12288, '\p{Space:		T}', "");
Expect(0, 12288, '\p{^Space:		T}', "");
Expect(0, 12288, '\P{Space:		T}', "");
Expect(1, 12288, '\P{^Space:		T}', "");
Expect(0, 12289, '\p{Space:		T}', "");
Expect(1, 12289, '\p{^Space:		T}', "");
Expect(1, 12289, '\P{Space:		T}', "");
Expect(0, 12289, '\P{^Space:		T}', "");
Error('\p{Is_White_Space=:=  True}');
Error('\P{Is_White_Space=:=  True}');
Expect(1, 12288, '\p{Is_White_Space=true}', "");
Expect(0, 12288, '\p{^Is_White_Space=true}', "");
Expect(0, 12288, '\P{Is_White_Space=true}', "");
Expect(1, 12288, '\P{^Is_White_Space=true}', "");
Expect(0, 12289, '\p{Is_White_Space=true}', "");
Expect(1, 12289, '\p{^Is_White_Space=true}', "");
Expect(1, 12289, '\P{Is_White_Space=true}', "");
Expect(0, 12289, '\P{^Is_White_Space=true}', "");
Expect(1, 12288, '\p{Is_White_Space=_True}', "");
Expect(0, 12288, '\p{^Is_White_Space=_True}', "");
Expect(0, 12288, '\P{Is_White_Space=_True}', "");
Expect(1, 12288, '\P{^Is_White_Space=_True}', "");
Expect(0, 12289, '\p{Is_White_Space=_True}', "");
Expect(1, 12289, '\p{^Is_White_Space=_True}', "");
Expect(1, 12289, '\P{Is_White_Space=_True}', "");
Expect(0, 12289, '\P{^Is_White_Space=_True}', "");
Error('\p{Is_WSpace=/a/		Yes}');
Error('\P{Is_WSpace=/a/		Yes}');
Expect(1, 12288, '\p{Is_WSpace:yes}', "");
Expect(0, 12288, '\p{^Is_WSpace:yes}', "");
Expect(0, 12288, '\P{Is_WSpace:yes}', "");
Expect(1, 12288, '\P{^Is_WSpace:yes}', "");
Expect(0, 12289, '\p{Is_WSpace:yes}', "");
Expect(1, 12289, '\p{^Is_WSpace:yes}', "");
Expect(1, 12289, '\P{Is_WSpace:yes}', "");
Expect(0, 12289, '\P{^Is_WSpace:yes}', "");
Expect(1, 12288, '\p{Is_WSpace= 	yes}', "");
Expect(0, 12288, '\p{^Is_WSpace= 	yes}', "");
Expect(0, 12288, '\P{Is_WSpace= 	yes}', "");
Expect(1, 12288, '\P{^Is_WSpace= 	yes}', "");
Expect(0, 12289, '\p{Is_WSpace= 	yes}', "");
Expect(1, 12289, '\p{^Is_WSpace= 	yes}', "");
Expect(1, 12289, '\P{Is_WSpace= 	yes}', "");
Expect(0, 12289, '\P{^Is_WSpace= 	yes}', "");
Error('\p{Is_Space=_	Y/a/}');
Error('\P{Is_Space=_	Y/a/}');
Expect(1, 12288, '\p{Is_Space=y}', "");
Expect(0, 12288, '\p{^Is_Space=y}', "");
Expect(0, 12288, '\P{Is_Space=y}', "");
Expect(1, 12288, '\P{^Is_Space=y}', "");
Expect(0, 12289, '\p{Is_Space=y}', "");
Expect(1, 12289, '\p{^Is_Space=y}', "");
Expect(1, 12289, '\P{Is_Space=y}', "");
Expect(0, 12289, '\P{^Is_Space=y}', "");
Expect(1, 12288, '\p{Is_Space=_y}', "");
Expect(0, 12288, '\p{^Is_Space=_y}', "");
Expect(0, 12288, '\P{Is_Space=_y}', "");
Expect(1, 12288, '\P{^Is_Space=_y}', "");
Expect(0, 12289, '\p{Is_Space=_y}', "");
Expect(1, 12289, '\p{^Is_Space=_y}', "");
Expect(1, 12289, '\P{Is_Space=_y}', "");
Expect(0, 12289, '\P{^Is_Space=_y}', "");
Error('\p{XID_Continue= :=No}');
Error('\P{XID_Continue= :=No}');
Expect(1, 918000, '\p{XID_Continue=no}', "");
Expect(0, 918000, '\p{^XID_Continue=no}', "");
Expect(0, 918000, '\P{XID_Continue=no}', "");
Expect(1, 918000, '\P{^XID_Continue=no}', "");
Expect(0, 917999, '\p{XID_Continue=no}', "");
Expect(1, 917999, '\p{^XID_Continue=no}', "");
Expect(1, 917999, '\P{XID_Continue=no}', "");
Expect(0, 917999, '\P{^XID_Continue=no}', "");
Expect(1, 918000, '\p{XID_Continue=_	No}', "");
Expect(0, 918000, '\p{^XID_Continue=_	No}', "");
Expect(0, 918000, '\P{XID_Continue=_	No}', "");
Expect(1, 918000, '\P{^XID_Continue=_	No}', "");
Expect(0, 917999, '\p{XID_Continue=_	No}', "");
Expect(1, 917999, '\p{^XID_Continue=_	No}', "");
Expect(1, 917999, '\P{XID_Continue=_	No}', "");
Expect(0, 917999, '\P{^XID_Continue=_	No}', "");
Error('\p{XIDC=/a/	 n}');
Error('\P{XIDC=/a/	 n}');
Expect(1, 918000, '\p{XIDC=n}', "");
Expect(0, 918000, '\p{^XIDC=n}', "");
Expect(0, 918000, '\P{XIDC=n}', "");
Expect(1, 918000, '\P{^XIDC=n}', "");
Expect(0, 917999, '\p{XIDC=n}', "");
Expect(1, 917999, '\p{^XIDC=n}', "");
Expect(1, 917999, '\P{XIDC=n}', "");
Expect(0, 917999, '\P{^XIDC=n}', "");
Expect(1, 918000, '\p{XIDC:	-_N}', "");
Expect(0, 918000, '\p{^XIDC:	-_N}', "");
Expect(0, 918000, '\P{XIDC:	-_N}', "");
Expect(1, 918000, '\P{^XIDC:	-_N}', "");
Expect(0, 917999, '\p{XIDC:	-_N}', "");
Expect(1, 917999, '\p{^XIDC:	-_N}', "");
Expect(1, 917999, '\P{XIDC:	-_N}', "");
Expect(0, 917999, '\P{^XIDC:	-_N}', "");
Error('\p{Is_XID_Continue=_f/a/}');
Error('\P{Is_XID_Continue=_f/a/}');
Expect(1, 918000, '\p{Is_XID_Continue=f}', "");
Expect(0, 918000, '\p{^Is_XID_Continue=f}', "");
Expect(0, 918000, '\P{Is_XID_Continue=f}', "");
Expect(1, 918000, '\P{^Is_XID_Continue=f}', "");
Expect(0, 917999, '\p{Is_XID_Continue=f}', "");
Expect(1, 917999, '\p{^Is_XID_Continue=f}', "");
Expect(1, 917999, '\P{Is_XID_Continue=f}', "");
Expect(0, 917999, '\P{^Is_XID_Continue=f}', "");
Expect(1, 918000, '\p{Is_XID_Continue:_F}', "");
Expect(0, 918000, '\p{^Is_XID_Continue:_F}', "");
Expect(0, 918000, '\P{Is_XID_Continue:_F}', "");
Expect(1, 918000, '\P{^Is_XID_Continue:_F}', "");
Expect(0, 917999, '\p{Is_XID_Continue:_F}', "");
Expect(1, 917999, '\p{^Is_XID_Continue:_F}', "");
Expect(1, 917999, '\P{Is_XID_Continue:_F}', "");
Expect(0, 917999, '\P{^Is_XID_Continue:_F}', "");
Error('\p{Is_XIDC=	/a/FALSE}');
Error('\P{Is_XIDC=	/a/FALSE}');
Expect(1, 918000, '\p{Is_XIDC=false}', "");
Expect(0, 918000, '\p{^Is_XIDC=false}', "");
Expect(0, 918000, '\P{Is_XIDC=false}', "");
Expect(1, 918000, '\P{^Is_XIDC=false}', "");
Expect(0, 917999, '\p{Is_XIDC=false}', "");
Expect(1, 917999, '\p{^Is_XIDC=false}', "");
Expect(1, 917999, '\P{Is_XIDC=false}', "");
Expect(0, 917999, '\P{^Is_XIDC=false}', "");
Expect(1, 918000, '\p{Is_XIDC=-false}', "");
Expect(0, 918000, '\p{^Is_XIDC=-false}', "");
Expect(0, 918000, '\P{Is_XIDC=-false}', "");
Expect(1, 918000, '\P{^Is_XIDC=-false}', "");
Expect(0, 917999, '\p{Is_XIDC=-false}', "");
Expect(1, 917999, '\p{^Is_XIDC=-false}', "");
Expect(1, 917999, '\P{Is_XIDC=-false}', "");
Expect(0, 917999, '\P{^Is_XIDC=-false}', "");
Error('\p{XID_Continue=-/a/Yes}');
Error('\P{XID_Continue=-/a/Yes}');
Expect(1, 917999, '\p{XID_Continue=yes}', "");
Expect(0, 917999, '\p{^XID_Continue=yes}', "");
Expect(0, 917999, '\P{XID_Continue=yes}', "");
Expect(1, 917999, '\P{^XID_Continue=yes}', "");
Expect(0, 918000, '\p{XID_Continue=yes}', "");
Expect(1, 918000, '\p{^XID_Continue=yes}', "");
Expect(1, 918000, '\P{XID_Continue=yes}', "");
Expect(0, 918000, '\P{^XID_Continue=yes}', "");
Expect(1, 917999, '\p{XID_Continue: -_Yes}', "");
Expect(0, 917999, '\p{^XID_Continue: -_Yes}', "");
Expect(0, 917999, '\P{XID_Continue: -_Yes}', "");
Expect(1, 917999, '\P{^XID_Continue: -_Yes}', "");
Expect(0, 918000, '\p{XID_Continue: -_Yes}', "");
Expect(1, 918000, '\p{^XID_Continue: -_Yes}', "");
Expect(1, 918000, '\P{XID_Continue: -_Yes}', "");
Expect(0, 918000, '\P{^XID_Continue: -_Yes}', "");
Error('\p{XIDC=_:=Y}');
Error('\P{XIDC=_:=Y}');
Expect(1, 917999, '\p{XIDC=y}', "");
Expect(0, 917999, '\p{^XIDC=y}', "");
Expect(0, 917999, '\P{XIDC=y}', "");
Expect(1, 917999, '\P{^XIDC=y}', "");
Expect(0, 918000, '\p{XIDC=y}', "");
Expect(1, 918000, '\p{^XIDC=y}', "");
Expect(1, 918000, '\P{XIDC=y}', "");
Expect(0, 918000, '\P{^XIDC=y}', "");
Expect(1, 917999, '\p{XIDC=	 Y}', "");
Expect(0, 917999, '\p{^XIDC=	 Y}', "");
Expect(0, 917999, '\P{XIDC=	 Y}', "");
Expect(1, 917999, '\P{^XIDC=	 Y}', "");
Expect(0, 918000, '\p{XIDC=	 Y}', "");
Expect(1, 918000, '\p{^XIDC=	 Y}', "");
Expect(1, 918000, '\P{XIDC=	 Y}', "");
Expect(0, 918000, '\P{^XIDC=	 Y}', "");
Error('\p{Is_XID_Continue=_T/a/}');
Error('\P{Is_XID_Continue=_T/a/}');
Expect(1, 917999, '\p{Is_XID_Continue=t}', "");
Expect(0, 917999, '\p{^Is_XID_Continue=t}', "");
Expect(0, 917999, '\P{Is_XID_Continue=t}', "");
Expect(1, 917999, '\P{^Is_XID_Continue=t}', "");
Expect(0, 918000, '\p{Is_XID_Continue=t}', "");
Expect(1, 918000, '\p{^Is_XID_Continue=t}', "");
Expect(1, 918000, '\P{Is_XID_Continue=t}', "");
Expect(0, 918000, '\P{^Is_XID_Continue=t}', "");
Expect(1, 917999, '\p{Is_XID_Continue= _t}', "");
Expect(0, 917999, '\p{^Is_XID_Continue= _t}', "");
Expect(0, 917999, '\P{Is_XID_Continue= _t}', "");
Expect(1, 917999, '\P{^Is_XID_Continue= _t}', "");
Expect(0, 918000, '\p{Is_XID_Continue= _t}', "");
Expect(1, 918000, '\p{^Is_XID_Continue= _t}', "");
Expect(1, 918000, '\P{Is_XID_Continue= _t}', "");
Expect(0, 918000, '\P{^Is_XID_Continue= _t}', "");
Error('\p{Is_XIDC= :=True}');
Error('\P{Is_XIDC= :=True}');
Expect(1, 917999, '\p{Is_XIDC=true}', "");
Expect(0, 917999, '\p{^Is_XIDC=true}', "");
Expect(0, 917999, '\P{Is_XIDC=true}', "");
Expect(1, 917999, '\P{^Is_XIDC=true}', "");
Expect(0, 918000, '\p{Is_XIDC=true}', "");
Expect(1, 918000, '\p{^Is_XIDC=true}', "");
Expect(1, 918000, '\P{Is_XIDC=true}', "");
Expect(0, 918000, '\P{^Is_XIDC=true}', "");
Expect(1, 917999, '\p{Is_XIDC=		True}', "");
Expect(0, 917999, '\p{^Is_XIDC=		True}', "");
Expect(0, 917999, '\P{Is_XIDC=		True}', "");
Expect(1, 917999, '\P{^Is_XIDC=		True}', "");
Expect(0, 918000, '\p{Is_XIDC=		True}', "");
Expect(1, 918000, '\p{^Is_XIDC=		True}', "");
Expect(1, 918000, '\P{Is_XIDC=		True}', "");
Expect(0, 918000, '\P{^Is_XIDC=		True}', "");
Error('\p{XID_Start=/a/_No}');
Error('\P{XID_Start=/a/_No}');
Expect(1, 195102, '\p{XID_Start: no}', "");
Expect(0, 195102, '\p{^XID_Start: no}', "");
Expect(0, 195102, '\P{XID_Start: no}', "");
Expect(1, 195102, '\P{^XID_Start: no}', "");
Expect(0, 195101, '\p{XID_Start: no}', "");
Expect(1, 195101, '\p{^XID_Start: no}', "");
Expect(1, 195101, '\P{XID_Start: no}', "");
Expect(0, 195101, '\P{^XID_Start: no}', "");
Expect(1, 195102, '\p{XID_Start:	 -no}', "");
Expect(0, 195102, '\p{^XID_Start:	 -no}', "");
Expect(0, 195102, '\P{XID_Start:	 -no}', "");
Expect(1, 195102, '\P{^XID_Start:	 -no}', "");
Expect(0, 195101, '\p{XID_Start:	 -no}', "");
Expect(1, 195101, '\p{^XID_Start:	 -no}', "");
Expect(1, 195101, '\P{XID_Start:	 -no}', "");
Expect(0, 195101, '\P{^XID_Start:	 -no}', "");
Error('\p{XIDS=:=_N}');
Error('\P{XIDS=:=_N}');
Expect(1, 195102, '\p{XIDS=n}', "");
Expect(0, 195102, '\p{^XIDS=n}', "");
Expect(0, 195102, '\P{XIDS=n}', "");
Expect(1, 195102, '\P{^XIDS=n}', "");
Expect(0, 195101, '\p{XIDS=n}', "");
Expect(1, 195101, '\p{^XIDS=n}', "");
Expect(1, 195101, '\P{XIDS=n}', "");
Expect(0, 195101, '\P{^XIDS=n}', "");
Expect(1, 195102, '\p{XIDS=_n}', "");
Expect(0, 195102, '\p{^XIDS=_n}', "");
Expect(0, 195102, '\P{XIDS=_n}', "");
Expect(1, 195102, '\P{^XIDS=_n}', "");
Expect(0, 195101, '\p{XIDS=_n}', "");
Expect(1, 195101, '\p{^XIDS=_n}', "");
Expect(1, 195101, '\P{XIDS=_n}', "");
Expect(0, 195101, '\P{^XIDS=_n}', "");
Error('\p{Is_XID_Start=:=	F}');
Error('\P{Is_XID_Start=:=	F}');
Expect(1, 195102, '\p{Is_XID_Start=f}', "");
Expect(0, 195102, '\p{^Is_XID_Start=f}', "");
Expect(0, 195102, '\P{Is_XID_Start=f}', "");
Expect(1, 195102, '\P{^Is_XID_Start=f}', "");
Expect(0, 195101, '\p{Is_XID_Start=f}', "");
Expect(1, 195101, '\p{^Is_XID_Start=f}', "");
Expect(1, 195101, '\P{Is_XID_Start=f}', "");
Expect(0, 195101, '\P{^Is_XID_Start=f}', "");
Expect(1, 195102, '\p{Is_XID_Start:	F}', "");
Expect(0, 195102, '\p{^Is_XID_Start:	F}', "");
Expect(0, 195102, '\P{Is_XID_Start:	F}', "");
Expect(1, 195102, '\P{^Is_XID_Start:	F}', "");
Expect(0, 195101, '\p{Is_XID_Start:	F}', "");
Expect(1, 195101, '\p{^Is_XID_Start:	F}', "");
Expect(1, 195101, '\P{Is_XID_Start:	F}', "");
Expect(0, 195101, '\P{^Is_XID_Start:	F}', "");
Error('\p{Is_XIDS=  False/a/}');
Error('\P{Is_XIDS=  False/a/}');
Expect(1, 195102, '\p{Is_XIDS=false}', "");
Expect(0, 195102, '\p{^Is_XIDS=false}', "");
Expect(0, 195102, '\P{Is_XIDS=false}', "");
Expect(1, 195102, '\P{^Is_XIDS=false}', "");
Expect(0, 195101, '\p{Is_XIDS=false}', "");
Expect(1, 195101, '\p{^Is_XIDS=false}', "");
Expect(1, 195101, '\P{Is_XIDS=false}', "");
Expect(0, 195101, '\P{^Is_XIDS=false}', "");
Expect(1, 195102, '\p{Is_XIDS=_-False}', "");
Expect(0, 195102, '\p{^Is_XIDS=_-False}', "");
Expect(0, 195102, '\P{Is_XIDS=_-False}', "");
Expect(1, 195102, '\P{^Is_XIDS=_-False}', "");
Expect(0, 195101, '\p{Is_XIDS=_-False}', "");
Expect(1, 195101, '\p{^Is_XIDS=_-False}', "");
Expect(1, 195101, '\P{Is_XIDS=_-False}', "");
Expect(0, 195101, '\P{^Is_XIDS=_-False}', "");
Error('\p{XID_Start=-_YES:=}');
Error('\P{XID_Start=-_YES:=}');
Expect(1, 195101, '\p{XID_Start=yes}', "");
Expect(0, 195101, '\p{^XID_Start=yes}', "");
Expect(0, 195101, '\P{XID_Start=yes}', "");
Expect(1, 195101, '\P{^XID_Start=yes}', "");
Expect(0, 195102, '\p{XID_Start=yes}', "");
Expect(1, 195102, '\p{^XID_Start=yes}', "");
Expect(1, 195102, '\P{XID_Start=yes}', "");
Expect(0, 195102, '\P{^XID_Start=yes}', "");
Expect(1, 195101, '\p{XID_Start= 	Yes}', "");
Expect(0, 195101, '\p{^XID_Start= 	Yes}', "");
Expect(0, 195101, '\P{XID_Start= 	Yes}', "");
Expect(1, 195101, '\P{^XID_Start= 	Yes}', "");
Expect(0, 195102, '\p{XID_Start= 	Yes}', "");
Expect(1, 195102, '\p{^XID_Start= 	Yes}', "");
Expect(1, 195102, '\P{XID_Start= 	Yes}', "");
Expect(0, 195102, '\P{^XID_Start= 	Yes}', "");
Error('\p{XIDS:	-:=Y}');
Error('\P{XIDS:	-:=Y}');
Expect(1, 195101, '\p{XIDS=y}', "");
Expect(0, 195101, '\p{^XIDS=y}', "");
Expect(0, 195101, '\P{XIDS=y}', "");
Expect(1, 195101, '\P{^XIDS=y}', "");
Expect(0, 195102, '\p{XIDS=y}', "");
Expect(1, 195102, '\p{^XIDS=y}', "");
Expect(1, 195102, '\P{XIDS=y}', "");
Expect(0, 195102, '\P{^XIDS=y}', "");
Expect(1, 195101, '\p{XIDS=		Y}', "");
Expect(0, 195101, '\p{^XIDS=		Y}', "");
Expect(0, 195101, '\P{XIDS=		Y}', "");
Expect(1, 195101, '\P{^XIDS=		Y}', "");
Expect(0, 195102, '\p{XIDS=		Y}', "");
Expect(1, 195102, '\p{^XIDS=		Y}', "");
Expect(1, 195102, '\P{XIDS=		Y}', "");
Expect(0, 195102, '\P{^XIDS=		Y}', "");
Error('\p{Is_XID_Start=:=T}');
Error('\P{Is_XID_Start=:=T}');
Expect(1, 195101, '\p{Is_XID_Start=t}', "");
Expect(0, 195101, '\p{^Is_XID_Start=t}', "");
Expect(0, 195101, '\P{Is_XID_Start=t}', "");
Expect(1, 195101, '\P{^Is_XID_Start=t}', "");
Expect(0, 195102, '\p{Is_XID_Start=t}', "");
Expect(1, 195102, '\p{^Is_XID_Start=t}', "");
Expect(1, 195102, '\P{Is_XID_Start=t}', "");
Expect(0, 195102, '\P{^Is_XID_Start=t}', "");
Expect(1, 195101, '\p{Is_XID_Start=	T}', "");
Expect(0, 195101, '\p{^Is_XID_Start=	T}', "");
Expect(0, 195101, '\P{Is_XID_Start=	T}', "");
Expect(1, 195101, '\P{^Is_XID_Start=	T}', "");
Expect(0, 195102, '\p{Is_XID_Start=	T}', "");
Expect(1, 195102, '\p{^Is_XID_Start=	T}', "");
Expect(1, 195102, '\P{Is_XID_Start=	T}', "");
Expect(0, 195102, '\P{^Is_XID_Start=	T}', "");
Error('\p{Is_XIDS=/a/-_TRUE}');
Error('\P{Is_XIDS=/a/-_TRUE}');
Expect(1, 195101, '\p{Is_XIDS=true}', "");
Expect(0, 195101, '\p{^Is_XIDS=true}', "");
Expect(0, 195101, '\P{Is_XIDS=true}', "");
Expect(1, 195101, '\P{^Is_XIDS=true}', "");
Expect(0, 195102, '\p{Is_XIDS=true}', "");
Expect(1, 195102, '\p{^Is_XIDS=true}', "");
Expect(1, 195102, '\P{Is_XIDS=true}', "");
Expect(0, 195102, '\P{^Is_XIDS=true}', "");
Expect(1, 195101, '\p{Is_XIDS:   	_True}', "");
Expect(0, 195101, '\p{^Is_XIDS:   	_True}', "");
Expect(0, 195101, '\P{Is_XIDS:   	_True}', "");
Expect(1, 195101, '\P{^Is_XIDS:   	_True}', "");
Expect(0, 195102, '\p{Is_XIDS:   	_True}', "");
Expect(1, 195102, '\p{^Is_XIDS:   	_True}', "");
Expect(1, 195102, '\P{Is_XIDS:   	_True}', "");
Expect(0, 195102, '\P{^Is_XIDS:   	_True}', "");
Error('\p{Expands_On_NFC=No}');
Error('\P{Expands_On_NFC=No}');
Error('\p{XO_NFC=N}');
Error('\P{XO_NFC=N}');
Error('\p{Is_Expands_On_NFC=F}');
Error('\P{Is_Expands_On_NFC=F}');
Error('\p{Is_XO_NFC=False}');
Error('\P{Is_XO_NFC=False}');
Error('\p{Expands_On_NFC:Yes}');
Error('\P{Expands_On_NFC:Yes}');
Error('\p{XO_NFC=Y}');
Error('\P{XO_NFC=Y}');
Error('\p{Is_Expands_On_NFC=T}');
Error('\P{Is_Expands_On_NFC=T}');
Error('\p{Is_XO_NFC=True}');
Error('\P{Is_XO_NFC=True}');
Error('\p{Expands_On_NFD=No}');
Error('\P{Expands_On_NFD=No}');
Error('\p{XO_NFD=N}');
Error('\P{XO_NFD=N}');
Error('\p{Is_Expands_On_NFD: F}');
Error('\P{Is_Expands_On_NFD: F}');
Error('\p{Is_XO_NFD=False}');
Error('\P{Is_XO_NFD=False}');
Error('\p{Expands_On_NFD:Yes}');
Error('\P{Expands_On_NFD:Yes}');
Error('\p{XO_NFD=Y}');
Error('\P{XO_NFD=Y}');
Error('\p{Is_Expands_On_NFD=T}');
Error('\P{Is_Expands_On_NFD=T}');
Error('\p{Is_XO_NFD=True}');
Error('\P{Is_XO_NFD=True}');
Error('\p{Expands_On_NFKC=No}');
Error('\P{Expands_On_NFKC=No}');
Error('\p{XO_NFKC=N}');
Error('\P{XO_NFKC=N}');
Error('\p{Is_Expands_On_NFKC=F}');
Error('\P{Is_Expands_On_NFKC=F}');
Error('\p{Is_XO_NFKC=False}');
Error('\P{Is_XO_NFKC=False}');
Error('\p{Expands_On_NFKC=Yes}');
Error('\P{Expands_On_NFKC=Yes}');
Error('\p{XO_NFKC=Y}');
Error('\P{XO_NFKC=Y}');
Error('\p{Is_Expands_On_NFKC=T}');
Error('\P{Is_Expands_On_NFKC=T}');
Error('\p{Is_XO_NFKC=True}');
Error('\P{Is_XO_NFKC=True}');
Error('\p{Expands_On_NFKD=No}');
Error('\P{Expands_On_NFKD=No}');
Error('\p{XO_NFKD=N}');
Error('\P{XO_NFKD=N}');
Error('\p{Is_Expands_On_NFKD:F}');
Error('\P{Is_Expands_On_NFKD:F}');
Error('\p{Is_XO_NFKD=False}');
Error('\P{Is_XO_NFKD=False}');
Error('\p{Expands_On_NFKD=Yes}');
Error('\P{Expands_On_NFKD=Yes}');
Error('\p{XO_NFKD=Y}');
Error('\P{XO_NFKD=Y}');
Error('\p{Is_Expands_On_NFKD=T}');
Error('\P{Is_Expands_On_NFKD=T}');
Error('\p{Is_XO_NFKD=True}');
Error('\P{Is_XO_NFKD=True}');
Error('\p{Age= _V1_1/a/}');
Error('\P{Age= _V1_1/a/}');
Expect(1, 65533, '\p{Age=v11}', "");
Expect(0, 65533, '\p{^Age=v11}', "");
Expect(0, 65533, '\P{Age=v11}', "");
Expect(1, 65533, '\P{^Age=v11}', "");
Expect(0, 65536, '\p{Age=v11}', "");
Expect(1, 65536, '\p{^Age=v11}', "");
Expect(1, 65536, '\P{Age=v11}', "");
Expect(0, 65536, '\P{^Age=v11}', "");
Expect(1, 65533, '\p{Age= _v1_1}', "");
Expect(0, 65533, '\p{^Age= _v1_1}', "");
Expect(0, 65533, '\P{Age= _v1_1}', "");
Expect(1, 65533, '\P{^Age= _v1_1}', "");
Expect(0, 65536, '\p{Age= _v1_1}', "");
Expect(1, 65536, '\p{^Age= _v1_1}', "");
Expect(1, 65536, '\P{Age= _v1_1}', "");
Expect(0, 65536, '\P{^Age= _v1_1}', "");
Error('\p{Is_Age=/a/ -0_0_0_0_0_0_0_01.1}');
Error('\P{Is_Age=/a/ -0_0_0_0_0_0_0_01.1}');
Expect(1, 65533, '\p{Is_Age: 00000001.1}', "");
Expect(0, 65533, '\p{^Is_Age: 00000001.1}', "");
Expect(0, 65533, '\P{Is_Age: 00000001.1}', "");
Expect(1, 65533, '\P{^Is_Age: 00000001.1}', "");
Expect(0, 65536, '\p{Is_Age: 00000001.1}', "");
Expect(1, 65536, '\p{^Is_Age: 00000001.1}', "");
Expect(1, 65536, '\P{Is_Age: 00000001.1}', "");
Expect(0, 65536, '\P{^Is_Age: 00000001.1}', "");
Error('\p{Age=-V2_0:=}');
Error('\P{Age=-V2_0:=}');
Expect(1, 983040, '\p{Age=v20}', "");
Expect(0, 983040, '\p{^Age=v20}', "");
Expect(0, 983040, '\P{Age=v20}', "");
Expect(1, 983040, '\P{^Age=v20}', "");
Expect(0, 983037, '\p{Age=v20}', "");
Expect(1, 983037, '\p{^Age=v20}', "");
Expect(1, 983037, '\P{Age=v20}', "");
Expect(0, 983037, '\P{^Age=v20}', "");
Expect(1, 983040, '\p{Age:-	V2_0}', "");
Expect(0, 983040, '\p{^Age:-	V2_0}', "");
Expect(0, 983040, '\P{Age:-	V2_0}', "");
Expect(1, 983040, '\P{^Age:-	V2_0}', "");
Expect(0, 983037, '\p{Age:-	V2_0}', "");
Expect(1, 983037, '\p{^Age:-	V2_0}', "");
Expect(1, 983037, '\P{Age:-	V2_0}', "");
Expect(0, 983037, '\P{^Age:-	V2_0}', "");
Error('\p{Is_Age=/a/0_2.0}');
Error('\P{Is_Age=/a/0_2.0}');
Expect(1, 983040, '\p{Is_Age=0_0_0_0_0_0_0002.0}', "");
Expect(0, 983040, '\p{^Is_Age=0_0_0_0_0_0_0002.0}', "");
Expect(0, 983040, '\P{Is_Age=0_0_0_0_0_0_0002.0}', "");
Expect(1, 983040, '\P{^Is_Age=0_0_0_0_0_0_0002.0}', "");
Expect(0, 983037, '\p{Is_Age=0_0_0_0_0_0_0002.0}', "");
Expect(1, 983037, '\p{^Is_Age=0_0_0_0_0_0_0002.0}', "");
Expect(1, 983037, '\P{Is_Age=0_0_0_0_0_0_0002.0}', "");
Expect(0, 983037, '\P{^Is_Age=0_0_0_0_0_0_0002.0}', "");
Error('\p{Age=:=	_V2_1}');
Error('\P{Age=:=	_V2_1}');
Expect(1, 65532, '\p{Age=v21}', "");
Expect(0, 65532, '\p{^Age=v21}', "");
Expect(0, 65532, '\P{Age=v21}', "");
Expect(1, 65532, '\P{^Age=v21}', "");
Expect(0, 65533, '\p{Age=v21}', "");
Expect(1, 65533, '\p{^Age=v21}', "");
Expect(1, 65533, '\P{Age=v21}', "");
Expect(0, 65533, '\P{^Age=v21}', "");
Expect(1, 65532, '\p{Age=	V2_1}', "");
Expect(0, 65532, '\p{^Age=	V2_1}', "");
Expect(0, 65532, '\P{Age=	V2_1}', "");
Expect(1, 65532, '\P{^Age=	V2_1}', "");
Expect(0, 65533, '\p{Age=	V2_1}', "");
Expect(1, 65533, '\p{^Age=	V2_1}', "");
Expect(1, 65533, '\P{Age=	V2_1}', "");
Expect(0, 65533, '\P{^Age=	V2_1}', "");
Error('\p{Is_Age=-:=00002.1}');
Error('\P{Is_Age=-:=00002.1}');
Expect(1, 65532, '\p{Is_Age=+02.1}', "");
Expect(0, 65532, '\p{^Is_Age=+02.1}', "");
Expect(0, 65532, '\P{Is_Age=+02.1}', "");
Expect(1, 65532, '\P{^Is_Age=+02.1}', "");
Expect(0, 65533, '\p{Is_Age=+02.1}', "");
Expect(1, 65533, '\p{^Is_Age=+02.1}', "");
Expect(1, 65533, '\P{Is_Age=+02.1}', "");
Expect(0, 65533, '\P{^Is_Age=+02.1}', "");
Error('\p{Age=V3_0:=}');
Error('\P{Age=V3_0:=}');
Expect(1, 65531, '\p{Age=v30}', "");
Expect(0, 65531, '\p{^Age=v30}', "");
Expect(0, 65531, '\P{Age=v30}', "");
Expect(1, 65531, '\P{^Age=v30}', "");
Expect(0, 65532, '\p{Age=v30}', "");
Expect(1, 65532, '\p{^Age=v30}', "");
Expect(1, 65532, '\P{Age=v30}', "");
Expect(0, 65532, '\P{^Age=v30}', "");
Expect(1, 65531, '\p{Age=__v3_0}', "");
Expect(0, 65531, '\p{^Age=__v3_0}', "");
Expect(0, 65531, '\P{Age=__v3_0}', "");
Expect(1, 65531, '\P{^Age=__v3_0}', "");
Expect(0, 65532, '\p{Age=__v3_0}', "");
Expect(1, 65532, '\p{^Age=__v3_0}', "");
Expect(1, 65532, '\P{Age=__v3_0}', "");
Expect(0, 65532, '\P{^Age=__v3_0}', "");
Error('\p{Is_Age=/a/__0_3.0}');
Error('\P{Is_Age=/a/__0_3.0}');
Expect(1, 65531, '\p{Is_Age: 00_00_3.0}', "");
Expect(0, 65531, '\p{^Is_Age: 00_00_3.0}', "");
Expect(0, 65531, '\P{Is_Age: 00_00_3.0}', "");
Expect(1, 65531, '\P{^Is_Age: 00_00_3.0}', "");
Expect(0, 65532, '\p{Is_Age: 00_00_3.0}', "");
Expect(1, 65532, '\p{^Is_Age: 00_00_3.0}', "");
Expect(1, 65532, '\P{Is_Age: 00_00_3.0}', "");
Expect(0, 65532, '\P{^Is_Age: 00_00_3.0}', "");
Error('\p{Age=/a/__V3_1}');
Error('\P{Age=/a/__V3_1}');
Expect(1, 917631, '\p{Age=v31}', "");
Expect(0, 917631, '\p{^Age=v31}', "");
Expect(0, 917631, '\P{Age=v31}', "");
Expect(1, 917631, '\P{^Age=v31}', "");
Expect(0, 917632, '\p{Age=v31}', "");
Expect(1, 917632, '\p{^Age=v31}', "");
Expect(1, 917632, '\P{Age=v31}', "");
Expect(0, 917632, '\P{^Age=v31}', "");
Expect(1, 917631, '\p{Age=__V3_1}', "");
Expect(0, 917631, '\p{^Age=__V3_1}', "");
Expect(0, 917631, '\P{Age=__V3_1}', "");
Expect(1, 917631, '\P{^Age=__V3_1}', "");
Expect(0, 917632, '\p{Age=__V3_1}', "");
Expect(1, 917632, '\p{^Age=__V3_1}', "");
Expect(1, 917632, '\P{Age=__V3_1}', "");
Expect(0, 917632, '\P{^Age=__V3_1}', "");
Error('\p{Is_Age:    :=0_0_0_03.1}');
Error('\P{Is_Age:    :=0_0_0_03.1}');
Expect(1, 917631, '\p{Is_Age=0_3.1}', "");
Expect(0, 917631, '\p{^Is_Age=0_3.1}', "");
Expect(0, 917631, '\P{Is_Age=0_3.1}', "");
Expect(1, 917631, '\P{^Is_Age=0_3.1}', "");
Expect(0, 917632, '\p{Is_Age=0_3.1}', "");
Expect(1, 917632, '\p{^Is_Age=0_3.1}', "");
Expect(1, 917632, '\P{Is_Age=0_3.1}', "");
Expect(0, 917632, '\P{^Is_Age=0_3.1}', "");
Error('\p{Age=/a/ _V3_2}');
Error('\P{Age=/a/ _V3_2}');
Expect(1, 65376, '\p{Age=v32}', "");
Expect(0, 65376, '\p{^Age=v32}', "");
Expect(0, 65376, '\P{Age=v32}', "");
Expect(1, 65376, '\P{^Age=v32}', "");
Expect(0, 65377, '\p{Age=v32}', "");
Expect(1, 65377, '\p{^Age=v32}', "");
Expect(1, 65377, '\P{Age=v32}', "");
Expect(0, 65377, '\P{^Age=v32}', "");
Expect(1, 65376, '\p{Age=v3_2}', "");
Expect(0, 65376, '\p{^Age=v3_2}', "");
Expect(0, 65376, '\P{Age=v3_2}', "");
Expect(1, 65376, '\P{^Age=v3_2}', "");
Expect(0, 65377, '\p{Age=v3_2}', "");
Expect(1, 65377, '\p{^Age=v3_2}', "");
Expect(1, 65377, '\P{Age=v3_2}', "");
Expect(0, 65377, '\P{^Age=v3_2}', "");
Error('\p{Is_Age=	03.2:=}');
Error('\P{Is_Age=	03.2:=}');
Expect(1, 65376, '\p{Is_Age=00000003.2}', "");
Expect(0, 65376, '\p{^Is_Age=00000003.2}', "");
Expect(0, 65376, '\P{Is_Age=00000003.2}', "");
Expect(1, 65376, '\P{^Is_Age=00000003.2}', "");
Expect(0, 65377, '\p{Is_Age=00000003.2}', "");
Expect(1, 65377, '\p{^Is_Age=00000003.2}', "");
Expect(1, 65377, '\P{Is_Age=00000003.2}', "");
Expect(0, 65377, '\P{^Is_Age=00000003.2}', "");
Error('\p{Age= _V4_0:=}');
Error('\P{Age= _V4_0:=}');
Expect(1, 917999, '\p{Age=v40}', "");
Expect(0, 917999, '\p{^Age=v40}', "");
Expect(0, 917999, '\P{Age=v40}', "");
Expect(1, 917999, '\P{^Age=v40}', "");
Expect(0, 918000, '\p{Age=v40}', "");
Expect(1, 918000, '\p{^Age=v40}', "");
Expect(1, 918000, '\P{Age=v40}', "");
Expect(0, 918000, '\P{^Age=v40}', "");
Expect(1, 917999, '\p{Age: -	V4_0}', "");
Expect(0, 917999, '\p{^Age: -	V4_0}', "");
Expect(0, 917999, '\P{Age: -	V4_0}', "");
Expect(1, 917999, '\P{^Age: -	V4_0}', "");
Expect(0, 918000, '\p{Age: -	V4_0}', "");
Expect(1, 918000, '\p{^Age: -	V4_0}', "");
Expect(1, 918000, '\P{Age: -	V4_0}', "");
Expect(0, 918000, '\P{^Age: -	V4_0}', "");
Error('\p{Is_Age= :=04.0}');
Error('\P{Is_Age= :=04.0}');
Expect(1, 917999, '\p{Is_Age=004.0}', "");
Expect(0, 917999, '\p{^Is_Age=004.0}', "");
Expect(0, 917999, '\P{Is_Age=004.0}', "");
Expect(1, 917999, '\P{^Is_Age=004.0}', "");
Expect(0, 918000, '\p{Is_Age=004.0}', "");
Expect(1, 918000, '\p{^Is_Age=004.0}', "");
Expect(1, 918000, '\P{Is_Age=004.0}', "");
Expect(0, 918000, '\P{^Is_Age=004.0}', "");
Error('\p{Age=/a/_ V4_1}');
Error('\P{Age=/a/_ V4_1}');
Expect(1, 120485, '\p{Age=v41}', "");
Expect(0, 120485, '\p{^Age=v41}', "");
Expect(0, 120485, '\P{Age=v41}', "");
Expect(1, 120485, '\P{^Age=v41}', "");
Expect(0, 120486, '\p{Age=v41}', "");
Expect(1, 120486, '\p{^Age=v41}', "");
Expect(1, 120486, '\P{Age=v41}', "");
Expect(0, 120486, '\P{^Age=v41}', "");
Expect(1, 120485, '\p{Age=	v4_1}', "");
Expect(0, 120485, '\p{^Age=	v4_1}', "");
Expect(0, 120485, '\P{Age=	v4_1}', "");
Expect(1, 120485, '\P{^Age=	v4_1}', "");
Expect(0, 120486, '\p{Age=	v4_1}', "");
Expect(1, 120486, '\p{^Age=	v4_1}', "");
Expect(1, 120486, '\P{Age=	v4_1}', "");
Expect(0, 120486, '\P{^Age=	v4_1}', "");
Error('\p{Is_Age=-:=0000000004.1}');
Error('\P{Is_Age=-:=0000000004.1}');
Expect(1, 120485, '\p{Is_Age=004.1}', "");
Expect(0, 120485, '\p{^Is_Age=004.1}', "");
Expect(0, 120485, '\P{Is_Age=004.1}', "");
Expect(1, 120485, '\P{^Is_Age=004.1}', "");
Expect(0, 120486, '\p{Is_Age=004.1}', "");
Expect(1, 120486, '\p{^Is_Age=004.1}', "");
Expect(1, 120486, '\P{Is_Age=004.1}', "");
Expect(0, 120486, '\P{^Is_Age=004.1}', "");
Error('\p{Age=-_V5_0:=}');
Error('\P{Age=-_V5_0:=}');
Expect(1, 120779, '\p{Age=v50}', "");
Expect(0, 120779, '\p{^Age=v50}', "");
Expect(0, 120779, '\P{Age=v50}', "");
Expect(1, 120779, '\P{^Age=v50}', "");
Expect(0, 120780, '\p{Age=v50}', "");
Expect(1, 120780, '\p{^Age=v50}', "");
Expect(1, 120780, '\P{Age=v50}', "");
Expect(0, 120780, '\P{^Age=v50}', "");
Expect(1, 120779, '\p{Age= V5_0}', "");
Expect(0, 120779, '\p{^Age= V5_0}', "");
Expect(0, 120779, '\P{Age= V5_0}', "");
Expect(1, 120779, '\P{^Age= V5_0}', "");
Expect(0, 120780, '\p{Age= V5_0}', "");
Expect(1, 120780, '\p{^Age= V5_0}', "");
Expect(1, 120780, '\P{Age= V5_0}', "");
Expect(0, 120780, '\P{^Age= V5_0}', "");
Error('\p{Is_Age:	-	00000005.0:=}');
Error('\P{Is_Age:	-	00000005.0:=}');
Expect(1, 120779, '\p{Is_Age=+0_0_05.0}', "");
Expect(0, 120779, '\p{^Is_Age=+0_0_05.0}', "");
Expect(0, 120779, '\P{Is_Age=+0_0_05.0}', "");
Expect(1, 120779, '\P{^Is_Age=+0_0_05.0}', "");
Expect(0, 120780, '\p{Is_Age=+0_0_05.0}', "");
Expect(1, 120780, '\p{^Is_Age=+0_0_05.0}', "");
Expect(1, 120780, '\P{Is_Age=+0_0_05.0}', "");
Expect(0, 120780, '\P{^Is_Age=+0_0_05.0}', "");
Error('\p{Age=/a/- V5_1}');
Error('\P{Age=/a/- V5_1}');
Expect(1, 127123, '\p{Age=v51}', "");
Expect(0, 127123, '\p{^Age=v51}', "");
Expect(0, 127123, '\P{Age=v51}', "");
Expect(1, 127123, '\P{^Age=v51}', "");
Expect(0, 127124, '\p{Age=v51}', "");
Expect(1, 127124, '\p{^Age=v51}', "");
Expect(1, 127124, '\P{Age=v51}', "");
Expect(0, 127124, '\P{^Age=v51}', "");
Expect(1, 127123, '\p{Age:	 	V5_1}', "");
Expect(0, 127123, '\p{^Age:	 	V5_1}', "");
Expect(0, 127123, '\P{Age:	 	V5_1}', "");
Expect(1, 127123, '\P{^Age:	 	V5_1}', "");
Expect(0, 127124, '\p{Age:	 	V5_1}', "");
Expect(1, 127124, '\p{^Age:	 	V5_1}', "");
Expect(1, 127124, '\P{Age:	 	V5_1}', "");
Expect(0, 127124, '\P{^Age:	 	V5_1}', "");
Error('\p{Is_Age=:=-005.1}');
Error('\P{Is_Age=:=-005.1}');
Expect(1, 127123, '\p{Is_Age=000000_5.1}', "");
Expect(0, 127123, '\p{^Is_Age=000000_5.1}', "");
Expect(0, 127123, '\P{Is_Age=000000_5.1}', "");
Expect(1, 127123, '\P{^Is_Age=000000_5.1}', "");
Expect(0, 127124, '\p{Is_Age=000000_5.1}', "");
Expect(1, 127124, '\p{^Is_Age=000000_5.1}', "");
Expect(1, 127124, '\P{Is_Age=000000_5.1}', "");
Expect(0, 127124, '\P{^Is_Age=000000_5.1}', "");
Error('\p{Age=:=_V5_2}');
Error('\P{Age=:=_V5_2}');
Expect(1, 177972, '\p{Age=v52}', "");
Expect(0, 177972, '\p{^Age=v52}', "");
Expect(0, 177972, '\P{Age=v52}', "");
Expect(1, 177972, '\P{^Age=v52}', "");
Expect(0, 177973, '\p{Age=v52}', "");
Expect(1, 177973, '\p{^Age=v52}', "");
Expect(1, 177973, '\P{Age=v52}', "");
Expect(0, 177973, '\P{^Age=v52}', "");
Expect(1, 177972, '\p{Age=	-V5_2}', "");
Expect(0, 177972, '\p{^Age=	-V5_2}', "");
Expect(0, 177972, '\P{Age=	-V5_2}', "");
Expect(1, 177972, '\P{^Age=	-V5_2}', "");
Expect(0, 177973, '\p{Age=	-V5_2}', "");
Expect(1, 177973, '\p{^Age=	-V5_2}', "");
Expect(1, 177973, '\P{Age=	-V5_2}', "");
Expect(0, 177973, '\P{^Age=	-V5_2}', "");
Error('\p{Is_Age=:=_-0000000005.2}');
Error('\P{Is_Age=:=_-0000000005.2}');
Expect(1, 177972, '\p{Is_Age=005.2}', "");
Expect(0, 177972, '\p{^Is_Age=005.2}', "");
Expect(0, 177972, '\P{Is_Age=005.2}', "");
Expect(1, 177972, '\P{^Is_Age=005.2}', "");
Expect(0, 177973, '\p{Is_Age=005.2}', "");
Expect(1, 177973, '\p{^Is_Age=005.2}', "");
Expect(1, 177973, '\P{Is_Age=005.2}', "");
Expect(0, 177973, '\P{^Is_Age=005.2}', "");
Error('\p{Age= -V6_0/a/}');
Error('\P{Age= -V6_0/a/}');
Expect(1, 178205, '\p{Age=v60}', "");
Expect(0, 178205, '\p{^Age=v60}', "");
Expect(0, 178205, '\P{Age=v60}', "");
Expect(1, 178205, '\P{^Age=v60}', "");
Expect(0, 178206, '\p{Age=v60}', "");
Expect(1, 178206, '\p{^Age=v60}', "");
Expect(1, 178206, '\P{Age=v60}', "");
Expect(0, 178206, '\P{^Age=v60}', "");
Expect(1, 178205, '\p{Age=--V6_0}', "");
Expect(0, 178205, '\p{^Age=--V6_0}', "");
Expect(0, 178205, '\P{Age=--V6_0}', "");
Expect(1, 178205, '\P{^Age=--V6_0}', "");
Expect(0, 178206, '\p{Age=--V6_0}', "");
Expect(1, 178206, '\p{^Age=--V6_0}', "");
Expect(1, 178206, '\P{Age=--V6_0}', "");
Expect(0, 178206, '\P{^Age=--V6_0}', "");
Error('\p{Is_Age= _6.0:=}');
Error('\P{Is_Age= _6.0:=}');
Expect(1, 178205, '\p{Is_Age=+06.0}', "");
Expect(0, 178205, '\p{^Is_Age=+06.0}', "");
Expect(0, 178205, '\P{Is_Age=+06.0}', "");
Expect(1, 178205, '\P{^Is_Age=+06.0}', "");
Expect(0, 178206, '\p{Is_Age=+06.0}', "");
Expect(1, 178206, '\p{^Is_Age=+06.0}', "");
Expect(1, 178206, '\P{Is_Age=+06.0}', "");
Expect(0, 178206, '\P{^Is_Age=+06.0}', "");
Error('\p{Age:	:=V6_1}');
Error('\P{Age:	:=V6_1}');
Expect(1, 128564, '\p{Age=v61}', "");
Expect(0, 128564, '\p{^Age=v61}', "");
Expect(0, 128564, '\P{Age=v61}', "");
Expect(1, 128564, '\P{^Age=v61}', "");
Expect(0, 128565, '\p{Age=v61}', "");
Expect(1, 128565, '\p{^Age=v61}', "");
Expect(1, 128565, '\P{Age=v61}', "");
Expect(0, 128565, '\P{^Age=v61}', "");
Expect(1, 128564, '\p{Age= _v6_1}', "");
Expect(0, 128564, '\p{^Age= _v6_1}', "");
Expect(0, 128564, '\P{Age= _v6_1}', "");
Expect(1, 128564, '\P{^Age= _v6_1}', "");
Expect(0, 128565, '\p{Age= _v6_1}', "");
Expect(1, 128565, '\p{^Age= _v6_1}', "");
Expect(1, 128565, '\P{Age= _v6_1}', "");
Expect(0, 128565, '\P{^Age= _v6_1}', "");
Error('\p{Is_Age=	 6.1/a/}');
Error('\P{Is_Age=	 6.1/a/}');
Expect(1, 128564, '\p{Is_Age=+000_6.1}', "");
Expect(0, 128564, '\p{^Is_Age=+000_6.1}', "");
Expect(0, 128564, '\P{Is_Age=+000_6.1}', "");
Expect(1, 128564, '\P{^Is_Age=+000_6.1}', "");
Expect(0, 128565, '\p{Is_Age=+000_6.1}', "");
Expect(1, 128565, '\p{^Is_Age=+000_6.1}', "");
Expect(1, 128565, '\P{Is_Age=+000_6.1}', "");
Expect(0, 128565, '\P{^Is_Age=+000_6.1}', "");
Error('\p{Age=:=- V6_2}');
Error('\P{Age=:=- V6_2}');
Expect(1, 8378, '\p{Age=v62}', "");
Expect(0, 8378, '\p{^Age=v62}', "");
Expect(0, 8378, '\P{Age=v62}', "");
Expect(1, 8378, '\P{^Age=v62}', "");
Expect(0, 8379, '\p{Age=v62}', "");
Expect(1, 8379, '\p{^Age=v62}', "");
Expect(1, 8379, '\P{Age=v62}', "");
Expect(0, 8379, '\P{^Age=v62}', "");
Expect(1, 8378, '\p{Age=	_V6_2}', "");
Expect(0, 8378, '\p{^Age=	_V6_2}', "");
Expect(0, 8378, '\P{Age=	_V6_2}', "");
Expect(1, 8378, '\P{^Age=	_V6_2}', "");
Expect(0, 8379, '\p{Age=	_V6_2}', "");
Expect(1, 8379, '\p{^Age=	_V6_2}', "");
Expect(1, 8379, '\P{Age=	_V6_2}', "");
Expect(0, 8379, '\P{^Age=	_V6_2}', "");
Error('\p{Is_Age=__+0_0_0_06.2/a/}');
Error('\P{Is_Age=__+0_0_0_06.2/a/}');
Expect(1, 8378, '\p{Is_Age=+0_0_0_06.2}', "");
Expect(0, 8378, '\p{^Is_Age=+0_0_0_06.2}', "");
Expect(0, 8378, '\P{Is_Age=+0_0_0_06.2}', "");
Expect(1, 8378, '\P{^Is_Age=+0_0_0_06.2}', "");
Expect(0, 8379, '\p{Is_Age=+0_0_0_06.2}', "");
Expect(1, 8379, '\p{^Is_Age=+0_0_0_06.2}', "");
Expect(1, 8379, '\P{Is_Age=+0_0_0_06.2}', "");
Expect(0, 8379, '\P{^Is_Age=+0_0_0_06.2}', "");
Error('\p{Age=-V6_3/a/}');
Error('\P{Age=-V6_3/a/}');
Expect(1, 8297, '\p{Age=v63}', "");
Expect(0, 8297, '\p{^Age=v63}', "");
Expect(0, 8297, '\P{Age=v63}', "");
Expect(1, 8297, '\P{^Age=v63}', "");
Expect(0, 8298, '\p{Age=v63}', "");
Expect(1, 8298, '\p{^Age=v63}', "");
Expect(1, 8298, '\P{Age=v63}', "");
Expect(0, 8298, '\P{^Age=v63}', "");
Expect(1, 8297, '\p{Age=V6_3}', "");
Expect(0, 8297, '\p{^Age=V6_3}', "");
Expect(0, 8297, '\P{Age=V6_3}', "");
Expect(1, 8297, '\P{^Age=V6_3}', "");
Expect(0, 8298, '\p{Age=V6_3}', "");
Expect(1, 8298, '\p{^Age=V6_3}', "");
Expect(1, 8298, '\P{Age=V6_3}', "");
Expect(0, 8298, '\P{^Age=V6_3}', "");
Error('\p{Is_Age= _00_6.3/a/}');
Error('\P{Is_Age= _00_6.3/a/}');
Expect(1, 8297, '\p{Is_Age=0_0_06.3}', "");
Expect(0, 8297, '\p{^Is_Age=0_0_06.3}', "");
Expect(0, 8297, '\P{Is_Age=0_0_06.3}', "");
Expect(1, 8297, '\P{^Is_Age=0_0_06.3}', "");
Expect(0, 8298, '\p{Is_Age=0_0_06.3}', "");
Expect(1, 8298, '\p{^Is_Age=0_0_06.3}', "");
Expect(1, 8298, '\P{Is_Age=0_0_06.3}', "");
Expect(0, 8298, '\P{^Is_Age=0_0_06.3}', "");
Error('\p{Age= /a/v7_0}');
Error('\P{Age= /a/v7_0}');
Expect(1, 129197, '\p{Age=v70}', "");
Expect(0, 129197, '\p{^Age=v70}', "");
Expect(0, 129197, '\P{Age=v70}', "");
Expect(1, 129197, '\P{^Age=v70}', "");
Expect(0, 129198, '\p{Age=v70}', "");
Expect(1, 129198, '\p{^Age=v70}', "");
Expect(1, 129198, '\P{Age=v70}', "");
Expect(0, 129198, '\P{^Age=v70}', "");
Expect(1, 129197, '\p{Age= 	V7_0}', "");
Expect(0, 129197, '\p{^Age= 	V7_0}', "");
Expect(0, 129197, '\P{Age= 	V7_0}', "");
Expect(1, 129197, '\P{^Age= 	V7_0}', "");
Expect(0, 129198, '\p{Age= 	V7_0}', "");
Expect(1, 129198, '\p{^Age= 	V7_0}', "");
Expect(1, 129198, '\P{Age= 	V7_0}', "");
Expect(0, 129198, '\P{^Age= 	V7_0}', "");
Error('\p{Is_Age=	:=0_0_0_07.0}');
Error('\P{Is_Age=	:=0_0_0_07.0}');
Expect(1, 129197, '\p{Is_Age=00_7.0}', "");
Expect(0, 129197, '\p{^Is_Age=00_7.0}', "");
Expect(0, 129197, '\P{Is_Age=00_7.0}', "");
Expect(1, 129197, '\P{^Is_Age=00_7.0}', "");
Expect(0, 129198, '\p{Is_Age=00_7.0}', "");
Expect(1, 129198, '\p{^Is_Age=00_7.0}', "");
Expect(1, 129198, '\P{Is_Age=00_7.0}', "");
Expect(0, 129198, '\P{^Is_Age=00_7.0}', "");
Error('\p{Age=:=_-V8_0}');
Error('\P{Age=:=_-V8_0}');
Expect(1, 183969, '\p{Age=v80}', "");
Expect(0, 183969, '\p{^Age=v80}', "");
Expect(0, 183969, '\P{Age=v80}', "");
Expect(1, 183969, '\P{^Age=v80}', "");
Expect(0, 183970, '\p{Age=v80}', "");
Expect(1, 183970, '\p{^Age=v80}', "");
Expect(1, 183970, '\P{Age=v80}', "");
Expect(0, 183970, '\P{^Age=v80}', "");
Expect(1, 183969, '\p{Age=-_V8_0}', "");
Expect(0, 183969, '\p{^Age=-_V8_0}', "");
Expect(0, 183969, '\P{Age=-_V8_0}', "");
Expect(1, 183969, '\P{^Age=-_V8_0}', "");
Expect(0, 183970, '\p{Age=-_V8_0}', "");
Expect(1, 183970, '\p{^Age=-_V8_0}', "");
Expect(1, 183970, '\P{Age=-_V8_0}', "");
Expect(0, 183970, '\P{^Age=-_V8_0}', "");
Error('\p{Is_Age=:=--00_8.0}');
Error('\P{Is_Age=:=--00_8.0}');
Expect(1, 183969, '\p{Is_Age=+00_8.0}', "");
Expect(0, 183969, '\p{^Is_Age=+00_8.0}', "");
Expect(0, 183969, '\P{Is_Age=+00_8.0}', "");
Expect(1, 183969, '\P{^Is_Age=+00_8.0}', "");
Expect(0, 183970, '\p{Is_Age=+00_8.0}', "");
Expect(1, 183970, '\p{^Is_Age=+00_8.0}', "");
Expect(1, 183970, '\P{Is_Age=+00_8.0}', "");
Expect(0, 183970, '\P{^Is_Age=+00_8.0}', "");
Error('\p{Age=_:=UNASSIGNED}');
Error('\P{Age=_:=UNASSIGNED}');
Expect(1, 983037, '\p{Age=unassigned}', "");
Expect(0, 983037, '\p{^Age=unassigned}', "");
Expect(0, 983037, '\P{Age=unassigned}', "");
Expect(1, 983037, '\P{^Age=unassigned}', "");
Expect(0, 983040, '\p{Age=unassigned}', "");
Expect(1, 983040, '\p{^Age=unassigned}', "");
Expect(1, 983040, '\P{Age=unassigned}', "");
Expect(0, 983040, '\P{^Age=unassigned}', "");
Expect(1, 983037, '\p{Age=		unassigned}', "");
Expect(0, 983037, '\p{^Age=		unassigned}', "");
Expect(0, 983037, '\P{Age=		unassigned}', "");
Expect(1, 983037, '\P{^Age=		unassigned}', "");
Expect(0, 983040, '\p{Age=		unassigned}', "");
Expect(1, 983040, '\p{^Age=		unassigned}', "");
Expect(1, 983040, '\P{Age=		unassigned}', "");
Expect(0, 983040, '\P{^Age=		unassigned}', "");
Error('\p{Is_Age=:=--na}');
Error('\P{Is_Age=:=--na}');
Expect(1, 983037, '\p{Is_Age=na}', "");
Expect(0, 983037, '\p{^Is_Age=na}', "");
Expect(0, 983037, '\P{Is_Age=na}', "");
Expect(1, 983037, '\P{^Is_Age=na}', "");
Expect(0, 983040, '\p{Is_Age=na}', "");
Expect(1, 983040, '\p{^Is_Age=na}', "");
Expect(1, 983040, '\P{Is_Age=na}', "");
Expect(0, 983040, '\P{^Is_Age=na}', "");
Expect(1, 983037, '\p{Is_Age=  NA}', "");
Expect(0, 983037, '\p{^Is_Age=  NA}', "");
Expect(0, 983037, '\P{Is_Age=  NA}', "");
Expect(1, 983037, '\P{^Is_Age=  NA}', "");
Expect(0, 983040, '\p{Is_Age=  NA}', "");
Expect(1, 983040, '\p{^Is_Age=  NA}', "");
Expect(1, 983040, '\P{Is_Age=  NA}', "");
Expect(0, 983040, '\P{^Is_Age=  NA}', "");
Error('\p{Bidi_Class: -ARABIC_letter:=}');
Error('\P{Bidi_Class: -ARABIC_letter:=}');
Expect(1, 126719, '\p{Bidi_Class=arabicletter}', "");
Expect(0, 126719, '\p{^Bidi_Class=arabicletter}', "");
Expect(0, 126719, '\P{Bidi_Class=arabicletter}', "");
Expect(1, 126719, '\P{^Bidi_Class=arabicletter}', "");
Expect(0, 126720, '\p{Bidi_Class=arabicletter}', "");
Expect(1, 126720, '\p{^Bidi_Class=arabicletter}', "");
Expect(1, 126720, '\P{Bidi_Class=arabicletter}', "");
Expect(0, 126720, '\P{^Bidi_Class=arabicletter}', "");
Expect(1, 126719, '\p{Bidi_Class=  arabic_Letter}', "");
Expect(0, 126719, '\p{^Bidi_Class=  arabic_Letter}', "");
Expect(0, 126719, '\P{Bidi_Class=  arabic_Letter}', "");
Expect(1, 126719, '\P{^Bidi_Class=  arabic_Letter}', "");
Expect(0, 126720, '\p{Bidi_Class=  arabic_Letter}', "");
Expect(1, 126720, '\p{^Bidi_Class=  arabic_Letter}', "");
Expect(1, 126720, '\P{Bidi_Class=  arabic_Letter}', "");
Expect(0, 126720, '\P{^Bidi_Class=  arabic_Letter}', "");
Error('\p{Bc=	_AL/a/}');
Error('\P{Bc=	_AL/a/}');
Expect(1, 126719, '\p{Bc=al}', "");
Expect(0, 126719, '\p{^Bc=al}', "");
Expect(0, 126719, '\P{Bc=al}', "");
Expect(1, 126719, '\P{^Bc=al}', "");
Expect(0, 126720, '\p{Bc=al}', "");
Expect(1, 126720, '\p{^Bc=al}', "");
Expect(1, 126720, '\P{Bc=al}', "");
Expect(0, 126720, '\P{^Bc=al}', "");
Expect(1, 126719, '\p{Bc=		al}', "");
Expect(0, 126719, '\p{^Bc=		al}', "");
Expect(0, 126719, '\P{Bc=		al}', "");
Expect(1, 126719, '\P{^Bc=		al}', "");
Expect(0, 126720, '\p{Bc=		al}', "");
Expect(1, 126720, '\p{^Bc=		al}', "");
Expect(1, 126720, '\P{Bc=		al}', "");
Expect(0, 126720, '\P{^Bc=		al}', "");
Error('\p{Is_Bidi_Class:    /a/Arabic_LETTER}');
Error('\P{Is_Bidi_Class:    /a/Arabic_LETTER}');
Expect(1, 126719, '\p{Is_Bidi_Class:	arabicletter}', "");
Expect(0, 126719, '\p{^Is_Bidi_Class:	arabicletter}', "");
Expect(0, 126719, '\P{Is_Bidi_Class:	arabicletter}', "");
Expect(1, 126719, '\P{^Is_Bidi_Class:	arabicletter}', "");
Expect(0, 126720, '\p{Is_Bidi_Class:	arabicletter}', "");
Expect(1, 126720, '\p{^Is_Bidi_Class:	arabicletter}', "");
Expect(1, 126720, '\P{Is_Bidi_Class:	arabicletter}', "");
Expect(0, 126720, '\P{^Is_Bidi_Class:	arabicletter}', "");
Expect(1, 126719, '\p{Is_Bidi_Class:	 	ARABIC_LETTER}', "");
Expect(0, 126719, '\p{^Is_Bidi_Class:	 	ARABIC_LETTER}', "");
Expect(0, 126719, '\P{Is_Bidi_Class:	 	ARABIC_LETTER}', "");
Expect(1, 126719, '\P{^Is_Bidi_Class:	 	ARABIC_LETTER}', "");
Expect(0, 126720, '\p{Is_Bidi_Class:	 	ARABIC_LETTER}', "");
Expect(1, 126720, '\p{^Is_Bidi_Class:	 	ARABIC_LETTER}', "");
Expect(1, 126720, '\P{Is_Bidi_Class:	 	ARABIC_LETTER}', "");
Expect(0, 126720, '\P{^Is_Bidi_Class:	 	ARABIC_LETTER}', "");
Error('\p{Is_Bc=/a/ AL}');
Error('\P{Is_Bc=/a/ AL}');
Expect(1, 126719, '\p{Is_Bc=al}', "");
Expect(0, 126719, '\p{^Is_Bc=al}', "");
Expect(0, 126719, '\P{Is_Bc=al}', "");
Expect(1, 126719, '\P{^Is_Bc=al}', "");
Expect(0, 126720, '\p{Is_Bc=al}', "");
Expect(1, 126720, '\p{^Is_Bc=al}', "");
Expect(1, 126720, '\P{Is_Bc=al}', "");
Expect(0, 126720, '\P{^Is_Bc=al}', "");
Expect(1, 126719, '\p{Is_Bc=-AL}', "");
Expect(0, 126719, '\p{^Is_Bc=-AL}', "");
Expect(0, 126719, '\P{Is_Bc=-AL}', "");
Expect(1, 126719, '\P{^Is_Bc=-AL}', "");
Expect(0, 126720, '\p{Is_Bc=-AL}', "");
Expect(1, 126720, '\p{^Is_Bc=-AL}', "");
Expect(1, 126720, '\P{Is_Bc=-AL}', "");
Expect(0, 126720, '\P{^Is_Bc=-AL}', "");
Error('\p{Bidi_Class:    ARABIC_Number:=}');
Error('\P{Bidi_Class:    ARABIC_Number:=}');
Expect(1, 69246, '\p{Bidi_Class=arabicnumber}', "");
Expect(0, 69246, '\p{^Bidi_Class=arabicnumber}', "");
Expect(0, 69246, '\P{Bidi_Class=arabicnumber}', "");
Expect(1, 69246, '\P{^Bidi_Class=arabicnumber}', "");
Expect(0, 69247, '\p{Bidi_Class=arabicnumber}', "");
Expect(1, 69247, '\p{^Bidi_Class=arabicnumber}', "");
Expect(1, 69247, '\P{Bidi_Class=arabicnumber}', "");
Expect(0, 69247, '\P{^Bidi_Class=arabicnumber}', "");
Expect(1, 69246, '\p{Bidi_Class=	ARABIC_number}', "");
Expect(0, 69246, '\p{^Bidi_Class=	ARABIC_number}', "");
Expect(0, 69246, '\P{Bidi_Class=	ARABIC_number}', "");
Expect(1, 69246, '\P{^Bidi_Class=	ARABIC_number}', "");
Expect(0, 69247, '\p{Bidi_Class=	ARABIC_number}', "");
Expect(1, 69247, '\p{^Bidi_Class=	ARABIC_number}', "");
Expect(1, 69247, '\P{Bidi_Class=	ARABIC_number}', "");
Expect(0, 69247, '\P{^Bidi_Class=	ARABIC_number}', "");
Error('\p{Bc= /a/AN}');
Error('\P{Bc= /a/AN}');
Expect(1, 69246, '\p{Bc=an}', "");
Expect(0, 69246, '\p{^Bc=an}', "");
Expect(0, 69246, '\P{Bc=an}', "");
Expect(1, 69246, '\P{^Bc=an}', "");
Expect(0, 69247, '\p{Bc=an}', "");
Expect(1, 69247, '\p{^Bc=an}', "");
Expect(1, 69247, '\P{Bc=an}', "");
Expect(0, 69247, '\P{^Bc=an}', "");
Expect(1, 69246, '\p{Bc= AN}', "");
Expect(0, 69246, '\p{^Bc= AN}', "");
Expect(0, 69246, '\P{Bc= AN}', "");
Expect(1, 69246, '\P{^Bc= AN}', "");
Expect(0, 69247, '\p{Bc= AN}', "");
Expect(1, 69247, '\p{^Bc= AN}', "");
Expect(1, 69247, '\P{Bc= AN}', "");
Expect(0, 69247, '\P{^Bc= AN}', "");
Error('\p{Is_Bidi_Class=_:=ARABIC_Number}');
Error('\P{Is_Bidi_Class=_:=ARABIC_Number}');
Expect(1, 69246, '\p{Is_Bidi_Class=arabicnumber}', "");
Expect(0, 69246, '\p{^Is_Bidi_Class=arabicnumber}', "");
Expect(0, 69246, '\P{Is_Bidi_Class=arabicnumber}', "");
Expect(1, 69246, '\P{^Is_Bidi_Class=arabicnumber}', "");
Expect(0, 69247, '\p{Is_Bidi_Class=arabicnumber}', "");
Expect(1, 69247, '\p{^Is_Bidi_Class=arabicnumber}', "");
Expect(1, 69247, '\P{Is_Bidi_Class=arabicnumber}', "");
Expect(0, 69247, '\P{^Is_Bidi_Class=arabicnumber}', "");
Expect(1, 69246, '\p{Is_Bidi_Class=		ARABIC_number}', "");
Expect(0, 69246, '\p{^Is_Bidi_Class=		ARABIC_number}', "");
Expect(0, 69246, '\P{Is_Bidi_Class=		ARABIC_number}', "");
Expect(1, 69246, '\P{^Is_Bidi_Class=		ARABIC_number}', "");
Expect(0, 69247, '\p{Is_Bidi_Class=		ARABIC_number}', "");
Expect(1, 69247, '\p{^Is_Bidi_Class=		ARABIC_number}', "");
Expect(1, 69247, '\P{Is_Bidi_Class=		ARABIC_number}', "");
Expect(0, 69247, '\P{^Is_Bidi_Class=		ARABIC_number}', "");
Error('\p{Is_Bc::= 	an}');
Error('\P{Is_Bc::= 	an}');
Expect(1, 69246, '\p{Is_Bc=an}', "");
Expect(0, 69246, '\p{^Is_Bc=an}', "");
Expect(0, 69246, '\P{Is_Bc=an}', "");
Expect(1, 69246, '\P{^Is_Bc=an}', "");
Expect(0, 69247, '\p{Is_Bc=an}', "");
Expect(1, 69247, '\p{^Is_Bc=an}', "");
Expect(1, 69247, '\P{Is_Bc=an}', "");
Expect(0, 69247, '\P{^Is_Bc=an}', "");
Expect(1, 69246, '\p{Is_Bc=_	an}', "");
Expect(0, 69246, '\p{^Is_Bc=_	an}', "");
Expect(0, 69246, '\P{Is_Bc=_	an}', "");
Expect(1, 69246, '\P{^Is_Bc=_	an}', "");
Expect(0, 69247, '\p{Is_Bc=_	an}', "");
Expect(1, 69247, '\p{^Is_Bc=_	an}', "");
Expect(1, 69247, '\P{Is_Bc=_	an}', "");
Expect(0, 69247, '\P{^Is_Bc=_	an}', "");
Error('\p{Bidi_Class=/a/	 paragraph_Separator}');
Error('\P{Bidi_Class=/a/	 paragraph_Separator}');
Expect(1, 8233, '\p{Bidi_Class=paragraphseparator}', "");
Expect(0, 8233, '\p{^Bidi_Class=paragraphseparator}', "");
Expect(0, 8233, '\P{Bidi_Class=paragraphseparator}', "");
Expect(1, 8233, '\P{^Bidi_Class=paragraphseparator}', "");
Expect(0, 8234, '\p{Bidi_Class=paragraphseparator}', "");
Expect(1, 8234, '\p{^Bidi_Class=paragraphseparator}', "");
Expect(1, 8234, '\P{Bidi_Class=paragraphseparator}', "");
Expect(0, 8234, '\P{^Bidi_Class=paragraphseparator}', "");
Expect(1, 8233, '\p{Bidi_Class= PARAGRAPH_SEPARATOR}', "");
Expect(0, 8233, '\p{^Bidi_Class= PARAGRAPH_SEPARATOR}', "");
Expect(0, 8233, '\P{Bidi_Class= PARAGRAPH_SEPARATOR}', "");
Expect(1, 8233, '\P{^Bidi_Class= PARAGRAPH_SEPARATOR}', "");
Expect(0, 8234, '\p{Bidi_Class= PARAGRAPH_SEPARATOR}', "");
Expect(1, 8234, '\p{^Bidi_Class= PARAGRAPH_SEPARATOR}', "");
Expect(1, 8234, '\P{Bidi_Class= PARAGRAPH_SEPARATOR}', "");
Expect(0, 8234, '\P{^Bidi_Class= PARAGRAPH_SEPARATOR}', "");
Error('\p{Bc=/a/ 	B}');
Error('\P{Bc=/a/ 	B}');
Expect(1, 8233, '\p{Bc=b}', "");
Expect(0, 8233, '\p{^Bc=b}', "");
Expect(0, 8233, '\P{Bc=b}', "");
Expect(1, 8233, '\P{^Bc=b}', "");
Expect(0, 8234, '\p{Bc=b}', "");
Expect(1, 8234, '\p{^Bc=b}', "");
Expect(1, 8234, '\P{Bc=b}', "");
Expect(0, 8234, '\P{^Bc=b}', "");
Expect(1, 8233, '\p{Bc=  b}', "");
Expect(0, 8233, '\p{^Bc=  b}', "");
Expect(0, 8233, '\P{Bc=  b}', "");
Expect(1, 8233, '\P{^Bc=  b}', "");
Expect(0, 8234, '\p{Bc=  b}', "");
Expect(1, 8234, '\p{^Bc=  b}', "");
Expect(1, 8234, '\P{Bc=  b}', "");
Expect(0, 8234, '\P{^Bc=  b}', "");
Error('\p{Is_Bidi_Class=	-paragraph_Separator:=}');
Error('\P{Is_Bidi_Class=	-paragraph_Separator:=}');
Expect(1, 8233, '\p{Is_Bidi_Class=paragraphseparator}', "");
Expect(0, 8233, '\p{^Is_Bidi_Class=paragraphseparator}', "");
Expect(0, 8233, '\P{Is_Bidi_Class=paragraphseparator}', "");
Expect(1, 8233, '\P{^Is_Bidi_Class=paragraphseparator}', "");
Expect(0, 8234, '\p{Is_Bidi_Class=paragraphseparator}', "");
Expect(1, 8234, '\p{^Is_Bidi_Class=paragraphseparator}', "");
Expect(1, 8234, '\P{Is_Bidi_Class=paragraphseparator}', "");
Expect(0, 8234, '\P{^Is_Bidi_Class=paragraphseparator}', "");
Expect(1, 8233, '\p{Is_Bidi_Class=	paragraph_separator}', "");
Expect(0, 8233, '\p{^Is_Bidi_Class=	paragraph_separator}', "");
Expect(0, 8233, '\P{Is_Bidi_Class=	paragraph_separator}', "");
Expect(1, 8233, '\P{^Is_Bidi_Class=	paragraph_separator}', "");
Expect(0, 8234, '\p{Is_Bidi_Class=	paragraph_separator}', "");
Expect(1, 8234, '\p{^Is_Bidi_Class=	paragraph_separator}', "");
Expect(1, 8234, '\P{Is_Bidi_Class=	paragraph_separator}', "");
Expect(0, 8234, '\P{^Is_Bidi_Class=	paragraph_separator}', "");
Error('\p{Is_Bc:   	_b/a/}');
Error('\P{Is_Bc:   	_b/a/}');
Expect(1, 8233, '\p{Is_Bc=b}', "");
Expect(0, 8233, '\p{^Is_Bc=b}', "");
Expect(0, 8233, '\P{Is_Bc=b}', "");
Expect(1, 8233, '\P{^Is_Bc=b}', "");
Expect(0, 8234, '\p{Is_Bc=b}', "");
Expect(1, 8234, '\p{^Is_Bc=b}', "");
Expect(1, 8234, '\P{Is_Bc=b}', "");
Expect(0, 8234, '\P{^Is_Bc=b}', "");
Expect(1, 8233, '\p{Is_Bc= -b}', "");
Expect(0, 8233, '\p{^Is_Bc= -b}', "");
Expect(0, 8233, '\P{Is_Bc= -b}', "");
Expect(1, 8233, '\P{^Is_Bc= -b}', "");
Expect(0, 8234, '\p{Is_Bc= -b}', "");
Expect(1, 8234, '\p{^Is_Bc= -b}', "");
Expect(1, 8234, '\P{Is_Bc= -b}', "");
Expect(0, 8234, '\P{^Is_Bc= -b}', "");
Error('\p{Bidi_Class= boundary_neutral/a/}');
Error('\P{Bidi_Class= boundary_neutral/a/}');
Expect(1, 921599, '\p{Bidi_Class=boundaryneutral}', "");
Expect(0, 921599, '\p{^Bidi_Class=boundaryneutral}', "");
Expect(0, 921599, '\P{Bidi_Class=boundaryneutral}', "");
Expect(1, 921599, '\P{^Bidi_Class=boundaryneutral}', "");
Expect(0, 1114109, '\p{Bidi_Class=boundaryneutral}', "");
Expect(1, 1114109, '\p{^Bidi_Class=boundaryneutral}', "");
Expect(1, 1114109, '\P{Bidi_Class=boundaryneutral}', "");
Expect(0, 1114109, '\P{^Bidi_Class=boundaryneutral}', "");
Expect(1, 921599, '\p{Bidi_Class: 	-Boundary_NEUTRAL}', "");
Expect(0, 921599, '\p{^Bidi_Class: 	-Boundary_NEUTRAL}', "");
Expect(0, 921599, '\P{Bidi_Class: 	-Boundary_NEUTRAL}', "");
Expect(1, 921599, '\P{^Bidi_Class: 	-Boundary_NEUTRAL}', "");
Expect(0, 1114109, '\p{Bidi_Class: 	-Boundary_NEUTRAL}', "");
Expect(1, 1114109, '\p{^Bidi_Class: 	-Boundary_NEUTRAL}', "");
Expect(1, 1114109, '\P{Bidi_Class: 	-Boundary_NEUTRAL}', "");
Expect(0, 1114109, '\P{^Bidi_Class: 	-Boundary_NEUTRAL}', "");
Error('\p{Bc=/a/_bn}');
Error('\P{Bc=/a/_bn}');
Expect(1, 921599, '\p{Bc=bn}', "");
Expect(0, 921599, '\p{^Bc=bn}', "");
Expect(0, 921599, '\P{Bc=bn}', "");
Expect(1, 921599, '\P{^Bc=bn}', "");
Expect(0, 1114109, '\p{Bc=bn}', "");
Expect(1, 1114109, '\p{^Bc=bn}', "");
Expect(1, 1114109, '\P{Bc=bn}', "");
Expect(0, 1114109, '\P{^Bc=bn}', "");
Expect(1, 921599, '\p{Bc= BN}', "");
Expect(0, 921599, '\p{^Bc= BN}', "");
Expect(0, 921599, '\P{Bc= BN}', "");
Expect(1, 921599, '\P{^Bc= BN}', "");
Expect(0, 1114109, '\p{Bc= BN}', "");
Expect(1, 1114109, '\p{^Bc= BN}', "");
Expect(1, 1114109, '\P{Bc= BN}', "");
Expect(0, 1114109, '\P{^Bc= BN}', "");
Error('\p{Is_Bidi_Class:	/a/__boundary_Neutral}');
Error('\P{Is_Bidi_Class:	/a/__boundary_Neutral}');
Expect(1, 921599, '\p{Is_Bidi_Class:boundaryneutral}', "");
Expect(0, 921599, '\p{^Is_Bidi_Class:boundaryneutral}', "");
Expect(0, 921599, '\P{Is_Bidi_Class:boundaryneutral}', "");
Expect(1, 921599, '\P{^Is_Bidi_Class:boundaryneutral}', "");
Expect(0, 1114109, '\p{Is_Bidi_Class:boundaryneutral}', "");
Expect(1, 1114109, '\p{^Is_Bidi_Class:boundaryneutral}', "");
Expect(1, 1114109, '\P{Is_Bidi_Class:boundaryneutral}', "");
Expect(0, 1114109, '\P{^Is_Bidi_Class:boundaryneutral}', "");
Expect(1, 921599, '\p{Is_Bidi_Class=-Boundary_neutral}', "");
Expect(0, 921599, '\p{^Is_Bidi_Class=-Boundary_neutral}', "");
Expect(0, 921599, '\P{Is_Bidi_Class=-Boundary_neutral}', "");
Expect(1, 921599, '\P{^Is_Bidi_Class=-Boundary_neutral}', "");
Expect(0, 1114109, '\p{Is_Bidi_Class=-Boundary_neutral}', "");
Expect(1, 1114109, '\p{^Is_Bidi_Class=-Boundary_neutral}', "");
Expect(1, 1114109, '\P{Is_Bidi_Class=-Boundary_neutral}', "");
Expect(0, 1114109, '\P{^Is_Bidi_Class=-Boundary_neutral}', "");
Error('\p{Is_Bc= /a/BN}');
Error('\P{Is_Bc= /a/BN}');
Expect(1, 921599, '\p{Is_Bc=bn}', "");
Expect(0, 921599, '\p{^Is_Bc=bn}', "");
Expect(0, 921599, '\P{Is_Bc=bn}', "");
Expect(1, 921599, '\P{^Is_Bc=bn}', "");
Expect(0, 1114109, '\p{Is_Bc=bn}', "");
Expect(1, 1114109, '\p{^Is_Bc=bn}', "");
Expect(1, 1114109, '\P{Is_Bc=bn}', "");
Expect(0, 1114109, '\P{^Is_Bc=bn}', "");
Expect(1, 921599, '\p{Is_Bc= -bn}', "");
Expect(0, 921599, '\p{^Is_Bc= -bn}', "");
Expect(0, 921599, '\P{Is_Bc= -bn}', "");
Expect(1, 921599, '\P{^Is_Bc= -bn}', "");
Expect(0, 1114109, '\p{Is_Bc= -bn}', "");
Expect(1, 1114109, '\p{^Is_Bc= -bn}', "");
Expect(1, 1114109, '\P{Is_Bc= -bn}', "");
Expect(0, 1114109, '\P{^Is_Bc= -bn}', "");
Error('\p{Bidi_Class=_/a/COMMON_SEPARATOR}');
Error('\P{Bidi_Class=_/a/COMMON_SEPARATOR}');
Expect(1, 65306, '\p{Bidi_Class=commonseparator}', "");
Expect(0, 65306, '\p{^Bidi_Class=commonseparator}', "");
Expect(0, 65306, '\P{Bidi_Class=commonseparator}', "");
Expect(1, 65306, '\P{^Bidi_Class=commonseparator}', "");
Expect(0, 65307, '\p{Bidi_Class=commonseparator}', "");
Expect(1, 65307, '\p{^Bidi_Class=commonseparator}', "");
Expect(1, 65307, '\P{Bidi_Class=commonseparator}', "");
Expect(0, 65307, '\P{^Bidi_Class=commonseparator}', "");
Expect(1, 65306, '\p{Bidi_Class=_-Common_Separator}', "");
Expect(0, 65306, '\p{^Bidi_Class=_-Common_Separator}', "");
Expect(0, 65306, '\P{Bidi_Class=_-Common_Separator}', "");
Expect(1, 65306, '\P{^Bidi_Class=_-Common_Separator}', "");
Expect(0, 65307, '\p{Bidi_Class=_-Common_Separator}', "");
Expect(1, 65307, '\p{^Bidi_Class=_-Common_Separator}', "");
Expect(1, 65307, '\P{Bidi_Class=_-Common_Separator}', "");
Expect(0, 65307, '\P{^Bidi_Class=_-Common_Separator}', "");
Error('\p{Bc: :=  cs}');
Error('\P{Bc: :=  cs}');
Expect(1, 65306, '\p{Bc=cs}', "");
Expect(0, 65306, '\p{^Bc=cs}', "");
Expect(0, 65306, '\P{Bc=cs}', "");
Expect(1, 65306, '\P{^Bc=cs}', "");
Expect(0, 65307, '\p{Bc=cs}', "");
Expect(1, 65307, '\p{^Bc=cs}', "");
Expect(1, 65307, '\P{Bc=cs}', "");
Expect(0, 65307, '\P{^Bc=cs}', "");
Expect(1, 65306, '\p{Bc=_-CS}', "");
Expect(0, 65306, '\p{^Bc=_-CS}', "");
Expect(0, 65306, '\P{Bc=_-CS}', "");
Expect(1, 65306, '\P{^Bc=_-CS}', "");
Expect(0, 65307, '\p{Bc=_-CS}', "");
Expect(1, 65307, '\p{^Bc=_-CS}', "");
Expect(1, 65307, '\P{Bc=_-CS}', "");
Expect(0, 65307, '\P{^Bc=_-CS}', "");
Error('\p{Is_Bidi_Class=-/a/COMMON_Separator}');
Error('\P{Is_Bidi_Class=-/a/COMMON_Separator}');
Expect(1, 65306, '\p{Is_Bidi_Class=commonseparator}', "");
Expect(0, 65306, '\p{^Is_Bidi_Class=commonseparator}', "");
Expect(0, 65306, '\P{Is_Bidi_Class=commonseparator}', "");
Expect(1, 65306, '\P{^Is_Bidi_Class=commonseparator}', "");
Expect(0, 65307, '\p{Is_Bidi_Class=commonseparator}', "");
Expect(1, 65307, '\p{^Is_Bidi_Class=commonseparator}', "");
Expect(1, 65307, '\P{Is_Bidi_Class=commonseparator}', "");
Expect(0, 65307, '\P{^Is_Bidi_Class=commonseparator}', "");
Expect(1, 65306, '\p{Is_Bidi_Class=__COMMON_separator}', "");
Expect(0, 65306, '\p{^Is_Bidi_Class=__COMMON_separator}', "");
Expect(0, 65306, '\P{Is_Bidi_Class=__COMMON_separator}', "");
Expect(1, 65306, '\P{^Is_Bidi_Class=__COMMON_separator}', "");
Expect(0, 65307, '\p{Is_Bidi_Class=__COMMON_separator}', "");
Expect(1, 65307, '\p{^Is_Bidi_Class=__COMMON_separator}', "");
Expect(1, 65307, '\P{Is_Bidi_Class=__COMMON_separator}', "");
Expect(0, 65307, '\P{^Is_Bidi_Class=__COMMON_separator}', "");
Error('\p{Is_Bc=/a/	cs}');
Error('\P{Is_Bc=/a/	cs}');
Expect(1, 65306, '\p{Is_Bc=cs}', "");
Expect(0, 65306, '\p{^Is_Bc=cs}', "");
Expect(0, 65306, '\P{Is_Bc=cs}', "");
Expect(1, 65306, '\P{^Is_Bc=cs}', "");
Expect(0, 65307, '\p{Is_Bc=cs}', "");
Expect(1, 65307, '\p{^Is_Bc=cs}', "");
Expect(1, 65307, '\P{Is_Bc=cs}', "");
Expect(0, 65307, '\P{^Is_Bc=cs}', "");
Error('\p{Bidi_Class= 	EUROPEAN_NUMBER:=}');
Error('\P{Bidi_Class= 	EUROPEAN_NUMBER:=}');
Expect(1, 127242, '\p{Bidi_Class:europeannumber}', "");
Expect(0, 127242, '\p{^Bidi_Class:europeannumber}', "");
Expect(0, 127242, '\P{Bidi_Class:europeannumber}', "");
Expect(1, 127242, '\P{^Bidi_Class:europeannumber}', "");
Expect(0, 127243, '\p{Bidi_Class:europeannumber}', "");
Expect(1, 127243, '\p{^Bidi_Class:europeannumber}', "");
Expect(1, 127243, '\P{Bidi_Class:europeannumber}', "");
Expect(0, 127243, '\P{^Bidi_Class:europeannumber}', "");
Expect(1, 127242, '\p{Bidi_Class=  European_Number}', "");
Expect(0, 127242, '\p{^Bidi_Class=  European_Number}', "");
Expect(0, 127242, '\P{Bidi_Class=  European_Number}', "");
Expect(1, 127242, '\P{^Bidi_Class=  European_Number}', "");
Expect(0, 127243, '\p{Bidi_Class=  European_Number}', "");
Expect(1, 127243, '\p{^Bidi_Class=  European_Number}', "");
Expect(1, 127243, '\P{Bidi_Class=  European_Number}', "");
Expect(0, 127243, '\P{^Bidi_Class=  European_Number}', "");
Error('\p{Bc=_-EN:=}');
Error('\P{Bc=_-EN:=}');
Expect(1, 127242, '\p{Bc=en}', "");
Expect(0, 127242, '\p{^Bc=en}', "");
Expect(0, 127242, '\P{Bc=en}', "");
Expect(1, 127242, '\P{^Bc=en}', "");
Expect(0, 127243, '\p{Bc=en}', "");
Expect(1, 127243, '\p{^Bc=en}', "");
Expect(1, 127243, '\P{Bc=en}', "");
Expect(0, 127243, '\P{^Bc=en}', "");
Expect(1, 127242, '\p{Bc:_en}', "");
Expect(0, 127242, '\p{^Bc:_en}', "");
Expect(0, 127242, '\P{Bc:_en}', "");
Expect(1, 127242, '\P{^Bc:_en}', "");
Expect(0, 127243, '\p{Bc:_en}', "");
Expect(1, 127243, '\p{^Bc:_en}', "");
Expect(1, 127243, '\P{Bc:_en}', "");
Expect(0, 127243, '\P{^Bc:_en}', "");
Error('\p{Is_Bidi_Class= European_Number/a/}');
Error('\P{Is_Bidi_Class= European_Number/a/}');
Expect(1, 127242, '\p{Is_Bidi_Class=europeannumber}', "");
Expect(0, 127242, '\p{^Is_Bidi_Class=europeannumber}', "");
Expect(0, 127242, '\P{Is_Bidi_Class=europeannumber}', "");
Expect(1, 127242, '\P{^Is_Bidi_Class=europeannumber}', "");
Expect(0, 127243, '\p{Is_Bidi_Class=europeannumber}', "");
Expect(1, 127243, '\p{^Is_Bidi_Class=europeannumber}', "");
Expect(1, 127243, '\P{Is_Bidi_Class=europeannumber}', "");
Expect(0, 127243, '\P{^Is_Bidi_Class=europeannumber}', "");
Expect(1, 127242, '\p{Is_Bidi_Class=_ EUROPEAN_NUMBER}', "");
Expect(0, 127242, '\p{^Is_Bidi_Class=_ EUROPEAN_NUMBER}', "");
Expect(0, 127242, '\P{Is_Bidi_Class=_ EUROPEAN_NUMBER}', "");
Expect(1, 127242, '\P{^Is_Bidi_Class=_ EUROPEAN_NUMBER}', "");
Expect(0, 127243, '\p{Is_Bidi_Class=_ EUROPEAN_NUMBER}', "");
Expect(1, 127243, '\p{^Is_Bidi_Class=_ EUROPEAN_NUMBER}', "");
Expect(1, 127243, '\P{Is_Bidi_Class=_ EUROPEAN_NUMBER}', "");
Expect(0, 127243, '\P{^Is_Bidi_Class=_ EUROPEAN_NUMBER}', "");
Error('\p{Is_Bc=-/a/EN}');
Error('\P{Is_Bc=-/a/EN}');
Expect(1, 127242, '\p{Is_Bc=en}', "");
Expect(0, 127242, '\p{^Is_Bc=en}', "");
Expect(0, 127242, '\P{Is_Bc=en}', "");
Expect(1, 127242, '\P{^Is_Bc=en}', "");
Expect(0, 127243, '\p{Is_Bc=en}', "");
Expect(1, 127243, '\p{^Is_Bc=en}', "");
Expect(1, 127243, '\P{Is_Bc=en}', "");
Expect(0, 127243, '\P{^Is_Bc=en}', "");
Expect(1, 127242, '\p{Is_Bc:_	en}', "");
Expect(0, 127242, '\p{^Is_Bc:_	en}', "");
Expect(0, 127242, '\P{Is_Bc:_	en}', "");
Expect(1, 127242, '\P{^Is_Bc:_	en}', "");
Expect(0, 127243, '\p{Is_Bc:_	en}', "");
Expect(1, 127243, '\p{^Is_Bc:_	en}', "");
Expect(1, 127243, '\P{Is_Bc:_	en}', "");
Expect(0, 127243, '\P{^Is_Bc:_	en}', "");
Error('\p{Bidi_Class=_European_Separator:=}');
Error('\P{Bidi_Class=_European_Separator:=}');
Expect(1, 65293, '\p{Bidi_Class=europeanseparator}', "");
Expect(0, 65293, '\p{^Bidi_Class=europeanseparator}', "");
Expect(0, 65293, '\P{Bidi_Class=europeanseparator}', "");
Expect(1, 65293, '\P{^Bidi_Class=europeanseparator}', "");
Expect(0, 65294, '\p{Bidi_Class=europeanseparator}', "");
Expect(1, 65294, '\p{^Bidi_Class=europeanseparator}', "");
Expect(1, 65294, '\P{Bidi_Class=europeanseparator}', "");
Expect(0, 65294, '\P{^Bidi_Class=europeanseparator}', "");
Expect(1, 65293, '\p{Bidi_Class=-_European_Separator}', "");
Expect(0, 65293, '\p{^Bidi_Class=-_European_Separator}', "");
Expect(0, 65293, '\P{Bidi_Class=-_European_Separator}', "");
Expect(1, 65293, '\P{^Bidi_Class=-_European_Separator}', "");
Expect(0, 65294, '\p{Bidi_Class=-_European_Separator}', "");
Expect(1, 65294, '\p{^Bidi_Class=-_European_Separator}', "");
Expect(1, 65294, '\P{Bidi_Class=-_European_Separator}', "");
Expect(0, 65294, '\P{^Bidi_Class=-_European_Separator}', "");
Error('\p{Bc=:=	_ES}');
Error('\P{Bc=:=	_ES}');
Expect(1, 65293, '\p{Bc=es}', "");
Expect(0, 65293, '\p{^Bc=es}', "");
Expect(0, 65293, '\P{Bc=es}', "");
Expect(1, 65293, '\P{^Bc=es}', "");
Expect(0, 65294, '\p{Bc=es}', "");
Expect(1, 65294, '\p{^Bc=es}', "");
Expect(1, 65294, '\P{Bc=es}', "");
Expect(0, 65294, '\P{^Bc=es}', "");
Expect(1, 65293, '\p{Bc=-	ES}', "");
Expect(0, 65293, '\p{^Bc=-	ES}', "");
Expect(0, 65293, '\P{Bc=-	ES}', "");
Expect(1, 65293, '\P{^Bc=-	ES}', "");
Expect(0, 65294, '\p{Bc=-	ES}', "");
Expect(1, 65294, '\p{^Bc=-	ES}', "");
Expect(1, 65294, '\P{Bc=-	ES}', "");
Expect(0, 65294, '\P{^Bc=-	ES}', "");
Error('\p{Is_Bidi_Class=-	European_Separator:=}');
Error('\P{Is_Bidi_Class=-	European_Separator:=}');
Expect(1, 65293, '\p{Is_Bidi_Class:	europeanseparator}', "");
Expect(0, 65293, '\p{^Is_Bidi_Class:	europeanseparator}', "");
Expect(0, 65293, '\P{Is_Bidi_Class:	europeanseparator}', "");
Expect(1, 65293, '\P{^Is_Bidi_Class:	europeanseparator}', "");
Expect(0, 65294, '\p{Is_Bidi_Class:	europeanseparator}', "");
Expect(1, 65294, '\p{^Is_Bidi_Class:	europeanseparator}', "");
Expect(1, 65294, '\P{Is_Bidi_Class:	europeanseparator}', "");
Expect(0, 65294, '\P{^Is_Bidi_Class:	europeanseparator}', "");
Expect(1, 65293, '\p{Is_Bidi_Class= european_Separator}', "");
Expect(0, 65293, '\p{^Is_Bidi_Class= european_Separator}', "");
Expect(0, 65293, '\P{Is_Bidi_Class= european_Separator}', "");
Expect(1, 65293, '\P{^Is_Bidi_Class= european_Separator}', "");
Expect(0, 65294, '\p{Is_Bidi_Class= european_Separator}', "");
Expect(1, 65294, '\p{^Is_Bidi_Class= european_Separator}', "");
Expect(1, 65294, '\P{Is_Bidi_Class= european_Separator}', "");
Expect(0, 65294, '\P{^Is_Bidi_Class= european_Separator}', "");
Error('\p{Is_Bc:   -_es:=}');
Error('\P{Is_Bc:   -_es:=}');
Expect(1, 65293, '\p{Is_Bc: es}', "");
Expect(0, 65293, '\p{^Is_Bc: es}', "");
Expect(0, 65293, '\P{Is_Bc: es}', "");
Expect(1, 65293, '\P{^Is_Bc: es}', "");
Expect(0, 65294, '\p{Is_Bc: es}', "");
Expect(1, 65294, '\p{^Is_Bc: es}', "");
Expect(1, 65294, '\P{Is_Bc: es}', "");
Expect(0, 65294, '\P{^Is_Bc: es}', "");
Expect(1, 65293, '\p{Is_Bc=_-ES}', "");
Expect(0, 65293, '\p{^Is_Bc=_-ES}', "");
Expect(0, 65293, '\P{Is_Bc=_-ES}', "");
Expect(1, 65293, '\P{^Is_Bc=_-ES}', "");
Expect(0, 65294, '\p{Is_Bc=_-ES}', "");
Expect(1, 65294, '\p{^Is_Bc=_-ES}', "");
Expect(1, 65294, '\P{Is_Bc=_-ES}', "");
Expect(0, 65294, '\P{^Is_Bc=_-ES}', "");
Error('\p{Bidi_Class=_:=European_terminator}');
Error('\P{Bidi_Class=_:=European_terminator}');
Expect(1, 65510, '\p{Bidi_Class=europeanterminator}', "");
Expect(0, 65510, '\p{^Bidi_Class=europeanterminator}', "");
Expect(0, 65510, '\P{Bidi_Class=europeanterminator}', "");
Expect(1, 65510, '\P{^Bidi_Class=europeanterminator}', "");
Expect(0, 65511, '\p{Bidi_Class=europeanterminator}', "");
Expect(1, 65511, '\p{^Bidi_Class=europeanterminator}', "");
Expect(1, 65511, '\P{Bidi_Class=europeanterminator}', "");
Expect(0, 65511, '\P{^Bidi_Class=europeanterminator}', "");
Expect(1, 65510, '\p{Bidi_Class=_	european_Terminator}', "");
Expect(0, 65510, '\p{^Bidi_Class=_	european_Terminator}', "");
Expect(0, 65510, '\P{Bidi_Class=_	european_Terminator}', "");
Expect(1, 65510, '\P{^Bidi_Class=_	european_Terminator}', "");
Expect(0, 65511, '\p{Bidi_Class=_	european_Terminator}', "");
Expect(1, 65511, '\p{^Bidi_Class=_	european_Terminator}', "");
Expect(1, 65511, '\P{Bidi_Class=_	european_Terminator}', "");
Expect(0, 65511, '\P{^Bidi_Class=_	european_Terminator}', "");
Error('\p{Bc=:=-ET}');
Error('\P{Bc=:=-ET}');
Expect(1, 65510, '\p{Bc:	et}', "");
Expect(0, 65510, '\p{^Bc:	et}', "");
Expect(0, 65510, '\P{Bc:	et}', "");
Expect(1, 65510, '\P{^Bc:	et}', "");
Expect(0, 65511, '\p{Bc:	et}', "");
Expect(1, 65511, '\p{^Bc:	et}', "");
Expect(1, 65511, '\P{Bc:	et}', "");
Expect(0, 65511, '\P{^Bc:	et}', "");
Expect(1, 65510, '\p{Bc=-	ET}', "");
Expect(0, 65510, '\p{^Bc=-	ET}', "");
Expect(0, 65510, '\P{Bc=-	ET}', "");
Expect(1, 65510, '\P{^Bc=-	ET}', "");
Expect(0, 65511, '\p{Bc=-	ET}', "");
Expect(1, 65511, '\p{^Bc=-	ET}', "");
Expect(1, 65511, '\P{Bc=-	ET}', "");
Expect(0, 65511, '\P{^Bc=-	ET}', "");
Error('\p{Is_Bidi_Class=- European_Terminator:=}');
Error('\P{Is_Bidi_Class=- European_Terminator:=}');
Expect(1, 65510, '\p{Is_Bidi_Class=europeanterminator}', "");
Expect(0, 65510, '\p{^Is_Bidi_Class=europeanterminator}', "");
Expect(0, 65510, '\P{Is_Bidi_Class=europeanterminator}', "");
Expect(1, 65510, '\P{^Is_Bidi_Class=europeanterminator}', "");
Expect(0, 65511, '\p{Is_Bidi_Class=europeanterminator}', "");
Expect(1, 65511, '\p{^Is_Bidi_Class=europeanterminator}', "");
Expect(1, 65511, '\P{Is_Bidi_Class=europeanterminator}', "");
Expect(0, 65511, '\P{^Is_Bidi_Class=europeanterminator}', "");
Expect(1, 65510, '\p{Is_Bidi_Class=_-European_terminator}', "");
Expect(0, 65510, '\p{^Is_Bidi_Class=_-European_terminator}', "");
Expect(0, 65510, '\P{Is_Bidi_Class=_-European_terminator}', "");
Expect(1, 65510, '\P{^Is_Bidi_Class=_-European_terminator}', "");
Expect(0, 65511, '\p{Is_Bidi_Class=_-European_terminator}', "");
Expect(1, 65511, '\p{^Is_Bidi_Class=_-European_terminator}', "");
Expect(1, 65511, '\P{Is_Bidi_Class=_-European_terminator}', "");
Expect(0, 65511, '\P{^Is_Bidi_Class=_-European_terminator}', "");
Error('\p{Is_Bc=-/a/ET}');
Error('\P{Is_Bc=-/a/ET}');
Expect(1, 65510, '\p{Is_Bc=et}', "");
Expect(0, 65510, '\p{^Is_Bc=et}', "");
Expect(0, 65510, '\P{Is_Bc=et}', "");
Expect(1, 65510, '\P{^Is_Bc=et}', "");
Expect(0, 65511, '\p{Is_Bc=et}', "");
Expect(1, 65511, '\p{^Is_Bc=et}', "");
Expect(1, 65511, '\P{Is_Bc=et}', "");
Expect(0, 65511, '\P{^Is_Bc=et}', "");
Expect(1, 65510, '\p{Is_Bc=_-et}', "");
Expect(0, 65510, '\p{^Is_Bc=_-et}', "");
Expect(0, 65510, '\P{Is_Bc=_-et}', "");
Expect(1, 65510, '\P{^Is_Bc=_-et}', "");
Expect(0, 65511, '\p{Is_Bc=_-et}', "");
Expect(1, 65511, '\p{^Is_Bc=_-et}', "");
Expect(1, 65511, '\P{Is_Bc=_-et}', "");
Expect(0, 65511, '\P{^Is_Bc=_-et}', "");
Error('\p{Bidi_Class=:=	_FIRST_Strong_Isolate}');
Error('\P{Bidi_Class=:=	_FIRST_Strong_Isolate}');
Expect(1, 8296, '\p{Bidi_Class=firststrongisolate}', "");
Expect(0, 8296, '\p{^Bidi_Class=firststrongisolate}', "");
Expect(0, 8296, '\P{Bidi_Class=firststrongisolate}', "");
Expect(1, 8296, '\P{^Bidi_Class=firststrongisolate}', "");
Expect(0, 8297, '\p{Bidi_Class=firststrongisolate}', "");
Expect(1, 8297, '\p{^Bidi_Class=firststrongisolate}', "");
Expect(1, 8297, '\P{Bidi_Class=firststrongisolate}', "");
Expect(0, 8297, '\P{^Bidi_Class=firststrongisolate}', "");
Expect(1, 8296, '\p{Bidi_Class=--first_STRONG_Isolate}', "");
Expect(0, 8296, '\p{^Bidi_Class=--first_STRONG_Isolate}', "");
Expect(0, 8296, '\P{Bidi_Class=--first_STRONG_Isolate}', "");
Expect(1, 8296, '\P{^Bidi_Class=--first_STRONG_Isolate}', "");
Expect(0, 8297, '\p{Bidi_Class=--first_STRONG_Isolate}', "");
Expect(1, 8297, '\p{^Bidi_Class=--first_STRONG_Isolate}', "");
Expect(1, 8297, '\P{Bidi_Class=--first_STRONG_Isolate}', "");
Expect(0, 8297, '\P{^Bidi_Class=--first_STRONG_Isolate}', "");
Error('\p{Bc=	FSI/a/}');
Error('\P{Bc=	FSI/a/}');
Expect(1, 8296, '\p{Bc=fsi}', "");
Expect(0, 8296, '\p{^Bc=fsi}', "");
Expect(0, 8296, '\P{Bc=fsi}', "");
Expect(1, 8296, '\P{^Bc=fsi}', "");
Expect(0, 8297, '\p{Bc=fsi}', "");
Expect(1, 8297, '\p{^Bc=fsi}', "");
Expect(1, 8297, '\P{Bc=fsi}', "");
Expect(0, 8297, '\P{^Bc=fsi}', "");
Expect(1, 8296, '\p{Bc:   -_FSI}', "");
Expect(0, 8296, '\p{^Bc:   -_FSI}', "");
Expect(0, 8296, '\P{Bc:   -_FSI}', "");
Expect(1, 8296, '\P{^Bc:   -_FSI}', "");
Expect(0, 8297, '\p{Bc:   -_FSI}', "");
Expect(1, 8297, '\p{^Bc:   -_FSI}', "");
Expect(1, 8297, '\P{Bc:   -_FSI}', "");
Expect(0, 8297, '\P{^Bc:   -_FSI}', "");
Error('\p{Is_Bidi_Class=/a/-First_STRONG_isolate}');
Error('\P{Is_Bidi_Class=/a/-First_STRONG_isolate}');
Expect(1, 8296, '\p{Is_Bidi_Class=firststrongisolate}', "");
Expect(0, 8296, '\p{^Is_Bidi_Class=firststrongisolate}', "");
Expect(0, 8296, '\P{Is_Bidi_Class=firststrongisolate}', "");
Expect(1, 8296, '\P{^Is_Bidi_Class=firststrongisolate}', "");
Expect(0, 8297, '\p{Is_Bidi_Class=firststrongisolate}', "");
Expect(1, 8297, '\p{^Is_Bidi_Class=firststrongisolate}', "");
Expect(1, 8297, '\P{Is_Bidi_Class=firststrongisolate}', "");
Expect(0, 8297, '\P{^Is_Bidi_Class=firststrongisolate}', "");
Expect(1, 8296, '\p{Is_Bidi_Class=__first_Strong_Isolate}', "");
Expect(0, 8296, '\p{^Is_Bidi_Class=__first_Strong_Isolate}', "");
Expect(0, 8296, '\P{Is_Bidi_Class=__first_Strong_Isolate}', "");
Expect(1, 8296, '\P{^Is_Bidi_Class=__first_Strong_Isolate}', "");
Expect(0, 8297, '\p{Is_Bidi_Class=__first_Strong_Isolate}', "");
Expect(1, 8297, '\p{^Is_Bidi_Class=__first_Strong_Isolate}', "");
Expect(1, 8297, '\P{Is_Bidi_Class=__first_Strong_Isolate}', "");
Expect(0, 8297, '\P{^Is_Bidi_Class=__first_Strong_Isolate}', "");
Error('\p{Is_Bc=	FSI:=}');
Error('\P{Is_Bc=	FSI:=}');
Expect(1, 8296, '\p{Is_Bc=fsi}', "");
Expect(0, 8296, '\p{^Is_Bc=fsi}', "");
Expect(0, 8296, '\P{Is_Bc=fsi}', "");
Expect(1, 8296, '\P{^Is_Bc=fsi}', "");
Expect(0, 8297, '\p{Is_Bc=fsi}', "");
Expect(1, 8297, '\p{^Is_Bc=fsi}', "");
Expect(1, 8297, '\P{Is_Bc=fsi}', "");
Expect(0, 8297, '\P{^Is_Bc=fsi}', "");
Expect(1, 8296, '\p{Is_Bc= _fsi}', "");
Expect(0, 8296, '\p{^Is_Bc= _fsi}', "");
Expect(0, 8296, '\P{Is_Bc= _fsi}', "");
Expect(1, 8296, '\P{^Is_Bc= _fsi}', "");
Expect(0, 8297, '\p{Is_Bc= _fsi}', "");
Expect(1, 8297, '\p{^Is_Bc= _fsi}', "");
Expect(1, 8297, '\P{Is_Bc= _fsi}', "");
Expect(0, 8297, '\P{^Is_Bc= _fsi}', "");
Error('\p{Bidi_Class: 	:=left_to_RIGHT}');
Error('\P{Bidi_Class: 	:=left_to_RIGHT}');
Expect(1, 1114109, '\p{Bidi_Class: lefttoright}', "");
Expect(0, 1114109, '\p{^Bidi_Class: lefttoright}', "");
Expect(0, 1114109, '\P{Bidi_Class: lefttoright}', "");
Expect(1, 1114109, '\P{^Bidi_Class: lefttoright}', "");
Expect(0, 921599, '\p{Bidi_Class: lefttoright}', "");
Expect(1, 921599, '\p{^Bidi_Class: lefttoright}', "");
Expect(1, 921599, '\P{Bidi_Class: lefttoright}', "");
Expect(0, 921599, '\P{^Bidi_Class: lefttoright}', "");
Expect(1, 1114109, '\p{Bidi_Class= _Left_to_Right}', "");
Expect(0, 1114109, '\p{^Bidi_Class= _Left_to_Right}', "");
Expect(0, 1114109, '\P{Bidi_Class= _Left_to_Right}', "");
Expect(1, 1114109, '\P{^Bidi_Class= _Left_to_Right}', "");
Expect(0, 921599, '\p{Bidi_Class= _Left_to_Right}', "");
Expect(1, 921599, '\p{^Bidi_Class= _Left_to_Right}', "");
Expect(1, 921599, '\P{Bidi_Class= _Left_to_Right}', "");
Expect(0, 921599, '\P{^Bidi_Class= _Left_to_Right}', "");
Error('\p{Bc=/a/	_L}');
Error('\P{Bc=/a/	_L}');
Expect(1, 1114109, '\p{Bc=l}', "");
Expect(0, 1114109, '\p{^Bc=l}', "");
Expect(0, 1114109, '\P{Bc=l}', "");
Expect(1, 1114109, '\P{^Bc=l}', "");
Expect(0, 921599, '\p{Bc=l}', "");
Expect(1, 921599, '\p{^Bc=l}', "");
Expect(1, 921599, '\P{Bc=l}', "");
Expect(0, 921599, '\P{^Bc=l}', "");
Expect(1, 1114109, '\p{Bc=		l}', "");
Expect(0, 1114109, '\p{^Bc=		l}', "");
Expect(0, 1114109, '\P{Bc=		l}', "");
Expect(1, 1114109, '\P{^Bc=		l}', "");
Expect(0, 921599, '\p{Bc=		l}', "");
Expect(1, 921599, '\p{^Bc=		l}', "");
Expect(1, 921599, '\P{Bc=		l}', "");
Expect(0, 921599, '\P{^Bc=		l}', "");
Error('\p{Is_Bidi_Class=_Left_to_Right/a/}');
Error('\P{Is_Bidi_Class=_Left_to_Right/a/}');
Expect(1, 1114109, '\p{Is_Bidi_Class:   lefttoright}', "");
Expect(0, 1114109, '\p{^Is_Bidi_Class:   lefttoright}', "");
Expect(0, 1114109, '\P{Is_Bidi_Class:   lefttoright}', "");
Expect(1, 1114109, '\P{^Is_Bidi_Class:   lefttoright}', "");
Expect(0, 921599, '\p{Is_Bidi_Class:   lefttoright}', "");
Expect(1, 921599, '\p{^Is_Bidi_Class:   lefttoright}', "");
Expect(1, 921599, '\P{Is_Bidi_Class:   lefttoright}', "");
Expect(0, 921599, '\P{^Is_Bidi_Class:   lefttoright}', "");
Expect(1, 1114109, '\p{Is_Bidi_Class=-	left_to_RIGHT}', "");
Expect(0, 1114109, '\p{^Is_Bidi_Class=-	left_to_RIGHT}', "");
Expect(0, 1114109, '\P{Is_Bidi_Class=-	left_to_RIGHT}', "");
Expect(1, 1114109, '\P{^Is_Bidi_Class=-	left_to_RIGHT}', "");
Expect(0, 921599, '\p{Is_Bidi_Class=-	left_to_RIGHT}', "");
Expect(1, 921599, '\p{^Is_Bidi_Class=-	left_to_RIGHT}', "");
Expect(1, 921599, '\P{Is_Bidi_Class=-	left_to_RIGHT}', "");
Expect(0, 921599, '\P{^Is_Bidi_Class=-	left_to_RIGHT}', "");
Error('\p{Is_Bc=-_l:=}');
Error('\P{Is_Bc=-_l:=}');
Expect(1, 1114109, '\p{Is_Bc=l}', "");
Expect(0, 1114109, '\p{^Is_Bc=l}', "");
Expect(0, 1114109, '\P{Is_Bc=l}', "");
Expect(1, 1114109, '\P{^Is_Bc=l}', "");
Expect(0, 921599, '\p{Is_Bc=l}', "");
Expect(1, 921599, '\p{^Is_Bc=l}', "");
Expect(1, 921599, '\P{Is_Bc=l}', "");
Expect(0, 921599, '\P{^Is_Bc=l}', "");
Expect(1, 1114109, '\p{Is_Bc=	 l}', "");
Expect(0, 1114109, '\p{^Is_Bc=	 l}', "");
Expect(0, 1114109, '\P{Is_Bc=	 l}', "");
Expect(1, 1114109, '\P{^Is_Bc=	 l}', "");
Expect(0, 921599, '\p{Is_Bc=	 l}', "");
Expect(1, 921599, '\p{^Is_Bc=	 l}', "");
Expect(1, 921599, '\P{Is_Bc=	 l}', "");
Expect(0, 921599, '\P{^Is_Bc=	 l}', "");
Error('\p{Bidi_Class: -Left_To_right_embedding/a/}');
Error('\P{Bidi_Class: -Left_To_right_embedding/a/}');
Expect(1, 8234, '\p{Bidi_Class=lefttorightembedding}', "");
Expect(0, 8234, '\p{^Bidi_Class=lefttorightembedding}', "");
Expect(0, 8234, '\P{Bidi_Class=lefttorightembedding}', "");
Expect(1, 8234, '\P{^Bidi_Class=lefttorightembedding}', "");
Expect(0, 8235, '\p{Bidi_Class=lefttorightembedding}', "");
Expect(1, 8235, '\p{^Bidi_Class=lefttorightembedding}', "");
Expect(1, 8235, '\P{Bidi_Class=lefttorightembedding}', "");
Expect(0, 8235, '\P{^Bidi_Class=lefttorightembedding}', "");
Expect(1, 8234, '\p{Bidi_Class= -Left_TO_Right_embedding}', "");
Expect(0, 8234, '\p{^Bidi_Class= -Left_TO_Right_embedding}', "");
Expect(0, 8234, '\P{Bidi_Class= -Left_TO_Right_embedding}', "");
Expect(1, 8234, '\P{^Bidi_Class= -Left_TO_Right_embedding}', "");
Expect(0, 8235, '\p{Bidi_Class= -Left_TO_Right_embedding}', "");
Expect(1, 8235, '\p{^Bidi_Class= -Left_TO_Right_embedding}', "");
Expect(1, 8235, '\P{Bidi_Class= -Left_TO_Right_embedding}', "");
Expect(0, 8235, '\P{^Bidi_Class= -Left_TO_Right_embedding}', "");
Error('\p{Bc=/a/	LRE}');
Error('\P{Bc=/a/	LRE}');
Expect(1, 8234, '\p{Bc:lre}', "");
Expect(0, 8234, '\p{^Bc:lre}', "");
Expect(0, 8234, '\P{Bc:lre}', "");
Expect(1, 8234, '\P{^Bc:lre}', "");
Expect(0, 8235, '\p{Bc:lre}', "");
Expect(1, 8235, '\p{^Bc:lre}', "");
Expect(1, 8235, '\P{Bc:lre}', "");
Expect(0, 8235, '\P{^Bc:lre}', "");
Expect(1, 8234, '\p{Bc=__LRE}', "");
Expect(0, 8234, '\p{^Bc=__LRE}', "");
Expect(0, 8234, '\P{Bc=__LRE}', "");
Expect(1, 8234, '\P{^Bc=__LRE}', "");
Expect(0, 8235, '\p{Bc=__LRE}', "");
Expect(1, 8235, '\p{^Bc=__LRE}', "");
Expect(1, 8235, '\P{Bc=__LRE}', "");
Expect(0, 8235, '\P{^Bc=__LRE}', "");
Error('\p{Is_Bidi_Class=/a/left_to_right_EMBEDDING}');
Error('\P{Is_Bidi_Class=/a/left_to_right_EMBEDDING}');
Expect(1, 8234, '\p{Is_Bidi_Class=lefttorightembedding}', "");
Expect(0, 8234, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
Expect(0, 8234, '\P{Is_Bidi_Class=lefttorightembedding}', "");
Expect(1, 8234, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
Expect(0, 8235, '\p{Is_Bidi_Class=lefttorightembedding}', "");
Expect(1, 8235, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
Expect(1, 8235, '\P{Is_Bidi_Class=lefttorightembedding}', "");
Expect(0, 8235, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
Expect(1, 8234, '\p{Is_Bidi_Class:   -LEFT_To_Right_Embedding}', "");
Expect(0, 8234, '\p{^Is_Bidi_Class:   -LEFT_To_Right_Embedding}', "");
Expect(0, 8234, '\P{Is_Bidi_Class:   -LEFT_To_Right_Embedding}', "");
Expect(1, 8234, '\P{^Is_Bidi_Class:   -LEFT_To_Right_Embedding}', "");
Expect(0, 8235, '\p{Is_Bidi_Class:   -LEFT_To_Right_Embedding}', "");
Expect(1, 8235, '\p{^Is_Bidi_Class:   -LEFT_To_Right_Embedding}', "");
Expect(1, 8235, '\P{Is_Bidi_Class:   -LEFT_To_Right_Embedding}', "");
Expect(0, 8235, '\P{^Is_Bidi_Class:   -LEFT_To_Right_Embedding}', "");
Error('\p{Is_Bc=:= 	LRE}');
Error('\P{Is_Bc=:= 	LRE}');
Expect(1, 8234, '\p{Is_Bc=lre}', "");
Expect(0, 8234, '\p{^Is_Bc=lre}', "");
Expect(0, 8234, '\P{Is_Bc=lre}', "");
Expect(1, 8234, '\P{^Is_Bc=lre}', "");
Expect(0, 8235, '\p{Is_Bc=lre}', "");
Expect(1, 8235, '\p{^Is_Bc=lre}', "");
Expect(1, 8235, '\P{Is_Bc=lre}', "");
Expect(0, 8235, '\P{^Is_Bc=lre}', "");
Expect(1, 8234, '\p{Is_Bc=-LRE}', "");
Expect(0, 8234, '\p{^Is_Bc=-LRE}', "");
Expect(0, 8234, '\P{Is_Bc=-LRE}', "");
Expect(1, 8234, '\P{^Is_Bc=-LRE}', "");
Expect(0, 8235, '\p{Is_Bc=-LRE}', "");
Expect(1, 8235, '\p{^Is_Bc=-LRE}', "");
Expect(1, 8235, '\P{Is_Bc=-LRE}', "");
Expect(0, 8235, '\P{^Is_Bc=-LRE}', "");
Error('\p{Bidi_Class=__Left_To_Right_Isolate:=}');
Error('\P{Bidi_Class=__Left_To_Right_Isolate:=}');
Expect(1, 8294, '\p{Bidi_Class=lefttorightisolate}', "");
Expect(0, 8294, '\p{^Bidi_Class=lefttorightisolate}', "");
Expect(0, 8294, '\P{Bidi_Class=lefttorightisolate}', "");
Expect(1, 8294, '\P{^Bidi_Class=lefttorightisolate}', "");
Expect(0, 8295, '\p{Bidi_Class=lefttorightisolate}', "");
Expect(1, 8295, '\p{^Bidi_Class=lefttorightisolate}', "");
Expect(1, 8295, '\P{Bidi_Class=lefttorightisolate}', "");
Expect(0, 8295, '\P{^Bidi_Class=lefttorightisolate}', "");
Expect(1, 8294, '\p{Bidi_Class=_ Left_TO_Right_ISOLATE}', "");
Expect(0, 8294, '\p{^Bidi_Class=_ Left_TO_Right_ISOLATE}', "");
Expect(0, 8294, '\P{Bidi_Class=_ Left_TO_Right_ISOLATE}', "");
Expect(1, 8294, '\P{^Bidi_Class=_ Left_TO_Right_ISOLATE}', "");
Expect(0, 8295, '\p{Bidi_Class=_ Left_TO_Right_ISOLATE}', "");
Expect(1, 8295, '\p{^Bidi_Class=_ Left_TO_Right_ISOLATE}', "");
Expect(1, 8295, '\P{Bidi_Class=_ Left_TO_Right_ISOLATE}', "");
Expect(0, 8295, '\P{^Bidi_Class=_ Left_TO_Right_ISOLATE}', "");
Error('\p{Bc=_	lri:=}');
Error('\P{Bc=_	lri:=}');
Expect(1, 8294, '\p{Bc=lri}', "");
Expect(0, 8294, '\p{^Bc=lri}', "");
Expect(0, 8294, '\P{Bc=lri}', "");
Expect(1, 8294, '\P{^Bc=lri}', "");
Expect(0, 8295, '\p{Bc=lri}', "");
Expect(1, 8295, '\p{^Bc=lri}', "");
Expect(1, 8295, '\P{Bc=lri}', "");
Expect(0, 8295, '\P{^Bc=lri}', "");
Expect(1, 8294, '\p{Bc:	_lri}', "");
Expect(0, 8294, '\p{^Bc:	_lri}', "");
Expect(0, 8294, '\P{Bc:	_lri}', "");
Expect(1, 8294, '\P{^Bc:	_lri}', "");
Expect(0, 8295, '\p{Bc:	_lri}', "");
Expect(1, 8295, '\p{^Bc:	_lri}', "");
Expect(1, 8295, '\P{Bc:	_lri}', "");
Expect(0, 8295, '\P{^Bc:	_lri}', "");
Error('\p{Is_Bidi_Class=:=_	left_to_RIGHT_Isolate}');
Error('\P{Is_Bidi_Class=:=_	left_to_RIGHT_Isolate}');
Expect(1, 8294, '\p{Is_Bidi_Class:   lefttorightisolate}', "");
Expect(0, 8294, '\p{^Is_Bidi_Class:   lefttorightisolate}', "");
Expect(0, 8294, '\P{Is_Bidi_Class:   lefttorightisolate}', "");
Expect(1, 8294, '\P{^Is_Bidi_Class:   lefttorightisolate}', "");
Expect(0, 8295, '\p{Is_Bidi_Class:   lefttorightisolate}', "");
Expect(1, 8295, '\p{^Is_Bidi_Class:   lefttorightisolate}', "");
Expect(1, 8295, '\P{Is_Bidi_Class:   lefttorightisolate}', "");
Expect(0, 8295, '\P{^Is_Bidi_Class:   lefttorightisolate}', "");
Expect(1, 8294, '\p{Is_Bidi_Class=	Left_To_RIGHT_Isolate}', "");
Expect(0, 8294, '\p{^Is_Bidi_Class=	Left_To_RIGHT_Isolate}', "");
Expect(0, 8294, '\P{Is_Bidi_Class=	Left_To_RIGHT_Isolate}', "");
Expect(1, 8294, '\P{^Is_Bidi_Class=	Left_To_RIGHT_Isolate}', "");
Expect(0, 8295, '\p{Is_Bidi_Class=	Left_To_RIGHT_Isolate}', "");
Expect(1, 8295, '\p{^Is_Bidi_Class=	Left_To_RIGHT_Isolate}', "");
Expect(1, 8295, '\P{Is_Bidi_Class=	Left_To_RIGHT_Isolate}', "");
Expect(0, 8295, '\P{^Is_Bidi_Class=	Left_To_RIGHT_Isolate}', "");
Error('\p{Is_Bc:	/a/lri}');
Error('\P{Is_Bc:	/a/lri}');
Expect(1, 8294, '\p{Is_Bc=lri}', "");
Expect(0, 8294, '\p{^Is_Bc=lri}', "");
Expect(0, 8294, '\P{Is_Bc=lri}', "");
Expect(1, 8294, '\P{^Is_Bc=lri}', "");
Expect(0, 8295, '\p{Is_Bc=lri}', "");
Expect(1, 8295, '\p{^Is_Bc=lri}', "");
Expect(1, 8295, '\P{Is_Bc=lri}', "");
Expect(0, 8295, '\P{^Is_Bc=lri}', "");
Expect(1, 8294, '\p{Is_Bc=-LRI}', "");
Expect(0, 8294, '\p{^Is_Bc=-LRI}', "");
Expect(0, 8294, '\P{Is_Bc=-LRI}', "");
Expect(1, 8294, '\P{^Is_Bc=-LRI}', "");
Expect(0, 8295, '\p{Is_Bc=-LRI}', "");
Expect(1, 8295, '\p{^Is_Bc=-LRI}', "");
Expect(1, 8295, '\P{Is_Bc=-LRI}', "");
Expect(0, 8295, '\P{^Is_Bc=-LRI}', "");
Error('\p{Bidi_Class= /a/Left_To_right_Override}');
Error('\P{Bidi_Class= /a/Left_To_right_Override}');
Expect(1, 8237, '\p{Bidi_Class=lefttorightoverride}', "");
Expect(0, 8237, '\p{^Bidi_Class=lefttorightoverride}', "");
Expect(0, 8237, '\P{Bidi_Class=lefttorightoverride}', "");
Expect(1, 8237, '\P{^Bidi_Class=lefttorightoverride}', "");
Expect(0, 8238, '\p{Bidi_Class=lefttorightoverride}', "");
Expect(1, 8238, '\p{^Bidi_Class=lefttorightoverride}', "");
Expect(1, 8238, '\P{Bidi_Class=lefttorightoverride}', "");
Expect(0, 8238, '\P{^Bidi_Class=lefttorightoverride}', "");
Expect(1, 8237, '\p{Bidi_Class=		LEFT_TO_Right_Override}', "");
Expect(0, 8237, '\p{^Bidi_Class=		LEFT_TO_Right_Override}', "");
Expect(0, 8237, '\P{Bidi_Class=		LEFT_TO_Right_Override}', "");
Expect(1, 8237, '\P{^Bidi_Class=		LEFT_TO_Right_Override}', "");
Expect(0, 8238, '\p{Bidi_Class=		LEFT_TO_Right_Override}', "");
Expect(1, 8238, '\p{^Bidi_Class=		LEFT_TO_Right_Override}', "");
Expect(1, 8238, '\P{Bidi_Class=		LEFT_TO_Right_Override}', "");
Expect(0, 8238, '\P{^Bidi_Class=		LEFT_TO_Right_Override}', "");
Error('\p{Bc:	/a/_ lro}');
Error('\P{Bc:	/a/_ lro}');
Expect(1, 8237, '\p{Bc=lro}', "");
Expect(0, 8237, '\p{^Bc=lro}', "");
Expect(0, 8237, '\P{Bc=lro}', "");
Expect(1, 8237, '\P{^Bc=lro}', "");
Expect(0, 8238, '\p{Bc=lro}', "");
Expect(1, 8238, '\p{^Bc=lro}', "");
Expect(1, 8238, '\P{Bc=lro}', "");
Expect(0, 8238, '\P{^Bc=lro}', "");
Expect(1, 8237, '\p{Bc=- LRO}', "");
Expect(0, 8237, '\p{^Bc=- LRO}', "");
Expect(0, 8237, '\P{Bc=- LRO}', "");
Expect(1, 8237, '\P{^Bc=- LRO}', "");
Expect(0, 8238, '\p{Bc=- LRO}', "");
Expect(1, 8238, '\p{^Bc=- LRO}', "");
Expect(1, 8238, '\P{Bc=- LRO}', "");
Expect(0, 8238, '\P{^Bc=- LRO}', "");
Error('\p{Is_Bidi_Class=:=_Left_To_Right_OVERRIDE}');
Error('\P{Is_Bidi_Class=:=_Left_To_Right_OVERRIDE}');
Expect(1, 8237, '\p{Is_Bidi_Class=lefttorightoverride}', "");
Expect(0, 8237, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
Expect(0, 8237, '\P{Is_Bidi_Class=lefttorightoverride}', "");
Expect(1, 8237, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
Expect(0, 8238, '\p{Is_Bidi_Class=lefttorightoverride}', "");
Expect(1, 8238, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
Expect(1, 8238, '\P{Is_Bidi_Class=lefttorightoverride}', "");
Expect(0, 8238, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
Expect(1, 8237, '\p{Is_Bidi_Class=__Left_to_right_Override}', "");
Expect(0, 8237, '\p{^Is_Bidi_Class=__Left_to_right_Override}', "");
Expect(0, 8237, '\P{Is_Bidi_Class=__Left_to_right_Override}', "");
Expect(1, 8237, '\P{^Is_Bidi_Class=__Left_to_right_Override}', "");
Expect(0, 8238, '\p{Is_Bidi_Class=__Left_to_right_Override}', "");
Expect(1, 8238, '\p{^Is_Bidi_Class=__Left_to_right_Override}', "");
Expect(1, 8238, '\P{Is_Bidi_Class=__Left_to_right_Override}', "");
Expect(0, 8238, '\P{^Is_Bidi_Class=__Left_to_right_Override}', "");
Error('\p{Is_Bc= :=LRO}');
Error('\P{Is_Bc= :=LRO}');
Expect(1, 8237, '\p{Is_Bc=lro}', "");
Expect(0, 8237, '\p{^Is_Bc=lro}', "");
Expect(0, 8237, '\P{Is_Bc=lro}', "");
Expect(1, 8237, '\P{^Is_Bc=lro}', "");
Expect(0, 8238, '\p{Is_Bc=lro}', "");
Expect(1, 8238, '\p{^Is_Bc=lro}', "");
Expect(1, 8238, '\P{Is_Bc=lro}', "");
Expect(0, 8238, '\P{^Is_Bc=lro}', "");
Expect(1, 8237, '\p{Is_Bc=  LRO}', "");
Expect(0, 8237, '\p{^Is_Bc=  LRO}', "");
Expect(0, 8237, '\P{Is_Bc=  LRO}', "");
Expect(1, 8237, '\P{^Is_Bc=  LRO}', "");
Expect(0, 8238, '\p{Is_Bc=  LRO}', "");
Expect(1, 8238, '\p{^Is_Bc=  LRO}', "");
Expect(1, 8238, '\P{Is_Bc=  LRO}', "");
Expect(0, 8238, '\P{^Is_Bc=  LRO}', "");
Error('\p{Bidi_Class= Nonspacing_Mark/a/}');
Error('\P{Bidi_Class= Nonspacing_Mark/a/}');
Expect(1, 917999, '\p{Bidi_Class=nonspacingmark}', "");
Expect(0, 917999, '\p{^Bidi_Class=nonspacingmark}', "");
Expect(0, 917999, '\P{Bidi_Class=nonspacingmark}', "");
Expect(1, 917999, '\P{^Bidi_Class=nonspacingmark}', "");
Expect(0, 918000, '\p{Bidi_Class=nonspacingmark}', "");
Expect(1, 918000, '\p{^Bidi_Class=nonspacingmark}', "");
Expect(1, 918000, '\P{Bidi_Class=nonspacingmark}', "");
Expect(0, 918000, '\P{^Bidi_Class=nonspacingmark}', "");
Expect(1, 917999, '\p{Bidi_Class=_	Nonspacing_mark}', "");
Expect(0, 917999, '\p{^Bidi_Class=_	Nonspacing_mark}', "");
Expect(0, 917999, '\P{Bidi_Class=_	Nonspacing_mark}', "");
Expect(1, 917999, '\P{^Bidi_Class=_	Nonspacing_mark}', "");
Expect(0, 918000, '\p{Bidi_Class=_	Nonspacing_mark}', "");
Expect(1, 918000, '\p{^Bidi_Class=_	Nonspacing_mark}', "");
Expect(1, 918000, '\P{Bidi_Class=_	Nonspacing_mark}', "");
Expect(0, 918000, '\P{^Bidi_Class=_	Nonspacing_mark}', "");
Error('\p{Bc=_	NSM:=}');
Error('\P{Bc=_	NSM:=}');
Expect(1, 917999, '\p{Bc=nsm}', "");
Expect(0, 917999, '\p{^Bc=nsm}', "");
Expect(0, 917999, '\P{Bc=nsm}', "");
Expect(1, 917999, '\P{^Bc=nsm}', "");
Expect(0, 918000, '\p{Bc=nsm}', "");
Expect(1, 918000, '\p{^Bc=nsm}', "");
Expect(1, 918000, '\P{Bc=nsm}', "");
Expect(0, 918000, '\P{^Bc=nsm}', "");
Expect(1, 917999, '\p{Bc=- NSM}', "");
Expect(0, 917999, '\p{^Bc=- NSM}', "");
Expect(0, 917999, '\P{Bc=- NSM}', "");
Expect(1, 917999, '\P{^Bc=- NSM}', "");
Expect(0, 918000, '\p{Bc=- NSM}', "");
Expect(1, 918000, '\p{^Bc=- NSM}', "");
Expect(1, 918000, '\P{Bc=- NSM}', "");
Expect(0, 918000, '\P{^Bc=- NSM}', "");
Error('\p{Is_Bidi_Class=	_nonspacing_Mark/a/}');
Error('\P{Is_Bidi_Class=	_nonspacing_Mark/a/}');
Expect(1, 917999, '\p{Is_Bidi_Class=nonspacingmark}', "");
Expect(0, 917999, '\p{^Is_Bidi_Class=nonspacingmark}', "");
Expect(0, 917999, '\P{Is_Bidi_Class=nonspacingmark}', "");
Expect(1, 917999, '\P{^Is_Bidi_Class=nonspacingmark}', "");
Expect(0, 918000, '\p{Is_Bidi_Class=nonspacingmark}', "");
Expect(1, 918000, '\p{^Is_Bidi_Class=nonspacingmark}', "");
Expect(1, 918000, '\P{Is_Bidi_Class=nonspacingmark}', "");
Expect(0, 918000, '\P{^Is_Bidi_Class=nonspacingmark}', "");
Expect(1, 917999, '\p{Is_Bidi_Class=_nonspacing_Mark}', "");
Expect(0, 917999, '\p{^Is_Bidi_Class=_nonspacing_Mark}', "");
Expect(0, 917999, '\P{Is_Bidi_Class=_nonspacing_Mark}', "");
Expect(1, 917999, '\P{^Is_Bidi_Class=_nonspacing_Mark}', "");
Expect(0, 918000, '\p{Is_Bidi_Class=_nonspacing_Mark}', "");
Expect(1, 918000, '\p{^Is_Bidi_Class=_nonspacing_Mark}', "");
Expect(1, 918000, '\P{Is_Bidi_Class=_nonspacing_Mark}', "");
Expect(0, 918000, '\P{^Is_Bidi_Class=_nonspacing_Mark}', "");
Error('\p{Is_Bc=:=nsm}');
Error('\P{Is_Bc=:=nsm}');
Expect(1, 917999, '\p{Is_Bc=nsm}', "");
Expect(0, 917999, '\p{^Is_Bc=nsm}', "");
Expect(0, 917999, '\P{Is_Bc=nsm}', "");
Expect(1, 917999, '\P{^Is_Bc=nsm}', "");
Expect(0, 918000, '\p{Is_Bc=nsm}', "");
Expect(1, 918000, '\p{^Is_Bc=nsm}', "");
Expect(1, 918000, '\P{Is_Bc=nsm}', "");
Expect(0, 918000, '\P{^Is_Bc=nsm}', "");
Expect(1, 917999, '\p{Is_Bc=NSM}', "");
Expect(0, 917999, '\p{^Is_Bc=NSM}', "");
Expect(0, 917999, '\P{Is_Bc=NSM}', "");
Expect(1, 917999, '\P{^Is_Bc=NSM}', "");
Expect(0, 918000, '\p{Is_Bc=NSM}', "");
Expect(1, 918000, '\p{^Is_Bc=NSM}', "");
Expect(1, 918000, '\P{Is_Bc=NSM}', "");
Expect(0, 918000, '\P{^Is_Bc=NSM}', "");
Error('\p{Bidi_Class: /a/_other_Neutral}');
Error('\P{Bidi_Class: /a/_other_Neutral}');
Expect(1, 129472, '\p{Bidi_Class=otherneutral}', "");
Expect(0, 129472, '\p{^Bidi_Class=otherneutral}', "");
Expect(0, 129472, '\P{Bidi_Class=otherneutral}', "");
Expect(1, 129472, '\P{^Bidi_Class=otherneutral}', "");
Expect(0, 129473, '\p{Bidi_Class=otherneutral}', "");
Expect(1, 129473, '\p{^Bidi_Class=otherneutral}', "");
Expect(1, 129473, '\P{Bidi_Class=otherneutral}', "");
Expect(0, 129473, '\P{^Bidi_Class=otherneutral}', "");
Expect(1, 129472, '\p{Bidi_Class=	 other_Neutral}', "");
Expect(0, 129472, '\p{^Bidi_Class=	 other_Neutral}', "");
Expect(0, 129472, '\P{Bidi_Class=	 other_Neutral}', "");
Expect(1, 129472, '\P{^Bidi_Class=	 other_Neutral}', "");
Expect(0, 129473, '\p{Bidi_Class=	 other_Neutral}', "");
Expect(1, 129473, '\p{^Bidi_Class=	 other_Neutral}', "");
Expect(1, 129473, '\P{Bidi_Class=	 other_Neutral}', "");
Expect(0, 129473, '\P{^Bidi_Class=	 other_Neutral}', "");
Error('\p{Bc=	:=on}');
Error('\P{Bc=	:=on}');
Expect(1, 129472, '\p{Bc=on}', "");
Expect(0, 129472, '\p{^Bc=on}', "");
Expect(0, 129472, '\P{Bc=on}', "");
Expect(1, 129472, '\P{^Bc=on}', "");
Expect(0, 129473, '\p{Bc=on}', "");
Expect(1, 129473, '\p{^Bc=on}', "");
Expect(1, 129473, '\P{Bc=on}', "");
Expect(0, 129473, '\P{^Bc=on}', "");
Expect(1, 129472, '\p{Bc=__ON}', "");
Expect(0, 129472, '\p{^Bc=__ON}', "");
Expect(0, 129472, '\P{Bc=__ON}', "");
Expect(1, 129472, '\P{^Bc=__ON}', "");
Expect(0, 129473, '\p{Bc=__ON}', "");
Expect(1, 129473, '\p{^Bc=__ON}', "");
Expect(1, 129473, '\P{Bc=__ON}', "");
Expect(0, 129473, '\P{^Bc=__ON}', "");
Error('\p{Is_Bidi_Class:   /a/-Other_neutral}');
Error('\P{Is_Bidi_Class:   /a/-Other_neutral}');
Expect(1, 129472, '\p{Is_Bidi_Class=otherneutral}', "");
Expect(0, 129472, '\p{^Is_Bidi_Class=otherneutral}', "");
Expect(0, 129472, '\P{Is_Bidi_Class=otherneutral}', "");
Expect(1, 129472, '\P{^Is_Bidi_Class=otherneutral}', "");
Expect(0, 129473, '\p{Is_Bidi_Class=otherneutral}', "");
Expect(1, 129473, '\p{^Is_Bidi_Class=otherneutral}', "");
Expect(1, 129473, '\P{Is_Bidi_Class=otherneutral}', "");
Expect(0, 129473, '\P{^Is_Bidi_Class=otherneutral}', "");
Expect(1, 129472, '\p{Is_Bidi_Class=other_neutral}', "");
Expect(0, 129472, '\p{^Is_Bidi_Class=other_neutral}', "");
Expect(0, 129472, '\P{Is_Bidi_Class=other_neutral}', "");
Expect(1, 129472, '\P{^Is_Bidi_Class=other_neutral}', "");
Expect(0, 129473, '\p{Is_Bidi_Class=other_neutral}', "");
Expect(1, 129473, '\p{^Is_Bidi_Class=other_neutral}', "");
Expect(1, 129473, '\P{Is_Bidi_Class=other_neutral}', "");
Expect(0, 129473, '\P{^Is_Bidi_Class=other_neutral}', "");
Error('\p{Is_Bc=:=	ON}');
Error('\P{Is_Bc=:=	ON}');
Expect(1, 129472, '\p{Is_Bc=on}', "");
Expect(0, 129472, '\p{^Is_Bc=on}', "");
Expect(0, 129472, '\P{Is_Bc=on}', "");
Expect(1, 129472, '\P{^Is_Bc=on}', "");
Expect(0, 129473, '\p{Is_Bc=on}', "");
Expect(1, 129473, '\p{^Is_Bc=on}', "");
Expect(1, 129473, '\P{Is_Bc=on}', "");
Expect(0, 129473, '\P{^Is_Bc=on}', "");
Error('\p{Bidi_Class= /a/POP_Directional_Format}');
Error('\P{Bidi_Class= /a/POP_Directional_Format}');
Expect(1, 8236, '\p{Bidi_Class=popdirectionalformat}', "");
Expect(0, 8236, '\p{^Bidi_Class=popdirectionalformat}', "");
Expect(0, 8236, '\P{Bidi_Class=popdirectionalformat}', "");
Expect(1, 8236, '\P{^Bidi_Class=popdirectionalformat}', "");
Expect(0, 8237, '\p{Bidi_Class=popdirectionalformat}', "");
Expect(1, 8237, '\p{^Bidi_Class=popdirectionalformat}', "");
Expect(1, 8237, '\P{Bidi_Class=popdirectionalformat}', "");
Expect(0, 8237, '\P{^Bidi_Class=popdirectionalformat}', "");
Expect(1, 8236, '\p{Bidi_Class=	Pop_Directional_format}', "");
Expect(0, 8236, '\p{^Bidi_Class=	Pop_Directional_format}', "");
Expect(0, 8236, '\P{Bidi_Class=	Pop_Directional_format}', "");
Expect(1, 8236, '\P{^Bidi_Class=	Pop_Directional_format}', "");
Expect(0, 8237, '\p{Bidi_Class=	Pop_Directional_format}', "");
Expect(1, 8237, '\p{^Bidi_Class=	Pop_Directional_format}', "");
Expect(1, 8237, '\P{Bidi_Class=	Pop_Directional_format}', "");
Expect(0, 8237, '\P{^Bidi_Class=	Pop_Directional_format}', "");
Error('\p{Bc=	:=pdf}');
Error('\P{Bc=	:=pdf}');
Expect(1, 8236, '\p{Bc=pdf}', "");
Expect(0, 8236, '\p{^Bc=pdf}', "");
Expect(0, 8236, '\P{Bc=pdf}', "");
Expect(1, 8236, '\P{^Bc=pdf}', "");
Expect(0, 8237, '\p{Bc=pdf}', "");
Expect(1, 8237, '\p{^Bc=pdf}', "");
Expect(1, 8237, '\P{Bc=pdf}', "");
Expect(0, 8237, '\P{^Bc=pdf}', "");
Expect(1, 8236, '\p{Bc:		PDF}', "");
Expect(0, 8236, '\p{^Bc:		PDF}', "");
Expect(0, 8236, '\P{Bc:		PDF}', "");
Expect(1, 8236, '\P{^Bc:		PDF}', "");
Expect(0, 8237, '\p{Bc:		PDF}', "");
Expect(1, 8237, '\p{^Bc:		PDF}', "");
Expect(1, 8237, '\P{Bc:		PDF}', "");
Expect(0, 8237, '\P{^Bc:		PDF}', "");
Error('\p{Is_Bidi_Class= :=POP_Directional_Format}');
Error('\P{Is_Bidi_Class= :=POP_Directional_Format}');
Expect(1, 8236, '\p{Is_Bidi_Class=popdirectionalformat}', "");
Expect(0, 8236, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
Expect(0, 8236, '\P{Is_Bidi_Class=popdirectionalformat}', "");
Expect(1, 8236, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
Expect(0, 8237, '\p{Is_Bidi_Class=popdirectionalformat}', "");
Expect(1, 8237, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
Expect(1, 8237, '\P{Is_Bidi_Class=popdirectionalformat}', "");
Expect(0, 8237, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
Expect(1, 8236, '\p{Is_Bidi_Class= _POP_directional_FORMAT}', "");
Expect(0, 8236, '\p{^Is_Bidi_Class= _POP_directional_FORMAT}', "");
Expect(0, 8236, '\P{Is_Bidi_Class= _POP_directional_FORMAT}', "");
Expect(1, 8236, '\P{^Is_Bidi_Class= _POP_directional_FORMAT}', "");
Expect(0, 8237, '\p{Is_Bidi_Class= _POP_directional_FORMAT}', "");
Expect(1, 8237, '\p{^Is_Bidi_Class= _POP_directional_FORMAT}', "");
Expect(1, 8237, '\P{Is_Bidi_Class= _POP_directional_FORMAT}', "");
Expect(0, 8237, '\P{^Is_Bidi_Class= _POP_directional_FORMAT}', "");
Error('\p{Is_Bc=	-PDF/a/}');
Error('\P{Is_Bc=	-PDF/a/}');
Expect(1, 8236, '\p{Is_Bc:	pdf}', "");
Expect(0, 8236, '\p{^Is_Bc:	pdf}', "");
Expect(0, 8236, '\P{Is_Bc:	pdf}', "");
Expect(1, 8236, '\P{^Is_Bc:	pdf}', "");
Expect(0, 8237, '\p{Is_Bc:	pdf}', "");
Expect(1, 8237, '\p{^Is_Bc:	pdf}', "");
Expect(1, 8237, '\P{Is_Bc:	pdf}', "");
Expect(0, 8237, '\P{^Is_Bc:	pdf}', "");
Expect(1, 8236, '\p{Is_Bc= pdf}', "");
Expect(0, 8236, '\p{^Is_Bc= pdf}', "");
Expect(0, 8236, '\P{Is_Bc= pdf}', "");
Expect(1, 8236, '\P{^Is_Bc= pdf}', "");
Expect(0, 8237, '\p{Is_Bc= pdf}', "");
Expect(1, 8237, '\p{^Is_Bc= pdf}', "");
Expect(1, 8237, '\P{Is_Bc= pdf}', "");
Expect(0, 8237, '\P{^Is_Bc= pdf}', "");
Error('\p{Bidi_Class=	:=POP_DIRECTIONAL_isolate}');
Error('\P{Bidi_Class=	:=POP_DIRECTIONAL_isolate}');
Expect(1, 8297, '\p{Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8297, '\p{^Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8297, '\P{Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8297, '\P{^Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8298, '\p{Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8298, '\p{^Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8298, '\P{Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8298, '\P{^Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8297, '\p{Bidi_Class=_	POP_directional_Isolate}', "");
Expect(0, 8297, '\p{^Bidi_Class=_	POP_directional_Isolate}', "");
Expect(0, 8297, '\P{Bidi_Class=_	POP_directional_Isolate}', "");
Expect(1, 8297, '\P{^Bidi_Class=_	POP_directional_Isolate}', "");
Expect(0, 8298, '\p{Bidi_Class=_	POP_directional_Isolate}', "");
Expect(1, 8298, '\p{^Bidi_Class=_	POP_directional_Isolate}', "");
Expect(1, 8298, '\P{Bidi_Class=_	POP_directional_Isolate}', "");
Expect(0, 8298, '\P{^Bidi_Class=_	POP_directional_Isolate}', "");
Error('\p{Bc=:=_-PDI}');
Error('\P{Bc=:=_-PDI}');
Expect(1, 8297, '\p{Bc=pdi}', "");
Expect(0, 8297, '\p{^Bc=pdi}', "");
Expect(0, 8297, '\P{Bc=pdi}', "");
Expect(1, 8297, '\P{^Bc=pdi}', "");
Expect(0, 8298, '\p{Bc=pdi}', "");
Expect(1, 8298, '\p{^Bc=pdi}', "");
Expect(1, 8298, '\P{Bc=pdi}', "");
Expect(0, 8298, '\P{^Bc=pdi}', "");
Expect(1, 8297, '\p{Bc=- PDI}', "");
Expect(0, 8297, '\p{^Bc=- PDI}', "");
Expect(0, 8297, '\P{Bc=- PDI}', "");
Expect(1, 8297, '\P{^Bc=- PDI}', "");
Expect(0, 8298, '\p{Bc=- PDI}', "");
Expect(1, 8298, '\p{^Bc=- PDI}', "");
Expect(1, 8298, '\P{Bc=- PDI}', "");
Expect(0, 8298, '\P{^Bc=- PDI}', "");
Error('\p{Is_Bidi_Class:	/a/ -Pop_directional_isolate}');
Error('\P{Is_Bidi_Class:	/a/ -Pop_directional_isolate}');
Expect(1, 8297, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8297, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8297, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8297, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8298, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8298, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8298, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8298, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8297, '\p{Is_Bidi_Class= -Pop_directional_isolate}', "");
Expect(0, 8297, '\p{^Is_Bidi_Class= -Pop_directional_isolate}', "");
Expect(0, 8297, '\P{Is_Bidi_Class= -Pop_directional_isolate}', "");
Expect(1, 8297, '\P{^Is_Bidi_Class= -Pop_directional_isolate}', "");
Expect(0, 8298, '\p{Is_Bidi_Class= -Pop_directional_isolate}', "");
Expect(1, 8298, '\p{^Is_Bidi_Class= -Pop_directional_isolate}', "");
Expect(1, 8298, '\P{Is_Bidi_Class= -Pop_directional_isolate}', "");
Expect(0, 8298, '\P{^Is_Bidi_Class= -Pop_directional_isolate}', "");
Error('\p{Is_Bc=:=  PDI}');
Error('\P{Is_Bc=:=  PDI}');
Expect(1, 8297, '\p{Is_Bc=pdi}', "");
Expect(0, 8297, '\p{^Is_Bc=pdi}', "");
Expect(0, 8297, '\P{Is_Bc=pdi}', "");
Expect(1, 8297, '\P{^Is_Bc=pdi}', "");
Expect(0, 8298, '\p{Is_Bc=pdi}', "");
Expect(1, 8298, '\p{^Is_Bc=pdi}', "");
Expect(1, 8298, '\P{Is_Bc=pdi}', "");
Expect(0, 8298, '\P{^Is_Bc=pdi}', "");
Expect(1, 8297, '\p{Is_Bc= PDI}', "");
Expect(0, 8297, '\p{^Is_Bc= PDI}', "");
Expect(0, 8297, '\P{Is_Bc= PDI}', "");
Expect(1, 8297, '\P{^Is_Bc= PDI}', "");
Expect(0, 8298, '\p{Is_Bc= PDI}', "");
Expect(1, 8298, '\p{^Is_Bc= PDI}', "");
Expect(1, 8298, '\P{Is_Bc= PDI}', "");
Expect(0, 8298, '\P{^Is_Bc= PDI}', "");
Error('\p{Bidi_Class=-Right_TO_left:=}');
Error('\P{Bidi_Class=-Right_TO_left:=}');
Expect(1, 126975, '\p{Bidi_Class:   righttoleft}', "");
Expect(0, 126975, '\p{^Bidi_Class:   righttoleft}', "");
Expect(0, 126975, '\P{Bidi_Class:   righttoleft}', "");
Expect(1, 126975, '\P{^Bidi_Class:   righttoleft}', "");
Expect(0, 126976, '\p{Bidi_Class:   righttoleft}', "");
Expect(1, 126976, '\p{^Bidi_Class:   righttoleft}', "");
Expect(1, 126976, '\P{Bidi_Class:   righttoleft}', "");
Expect(0, 126976, '\P{^Bidi_Class:   righttoleft}', "");
Expect(1, 126975, '\p{Bidi_Class=--RIGHT_To_Left}', "");
Expect(0, 126975, '\p{^Bidi_Class=--RIGHT_To_Left}', "");
Expect(0, 126975, '\P{Bidi_Class=--RIGHT_To_Left}', "");
Expect(1, 126975, '\P{^Bidi_Class=--RIGHT_To_Left}', "");
Expect(0, 126976, '\p{Bidi_Class=--RIGHT_To_Left}', "");
Expect(1, 126976, '\p{^Bidi_Class=--RIGHT_To_Left}', "");
Expect(1, 126976, '\P{Bidi_Class=--RIGHT_To_Left}', "");
Expect(0, 126976, '\P{^Bidi_Class=--RIGHT_To_Left}', "");
Error('\p{Bc=- R/a/}');
Error('\P{Bc=- R/a/}');
Expect(1, 126975, '\p{Bc=r}', "");
Expect(0, 126975, '\p{^Bc=r}', "");
Expect(0, 126975, '\P{Bc=r}', "");
Expect(1, 126975, '\P{^Bc=r}', "");
Expect(0, 126976, '\p{Bc=r}', "");
Expect(1, 126976, '\p{^Bc=r}', "");
Expect(1, 126976, '\P{Bc=r}', "");
Expect(0, 126976, '\P{^Bc=r}', "");
Expect(1, 126975, '\p{Bc=R}', "");
Expect(0, 126975, '\p{^Bc=R}', "");
Expect(0, 126975, '\P{Bc=R}', "");
Expect(1, 126975, '\P{^Bc=R}', "");
Expect(0, 126976, '\p{Bc=R}', "");
Expect(1, 126976, '\p{^Bc=R}', "");
Expect(1, 126976, '\P{Bc=R}', "");
Expect(0, 126976, '\P{^Bc=R}', "");
Error('\p{Is_Bidi_Class=:=Right_to_Left}');
Error('\P{Is_Bidi_Class=:=Right_to_Left}');
Expect(1, 126975, '\p{Is_Bidi_Class=righttoleft}', "");
Expect(0, 126975, '\p{^Is_Bidi_Class=righttoleft}', "");
Expect(0, 126975, '\P{Is_Bidi_Class=righttoleft}', "");
Expect(1, 126975, '\P{^Is_Bidi_Class=righttoleft}', "");
Expect(0, 126976, '\p{Is_Bidi_Class=righttoleft}', "");
Expect(1, 126976, '\p{^Is_Bidi_Class=righttoleft}', "");
Expect(1, 126976, '\P{Is_Bidi_Class=righttoleft}', "");
Expect(0, 126976, '\P{^Is_Bidi_Class=righttoleft}', "");
Expect(1, 126975, '\p{Is_Bidi_Class=	 Right_to_Left}', "");
Expect(0, 126975, '\p{^Is_Bidi_Class=	 Right_to_Left}', "");
Expect(0, 126975, '\P{Is_Bidi_Class=	 Right_to_Left}', "");
Expect(1, 126975, '\P{^Is_Bidi_Class=	 Right_to_Left}', "");
Expect(0, 126976, '\p{Is_Bidi_Class=	 Right_to_Left}', "");
Expect(1, 126976, '\p{^Is_Bidi_Class=	 Right_to_Left}', "");
Expect(1, 126976, '\P{Is_Bidi_Class=	 Right_to_Left}', "");
Expect(0, 126976, '\P{^Is_Bidi_Class=	 Right_to_Left}', "");
Error('\p{Is_Bc= /a/R}');
Error('\P{Is_Bc= /a/R}');
Expect(1, 126975, '\p{Is_Bc=r}', "");
Expect(0, 126975, '\p{^Is_Bc=r}', "");
Expect(0, 126975, '\P{Is_Bc=r}', "");
Expect(1, 126975, '\P{^Is_Bc=r}', "");
Expect(0, 126976, '\p{Is_Bc=r}', "");
Expect(1, 126976, '\p{^Is_Bc=r}', "");
Expect(1, 126976, '\P{Is_Bc=r}', "");
Expect(0, 126976, '\P{^Is_Bc=r}', "");
Expect(1, 126975, '\p{Is_Bc= -R}', "");
Expect(0, 126975, '\p{^Is_Bc= -R}', "");
Expect(0, 126975, '\P{Is_Bc= -R}', "");
Expect(1, 126975, '\P{^Is_Bc= -R}', "");
Expect(0, 126976, '\p{Is_Bc= -R}', "");
Expect(1, 126976, '\p{^Is_Bc= -R}', "");
Expect(1, 126976, '\P{Is_Bc= -R}', "");
Expect(0, 126976, '\P{^Is_Bc= -R}', "");
Error('\p{Bidi_Class=:=- Right_to_Left_embedding}');
Error('\P{Bidi_Class=:=- Right_to_Left_embedding}');
Expect(1, 8235, '\p{Bidi_Class=righttoleftembedding}', "");
Expect(0, 8235, '\p{^Bidi_Class=righttoleftembedding}', "");
Expect(0, 8235, '\P{Bidi_Class=righttoleftembedding}', "");
Expect(1, 8235, '\P{^Bidi_Class=righttoleftembedding}', "");
Expect(0, 8236, '\p{Bidi_Class=righttoleftembedding}', "");
Expect(1, 8236, '\p{^Bidi_Class=righttoleftembedding}', "");
Expect(1, 8236, '\P{Bidi_Class=righttoleftembedding}', "");
Expect(0, 8236, '\P{^Bidi_Class=righttoleftembedding}', "");
Expect(1, 8235, '\p{Bidi_Class=_RIGHT_To_Left_EMBEDDING}', "");
Expect(0, 8235, '\p{^Bidi_Class=_RIGHT_To_Left_EMBEDDING}', "");
Expect(0, 8235, '\P{Bidi_Class=_RIGHT_To_Left_EMBEDDING}', "");
Expect(1, 8235, '\P{^Bidi_Class=_RIGHT_To_Left_EMBEDDING}', "");
Expect(0, 8236, '\p{Bidi_Class=_RIGHT_To_Left_EMBEDDING}', "");
Expect(1, 8236, '\p{^Bidi_Class=_RIGHT_To_Left_EMBEDDING}', "");
Expect(1, 8236, '\P{Bidi_Class=_RIGHT_To_Left_EMBEDDING}', "");
Expect(0, 8236, '\P{^Bidi_Class=_RIGHT_To_Left_EMBEDDING}', "");
Error('\p{Bc=:= _RLE}');
Error('\P{Bc=:= _RLE}');
Expect(1, 8235, '\p{Bc=rle}', "");
Expect(0, 8235, '\p{^Bc=rle}', "");
Expect(0, 8235, '\P{Bc=rle}', "");
Expect(1, 8235, '\P{^Bc=rle}', "");
Expect(0, 8236, '\p{Bc=rle}', "");
Expect(1, 8236, '\p{^Bc=rle}', "");
Expect(1, 8236, '\P{Bc=rle}', "");
Expect(0, 8236, '\P{^Bc=rle}', "");
Expect(1, 8235, '\p{Bc=	RLE}', "");
Expect(0, 8235, '\p{^Bc=	RLE}', "");
Expect(0, 8235, '\P{Bc=	RLE}', "");
Expect(1, 8235, '\P{^Bc=	RLE}', "");
Expect(0, 8236, '\p{Bc=	RLE}', "");
Expect(1, 8236, '\p{^Bc=	RLE}', "");
Expect(1, 8236, '\P{Bc=	RLE}', "");
Expect(0, 8236, '\P{^Bc=	RLE}', "");
Error('\p{Is_Bidi_Class=/a/_right_TO_LEFT_Embedding}');
Error('\P{Is_Bidi_Class=/a/_right_TO_LEFT_Embedding}');
Expect(1, 8235, '\p{Is_Bidi_Class=righttoleftembedding}', "");
Expect(0, 8235, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
Expect(0, 8235, '\P{Is_Bidi_Class=righttoleftembedding}', "");
Expect(1, 8235, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
Expect(0, 8236, '\p{Is_Bidi_Class=righttoleftembedding}', "");
Expect(1, 8236, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
Expect(1, 8236, '\P{Is_Bidi_Class=righttoleftembedding}', "");
Expect(0, 8236, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
Expect(1, 8235, '\p{Is_Bidi_Class=--Right_To_Left_embedding}', "");
Expect(0, 8235, '\p{^Is_Bidi_Class=--Right_To_Left_embedding}', "");
Expect(0, 8235, '\P{Is_Bidi_Class=--Right_To_Left_embedding}', "");
Expect(1, 8235, '\P{^Is_Bidi_Class=--Right_To_Left_embedding}', "");
Expect(0, 8236, '\p{Is_Bidi_Class=--Right_To_Left_embedding}', "");
Expect(1, 8236, '\p{^Is_Bidi_Class=--Right_To_Left_embedding}', "");
Expect(1, 8236, '\P{Is_Bidi_Class=--Right_To_Left_embedding}', "");
Expect(0, 8236, '\P{^Is_Bidi_Class=--Right_To_Left_embedding}', "");
Error('\p{Is_Bc=/a/- rle}');
Error('\P{Is_Bc=/a/- rle}');
Expect(1, 8235, '\p{Is_Bc:	rle}', "");
Expect(0, 8235, '\p{^Is_Bc:	rle}', "");
Expect(0, 8235, '\P{Is_Bc:	rle}', "");
Expect(1, 8235, '\P{^Is_Bc:	rle}', "");
Expect(0, 8236, '\p{Is_Bc:	rle}', "");
Expect(1, 8236, '\p{^Is_Bc:	rle}', "");
Expect(1, 8236, '\P{Is_Bc:	rle}', "");
Expect(0, 8236, '\P{^Is_Bc:	rle}', "");
Expect(1, 8235, '\p{Is_Bc=		RLE}', "");
Expect(0, 8235, '\p{^Is_Bc=		RLE}', "");
Expect(0, 8235, '\P{Is_Bc=		RLE}', "");
Expect(1, 8235, '\P{^Is_Bc=		RLE}', "");
Expect(0, 8236, '\p{Is_Bc=		RLE}', "");
Expect(1, 8236, '\p{^Is_Bc=		RLE}', "");
Expect(1, 8236, '\P{Is_Bc=		RLE}', "");
Expect(0, 8236, '\P{^Is_Bc=		RLE}', "");
Error('\p{Bidi_Class=:=	Right_TO_LEFT_Isolate}');
Error('\P{Bidi_Class=:=	Right_TO_LEFT_Isolate}');
Expect(1, 8295, '\p{Bidi_Class=righttoleftisolate}', "");
Expect(0, 8295, '\p{^Bidi_Class=righttoleftisolate}', "");
Expect(0, 8295, '\P{Bidi_Class=righttoleftisolate}', "");
Expect(1, 8295, '\P{^Bidi_Class=righttoleftisolate}', "");
Expect(0, 8296, '\p{Bidi_Class=righttoleftisolate}', "");
Expect(1, 8296, '\p{^Bidi_Class=righttoleftisolate}', "");
Expect(1, 8296, '\P{Bidi_Class=righttoleftisolate}', "");
Expect(0, 8296, '\P{^Bidi_Class=righttoleftisolate}', "");
Expect(1, 8295, '\p{Bidi_Class=	RIGHT_To_LEFT_Isolate}', "");
Expect(0, 8295, '\p{^Bidi_Class=	RIGHT_To_LEFT_Isolate}', "");
Expect(0, 8295, '\P{Bidi_Class=	RIGHT_To_LEFT_Isolate}', "");
Expect(1, 8295, '\P{^Bidi_Class=	RIGHT_To_LEFT_Isolate}', "");
Expect(0, 8296, '\p{Bidi_Class=	RIGHT_To_LEFT_Isolate}', "");
Expect(1, 8296, '\p{^Bidi_Class=	RIGHT_To_LEFT_Isolate}', "");
Expect(1, 8296, '\P{Bidi_Class=	RIGHT_To_LEFT_Isolate}', "");
Expect(0, 8296, '\P{^Bidi_Class=	RIGHT_To_LEFT_Isolate}', "");
Error('\p{Bc:	:=rli}');
Error('\P{Bc:	:=rli}');
Expect(1, 8295, '\p{Bc=rli}', "");
Expect(0, 8295, '\p{^Bc=rli}', "");
Expect(0, 8295, '\P{Bc=rli}', "");
Expect(1, 8295, '\P{^Bc=rli}', "");
Expect(0, 8296, '\p{Bc=rli}', "");
Expect(1, 8296, '\p{^Bc=rli}', "");
Expect(1, 8296, '\P{Bc=rli}', "");
Expect(0, 8296, '\P{^Bc=rli}', "");
Expect(1, 8295, '\p{Bc=-	rli}', "");
Expect(0, 8295, '\p{^Bc=-	rli}', "");
Expect(0, 8295, '\P{Bc=-	rli}', "");
Expect(1, 8295, '\P{^Bc=-	rli}', "");
Expect(0, 8296, '\p{Bc=-	rli}', "");
Expect(1, 8296, '\p{^Bc=-	rli}', "");
Expect(1, 8296, '\P{Bc=-	rli}', "");
Expect(0, 8296, '\P{^Bc=-	rli}', "");
Error('\p{Is_Bidi_Class=/a/ Right_To_Left_isolate}');
Error('\P{Is_Bidi_Class=/a/ Right_To_Left_isolate}');
Expect(1, 8295, '\p{Is_Bidi_Class=righttoleftisolate}', "");
Expect(0, 8295, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
Expect(0, 8295, '\P{Is_Bidi_Class=righttoleftisolate}', "");
Expect(1, 8295, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
Expect(0, 8296, '\p{Is_Bidi_Class=righttoleftisolate}', "");
Expect(1, 8296, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
Expect(1, 8296, '\P{Is_Bidi_Class=righttoleftisolate}', "");
Expect(0, 8296, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
Expect(1, 8295, '\p{Is_Bidi_Class=	-Right_TO_Left_ISOLATE}', "");
Expect(0, 8295, '\p{^Is_Bidi_Class=	-Right_TO_Left_ISOLATE}', "");
Expect(0, 8295, '\P{Is_Bidi_Class=	-Right_TO_Left_ISOLATE}', "");
Expect(1, 8295, '\P{^Is_Bidi_Class=	-Right_TO_Left_ISOLATE}', "");
Expect(0, 8296, '\p{Is_Bidi_Class=	-Right_TO_Left_ISOLATE}', "");
Expect(1, 8296, '\p{^Is_Bidi_Class=	-Right_TO_Left_ISOLATE}', "");
Expect(1, 8296, '\P{Is_Bidi_Class=	-Right_TO_Left_ISOLATE}', "");
Expect(0, 8296, '\P{^Is_Bidi_Class=	-Right_TO_Left_ISOLATE}', "");
Error('\p{Is_Bc=-/a/rli}');
Error('\P{Is_Bc=-/a/rli}');
Expect(1, 8295, '\p{Is_Bc=rli}', "");
Expect(0, 8295, '\p{^Is_Bc=rli}', "");
Expect(0, 8295, '\P{Is_Bc=rli}', "");
Expect(1, 8295, '\P{^Is_Bc=rli}', "");
Expect(0, 8296, '\p{Is_Bc=rli}', "");
Expect(1, 8296, '\p{^Is_Bc=rli}', "");
Expect(1, 8296, '\P{Is_Bc=rli}', "");
Expect(0, 8296, '\P{^Is_Bc=rli}', "");
Expect(1, 8295, '\p{Is_Bc= _rli}', "");
Expect(0, 8295, '\p{^Is_Bc= _rli}', "");
Expect(0, 8295, '\P{Is_Bc= _rli}', "");
Expect(1, 8295, '\P{^Is_Bc= _rli}', "");
Expect(0, 8296, '\p{Is_Bc= _rli}', "");
Expect(1, 8296, '\p{^Is_Bc= _rli}', "");
Expect(1, 8296, '\P{Is_Bc= _rli}', "");
Expect(0, 8296, '\P{^Is_Bc= _rli}', "");
Error('\p{Bidi_Class=/a/_right_To_Left_override}');
Error('\P{Bidi_Class=/a/_right_To_Left_override}');
Expect(1, 8238, '\p{Bidi_Class=righttoleftoverride}', "");
Expect(0, 8238, '\p{^Bidi_Class=righttoleftoverride}', "");
Expect(0, 8238, '\P{Bidi_Class=righttoleftoverride}', "");
Expect(1, 8238, '\P{^Bidi_Class=righttoleftoverride}', "");
Expect(0, 8239, '\p{Bidi_Class=righttoleftoverride}', "");
Expect(1, 8239, '\p{^Bidi_Class=righttoleftoverride}', "");
Expect(1, 8239, '\P{Bidi_Class=righttoleftoverride}', "");
Expect(0, 8239, '\P{^Bidi_Class=righttoleftoverride}', "");
Expect(1, 8238, '\p{Bidi_Class=--Right_To_Left_Override}', "");
Expect(0, 8238, '\p{^Bidi_Class=--Right_To_Left_Override}', "");
Expect(0, 8238, '\P{Bidi_Class=--Right_To_Left_Override}', "");
Expect(1, 8238, '\P{^Bidi_Class=--Right_To_Left_Override}', "");
Expect(0, 8239, '\p{Bidi_Class=--Right_To_Left_Override}', "");
Expect(1, 8239, '\p{^Bidi_Class=--Right_To_Left_Override}', "");
Expect(1, 8239, '\P{Bidi_Class=--Right_To_Left_Override}', "");
Expect(0, 8239, '\P{^Bidi_Class=--Right_To_Left_Override}', "");
Error('\p{Bc= :=RLO}');
Error('\P{Bc= :=RLO}');
Expect(1, 8238, '\p{Bc=rlo}', "");
Expect(0, 8238, '\p{^Bc=rlo}', "");
Expect(0, 8238, '\P{Bc=rlo}', "");
Expect(1, 8238, '\P{^Bc=rlo}', "");
Expect(0, 8239, '\p{Bc=rlo}', "");
Expect(1, 8239, '\p{^Bc=rlo}', "");
Expect(1, 8239, '\P{Bc=rlo}', "");
Expect(0, 8239, '\P{^Bc=rlo}', "");
Expect(1, 8238, '\p{Bc= RLO}', "");
Expect(0, 8238, '\p{^Bc= RLO}', "");
Expect(0, 8238, '\P{Bc= RLO}', "");
Expect(1, 8238, '\P{^Bc= RLO}', "");
Expect(0, 8239, '\p{Bc= RLO}', "");
Expect(1, 8239, '\p{^Bc= RLO}', "");
Expect(1, 8239, '\P{Bc= RLO}', "");
Expect(0, 8239, '\P{^Bc= RLO}', "");
Error('\p{Is_Bidi_Class=- Right_To_LEFT_Override:=}');
Error('\P{Is_Bidi_Class=- Right_To_LEFT_Override:=}');
Expect(1, 8238, '\p{Is_Bidi_Class=righttoleftoverride}', "");
Expect(0, 8238, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
Expect(0, 8238, '\P{Is_Bidi_Class=righttoleftoverride}', "");
Expect(1, 8238, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
Expect(0, 8239, '\p{Is_Bidi_Class=righttoleftoverride}', "");
Expect(1, 8239, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
Expect(1, 8239, '\P{Is_Bidi_Class=righttoleftoverride}', "");
Expect(0, 8239, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
Expect(1, 8238, '\p{Is_Bidi_Class=_right_to_left_OVERRIDE}', "");
Expect(0, 8238, '\p{^Is_Bidi_Class=_right_to_left_OVERRIDE}', "");
Expect(0, 8238, '\P{Is_Bidi_Class=_right_to_left_OVERRIDE}', "");
Expect(1, 8238, '\P{^Is_Bidi_Class=_right_to_left_OVERRIDE}', "");
Expect(0, 8239, '\p{Is_Bidi_Class=_right_to_left_OVERRIDE}', "");
Expect(1, 8239, '\p{^Is_Bidi_Class=_right_to_left_OVERRIDE}', "");
Expect(1, 8239, '\P{Is_Bidi_Class=_right_to_left_OVERRIDE}', "");
Expect(0, 8239, '\P{^Is_Bidi_Class=_right_to_left_OVERRIDE}', "");
Error('\p{Is_Bc:		RLO/a/}');
Error('\P{Is_Bc:		RLO/a/}');
Expect(1, 8238, '\p{Is_Bc=rlo}', "");
Expect(0, 8238, '\p{^Is_Bc=rlo}', "");
Expect(0, 8238, '\P{Is_Bc=rlo}', "");
Expect(1, 8238, '\P{^Is_Bc=rlo}', "");
Expect(0, 8239, '\p{Is_Bc=rlo}', "");
Expect(1, 8239, '\p{^Is_Bc=rlo}', "");
Expect(1, 8239, '\P{Is_Bc=rlo}', "");
Expect(0, 8239, '\P{^Is_Bc=rlo}', "");
Expect(1, 8238, '\p{Is_Bc:	_rlo}', "");
Expect(0, 8238, '\p{^Is_Bc:	_rlo}', "");
Expect(0, 8238, '\P{Is_Bc:	_rlo}', "");
Expect(1, 8238, '\P{^Is_Bc:	_rlo}', "");
Expect(0, 8239, '\p{Is_Bc:	_rlo}', "");
Expect(1, 8239, '\p{^Is_Bc:	_rlo}', "");
Expect(1, 8239, '\P{Is_Bc:	_rlo}', "");
Expect(0, 8239, '\P{^Is_Bc:	_rlo}', "");
Error('\p{Bidi_Class=	_Segment_SEPARATOR:=}');
Error('\P{Bidi_Class=	_Segment_SEPARATOR:=}');
Expect(1, 31, '\p{Bidi_Class=segmentseparator}', "");
Expect(0, 31, '\p{^Bidi_Class=segmentseparator}', "");
Expect(0, 31, '\P{Bidi_Class=segmentseparator}', "");
Expect(1, 31, '\P{^Bidi_Class=segmentseparator}', "");
Expect(0, 32, '\p{Bidi_Class=segmentseparator}', "");
Expect(1, 32, '\p{^Bidi_Class=segmentseparator}', "");
Expect(1, 32, '\P{Bidi_Class=segmentseparator}', "");
Expect(0, 32, '\P{^Bidi_Class=segmentseparator}', "");
Expect(1, 31, '\p{Bidi_Class= segment_Separator}', "");
Expect(0, 31, '\p{^Bidi_Class= segment_Separator}', "");
Expect(0, 31, '\P{Bidi_Class= segment_Separator}', "");
Expect(1, 31, '\P{^Bidi_Class= segment_Separator}', "");
Expect(0, 32, '\p{Bidi_Class= segment_Separator}', "");
Expect(1, 32, '\p{^Bidi_Class= segment_Separator}', "");
Expect(1, 32, '\P{Bidi_Class= segment_Separator}', "");
Expect(0, 32, '\P{^Bidi_Class= segment_Separator}', "");
Error('\p{Bc=-/a/S}');
Error('\P{Bc=-/a/S}');
Expect(1, 31, '\p{Bc=s}', "");
Expect(0, 31, '\p{^Bc=s}', "");
Expect(0, 31, '\P{Bc=s}', "");
Expect(1, 31, '\P{^Bc=s}', "");
Expect(0, 32, '\p{Bc=s}', "");
Expect(1, 32, '\p{^Bc=s}', "");
Expect(1, 32, '\P{Bc=s}', "");
Expect(0, 32, '\P{^Bc=s}', "");
Expect(1, 31, '\p{Bc= -s}', "");
Expect(0, 31, '\p{^Bc= -s}', "");
Expect(0, 31, '\P{Bc= -s}', "");
Expect(1, 31, '\P{^Bc= -s}', "");
Expect(0, 32, '\p{Bc= -s}', "");
Expect(1, 32, '\p{^Bc= -s}', "");
Expect(1, 32, '\P{Bc= -s}', "");
Expect(0, 32, '\P{^Bc= -s}', "");
Error('\p{Is_Bidi_Class=:= Segment_SEPARATOR}');
Error('\P{Is_Bidi_Class=:= Segment_SEPARATOR}');
Expect(1, 31, '\p{Is_Bidi_Class=segmentseparator}', "");
Expect(0, 31, '\p{^Is_Bidi_Class=segmentseparator}', "");
Expect(0, 31, '\P{Is_Bidi_Class=segmentseparator}', "");
Expect(1, 31, '\P{^Is_Bidi_Class=segmentseparator}', "");
Expect(0, 32, '\p{Is_Bidi_Class=segmentseparator}', "");
Expect(1, 32, '\p{^Is_Bidi_Class=segmentseparator}', "");
Expect(1, 32, '\P{Is_Bidi_Class=segmentseparator}', "");
Expect(0, 32, '\P{^Is_Bidi_Class=segmentseparator}', "");
Expect(1, 31, '\p{Is_Bidi_Class: _ Segment_Separator}', "");
Expect(0, 31, '\p{^Is_Bidi_Class: _ Segment_Separator}', "");
Expect(0, 31, '\P{Is_Bidi_Class: _ Segment_Separator}', "");
Expect(1, 31, '\P{^Is_Bidi_Class: _ Segment_Separator}', "");
Expect(0, 32, '\p{Is_Bidi_Class: _ Segment_Separator}', "");
Expect(1, 32, '\p{^Is_Bidi_Class: _ Segment_Separator}', "");
Expect(1, 32, '\P{Is_Bidi_Class: _ Segment_Separator}', "");
Expect(0, 32, '\P{^Is_Bidi_Class: _ Segment_Separator}', "");
Error('\p{Is_Bc=/a/		S}');
Error('\P{Is_Bc=/a/		S}');
Expect(1, 31, '\p{Is_Bc=s}', "");
Expect(0, 31, '\p{^Is_Bc=s}', "");
Expect(0, 31, '\P{Is_Bc=s}', "");
Expect(1, 31, '\P{^Is_Bc=s}', "");
Expect(0, 32, '\p{Is_Bc=s}', "");
Expect(1, 32, '\p{^Is_Bc=s}', "");
Expect(1, 32, '\P{Is_Bc=s}', "");
Expect(0, 32, '\P{^Is_Bc=s}', "");
Expect(1, 31, '\p{Is_Bc=__S}', "");
Expect(0, 31, '\p{^Is_Bc=__S}', "");
Expect(0, 31, '\P{Is_Bc=__S}', "");
Expect(1, 31, '\P{^Is_Bc=__S}', "");
Expect(0, 32, '\p{Is_Bc=__S}', "");
Expect(1, 32, '\p{^Is_Bc=__S}', "");
Expect(1, 32, '\P{Is_Bc=__S}', "");
Expect(0, 32, '\P{^Is_Bc=__S}', "");
Error('\p{Bidi_Class=/a/ _White_Space}');
Error('\P{Bidi_Class=/a/ _White_Space}');
Expect(1, 12288, '\p{Bidi_Class=whitespace}', "");
Expect(0, 12288, '\p{^Bidi_Class=whitespace}', "");
Expect(0, 12288, '\P{Bidi_Class=whitespace}', "");
Expect(1, 12288, '\P{^Bidi_Class=whitespace}', "");
Expect(0, 12289, '\p{Bidi_Class=whitespace}', "");
Expect(1, 12289, '\p{^Bidi_Class=whitespace}', "");
Expect(1, 12289, '\P{Bidi_Class=whitespace}', "");
Expect(0, 12289, '\P{^Bidi_Class=whitespace}', "");
Expect(1, 12288, '\p{Bidi_Class:_White_Space}', "");
Expect(0, 12288, '\p{^Bidi_Class:_White_Space}', "");
Expect(0, 12288, '\P{Bidi_Class:_White_Space}', "");
Expect(1, 12288, '\P{^Bidi_Class:_White_Space}', "");
Expect(0, 12289, '\p{Bidi_Class:_White_Space}', "");
Expect(1, 12289, '\p{^Bidi_Class:_White_Space}', "");
Expect(1, 12289, '\P{Bidi_Class:_White_Space}', "");
Expect(0, 12289, '\P{^Bidi_Class:_White_Space}', "");
Error('\p{Bc:  :=WS}');
Error('\P{Bc:  :=WS}');
Expect(1, 12288, '\p{Bc:   ws}', "");
Expect(0, 12288, '\p{^Bc:   ws}', "");
Expect(0, 12288, '\P{Bc:   ws}', "");
Expect(1, 12288, '\P{^Bc:   ws}', "");
Expect(0, 12289, '\p{Bc:   ws}', "");
Expect(1, 12289, '\p{^Bc:   ws}', "");
Expect(1, 12289, '\P{Bc:   ws}', "");
Expect(0, 12289, '\P{^Bc:   ws}', "");
Expect(1, 12288, '\p{Bc=_ WS}', "");
Expect(0, 12288, '\p{^Bc=_ WS}', "");
Expect(0, 12288, '\P{Bc=_ WS}', "");
Expect(1, 12288, '\P{^Bc=_ WS}', "");
Expect(0, 12289, '\p{Bc=_ WS}', "");
Expect(1, 12289, '\p{^Bc=_ WS}', "");
Expect(1, 12289, '\P{Bc=_ WS}', "");
Expect(0, 12289, '\P{^Bc=_ WS}', "");
Error('\p{Is_Bidi_Class: 	White_SPACE/a/}');
Error('\P{Is_Bidi_Class: 	White_SPACE/a/}');
Expect(1, 12288, '\p{Is_Bidi_Class=whitespace}', "");
Expect(0, 12288, '\p{^Is_Bidi_Class=whitespace}', "");
Expect(0, 12288, '\P{Is_Bidi_Class=whitespace}', "");
Expect(1, 12288, '\P{^Is_Bidi_Class=whitespace}', "");
Expect(0, 12289, '\p{Is_Bidi_Class=whitespace}', "");
Expect(1, 12289, '\p{^Is_Bidi_Class=whitespace}', "");
Expect(1, 12289, '\P{Is_Bidi_Class=whitespace}', "");
Expect(0, 12289, '\P{^Is_Bidi_Class=whitespace}', "");
Expect(1, 12288, '\p{Is_Bidi_Class=	-WHITE_Space}', "");
Expect(0, 12288, '\p{^Is_Bidi_Class=	-WHITE_Space}', "");
Expect(0, 12288, '\P{Is_Bidi_Class=	-WHITE_Space}', "");
Expect(1, 12288, '\P{^Is_Bidi_Class=	-WHITE_Space}', "");
Expect(0, 12289, '\p{Is_Bidi_Class=	-WHITE_Space}', "");
Expect(1, 12289, '\p{^Is_Bidi_Class=	-WHITE_Space}', "");
Expect(1, 12289, '\P{Is_Bidi_Class=	-WHITE_Space}', "");
Expect(0, 12289, '\P{^Is_Bidi_Class=	-WHITE_Space}', "");
Error('\p{Is_Bc=-:=WS}');
Error('\P{Is_Bc=-:=WS}');
Expect(1, 12288, '\p{Is_Bc=ws}', "");
Expect(0, 12288, '\p{^Is_Bc=ws}', "");
Expect(0, 12288, '\P{Is_Bc=ws}', "");
Expect(1, 12288, '\P{^Is_Bc=ws}', "");
Expect(0, 12289, '\p{Is_Bc=ws}', "");
Expect(1, 12289, '\p{^Is_Bc=ws}', "");
Expect(1, 12289, '\P{Is_Bc=ws}', "");
Expect(0, 12289, '\P{^Is_Bc=ws}', "");
Expect(1, 12288, '\p{Is_Bc=_ WS}', "");
Expect(0, 12288, '\p{^Is_Bc=_ WS}', "");
Expect(0, 12288, '\P{Is_Bc=_ WS}', "");
Expect(1, 12288, '\P{^Is_Bc=_ WS}', "");
Expect(0, 12289, '\p{Is_Bc=_ WS}', "");
Expect(1, 12289, '\p{^Is_Bc=_ WS}', "");
Expect(1, 12289, '\P{Is_Bc=_ WS}', "");
Expect(0, 12289, '\P{^Is_Bc=_ WS}', "");
Error('\p{Block=	BASIC_LATIN/a/}');
Error('\P{Block=	BASIC_LATIN/a/}');
Expect(1, 127, '\p{Block=basiclatin}', "");
Expect(0, 127, '\p{^Block=basiclatin}', "");
Expect(0, 127, '\P{Block=basiclatin}', "");
Expect(1, 127, '\P{^Block=basiclatin}', "");
Expect(0, 128, '\p{Block=basiclatin}', "");
Expect(1, 128, '\p{^Block=basiclatin}', "");
Expect(1, 128, '\P{Block=basiclatin}', "");
Expect(0, 128, '\P{^Block=basiclatin}', "");
Expect(1, 127, '\p{Block=-Basic_latin}', "");
Expect(0, 127, '\p{^Block=-Basic_latin}', "");
Expect(0, 127, '\P{Block=-Basic_latin}', "");
Expect(1, 127, '\P{^Block=-Basic_latin}', "");
Expect(0, 128, '\p{Block=-Basic_latin}', "");
Expect(1, 128, '\p{^Block=-Basic_latin}', "");
Expect(1, 128, '\P{Block=-Basic_latin}', "");
Expect(0, 128, '\P{^Block=-Basic_latin}', "");
Error('\p{Blk=/a/ -ASCII}');
Error('\P{Blk=/a/ -ASCII}');
Expect(1, 127, '\p{Blk=ascii}', "");
Expect(0, 127, '\p{^Blk=ascii}', "");
Expect(0, 127, '\P{Blk=ascii}', "");
Expect(1, 127, '\P{^Blk=ascii}', "");
Expect(0, 128, '\p{Blk=ascii}', "");
Expect(1, 128, '\p{^Blk=ascii}', "");
Expect(1, 128, '\P{Blk=ascii}', "");
Expect(0, 128, '\P{^Blk=ascii}', "");
Expect(1, 127, '\p{Blk=-ASCII}', "");
Expect(0, 127, '\p{^Blk=-ASCII}', "");
Expect(0, 127, '\P{Blk=-ASCII}', "");
Expect(1, 127, '\P{^Blk=-ASCII}', "");
Expect(0, 128, '\p{Blk=-ASCII}', "");
Expect(1, 128, '\p{^Blk=-ASCII}', "");
Expect(1, 128, '\P{Blk=-ASCII}', "");
Expect(0, 128, '\P{^Blk=-ASCII}', "");
Error('\p{Is_Block=/a/ 	Basic_LATIN}');
Error('\P{Is_Block=/a/ 	Basic_LATIN}');
Expect(1, 127, '\p{Is_Block=basiclatin}', "");
Expect(0, 127, '\p{^Is_Block=basiclatin}', "");
Expect(0, 127, '\P{Is_Block=basiclatin}', "");
Expect(1, 127, '\P{^Is_Block=basiclatin}', "");
Expect(0, 128, '\p{Is_Block=basiclatin}', "");
Expect(1, 128, '\p{^Is_Block=basiclatin}', "");
Expect(1, 128, '\P{Is_Block=basiclatin}', "");
Expect(0, 128, '\P{^Is_Block=basiclatin}', "");
Expect(1, 127, '\p{Is_Block=	Basic_Latin}', "");
Expect(0, 127, '\p{^Is_Block=	Basic_Latin}', "");
Expect(0, 127, '\P{Is_Block=	Basic_Latin}', "");
Expect(1, 127, '\P{^Is_Block=	Basic_Latin}', "");
Expect(0, 128, '\p{Is_Block=	Basic_Latin}', "");
Expect(1, 128, '\p{^Is_Block=	Basic_Latin}', "");
Expect(1, 128, '\P{Is_Block=	Basic_Latin}', "");
Expect(0, 128, '\P{^Is_Block=	Basic_Latin}', "");
Error('\p{Is_Blk=/a/_ASCII}');
Error('\P{Is_Blk=/a/_ASCII}');
Expect(1, 127, '\p{Is_Blk=ascii}', "");
Expect(0, 127, '\p{^Is_Blk=ascii}', "");
Expect(0, 127, '\P{Is_Blk=ascii}', "");
Expect(1, 127, '\P{^Is_Blk=ascii}', "");
Expect(0, 128, '\p{Is_Blk=ascii}', "");
Expect(1, 128, '\p{^Is_Blk=ascii}', "");
Expect(1, 128, '\P{Is_Blk=ascii}', "");
Expect(0, 128, '\P{^Is_Blk=ascii}', "");
Expect(1, 127, '\p{Is_Blk:   _ASCII}', "");
Expect(0, 127, '\p{^Is_Blk:   _ASCII}', "");
Expect(0, 127, '\P{Is_Blk:   _ASCII}', "");
Expect(1, 127, '\P{^Is_Blk:   _ASCII}', "");
Expect(0, 128, '\p{Is_Blk:   _ASCII}', "");
Expect(1, 128, '\p{^Is_Blk:   _ASCII}', "");
Expect(1, 128, '\P{Is_Blk:   _ASCII}', "");
Expect(0, 128, '\P{^Is_Blk:   _ASCII}', "");
Error('\p{Block=		AEGEAN_numbers:=}');
Error('\P{Block=		AEGEAN_numbers:=}');
Expect(1, 65855, '\p{Block=aegeannumbers}', "");
Expect(0, 65855, '\p{^Block=aegeannumbers}', "");
Expect(0, 65855, '\P{Block=aegeannumbers}', "");
Expect(1, 65855, '\P{^Block=aegeannumbers}', "");
Expect(0, 65856, '\p{Block=aegeannumbers}', "");
Expect(1, 65856, '\p{^Block=aegeannumbers}', "");
Expect(1, 65856, '\P{Block=aegeannumbers}', "");
Expect(0, 65856, '\P{^Block=aegeannumbers}', "");
Expect(1, 65855, '\p{Block=_aegean_Numbers}', "");
Expect(0, 65855, '\p{^Block=_aegean_Numbers}', "");
Expect(0, 65855, '\P{Block=_aegean_Numbers}', "");
Expect(1, 65855, '\P{^Block=_aegean_Numbers}', "");
Expect(0, 65856, '\p{Block=_aegean_Numbers}', "");
Expect(1, 65856, '\p{^Block=_aegean_Numbers}', "");
Expect(1, 65856, '\P{Block=_aegean_Numbers}', "");
Expect(0, 65856, '\P{^Block=_aegean_Numbers}', "");
Error('\p{Blk=	/a/aegean_numbers}');
Error('\P{Blk=	/a/aegean_numbers}');
Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
Expect(0, 65856, '\p{Blk=aegeannumbers}', "");
Expect(1, 65856, '\p{^Blk=aegeannumbers}', "");
Expect(1, 65856, '\P{Blk=aegeannumbers}', "");
Expect(0, 65856, '\P{^Blk=aegeannumbers}', "");
Expect(1, 65855, '\p{Blk=-aegean_Numbers}', "");
Expect(0, 65855, '\p{^Blk=-aegean_Numbers}', "");
Expect(0, 65855, '\P{Blk=-aegean_Numbers}', "");
Expect(1, 65855, '\P{^Blk=-aegean_Numbers}', "");
Expect(0, 65856, '\p{Blk=-aegean_Numbers}', "");
Expect(1, 65856, '\p{^Blk=-aegean_Numbers}', "");
Expect(1, 65856, '\P{Blk=-aegean_Numbers}', "");
Expect(0, 65856, '\P{^Blk=-aegean_Numbers}', "");
Error('\p{Is_Block=		Aegean_numbers:=}');
Error('\P{Is_Block=		Aegean_numbers:=}');
Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
Expect(0, 65856, '\p{Is_Block=aegeannumbers}', "");
Expect(1, 65856, '\p{^Is_Block=aegeannumbers}', "");
Expect(1, 65856, '\P{Is_Block=aegeannumbers}', "");
Expect(0, 65856, '\P{^Is_Block=aegeannumbers}', "");
Expect(1, 65855, '\p{Is_Block:		-AEGEAN_Numbers}', "");
Expect(0, 65855, '\p{^Is_Block:		-AEGEAN_Numbers}', "");
Expect(0, 65855, '\P{Is_Block:		-AEGEAN_Numbers}', "");
Expect(1, 65855, '\P{^Is_Block:		-AEGEAN_Numbers}', "");
Expect(0, 65856, '\p{Is_Block:		-AEGEAN_Numbers}', "");
Expect(1, 65856, '\p{^Is_Block:		-AEGEAN_Numbers}', "");
Expect(1, 65856, '\P{Is_Block:		-AEGEAN_Numbers}', "");
Expect(0, 65856, '\P{^Is_Block:		-AEGEAN_Numbers}', "");
Error('\p{Is_Blk=:=_Aegean_NUMBERS}');
Error('\P{Is_Blk=:=_Aegean_NUMBERS}');
Expect(1, 65855, '\p{Is_Blk:	aegeannumbers}', "");
Expect(0, 65855, '\p{^Is_Blk:	aegeannumbers}', "");
Expect(0, 65855, '\P{Is_Blk:	aegeannumbers}', "");
Expect(1, 65855, '\P{^Is_Blk:	aegeannumbers}', "");
Expect(0, 65856, '\p{Is_Blk:	aegeannumbers}', "");
Expect(1, 65856, '\p{^Is_Blk:	aegeannumbers}', "");
Expect(1, 65856, '\P{Is_Blk:	aegeannumbers}', "");
Expect(0, 65856, '\P{^Is_Blk:	aegeannumbers}', "");
Expect(1, 65855, '\p{Is_Blk:   _Aegean_Numbers}', "");
Expect(0, 65855, '\p{^Is_Blk:   _Aegean_Numbers}', "");
Expect(0, 65855, '\P{Is_Blk:   _Aegean_Numbers}', "");
Expect(1, 65855, '\P{^Is_Blk:   _Aegean_Numbers}', "");
Expect(0, 65856, '\p{Is_Blk:   _Aegean_Numbers}', "");
Expect(1, 65856, '\p{^Is_Blk:   _Aegean_Numbers}', "");
Expect(1, 65856, '\P{Is_Blk:   _Aegean_Numbers}', "");
Expect(0, 65856, '\P{^Is_Blk:   _Aegean_Numbers}', "");
Error('\p{Block=:= Ahom}');
Error('\P{Block=:= Ahom}');
Expect(1, 71487, '\p{Block=ahom}', "");
Expect(0, 71487, '\p{^Block=ahom}', "");
Expect(0, 71487, '\P{Block=ahom}', "");
Expect(1, 71487, '\P{^Block=ahom}', "");
Expect(0, 71488, '\p{Block=ahom}', "");
Expect(1, 71488, '\p{^Block=ahom}', "");
Expect(1, 71488, '\P{Block=ahom}', "");
Expect(0, 71488, '\P{^Block=ahom}', "");
Expect(1, 71487, '\p{Block=- Ahom}', "");
Expect(0, 71487, '\p{^Block=- Ahom}', "");
Expect(0, 71487, '\P{Block=- Ahom}', "");
Expect(1, 71487, '\P{^Block=- Ahom}', "");
Expect(0, 71488, '\p{Block=- Ahom}', "");
Expect(1, 71488, '\p{^Block=- Ahom}', "");
Expect(1, 71488, '\P{Block=- Ahom}', "");
Expect(0, 71488, '\P{^Block=- Ahom}', "");
Error('\p{Blk=_ Ahom:=}');
Error('\P{Blk=_ Ahom:=}');
Expect(1, 71487, '\p{Blk=ahom}', "");
Expect(0, 71487, '\p{^Blk=ahom}', "");
Expect(0, 71487, '\P{Blk=ahom}', "");
Expect(1, 71487, '\P{^Blk=ahom}', "");
Expect(0, 71488, '\p{Blk=ahom}', "");
Expect(1, 71488, '\p{^Blk=ahom}', "");
Expect(1, 71488, '\P{Blk=ahom}', "");
Expect(0, 71488, '\P{^Blk=ahom}', "");
Expect(1, 71487, '\p{Blk=	 Ahom}', "");
Expect(0, 71487, '\p{^Blk=	 Ahom}', "");
Expect(0, 71487, '\P{Blk=	 Ahom}', "");
Expect(1, 71487, '\P{^Blk=	 Ahom}', "");
Expect(0, 71488, '\p{Blk=	 Ahom}', "");
Expect(1, 71488, '\p{^Blk=	 Ahom}', "");
Expect(1, 71488, '\P{Blk=	 Ahom}', "");
Expect(0, 71488, '\P{^Blk=	 Ahom}', "");
Error('\p{Is_Block=:=-	ahom}');
Error('\P{Is_Block=:=-	ahom}');
Expect(1, 71487, '\p{Is_Block=ahom}', "");
Expect(0, 71487, '\p{^Is_Block=ahom}', "");
Expect(0, 71487, '\P{Is_Block=ahom}', "");
Expect(1, 71487, '\P{^Is_Block=ahom}', "");
Expect(0, 71488, '\p{Is_Block=ahom}', "");
Expect(1, 71488, '\p{^Is_Block=ahom}', "");
Expect(1, 71488, '\P{Is_Block=ahom}', "");
Expect(0, 71488, '\P{^Is_Block=ahom}', "");
Expect(1, 71487, '\p{Is_Block:    ahom}', "");
Expect(0, 71487, '\p{^Is_Block:    ahom}', "");
Expect(0, 71487, '\P{Is_Block:    ahom}', "");
Expect(1, 71487, '\P{^Is_Block:    ahom}', "");
Expect(0, 71488, '\p{Is_Block:    ahom}', "");
Expect(1, 71488, '\p{^Is_Block:    ahom}', "");
Expect(1, 71488, '\P{Is_Block:    ahom}', "");
Expect(0, 71488, '\P{^Is_Block:    ahom}', "");
Error('\p{Is_Blk: 	:=AHOM}');
Error('\P{Is_Blk: 	:=AHOM}');
Expect(1, 71487, '\p{Is_Blk=ahom}', "");
Expect(0, 71487, '\p{^Is_Blk=ahom}', "");
Expect(0, 71487, '\P{Is_Blk=ahom}', "");
Expect(1, 71487, '\P{^Is_Blk=ahom}', "");
Expect(0, 71488, '\p{Is_Blk=ahom}', "");
Expect(1, 71488, '\p{^Is_Blk=ahom}', "");
Expect(1, 71488, '\P{Is_Blk=ahom}', "");
Expect(0, 71488, '\P{^Is_Blk=ahom}', "");
Expect(1, 71487, '\p{Is_Blk=__ahom}', "");
Expect(0, 71487, '\p{^Is_Blk=__ahom}', "");
Expect(0, 71487, '\P{Is_Blk=__ahom}', "");
Expect(1, 71487, '\P{^Is_Blk=__ahom}', "");
Expect(0, 71488, '\p{Is_Blk=__ahom}', "");
Expect(1, 71488, '\p{^Is_Blk=__ahom}', "");
Expect(1, 71488, '\P{Is_Blk=__ahom}', "");
Expect(0, 71488, '\P{^Is_Blk=__ahom}', "");
Error('\p{Block=_:=Alchemical_Symbols}');
Error('\P{Block=_:=Alchemical_Symbols}');
Expect(1, 128895, '\p{Block:	alchemicalsymbols}', "");
Expect(0, 128895, '\p{^Block:	alchemicalsymbols}', "");
Expect(0, 128895, '\P{Block:	alchemicalsymbols}', "");
Expect(1, 128895, '\P{^Block:	alchemicalsymbols}', "");
Expect(0, 128896, '\p{Block:	alchemicalsymbols}', "");
Expect(1, 128896, '\p{^Block:	alchemicalsymbols}', "");
Expect(1, 128896, '\P{Block:	alchemicalsymbols}', "");
Expect(0, 128896, '\P{^Block:	alchemicalsymbols}', "");
Expect(1, 128895, '\p{Block=_Alchemical_Symbols}', "");
Expect(0, 128895, '\p{^Block=_Alchemical_Symbols}', "");
Expect(0, 128895, '\P{Block=_Alchemical_Symbols}', "");
Expect(1, 128895, '\P{^Block=_Alchemical_Symbols}', "");
Expect(0, 128896, '\p{Block=_Alchemical_Symbols}', "");
Expect(1, 128896, '\p{^Block=_Alchemical_Symbols}', "");
Expect(1, 128896, '\P{Block=_Alchemical_Symbols}', "");
Expect(0, 128896, '\P{^Block=_Alchemical_Symbols}', "");
Error('\p{Blk= :=Alchemical}');
Error('\P{Blk= :=Alchemical}');
Expect(1, 128895, '\p{Blk:alchemical}', "");
Expect(0, 128895, '\p{^Blk:alchemical}', "");
Expect(0, 128895, '\P{Blk:alchemical}', "");
Expect(1, 128895, '\P{^Blk:alchemical}', "");
Expect(0, 128896, '\p{Blk:alchemical}', "");
Expect(1, 128896, '\p{^Blk:alchemical}', "");
Expect(1, 128896, '\P{Blk:alchemical}', "");
Expect(0, 128896, '\P{^Blk:alchemical}', "");
Expect(1, 128895, '\p{Blk=	_Alchemical}', "");
Expect(0, 128895, '\p{^Blk=	_Alchemical}', "");
Expect(0, 128895, '\P{Blk=	_Alchemical}', "");
Expect(1, 128895, '\P{^Blk=	_Alchemical}', "");
Expect(0, 128896, '\p{Blk=	_Alchemical}', "");
Expect(1, 128896, '\p{^Blk=	_Alchemical}', "");
Expect(1, 128896, '\P{Blk=	_Alchemical}', "");
Expect(0, 128896, '\P{^Blk=	_Alchemical}', "");
Error('\p{Is_Block: :=alchemical_Symbols}');
Error('\P{Is_Block: :=alchemical_Symbols}');
Expect(1, 128895, '\p{Is_Block=alchemicalsymbols}', "");
Expect(0, 128895, '\p{^Is_Block=alchemicalsymbols}', "");
Expect(0, 128895, '\P{Is_Block=alchemicalsymbols}', "");
Expect(1, 128895, '\P{^Is_Block=alchemicalsymbols}', "");
Expect(0, 128896, '\p{Is_Block=alchemicalsymbols}', "");
Expect(1, 128896, '\p{^Is_Block=alchemicalsymbols}', "");
Expect(1, 128896, '\P{Is_Block=alchemicalsymbols}', "");
Expect(0, 128896, '\P{^Is_Block=alchemicalsymbols}', "");
Expect(1, 128895, '\p{Is_Block= 	alchemical_symbols}', "");
Expect(0, 128895, '\p{^Is_Block= 	alchemical_symbols}', "");
Expect(0, 128895, '\P{Is_Block= 	alchemical_symbols}', "");
Expect(1, 128895, '\P{^Is_Block= 	alchemical_symbols}', "");
Expect(0, 128896, '\p{Is_Block= 	alchemical_symbols}', "");
Expect(1, 128896, '\p{^Is_Block= 	alchemical_symbols}', "");
Expect(1, 128896, '\P{Is_Block= 	alchemical_symbols}', "");
Expect(0, 128896, '\P{^Is_Block= 	alchemical_symbols}', "");
Error('\p{Is_Blk=:=alchemical}');
Error('\P{Is_Blk=:=alchemical}');
Expect(1, 128895, '\p{Is_Blk:   alchemical}', "");
Expect(0, 128895, '\p{^Is_Blk:   alchemical}', "");
Expect(0, 128895, '\P{Is_Blk:   alchemical}', "");
Expect(1, 128895, '\P{^Is_Blk:   alchemical}', "");
Expect(0, 128896, '\p{Is_Blk:   alchemical}', "");
Expect(1, 128896, '\p{^Is_Blk:   alchemical}', "");
Expect(1, 128896, '\P{Is_Blk:   alchemical}', "");
Expect(0, 128896, '\P{^Is_Blk:   alchemical}', "");
Expect(1, 128895, '\p{Is_Blk= -ALCHEMICAL}', "");
Expect(0, 128895, '\p{^Is_Blk= -ALCHEMICAL}', "");
Expect(0, 128895, '\P{Is_Blk= -ALCHEMICAL}', "");
Expect(1, 128895, '\P{^Is_Blk= -ALCHEMICAL}', "");
Expect(0, 128896, '\p{Is_Blk= -ALCHEMICAL}', "");
Expect(1, 128896, '\p{^Is_Blk= -ALCHEMICAL}', "");
Expect(1, 128896, '\P{Is_Blk= -ALCHEMICAL}', "");
Expect(0, 128896, '\P{^Is_Blk= -ALCHEMICAL}', "");
Error('\p{Block= :=Alphabetic_PRESENTATION_forms}');
Error('\P{Block= :=Alphabetic_PRESENTATION_forms}');
Expect(1, 64335, '\p{Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Block=alphabeticpresentationforms}', "");
Expect(0, 64336, '\p{Block=alphabeticpresentationforms}', "");
Expect(1, 64336, '\p{^Block=alphabeticpresentationforms}', "");
Expect(1, 64336, '\P{Block=alphabeticpresentationforms}', "");
Expect(0, 64336, '\P{^Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Block=_	Alphabetic_Presentation_forms}', "");
Expect(0, 64335, '\p{^Block=_	Alphabetic_Presentation_forms}', "");
Expect(0, 64335, '\P{Block=_	Alphabetic_Presentation_forms}', "");
Expect(1, 64335, '\P{^Block=_	Alphabetic_Presentation_forms}', "");
Expect(0, 64336, '\p{Block=_	Alphabetic_Presentation_forms}', "");
Expect(1, 64336, '\p{^Block=_	Alphabetic_Presentation_forms}', "");
Expect(1, 64336, '\P{Block=_	Alphabetic_Presentation_forms}', "");
Expect(0, 64336, '\P{^Block=_	Alphabetic_Presentation_forms}', "");
Error('\p{Blk=	-ALPHABETIC_PF:=}');
Error('\P{Blk=	-ALPHABETIC_PF:=}');
Expect(1, 64335, '\p{Blk=alphabeticpf}', "");
Expect(0, 64335, '\p{^Blk=alphabeticpf}', "");
Expect(0, 64335, '\P{Blk=alphabeticpf}', "");
Expect(1, 64335, '\P{^Blk=alphabeticpf}', "");
Expect(0, 64336, '\p{Blk=alphabeticpf}', "");
Expect(1, 64336, '\p{^Blk=alphabeticpf}', "");
Expect(1, 64336, '\P{Blk=alphabeticpf}', "");
Expect(0, 64336, '\P{^Blk=alphabeticpf}', "");
Expect(1, 64335, '\p{Blk=-_Alphabetic_PF}', "");
Expect(0, 64335, '\p{^Blk=-_Alphabetic_PF}', "");
Expect(0, 64335, '\P{Blk=-_Alphabetic_PF}', "");
Expect(1, 64335, '\P{^Blk=-_Alphabetic_PF}', "");
Expect(0, 64336, '\p{Blk=-_Alphabetic_PF}', "");
Expect(1, 64336, '\p{^Blk=-_Alphabetic_PF}', "");
Expect(1, 64336, '\P{Blk=-_Alphabetic_PF}', "");
Expect(0, 64336, '\P{^Blk=-_Alphabetic_PF}', "");
Error('\p{Is_Block:   --ALPHABETIC_Presentation_Forms/a/}');
Error('\P{Is_Block:   --ALPHABETIC_Presentation_Forms/a/}');
Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64336, '\p{Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64336, '\p{^Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64336, '\P{Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64336, '\P{^Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Is_Block=	alphabetic_Presentation_forms}', "");
Expect(0, 64335, '\p{^Is_Block=	alphabetic_Presentation_forms}', "");
Expect(0, 64335, '\P{Is_Block=	alphabetic_Presentation_forms}', "");
Expect(1, 64335, '\P{^Is_Block=	alphabetic_Presentation_forms}', "");
Expect(0, 64336, '\p{Is_Block=	alphabetic_Presentation_forms}', "");
Expect(1, 64336, '\p{^Is_Block=	alphabetic_Presentation_forms}', "");
Expect(1, 64336, '\P{Is_Block=	alphabetic_Presentation_forms}', "");
Expect(0, 64336, '\P{^Is_Block=	alphabetic_Presentation_forms}', "");
Error('\p{Is_Blk=:=-_Alphabetic_PF}');
Error('\P{Is_Blk=:=-_Alphabetic_PF}');
Expect(1, 64335, '\p{Is_Blk=alphabeticpf}', "");
Expect(0, 64335, '\p{^Is_Blk=alphabeticpf}', "");
Expect(0, 64335, '\P{Is_Blk=alphabeticpf}', "");
Expect(1, 64335, '\P{^Is_Blk=alphabeticpf}', "");
Expect(0, 64336, '\p{Is_Blk=alphabeticpf}', "");
Expect(1, 64336, '\p{^Is_Blk=alphabeticpf}', "");
Expect(1, 64336, '\P{Is_Blk=alphabeticpf}', "");
Expect(0, 64336, '\P{^Is_Blk=alphabeticpf}', "");
Expect(1, 64335, '\p{Is_Blk=-	Alphabetic_PF}', "");
Expect(0, 64335, '\p{^Is_Blk=-	Alphabetic_PF}', "");
Expect(0, 64335, '\P{Is_Blk=-	Alphabetic_PF}', "");
Expect(1, 64335, '\P{^Is_Blk=-	Alphabetic_PF}', "");
Expect(0, 64336, '\p{Is_Blk=-	Alphabetic_PF}', "");
Expect(1, 64336, '\p{^Is_Blk=-	Alphabetic_PF}', "");
Expect(1, 64336, '\P{Is_Blk=-	Alphabetic_PF}', "");
Expect(0, 64336, '\P{^Is_Blk=-	Alphabetic_PF}', "");
Error('\p{Block=:=Anatolian_HIEROGLYPHS}');
Error('\P{Block=:=Anatolian_HIEROGLYPHS}');
Expect(1, 83583, '\p{Block=anatolianhieroglyphs}', "");
Expect(0, 83583, '\p{^Block=anatolianhieroglyphs}', "");
Expect(0, 83583, '\P{Block=anatolianhieroglyphs}', "");
Expect(1, 83583, '\P{^Block=anatolianhieroglyphs}', "");
Expect(0, 83584, '\p{Block=anatolianhieroglyphs}', "");
Expect(1, 83584, '\p{^Block=anatolianhieroglyphs}', "");
Expect(1, 83584, '\P{Block=anatolianhieroglyphs}', "");
Expect(0, 83584, '\P{^Block=anatolianhieroglyphs}', "");
Expect(1, 83583, '\p{Block=	-ANATOLIAN_HIEROGLYPHS}', "");
Expect(0, 83583, '\p{^Block=	-ANATOLIAN_HIEROGLYPHS}', "");
Expect(0, 83583, '\P{Block=	-ANATOLIAN_HIEROGLYPHS}', "");
Expect(1, 83583, '\P{^Block=	-ANATOLIAN_HIEROGLYPHS}', "");
Expect(0, 83584, '\p{Block=	-ANATOLIAN_HIEROGLYPHS}', "");
Expect(1, 83584, '\p{^Block=	-ANATOLIAN_HIEROGLYPHS}', "");
Expect(1, 83584, '\P{Block=	-ANATOLIAN_HIEROGLYPHS}', "");
Expect(0, 83584, '\P{^Block=	-ANATOLIAN_HIEROGLYPHS}', "");
Error('\p{Blk=_Anatolian_Hieroglyphs/a/}');
Error('\P{Blk=_Anatolian_Hieroglyphs/a/}');
Expect(1, 83583, '\p{Blk=anatolianhieroglyphs}', "");
Expect(0, 83583, '\p{^Blk=anatolianhieroglyphs}', "");
Expect(0, 83583, '\P{Blk=anatolianhieroglyphs}', "");
Expect(1, 83583, '\P{^Blk=anatolianhieroglyphs}', "");
Expect(0, 83584, '\p{Blk=anatolianhieroglyphs}', "");
Expect(1, 83584, '\p{^Blk=anatolianhieroglyphs}', "");
Expect(1, 83584, '\P{Blk=anatolianhieroglyphs}', "");
Expect(0, 83584, '\P{^Blk=anatolianhieroglyphs}', "");
Expect(1, 83583, '\p{Blk=-ANATOLIAN_Hieroglyphs}', "");
Expect(0, 83583, '\p{^Blk=-ANATOLIAN_Hieroglyphs}', "");
Expect(0, 83583, '\P{Blk=-ANATOLIAN_Hieroglyphs}', "");
Expect(1, 83583, '\P{^Blk=-ANATOLIAN_Hieroglyphs}', "");
Expect(0, 83584, '\p{Blk=-ANATOLIAN_Hieroglyphs}', "");
Expect(1, 83584, '\p{^Blk=-ANATOLIAN_Hieroglyphs}', "");
Expect(1, 83584, '\P{Blk=-ANATOLIAN_Hieroglyphs}', "");
Expect(0, 83584, '\P{^Blk=-ANATOLIAN_Hieroglyphs}', "");
Error('\p{Is_Block=-_ANATOLIAN_HIEROGLYPHS/a/}');
Error('\P{Is_Block=-_ANATOLIAN_HIEROGLYPHS/a/}');
Expect(1, 83583, '\p{Is_Block:   anatolianhieroglyphs}', "");
Expect(0, 83583, '\p{^Is_Block:   anatolianhieroglyphs}', "");
Expect(0, 83583, '\P{Is_Block:   anatolianhieroglyphs}', "");
Expect(1, 83583, '\P{^Is_Block:   anatolianhieroglyphs}', "");
Expect(0, 83584, '\p{Is_Block:   anatolianhieroglyphs}', "");
Expect(1, 83584, '\p{^Is_Block:   anatolianhieroglyphs}', "");
Expect(1, 83584, '\P{Is_Block:   anatolianhieroglyphs}', "");
Expect(0, 83584, '\P{^Is_Block:   anatolianhieroglyphs}', "");
Expect(1, 83583, '\p{Is_Block=__Anatolian_Hieroglyphs}', "");
Expect(0, 83583, '\p{^Is_Block=__Anatolian_Hieroglyphs}', "");
Expect(0, 83583, '\P{Is_Block=__Anatolian_Hieroglyphs}', "");
Expect(1, 83583, '\P{^Is_Block=__Anatolian_Hieroglyphs}', "");
Expect(0, 83584, '\p{Is_Block=__Anatolian_Hieroglyphs}', "");
Expect(1, 83584, '\p{^Is_Block=__Anatolian_Hieroglyphs}', "");
Expect(1, 83584, '\P{Is_Block=__Anatolian_Hieroglyphs}', "");
Expect(0, 83584, '\P{^Is_Block=__Anatolian_Hieroglyphs}', "");
Error('\p{Is_Blk=		ANATOLIAN_HIEROGLYPHS:=}');
Error('\P{Is_Blk=		ANATOLIAN_HIEROGLYPHS:=}');
Expect(1, 83583, '\p{Is_Blk=anatolianhieroglyphs}', "");
Expect(0, 83583, '\p{^Is_Blk=anatolianhieroglyphs}', "");
Expect(0, 83583, '\P{Is_Blk=anatolianhieroglyphs}', "");
Expect(1, 83583, '\P{^Is_Blk=anatolianhieroglyphs}', "");
Expect(0, 83584, '\p{Is_Blk=anatolianhieroglyphs}', "");
Expect(1, 83584, '\p{^Is_Blk=anatolianhieroglyphs}', "");
Expect(1, 83584, '\P{Is_Blk=anatolianhieroglyphs}', "");
Expect(0, 83584, '\P{^Is_Blk=anatolianhieroglyphs}', "");
Expect(1, 83583, '\p{Is_Blk= Anatolian_hieroglyphs}', "");
Expect(0, 83583, '\p{^Is_Blk= Anatolian_hieroglyphs}', "");
Expect(0, 83583, '\P{Is_Blk= Anatolian_hieroglyphs}', "");
Expect(1, 83583, '\P{^Is_Blk= Anatolian_hieroglyphs}', "");
Expect(0, 83584, '\p{Is_Blk= Anatolian_hieroglyphs}', "");
Expect(1, 83584, '\p{^Is_Blk= Anatolian_hieroglyphs}', "");
Expect(1, 83584, '\P{Is_Blk= Anatolian_hieroglyphs}', "");
Expect(0, 83584, '\P{^Is_Blk= Anatolian_hieroglyphs}', "");
Error('\p{Block= :=Ancient_Greek_Musical_notation}');
Error('\P{Block= :=Ancient_Greek_Musical_notation}');
Expect(1, 119375, '\p{Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Block=ancientgreekmusicalnotation}', "");
Expect(0, 119376, '\p{Block=ancientgreekmusicalnotation}', "");
Expect(1, 119376, '\p{^Block=ancientgreekmusicalnotation}', "");
Expect(1, 119376, '\P{Block=ancientgreekmusicalnotation}', "");
Expect(0, 119376, '\P{^Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Block= Ancient_Greek_musical_NOTATION}', "");
Expect(0, 119375, '\p{^Block= Ancient_Greek_musical_NOTATION}', "");
Expect(0, 119375, '\P{Block= Ancient_Greek_musical_NOTATION}', "");
Expect(1, 119375, '\P{^Block= Ancient_Greek_musical_NOTATION}', "");
Expect(0, 119376, '\p{Block= Ancient_Greek_musical_NOTATION}', "");
Expect(1, 119376, '\p{^Block= Ancient_Greek_musical_NOTATION}', "");
Expect(1, 119376, '\P{Block= Ancient_Greek_musical_NOTATION}', "");
Expect(0, 119376, '\P{^Block= Ancient_Greek_musical_NOTATION}', "");
Error('\p{Blk=:=Ancient_greek_MUSIC}');
Error('\P{Blk=:=Ancient_greek_MUSIC}');
Expect(1, 119375, '\p{Blk=ancientgreekmusic}', "");
Expect(0, 119375, '\p{^Blk=ancientgreekmusic}', "");
Expect(0, 119375, '\P{Blk=ancientgreekmusic}', "");
Expect(1, 119375, '\P{^Blk=ancientgreekmusic}', "");
Expect(0, 119376, '\p{Blk=ancientgreekmusic}', "");
Expect(1, 119376, '\p{^Blk=ancientgreekmusic}', "");
Expect(1, 119376, '\P{Blk=ancientgreekmusic}', "");
Expect(0, 119376, '\P{^Blk=ancientgreekmusic}', "");
Expect(1, 119375, '\p{Blk= 	ANCIENT_greek_MUSIC}', "");
Expect(0, 119375, '\p{^Blk= 	ANCIENT_greek_MUSIC}', "");
Expect(0, 119375, '\P{Blk= 	ANCIENT_greek_MUSIC}', "");
Expect(1, 119375, '\P{^Blk= 	ANCIENT_greek_MUSIC}', "");
Expect(0, 119376, '\p{Blk= 	ANCIENT_greek_MUSIC}', "");
Expect(1, 119376, '\p{^Blk= 	ANCIENT_greek_MUSIC}', "");
Expect(1, 119376, '\P{Blk= 	ANCIENT_greek_MUSIC}', "");
Expect(0, 119376, '\P{^Blk= 	ANCIENT_greek_MUSIC}', "");
Error('\p{Is_Block=  ancient_greek_Musical_Notation/a/}');
Error('\P{Is_Block=  ancient_greek_Musical_Notation/a/}');
Expect(1, 119375, '\p{Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119376, '\p{Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119376, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119376, '\P{Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119376, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Is_Block=-	ancient_Greek_musical_Notation}', "");
Expect(0, 119375, '\p{^Is_Block=-	ancient_Greek_musical_Notation}', "");
Expect(0, 119375, '\P{Is_Block=-	ancient_Greek_musical_Notation}', "");
Expect(1, 119375, '\P{^Is_Block=-	ancient_Greek_musical_Notation}', "");
Expect(0, 119376, '\p{Is_Block=-	ancient_Greek_musical_Notation}', "");
Expect(1, 119376, '\p{^Is_Block=-	ancient_Greek_musical_Notation}', "");
Expect(1, 119376, '\P{Is_Block=-	ancient_Greek_musical_Notation}', "");
Expect(0, 119376, '\P{^Is_Block=-	ancient_Greek_musical_Notation}', "");
Error('\p{Is_Blk=_	Ancient_Greek_MUSIC/a/}');
Error('\P{Is_Blk=_	Ancient_Greek_MUSIC/a/}');
Expect(1, 119375, '\p{Is_Blk=ancientgreekmusic}', "");
Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusic}', "");
Expect(0, 119375, '\P{Is_Blk=ancientgreekmusic}', "");
Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusic}', "");
Expect(0, 119376, '\p{Is_Blk=ancientgreekmusic}', "");
Expect(1, 119376, '\p{^Is_Blk=ancientgreekmusic}', "");
Expect(1, 119376, '\P{Is_Blk=ancientgreekmusic}', "");
Expect(0, 119376, '\P{^Is_Blk=ancientgreekmusic}', "");
Expect(1, 119375, '\p{Is_Blk=		Ancient_Greek_MUSIC}', "");
Expect(0, 119375, '\p{^Is_Blk=		Ancient_Greek_MUSIC}', "");
Expect(0, 119375, '\P{Is_Blk=		Ancient_Greek_MUSIC}', "");
Expect(1, 119375, '\P{^Is_Blk=		Ancient_Greek_MUSIC}', "");
Expect(0, 119376, '\p{Is_Blk=		Ancient_Greek_MUSIC}', "");
Expect(1, 119376, '\p{^Is_Blk=		Ancient_Greek_MUSIC}', "");
Expect(1, 119376, '\P{Is_Blk=		Ancient_Greek_MUSIC}', "");
Expect(0, 119376, '\P{^Is_Blk=		Ancient_Greek_MUSIC}', "");
Error('\p{Block=_ ancient_GREEK_numbers:=}');
Error('\P{Block=_ ancient_GREEK_numbers:=}');
Expect(1, 65935, '\p{Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Block=ancientgreeknumbers}', "");
Expect(0, 65936, '\p{Block=ancientgreeknumbers}', "");
Expect(1, 65936, '\p{^Block=ancientgreeknumbers}', "");
Expect(1, 65936, '\P{Block=ancientgreeknumbers}', "");
Expect(0, 65936, '\P{^Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Block=	ancient_greek_Numbers}', "");
Expect(0, 65935, '\p{^Block=	ancient_greek_Numbers}', "");
Expect(0, 65935, '\P{Block=	ancient_greek_Numbers}', "");
Expect(1, 65935, '\P{^Block=	ancient_greek_Numbers}', "");
Expect(0, 65936, '\p{Block=	ancient_greek_Numbers}', "");
Expect(1, 65936, '\p{^Block=	ancient_greek_Numbers}', "");
Expect(1, 65936, '\P{Block=	ancient_greek_Numbers}', "");
Expect(0, 65936, '\P{^Block=	ancient_greek_Numbers}', "");
Error('\p{Blk=:= -Ancient_Greek_numbers}');
Error('\P{Blk=:= -Ancient_Greek_numbers}');
Expect(1, 65935, '\p{Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Blk=ancientgreeknumbers}', "");
Expect(0, 65936, '\p{Blk=ancientgreeknumbers}', "");
Expect(1, 65936, '\p{^Blk=ancientgreeknumbers}', "");
Expect(1, 65936, '\P{Blk=ancientgreeknumbers}', "");
Expect(0, 65936, '\P{^Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Blk=_ ANCIENT_GREEK_Numbers}', "");
Expect(0, 65935, '\p{^Blk=_ ANCIENT_GREEK_Numbers}', "");
Expect(0, 65935, '\P{Blk=_ ANCIENT_GREEK_Numbers}', "");
Expect(1, 65935, '\P{^Blk=_ ANCIENT_GREEK_Numbers}', "");
Expect(0, 65936, '\p{Blk=_ ANCIENT_GREEK_Numbers}', "");
Expect(1, 65936, '\p{^Blk=_ ANCIENT_GREEK_Numbers}', "");
Expect(1, 65936, '\P{Blk=_ ANCIENT_GREEK_Numbers}', "");
Expect(0, 65936, '\P{^Blk=_ ANCIENT_GREEK_Numbers}', "");
Error('\p{Is_Block=:= _ANCIENT_Greek_Numbers}');
Error('\P{Is_Block=:= _ANCIENT_Greek_Numbers}');
Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
Expect(0, 65936, '\p{Is_Block=ancientgreeknumbers}', "");
Expect(1, 65936, '\p{^Is_Block=ancientgreeknumbers}', "");
Expect(1, 65936, '\P{Is_Block=ancientgreeknumbers}', "");
Expect(0, 65936, '\P{^Is_Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Is_Block= ancient_Greek_Numbers}', "");
Expect(0, 65935, '\p{^Is_Block= ancient_Greek_Numbers}', "");
Expect(0, 65935, '\P{Is_Block= ancient_Greek_Numbers}', "");
Expect(1, 65935, '\P{^Is_Block= ancient_Greek_Numbers}', "");
Expect(0, 65936, '\p{Is_Block= ancient_Greek_Numbers}', "");
Expect(1, 65936, '\p{^Is_Block= ancient_Greek_Numbers}', "");
Expect(1, 65936, '\P{Is_Block= ancient_Greek_Numbers}', "");
Expect(0, 65936, '\P{^Is_Block= ancient_Greek_Numbers}', "");
Error('\p{Is_Blk= :=Ancient_Greek_Numbers}');
Error('\P{Is_Blk= :=Ancient_Greek_Numbers}');
Expect(1, 65935, '\p{Is_Blk:ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Is_Blk:ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Is_Blk:ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Is_Blk:ancientgreeknumbers}', "");
Expect(0, 65936, '\p{Is_Blk:ancientgreeknumbers}', "");
Expect(1, 65936, '\p{^Is_Blk:ancientgreeknumbers}', "");
Expect(1, 65936, '\P{Is_Blk:ancientgreeknumbers}', "");
Expect(0, 65936, '\P{^Is_Blk:ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Is_Blk=_ancient_greek_NUMBERS}', "");
Expect(0, 65935, '\p{^Is_Blk=_ancient_greek_NUMBERS}', "");
Expect(0, 65935, '\P{Is_Blk=_ancient_greek_NUMBERS}', "");
Expect(1, 65935, '\P{^Is_Blk=_ancient_greek_NUMBERS}', "");
Expect(0, 65936, '\p{Is_Blk=_ancient_greek_NUMBERS}', "");
Expect(1, 65936, '\p{^Is_Blk=_ancient_greek_NUMBERS}', "");
Expect(1, 65936, '\P{Is_Blk=_ancient_greek_NUMBERS}', "");
Expect(0, 65936, '\P{^Is_Blk=_ancient_greek_NUMBERS}', "");
Error('\p{Block=-ancient_SYMBOLS:=}');
Error('\P{Block=-ancient_SYMBOLS:=}');
Expect(1, 65999, '\p{Block=ancientsymbols}', "");
Expect(0, 65999, '\p{^Block=ancientsymbols}', "");
Expect(0, 65999, '\P{Block=ancientsymbols}', "");
Expect(1, 65999, '\P{^Block=ancientsymbols}', "");
Expect(0, 66000, '\p{Block=ancientsymbols}', "");
Expect(1, 66000, '\p{^Block=ancientsymbols}', "");
Expect(1, 66000, '\P{Block=ancientsymbols}', "");
Expect(0, 66000, '\P{^Block=ancientsymbols}', "");
Expect(1, 65999, '\p{Block=ANCIENT_Symbols}', "");
Expect(0, 65999, '\p{^Block=ANCIENT_Symbols}', "");
Expect(0, 65999, '\P{Block=ANCIENT_Symbols}', "");
Expect(1, 65999, '\P{^Block=ANCIENT_Symbols}', "");
Expect(0, 66000, '\p{Block=ANCIENT_Symbols}', "");
Expect(1, 66000, '\p{^Block=ANCIENT_Symbols}', "");
Expect(1, 66000, '\P{Block=ANCIENT_Symbols}', "");
Expect(0, 66000, '\P{^Block=ANCIENT_Symbols}', "");
Error('\p{Blk=	:=Ancient_Symbols}');
Error('\P{Blk=	:=Ancient_Symbols}');
Expect(1, 65999, '\p{Blk=ancientsymbols}', "");
Expect(0, 65999, '\p{^Blk=ancientsymbols}', "");
Expect(0, 65999, '\P{Blk=ancientsymbols}', "");
Expect(1, 65999, '\P{^Blk=ancientsymbols}', "");
Expect(0, 66000, '\p{Blk=ancientsymbols}', "");
Expect(1, 66000, '\p{^Blk=ancientsymbols}', "");
Expect(1, 66000, '\P{Blk=ancientsymbols}', "");
Expect(0, 66000, '\P{^Blk=ancientsymbols}', "");
Expect(1, 65999, '\p{Blk=_	Ancient_Symbols}', "");
Expect(0, 65999, '\p{^Blk=_	Ancient_Symbols}', "");
Expect(0, 65999, '\P{Blk=_	Ancient_Symbols}', "");
Expect(1, 65999, '\P{^Blk=_	Ancient_Symbols}', "");
Expect(0, 66000, '\p{Blk=_	Ancient_Symbols}', "");
Expect(1, 66000, '\p{^Blk=_	Ancient_Symbols}', "");
Expect(1, 66000, '\P{Blk=_	Ancient_Symbols}', "");
Expect(0, 66000, '\P{^Blk=_	Ancient_Symbols}', "");
Error('\p{Is_Block=/a/		ANCIENT_Symbols}');
Error('\P{Is_Block=/a/		ANCIENT_Symbols}');
Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
Expect(0, 66000, '\p{Is_Block=ancientsymbols}', "");
Expect(1, 66000, '\p{^Is_Block=ancientsymbols}', "");
Expect(1, 66000, '\P{Is_Block=ancientsymbols}', "");
Expect(0, 66000, '\P{^Is_Block=ancientsymbols}', "");
Expect(1, 65999, '\p{Is_Block=- Ancient_symbols}', "");
Expect(0, 65999, '\p{^Is_Block=- Ancient_symbols}', "");
Expect(0, 65999, '\P{Is_Block=- Ancient_symbols}', "");
Expect(1, 65999, '\P{^Is_Block=- Ancient_symbols}', "");
Expect(0, 66000, '\p{Is_Block=- Ancient_symbols}', "");
Expect(1, 66000, '\p{^Is_Block=- Ancient_symbols}', "");
Expect(1, 66000, '\P{Is_Block=- Ancient_symbols}', "");
Expect(0, 66000, '\P{^Is_Block=- Ancient_symbols}', "");
Error('\p{Is_Blk=:=  ANCIENT_SYMBOLS}');
Error('\P{Is_Blk=:=  ANCIENT_SYMBOLS}');
Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
Expect(0, 66000, '\p{Is_Blk=ancientsymbols}', "");
Expect(1, 66000, '\p{^Is_Blk=ancientsymbols}', "");
Expect(1, 66000, '\P{Is_Blk=ancientsymbols}', "");
Expect(0, 66000, '\P{^Is_Blk=ancientsymbols}', "");
Expect(1, 65999, '\p{Is_Blk=_ Ancient_Symbols}', "");
Expect(0, 65999, '\p{^Is_Blk=_ Ancient_Symbols}', "");
Expect(0, 65999, '\P{Is_Blk=_ Ancient_Symbols}', "");
Expect(1, 65999, '\P{^Is_Blk=_ Ancient_Symbols}', "");
Expect(0, 66000, '\p{Is_Blk=_ Ancient_Symbols}', "");
Expect(1, 66000, '\p{^Is_Blk=_ Ancient_Symbols}', "");
Expect(1, 66000, '\P{Is_Blk=_ Ancient_Symbols}', "");
Expect(0, 66000, '\P{^Is_Blk=_ Ancient_Symbols}', "");
Error('\p{Block:	:=Arabic}');
Error('\P{Block:	:=Arabic}');
Expect(1, 1791, '\p{Block=arabic}', "");
Expect(0, 1791, '\p{^Block=arabic}', "");
Expect(0, 1791, '\P{Block=arabic}', "");
Expect(1, 1791, '\P{^Block=arabic}', "");
Expect(0, 1792, '\p{Block=arabic}', "");
Expect(1, 1792, '\p{^Block=arabic}', "");
Expect(1, 1792, '\P{Block=arabic}', "");
Expect(0, 1792, '\P{^Block=arabic}', "");
Expect(1, 1791, '\p{Block= _ARABIC}', "");
Expect(0, 1791, '\p{^Block= _ARABIC}', "");
Expect(0, 1791, '\P{Block= _ARABIC}', "");
Expect(1, 1791, '\P{^Block= _ARABIC}', "");
Expect(0, 1792, '\p{Block= _ARABIC}', "");
Expect(1, 1792, '\p{^Block= _ARABIC}', "");
Expect(1, 1792, '\P{Block= _ARABIC}', "");
Expect(0, 1792, '\P{^Block= _ARABIC}', "");
Error('\p{Blk=_:=Arabic}');
Error('\P{Blk=_:=Arabic}');
Expect(1, 1791, '\p{Blk=arabic}', "");
Expect(0, 1791, '\p{^Blk=arabic}', "");
Expect(0, 1791, '\P{Blk=arabic}', "");
Expect(1, 1791, '\P{^Blk=arabic}', "");
Expect(0, 1792, '\p{Blk=arabic}', "");
Expect(1, 1792, '\p{^Blk=arabic}', "");
Expect(1, 1792, '\P{Blk=arabic}', "");
Expect(0, 1792, '\P{^Blk=arabic}', "");
Expect(1, 1791, '\p{Blk=-_Arabic}', "");
Expect(0, 1791, '\p{^Blk=-_Arabic}', "");
Expect(0, 1791, '\P{Blk=-_Arabic}', "");
Expect(1, 1791, '\P{^Blk=-_Arabic}', "");
Expect(0, 1792, '\p{Blk=-_Arabic}', "");
Expect(1, 1792, '\p{^Blk=-_Arabic}', "");
Expect(1, 1792, '\P{Blk=-_Arabic}', "");
Expect(0, 1792, '\P{^Blk=-_Arabic}', "");
Error('\p{Is_Block=_/a/arabic}');
Error('\P{Is_Block=_/a/arabic}');
Expect(1, 1791, '\p{Is_Block=arabic}', "");
Expect(0, 1791, '\p{^Is_Block=arabic}', "");
Expect(0, 1791, '\P{Is_Block=arabic}', "");
Expect(1, 1791, '\P{^Is_Block=arabic}', "");
Expect(0, 1792, '\p{Is_Block=arabic}', "");
Expect(1, 1792, '\p{^Is_Block=arabic}', "");
Expect(1, 1792, '\P{Is_Block=arabic}', "");
Expect(0, 1792, '\P{^Is_Block=arabic}', "");
Expect(1, 1791, '\p{Is_Block=_ arabic}', "");
Expect(0, 1791, '\p{^Is_Block=_ arabic}', "");
Expect(0, 1791, '\P{Is_Block=_ arabic}', "");
Expect(1, 1791, '\P{^Is_Block=_ arabic}', "");
Expect(0, 1792, '\p{Is_Block=_ arabic}', "");
Expect(1, 1792, '\p{^Is_Block=_ arabic}', "");
Expect(1, 1792, '\P{Is_Block=_ arabic}', "");
Expect(0, 1792, '\P{^Is_Block=_ arabic}', "");
Error('\p{Is_Blk=/a/- arabic}');
Error('\P{Is_Blk=/a/- arabic}');
Expect(1, 1791, '\p{Is_Blk=arabic}', "");
Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
Expect(0, 1791, '\P{Is_Blk=arabic}', "");
Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
Expect(0, 1792, '\p{Is_Blk=arabic}', "");
Expect(1, 1792, '\p{^Is_Blk=arabic}', "");
Expect(1, 1792, '\P{Is_Blk=arabic}', "");
Expect(0, 1792, '\P{^Is_Blk=arabic}', "");
Expect(1, 1791, '\p{Is_Blk= _Arabic}', "");
Expect(0, 1791, '\p{^Is_Blk= _Arabic}', "");
Expect(0, 1791, '\P{Is_Blk= _Arabic}', "");
Expect(1, 1791, '\P{^Is_Blk= _Arabic}', "");
Expect(0, 1792, '\p{Is_Blk= _Arabic}', "");
Expect(1, 1792, '\p{^Is_Blk= _Arabic}', "");
Expect(1, 1792, '\P{Is_Blk= _Arabic}', "");
Expect(0, 1792, '\P{^Is_Blk= _Arabic}', "");
Error('\p{Block=_:=arabic_extended_A}');
Error('\P{Block=_:=arabic_extended_A}');
Expect(1, 2303, '\p{Block=arabicextendeda}', "");
Expect(0, 2303, '\p{^Block=arabicextendeda}', "");
Expect(0, 2303, '\P{Block=arabicextendeda}', "");
Expect(1, 2303, '\P{^Block=arabicextendeda}', "");
Expect(0, 2304, '\p{Block=arabicextendeda}', "");
Expect(1, 2304, '\p{^Block=arabicextendeda}', "");
Expect(1, 2304, '\P{Block=arabicextendeda}', "");
Expect(0, 2304, '\P{^Block=arabicextendeda}', "");
Expect(1, 2303, '\p{Block=_Arabic_Extended_A}', "");
Expect(0, 2303, '\p{^Block=_Arabic_Extended_A}', "");
Expect(0, 2303, '\P{Block=_Arabic_Extended_A}', "");
Expect(1, 2303, '\P{^Block=_Arabic_Extended_A}', "");
Expect(0, 2304, '\p{Block=_Arabic_Extended_A}', "");
Expect(1, 2304, '\p{^Block=_Arabic_Extended_A}', "");
Expect(1, 2304, '\P{Block=_Arabic_Extended_A}', "");
Expect(0, 2304, '\P{^Block=_Arabic_Extended_A}', "");
Error('\p{Blk:   	/a/Arabic_Ext_A}');
Error('\P{Blk:   	/a/Arabic_Ext_A}');
Expect(1, 2303, '\p{Blk=arabicexta}', "");
Expect(0, 2303, '\p{^Blk=arabicexta}', "");
Expect(0, 2303, '\P{Blk=arabicexta}', "");
Expect(1, 2303, '\P{^Blk=arabicexta}', "");
Expect(0, 2304, '\p{Blk=arabicexta}', "");
Expect(1, 2304, '\p{^Blk=arabicexta}', "");
Expect(1, 2304, '\P{Blk=arabicexta}', "");
Expect(0, 2304, '\P{^Blk=arabicexta}', "");
Expect(1, 2303, '\p{Blk=  arabic_Ext_A}', "");
Expect(0, 2303, '\p{^Blk=  arabic_Ext_A}', "");
Expect(0, 2303, '\P{Blk=  arabic_Ext_A}', "");
Expect(1, 2303, '\P{^Blk=  arabic_Ext_A}', "");
Expect(0, 2304, '\p{Blk=  arabic_Ext_A}', "");
Expect(1, 2304, '\p{^Blk=  arabic_Ext_A}', "");
Expect(1, 2304, '\P{Blk=  arabic_Ext_A}', "");
Expect(0, 2304, '\P{^Blk=  arabic_Ext_A}', "");
Error('\p{Is_Block=/a/ARABIC_Extended_A}');
Error('\P{Is_Block=/a/ARABIC_Extended_A}');
Expect(1, 2303, '\p{Is_Block=arabicextendeda}', "");
Expect(0, 2303, '\p{^Is_Block=arabicextendeda}', "");
Expect(0, 2303, '\P{Is_Block=arabicextendeda}', "");
Expect(1, 2303, '\P{^Is_Block=arabicextendeda}', "");
Expect(0, 2304, '\p{Is_Block=arabicextendeda}', "");
Expect(1, 2304, '\p{^Is_Block=arabicextendeda}', "");
Expect(1, 2304, '\P{Is_Block=arabicextendeda}', "");
Expect(0, 2304, '\P{^Is_Block=arabicextendeda}', "");
Expect(1, 2303, '\p{Is_Block=-	Arabic_Extended_A}', "");
Expect(0, 2303, '\p{^Is_Block=-	Arabic_Extended_A}', "");
Expect(0, 2303, '\P{Is_Block=-	Arabic_Extended_A}', "");
Expect(1, 2303, '\P{^Is_Block=-	Arabic_Extended_A}', "");
Expect(0, 2304, '\p{Is_Block=-	Arabic_Extended_A}', "");
Expect(1, 2304, '\p{^Is_Block=-	Arabic_Extended_A}', "");
Expect(1, 2304, '\P{Is_Block=-	Arabic_Extended_A}', "");
Expect(0, 2304, '\P{^Is_Block=-	Arabic_Extended_A}', "");
Error('\p{Is_Blk=:=  Arabic_ext_a}');
Error('\P{Is_Blk=:=  Arabic_ext_a}');
Expect(1, 2303, '\p{Is_Blk:   arabicexta}', "");
Expect(0, 2303, '\p{^Is_Blk:   arabicexta}', "");
Expect(0, 2303, '\P{Is_Blk:   arabicexta}', "");
Expect(1, 2303, '\P{^Is_Blk:   arabicexta}', "");
Expect(0, 2304, '\p{Is_Blk:   arabicexta}', "");
Expect(1, 2304, '\p{^Is_Blk:   arabicexta}', "");
Expect(1, 2304, '\P{Is_Blk:   arabicexta}', "");
Expect(0, 2304, '\P{^Is_Blk:   arabicexta}', "");
Expect(1, 2303, '\p{Is_Blk=	Arabic_Ext_A}', "");
Expect(0, 2303, '\p{^Is_Blk=	Arabic_Ext_A}', "");
Expect(0, 2303, '\P{Is_Blk=	Arabic_Ext_A}', "");
Expect(1, 2303, '\P{^Is_Blk=	Arabic_Ext_A}', "");
Expect(0, 2304, '\p{Is_Blk=	Arabic_Ext_A}', "");
Expect(1, 2304, '\p{^Is_Blk=	Arabic_Ext_A}', "");
Expect(1, 2304, '\P{Is_Blk=	Arabic_Ext_A}', "");
Expect(0, 2304, '\P{^Is_Blk=	Arabic_Ext_A}', "");
Error('\p{Block= /a/arabic_MATHEMATICAL_alphabetic_Symbols}');
Error('\P{Block= /a/arabic_MATHEMATICAL_alphabetic_Symbols}');
Expect(1, 126719, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126719, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126719, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126719, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126720, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126720, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126720, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126720, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126719, '\p{Block=	_arabic_Mathematical_ALPHABETIC_Symbols}', "");
Expect(0, 126719, '\p{^Block=	_arabic_Mathematical_ALPHABETIC_Symbols}', "");
Expect(0, 126719, '\P{Block=	_arabic_Mathematical_ALPHABETIC_Symbols}', "");
Expect(1, 126719, '\P{^Block=	_arabic_Mathematical_ALPHABETIC_Symbols}', "");
Expect(0, 126720, '\p{Block=	_arabic_Mathematical_ALPHABETIC_Symbols}', "");
Expect(1, 126720, '\p{^Block=	_arabic_Mathematical_ALPHABETIC_Symbols}', "");
Expect(1, 126720, '\P{Block=	_arabic_Mathematical_ALPHABETIC_Symbols}', "");
Expect(0, 126720, '\P{^Block=	_arabic_Mathematical_ALPHABETIC_Symbols}', "");
Error('\p{Blk= Arabic_math:=}');
Error('\P{Blk= Arabic_math:=}');
Expect(1, 126719, '\p{Blk=arabicmath}', "");
Expect(0, 126719, '\p{^Blk=arabicmath}', "");
Expect(0, 126719, '\P{Blk=arabicmath}', "");
Expect(1, 126719, '\P{^Blk=arabicmath}', "");
Expect(0, 126720, '\p{Blk=arabicmath}', "");
Expect(1, 126720, '\p{^Blk=arabicmath}', "");
Expect(1, 126720, '\P{Blk=arabicmath}', "");
Expect(0, 126720, '\P{^Blk=arabicmath}', "");
Expect(1, 126719, '\p{Blk=	arabic_MATH}', "");
Expect(0, 126719, '\p{^Blk=	arabic_MATH}', "");
Expect(0, 126719, '\P{Blk=	arabic_MATH}', "");
Expect(1, 126719, '\P{^Blk=	arabic_MATH}', "");
Expect(0, 126720, '\p{Blk=	arabic_MATH}', "");
Expect(1, 126720, '\p{^Blk=	arabic_MATH}', "");
Expect(1, 126720, '\P{Blk=	arabic_MATH}', "");
Expect(0, 126720, '\P{^Blk=	arabic_MATH}', "");
Error('\p{Is_Block=_	arabic_Mathematical_ALPHABETIC_Symbols/a/}');
Error('\P{Is_Block=_	arabic_Mathematical_ALPHABETIC_Symbols/a/}');
Expect(1, 126719, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126719, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126719, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126719, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126720, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126720, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126720, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126720, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126719, '\p{Is_Block=	-arabic_MATHEMATICAL_Alphabetic_SYMBOLS}', "");
Expect(0, 126719, '\p{^Is_Block=	-arabic_MATHEMATICAL_Alphabetic_SYMBOLS}', "");
Expect(0, 126719, '\P{Is_Block=	-arabic_MATHEMATICAL_Alphabetic_SYMBOLS}', "");
Expect(1, 126719, '\P{^Is_Block=	-arabic_MATHEMATICAL_Alphabetic_SYMBOLS}', "");
Expect(0, 126720, '\p{Is_Block=	-arabic_MATHEMATICAL_Alphabetic_SYMBOLS}', "");
Expect(1, 126720, '\p{^Is_Block=	-arabic_MATHEMATICAL_Alphabetic_SYMBOLS}', "");
Expect(1, 126720, '\P{Is_Block=	-arabic_MATHEMATICAL_Alphabetic_SYMBOLS}', "");
Expect(0, 126720, '\P{^Is_Block=	-arabic_MATHEMATICAL_Alphabetic_SYMBOLS}', "");
Error('\p{Is_Blk=:=Arabic_math}');
Error('\P{Is_Blk=:=Arabic_math}');
Expect(1, 126719, '\p{Is_Blk=arabicmath}', "");
Expect(0, 126719, '\p{^Is_Blk=arabicmath}', "");
Expect(0, 126719, '\P{Is_Blk=arabicmath}', "");
Expect(1, 126719, '\P{^Is_Blk=arabicmath}', "");
Expect(0, 126720, '\p{Is_Blk=arabicmath}', "");
Expect(1, 126720, '\p{^Is_Blk=arabicmath}', "");
Expect(1, 126720, '\P{Is_Blk=arabicmath}', "");
Expect(0, 126720, '\P{^Is_Blk=arabicmath}', "");
Expect(1, 126719, '\p{Is_Blk=-_arabic_math}', "");
Expect(0, 126719, '\p{^Is_Blk=-_arabic_math}', "");
Expect(0, 126719, '\P{Is_Blk=-_arabic_math}', "");
Expect(1, 126719, '\P{^Is_Blk=-_arabic_math}', "");
Expect(0, 126720, '\p{Is_Blk=-_arabic_math}', "");
Expect(1, 126720, '\p{^Is_Blk=-_arabic_math}', "");
Expect(1, 126720, '\P{Is_Blk=-_arabic_math}', "");
Expect(0, 126720, '\P{^Is_Blk=-_arabic_math}', "");
Error('\p{Block=	Arabic_PRESENTATION_Forms_A:=}');
Error('\P{Block=	Arabic_PRESENTATION_Forms_A:=}');
Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
Expect(0, 65024, '\p{Block=arabicpresentationformsa}', "");
Expect(1, 65024, '\p{^Block=arabicpresentationformsa}', "");
Expect(1, 65024, '\P{Block=arabicpresentationformsa}', "");
Expect(0, 65024, '\P{^Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Block=		ARABIC_Presentation_Forms_a}', "");
Expect(0, 65023, '\p{^Block=		ARABIC_Presentation_Forms_a}', "");
Expect(0, 65023, '\P{Block=		ARABIC_Presentation_Forms_a}', "");
Expect(1, 65023, '\P{^Block=		ARABIC_Presentation_Forms_a}', "");
Expect(0, 65024, '\p{Block=		ARABIC_Presentation_Forms_a}', "");
Expect(1, 65024, '\p{^Block=		ARABIC_Presentation_Forms_a}', "");
Expect(1, 65024, '\P{Block=		ARABIC_Presentation_Forms_a}', "");
Expect(0, 65024, '\P{^Block=		ARABIC_Presentation_Forms_a}', "");
Error('\p{Blk:	_:=arabic_PF_a}');
Error('\P{Blk:	_:=arabic_PF_a}');
Expect(1, 65023, '\p{Blk=arabicpfa}', "");
Expect(0, 65023, '\p{^Blk=arabicpfa}', "");
Expect(0, 65023, '\P{Blk=arabicpfa}', "");
Expect(1, 65023, '\P{^Blk=arabicpfa}', "");
Expect(0, 65024, '\p{Blk=arabicpfa}', "");
Expect(1, 65024, '\p{^Blk=arabicpfa}', "");
Expect(1, 65024, '\P{Blk=arabicpfa}', "");
Expect(0, 65024, '\P{^Blk=arabicpfa}', "");
Expect(1, 65023, '\p{Blk= Arabic_PF_A}', "");
Expect(0, 65023, '\p{^Blk= Arabic_PF_A}', "");
Expect(0, 65023, '\P{Blk= Arabic_PF_A}', "");
Expect(1, 65023, '\P{^Blk= Arabic_PF_A}', "");
Expect(0, 65024, '\p{Blk= Arabic_PF_A}', "");
Expect(1, 65024, '\p{^Blk= Arabic_PF_A}', "");
Expect(1, 65024, '\P{Blk= Arabic_PF_A}', "");
Expect(0, 65024, '\P{^Blk= Arabic_PF_A}', "");
Error('\p{Is_Block=_:=arabic_Presentation_Forms_A}');
Error('\P{Is_Block=_:=arabic_Presentation_Forms_A}');
Expect(1, 65023, '\p{Is_Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Is_Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Is_Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Is_Block=arabicpresentationformsa}', "");
Expect(0, 65024, '\p{Is_Block=arabicpresentationformsa}', "");
Expect(1, 65024, '\p{^Is_Block=arabicpresentationformsa}', "");
Expect(1, 65024, '\P{Is_Block=arabicpresentationformsa}', "");
Expect(0, 65024, '\P{^Is_Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Is_Block=	ARABIC_Presentation_Forms_A}', "");
Expect(0, 65023, '\p{^Is_Block=	ARABIC_Presentation_Forms_A}', "");
Expect(0, 65023, '\P{Is_Block=	ARABIC_Presentation_Forms_A}', "");
Expect(1, 65023, '\P{^Is_Block=	ARABIC_Presentation_Forms_A}', "");
Expect(0, 65024, '\p{Is_Block=	ARABIC_Presentation_Forms_A}', "");
Expect(1, 65024, '\p{^Is_Block=	ARABIC_Presentation_Forms_A}', "");
Expect(1, 65024, '\P{Is_Block=	ARABIC_Presentation_Forms_A}', "");
Expect(0, 65024, '\P{^Is_Block=	ARABIC_Presentation_Forms_A}', "");
Error('\p{Is_Blk= /a/Arabic_PF_A}');
Error('\P{Is_Blk= /a/Arabic_PF_A}');
Expect(1, 65023, '\p{Is_Blk=arabicpfa}', "");
Expect(0, 65023, '\p{^Is_Blk=arabicpfa}', "");
Expect(0, 65023, '\P{Is_Blk=arabicpfa}', "");
Expect(1, 65023, '\P{^Is_Blk=arabicpfa}', "");
Expect(0, 65024, '\p{Is_Blk=arabicpfa}', "");
Expect(1, 65024, '\p{^Is_Blk=arabicpfa}', "");
Expect(1, 65024, '\P{Is_Blk=arabicpfa}', "");
Expect(0, 65024, '\P{^Is_Blk=arabicpfa}', "");
Expect(1, 65023, '\p{Is_Blk=	arabic_pf_a}', "");
Expect(0, 65023, '\p{^Is_Blk=	arabic_pf_a}', "");
Expect(0, 65023, '\P{Is_Blk=	arabic_pf_a}', "");
Expect(1, 65023, '\P{^Is_Blk=	arabic_pf_a}', "");
Expect(0, 65024, '\p{Is_Blk=	arabic_pf_a}', "");
Expect(1, 65024, '\p{^Is_Blk=	arabic_pf_a}', "");
Expect(1, 65024, '\P{Is_Blk=	arabic_pf_a}', "");
Expect(0, 65024, '\P{^Is_Blk=	arabic_pf_a}', "");
Error('\p{Block=_:=Arabic_PRESENTATION_FORMS_B}');
Error('\P{Block=_:=Arabic_PRESENTATION_FORMS_B}');
Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
Expect(0, 65280, '\p{Block=arabicpresentationformsb}', "");
Expect(1, 65280, '\p{^Block=arabicpresentationformsb}', "");
Expect(1, 65280, '\P{Block=arabicpresentationformsb}', "");
Expect(0, 65280, '\P{^Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Block=	 ARABIC_PRESENTATION_FORMS_B}', "");
Expect(0, 65279, '\p{^Block=	 ARABIC_PRESENTATION_FORMS_B}', "");
Expect(0, 65279, '\P{Block=	 ARABIC_PRESENTATION_FORMS_B}', "");
Expect(1, 65279, '\P{^Block=	 ARABIC_PRESENTATION_FORMS_B}', "");
Expect(0, 65280, '\p{Block=	 ARABIC_PRESENTATION_FORMS_B}', "");
Expect(1, 65280, '\p{^Block=	 ARABIC_PRESENTATION_FORMS_B}', "");
Expect(1, 65280, '\P{Block=	 ARABIC_PRESENTATION_FORMS_B}', "");
Expect(0, 65280, '\P{^Block=	 ARABIC_PRESENTATION_FORMS_B}', "");
Error('\p{Blk=_Arabic_PF_B:=}');
Error('\P{Blk=_Arabic_PF_B:=}');
Expect(1, 65279, '\p{Blk=arabicpfb}', "");
Expect(0, 65279, '\p{^Blk=arabicpfb}', "");
Expect(0, 65279, '\P{Blk=arabicpfb}', "");
Expect(1, 65279, '\P{^Blk=arabicpfb}', "");
Expect(0, 65280, '\p{Blk=arabicpfb}', "");
Expect(1, 65280, '\p{^Blk=arabicpfb}', "");
Expect(1, 65280, '\P{Blk=arabicpfb}', "");
Expect(0, 65280, '\P{^Blk=arabicpfb}', "");
Expect(1, 65279, '\p{Blk=__ARABIC_PF_B}', "");
Expect(0, 65279, '\p{^Blk=__ARABIC_PF_B}', "");
Expect(0, 65279, '\P{Blk=__ARABIC_PF_B}', "");
Expect(1, 65279, '\P{^Blk=__ARABIC_PF_B}', "");
Expect(0, 65280, '\p{Blk=__ARABIC_PF_B}', "");
Expect(1, 65280, '\p{^Blk=__ARABIC_PF_B}', "");
Expect(1, 65280, '\P{Blk=__ARABIC_PF_B}', "");
Expect(0, 65280, '\P{^Blk=__ARABIC_PF_B}', "");
Error('\p{Is_Block=/a/ 	Arabic_Presentation_FORMS_B}');
Error('\P{Is_Block=/a/ 	Arabic_Presentation_FORMS_B}');
Expect(1, 65279, '\p{Is_Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Is_Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Is_Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Is_Block=arabicpresentationformsb}', "");
Expect(0, 65280, '\p{Is_Block=arabicpresentationformsb}', "");
Expect(1, 65280, '\p{^Is_Block=arabicpresentationformsb}', "");
Expect(1, 65280, '\P{Is_Block=arabicpresentationformsb}', "");
Expect(0, 65280, '\P{^Is_Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Is_Block= Arabic_Presentation_Forms_B}', "");
Expect(0, 65279, '\p{^Is_Block= Arabic_Presentation_Forms_B}', "");
Expect(0, 65279, '\P{Is_Block= Arabic_Presentation_Forms_B}', "");
Expect(1, 65279, '\P{^Is_Block= Arabic_Presentation_Forms_B}', "");
Expect(0, 65280, '\p{Is_Block= Arabic_Presentation_Forms_B}', "");
Expect(1, 65280, '\p{^Is_Block= Arabic_Presentation_Forms_B}', "");
Expect(1, 65280, '\P{Is_Block= Arabic_Presentation_Forms_B}', "");
Expect(0, 65280, '\P{^Is_Block= Arabic_Presentation_Forms_B}', "");
Error('\p{Is_Blk:-/a/ARABIC_pf_B}');
Error('\P{Is_Blk:-/a/ARABIC_pf_B}');
Expect(1, 65279, '\p{Is_Blk=arabicpfb}', "");
Expect(0, 65279, '\p{^Is_Blk=arabicpfb}', "");
Expect(0, 65279, '\P{Is_Blk=arabicpfb}', "");
Expect(1, 65279, '\P{^Is_Blk=arabicpfb}', "");
Expect(0, 65280, '\p{Is_Blk=arabicpfb}', "");
Expect(1, 65280, '\p{^Is_Blk=arabicpfb}', "");
Expect(1, 65280, '\P{Is_Blk=arabicpfb}', "");
Expect(0, 65280, '\P{^Is_Blk=arabicpfb}', "");
Expect(1, 65279, '\p{Is_Blk=	-Arabic_PF_B}', "");
Expect(0, 65279, '\p{^Is_Blk=	-Arabic_PF_B}', "");
Expect(0, 65279, '\P{Is_Blk=	-Arabic_PF_B}', "");
Expect(1, 65279, '\P{^Is_Blk=	-Arabic_PF_B}', "");
Expect(0, 65280, '\p{Is_Blk=	-Arabic_PF_B}', "");
Expect(1, 65280, '\p{^Is_Blk=	-Arabic_PF_B}', "");
Expect(1, 65280, '\P{Is_Blk=	-Arabic_PF_B}', "");
Expect(0, 65280, '\P{^Is_Blk=	-Arabic_PF_B}', "");
Error('\p{Block=/a/Arabic_Supplement}');
Error('\P{Block=/a/Arabic_Supplement}');
Expect(1, 1919, '\p{Block=arabicsupplement}', "");
Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
Expect(0, 1919, '\P{Block=arabicsupplement}', "");
Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
Expect(0, 1920, '\p{Block=arabicsupplement}', "");
Expect(1, 1920, '\p{^Block=arabicsupplement}', "");
Expect(1, 1920, '\P{Block=arabicsupplement}', "");
Expect(0, 1920, '\P{^Block=arabicsupplement}', "");
Expect(1, 1919, '\p{Block=-_arabic_Supplement}', "");
Expect(0, 1919, '\p{^Block=-_arabic_Supplement}', "");
Expect(0, 1919, '\P{Block=-_arabic_Supplement}', "");
Expect(1, 1919, '\P{^Block=-_arabic_Supplement}', "");
Expect(0, 1920, '\p{Block=-_arabic_Supplement}', "");
Expect(1, 1920, '\p{^Block=-_arabic_Supplement}', "");
Expect(1, 1920, '\P{Block=-_arabic_Supplement}', "");
Expect(0, 1920, '\P{^Block=-_arabic_Supplement}', "");
Error('\p{Blk:	ARABIC_sup:=}');
Error('\P{Blk:	ARABIC_sup:=}');
Expect(1, 1919, '\p{Blk=arabicsup}', "");
Expect(0, 1919, '\p{^Blk=arabicsup}', "");
Expect(0, 1919, '\P{Blk=arabicsup}', "");
Expect(1, 1919, '\P{^Blk=arabicsup}', "");
Expect(0, 1920, '\p{Blk=arabicsup}', "");
Expect(1, 1920, '\p{^Blk=arabicsup}', "");
Expect(1, 1920, '\P{Blk=arabicsup}', "");
Expect(0, 1920, '\P{^Blk=arabicsup}', "");
Expect(1, 1919, '\p{Blk= 	arabic_sup}', "");
Expect(0, 1919, '\p{^Blk= 	arabic_sup}', "");
Expect(0, 1919, '\P{Blk= 	arabic_sup}', "");
Expect(1, 1919, '\P{^Blk= 	arabic_sup}', "");
Expect(0, 1920, '\p{Blk= 	arabic_sup}', "");
Expect(1, 1920, '\p{^Blk= 	arabic_sup}', "");
Expect(1, 1920, '\P{Blk= 	arabic_sup}', "");
Expect(0, 1920, '\P{^Blk= 	arabic_sup}', "");
Error('\p{Is_Block=/a/	ARABIC_Supplement}');
Error('\P{Is_Block=/a/	ARABIC_Supplement}');
Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
Expect(0, 1920, '\p{Is_Block=arabicsupplement}', "");
Expect(1, 1920, '\p{^Is_Block=arabicsupplement}', "");
Expect(1, 1920, '\P{Is_Block=arabicsupplement}', "");
Expect(0, 1920, '\P{^Is_Block=arabicsupplement}', "");
Expect(1, 1919, '\p{Is_Block=-Arabic_SUPPLEMENT}', "");
Expect(0, 1919, '\p{^Is_Block=-Arabic_SUPPLEMENT}', "");
Expect(0, 1919, '\P{Is_Block=-Arabic_SUPPLEMENT}', "");
Expect(1, 1919, '\P{^Is_Block=-Arabic_SUPPLEMENT}', "");
Expect(0, 1920, '\p{Is_Block=-Arabic_SUPPLEMENT}', "");
Expect(1, 1920, '\p{^Is_Block=-Arabic_SUPPLEMENT}', "");
Expect(1, 1920, '\P{Is_Block=-Arabic_SUPPLEMENT}', "");
Expect(0, 1920, '\P{^Is_Block=-Arabic_SUPPLEMENT}', "");
Error('\p{Is_Blk=-ARABIC_sup/a/}');
Error('\P{Is_Blk=-ARABIC_sup/a/}');
Expect(1, 1919, '\p{Is_Blk: arabicsup}', "");
Expect(0, 1919, '\p{^Is_Blk: arabicsup}', "");
Expect(0, 1919, '\P{Is_Blk: arabicsup}', "");
Expect(1, 1919, '\P{^Is_Blk: arabicsup}', "");
Expect(0, 1920, '\p{Is_Blk: arabicsup}', "");
Expect(1, 1920, '\p{^Is_Blk: arabicsup}', "");
Expect(1, 1920, '\P{Is_Blk: arabicsup}', "");
Expect(0, 1920, '\P{^Is_Blk: arabicsup}', "");
Expect(1, 1919, '\p{Is_Blk=_	arabic_Sup}', "");
Expect(0, 1919, '\p{^Is_Blk=_	arabic_Sup}', "");
Expect(0, 1919, '\P{Is_Blk=_	arabic_Sup}', "");
Expect(1, 1919, '\P{^Is_Blk=_	arabic_Sup}', "");
Expect(0, 1920, '\p{Is_Blk=_	arabic_Sup}', "");
Expect(1, 1920, '\p{^Is_Blk=_	arabic_Sup}', "");
Expect(1, 1920, '\P{Is_Blk=_	arabic_Sup}', "");
Expect(0, 1920, '\P{^Is_Blk=_	arabic_Sup}', "");
Error('\p{Block=_/a/Armenian}');
Error('\P{Block=_/a/Armenian}');
Expect(1, 1423, '\p{Block=armenian}', "");
Expect(0, 1423, '\p{^Block=armenian}', "");
Expect(0, 1423, '\P{Block=armenian}', "");
Expect(1, 1423, '\P{^Block=armenian}', "");
Expect(0, 1424, '\p{Block=armenian}', "");
Expect(1, 1424, '\p{^Block=armenian}', "");
Expect(1, 1424, '\P{Block=armenian}', "");
Expect(0, 1424, '\P{^Block=armenian}', "");
Expect(1, 1423, '\p{Block=	ARMENIAN}', "");
Expect(0, 1423, '\p{^Block=	ARMENIAN}', "");
Expect(0, 1423, '\P{Block=	ARMENIAN}', "");
Expect(1, 1423, '\P{^Block=	ARMENIAN}', "");
Expect(0, 1424, '\p{Block=	ARMENIAN}', "");
Expect(1, 1424, '\p{^Block=	ARMENIAN}', "");
Expect(1, 1424, '\P{Block=	ARMENIAN}', "");
Expect(0, 1424, '\P{^Block=	ARMENIAN}', "");
Error('\p{Blk=_/a/Armenian}');
Error('\P{Blk=_/a/Armenian}');
Expect(1, 1423, '\p{Blk=armenian}', "");
Expect(0, 1423, '\p{^Blk=armenian}', "");
Expect(0, 1423, '\P{Blk=armenian}', "");
Expect(1, 1423, '\P{^Blk=armenian}', "");
Expect(0, 1424, '\p{Blk=armenian}', "");
Expect(1, 1424, '\p{^Blk=armenian}', "");
Expect(1, 1424, '\P{Blk=armenian}', "");
Expect(0, 1424, '\P{^Blk=armenian}', "");
Expect(1, 1423, '\p{Blk= -Armenian}', "");
Expect(0, 1423, '\p{^Blk= -Armenian}', "");
Expect(0, 1423, '\P{Blk= -Armenian}', "");
Expect(1, 1423, '\P{^Blk= -Armenian}', "");
Expect(0, 1424, '\p{Blk= -Armenian}', "");
Expect(1, 1424, '\p{^Blk= -Armenian}', "");
Expect(1, 1424, '\P{Blk= -Armenian}', "");
Expect(0, 1424, '\P{^Blk= -Armenian}', "");
Error('\p{Is_Block=_/a/armenian}');
Error('\P{Is_Block=_/a/armenian}');
Expect(1, 1423, '\p{Is_Block=armenian}', "");
Expect(0, 1423, '\p{^Is_Block=armenian}', "");
Expect(0, 1423, '\P{Is_Block=armenian}', "");
Expect(1, 1423, '\P{^Is_Block=armenian}', "");
Expect(0, 1424, '\p{Is_Block=armenian}', "");
Expect(1, 1424, '\p{^Is_Block=armenian}', "");
Expect(1, 1424, '\P{Is_Block=armenian}', "");
Expect(0, 1424, '\P{^Is_Block=armenian}', "");
Expect(1, 1423, '\p{Is_Block=  ARMENIAN}', "");
Expect(0, 1423, '\p{^Is_Block=  ARMENIAN}', "");
Expect(0, 1423, '\P{Is_Block=  ARMENIAN}', "");
Expect(1, 1423, '\P{^Is_Block=  ARMENIAN}', "");
Expect(0, 1424, '\p{Is_Block=  ARMENIAN}', "");
Expect(1, 1424, '\p{^Is_Block=  ARMENIAN}', "");
Expect(1, 1424, '\P{Is_Block=  ARMENIAN}', "");
Expect(0, 1424, '\P{^Is_Block=  ARMENIAN}', "");
Error('\p{Is_Blk=_/a/ARMENIAN}');
Error('\P{Is_Blk=_/a/ARMENIAN}');
Expect(1, 1423, '\p{Is_Blk=armenian}', "");
Expect(0, 1423, '\p{^Is_Blk=armenian}', "");
Expect(0, 1423, '\P{Is_Blk=armenian}', "");
Expect(1, 1423, '\P{^Is_Blk=armenian}', "");
Expect(0, 1424, '\p{Is_Blk=armenian}', "");
Expect(1, 1424, '\p{^Is_Blk=armenian}', "");
Expect(1, 1424, '\P{Is_Blk=armenian}', "");
Expect(0, 1424, '\P{^Is_Blk=armenian}', "");
Expect(1, 1423, '\p{Is_Blk= 	Armenian}', "");
Expect(0, 1423, '\p{^Is_Blk= 	Armenian}', "");
Expect(0, 1423, '\P{Is_Blk= 	Armenian}', "");
Expect(1, 1423, '\P{^Is_Blk= 	Armenian}', "");
Expect(0, 1424, '\p{Is_Blk= 	Armenian}', "");
Expect(1, 1424, '\p{^Is_Blk= 	Armenian}', "");
Expect(1, 1424, '\P{Is_Blk= 	Armenian}', "");
Expect(0, 1424, '\P{^Is_Blk= 	Armenian}', "");
Error('\p{Block:  /a/arrows}');
Error('\P{Block:  /a/arrows}');
Expect(1, 8703, '\p{Block=arrows}', "");
Expect(0, 8703, '\p{^Block=arrows}', "");
Expect(0, 8703, '\P{Block=arrows}', "");
Expect(1, 8703, '\P{^Block=arrows}', "");
Expect(0, 8704, '\p{Block=arrows}', "");
Expect(1, 8704, '\p{^Block=arrows}', "");
Expect(1, 8704, '\P{Block=arrows}', "");
Expect(0, 8704, '\P{^Block=arrows}', "");
Expect(1, 8703, '\p{Block=	arrows}', "");
Expect(0, 8703, '\p{^Block=	arrows}', "");
Expect(0, 8703, '\P{Block=	arrows}', "");
Expect(1, 8703, '\P{^Block=	arrows}', "");
Expect(0, 8704, '\p{Block=	arrows}', "");
Expect(1, 8704, '\p{^Block=	arrows}', "");
Expect(1, 8704, '\P{Block=	arrows}', "");
Expect(0, 8704, '\P{^Block=	arrows}', "");
Error('\p{Blk=	 Arrows:=}');
Error('\P{Blk=	 Arrows:=}');
Expect(1, 8703, '\p{Blk: arrows}', "");
Expect(0, 8703, '\p{^Blk: arrows}', "");
Expect(0, 8703, '\P{Blk: arrows}', "");
Expect(1, 8703, '\P{^Blk: arrows}', "");
Expect(0, 8704, '\p{Blk: arrows}', "");
Expect(1, 8704, '\p{^Blk: arrows}', "");
Expect(1, 8704, '\P{Blk: arrows}', "");
Expect(0, 8704, '\P{^Blk: arrows}', "");
Expect(1, 8703, '\p{Blk=	-Arrows}', "");
Expect(0, 8703, '\p{^Blk=	-Arrows}', "");
Expect(0, 8703, '\P{Blk=	-Arrows}', "");
Expect(1, 8703, '\P{^Blk=	-Arrows}', "");
Expect(0, 8704, '\p{Blk=	-Arrows}', "");
Expect(1, 8704, '\p{^Blk=	-Arrows}', "");
Expect(1, 8704, '\P{Blk=	-Arrows}', "");
Expect(0, 8704, '\P{^Blk=	-Arrows}', "");
Error('\p{Is_Block: _-arrows/a/}');
Error('\P{Is_Block: _-arrows/a/}');
Expect(1, 8703, '\p{Is_Block=arrows}', "");
Expect(0, 8703, '\p{^Is_Block=arrows}', "");
Expect(0, 8703, '\P{Is_Block=arrows}', "");
Expect(1, 8703, '\P{^Is_Block=arrows}', "");
Expect(0, 8704, '\p{Is_Block=arrows}', "");
Expect(1, 8704, '\p{^Is_Block=arrows}', "");
Expect(1, 8704, '\P{Is_Block=arrows}', "");
Expect(0, 8704, '\P{^Is_Block=arrows}', "");
Expect(1, 8703, '\p{Is_Block=_-Arrows}', "");
Expect(0, 8703, '\p{^Is_Block=_-Arrows}', "");
Expect(0, 8703, '\P{Is_Block=_-Arrows}', "");
Expect(1, 8703, '\P{^Is_Block=_-Arrows}', "");
Expect(0, 8704, '\p{Is_Block=_-Arrows}', "");
Expect(1, 8704, '\p{^Is_Block=_-Arrows}', "");
Expect(1, 8704, '\P{Is_Block=_-Arrows}', "");
Expect(0, 8704, '\P{^Is_Block=_-Arrows}', "");
Error('\p{Is_Blk=:=	_Arrows}');
Error('\P{Is_Blk=:=	_Arrows}');
Expect(1, 8703, '\p{Is_Blk:   arrows}', "");
Expect(0, 8703, '\p{^Is_Blk:   arrows}', "");
Expect(0, 8703, '\P{Is_Blk:   arrows}', "");
Expect(1, 8703, '\P{^Is_Blk:   arrows}', "");
Expect(0, 8704, '\p{Is_Blk:   arrows}', "");
Expect(1, 8704, '\p{^Is_Blk:   arrows}', "");
Expect(1, 8704, '\P{Is_Blk:   arrows}', "");
Expect(0, 8704, '\P{^Is_Blk:   arrows}', "");
Expect(1, 8703, '\p{Is_Blk=-ARROWS}', "");
Expect(0, 8703, '\p{^Is_Blk=-ARROWS}', "");
Expect(0, 8703, '\P{Is_Blk=-ARROWS}', "");
Expect(1, 8703, '\P{^Is_Blk=-ARROWS}', "");
Expect(0, 8704, '\p{Is_Blk=-ARROWS}', "");
Expect(1, 8704, '\p{^Is_Blk=-ARROWS}', "");
Expect(1, 8704, '\P{Is_Blk=-ARROWS}', "");
Expect(0, 8704, '\P{^Is_Blk=-ARROWS}', "");
Error('\p{Block: /a/	AVESTAN}');
Error('\P{Block: /a/	AVESTAN}');
Expect(1, 68415, '\p{Block=avestan}', "");
Expect(0, 68415, '\p{^Block=avestan}', "");
Expect(0, 68415, '\P{Block=avestan}', "");
Expect(1, 68415, '\P{^Block=avestan}', "");
Expect(0, 68416, '\p{Block=avestan}', "");
Expect(1, 68416, '\p{^Block=avestan}', "");
Expect(1, 68416, '\P{Block=avestan}', "");
Expect(0, 68416, '\P{^Block=avestan}', "");
Expect(1, 68415, '\p{Block=	 Avestan}', "");
Expect(0, 68415, '\p{^Block=	 Avestan}', "");
Expect(0, 68415, '\P{Block=	 Avestan}', "");
Expect(1, 68415, '\P{^Block=	 Avestan}', "");
Expect(0, 68416, '\p{Block=	 Avestan}', "");
Expect(1, 68416, '\p{^Block=	 Avestan}', "");
Expect(1, 68416, '\P{Block=	 Avestan}', "");
Expect(0, 68416, '\P{^Block=	 Avestan}', "");
Error('\p{Blk= :=avestan}');
Error('\P{Blk= :=avestan}');
Expect(1, 68415, '\p{Blk: avestan}', "");
Expect(0, 68415, '\p{^Blk: avestan}', "");
Expect(0, 68415, '\P{Blk: avestan}', "");
Expect(1, 68415, '\P{^Blk: avestan}', "");
Expect(0, 68416, '\p{Blk: avestan}', "");
Expect(1, 68416, '\p{^Blk: avestan}', "");
Expect(1, 68416, '\P{Blk: avestan}', "");
Expect(0, 68416, '\P{^Blk: avestan}', "");
Expect(1, 68415, '\p{Blk= Avestan}', "");
Expect(0, 68415, '\p{^Blk= Avestan}', "");
Expect(0, 68415, '\P{Blk= Avestan}', "");
Expect(1, 68415, '\P{^Blk= Avestan}', "");
Expect(0, 68416, '\p{Blk= Avestan}', "");
Expect(1, 68416, '\p{^Blk= Avestan}', "");
Expect(1, 68416, '\P{Blk= Avestan}', "");
Expect(0, 68416, '\P{^Blk= Avestan}', "");
Error('\p{Is_Block= Avestan:=}');
Error('\P{Is_Block= Avestan:=}');
Expect(1, 68415, '\p{Is_Block=avestan}', "");
Expect(0, 68415, '\p{^Is_Block=avestan}', "");
Expect(0, 68415, '\P{Is_Block=avestan}', "");
Expect(1, 68415, '\P{^Is_Block=avestan}', "");
Expect(0, 68416, '\p{Is_Block=avestan}', "");
Expect(1, 68416, '\p{^Is_Block=avestan}', "");
Expect(1, 68416, '\P{Is_Block=avestan}', "");
Expect(0, 68416, '\P{^Is_Block=avestan}', "");
Expect(1, 68415, '\p{Is_Block=_Avestan}', "");
Expect(0, 68415, '\p{^Is_Block=_Avestan}', "");
Expect(0, 68415, '\P{Is_Block=_Avestan}', "");
Expect(1, 68415, '\P{^Is_Block=_Avestan}', "");
Expect(0, 68416, '\p{Is_Block=_Avestan}', "");
Expect(1, 68416, '\p{^Is_Block=_Avestan}', "");
Expect(1, 68416, '\P{Is_Block=_Avestan}', "");
Expect(0, 68416, '\P{^Is_Block=_Avestan}', "");
Error('\p{Is_Blk=	/a/Avestan}');
Error('\P{Is_Blk=	/a/Avestan}');
Expect(1, 68415, '\p{Is_Blk:   avestan}', "");
Expect(0, 68415, '\p{^Is_Blk:   avestan}', "");
Expect(0, 68415, '\P{Is_Blk:   avestan}', "");
Expect(1, 68415, '\P{^Is_Blk:   avestan}', "");
Expect(0, 68416, '\p{Is_Blk:   avestan}', "");
Expect(1, 68416, '\p{^Is_Blk:   avestan}', "");
Expect(1, 68416, '\P{Is_Blk:   avestan}', "");
Expect(0, 68416, '\P{^Is_Blk:   avestan}', "");
Expect(1, 68415, '\p{Is_Blk=-_avestan}', "");
Expect(0, 68415, '\p{^Is_Blk=-_avestan}', "");
Expect(0, 68415, '\P{Is_Blk=-_avestan}', "");
Expect(1, 68415, '\P{^Is_Blk=-_avestan}', "");
Expect(0, 68416, '\p{Is_Blk=-_avestan}', "");
Expect(1, 68416, '\p{^Is_Blk=-_avestan}', "");
Expect(1, 68416, '\P{Is_Blk=-_avestan}', "");
Expect(0, 68416, '\P{^Is_Blk=-_avestan}', "");
Error('\p{Block=/a/ -balinese}');
Error('\P{Block=/a/ -balinese}');
Expect(1, 7039, '\p{Block=balinese}', "");
Expect(0, 7039, '\p{^Block=balinese}', "");
Expect(0, 7039, '\P{Block=balinese}', "");
Expect(1, 7039, '\P{^Block=balinese}', "");
Expect(0, 7040, '\p{Block=balinese}', "");
Expect(1, 7040, '\p{^Block=balinese}', "");
Expect(1, 7040, '\P{Block=balinese}', "");
Expect(0, 7040, '\P{^Block=balinese}', "");
Expect(1, 7039, '\p{Block= _Balinese}', "");
Expect(0, 7039, '\p{^Block= _Balinese}', "");
Expect(0, 7039, '\P{Block= _Balinese}', "");
Expect(1, 7039, '\P{^Block= _Balinese}', "");
Expect(0, 7040, '\p{Block= _Balinese}', "");
Expect(1, 7040, '\p{^Block= _Balinese}', "");
Expect(1, 7040, '\P{Block= _Balinese}', "");
Expect(0, 7040, '\P{^Block= _Balinese}', "");
Error('\p{Blk=	/a/Balinese}');
Error('\P{Blk=	/a/Balinese}');
Expect(1, 7039, '\p{Blk=balinese}', "");
Expect(0, 7039, '\p{^Blk=balinese}', "");
Expect(0, 7039, '\P{Blk=balinese}', "");
Expect(1, 7039, '\P{^Blk=balinese}', "");
Expect(0, 7040, '\p{Blk=balinese}', "");
Expect(1, 7040, '\p{^Blk=balinese}', "");
Expect(1, 7040, '\P{Blk=balinese}', "");
Expect(0, 7040, '\P{^Blk=balinese}', "");
Expect(1, 7039, '\p{Blk=	 Balinese}', "");
Expect(0, 7039, '\p{^Blk=	 Balinese}', "");
Expect(0, 7039, '\P{Blk=	 Balinese}', "");
Expect(1, 7039, '\P{^Blk=	 Balinese}', "");
Expect(0, 7040, '\p{Blk=	 Balinese}', "");
Expect(1, 7040, '\p{^Blk=	 Balinese}', "");
Expect(1, 7040, '\P{Blk=	 Balinese}', "");
Expect(0, 7040, '\P{^Blk=	 Balinese}', "");
Error('\p{Is_Block=	_balinese/a/}');
Error('\P{Is_Block=	_balinese/a/}');
Expect(1, 7039, '\p{Is_Block=balinese}', "");
Expect(0, 7039, '\p{^Is_Block=balinese}', "");
Expect(0, 7039, '\P{Is_Block=balinese}', "");
Expect(1, 7039, '\P{^Is_Block=balinese}', "");
Expect(0, 7040, '\p{Is_Block=balinese}', "");
Expect(1, 7040, '\p{^Is_Block=balinese}', "");
Expect(1, 7040, '\P{Is_Block=balinese}', "");
Expect(0, 7040, '\P{^Is_Block=balinese}', "");
Expect(1, 7039, '\p{Is_Block=-Balinese}', "");
Expect(0, 7039, '\p{^Is_Block=-Balinese}', "");
Expect(0, 7039, '\P{Is_Block=-Balinese}', "");
Expect(1, 7039, '\P{^Is_Block=-Balinese}', "");
Expect(0, 7040, '\p{Is_Block=-Balinese}', "");
Expect(1, 7040, '\p{^Is_Block=-Balinese}', "");
Expect(1, 7040, '\P{Is_Block=-Balinese}', "");
Expect(0, 7040, '\P{^Is_Block=-Balinese}', "");
Error('\p{Is_Blk=	 BALINESE:=}');
Error('\P{Is_Blk=	 BALINESE:=}');
Expect(1, 7039, '\p{Is_Blk=balinese}', "");
Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
Expect(0, 7039, '\P{Is_Blk=balinese}', "");
Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
Expect(0, 7040, '\p{Is_Blk=balinese}', "");
Expect(1, 7040, '\p{^Is_Blk=balinese}', "");
Expect(1, 7040, '\P{Is_Blk=balinese}', "");
Expect(0, 7040, '\P{^Is_Blk=balinese}', "");
Expect(1, 7039, '\p{Is_Blk=	Balinese}', "");
Expect(0, 7039, '\p{^Is_Blk=	Balinese}', "");
Expect(0, 7039, '\P{Is_Blk=	Balinese}', "");
Expect(1, 7039, '\P{^Is_Blk=	Balinese}', "");
Expect(0, 7040, '\p{Is_Blk=	Balinese}', "");
Expect(1, 7040, '\p{^Is_Blk=	Balinese}', "");
Expect(1, 7040, '\P{Is_Blk=	Balinese}', "");
Expect(0, 7040, '\P{^Is_Blk=	Balinese}', "");
Error('\p{Block=/a/__Bamum}');
Error('\P{Block=/a/__Bamum}');
Expect(1, 42751, '\p{Block=bamum}', "");
Expect(0, 42751, '\p{^Block=bamum}', "");
Expect(0, 42751, '\P{Block=bamum}', "");
Expect(1, 42751, '\P{^Block=bamum}', "");
Expect(0, 42752, '\p{Block=bamum}', "");
Expect(1, 42752, '\p{^Block=bamum}', "");
Expect(1, 42752, '\P{Block=bamum}', "");
Expect(0, 42752, '\P{^Block=bamum}', "");
Expect(1, 42751, '\p{Block=- Bamum}', "");
Expect(0, 42751, '\p{^Block=- Bamum}', "");
Expect(0, 42751, '\P{Block=- Bamum}', "");
Expect(1, 42751, '\P{^Block=- Bamum}', "");
Expect(0, 42752, '\p{Block=- Bamum}', "");
Expect(1, 42752, '\p{^Block=- Bamum}', "");
Expect(1, 42752, '\P{Block=- Bamum}', "");
Expect(0, 42752, '\P{^Block=- Bamum}', "");
Error('\p{Blk:	_ bamum/a/}');
Error('\P{Blk:	_ bamum/a/}');
Expect(1, 42751, '\p{Blk=bamum}', "");
Expect(0, 42751, '\p{^Blk=bamum}', "");
Expect(0, 42751, '\P{Blk=bamum}', "");
Expect(1, 42751, '\P{^Blk=bamum}', "");
Expect(0, 42752, '\p{Blk=bamum}', "");
Expect(1, 42752, '\p{^Blk=bamum}', "");
Expect(1, 42752, '\P{Blk=bamum}', "");
Expect(0, 42752, '\P{^Blk=bamum}', "");
Expect(1, 42751, '\p{Blk=		bamum}', "");
Expect(0, 42751, '\p{^Blk=		bamum}', "");
Expect(0, 42751, '\P{Blk=		bamum}', "");
Expect(1, 42751, '\P{^Blk=		bamum}', "");
Expect(0, 42752, '\p{Blk=		bamum}', "");
Expect(1, 42752, '\p{^Blk=		bamum}', "");
Expect(1, 42752, '\P{Blk=		bamum}', "");
Expect(0, 42752, '\P{^Blk=		bamum}', "");
Error('\p{Is_Block=--bamum/a/}');
Error('\P{Is_Block=--bamum/a/}');
Expect(1, 42751, '\p{Is_Block:   bamum}', "");
Expect(0, 42751, '\p{^Is_Block:   bamum}', "");
Expect(0, 42751, '\P{Is_Block:   bamum}', "");
Expect(1, 42751, '\P{^Is_Block:   bamum}', "");
Expect(0, 42752, '\p{Is_Block:   bamum}', "");
Expect(1, 42752, '\p{^Is_Block:   bamum}', "");
Expect(1, 42752, '\P{Is_Block:   bamum}', "");
Expect(0, 42752, '\P{^Is_Block:   bamum}', "");
Expect(1, 42751, '\p{Is_Block=_-Bamum}', "");
Expect(0, 42751, '\p{^Is_Block=_-Bamum}', "");
Expect(0, 42751, '\P{Is_Block=_-Bamum}', "");
Expect(1, 42751, '\P{^Is_Block=_-Bamum}', "");
Expect(0, 42752, '\p{Is_Block=_-Bamum}', "");
Expect(1, 42752, '\p{^Is_Block=_-Bamum}', "");
Expect(1, 42752, '\P{Is_Block=_-Bamum}', "");
Expect(0, 42752, '\P{^Is_Block=_-Bamum}', "");
Error('\p{Is_Blk=	_Bamum:=}');
Error('\P{Is_Blk=	_Bamum:=}');
Expect(1, 42751, '\p{Is_Blk=bamum}', "");
Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
Expect(0, 42751, '\P{Is_Blk=bamum}', "");
Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
Expect(0, 42752, '\p{Is_Blk=bamum}', "");
Expect(1, 42752, '\p{^Is_Blk=bamum}', "");
Expect(1, 42752, '\P{Is_Blk=bamum}', "");
Expect(0, 42752, '\P{^Is_Blk=bamum}', "");
Expect(1, 42751, '\p{Is_Blk=__Bamum}', "");
Expect(0, 42751, '\p{^Is_Blk=__Bamum}', "");
Expect(0, 42751, '\P{Is_Blk=__Bamum}', "");
Expect(1, 42751, '\P{^Is_Blk=__Bamum}', "");
Expect(0, 42752, '\p{Is_Blk=__Bamum}', "");
Expect(1, 42752, '\p{^Is_Blk=__Bamum}', "");
Expect(1, 42752, '\P{Is_Blk=__Bamum}', "");
Expect(0, 42752, '\P{^Is_Blk=__Bamum}', "");
Error('\p{Block=_Bamum_Supplement/a/}');
Error('\P{Block=_Bamum_Supplement/a/}');
Expect(1, 92735, '\p{Block=bamumsupplement}', "");
Expect(0, 92735, '\p{^Block=bamumsupplement}', "");
Expect(0, 92735, '\P{Block=bamumsupplement}', "");
Expect(1, 92735, '\P{^Block=bamumsupplement}', "");
Expect(0, 92736, '\p{Block=bamumsupplement}', "");
Expect(1, 92736, '\p{^Block=bamumsupplement}', "");
Expect(1, 92736, '\P{Block=bamumsupplement}', "");
Expect(0, 92736, '\P{^Block=bamumsupplement}', "");
Expect(1, 92735, '\p{Block=	Bamum_Supplement}', "");
Expect(0, 92735, '\p{^Block=	Bamum_Supplement}', "");
Expect(0, 92735, '\P{Block=	Bamum_Supplement}', "");
Expect(1, 92735, '\P{^Block=	Bamum_Supplement}', "");
Expect(0, 92736, '\p{Block=	Bamum_Supplement}', "");
Expect(1, 92736, '\p{^Block=	Bamum_Supplement}', "");
Expect(1, 92736, '\P{Block=	Bamum_Supplement}', "");
Expect(0, 92736, '\P{^Block=	Bamum_Supplement}', "");
Error('\p{Blk:   :=Bamum_sup}');
Error('\P{Blk:   :=Bamum_sup}');
Expect(1, 92735, '\p{Blk=bamumsup}', "");
Expect(0, 92735, '\p{^Blk=bamumsup}', "");
Expect(0, 92735, '\P{Blk=bamumsup}', "");
Expect(1, 92735, '\P{^Blk=bamumsup}', "");
Expect(0, 92736, '\p{Blk=bamumsup}', "");
Expect(1, 92736, '\p{^Blk=bamumsup}', "");
Expect(1, 92736, '\P{Blk=bamumsup}', "");
Expect(0, 92736, '\P{^Blk=bamumsup}', "");
Expect(1, 92735, '\p{Blk=-Bamum_Sup}', "");
Expect(0, 92735, '\p{^Blk=-Bamum_Sup}', "");
Expect(0, 92735, '\P{Blk=-Bamum_Sup}', "");
Expect(1, 92735, '\P{^Blk=-Bamum_Sup}', "");
Expect(0, 92736, '\p{Blk=-Bamum_Sup}', "");
Expect(1, 92736, '\p{^Blk=-Bamum_Sup}', "");
Expect(1, 92736, '\P{Blk=-Bamum_Sup}', "");
Expect(0, 92736, '\P{^Blk=-Bamum_Sup}', "");
Error('\p{Is_Block=_/a/bamum_Supplement}');
Error('\P{Is_Block=_/a/bamum_Supplement}');
Expect(1, 92735, '\p{Is_Block=bamumsupplement}', "");
Expect(0, 92735, '\p{^Is_Block=bamumsupplement}', "");
Expect(0, 92735, '\P{Is_Block=bamumsupplement}', "");
Expect(1, 92735, '\P{^Is_Block=bamumsupplement}', "");
Expect(0, 92736, '\p{Is_Block=bamumsupplement}', "");
Expect(1, 92736, '\p{^Is_Block=bamumsupplement}', "");
Expect(1, 92736, '\P{Is_Block=bamumsupplement}', "");
Expect(0, 92736, '\P{^Is_Block=bamumsupplement}', "");
Expect(1, 92735, '\p{Is_Block=		Bamum_Supplement}', "");
Expect(0, 92735, '\p{^Is_Block=		Bamum_Supplement}', "");
Expect(0, 92735, '\P{Is_Block=		Bamum_Supplement}', "");
Expect(1, 92735, '\P{^Is_Block=		Bamum_Supplement}', "");
Expect(0, 92736, '\p{Is_Block=		Bamum_Supplement}', "");
Expect(1, 92736, '\p{^Is_Block=		Bamum_Supplement}', "");
Expect(1, 92736, '\P{Is_Block=		Bamum_Supplement}', "");
Expect(0, 92736, '\P{^Is_Block=		Bamum_Supplement}', "");
Error('\p{Is_Blk=-/a/bamum_Sup}');
Error('\P{Is_Blk=-/a/bamum_Sup}');
Expect(1, 92735, '\p{Is_Blk=bamumsup}', "");
Expect(0, 92735, '\p{^Is_Blk=bamumsup}', "");
Expect(0, 92735, '\P{Is_Blk=bamumsup}', "");
Expect(1, 92735, '\P{^Is_Blk=bamumsup}', "");
Expect(0, 92736, '\p{Is_Blk=bamumsup}', "");
Expect(1, 92736, '\p{^Is_Blk=bamumsup}', "");
Expect(1, 92736, '\P{Is_Blk=bamumsup}', "");
Expect(0, 92736, '\P{^Is_Blk=bamumsup}', "");
Expect(1, 92735, '\p{Is_Blk=	_BAMUM_SUP}', "");
Expect(0, 92735, '\p{^Is_Blk=	_BAMUM_SUP}', "");
Expect(0, 92735, '\P{Is_Blk=	_BAMUM_SUP}', "");
Expect(1, 92735, '\P{^Is_Blk=	_BAMUM_SUP}', "");
Expect(0, 92736, '\p{Is_Blk=	_BAMUM_SUP}', "");
Expect(1, 92736, '\p{^Is_Blk=	_BAMUM_SUP}', "");
Expect(1, 92736, '\P{Is_Blk=	_BAMUM_SUP}', "");
Expect(0, 92736, '\P{^Is_Blk=	_BAMUM_SUP}', "");
Error('\p{Block= bassa_vah:=}');
Error('\P{Block= bassa_vah:=}');
Expect(1, 92927, '\p{Block=bassavah}', "");
Expect(0, 92927, '\p{^Block=bassavah}', "");
Expect(0, 92927, '\P{Block=bassavah}', "");
Expect(1, 92927, '\P{^Block=bassavah}', "");
Expect(0, 92928, '\p{Block=bassavah}', "");
Expect(1, 92928, '\p{^Block=bassavah}', "");
Expect(1, 92928, '\P{Block=bassavah}', "");
Expect(0, 92928, '\P{^Block=bassavah}', "");
Expect(1, 92927, '\p{Block= _Bassa_Vah}', "");
Expect(0, 92927, '\p{^Block= _Bassa_Vah}', "");
Expect(0, 92927, '\P{Block= _Bassa_Vah}', "");
Expect(1, 92927, '\P{^Block= _Bassa_Vah}', "");
Expect(0, 92928, '\p{Block= _Bassa_Vah}', "");
Expect(1, 92928, '\p{^Block= _Bassa_Vah}', "");
Expect(1, 92928, '\P{Block= _Bassa_Vah}', "");
Expect(0, 92928, '\P{^Block= _Bassa_Vah}', "");
Error('\p{Blk=/a/ bassa_VAH}');
Error('\P{Blk=/a/ bassa_VAH}');
Expect(1, 92927, '\p{Blk:bassavah}', "");
Expect(0, 92927, '\p{^Blk:bassavah}', "");
Expect(0, 92927, '\P{Blk:bassavah}', "");
Expect(1, 92927, '\P{^Blk:bassavah}', "");
Expect(0, 92928, '\p{Blk:bassavah}', "");
Expect(1, 92928, '\p{^Blk:bassavah}', "");
Expect(1, 92928, '\P{Blk:bassavah}', "");
Expect(0, 92928, '\P{^Blk:bassavah}', "");
Expect(1, 92927, '\p{Blk=	Bassa_vah}', "");
Expect(0, 92927, '\p{^Blk=	Bassa_vah}', "");
Expect(0, 92927, '\P{Blk=	Bassa_vah}', "");
Expect(1, 92927, '\P{^Blk=	Bassa_vah}', "");
Expect(0, 92928, '\p{Blk=	Bassa_vah}', "");
Expect(1, 92928, '\p{^Blk=	Bassa_vah}', "");
Expect(1, 92928, '\P{Blk=	Bassa_vah}', "");
Expect(0, 92928, '\P{^Blk=	Bassa_vah}', "");
Error('\p{Is_Block=_/a/bassa_VAH}');
Error('\P{Is_Block=_/a/bassa_VAH}');
Expect(1, 92927, '\p{Is_Block=bassavah}', "");
Expect(0, 92927, '\p{^Is_Block=bassavah}', "");
Expect(0, 92927, '\P{Is_Block=bassavah}', "");
Expect(1, 92927, '\P{^Is_Block=bassavah}', "");
Expect(0, 92928, '\p{Is_Block=bassavah}', "");
Expect(1, 92928, '\p{^Is_Block=bassavah}', "");
Expect(1, 92928, '\P{Is_Block=bassavah}', "");
Expect(0, 92928, '\P{^Is_Block=bassavah}', "");
Expect(1, 92927, '\p{Is_Block=_BASSA_vah}', "");
Expect(0, 92927, '\p{^Is_Block=_BASSA_vah}', "");
Expect(0, 92927, '\P{Is_Block=_BASSA_vah}', "");
Expect(1, 92927, '\P{^Is_Block=_BASSA_vah}', "");
Expect(0, 92928, '\p{Is_Block=_BASSA_vah}', "");
Expect(1, 92928, '\p{^Is_Block=_BASSA_vah}', "");
Expect(1, 92928, '\P{Is_Block=_BASSA_vah}', "");
Expect(0, 92928, '\P{^Is_Block=_BASSA_vah}', "");
Error('\p{Is_Blk=:=		Bassa_VAH}');
Error('\P{Is_Blk=:=		Bassa_VAH}');
Expect(1, 92927, '\p{Is_Blk=bassavah}', "");
Expect(0, 92927, '\p{^Is_Blk=bassavah}', "");
Expect(0, 92927, '\P{Is_Blk=bassavah}', "");
Expect(1, 92927, '\P{^Is_Blk=bassavah}', "");
Expect(0, 92928, '\p{Is_Blk=bassavah}', "");
Expect(1, 92928, '\p{^Is_Blk=bassavah}', "");
Expect(1, 92928, '\P{Is_Blk=bassavah}', "");
Expect(0, 92928, '\P{^Is_Blk=bassavah}', "");
Expect(1, 92927, '\p{Is_Blk=	_BASSA_Vah}', "");
Expect(0, 92927, '\p{^Is_Blk=	_BASSA_Vah}', "");
Expect(0, 92927, '\P{Is_Blk=	_BASSA_Vah}', "");
Expect(1, 92927, '\P{^Is_Blk=	_BASSA_Vah}', "");
Expect(0, 92928, '\p{Is_Blk=	_BASSA_Vah}', "");
Expect(1, 92928, '\p{^Is_Blk=	_BASSA_Vah}', "");
Expect(1, 92928, '\P{Is_Blk=	_BASSA_Vah}', "");
Expect(0, 92928, '\P{^Is_Blk=	_BASSA_Vah}', "");
Error('\p{Block=:=	Batak}');
Error('\P{Block=:=	Batak}');
Expect(1, 7167, '\p{Block=batak}', "");
Expect(0, 7167, '\p{^Block=batak}', "");
Expect(0, 7167, '\P{Block=batak}', "");
Expect(1, 7167, '\P{^Block=batak}', "");
Expect(0, 7168, '\p{Block=batak}', "");
Expect(1, 7168, '\p{^Block=batak}', "");
Expect(1, 7168, '\P{Block=batak}', "");
Expect(0, 7168, '\P{^Block=batak}', "");
Expect(1, 7167, '\p{Block=_Batak}', "");
Expect(0, 7167, '\p{^Block=_Batak}', "");
Expect(0, 7167, '\P{Block=_Batak}', "");
Expect(1, 7167, '\P{^Block=_Batak}', "");
Expect(0, 7168, '\p{Block=_Batak}', "");
Expect(1, 7168, '\p{^Block=_Batak}', "");
Expect(1, 7168, '\P{Block=_Batak}', "");
Expect(0, 7168, '\P{^Block=_Batak}', "");
Error('\p{Blk=_batak/a/}');
Error('\P{Blk=_batak/a/}');
Expect(1, 7167, '\p{Blk=batak}', "");
Expect(0, 7167, '\p{^Blk=batak}', "");
Expect(0, 7167, '\P{Blk=batak}', "");
Expect(1, 7167, '\P{^Blk=batak}', "");
Expect(0, 7168, '\p{Blk=batak}', "");
Expect(1, 7168, '\p{^Blk=batak}', "");
Expect(1, 7168, '\P{Blk=batak}', "");
Expect(0, 7168, '\P{^Blk=batak}', "");
Expect(1, 7167, '\p{Blk=_batak}', "");
Expect(0, 7167, '\p{^Blk=_batak}', "");
Expect(0, 7167, '\P{Blk=_batak}', "");
Expect(1, 7167, '\P{^Blk=_batak}', "");
Expect(0, 7168, '\p{Blk=_batak}', "");
Expect(1, 7168, '\p{^Blk=_batak}', "");
Expect(1, 7168, '\P{Blk=_batak}', "");
Expect(0, 7168, '\P{^Blk=_batak}', "");
Error('\p{Is_Block=_ Batak/a/}');
Error('\P{Is_Block=_ Batak/a/}');
Expect(1, 7167, '\p{Is_Block=batak}', "");
Expect(0, 7167, '\p{^Is_Block=batak}', "");
Expect(0, 7167, '\P{Is_Block=batak}', "");
Expect(1, 7167, '\P{^Is_Block=batak}', "");
Expect(0, 7168, '\p{Is_Block=batak}', "");
Expect(1, 7168, '\p{^Is_Block=batak}', "");
Expect(1, 7168, '\P{Is_Block=batak}', "");
Expect(0, 7168, '\P{^Is_Block=batak}', "");
Expect(1, 7167, '\p{Is_Block=	_batak}', "");
Expect(0, 7167, '\p{^Is_Block=	_batak}', "");
Expect(0, 7167, '\P{Is_Block=	_batak}', "");
Expect(1, 7167, '\P{^Is_Block=	_batak}', "");
Expect(0, 7168, '\p{Is_Block=	_batak}', "");
Expect(1, 7168, '\p{^Is_Block=	_batak}', "");
Expect(1, 7168, '\P{Is_Block=	_batak}', "");
Expect(0, 7168, '\P{^Is_Block=	_batak}', "");
Error('\p{Is_Blk=--Batak:=}');
Error('\P{Is_Blk=--Batak:=}');
Expect(1, 7167, '\p{Is_Blk=batak}', "");
Expect(0, 7167, '\p{^Is_Blk=batak}', "");
Expect(0, 7167, '\P{Is_Blk=batak}', "");
Expect(1, 7167, '\P{^Is_Blk=batak}', "");
Expect(0, 7168, '\p{Is_Blk=batak}', "");
Expect(1, 7168, '\p{^Is_Blk=batak}', "");
Expect(1, 7168, '\P{Is_Blk=batak}', "");
Expect(0, 7168, '\P{^Is_Blk=batak}', "");
Expect(1, 7167, '\p{Is_Blk=	_BATAK}', "");
Expect(0, 7167, '\p{^Is_Blk=	_BATAK}', "");
Expect(0, 7167, '\P{Is_Blk=	_BATAK}', "");
Expect(1, 7167, '\P{^Is_Blk=	_BATAK}', "");
Expect(0, 7168, '\p{Is_Blk=	_BATAK}', "");
Expect(1, 7168, '\p{^Is_Blk=	_BATAK}', "");
Expect(1, 7168, '\P{Is_Blk=	_BATAK}', "");
Expect(0, 7168, '\P{^Is_Blk=	_BATAK}', "");
Error('\p{Block=_/a/Bengali}');
Error('\P{Block=_/a/Bengali}');
Expect(1, 2559, '\p{Block=bengali}', "");
Expect(0, 2559, '\p{^Block=bengali}', "");
Expect(0, 2559, '\P{Block=bengali}', "");
Expect(1, 2559, '\P{^Block=bengali}', "");
Expect(0, 2560, '\p{Block=bengali}', "");
Expect(1, 2560, '\p{^Block=bengali}', "");
Expect(1, 2560, '\P{Block=bengali}', "");
Expect(0, 2560, '\P{^Block=bengali}', "");
Expect(1, 2559, '\p{Block: Bengali}', "");
Expect(0, 2559, '\p{^Block: Bengali}', "");
Expect(0, 2559, '\P{Block: Bengali}', "");
Expect(1, 2559, '\P{^Block: Bengali}', "");
Expect(0, 2560, '\p{Block: Bengali}', "");
Expect(1, 2560, '\p{^Block: Bengali}', "");
Expect(1, 2560, '\P{Block: Bengali}', "");
Expect(0, 2560, '\P{^Block: Bengali}', "");
Error('\p{Blk=--Bengali/a/}');
Error('\P{Blk=--Bengali/a/}');
Expect(1, 2559, '\p{Blk=bengali}', "");
Expect(0, 2559, '\p{^Blk=bengali}', "");
Expect(0, 2559, '\P{Blk=bengali}', "");
Expect(1, 2559, '\P{^Blk=bengali}', "");
Expect(0, 2560, '\p{Blk=bengali}', "");
Expect(1, 2560, '\p{^Blk=bengali}', "");
Expect(1, 2560, '\P{Blk=bengali}', "");
Expect(0, 2560, '\P{^Blk=bengali}', "");
Expect(1, 2559, '\p{Blk=- bengali}', "");
Expect(0, 2559, '\p{^Blk=- bengali}', "");
Expect(0, 2559, '\P{Blk=- bengali}', "");
Expect(1, 2559, '\P{^Blk=- bengali}', "");
Expect(0, 2560, '\p{Blk=- bengali}', "");
Expect(1, 2560, '\p{^Blk=- bengali}', "");
Expect(1, 2560, '\P{Blk=- bengali}', "");
Expect(0, 2560, '\P{^Blk=- bengali}', "");
Error('\p{Is_Block=:=BENGALI}');
Error('\P{Is_Block=:=BENGALI}');
Expect(1, 2559, '\p{Is_Block=bengali}', "");
Expect(0, 2559, '\p{^Is_Block=bengali}', "");
Expect(0, 2559, '\P{Is_Block=bengali}', "");
Expect(1, 2559, '\P{^Is_Block=bengali}', "");
Expect(0, 2560, '\p{Is_Block=bengali}', "");
Expect(1, 2560, '\p{^Is_Block=bengali}', "");
Expect(1, 2560, '\P{Is_Block=bengali}', "");
Expect(0, 2560, '\P{^Is_Block=bengali}', "");
Expect(1, 2559, '\p{Is_Block=  bengali}', "");
Expect(0, 2559, '\p{^Is_Block=  bengali}', "");
Expect(0, 2559, '\P{Is_Block=  bengali}', "");
Expect(1, 2559, '\P{^Is_Block=  bengali}', "");
Expect(0, 2560, '\p{Is_Block=  bengali}', "");
Expect(1, 2560, '\p{^Is_Block=  bengali}', "");
Expect(1, 2560, '\P{Is_Block=  bengali}', "");
Expect(0, 2560, '\P{^Is_Block=  bengali}', "");
Error('\p{Is_Blk=:=	 bengali}');
Error('\P{Is_Blk=:=	 bengali}');
Expect(1, 2559, '\p{Is_Blk=bengali}', "");
Expect(0, 2559, '\p{^Is_Blk=bengali}', "");
Expect(0, 2559, '\P{Is_Blk=bengali}', "");
Expect(1, 2559, '\P{^Is_Blk=bengali}', "");
Expect(0, 2560, '\p{Is_Blk=bengali}', "");
Expect(1, 2560, '\p{^Is_Blk=bengali}', "");
Expect(1, 2560, '\P{Is_Blk=bengali}', "");
Expect(0, 2560, '\P{^Is_Blk=bengali}', "");
Expect(1, 2559, '\p{Is_Blk=_	Bengali}', "");
Expect(0, 2559, '\p{^Is_Blk=_	Bengali}', "");
Expect(0, 2559, '\P{Is_Blk=_	Bengali}', "");
Expect(1, 2559, '\P{^Is_Blk=_	Bengali}', "");
Expect(0, 2560, '\p{Is_Blk=_	Bengali}', "");
Expect(1, 2560, '\p{^Is_Blk=_	Bengali}', "");
Expect(1, 2560, '\P{Is_Blk=_	Bengali}', "");
Expect(0, 2560, '\P{^Is_Blk=_	Bengali}', "");
Error('\p{Block=-/a/Block_Elements}');
Error('\P{Block=-/a/Block_Elements}');
Expect(1, 9631, '\p{Block: blockelements}', "");
Expect(0, 9631, '\p{^Block: blockelements}', "");
Expect(0, 9631, '\P{Block: blockelements}', "");
Expect(1, 9631, '\P{^Block: blockelements}', "");
Expect(0, 9632, '\p{Block: blockelements}', "");
Expect(1, 9632, '\p{^Block: blockelements}', "");
Expect(1, 9632, '\P{Block: blockelements}', "");
Expect(0, 9632, '\P{^Block: blockelements}', "");
Expect(1, 9631, '\p{Block= Block_Elements}', "");
Expect(0, 9631, '\p{^Block= Block_Elements}', "");
Expect(0, 9631, '\P{Block= Block_Elements}', "");
Expect(1, 9631, '\P{^Block= Block_Elements}', "");
Expect(0, 9632, '\p{Block= Block_Elements}', "");
Expect(1, 9632, '\p{^Block= Block_Elements}', "");
Expect(1, 9632, '\P{Block= Block_Elements}', "");
Expect(0, 9632, '\P{^Block= Block_Elements}', "");
Error('\p{Blk=_/a/Block_ELEMENTS}');
Error('\P{Blk=_/a/Block_ELEMENTS}');
Expect(1, 9631, '\p{Blk=blockelements}', "");
Expect(0, 9631, '\p{^Blk=blockelements}', "");
Expect(0, 9631, '\P{Blk=blockelements}', "");
Expect(1, 9631, '\P{^Blk=blockelements}', "");
Expect(0, 9632, '\p{Blk=blockelements}', "");
Expect(1, 9632, '\p{^Blk=blockelements}', "");
Expect(1, 9632, '\P{Blk=blockelements}', "");
Expect(0, 9632, '\P{^Blk=blockelements}', "");
Expect(1, 9631, '\p{Blk=_BLOCK_elements}', "");
Expect(0, 9631, '\p{^Blk=_BLOCK_elements}', "");
Expect(0, 9631, '\P{Blk=_BLOCK_elements}', "");
Expect(1, 9631, '\P{^Blk=_BLOCK_elements}', "");
Expect(0, 9632, '\p{Blk=_BLOCK_elements}', "");
Expect(1, 9632, '\p{^Blk=_BLOCK_elements}', "");
Expect(1, 9632, '\P{Blk=_BLOCK_elements}', "");
Expect(0, 9632, '\P{^Blk=_BLOCK_elements}', "");
Error('\p{Is_Block=:=--block_Elements}');
Error('\P{Is_Block=:=--block_Elements}');
Expect(1, 9631, '\p{Is_Block=blockelements}', "");
Expect(0, 9631, '\p{^Is_Block=blockelements}', "");
Expect(0, 9631, '\P{Is_Block=blockelements}', "");
Expect(1, 9631, '\P{^Is_Block=blockelements}', "");
Expect(0, 9632, '\p{Is_Block=blockelements}', "");
Expect(1, 9632, '\p{^Is_Block=blockelements}', "");
Expect(1, 9632, '\P{Is_Block=blockelements}', "");
Expect(0, 9632, '\P{^Is_Block=blockelements}', "");
Expect(1, 9631, '\p{Is_Block=-Block_Elements}', "");
Expect(0, 9631, '\p{^Is_Block=-Block_Elements}', "");
Expect(0, 9631, '\P{Is_Block=-Block_Elements}', "");
Expect(1, 9631, '\P{^Is_Block=-Block_Elements}', "");
Expect(0, 9632, '\p{Is_Block=-Block_Elements}', "");
Expect(1, 9632, '\p{^Is_Block=-Block_Elements}', "");
Expect(1, 9632, '\P{Is_Block=-Block_Elements}', "");
Expect(0, 9632, '\P{^Is_Block=-Block_Elements}', "");
Error('\p{Is_Blk=/a/ 	Block_Elements}');
Error('\P{Is_Blk=/a/ 	Block_Elements}');
Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
Expect(0, 9632, '\p{Is_Blk=blockelements}', "");
Expect(1, 9632, '\p{^Is_Blk=blockelements}', "");
Expect(1, 9632, '\P{Is_Blk=blockelements}', "");
Expect(0, 9632, '\P{^Is_Blk=blockelements}', "");
Expect(1, 9631, '\p{Is_Blk=	Block_Elements}', "");
Expect(0, 9631, '\p{^Is_Blk=	Block_Elements}', "");
Expect(0, 9631, '\P{Is_Blk=	Block_Elements}', "");
Expect(1, 9631, '\P{^Is_Blk=	Block_Elements}', "");
Expect(0, 9632, '\p{Is_Blk=	Block_Elements}', "");
Expect(1, 9632, '\p{^Is_Blk=	Block_Elements}', "");
Expect(1, 9632, '\P{Is_Blk=	Block_Elements}', "");
Expect(0, 9632, '\P{^Is_Blk=	Block_Elements}', "");
Error('\p{Block=-BOPOMOFO/a/}');
Error('\P{Block=-BOPOMOFO/a/}');
Expect(1, 12591, '\p{Block=bopomofo}', "");
Expect(0, 12591, '\p{^Block=bopomofo}', "");
Expect(0, 12591, '\P{Block=bopomofo}', "");
Expect(1, 12591, '\P{^Block=bopomofo}', "");
Expect(0, 12592, '\p{Block=bopomofo}', "");
Expect(1, 12592, '\p{^Block=bopomofo}', "");
Expect(1, 12592, '\P{Block=bopomofo}', "");
Expect(0, 12592, '\P{^Block=bopomofo}', "");
Expect(1, 12591, '\p{Block=- Bopomofo}', "");
Expect(0, 12591, '\p{^Block=- Bopomofo}', "");
Expect(0, 12591, '\P{Block=- Bopomofo}', "");
Expect(1, 12591, '\P{^Block=- Bopomofo}', "");
Expect(0, 12592, '\p{Block=- Bopomofo}', "");
Expect(1, 12592, '\p{^Block=- Bopomofo}', "");
Expect(1, 12592, '\P{Block=- Bopomofo}', "");
Expect(0, 12592, '\P{^Block=- Bopomofo}', "");
Error('\p{Blk=	:=Bopomofo}');
Error('\P{Blk=	:=Bopomofo}');
Expect(1, 12591, '\p{Blk=bopomofo}', "");
Expect(0, 12591, '\p{^Blk=bopomofo}', "");
Expect(0, 12591, '\P{Blk=bopomofo}', "");
Expect(1, 12591, '\P{^Blk=bopomofo}', "");
Expect(0, 12592, '\p{Blk=bopomofo}', "");
Expect(1, 12592, '\p{^Blk=bopomofo}', "");
Expect(1, 12592, '\P{Blk=bopomofo}', "");
Expect(0, 12592, '\P{^Blk=bopomofo}', "");
Expect(1, 12591, '\p{Blk=  Bopomofo}', "");
Expect(0, 12591, '\p{^Blk=  Bopomofo}', "");
Expect(0, 12591, '\P{Blk=  Bopomofo}', "");
Expect(1, 12591, '\P{^Blk=  Bopomofo}', "");
Expect(0, 12592, '\p{Blk=  Bopomofo}', "");
Expect(1, 12592, '\p{^Blk=  Bopomofo}', "");
Expect(1, 12592, '\P{Blk=  Bopomofo}', "");
Expect(0, 12592, '\P{^Blk=  Bopomofo}', "");
Error('\p{Is_Block=:=	_bopomofo}');
Error('\P{Is_Block=:=	_bopomofo}');
Expect(1, 12591, '\p{Is_Block=bopomofo}', "");
Expect(0, 12591, '\p{^Is_Block=bopomofo}', "");
Expect(0, 12591, '\P{Is_Block=bopomofo}', "");
Expect(1, 12591, '\P{^Is_Block=bopomofo}', "");
Expect(0, 12592, '\p{Is_Block=bopomofo}', "");
Expect(1, 12592, '\p{^Is_Block=bopomofo}', "");
Expect(1, 12592, '\P{Is_Block=bopomofo}', "");
Expect(0, 12592, '\P{^Is_Block=bopomofo}', "");
Expect(1, 12591, '\p{Is_Block= _Bopomofo}', "");
Expect(0, 12591, '\p{^Is_Block= _Bopomofo}', "");
Expect(0, 12591, '\P{Is_Block= _Bopomofo}', "");
Expect(1, 12591, '\P{^Is_Block= _Bopomofo}', "");
Expect(0, 12592, '\p{Is_Block= _Bopomofo}', "");
Expect(1, 12592, '\p{^Is_Block= _Bopomofo}', "");
Expect(1, 12592, '\P{Is_Block= _Bopomofo}', "");
Expect(0, 12592, '\P{^Is_Block= _Bopomofo}', "");
Error('\p{Is_Blk=/a/ bopomofo}');
Error('\P{Is_Blk=/a/ bopomofo}');
Expect(1, 12591, '\p{Is_Blk=bopomofo}', "");
Expect(0, 12591, '\p{^Is_Blk=bopomofo}', "");
Expect(0, 12591, '\P{Is_Blk=bopomofo}', "");
Expect(1, 12591, '\P{^Is_Blk=bopomofo}', "");
Expect(0, 12592, '\p{Is_Blk=bopomofo}', "");
Expect(1, 12592, '\p{^Is_Blk=bopomofo}', "");
Expect(1, 12592, '\P{Is_Blk=bopomofo}', "");
Expect(0, 12592, '\P{^Is_Blk=bopomofo}', "");
Expect(1, 12591, '\p{Is_Blk= 	Bopomofo}', "");
Expect(0, 12591, '\p{^Is_Blk= 	Bopomofo}', "");
Expect(0, 12591, '\P{Is_Blk= 	Bopomofo}', "");
Expect(1, 12591, '\P{^Is_Blk= 	Bopomofo}', "");
Expect(0, 12592, '\p{Is_Blk= 	Bopomofo}', "");
Expect(1, 12592, '\p{^Is_Blk= 	Bopomofo}', "");
Expect(1, 12592, '\P{Is_Blk= 	Bopomofo}', "");
Expect(0, 12592, '\P{^Is_Blk= 	Bopomofo}', "");
Error('\p{Block=/a/--Bopomofo_EXTENDED}');
Error('\P{Block=/a/--Bopomofo_EXTENDED}');
Expect(1, 12735, '\p{Block: bopomofoextended}', "");
Expect(0, 12735, '\p{^Block: bopomofoextended}', "");
Expect(0, 12735, '\P{Block: bopomofoextended}', "");
Expect(1, 12735, '\P{^Block: bopomofoextended}', "");
Expect(0, 12736, '\p{Block: bopomofoextended}', "");
Expect(1, 12736, '\p{^Block: bopomofoextended}', "");
Expect(1, 12736, '\P{Block: bopomofoextended}', "");
Expect(0, 12736, '\P{^Block: bopomofoextended}', "");
Expect(1, 12735, '\p{Block=	-Bopomofo_EXTENDED}', "");
Expect(0, 12735, '\p{^Block=	-Bopomofo_EXTENDED}', "");
Expect(0, 12735, '\P{Block=	-Bopomofo_EXTENDED}', "");
Expect(1, 12735, '\P{^Block=	-Bopomofo_EXTENDED}', "");
Expect(0, 12736, '\p{Block=	-Bopomofo_EXTENDED}', "");
Expect(1, 12736, '\p{^Block=	-Bopomofo_EXTENDED}', "");
Expect(1, 12736, '\P{Block=	-Bopomofo_EXTENDED}', "");
Expect(0, 12736, '\P{^Block=	-Bopomofo_EXTENDED}', "");
Error('\p{Blk=-/a/BOPOMOFO_EXT}');
Error('\P{Blk=-/a/BOPOMOFO_EXT}');
Expect(1, 12735, '\p{Blk:	bopomofoext}', "");
Expect(0, 12735, '\p{^Blk:	bopomofoext}', "");
Expect(0, 12735, '\P{Blk:	bopomofoext}', "");
Expect(1, 12735, '\P{^Blk:	bopomofoext}', "");
Expect(0, 12736, '\p{Blk:	bopomofoext}', "");
Expect(1, 12736, '\p{^Blk:	bopomofoext}', "");
Expect(1, 12736, '\P{Blk:	bopomofoext}', "");
Expect(0, 12736, '\P{^Blk:	bopomofoext}', "");
Expect(1, 12735, '\p{Blk= _BOPOMOFO_Ext}', "");
Expect(0, 12735, '\p{^Blk= _BOPOMOFO_Ext}', "");
Expect(0, 12735, '\P{Blk= _BOPOMOFO_Ext}', "");
Expect(1, 12735, '\P{^Blk= _BOPOMOFO_Ext}', "");
Expect(0, 12736, '\p{Blk= _BOPOMOFO_Ext}', "");
Expect(1, 12736, '\p{^Blk= _BOPOMOFO_Ext}', "");
Expect(1, 12736, '\P{Blk= _BOPOMOFO_Ext}', "");
Expect(0, 12736, '\P{^Blk= _BOPOMOFO_Ext}', "");
Error('\p{Is_Block=/a/Bopomofo_EXTENDED}');
Error('\P{Is_Block=/a/Bopomofo_EXTENDED}');
Expect(1, 12735, '\p{Is_Block=bopomofoextended}', "");
Expect(0, 12735, '\p{^Is_Block=bopomofoextended}', "");
Expect(0, 12735, '\P{Is_Block=bopomofoextended}', "");
Expect(1, 12735, '\P{^Is_Block=bopomofoextended}', "");
Expect(0, 12736, '\p{Is_Block=bopomofoextended}', "");
Expect(1, 12736, '\p{^Is_Block=bopomofoextended}', "");
Expect(1, 12736, '\P{Is_Block=bopomofoextended}', "");
Expect(0, 12736, '\P{^Is_Block=bopomofoextended}', "");
Expect(1, 12735, '\p{Is_Block:	Bopomofo_extended}', "");
Expect(0, 12735, '\p{^Is_Block:	Bopomofo_extended}', "");
Expect(0, 12735, '\P{Is_Block:	Bopomofo_extended}', "");
Expect(1, 12735, '\P{^Is_Block:	Bopomofo_extended}', "");
Expect(0, 12736, '\p{Is_Block:	Bopomofo_extended}', "");
Expect(1, 12736, '\p{^Is_Block:	Bopomofo_extended}', "");
Expect(1, 12736, '\P{Is_Block:	Bopomofo_extended}', "");
Expect(0, 12736, '\P{^Is_Block:	Bopomofo_extended}', "");
Error('\p{Is_Blk=	Bopomofo_ext/a/}');
Error('\P{Is_Blk=	Bopomofo_ext/a/}');
Expect(1, 12735, '\p{Is_Blk=bopomofoext}', "");
Expect(0, 12735, '\p{^Is_Blk=bopomofoext}', "");
Expect(0, 12735, '\P{Is_Blk=bopomofoext}', "");
Expect(1, 12735, '\P{^Is_Blk=bopomofoext}', "");
Expect(0, 12736, '\p{Is_Blk=bopomofoext}', "");
Expect(1, 12736, '\p{^Is_Blk=bopomofoext}', "");
Expect(1, 12736, '\P{Is_Blk=bopomofoext}', "");
Expect(0, 12736, '\P{^Is_Blk=bopomofoext}', "");
Expect(1, 12735, '\p{Is_Blk= BOPOMOFO_EXT}', "");
Expect(0, 12735, '\p{^Is_Blk= BOPOMOFO_EXT}', "");
Expect(0, 12735, '\P{Is_Blk= BOPOMOFO_EXT}', "");
Expect(1, 12735, '\P{^Is_Blk= BOPOMOFO_EXT}', "");
Expect(0, 12736, '\p{Is_Blk= BOPOMOFO_EXT}', "");
Expect(1, 12736, '\p{^Is_Blk= BOPOMOFO_EXT}', "");
Expect(1, 12736, '\P{Is_Blk= BOPOMOFO_EXT}', "");
Expect(0, 12736, '\P{^Is_Blk= BOPOMOFO_EXT}', "");
Error('\p{Block=/a/		Box_Drawing}');
Error('\P{Block=/a/		Box_Drawing}');
Expect(1, 9599, '\p{Block=boxdrawing}', "");
Expect(0, 9599, '\p{^Block=boxdrawing}', "");
Expect(0, 9599, '\P{Block=boxdrawing}', "");
Expect(1, 9599, '\P{^Block=boxdrawing}', "");
Expect(0, 9600, '\p{Block=boxdrawing}', "");
Expect(1, 9600, '\p{^Block=boxdrawing}', "");
Expect(1, 9600, '\P{Block=boxdrawing}', "");
Expect(0, 9600, '\P{^Block=boxdrawing}', "");
Expect(1, 9599, '\p{Block=_ Box_DRAWING}', "");
Expect(0, 9599, '\p{^Block=_ Box_DRAWING}', "");
Expect(0, 9599, '\P{Block=_ Box_DRAWING}', "");
Expect(1, 9599, '\P{^Block=_ Box_DRAWING}', "");
Expect(0, 9600, '\p{Block=_ Box_DRAWING}', "");
Expect(1, 9600, '\p{^Block=_ Box_DRAWING}', "");
Expect(1, 9600, '\P{Block=_ Box_DRAWING}', "");
Expect(0, 9600, '\P{^Block=_ Box_DRAWING}', "");
Error('\p{Blk=/a/  box_Drawing}');
Error('\P{Blk=/a/  box_Drawing}');
Expect(1, 9599, '\p{Blk:   boxdrawing}', "");
Expect(0, 9599, '\p{^Blk:   boxdrawing}', "");
Expect(0, 9599, '\P{Blk:   boxdrawing}', "");
Expect(1, 9599, '\P{^Blk:   boxdrawing}', "");
Expect(0, 9600, '\p{Blk:   boxdrawing}', "");
Expect(1, 9600, '\p{^Blk:   boxdrawing}', "");
Expect(1, 9600, '\P{Blk:   boxdrawing}', "");
Expect(0, 9600, '\P{^Blk:   boxdrawing}', "");
Expect(1, 9599, '\p{Blk=	 BOX_Drawing}', "");
Expect(0, 9599, '\p{^Blk=	 BOX_Drawing}', "");
Expect(0, 9599, '\P{Blk=	 BOX_Drawing}', "");
Expect(1, 9599, '\P{^Blk=	 BOX_Drawing}', "");
Expect(0, 9600, '\p{Blk=	 BOX_Drawing}', "");
Expect(1, 9600, '\p{^Blk=	 BOX_Drawing}', "");
Expect(1, 9600, '\P{Blk=	 BOX_Drawing}', "");
Expect(0, 9600, '\P{^Blk=	 BOX_Drawing}', "");
Error('\p{Is_Block=_:=box_Drawing}');
Error('\P{Is_Block=_:=box_Drawing}');
Expect(1, 9599, '\p{Is_Block:	boxdrawing}', "");
Expect(0, 9599, '\p{^Is_Block:	boxdrawing}', "");
Expect(0, 9599, '\P{Is_Block:	boxdrawing}', "");
Expect(1, 9599, '\P{^Is_Block:	boxdrawing}', "");
Expect(0, 9600, '\p{Is_Block:	boxdrawing}', "");
Expect(1, 9600, '\p{^Is_Block:	boxdrawing}', "");
Expect(1, 9600, '\P{Is_Block:	boxdrawing}', "");
Expect(0, 9600, '\P{^Is_Block:	boxdrawing}', "");
Expect(1, 9599, '\p{Is_Block=	-box_drawing}', "");
Expect(0, 9599, '\p{^Is_Block=	-box_drawing}', "");
Expect(0, 9599, '\P{Is_Block=	-box_drawing}', "");
Expect(1, 9599, '\P{^Is_Block=	-box_drawing}', "");
Expect(0, 9600, '\p{Is_Block=	-box_drawing}', "");
Expect(1, 9600, '\p{^Is_Block=	-box_drawing}', "");
Expect(1, 9600, '\P{Is_Block=	-box_drawing}', "");
Expect(0, 9600, '\P{^Is_Block=	-box_drawing}', "");
Error('\p{Is_Blk=/a/_	box_DRAWING}');
Error('\P{Is_Blk=/a/_	box_DRAWING}');
Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
Expect(0, 9600, '\p{Is_Blk=boxdrawing}', "");
Expect(1, 9600, '\p{^Is_Blk=boxdrawing}', "");
Expect(1, 9600, '\P{Is_Blk=boxdrawing}', "");
Expect(0, 9600, '\P{^Is_Blk=boxdrawing}', "");
Expect(1, 9599, '\p{Is_Blk=- BOX_drawing}', "");
Expect(0, 9599, '\p{^Is_Blk=- BOX_drawing}', "");
Expect(0, 9599, '\P{Is_Blk=- BOX_drawing}', "");
Expect(1, 9599, '\P{^Is_Blk=- BOX_drawing}', "");
Expect(0, 9600, '\p{Is_Blk=- BOX_drawing}', "");
Expect(1, 9600, '\p{^Is_Blk=- BOX_drawing}', "");
Expect(1, 9600, '\P{Is_Blk=- BOX_drawing}', "");
Expect(0, 9600, '\P{^Is_Blk=- BOX_drawing}', "");
Error('\p{Block=	:=brahmi}');
Error('\P{Block=	:=brahmi}');
Expect(1, 69759, '\p{Block:	brahmi}', "");
Expect(0, 69759, '\p{^Block:	brahmi}', "");
Expect(0, 69759, '\P{Block:	brahmi}', "");
Expect(1, 69759, '\P{^Block:	brahmi}', "");
Expect(0, 69760, '\p{Block:	brahmi}', "");
Expect(1, 69760, '\p{^Block:	brahmi}', "");
Expect(1, 69760, '\P{Block:	brahmi}', "");
Expect(0, 69760, '\P{^Block:	brahmi}', "");
Expect(1, 69759, '\p{Block=_	Brahmi}', "");
Expect(0, 69759, '\p{^Block=_	Brahmi}', "");
Expect(0, 69759, '\P{Block=_	Brahmi}', "");
Expect(1, 69759, '\P{^Block=_	Brahmi}', "");
Expect(0, 69760, '\p{Block=_	Brahmi}', "");
Expect(1, 69760, '\p{^Block=_	Brahmi}', "");
Expect(1, 69760, '\P{Block=_	Brahmi}', "");
Expect(0, 69760, '\P{^Block=_	Brahmi}', "");
Error('\p{Blk=:=-Brahmi}');
Error('\P{Blk=:=-Brahmi}');
Expect(1, 69759, '\p{Blk:	brahmi}', "");
Expect(0, 69759, '\p{^Blk:	brahmi}', "");
Expect(0, 69759, '\P{Blk:	brahmi}', "");
Expect(1, 69759, '\P{^Blk:	brahmi}', "");
Expect(0, 69760, '\p{Blk:	brahmi}', "");
Expect(1, 69760, '\p{^Blk:	brahmi}', "");
Expect(1, 69760, '\P{Blk:	brahmi}', "");
Expect(0, 69760, '\P{^Blk:	brahmi}', "");
Expect(1, 69759, '\p{Blk:   _BRAHMI}', "");
Expect(0, 69759, '\p{^Blk:   _BRAHMI}', "");
Expect(0, 69759, '\P{Blk:   _BRAHMI}', "");
Expect(1, 69759, '\P{^Blk:   _BRAHMI}', "");
Expect(0, 69760, '\p{Blk:   _BRAHMI}', "");
Expect(1, 69760, '\p{^Blk:   _BRAHMI}', "");
Expect(1, 69760, '\P{Blk:   _BRAHMI}', "");
Expect(0, 69760, '\P{^Blk:   _BRAHMI}', "");
Error('\p{Is_Block=:=Brahmi}');
Error('\P{Is_Block=:=Brahmi}');
Expect(1, 69759, '\p{Is_Block=brahmi}', "");
Expect(0, 69759, '\p{^Is_Block=brahmi}', "");
Expect(0, 69759, '\P{Is_Block=brahmi}', "");
Expect(1, 69759, '\P{^Is_Block=brahmi}', "");
Expect(0, 69760, '\p{Is_Block=brahmi}', "");
Expect(1, 69760, '\p{^Is_Block=brahmi}', "");
Expect(1, 69760, '\P{Is_Block=brahmi}', "");
Expect(0, 69760, '\P{^Is_Block=brahmi}', "");
Expect(1, 69759, '\p{Is_Block=	Brahmi}', "");
Expect(0, 69759, '\p{^Is_Block=	Brahmi}', "");
Expect(0, 69759, '\P{Is_Block=	Brahmi}', "");
Expect(1, 69759, '\P{^Is_Block=	Brahmi}', "");
Expect(0, 69760, '\p{Is_Block=	Brahmi}', "");
Expect(1, 69760, '\p{^Is_Block=	Brahmi}', "");
Expect(1, 69760, '\P{Is_Block=	Brahmi}', "");
Expect(0, 69760, '\P{^Is_Block=	Brahmi}', "");
Error('\p{Is_Blk=- Brahmi/a/}');
Error('\P{Is_Blk=- Brahmi/a/}');
Expect(1, 69759, '\p{Is_Blk=brahmi}', "");
Expect(0, 69759, '\p{^Is_Blk=brahmi}', "");
Expect(0, 69759, '\P{Is_Blk=brahmi}', "");
Expect(1, 69759, '\P{^Is_Blk=brahmi}', "");
Expect(0, 69760, '\p{Is_Blk=brahmi}', "");
Expect(1, 69760, '\p{^Is_Blk=brahmi}', "");
Expect(1, 69760, '\P{Is_Blk=brahmi}', "");
Expect(0, 69760, '\P{^Is_Blk=brahmi}', "");
Expect(1, 69759, '\p{Is_Blk=_ Brahmi}', "");
Expect(0, 69759, '\p{^Is_Blk=_ Brahmi}', "");
Expect(0, 69759, '\P{Is_Blk=_ Brahmi}', "");
Expect(1, 69759, '\P{^Is_Blk=_ Brahmi}', "");
Expect(0, 69760, '\p{Is_Blk=_ Brahmi}', "");
Expect(1, 69760, '\p{^Is_Blk=_ Brahmi}', "");
Expect(1, 69760, '\P{Is_Blk=_ Brahmi}', "");
Expect(0, 69760, '\P{^Is_Blk=_ Brahmi}', "");
Error('\p{Block=_:=BRAILLE_patterns}');
Error('\P{Block=_:=BRAILLE_patterns}');
Expect(1, 10495, '\p{Block=braillepatterns}', "");
Expect(0, 10495, '\p{^Block=braillepatterns}', "");
Expect(0, 10495, '\P{Block=braillepatterns}', "");
Expect(1, 10495, '\P{^Block=braillepatterns}', "");
Expect(0, 10496, '\p{Block=braillepatterns}', "");
Expect(1, 10496, '\p{^Block=braillepatterns}', "");
Expect(1, 10496, '\P{Block=braillepatterns}', "");
Expect(0, 10496, '\P{^Block=braillepatterns}', "");
Expect(1, 10495, '\p{Block:    -BRAILLE_PATTERNS}', "");
Expect(0, 10495, '\p{^Block:    -BRAILLE_PATTERNS}', "");
Expect(0, 10495, '\P{Block:    -BRAILLE_PATTERNS}', "");
Expect(1, 10495, '\P{^Block:    -BRAILLE_PATTERNS}', "");
Expect(0, 10496, '\p{Block:    -BRAILLE_PATTERNS}', "");
Expect(1, 10496, '\p{^Block:    -BRAILLE_PATTERNS}', "");
Expect(1, 10496, '\P{Block:    -BRAILLE_PATTERNS}', "");
Expect(0, 10496, '\P{^Block:    -BRAILLE_PATTERNS}', "");
Error('\p{Blk=  braille:=}');
Error('\P{Blk=  braille:=}');
Expect(1, 10495, '\p{Blk=braille}', "");
Expect(0, 10495, '\p{^Blk=braille}', "");
Expect(0, 10495, '\P{Blk=braille}', "");
Expect(1, 10495, '\P{^Blk=braille}', "");
Expect(0, 10496, '\p{Blk=braille}', "");
Expect(1, 10496, '\p{^Blk=braille}', "");
Expect(1, 10496, '\P{Blk=braille}', "");
Expect(0, 10496, '\P{^Blk=braille}', "");
Expect(1, 10495, '\p{Blk=		BRAILLE}', "");
Expect(0, 10495, '\p{^Blk=		BRAILLE}', "");
Expect(0, 10495, '\P{Blk=		BRAILLE}', "");
Expect(1, 10495, '\P{^Blk=		BRAILLE}', "");
Expect(0, 10496, '\p{Blk=		BRAILLE}', "");
Expect(1, 10496, '\p{^Blk=		BRAILLE}', "");
Expect(1, 10496, '\P{Blk=		BRAILLE}', "");
Expect(0, 10496, '\P{^Blk=		BRAILLE}', "");
Error('\p{Is_Block=_-BRAILLE_Patterns/a/}');
Error('\P{Is_Block=_-BRAILLE_Patterns/a/}');
Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
Expect(0, 10496, '\p{Is_Block=braillepatterns}', "");
Expect(1, 10496, '\p{^Is_Block=braillepatterns}', "");
Expect(1, 10496, '\P{Is_Block=braillepatterns}', "");
Expect(0, 10496, '\P{^Is_Block=braillepatterns}', "");
Expect(1, 10495, '\p{Is_Block=  BRAILLE_Patterns}', "");
Expect(0, 10495, '\p{^Is_Block=  BRAILLE_Patterns}', "");
Expect(0, 10495, '\P{Is_Block=  BRAILLE_Patterns}', "");
Expect(1, 10495, '\P{^Is_Block=  BRAILLE_Patterns}', "");
Expect(0, 10496, '\p{Is_Block=  BRAILLE_Patterns}', "");
Expect(1, 10496, '\p{^Is_Block=  BRAILLE_Patterns}', "");
Expect(1, 10496, '\P{Is_Block=  BRAILLE_Patterns}', "");
Expect(0, 10496, '\P{^Is_Block=  BRAILLE_Patterns}', "");
Error('\p{Is_Blk=	:=Braille}');
Error('\P{Is_Blk=	:=Braille}');
Expect(1, 10495, '\p{Is_Blk=braille}', "");
Expect(0, 10495, '\p{^Is_Blk=braille}', "");
Expect(0, 10495, '\P{Is_Blk=braille}', "");
Expect(1, 10495, '\P{^Is_Blk=braille}', "");
Expect(0, 10496, '\p{Is_Blk=braille}', "");
Expect(1, 10496, '\p{^Is_Blk=braille}', "");
Expect(1, 10496, '\P{Is_Blk=braille}', "");
Expect(0, 10496, '\P{^Is_Blk=braille}', "");
Expect(1, 10495, '\p{Is_Blk= braille}', "");
Expect(0, 10495, '\p{^Is_Blk= braille}', "");
Expect(0, 10495, '\P{Is_Blk= braille}', "");
Expect(1, 10495, '\P{^Is_Blk= braille}', "");
Expect(0, 10496, '\p{Is_Blk= braille}', "");
Expect(1, 10496, '\p{^Is_Blk= braille}', "");
Expect(1, 10496, '\P{Is_Blk= braille}', "");
Expect(0, 10496, '\P{^Is_Blk= braille}', "");
Error('\p{Block=_	BUGINESE/a/}');
Error('\P{Block=_	BUGINESE/a/}');
Expect(1, 6687, '\p{Block:	buginese}', "");
Expect(0, 6687, '\p{^Block:	buginese}', "");
Expect(0, 6687, '\P{Block:	buginese}', "");
Expect(1, 6687, '\P{^Block:	buginese}', "");
Expect(0, 6688, '\p{Block:	buginese}', "");
Expect(1, 6688, '\p{^Block:	buginese}', "");
Expect(1, 6688, '\P{Block:	buginese}', "");
Expect(0, 6688, '\P{^Block:	buginese}', "");
Expect(1, 6687, '\p{Block=	Buginese}', "");
Expect(0, 6687, '\p{^Block=	Buginese}', "");
Expect(0, 6687, '\P{Block=	Buginese}', "");
Expect(1, 6687, '\P{^Block=	Buginese}', "");
Expect(0, 6688, '\p{Block=	Buginese}', "");
Expect(1, 6688, '\p{^Block=	Buginese}', "");
Expect(1, 6688, '\P{Block=	Buginese}', "");
Expect(0, 6688, '\P{^Block=	Buginese}', "");
Error('\p{Blk=:=__Buginese}');
Error('\P{Blk=:=__Buginese}');
Expect(1, 6687, '\p{Blk=buginese}', "");
Expect(0, 6687, '\p{^Blk=buginese}', "");
Expect(0, 6687, '\P{Blk=buginese}', "");
Expect(1, 6687, '\P{^Blk=buginese}', "");
Expect(0, 6688, '\p{Blk=buginese}', "");
Expect(1, 6688, '\p{^Blk=buginese}', "");
Expect(1, 6688, '\P{Blk=buginese}', "");
Expect(0, 6688, '\P{^Blk=buginese}', "");
Expect(1, 6687, '\p{Blk=	_buginese}', "");
Expect(0, 6687, '\p{^Blk=	_buginese}', "");
Expect(0, 6687, '\P{Blk=	_buginese}', "");
Expect(1, 6687, '\P{^Blk=	_buginese}', "");
Expect(0, 6688, '\p{Blk=	_buginese}', "");
Expect(1, 6688, '\p{^Blk=	_buginese}', "");
Expect(1, 6688, '\P{Blk=	_buginese}', "");
Expect(0, 6688, '\P{^Blk=	_buginese}', "");
Error('\p{Is_Block=/a/ 	buginese}');
Error('\P{Is_Block=/a/ 	buginese}');
Expect(1, 6687, '\p{Is_Block:   buginese}', "");
Expect(0, 6687, '\p{^Is_Block:   buginese}', "");
Expect(0, 6687, '\P{Is_Block:   buginese}', "");
Expect(1, 6687, '\P{^Is_Block:   buginese}', "");
Expect(0, 6688, '\p{Is_Block:   buginese}', "");
Expect(1, 6688, '\p{^Is_Block:   buginese}', "");
Expect(1, 6688, '\P{Is_Block:   buginese}', "");
Expect(0, 6688, '\P{^Is_Block:   buginese}', "");
Expect(1, 6687, '\p{Is_Block=__Buginese}', "");
Expect(0, 6687, '\p{^Is_Block=__Buginese}', "");
Expect(0, 6687, '\P{Is_Block=__Buginese}', "");
Expect(1, 6687, '\P{^Is_Block=__Buginese}', "");
Expect(0, 6688, '\p{Is_Block=__Buginese}', "");
Expect(1, 6688, '\p{^Is_Block=__Buginese}', "");
Expect(1, 6688, '\P{Is_Block=__Buginese}', "");
Expect(0, 6688, '\P{^Is_Block=__Buginese}', "");
Error('\p{Is_Blk=	/a/Buginese}');
Error('\P{Is_Blk=	/a/Buginese}');
Expect(1, 6687, '\p{Is_Blk=buginese}', "");
Expect(0, 6687, '\p{^Is_Blk=buginese}', "");
Expect(0, 6687, '\P{Is_Blk=buginese}', "");
Expect(1, 6687, '\P{^Is_Blk=buginese}', "");
Expect(0, 6688, '\p{Is_Blk=buginese}', "");
Expect(1, 6688, '\p{^Is_Blk=buginese}', "");
Expect(1, 6688, '\P{Is_Blk=buginese}', "");
Expect(0, 6688, '\P{^Is_Blk=buginese}', "");
Expect(1, 6687, '\p{Is_Blk: -	buginese}', "");
Expect(0, 6687, '\p{^Is_Blk: -	buginese}', "");
Expect(0, 6687, '\P{Is_Blk: -	buginese}', "");
Expect(1, 6687, '\P{^Is_Blk: -	buginese}', "");
Expect(0, 6688, '\p{Is_Blk: -	buginese}', "");
Expect(1, 6688, '\p{^Is_Blk: -	buginese}', "");
Expect(1, 6688, '\P{Is_Blk: -	buginese}', "");
Expect(0, 6688, '\P{^Is_Blk: -	buginese}', "");
Error('\p{Block=:=Buhid}');
Error('\P{Block=:=Buhid}');
Expect(1, 5983, '\p{Block=buhid}', "");
Expect(0, 5983, '\p{^Block=buhid}', "");
Expect(0, 5983, '\P{Block=buhid}', "");
Expect(1, 5983, '\P{^Block=buhid}', "");
Expect(0, 5984, '\p{Block=buhid}', "");
Expect(1, 5984, '\p{^Block=buhid}', "");
Expect(1, 5984, '\P{Block=buhid}', "");
Expect(0, 5984, '\P{^Block=buhid}', "");
Expect(1, 5983, '\p{Block=_	Buhid}', "");
Expect(0, 5983, '\p{^Block=_	Buhid}', "");
Expect(0, 5983, '\P{Block=_	Buhid}', "");
Expect(1, 5983, '\P{^Block=_	Buhid}', "");
Expect(0, 5984, '\p{Block=_	Buhid}', "");
Expect(1, 5984, '\p{^Block=_	Buhid}', "");
Expect(1, 5984, '\P{Block=_	Buhid}', "");
Expect(0, 5984, '\P{^Block=_	Buhid}', "");
Error('\p{Blk=_Buhid/a/}');
Error('\P{Blk=_Buhid/a/}');
Expect(1, 5983, '\p{Blk=buhid}', "");
Expect(0, 5983, '\p{^Blk=buhid}', "");
Expect(0, 5983, '\P{Blk=buhid}', "");
Expect(1, 5983, '\P{^Blk=buhid}', "");
Expect(0, 5984, '\p{Blk=buhid}', "");
Expect(1, 5984, '\p{^Blk=buhid}', "");
Expect(1, 5984, '\P{Blk=buhid}', "");
Expect(0, 5984, '\P{^Blk=buhid}', "");
Expect(1, 5983, '\p{Blk=		Buhid}', "");
Expect(0, 5983, '\p{^Blk=		Buhid}', "");
Expect(0, 5983, '\P{Blk=		Buhid}', "");
Expect(1, 5983, '\P{^Blk=		Buhid}', "");
Expect(0, 5984, '\p{Blk=		Buhid}', "");
Expect(1, 5984, '\p{^Blk=		Buhid}', "");
Expect(1, 5984, '\P{Blk=		Buhid}', "");
Expect(0, 5984, '\P{^Blk=		Buhid}', "");
Error('\p{Is_Block=-/a/Buhid}');
Error('\P{Is_Block=-/a/Buhid}');
Expect(1, 5983, '\p{Is_Block=buhid}', "");
Expect(0, 5983, '\p{^Is_Block=buhid}', "");
Expect(0, 5983, '\P{Is_Block=buhid}', "");
Expect(1, 5983, '\P{^Is_Block=buhid}', "");
Expect(0, 5984, '\p{Is_Block=buhid}', "");
Expect(1, 5984, '\p{^Is_Block=buhid}', "");
Expect(1, 5984, '\P{Is_Block=buhid}', "");
Expect(0, 5984, '\P{^Is_Block=buhid}', "");
Expect(1, 5983, '\p{Is_Block=	 BUHID}', "");
Expect(0, 5983, '\p{^Is_Block=	 BUHID}', "");
Expect(0, 5983, '\P{Is_Block=	 BUHID}', "");
Expect(1, 5983, '\P{^Is_Block=	 BUHID}', "");
Expect(0, 5984, '\p{Is_Block=	 BUHID}', "");
Expect(1, 5984, '\p{^Is_Block=	 BUHID}', "");
Expect(1, 5984, '\P{Is_Block=	 BUHID}', "");
Expect(0, 5984, '\P{^Is_Block=	 BUHID}', "");
Error('\p{Is_Blk=-_buhid/a/}');
Error('\P{Is_Blk=-_buhid/a/}');
Expect(1, 5983, '\p{Is_Blk=buhid}', "");
Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
Expect(0, 5983, '\P{Is_Blk=buhid}', "");
Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
Expect(0, 5984, '\p{Is_Blk=buhid}', "");
Expect(1, 5984, '\p{^Is_Blk=buhid}', "");
Expect(1, 5984, '\P{Is_Blk=buhid}', "");
Expect(0, 5984, '\P{^Is_Blk=buhid}', "");
Expect(1, 5983, '\p{Is_Blk:	-Buhid}', "");
Expect(0, 5983, '\p{^Is_Blk:	-Buhid}', "");
Expect(0, 5983, '\P{Is_Blk:	-Buhid}', "");
Expect(1, 5983, '\P{^Is_Blk:	-Buhid}', "");
Expect(0, 5984, '\p{Is_Blk:	-Buhid}', "");
Expect(1, 5984, '\p{^Is_Blk:	-Buhid}', "");
Expect(1, 5984, '\P{Is_Blk:	-Buhid}', "");
Expect(0, 5984, '\P{^Is_Blk:	-Buhid}', "");
Error('\p{Block=-/a/BYZANTINE_musical_Symbols}');
Error('\P{Block=-/a/BYZANTINE_musical_Symbols}');
Expect(1, 119039, '\p{Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Block=byzantinemusicalsymbols}', "");
Expect(0, 119040, '\p{Block=byzantinemusicalsymbols}', "");
Expect(1, 119040, '\p{^Block=byzantinemusicalsymbols}', "");
Expect(1, 119040, '\P{Block=byzantinemusicalsymbols}', "");
Expect(0, 119040, '\P{^Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Block=	_Byzantine_Musical_Symbols}', "");
Expect(0, 119039, '\p{^Block=	_Byzantine_Musical_Symbols}', "");
Expect(0, 119039, '\P{Block=	_Byzantine_Musical_Symbols}', "");
Expect(1, 119039, '\P{^Block=	_Byzantine_Musical_Symbols}', "");
Expect(0, 119040, '\p{Block=	_Byzantine_Musical_Symbols}', "");
Expect(1, 119040, '\p{^Block=	_Byzantine_Musical_Symbols}', "");
Expect(1, 119040, '\P{Block=	_Byzantine_Musical_Symbols}', "");
Expect(0, 119040, '\P{^Block=	_Byzantine_Musical_Symbols}', "");
Error('\p{Blk=/a/_-Byzantine_music}');
Error('\P{Blk=/a/_-Byzantine_music}');
Expect(1, 119039, '\p{Blk=byzantinemusic}', "");
Expect(0, 119039, '\p{^Blk=byzantinemusic}', "");
Expect(0, 119039, '\P{Blk=byzantinemusic}', "");
Expect(1, 119039, '\P{^Blk=byzantinemusic}', "");
Expect(0, 119040, '\p{Blk=byzantinemusic}', "");
Expect(1, 119040, '\p{^Blk=byzantinemusic}', "");
Expect(1, 119040, '\P{Blk=byzantinemusic}', "");
Expect(0, 119040, '\P{^Blk=byzantinemusic}', "");
Expect(1, 119039, '\p{Blk=-	BYZANTINE_Music}', "");
Expect(0, 119039, '\p{^Blk=-	BYZANTINE_Music}', "");
Expect(0, 119039, '\P{Blk=-	BYZANTINE_Music}', "");
Expect(1, 119039, '\P{^Blk=-	BYZANTINE_Music}', "");
Expect(0, 119040, '\p{Blk=-	BYZANTINE_Music}', "");
Expect(1, 119040, '\p{^Blk=-	BYZANTINE_Music}', "");
Expect(1, 119040, '\P{Blk=-	BYZANTINE_Music}', "");
Expect(0, 119040, '\P{^Blk=-	BYZANTINE_Music}', "");
Error('\p{Is_Block=-:=byzantine_MUSICAL_SYMBOLS}');
Error('\P{Is_Block=-:=byzantine_MUSICAL_SYMBOLS}');
Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119040, '\p{Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119040, '\p{^Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119040, '\P{Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119040, '\P{^Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Is_Block=	 BYZANTINE_musical_symbols}', "");
Expect(0, 119039, '\p{^Is_Block=	 BYZANTINE_musical_symbols}', "");
Expect(0, 119039, '\P{Is_Block=	 BYZANTINE_musical_symbols}', "");
Expect(1, 119039, '\P{^Is_Block=	 BYZANTINE_musical_symbols}', "");
Expect(0, 119040, '\p{Is_Block=	 BYZANTINE_musical_symbols}', "");
Expect(1, 119040, '\p{^Is_Block=	 BYZANTINE_musical_symbols}', "");
Expect(1, 119040, '\P{Is_Block=	 BYZANTINE_musical_symbols}', "");
Expect(0, 119040, '\P{^Is_Block=	 BYZANTINE_musical_symbols}', "");
Error('\p{Is_Blk=:=-	BYZANTINE_MUSIC}');
Error('\P{Is_Blk=:=-	BYZANTINE_MUSIC}');
Expect(1, 119039, '\p{Is_Blk=byzantinemusic}', "");
Expect(0, 119039, '\p{^Is_Blk=byzantinemusic}', "");
Expect(0, 119039, '\P{Is_Blk=byzantinemusic}', "");
Expect(1, 119039, '\P{^Is_Blk=byzantinemusic}', "");
Expect(0, 119040, '\p{Is_Blk=byzantinemusic}', "");
Expect(1, 119040, '\p{^Is_Blk=byzantinemusic}', "");
Expect(1, 119040, '\P{Is_Blk=byzantinemusic}', "");
Expect(0, 119040, '\P{^Is_Blk=byzantinemusic}', "");
Expect(1, 119039, '\p{Is_Blk=_Byzantine_MUSIC}', "");
Expect(0, 119039, '\p{^Is_Blk=_Byzantine_MUSIC}', "");
Expect(0, 119039, '\P{Is_Blk=_Byzantine_MUSIC}', "");
Expect(1, 119039, '\P{^Is_Blk=_Byzantine_MUSIC}', "");
Expect(0, 119040, '\p{Is_Blk=_Byzantine_MUSIC}', "");
Expect(1, 119040, '\p{^Is_Blk=_Byzantine_MUSIC}', "");
Expect(1, 119040, '\P{Is_Blk=_Byzantine_MUSIC}', "");
Expect(0, 119040, '\P{^Is_Blk=_Byzantine_MUSIC}', "");
Error('\p{Block=cjk_UNIFIED_Ideographs:=}');
Error('\P{Block=cjk_UNIFIED_Ideographs:=}');
Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
Expect(0, 40960, '\p{Block=cjkunifiedideographs}', "");
Expect(1, 40960, '\p{^Block=cjkunifiedideographs}', "");
Expect(1, 40960, '\P{Block=cjkunifiedideographs}', "");
Expect(0, 40960, '\P{^Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Block=  cjk_UNIFIED_IDEOGRAPHS}', "");
Expect(0, 40959, '\p{^Block=  cjk_UNIFIED_IDEOGRAPHS}', "");
Expect(0, 40959, '\P{Block=  cjk_UNIFIED_IDEOGRAPHS}', "");
Expect(1, 40959, '\P{^Block=  cjk_UNIFIED_IDEOGRAPHS}', "");
Expect(0, 40960, '\p{Block=  cjk_UNIFIED_IDEOGRAPHS}', "");
Expect(1, 40960, '\p{^Block=  cjk_UNIFIED_IDEOGRAPHS}', "");
Expect(1, 40960, '\P{Block=  cjk_UNIFIED_IDEOGRAPHS}', "");
Expect(0, 40960, '\P{^Block=  cjk_UNIFIED_IDEOGRAPHS}', "");
Error('\p{Blk=/a/cjk}');
Error('\P{Blk=/a/cjk}');
Expect(1, 40959, '\p{Blk=cjk}', "");
Expect(0, 40959, '\p{^Blk=cjk}', "");
Expect(0, 40959, '\P{Blk=cjk}', "");
Expect(1, 40959, '\P{^Blk=cjk}', "");
Expect(0, 40960, '\p{Blk=cjk}', "");
Expect(1, 40960, '\p{^Blk=cjk}', "");
Expect(1, 40960, '\P{Blk=cjk}', "");
Expect(0, 40960, '\P{^Blk=cjk}', "");
Expect(1, 40959, '\p{Blk:   	CJK}', "");
Expect(0, 40959, '\p{^Blk:   	CJK}', "");
Expect(0, 40959, '\P{Blk:   	CJK}', "");
Expect(1, 40959, '\P{^Blk:   	CJK}', "");
Expect(0, 40960, '\p{Blk:   	CJK}', "");
Expect(1, 40960, '\p{^Blk:   	CJK}', "");
Expect(1, 40960, '\P{Blk:   	CJK}', "");
Expect(0, 40960, '\P{^Blk:   	CJK}', "");
Error('\p{Is_Block=	CJK_Unified_Ideographs/a/}');
Error('\P{Is_Block=	CJK_Unified_Ideographs/a/}');
Expect(1, 40959, '\p{Is_Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Is_Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Is_Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Is_Block=cjkunifiedideographs}', "");
Expect(0, 40960, '\p{Is_Block=cjkunifiedideographs}', "");
Expect(1, 40960, '\p{^Is_Block=cjkunifiedideographs}', "");
Expect(1, 40960, '\P{Is_Block=cjkunifiedideographs}', "");
Expect(0, 40960, '\P{^Is_Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Is_Block= _CJK_UNIFIED_IDEOGRAPHS}', "");
Expect(0, 40959, '\p{^Is_Block= _CJK_UNIFIED_IDEOGRAPHS}', "");
Expect(0, 40959, '\P{Is_Block= _CJK_UNIFIED_IDEOGRAPHS}', "");
Expect(1, 40959, '\P{^Is_Block= _CJK_UNIFIED_IDEOGRAPHS}', "");
Expect(0, 40960, '\p{Is_Block= _CJK_UNIFIED_IDEOGRAPHS}', "");
Expect(1, 40960, '\p{^Is_Block= _CJK_UNIFIED_IDEOGRAPHS}', "");
Expect(1, 40960, '\P{Is_Block= _CJK_UNIFIED_IDEOGRAPHS}', "");
Expect(0, 40960, '\P{^Is_Block= _CJK_UNIFIED_IDEOGRAPHS}', "");
Error('\p{Is_Blk: /a/CJK}');
Error('\P{Is_Blk: /a/CJK}');
Expect(1, 40959, '\p{Is_Blk=cjk}', "");
Expect(0, 40959, '\p{^Is_Blk=cjk}', "");
Expect(0, 40959, '\P{Is_Blk=cjk}', "");
Expect(1, 40959, '\P{^Is_Blk=cjk}', "");
Expect(0, 40960, '\p{Is_Blk=cjk}', "");
Expect(1, 40960, '\p{^Is_Blk=cjk}', "");
Expect(1, 40960, '\P{Is_Blk=cjk}', "");
Expect(0, 40960, '\P{^Is_Blk=cjk}', "");
Expect(1, 40959, '\p{Is_Blk:	 cjk}', "");
Expect(0, 40959, '\p{^Is_Blk:	 cjk}', "");
Expect(0, 40959, '\P{Is_Blk:	 cjk}', "");
Expect(1, 40959, '\P{^Is_Blk:	 cjk}', "");
Expect(0, 40960, '\p{Is_Blk:	 cjk}', "");
Expect(1, 40960, '\p{^Is_Blk:	 cjk}', "");
Expect(1, 40960, '\P{Is_Blk:	 cjk}', "");
Expect(0, 40960, '\P{^Is_Blk:	 cjk}', "");
Error('\p{Block:   /a/__CJK_Compatibility}');
Error('\P{Block:   /a/__CJK_Compatibility}');
Expect(1, 13311, '\p{Block=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Block=cjkcompatibility}', "");
Expect(0, 13311, '\P{Block=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Block=cjkcompatibility}', "");
Expect(0, 13312, '\p{Block=cjkcompatibility}', "");
Expect(1, 13312, '\p{^Block=cjkcompatibility}', "");
Expect(1, 13312, '\P{Block=cjkcompatibility}', "");
Expect(0, 13312, '\P{^Block=cjkcompatibility}', "");
Expect(1, 13311, '\p{Block= 	CJK_compatibility}', "");
Expect(0, 13311, '\p{^Block= 	CJK_compatibility}', "");
Expect(0, 13311, '\P{Block= 	CJK_compatibility}', "");
Expect(1, 13311, '\P{^Block= 	CJK_compatibility}', "");
Expect(0, 13312, '\p{Block= 	CJK_compatibility}', "");
Expect(1, 13312, '\p{^Block= 	CJK_compatibility}', "");
Expect(1, 13312, '\P{Block= 	CJK_compatibility}', "");
Expect(0, 13312, '\P{^Block= 	CJK_compatibility}', "");
Error('\p{Blk: :=CJK_COMPAT}');
Error('\P{Blk: :=CJK_COMPAT}');
Expect(1, 13311, '\p{Blk=cjkcompat}', "");
Expect(0, 13311, '\p{^Blk=cjkcompat}', "");
Expect(0, 13311, '\P{Blk=cjkcompat}', "");
Expect(1, 13311, '\P{^Blk=cjkcompat}', "");
Expect(0, 13312, '\p{Blk=cjkcompat}', "");
Expect(1, 13312, '\p{^Blk=cjkcompat}', "");
Expect(1, 13312, '\P{Blk=cjkcompat}', "");
Expect(0, 13312, '\P{^Blk=cjkcompat}', "");
Expect(1, 13311, '\p{Blk= _CJK_COMPAT}', "");
Expect(0, 13311, '\p{^Blk= _CJK_COMPAT}', "");
Expect(0, 13311, '\P{Blk= _CJK_COMPAT}', "");
Expect(1, 13311, '\P{^Blk= _CJK_COMPAT}', "");
Expect(0, 13312, '\p{Blk= _CJK_COMPAT}', "");
Expect(1, 13312, '\p{^Blk= _CJK_COMPAT}', "");
Expect(1, 13312, '\P{Blk= _CJK_COMPAT}', "");
Expect(0, 13312, '\P{^Blk= _CJK_COMPAT}', "");
Error('\p{Is_Block=:=_ CJK_COMPATIBILITY}');
Error('\P{Is_Block=:=_ CJK_COMPATIBILITY}');
Expect(1, 13311, '\p{Is_Block=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Is_Block=cjkcompatibility}', "");
Expect(0, 13311, '\P{Is_Block=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Is_Block=cjkcompatibility}', "");
Expect(0, 13312, '\p{Is_Block=cjkcompatibility}', "");
Expect(1, 13312, '\p{^Is_Block=cjkcompatibility}', "");
Expect(1, 13312, '\P{Is_Block=cjkcompatibility}', "");
Expect(0, 13312, '\P{^Is_Block=cjkcompatibility}', "");
Expect(1, 13311, '\p{Is_Block=-	cjk_Compatibility}', "");
Expect(0, 13311, '\p{^Is_Block=-	cjk_Compatibility}', "");
Expect(0, 13311, '\P{Is_Block=-	cjk_Compatibility}', "");
Expect(1, 13311, '\P{^Is_Block=-	cjk_Compatibility}', "");
Expect(0, 13312, '\p{Is_Block=-	cjk_Compatibility}', "");
Expect(1, 13312, '\p{^Is_Block=-	cjk_Compatibility}', "");
Expect(1, 13312, '\P{Is_Block=-	cjk_Compatibility}', "");
Expect(0, 13312, '\P{^Is_Block=-	cjk_Compatibility}', "");
Error('\p{Is_Blk: 		cjk_compat/a/}');
Error('\P{Is_Blk: 		cjk_compat/a/}');
Expect(1, 13311, '\p{Is_Blk=cjkcompat}', "");
Expect(0, 13311, '\p{^Is_Blk=cjkcompat}', "");
Expect(0, 13311, '\P{Is_Blk=cjkcompat}', "");
Expect(1, 13311, '\P{^Is_Blk=cjkcompat}', "");
Expect(0, 13312, '\p{Is_Blk=cjkcompat}', "");
Expect(1, 13312, '\p{^Is_Blk=cjkcompat}', "");
Expect(1, 13312, '\P{Is_Blk=cjkcompat}', "");
Expect(0, 13312, '\P{^Is_Blk=cjkcompat}', "");
Expect(1, 13311, '\p{Is_Blk= 	CJK_compat}', "");
Expect(0, 13311, '\p{^Is_Blk= 	CJK_compat}', "");
Expect(0, 13311, '\P{Is_Blk= 	CJK_compat}', "");
Expect(1, 13311, '\P{^Is_Blk= 	CJK_compat}', "");
Expect(0, 13312, '\p{Is_Blk= 	CJK_compat}', "");
Expect(1, 13312, '\p{^Is_Blk= 	CJK_compat}', "");
Expect(1, 13312, '\P{Is_Blk= 	CJK_compat}', "");
Expect(0, 13312, '\P{^Is_Blk= 	CJK_compat}', "");
Error('\p{Block=_ CJK_compatibility_FORMS:=}');
Error('\P{Block=_ CJK_compatibility_FORMS:=}');
Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
Expect(0, 65104, '\p{Block=cjkcompatibilityforms}', "");
Expect(1, 65104, '\p{^Block=cjkcompatibilityforms}', "");
Expect(1, 65104, '\P{Block=cjkcompatibilityforms}', "");
Expect(0, 65104, '\P{^Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Block=--CJK_compatibility_forms}', "");
Expect(0, 65103, '\p{^Block=--CJK_compatibility_forms}', "");
Expect(0, 65103, '\P{Block=--CJK_compatibility_forms}', "");
Expect(1, 65103, '\P{^Block=--CJK_compatibility_forms}', "");
Expect(0, 65104, '\p{Block=--CJK_compatibility_forms}', "");
Expect(1, 65104, '\p{^Block=--CJK_compatibility_forms}', "");
Expect(1, 65104, '\P{Block=--CJK_compatibility_forms}', "");
Expect(0, 65104, '\P{^Block=--CJK_compatibility_forms}', "");
Error('\p{Blk=-cjk_Compat_Forms:=}');
Error('\P{Blk=-cjk_Compat_Forms:=}');
Expect(1, 65103, '\p{Blk=cjkcompatforms}', "");
Expect(0, 65103, '\p{^Blk=cjkcompatforms}', "");
Expect(0, 65103, '\P{Blk=cjkcompatforms}', "");
Expect(1, 65103, '\P{^Blk=cjkcompatforms}', "");
Expect(0, 65104, '\p{Blk=cjkcompatforms}', "");
Expect(1, 65104, '\p{^Blk=cjkcompatforms}', "");
Expect(1, 65104, '\P{Blk=cjkcompatforms}', "");
Expect(0, 65104, '\P{^Blk=cjkcompatforms}', "");
Expect(1, 65103, '\p{Blk=-	cjk_Compat_Forms}', "");
Expect(0, 65103, '\p{^Blk=-	cjk_Compat_Forms}', "");
Expect(0, 65103, '\P{Blk=-	cjk_Compat_Forms}', "");
Expect(1, 65103, '\P{^Blk=-	cjk_Compat_Forms}', "");
Expect(0, 65104, '\p{Blk=-	cjk_Compat_Forms}', "");
Expect(1, 65104, '\p{^Blk=-	cjk_Compat_Forms}', "");
Expect(1, 65104, '\P{Blk=-	cjk_Compat_Forms}', "");
Expect(0, 65104, '\P{^Blk=-	cjk_Compat_Forms}', "");
Error('\p{Is_Block=/a/ cjk_COMPATIBILITY_forms}');
Error('\P{Is_Block=/a/ cjk_COMPATIBILITY_forms}');
Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65104, '\p{Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65104, '\p{^Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65104, '\P{Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65104, '\P{^Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Is_Block=		cjk_Compatibility_forms}', "");
Expect(0, 65103, '\p{^Is_Block=		cjk_Compatibility_forms}', "");
Expect(0, 65103, '\P{Is_Block=		cjk_Compatibility_forms}', "");
Expect(1, 65103, '\P{^Is_Block=		cjk_Compatibility_forms}', "");
Expect(0, 65104, '\p{Is_Block=		cjk_Compatibility_forms}', "");
Expect(1, 65104, '\p{^Is_Block=		cjk_Compatibility_forms}', "");
Expect(1, 65104, '\P{Is_Block=		cjk_Compatibility_forms}', "");
Expect(0, 65104, '\P{^Is_Block=		cjk_Compatibility_forms}', "");
Error('\p{Is_Blk=:=CJK_compat_FORMS}');
Error('\P{Is_Blk=:=CJK_compat_FORMS}');
Expect(1, 65103, '\p{Is_Blk=cjkcompatforms}', "");
Expect(0, 65103, '\p{^Is_Blk=cjkcompatforms}', "");
Expect(0, 65103, '\P{Is_Blk=cjkcompatforms}', "");
Expect(1, 65103, '\P{^Is_Blk=cjkcompatforms}', "");
Expect(0, 65104, '\p{Is_Blk=cjkcompatforms}', "");
Expect(1, 65104, '\p{^Is_Blk=cjkcompatforms}', "");
Expect(1, 65104, '\P{Is_Blk=cjkcompatforms}', "");
Expect(0, 65104, '\P{^Is_Blk=cjkcompatforms}', "");
Expect(1, 65103, '\p{Is_Blk=-_CJK_compat_Forms}', "");
Expect(0, 65103, '\p{^Is_Blk=-_CJK_compat_Forms}', "");
Expect(0, 65103, '\P{Is_Blk=-_CJK_compat_Forms}', "");
Expect(1, 65103, '\P{^Is_Blk=-_CJK_compat_Forms}', "");
Expect(0, 65104, '\p{Is_Blk=-_CJK_compat_Forms}', "");
Expect(1, 65104, '\p{^Is_Blk=-_CJK_compat_Forms}', "");
Expect(1, 65104, '\P{Is_Blk=-_CJK_compat_Forms}', "");
Expect(0, 65104, '\P{^Is_Blk=-_CJK_compat_Forms}', "");
Error('\p{Block=:= cjk_compatibility_IDEOGRAPHS}');
Error('\P{Block=:= cjk_compatibility_IDEOGRAPHS}');
Expect(1, 64255, '\p{Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Block=cjkcompatibilityideographs}', "");
Expect(0, 64256, '\p{Block=cjkcompatibilityideographs}', "");
Expect(1, 64256, '\p{^Block=cjkcompatibilityideographs}', "");
Expect(1, 64256, '\P{Block=cjkcompatibilityideographs}', "");
Expect(0, 64256, '\P{^Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Block= 	cjk_Compatibility_ideographs}', "");
Expect(0, 64255, '\p{^Block= 	cjk_Compatibility_ideographs}', "");
Expect(0, 64255, '\P{Block= 	cjk_Compatibility_ideographs}', "");
Expect(1, 64255, '\P{^Block= 	cjk_Compatibility_ideographs}', "");
Expect(0, 64256, '\p{Block= 	cjk_Compatibility_ideographs}', "");
Expect(1, 64256, '\p{^Block= 	cjk_Compatibility_ideographs}', "");
Expect(1, 64256, '\P{Block= 	cjk_Compatibility_ideographs}', "");
Expect(0, 64256, '\P{^Block= 	cjk_Compatibility_ideographs}', "");
Error('\p{Blk=CJK_compat_ideographs/a/}');
Error('\P{Blk=CJK_compat_ideographs/a/}');
Expect(1, 64255, '\p{Blk=cjkcompatideographs}', "");
Expect(0, 64255, '\p{^Blk=cjkcompatideographs}', "");
Expect(0, 64255, '\P{Blk=cjkcompatideographs}', "");
Expect(1, 64255, '\P{^Blk=cjkcompatideographs}', "");
Expect(0, 64256, '\p{Blk=cjkcompatideographs}', "");
Expect(1, 64256, '\p{^Blk=cjkcompatideographs}', "");
Expect(1, 64256, '\P{Blk=cjkcompatideographs}', "");
Expect(0, 64256, '\P{^Blk=cjkcompatideographs}', "");
Expect(1, 64255, '\p{Blk=	CJK_COMPAT_ideographs}', "");
Expect(0, 64255, '\p{^Blk=	CJK_COMPAT_ideographs}', "");
Expect(0, 64255, '\P{Blk=	CJK_COMPAT_ideographs}', "");
Expect(1, 64255, '\P{^Blk=	CJK_COMPAT_ideographs}', "");
Expect(0, 64256, '\p{Blk=	CJK_COMPAT_ideographs}', "");
Expect(1, 64256, '\p{^Blk=	CJK_COMPAT_ideographs}', "");
Expect(1, 64256, '\P{Blk=	CJK_COMPAT_ideographs}', "");
Expect(0, 64256, '\P{^Blk=	CJK_COMPAT_ideographs}', "");
Error('\p{Is_Block=-	cjk_COMPATIBILITY_Ideographs/a/}');
Error('\P{Is_Block=-	cjk_COMPATIBILITY_Ideographs/a/}');
Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64256, '\p{Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64256, '\p{^Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64256, '\P{Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64256, '\P{^Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Is_Block=-_cjk_Compatibility_Ideographs}', "");
Expect(0, 64255, '\p{^Is_Block=-_cjk_Compatibility_Ideographs}', "");
Expect(0, 64255, '\P{Is_Block=-_cjk_Compatibility_Ideographs}', "");
Expect(1, 64255, '\P{^Is_Block=-_cjk_Compatibility_Ideographs}', "");
Expect(0, 64256, '\p{Is_Block=-_cjk_Compatibility_Ideographs}', "");
Expect(1, 64256, '\p{^Is_Block=-_cjk_Compatibility_Ideographs}', "");
Expect(1, 64256, '\P{Is_Block=-_cjk_Compatibility_Ideographs}', "");
Expect(0, 64256, '\P{^Is_Block=-_cjk_Compatibility_Ideographs}', "");
Error('\p{Is_Blk=:=CJK_compat_Ideographs}');
Error('\P{Is_Blk=:=CJK_compat_Ideographs}');
Expect(1, 64255, '\p{Is_Blk:   cjkcompatideographs}', "");
Expect(0, 64255, '\p{^Is_Blk:   cjkcompatideographs}', "");
Expect(0, 64255, '\P{Is_Blk:   cjkcompatideographs}', "");
Expect(1, 64255, '\P{^Is_Blk:   cjkcompatideographs}', "");
Expect(0, 64256, '\p{Is_Blk:   cjkcompatideographs}', "");
Expect(1, 64256, '\p{^Is_Blk:   cjkcompatideographs}', "");
Expect(1, 64256, '\P{Is_Blk:   cjkcompatideographs}', "");
Expect(0, 64256, '\P{^Is_Blk:   cjkcompatideographs}', "");
Expect(1, 64255, '\p{Is_Blk= -CJK_COMPAT_IDEOGRAPHS}', "");
Expect(0, 64255, '\p{^Is_Blk= -CJK_COMPAT_IDEOGRAPHS}', "");
Expect(0, 64255, '\P{Is_Blk= -CJK_COMPAT_IDEOGRAPHS}', "");
Expect(1, 64255, '\P{^Is_Blk= -CJK_COMPAT_IDEOGRAPHS}', "");
Expect(0, 64256, '\p{Is_Blk= -CJK_COMPAT_IDEOGRAPHS}', "");
Expect(1, 64256, '\p{^Is_Blk= -CJK_COMPAT_IDEOGRAPHS}', "");
Expect(1, 64256, '\P{Is_Blk= -CJK_COMPAT_IDEOGRAPHS}', "");
Expect(0, 64256, '\P{^Is_Blk= -CJK_COMPAT_IDEOGRAPHS}', "");
Error('\p{Block= _CJK_Compatibility_ideographs_Supplement/a/}');
Error('\P{Block= _CJK_Compatibility_ideographs_Supplement/a/}');
Expect(1, 195103, '\p{Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195104, '\p{Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195104, '\p{^Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195104, '\P{Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195104, '\P{^Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Block=	 CJK_COMPATIBILITY_IDEOGRAPHS_supplement}', "");
Expect(0, 195103, '\p{^Block=	 CJK_COMPATIBILITY_IDEOGRAPHS_supplement}', "");
Expect(0, 195103, '\P{Block=	 CJK_COMPATIBILITY_IDEOGRAPHS_supplement}', "");
Expect(1, 195103, '\P{^Block=	 CJK_COMPATIBILITY_IDEOGRAPHS_supplement}', "");
Expect(0, 195104, '\p{Block=	 CJK_COMPATIBILITY_IDEOGRAPHS_supplement}', "");
Expect(1, 195104, '\p{^Block=	 CJK_COMPATIBILITY_IDEOGRAPHS_supplement}', "");
Expect(1, 195104, '\P{Block=	 CJK_COMPATIBILITY_IDEOGRAPHS_supplement}', "");
Expect(0, 195104, '\P{^Block=	 CJK_COMPATIBILITY_IDEOGRAPHS_supplement}', "");
Error('\p{Blk=/a/ 	CJK_Compat_Ideographs_sup}');
Error('\P{Blk=/a/ 	CJK_Compat_Ideographs_sup}');
Expect(1, 195103, '\p{Blk: cjkcompatideographssup}', "");
Expect(0, 195103, '\p{^Blk: cjkcompatideographssup}', "");
Expect(0, 195103, '\P{Blk: cjkcompatideographssup}', "");
Expect(1, 195103, '\P{^Blk: cjkcompatideographssup}', "");
Expect(0, 195104, '\p{Blk: cjkcompatideographssup}', "");
Expect(1, 195104, '\p{^Blk: cjkcompatideographssup}', "");
Expect(1, 195104, '\P{Blk: cjkcompatideographssup}', "");
Expect(0, 195104, '\P{^Blk: cjkcompatideographssup}', "");
Expect(1, 195103, '\p{Blk=_CJK_COMPAT_Ideographs_SUP}', "");
Expect(0, 195103, '\p{^Blk=_CJK_COMPAT_Ideographs_SUP}', "");
Expect(0, 195103, '\P{Blk=_CJK_COMPAT_Ideographs_SUP}', "");
Expect(1, 195103, '\P{^Blk=_CJK_COMPAT_Ideographs_SUP}', "");
Expect(0, 195104, '\p{Blk=_CJK_COMPAT_Ideographs_SUP}', "");
Expect(1, 195104, '\p{^Blk=_CJK_COMPAT_Ideographs_SUP}', "");
Expect(1, 195104, '\P{Blk=_CJK_COMPAT_Ideographs_SUP}', "");
Expect(0, 195104, '\P{^Blk=_CJK_COMPAT_Ideographs_SUP}', "");
Error('\p{Is_Block=/a/_ CJK_Compatibility_Ideographs_SUPPLEMENT}');
Error('\P{Is_Block=/a/_ CJK_Compatibility_Ideographs_SUPPLEMENT}');
Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195104, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195104, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195104, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195104, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Is_Block=  cjk_Compatibility_ideographs_supplement}', "");
Expect(0, 195103, '\p{^Is_Block=  cjk_Compatibility_ideographs_supplement}', "");
Expect(0, 195103, '\P{Is_Block=  cjk_Compatibility_ideographs_supplement}', "");
Expect(1, 195103, '\P{^Is_Block=  cjk_Compatibility_ideographs_supplement}', "");
Expect(0, 195104, '\p{Is_Block=  cjk_Compatibility_ideographs_supplement}', "");
Expect(1, 195104, '\p{^Is_Block=  cjk_Compatibility_ideographs_supplement}', "");
Expect(1, 195104, '\P{Is_Block=  cjk_Compatibility_ideographs_supplement}', "");
Expect(0, 195104, '\P{^Is_Block=  cjk_Compatibility_ideographs_supplement}', "");
Error('\p{Is_Blk=:=--cjk_Compat_IDEOGRAPHS_sup}');
Error('\P{Is_Blk=:=--cjk_Compat_IDEOGRAPHS_sup}');
Expect(1, 195103, '\p{Is_Blk=cjkcompatideographssup}', "");
Expect(0, 195103, '\p{^Is_Blk=cjkcompatideographssup}', "");
Expect(0, 195103, '\P{Is_Blk=cjkcompatideographssup}', "");
Expect(1, 195103, '\P{^Is_Blk=cjkcompatideographssup}', "");
Expect(0, 195104, '\p{Is_Blk=cjkcompatideographssup}', "");
Expect(1, 195104, '\p{^Is_Blk=cjkcompatideographssup}', "");
Expect(1, 195104, '\P{Is_Blk=cjkcompatideographssup}', "");
Expect(0, 195104, '\P{^Is_Blk=cjkcompatideographssup}', "");
Expect(1, 195103, '\p{Is_Blk=__CJK_COMPAT_IDEOGRAPHS_Sup}', "");
Expect(0, 195103, '\p{^Is_Blk=__CJK_COMPAT_IDEOGRAPHS_Sup}', "");
Expect(0, 195103, '\P{Is_Blk=__CJK_COMPAT_IDEOGRAPHS_Sup}', "");
Expect(1, 195103, '\P{^Is_Blk=__CJK_COMPAT_IDEOGRAPHS_Sup}', "");
Expect(0, 195104, '\p{Is_Blk=__CJK_COMPAT_IDEOGRAPHS_Sup}', "");
Expect(1, 195104, '\p{^Is_Blk=__CJK_COMPAT_IDEOGRAPHS_Sup}', "");
Expect(1, 195104, '\P{Is_Blk=__CJK_COMPAT_IDEOGRAPHS_Sup}', "");
Expect(0, 195104, '\P{^Is_Blk=__CJK_COMPAT_IDEOGRAPHS_Sup}', "");
Error('\p{Block=/a/ 	cjk_unified_ideographs_Extension_A}');
Error('\P{Block=/a/ 	cjk_unified_ideographs_Extension_A}');
Expect(1, 19903, '\p{Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19904, '\p{Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19904, '\p{^Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19904, '\P{Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19904, '\P{^Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Block=--cjk_Unified_Ideographs_Extension_A}', "");
Expect(0, 19903, '\p{^Block=--cjk_Unified_Ideographs_Extension_A}', "");
Expect(0, 19903, '\P{Block=--cjk_Unified_Ideographs_Extension_A}', "");
Expect(1, 19903, '\P{^Block=--cjk_Unified_Ideographs_Extension_A}', "");
Expect(0, 19904, '\p{Block=--cjk_Unified_Ideographs_Extension_A}', "");
Expect(1, 19904, '\p{^Block=--cjk_Unified_Ideographs_Extension_A}', "");
Expect(1, 19904, '\P{Block=--cjk_Unified_Ideographs_Extension_A}', "");
Expect(0, 19904, '\P{^Block=--cjk_Unified_Ideographs_Extension_A}', "");
Error('\p{Blk: /a/_CJK_Ext_a}');
Error('\P{Blk: /a/_CJK_Ext_a}');
Expect(1, 19903, '\p{Blk=cjkexta}', "");
Expect(0, 19903, '\p{^Blk=cjkexta}', "");
Expect(0, 19903, '\P{Blk=cjkexta}', "");
Expect(1, 19903, '\P{^Blk=cjkexta}', "");
Expect(0, 19904, '\p{Blk=cjkexta}', "");
Expect(1, 19904, '\p{^Blk=cjkexta}', "");
Expect(1, 19904, '\P{Blk=cjkexta}', "");
Expect(0, 19904, '\P{^Blk=cjkexta}', "");
Expect(1, 19903, '\p{Blk= CJK_EXT_A}', "");
Expect(0, 19903, '\p{^Blk= CJK_EXT_A}', "");
Expect(0, 19903, '\P{Blk= CJK_EXT_A}', "");
Expect(1, 19903, '\P{^Blk= CJK_EXT_A}', "");
Expect(0, 19904, '\p{Blk= CJK_EXT_A}', "");
Expect(1, 19904, '\p{^Blk= CJK_EXT_A}', "");
Expect(1, 19904, '\P{Blk= CJK_EXT_A}', "");
Expect(0, 19904, '\P{^Blk= CJK_EXT_A}', "");
Error('\p{Is_Block=/a/__cjk_Unified_Ideographs_Extension_A}');
Error('\P{Is_Block=/a/__cjk_Unified_Ideographs_Extension_A}');
Expect(1, 19903, '\p{Is_Block:   cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Is_Block:   cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Is_Block:   cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Is_Block:   cjkunifiedideographsextensiona}', "");
Expect(0, 19904, '\p{Is_Block:   cjkunifiedideographsextensiona}', "");
Expect(1, 19904, '\p{^Is_Block:   cjkunifiedideographsextensiona}', "");
Expect(1, 19904, '\P{Is_Block:   cjkunifiedideographsextensiona}', "");
Expect(0, 19904, '\P{^Is_Block:   cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Is_Block=	-cjk_Unified_ideographs_Extension_A}', "");
Expect(0, 19903, '\p{^Is_Block=	-cjk_Unified_ideographs_Extension_A}', "");
Expect(0, 19903, '\P{Is_Block=	-cjk_Unified_ideographs_Extension_A}', "");
Expect(1, 19903, '\P{^Is_Block=	-cjk_Unified_ideographs_Extension_A}', "");
Expect(0, 19904, '\p{Is_Block=	-cjk_Unified_ideographs_Extension_A}', "");
Expect(1, 19904, '\p{^Is_Block=	-cjk_Unified_ideographs_Extension_A}', "");
Expect(1, 19904, '\P{Is_Block=	-cjk_Unified_ideographs_Extension_A}', "");
Expect(0, 19904, '\P{^Is_Block=	-cjk_Unified_ideographs_Extension_A}', "");
Error('\p{Is_Blk= cjk_Ext_A/a/}');
Error('\P{Is_Blk= cjk_Ext_A/a/}');
Expect(1, 19903, '\p{Is_Blk=cjkexta}', "");
Expect(0, 19903, '\p{^Is_Blk=cjkexta}', "");
Expect(0, 19903, '\P{Is_Blk=cjkexta}', "");
Expect(1, 19903, '\P{^Is_Blk=cjkexta}', "");
Expect(0, 19904, '\p{Is_Blk=cjkexta}', "");
Expect(1, 19904, '\p{^Is_Blk=cjkexta}', "");
Expect(1, 19904, '\P{Is_Blk=cjkexta}', "");
Expect(0, 19904, '\P{^Is_Blk=cjkexta}', "");
Expect(1, 19903, '\p{Is_Blk= cjk_Ext_A}', "");
Expect(0, 19903, '\p{^Is_Blk= cjk_Ext_A}', "");
Expect(0, 19903, '\P{Is_Blk= cjk_Ext_A}', "");
Expect(1, 19903, '\P{^Is_Blk= cjk_Ext_A}', "");
Expect(0, 19904, '\p{Is_Blk= cjk_Ext_A}', "");
Expect(1, 19904, '\p{^Is_Blk= cjk_Ext_A}', "");
Expect(1, 19904, '\P{Is_Blk= cjk_Ext_A}', "");
Expect(0, 19904, '\P{^Is_Blk= cjk_Ext_A}', "");
Error('\p{Block=  CJK_Unified_Ideographs_EXTENSION_b:=}');
Error('\P{Block=  CJK_Unified_Ideographs_EXTENSION_b:=}');
Expect(1, 173791, '\p{Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173792, '\p{Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173792, '\p{^Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173792, '\P{Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173792, '\P{^Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Block=_CJK_unified_Ideographs_extension_b}', "");
Expect(0, 173791, '\p{^Block=_CJK_unified_Ideographs_extension_b}', "");
Expect(0, 173791, '\P{Block=_CJK_unified_Ideographs_extension_b}', "");
Expect(1, 173791, '\P{^Block=_CJK_unified_Ideographs_extension_b}', "");
Expect(0, 173792, '\p{Block=_CJK_unified_Ideographs_extension_b}', "");
Expect(1, 173792, '\p{^Block=_CJK_unified_Ideographs_extension_b}', "");
Expect(1, 173792, '\P{Block=_CJK_unified_Ideographs_extension_b}', "");
Expect(0, 173792, '\P{^Block=_CJK_unified_Ideographs_extension_b}', "");
Error('\p{Blk=-	CJK_Ext_B/a/}');
Error('\P{Blk=-	CJK_Ext_B/a/}');
Expect(1, 173791, '\p{Blk=cjkextb}', "");
Expect(0, 173791, '\p{^Blk=cjkextb}', "");
Expect(0, 173791, '\P{Blk=cjkextb}', "");
Expect(1, 173791, '\P{^Blk=cjkextb}', "");
Expect(0, 173792, '\p{Blk=cjkextb}', "");
Expect(1, 173792, '\p{^Blk=cjkextb}', "");
Expect(1, 173792, '\P{Blk=cjkextb}', "");
Expect(0, 173792, '\P{^Blk=cjkextb}', "");
Expect(1, 173791, '\p{Blk=-CJK_Ext_b}', "");
Expect(0, 173791, '\p{^Blk=-CJK_Ext_b}', "");
Expect(0, 173791, '\P{Blk=-CJK_Ext_b}', "");
Expect(1, 173791, '\P{^Blk=-CJK_Ext_b}', "");
Expect(0, 173792, '\p{Blk=-CJK_Ext_b}', "");
Expect(1, 173792, '\p{^Blk=-CJK_Ext_b}', "");
Expect(1, 173792, '\P{Blk=-CJK_Ext_b}', "");
Expect(0, 173792, '\P{^Blk=-CJK_Ext_b}', "");
Error('\p{Is_Block: -:=CJK_Unified_IDEOGRAPHS_Extension_b}');
Error('\P{Is_Block: -:=CJK_Unified_IDEOGRAPHS_Extension_b}');
Expect(1, 173791, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173792, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173792, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173792, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173792, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Is_Block=CJK_UNIFIED_Ideographs_extension_B}', "");
Expect(0, 173791, '\p{^Is_Block=CJK_UNIFIED_Ideographs_extension_B}', "");
Expect(0, 173791, '\P{Is_Block=CJK_UNIFIED_Ideographs_extension_B}', "");
Expect(1, 173791, '\P{^Is_Block=CJK_UNIFIED_Ideographs_extension_B}', "");
Expect(0, 173792, '\p{Is_Block=CJK_UNIFIED_Ideographs_extension_B}', "");
Expect(1, 173792, '\p{^Is_Block=CJK_UNIFIED_Ideographs_extension_B}', "");
Expect(1, 173792, '\P{Is_Block=CJK_UNIFIED_Ideographs_extension_B}', "");
Expect(0, 173792, '\P{^Is_Block=CJK_UNIFIED_Ideographs_extension_B}', "");
Error('\p{Is_Blk=	-CJK_ext_B:=}');
Error('\P{Is_Blk=	-CJK_ext_B:=}');
Expect(1, 173791, '\p{Is_Blk=cjkextb}', "");
Expect(0, 173791, '\p{^Is_Blk=cjkextb}', "");
Expect(0, 173791, '\P{Is_Blk=cjkextb}', "");
Expect(1, 173791, '\P{^Is_Blk=cjkextb}', "");
Expect(0, 173792, '\p{Is_Blk=cjkextb}', "");
Expect(1, 173792, '\p{^Is_Blk=cjkextb}', "");
Expect(1, 173792, '\P{Is_Blk=cjkextb}', "");
Expect(0, 173792, '\P{^Is_Blk=cjkextb}', "");
Expect(1, 173791, '\p{Is_Blk=_-CJK_Ext_B}', "");
Expect(0, 173791, '\p{^Is_Blk=_-CJK_Ext_B}', "");
Expect(0, 173791, '\P{Is_Blk=_-CJK_Ext_B}', "");
Expect(1, 173791, '\P{^Is_Blk=_-CJK_Ext_B}', "");
Expect(0, 173792, '\p{Is_Blk=_-CJK_Ext_B}', "");
Expect(1, 173792, '\p{^Is_Blk=_-CJK_Ext_B}', "");
Expect(1, 173792, '\P{Is_Blk=_-CJK_Ext_B}', "");
Expect(0, 173792, '\P{^Is_Blk=_-CJK_Ext_B}', "");
Error('\p{Block:	:=CJK_Unified_Ideographs_EXTENSION_C}');
Error('\P{Block:	:=CJK_Unified_Ideographs_EXTENSION_C}');
Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177984, '\p{Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177984, '\p{^Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177984, '\P{Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177984, '\P{^Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Block=cjk_UNIFIED_Ideographs_EXTENSION_C}', "");
Expect(0, 177983, '\p{^Block=cjk_UNIFIED_Ideographs_EXTENSION_C}', "");
Expect(0, 177983, '\P{Block=cjk_UNIFIED_Ideographs_EXTENSION_C}', "");
Expect(1, 177983, '\P{^Block=cjk_UNIFIED_Ideographs_EXTENSION_C}', "");
Expect(0, 177984, '\p{Block=cjk_UNIFIED_Ideographs_EXTENSION_C}', "");
Expect(1, 177984, '\p{^Block=cjk_UNIFIED_Ideographs_EXTENSION_C}', "");
Expect(1, 177984, '\P{Block=cjk_UNIFIED_Ideographs_EXTENSION_C}', "");
Expect(0, 177984, '\P{^Block=cjk_UNIFIED_Ideographs_EXTENSION_C}', "");
Error('\p{Blk=	:=cjk_Ext_C}');
Error('\P{Blk=	:=cjk_Ext_C}');
Expect(1, 177983, '\p{Blk:cjkextc}', "");
Expect(0, 177983, '\p{^Blk:cjkextc}', "");
Expect(0, 177983, '\P{Blk:cjkextc}', "");
Expect(1, 177983, '\P{^Blk:cjkextc}', "");
Expect(0, 177984, '\p{Blk:cjkextc}', "");
Expect(1, 177984, '\p{^Blk:cjkextc}', "");
Expect(1, 177984, '\P{Blk:cjkextc}', "");
Expect(0, 177984, '\P{^Blk:cjkextc}', "");
Expect(1, 177983, '\p{Blk=		cjk_EXT_C}', "");
Expect(0, 177983, '\p{^Blk=		cjk_EXT_C}', "");
Expect(0, 177983, '\P{Blk=		cjk_EXT_C}', "");
Expect(1, 177983, '\P{^Blk=		cjk_EXT_C}', "");
Expect(0, 177984, '\p{Blk=		cjk_EXT_C}', "");
Expect(1, 177984, '\p{^Blk=		cjk_EXT_C}', "");
Expect(1, 177984, '\P{Blk=		cjk_EXT_C}', "");
Expect(0, 177984, '\P{^Blk=		cjk_EXT_C}', "");
Error('\p{Is_Block=-/a/CJK_unified_Ideographs_extension_C}');
Error('\P{Is_Block=-/a/CJK_unified_Ideographs_extension_C}');
Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177984, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177984, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177984, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177984, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Is_Block=_	CJK_unified_Ideographs_Extension_C}', "");
Expect(0, 177983, '\p{^Is_Block=_	CJK_unified_Ideographs_Extension_C}', "");
Expect(0, 177983, '\P{Is_Block=_	CJK_unified_Ideographs_Extension_C}', "");
Expect(1, 177983, '\P{^Is_Block=_	CJK_unified_Ideographs_Extension_C}', "");
Expect(0, 177984, '\p{Is_Block=_	CJK_unified_Ideographs_Extension_C}', "");
Expect(1, 177984, '\p{^Is_Block=_	CJK_unified_Ideographs_Extension_C}', "");
Expect(1, 177984, '\P{Is_Block=_	CJK_unified_Ideographs_Extension_C}', "");
Expect(0, 177984, '\P{^Is_Block=_	CJK_unified_Ideographs_Extension_C}', "");
Error('\p{Is_Blk=:=	CJK_ext_C}');
Error('\P{Is_Blk=:=	CJK_ext_C}');
Expect(1, 177983, '\p{Is_Blk=cjkextc}', "");
Expect(0, 177983, '\p{^Is_Blk=cjkextc}', "");
Expect(0, 177983, '\P{Is_Blk=cjkextc}', "");
Expect(1, 177983, '\P{^Is_Blk=cjkextc}', "");
Expect(0, 177984, '\p{Is_Blk=cjkextc}', "");
Expect(1, 177984, '\p{^Is_Blk=cjkextc}', "");
Expect(1, 177984, '\P{Is_Blk=cjkextc}', "");
Expect(0, 177984, '\P{^Is_Blk=cjkextc}', "");
Expect(1, 177983, '\p{Is_Blk= cjk_Ext_C}', "");
Expect(0, 177983, '\p{^Is_Blk= cjk_Ext_C}', "");
Expect(0, 177983, '\P{Is_Blk= cjk_Ext_C}', "");
Expect(1, 177983, '\P{^Is_Blk= cjk_Ext_C}', "");
Expect(0, 177984, '\p{Is_Blk= cjk_Ext_C}', "");
Expect(1, 177984, '\p{^Is_Blk= cjk_Ext_C}', "");
Expect(1, 177984, '\P{Is_Blk= cjk_Ext_C}', "");
Expect(0, 177984, '\P{^Is_Blk= cjk_Ext_C}', "");
Error('\p{Block=:= CJK_Unified_Ideographs_Extension_D}');
Error('\P{Block=:= CJK_Unified_Ideographs_Extension_D}');
Expect(1, 178207, '\p{Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178207, '\p{^Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178207, '\P{Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178207, '\P{^Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178208, '\p{Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178208, '\p{^Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178208, '\P{Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178208, '\P{^Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178207, '\p{Block=-	CJK_unified_ideographs_Extension_D}', "");
Expect(0, 178207, '\p{^Block=-	CJK_unified_ideographs_Extension_D}', "");
Expect(0, 178207, '\P{Block=-	CJK_unified_ideographs_Extension_D}', "");
Expect(1, 178207, '\P{^Block=-	CJK_unified_ideographs_Extension_D}', "");
Expect(0, 178208, '\p{Block=-	CJK_unified_ideographs_Extension_D}', "");
Expect(1, 178208, '\p{^Block=-	CJK_unified_ideographs_Extension_D}', "");
Expect(1, 178208, '\P{Block=-	CJK_unified_ideographs_Extension_D}', "");
Expect(0, 178208, '\P{^Block=-	CJK_unified_ideographs_Extension_D}', "");
Error('\p{Blk=:= _cjk_Ext_d}');
Error('\P{Blk=:= _cjk_Ext_d}');
Expect(1, 178207, '\p{Blk=cjkextd}', "");
Expect(0, 178207, '\p{^Blk=cjkextd}', "");
Expect(0, 178207, '\P{Blk=cjkextd}', "");
Expect(1, 178207, '\P{^Blk=cjkextd}', "");
Expect(0, 178208, '\p{Blk=cjkextd}', "");
Expect(1, 178208, '\p{^Blk=cjkextd}', "");
Expect(1, 178208, '\P{Blk=cjkextd}', "");
Expect(0, 178208, '\P{^Blk=cjkextd}', "");
Expect(1, 178207, '\p{Blk=_ CJK_ext_D}', "");
Expect(0, 178207, '\p{^Blk=_ CJK_ext_D}', "");
Expect(0, 178207, '\P{Blk=_ CJK_ext_D}', "");
Expect(1, 178207, '\P{^Blk=_ CJK_ext_D}', "");
Expect(0, 178208, '\p{Blk=_ CJK_ext_D}', "");
Expect(1, 178208, '\p{^Blk=_ CJK_ext_D}', "");
Expect(1, 178208, '\P{Blk=_ CJK_ext_D}', "");
Expect(0, 178208, '\P{^Blk=_ CJK_ext_D}', "");
Error('\p{Is_Block=/a/ 	cjk_Unified_Ideographs_Extension_D}');
Error('\P{Is_Block=/a/ 	cjk_Unified_Ideographs_Extension_D}');
Expect(1, 178207, '\p{Is_Block: cjkunifiedideographsextensiond}', "");
Expect(0, 178207, '\p{^Is_Block: cjkunifiedideographsextensiond}', "");
Expect(0, 178207, '\P{Is_Block: cjkunifiedideographsextensiond}', "");
Expect(1, 178207, '\P{^Is_Block: cjkunifiedideographsextensiond}', "");
Expect(0, 178208, '\p{Is_Block: cjkunifiedideographsextensiond}', "");
Expect(1, 178208, '\p{^Is_Block: cjkunifiedideographsextensiond}', "");
Expect(1, 178208, '\P{Is_Block: cjkunifiedideographsextensiond}', "");
Expect(0, 178208, '\P{^Is_Block: cjkunifiedideographsextensiond}', "");
Expect(1, 178207, '\p{Is_Block=-cjk_Unified_Ideographs_Extension_D}', "");
Expect(0, 178207, 