#!/usr/bin/env python

import curses

DEFAULT_KEYBINDINGS = {
    'RSS'                : [ ord('w') ],
    'UP'                 : [ curses.KEY_UP, ],
    'DOWN'               : [ curses.KEY_DOWN, ],
    'LEFT'               : [ curses.KEY_LEFT, ],
    'RIGHT'              : [ curses.KEY_RIGHT, ],
    'VIDEO'              : [ 10, curses.KEY_MOUSE ],
    'AUDIO'              : [ ord('a') ],
    'ALT_AUDIO'          : [ ord('A') ],
    'HELP'               : [ ord('h') ],
    'JUMP'               : [ ord('j') ],
    'MEDIA_DEBUG'        : [ ord('z') ],
    'MEDIA_DETAIL'       : [ ord('e') ],
    'OPTIONS'            : [ ord('o') ],
    'LINE_SCORE'         : [ ord('b') ],
    'BOX_SCORE'          : [ ord('x') ],
    'MASTER_SCOREBOARD'  : [ ord('m') ],
    'HIGHLIGHTS'         : [ ord('t') ],
    'HIGHLIGHTS_PLAYLIST': [ ord('y') ],
    'STANDINGS'          : [ ord('g') ],
    'INNINGS'            : [ ord('i') ],
    'LISTINGS'           : [ ord('l'), ord('L') ],
    'REFRESH'            : [ ord('r') ],
    'NEXDEF'             : [ ord('n') ],
    'COVERAGE'           : [ ord('s') ],
    'SPEED'              : [ ord('p') ],
    'STATS'              : [ ord('S') ],
    'STATS_ORDER'        : [ ord('O') ],
    'CONDENSED_GAME'     : [ ord('c') ],
    'RELOAD_CONFIG'      : [ ord('R') ],
    'QUIT'               : [ ord('q') ],
    'DEBUG'              : [ ord('d') ],
    'MILBTV'             : [ ord('M') ],
    'POSTSEASON'         : [ ord('P') ],
    'CALENDAR'           : [ ord('C') ],
    'DIVISION'           : [ ord('D') ],
}
