/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.pentaho.di.trans.steps.webservices.wsdl.DomUtils;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlTypes;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComplexType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, QName> _elements = new HashMap();
    private final List<String> _elementNames = new ArrayList<String>();
    private final String _name;
    private WsdlTypes _wsdlTypes;

    ComplexType(Element type, WsdlTypes wsdlTypes) {
        this._name = type.getAttribute("name");
        this._wsdlTypes = wsdlTypes;
        Element child = DomUtils.getChildElementByName(type, "simpleContent");
        if (child != null) {
            this.processSimpleContent(child);
        } else {
            child = DomUtils.getChildElementByName(type, "complexContent");
            if (child != null) {
                this.processComplexContent(child);
            } else {
                child = DomUtils.getChildElementByName(type, "group");
                if (child != null) {
                    this.processGroup(child);
                } else {
                    child = DomUtils.getChildElementByName(type, "all");
                    if (child != null) {
                        this.processAll(child);
                    } else {
                        child = DomUtils.getChildElementByName(type, "choice");
                        if (child != null) {
                            this.processChoice(child);
                        } else {
                            child = DomUtils.getChildElementByName(type, "sequence");
                            if (child != null) {
                                this.processSequence(child);
                            }
                        }
                    }
                }
            }
        }
        this._wsdlTypes = null;
    }

    public String getName() {
        return this._name;
    }

    public QName getElementType(String elementName) {
        return this._elements.get(elementName.toLowerCase());
    }

    public List<String> getElementNames() {
        return this._elementNames;
    }

    private void processAll(Element all) {
        List<Element> elements = DomUtils.getChildElementsByName(all, "element");
        Iterator<Element> itr = elements.iterator();
        while (itr.hasNext()) {
            this.processElement(itr.next());
        }
    }

    private void processAny(Element any) {
    }

    private void processChoice(Element choice) {
        this.processSequence(choice);
    }

    private void processComplexContent(Element complexContent) {
        Element child = DomUtils.getChildElementByName(complexContent, "extension");
        if (child != null) {
            this.processComplexExtension(child);
        } else {
            child = DomUtils.getChildElementByName(complexContent, "restriction");
            if (child != null) {
                this.processComplexRestriction(child);
            }
        }
    }

    private void processComplexExtension(Element complexExtension) {
        Element child = DomUtils.getChildElementByName(complexExtension, "group");
        if (child != null) {
            this.processGroup(child);
        } else {
            child = DomUtils.getChildElementByName(complexExtension, "all");
            if (child != null) {
                this.processAll(child);
            } else {
                child = DomUtils.getChildElementByName(complexExtension, "choice");
                if (child != null) {
                    this.processChoice(child);
                } else {
                    child = DomUtils.getChildElementByName(complexExtension, "sequence");
                    if (child != null) {
                        this.processSequence(child);
                    }
                }
            }
        }
    }

    private void processComplexRestriction(Element complexRestriction) {
        Element child = DomUtils.getChildElementByName(complexRestriction, "group");
        if (child != null) {
            this.processGroup(child);
        } else {
            child = DomUtils.getChildElementByName(complexRestriction, "all");
            if (child != null) {
                this.processAll(child);
            } else {
                child = DomUtils.getChildElementByName(complexRestriction, "choice");
                if (child != null) {
                    this.processChoice(child);
                } else {
                    child = DomUtils.getChildElementByName(complexRestriction, "sequence");
                    if (child != null) {
                        this.processSequence(child);
                    }
                }
            }
        }
    }

    private void processElement(Element element) {
        if (element.hasAttribute("name")) {
            String elementName = element.getAttribute("name");
            String elementType = element.getAttribute("type");
            this._elements.put(elementName.toLowerCase(), this._wsdlTypes.getTypeQName(elementType));
            this._elementNames.add(elementName);
        }
    }

    private void processGroup(Element group) {
        Element child = DomUtils.getChildElementByName(group, "all");
        if (child != null) {
            this.processAll(child);
        } else {
            child = DomUtils.getChildElementByName(group, "choice");
            if (child != null) {
                this.processChoice(child);
            } else {
                child = DomUtils.getChildElementByName(group, "sequence");
                if (child != null) {
                    this.processSequence(child);
                }
            }
        }
    }

    private void processSequence(Element sequence) {
        List<Element> elements = DomUtils.getChildElementsByName(sequence, "element");
        Iterator<Element> itr = elements.iterator();
        while (itr.hasNext()) {
            this.processElement(itr.next());
        }
        elements = DomUtils.getChildElementsByName(sequence, "group");
        itr = elements.iterator();
        while (itr.hasNext()) {
            this.processGroup(itr.next());
        }
        elements = DomUtils.getChildElementsByName(sequence, "choice");
        itr = elements.iterator();
        while (itr.hasNext()) {
            this.processChoice(itr.next());
        }
        elements = DomUtils.getChildElementsByName(sequence, "sequence");
        itr = elements.iterator();
        while (itr.hasNext()) {
            this.processSequence(itr.next());
        }
        elements = DomUtils.getChildElementsByName(sequence, "any");
        itr = elements.iterator();
        while (itr.hasNext()) {
            this.processAny(itr.next());
        }
    }

    private void processSimpleContent(Element simpleContent) {
        Element child = DomUtils.getChildElementByName(simpleContent, "extension");
        if (child != null) {
            this.processSimpleExtension(child);
        } else {
            child = DomUtils.getChildElementByName(simpleContent, "restriction");
            if (child != null) {
                this.processSimpleRestriction(child);
            }
        }
    }

    private void processSimpleExtension(Element any) {
    }

    private void processSimpleRestriction(Element simpleRestriction) {
    }
}

