/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_delete_donau_instance.h
 * @brief implementation of the delete_donau_instance function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#ifndef PG_DELETE_DONAU_INSTANCE_H
#define PG_DELETE_DONAU_INSTANCE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Delete an existing Donau charity instance from the database.
 *
 * @param cls closure
 * @param id merchant instance id
 * @param charity_id unique identifier of the charity instance to be deleted
 * @return transaction status code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_delete_donau_instance (
  void *cls,
  const char *id,
  const uint64_t charity_id);

#endif
