/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRCTemplate {
    public static final DRCTemplateSort templateSort = new DRCTemplateSort();
    public String ruleName;
    public int when;
    public DRCRuleType ruleType;
    public String name1;
    public String name2;
    public double value1;
    public double value2;
    public double maxWidth;
    public double minLength;
    public String nodeName;
    public int multiCuts;

    public DRCTemplate(DRCTemplate rule) {
        this.ruleName = rule.ruleName;
        this.when = rule.when;
        this.ruleType = rule.ruleType;
        this.name1 = rule.name1;
        this.name2 = rule.name2;
        this.value1 = rule.value1;
        this.value2 = rule.value2;
        this.maxWidth = rule.maxWidth;
        this.minLength = rule.minLength;
        this.nodeName = rule.nodeName;
        this.multiCuts = rule.multiCuts;
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, String name1, String name2, double distance, String nodeName) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.name1 = name1;
        this.name2 = name2;
        this.value1 = this.value2 = distance;
        this.nodeName = nodeName;
        this.multiCuts = -1;
        switch (ruleType) {
            case SPACING: 
            case SURROUND: {
                if (name1 != null && name2 != null) break;
                System.out.println("Error: missing one layer in no '" + rule + "' ");
                break;
            }
        }
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, double maxW, double minLen, double distance, int multiCut) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.value1 = distance;
        this.maxWidth = maxW;
        this.minLength = minLen;
        this.multiCuts = multiCut;
    }

    public DRCTemplate(String rule, int when, DRCRuleType ruleType, double maxW, double minLen, String name1, String name2, double distance, int multiCut) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.name1 = name1;
        this.name2 = name2;
        this.value1 = distance;
        this.maxWidth = maxW;
        this.minLength = minLen;
        this.multiCuts = multiCut;
        switch (ruleType) {
            case SPACING: {
                if (name1 != null && name2 != null) break;
                System.out.println("Error: missing one layer in no '" + rule + "' ");
                break;
            }
        }
    }

    public static List<DRCTemplate> makeRuleTemplates(String name, int when, DRCRuleType type, double maxW, double minLen, double value, String[] arrayL) {
        int length = arrayL.length;
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(length);
        for (int i = 0; i < length; ++i) {
            String layer = arrayL[i];
            DRCTemplate r = new DRCTemplate(name, when, type, maxW, minLen, layer, null, value, -1);
            list.add(r);
        }
        return list;
    }

    public static List<DRCTemplate> makeRuleTemplates(String[] names, int[] when, DRCRuleType type, double value, String[][] matrix) {
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(names.length * matrix.length);
        for (int i = 0; i < names.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                DRCTemplate r = new DRCTemplate(names[i], when[i], type, matrix[j][0], matrix[j][1], value, matrix[j].length > 2 ? matrix[j][2] : null);
                list.add(r);
            }
        }
        return list;
    }

    public static List<DRCTemplate> makeRuleTemplates(String[] names, int[] when, DRCRuleType type, double maxW, double value, String[][] arrayL) {
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(names.length);
        for (int i = 0; i < names.length; ++i) {
            list.addAll(DRCTemplate.makeRuleTemplates(names[i], when[i], type, maxW, 0.0, value, arrayL, -1));
        }
        return list;
    }

    public static List<DRCTemplate> makeRuleTemplates(String name, int when, DRCRuleType type, double maxW, double minLen, double value, String[][] arrayL, int multiCut) {
        int l = arrayL.length;
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(l);
        for (int i = 0; i < l; ++i) {
            String[] layers = arrayL[i];
            if (layers.length != 2) {
                System.out.println("Invalid number of layers in DRC::makeRuleTemplates");
            }
            DRCTemplate r = new DRCTemplate(name, when, type, maxW, minLen, layers[0], layers[1], value, multiCut);
            list.add(r);
        }
        return list;
    }

    public static List<DRCTemplate> makeRuleTemplates(String name, int when, DRCRuleType type, double value, String[] arrayL) {
        int length = arrayL.length;
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(length);
        for (int i = 0; i < length; ++i) {
            String primitiveNode = arrayL[i];
            DRCTemplate r = new DRCTemplate(name, when, type, null, null, value, primitiveNode);
            list.add(r);
        }
        return list;
    }

    public static DRCXMLParser importDRCDeck(URL fileURL, boolean verbose) {
        DRCXMLParser parser = new DRCXMLParser();
        parser.process(fileURL, verbose);
        return parser;
    }

    public static void exportDRCDecks(String fileName, Technology tech) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<!--");
            out.println("\t Document: DRC deck for " + tech);
            out.println("\t Generated by: Electric (" + Version.getVersion() + ")");
            out.println("-->");
            out.println("<!DOCTYPE DRCRules SYSTEM \"DRC.dtd\">");
            out.println("<DRCRules>");
            Iterator<Foundry> it = tech.getFoundries();
            while (it.hasNext()) {
                Foundry foundry = it.next();
                List<DRCTemplate> rules = foundry.getRules();
                out.println("    <Foundry name=\"" + foundry.getType().name() + "\">");
                block9: for (DRCTemplate rule : rules) {
                    String whenName = null;
                    for (DRCMode p : DRCMode.values()) {
                        if (p == DRCMode.NONE || p.mode() == Foundry.Type.MOSIS.mode() || p.mode() == Foundry.Type.TSMC.mode() || p.mode() == Foundry.Type.ST.mode() || (p.mode() & rule.when) == 0) continue;
                        whenName = whenName == null ? "" : whenName + "|";
                        whenName = whenName + (Object)((Object)p);
                    }
                    if (whenName == null) {
                        whenName = DRCMode.ALL.name();
                    }
                    switch (rule.ruleType) {
                        case MINWID: 
                        case MINAREA: 
                        case MINENCLOSEDAREA: {
                            out.println("        <LayerRule ruleName=\"" + rule.ruleName + "\"" + " layerName=\"" + rule.name1 + "\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + " value=\"" + rule.value1 + "\"" + "/>");
                            continue block9;
                        }
                        case SPACING: 
                        case UCONSPA: 
                        case UCONSPA2D: 
                        case CONSPA: 
                        case SPACINGE: 
                        case COMBINATION: {
                            String noName = rule.nodeName != null ? " nodeName=\"" + rule.nodeName + "\"" : "";
                            String wideValues = rule.maxWidth > 0.0 ? " maxW=\"" + rule.maxWidth + "\"" + " minLen=\"" + rule.minLength + "\"" : "";
                            out.println("        <LayersRule ruleName=\"" + rule.ruleName + "\"" + " layerNames=\"{" + rule.name1 + "," + rule.name2 + "}\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + " value=\"" + rule.value1 + "\"" + wideValues + noName + "/>");
                            continue block9;
                        }
                        case SURROUND: 
                        case ASURROUND: {
                            out.println("        <NodeLayersRule ruleName=\"" + rule.ruleName + "\"" + " layerNames=\"{" + rule.name1 + "," + rule.name2 + "}\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + " value=\"" + rule.value1 + "\"" + " nodeName=\"" + rule.nodeName + "\"" + "/>");
                            continue block9;
                        }
                        case NODSIZ: {
                            out.println("        <NodeRule ruleName=\"" + rule.ruleName + "\"" + " type=\"" + (Object)((Object)rule.ruleType) + "\"" + " when=\"" + whenName + "\"" + " value=\"" + rule.value1 + "\"" + " nodeName=\"" + rule.nodeName + "\"" + "/>");
                            continue block9;
                        }
                    }
                    System.out.println("Case not implemented " + (Object)((Object)rule.ruleType));
                }
                out.println("    </Foundry>");
            }
            out.println("</DRCRules>");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getSpacingCombinedName(Layer layer, Geometric geo) {
        String n1 = layer.getName() + "-";
        if (geo != null) {
            n1 = geo instanceof NodeInst ? n1 + ((NodeInst)geo).getProto().getName() : n1 + ((ArcInst)geo).getProto().getName();
        }
        return n1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DRCXMLParser {
        private List<DRCXMLBucket> rulesList = new ArrayList<DRCXMLBucket>();
        private DRCXMLBucket current = null;
        private boolean fullLoaded = true;
        private String fileName;

        public List<DRCXMLBucket> getRules() {
            return this.rulesList;
        }

        public boolean isParseOK() {
            return this.fullLoaded;
        }

        protected boolean process(URL fileURL, boolean verbose) {
            this.fileName = TextUtils.getFileNameWithoutExtension(fileURL);
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                SAXParser parser = factory.newSAXParser();
                URLConnection urlCon = fileURL.openConnection();
                InputStream inputStream = urlCon.getInputStream();
                if (verbose) {
                    System.out.println("Parsing XML file \"" + fileURL + "\"");
                }
                DRCXMLHandler handler = new DRCXMLHandler();
                parser.parse(inputStream, (DefaultHandler)handler);
                this.fullLoaded = handler.passed;
                if (verbose) {
                    System.out.println("End Parsing XML file ...");
                }
            }
            catch (Exception e) {
                if (verbose) {
                    e.printStackTrace();
                }
                this.fullLoaded = false;
            }
            return this.fullLoaded;
        }

        private class DRCXMLHandler
        extends DefaultHandler {
            boolean passed = true;

            DRCXMLHandler() {
            }

            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                URL fileURL = this.getClass().getResource("DRC.dtd");
                URLConnection urlCon = fileURL.openConnection();
                InputStream inputStream = urlCon.getInputStream();
                return new InputSource(inputStream);
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                DRCTemplate tmp;
                if (qName.equals("Foundry")) {
                    DRCXMLParser.this.current = new DRCXMLBucket();
                    DRCXMLParser.this.rulesList.add(DRCXMLParser.this.current);
                    ((DRCXMLParser)DRCXMLParser.this).current.foundry = attributes.getValue(0);
                    return;
                }
                boolean layerRule = qName.equals("LayerRule");
                boolean layersRule = qName.equals("LayersRule");
                boolean nodeLayersRule = qName.equals("NodeLayersRule");
                boolean nodeRule = qName.equals("NodeRule");
                if (!(layerRule || layersRule || nodeLayersRule || nodeRule)) {
                    return;
                }
                String ruleName = "";
                String layerNames = "";
                String nodeNames = null;
                int when = DRCMode.ALL.mode();
                DRCRuleType type = DRCRuleType.NONE;
                double value = Double.NaN;
                Double maxW = null;
                Double minLen = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("ruleName")) {
                        ruleName = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("layerName")) {
                        layerNames = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("nodeName")) {
                        nodeNames = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).equals("type")) {
                        type = DRCRuleType.valueOf(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("when")) {
                        String[] modes;
                        for (String mode : modes = TextUtils.parseString(attributes.getValue(i), "|")) {
                            DRCMode m = DRCMode.valueOf(mode);
                            when |= m.mode();
                        }
                        continue;
                    }
                    if (attributes.getQName(i).equals("value")) {
                        value = Double.parseDouble(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("maxW")) {
                        maxW = Double.parseDouble(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("minLen")) {
                        minLen = Double.parseDouble(attributes.getValue(i));
                        continue;
                    }
                    new Error("Invalid attribute in DRCXMLParser");
                }
                if (layerRule) {
                    String[] layers;
                    for (String layer : layers = TextUtils.parseString(layerNames, ",")) {
                        String[] names;
                        if (nodeNames == null) {
                            tmp = new DRCTemplate(ruleName, when, type, layer, null, value, null);
                            ((DRCXMLParser)DRCXMLParser.this).current.drcRules.add(tmp);
                            continue;
                        }
                        for (String name : names = TextUtils.parseString(nodeNames, ",")) {
                            DRCTemplate tmp2 = new DRCTemplate(ruleName, when, type, layer, null, value, name);
                            ((DRCXMLParser)DRCXMLParser.this).current.drcRules.add(tmp2);
                        }
                    }
                } else if (nodeRule) {
                    if (nodeNames == null) {
                        DRCTemplate tmp3 = new DRCTemplate(ruleName, when, type, null, null, value, null);
                        ((DRCXMLParser)DRCXMLParser.this).current.drcRules.add(tmp3);
                    } else {
                        String[] names;
                        for (String name : names = TextUtils.parseString(nodeNames, ",")) {
                            tmp = new DRCTemplate(ruleName, when, type, null, null, value, name);
                            ((DRCXMLParser)DRCXMLParser.this).current.drcRules.add(tmp);
                        }
                    }
                } else if (layersRule || nodeLayersRule) {
                    String[] layerPairs;
                    for (String layerPair : layerPairs = TextUtils.parseString(layerNames, "{}")) {
                        String[] names;
                        String[] pair = TextUtils.parseString(layerPair, ",");
                        if (pair.length != 2) continue;
                        if (nodeNames == null) {
                            DRCTemplate tmp4 = maxW == null ? new DRCTemplate(ruleName, when, type, pair[0], pair[1], value, null) : new DRCTemplate(ruleName, when, type, maxW, minLen, pair[0], pair[1], value, -1);
                            ((DRCXMLParser)DRCXMLParser.this).current.drcRules.add(tmp4);
                            continue;
                        }
                        for (String name : names = TextUtils.parseString(nodeNames, ",")) {
                            DRCTemplate tmp5 = null;
                            if (maxW == null) {
                                tmp5 = new DRCTemplate(ruleName, when, type, pair[0], pair[1], value, name);
                            } else {
                                System.out.println("When do I have this case?");
                            }
                            ((DRCXMLParser)DRCXMLParser.this).current.drcRules.add(tmp5);
                        }
                    }
                } else {
                    System.out.println("Case not implemented in DRCXMLParser");
                    this.passed = false;
                }
            }

            public void fatalError(SAXParseException e) {
                System.out.println("Parser Fatal Error: '" + e.getMessage() + "' in line " + e.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
                this.passed = false;
            }

            public void warning(SAXParseException e) {
                System.out.println("Parser Warning: '" + e.getMessage() + "' in line " + e.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
            }

            public void error(SAXParseException e) {
                System.out.println("Parser Error: " + e.getMessage() + "' in line " + e.getLineNumber() + " in '" + DRCXMLParser.this.fileName + "'.");
                this.passed = false;
            }
        }
    }

    public static class DRCXMLBucket {
        public List<DRCTemplate> drcRules = new ArrayList<DRCTemplate>();
        public String foundry = Foundry.Type.NONE.name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DRCTemplateSort
    implements Comparator<DRCTemplate> {
        @Override
        public int compare(DRCTemplate d1, DRCTemplate d2) {
            double bb1 = d1.value1;
            double bb2 = d2.value1;
            if (bb1 < bb2) {
                return -1;
            }
            if (bb1 > bb2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCRuleType {
        NONE(-1),
        MINWID(1),
        NODSIZ(2),
        SURROUND(3),
        SPACING(8),
        SPACINGE(11),
        CONSPA(12),
        UCONSPA(13),
        UCONSPA2D(28),
        CUTSURX(18),
        CUTSURY(19),
        ASURROUND(20),
        MINAREA(21),
        MINENCLOSEDAREA(22),
        EXTENSION(23),
        FORBIDDEN(24),
        COMBINATION(25),
        EXTENSIONGATE(26),
        SLOTSIZE(27);

        private final int mode;

        private DRCRuleType(int mode) {
            this.mode = mode;
        }

        public int mode() {
            return this.mode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCMode {
        NONE(-1),
        ALL(0),
        M2(1),
        M3(2),
        M4(4),
        M5(8),
        M6(16),
        M23(3),
        M456(28),
        M56(24),
        M7(32768),
        M8(65536),
        M9(131072),
        AC(32),
        NAC(64),
        SV(128),
        NSV(256),
        DE(512),
        SU(1024),
        SC(2048);

        private final int mode;

        private DRCMode(int mode) {
            this.mode = mode;
        }

        public int mode() {
            return this.mode;
        }

        public String toString() {
            return this.name();
        }
    }
}

