/*
 * Copyright (C) 2000-2025 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */

#ifndef SKINS_H
#define SKINS_H

#define DEFAULT_SKIN        "xinetic"
#define SKIN_IFACE_VERSION  5

#undef SKIN_DEBUG

/** return current skin dir. */
const char *skin_init (gGui_t *gui);
/** load user preferred skin, or some fallback if that fails. */
void skin_load (gGui_t *gui);

/** /usr/local/share/xine/skins/name\0
 *  ^-fullname             name-^   ^-end.
 *  return >= 0 (added_index) or < 0 (~already_found_index). */
int skin_add_1 (gGui_t *gui, const char *fullname, const char *name, const char *end);
/** switch to a different skin, or reload same. */
void skin_select (gGui_t *gui, int selected);

#ifdef HAVE_TAR
void skin_download (gGui_t *gui, const char *url);
void skin_download_end (xui_skdloader_t *skd);
#endif

void skin_deinit (gGui_t *gui);

#endif
