/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.ArrangeMeasurement;
import WIMSchem.ArrangeMolecule;
import WIMSchem.EditorPane;
import WIMSchem.MainApplet;
import WIMSchem.Molecule;
import WIMSchem.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.QuadCurve2D;
import java.text.DecimalFormat;

public class DrawMolecule
implements ArrangeMeasurement {
    public static final double DEFSCALE = 20.0;
    private Molecule mol;
    private Graphics2D g;
    private ArrangeMolecule arrmol = null;
    private final double ASCENT_FUDGE = 0.8;
    private Color backgr = Color.WHITE;
    private Color colHighlight = null;
    private Color colSelected = null;
    private Color colDragged = null;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double scale = 20.0;
    private boolean[] selected = null;
    private boolean[] dragged = null;
    private int highlightAtom = 0;
    private int highlightBond = 0;
    private boolean bondInProgress = false;
    private int bipFrom;
    private int bipOrder;
    private int bipType;
    private double bipToX;
    private double bipToY;
    private boolean atomInProgress = false;
    private String aipLabel;
    private double aipToX;
    private double aipToY;
    private boolean newBondLine = false;
    private double nblX1;
    private double nblY1;
    private double nblX2;
    private double nblY2;
    private boolean dragSelect = false;
    private int dslX1;
    private int dslY1;
    private int dslX2;
    private int dslY2;
    private boolean dragScale = false;
    private double dscCX;
    private double dscCY;
    private double dscExtMul;
    private boolean dragMove = false;
    private double dmvDX;
    private double dmvDY;
    private boolean dmvCopy;
    private boolean dragRotate = false;
    private double droTheta;
    private int droX;
    private int droY;
    private boolean outlineTemplate = false;
    private Molecule oltMol;

    public DrawMolecule(Molecule Mol, Graphics2D Gr, double Scale) {
        this.mol = Mol;
        this.g = Gr;
        this.scale = Scale;
        this.arrmol = new ArrangeMolecule(this.mol, this);
        this.arrmol.setDevRounding(true);
    }

    public void setOffset(double OX, double OY) {
        this.offsetX = OX;
        this.offsetY = OY;
    }

    public void setShowMode(int Mode) {
        this.arrmol.setElementMode(Mode);
    }

    public void setShowHydr(boolean ShowH) {
        this.arrmol.setShowHydrogens(ShowH);
    }

    public void setShowStereo(boolean ShowSter) {
        this.arrmol.setAnnotRS(ShowSter);
        this.arrmol.setAnnotEZ(ShowSter);
    }

    public void setBackground(Color Col) {
        this.backgr = Col;
    }

    public void setSelected(boolean[] Selected, boolean[] Dragged) {
        this.selected = Selected;
        this.dragged = Dragged;
    }

    public void setHighlight(int Atom2, int Bond2) {
        this.highlightAtom = Atom2;
        this.highlightBond = Bond2;
    }

    public void bondInProgress(int From, double X, double Y, int Order, int Type2) {
        this.bondInProgress = true;
        this.bipFrom = From;
        this.bipToX = X;
        this.bipToY = Y;
        this.bipOrder = Order;
        this.bipType = Type2;
    }

    public void atomInProgress(String Label, double X, double Y) {
        this.atomInProgress = true;
        this.aipLabel = Label;
        this.aipToX = X;
        this.aipToY = Y;
    }

    public void newBondLine(double X1, double Y1, double X2, double Y2) {
        this.newBondLine = true;
        this.nblX1 = X1;
        this.nblY1 = Y1;
        this.nblX2 = X2;
        this.nblY2 = Y2;
    }

    public void dragSelect(int X1, int Y1, int X2, int Y2) {
        this.dragSelect = true;
        this.dslX1 = X1;
        this.dslY1 = Y1;
        this.dslX2 = X2;
        this.dslY2 = Y2;
    }

    public void dragScale(double CX, double CY, double ExtMul) {
        this.dragScale = true;
        this.dscCX = CX;
        this.dscCY = CY;
        this.dscExtMul = ExtMul;
    }

    public void dragMove(double DX, double DY, boolean Copy) {
        this.dragMove = true;
        this.dmvDX = DX;
        this.dmvDY = DY;
        this.dmvCopy = Copy;
    }

    public void dragRotate(double Theta, int X, int Y) {
        this.dragRotate = true;
        this.droTheta = Theta;
        this.droX = X;
        this.droY = Y;
    }

    public void outlineTemplate(Molecule Templ) {
        this.outlineTemplate = true;
        this.oltMol = Templ;
    }

    public void draw() {
        this.arrmol.arrange();
        this.setupColours();
        this.drawBacklighting();
        this.drawBonds();
        this.drawAtoms();
        this.drawEffects();
        this.drawCorrections();
        if (MainApplet.USER_SELECTION) {
            this.drawAtomSelection();
        }
    }

    public ArrangeMolecule arrangement() {
        return this.arrmol;
    }

    private void setupColours() {
        if (this.colHighlight == null) {
            this.colHighlight = this.backgr.darker();
        }
        if (this.colSelected == null) {
            this.colSelected = new Color(this.colHighlight.getRed(), this.colHighlight.getGreen(), 255);
        }
        if (this.colDragged == null) {
            this.colDragged = new Color(this.colHighlight.getRed(), 192, 255);
        }
    }

    private void drawBacklighting() {
        int n;
        for (n = 1; n <= this.mol.numAtoms(); ++n) {
            boolean drag = false;
            if (this.dragged != null) {
                drag = this.dragged[n - 1];
            }
            if (!this.selected[n - 1] && n != this.highlightAtom && !drag) continue;
            this.g.setColor(this.selected[n - 1] ? this.colSelected : (drag ? this.colDragged : this.colHighlight));
            double cx = this.arrmol.pointCX(n - 1);
            double cy = this.arrmol.pointCY(n - 1);
            double rw = this.arrmol.pointRW(n - 1);
            double rh = this.arrmol.pointRH(n - 1);
            double ext = rw == 0.0 && rh == 0.0 ? 0.25 * this.scale : Math.max(rw * 1.5, rh * 1.5);
            this.g.fill(new Ellipse2D.Double(cx - ext, cy - ext, 2.0 * ext, 2.0 * ext));
        }
        if (this.highlightBond != 0) {
            for (n = 0; n < this.arrmol.numLines(); ++n) {
                if (this.arrmol.lineBNum(n) != this.highlightBond) continue;
                double x1 = this.arrmol.lineX1(n);
                double y1 = this.arrmol.lineY1(n);
                double x2 = this.arrmol.lineX2(n);
                double y2 = this.arrmol.lineY2(n);
                double sz = this.arrmol.lineSize(n) + 0.1 * this.scale;
                double dx = x2 - x1;
                double dy = y2 - y1;
                double norm = sz / Math.sqrt(dx * dx + dy * dy);
                double ox = norm * dy;
                double oy = -norm * dx;
                Polygon pgn = new Polygon();
                pgn.addPoint(Util.iround(x1 + oy * 0.5), Util.iround(y1 - ox * 0.5));
                pgn.addPoint(Util.iround(x1 - ox), Util.iround(y1 - oy));
                pgn.addPoint(Util.iround(x2 - ox), Util.iround(y2 - oy));
                pgn.addPoint(Util.iround(x2 - oy * 0.5), Util.iround(y2 + ox * 0.5));
                pgn.addPoint(Util.iround(x2 + ox), Util.iround(y2 + oy));
                pgn.addPoint(Util.iround(x1 + ox), Util.iround(y1 + oy));
                this.g.setColor(this.colHighlight);
                this.g.fill(pgn);
            }
        }
    }

    private void drawBonds() {
        block24: {
            for (int n = 0; n < this.arrmol.numLines(); ++n) {
                int i;
                double oy;
                double ox;
                int nsteps;
                int btype = this.arrmol.lineType(n);
                double x1 = this.arrmol.lineX1(n);
                double y1 = this.arrmol.lineY1(n);
                double x2 = this.arrmol.lineX2(n);
                double y2 = this.arrmol.lineY2(n);
                double dx = x2 - x1;
                double dy = y2 - y1;
                int factor = 1;
                this.g.setColor(new Color(this.arrmol.lineCol(n)));
                if (MainApplet.USER_SELECTION) {
                    if (EditorPane.bondselection.length > this.mol.numBonds()) {
                        if (EditorPane.bondselection[this.arrmol.lineBNum(n)]) {
                            this.g.setColor(MainApplet.BOND_SELECT_COLOR);
                            factor = 2;
                        } else {
                            this.g.setColor(new Color(this.arrmol.lineCol(n)));
                            factor = 1;
                        }
                    } else {
                        EditorPane.bondselection = EditorPane.GrowArray(EditorPane.bondselection, this.mol.numBonds() + 32);
                    }
                } else if (MainApplet.ExternalBondSelection != null) {
                    for (int i2 = 0; i2 < MainApplet.ExternalBondSelection.length; ++i2) {
                        if (n != MainApplet.ExternalBondSelection[i2]) continue;
                        this.g.setColor(MainApplet.SelectedBondColorArray[i2]);
                        factor = 2;
                    }
                }
                if (btype == 1) {
                    this.g.setStroke(new BasicStroke((float)((double)factor * this.arrmol.lineSize(n)), 1, 1));
                    this.g.draw(new Line2D.Double(x1, y1, x2, y2));
                    continue;
                }
                if (btype == 2) {
                    double norm = (double)factor * 0.15 * this.scale / Math.sqrt(dx * dx + dy * dy);
                    double ox2 = norm * dy;
                    double oy2 = -norm * dx;
                    Path2D.Double path = new Path2D.Double();
                    ((Path2D)path).moveTo(x1, y1);
                    ((Path2D)path).lineTo(x2 - ox2, y2 - oy2);
                    ((Path2D)path).lineTo(x2 + ox2, y2 + oy2);
                    this.g.fill(path);
                    continue;
                }
                if (btype == 3) {
                    nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.15);
                    double norm = 0.15 * this.scale / Math.sqrt(dx * dx + dy * dy);
                    ox = norm * dy;
                    oy = -norm * dx;
                    for (i = 0; i <= nsteps + 1; ++i) {
                        double cx = x1 + (double)i * dx / (double)(nsteps + 1);
                        double cy = y1 + (double)i * dy / (double)(nsteps + 1);
                        double ix = ox * (double)i / (double)(nsteps + 1);
                        double iy = oy * (double)i / (double)(nsteps + 1);
                        this.g.setStroke(new BasicStroke((float)((double)factor * 0.05 * this.scale)));
                        this.g.draw(new Line2D.Double(cx - ix, cy - iy, cx + ix, cy + iy));
                    }
                    continue;
                }
                if (btype == 4) {
                    nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.2);
                    double norm = 0.2 * this.scale / Math.sqrt(dx * dx + dy * dy);
                    ox = norm * dy;
                    oy = -norm * dx;
                    for (i = 0; i <= nsteps; ++i) {
                        double ax = x1 + (double)i * dx / (double)(nsteps + 1);
                        double ay = y1 + (double)i * dy / (double)(nsteps + 1);
                        double cx = x1 + (double)(i + 1) * dx / (double)(nsteps + 1);
                        double cy = y1 + (double)(i + 1) * dy / (double)(nsteps + 1);
                        double bx = (ax + cx) / 2.0;
                        double by = (ay + cy) / 2.0;
                        int sign = i % 2 == 0 ? 1 : -1;
                        this.g.setStroke(new BasicStroke((float)((double)factor * 0.05 * this.scale)));
                        this.g.draw(new QuadCurve2D.Double(ax, ay, bx + (double)sign * ox, by + (double)sign * oy, cx, cy));
                    }
                    continue;
                }
                if (btype != 5) continue;
                nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.1);
                float radius = (float)this.arrmol.lineSize(n);
                for (int i3 = 0; i3 <= nsteps + 1; ++i3) {
                    double cx = x1 + (double)i3 * dx / (double)(nsteps + 1);
                    double cy = y1 + (double)i3 * dy / (double)(nsteps + 1);
                    this.g.fill(new Ellipse2D.Double(cx - (double)radius, cy - (double)radius, 2.0f * radius, 2.0f * radius));
                }
            }
            if (!this.bondInProgress) break block24;
            double x1 = this.arrmol.pointCX(this.bipFrom - 1);
            double y1 = this.arrmol.pointCY(this.bipFrom - 1);
            double x2 = this.angToX(this.bipToX);
            double y2 = this.angToY(this.bipToY);
            double dx = x2 - x1;
            double dy = y2 - y1;
            double norm = 0.2 * this.scale / Math.sqrt(dx * dx + dy * dy);
            double ox = norm * dy;
            double oy = -norm * dx;
            this.g.setColor(this.colHighlight);
            if (this.bipType == 1 || this.bipType == 2) {
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(x1, y1);
                ((Path2D)path).lineTo(x2 - ox, y2 - oy);
                ((Path2D)path).lineTo(x2 + ox, y2 + oy);
                path.closePath();
                if (this.bipType == 1) {
                    this.g.fill(path);
                } else {
                    this.g.draw(path);
                }
            } else if (this.bipType == 3 || this.bipOrder == 0) {
                int nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.15);
                float radius = (float)(0.15 * this.scale);
                for (int i = 0; i <= nsteps + 1; ++i) {
                    double cx = x1 + (double)i * dx / (double)(nsteps + 1);
                    double cy = y1 + (double)i * dy / (double)(nsteps + 1);
                    this.g.fill(new Ellipse2D.Double(cx - 0.05 * this.scale, cy - 0.05 * this.scale, radius, radius));
                }
            } else {
                double v = -0.5 * (double)(this.bipOrder - 1);
                this.g.setStroke(new BasicStroke((float)(0.1 * this.scale), 1, 1));
                int i = 0;
                while (i < this.bipOrder) {
                    this.g.draw(new Line2D.Double(x1 + ox * v, y1 + oy * v, x2 + ox * v, y2 + oy * v));
                    ++i;
                    v += 1.0;
                }
            }
        }
    }

    private void drawAtoms() {
        int n;
        for (n = 0; n < this.arrmol.numPoints(); ++n) {
            String txt = this.arrmol.pointText(n);
            if (txt == null) continue;
            Font font = new Font("SansSerif", this.arrmol.pointBold(n) ? 1 : 0, Util.iround(this.arrmol.pointFontSize(n)));
            this.g.setFont(font);
            FontMetrics fm = this.g.getFontMetrics();
            double ascent = 0.8 * (double)fm.getAscent();
            float cx = (float)(this.arrmol.pointCX(n) - 0.5 * (double)fm.stringWidth(txt));
            float cy = (float)(this.arrmol.pointCY(n) + 0.5 * ascent);
            this.g.setColor(new Color(this.arrmol.pointCol(n)));
            this.g.drawString(txt, cx, cy);
        }
        if (MainApplet.ExternalAtomSelection != null) {
            for (n = 0; n < this.arrmol.numPoints(); ++n) {
                for (int i = 0; i < MainApplet.ExternalAtomSelection.length; ++i) {
                    if (n != MainApplet.ExternalAtomSelection[i]) continue;
                    this.g.setColor(MainApplet.SelectedAtomColorArray[i]);
                    this.g.fill(this.circle(this.arrmol.pointCX(n - 1), this.arrmol.pointCY(n - 1), 0.5 * this.scale));
                }
            }
        }
    }

    private void drawAtomSelection() {
        this.g.setColor(MainApplet.ATOM_SELECT_COLOR);
        int len1 = this.mol.numAtoms();
        int len2 = EditorPane.atomselection.length;
        if (len2 < len1 - 2) {
            EditorPane.atomselection = EditorPane.GrowArray(EditorPane.atomselection, len1 + 8);
        }
        for (int n = 1; n < len2; ++n) {
            if (!EditorPane.atomselection[n]) continue;
            this.g.fill(this.circle(this.arrmol.pointCX(n - 1), this.arrmol.pointCY(n - 1), 0.5 * this.scale));
        }
    }

    private void drawEffects() {
        double sy;
        double sx;
        if (this.atomInProgress) {
            this.g.setColor(Color.BLUE);
            Font font = new Font("SansSerif", 0, Util.iround(this.arrmol.getFontSizeDev()));
            this.g.setFont(font);
            double tx = this.angToX(this.aipToX);
            double ty = this.angToY(this.aipToY);
            double[] wad = this.measureText(this.aipLabel, this.arrmol.getFontSizeDev());
            this.g.drawString(this.aipLabel, (float)(tx - 0.5 * wad[0]), (float)(ty + 0.4 * wad[1]));
        }
        if (this.newBondLine) {
            this.g.setColor(this.colHighlight);
            this.g.draw(new Line2D.Double(this.angToX(this.nblX1), this.angToY(this.nblY1), this.angToX(this.nblX2), this.angToY(this.nblY2)));
        }
        if (this.dragSelect) {
            this.g.setXORMode(Color.YELLOW);
            int x = this.dslX1;
            int y = this.dslY1;
            int w = this.dslX2 - this.dslX1;
            int h = this.dslY2 - this.dslY1;
            if (w < 0) {
                w = -w;
                x -= w;
            }
            if (h < 0) {
                h = -h;
                y -= h;
            }
            this.g.drawRect(x, y, w, h);
            this.g.setXORMode(Color.BLACK);
        }
        if (this.dragScale) {
            this.g.setColor(Color.BLACK);
            this.g.setStroke(new BasicStroke(1.1f));
            for (int n = 1; n <= this.mol.numAtoms(); ++n) {
                if (!this.selected[n - 1]) continue;
                sx = this.angToX((this.mol.atomX(n) - this.dscCX) * this.dscExtMul + this.dscCX);
                sy = this.angToY((this.mol.atomY(n) - this.dscCY) * this.dscExtMul + this.dscCY);
                this.g.draw(new Ellipse2D.Double(sx - this.scale * 0.3, sy - this.scale * 0.3, this.scale * 0.6, this.scale * 0.6));
            }
        }
        if (this.dragMove) {
            this.g.setColor(Color.BLACK);
            this.g.setStroke(new BasicStroke(1.1f));
            for (int n = 1; n <= this.mol.numAtoms(); ++n) {
                if (!this.selected[n - 1]) continue;
                sx = this.arrmol.pointCX(n - 1) + this.dmvDX;
                sy = this.arrmol.pointCY(n - 1) + this.dmvDY;
                this.g.draw(new Ellipse2D.Double(sx - this.scale * 0.3, sy - this.scale * 0.3, this.scale * 0.6, this.scale * 0.6));
                if (!this.dmvCopy) continue;
                this.g.draw(new Line2D.Double(sx - this.scale * 0.15, sy, sx + this.scale * 0.15, sy));
                this.g.draw(new Line2D.Double(sx, sy - this.scale * 0.15, sx, sy + this.scale * 0.15));
            }
        }
        if (this.dragRotate) {
            double thrad = this.droTheta * Math.PI / 180.0;
            this.g.setColor(Color.RED);
            this.g.setStroke(new BasicStroke(0.5f, 1, 1, 1.0f, new float[]{2.0f, 2.0f}, 0.0f));
            this.g.draw(new Line2D.Double(this.droX, this.droY, this.droX + 50, this.droY));
            this.g.setStroke(new BasicStroke(1.0f));
            this.g.draw(new Line2D.Double(this.droX, this.droY, (double)this.droX + 50.0 * Math.cos(-thrad), (double)this.droY + 50.0 * Math.sin(-thrad)));
            this.g.draw(new Arc2D.Double(this.droX - 20, this.droY - 20, 40.0, 40.0, 0.0, this.droTheta, 0));
            Font font = new Font("SansSerif", 0, 12);
            this.g.setFont(font);
            int ty = (int)(this.droTheta > 25.0 || this.droTheta < 0.0 && this.droTheta >= -25.0 ? (double)(this.droY - 5) : (double)(this.droY + 5) + 0.8 * (double)font.getSize());
            DecimalFormat fmt = new DecimalFormat("0");
            this.g.drawString((this.droTheta > 0.0 ? "+" : "") + fmt.format(Math.round(this.droTheta)) + "\u00b0", this.droX + 25, ty);
            double ax = this.xToAng(this.droX);
            double ay = this.yToAng(this.droY);
            this.g.setStroke(new BasicStroke(1.1f));
            for (int n = 1; n <= this.mol.numAtoms(); ++n) {
                if (!this.selected[n - 1]) continue;
                double rx = this.mol.atomX(n) - ax;
                double ry = this.mol.atomY(n) - ay;
                double rth = Math.atan2(ry, rx);
                double ext = Math.sqrt(rx * rx + ry * ry);
                rx = ax + ext * Math.cos(rth + thrad);
                ry = ay + ext * Math.sin(rth + thrad);
                this.g.draw(new Ellipse2D.Double(this.angToX(rx) - this.scale * 0.3, this.angToY(ry) - this.scale * 0.3, this.scale * 0.6, this.scale * 0.6));
            }
        }
        if (this.outlineTemplate) {
            this.g.setColor(new Color(128, 128, 128));
            this.g.setStroke(new BasicStroke(1.0f));
            for (int n = 1; n <= this.oltMol.numBonds(); ++n) {
                int from = this.oltMol.bondFrom(n);
                int to = this.oltMol.bondTo(n);
                this.g.draw(new Line2D.Double(this.angToX(this.oltMol.atomX(from)), this.angToY(this.oltMol.atomY(from)), this.angToX(this.oltMol.atomX(to)), this.angToY(this.oltMol.atomY(to))));
            }
        }
    }

    private void drawCorrections() {
        for (int i = 1; i <= this.mol.numAtoms() - 1; ++i) {
            for (int j = i + 1; j <= this.mol.numAtoms(); ++j) {
                double dy;
                double dx = this.mol.atomX(i) - this.mol.atomX(j);
                if (!(dx * dx + (dy = this.mol.atomY(i) - this.mol.atomY(j)) * dy < 0.04000000000000001)) continue;
                this.g.setColor(Color.RED);
                this.g.setStroke(new BasicStroke(0.5f));
                this.g.draw(new Ellipse2D.Double(this.arrmol.pointCX(i - 1) - this.scale * 0.25, this.arrmol.pointCY(i - 1) - this.scale * 0.25, this.scale * 0.5, this.scale * 0.5));
            }
        }
    }

    public double scale() {
        return this.scale;
    }

    public double angToX(double AX) {
        return (this.offsetX + AX) * this.scale;
    }

    public double angToY(double AY) {
        return (this.offsetY - AY) * this.scale;
    }

    public double xToAng(double PX) {
        return PX / this.scale - this.offsetX;
    }

    public double yToAng(double PY) {
        return -PY / this.scale + this.offsetY;
    }

    public double[] measureText(String str, double fontSize) {
        Font font = new Font("SansSerif", 0, (int)Math.round(fontSize));
        FontMetrics fm = this.g.getFontMetrics(font);
        return new double[]{fm.stringWidth(str), (double)fm.getAscent() * 0.8, fm.getDescent()};
    }

    private Ellipse2D circle(double x, double y, double radius) {
        double newX = x - radius;
        double newY = y - radius;
        double diam = 2.0 * radius;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(newX, newY, diam, diam);
        return ellipse;
    }
}

