// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See function_pointers_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2015-2025 The Khronos Group Inc.
 * Copyright (c) 2015-2025 Valve Corporation
 * Copyright (c) 2015-2025 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN
// clang-format off

#include "vk_function_pointers.h"
#include <cassert>
#include <cstdio>
#include <cstdlib>
#include <functional>
#include <string>
#include "containers/custom_containers.h"

#ifdef _WIN32
// Dynamic Loading:
typedef HMODULE dl_handle;
static dl_handle open_library(const char *lib_path) {
    // Try loading the library the original way first.
    dl_handle lib_handle = LoadLibrary(lib_path);
    if (lib_handle == NULL && GetLastError() == ERROR_MOD_NOT_FOUND) {
        // If that failed, then try loading it with broader search folders.
        lib_handle = LoadLibraryEx(lib_path, NULL, LOAD_LIBRARY_SEARCH_DEFAULT_DIRS | LOAD_LIBRARY_SEARCH_DLL_LOAD_DIR);
    }
    return lib_handle;
}
static char *open_library_error(const char *libPath) {
    static char errorMsg[164];
    (void)snprintf(errorMsg, 163, "Failed to open dynamic library \"%s\" with error %lu", libPath, GetLastError());
    return errorMsg;
}
static void *get_proc_address(dl_handle library, const char *name) {
    assert(library);
    assert(name);
    return (void *)GetProcAddress(library, name);
}
#elif defined(__linux__) || defined(__APPLE__) || defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__QNX__) || defined(__GNU__)

#include <dlfcn.h>

typedef void *dl_handle;
static inline dl_handle open_library(const char *libPath) {
    // When loading the library, we use RTLD_LAZY so that not all symbols have to be
    // resolved at this time (which improves performance). Note that if not all symbols
    // can be resolved, this could cause crashes later. Use the LD_BIND_NOW environment
    // variable to force all symbols to be resolved here.
    return dlopen(libPath, RTLD_LAZY | RTLD_LOCAL);
}
static inline const char *open_library_error(const char * /*libPath*/) { return dlerror(); }
static inline void *get_proc_address(dl_handle library, const char *name) {
    assert(library);
    assert(name);
    return dlsym(library, name);
}
#else
#error Dynamic library functions must be defined for this OS.
#endif

namespace vk {
PFN_vkCreateInstance CreateInstance;
PFN_vkDestroyInstance DestroyInstance;
PFN_vkEnumeratePhysicalDevices EnumeratePhysicalDevices;
PFN_vkGetPhysicalDeviceFeatures GetPhysicalDeviceFeatures;
PFN_vkGetPhysicalDeviceFormatProperties GetPhysicalDeviceFormatProperties;
PFN_vkGetPhysicalDeviceImageFormatProperties GetPhysicalDeviceImageFormatProperties;
PFN_vkGetPhysicalDeviceProperties GetPhysicalDeviceProperties;
PFN_vkGetPhysicalDeviceQueueFamilyProperties GetPhysicalDeviceQueueFamilyProperties;
PFN_vkGetPhysicalDeviceMemoryProperties GetPhysicalDeviceMemoryProperties;
PFN_vkGetInstanceProcAddr GetInstanceProcAddr;
PFN_vkGetDeviceProcAddr GetDeviceProcAddr;
PFN_vkCreateDevice CreateDevice;
PFN_vkDestroyDevice DestroyDevice;
PFN_vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties;
PFN_vkEnumerateDeviceExtensionProperties EnumerateDeviceExtensionProperties;
PFN_vkEnumerateInstanceLayerProperties EnumerateInstanceLayerProperties;
PFN_vkEnumerateDeviceLayerProperties EnumerateDeviceLayerProperties;
PFN_vkGetDeviceQueue GetDeviceQueue;
PFN_vkQueueSubmit QueueSubmit;
PFN_vkQueueWaitIdle QueueWaitIdle;
PFN_vkDeviceWaitIdle DeviceWaitIdle;
PFN_vkAllocateMemory AllocateMemory;
PFN_vkFreeMemory FreeMemory;
PFN_vkMapMemory MapMemory;
PFN_vkUnmapMemory UnmapMemory;
PFN_vkFlushMappedMemoryRanges FlushMappedMemoryRanges;
PFN_vkInvalidateMappedMemoryRanges InvalidateMappedMemoryRanges;
PFN_vkGetDeviceMemoryCommitment GetDeviceMemoryCommitment;
PFN_vkBindBufferMemory BindBufferMemory;
PFN_vkBindImageMemory BindImageMemory;
PFN_vkGetBufferMemoryRequirements GetBufferMemoryRequirements;
PFN_vkGetImageMemoryRequirements GetImageMemoryRequirements;
PFN_vkGetImageSparseMemoryRequirements GetImageSparseMemoryRequirements;
PFN_vkGetPhysicalDeviceSparseImageFormatProperties GetPhysicalDeviceSparseImageFormatProperties;
PFN_vkQueueBindSparse QueueBindSparse;
PFN_vkCreateFence CreateFence;
PFN_vkDestroyFence DestroyFence;
PFN_vkResetFences ResetFences;
PFN_vkGetFenceStatus GetFenceStatus;
PFN_vkWaitForFences WaitForFences;
PFN_vkCreateSemaphore CreateSemaphore;
PFN_vkDestroySemaphore DestroySemaphore;
PFN_vkCreateQueryPool CreateQueryPool;
PFN_vkDestroyQueryPool DestroyQueryPool;
PFN_vkGetQueryPoolResults GetQueryPoolResults;
PFN_vkCreateBuffer CreateBuffer;
PFN_vkDestroyBuffer DestroyBuffer;
PFN_vkCreateImage CreateImage;
PFN_vkDestroyImage DestroyImage;
PFN_vkGetImageSubresourceLayout GetImageSubresourceLayout;
PFN_vkCreateImageView CreateImageView;
PFN_vkDestroyImageView DestroyImageView;
PFN_vkCreateCommandPool CreateCommandPool;
PFN_vkDestroyCommandPool DestroyCommandPool;
PFN_vkResetCommandPool ResetCommandPool;
PFN_vkAllocateCommandBuffers AllocateCommandBuffers;
PFN_vkFreeCommandBuffers FreeCommandBuffers;
PFN_vkBeginCommandBuffer BeginCommandBuffer;
PFN_vkEndCommandBuffer EndCommandBuffer;
PFN_vkResetCommandBuffer ResetCommandBuffer;
PFN_vkCmdCopyBuffer CmdCopyBuffer;
PFN_vkCmdCopyImage CmdCopyImage;
PFN_vkCmdCopyBufferToImage CmdCopyBufferToImage;
PFN_vkCmdCopyImageToBuffer CmdCopyImageToBuffer;
PFN_vkCmdUpdateBuffer CmdUpdateBuffer;
PFN_vkCmdFillBuffer CmdFillBuffer;
PFN_vkCmdPipelineBarrier CmdPipelineBarrier;
PFN_vkCmdBeginQuery CmdBeginQuery;
PFN_vkCmdEndQuery CmdEndQuery;
PFN_vkCmdResetQueryPool CmdResetQueryPool;
PFN_vkCmdWriteTimestamp CmdWriteTimestamp;
PFN_vkCmdCopyQueryPoolResults CmdCopyQueryPoolResults;
PFN_vkCmdExecuteCommands CmdExecuteCommands;
PFN_vkCreateEvent CreateEvent;
PFN_vkDestroyEvent DestroyEvent;
PFN_vkGetEventStatus GetEventStatus;
PFN_vkSetEvent SetEvent;
PFN_vkResetEvent ResetEvent;
PFN_vkCreateBufferView CreateBufferView;
PFN_vkDestroyBufferView DestroyBufferView;
PFN_vkCreateShaderModule CreateShaderModule;
PFN_vkDestroyShaderModule DestroyShaderModule;
PFN_vkCreatePipelineCache CreatePipelineCache;
PFN_vkDestroyPipelineCache DestroyPipelineCache;
PFN_vkGetPipelineCacheData GetPipelineCacheData;
PFN_vkMergePipelineCaches MergePipelineCaches;
PFN_vkCreateComputePipelines CreateComputePipelines;
PFN_vkDestroyPipeline DestroyPipeline;
PFN_vkCreatePipelineLayout CreatePipelineLayout;
PFN_vkDestroyPipelineLayout DestroyPipelineLayout;
PFN_vkCreateSampler CreateSampler;
PFN_vkDestroySampler DestroySampler;
PFN_vkCreateDescriptorSetLayout CreateDescriptorSetLayout;
PFN_vkDestroyDescriptorSetLayout DestroyDescriptorSetLayout;
PFN_vkCreateDescriptorPool CreateDescriptorPool;
PFN_vkDestroyDescriptorPool DestroyDescriptorPool;
PFN_vkResetDescriptorPool ResetDescriptorPool;
PFN_vkAllocateDescriptorSets AllocateDescriptorSets;
PFN_vkFreeDescriptorSets FreeDescriptorSets;
PFN_vkUpdateDescriptorSets UpdateDescriptorSets;
PFN_vkCmdBindPipeline CmdBindPipeline;
PFN_vkCmdBindDescriptorSets CmdBindDescriptorSets;
PFN_vkCmdClearColorImage CmdClearColorImage;
PFN_vkCmdDispatch CmdDispatch;
PFN_vkCmdDispatchIndirect CmdDispatchIndirect;
PFN_vkCmdSetEvent CmdSetEvent;
PFN_vkCmdResetEvent CmdResetEvent;
PFN_vkCmdWaitEvents CmdWaitEvents;
PFN_vkCmdPushConstants CmdPushConstants;
PFN_vkCreateGraphicsPipelines CreateGraphicsPipelines;
PFN_vkCreateFramebuffer CreateFramebuffer;
PFN_vkDestroyFramebuffer DestroyFramebuffer;
PFN_vkCreateRenderPass CreateRenderPass;
PFN_vkDestroyRenderPass DestroyRenderPass;
PFN_vkGetRenderAreaGranularity GetRenderAreaGranularity;
PFN_vkCmdSetViewport CmdSetViewport;
PFN_vkCmdSetScissor CmdSetScissor;
PFN_vkCmdSetLineWidth CmdSetLineWidth;
PFN_vkCmdSetDepthBias CmdSetDepthBias;
PFN_vkCmdSetBlendConstants CmdSetBlendConstants;
PFN_vkCmdSetDepthBounds CmdSetDepthBounds;
PFN_vkCmdSetStencilCompareMask CmdSetStencilCompareMask;
PFN_vkCmdSetStencilWriteMask CmdSetStencilWriteMask;
PFN_vkCmdSetStencilReference CmdSetStencilReference;
PFN_vkCmdBindIndexBuffer CmdBindIndexBuffer;
PFN_vkCmdBindVertexBuffers CmdBindVertexBuffers;
PFN_vkCmdDraw CmdDraw;
PFN_vkCmdDrawIndexed CmdDrawIndexed;
PFN_vkCmdDrawIndirect CmdDrawIndirect;
PFN_vkCmdDrawIndexedIndirect CmdDrawIndexedIndirect;
PFN_vkCmdBlitImage CmdBlitImage;
PFN_vkCmdClearDepthStencilImage CmdClearDepthStencilImage;
PFN_vkCmdClearAttachments CmdClearAttachments;
PFN_vkCmdResolveImage CmdResolveImage;
PFN_vkCmdBeginRenderPass CmdBeginRenderPass;
PFN_vkCmdNextSubpass CmdNextSubpass;
PFN_vkCmdEndRenderPass CmdEndRenderPass;
PFN_vkEnumerateInstanceVersion EnumerateInstanceVersion;
PFN_vkBindBufferMemory2 BindBufferMemory2;
PFN_vkBindImageMemory2 BindImageMemory2;
PFN_vkGetDeviceGroupPeerMemoryFeatures GetDeviceGroupPeerMemoryFeatures;
PFN_vkCmdSetDeviceMask CmdSetDeviceMask;
PFN_vkEnumeratePhysicalDeviceGroups EnumeratePhysicalDeviceGroups;
PFN_vkGetImageMemoryRequirements2 GetImageMemoryRequirements2;
PFN_vkGetBufferMemoryRequirements2 GetBufferMemoryRequirements2;
PFN_vkGetImageSparseMemoryRequirements2 GetImageSparseMemoryRequirements2;
PFN_vkGetPhysicalDeviceFeatures2 GetPhysicalDeviceFeatures2;
PFN_vkGetPhysicalDeviceProperties2 GetPhysicalDeviceProperties2;
PFN_vkGetPhysicalDeviceFormatProperties2 GetPhysicalDeviceFormatProperties2;
PFN_vkGetPhysicalDeviceImageFormatProperties2 GetPhysicalDeviceImageFormatProperties2;
PFN_vkGetPhysicalDeviceQueueFamilyProperties2 GetPhysicalDeviceQueueFamilyProperties2;
PFN_vkGetPhysicalDeviceMemoryProperties2 GetPhysicalDeviceMemoryProperties2;
PFN_vkGetPhysicalDeviceSparseImageFormatProperties2 GetPhysicalDeviceSparseImageFormatProperties2;
PFN_vkTrimCommandPool TrimCommandPool;
PFN_vkGetDeviceQueue2 GetDeviceQueue2;
PFN_vkGetPhysicalDeviceExternalBufferProperties GetPhysicalDeviceExternalBufferProperties;
PFN_vkGetPhysicalDeviceExternalFenceProperties GetPhysicalDeviceExternalFenceProperties;
PFN_vkGetPhysicalDeviceExternalSemaphoreProperties GetPhysicalDeviceExternalSemaphoreProperties;
PFN_vkCmdDispatchBase CmdDispatchBase;
PFN_vkCreateDescriptorUpdateTemplate CreateDescriptorUpdateTemplate;
PFN_vkDestroyDescriptorUpdateTemplate DestroyDescriptorUpdateTemplate;
PFN_vkUpdateDescriptorSetWithTemplate UpdateDescriptorSetWithTemplate;
PFN_vkGetDescriptorSetLayoutSupport GetDescriptorSetLayoutSupport;
PFN_vkCreateSamplerYcbcrConversion CreateSamplerYcbcrConversion;
PFN_vkDestroySamplerYcbcrConversion DestroySamplerYcbcrConversion;
PFN_vkResetQueryPool ResetQueryPool;
PFN_vkGetSemaphoreCounterValue GetSemaphoreCounterValue;
PFN_vkWaitSemaphores WaitSemaphores;
PFN_vkSignalSemaphore SignalSemaphore;
PFN_vkGetBufferDeviceAddress GetBufferDeviceAddress;
PFN_vkGetBufferOpaqueCaptureAddress GetBufferOpaqueCaptureAddress;
PFN_vkGetDeviceMemoryOpaqueCaptureAddress GetDeviceMemoryOpaqueCaptureAddress;
PFN_vkCmdDrawIndirectCount CmdDrawIndirectCount;
PFN_vkCmdDrawIndexedIndirectCount CmdDrawIndexedIndirectCount;
PFN_vkCreateRenderPass2 CreateRenderPass2;
PFN_vkCmdBeginRenderPass2 CmdBeginRenderPass2;
PFN_vkCmdNextSubpass2 CmdNextSubpass2;
PFN_vkCmdEndRenderPass2 CmdEndRenderPass2;
PFN_vkGetPhysicalDeviceToolProperties GetPhysicalDeviceToolProperties;
PFN_vkCreatePrivateDataSlot CreatePrivateDataSlot;
PFN_vkDestroyPrivateDataSlot DestroyPrivateDataSlot;
PFN_vkSetPrivateData SetPrivateData;
PFN_vkGetPrivateData GetPrivateData;
PFN_vkCmdPipelineBarrier2 CmdPipelineBarrier2;
PFN_vkCmdWriteTimestamp2 CmdWriteTimestamp2;
PFN_vkQueueSubmit2 QueueSubmit2;
PFN_vkCmdCopyBuffer2 CmdCopyBuffer2;
PFN_vkCmdCopyImage2 CmdCopyImage2;
PFN_vkCmdCopyBufferToImage2 CmdCopyBufferToImage2;
PFN_vkCmdCopyImageToBuffer2 CmdCopyImageToBuffer2;
PFN_vkGetDeviceBufferMemoryRequirements GetDeviceBufferMemoryRequirements;
PFN_vkGetDeviceImageMemoryRequirements GetDeviceImageMemoryRequirements;
PFN_vkGetDeviceImageSparseMemoryRequirements GetDeviceImageSparseMemoryRequirements;
PFN_vkCmdSetEvent2 CmdSetEvent2;
PFN_vkCmdResetEvent2 CmdResetEvent2;
PFN_vkCmdWaitEvents2 CmdWaitEvents2;
PFN_vkCmdBlitImage2 CmdBlitImage2;
PFN_vkCmdResolveImage2 CmdResolveImage2;
PFN_vkCmdBeginRendering CmdBeginRendering;
PFN_vkCmdEndRendering CmdEndRendering;
PFN_vkCmdSetCullMode CmdSetCullMode;
PFN_vkCmdSetFrontFace CmdSetFrontFace;
PFN_vkCmdSetPrimitiveTopology CmdSetPrimitiveTopology;
PFN_vkCmdSetViewportWithCount CmdSetViewportWithCount;
PFN_vkCmdSetScissorWithCount CmdSetScissorWithCount;
PFN_vkCmdBindVertexBuffers2 CmdBindVertexBuffers2;
PFN_vkCmdSetDepthTestEnable CmdSetDepthTestEnable;
PFN_vkCmdSetDepthWriteEnable CmdSetDepthWriteEnable;
PFN_vkCmdSetDepthCompareOp CmdSetDepthCompareOp;
PFN_vkCmdSetDepthBoundsTestEnable CmdSetDepthBoundsTestEnable;
PFN_vkCmdSetStencilTestEnable CmdSetStencilTestEnable;
PFN_vkCmdSetStencilOp CmdSetStencilOp;
PFN_vkCmdSetRasterizerDiscardEnable CmdSetRasterizerDiscardEnable;
PFN_vkCmdSetDepthBiasEnable CmdSetDepthBiasEnable;
PFN_vkCmdSetPrimitiveRestartEnable CmdSetPrimitiveRestartEnable;
PFN_vkMapMemory2 MapMemory2;
PFN_vkUnmapMemory2 UnmapMemory2;
PFN_vkGetDeviceImageSubresourceLayout GetDeviceImageSubresourceLayout;
PFN_vkGetImageSubresourceLayout2 GetImageSubresourceLayout2;
PFN_vkCopyMemoryToImage CopyMemoryToImage;
PFN_vkCopyImageToMemory CopyImageToMemory;
PFN_vkCopyImageToImage CopyImageToImage;
PFN_vkTransitionImageLayout TransitionImageLayout;
PFN_vkCmdPushDescriptorSet CmdPushDescriptorSet;
PFN_vkCmdPushDescriptorSetWithTemplate CmdPushDescriptorSetWithTemplate;
PFN_vkCmdBindDescriptorSets2 CmdBindDescriptorSets2;
PFN_vkCmdPushConstants2 CmdPushConstants2;
PFN_vkCmdPushDescriptorSet2 CmdPushDescriptorSet2;
PFN_vkCmdPushDescriptorSetWithTemplate2 CmdPushDescriptorSetWithTemplate2;
PFN_vkCmdSetLineStipple CmdSetLineStipple;
PFN_vkCmdBindIndexBuffer2 CmdBindIndexBuffer2;
PFN_vkGetRenderingAreaGranularity GetRenderingAreaGranularity;
PFN_vkCmdSetRenderingAttachmentLocations CmdSetRenderingAttachmentLocations;
PFN_vkCmdSetRenderingInputAttachmentIndices CmdSetRenderingInputAttachmentIndices;
PFN_vkDestroySurfaceKHR DestroySurfaceKHR;
PFN_vkGetPhysicalDeviceSurfaceSupportKHR GetPhysicalDeviceSurfaceSupportKHR;
PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR GetPhysicalDeviceSurfaceCapabilitiesKHR;
PFN_vkGetPhysicalDeviceSurfaceFormatsKHR GetPhysicalDeviceSurfaceFormatsKHR;
PFN_vkGetPhysicalDeviceSurfacePresentModesKHR GetPhysicalDeviceSurfacePresentModesKHR;
PFN_vkCreateSwapchainKHR CreateSwapchainKHR;
PFN_vkDestroySwapchainKHR DestroySwapchainKHR;
PFN_vkGetSwapchainImagesKHR GetSwapchainImagesKHR;
PFN_vkAcquireNextImageKHR AcquireNextImageKHR;
PFN_vkQueuePresentKHR QueuePresentKHR;
PFN_vkGetDeviceGroupPresentCapabilitiesKHR GetDeviceGroupPresentCapabilitiesKHR;
PFN_vkGetDeviceGroupSurfacePresentModesKHR GetDeviceGroupSurfacePresentModesKHR;
PFN_vkGetPhysicalDevicePresentRectanglesKHR GetPhysicalDevicePresentRectanglesKHR;
PFN_vkAcquireNextImage2KHR AcquireNextImage2KHR;
PFN_vkGetPhysicalDeviceDisplayPropertiesKHR GetPhysicalDeviceDisplayPropertiesKHR;
PFN_vkGetPhysicalDeviceDisplayPlanePropertiesKHR GetPhysicalDeviceDisplayPlanePropertiesKHR;
PFN_vkGetDisplayPlaneSupportedDisplaysKHR GetDisplayPlaneSupportedDisplaysKHR;
PFN_vkGetDisplayModePropertiesKHR GetDisplayModePropertiesKHR;
PFN_vkCreateDisplayModeKHR CreateDisplayModeKHR;
PFN_vkGetDisplayPlaneCapabilitiesKHR GetDisplayPlaneCapabilitiesKHR;
PFN_vkCreateDisplayPlaneSurfaceKHR CreateDisplayPlaneSurfaceKHR;
PFN_vkCreateSharedSwapchainsKHR CreateSharedSwapchainsKHR;
#ifdef VK_USE_PLATFORM_XLIB_KHR
PFN_vkCreateXlibSurfaceKHR CreateXlibSurfaceKHR;
PFN_vkGetPhysicalDeviceXlibPresentationSupportKHR GetPhysicalDeviceXlibPresentationSupportKHR;
#endif  // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
PFN_vkCreateXcbSurfaceKHR CreateXcbSurfaceKHR;
PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR GetPhysicalDeviceXcbPresentationSupportKHR;
#endif  // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
PFN_vkCreateWaylandSurfaceKHR CreateWaylandSurfaceKHR;
PFN_vkGetPhysicalDeviceWaylandPresentationSupportKHR GetPhysicalDeviceWaylandPresentationSupportKHR;
#endif  // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
PFN_vkCreateAndroidSurfaceKHR CreateAndroidSurfaceKHR;
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
PFN_vkCreateWin32SurfaceKHR CreateWin32SurfaceKHR;
PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR GetPhysicalDeviceWin32PresentationSupportKHR;
#endif  // VK_USE_PLATFORM_WIN32_KHR
PFN_vkGetPhysicalDeviceVideoCapabilitiesKHR GetPhysicalDeviceVideoCapabilitiesKHR;
PFN_vkGetPhysicalDeviceVideoFormatPropertiesKHR GetPhysicalDeviceVideoFormatPropertiesKHR;
PFN_vkCreateVideoSessionKHR CreateVideoSessionKHR;
PFN_vkDestroyVideoSessionKHR DestroyVideoSessionKHR;
PFN_vkGetVideoSessionMemoryRequirementsKHR GetVideoSessionMemoryRequirementsKHR;
PFN_vkBindVideoSessionMemoryKHR BindVideoSessionMemoryKHR;
PFN_vkCreateVideoSessionParametersKHR CreateVideoSessionParametersKHR;
PFN_vkUpdateVideoSessionParametersKHR UpdateVideoSessionParametersKHR;
PFN_vkDestroyVideoSessionParametersKHR DestroyVideoSessionParametersKHR;
PFN_vkCmdBeginVideoCodingKHR CmdBeginVideoCodingKHR;
PFN_vkCmdEndVideoCodingKHR CmdEndVideoCodingKHR;
PFN_vkCmdControlVideoCodingKHR CmdControlVideoCodingKHR;
PFN_vkCmdDecodeVideoKHR CmdDecodeVideoKHR;
PFN_vkCmdBeginRenderingKHR CmdBeginRenderingKHR;
PFN_vkCmdEndRenderingKHR CmdEndRenderingKHR;
PFN_vkGetPhysicalDeviceFeatures2KHR GetPhysicalDeviceFeatures2KHR;
PFN_vkGetPhysicalDeviceProperties2KHR GetPhysicalDeviceProperties2KHR;
PFN_vkGetPhysicalDeviceFormatProperties2KHR GetPhysicalDeviceFormatProperties2KHR;
PFN_vkGetPhysicalDeviceImageFormatProperties2KHR GetPhysicalDeviceImageFormatProperties2KHR;
PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR GetPhysicalDeviceQueueFamilyProperties2KHR;
PFN_vkGetPhysicalDeviceMemoryProperties2KHR GetPhysicalDeviceMemoryProperties2KHR;
PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR GetPhysicalDeviceSparseImageFormatProperties2KHR;
PFN_vkGetDeviceGroupPeerMemoryFeaturesKHR GetDeviceGroupPeerMemoryFeaturesKHR;
PFN_vkCmdSetDeviceMaskKHR CmdSetDeviceMaskKHR;
PFN_vkCmdDispatchBaseKHR CmdDispatchBaseKHR;
PFN_vkTrimCommandPoolKHR TrimCommandPoolKHR;
PFN_vkEnumeratePhysicalDeviceGroupsKHR EnumeratePhysicalDeviceGroupsKHR;
PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR GetPhysicalDeviceExternalBufferPropertiesKHR;
#ifdef VK_USE_PLATFORM_WIN32_KHR
PFN_vkGetMemoryWin32HandleKHR GetMemoryWin32HandleKHR;
PFN_vkGetMemoryWin32HandlePropertiesKHR GetMemoryWin32HandlePropertiesKHR;
#endif  // VK_USE_PLATFORM_WIN32_KHR
PFN_vkGetMemoryFdKHR GetMemoryFdKHR;
PFN_vkGetMemoryFdPropertiesKHR GetMemoryFdPropertiesKHR;
PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR GetPhysicalDeviceExternalSemaphorePropertiesKHR;
#ifdef VK_USE_PLATFORM_WIN32_KHR
PFN_vkImportSemaphoreWin32HandleKHR ImportSemaphoreWin32HandleKHR;
PFN_vkGetSemaphoreWin32HandleKHR GetSemaphoreWin32HandleKHR;
#endif  // VK_USE_PLATFORM_WIN32_KHR
PFN_vkImportSemaphoreFdKHR ImportSemaphoreFdKHR;
PFN_vkGetSemaphoreFdKHR GetSemaphoreFdKHR;
PFN_vkCmdPushDescriptorSetKHR CmdPushDescriptorSetKHR;
PFN_vkCmdPushDescriptorSetWithTemplateKHR CmdPushDescriptorSetWithTemplateKHR;
PFN_vkCreateDescriptorUpdateTemplateKHR CreateDescriptorUpdateTemplateKHR;
PFN_vkDestroyDescriptorUpdateTemplateKHR DestroyDescriptorUpdateTemplateKHR;
PFN_vkUpdateDescriptorSetWithTemplateKHR UpdateDescriptorSetWithTemplateKHR;
PFN_vkCreateRenderPass2KHR CreateRenderPass2KHR;
PFN_vkCmdBeginRenderPass2KHR CmdBeginRenderPass2KHR;
PFN_vkCmdNextSubpass2KHR CmdNextSubpass2KHR;
PFN_vkCmdEndRenderPass2KHR CmdEndRenderPass2KHR;
PFN_vkGetSwapchainStatusKHR GetSwapchainStatusKHR;
PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR GetPhysicalDeviceExternalFencePropertiesKHR;
#ifdef VK_USE_PLATFORM_WIN32_KHR
PFN_vkImportFenceWin32HandleKHR ImportFenceWin32HandleKHR;
PFN_vkGetFenceWin32HandleKHR GetFenceWin32HandleKHR;
#endif  // VK_USE_PLATFORM_WIN32_KHR
PFN_vkImportFenceFdKHR ImportFenceFdKHR;
PFN_vkGetFenceFdKHR GetFenceFdKHR;
PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR;
PFN_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR;
PFN_vkAcquireProfilingLockKHR AcquireProfilingLockKHR;
PFN_vkReleaseProfilingLockKHR ReleaseProfilingLockKHR;
PFN_vkGetPhysicalDeviceSurfaceCapabilities2KHR GetPhysicalDeviceSurfaceCapabilities2KHR;
PFN_vkGetPhysicalDeviceSurfaceFormats2KHR GetPhysicalDeviceSurfaceFormats2KHR;
PFN_vkGetPhysicalDeviceDisplayProperties2KHR GetPhysicalDeviceDisplayProperties2KHR;
PFN_vkGetPhysicalDeviceDisplayPlaneProperties2KHR GetPhysicalDeviceDisplayPlaneProperties2KHR;
PFN_vkGetDisplayModeProperties2KHR GetDisplayModeProperties2KHR;
PFN_vkGetDisplayPlaneCapabilities2KHR GetDisplayPlaneCapabilities2KHR;
PFN_vkGetImageMemoryRequirements2KHR GetImageMemoryRequirements2KHR;
PFN_vkGetBufferMemoryRequirements2KHR GetBufferMemoryRequirements2KHR;
PFN_vkGetImageSparseMemoryRequirements2KHR GetImageSparseMemoryRequirements2KHR;
PFN_vkCreateSamplerYcbcrConversionKHR CreateSamplerYcbcrConversionKHR;
PFN_vkDestroySamplerYcbcrConversionKHR DestroySamplerYcbcrConversionKHR;
PFN_vkBindBufferMemory2KHR BindBufferMemory2KHR;
PFN_vkBindImageMemory2KHR BindImageMemory2KHR;
PFN_vkGetDescriptorSetLayoutSupportKHR GetDescriptorSetLayoutSupportKHR;
PFN_vkCmdDrawIndirectCountKHR CmdDrawIndirectCountKHR;
PFN_vkCmdDrawIndexedIndirectCountKHR CmdDrawIndexedIndirectCountKHR;
PFN_vkGetSemaphoreCounterValueKHR GetSemaphoreCounterValueKHR;
PFN_vkWaitSemaphoresKHR WaitSemaphoresKHR;
PFN_vkSignalSemaphoreKHR SignalSemaphoreKHR;
PFN_vkGetPhysicalDeviceFragmentShadingRatesKHR GetPhysicalDeviceFragmentShadingRatesKHR;
PFN_vkCmdSetFragmentShadingRateKHR CmdSetFragmentShadingRateKHR;
PFN_vkCmdSetRenderingAttachmentLocationsKHR CmdSetRenderingAttachmentLocationsKHR;
PFN_vkCmdSetRenderingInputAttachmentIndicesKHR CmdSetRenderingInputAttachmentIndicesKHR;
PFN_vkWaitForPresentKHR WaitForPresentKHR;
PFN_vkGetBufferDeviceAddressKHR GetBufferDeviceAddressKHR;
PFN_vkGetBufferOpaqueCaptureAddressKHR GetBufferOpaqueCaptureAddressKHR;
PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR GetDeviceMemoryOpaqueCaptureAddressKHR;
PFN_vkCreateDeferredOperationKHR CreateDeferredOperationKHR;
PFN_vkDestroyDeferredOperationKHR DestroyDeferredOperationKHR;
PFN_vkGetDeferredOperationMaxConcurrencyKHR GetDeferredOperationMaxConcurrencyKHR;
PFN_vkGetDeferredOperationResultKHR GetDeferredOperationResultKHR;
PFN_vkDeferredOperationJoinKHR DeferredOperationJoinKHR;
PFN_vkGetPipelineExecutablePropertiesKHR GetPipelineExecutablePropertiesKHR;
PFN_vkGetPipelineExecutableStatisticsKHR GetPipelineExecutableStatisticsKHR;
PFN_vkGetPipelineExecutableInternalRepresentationsKHR GetPipelineExecutableInternalRepresentationsKHR;
PFN_vkMapMemory2KHR MapMemory2KHR;
PFN_vkUnmapMemory2KHR UnmapMemory2KHR;
PFN_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR;
PFN_vkGetEncodedVideoSessionParametersKHR GetEncodedVideoSessionParametersKHR;
PFN_vkCmdEncodeVideoKHR CmdEncodeVideoKHR;
PFN_vkCmdSetEvent2KHR CmdSetEvent2KHR;
PFN_vkCmdResetEvent2KHR CmdResetEvent2KHR;
PFN_vkCmdWaitEvents2KHR CmdWaitEvents2KHR;
PFN_vkCmdPipelineBarrier2KHR CmdPipelineBarrier2KHR;
PFN_vkCmdWriteTimestamp2KHR CmdWriteTimestamp2KHR;
PFN_vkQueueSubmit2KHR QueueSubmit2KHR;
PFN_vkCmdCopyBuffer2KHR CmdCopyBuffer2KHR;
PFN_vkCmdCopyImage2KHR CmdCopyImage2KHR;
PFN_vkCmdCopyBufferToImage2KHR CmdCopyBufferToImage2KHR;
PFN_vkCmdCopyImageToBuffer2KHR CmdCopyImageToBuffer2KHR;
PFN_vkCmdBlitImage2KHR CmdBlitImage2KHR;
PFN_vkCmdResolveImage2KHR CmdResolveImage2KHR;
PFN_vkCmdTraceRaysIndirect2KHR CmdTraceRaysIndirect2KHR;
PFN_vkGetDeviceBufferMemoryRequirementsKHR GetDeviceBufferMemoryRequirementsKHR;
PFN_vkGetDeviceImageMemoryRequirementsKHR GetDeviceImageMemoryRequirementsKHR;
PFN_vkGetDeviceImageSparseMemoryRequirementsKHR GetDeviceImageSparseMemoryRequirementsKHR;
PFN_vkCmdBindIndexBuffer2KHR CmdBindIndexBuffer2KHR;
PFN_vkGetRenderingAreaGranularityKHR GetRenderingAreaGranularityKHR;
PFN_vkGetDeviceImageSubresourceLayoutKHR GetDeviceImageSubresourceLayoutKHR;
PFN_vkGetImageSubresourceLayout2KHR GetImageSubresourceLayout2KHR;
PFN_vkWaitForPresent2KHR WaitForPresent2KHR;
PFN_vkCreatePipelineBinariesKHR CreatePipelineBinariesKHR;
PFN_vkDestroyPipelineBinaryKHR DestroyPipelineBinaryKHR;
PFN_vkGetPipelineKeyKHR GetPipelineKeyKHR;
PFN_vkGetPipelineBinaryDataKHR GetPipelineBinaryDataKHR;
PFN_vkReleaseCapturedPipelineDataKHR ReleaseCapturedPipelineDataKHR;
PFN_vkReleaseSwapchainImagesKHR ReleaseSwapchainImagesKHR;
PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR GetPhysicalDeviceCooperativeMatrixPropertiesKHR;
PFN_vkCmdSetLineStippleKHR CmdSetLineStippleKHR;
PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR GetPhysicalDeviceCalibrateableTimeDomainsKHR;
PFN_vkGetCalibratedTimestampsKHR GetCalibratedTimestampsKHR;
PFN_vkCmdBindDescriptorSets2KHR CmdBindDescriptorSets2KHR;
PFN_vkCmdPushConstants2KHR CmdPushConstants2KHR;
PFN_vkCmdPushDescriptorSet2KHR CmdPushDescriptorSet2KHR;
PFN_vkCmdPushDescriptorSetWithTemplate2KHR CmdPushDescriptorSetWithTemplate2KHR;
PFN_vkCmdSetDescriptorBufferOffsets2EXT CmdSetDescriptorBufferOffsets2EXT;
PFN_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT CmdBindDescriptorBufferEmbeddedSamplers2EXT;
PFN_vkCmdCopyMemoryIndirectKHR CmdCopyMemoryIndirectKHR;
PFN_vkCmdCopyMemoryToImageIndirectKHR CmdCopyMemoryToImageIndirectKHR;
PFN_vkCmdEndRendering2KHR CmdEndRendering2KHR;
PFN_vkCreateDebugReportCallbackEXT CreateDebugReportCallbackEXT;
PFN_vkDestroyDebugReportCallbackEXT DestroyDebugReportCallbackEXT;
PFN_vkDebugReportMessageEXT DebugReportMessageEXT;
PFN_vkDebugMarkerSetObjectTagEXT DebugMarkerSetObjectTagEXT;
PFN_vkDebugMarkerSetObjectNameEXT DebugMarkerSetObjectNameEXT;
PFN_vkCmdDebugMarkerBeginEXT CmdDebugMarkerBeginEXT;
PFN_vkCmdDebugMarkerEndEXT CmdDebugMarkerEndEXT;
PFN_vkCmdDebugMarkerInsertEXT CmdDebugMarkerInsertEXT;
PFN_vkCmdBindTransformFeedbackBuffersEXT CmdBindTransformFeedbackBuffersEXT;
PFN_vkCmdBeginTransformFeedbackEXT CmdBeginTransformFeedbackEXT;
PFN_vkCmdEndTransformFeedbackEXT CmdEndTransformFeedbackEXT;
PFN_vkCmdBeginQueryIndexedEXT CmdBeginQueryIndexedEXT;
PFN_vkCmdEndQueryIndexedEXT CmdEndQueryIndexedEXT;
PFN_vkCmdDrawIndirectByteCountEXT CmdDrawIndirectByteCountEXT;
PFN_vkCreateCuModuleNVX CreateCuModuleNVX;
PFN_vkCreateCuFunctionNVX CreateCuFunctionNVX;
PFN_vkDestroyCuModuleNVX DestroyCuModuleNVX;
PFN_vkDestroyCuFunctionNVX DestroyCuFunctionNVX;
PFN_vkCmdCuLaunchKernelNVX CmdCuLaunchKernelNVX;
PFN_vkGetImageViewHandleNVX GetImageViewHandleNVX;
PFN_vkGetImageViewHandle64NVX GetImageViewHandle64NVX;
PFN_vkGetImageViewAddressNVX GetImageViewAddressNVX;
PFN_vkCmdDrawIndirectCountAMD CmdDrawIndirectCountAMD;
PFN_vkCmdDrawIndexedIndirectCountAMD CmdDrawIndexedIndirectCountAMD;
PFN_vkGetShaderInfoAMD GetShaderInfoAMD;
#ifdef VK_USE_PLATFORM_GGP
PFN_vkCreateStreamDescriptorSurfaceGGP CreateStreamDescriptorSurfaceGGP;
#endif  // VK_USE_PLATFORM_GGP
PFN_vkGetPhysicalDeviceExternalImageFormatPropertiesNV GetPhysicalDeviceExternalImageFormatPropertiesNV;
#ifdef VK_USE_PLATFORM_WIN32_KHR
PFN_vkGetMemoryWin32HandleNV GetMemoryWin32HandleNV;
#endif  // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_VI_NN
PFN_vkCreateViSurfaceNN CreateViSurfaceNN;
#endif  // VK_USE_PLATFORM_VI_NN
PFN_vkCmdBeginConditionalRenderingEXT CmdBeginConditionalRenderingEXT;
PFN_vkCmdEndConditionalRenderingEXT CmdEndConditionalRenderingEXT;
PFN_vkCmdSetViewportWScalingNV CmdSetViewportWScalingNV;
PFN_vkReleaseDisplayEXT ReleaseDisplayEXT;
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
PFN_vkAcquireXlibDisplayEXT AcquireXlibDisplayEXT;
PFN_vkGetRandROutputDisplayEXT GetRandROutputDisplayEXT;
#endif  // VK_USE_PLATFORM_XLIB_XRANDR_EXT
PFN_vkGetPhysicalDeviceSurfaceCapabilities2EXT GetPhysicalDeviceSurfaceCapabilities2EXT;
PFN_vkDisplayPowerControlEXT DisplayPowerControlEXT;
PFN_vkRegisterDeviceEventEXT RegisterDeviceEventEXT;
PFN_vkRegisterDisplayEventEXT RegisterDisplayEventEXT;
PFN_vkGetSwapchainCounterEXT GetSwapchainCounterEXT;
PFN_vkGetRefreshCycleDurationGOOGLE GetRefreshCycleDurationGOOGLE;
PFN_vkGetPastPresentationTimingGOOGLE GetPastPresentationTimingGOOGLE;
PFN_vkCmdSetDiscardRectangleEXT CmdSetDiscardRectangleEXT;
PFN_vkCmdSetDiscardRectangleEnableEXT CmdSetDiscardRectangleEnableEXT;
PFN_vkCmdSetDiscardRectangleModeEXT CmdSetDiscardRectangleModeEXT;
PFN_vkSetHdrMetadataEXT SetHdrMetadataEXT;
#ifdef VK_USE_PLATFORM_IOS_MVK
PFN_vkCreateIOSSurfaceMVK CreateIOSSurfaceMVK;
#endif  // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
PFN_vkCreateMacOSSurfaceMVK CreateMacOSSurfaceMVK;
#endif  // VK_USE_PLATFORM_MACOS_MVK
PFN_vkSetDebugUtilsObjectNameEXT SetDebugUtilsObjectNameEXT;
PFN_vkSetDebugUtilsObjectTagEXT SetDebugUtilsObjectTagEXT;
PFN_vkQueueBeginDebugUtilsLabelEXT QueueBeginDebugUtilsLabelEXT;
PFN_vkQueueEndDebugUtilsLabelEXT QueueEndDebugUtilsLabelEXT;
PFN_vkQueueInsertDebugUtilsLabelEXT QueueInsertDebugUtilsLabelEXT;
PFN_vkCmdBeginDebugUtilsLabelEXT CmdBeginDebugUtilsLabelEXT;
PFN_vkCmdEndDebugUtilsLabelEXT CmdEndDebugUtilsLabelEXT;
PFN_vkCmdInsertDebugUtilsLabelEXT CmdInsertDebugUtilsLabelEXT;
PFN_vkCreateDebugUtilsMessengerEXT CreateDebugUtilsMessengerEXT;
PFN_vkDestroyDebugUtilsMessengerEXT DestroyDebugUtilsMessengerEXT;
PFN_vkSubmitDebugUtilsMessageEXT SubmitDebugUtilsMessageEXT;
#ifdef VK_USE_PLATFORM_ANDROID_KHR
PFN_vkGetAndroidHardwareBufferPropertiesANDROID GetAndroidHardwareBufferPropertiesANDROID;
PFN_vkGetMemoryAndroidHardwareBufferANDROID GetMemoryAndroidHardwareBufferANDROID;
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_ENABLE_BETA_EXTENSIONS
PFN_vkCreateExecutionGraphPipelinesAMDX CreateExecutionGraphPipelinesAMDX;
PFN_vkGetExecutionGraphPipelineScratchSizeAMDX GetExecutionGraphPipelineScratchSizeAMDX;
PFN_vkGetExecutionGraphPipelineNodeIndexAMDX GetExecutionGraphPipelineNodeIndexAMDX;
PFN_vkCmdInitializeGraphScratchMemoryAMDX CmdInitializeGraphScratchMemoryAMDX;
PFN_vkCmdDispatchGraphAMDX CmdDispatchGraphAMDX;
PFN_vkCmdDispatchGraphIndirectAMDX CmdDispatchGraphIndirectAMDX;
PFN_vkCmdDispatchGraphIndirectCountAMDX CmdDispatchGraphIndirectCountAMDX;
#endif  // VK_ENABLE_BETA_EXTENSIONS
PFN_vkCmdSetSampleLocationsEXT CmdSetSampleLocationsEXT;
PFN_vkGetPhysicalDeviceMultisamplePropertiesEXT GetPhysicalDeviceMultisamplePropertiesEXT;
PFN_vkGetImageDrmFormatModifierPropertiesEXT GetImageDrmFormatModifierPropertiesEXT;
PFN_vkCreateValidationCacheEXT CreateValidationCacheEXT;
PFN_vkDestroyValidationCacheEXT DestroyValidationCacheEXT;
PFN_vkMergeValidationCachesEXT MergeValidationCachesEXT;
PFN_vkGetValidationCacheDataEXT GetValidationCacheDataEXT;
PFN_vkCmdBindShadingRateImageNV CmdBindShadingRateImageNV;
PFN_vkCmdSetViewportShadingRatePaletteNV CmdSetViewportShadingRatePaletteNV;
PFN_vkCmdSetCoarseSampleOrderNV CmdSetCoarseSampleOrderNV;
PFN_vkCreateAccelerationStructureNV CreateAccelerationStructureNV;
PFN_vkDestroyAccelerationStructureNV DestroyAccelerationStructureNV;
PFN_vkGetAccelerationStructureMemoryRequirementsNV GetAccelerationStructureMemoryRequirementsNV;
PFN_vkBindAccelerationStructureMemoryNV BindAccelerationStructureMemoryNV;
PFN_vkCmdBuildAccelerationStructureNV CmdBuildAccelerationStructureNV;
PFN_vkCmdCopyAccelerationStructureNV CmdCopyAccelerationStructureNV;
PFN_vkCmdTraceRaysNV CmdTraceRaysNV;
PFN_vkCreateRayTracingPipelinesNV CreateRayTracingPipelinesNV;
PFN_vkGetRayTracingShaderGroupHandlesKHR GetRayTracingShaderGroupHandlesKHR;
PFN_vkGetRayTracingShaderGroupHandlesNV GetRayTracingShaderGroupHandlesNV;
PFN_vkGetAccelerationStructureHandleNV GetAccelerationStructureHandleNV;
PFN_vkCmdWriteAccelerationStructuresPropertiesNV CmdWriteAccelerationStructuresPropertiesNV;
PFN_vkCompileDeferredNV CompileDeferredNV;
PFN_vkGetMemoryHostPointerPropertiesEXT GetMemoryHostPointerPropertiesEXT;
PFN_vkCmdWriteBufferMarkerAMD CmdWriteBufferMarkerAMD;
PFN_vkCmdWriteBufferMarker2AMD CmdWriteBufferMarker2AMD;
PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT GetPhysicalDeviceCalibrateableTimeDomainsEXT;
PFN_vkGetCalibratedTimestampsEXT GetCalibratedTimestampsEXT;
PFN_vkCmdDrawMeshTasksNV CmdDrawMeshTasksNV;
PFN_vkCmdDrawMeshTasksIndirectNV CmdDrawMeshTasksIndirectNV;
PFN_vkCmdDrawMeshTasksIndirectCountNV CmdDrawMeshTasksIndirectCountNV;
PFN_vkCmdSetExclusiveScissorEnableNV CmdSetExclusiveScissorEnableNV;
PFN_vkCmdSetExclusiveScissorNV CmdSetExclusiveScissorNV;
PFN_vkCmdSetCheckpointNV CmdSetCheckpointNV;
PFN_vkGetQueueCheckpointDataNV GetQueueCheckpointDataNV;
PFN_vkGetQueueCheckpointData2NV GetQueueCheckpointData2NV;
PFN_vkSetSwapchainPresentTimingQueueSizeEXT SetSwapchainPresentTimingQueueSizeEXT;
PFN_vkGetSwapchainTimingPropertiesEXT GetSwapchainTimingPropertiesEXT;
PFN_vkGetSwapchainTimeDomainPropertiesEXT GetSwapchainTimeDomainPropertiesEXT;
PFN_vkGetPastPresentationTimingEXT GetPastPresentationTimingEXT;
PFN_vkInitializePerformanceApiINTEL InitializePerformanceApiINTEL;
PFN_vkUninitializePerformanceApiINTEL UninitializePerformanceApiINTEL;
PFN_vkCmdSetPerformanceMarkerINTEL CmdSetPerformanceMarkerINTEL;
PFN_vkCmdSetPerformanceStreamMarkerINTEL CmdSetPerformanceStreamMarkerINTEL;
PFN_vkCmdSetPerformanceOverrideINTEL CmdSetPerformanceOverrideINTEL;
PFN_vkAcquirePerformanceConfigurationINTEL AcquirePerformanceConfigurationINTEL;
PFN_vkReleasePerformanceConfigurationINTEL ReleasePerformanceConfigurationINTEL;
PFN_vkQueueSetPerformanceConfigurationINTEL QueueSetPerformanceConfigurationINTEL;
PFN_vkGetPerformanceParameterINTEL GetPerformanceParameterINTEL;
PFN_vkSetLocalDimmingAMD SetLocalDimmingAMD;
#ifdef VK_USE_PLATFORM_FUCHSIA
PFN_vkCreateImagePipeSurfaceFUCHSIA CreateImagePipeSurfaceFUCHSIA;
#endif  // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_METAL_EXT
PFN_vkCreateMetalSurfaceEXT CreateMetalSurfaceEXT;
#endif  // VK_USE_PLATFORM_METAL_EXT
PFN_vkGetBufferDeviceAddressEXT GetBufferDeviceAddressEXT;
PFN_vkGetPhysicalDeviceToolPropertiesEXT GetPhysicalDeviceToolPropertiesEXT;
PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV GetPhysicalDeviceCooperativeMatrixPropertiesNV;
PFN_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV;
#ifdef VK_USE_PLATFORM_WIN32_KHR
PFN_vkGetPhysicalDeviceSurfacePresentModes2EXT GetPhysicalDeviceSurfacePresentModes2EXT;
PFN_vkAcquireFullScreenExclusiveModeEXT AcquireFullScreenExclusiveModeEXT;
PFN_vkReleaseFullScreenExclusiveModeEXT ReleaseFullScreenExclusiveModeEXT;
PFN_vkGetDeviceGroupSurfacePresentModes2EXT GetDeviceGroupSurfacePresentModes2EXT;
#endif  // VK_USE_PLATFORM_WIN32_KHR
PFN_vkCreateHeadlessSurfaceEXT CreateHeadlessSurfaceEXT;
PFN_vkCmdSetLineStippleEXT CmdSetLineStippleEXT;
PFN_vkResetQueryPoolEXT ResetQueryPoolEXT;
PFN_vkCmdSetCullModeEXT CmdSetCullModeEXT;
PFN_vkCmdSetFrontFaceEXT CmdSetFrontFaceEXT;
PFN_vkCmdSetPrimitiveTopologyEXT CmdSetPrimitiveTopologyEXT;
PFN_vkCmdSetViewportWithCountEXT CmdSetViewportWithCountEXT;
PFN_vkCmdSetScissorWithCountEXT CmdSetScissorWithCountEXT;
PFN_vkCmdBindVertexBuffers2EXT CmdBindVertexBuffers2EXT;
PFN_vkCmdSetDepthTestEnableEXT CmdSetDepthTestEnableEXT;
PFN_vkCmdSetDepthWriteEnableEXT CmdSetDepthWriteEnableEXT;
PFN_vkCmdSetDepthCompareOpEXT CmdSetDepthCompareOpEXT;
PFN_vkCmdSetDepthBoundsTestEnableEXT CmdSetDepthBoundsTestEnableEXT;
PFN_vkCmdSetStencilTestEnableEXT CmdSetStencilTestEnableEXT;
PFN_vkCmdSetStencilOpEXT CmdSetStencilOpEXT;
PFN_vkCopyMemoryToImageEXT CopyMemoryToImageEXT;
PFN_vkCopyImageToMemoryEXT CopyImageToMemoryEXT;
PFN_vkCopyImageToImageEXT CopyImageToImageEXT;
PFN_vkTransitionImageLayoutEXT TransitionImageLayoutEXT;
PFN_vkGetImageSubresourceLayout2EXT GetImageSubresourceLayout2EXT;
PFN_vkReleaseSwapchainImagesEXT ReleaseSwapchainImagesEXT;
PFN_vkGetGeneratedCommandsMemoryRequirementsNV GetGeneratedCommandsMemoryRequirementsNV;
PFN_vkCmdPreprocessGeneratedCommandsNV CmdPreprocessGeneratedCommandsNV;
PFN_vkCmdExecuteGeneratedCommandsNV CmdExecuteGeneratedCommandsNV;
PFN_vkCmdBindPipelineShaderGroupNV CmdBindPipelineShaderGroupNV;
PFN_vkCreateIndirectCommandsLayoutNV CreateIndirectCommandsLayoutNV;
PFN_vkDestroyIndirectCommandsLayoutNV DestroyIndirectCommandsLayoutNV;
PFN_vkCmdSetDepthBias2EXT CmdSetDepthBias2EXT;
PFN_vkAcquireDrmDisplayEXT AcquireDrmDisplayEXT;
PFN_vkGetDrmDisplayEXT GetDrmDisplayEXT;
PFN_vkCreatePrivateDataSlotEXT CreatePrivateDataSlotEXT;
PFN_vkDestroyPrivateDataSlotEXT DestroyPrivateDataSlotEXT;
PFN_vkSetPrivateDataEXT SetPrivateDataEXT;
PFN_vkGetPrivateDataEXT GetPrivateDataEXT;
#ifdef VK_ENABLE_BETA_EXTENSIONS
PFN_vkCreateCudaModuleNV CreateCudaModuleNV;
PFN_vkGetCudaModuleCacheNV GetCudaModuleCacheNV;
PFN_vkCreateCudaFunctionNV CreateCudaFunctionNV;
PFN_vkDestroyCudaModuleNV DestroyCudaModuleNV;
PFN_vkDestroyCudaFunctionNV DestroyCudaFunctionNV;
PFN_vkCmdCudaLaunchKernelNV CmdCudaLaunchKernelNV;
#endif  // VK_ENABLE_BETA_EXTENSIONS
PFN_vkCmdDispatchTileQCOM CmdDispatchTileQCOM;
PFN_vkCmdBeginPerTileExecutionQCOM CmdBeginPerTileExecutionQCOM;
PFN_vkCmdEndPerTileExecutionQCOM CmdEndPerTileExecutionQCOM;
#ifdef VK_USE_PLATFORM_METAL_EXT
PFN_vkExportMetalObjectsEXT ExportMetalObjectsEXT;
#endif  // VK_USE_PLATFORM_METAL_EXT
PFN_vkGetDescriptorSetLayoutSizeEXT GetDescriptorSetLayoutSizeEXT;
PFN_vkGetDescriptorSetLayoutBindingOffsetEXT GetDescriptorSetLayoutBindingOffsetEXT;
PFN_vkGetDescriptorEXT GetDescriptorEXT;
PFN_vkCmdBindDescriptorBuffersEXT CmdBindDescriptorBuffersEXT;
PFN_vkCmdSetDescriptorBufferOffsetsEXT CmdSetDescriptorBufferOffsetsEXT;
PFN_vkCmdBindDescriptorBufferEmbeddedSamplersEXT CmdBindDescriptorBufferEmbeddedSamplersEXT;
PFN_vkGetBufferOpaqueCaptureDescriptorDataEXT GetBufferOpaqueCaptureDescriptorDataEXT;
PFN_vkGetImageOpaqueCaptureDescriptorDataEXT GetImageOpaqueCaptureDescriptorDataEXT;
PFN_vkGetImageViewOpaqueCaptureDescriptorDataEXT GetImageViewOpaqueCaptureDescriptorDataEXT;
PFN_vkGetSamplerOpaqueCaptureDescriptorDataEXT GetSamplerOpaqueCaptureDescriptorDataEXT;
PFN_vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT GetAccelerationStructureOpaqueCaptureDescriptorDataEXT;
PFN_vkCmdSetFragmentShadingRateEnumNV CmdSetFragmentShadingRateEnumNV;
PFN_vkGetDeviceFaultInfoEXT GetDeviceFaultInfoEXT;
#ifdef VK_USE_PLATFORM_WIN32_KHR
PFN_vkAcquireWinrtDisplayNV AcquireWinrtDisplayNV;
PFN_vkGetWinrtDisplayNV GetWinrtDisplayNV;
#endif  // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
PFN_vkCreateDirectFBSurfaceEXT CreateDirectFBSurfaceEXT;
PFN_vkGetPhysicalDeviceDirectFBPresentationSupportEXT GetPhysicalDeviceDirectFBPresentationSupportEXT;
#endif  // VK_USE_PLATFORM_DIRECTFB_EXT
PFN_vkCmdSetVertexInputEXT CmdSetVertexInputEXT;
#ifdef VK_USE_PLATFORM_FUCHSIA
PFN_vkGetMemoryZirconHandleFUCHSIA GetMemoryZirconHandleFUCHSIA;
PFN_vkGetMemoryZirconHandlePropertiesFUCHSIA GetMemoryZirconHandlePropertiesFUCHSIA;
PFN_vkImportSemaphoreZirconHandleFUCHSIA ImportSemaphoreZirconHandleFUCHSIA;
PFN_vkGetSemaphoreZirconHandleFUCHSIA GetSemaphoreZirconHandleFUCHSIA;
PFN_vkCreateBufferCollectionFUCHSIA CreateBufferCollectionFUCHSIA;
PFN_vkSetBufferCollectionImageConstraintsFUCHSIA SetBufferCollectionImageConstraintsFUCHSIA;
PFN_vkSetBufferCollectionBufferConstraintsFUCHSIA SetBufferCollectionBufferConstraintsFUCHSIA;
PFN_vkDestroyBufferCollectionFUCHSIA DestroyBufferCollectionFUCHSIA;
PFN_vkGetBufferCollectionPropertiesFUCHSIA GetBufferCollectionPropertiesFUCHSIA;
#endif  // VK_USE_PLATFORM_FUCHSIA
PFN_vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI;
PFN_vkCmdSubpassShadingHUAWEI CmdSubpassShadingHUAWEI;
PFN_vkCmdBindInvocationMaskHUAWEI CmdBindInvocationMaskHUAWEI;
PFN_vkGetMemoryRemoteAddressNV GetMemoryRemoteAddressNV;
PFN_vkGetPipelinePropertiesEXT GetPipelinePropertiesEXT;
PFN_vkCmdSetPatchControlPointsEXT CmdSetPatchControlPointsEXT;
PFN_vkCmdSetRasterizerDiscardEnableEXT CmdSetRasterizerDiscardEnableEXT;
PFN_vkCmdSetDepthBiasEnableEXT CmdSetDepthBiasEnableEXT;
PFN_vkCmdSetLogicOpEXT CmdSetLogicOpEXT;
PFN_vkCmdSetPrimitiveRestartEnableEXT CmdSetPrimitiveRestartEnableEXT;
#ifdef VK_USE_PLATFORM_SCREEN_QNX
PFN_vkCreateScreenSurfaceQNX CreateScreenSurfaceQNX;
PFN_vkGetPhysicalDeviceScreenPresentationSupportQNX GetPhysicalDeviceScreenPresentationSupportQNX;
#endif  // VK_USE_PLATFORM_SCREEN_QNX
PFN_vkCmdSetColorWriteEnableEXT CmdSetColorWriteEnableEXT;
PFN_vkCmdDrawMultiEXT CmdDrawMultiEXT;
PFN_vkCmdDrawMultiIndexedEXT CmdDrawMultiIndexedEXT;
PFN_vkCreateMicromapEXT CreateMicromapEXT;
PFN_vkDestroyMicromapEXT DestroyMicromapEXT;
PFN_vkCmdBuildMicromapsEXT CmdBuildMicromapsEXT;
PFN_vkBuildMicromapsEXT BuildMicromapsEXT;
PFN_vkCopyMicromapEXT CopyMicromapEXT;
PFN_vkCopyMicromapToMemoryEXT CopyMicromapToMemoryEXT;
PFN_vkCopyMemoryToMicromapEXT CopyMemoryToMicromapEXT;
PFN_vkWriteMicromapsPropertiesEXT WriteMicromapsPropertiesEXT;
PFN_vkCmdCopyMicromapEXT CmdCopyMicromapEXT;
PFN_vkCmdCopyMicromapToMemoryEXT CmdCopyMicromapToMemoryEXT;
PFN_vkCmdCopyMemoryToMicromapEXT CmdCopyMemoryToMicromapEXT;
PFN_vkCmdWriteMicromapsPropertiesEXT CmdWriteMicromapsPropertiesEXT;
PFN_vkGetDeviceMicromapCompatibilityEXT GetDeviceMicromapCompatibilityEXT;
PFN_vkGetMicromapBuildSizesEXT GetMicromapBuildSizesEXT;
PFN_vkCmdDrawClusterHUAWEI CmdDrawClusterHUAWEI;
PFN_vkCmdDrawClusterIndirectHUAWEI CmdDrawClusterIndirectHUAWEI;
PFN_vkSetDeviceMemoryPriorityEXT SetDeviceMemoryPriorityEXT;
PFN_vkGetDescriptorSetLayoutHostMappingInfoVALVE GetDescriptorSetLayoutHostMappingInfoVALVE;
PFN_vkGetDescriptorSetHostMappingVALVE GetDescriptorSetHostMappingVALVE;
PFN_vkCmdCopyMemoryIndirectNV CmdCopyMemoryIndirectNV;
PFN_vkCmdCopyMemoryToImageIndirectNV CmdCopyMemoryToImageIndirectNV;
PFN_vkCmdDecompressMemoryNV CmdDecompressMemoryNV;
PFN_vkCmdDecompressMemoryIndirectCountNV CmdDecompressMemoryIndirectCountNV;
PFN_vkGetPipelineIndirectMemoryRequirementsNV GetPipelineIndirectMemoryRequirementsNV;
PFN_vkCmdUpdatePipelineIndirectBufferNV CmdUpdatePipelineIndirectBufferNV;
PFN_vkGetPipelineIndirectDeviceAddressNV GetPipelineIndirectDeviceAddressNV;
#ifdef VK_USE_PLATFORM_OHOS
PFN_vkGetNativeBufferPropertiesOHOS GetNativeBufferPropertiesOHOS;
PFN_vkGetMemoryNativeBufferOHOS GetMemoryNativeBufferOHOS;
#endif  // VK_USE_PLATFORM_OHOS
PFN_vkCmdSetDepthClampEnableEXT CmdSetDepthClampEnableEXT;
PFN_vkCmdSetPolygonModeEXT CmdSetPolygonModeEXT;
PFN_vkCmdSetRasterizationSamplesEXT CmdSetRasterizationSamplesEXT;
PFN_vkCmdSetSampleMaskEXT CmdSetSampleMaskEXT;
PFN_vkCmdSetAlphaToCoverageEnableEXT CmdSetAlphaToCoverageEnableEXT;
PFN_vkCmdSetAlphaToOneEnableEXT CmdSetAlphaToOneEnableEXT;
PFN_vkCmdSetLogicOpEnableEXT CmdSetLogicOpEnableEXT;
PFN_vkCmdSetColorBlendEnableEXT CmdSetColorBlendEnableEXT;
PFN_vkCmdSetColorBlendEquationEXT CmdSetColorBlendEquationEXT;
PFN_vkCmdSetColorWriteMaskEXT CmdSetColorWriteMaskEXT;
PFN_vkCmdSetTessellationDomainOriginEXT CmdSetTessellationDomainOriginEXT;
PFN_vkCmdSetRasterizationStreamEXT CmdSetRasterizationStreamEXT;
PFN_vkCmdSetConservativeRasterizationModeEXT CmdSetConservativeRasterizationModeEXT;
PFN_vkCmdSetExtraPrimitiveOverestimationSizeEXT CmdSetExtraPrimitiveOverestimationSizeEXT;
PFN_vkCmdSetDepthClipEnableEXT CmdSetDepthClipEnableEXT;
PFN_vkCmdSetSampleLocationsEnableEXT CmdSetSampleLocationsEnableEXT;
PFN_vkCmdSetColorBlendAdvancedEXT CmdSetColorBlendAdvancedEXT;
PFN_vkCmdSetProvokingVertexModeEXT CmdSetProvokingVertexModeEXT;
PFN_vkCmdSetLineRasterizationModeEXT CmdSetLineRasterizationModeEXT;
PFN_vkCmdSetLineStippleEnableEXT CmdSetLineStippleEnableEXT;
PFN_vkCmdSetDepthClipNegativeOneToOneEXT CmdSetDepthClipNegativeOneToOneEXT;
PFN_vkCmdSetViewportWScalingEnableNV CmdSetViewportWScalingEnableNV;
PFN_vkCmdSetViewportSwizzleNV CmdSetViewportSwizzleNV;
PFN_vkCmdSetCoverageToColorEnableNV CmdSetCoverageToColorEnableNV;
PFN_vkCmdSetCoverageToColorLocationNV CmdSetCoverageToColorLocationNV;
PFN_vkCmdSetCoverageModulationModeNV CmdSetCoverageModulationModeNV;
PFN_vkCmdSetCoverageModulationTableEnableNV CmdSetCoverageModulationTableEnableNV;
PFN_vkCmdSetCoverageModulationTableNV CmdSetCoverageModulationTableNV;
PFN_vkCmdSetShadingRateImageEnableNV CmdSetShadingRateImageEnableNV;
PFN_vkCmdSetRepresentativeFragmentTestEnableNV CmdSetRepresentativeFragmentTestEnableNV;
PFN_vkCmdSetCoverageReductionModeNV CmdSetCoverageReductionModeNV;
PFN_vkCreateTensorARM CreateTensorARM;
PFN_vkDestroyTensorARM DestroyTensorARM;
PFN_vkCreateTensorViewARM CreateTensorViewARM;
PFN_vkDestroyTensorViewARM DestroyTensorViewARM;
PFN_vkGetTensorMemoryRequirementsARM GetTensorMemoryRequirementsARM;
PFN_vkBindTensorMemoryARM BindTensorMemoryARM;
PFN_vkGetDeviceTensorMemoryRequirementsARM GetDeviceTensorMemoryRequirementsARM;
PFN_vkCmdCopyTensorARM CmdCopyTensorARM;
PFN_vkGetPhysicalDeviceExternalTensorPropertiesARM GetPhysicalDeviceExternalTensorPropertiesARM;
PFN_vkGetTensorOpaqueCaptureDescriptorDataARM GetTensorOpaqueCaptureDescriptorDataARM;
PFN_vkGetTensorViewOpaqueCaptureDescriptorDataARM GetTensorViewOpaqueCaptureDescriptorDataARM;
PFN_vkGetShaderModuleIdentifierEXT GetShaderModuleIdentifierEXT;
PFN_vkGetShaderModuleCreateInfoIdentifierEXT GetShaderModuleCreateInfoIdentifierEXT;
PFN_vkGetPhysicalDeviceOpticalFlowImageFormatsNV GetPhysicalDeviceOpticalFlowImageFormatsNV;
PFN_vkCreateOpticalFlowSessionNV CreateOpticalFlowSessionNV;
PFN_vkDestroyOpticalFlowSessionNV DestroyOpticalFlowSessionNV;
PFN_vkBindOpticalFlowSessionImageNV BindOpticalFlowSessionImageNV;
PFN_vkCmdOpticalFlowExecuteNV CmdOpticalFlowExecuteNV;
PFN_vkAntiLagUpdateAMD AntiLagUpdateAMD;
PFN_vkCreateShadersEXT CreateShadersEXT;
PFN_vkDestroyShaderEXT DestroyShaderEXT;
PFN_vkGetShaderBinaryDataEXT GetShaderBinaryDataEXT;
PFN_vkCmdBindShadersEXT CmdBindShadersEXT;
PFN_vkCmdSetDepthClampRangeEXT CmdSetDepthClampRangeEXT;
PFN_vkGetFramebufferTilePropertiesQCOM GetFramebufferTilePropertiesQCOM;
PFN_vkGetDynamicRenderingTilePropertiesQCOM GetDynamicRenderingTilePropertiesQCOM;
PFN_vkGetPhysicalDeviceCooperativeVectorPropertiesNV GetPhysicalDeviceCooperativeVectorPropertiesNV;
PFN_vkConvertCooperativeVectorMatrixNV ConvertCooperativeVectorMatrixNV;
PFN_vkCmdConvertCooperativeVectorMatrixNV CmdConvertCooperativeVectorMatrixNV;
PFN_vkSetLatencySleepModeNV SetLatencySleepModeNV;
PFN_vkLatencySleepNV LatencySleepNV;
PFN_vkSetLatencyMarkerNV SetLatencyMarkerNV;
PFN_vkGetLatencyTimingsNV GetLatencyTimingsNV;
PFN_vkQueueNotifyOutOfBandNV QueueNotifyOutOfBandNV;
PFN_vkCreateDataGraphPipelinesARM CreateDataGraphPipelinesARM;
PFN_vkCreateDataGraphPipelineSessionARM CreateDataGraphPipelineSessionARM;
PFN_vkGetDataGraphPipelineSessionBindPointRequirementsARM GetDataGraphPipelineSessionBindPointRequirementsARM;
PFN_vkGetDataGraphPipelineSessionMemoryRequirementsARM GetDataGraphPipelineSessionMemoryRequirementsARM;
PFN_vkBindDataGraphPipelineSessionMemoryARM BindDataGraphPipelineSessionMemoryARM;
PFN_vkDestroyDataGraphPipelineSessionARM DestroyDataGraphPipelineSessionARM;
PFN_vkCmdDispatchDataGraphARM CmdDispatchDataGraphARM;
PFN_vkGetDataGraphPipelineAvailablePropertiesARM GetDataGraphPipelineAvailablePropertiesARM;
PFN_vkGetDataGraphPipelinePropertiesARM GetDataGraphPipelinePropertiesARM;
PFN_vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM;
PFN_vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM;
PFN_vkCmdSetAttachmentFeedbackLoopEnableEXT CmdSetAttachmentFeedbackLoopEnableEXT;
#ifdef VK_USE_PLATFORM_SCREEN_QNX
PFN_vkGetScreenBufferPropertiesQNX GetScreenBufferPropertiesQNX;
#endif  // VK_USE_PLATFORM_SCREEN_QNX
PFN_vkCmdBindTileMemoryQCOM CmdBindTileMemoryQCOM;
PFN_vkCmdDecompressMemoryEXT CmdDecompressMemoryEXT;
PFN_vkCmdDecompressMemoryIndirectCountEXT CmdDecompressMemoryIndirectCountEXT;
PFN_vkCreateExternalComputeQueueNV CreateExternalComputeQueueNV;
PFN_vkDestroyExternalComputeQueueNV DestroyExternalComputeQueueNV;
PFN_vkGetExternalComputeQueueDataNV GetExternalComputeQueueDataNV;
PFN_vkGetClusterAccelerationStructureBuildSizesNV GetClusterAccelerationStructureBuildSizesNV;
PFN_vkCmdBuildClusterAccelerationStructureIndirectNV CmdBuildClusterAccelerationStructureIndirectNV;
PFN_vkGetPartitionedAccelerationStructuresBuildSizesNV GetPartitionedAccelerationStructuresBuildSizesNV;
PFN_vkCmdBuildPartitionedAccelerationStructuresNV CmdBuildPartitionedAccelerationStructuresNV;
PFN_vkGetGeneratedCommandsMemoryRequirementsEXT GetGeneratedCommandsMemoryRequirementsEXT;
PFN_vkCmdPreprocessGeneratedCommandsEXT CmdPreprocessGeneratedCommandsEXT;
PFN_vkCmdExecuteGeneratedCommandsEXT CmdExecuteGeneratedCommandsEXT;
PFN_vkCreateIndirectCommandsLayoutEXT CreateIndirectCommandsLayoutEXT;
PFN_vkDestroyIndirectCommandsLayoutEXT DestroyIndirectCommandsLayoutEXT;
PFN_vkCreateIndirectExecutionSetEXT CreateIndirectExecutionSetEXT;
PFN_vkDestroyIndirectExecutionSetEXT DestroyIndirectExecutionSetEXT;
PFN_vkUpdateIndirectExecutionSetPipelineEXT UpdateIndirectExecutionSetPipelineEXT;
PFN_vkUpdateIndirectExecutionSetShaderEXT UpdateIndirectExecutionSetShaderEXT;
#ifdef VK_USE_PLATFORM_OHOS
PFN_vkCreateSurfaceOHOS CreateSurfaceOHOS;
PFN_vkGetSwapchainGrallocUsageOHOS GetSwapchainGrallocUsageOHOS;
PFN_vkAcquireImageOHOS AcquireImageOHOS;
PFN_vkQueueSignalReleaseImageOHOS QueueSignalReleaseImageOHOS;
#endif  // VK_USE_PLATFORM_OHOS
PFN_vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV;
#ifdef VK_USE_PLATFORM_METAL_EXT
PFN_vkGetMemoryMetalHandleEXT GetMemoryMetalHandleEXT;
PFN_vkGetMemoryMetalHandlePropertiesEXT GetMemoryMetalHandlePropertiesEXT;
#endif  // VK_USE_PLATFORM_METAL_EXT
PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM;
PFN_vkCmdEndRendering2EXT CmdEndRendering2EXT;
PFN_vkCmdBeginCustomResolveEXT CmdBeginCustomResolveEXT;
PFN_vkCreateAccelerationStructureKHR CreateAccelerationStructureKHR;
PFN_vkDestroyAccelerationStructureKHR DestroyAccelerationStructureKHR;
PFN_vkCmdBuildAccelerationStructuresKHR CmdBuildAccelerationStructuresKHR;
PFN_vkCmdBuildAccelerationStructuresIndirectKHR CmdBuildAccelerationStructuresIndirectKHR;
PFN_vkBuildAccelerationStructuresKHR BuildAccelerationStructuresKHR;
PFN_vkCopyAccelerationStructureKHR CopyAccelerationStructureKHR;
PFN_vkCopyAccelerationStructureToMemoryKHR CopyAccelerationStructureToMemoryKHR;
PFN_vkCopyMemoryToAccelerationStructureKHR CopyMemoryToAccelerationStructureKHR;
PFN_vkWriteAccelerationStructuresPropertiesKHR WriteAccelerationStructuresPropertiesKHR;
PFN_vkCmdCopyAccelerationStructureKHR CmdCopyAccelerationStructureKHR;
PFN_vkCmdCopyAccelerationStructureToMemoryKHR CmdCopyAccelerationStructureToMemoryKHR;
PFN_vkCmdCopyMemoryToAccelerationStructureKHR CmdCopyMemoryToAccelerationStructureKHR;
PFN_vkGetAccelerationStructureDeviceAddressKHR GetAccelerationStructureDeviceAddressKHR;
PFN_vkCmdWriteAccelerationStructuresPropertiesKHR CmdWriteAccelerationStructuresPropertiesKHR;
PFN_vkGetDeviceAccelerationStructureCompatibilityKHR GetDeviceAccelerationStructureCompatibilityKHR;
PFN_vkGetAccelerationStructureBuildSizesKHR GetAccelerationStructureBuildSizesKHR;
PFN_vkCmdTraceRaysKHR CmdTraceRaysKHR;
PFN_vkCreateRayTracingPipelinesKHR CreateRayTracingPipelinesKHR;
PFN_vkGetRayTracingCaptureReplayShaderGroupHandlesKHR GetRayTracingCaptureReplayShaderGroupHandlesKHR;
PFN_vkCmdTraceRaysIndirectKHR CmdTraceRaysIndirectKHR;
PFN_vkGetRayTracingShaderGroupStackSizeKHR GetRayTracingShaderGroupStackSizeKHR;
PFN_vkCmdSetRayTracingPipelineStackSizeKHR CmdSetRayTracingPipelineStackSizeKHR;
PFN_vkCmdDrawMeshTasksEXT CmdDrawMeshTasksEXT;
PFN_vkCmdDrawMeshTasksIndirectEXT CmdDrawMeshTasksIndirectEXT;
PFN_vkCmdDrawMeshTasksIndirectCountEXT CmdDrawMeshTasksIndirectCountEXT;

void InitCore(const char *api_name) {

#if defined(WIN32)
    std::string filename = std::string(api_name) + "-1.dll";
    auto lib_handle = open_library(filename.c_str());
#elif(__APPLE__)
    std::string filename = std::string("lib") + api_name + ".dylib";
    auto lib_handle = open_library(filename.c_str());
#else
    std::string filename = std::string("lib") + api_name + ".so";
    auto lib_handle = open_library(filename.c_str());
    if (!lib_handle) {
        filename = std::string("lib") + api_name + ".so.1";
        lib_handle = open_library(filename.c_str());
    }
#endif

    if (lib_handle == nullptr) {
        printf("%s\n", open_library_error(filename.c_str()));
        exit(1);
    }
    CreateInstance = reinterpret_cast<PFN_vkCreateInstance>(get_proc_address(lib_handle, "vkCreateInstance"));
    DestroyInstance = reinterpret_cast<PFN_vkDestroyInstance>(get_proc_address(lib_handle, "vkDestroyInstance"));
    EnumeratePhysicalDevices = reinterpret_cast<PFN_vkEnumeratePhysicalDevices>(get_proc_address(lib_handle, "vkEnumeratePhysicalDevices"));
    GetPhysicalDeviceFeatures = reinterpret_cast<PFN_vkGetPhysicalDeviceFeatures>(get_proc_address(lib_handle, "vkGetPhysicalDeviceFeatures"));
    GetPhysicalDeviceFormatProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceFormatProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceFormatProperties"));
    GetPhysicalDeviceImageFormatProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceImageFormatProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceImageFormatProperties"));
    GetPhysicalDeviceProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceProperties"));
    GetPhysicalDeviceQueueFamilyProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceQueueFamilyProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceQueueFamilyProperties"));
    GetPhysicalDeviceMemoryProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceMemoryProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceMemoryProperties"));
    GetInstanceProcAddr = reinterpret_cast<PFN_vkGetInstanceProcAddr>(get_proc_address(lib_handle, "vkGetInstanceProcAddr"));
    GetDeviceProcAddr = reinterpret_cast<PFN_vkGetDeviceProcAddr>(get_proc_address(lib_handle, "vkGetDeviceProcAddr"));
    CreateDevice = reinterpret_cast<PFN_vkCreateDevice>(get_proc_address(lib_handle, "vkCreateDevice"));
    DestroyDevice = reinterpret_cast<PFN_vkDestroyDevice>(get_proc_address(lib_handle, "vkDestroyDevice"));
    EnumerateInstanceExtensionProperties = reinterpret_cast<PFN_vkEnumerateInstanceExtensionProperties>(get_proc_address(lib_handle, "vkEnumerateInstanceExtensionProperties"));
    EnumerateDeviceExtensionProperties = reinterpret_cast<PFN_vkEnumerateDeviceExtensionProperties>(get_proc_address(lib_handle, "vkEnumerateDeviceExtensionProperties"));
    EnumerateInstanceLayerProperties = reinterpret_cast<PFN_vkEnumerateInstanceLayerProperties>(get_proc_address(lib_handle, "vkEnumerateInstanceLayerProperties"));
    EnumerateDeviceLayerProperties = reinterpret_cast<PFN_vkEnumerateDeviceLayerProperties>(get_proc_address(lib_handle, "vkEnumerateDeviceLayerProperties"));
    GetDeviceQueue = reinterpret_cast<PFN_vkGetDeviceQueue>(get_proc_address(lib_handle, "vkGetDeviceQueue"));
    QueueSubmit = reinterpret_cast<PFN_vkQueueSubmit>(get_proc_address(lib_handle, "vkQueueSubmit"));
    QueueWaitIdle = reinterpret_cast<PFN_vkQueueWaitIdle>(get_proc_address(lib_handle, "vkQueueWaitIdle"));
    DeviceWaitIdle = reinterpret_cast<PFN_vkDeviceWaitIdle>(get_proc_address(lib_handle, "vkDeviceWaitIdle"));
    AllocateMemory = reinterpret_cast<PFN_vkAllocateMemory>(get_proc_address(lib_handle, "vkAllocateMemory"));
    FreeMemory = reinterpret_cast<PFN_vkFreeMemory>(get_proc_address(lib_handle, "vkFreeMemory"));
    MapMemory = reinterpret_cast<PFN_vkMapMemory>(get_proc_address(lib_handle, "vkMapMemory"));
    UnmapMemory = reinterpret_cast<PFN_vkUnmapMemory>(get_proc_address(lib_handle, "vkUnmapMemory"));
    FlushMappedMemoryRanges = reinterpret_cast<PFN_vkFlushMappedMemoryRanges>(get_proc_address(lib_handle, "vkFlushMappedMemoryRanges"));
    InvalidateMappedMemoryRanges = reinterpret_cast<PFN_vkInvalidateMappedMemoryRanges>(get_proc_address(lib_handle, "vkInvalidateMappedMemoryRanges"));
    GetDeviceMemoryCommitment = reinterpret_cast<PFN_vkGetDeviceMemoryCommitment>(get_proc_address(lib_handle, "vkGetDeviceMemoryCommitment"));
    BindBufferMemory = reinterpret_cast<PFN_vkBindBufferMemory>(get_proc_address(lib_handle, "vkBindBufferMemory"));
    BindImageMemory = reinterpret_cast<PFN_vkBindImageMemory>(get_proc_address(lib_handle, "vkBindImageMemory"));
    GetBufferMemoryRequirements = reinterpret_cast<PFN_vkGetBufferMemoryRequirements>(get_proc_address(lib_handle, "vkGetBufferMemoryRequirements"));
    GetImageMemoryRequirements = reinterpret_cast<PFN_vkGetImageMemoryRequirements>(get_proc_address(lib_handle, "vkGetImageMemoryRequirements"));
    GetImageSparseMemoryRequirements = reinterpret_cast<PFN_vkGetImageSparseMemoryRequirements>(get_proc_address(lib_handle, "vkGetImageSparseMemoryRequirements"));
    GetPhysicalDeviceSparseImageFormatProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceSparseImageFormatProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceSparseImageFormatProperties"));
    QueueBindSparse = reinterpret_cast<PFN_vkQueueBindSparse>(get_proc_address(lib_handle, "vkQueueBindSparse"));
    CreateFence = reinterpret_cast<PFN_vkCreateFence>(get_proc_address(lib_handle, "vkCreateFence"));
    DestroyFence = reinterpret_cast<PFN_vkDestroyFence>(get_proc_address(lib_handle, "vkDestroyFence"));
    ResetFences = reinterpret_cast<PFN_vkResetFences>(get_proc_address(lib_handle, "vkResetFences"));
    GetFenceStatus = reinterpret_cast<PFN_vkGetFenceStatus>(get_proc_address(lib_handle, "vkGetFenceStatus"));
    WaitForFences = reinterpret_cast<PFN_vkWaitForFences>(get_proc_address(lib_handle, "vkWaitForFences"));
    CreateSemaphore = reinterpret_cast<PFN_vkCreateSemaphore>(get_proc_address(lib_handle, "vkCreateSemaphore"));
    DestroySemaphore = reinterpret_cast<PFN_vkDestroySemaphore>(get_proc_address(lib_handle, "vkDestroySemaphore"));
    CreateQueryPool = reinterpret_cast<PFN_vkCreateQueryPool>(get_proc_address(lib_handle, "vkCreateQueryPool"));
    DestroyQueryPool = reinterpret_cast<PFN_vkDestroyQueryPool>(get_proc_address(lib_handle, "vkDestroyQueryPool"));
    GetQueryPoolResults = reinterpret_cast<PFN_vkGetQueryPoolResults>(get_proc_address(lib_handle, "vkGetQueryPoolResults"));
    CreateBuffer = reinterpret_cast<PFN_vkCreateBuffer>(get_proc_address(lib_handle, "vkCreateBuffer"));
    DestroyBuffer = reinterpret_cast<PFN_vkDestroyBuffer>(get_proc_address(lib_handle, "vkDestroyBuffer"));
    CreateImage = reinterpret_cast<PFN_vkCreateImage>(get_proc_address(lib_handle, "vkCreateImage"));
    DestroyImage = reinterpret_cast<PFN_vkDestroyImage>(get_proc_address(lib_handle, "vkDestroyImage"));
    GetImageSubresourceLayout = reinterpret_cast<PFN_vkGetImageSubresourceLayout>(get_proc_address(lib_handle, "vkGetImageSubresourceLayout"));
    CreateImageView = reinterpret_cast<PFN_vkCreateImageView>(get_proc_address(lib_handle, "vkCreateImageView"));
    DestroyImageView = reinterpret_cast<PFN_vkDestroyImageView>(get_proc_address(lib_handle, "vkDestroyImageView"));
    CreateCommandPool = reinterpret_cast<PFN_vkCreateCommandPool>(get_proc_address(lib_handle, "vkCreateCommandPool"));
    DestroyCommandPool = reinterpret_cast<PFN_vkDestroyCommandPool>(get_proc_address(lib_handle, "vkDestroyCommandPool"));
    ResetCommandPool = reinterpret_cast<PFN_vkResetCommandPool>(get_proc_address(lib_handle, "vkResetCommandPool"));
    AllocateCommandBuffers = reinterpret_cast<PFN_vkAllocateCommandBuffers>(get_proc_address(lib_handle, "vkAllocateCommandBuffers"));
    FreeCommandBuffers = reinterpret_cast<PFN_vkFreeCommandBuffers>(get_proc_address(lib_handle, "vkFreeCommandBuffers"));
    BeginCommandBuffer = reinterpret_cast<PFN_vkBeginCommandBuffer>(get_proc_address(lib_handle, "vkBeginCommandBuffer"));
    EndCommandBuffer = reinterpret_cast<PFN_vkEndCommandBuffer>(get_proc_address(lib_handle, "vkEndCommandBuffer"));
    ResetCommandBuffer = reinterpret_cast<PFN_vkResetCommandBuffer>(get_proc_address(lib_handle, "vkResetCommandBuffer"));
    CmdCopyBuffer = reinterpret_cast<PFN_vkCmdCopyBuffer>(get_proc_address(lib_handle, "vkCmdCopyBuffer"));
    CmdCopyImage = reinterpret_cast<PFN_vkCmdCopyImage>(get_proc_address(lib_handle, "vkCmdCopyImage"));
    CmdCopyBufferToImage = reinterpret_cast<PFN_vkCmdCopyBufferToImage>(get_proc_address(lib_handle, "vkCmdCopyBufferToImage"));
    CmdCopyImageToBuffer = reinterpret_cast<PFN_vkCmdCopyImageToBuffer>(get_proc_address(lib_handle, "vkCmdCopyImageToBuffer"));
    CmdUpdateBuffer = reinterpret_cast<PFN_vkCmdUpdateBuffer>(get_proc_address(lib_handle, "vkCmdUpdateBuffer"));
    CmdFillBuffer = reinterpret_cast<PFN_vkCmdFillBuffer>(get_proc_address(lib_handle, "vkCmdFillBuffer"));
    CmdPipelineBarrier = reinterpret_cast<PFN_vkCmdPipelineBarrier>(get_proc_address(lib_handle, "vkCmdPipelineBarrier"));
    CmdBeginQuery = reinterpret_cast<PFN_vkCmdBeginQuery>(get_proc_address(lib_handle, "vkCmdBeginQuery"));
    CmdEndQuery = reinterpret_cast<PFN_vkCmdEndQuery>(get_proc_address(lib_handle, "vkCmdEndQuery"));
    CmdResetQueryPool = reinterpret_cast<PFN_vkCmdResetQueryPool>(get_proc_address(lib_handle, "vkCmdResetQueryPool"));
    CmdWriteTimestamp = reinterpret_cast<PFN_vkCmdWriteTimestamp>(get_proc_address(lib_handle, "vkCmdWriteTimestamp"));
    CmdCopyQueryPoolResults = reinterpret_cast<PFN_vkCmdCopyQueryPoolResults>(get_proc_address(lib_handle, "vkCmdCopyQueryPoolResults"));
    CmdExecuteCommands = reinterpret_cast<PFN_vkCmdExecuteCommands>(get_proc_address(lib_handle, "vkCmdExecuteCommands"));
    CreateEvent = reinterpret_cast<PFN_vkCreateEvent>(get_proc_address(lib_handle, "vkCreateEvent"));
    DestroyEvent = reinterpret_cast<PFN_vkDestroyEvent>(get_proc_address(lib_handle, "vkDestroyEvent"));
    GetEventStatus = reinterpret_cast<PFN_vkGetEventStatus>(get_proc_address(lib_handle, "vkGetEventStatus"));
    SetEvent = reinterpret_cast<PFN_vkSetEvent>(get_proc_address(lib_handle, "vkSetEvent"));
    ResetEvent = reinterpret_cast<PFN_vkResetEvent>(get_proc_address(lib_handle, "vkResetEvent"));
    CreateBufferView = reinterpret_cast<PFN_vkCreateBufferView>(get_proc_address(lib_handle, "vkCreateBufferView"));
    DestroyBufferView = reinterpret_cast<PFN_vkDestroyBufferView>(get_proc_address(lib_handle, "vkDestroyBufferView"));
    CreateShaderModule = reinterpret_cast<PFN_vkCreateShaderModule>(get_proc_address(lib_handle, "vkCreateShaderModule"));
    DestroyShaderModule = reinterpret_cast<PFN_vkDestroyShaderModule>(get_proc_address(lib_handle, "vkDestroyShaderModule"));
    CreatePipelineCache = reinterpret_cast<PFN_vkCreatePipelineCache>(get_proc_address(lib_handle, "vkCreatePipelineCache"));
    DestroyPipelineCache = reinterpret_cast<PFN_vkDestroyPipelineCache>(get_proc_address(lib_handle, "vkDestroyPipelineCache"));
    GetPipelineCacheData = reinterpret_cast<PFN_vkGetPipelineCacheData>(get_proc_address(lib_handle, "vkGetPipelineCacheData"));
    MergePipelineCaches = reinterpret_cast<PFN_vkMergePipelineCaches>(get_proc_address(lib_handle, "vkMergePipelineCaches"));
    CreateComputePipelines = reinterpret_cast<PFN_vkCreateComputePipelines>(get_proc_address(lib_handle, "vkCreateComputePipelines"));
    DestroyPipeline = reinterpret_cast<PFN_vkDestroyPipeline>(get_proc_address(lib_handle, "vkDestroyPipeline"));
    CreatePipelineLayout = reinterpret_cast<PFN_vkCreatePipelineLayout>(get_proc_address(lib_handle, "vkCreatePipelineLayout"));
    DestroyPipelineLayout = reinterpret_cast<PFN_vkDestroyPipelineLayout>(get_proc_address(lib_handle, "vkDestroyPipelineLayout"));
    CreateSampler = reinterpret_cast<PFN_vkCreateSampler>(get_proc_address(lib_handle, "vkCreateSampler"));
    DestroySampler = reinterpret_cast<PFN_vkDestroySampler>(get_proc_address(lib_handle, "vkDestroySampler"));
    CreateDescriptorSetLayout = reinterpret_cast<PFN_vkCreateDescriptorSetLayout>(get_proc_address(lib_handle, "vkCreateDescriptorSetLayout"));
    DestroyDescriptorSetLayout = reinterpret_cast<PFN_vkDestroyDescriptorSetLayout>(get_proc_address(lib_handle, "vkDestroyDescriptorSetLayout"));
    CreateDescriptorPool = reinterpret_cast<PFN_vkCreateDescriptorPool>(get_proc_address(lib_handle, "vkCreateDescriptorPool"));
    DestroyDescriptorPool = reinterpret_cast<PFN_vkDestroyDescriptorPool>(get_proc_address(lib_handle, "vkDestroyDescriptorPool"));
    ResetDescriptorPool = reinterpret_cast<PFN_vkResetDescriptorPool>(get_proc_address(lib_handle, "vkResetDescriptorPool"));
    AllocateDescriptorSets = reinterpret_cast<PFN_vkAllocateDescriptorSets>(get_proc_address(lib_handle, "vkAllocateDescriptorSets"));
    FreeDescriptorSets = reinterpret_cast<PFN_vkFreeDescriptorSets>(get_proc_address(lib_handle, "vkFreeDescriptorSets"));
    UpdateDescriptorSets = reinterpret_cast<PFN_vkUpdateDescriptorSets>(get_proc_address(lib_handle, "vkUpdateDescriptorSets"));
    CmdBindPipeline = reinterpret_cast<PFN_vkCmdBindPipeline>(get_proc_address(lib_handle, "vkCmdBindPipeline"));
    CmdBindDescriptorSets = reinterpret_cast<PFN_vkCmdBindDescriptorSets>(get_proc_address(lib_handle, "vkCmdBindDescriptorSets"));
    CmdClearColorImage = reinterpret_cast<PFN_vkCmdClearColorImage>(get_proc_address(lib_handle, "vkCmdClearColorImage"));
    CmdDispatch = reinterpret_cast<PFN_vkCmdDispatch>(get_proc_address(lib_handle, "vkCmdDispatch"));
    CmdDispatchIndirect = reinterpret_cast<PFN_vkCmdDispatchIndirect>(get_proc_address(lib_handle, "vkCmdDispatchIndirect"));
    CmdSetEvent = reinterpret_cast<PFN_vkCmdSetEvent>(get_proc_address(lib_handle, "vkCmdSetEvent"));
    CmdResetEvent = reinterpret_cast<PFN_vkCmdResetEvent>(get_proc_address(lib_handle, "vkCmdResetEvent"));
    CmdWaitEvents = reinterpret_cast<PFN_vkCmdWaitEvents>(get_proc_address(lib_handle, "vkCmdWaitEvents"));
    CmdPushConstants = reinterpret_cast<PFN_vkCmdPushConstants>(get_proc_address(lib_handle, "vkCmdPushConstants"));
    CreateGraphicsPipelines = reinterpret_cast<PFN_vkCreateGraphicsPipelines>(get_proc_address(lib_handle, "vkCreateGraphicsPipelines"));
    CreateFramebuffer = reinterpret_cast<PFN_vkCreateFramebuffer>(get_proc_address(lib_handle, "vkCreateFramebuffer"));
    DestroyFramebuffer = reinterpret_cast<PFN_vkDestroyFramebuffer>(get_proc_address(lib_handle, "vkDestroyFramebuffer"));
    CreateRenderPass = reinterpret_cast<PFN_vkCreateRenderPass>(get_proc_address(lib_handle, "vkCreateRenderPass"));
    DestroyRenderPass = reinterpret_cast<PFN_vkDestroyRenderPass>(get_proc_address(lib_handle, "vkDestroyRenderPass"));
    GetRenderAreaGranularity = reinterpret_cast<PFN_vkGetRenderAreaGranularity>(get_proc_address(lib_handle, "vkGetRenderAreaGranularity"));
    CmdSetViewport = reinterpret_cast<PFN_vkCmdSetViewport>(get_proc_address(lib_handle, "vkCmdSetViewport"));
    CmdSetScissor = reinterpret_cast<PFN_vkCmdSetScissor>(get_proc_address(lib_handle, "vkCmdSetScissor"));
    CmdSetLineWidth = reinterpret_cast<PFN_vkCmdSetLineWidth>(get_proc_address(lib_handle, "vkCmdSetLineWidth"));
    CmdSetDepthBias = reinterpret_cast<PFN_vkCmdSetDepthBias>(get_proc_address(lib_handle, "vkCmdSetDepthBias"));
    CmdSetBlendConstants = reinterpret_cast<PFN_vkCmdSetBlendConstants>(get_proc_address(lib_handle, "vkCmdSetBlendConstants"));
    CmdSetDepthBounds = reinterpret_cast<PFN_vkCmdSetDepthBounds>(get_proc_address(lib_handle, "vkCmdSetDepthBounds"));
    CmdSetStencilCompareMask = reinterpret_cast<PFN_vkCmdSetStencilCompareMask>(get_proc_address(lib_handle, "vkCmdSetStencilCompareMask"));
    CmdSetStencilWriteMask = reinterpret_cast<PFN_vkCmdSetStencilWriteMask>(get_proc_address(lib_handle, "vkCmdSetStencilWriteMask"));
    CmdSetStencilReference = reinterpret_cast<PFN_vkCmdSetStencilReference>(get_proc_address(lib_handle, "vkCmdSetStencilReference"));
    CmdBindIndexBuffer = reinterpret_cast<PFN_vkCmdBindIndexBuffer>(get_proc_address(lib_handle, "vkCmdBindIndexBuffer"));
    CmdBindVertexBuffers = reinterpret_cast<PFN_vkCmdBindVertexBuffers>(get_proc_address(lib_handle, "vkCmdBindVertexBuffers"));
    CmdDraw = reinterpret_cast<PFN_vkCmdDraw>(get_proc_address(lib_handle, "vkCmdDraw"));
    CmdDrawIndexed = reinterpret_cast<PFN_vkCmdDrawIndexed>(get_proc_address(lib_handle, "vkCmdDrawIndexed"));
    CmdDrawIndirect = reinterpret_cast<PFN_vkCmdDrawIndirect>(get_proc_address(lib_handle, "vkCmdDrawIndirect"));
    CmdDrawIndexedIndirect = reinterpret_cast<PFN_vkCmdDrawIndexedIndirect>(get_proc_address(lib_handle, "vkCmdDrawIndexedIndirect"));
    CmdBlitImage = reinterpret_cast<PFN_vkCmdBlitImage>(get_proc_address(lib_handle, "vkCmdBlitImage"));
    CmdClearDepthStencilImage = reinterpret_cast<PFN_vkCmdClearDepthStencilImage>(get_proc_address(lib_handle, "vkCmdClearDepthStencilImage"));
    CmdClearAttachments = reinterpret_cast<PFN_vkCmdClearAttachments>(get_proc_address(lib_handle, "vkCmdClearAttachments"));
    CmdResolveImage = reinterpret_cast<PFN_vkCmdResolveImage>(get_proc_address(lib_handle, "vkCmdResolveImage"));
    CmdBeginRenderPass = reinterpret_cast<PFN_vkCmdBeginRenderPass>(get_proc_address(lib_handle, "vkCmdBeginRenderPass"));
    CmdNextSubpass = reinterpret_cast<PFN_vkCmdNextSubpass>(get_proc_address(lib_handle, "vkCmdNextSubpass"));
    CmdEndRenderPass = reinterpret_cast<PFN_vkCmdEndRenderPass>(get_proc_address(lib_handle, "vkCmdEndRenderPass"));
    EnumerateInstanceVersion = reinterpret_cast<PFN_vkEnumerateInstanceVersion>(get_proc_address(lib_handle, "vkEnumerateInstanceVersion"));
    BindBufferMemory2 = reinterpret_cast<PFN_vkBindBufferMemory2>(get_proc_address(lib_handle, "vkBindBufferMemory2"));
    BindImageMemory2 = reinterpret_cast<PFN_vkBindImageMemory2>(get_proc_address(lib_handle, "vkBindImageMemory2"));
    GetDeviceGroupPeerMemoryFeatures = reinterpret_cast<PFN_vkGetDeviceGroupPeerMemoryFeatures>(get_proc_address(lib_handle, "vkGetDeviceGroupPeerMemoryFeatures"));
    CmdSetDeviceMask = reinterpret_cast<PFN_vkCmdSetDeviceMask>(get_proc_address(lib_handle, "vkCmdSetDeviceMask"));
    EnumeratePhysicalDeviceGroups = reinterpret_cast<PFN_vkEnumeratePhysicalDeviceGroups>(get_proc_address(lib_handle, "vkEnumeratePhysicalDeviceGroups"));
    GetImageMemoryRequirements2 = reinterpret_cast<PFN_vkGetImageMemoryRequirements2>(get_proc_address(lib_handle, "vkGetImageMemoryRequirements2"));
    GetBufferMemoryRequirements2 = reinterpret_cast<PFN_vkGetBufferMemoryRequirements2>(get_proc_address(lib_handle, "vkGetBufferMemoryRequirements2"));
    GetImageSparseMemoryRequirements2 = reinterpret_cast<PFN_vkGetImageSparseMemoryRequirements2>(get_proc_address(lib_handle, "vkGetImageSparseMemoryRequirements2"));
    GetPhysicalDeviceFeatures2 = reinterpret_cast<PFN_vkGetPhysicalDeviceFeatures2>(get_proc_address(lib_handle, "vkGetPhysicalDeviceFeatures2"));
    GetPhysicalDeviceProperties2 = reinterpret_cast<PFN_vkGetPhysicalDeviceProperties2>(get_proc_address(lib_handle, "vkGetPhysicalDeviceProperties2"));
    GetPhysicalDeviceFormatProperties2 = reinterpret_cast<PFN_vkGetPhysicalDeviceFormatProperties2>(get_proc_address(lib_handle, "vkGetPhysicalDeviceFormatProperties2"));
    GetPhysicalDeviceImageFormatProperties2 = reinterpret_cast<PFN_vkGetPhysicalDeviceImageFormatProperties2>(get_proc_address(lib_handle, "vkGetPhysicalDeviceImageFormatProperties2"));
    GetPhysicalDeviceQueueFamilyProperties2 = reinterpret_cast<PFN_vkGetPhysicalDeviceQueueFamilyProperties2>(get_proc_address(lib_handle, "vkGetPhysicalDeviceQueueFamilyProperties2"));
    GetPhysicalDeviceMemoryProperties2 = reinterpret_cast<PFN_vkGetPhysicalDeviceMemoryProperties2>(get_proc_address(lib_handle, "vkGetPhysicalDeviceMemoryProperties2"));
    GetPhysicalDeviceSparseImageFormatProperties2 = reinterpret_cast<PFN_vkGetPhysicalDeviceSparseImageFormatProperties2>(get_proc_address(lib_handle, "vkGetPhysicalDeviceSparseImageFormatProperties2"));
    TrimCommandPool = reinterpret_cast<PFN_vkTrimCommandPool>(get_proc_address(lib_handle, "vkTrimCommandPool"));
    GetDeviceQueue2 = reinterpret_cast<PFN_vkGetDeviceQueue2>(get_proc_address(lib_handle, "vkGetDeviceQueue2"));
    GetPhysicalDeviceExternalBufferProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceExternalBufferProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceExternalBufferProperties"));
    GetPhysicalDeviceExternalFenceProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceExternalFenceProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceExternalFenceProperties"));
    GetPhysicalDeviceExternalSemaphoreProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceExternalSemaphoreProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceExternalSemaphoreProperties"));
    CmdDispatchBase = reinterpret_cast<PFN_vkCmdDispatchBase>(get_proc_address(lib_handle, "vkCmdDispatchBase"));
    CreateDescriptorUpdateTemplate = reinterpret_cast<PFN_vkCreateDescriptorUpdateTemplate>(get_proc_address(lib_handle, "vkCreateDescriptorUpdateTemplate"));
    DestroyDescriptorUpdateTemplate = reinterpret_cast<PFN_vkDestroyDescriptorUpdateTemplate>(get_proc_address(lib_handle, "vkDestroyDescriptorUpdateTemplate"));
    UpdateDescriptorSetWithTemplate = reinterpret_cast<PFN_vkUpdateDescriptorSetWithTemplate>(get_proc_address(lib_handle, "vkUpdateDescriptorSetWithTemplate"));
    GetDescriptorSetLayoutSupport = reinterpret_cast<PFN_vkGetDescriptorSetLayoutSupport>(get_proc_address(lib_handle, "vkGetDescriptorSetLayoutSupport"));
    CreateSamplerYcbcrConversion = reinterpret_cast<PFN_vkCreateSamplerYcbcrConversion>(get_proc_address(lib_handle, "vkCreateSamplerYcbcrConversion"));
    DestroySamplerYcbcrConversion = reinterpret_cast<PFN_vkDestroySamplerYcbcrConversion>(get_proc_address(lib_handle, "vkDestroySamplerYcbcrConversion"));
    ResetQueryPool = reinterpret_cast<PFN_vkResetQueryPool>(get_proc_address(lib_handle, "vkResetQueryPool"));
    GetSemaphoreCounterValue = reinterpret_cast<PFN_vkGetSemaphoreCounterValue>(get_proc_address(lib_handle, "vkGetSemaphoreCounterValue"));
    WaitSemaphores = reinterpret_cast<PFN_vkWaitSemaphores>(get_proc_address(lib_handle, "vkWaitSemaphores"));
    SignalSemaphore = reinterpret_cast<PFN_vkSignalSemaphore>(get_proc_address(lib_handle, "vkSignalSemaphore"));
    GetBufferDeviceAddress = reinterpret_cast<PFN_vkGetBufferDeviceAddress>(get_proc_address(lib_handle, "vkGetBufferDeviceAddress"));
    GetBufferOpaqueCaptureAddress = reinterpret_cast<PFN_vkGetBufferOpaqueCaptureAddress>(get_proc_address(lib_handle, "vkGetBufferOpaqueCaptureAddress"));
    GetDeviceMemoryOpaqueCaptureAddress = reinterpret_cast<PFN_vkGetDeviceMemoryOpaqueCaptureAddress>(get_proc_address(lib_handle, "vkGetDeviceMemoryOpaqueCaptureAddress"));
    CmdDrawIndirectCount = reinterpret_cast<PFN_vkCmdDrawIndirectCount>(get_proc_address(lib_handle, "vkCmdDrawIndirectCount"));
    CmdDrawIndexedIndirectCount = reinterpret_cast<PFN_vkCmdDrawIndexedIndirectCount>(get_proc_address(lib_handle, "vkCmdDrawIndexedIndirectCount"));
    CreateRenderPass2 = reinterpret_cast<PFN_vkCreateRenderPass2>(get_proc_address(lib_handle, "vkCreateRenderPass2"));
    CmdBeginRenderPass2 = reinterpret_cast<PFN_vkCmdBeginRenderPass2>(get_proc_address(lib_handle, "vkCmdBeginRenderPass2"));
    CmdNextSubpass2 = reinterpret_cast<PFN_vkCmdNextSubpass2>(get_proc_address(lib_handle, "vkCmdNextSubpass2"));
    CmdEndRenderPass2 = reinterpret_cast<PFN_vkCmdEndRenderPass2>(get_proc_address(lib_handle, "vkCmdEndRenderPass2"));
    GetPhysicalDeviceToolProperties = reinterpret_cast<PFN_vkGetPhysicalDeviceToolProperties>(get_proc_address(lib_handle, "vkGetPhysicalDeviceToolProperties"));
    CreatePrivateDataSlot = reinterpret_cast<PFN_vkCreatePrivateDataSlot>(get_proc_address(lib_handle, "vkCreatePrivateDataSlot"));
    DestroyPrivateDataSlot = reinterpret_cast<PFN_vkDestroyPrivateDataSlot>(get_proc_address(lib_handle, "vkDestroyPrivateDataSlot"));
    SetPrivateData = reinterpret_cast<PFN_vkSetPrivateData>(get_proc_address(lib_handle, "vkSetPrivateData"));
    GetPrivateData = reinterpret_cast<PFN_vkGetPrivateData>(get_proc_address(lib_handle, "vkGetPrivateData"));
    CmdPipelineBarrier2 = reinterpret_cast<PFN_vkCmdPipelineBarrier2>(get_proc_address(lib_handle, "vkCmdPipelineBarrier2"));
    CmdWriteTimestamp2 = reinterpret_cast<PFN_vkCmdWriteTimestamp2>(get_proc_address(lib_handle, "vkCmdWriteTimestamp2"));
    QueueSubmit2 = reinterpret_cast<PFN_vkQueueSubmit2>(get_proc_address(lib_handle, "vkQueueSubmit2"));
    CmdCopyBuffer2 = reinterpret_cast<PFN_vkCmdCopyBuffer2>(get_proc_address(lib_handle, "vkCmdCopyBuffer2"));
    CmdCopyImage2 = reinterpret_cast<PFN_vkCmdCopyImage2>(get_proc_address(lib_handle, "vkCmdCopyImage2"));
    CmdCopyBufferToImage2 = reinterpret_cast<PFN_vkCmdCopyBufferToImage2>(get_proc_address(lib_handle, "vkCmdCopyBufferToImage2"));
    CmdCopyImageToBuffer2 = reinterpret_cast<PFN_vkCmdCopyImageToBuffer2>(get_proc_address(lib_handle, "vkCmdCopyImageToBuffer2"));
    GetDeviceBufferMemoryRequirements = reinterpret_cast<PFN_vkGetDeviceBufferMemoryRequirements>(get_proc_address(lib_handle, "vkGetDeviceBufferMemoryRequirements"));
    GetDeviceImageMemoryRequirements = reinterpret_cast<PFN_vkGetDeviceImageMemoryRequirements>(get_proc_address(lib_handle, "vkGetDeviceImageMemoryRequirements"));
    GetDeviceImageSparseMemoryRequirements = reinterpret_cast<PFN_vkGetDeviceImageSparseMemoryRequirements>(get_proc_address(lib_handle, "vkGetDeviceImageSparseMemoryRequirements"));
    CmdSetEvent2 = reinterpret_cast<PFN_vkCmdSetEvent2>(get_proc_address(lib_handle, "vkCmdSetEvent2"));
    CmdResetEvent2 = reinterpret_cast<PFN_vkCmdResetEvent2>(get_proc_address(lib_handle, "vkCmdResetEvent2"));
    CmdWaitEvents2 = reinterpret_cast<PFN_vkCmdWaitEvents2>(get_proc_address(lib_handle, "vkCmdWaitEvents2"));
    CmdBlitImage2 = reinterpret_cast<PFN_vkCmdBlitImage2>(get_proc_address(lib_handle, "vkCmdBlitImage2"));
    CmdResolveImage2 = reinterpret_cast<PFN_vkCmdResolveImage2>(get_proc_address(lib_handle, "vkCmdResolveImage2"));
    CmdBeginRendering = reinterpret_cast<PFN_vkCmdBeginRendering>(get_proc_address(lib_handle, "vkCmdBeginRendering"));
    CmdEndRendering = reinterpret_cast<PFN_vkCmdEndRendering>(get_proc_address(lib_handle, "vkCmdEndRendering"));
    CmdSetCullMode = reinterpret_cast<PFN_vkCmdSetCullMode>(get_proc_address(lib_handle, "vkCmdSetCullMode"));
    CmdSetFrontFace = reinterpret_cast<PFN_vkCmdSetFrontFace>(get_proc_address(lib_handle, "vkCmdSetFrontFace"));
    CmdSetPrimitiveTopology = reinterpret_cast<PFN_vkCmdSetPrimitiveTopology>(get_proc_address(lib_handle, "vkCmdSetPrimitiveTopology"));
    CmdSetViewportWithCount = reinterpret_cast<PFN_vkCmdSetViewportWithCount>(get_proc_address(lib_handle, "vkCmdSetViewportWithCount"));
    CmdSetScissorWithCount = reinterpret_cast<PFN_vkCmdSetScissorWithCount>(get_proc_address(lib_handle, "vkCmdSetScissorWithCount"));
    CmdBindVertexBuffers2 = reinterpret_cast<PFN_vkCmdBindVertexBuffers2>(get_proc_address(lib_handle, "vkCmdBindVertexBuffers2"));
    CmdSetDepthTestEnable = reinterpret_cast<PFN_vkCmdSetDepthTestEnable>(get_proc_address(lib_handle, "vkCmdSetDepthTestEnable"));
    CmdSetDepthWriteEnable = reinterpret_cast<PFN_vkCmdSetDepthWriteEnable>(get_proc_address(lib_handle, "vkCmdSetDepthWriteEnable"));
    CmdSetDepthCompareOp = reinterpret_cast<PFN_vkCmdSetDepthCompareOp>(get_proc_address(lib_handle, "vkCmdSetDepthCompareOp"));
    CmdSetDepthBoundsTestEnable = reinterpret_cast<PFN_vkCmdSetDepthBoundsTestEnable>(get_proc_address(lib_handle, "vkCmdSetDepthBoundsTestEnable"));
    CmdSetStencilTestEnable = reinterpret_cast<PFN_vkCmdSetStencilTestEnable>(get_proc_address(lib_handle, "vkCmdSetStencilTestEnable"));
    CmdSetStencilOp = reinterpret_cast<PFN_vkCmdSetStencilOp>(get_proc_address(lib_handle, "vkCmdSetStencilOp"));
    CmdSetRasterizerDiscardEnable = reinterpret_cast<PFN_vkCmdSetRasterizerDiscardEnable>(get_proc_address(lib_handle, "vkCmdSetRasterizerDiscardEnable"));
    CmdSetDepthBiasEnable = reinterpret_cast<PFN_vkCmdSetDepthBiasEnable>(get_proc_address(lib_handle, "vkCmdSetDepthBiasEnable"));
    CmdSetPrimitiveRestartEnable = reinterpret_cast<PFN_vkCmdSetPrimitiveRestartEnable>(get_proc_address(lib_handle, "vkCmdSetPrimitiveRestartEnable"));
    MapMemory2 = reinterpret_cast<PFN_vkMapMemory2>(get_proc_address(lib_handle, "vkMapMemory2"));
    UnmapMemory2 = reinterpret_cast<PFN_vkUnmapMemory2>(get_proc_address(lib_handle, "vkUnmapMemory2"));
    GetDeviceImageSubresourceLayout = reinterpret_cast<PFN_vkGetDeviceImageSubresourceLayout>(get_proc_address(lib_handle, "vkGetDeviceImageSubresourceLayout"));
    GetImageSubresourceLayout2 = reinterpret_cast<PFN_vkGetImageSubresourceLayout2>(get_proc_address(lib_handle, "vkGetImageSubresourceLayout2"));
    CopyMemoryToImage = reinterpret_cast<PFN_vkCopyMemoryToImage>(get_proc_address(lib_handle, "vkCopyMemoryToImage"));
    CopyImageToMemory = reinterpret_cast<PFN_vkCopyImageToMemory>(get_proc_address(lib_handle, "vkCopyImageToMemory"));
    CopyImageToImage = reinterpret_cast<PFN_vkCopyImageToImage>(get_proc_address(lib_handle, "vkCopyImageToImage"));
    TransitionImageLayout = reinterpret_cast<PFN_vkTransitionImageLayout>(get_proc_address(lib_handle, "vkTransitionImageLayout"));
    CmdPushDescriptorSet = reinterpret_cast<PFN_vkCmdPushDescriptorSet>(get_proc_address(lib_handle, "vkCmdPushDescriptorSet"));
    CmdPushDescriptorSetWithTemplate = reinterpret_cast<PFN_vkCmdPushDescriptorSetWithTemplate>(get_proc_address(lib_handle, "vkCmdPushDescriptorSetWithTemplate"));
    CmdBindDescriptorSets2 = reinterpret_cast<PFN_vkCmdBindDescriptorSets2>(get_proc_address(lib_handle, "vkCmdBindDescriptorSets2"));
    CmdPushConstants2 = reinterpret_cast<PFN_vkCmdPushConstants2>(get_proc_address(lib_handle, "vkCmdPushConstants2"));
    CmdPushDescriptorSet2 = reinterpret_cast<PFN_vkCmdPushDescriptorSet2>(get_proc_address(lib_handle, "vkCmdPushDescriptorSet2"));
    CmdPushDescriptorSetWithTemplate2 = reinterpret_cast<PFN_vkCmdPushDescriptorSetWithTemplate2>(get_proc_address(lib_handle, "vkCmdPushDescriptorSetWithTemplate2"));
    CmdSetLineStipple = reinterpret_cast<PFN_vkCmdSetLineStipple>(get_proc_address(lib_handle, "vkCmdSetLineStipple"));
    CmdBindIndexBuffer2 = reinterpret_cast<PFN_vkCmdBindIndexBuffer2>(get_proc_address(lib_handle, "vkCmdBindIndexBuffer2"));
    GetRenderingAreaGranularity = reinterpret_cast<PFN_vkGetRenderingAreaGranularity>(get_proc_address(lib_handle, "vkGetRenderingAreaGranularity"));
    CmdSetRenderingAttachmentLocations = reinterpret_cast<PFN_vkCmdSetRenderingAttachmentLocations>(get_proc_address(lib_handle, "vkCmdSetRenderingAttachmentLocations"));
    CmdSetRenderingInputAttachmentIndices = reinterpret_cast<PFN_vkCmdSetRenderingInputAttachmentIndices>(get_proc_address(lib_handle, "vkCmdSetRenderingInputAttachmentIndices"));
}
void InitExtensionFromCore(const char* extension_name) {
    static const vvl::unordered_map<std::string, std::function<void()>> initializers = {
        {
            "VK_KHR_dynamic_rendering", []() {
                CmdBeginRenderingKHR = CmdBeginRendering;
                CmdEndRenderingKHR = CmdEndRendering;
            }
        },
        {
            "VK_KHR_get_physical_device_properties2", []() {
                GetPhysicalDeviceFeatures2KHR = GetPhysicalDeviceFeatures2;
                GetPhysicalDeviceProperties2KHR = GetPhysicalDeviceProperties2;
                GetPhysicalDeviceFormatProperties2KHR = GetPhysicalDeviceFormatProperties2;
                GetPhysicalDeviceImageFormatProperties2KHR = GetPhysicalDeviceImageFormatProperties2;
                GetPhysicalDeviceQueueFamilyProperties2KHR = GetPhysicalDeviceQueueFamilyProperties2;
                GetPhysicalDeviceMemoryProperties2KHR = GetPhysicalDeviceMemoryProperties2;
                GetPhysicalDeviceSparseImageFormatProperties2KHR = GetPhysicalDeviceSparseImageFormatProperties2;
            }
        },
        {
            "VK_KHR_device_group", []() {
                GetDeviceGroupPeerMemoryFeaturesKHR = GetDeviceGroupPeerMemoryFeatures;
                CmdSetDeviceMaskKHR = CmdSetDeviceMask;
                CmdDispatchBaseKHR = CmdDispatchBase;
            }
        },
        {
            "VK_KHR_maintenance1", []() {
                TrimCommandPoolKHR = TrimCommandPool;
            }
        },
        {
            "VK_KHR_device_group_creation", []() {
                EnumeratePhysicalDeviceGroupsKHR = EnumeratePhysicalDeviceGroups;
            }
        },
        {
            "VK_KHR_external_memory_capabilities", []() {
                GetPhysicalDeviceExternalBufferPropertiesKHR = GetPhysicalDeviceExternalBufferProperties;
            }
        },
        {
            "VK_KHR_external_semaphore_capabilities", []() {
                GetPhysicalDeviceExternalSemaphorePropertiesKHR = GetPhysicalDeviceExternalSemaphoreProperties;
            }
        },
        {
            "VK_KHR_push_descriptor", []() {
                CmdPushDescriptorSetKHR = CmdPushDescriptorSet;
                CmdPushDescriptorSetWithTemplateKHR = CmdPushDescriptorSetWithTemplate;
            }
        },
        {
            "VK_KHR_descriptor_update_template", []() {
                CreateDescriptorUpdateTemplateKHR = CreateDescriptorUpdateTemplate;
                DestroyDescriptorUpdateTemplateKHR = DestroyDescriptorUpdateTemplate;
                UpdateDescriptorSetWithTemplateKHR = UpdateDescriptorSetWithTemplate;
                CmdPushDescriptorSetWithTemplateKHR = CmdPushDescriptorSetWithTemplate;
            }
        },
        {
            "VK_KHR_create_renderpass2", []() {
                CreateRenderPass2KHR = CreateRenderPass2;
                CmdBeginRenderPass2KHR = CmdBeginRenderPass2;
                CmdNextSubpass2KHR = CmdNextSubpass2;
                CmdEndRenderPass2KHR = CmdEndRenderPass2;
            }
        },
        {
            "VK_KHR_external_fence_capabilities", []() {
                GetPhysicalDeviceExternalFencePropertiesKHR = GetPhysicalDeviceExternalFenceProperties;
            }
        },
        {
            "VK_KHR_get_memory_requirements2", []() {
                GetImageMemoryRequirements2KHR = GetImageMemoryRequirements2;
                GetBufferMemoryRequirements2KHR = GetBufferMemoryRequirements2;
                GetImageSparseMemoryRequirements2KHR = GetImageSparseMemoryRequirements2;
            }
        },
        {
            "VK_KHR_sampler_ycbcr_conversion", []() {
                CreateSamplerYcbcrConversionKHR = CreateSamplerYcbcrConversion;
                DestroySamplerYcbcrConversionKHR = DestroySamplerYcbcrConversion;
            }
        },
        {
            "VK_KHR_bind_memory2", []() {
                BindBufferMemory2KHR = BindBufferMemory2;
                BindImageMemory2KHR = BindImageMemory2;
            }
        },
        {
            "VK_KHR_maintenance3", []() {
                GetDescriptorSetLayoutSupportKHR = GetDescriptorSetLayoutSupport;
            }
        },
        {
            "VK_KHR_draw_indirect_count", []() {
                CmdDrawIndirectCountKHR = CmdDrawIndirectCount;
                CmdDrawIndexedIndirectCountKHR = CmdDrawIndexedIndirectCount;
            }
        },
        {
            "VK_KHR_timeline_semaphore", []() {
                GetSemaphoreCounterValueKHR = GetSemaphoreCounterValue;
                WaitSemaphoresKHR = WaitSemaphores;
                SignalSemaphoreKHR = SignalSemaphore;
            }
        },
        {
            "VK_KHR_dynamic_rendering_local_read", []() {
                CmdSetRenderingAttachmentLocationsKHR = CmdSetRenderingAttachmentLocations;
                CmdSetRenderingInputAttachmentIndicesKHR = CmdSetRenderingInputAttachmentIndices;
            }
        },
        {
            "VK_KHR_buffer_device_address", []() {
                GetBufferDeviceAddressKHR = GetBufferDeviceAddress;
                GetBufferOpaqueCaptureAddressKHR = GetBufferOpaqueCaptureAddress;
                GetDeviceMemoryOpaqueCaptureAddressKHR = GetDeviceMemoryOpaqueCaptureAddress;
            }
        },
        {
            "VK_KHR_map_memory2", []() {
                MapMemory2KHR = MapMemory2;
                UnmapMemory2KHR = UnmapMemory2;
            }
        },
        {
            "VK_KHR_synchronization2", []() {
                CmdSetEvent2KHR = CmdSetEvent2;
                CmdResetEvent2KHR = CmdResetEvent2;
                CmdWaitEvents2KHR = CmdWaitEvents2;
                CmdPipelineBarrier2KHR = CmdPipelineBarrier2;
                CmdWriteTimestamp2KHR = CmdWriteTimestamp2;
                QueueSubmit2KHR = QueueSubmit2;
            }
        },
        {
            "VK_KHR_copy_commands2", []() {
                CmdCopyBuffer2KHR = CmdCopyBuffer2;
                CmdCopyImage2KHR = CmdCopyImage2;
                CmdCopyBufferToImage2KHR = CmdCopyBufferToImage2;
                CmdCopyImageToBuffer2KHR = CmdCopyImageToBuffer2;
                CmdBlitImage2KHR = CmdBlitImage2;
                CmdResolveImage2KHR = CmdResolveImage2;
            }
        },
        {
            "VK_KHR_maintenance4", []() {
                GetDeviceBufferMemoryRequirementsKHR = GetDeviceBufferMemoryRequirements;
                GetDeviceImageMemoryRequirementsKHR = GetDeviceImageMemoryRequirements;
                GetDeviceImageSparseMemoryRequirementsKHR = GetDeviceImageSparseMemoryRequirements;
            }
        },
        {
            "VK_KHR_maintenance5", []() {
                CmdBindIndexBuffer2KHR = CmdBindIndexBuffer2;
                GetRenderingAreaGranularityKHR = GetRenderingAreaGranularity;
                GetDeviceImageSubresourceLayoutKHR = GetDeviceImageSubresourceLayout;
                GetImageSubresourceLayout2KHR = GetImageSubresourceLayout2;
            }
        },
        {
            "VK_KHR_line_rasterization", []() {
                CmdSetLineStippleKHR = CmdSetLineStipple;
            }
        },
        {
            "VK_KHR_maintenance6", []() {
                CmdBindDescriptorSets2KHR = CmdBindDescriptorSets2;
                CmdPushConstants2KHR = CmdPushConstants2;
                CmdPushDescriptorSet2KHR = CmdPushDescriptorSet2;
                CmdPushDescriptorSetWithTemplate2KHR = CmdPushDescriptorSetWithTemplate2;
            }
        },
        {
            "VK_EXT_debug_marker", []() {
            }
        },
        {
            "VK_AMD_draw_indirect_count", []() {
                CmdDrawIndirectCountAMD = CmdDrawIndirectCount;
                CmdDrawIndexedIndirectCountAMD = CmdDrawIndexedIndirectCount;
            }
        },
        {
            "VK_EXT_calibrated_timestamps", []() {
            }
        },
        {
            "VK_EXT_tooling_info", []() {
                GetPhysicalDeviceToolPropertiesEXT = GetPhysicalDeviceToolProperties;
            }
        },
        {
            "VK_EXT_line_rasterization", []() {
                CmdSetLineStippleEXT = CmdSetLineStipple;
            }
        },
        {
            "VK_EXT_host_query_reset", []() {
                ResetQueryPoolEXT = ResetQueryPool;
            }
        },
        {
            "VK_EXT_extended_dynamic_state", []() {
                CmdSetCullModeEXT = CmdSetCullMode;
                CmdSetFrontFaceEXT = CmdSetFrontFace;
                CmdSetPrimitiveTopologyEXT = CmdSetPrimitiveTopology;
                CmdSetViewportWithCountEXT = CmdSetViewportWithCount;
                CmdSetScissorWithCountEXT = CmdSetScissorWithCount;
                CmdBindVertexBuffers2EXT = CmdBindVertexBuffers2;
                CmdSetDepthTestEnableEXT = CmdSetDepthTestEnable;
                CmdSetDepthWriteEnableEXT = CmdSetDepthWriteEnable;
                CmdSetDepthCompareOpEXT = CmdSetDepthCompareOp;
                CmdSetDepthBoundsTestEnableEXT = CmdSetDepthBoundsTestEnable;
                CmdSetStencilTestEnableEXT = CmdSetStencilTestEnable;
                CmdSetStencilOpEXT = CmdSetStencilOp;
            }
        },
        {
            "VK_EXT_host_image_copy", []() {
                CopyMemoryToImageEXT = CopyMemoryToImage;
                CopyImageToMemoryEXT = CopyImageToMemory;
                CopyImageToImageEXT = CopyImageToImage;
                TransitionImageLayoutEXT = TransitionImageLayout;
                GetImageSubresourceLayout2EXT = GetImageSubresourceLayout2;
            }
        },
        {
            "VK_EXT_swapchain_maintenance1", []() {
            }
        },
        {
            "VK_EXT_private_data", []() {
                CreatePrivateDataSlotEXT = CreatePrivateDataSlot;
                DestroyPrivateDataSlotEXT = DestroyPrivateDataSlot;
                SetPrivateDataEXT = SetPrivateData;
                GetPrivateDataEXT = GetPrivateData;
            }
        },
        {
            "VK_EXT_extended_dynamic_state2", []() {
                CmdSetRasterizerDiscardEnableEXT = CmdSetRasterizerDiscardEnable;
                CmdSetDepthBiasEnableEXT = CmdSetDepthBiasEnable;
                CmdSetPrimitiveRestartEnableEXT = CmdSetPrimitiveRestartEnable;
            }
        },
        {
            "VK_NV_copy_memory_indirect", []() {
            }
        },
        {
            "VK_NV_memory_decompression", []() {
            }
        },

    };

    if (auto it = initializers.find(extension_name); it != initializers.end())
        (it->second)();
}

void InitInstanceExtension(VkInstance instance, const char* extension_name) {
    assert(instance);
    static const vvl::unordered_map<std::string, std::function<void(VkInstance)>> initializers = {
        {
            "VK_KHR_surface", [](VkInstance instance) {
                DestroySurfaceKHR = reinterpret_cast<PFN_vkDestroySurfaceKHR>(GetInstanceProcAddr(instance, "vkDestroySurfaceKHR"));
                GetPhysicalDeviceSurfaceSupportKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceSurfaceSupportKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSurfaceSupportKHR"));
                GetPhysicalDeviceSurfaceCapabilitiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSurfaceCapabilitiesKHR"));
                GetPhysicalDeviceSurfaceFormatsKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceSurfaceFormatsKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSurfaceFormatsKHR"));
                GetPhysicalDeviceSurfacePresentModesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceSurfacePresentModesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSurfacePresentModesKHR"));
            }
        },
        {
            "VK_KHR_display", [](VkInstance instance) {
                GetPhysicalDeviceDisplayPropertiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceDisplayPropertiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceDisplayPropertiesKHR"));
                GetPhysicalDeviceDisplayPlanePropertiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceDisplayPlanePropertiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceDisplayPlanePropertiesKHR"));
                GetDisplayPlaneSupportedDisplaysKHR = reinterpret_cast<PFN_vkGetDisplayPlaneSupportedDisplaysKHR>(GetInstanceProcAddr(instance, "vkGetDisplayPlaneSupportedDisplaysKHR"));
                GetDisplayModePropertiesKHR = reinterpret_cast<PFN_vkGetDisplayModePropertiesKHR>(GetInstanceProcAddr(instance, "vkGetDisplayModePropertiesKHR"));
                CreateDisplayModeKHR = reinterpret_cast<PFN_vkCreateDisplayModeKHR>(GetInstanceProcAddr(instance, "vkCreateDisplayModeKHR"));
                GetDisplayPlaneCapabilitiesKHR = reinterpret_cast<PFN_vkGetDisplayPlaneCapabilitiesKHR>(GetInstanceProcAddr(instance, "vkGetDisplayPlaneCapabilitiesKHR"));
                CreateDisplayPlaneSurfaceKHR = reinterpret_cast<PFN_vkCreateDisplayPlaneSurfaceKHR>(GetInstanceProcAddr(instance, "vkCreateDisplayPlaneSurfaceKHR"));
            }
        },
#ifdef VK_USE_PLATFORM_XLIB_KHR
        {
            "VK_KHR_xlib_surface", [](VkInstance instance) {
                CreateXlibSurfaceKHR = reinterpret_cast<PFN_vkCreateXlibSurfaceKHR>(GetInstanceProcAddr(instance, "vkCreateXlibSurfaceKHR"));
                GetPhysicalDeviceXlibPresentationSupportKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceXlibPresentationSupportKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceXlibPresentationSupportKHR"));
            }
        },
#endif  // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
        {
            "VK_KHR_xcb_surface", [](VkInstance instance) {
                CreateXcbSurfaceKHR = reinterpret_cast<PFN_vkCreateXcbSurfaceKHR>(GetInstanceProcAddr(instance, "vkCreateXcbSurfaceKHR"));
                GetPhysicalDeviceXcbPresentationSupportKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceXcbPresentationSupportKHR"));
            }
        },
#endif  // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
        {
            "VK_KHR_wayland_surface", [](VkInstance instance) {
                CreateWaylandSurfaceKHR = reinterpret_cast<PFN_vkCreateWaylandSurfaceKHR>(GetInstanceProcAddr(instance, "vkCreateWaylandSurfaceKHR"));
                GetPhysicalDeviceWaylandPresentationSupportKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceWaylandPresentationSupportKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceWaylandPresentationSupportKHR"));
            }
        },
#endif  // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
        {
            "VK_KHR_android_surface", [](VkInstance instance) {
                CreateAndroidSurfaceKHR = reinterpret_cast<PFN_vkCreateAndroidSurfaceKHR>(GetInstanceProcAddr(instance, "vkCreateAndroidSurfaceKHR"));
            }
        },
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_KHR_win32_surface", [](VkInstance instance) {
                CreateWin32SurfaceKHR = reinterpret_cast<PFN_vkCreateWin32SurfaceKHR>(GetInstanceProcAddr(instance, "vkCreateWin32SurfaceKHR"));
                GetPhysicalDeviceWin32PresentationSupportKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceWin32PresentationSupportKHR"));
            }
        },
#endif  // VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_KHR_get_physical_device_properties2", [](VkInstance instance) {
                GetPhysicalDeviceFeatures2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceFeatures2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceFeatures2KHR"));
                GetPhysicalDeviceProperties2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceProperties2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceProperties2KHR"));
                GetPhysicalDeviceFormatProperties2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceFormatProperties2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceFormatProperties2KHR"));
                GetPhysicalDeviceImageFormatProperties2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceImageFormatProperties2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceImageFormatProperties2KHR"));
                GetPhysicalDeviceQueueFamilyProperties2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceQueueFamilyProperties2KHR"));
                GetPhysicalDeviceMemoryProperties2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceMemoryProperties2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceMemoryProperties2KHR"));
                GetPhysicalDeviceSparseImageFormatProperties2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSparseImageFormatProperties2KHR"));
            }
        },
        {
            "VK_KHR_device_group_creation", [](VkInstance instance) {
                EnumeratePhysicalDeviceGroupsKHR = reinterpret_cast<PFN_vkEnumeratePhysicalDeviceGroupsKHR>(GetInstanceProcAddr(instance, "vkEnumeratePhysicalDeviceGroupsKHR"));
            }
        },
        {
            "VK_KHR_external_memory_capabilities", [](VkInstance instance) {
                GetPhysicalDeviceExternalBufferPropertiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceExternalBufferPropertiesKHR"));
            }
        },
        {
            "VK_KHR_external_semaphore_capabilities", [](VkInstance instance) {
                GetPhysicalDeviceExternalSemaphorePropertiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceExternalSemaphorePropertiesKHR"));
            }
        },
        {
            "VK_KHR_external_fence_capabilities", [](VkInstance instance) {
                GetPhysicalDeviceExternalFencePropertiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceExternalFencePropertiesKHR"));
            }
        },
        {
            "VK_KHR_get_surface_capabilities2", [](VkInstance instance) {
                GetPhysicalDeviceSurfaceCapabilities2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceSurfaceCapabilities2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSurfaceCapabilities2KHR"));
                GetPhysicalDeviceSurfaceFormats2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceSurfaceFormats2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSurfaceFormats2KHR"));
            }
        },
        {
            "VK_KHR_get_display_properties2", [](VkInstance instance) {
                GetPhysicalDeviceDisplayProperties2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceDisplayProperties2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceDisplayProperties2KHR"));
                GetPhysicalDeviceDisplayPlaneProperties2KHR = reinterpret_cast<PFN_vkGetPhysicalDeviceDisplayPlaneProperties2KHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceDisplayPlaneProperties2KHR"));
                GetDisplayModeProperties2KHR = reinterpret_cast<PFN_vkGetDisplayModeProperties2KHR>(GetInstanceProcAddr(instance, "vkGetDisplayModeProperties2KHR"));
                GetDisplayPlaneCapabilities2KHR = reinterpret_cast<PFN_vkGetDisplayPlaneCapabilities2KHR>(GetInstanceProcAddr(instance, "vkGetDisplayPlaneCapabilities2KHR"));
            }
        },
        {
            "VK_EXT_debug_report", [](VkInstance instance) {
                CreateDebugReportCallbackEXT = reinterpret_cast<PFN_vkCreateDebugReportCallbackEXT>(GetInstanceProcAddr(instance, "vkCreateDebugReportCallbackEXT"));
                DestroyDebugReportCallbackEXT = reinterpret_cast<PFN_vkDestroyDebugReportCallbackEXT>(GetInstanceProcAddr(instance, "vkDestroyDebugReportCallbackEXT"));
                DebugReportMessageEXT = reinterpret_cast<PFN_vkDebugReportMessageEXT>(GetInstanceProcAddr(instance, "vkDebugReportMessageEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_GGP
        {
            "VK_GGP_stream_descriptor_surface", [](VkInstance instance) {
                CreateStreamDescriptorSurfaceGGP = reinterpret_cast<PFN_vkCreateStreamDescriptorSurfaceGGP>(GetInstanceProcAddr(instance, "vkCreateStreamDescriptorSurfaceGGP"));
            }
        },
#endif  // VK_USE_PLATFORM_GGP
        {
            "VK_NV_external_memory_capabilities", [](VkInstance instance) {
                GetPhysicalDeviceExternalImageFormatPropertiesNV = reinterpret_cast<PFN_vkGetPhysicalDeviceExternalImageFormatPropertiesNV>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceExternalImageFormatPropertiesNV"));
            }
        },
#ifdef VK_USE_PLATFORM_VI_NN
        {
            "VK_NN_vi_surface", [](VkInstance instance) {
                CreateViSurfaceNN = reinterpret_cast<PFN_vkCreateViSurfaceNN>(GetInstanceProcAddr(instance, "vkCreateViSurfaceNN"));
            }
        },
#endif  // VK_USE_PLATFORM_VI_NN
        {
            "VK_EXT_direct_mode_display", [](VkInstance instance) {
                ReleaseDisplayEXT = reinterpret_cast<PFN_vkReleaseDisplayEXT>(GetInstanceProcAddr(instance, "vkReleaseDisplayEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
        {
            "VK_EXT_acquire_xlib_display", [](VkInstance instance) {
                AcquireXlibDisplayEXT = reinterpret_cast<PFN_vkAcquireXlibDisplayEXT>(GetInstanceProcAddr(instance, "vkAcquireXlibDisplayEXT"));
                GetRandROutputDisplayEXT = reinterpret_cast<PFN_vkGetRandROutputDisplayEXT>(GetInstanceProcAddr(instance, "vkGetRandROutputDisplayEXT"));
            }
        },
#endif  // VK_USE_PLATFORM_XLIB_XRANDR_EXT
        {
            "VK_EXT_display_surface_counter", [](VkInstance instance) {
                GetPhysicalDeviceSurfaceCapabilities2EXT = reinterpret_cast<PFN_vkGetPhysicalDeviceSurfaceCapabilities2EXT>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSurfaceCapabilities2EXT"));
            }
        },
#ifdef VK_USE_PLATFORM_IOS_MVK
        {
            "VK_MVK_ios_surface", [](VkInstance instance) {
                CreateIOSSurfaceMVK = reinterpret_cast<PFN_vkCreateIOSSurfaceMVK>(GetInstanceProcAddr(instance, "vkCreateIOSSurfaceMVK"));
            }
        },
#endif  // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
        {
            "VK_MVK_macos_surface", [](VkInstance instance) {
                CreateMacOSSurfaceMVK = reinterpret_cast<PFN_vkCreateMacOSSurfaceMVK>(GetInstanceProcAddr(instance, "vkCreateMacOSSurfaceMVK"));
            }
        },
#endif  // VK_USE_PLATFORM_MACOS_MVK
        {
            "VK_EXT_debug_utils", [](VkInstance instance) {
                SetDebugUtilsObjectNameEXT = reinterpret_cast<PFN_vkSetDebugUtilsObjectNameEXT>(GetInstanceProcAddr(instance, "vkSetDebugUtilsObjectNameEXT"));
                SetDebugUtilsObjectTagEXT = reinterpret_cast<PFN_vkSetDebugUtilsObjectTagEXT>(GetInstanceProcAddr(instance, "vkSetDebugUtilsObjectTagEXT"));
                QueueBeginDebugUtilsLabelEXT = reinterpret_cast<PFN_vkQueueBeginDebugUtilsLabelEXT>(GetInstanceProcAddr(instance, "vkQueueBeginDebugUtilsLabelEXT"));
                QueueEndDebugUtilsLabelEXT = reinterpret_cast<PFN_vkQueueEndDebugUtilsLabelEXT>(GetInstanceProcAddr(instance, "vkQueueEndDebugUtilsLabelEXT"));
                QueueInsertDebugUtilsLabelEXT = reinterpret_cast<PFN_vkQueueInsertDebugUtilsLabelEXT>(GetInstanceProcAddr(instance, "vkQueueInsertDebugUtilsLabelEXT"));
                CmdBeginDebugUtilsLabelEXT = reinterpret_cast<PFN_vkCmdBeginDebugUtilsLabelEXT>(GetInstanceProcAddr(instance, "vkCmdBeginDebugUtilsLabelEXT"));
                CmdEndDebugUtilsLabelEXT = reinterpret_cast<PFN_vkCmdEndDebugUtilsLabelEXT>(GetInstanceProcAddr(instance, "vkCmdEndDebugUtilsLabelEXT"));
                CmdInsertDebugUtilsLabelEXT = reinterpret_cast<PFN_vkCmdInsertDebugUtilsLabelEXT>(GetInstanceProcAddr(instance, "vkCmdInsertDebugUtilsLabelEXT"));
                CreateDebugUtilsMessengerEXT = reinterpret_cast<PFN_vkCreateDebugUtilsMessengerEXT>(GetInstanceProcAddr(instance, "vkCreateDebugUtilsMessengerEXT"));
                DestroyDebugUtilsMessengerEXT = reinterpret_cast<PFN_vkDestroyDebugUtilsMessengerEXT>(GetInstanceProcAddr(instance, "vkDestroyDebugUtilsMessengerEXT"));
                SubmitDebugUtilsMessageEXT = reinterpret_cast<PFN_vkSubmitDebugUtilsMessageEXT>(GetInstanceProcAddr(instance, "vkSubmitDebugUtilsMessageEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_FUCHSIA
        {
            "VK_FUCHSIA_imagepipe_surface", [](VkInstance instance) {
                CreateImagePipeSurfaceFUCHSIA = reinterpret_cast<PFN_vkCreateImagePipeSurfaceFUCHSIA>(GetInstanceProcAddr(instance, "vkCreateImagePipeSurfaceFUCHSIA"));
            }
        },
#endif  // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_METAL_EXT
        {
            "VK_EXT_metal_surface", [](VkInstance instance) {
                CreateMetalSurfaceEXT = reinterpret_cast<PFN_vkCreateMetalSurfaceEXT>(GetInstanceProcAddr(instance, "vkCreateMetalSurfaceEXT"));
            }
        },
#endif  // VK_USE_PLATFORM_METAL_EXT
        {
            "VK_EXT_headless_surface", [](VkInstance instance) {
                CreateHeadlessSurfaceEXT = reinterpret_cast<PFN_vkCreateHeadlessSurfaceEXT>(GetInstanceProcAddr(instance, "vkCreateHeadlessSurfaceEXT"));
            }
        },
        {
            "VK_EXT_acquire_drm_display", [](VkInstance instance) {
                AcquireDrmDisplayEXT = reinterpret_cast<PFN_vkAcquireDrmDisplayEXT>(GetInstanceProcAddr(instance, "vkAcquireDrmDisplayEXT"));
                GetDrmDisplayEXT = reinterpret_cast<PFN_vkGetDrmDisplayEXT>(GetInstanceProcAddr(instance, "vkGetDrmDisplayEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
        {
            "VK_EXT_directfb_surface", [](VkInstance instance) {
                CreateDirectFBSurfaceEXT = reinterpret_cast<PFN_vkCreateDirectFBSurfaceEXT>(GetInstanceProcAddr(instance, "vkCreateDirectFBSurfaceEXT"));
                GetPhysicalDeviceDirectFBPresentationSupportEXT = reinterpret_cast<PFN_vkGetPhysicalDeviceDirectFBPresentationSupportEXT>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceDirectFBPresentationSupportEXT"));
            }
        },
#endif  // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
        {
            "VK_QNX_screen_surface", [](VkInstance instance) {
                CreateScreenSurfaceQNX = reinterpret_cast<PFN_vkCreateScreenSurfaceQNX>(GetInstanceProcAddr(instance, "vkCreateScreenSurfaceQNX"));
                GetPhysicalDeviceScreenPresentationSupportQNX = reinterpret_cast<PFN_vkGetPhysicalDeviceScreenPresentationSupportQNX>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceScreenPresentationSupportQNX"));
            }
        },
#endif  // VK_USE_PLATFORM_SCREEN_QNX
#ifdef VK_USE_PLATFORM_OHOS
        {
            "VK_OHOS_surface", [](VkInstance instance) {
                CreateSurfaceOHOS = reinterpret_cast<PFN_vkCreateSurfaceOHOS>(GetInstanceProcAddr(instance, "vkCreateSurfaceOHOS"));
            }
        },
#endif  // VK_USE_PLATFORM_OHOS

    };

    if (auto it = initializers.find(extension_name); it != initializers.end())
        (it->second)(instance);
}

void InitDeviceExtension(VkInstance instance, VkDevice device, const char* extension_name) {
    static const vvl::unordered_map<std::string, std::function<void(VkInstance, VkDevice)>> initializers = {
        {
            "VK_KHR_swapchain", [](VkInstance instance, VkDevice device) {
                CreateSwapchainKHR = reinterpret_cast<PFN_vkCreateSwapchainKHR>(GetDeviceProcAddr(device, "vkCreateSwapchainKHR"));
                DestroySwapchainKHR = reinterpret_cast<PFN_vkDestroySwapchainKHR>(GetDeviceProcAddr(device, "vkDestroySwapchainKHR"));
                GetSwapchainImagesKHR = reinterpret_cast<PFN_vkGetSwapchainImagesKHR>(GetDeviceProcAddr(device, "vkGetSwapchainImagesKHR"));
                AcquireNextImageKHR = reinterpret_cast<PFN_vkAcquireNextImageKHR>(GetDeviceProcAddr(device, "vkAcquireNextImageKHR"));
                QueuePresentKHR = reinterpret_cast<PFN_vkQueuePresentKHR>(GetDeviceProcAddr(device, "vkQueuePresentKHR"));
                GetDeviceGroupPresentCapabilitiesKHR = reinterpret_cast<PFN_vkGetDeviceGroupPresentCapabilitiesKHR>(GetDeviceProcAddr(device, "vkGetDeviceGroupPresentCapabilitiesKHR"));
                GetDeviceGroupSurfacePresentModesKHR = reinterpret_cast<PFN_vkGetDeviceGroupSurfacePresentModesKHR>(GetDeviceProcAddr(device, "vkGetDeviceGroupSurfacePresentModesKHR"));
                AcquireNextImage2KHR = reinterpret_cast<PFN_vkAcquireNextImage2KHR>(GetDeviceProcAddr(device, "vkAcquireNextImage2KHR"));
                GetPhysicalDevicePresentRectanglesKHR = reinterpret_cast<PFN_vkGetPhysicalDevicePresentRectanglesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDevicePresentRectanglesKHR"));
            }
        },
        {
            "VK_KHR_display_swapchain", [](VkInstance , VkDevice device) {
                CreateSharedSwapchainsKHR = reinterpret_cast<PFN_vkCreateSharedSwapchainsKHR>(GetDeviceProcAddr(device, "vkCreateSharedSwapchainsKHR"));
            }
        },
        {
            "VK_KHR_video_queue", [](VkInstance instance, VkDevice device) {
                CreateVideoSessionKHR = reinterpret_cast<PFN_vkCreateVideoSessionKHR>(GetDeviceProcAddr(device, "vkCreateVideoSessionKHR"));
                DestroyVideoSessionKHR = reinterpret_cast<PFN_vkDestroyVideoSessionKHR>(GetDeviceProcAddr(device, "vkDestroyVideoSessionKHR"));
                GetVideoSessionMemoryRequirementsKHR = reinterpret_cast<PFN_vkGetVideoSessionMemoryRequirementsKHR>(GetDeviceProcAddr(device, "vkGetVideoSessionMemoryRequirementsKHR"));
                BindVideoSessionMemoryKHR = reinterpret_cast<PFN_vkBindVideoSessionMemoryKHR>(GetDeviceProcAddr(device, "vkBindVideoSessionMemoryKHR"));
                CreateVideoSessionParametersKHR = reinterpret_cast<PFN_vkCreateVideoSessionParametersKHR>(GetDeviceProcAddr(device, "vkCreateVideoSessionParametersKHR"));
                UpdateVideoSessionParametersKHR = reinterpret_cast<PFN_vkUpdateVideoSessionParametersKHR>(GetDeviceProcAddr(device, "vkUpdateVideoSessionParametersKHR"));
                DestroyVideoSessionParametersKHR = reinterpret_cast<PFN_vkDestroyVideoSessionParametersKHR>(GetDeviceProcAddr(device, "vkDestroyVideoSessionParametersKHR"));
                CmdBeginVideoCodingKHR = reinterpret_cast<PFN_vkCmdBeginVideoCodingKHR>(GetDeviceProcAddr(device, "vkCmdBeginVideoCodingKHR"));
                CmdEndVideoCodingKHR = reinterpret_cast<PFN_vkCmdEndVideoCodingKHR>(GetDeviceProcAddr(device, "vkCmdEndVideoCodingKHR"));
                CmdControlVideoCodingKHR = reinterpret_cast<PFN_vkCmdControlVideoCodingKHR>(GetDeviceProcAddr(device, "vkCmdControlVideoCodingKHR"));
                GetPhysicalDeviceVideoCapabilitiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceVideoCapabilitiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceVideoCapabilitiesKHR"));
                GetPhysicalDeviceVideoFormatPropertiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceVideoFormatPropertiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceVideoFormatPropertiesKHR"));
            }
        },
        {
            "VK_KHR_video_decode_queue", [](VkInstance , VkDevice device) {
                CmdDecodeVideoKHR = reinterpret_cast<PFN_vkCmdDecodeVideoKHR>(GetDeviceProcAddr(device, "vkCmdDecodeVideoKHR"));
            }
        },
        {
            "VK_KHR_dynamic_rendering", [](VkInstance , VkDevice device) {
                CmdBeginRenderingKHR = reinterpret_cast<PFN_vkCmdBeginRenderingKHR>(GetDeviceProcAddr(device, "vkCmdBeginRenderingKHR"));
                CmdEndRenderingKHR = reinterpret_cast<PFN_vkCmdEndRenderingKHR>(GetDeviceProcAddr(device, "vkCmdEndRenderingKHR"));
            }
        },
        {
            "VK_KHR_device_group", [](VkInstance instance, VkDevice device) {
                GetDeviceGroupPeerMemoryFeaturesKHR = reinterpret_cast<PFN_vkGetDeviceGroupPeerMemoryFeaturesKHR>(GetDeviceProcAddr(device, "vkGetDeviceGroupPeerMemoryFeaturesKHR"));
                CmdSetDeviceMaskKHR = reinterpret_cast<PFN_vkCmdSetDeviceMaskKHR>(GetDeviceProcAddr(device, "vkCmdSetDeviceMaskKHR"));
                CmdDispatchBaseKHR = reinterpret_cast<PFN_vkCmdDispatchBaseKHR>(GetDeviceProcAddr(device, "vkCmdDispatchBaseKHR"));
                GetDeviceGroupPresentCapabilitiesKHR = reinterpret_cast<PFN_vkGetDeviceGroupPresentCapabilitiesKHR>(GetDeviceProcAddr(device, "vkGetDeviceGroupPresentCapabilitiesKHR"));
                GetDeviceGroupSurfacePresentModesKHR = reinterpret_cast<PFN_vkGetDeviceGroupSurfacePresentModesKHR>(GetDeviceProcAddr(device, "vkGetDeviceGroupSurfacePresentModesKHR"));
                AcquireNextImage2KHR = reinterpret_cast<PFN_vkAcquireNextImage2KHR>(GetDeviceProcAddr(device, "vkAcquireNextImage2KHR"));
                GetPhysicalDevicePresentRectanglesKHR = reinterpret_cast<PFN_vkGetPhysicalDevicePresentRectanglesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDevicePresentRectanglesKHR"));
            }
        },
        {
            "VK_KHR_maintenance1", [](VkInstance , VkDevice device) {
                TrimCommandPoolKHR = reinterpret_cast<PFN_vkTrimCommandPoolKHR>(GetDeviceProcAddr(device, "vkTrimCommandPoolKHR"));
            }
        },
#ifdef VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_KHR_external_memory_win32", [](VkInstance , VkDevice device) {
                GetMemoryWin32HandleKHR = reinterpret_cast<PFN_vkGetMemoryWin32HandleKHR>(GetDeviceProcAddr(device, "vkGetMemoryWin32HandleKHR"));
                GetMemoryWin32HandlePropertiesKHR = reinterpret_cast<PFN_vkGetMemoryWin32HandlePropertiesKHR>(GetDeviceProcAddr(device, "vkGetMemoryWin32HandlePropertiesKHR"));
            }
        },
#endif  // VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_KHR_external_memory_fd", [](VkInstance , VkDevice device) {
                GetMemoryFdKHR = reinterpret_cast<PFN_vkGetMemoryFdKHR>(GetDeviceProcAddr(device, "vkGetMemoryFdKHR"));
                GetMemoryFdPropertiesKHR = reinterpret_cast<PFN_vkGetMemoryFdPropertiesKHR>(GetDeviceProcAddr(device, "vkGetMemoryFdPropertiesKHR"));
            }
        },
#ifdef VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_KHR_external_semaphore_win32", [](VkInstance , VkDevice device) {
                ImportSemaphoreWin32HandleKHR = reinterpret_cast<PFN_vkImportSemaphoreWin32HandleKHR>(GetDeviceProcAddr(device, "vkImportSemaphoreWin32HandleKHR"));
                GetSemaphoreWin32HandleKHR = reinterpret_cast<PFN_vkGetSemaphoreWin32HandleKHR>(GetDeviceProcAddr(device, "vkGetSemaphoreWin32HandleKHR"));
            }
        },
#endif  // VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_KHR_external_semaphore_fd", [](VkInstance , VkDevice device) {
                ImportSemaphoreFdKHR = reinterpret_cast<PFN_vkImportSemaphoreFdKHR>(GetDeviceProcAddr(device, "vkImportSemaphoreFdKHR"));
                GetSemaphoreFdKHR = reinterpret_cast<PFN_vkGetSemaphoreFdKHR>(GetDeviceProcAddr(device, "vkGetSemaphoreFdKHR"));
            }
        },
        {
            "VK_KHR_push_descriptor", [](VkInstance , VkDevice device) {
                CmdPushDescriptorSetKHR = reinterpret_cast<PFN_vkCmdPushDescriptorSetKHR>(GetDeviceProcAddr(device, "vkCmdPushDescriptorSetKHR"));
                CmdPushDescriptorSetWithTemplateKHR = reinterpret_cast<PFN_vkCmdPushDescriptorSetWithTemplateKHR>(GetDeviceProcAddr(device, "vkCmdPushDescriptorSetWithTemplateKHR"));
            }
        },
        {
            "VK_KHR_descriptor_update_template", [](VkInstance , VkDevice device) {
                CreateDescriptorUpdateTemplateKHR = reinterpret_cast<PFN_vkCreateDescriptorUpdateTemplateKHR>(GetDeviceProcAddr(device, "vkCreateDescriptorUpdateTemplateKHR"));
                DestroyDescriptorUpdateTemplateKHR = reinterpret_cast<PFN_vkDestroyDescriptorUpdateTemplateKHR>(GetDeviceProcAddr(device, "vkDestroyDescriptorUpdateTemplateKHR"));
                UpdateDescriptorSetWithTemplateKHR = reinterpret_cast<PFN_vkUpdateDescriptorSetWithTemplateKHR>(GetDeviceProcAddr(device, "vkUpdateDescriptorSetWithTemplateKHR"));
                CmdPushDescriptorSetWithTemplateKHR = reinterpret_cast<PFN_vkCmdPushDescriptorSetWithTemplateKHR>(GetDeviceProcAddr(device, "vkCmdPushDescriptorSetWithTemplateKHR"));
            }
        },
        {
            "VK_KHR_create_renderpass2", [](VkInstance , VkDevice device) {
                CreateRenderPass2KHR = reinterpret_cast<PFN_vkCreateRenderPass2KHR>(GetDeviceProcAddr(device, "vkCreateRenderPass2KHR"));
                CmdBeginRenderPass2KHR = reinterpret_cast<PFN_vkCmdBeginRenderPass2KHR>(GetDeviceProcAddr(device, "vkCmdBeginRenderPass2KHR"));
                CmdNextSubpass2KHR = reinterpret_cast<PFN_vkCmdNextSubpass2KHR>(GetDeviceProcAddr(device, "vkCmdNextSubpass2KHR"));
                CmdEndRenderPass2KHR = reinterpret_cast<PFN_vkCmdEndRenderPass2KHR>(GetDeviceProcAddr(device, "vkCmdEndRenderPass2KHR"));
            }
        },
        {
            "VK_KHR_shared_presentable_image", [](VkInstance , VkDevice device) {
                GetSwapchainStatusKHR = reinterpret_cast<PFN_vkGetSwapchainStatusKHR>(GetDeviceProcAddr(device, "vkGetSwapchainStatusKHR"));
            }
        },
#ifdef VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_KHR_external_fence_win32", [](VkInstance , VkDevice device) {
                ImportFenceWin32HandleKHR = reinterpret_cast<PFN_vkImportFenceWin32HandleKHR>(GetDeviceProcAddr(device, "vkImportFenceWin32HandleKHR"));
                GetFenceWin32HandleKHR = reinterpret_cast<PFN_vkGetFenceWin32HandleKHR>(GetDeviceProcAddr(device, "vkGetFenceWin32HandleKHR"));
            }
        },
#endif  // VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_KHR_external_fence_fd", [](VkInstance , VkDevice device) {
                ImportFenceFdKHR = reinterpret_cast<PFN_vkImportFenceFdKHR>(GetDeviceProcAddr(device, "vkImportFenceFdKHR"));
                GetFenceFdKHR = reinterpret_cast<PFN_vkGetFenceFdKHR>(GetDeviceProcAddr(device, "vkGetFenceFdKHR"));
            }
        },
        {
            "VK_KHR_performance_query", [](VkInstance instance, VkDevice device) {
                AcquireProfilingLockKHR = reinterpret_cast<PFN_vkAcquireProfilingLockKHR>(GetDeviceProcAddr(device, "vkAcquireProfilingLockKHR"));
                ReleaseProfilingLockKHR = reinterpret_cast<PFN_vkReleaseProfilingLockKHR>(GetDeviceProcAddr(device, "vkReleaseProfilingLockKHR"));
                EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = reinterpret_cast<PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR>(GetInstanceProcAddr(instance, "vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR"));
                GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR"));
            }
        },
        {
            "VK_KHR_get_memory_requirements2", [](VkInstance , VkDevice device) {
                GetImageMemoryRequirements2KHR = reinterpret_cast<PFN_vkGetImageMemoryRequirements2KHR>(GetDeviceProcAddr(device, "vkGetImageMemoryRequirements2KHR"));
                GetBufferMemoryRequirements2KHR = reinterpret_cast<PFN_vkGetBufferMemoryRequirements2KHR>(GetDeviceProcAddr(device, "vkGetBufferMemoryRequirements2KHR"));
                GetImageSparseMemoryRequirements2KHR = reinterpret_cast<PFN_vkGetImageSparseMemoryRequirements2KHR>(GetDeviceProcAddr(device, "vkGetImageSparseMemoryRequirements2KHR"));
            }
        },
        {
            "VK_KHR_sampler_ycbcr_conversion", [](VkInstance , VkDevice device) {
                CreateSamplerYcbcrConversionKHR = reinterpret_cast<PFN_vkCreateSamplerYcbcrConversionKHR>(GetDeviceProcAddr(device, "vkCreateSamplerYcbcrConversionKHR"));
                DestroySamplerYcbcrConversionKHR = reinterpret_cast<PFN_vkDestroySamplerYcbcrConversionKHR>(GetDeviceProcAddr(device, "vkDestroySamplerYcbcrConversionKHR"));
            }
        },
        {
            "VK_KHR_bind_memory2", [](VkInstance , VkDevice device) {
                BindBufferMemory2KHR = reinterpret_cast<PFN_vkBindBufferMemory2KHR>(GetDeviceProcAddr(device, "vkBindBufferMemory2KHR"));
                BindImageMemory2KHR = reinterpret_cast<PFN_vkBindImageMemory2KHR>(GetDeviceProcAddr(device, "vkBindImageMemory2KHR"));
            }
        },
        {
            "VK_KHR_maintenance3", [](VkInstance , VkDevice device) {
                GetDescriptorSetLayoutSupportKHR = reinterpret_cast<PFN_vkGetDescriptorSetLayoutSupportKHR>(GetDeviceProcAddr(device, "vkGetDescriptorSetLayoutSupportKHR"));
            }
        },
        {
            "VK_KHR_draw_indirect_count", [](VkInstance , VkDevice device) {
                CmdDrawIndirectCountKHR = reinterpret_cast<PFN_vkCmdDrawIndirectCountKHR>(GetDeviceProcAddr(device, "vkCmdDrawIndirectCountKHR"));
                CmdDrawIndexedIndirectCountKHR = reinterpret_cast<PFN_vkCmdDrawIndexedIndirectCountKHR>(GetDeviceProcAddr(device, "vkCmdDrawIndexedIndirectCountKHR"));
            }
        },
        {
            "VK_KHR_timeline_semaphore", [](VkInstance , VkDevice device) {
                GetSemaphoreCounterValueKHR = reinterpret_cast<PFN_vkGetSemaphoreCounterValueKHR>(GetDeviceProcAddr(device, "vkGetSemaphoreCounterValueKHR"));
                WaitSemaphoresKHR = reinterpret_cast<PFN_vkWaitSemaphoresKHR>(GetDeviceProcAddr(device, "vkWaitSemaphoresKHR"));
                SignalSemaphoreKHR = reinterpret_cast<PFN_vkSignalSemaphoreKHR>(GetDeviceProcAddr(device, "vkSignalSemaphoreKHR"));
            }
        },
        {
            "VK_KHR_fragment_shading_rate", [](VkInstance instance, VkDevice device) {
                CmdSetFragmentShadingRateKHR = reinterpret_cast<PFN_vkCmdSetFragmentShadingRateKHR>(GetDeviceProcAddr(device, "vkCmdSetFragmentShadingRateKHR"));
                GetPhysicalDeviceFragmentShadingRatesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceFragmentShadingRatesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceFragmentShadingRatesKHR"));
            }
        },
        {
            "VK_KHR_dynamic_rendering_local_read", [](VkInstance , VkDevice device) {
                CmdSetRenderingAttachmentLocationsKHR = reinterpret_cast<PFN_vkCmdSetRenderingAttachmentLocationsKHR>(GetDeviceProcAddr(device, "vkCmdSetRenderingAttachmentLocationsKHR"));
                CmdSetRenderingInputAttachmentIndicesKHR = reinterpret_cast<PFN_vkCmdSetRenderingInputAttachmentIndicesKHR>(GetDeviceProcAddr(device, "vkCmdSetRenderingInputAttachmentIndicesKHR"));
            }
        },
        {
            "VK_KHR_present_wait", [](VkInstance , VkDevice device) {
                WaitForPresentKHR = reinterpret_cast<PFN_vkWaitForPresentKHR>(GetDeviceProcAddr(device, "vkWaitForPresentKHR"));
            }
        },
        {
            "VK_KHR_buffer_device_address", [](VkInstance , VkDevice device) {
                GetBufferDeviceAddressKHR = reinterpret_cast<PFN_vkGetBufferDeviceAddressKHR>(GetDeviceProcAddr(device, "vkGetBufferDeviceAddressKHR"));
                GetBufferOpaqueCaptureAddressKHR = reinterpret_cast<PFN_vkGetBufferOpaqueCaptureAddressKHR>(GetDeviceProcAddr(device, "vkGetBufferOpaqueCaptureAddressKHR"));
                GetDeviceMemoryOpaqueCaptureAddressKHR = reinterpret_cast<PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR>(GetDeviceProcAddr(device, "vkGetDeviceMemoryOpaqueCaptureAddressKHR"));
            }
        },
        {
            "VK_KHR_deferred_host_operations", [](VkInstance , VkDevice device) {
                CreateDeferredOperationKHR = reinterpret_cast<PFN_vkCreateDeferredOperationKHR>(GetDeviceProcAddr(device, "vkCreateDeferredOperationKHR"));
                DestroyDeferredOperationKHR = reinterpret_cast<PFN_vkDestroyDeferredOperationKHR>(GetDeviceProcAddr(device, "vkDestroyDeferredOperationKHR"));
                GetDeferredOperationMaxConcurrencyKHR = reinterpret_cast<PFN_vkGetDeferredOperationMaxConcurrencyKHR>(GetDeviceProcAddr(device, "vkGetDeferredOperationMaxConcurrencyKHR"));
                GetDeferredOperationResultKHR = reinterpret_cast<PFN_vkGetDeferredOperationResultKHR>(GetDeviceProcAddr(device, "vkGetDeferredOperationResultKHR"));
                DeferredOperationJoinKHR = reinterpret_cast<PFN_vkDeferredOperationJoinKHR>(GetDeviceProcAddr(device, "vkDeferredOperationJoinKHR"));
            }
        },
        {
            "VK_KHR_pipeline_executable_properties", [](VkInstance , VkDevice device) {
                GetPipelineExecutablePropertiesKHR = reinterpret_cast<PFN_vkGetPipelineExecutablePropertiesKHR>(GetDeviceProcAddr(device, "vkGetPipelineExecutablePropertiesKHR"));
                GetPipelineExecutableStatisticsKHR = reinterpret_cast<PFN_vkGetPipelineExecutableStatisticsKHR>(GetDeviceProcAddr(device, "vkGetPipelineExecutableStatisticsKHR"));
                GetPipelineExecutableInternalRepresentationsKHR = reinterpret_cast<PFN_vkGetPipelineExecutableInternalRepresentationsKHR>(GetDeviceProcAddr(device, "vkGetPipelineExecutableInternalRepresentationsKHR"));
            }
        },
        {
            "VK_KHR_map_memory2", [](VkInstance , VkDevice device) {
                MapMemory2KHR = reinterpret_cast<PFN_vkMapMemory2KHR>(GetDeviceProcAddr(device, "vkMapMemory2KHR"));
                UnmapMemory2KHR = reinterpret_cast<PFN_vkUnmapMemory2KHR>(GetDeviceProcAddr(device, "vkUnmapMemory2KHR"));
            }
        },
        {
            "VK_KHR_video_encode_queue", [](VkInstance instance, VkDevice device) {
                GetEncodedVideoSessionParametersKHR = reinterpret_cast<PFN_vkGetEncodedVideoSessionParametersKHR>(GetDeviceProcAddr(device, "vkGetEncodedVideoSessionParametersKHR"));
                CmdEncodeVideoKHR = reinterpret_cast<PFN_vkCmdEncodeVideoKHR>(GetDeviceProcAddr(device, "vkCmdEncodeVideoKHR"));
                GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR"));
            }
        },
        {
            "VK_KHR_synchronization2", [](VkInstance , VkDevice device) {
                CmdSetEvent2KHR = reinterpret_cast<PFN_vkCmdSetEvent2KHR>(GetDeviceProcAddr(device, "vkCmdSetEvent2KHR"));
                CmdResetEvent2KHR = reinterpret_cast<PFN_vkCmdResetEvent2KHR>(GetDeviceProcAddr(device, "vkCmdResetEvent2KHR"));
                CmdWaitEvents2KHR = reinterpret_cast<PFN_vkCmdWaitEvents2KHR>(GetDeviceProcAddr(device, "vkCmdWaitEvents2KHR"));
                CmdPipelineBarrier2KHR = reinterpret_cast<PFN_vkCmdPipelineBarrier2KHR>(GetDeviceProcAddr(device, "vkCmdPipelineBarrier2KHR"));
                CmdWriteTimestamp2KHR = reinterpret_cast<PFN_vkCmdWriteTimestamp2KHR>(GetDeviceProcAddr(device, "vkCmdWriteTimestamp2KHR"));
                QueueSubmit2KHR = reinterpret_cast<PFN_vkQueueSubmit2KHR>(GetDeviceProcAddr(device, "vkQueueSubmit2KHR"));
            }
        },
        {
            "VK_KHR_copy_commands2", [](VkInstance , VkDevice device) {
                CmdCopyBuffer2KHR = reinterpret_cast<PFN_vkCmdCopyBuffer2KHR>(GetDeviceProcAddr(device, "vkCmdCopyBuffer2KHR"));
                CmdCopyImage2KHR = reinterpret_cast<PFN_vkCmdCopyImage2KHR>(GetDeviceProcAddr(device, "vkCmdCopyImage2KHR"));
                CmdCopyBufferToImage2KHR = reinterpret_cast<PFN_vkCmdCopyBufferToImage2KHR>(GetDeviceProcAddr(device, "vkCmdCopyBufferToImage2KHR"));
                CmdCopyImageToBuffer2KHR = reinterpret_cast<PFN_vkCmdCopyImageToBuffer2KHR>(GetDeviceProcAddr(device, "vkCmdCopyImageToBuffer2KHR"));
                CmdBlitImage2KHR = reinterpret_cast<PFN_vkCmdBlitImage2KHR>(GetDeviceProcAddr(device, "vkCmdBlitImage2KHR"));
                CmdResolveImage2KHR = reinterpret_cast<PFN_vkCmdResolveImage2KHR>(GetDeviceProcAddr(device, "vkCmdResolveImage2KHR"));
            }
        },
        {
            "VK_KHR_ray_tracing_maintenance1", [](VkInstance , VkDevice device) {
                CmdTraceRaysIndirect2KHR = reinterpret_cast<PFN_vkCmdTraceRaysIndirect2KHR>(GetDeviceProcAddr(device, "vkCmdTraceRaysIndirect2KHR"));
            }
        },
        {
            "VK_KHR_maintenance4", [](VkInstance , VkDevice device) {
                GetDeviceBufferMemoryRequirementsKHR = reinterpret_cast<PFN_vkGetDeviceBufferMemoryRequirementsKHR>(GetDeviceProcAddr(device, "vkGetDeviceBufferMemoryRequirementsKHR"));
                GetDeviceImageMemoryRequirementsKHR = reinterpret_cast<PFN_vkGetDeviceImageMemoryRequirementsKHR>(GetDeviceProcAddr(device, "vkGetDeviceImageMemoryRequirementsKHR"));
                GetDeviceImageSparseMemoryRequirementsKHR = reinterpret_cast<PFN_vkGetDeviceImageSparseMemoryRequirementsKHR>(GetDeviceProcAddr(device, "vkGetDeviceImageSparseMemoryRequirementsKHR"));
            }
        },
        {
            "VK_KHR_maintenance5", [](VkInstance , VkDevice device) {
                CmdBindIndexBuffer2KHR = reinterpret_cast<PFN_vkCmdBindIndexBuffer2KHR>(GetDeviceProcAddr(device, "vkCmdBindIndexBuffer2KHR"));
                GetRenderingAreaGranularityKHR = reinterpret_cast<PFN_vkGetRenderingAreaGranularityKHR>(GetDeviceProcAddr(device, "vkGetRenderingAreaGranularityKHR"));
                GetDeviceImageSubresourceLayoutKHR = reinterpret_cast<PFN_vkGetDeviceImageSubresourceLayoutKHR>(GetDeviceProcAddr(device, "vkGetDeviceImageSubresourceLayoutKHR"));
                GetImageSubresourceLayout2KHR = reinterpret_cast<PFN_vkGetImageSubresourceLayout2KHR>(GetDeviceProcAddr(device, "vkGetImageSubresourceLayout2KHR"));
            }
        },
        {
            "VK_KHR_present_wait2", [](VkInstance , VkDevice device) {
                WaitForPresent2KHR = reinterpret_cast<PFN_vkWaitForPresent2KHR>(GetDeviceProcAddr(device, "vkWaitForPresent2KHR"));
            }
        },
        {
            "VK_KHR_pipeline_binary", [](VkInstance , VkDevice device) {
                CreatePipelineBinariesKHR = reinterpret_cast<PFN_vkCreatePipelineBinariesKHR>(GetDeviceProcAddr(device, "vkCreatePipelineBinariesKHR"));
                DestroyPipelineBinaryKHR = reinterpret_cast<PFN_vkDestroyPipelineBinaryKHR>(GetDeviceProcAddr(device, "vkDestroyPipelineBinaryKHR"));
                GetPipelineKeyKHR = reinterpret_cast<PFN_vkGetPipelineKeyKHR>(GetDeviceProcAddr(device, "vkGetPipelineKeyKHR"));
                GetPipelineBinaryDataKHR = reinterpret_cast<PFN_vkGetPipelineBinaryDataKHR>(GetDeviceProcAddr(device, "vkGetPipelineBinaryDataKHR"));
                ReleaseCapturedPipelineDataKHR = reinterpret_cast<PFN_vkReleaseCapturedPipelineDataKHR>(GetDeviceProcAddr(device, "vkReleaseCapturedPipelineDataKHR"));
            }
        },
        {
            "VK_KHR_swapchain_maintenance1", [](VkInstance , VkDevice device) {
                ReleaseSwapchainImagesKHR = reinterpret_cast<PFN_vkReleaseSwapchainImagesKHR>(GetDeviceProcAddr(device, "vkReleaseSwapchainImagesKHR"));
            }
        },
        {
            "VK_KHR_cooperative_matrix", [](VkInstance instance, VkDevice ) {
                GetPhysicalDeviceCooperativeMatrixPropertiesKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR"));
            }
        },
        {
            "VK_KHR_line_rasterization", [](VkInstance , VkDevice device) {
                CmdSetLineStippleKHR = reinterpret_cast<PFN_vkCmdSetLineStippleKHR>(GetDeviceProcAddr(device, "vkCmdSetLineStippleKHR"));
            }
        },
        {
            "VK_KHR_calibrated_timestamps", [](VkInstance instance, VkDevice device) {
                GetCalibratedTimestampsKHR = reinterpret_cast<PFN_vkGetCalibratedTimestampsKHR>(GetDeviceProcAddr(device, "vkGetCalibratedTimestampsKHR"));
                GetPhysicalDeviceCalibrateableTimeDomainsKHR = reinterpret_cast<PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceCalibrateableTimeDomainsKHR"));
            }
        },
        {
            "VK_KHR_maintenance6", [](VkInstance , VkDevice device) {
                CmdBindDescriptorSets2KHR = reinterpret_cast<PFN_vkCmdBindDescriptorSets2KHR>(GetDeviceProcAddr(device, "vkCmdBindDescriptorSets2KHR"));
                CmdPushConstants2KHR = reinterpret_cast<PFN_vkCmdPushConstants2KHR>(GetDeviceProcAddr(device, "vkCmdPushConstants2KHR"));
                CmdPushDescriptorSet2KHR = reinterpret_cast<PFN_vkCmdPushDescriptorSet2KHR>(GetDeviceProcAddr(device, "vkCmdPushDescriptorSet2KHR"));
                CmdPushDescriptorSetWithTemplate2KHR = reinterpret_cast<PFN_vkCmdPushDescriptorSetWithTemplate2KHR>(GetDeviceProcAddr(device, "vkCmdPushDescriptorSetWithTemplate2KHR"));
                CmdSetDescriptorBufferOffsets2EXT = reinterpret_cast<PFN_vkCmdSetDescriptorBufferOffsets2EXT>(GetDeviceProcAddr(device, "vkCmdSetDescriptorBufferOffsets2EXT"));
                CmdBindDescriptorBufferEmbeddedSamplers2EXT = reinterpret_cast<PFN_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT>(GetDeviceProcAddr(device, "vkCmdBindDescriptorBufferEmbeddedSamplers2EXT"));
            }
        },
        {
            "VK_KHR_copy_memory_indirect", [](VkInstance , VkDevice device) {
                CmdCopyMemoryIndirectKHR = reinterpret_cast<PFN_vkCmdCopyMemoryIndirectKHR>(GetDeviceProcAddr(device, "vkCmdCopyMemoryIndirectKHR"));
                CmdCopyMemoryToImageIndirectKHR = reinterpret_cast<PFN_vkCmdCopyMemoryToImageIndirectKHR>(GetDeviceProcAddr(device, "vkCmdCopyMemoryToImageIndirectKHR"));
            }
        },
        {
            "VK_KHR_maintenance10", [](VkInstance , VkDevice device) {
                CmdEndRendering2KHR = reinterpret_cast<PFN_vkCmdEndRendering2KHR>(GetDeviceProcAddr(device, "vkCmdEndRendering2KHR"));
            }
        },
        {
            "VK_EXT_debug_marker", [](VkInstance , VkDevice device) {
                DebugMarkerSetObjectTagEXT = reinterpret_cast<PFN_vkDebugMarkerSetObjectTagEXT>(GetDeviceProcAddr(device, "vkDebugMarkerSetObjectTagEXT"));
                DebugMarkerSetObjectNameEXT = reinterpret_cast<PFN_vkDebugMarkerSetObjectNameEXT>(GetDeviceProcAddr(device, "vkDebugMarkerSetObjectNameEXT"));
                CmdDebugMarkerBeginEXT = reinterpret_cast<PFN_vkCmdDebugMarkerBeginEXT>(GetDeviceProcAddr(device, "vkCmdDebugMarkerBeginEXT"));
                CmdDebugMarkerEndEXT = reinterpret_cast<PFN_vkCmdDebugMarkerEndEXT>(GetDeviceProcAddr(device, "vkCmdDebugMarkerEndEXT"));
                CmdDebugMarkerInsertEXT = reinterpret_cast<PFN_vkCmdDebugMarkerInsertEXT>(GetDeviceProcAddr(device, "vkCmdDebugMarkerInsertEXT"));
            }
        },
        {
            "VK_EXT_transform_feedback", [](VkInstance , VkDevice device) {
                CmdBindTransformFeedbackBuffersEXT = reinterpret_cast<PFN_vkCmdBindTransformFeedbackBuffersEXT>(GetDeviceProcAddr(device, "vkCmdBindTransformFeedbackBuffersEXT"));
                CmdBeginTransformFeedbackEXT = reinterpret_cast<PFN_vkCmdBeginTransformFeedbackEXT>(GetDeviceProcAddr(device, "vkCmdBeginTransformFeedbackEXT"));
                CmdEndTransformFeedbackEXT = reinterpret_cast<PFN_vkCmdEndTransformFeedbackEXT>(GetDeviceProcAddr(device, "vkCmdEndTransformFeedbackEXT"));
                CmdBeginQueryIndexedEXT = reinterpret_cast<PFN_vkCmdBeginQueryIndexedEXT>(GetDeviceProcAddr(device, "vkCmdBeginQueryIndexedEXT"));
                CmdEndQueryIndexedEXT = reinterpret_cast<PFN_vkCmdEndQueryIndexedEXT>(GetDeviceProcAddr(device, "vkCmdEndQueryIndexedEXT"));
                CmdDrawIndirectByteCountEXT = reinterpret_cast<PFN_vkCmdDrawIndirectByteCountEXT>(GetDeviceProcAddr(device, "vkCmdDrawIndirectByteCountEXT"));
            }
        },
        {
            "VK_NVX_binary_import", [](VkInstance , VkDevice device) {
                CreateCuModuleNVX = reinterpret_cast<PFN_vkCreateCuModuleNVX>(GetDeviceProcAddr(device, "vkCreateCuModuleNVX"));
                CreateCuFunctionNVX = reinterpret_cast<PFN_vkCreateCuFunctionNVX>(GetDeviceProcAddr(device, "vkCreateCuFunctionNVX"));
                DestroyCuModuleNVX = reinterpret_cast<PFN_vkDestroyCuModuleNVX>(GetDeviceProcAddr(device, "vkDestroyCuModuleNVX"));
                DestroyCuFunctionNVX = reinterpret_cast<PFN_vkDestroyCuFunctionNVX>(GetDeviceProcAddr(device, "vkDestroyCuFunctionNVX"));
                CmdCuLaunchKernelNVX = reinterpret_cast<PFN_vkCmdCuLaunchKernelNVX>(GetDeviceProcAddr(device, "vkCmdCuLaunchKernelNVX"));
            }
        },
        {
            "VK_NVX_image_view_handle", [](VkInstance , VkDevice device) {
                GetImageViewHandleNVX = reinterpret_cast<PFN_vkGetImageViewHandleNVX>(GetDeviceProcAddr(device, "vkGetImageViewHandleNVX"));
                GetImageViewHandle64NVX = reinterpret_cast<PFN_vkGetImageViewHandle64NVX>(GetDeviceProcAddr(device, "vkGetImageViewHandle64NVX"));
                GetImageViewAddressNVX = reinterpret_cast<PFN_vkGetImageViewAddressNVX>(GetDeviceProcAddr(device, "vkGetImageViewAddressNVX"));
            }
        },
        {
            "VK_AMD_draw_indirect_count", [](VkInstance , VkDevice device) {
                CmdDrawIndirectCountAMD = reinterpret_cast<PFN_vkCmdDrawIndirectCountAMD>(GetDeviceProcAddr(device, "vkCmdDrawIndirectCountAMD"));
                CmdDrawIndexedIndirectCountAMD = reinterpret_cast<PFN_vkCmdDrawIndexedIndirectCountAMD>(GetDeviceProcAddr(device, "vkCmdDrawIndexedIndirectCountAMD"));
            }
        },
        {
            "VK_AMD_shader_info", [](VkInstance , VkDevice device) {
                GetShaderInfoAMD = reinterpret_cast<PFN_vkGetShaderInfoAMD>(GetDeviceProcAddr(device, "vkGetShaderInfoAMD"));
            }
        },
#ifdef VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_NV_external_memory_win32", [](VkInstance , VkDevice device) {
                GetMemoryWin32HandleNV = reinterpret_cast<PFN_vkGetMemoryWin32HandleNV>(GetDeviceProcAddr(device, "vkGetMemoryWin32HandleNV"));
            }
        },
#endif  // VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_EXT_conditional_rendering", [](VkInstance , VkDevice device) {
                CmdBeginConditionalRenderingEXT = reinterpret_cast<PFN_vkCmdBeginConditionalRenderingEXT>(GetDeviceProcAddr(device, "vkCmdBeginConditionalRenderingEXT"));
                CmdEndConditionalRenderingEXT = reinterpret_cast<PFN_vkCmdEndConditionalRenderingEXT>(GetDeviceProcAddr(device, "vkCmdEndConditionalRenderingEXT"));
            }
        },
        {
            "VK_NV_clip_space_w_scaling", [](VkInstance , VkDevice device) {
                CmdSetViewportWScalingNV = reinterpret_cast<PFN_vkCmdSetViewportWScalingNV>(GetDeviceProcAddr(device, "vkCmdSetViewportWScalingNV"));
            }
        },
        {
            "VK_EXT_display_control", [](VkInstance , VkDevice device) {
                DisplayPowerControlEXT = reinterpret_cast<PFN_vkDisplayPowerControlEXT>(GetDeviceProcAddr(device, "vkDisplayPowerControlEXT"));
                RegisterDeviceEventEXT = reinterpret_cast<PFN_vkRegisterDeviceEventEXT>(GetDeviceProcAddr(device, "vkRegisterDeviceEventEXT"));
                RegisterDisplayEventEXT = reinterpret_cast<PFN_vkRegisterDisplayEventEXT>(GetDeviceProcAddr(device, "vkRegisterDisplayEventEXT"));
                GetSwapchainCounterEXT = reinterpret_cast<PFN_vkGetSwapchainCounterEXT>(GetDeviceProcAddr(device, "vkGetSwapchainCounterEXT"));
            }
        },
        {
            "VK_GOOGLE_display_timing", [](VkInstance , VkDevice device) {
                GetRefreshCycleDurationGOOGLE = reinterpret_cast<PFN_vkGetRefreshCycleDurationGOOGLE>(GetDeviceProcAddr(device, "vkGetRefreshCycleDurationGOOGLE"));
                GetPastPresentationTimingGOOGLE = reinterpret_cast<PFN_vkGetPastPresentationTimingGOOGLE>(GetDeviceProcAddr(device, "vkGetPastPresentationTimingGOOGLE"));
            }
        },
        {
            "VK_EXT_discard_rectangles", [](VkInstance , VkDevice device) {
                CmdSetDiscardRectangleEXT = reinterpret_cast<PFN_vkCmdSetDiscardRectangleEXT>(GetDeviceProcAddr(device, "vkCmdSetDiscardRectangleEXT"));
                CmdSetDiscardRectangleEnableEXT = reinterpret_cast<PFN_vkCmdSetDiscardRectangleEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDiscardRectangleEnableEXT"));
                CmdSetDiscardRectangleModeEXT = reinterpret_cast<PFN_vkCmdSetDiscardRectangleModeEXT>(GetDeviceProcAddr(device, "vkCmdSetDiscardRectangleModeEXT"));
            }
        },
        {
            "VK_EXT_hdr_metadata", [](VkInstance , VkDevice device) {
                SetHdrMetadataEXT = reinterpret_cast<PFN_vkSetHdrMetadataEXT>(GetDeviceProcAddr(device, "vkSetHdrMetadataEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_ANDROID_KHR
        {
            "VK_ANDROID_external_memory_android_hardware_buffer", [](VkInstance , VkDevice device) {
                GetAndroidHardwareBufferPropertiesANDROID = reinterpret_cast<PFN_vkGetAndroidHardwareBufferPropertiesANDROID>(GetDeviceProcAddr(device, "vkGetAndroidHardwareBufferPropertiesANDROID"));
                GetMemoryAndroidHardwareBufferANDROID = reinterpret_cast<PFN_vkGetMemoryAndroidHardwareBufferANDROID>(GetDeviceProcAddr(device, "vkGetMemoryAndroidHardwareBufferANDROID"));
            }
        },
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_ENABLE_BETA_EXTENSIONS
        {
            "VK_AMDX_shader_enqueue", [](VkInstance , VkDevice device) {
                CreateExecutionGraphPipelinesAMDX = reinterpret_cast<PFN_vkCreateExecutionGraphPipelinesAMDX>(GetDeviceProcAddr(device, "vkCreateExecutionGraphPipelinesAMDX"));
                GetExecutionGraphPipelineScratchSizeAMDX = reinterpret_cast<PFN_vkGetExecutionGraphPipelineScratchSizeAMDX>(GetDeviceProcAddr(device, "vkGetExecutionGraphPipelineScratchSizeAMDX"));
                GetExecutionGraphPipelineNodeIndexAMDX = reinterpret_cast<PFN_vkGetExecutionGraphPipelineNodeIndexAMDX>(GetDeviceProcAddr(device, "vkGetExecutionGraphPipelineNodeIndexAMDX"));
                CmdInitializeGraphScratchMemoryAMDX = reinterpret_cast<PFN_vkCmdInitializeGraphScratchMemoryAMDX>(GetDeviceProcAddr(device, "vkCmdInitializeGraphScratchMemoryAMDX"));
                CmdDispatchGraphAMDX = reinterpret_cast<PFN_vkCmdDispatchGraphAMDX>(GetDeviceProcAddr(device, "vkCmdDispatchGraphAMDX"));
                CmdDispatchGraphIndirectAMDX = reinterpret_cast<PFN_vkCmdDispatchGraphIndirectAMDX>(GetDeviceProcAddr(device, "vkCmdDispatchGraphIndirectAMDX"));
                CmdDispatchGraphIndirectCountAMDX = reinterpret_cast<PFN_vkCmdDispatchGraphIndirectCountAMDX>(GetDeviceProcAddr(device, "vkCmdDispatchGraphIndirectCountAMDX"));
            }
        },
#endif  // VK_ENABLE_BETA_EXTENSIONS
        {
            "VK_EXT_sample_locations", [](VkInstance instance, VkDevice device) {
                CmdSetSampleLocationsEXT = reinterpret_cast<PFN_vkCmdSetSampleLocationsEXT>(GetDeviceProcAddr(device, "vkCmdSetSampleLocationsEXT"));
                GetPhysicalDeviceMultisamplePropertiesEXT = reinterpret_cast<PFN_vkGetPhysicalDeviceMultisamplePropertiesEXT>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceMultisamplePropertiesEXT"));
            }
        },
        {
            "VK_EXT_image_drm_format_modifier", [](VkInstance , VkDevice device) {
                GetImageDrmFormatModifierPropertiesEXT = reinterpret_cast<PFN_vkGetImageDrmFormatModifierPropertiesEXT>(GetDeviceProcAddr(device, "vkGetImageDrmFormatModifierPropertiesEXT"));
            }
        },
        {
            "VK_EXT_validation_cache", [](VkInstance , VkDevice device) {
                CreateValidationCacheEXT = reinterpret_cast<PFN_vkCreateValidationCacheEXT>(GetDeviceProcAddr(device, "vkCreateValidationCacheEXT"));
                DestroyValidationCacheEXT = reinterpret_cast<PFN_vkDestroyValidationCacheEXT>(GetDeviceProcAddr(device, "vkDestroyValidationCacheEXT"));
                MergeValidationCachesEXT = reinterpret_cast<PFN_vkMergeValidationCachesEXT>(GetDeviceProcAddr(device, "vkMergeValidationCachesEXT"));
                GetValidationCacheDataEXT = reinterpret_cast<PFN_vkGetValidationCacheDataEXT>(GetDeviceProcAddr(device, "vkGetValidationCacheDataEXT"));
            }
        },
        {
            "VK_NV_shading_rate_image", [](VkInstance , VkDevice device) {
                CmdBindShadingRateImageNV = reinterpret_cast<PFN_vkCmdBindShadingRateImageNV>(GetDeviceProcAddr(device, "vkCmdBindShadingRateImageNV"));
                CmdSetViewportShadingRatePaletteNV = reinterpret_cast<PFN_vkCmdSetViewportShadingRatePaletteNV>(GetDeviceProcAddr(device, "vkCmdSetViewportShadingRatePaletteNV"));
                CmdSetCoarseSampleOrderNV = reinterpret_cast<PFN_vkCmdSetCoarseSampleOrderNV>(GetDeviceProcAddr(device, "vkCmdSetCoarseSampleOrderNV"));
            }
        },
        {
            "VK_NV_ray_tracing", [](VkInstance , VkDevice device) {
                CreateAccelerationStructureNV = reinterpret_cast<PFN_vkCreateAccelerationStructureNV>(GetDeviceProcAddr(device, "vkCreateAccelerationStructureNV"));
                DestroyAccelerationStructureNV = reinterpret_cast<PFN_vkDestroyAccelerationStructureNV>(GetDeviceProcAddr(device, "vkDestroyAccelerationStructureNV"));
                GetAccelerationStructureMemoryRequirementsNV = reinterpret_cast<PFN_vkGetAccelerationStructureMemoryRequirementsNV>(GetDeviceProcAddr(device, "vkGetAccelerationStructureMemoryRequirementsNV"));
                BindAccelerationStructureMemoryNV = reinterpret_cast<PFN_vkBindAccelerationStructureMemoryNV>(GetDeviceProcAddr(device, "vkBindAccelerationStructureMemoryNV"));
                CmdBuildAccelerationStructureNV = reinterpret_cast<PFN_vkCmdBuildAccelerationStructureNV>(GetDeviceProcAddr(device, "vkCmdBuildAccelerationStructureNV"));
                CmdCopyAccelerationStructureNV = reinterpret_cast<PFN_vkCmdCopyAccelerationStructureNV>(GetDeviceProcAddr(device, "vkCmdCopyAccelerationStructureNV"));
                CmdTraceRaysNV = reinterpret_cast<PFN_vkCmdTraceRaysNV>(GetDeviceProcAddr(device, "vkCmdTraceRaysNV"));
                CreateRayTracingPipelinesNV = reinterpret_cast<PFN_vkCreateRayTracingPipelinesNV>(GetDeviceProcAddr(device, "vkCreateRayTracingPipelinesNV"));
                GetRayTracingShaderGroupHandlesNV = reinterpret_cast<PFN_vkGetRayTracingShaderGroupHandlesNV>(GetDeviceProcAddr(device, "vkGetRayTracingShaderGroupHandlesNV"));
                GetAccelerationStructureHandleNV = reinterpret_cast<PFN_vkGetAccelerationStructureHandleNV>(GetDeviceProcAddr(device, "vkGetAccelerationStructureHandleNV"));
                CmdWriteAccelerationStructuresPropertiesNV = reinterpret_cast<PFN_vkCmdWriteAccelerationStructuresPropertiesNV>(GetDeviceProcAddr(device, "vkCmdWriteAccelerationStructuresPropertiesNV"));
                CompileDeferredNV = reinterpret_cast<PFN_vkCompileDeferredNV>(GetDeviceProcAddr(device, "vkCompileDeferredNV"));
            }
        },
        {
            "VK_EXT_external_memory_host", [](VkInstance , VkDevice device) {
                GetMemoryHostPointerPropertiesEXT = reinterpret_cast<PFN_vkGetMemoryHostPointerPropertiesEXT>(GetDeviceProcAddr(device, "vkGetMemoryHostPointerPropertiesEXT"));
            }
        },
        {
            "VK_AMD_buffer_marker", [](VkInstance , VkDevice device) {
                CmdWriteBufferMarkerAMD = reinterpret_cast<PFN_vkCmdWriteBufferMarkerAMD>(GetDeviceProcAddr(device, "vkCmdWriteBufferMarkerAMD"));
                CmdWriteBufferMarker2AMD = reinterpret_cast<PFN_vkCmdWriteBufferMarker2AMD>(GetDeviceProcAddr(device, "vkCmdWriteBufferMarker2AMD"));
            }
        },
        {
            "VK_EXT_calibrated_timestamps", [](VkInstance instance, VkDevice device) {
                GetCalibratedTimestampsEXT = reinterpret_cast<PFN_vkGetCalibratedTimestampsEXT>(GetDeviceProcAddr(device, "vkGetCalibratedTimestampsEXT"));
                GetPhysicalDeviceCalibrateableTimeDomainsEXT = reinterpret_cast<PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceCalibrateableTimeDomainsEXT"));
            }
        },
        {
            "VK_NV_mesh_shader", [](VkInstance , VkDevice device) {
                CmdDrawMeshTasksNV = reinterpret_cast<PFN_vkCmdDrawMeshTasksNV>(GetDeviceProcAddr(device, "vkCmdDrawMeshTasksNV"));
                CmdDrawMeshTasksIndirectNV = reinterpret_cast<PFN_vkCmdDrawMeshTasksIndirectNV>(GetDeviceProcAddr(device, "vkCmdDrawMeshTasksIndirectNV"));
                CmdDrawMeshTasksIndirectCountNV = reinterpret_cast<PFN_vkCmdDrawMeshTasksIndirectCountNV>(GetDeviceProcAddr(device, "vkCmdDrawMeshTasksIndirectCountNV"));
            }
        },
        {
            "VK_NV_scissor_exclusive", [](VkInstance , VkDevice device) {
                CmdSetExclusiveScissorEnableNV = reinterpret_cast<PFN_vkCmdSetExclusiveScissorEnableNV>(GetDeviceProcAddr(device, "vkCmdSetExclusiveScissorEnableNV"));
                CmdSetExclusiveScissorNV = reinterpret_cast<PFN_vkCmdSetExclusiveScissorNV>(GetDeviceProcAddr(device, "vkCmdSetExclusiveScissorNV"));
            }
        },
        {
            "VK_NV_device_diagnostic_checkpoints", [](VkInstance , VkDevice device) {
                CmdSetCheckpointNV = reinterpret_cast<PFN_vkCmdSetCheckpointNV>(GetDeviceProcAddr(device, "vkCmdSetCheckpointNV"));
                GetQueueCheckpointDataNV = reinterpret_cast<PFN_vkGetQueueCheckpointDataNV>(GetDeviceProcAddr(device, "vkGetQueueCheckpointDataNV"));
                GetQueueCheckpointData2NV = reinterpret_cast<PFN_vkGetQueueCheckpointData2NV>(GetDeviceProcAddr(device, "vkGetQueueCheckpointData2NV"));
            }
        },
        {
            "VK_EXT_present_timing", [](VkInstance , VkDevice device) {
                SetSwapchainPresentTimingQueueSizeEXT = reinterpret_cast<PFN_vkSetSwapchainPresentTimingQueueSizeEXT>(GetDeviceProcAddr(device, "vkSetSwapchainPresentTimingQueueSizeEXT"));
                GetSwapchainTimingPropertiesEXT = reinterpret_cast<PFN_vkGetSwapchainTimingPropertiesEXT>(GetDeviceProcAddr(device, "vkGetSwapchainTimingPropertiesEXT"));
                GetSwapchainTimeDomainPropertiesEXT = reinterpret_cast<PFN_vkGetSwapchainTimeDomainPropertiesEXT>(GetDeviceProcAddr(device, "vkGetSwapchainTimeDomainPropertiesEXT"));
                GetPastPresentationTimingEXT = reinterpret_cast<PFN_vkGetPastPresentationTimingEXT>(GetDeviceProcAddr(device, "vkGetPastPresentationTimingEXT"));
            }
        },
        {
            "VK_INTEL_performance_query", [](VkInstance , VkDevice device) {
                InitializePerformanceApiINTEL = reinterpret_cast<PFN_vkInitializePerformanceApiINTEL>(GetDeviceProcAddr(device, "vkInitializePerformanceApiINTEL"));
                UninitializePerformanceApiINTEL = reinterpret_cast<PFN_vkUninitializePerformanceApiINTEL>(GetDeviceProcAddr(device, "vkUninitializePerformanceApiINTEL"));
                CmdSetPerformanceMarkerINTEL = reinterpret_cast<PFN_vkCmdSetPerformanceMarkerINTEL>(GetDeviceProcAddr(device, "vkCmdSetPerformanceMarkerINTEL"));
                CmdSetPerformanceStreamMarkerINTEL = reinterpret_cast<PFN_vkCmdSetPerformanceStreamMarkerINTEL>(GetDeviceProcAddr(device, "vkCmdSetPerformanceStreamMarkerINTEL"));
                CmdSetPerformanceOverrideINTEL = reinterpret_cast<PFN_vkCmdSetPerformanceOverrideINTEL>(GetDeviceProcAddr(device, "vkCmdSetPerformanceOverrideINTEL"));
                AcquirePerformanceConfigurationINTEL = reinterpret_cast<PFN_vkAcquirePerformanceConfigurationINTEL>(GetDeviceProcAddr(device, "vkAcquirePerformanceConfigurationINTEL"));
                ReleasePerformanceConfigurationINTEL = reinterpret_cast<PFN_vkReleasePerformanceConfigurationINTEL>(GetDeviceProcAddr(device, "vkReleasePerformanceConfigurationINTEL"));
                QueueSetPerformanceConfigurationINTEL = reinterpret_cast<PFN_vkQueueSetPerformanceConfigurationINTEL>(GetDeviceProcAddr(device, "vkQueueSetPerformanceConfigurationINTEL"));
                GetPerformanceParameterINTEL = reinterpret_cast<PFN_vkGetPerformanceParameterINTEL>(GetDeviceProcAddr(device, "vkGetPerformanceParameterINTEL"));
            }
        },
        {
            "VK_AMD_display_native_hdr", [](VkInstance , VkDevice device) {
                SetLocalDimmingAMD = reinterpret_cast<PFN_vkSetLocalDimmingAMD>(GetDeviceProcAddr(device, "vkSetLocalDimmingAMD"));
            }
        },
        {
            "VK_EXT_buffer_device_address", [](VkInstance , VkDevice device) {
                GetBufferDeviceAddressEXT = reinterpret_cast<PFN_vkGetBufferDeviceAddressEXT>(GetDeviceProcAddr(device, "vkGetBufferDeviceAddressEXT"));
            }
        },
        {
            "VK_EXT_tooling_info", [](VkInstance instance, VkDevice ) {
                GetPhysicalDeviceToolPropertiesEXT = reinterpret_cast<PFN_vkGetPhysicalDeviceToolPropertiesEXT>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceToolPropertiesEXT"));
            }
        },
        {
            "VK_NV_cooperative_matrix", [](VkInstance instance, VkDevice ) {
                GetPhysicalDeviceCooperativeMatrixPropertiesNV = reinterpret_cast<PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceCooperativeMatrixPropertiesNV"));
            }
        },
        {
            "VK_NV_coverage_reduction_mode", [](VkInstance instance, VkDevice ) {
                GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = reinterpret_cast<PFN_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV"));
            }
        },
#ifdef VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_EXT_full_screen_exclusive", [](VkInstance instance, VkDevice device) {
                AcquireFullScreenExclusiveModeEXT = reinterpret_cast<PFN_vkAcquireFullScreenExclusiveModeEXT>(GetDeviceProcAddr(device, "vkAcquireFullScreenExclusiveModeEXT"));
                ReleaseFullScreenExclusiveModeEXT = reinterpret_cast<PFN_vkReleaseFullScreenExclusiveModeEXT>(GetDeviceProcAddr(device, "vkReleaseFullScreenExclusiveModeEXT"));
                GetDeviceGroupSurfacePresentModes2EXT = reinterpret_cast<PFN_vkGetDeviceGroupSurfacePresentModes2EXT>(GetDeviceProcAddr(device, "vkGetDeviceGroupSurfacePresentModes2EXT"));
                GetPhysicalDeviceSurfacePresentModes2EXT = reinterpret_cast<PFN_vkGetPhysicalDeviceSurfacePresentModes2EXT>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceSurfacePresentModes2EXT"));
            }
        },
#endif  // VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_EXT_line_rasterization", [](VkInstance , VkDevice device) {
                CmdSetLineStippleEXT = reinterpret_cast<PFN_vkCmdSetLineStippleEXT>(GetDeviceProcAddr(device, "vkCmdSetLineStippleEXT"));
            }
        },
        {
            "VK_EXT_host_query_reset", [](VkInstance , VkDevice device) {
                ResetQueryPoolEXT = reinterpret_cast<PFN_vkResetQueryPoolEXT>(GetDeviceProcAddr(device, "vkResetQueryPoolEXT"));
            }
        },
        {
            "VK_EXT_extended_dynamic_state", [](VkInstance , VkDevice device) {
                CmdSetCullModeEXT = reinterpret_cast<PFN_vkCmdSetCullModeEXT>(GetDeviceProcAddr(device, "vkCmdSetCullModeEXT"));
                CmdSetFrontFaceEXT = reinterpret_cast<PFN_vkCmdSetFrontFaceEXT>(GetDeviceProcAddr(device, "vkCmdSetFrontFaceEXT"));
                CmdSetPrimitiveTopologyEXT = reinterpret_cast<PFN_vkCmdSetPrimitiveTopologyEXT>(GetDeviceProcAddr(device, "vkCmdSetPrimitiveTopologyEXT"));
                CmdSetViewportWithCountEXT = reinterpret_cast<PFN_vkCmdSetViewportWithCountEXT>(GetDeviceProcAddr(device, "vkCmdSetViewportWithCountEXT"));
                CmdSetScissorWithCountEXT = reinterpret_cast<PFN_vkCmdSetScissorWithCountEXT>(GetDeviceProcAddr(device, "vkCmdSetScissorWithCountEXT"));
                CmdBindVertexBuffers2EXT = reinterpret_cast<PFN_vkCmdBindVertexBuffers2EXT>(GetDeviceProcAddr(device, "vkCmdBindVertexBuffers2EXT"));
                CmdSetDepthTestEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthTestEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthTestEnableEXT"));
                CmdSetDepthWriteEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthWriteEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthWriteEnableEXT"));
                CmdSetDepthCompareOpEXT = reinterpret_cast<PFN_vkCmdSetDepthCompareOpEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthCompareOpEXT"));
                CmdSetDepthBoundsTestEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthBoundsTestEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthBoundsTestEnableEXT"));
                CmdSetStencilTestEnableEXT = reinterpret_cast<PFN_vkCmdSetStencilTestEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetStencilTestEnableEXT"));
                CmdSetStencilOpEXT = reinterpret_cast<PFN_vkCmdSetStencilOpEXT>(GetDeviceProcAddr(device, "vkCmdSetStencilOpEXT"));
            }
        },
        {
            "VK_EXT_host_image_copy", [](VkInstance , VkDevice device) {
                CopyMemoryToImageEXT = reinterpret_cast<PFN_vkCopyMemoryToImageEXT>(GetDeviceProcAddr(device, "vkCopyMemoryToImageEXT"));
                CopyImageToMemoryEXT = reinterpret_cast<PFN_vkCopyImageToMemoryEXT>(GetDeviceProcAddr(device, "vkCopyImageToMemoryEXT"));
                CopyImageToImageEXT = reinterpret_cast<PFN_vkCopyImageToImageEXT>(GetDeviceProcAddr(device, "vkCopyImageToImageEXT"));
                TransitionImageLayoutEXT = reinterpret_cast<PFN_vkTransitionImageLayoutEXT>(GetDeviceProcAddr(device, "vkTransitionImageLayoutEXT"));
                GetImageSubresourceLayout2EXT = reinterpret_cast<PFN_vkGetImageSubresourceLayout2EXT>(GetDeviceProcAddr(device, "vkGetImageSubresourceLayout2EXT"));
            }
        },
        {
            "VK_EXT_swapchain_maintenance1", [](VkInstance , VkDevice device) {
                ReleaseSwapchainImagesEXT = reinterpret_cast<PFN_vkReleaseSwapchainImagesEXT>(GetDeviceProcAddr(device, "vkReleaseSwapchainImagesEXT"));
            }
        },
        {
            "VK_NV_device_generated_commands", [](VkInstance , VkDevice device) {
                GetGeneratedCommandsMemoryRequirementsNV = reinterpret_cast<PFN_vkGetGeneratedCommandsMemoryRequirementsNV>(GetDeviceProcAddr(device, "vkGetGeneratedCommandsMemoryRequirementsNV"));
                CmdPreprocessGeneratedCommandsNV = reinterpret_cast<PFN_vkCmdPreprocessGeneratedCommandsNV>(GetDeviceProcAddr(device, "vkCmdPreprocessGeneratedCommandsNV"));
                CmdExecuteGeneratedCommandsNV = reinterpret_cast<PFN_vkCmdExecuteGeneratedCommandsNV>(GetDeviceProcAddr(device, "vkCmdExecuteGeneratedCommandsNV"));
                CmdBindPipelineShaderGroupNV = reinterpret_cast<PFN_vkCmdBindPipelineShaderGroupNV>(GetDeviceProcAddr(device, "vkCmdBindPipelineShaderGroupNV"));
                CreateIndirectCommandsLayoutNV = reinterpret_cast<PFN_vkCreateIndirectCommandsLayoutNV>(GetDeviceProcAddr(device, "vkCreateIndirectCommandsLayoutNV"));
                DestroyIndirectCommandsLayoutNV = reinterpret_cast<PFN_vkDestroyIndirectCommandsLayoutNV>(GetDeviceProcAddr(device, "vkDestroyIndirectCommandsLayoutNV"));
            }
        },
        {
            "VK_EXT_depth_bias_control", [](VkInstance , VkDevice device) {
                CmdSetDepthBias2EXT = reinterpret_cast<PFN_vkCmdSetDepthBias2EXT>(GetDeviceProcAddr(device, "vkCmdSetDepthBias2EXT"));
            }
        },
        {
            "VK_EXT_private_data", [](VkInstance , VkDevice device) {
                CreatePrivateDataSlotEXT = reinterpret_cast<PFN_vkCreatePrivateDataSlotEXT>(GetDeviceProcAddr(device, "vkCreatePrivateDataSlotEXT"));
                DestroyPrivateDataSlotEXT = reinterpret_cast<PFN_vkDestroyPrivateDataSlotEXT>(GetDeviceProcAddr(device, "vkDestroyPrivateDataSlotEXT"));
                SetPrivateDataEXT = reinterpret_cast<PFN_vkSetPrivateDataEXT>(GetDeviceProcAddr(device, "vkSetPrivateDataEXT"));
                GetPrivateDataEXT = reinterpret_cast<PFN_vkGetPrivateDataEXT>(GetDeviceProcAddr(device, "vkGetPrivateDataEXT"));
            }
        },
#ifdef VK_ENABLE_BETA_EXTENSIONS
        {
            "VK_NV_cuda_kernel_launch", [](VkInstance , VkDevice device) {
                CreateCudaModuleNV = reinterpret_cast<PFN_vkCreateCudaModuleNV>(GetDeviceProcAddr(device, "vkCreateCudaModuleNV"));
                GetCudaModuleCacheNV = reinterpret_cast<PFN_vkGetCudaModuleCacheNV>(GetDeviceProcAddr(device, "vkGetCudaModuleCacheNV"));
                CreateCudaFunctionNV = reinterpret_cast<PFN_vkCreateCudaFunctionNV>(GetDeviceProcAddr(device, "vkCreateCudaFunctionNV"));
                DestroyCudaModuleNV = reinterpret_cast<PFN_vkDestroyCudaModuleNV>(GetDeviceProcAddr(device, "vkDestroyCudaModuleNV"));
                DestroyCudaFunctionNV = reinterpret_cast<PFN_vkDestroyCudaFunctionNV>(GetDeviceProcAddr(device, "vkDestroyCudaFunctionNV"));
                CmdCudaLaunchKernelNV = reinterpret_cast<PFN_vkCmdCudaLaunchKernelNV>(GetDeviceProcAddr(device, "vkCmdCudaLaunchKernelNV"));
            }
        },
#endif  // VK_ENABLE_BETA_EXTENSIONS
        {
            "VK_QCOM_tile_shading", [](VkInstance , VkDevice device) {
                CmdDispatchTileQCOM = reinterpret_cast<PFN_vkCmdDispatchTileQCOM>(GetDeviceProcAddr(device, "vkCmdDispatchTileQCOM"));
                CmdBeginPerTileExecutionQCOM = reinterpret_cast<PFN_vkCmdBeginPerTileExecutionQCOM>(GetDeviceProcAddr(device, "vkCmdBeginPerTileExecutionQCOM"));
                CmdEndPerTileExecutionQCOM = reinterpret_cast<PFN_vkCmdEndPerTileExecutionQCOM>(GetDeviceProcAddr(device, "vkCmdEndPerTileExecutionQCOM"));
            }
        },
#ifdef VK_USE_PLATFORM_METAL_EXT
        {
            "VK_EXT_metal_objects", [](VkInstance , VkDevice device) {
                ExportMetalObjectsEXT = reinterpret_cast<PFN_vkExportMetalObjectsEXT>(GetDeviceProcAddr(device, "vkExportMetalObjectsEXT"));
            }
        },
#endif  // VK_USE_PLATFORM_METAL_EXT
        {
            "VK_EXT_descriptor_buffer", [](VkInstance , VkDevice device) {
                GetDescriptorSetLayoutSizeEXT = reinterpret_cast<PFN_vkGetDescriptorSetLayoutSizeEXT>(GetDeviceProcAddr(device, "vkGetDescriptorSetLayoutSizeEXT"));
                GetDescriptorSetLayoutBindingOffsetEXT = reinterpret_cast<PFN_vkGetDescriptorSetLayoutBindingOffsetEXT>(GetDeviceProcAddr(device, "vkGetDescriptorSetLayoutBindingOffsetEXT"));
                GetDescriptorEXT = reinterpret_cast<PFN_vkGetDescriptorEXT>(GetDeviceProcAddr(device, "vkGetDescriptorEXT"));
                CmdBindDescriptorBuffersEXT = reinterpret_cast<PFN_vkCmdBindDescriptorBuffersEXT>(GetDeviceProcAddr(device, "vkCmdBindDescriptorBuffersEXT"));
                CmdSetDescriptorBufferOffsetsEXT = reinterpret_cast<PFN_vkCmdSetDescriptorBufferOffsetsEXT>(GetDeviceProcAddr(device, "vkCmdSetDescriptorBufferOffsetsEXT"));
                CmdBindDescriptorBufferEmbeddedSamplersEXT = reinterpret_cast<PFN_vkCmdBindDescriptorBufferEmbeddedSamplersEXT>(GetDeviceProcAddr(device, "vkCmdBindDescriptorBufferEmbeddedSamplersEXT"));
                GetBufferOpaqueCaptureDescriptorDataEXT = reinterpret_cast<PFN_vkGetBufferOpaqueCaptureDescriptorDataEXT>(GetDeviceProcAddr(device, "vkGetBufferOpaqueCaptureDescriptorDataEXT"));
                GetImageOpaqueCaptureDescriptorDataEXT = reinterpret_cast<PFN_vkGetImageOpaqueCaptureDescriptorDataEXT>(GetDeviceProcAddr(device, "vkGetImageOpaqueCaptureDescriptorDataEXT"));
                GetImageViewOpaqueCaptureDescriptorDataEXT = reinterpret_cast<PFN_vkGetImageViewOpaqueCaptureDescriptorDataEXT>(GetDeviceProcAddr(device, "vkGetImageViewOpaqueCaptureDescriptorDataEXT"));
                GetSamplerOpaqueCaptureDescriptorDataEXT = reinterpret_cast<PFN_vkGetSamplerOpaqueCaptureDescriptorDataEXT>(GetDeviceProcAddr(device, "vkGetSamplerOpaqueCaptureDescriptorDataEXT"));
                GetAccelerationStructureOpaqueCaptureDescriptorDataEXT = reinterpret_cast<PFN_vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT>(GetDeviceProcAddr(device, "vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT"));
            }
        },
        {
            "VK_NV_fragment_shading_rate_enums", [](VkInstance , VkDevice device) {
                CmdSetFragmentShadingRateEnumNV = reinterpret_cast<PFN_vkCmdSetFragmentShadingRateEnumNV>(GetDeviceProcAddr(device, "vkCmdSetFragmentShadingRateEnumNV"));
            }
        },
        {
            "VK_EXT_image_compression_control", [](VkInstance , VkDevice device) {
                GetImageSubresourceLayout2EXT = reinterpret_cast<PFN_vkGetImageSubresourceLayout2EXT>(GetDeviceProcAddr(device, "vkGetImageSubresourceLayout2EXT"));
            }
        },
        {
            "VK_EXT_device_fault", [](VkInstance , VkDevice device) {
                GetDeviceFaultInfoEXT = reinterpret_cast<PFN_vkGetDeviceFaultInfoEXT>(GetDeviceProcAddr(device, "vkGetDeviceFaultInfoEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_NV_acquire_winrt_display", [](VkInstance instance, VkDevice ) {
                AcquireWinrtDisplayNV = reinterpret_cast<PFN_vkAcquireWinrtDisplayNV>(GetInstanceProcAddr(instance, "vkAcquireWinrtDisplayNV"));
                GetWinrtDisplayNV = reinterpret_cast<PFN_vkGetWinrtDisplayNV>(GetInstanceProcAddr(instance, "vkGetWinrtDisplayNV"));
            }
        },
#endif  // VK_USE_PLATFORM_WIN32_KHR
        {
            "VK_EXT_vertex_input_dynamic_state", [](VkInstance , VkDevice device) {
                CmdSetVertexInputEXT = reinterpret_cast<PFN_vkCmdSetVertexInputEXT>(GetDeviceProcAddr(device, "vkCmdSetVertexInputEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_FUCHSIA
        {
            "VK_FUCHSIA_external_memory", [](VkInstance , VkDevice device) {
                GetMemoryZirconHandleFUCHSIA = reinterpret_cast<PFN_vkGetMemoryZirconHandleFUCHSIA>(GetDeviceProcAddr(device, "vkGetMemoryZirconHandleFUCHSIA"));
                GetMemoryZirconHandlePropertiesFUCHSIA = reinterpret_cast<PFN_vkGetMemoryZirconHandlePropertiesFUCHSIA>(GetDeviceProcAddr(device, "vkGetMemoryZirconHandlePropertiesFUCHSIA"));
            }
        },
        {
            "VK_FUCHSIA_external_semaphore", [](VkInstance , VkDevice device) {
                ImportSemaphoreZirconHandleFUCHSIA = reinterpret_cast<PFN_vkImportSemaphoreZirconHandleFUCHSIA>(GetDeviceProcAddr(device, "vkImportSemaphoreZirconHandleFUCHSIA"));
                GetSemaphoreZirconHandleFUCHSIA = reinterpret_cast<PFN_vkGetSemaphoreZirconHandleFUCHSIA>(GetDeviceProcAddr(device, "vkGetSemaphoreZirconHandleFUCHSIA"));
            }
        },
        {
            "VK_FUCHSIA_buffer_collection", [](VkInstance , VkDevice device) {
                CreateBufferCollectionFUCHSIA = reinterpret_cast<PFN_vkCreateBufferCollectionFUCHSIA>(GetDeviceProcAddr(device, "vkCreateBufferCollectionFUCHSIA"));
                SetBufferCollectionImageConstraintsFUCHSIA = reinterpret_cast<PFN_vkSetBufferCollectionImageConstraintsFUCHSIA>(GetDeviceProcAddr(device, "vkSetBufferCollectionImageConstraintsFUCHSIA"));
                SetBufferCollectionBufferConstraintsFUCHSIA = reinterpret_cast<PFN_vkSetBufferCollectionBufferConstraintsFUCHSIA>(GetDeviceProcAddr(device, "vkSetBufferCollectionBufferConstraintsFUCHSIA"));
                DestroyBufferCollectionFUCHSIA = reinterpret_cast<PFN_vkDestroyBufferCollectionFUCHSIA>(GetDeviceProcAddr(device, "vkDestroyBufferCollectionFUCHSIA"));
                GetBufferCollectionPropertiesFUCHSIA = reinterpret_cast<PFN_vkGetBufferCollectionPropertiesFUCHSIA>(GetDeviceProcAddr(device, "vkGetBufferCollectionPropertiesFUCHSIA"));
            }
        },
#endif  // VK_USE_PLATFORM_FUCHSIA
        {
            "VK_HUAWEI_subpass_shading", [](VkInstance , VkDevice device) {
                GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI = reinterpret_cast<PFN_vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI>(GetDeviceProcAddr(device, "vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI"));
                CmdSubpassShadingHUAWEI = reinterpret_cast<PFN_vkCmdSubpassShadingHUAWEI>(GetDeviceProcAddr(device, "vkCmdSubpassShadingHUAWEI"));
            }
        },
        {
            "VK_HUAWEI_invocation_mask", [](VkInstance , VkDevice device) {
                CmdBindInvocationMaskHUAWEI = reinterpret_cast<PFN_vkCmdBindInvocationMaskHUAWEI>(GetDeviceProcAddr(device, "vkCmdBindInvocationMaskHUAWEI"));
            }
        },
        {
            "VK_NV_external_memory_rdma", [](VkInstance , VkDevice device) {
                GetMemoryRemoteAddressNV = reinterpret_cast<PFN_vkGetMemoryRemoteAddressNV>(GetDeviceProcAddr(device, "vkGetMemoryRemoteAddressNV"));
            }
        },
        {
            "VK_EXT_pipeline_properties", [](VkInstance , VkDevice device) {
                GetPipelinePropertiesEXT = reinterpret_cast<PFN_vkGetPipelinePropertiesEXT>(GetDeviceProcAddr(device, "vkGetPipelinePropertiesEXT"));
            }
        },
        {
            "VK_EXT_extended_dynamic_state2", [](VkInstance , VkDevice device) {
                CmdSetPatchControlPointsEXT = reinterpret_cast<PFN_vkCmdSetPatchControlPointsEXT>(GetDeviceProcAddr(device, "vkCmdSetPatchControlPointsEXT"));
                CmdSetRasterizerDiscardEnableEXT = reinterpret_cast<PFN_vkCmdSetRasterizerDiscardEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetRasterizerDiscardEnableEXT"));
                CmdSetDepthBiasEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthBiasEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthBiasEnableEXT"));
                CmdSetLogicOpEXT = reinterpret_cast<PFN_vkCmdSetLogicOpEXT>(GetDeviceProcAddr(device, "vkCmdSetLogicOpEXT"));
                CmdSetPrimitiveRestartEnableEXT = reinterpret_cast<PFN_vkCmdSetPrimitiveRestartEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetPrimitiveRestartEnableEXT"));
            }
        },
        {
            "VK_EXT_color_write_enable", [](VkInstance , VkDevice device) {
                CmdSetColorWriteEnableEXT = reinterpret_cast<PFN_vkCmdSetColorWriteEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetColorWriteEnableEXT"));
            }
        },
        {
            "VK_EXT_multi_draw", [](VkInstance , VkDevice device) {
                CmdDrawMultiEXT = reinterpret_cast<PFN_vkCmdDrawMultiEXT>(GetDeviceProcAddr(device, "vkCmdDrawMultiEXT"));
                CmdDrawMultiIndexedEXT = reinterpret_cast<PFN_vkCmdDrawMultiIndexedEXT>(GetDeviceProcAddr(device, "vkCmdDrawMultiIndexedEXT"));
            }
        },
        {
            "VK_EXT_opacity_micromap", [](VkInstance , VkDevice device) {
                CreateMicromapEXT = reinterpret_cast<PFN_vkCreateMicromapEXT>(GetDeviceProcAddr(device, "vkCreateMicromapEXT"));
                DestroyMicromapEXT = reinterpret_cast<PFN_vkDestroyMicromapEXT>(GetDeviceProcAddr(device, "vkDestroyMicromapEXT"));
                CmdBuildMicromapsEXT = reinterpret_cast<PFN_vkCmdBuildMicromapsEXT>(GetDeviceProcAddr(device, "vkCmdBuildMicromapsEXT"));
                BuildMicromapsEXT = reinterpret_cast<PFN_vkBuildMicromapsEXT>(GetDeviceProcAddr(device, "vkBuildMicromapsEXT"));
                CopyMicromapEXT = reinterpret_cast<PFN_vkCopyMicromapEXT>(GetDeviceProcAddr(device, "vkCopyMicromapEXT"));
                CopyMicromapToMemoryEXT = reinterpret_cast<PFN_vkCopyMicromapToMemoryEXT>(GetDeviceProcAddr(device, "vkCopyMicromapToMemoryEXT"));
                CopyMemoryToMicromapEXT = reinterpret_cast<PFN_vkCopyMemoryToMicromapEXT>(GetDeviceProcAddr(device, "vkCopyMemoryToMicromapEXT"));
                WriteMicromapsPropertiesEXT = reinterpret_cast<PFN_vkWriteMicromapsPropertiesEXT>(GetDeviceProcAddr(device, "vkWriteMicromapsPropertiesEXT"));
                CmdCopyMicromapEXT = reinterpret_cast<PFN_vkCmdCopyMicromapEXT>(GetDeviceProcAddr(device, "vkCmdCopyMicromapEXT"));
                CmdCopyMicromapToMemoryEXT = reinterpret_cast<PFN_vkCmdCopyMicromapToMemoryEXT>(GetDeviceProcAddr(device, "vkCmdCopyMicromapToMemoryEXT"));
                CmdCopyMemoryToMicromapEXT = reinterpret_cast<PFN_vkCmdCopyMemoryToMicromapEXT>(GetDeviceProcAddr(device, "vkCmdCopyMemoryToMicromapEXT"));
                CmdWriteMicromapsPropertiesEXT = reinterpret_cast<PFN_vkCmdWriteMicromapsPropertiesEXT>(GetDeviceProcAddr(device, "vkCmdWriteMicromapsPropertiesEXT"));
                GetDeviceMicromapCompatibilityEXT = reinterpret_cast<PFN_vkGetDeviceMicromapCompatibilityEXT>(GetDeviceProcAddr(device, "vkGetDeviceMicromapCompatibilityEXT"));
                GetMicromapBuildSizesEXT = reinterpret_cast<PFN_vkGetMicromapBuildSizesEXT>(GetDeviceProcAddr(device, "vkGetMicromapBuildSizesEXT"));
            }
        },
        {
            "VK_HUAWEI_cluster_culling_shader", [](VkInstance , VkDevice device) {
                CmdDrawClusterHUAWEI = reinterpret_cast<PFN_vkCmdDrawClusterHUAWEI>(GetDeviceProcAddr(device, "vkCmdDrawClusterHUAWEI"));
                CmdDrawClusterIndirectHUAWEI = reinterpret_cast<PFN_vkCmdDrawClusterIndirectHUAWEI>(GetDeviceProcAddr(device, "vkCmdDrawClusterIndirectHUAWEI"));
            }
        },
        {
            "VK_EXT_pageable_device_local_memory", [](VkInstance , VkDevice device) {
                SetDeviceMemoryPriorityEXT = reinterpret_cast<PFN_vkSetDeviceMemoryPriorityEXT>(GetDeviceProcAddr(device, "vkSetDeviceMemoryPriorityEXT"));
            }
        },
        {
            "VK_VALVE_descriptor_set_host_mapping", [](VkInstance , VkDevice device) {
                GetDescriptorSetLayoutHostMappingInfoVALVE = reinterpret_cast<PFN_vkGetDescriptorSetLayoutHostMappingInfoVALVE>(GetDeviceProcAddr(device, "vkGetDescriptorSetLayoutHostMappingInfoVALVE"));
                GetDescriptorSetHostMappingVALVE = reinterpret_cast<PFN_vkGetDescriptorSetHostMappingVALVE>(GetDeviceProcAddr(device, "vkGetDescriptorSetHostMappingVALVE"));
            }
        },
        {
            "VK_NV_copy_memory_indirect", [](VkInstance , VkDevice device) {
                CmdCopyMemoryIndirectNV = reinterpret_cast<PFN_vkCmdCopyMemoryIndirectNV>(GetDeviceProcAddr(device, "vkCmdCopyMemoryIndirectNV"));
                CmdCopyMemoryToImageIndirectNV = reinterpret_cast<PFN_vkCmdCopyMemoryToImageIndirectNV>(GetDeviceProcAddr(device, "vkCmdCopyMemoryToImageIndirectNV"));
            }
        },
        {
            "VK_NV_memory_decompression", [](VkInstance , VkDevice device) {
                CmdDecompressMemoryNV = reinterpret_cast<PFN_vkCmdDecompressMemoryNV>(GetDeviceProcAddr(device, "vkCmdDecompressMemoryNV"));
                CmdDecompressMemoryIndirectCountNV = reinterpret_cast<PFN_vkCmdDecompressMemoryIndirectCountNV>(GetDeviceProcAddr(device, "vkCmdDecompressMemoryIndirectCountNV"));
            }
        },
        {
            "VK_NV_device_generated_commands_compute", [](VkInstance , VkDevice device) {
                GetPipelineIndirectMemoryRequirementsNV = reinterpret_cast<PFN_vkGetPipelineIndirectMemoryRequirementsNV>(GetDeviceProcAddr(device, "vkGetPipelineIndirectMemoryRequirementsNV"));
                CmdUpdatePipelineIndirectBufferNV = reinterpret_cast<PFN_vkCmdUpdatePipelineIndirectBufferNV>(GetDeviceProcAddr(device, "vkCmdUpdatePipelineIndirectBufferNV"));
                GetPipelineIndirectDeviceAddressNV = reinterpret_cast<PFN_vkGetPipelineIndirectDeviceAddressNV>(GetDeviceProcAddr(device, "vkGetPipelineIndirectDeviceAddressNV"));
            }
        },
#ifdef VK_USE_PLATFORM_OHOS
        {
            "VK_OHOS_external_memory", [](VkInstance , VkDevice device) {
                GetNativeBufferPropertiesOHOS = reinterpret_cast<PFN_vkGetNativeBufferPropertiesOHOS>(GetDeviceProcAddr(device, "vkGetNativeBufferPropertiesOHOS"));
                GetMemoryNativeBufferOHOS = reinterpret_cast<PFN_vkGetMemoryNativeBufferOHOS>(GetDeviceProcAddr(device, "vkGetMemoryNativeBufferOHOS"));
            }
        },
#endif  // VK_USE_PLATFORM_OHOS
        {
            "VK_EXT_extended_dynamic_state3", [](VkInstance , VkDevice device) {
                CmdSetDepthClampEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthClampEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthClampEnableEXT"));
                CmdSetPolygonModeEXT = reinterpret_cast<PFN_vkCmdSetPolygonModeEXT>(GetDeviceProcAddr(device, "vkCmdSetPolygonModeEXT"));
                CmdSetRasterizationSamplesEXT = reinterpret_cast<PFN_vkCmdSetRasterizationSamplesEXT>(GetDeviceProcAddr(device, "vkCmdSetRasterizationSamplesEXT"));
                CmdSetSampleMaskEXT = reinterpret_cast<PFN_vkCmdSetSampleMaskEXT>(GetDeviceProcAddr(device, "vkCmdSetSampleMaskEXT"));
                CmdSetAlphaToCoverageEnableEXT = reinterpret_cast<PFN_vkCmdSetAlphaToCoverageEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetAlphaToCoverageEnableEXT"));
                CmdSetAlphaToOneEnableEXT = reinterpret_cast<PFN_vkCmdSetAlphaToOneEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetAlphaToOneEnableEXT"));
                CmdSetLogicOpEnableEXT = reinterpret_cast<PFN_vkCmdSetLogicOpEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetLogicOpEnableEXT"));
                CmdSetColorBlendEnableEXT = reinterpret_cast<PFN_vkCmdSetColorBlendEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetColorBlendEnableEXT"));
                CmdSetColorBlendEquationEXT = reinterpret_cast<PFN_vkCmdSetColorBlendEquationEXT>(GetDeviceProcAddr(device, "vkCmdSetColorBlendEquationEXT"));
                CmdSetColorWriteMaskEXT = reinterpret_cast<PFN_vkCmdSetColorWriteMaskEXT>(GetDeviceProcAddr(device, "vkCmdSetColorWriteMaskEXT"));
                CmdSetTessellationDomainOriginEXT = reinterpret_cast<PFN_vkCmdSetTessellationDomainOriginEXT>(GetDeviceProcAddr(device, "vkCmdSetTessellationDomainOriginEXT"));
                CmdSetRasterizationStreamEXT = reinterpret_cast<PFN_vkCmdSetRasterizationStreamEXT>(GetDeviceProcAddr(device, "vkCmdSetRasterizationStreamEXT"));
                CmdSetConservativeRasterizationModeEXT = reinterpret_cast<PFN_vkCmdSetConservativeRasterizationModeEXT>(GetDeviceProcAddr(device, "vkCmdSetConservativeRasterizationModeEXT"));
                CmdSetExtraPrimitiveOverestimationSizeEXT = reinterpret_cast<PFN_vkCmdSetExtraPrimitiveOverestimationSizeEXT>(GetDeviceProcAddr(device, "vkCmdSetExtraPrimitiveOverestimationSizeEXT"));
                CmdSetDepthClipEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthClipEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthClipEnableEXT"));
                CmdSetSampleLocationsEnableEXT = reinterpret_cast<PFN_vkCmdSetSampleLocationsEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetSampleLocationsEnableEXT"));
                CmdSetColorBlendAdvancedEXT = reinterpret_cast<PFN_vkCmdSetColorBlendAdvancedEXT>(GetDeviceProcAddr(device, "vkCmdSetColorBlendAdvancedEXT"));
                CmdSetProvokingVertexModeEXT = reinterpret_cast<PFN_vkCmdSetProvokingVertexModeEXT>(GetDeviceProcAddr(device, "vkCmdSetProvokingVertexModeEXT"));
                CmdSetLineRasterizationModeEXT = reinterpret_cast<PFN_vkCmdSetLineRasterizationModeEXT>(GetDeviceProcAddr(device, "vkCmdSetLineRasterizationModeEXT"));
                CmdSetLineStippleEnableEXT = reinterpret_cast<PFN_vkCmdSetLineStippleEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetLineStippleEnableEXT"));
                CmdSetDepthClipNegativeOneToOneEXT = reinterpret_cast<PFN_vkCmdSetDepthClipNegativeOneToOneEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthClipNegativeOneToOneEXT"));
                CmdSetViewportWScalingEnableNV = reinterpret_cast<PFN_vkCmdSetViewportWScalingEnableNV>(GetDeviceProcAddr(device, "vkCmdSetViewportWScalingEnableNV"));
                CmdSetViewportSwizzleNV = reinterpret_cast<PFN_vkCmdSetViewportSwizzleNV>(GetDeviceProcAddr(device, "vkCmdSetViewportSwizzleNV"));
                CmdSetCoverageToColorEnableNV = reinterpret_cast<PFN_vkCmdSetCoverageToColorEnableNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageToColorEnableNV"));
                CmdSetCoverageToColorLocationNV = reinterpret_cast<PFN_vkCmdSetCoverageToColorLocationNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageToColorLocationNV"));
                CmdSetCoverageModulationModeNV = reinterpret_cast<PFN_vkCmdSetCoverageModulationModeNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageModulationModeNV"));
                CmdSetCoverageModulationTableEnableNV = reinterpret_cast<PFN_vkCmdSetCoverageModulationTableEnableNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageModulationTableEnableNV"));
                CmdSetCoverageModulationTableNV = reinterpret_cast<PFN_vkCmdSetCoverageModulationTableNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageModulationTableNV"));
                CmdSetShadingRateImageEnableNV = reinterpret_cast<PFN_vkCmdSetShadingRateImageEnableNV>(GetDeviceProcAddr(device, "vkCmdSetShadingRateImageEnableNV"));
                CmdSetRepresentativeFragmentTestEnableNV = reinterpret_cast<PFN_vkCmdSetRepresentativeFragmentTestEnableNV>(GetDeviceProcAddr(device, "vkCmdSetRepresentativeFragmentTestEnableNV"));
                CmdSetCoverageReductionModeNV = reinterpret_cast<PFN_vkCmdSetCoverageReductionModeNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageReductionModeNV"));
            }
        },
        {
            "VK_ARM_tensors", [](VkInstance instance, VkDevice device) {
                CreateTensorARM = reinterpret_cast<PFN_vkCreateTensorARM>(GetDeviceProcAddr(device, "vkCreateTensorARM"));
                DestroyTensorARM = reinterpret_cast<PFN_vkDestroyTensorARM>(GetDeviceProcAddr(device, "vkDestroyTensorARM"));
                CreateTensorViewARM = reinterpret_cast<PFN_vkCreateTensorViewARM>(GetDeviceProcAddr(device, "vkCreateTensorViewARM"));
                DestroyTensorViewARM = reinterpret_cast<PFN_vkDestroyTensorViewARM>(GetDeviceProcAddr(device, "vkDestroyTensorViewARM"));
                GetTensorMemoryRequirementsARM = reinterpret_cast<PFN_vkGetTensorMemoryRequirementsARM>(GetDeviceProcAddr(device, "vkGetTensorMemoryRequirementsARM"));
                BindTensorMemoryARM = reinterpret_cast<PFN_vkBindTensorMemoryARM>(GetDeviceProcAddr(device, "vkBindTensorMemoryARM"));
                GetDeviceTensorMemoryRequirementsARM = reinterpret_cast<PFN_vkGetDeviceTensorMemoryRequirementsARM>(GetDeviceProcAddr(device, "vkGetDeviceTensorMemoryRequirementsARM"));
                CmdCopyTensorARM = reinterpret_cast<PFN_vkCmdCopyTensorARM>(GetDeviceProcAddr(device, "vkCmdCopyTensorARM"));
                GetTensorOpaqueCaptureDescriptorDataARM = reinterpret_cast<PFN_vkGetTensorOpaqueCaptureDescriptorDataARM>(GetDeviceProcAddr(device, "vkGetTensorOpaqueCaptureDescriptorDataARM"));
                GetTensorViewOpaqueCaptureDescriptorDataARM = reinterpret_cast<PFN_vkGetTensorViewOpaqueCaptureDescriptorDataARM>(GetDeviceProcAddr(device, "vkGetTensorViewOpaqueCaptureDescriptorDataARM"));
                GetPhysicalDeviceExternalTensorPropertiesARM = reinterpret_cast<PFN_vkGetPhysicalDeviceExternalTensorPropertiesARM>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceExternalTensorPropertiesARM"));
            }
        },
        {
            "VK_EXT_shader_module_identifier", [](VkInstance , VkDevice device) {
                GetShaderModuleIdentifierEXT = reinterpret_cast<PFN_vkGetShaderModuleIdentifierEXT>(GetDeviceProcAddr(device, "vkGetShaderModuleIdentifierEXT"));
                GetShaderModuleCreateInfoIdentifierEXT = reinterpret_cast<PFN_vkGetShaderModuleCreateInfoIdentifierEXT>(GetDeviceProcAddr(device, "vkGetShaderModuleCreateInfoIdentifierEXT"));
            }
        },
        {
            "VK_NV_optical_flow", [](VkInstance instance, VkDevice device) {
                CreateOpticalFlowSessionNV = reinterpret_cast<PFN_vkCreateOpticalFlowSessionNV>(GetDeviceProcAddr(device, "vkCreateOpticalFlowSessionNV"));
                DestroyOpticalFlowSessionNV = reinterpret_cast<PFN_vkDestroyOpticalFlowSessionNV>(GetDeviceProcAddr(device, "vkDestroyOpticalFlowSessionNV"));
                BindOpticalFlowSessionImageNV = reinterpret_cast<PFN_vkBindOpticalFlowSessionImageNV>(GetDeviceProcAddr(device, "vkBindOpticalFlowSessionImageNV"));
                CmdOpticalFlowExecuteNV = reinterpret_cast<PFN_vkCmdOpticalFlowExecuteNV>(GetDeviceProcAddr(device, "vkCmdOpticalFlowExecuteNV"));
                GetPhysicalDeviceOpticalFlowImageFormatsNV = reinterpret_cast<PFN_vkGetPhysicalDeviceOpticalFlowImageFormatsNV>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceOpticalFlowImageFormatsNV"));
            }
        },
        {
            "VK_AMD_anti_lag", [](VkInstance , VkDevice device) {
                AntiLagUpdateAMD = reinterpret_cast<PFN_vkAntiLagUpdateAMD>(GetDeviceProcAddr(device, "vkAntiLagUpdateAMD"));
            }
        },
        {
            "VK_EXT_shader_object", [](VkInstance , VkDevice device) {
                CreateShadersEXT = reinterpret_cast<PFN_vkCreateShadersEXT>(GetDeviceProcAddr(device, "vkCreateShadersEXT"));
                DestroyShaderEXT = reinterpret_cast<PFN_vkDestroyShaderEXT>(GetDeviceProcAddr(device, "vkDestroyShaderEXT"));
                GetShaderBinaryDataEXT = reinterpret_cast<PFN_vkGetShaderBinaryDataEXT>(GetDeviceProcAddr(device, "vkGetShaderBinaryDataEXT"));
                CmdBindShadersEXT = reinterpret_cast<PFN_vkCmdBindShadersEXT>(GetDeviceProcAddr(device, "vkCmdBindShadersEXT"));
                CmdSetCullModeEXT = reinterpret_cast<PFN_vkCmdSetCullModeEXT>(GetDeviceProcAddr(device, "vkCmdSetCullModeEXT"));
                CmdSetFrontFaceEXT = reinterpret_cast<PFN_vkCmdSetFrontFaceEXT>(GetDeviceProcAddr(device, "vkCmdSetFrontFaceEXT"));
                CmdSetPrimitiveTopologyEXT = reinterpret_cast<PFN_vkCmdSetPrimitiveTopologyEXT>(GetDeviceProcAddr(device, "vkCmdSetPrimitiveTopologyEXT"));
                CmdSetViewportWithCountEXT = reinterpret_cast<PFN_vkCmdSetViewportWithCountEXT>(GetDeviceProcAddr(device, "vkCmdSetViewportWithCountEXT"));
                CmdSetScissorWithCountEXT = reinterpret_cast<PFN_vkCmdSetScissorWithCountEXT>(GetDeviceProcAddr(device, "vkCmdSetScissorWithCountEXT"));
                CmdBindVertexBuffers2EXT = reinterpret_cast<PFN_vkCmdBindVertexBuffers2EXT>(GetDeviceProcAddr(device, "vkCmdBindVertexBuffers2EXT"));
                CmdSetDepthTestEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthTestEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthTestEnableEXT"));
                CmdSetDepthWriteEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthWriteEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthWriteEnableEXT"));
                CmdSetDepthCompareOpEXT = reinterpret_cast<PFN_vkCmdSetDepthCompareOpEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthCompareOpEXT"));
                CmdSetDepthBoundsTestEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthBoundsTestEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthBoundsTestEnableEXT"));
                CmdSetStencilTestEnableEXT = reinterpret_cast<PFN_vkCmdSetStencilTestEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetStencilTestEnableEXT"));
                CmdSetStencilOpEXT = reinterpret_cast<PFN_vkCmdSetStencilOpEXT>(GetDeviceProcAddr(device, "vkCmdSetStencilOpEXT"));
                CmdSetVertexInputEXT = reinterpret_cast<PFN_vkCmdSetVertexInputEXT>(GetDeviceProcAddr(device, "vkCmdSetVertexInputEXT"));
                CmdSetPatchControlPointsEXT = reinterpret_cast<PFN_vkCmdSetPatchControlPointsEXT>(GetDeviceProcAddr(device, "vkCmdSetPatchControlPointsEXT"));
                CmdSetRasterizerDiscardEnableEXT = reinterpret_cast<PFN_vkCmdSetRasterizerDiscardEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetRasterizerDiscardEnableEXT"));
                CmdSetDepthBiasEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthBiasEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthBiasEnableEXT"));
                CmdSetLogicOpEXT = reinterpret_cast<PFN_vkCmdSetLogicOpEXT>(GetDeviceProcAddr(device, "vkCmdSetLogicOpEXT"));
                CmdSetPrimitiveRestartEnableEXT = reinterpret_cast<PFN_vkCmdSetPrimitiveRestartEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetPrimitiveRestartEnableEXT"));
                CmdSetTessellationDomainOriginEXT = reinterpret_cast<PFN_vkCmdSetTessellationDomainOriginEXT>(GetDeviceProcAddr(device, "vkCmdSetTessellationDomainOriginEXT"));
                CmdSetDepthClampEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthClampEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthClampEnableEXT"));
                CmdSetPolygonModeEXT = reinterpret_cast<PFN_vkCmdSetPolygonModeEXT>(GetDeviceProcAddr(device, "vkCmdSetPolygonModeEXT"));
                CmdSetRasterizationSamplesEXT = reinterpret_cast<PFN_vkCmdSetRasterizationSamplesEXT>(GetDeviceProcAddr(device, "vkCmdSetRasterizationSamplesEXT"));
                CmdSetSampleMaskEXT = reinterpret_cast<PFN_vkCmdSetSampleMaskEXT>(GetDeviceProcAddr(device, "vkCmdSetSampleMaskEXT"));
                CmdSetAlphaToCoverageEnableEXT = reinterpret_cast<PFN_vkCmdSetAlphaToCoverageEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetAlphaToCoverageEnableEXT"));
                CmdSetAlphaToOneEnableEXT = reinterpret_cast<PFN_vkCmdSetAlphaToOneEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetAlphaToOneEnableEXT"));
                CmdSetLogicOpEnableEXT = reinterpret_cast<PFN_vkCmdSetLogicOpEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetLogicOpEnableEXT"));
                CmdSetColorBlendEnableEXT = reinterpret_cast<PFN_vkCmdSetColorBlendEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetColorBlendEnableEXT"));
                CmdSetColorBlendEquationEXT = reinterpret_cast<PFN_vkCmdSetColorBlendEquationEXT>(GetDeviceProcAddr(device, "vkCmdSetColorBlendEquationEXT"));
                CmdSetColorWriteMaskEXT = reinterpret_cast<PFN_vkCmdSetColorWriteMaskEXT>(GetDeviceProcAddr(device, "vkCmdSetColorWriteMaskEXT"));
                CmdSetRasterizationStreamEXT = reinterpret_cast<PFN_vkCmdSetRasterizationStreamEXT>(GetDeviceProcAddr(device, "vkCmdSetRasterizationStreamEXT"));
                CmdSetConservativeRasterizationModeEXT = reinterpret_cast<PFN_vkCmdSetConservativeRasterizationModeEXT>(GetDeviceProcAddr(device, "vkCmdSetConservativeRasterizationModeEXT"));
                CmdSetExtraPrimitiveOverestimationSizeEXT = reinterpret_cast<PFN_vkCmdSetExtraPrimitiveOverestimationSizeEXT>(GetDeviceProcAddr(device, "vkCmdSetExtraPrimitiveOverestimationSizeEXT"));
                CmdSetDepthClipEnableEXT = reinterpret_cast<PFN_vkCmdSetDepthClipEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthClipEnableEXT"));
                CmdSetSampleLocationsEnableEXT = reinterpret_cast<PFN_vkCmdSetSampleLocationsEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetSampleLocationsEnableEXT"));
                CmdSetColorBlendAdvancedEXT = reinterpret_cast<PFN_vkCmdSetColorBlendAdvancedEXT>(GetDeviceProcAddr(device, "vkCmdSetColorBlendAdvancedEXT"));
                CmdSetProvokingVertexModeEXT = reinterpret_cast<PFN_vkCmdSetProvokingVertexModeEXT>(GetDeviceProcAddr(device, "vkCmdSetProvokingVertexModeEXT"));
                CmdSetLineRasterizationModeEXT = reinterpret_cast<PFN_vkCmdSetLineRasterizationModeEXT>(GetDeviceProcAddr(device, "vkCmdSetLineRasterizationModeEXT"));
                CmdSetLineStippleEnableEXT = reinterpret_cast<PFN_vkCmdSetLineStippleEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetLineStippleEnableEXT"));
                CmdSetDepthClipNegativeOneToOneEXT = reinterpret_cast<PFN_vkCmdSetDepthClipNegativeOneToOneEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthClipNegativeOneToOneEXT"));
                CmdSetViewportWScalingEnableNV = reinterpret_cast<PFN_vkCmdSetViewportWScalingEnableNV>(GetDeviceProcAddr(device, "vkCmdSetViewportWScalingEnableNV"));
                CmdSetViewportSwizzleNV = reinterpret_cast<PFN_vkCmdSetViewportSwizzleNV>(GetDeviceProcAddr(device, "vkCmdSetViewportSwizzleNV"));
                CmdSetCoverageToColorEnableNV = reinterpret_cast<PFN_vkCmdSetCoverageToColorEnableNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageToColorEnableNV"));
                CmdSetCoverageToColorLocationNV = reinterpret_cast<PFN_vkCmdSetCoverageToColorLocationNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageToColorLocationNV"));
                CmdSetCoverageModulationModeNV = reinterpret_cast<PFN_vkCmdSetCoverageModulationModeNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageModulationModeNV"));
                CmdSetCoverageModulationTableEnableNV = reinterpret_cast<PFN_vkCmdSetCoverageModulationTableEnableNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageModulationTableEnableNV"));
                CmdSetCoverageModulationTableNV = reinterpret_cast<PFN_vkCmdSetCoverageModulationTableNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageModulationTableNV"));
                CmdSetShadingRateImageEnableNV = reinterpret_cast<PFN_vkCmdSetShadingRateImageEnableNV>(GetDeviceProcAddr(device, "vkCmdSetShadingRateImageEnableNV"));
                CmdSetRepresentativeFragmentTestEnableNV = reinterpret_cast<PFN_vkCmdSetRepresentativeFragmentTestEnableNV>(GetDeviceProcAddr(device, "vkCmdSetRepresentativeFragmentTestEnableNV"));
                CmdSetCoverageReductionModeNV = reinterpret_cast<PFN_vkCmdSetCoverageReductionModeNV>(GetDeviceProcAddr(device, "vkCmdSetCoverageReductionModeNV"));
                CmdSetDepthClampRangeEXT = reinterpret_cast<PFN_vkCmdSetDepthClampRangeEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthClampRangeEXT"));
            }
        },
        {
            "VK_QCOM_tile_properties", [](VkInstance , VkDevice device) {
                GetFramebufferTilePropertiesQCOM = reinterpret_cast<PFN_vkGetFramebufferTilePropertiesQCOM>(GetDeviceProcAddr(device, "vkGetFramebufferTilePropertiesQCOM"));
                GetDynamicRenderingTilePropertiesQCOM = reinterpret_cast<PFN_vkGetDynamicRenderingTilePropertiesQCOM>(GetDeviceProcAddr(device, "vkGetDynamicRenderingTilePropertiesQCOM"));
            }
        },
        {
            "VK_NV_cooperative_vector", [](VkInstance instance, VkDevice device) {
                ConvertCooperativeVectorMatrixNV = reinterpret_cast<PFN_vkConvertCooperativeVectorMatrixNV>(GetDeviceProcAddr(device, "vkConvertCooperativeVectorMatrixNV"));
                CmdConvertCooperativeVectorMatrixNV = reinterpret_cast<PFN_vkCmdConvertCooperativeVectorMatrixNV>(GetDeviceProcAddr(device, "vkCmdConvertCooperativeVectorMatrixNV"));
                GetPhysicalDeviceCooperativeVectorPropertiesNV = reinterpret_cast<PFN_vkGetPhysicalDeviceCooperativeVectorPropertiesNV>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceCooperativeVectorPropertiesNV"));
            }
        },
        {
            "VK_NV_low_latency2", [](VkInstance , VkDevice device) {
                SetLatencySleepModeNV = reinterpret_cast<PFN_vkSetLatencySleepModeNV>(GetDeviceProcAddr(device, "vkSetLatencySleepModeNV"));
                LatencySleepNV = reinterpret_cast<PFN_vkLatencySleepNV>(GetDeviceProcAddr(device, "vkLatencySleepNV"));
                SetLatencyMarkerNV = reinterpret_cast<PFN_vkSetLatencyMarkerNV>(GetDeviceProcAddr(device, "vkSetLatencyMarkerNV"));
                GetLatencyTimingsNV = reinterpret_cast<PFN_vkGetLatencyTimingsNV>(GetDeviceProcAddr(device, "vkGetLatencyTimingsNV"));
                QueueNotifyOutOfBandNV = reinterpret_cast<PFN_vkQueueNotifyOutOfBandNV>(GetDeviceProcAddr(device, "vkQueueNotifyOutOfBandNV"));
            }
        },
        {
            "VK_ARM_data_graph", [](VkInstance instance, VkDevice device) {
                CreateDataGraphPipelinesARM = reinterpret_cast<PFN_vkCreateDataGraphPipelinesARM>(GetDeviceProcAddr(device, "vkCreateDataGraphPipelinesARM"));
                CreateDataGraphPipelineSessionARM = reinterpret_cast<PFN_vkCreateDataGraphPipelineSessionARM>(GetDeviceProcAddr(device, "vkCreateDataGraphPipelineSessionARM"));
                GetDataGraphPipelineSessionBindPointRequirementsARM = reinterpret_cast<PFN_vkGetDataGraphPipelineSessionBindPointRequirementsARM>(GetDeviceProcAddr(device, "vkGetDataGraphPipelineSessionBindPointRequirementsARM"));
                GetDataGraphPipelineSessionMemoryRequirementsARM = reinterpret_cast<PFN_vkGetDataGraphPipelineSessionMemoryRequirementsARM>(GetDeviceProcAddr(device, "vkGetDataGraphPipelineSessionMemoryRequirementsARM"));
                BindDataGraphPipelineSessionMemoryARM = reinterpret_cast<PFN_vkBindDataGraphPipelineSessionMemoryARM>(GetDeviceProcAddr(device, "vkBindDataGraphPipelineSessionMemoryARM"));
                DestroyDataGraphPipelineSessionARM = reinterpret_cast<PFN_vkDestroyDataGraphPipelineSessionARM>(GetDeviceProcAddr(device, "vkDestroyDataGraphPipelineSessionARM"));
                CmdDispatchDataGraphARM = reinterpret_cast<PFN_vkCmdDispatchDataGraphARM>(GetDeviceProcAddr(device, "vkCmdDispatchDataGraphARM"));
                GetDataGraphPipelineAvailablePropertiesARM = reinterpret_cast<PFN_vkGetDataGraphPipelineAvailablePropertiesARM>(GetDeviceProcAddr(device, "vkGetDataGraphPipelineAvailablePropertiesARM"));
                GetDataGraphPipelinePropertiesARM = reinterpret_cast<PFN_vkGetDataGraphPipelinePropertiesARM>(GetDeviceProcAddr(device, "vkGetDataGraphPipelinePropertiesARM"));
                GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM = reinterpret_cast<PFN_vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM"));
                GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM = reinterpret_cast<PFN_vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM"));
            }
        },
        {
            "VK_EXT_attachment_feedback_loop_dynamic_state", [](VkInstance , VkDevice device) {
                CmdSetAttachmentFeedbackLoopEnableEXT = reinterpret_cast<PFN_vkCmdSetAttachmentFeedbackLoopEnableEXT>(GetDeviceProcAddr(device, "vkCmdSetAttachmentFeedbackLoopEnableEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_SCREEN_QNX
        {
            "VK_QNX_external_memory_screen_buffer", [](VkInstance , VkDevice device) {
                GetScreenBufferPropertiesQNX = reinterpret_cast<PFN_vkGetScreenBufferPropertiesQNX>(GetDeviceProcAddr(device, "vkGetScreenBufferPropertiesQNX"));
            }
        },
#endif  // VK_USE_PLATFORM_SCREEN_QNX
        {
            "VK_QCOM_tile_memory_heap", [](VkInstance , VkDevice device) {
                CmdBindTileMemoryQCOM = reinterpret_cast<PFN_vkCmdBindTileMemoryQCOM>(GetDeviceProcAddr(device, "vkCmdBindTileMemoryQCOM"));
            }
        },
        {
            "VK_EXT_memory_decompression", [](VkInstance , VkDevice device) {
                CmdDecompressMemoryEXT = reinterpret_cast<PFN_vkCmdDecompressMemoryEXT>(GetDeviceProcAddr(device, "vkCmdDecompressMemoryEXT"));
                CmdDecompressMemoryIndirectCountEXT = reinterpret_cast<PFN_vkCmdDecompressMemoryIndirectCountEXT>(GetDeviceProcAddr(device, "vkCmdDecompressMemoryIndirectCountEXT"));
            }
        },
        {
            "VK_NV_external_compute_queue", [](VkInstance , VkDevice device) {
                CreateExternalComputeQueueNV = reinterpret_cast<PFN_vkCreateExternalComputeQueueNV>(GetDeviceProcAddr(device, "vkCreateExternalComputeQueueNV"));
                DestroyExternalComputeQueueNV = reinterpret_cast<PFN_vkDestroyExternalComputeQueueNV>(GetDeviceProcAddr(device, "vkDestroyExternalComputeQueueNV"));
                GetExternalComputeQueueDataNV = reinterpret_cast<PFN_vkGetExternalComputeQueueDataNV>(GetDeviceProcAddr(device, "vkGetExternalComputeQueueDataNV"));
            }
        },
        {
            "VK_NV_cluster_acceleration_structure", [](VkInstance , VkDevice device) {
                GetClusterAccelerationStructureBuildSizesNV = reinterpret_cast<PFN_vkGetClusterAccelerationStructureBuildSizesNV>(GetDeviceProcAddr(device, "vkGetClusterAccelerationStructureBuildSizesNV"));
                CmdBuildClusterAccelerationStructureIndirectNV = reinterpret_cast<PFN_vkCmdBuildClusterAccelerationStructureIndirectNV>(GetDeviceProcAddr(device, "vkCmdBuildClusterAccelerationStructureIndirectNV"));
            }
        },
        {
            "VK_NV_partitioned_acceleration_structure", [](VkInstance , VkDevice device) {
                GetPartitionedAccelerationStructuresBuildSizesNV = reinterpret_cast<PFN_vkGetPartitionedAccelerationStructuresBuildSizesNV>(GetDeviceProcAddr(device, "vkGetPartitionedAccelerationStructuresBuildSizesNV"));
                CmdBuildPartitionedAccelerationStructuresNV = reinterpret_cast<PFN_vkCmdBuildPartitionedAccelerationStructuresNV>(GetDeviceProcAddr(device, "vkCmdBuildPartitionedAccelerationStructuresNV"));
            }
        },
        {
            "VK_EXT_device_generated_commands", [](VkInstance , VkDevice device) {
                GetGeneratedCommandsMemoryRequirementsEXT = reinterpret_cast<PFN_vkGetGeneratedCommandsMemoryRequirementsEXT>(GetDeviceProcAddr(device, "vkGetGeneratedCommandsMemoryRequirementsEXT"));
                CmdPreprocessGeneratedCommandsEXT = reinterpret_cast<PFN_vkCmdPreprocessGeneratedCommandsEXT>(GetDeviceProcAddr(device, "vkCmdPreprocessGeneratedCommandsEXT"));
                CmdExecuteGeneratedCommandsEXT = reinterpret_cast<PFN_vkCmdExecuteGeneratedCommandsEXT>(GetDeviceProcAddr(device, "vkCmdExecuteGeneratedCommandsEXT"));
                CreateIndirectCommandsLayoutEXT = reinterpret_cast<PFN_vkCreateIndirectCommandsLayoutEXT>(GetDeviceProcAddr(device, "vkCreateIndirectCommandsLayoutEXT"));
                DestroyIndirectCommandsLayoutEXT = reinterpret_cast<PFN_vkDestroyIndirectCommandsLayoutEXT>(GetDeviceProcAddr(device, "vkDestroyIndirectCommandsLayoutEXT"));
                CreateIndirectExecutionSetEXT = reinterpret_cast<PFN_vkCreateIndirectExecutionSetEXT>(GetDeviceProcAddr(device, "vkCreateIndirectExecutionSetEXT"));
                DestroyIndirectExecutionSetEXT = reinterpret_cast<PFN_vkDestroyIndirectExecutionSetEXT>(GetDeviceProcAddr(device, "vkDestroyIndirectExecutionSetEXT"));
                UpdateIndirectExecutionSetPipelineEXT = reinterpret_cast<PFN_vkUpdateIndirectExecutionSetPipelineEXT>(GetDeviceProcAddr(device, "vkUpdateIndirectExecutionSetPipelineEXT"));
                UpdateIndirectExecutionSetShaderEXT = reinterpret_cast<PFN_vkUpdateIndirectExecutionSetShaderEXT>(GetDeviceProcAddr(device, "vkUpdateIndirectExecutionSetShaderEXT"));
            }
        },
        {
            "VK_EXT_depth_clamp_control", [](VkInstance , VkDevice device) {
                CmdSetDepthClampRangeEXT = reinterpret_cast<PFN_vkCmdSetDepthClampRangeEXT>(GetDeviceProcAddr(device, "vkCmdSetDepthClampRangeEXT"));
            }
        },
#ifdef VK_USE_PLATFORM_OHOS
        {
            "VK_OHOS_native_buffer", [](VkInstance , VkDevice device) {
                GetSwapchainGrallocUsageOHOS = reinterpret_cast<PFN_vkGetSwapchainGrallocUsageOHOS>(GetDeviceProcAddr(device, "vkGetSwapchainGrallocUsageOHOS"));
                AcquireImageOHOS = reinterpret_cast<PFN_vkAcquireImageOHOS>(GetDeviceProcAddr(device, "vkAcquireImageOHOS"));
                QueueSignalReleaseImageOHOS = reinterpret_cast<PFN_vkQueueSignalReleaseImageOHOS>(GetDeviceProcAddr(device, "vkQueueSignalReleaseImageOHOS"));
            }
        },
#endif  // VK_USE_PLATFORM_OHOS
        {
            "VK_NV_cooperative_matrix2", [](VkInstance instance, VkDevice ) {
                GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV = reinterpret_cast<PFN_vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV>(GetInstanceProcAddr(instance, "vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV"));
            }
        },
#ifdef VK_USE_PLATFORM_METAL_EXT
        {
            "VK_EXT_external_memory_metal", [](VkInstance , VkDevice device) {
                GetMemoryMetalHandleEXT = reinterpret_cast<PFN_vkGetMemoryMetalHandleEXT>(GetDeviceProcAddr(device, "vkGetMemoryMetalHandleEXT"));
                GetMemoryMetalHandlePropertiesEXT = reinterpret_cast<PFN_vkGetMemoryMetalHandlePropertiesEXT>(GetDeviceProcAddr(device, "vkGetMemoryMetalHandlePropertiesEXT"));
            }
        },
#endif  // VK_USE_PLATFORM_METAL_EXT
        {
            "VK_ARM_performance_counters_by_region", [](VkInstance instance, VkDevice ) {
                EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM = reinterpret_cast<PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM>(GetInstanceProcAddr(instance, "vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM"));
            }
        },
        {
            "VK_EXT_fragment_density_map_offset", [](VkInstance , VkDevice device) {
                CmdEndRendering2EXT = reinterpret_cast<PFN_vkCmdEndRendering2EXT>(GetDeviceProcAddr(device, "vkCmdEndRendering2EXT"));
            }
        },
        {
            "VK_EXT_custom_resolve", [](VkInstance , VkDevice device) {
                CmdBeginCustomResolveEXT = reinterpret_cast<PFN_vkCmdBeginCustomResolveEXT>(GetDeviceProcAddr(device, "vkCmdBeginCustomResolveEXT"));
            }
        },
        {
            "VK_KHR_acceleration_structure", [](VkInstance , VkDevice device) {
                CreateAccelerationStructureKHR = reinterpret_cast<PFN_vkCreateAccelerationStructureKHR>(GetDeviceProcAddr(device, "vkCreateAccelerationStructureKHR"));
                DestroyAccelerationStructureKHR = reinterpret_cast<PFN_vkDestroyAccelerationStructureKHR>(GetDeviceProcAddr(device, "vkDestroyAccelerationStructureKHR"));
                CmdBuildAccelerationStructuresKHR = reinterpret_cast<PFN_vkCmdBuildAccelerationStructuresKHR>(GetDeviceProcAddr(device, "vkCmdBuildAccelerationStructuresKHR"));
                CmdBuildAccelerationStructuresIndirectKHR = reinterpret_cast<PFN_vkCmdBuildAccelerationStructuresIndirectKHR>(GetDeviceProcAddr(device, "vkCmdBuildAccelerationStructuresIndirectKHR"));
                BuildAccelerationStructuresKHR = reinterpret_cast<PFN_vkBuildAccelerationStructuresKHR>(GetDeviceProcAddr(device, "vkBuildAccelerationStructuresKHR"));
                CopyAccelerationStructureKHR = reinterpret_cast<PFN_vkCopyAccelerationStructureKHR>(GetDeviceProcAddr(device, "vkCopyAccelerationStructureKHR"));
                CopyAccelerationStructureToMemoryKHR = reinterpret_cast<PFN_vkCopyAccelerationStructureToMemoryKHR>(GetDeviceProcAddr(device, "vkCopyAccelerationStructureToMemoryKHR"));
                CopyMemoryToAccelerationStructureKHR = reinterpret_cast<PFN_vkCopyMemoryToAccelerationStructureKHR>(GetDeviceProcAddr(device, "vkCopyMemoryToAccelerationStructureKHR"));
                WriteAccelerationStructuresPropertiesKHR = reinterpret_cast<PFN_vkWriteAccelerationStructuresPropertiesKHR>(GetDeviceProcAddr(device, "vkWriteAccelerationStructuresPropertiesKHR"));
                CmdCopyAccelerationStructureKHR = reinterpret_cast<PFN_vkCmdCopyAccelerationStructureKHR>(GetDeviceProcAddr(device, "vkCmdCopyAccelerationStructureKHR"));
                CmdCopyAccelerationStructureToMemoryKHR = reinterpret_cast<PFN_vkCmdCopyAccelerationStructureToMemoryKHR>(GetDeviceProcAddr(device, "vkCmdCopyAccelerationStructureToMemoryKHR"));
                CmdCopyMemoryToAccelerationStructureKHR = reinterpret_cast<PFN_vkCmdCopyMemoryToAccelerationStructureKHR>(GetDeviceProcAddr(device, "vkCmdCopyMemoryToAccelerationStructureKHR"));
                GetAccelerationStructureDeviceAddressKHR = reinterpret_cast<PFN_vkGetAccelerationStructureDeviceAddressKHR>(GetDeviceProcAddr(device, "vkGetAccelerationStructureDeviceAddressKHR"));
                CmdWriteAccelerationStructuresPropertiesKHR = reinterpret_cast<PFN_vkCmdWriteAccelerationStructuresPropertiesKHR>(GetDeviceProcAddr(device, "vkCmdWriteAccelerationStructuresPropertiesKHR"));
                GetDeviceAccelerationStructureCompatibilityKHR = reinterpret_cast<PFN_vkGetDeviceAccelerationStructureCompatibilityKHR>(GetDeviceProcAddr(device, "vkGetDeviceAccelerationStructureCompatibilityKHR"));
                GetAccelerationStructureBuildSizesKHR = reinterpret_cast<PFN_vkGetAccelerationStructureBuildSizesKHR>(GetDeviceProcAddr(device, "vkGetAccelerationStructureBuildSizesKHR"));
            }
        },
        {
            "VK_KHR_ray_tracing_pipeline", [](VkInstance , VkDevice device) {
                CmdTraceRaysKHR = reinterpret_cast<PFN_vkCmdTraceRaysKHR>(GetDeviceProcAddr(device, "vkCmdTraceRaysKHR"));
                CreateRayTracingPipelinesKHR = reinterpret_cast<PFN_vkCreateRayTracingPipelinesKHR>(GetDeviceProcAddr(device, "vkCreateRayTracingPipelinesKHR"));
                GetRayTracingShaderGroupHandlesKHR = reinterpret_cast<PFN_vkGetRayTracingShaderGroupHandlesKHR>(GetDeviceProcAddr(device, "vkGetRayTracingShaderGroupHandlesKHR"));
                GetRayTracingCaptureReplayShaderGroupHandlesKHR = reinterpret_cast<PFN_vkGetRayTracingCaptureReplayShaderGroupHandlesKHR>(GetDeviceProcAddr(device, "vkGetRayTracingCaptureReplayShaderGroupHandlesKHR"));
                CmdTraceRaysIndirectKHR = reinterpret_cast<PFN_vkCmdTraceRaysIndirectKHR>(GetDeviceProcAddr(device, "vkCmdTraceRaysIndirectKHR"));
                GetRayTracingShaderGroupStackSizeKHR = reinterpret_cast<PFN_vkGetRayTracingShaderGroupStackSizeKHR>(GetDeviceProcAddr(device, "vkGetRayTracingShaderGroupStackSizeKHR"));
                CmdSetRayTracingPipelineStackSizeKHR = reinterpret_cast<PFN_vkCmdSetRayTracingPipelineStackSizeKHR>(GetDeviceProcAddr(device, "vkCmdSetRayTracingPipelineStackSizeKHR"));
            }
        },
        {
            "VK_EXT_mesh_shader", [](VkInstance , VkDevice device) {
                CmdDrawMeshTasksEXT = reinterpret_cast<PFN_vkCmdDrawMeshTasksEXT>(GetDeviceProcAddr(device, "vkCmdDrawMeshTasksEXT"));
                CmdDrawMeshTasksIndirectEXT = reinterpret_cast<PFN_vkCmdDrawMeshTasksIndirectEXT>(GetDeviceProcAddr(device, "vkCmdDrawMeshTasksIndirectEXT"));
                CmdDrawMeshTasksIndirectCountEXT = reinterpret_cast<PFN_vkCmdDrawMeshTasksIndirectCountEXT>(GetDeviceProcAddr(device, "vkCmdDrawMeshTasksIndirectCountEXT"));
            }
        },

    };

    if (auto it = initializers.find(extension_name); it != initializers.end())
        (it->second)(instance, device);
}
void ResetAllExtensions() {
    DestroySurfaceKHR = nullptr;
    GetPhysicalDeviceSurfaceSupportKHR = nullptr;
    GetPhysicalDeviceSurfaceCapabilitiesKHR = nullptr;
    GetPhysicalDeviceSurfaceFormatsKHR = nullptr;
    GetPhysicalDeviceSurfacePresentModesKHR = nullptr;
    CreateSwapchainKHR = nullptr;
    DestroySwapchainKHR = nullptr;
    GetSwapchainImagesKHR = nullptr;
    AcquireNextImageKHR = nullptr;
    QueuePresentKHR = nullptr;
    GetDeviceGroupPresentCapabilitiesKHR = nullptr;
    GetDeviceGroupSurfacePresentModesKHR = nullptr;
    GetPhysicalDevicePresentRectanglesKHR = nullptr;
    AcquireNextImage2KHR = nullptr;
    GetPhysicalDeviceDisplayPropertiesKHR = nullptr;
    GetPhysicalDeviceDisplayPlanePropertiesKHR = nullptr;
    GetDisplayPlaneSupportedDisplaysKHR = nullptr;
    GetDisplayModePropertiesKHR = nullptr;
    CreateDisplayModeKHR = nullptr;
    GetDisplayPlaneCapabilitiesKHR = nullptr;
    CreateDisplayPlaneSurfaceKHR = nullptr;
    CreateSharedSwapchainsKHR = nullptr;
#ifdef VK_USE_PLATFORM_XLIB_KHR
    CreateXlibSurfaceKHR = nullptr;
    GetPhysicalDeviceXlibPresentationSupportKHR = nullptr;
#endif  // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    CreateXcbSurfaceKHR = nullptr;
    GetPhysicalDeviceXcbPresentationSupportKHR = nullptr;
#endif  // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    CreateWaylandSurfaceKHR = nullptr;
    GetPhysicalDeviceWaylandPresentationSupportKHR = nullptr;
#endif  // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    CreateAndroidSurfaceKHR = nullptr;
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    CreateWin32SurfaceKHR = nullptr;
    GetPhysicalDeviceWin32PresentationSupportKHR = nullptr;
#endif  // VK_USE_PLATFORM_WIN32_KHR
    GetPhysicalDeviceVideoCapabilitiesKHR = nullptr;
    GetPhysicalDeviceVideoFormatPropertiesKHR = nullptr;
    CreateVideoSessionKHR = nullptr;
    DestroyVideoSessionKHR = nullptr;
    GetVideoSessionMemoryRequirementsKHR = nullptr;
    BindVideoSessionMemoryKHR = nullptr;
    CreateVideoSessionParametersKHR = nullptr;
    UpdateVideoSessionParametersKHR = nullptr;
    DestroyVideoSessionParametersKHR = nullptr;
    CmdBeginVideoCodingKHR = nullptr;
    CmdEndVideoCodingKHR = nullptr;
    CmdControlVideoCodingKHR = nullptr;
    CmdDecodeVideoKHR = nullptr;
    CmdBeginRenderingKHR = nullptr;
    CmdEndRenderingKHR = nullptr;
    GetPhysicalDeviceFeatures2KHR = nullptr;
    GetPhysicalDeviceProperties2KHR = nullptr;
    GetPhysicalDeviceFormatProperties2KHR = nullptr;
    GetPhysicalDeviceImageFormatProperties2KHR = nullptr;
    GetPhysicalDeviceQueueFamilyProperties2KHR = nullptr;
    GetPhysicalDeviceMemoryProperties2KHR = nullptr;
    GetPhysicalDeviceSparseImageFormatProperties2KHR = nullptr;
    GetDeviceGroupPeerMemoryFeaturesKHR = nullptr;
    CmdSetDeviceMaskKHR = nullptr;
    CmdDispatchBaseKHR = nullptr;
    TrimCommandPoolKHR = nullptr;
    EnumeratePhysicalDeviceGroupsKHR = nullptr;
    GetPhysicalDeviceExternalBufferPropertiesKHR = nullptr;
#ifdef VK_USE_PLATFORM_WIN32_KHR
    GetMemoryWin32HandleKHR = nullptr;
    GetMemoryWin32HandlePropertiesKHR = nullptr;
#endif  // VK_USE_PLATFORM_WIN32_KHR
    GetMemoryFdKHR = nullptr;
    GetMemoryFdPropertiesKHR = nullptr;
    GetPhysicalDeviceExternalSemaphorePropertiesKHR = nullptr;
#ifdef VK_USE_PLATFORM_WIN32_KHR
    ImportSemaphoreWin32HandleKHR = nullptr;
    GetSemaphoreWin32HandleKHR = nullptr;
#endif  // VK_USE_PLATFORM_WIN32_KHR
    ImportSemaphoreFdKHR = nullptr;
    GetSemaphoreFdKHR = nullptr;
    CmdPushDescriptorSetKHR = nullptr;
    CmdPushDescriptorSetWithTemplateKHR = nullptr;
    CreateDescriptorUpdateTemplateKHR = nullptr;
    DestroyDescriptorUpdateTemplateKHR = nullptr;
    UpdateDescriptorSetWithTemplateKHR = nullptr;
    CreateRenderPass2KHR = nullptr;
    CmdBeginRenderPass2KHR = nullptr;
    CmdNextSubpass2KHR = nullptr;
    CmdEndRenderPass2KHR = nullptr;
    GetSwapchainStatusKHR = nullptr;
    GetPhysicalDeviceExternalFencePropertiesKHR = nullptr;
#ifdef VK_USE_PLATFORM_WIN32_KHR
    ImportFenceWin32HandleKHR = nullptr;
    GetFenceWin32HandleKHR = nullptr;
#endif  // VK_USE_PLATFORM_WIN32_KHR
    ImportFenceFdKHR = nullptr;
    GetFenceFdKHR = nullptr;
    EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = nullptr;
    GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = nullptr;
    AcquireProfilingLockKHR = nullptr;
    ReleaseProfilingLockKHR = nullptr;
    GetPhysicalDeviceSurfaceCapabilities2KHR = nullptr;
    GetPhysicalDeviceSurfaceFormats2KHR = nullptr;
    GetPhysicalDeviceDisplayProperties2KHR = nullptr;
    GetPhysicalDeviceDisplayPlaneProperties2KHR = nullptr;
    GetDisplayModeProperties2KHR = nullptr;
    GetDisplayPlaneCapabilities2KHR = nullptr;
    GetImageMemoryRequirements2KHR = nullptr;
    GetBufferMemoryRequirements2KHR = nullptr;
    GetImageSparseMemoryRequirements2KHR = nullptr;
    CreateSamplerYcbcrConversionKHR = nullptr;
    DestroySamplerYcbcrConversionKHR = nullptr;
    BindBufferMemory2KHR = nullptr;
    BindImageMemory2KHR = nullptr;
    GetDescriptorSetLayoutSupportKHR = nullptr;
    CmdDrawIndirectCountKHR = nullptr;
    CmdDrawIndexedIndirectCountKHR = nullptr;
    GetSemaphoreCounterValueKHR = nullptr;
    WaitSemaphoresKHR = nullptr;
    SignalSemaphoreKHR = nullptr;
    GetPhysicalDeviceFragmentShadingRatesKHR = nullptr;
    CmdSetFragmentShadingRateKHR = nullptr;
    CmdSetRenderingAttachmentLocationsKHR = nullptr;
    CmdSetRenderingInputAttachmentIndicesKHR = nullptr;
    WaitForPresentKHR = nullptr;
    GetBufferDeviceAddressKHR = nullptr;
    GetBufferOpaqueCaptureAddressKHR = nullptr;
    GetDeviceMemoryOpaqueCaptureAddressKHR = nullptr;
    CreateDeferredOperationKHR = nullptr;
    DestroyDeferredOperationKHR = nullptr;
    GetDeferredOperationMaxConcurrencyKHR = nullptr;
    GetDeferredOperationResultKHR = nullptr;
    DeferredOperationJoinKHR = nullptr;
    GetPipelineExecutablePropertiesKHR = nullptr;
    GetPipelineExecutableStatisticsKHR = nullptr;
    GetPipelineExecutableInternalRepresentationsKHR = nullptr;
    MapMemory2KHR = nullptr;
    UnmapMemory2KHR = nullptr;
    GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = nullptr;
    GetEncodedVideoSessionParametersKHR = nullptr;
    CmdEncodeVideoKHR = nullptr;
    CmdSetEvent2KHR = nullptr;
    CmdResetEvent2KHR = nullptr;
    CmdWaitEvents2KHR = nullptr;
    CmdPipelineBarrier2KHR = nullptr;
    CmdWriteTimestamp2KHR = nullptr;
    QueueSubmit2KHR = nullptr;
    CmdCopyBuffer2KHR = nullptr;
    CmdCopyImage2KHR = nullptr;
    CmdCopyBufferToImage2KHR = nullptr;
    CmdCopyImageToBuffer2KHR = nullptr;
    CmdBlitImage2KHR = nullptr;
    CmdResolveImage2KHR = nullptr;
    CmdTraceRaysIndirect2KHR = nullptr;
    GetDeviceBufferMemoryRequirementsKHR = nullptr;
    GetDeviceImageMemoryRequirementsKHR = nullptr;
    GetDeviceImageSparseMemoryRequirementsKHR = nullptr;
    CmdBindIndexBuffer2KHR = nullptr;
    GetRenderingAreaGranularityKHR = nullptr;
    GetDeviceImageSubresourceLayoutKHR = nullptr;
    GetImageSubresourceLayout2KHR = nullptr;
    WaitForPresent2KHR = nullptr;
    CreatePipelineBinariesKHR = nullptr;
    DestroyPipelineBinaryKHR = nullptr;
    GetPipelineKeyKHR = nullptr;
    GetPipelineBinaryDataKHR = nullptr;
    ReleaseCapturedPipelineDataKHR = nullptr;
    ReleaseSwapchainImagesKHR = nullptr;
    GetPhysicalDeviceCooperativeMatrixPropertiesKHR = nullptr;
    CmdSetLineStippleKHR = nullptr;
    GetPhysicalDeviceCalibrateableTimeDomainsKHR = nullptr;
    GetCalibratedTimestampsKHR = nullptr;
    CmdBindDescriptorSets2KHR = nullptr;
    CmdPushConstants2KHR = nullptr;
    CmdPushDescriptorSet2KHR = nullptr;
    CmdPushDescriptorSetWithTemplate2KHR = nullptr;
    CmdSetDescriptorBufferOffsets2EXT = nullptr;
    CmdBindDescriptorBufferEmbeddedSamplers2EXT = nullptr;
    CmdCopyMemoryIndirectKHR = nullptr;
    CmdCopyMemoryToImageIndirectKHR = nullptr;
    CmdEndRendering2KHR = nullptr;
    CreateDebugReportCallbackEXT = nullptr;
    DestroyDebugReportCallbackEXT = nullptr;
    DebugReportMessageEXT = nullptr;
    DebugMarkerSetObjectTagEXT = nullptr;
    DebugMarkerSetObjectNameEXT = nullptr;
    CmdDebugMarkerBeginEXT = nullptr;
    CmdDebugMarkerEndEXT = nullptr;
    CmdDebugMarkerInsertEXT = nullptr;
    CmdBindTransformFeedbackBuffersEXT = nullptr;
    CmdBeginTransformFeedbackEXT = nullptr;
    CmdEndTransformFeedbackEXT = nullptr;
    CmdBeginQueryIndexedEXT = nullptr;
    CmdEndQueryIndexedEXT = nullptr;
    CmdDrawIndirectByteCountEXT = nullptr;
    CreateCuModuleNVX = nullptr;
    CreateCuFunctionNVX = nullptr;
    DestroyCuModuleNVX = nullptr;
    DestroyCuFunctionNVX = nullptr;
    CmdCuLaunchKernelNVX = nullptr;
    GetImageViewHandleNVX = nullptr;
    GetImageViewHandle64NVX = nullptr;
    GetImageViewAddressNVX = nullptr;
    CmdDrawIndirectCountAMD = nullptr;
    CmdDrawIndexedIndirectCountAMD = nullptr;
    GetShaderInfoAMD = nullptr;
#ifdef VK_USE_PLATFORM_GGP
    CreateStreamDescriptorSurfaceGGP = nullptr;
#endif  // VK_USE_PLATFORM_GGP
    GetPhysicalDeviceExternalImageFormatPropertiesNV = nullptr;
#ifdef VK_USE_PLATFORM_WIN32_KHR
    GetMemoryWin32HandleNV = nullptr;
#endif  // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_VI_NN
    CreateViSurfaceNN = nullptr;
#endif  // VK_USE_PLATFORM_VI_NN
    CmdBeginConditionalRenderingEXT = nullptr;
    CmdEndConditionalRenderingEXT = nullptr;
    CmdSetViewportWScalingNV = nullptr;
    ReleaseDisplayEXT = nullptr;
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    AcquireXlibDisplayEXT = nullptr;
    GetRandROutputDisplayEXT = nullptr;
#endif  // VK_USE_PLATFORM_XLIB_XRANDR_EXT
    GetPhysicalDeviceSurfaceCapabilities2EXT = nullptr;
    DisplayPowerControlEXT = nullptr;
    RegisterDeviceEventEXT = nullptr;
    RegisterDisplayEventEXT = nullptr;
    GetSwapchainCounterEXT = nullptr;
    GetRefreshCycleDurationGOOGLE = nullptr;
    GetPastPresentationTimingGOOGLE = nullptr;
    CmdSetDiscardRectangleEXT = nullptr;
    CmdSetDiscardRectangleEnableEXT = nullptr;
    CmdSetDiscardRectangleModeEXT = nullptr;
    SetHdrMetadataEXT = nullptr;
#ifdef VK_USE_PLATFORM_IOS_MVK
    CreateIOSSurfaceMVK = nullptr;
#endif  // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
    CreateMacOSSurfaceMVK = nullptr;
#endif  // VK_USE_PLATFORM_MACOS_MVK
    SetDebugUtilsObjectNameEXT = nullptr;
    SetDebugUtilsObjectTagEXT = nullptr;
    QueueBeginDebugUtilsLabelEXT = nullptr;
    QueueEndDebugUtilsLabelEXT = nullptr;
    QueueInsertDebugUtilsLabelEXT = nullptr;
    CmdBeginDebugUtilsLabelEXT = nullptr;
    CmdEndDebugUtilsLabelEXT = nullptr;
    CmdInsertDebugUtilsLabelEXT = nullptr;
    CreateDebugUtilsMessengerEXT = nullptr;
    DestroyDebugUtilsMessengerEXT = nullptr;
    SubmitDebugUtilsMessageEXT = nullptr;
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    GetAndroidHardwareBufferPropertiesANDROID = nullptr;
    GetMemoryAndroidHardwareBufferANDROID = nullptr;
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_ENABLE_BETA_EXTENSIONS
    CreateExecutionGraphPipelinesAMDX = nullptr;
    GetExecutionGraphPipelineScratchSizeAMDX = nullptr;
    GetExecutionGraphPipelineNodeIndexAMDX = nullptr;
    CmdInitializeGraphScratchMemoryAMDX = nullptr;
    CmdDispatchGraphAMDX = nullptr;
    CmdDispatchGraphIndirectAMDX = nullptr;
    CmdDispatchGraphIndirectCountAMDX = nullptr;
#endif  // VK_ENABLE_BETA_EXTENSIONS
    CmdSetSampleLocationsEXT = nullptr;
    GetPhysicalDeviceMultisamplePropertiesEXT = nullptr;
    GetImageDrmFormatModifierPropertiesEXT = nullptr;
    CreateValidationCacheEXT = nullptr;
    DestroyValidationCacheEXT = nullptr;
    MergeValidationCachesEXT = nullptr;
    GetValidationCacheDataEXT = nullptr;
    CmdBindShadingRateImageNV = nullptr;
    CmdSetViewportShadingRatePaletteNV = nullptr;
    CmdSetCoarseSampleOrderNV = nullptr;
    CreateAccelerationStructureNV = nullptr;
    DestroyAccelerationStructureNV = nullptr;
    GetAccelerationStructureMemoryRequirementsNV = nullptr;
    BindAccelerationStructureMemoryNV = nullptr;
    CmdBuildAccelerationStructureNV = nullptr;
    CmdCopyAccelerationStructureNV = nullptr;
    CmdTraceRaysNV = nullptr;
    CreateRayTracingPipelinesNV = nullptr;
    GetRayTracingShaderGroupHandlesKHR = nullptr;
    GetRayTracingShaderGroupHandlesNV = nullptr;
    GetAccelerationStructureHandleNV = nullptr;
    CmdWriteAccelerationStructuresPropertiesNV = nullptr;
    CompileDeferredNV = nullptr;
    GetMemoryHostPointerPropertiesEXT = nullptr;
    CmdWriteBufferMarkerAMD = nullptr;
    CmdWriteBufferMarker2AMD = nullptr;
    GetPhysicalDeviceCalibrateableTimeDomainsEXT = nullptr;
    GetCalibratedTimestampsEXT = nullptr;
    CmdDrawMeshTasksNV = nullptr;
    CmdDrawMeshTasksIndirectNV = nullptr;
    CmdDrawMeshTasksIndirectCountNV = nullptr;
    CmdSetExclusiveScissorEnableNV = nullptr;
    CmdSetExclusiveScissorNV = nullptr;
    CmdSetCheckpointNV = nullptr;
    GetQueueCheckpointDataNV = nullptr;
    GetQueueCheckpointData2NV = nullptr;
    SetSwapchainPresentTimingQueueSizeEXT = nullptr;
    GetSwapchainTimingPropertiesEXT = nullptr;
    GetSwapchainTimeDomainPropertiesEXT = nullptr;
    GetPastPresentationTimingEXT = nullptr;
    InitializePerformanceApiINTEL = nullptr;
    UninitializePerformanceApiINTEL = nullptr;
    CmdSetPerformanceMarkerINTEL = nullptr;
    CmdSetPerformanceStreamMarkerINTEL = nullptr;
    CmdSetPerformanceOverrideINTEL = nullptr;
    AcquirePerformanceConfigurationINTEL = nullptr;
    ReleasePerformanceConfigurationINTEL = nullptr;
    QueueSetPerformanceConfigurationINTEL = nullptr;
    GetPerformanceParameterINTEL = nullptr;
    SetLocalDimmingAMD = nullptr;
#ifdef VK_USE_PLATFORM_FUCHSIA
    CreateImagePipeSurfaceFUCHSIA = nullptr;
#endif  // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_METAL_EXT
    CreateMetalSurfaceEXT = nullptr;
#endif  // VK_USE_PLATFORM_METAL_EXT
    GetBufferDeviceAddressEXT = nullptr;
    GetPhysicalDeviceToolPropertiesEXT = nullptr;
    GetPhysicalDeviceCooperativeMatrixPropertiesNV = nullptr;
    GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = nullptr;
#ifdef VK_USE_PLATFORM_WIN32_KHR
    GetPhysicalDeviceSurfacePresentModes2EXT = nullptr;
    AcquireFullScreenExclusiveModeEXT = nullptr;
    ReleaseFullScreenExclusiveModeEXT = nullptr;
    GetDeviceGroupSurfacePresentModes2EXT = nullptr;
#endif  // VK_USE_PLATFORM_WIN32_KHR
    CreateHeadlessSurfaceEXT = nullptr;
    CmdSetLineStippleEXT = nullptr;
    ResetQueryPoolEXT = nullptr;
    CmdSetCullModeEXT = nullptr;
    CmdSetFrontFaceEXT = nullptr;
    CmdSetPrimitiveTopologyEXT = nullptr;
    CmdSetViewportWithCountEXT = nullptr;
    CmdSetScissorWithCountEXT = nullptr;
    CmdBindVertexBuffers2EXT = nullptr;
    CmdSetDepthTestEnableEXT = nullptr;
    CmdSetDepthWriteEnableEXT = nullptr;
    CmdSetDepthCompareOpEXT = nullptr;
    CmdSetDepthBoundsTestEnableEXT = nullptr;
    CmdSetStencilTestEnableEXT = nullptr;
    CmdSetStencilOpEXT = nullptr;
    CopyMemoryToImageEXT = nullptr;
    CopyImageToMemoryEXT = nullptr;
    CopyImageToImageEXT = nullptr;
    TransitionImageLayoutEXT = nullptr;
    GetImageSubresourceLayout2EXT = nullptr;
    ReleaseSwapchainImagesEXT = nullptr;
    GetGeneratedCommandsMemoryRequirementsNV = nullptr;
    CmdPreprocessGeneratedCommandsNV = nullptr;
    CmdExecuteGeneratedCommandsNV = nullptr;
    CmdBindPipelineShaderGroupNV = nullptr;
    CreateIndirectCommandsLayoutNV = nullptr;
    DestroyIndirectCommandsLayoutNV = nullptr;
    CmdSetDepthBias2EXT = nullptr;
    AcquireDrmDisplayEXT = nullptr;
    GetDrmDisplayEXT = nullptr;
    CreatePrivateDataSlotEXT = nullptr;
    DestroyPrivateDataSlotEXT = nullptr;
    SetPrivateDataEXT = nullptr;
    GetPrivateDataEXT = nullptr;
#ifdef VK_ENABLE_BETA_EXTENSIONS
    CreateCudaModuleNV = nullptr;
    GetCudaModuleCacheNV = nullptr;
    CreateCudaFunctionNV = nullptr;
    DestroyCudaModuleNV = nullptr;
    DestroyCudaFunctionNV = nullptr;
    CmdCudaLaunchKernelNV = nullptr;
#endif  // VK_ENABLE_BETA_EXTENSIONS
    CmdDispatchTileQCOM = nullptr;
    CmdBeginPerTileExecutionQCOM = nullptr;
    CmdEndPerTileExecutionQCOM = nullptr;
#ifdef VK_USE_PLATFORM_METAL_EXT
    ExportMetalObjectsEXT = nullptr;
#endif  // VK_USE_PLATFORM_METAL_EXT
    GetDescriptorSetLayoutSizeEXT = nullptr;
    GetDescriptorSetLayoutBindingOffsetEXT = nullptr;
    GetDescriptorEXT = nullptr;
    CmdBindDescriptorBuffersEXT = nullptr;
    CmdSetDescriptorBufferOffsetsEXT = nullptr;
    CmdBindDescriptorBufferEmbeddedSamplersEXT = nullptr;
    GetBufferOpaqueCaptureDescriptorDataEXT = nullptr;
    GetImageOpaqueCaptureDescriptorDataEXT = nullptr;
    GetImageViewOpaqueCaptureDescriptorDataEXT = nullptr;
    GetSamplerOpaqueCaptureDescriptorDataEXT = nullptr;
    GetAccelerationStructureOpaqueCaptureDescriptorDataEXT = nullptr;
    CmdSetFragmentShadingRateEnumNV = nullptr;
    GetDeviceFaultInfoEXT = nullptr;
#ifdef VK_USE_PLATFORM_WIN32_KHR
    AcquireWinrtDisplayNV = nullptr;
    GetWinrtDisplayNV = nullptr;
#endif  // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    CreateDirectFBSurfaceEXT = nullptr;
    GetPhysicalDeviceDirectFBPresentationSupportEXT = nullptr;
#endif  // VK_USE_PLATFORM_DIRECTFB_EXT
    CmdSetVertexInputEXT = nullptr;
#ifdef VK_USE_PLATFORM_FUCHSIA
    GetMemoryZirconHandleFUCHSIA = nullptr;
    GetMemoryZirconHandlePropertiesFUCHSIA = nullptr;
    ImportSemaphoreZirconHandleFUCHSIA = nullptr;
    GetSemaphoreZirconHandleFUCHSIA = nullptr;
    CreateBufferCollectionFUCHSIA = nullptr;
    SetBufferCollectionImageConstraintsFUCHSIA = nullptr;
    SetBufferCollectionBufferConstraintsFUCHSIA = nullptr;
    DestroyBufferCollectionFUCHSIA = nullptr;
    GetBufferCollectionPropertiesFUCHSIA = nullptr;
#endif  // VK_USE_PLATFORM_FUCHSIA
    GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI = nullptr;
    CmdSubpassShadingHUAWEI = nullptr;
    CmdBindInvocationMaskHUAWEI = nullptr;
    GetMemoryRemoteAddressNV = nullptr;
    GetPipelinePropertiesEXT = nullptr;
    CmdSetPatchControlPointsEXT = nullptr;
    CmdSetRasterizerDiscardEnableEXT = nullptr;
    CmdSetDepthBiasEnableEXT = nullptr;
    CmdSetLogicOpEXT = nullptr;
    CmdSetPrimitiveRestartEnableEXT = nullptr;
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    CreateScreenSurfaceQNX = nullptr;
    GetPhysicalDeviceScreenPresentationSupportQNX = nullptr;
#endif  // VK_USE_PLATFORM_SCREEN_QNX
    CmdSetColorWriteEnableEXT = nullptr;
    CmdDrawMultiEXT = nullptr;
    CmdDrawMultiIndexedEXT = nullptr;
    CreateMicromapEXT = nullptr;
    DestroyMicromapEXT = nullptr;
    CmdBuildMicromapsEXT = nullptr;
    BuildMicromapsEXT = nullptr;
    CopyMicromapEXT = nullptr;
    CopyMicromapToMemoryEXT = nullptr;
    CopyMemoryToMicromapEXT = nullptr;
    WriteMicromapsPropertiesEXT = nullptr;
    CmdCopyMicromapEXT = nullptr;
    CmdCopyMicromapToMemoryEXT = nullptr;
    CmdCopyMemoryToMicromapEXT = nullptr;
    CmdWriteMicromapsPropertiesEXT = nullptr;
    GetDeviceMicromapCompatibilityEXT = nullptr;
    GetMicromapBuildSizesEXT = nullptr;
    CmdDrawClusterHUAWEI = nullptr;
    CmdDrawClusterIndirectHUAWEI = nullptr;
    SetDeviceMemoryPriorityEXT = nullptr;
    GetDescriptorSetLayoutHostMappingInfoVALVE = nullptr;
    GetDescriptorSetHostMappingVALVE = nullptr;
    CmdCopyMemoryIndirectNV = nullptr;
    CmdCopyMemoryToImageIndirectNV = nullptr;
    CmdDecompressMemoryNV = nullptr;
    CmdDecompressMemoryIndirectCountNV = nullptr;
    GetPipelineIndirectMemoryRequirementsNV = nullptr;
    CmdUpdatePipelineIndirectBufferNV = nullptr;
    GetPipelineIndirectDeviceAddressNV = nullptr;
#ifdef VK_USE_PLATFORM_OHOS
    GetNativeBufferPropertiesOHOS = nullptr;
    GetMemoryNativeBufferOHOS = nullptr;
#endif  // VK_USE_PLATFORM_OHOS
    CmdSetDepthClampEnableEXT = nullptr;
    CmdSetPolygonModeEXT = nullptr;
    CmdSetRasterizationSamplesEXT = nullptr;
    CmdSetSampleMaskEXT = nullptr;
    CmdSetAlphaToCoverageEnableEXT = nullptr;
    CmdSetAlphaToOneEnableEXT = nullptr;
    CmdSetLogicOpEnableEXT = nullptr;
    CmdSetColorBlendEnableEXT = nullptr;
    CmdSetColorBlendEquationEXT = nullptr;
    CmdSetColorWriteMaskEXT = nullptr;
    CmdSetTessellationDomainOriginEXT = nullptr;
    CmdSetRasterizationStreamEXT = nullptr;
    CmdSetConservativeRasterizationModeEXT = nullptr;
    CmdSetExtraPrimitiveOverestimationSizeEXT = nullptr;
    CmdSetDepthClipEnableEXT = nullptr;
    CmdSetSampleLocationsEnableEXT = nullptr;
    CmdSetColorBlendAdvancedEXT = nullptr;
    CmdSetProvokingVertexModeEXT = nullptr;
    CmdSetLineRasterizationModeEXT = nullptr;
    CmdSetLineStippleEnableEXT = nullptr;
    CmdSetDepthClipNegativeOneToOneEXT = nullptr;
    CmdSetViewportWScalingEnableNV = nullptr;
    CmdSetViewportSwizzleNV = nullptr;
    CmdSetCoverageToColorEnableNV = nullptr;
    CmdSetCoverageToColorLocationNV = nullptr;
    CmdSetCoverageModulationModeNV = nullptr;
    CmdSetCoverageModulationTableEnableNV = nullptr;
    CmdSetCoverageModulationTableNV = nullptr;
    CmdSetShadingRateImageEnableNV = nullptr;
    CmdSetRepresentativeFragmentTestEnableNV = nullptr;
    CmdSetCoverageReductionModeNV = nullptr;
    CreateTensorARM = nullptr;
    DestroyTensorARM = nullptr;
    CreateTensorViewARM = nullptr;
    DestroyTensorViewARM = nullptr;
    GetTensorMemoryRequirementsARM = nullptr;
    BindTensorMemoryARM = nullptr;
    GetDeviceTensorMemoryRequirementsARM = nullptr;
    CmdCopyTensorARM = nullptr;
    GetPhysicalDeviceExternalTensorPropertiesARM = nullptr;
    GetTensorOpaqueCaptureDescriptorDataARM = nullptr;
    GetTensorViewOpaqueCaptureDescriptorDataARM = nullptr;
    GetShaderModuleIdentifierEXT = nullptr;
    GetShaderModuleCreateInfoIdentifierEXT = nullptr;
    GetPhysicalDeviceOpticalFlowImageFormatsNV = nullptr;
    CreateOpticalFlowSessionNV = nullptr;
    DestroyOpticalFlowSessionNV = nullptr;
    BindOpticalFlowSessionImageNV = nullptr;
    CmdOpticalFlowExecuteNV = nullptr;
    AntiLagUpdateAMD = nullptr;
    CreateShadersEXT = nullptr;
    DestroyShaderEXT = nullptr;
    GetShaderBinaryDataEXT = nullptr;
    CmdBindShadersEXT = nullptr;
    CmdSetDepthClampRangeEXT = nullptr;
    GetFramebufferTilePropertiesQCOM = nullptr;
    GetDynamicRenderingTilePropertiesQCOM = nullptr;
    GetPhysicalDeviceCooperativeVectorPropertiesNV = nullptr;
    ConvertCooperativeVectorMatrixNV = nullptr;
    CmdConvertCooperativeVectorMatrixNV = nullptr;
    SetLatencySleepModeNV = nullptr;
    LatencySleepNV = nullptr;
    SetLatencyMarkerNV = nullptr;
    GetLatencyTimingsNV = nullptr;
    QueueNotifyOutOfBandNV = nullptr;
    CreateDataGraphPipelinesARM = nullptr;
    CreateDataGraphPipelineSessionARM = nullptr;
    GetDataGraphPipelineSessionBindPointRequirementsARM = nullptr;
    GetDataGraphPipelineSessionMemoryRequirementsARM = nullptr;
    BindDataGraphPipelineSessionMemoryARM = nullptr;
    DestroyDataGraphPipelineSessionARM = nullptr;
    CmdDispatchDataGraphARM = nullptr;
    GetDataGraphPipelineAvailablePropertiesARM = nullptr;
    GetDataGraphPipelinePropertiesARM = nullptr;
    GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM = nullptr;
    GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM = nullptr;
    CmdSetAttachmentFeedbackLoopEnableEXT = nullptr;
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    GetScreenBufferPropertiesQNX = nullptr;
#endif  // VK_USE_PLATFORM_SCREEN_QNX
    CmdBindTileMemoryQCOM = nullptr;
    CmdDecompressMemoryEXT = nullptr;
    CmdDecompressMemoryIndirectCountEXT = nullptr;
    CreateExternalComputeQueueNV = nullptr;
    DestroyExternalComputeQueueNV = nullptr;
    GetExternalComputeQueueDataNV = nullptr;
    GetClusterAccelerationStructureBuildSizesNV = nullptr;
    CmdBuildClusterAccelerationStructureIndirectNV = nullptr;
    GetPartitionedAccelerationStructuresBuildSizesNV = nullptr;
    CmdBuildPartitionedAccelerationStructuresNV = nullptr;
    GetGeneratedCommandsMemoryRequirementsEXT = nullptr;
    CmdPreprocessGeneratedCommandsEXT = nullptr;
    CmdExecuteGeneratedCommandsEXT = nullptr;
    CreateIndirectCommandsLayoutEXT = nullptr;
    DestroyIndirectCommandsLayoutEXT = nullptr;
    CreateIndirectExecutionSetEXT = nullptr;
    DestroyIndirectExecutionSetEXT = nullptr;
    UpdateIndirectExecutionSetPipelineEXT = nullptr;
    UpdateIndirectExecutionSetShaderEXT = nullptr;
#ifdef VK_USE_PLATFORM_OHOS
    CreateSurfaceOHOS = nullptr;
    GetSwapchainGrallocUsageOHOS = nullptr;
    AcquireImageOHOS = nullptr;
    QueueSignalReleaseImageOHOS = nullptr;
#endif  // VK_USE_PLATFORM_OHOS
    GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV = nullptr;
#ifdef VK_USE_PLATFORM_METAL_EXT
    GetMemoryMetalHandleEXT = nullptr;
    GetMemoryMetalHandlePropertiesEXT = nullptr;
#endif  // VK_USE_PLATFORM_METAL_EXT
    EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM = nullptr;
    CmdEndRendering2EXT = nullptr;
    CmdBeginCustomResolveEXT = nullptr;
    CreateAccelerationStructureKHR = nullptr;
    DestroyAccelerationStructureKHR = nullptr;
    CmdBuildAccelerationStructuresKHR = nullptr;
    CmdBuildAccelerationStructuresIndirectKHR = nullptr;
    BuildAccelerationStructuresKHR = nullptr;
    CopyAccelerationStructureKHR = nullptr;
    CopyAccelerationStructureToMemoryKHR = nullptr;
    CopyMemoryToAccelerationStructureKHR = nullptr;
    WriteAccelerationStructuresPropertiesKHR = nullptr;
    CmdCopyAccelerationStructureKHR = nullptr;
    CmdCopyAccelerationStructureToMemoryKHR = nullptr;
    CmdCopyMemoryToAccelerationStructureKHR = nullptr;
    GetAccelerationStructureDeviceAddressKHR = nullptr;
    CmdWriteAccelerationStructuresPropertiesKHR = nullptr;
    GetDeviceAccelerationStructureCompatibilityKHR = nullptr;
    GetAccelerationStructureBuildSizesKHR = nullptr;
    CmdTraceRaysKHR = nullptr;
    CreateRayTracingPipelinesKHR = nullptr;
    GetRayTracingCaptureReplayShaderGroupHandlesKHR = nullptr;
    CmdTraceRaysIndirectKHR = nullptr;
    GetRayTracingShaderGroupStackSizeKHR = nullptr;
    CmdSetRayTracingPipelineStackSizeKHR = nullptr;
    CmdDrawMeshTasksEXT = nullptr;
    CmdDrawMeshTasksIndirectEXT = nullptr;
    CmdDrawMeshTasksIndirectCountEXT = nullptr;
}
} // namespace vk
// clang-format on
// NOLINTEND
