/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_PIPELINE_H
#define VN_PROTOCOL_RENDERER_PIPELINE_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#if !defined(__clang__) && defined(__GNUC__) && __GNUC__ >= 12
#pragma GCC diagnostic ignored "-Wdangling-pointer"
#endif
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/* struct VkSpecializationMapEntry */

static inline void
vn_decode_VkSpecializationMapEntry_temp(struct vn_cs_decoder *dec, VkSpecializationMapEntry *val)
{
    vn_decode_uint32_t(dec, &val->constantID);
    vn_decode_uint32_t(dec, &val->offset);
    vn_decode_size_t(dec, &val->size);
}

static inline void
vn_replace_VkSpecializationMapEntry_handle(VkSpecializationMapEntry *val)
{
    /* skip val->constantID */
    /* skip val->offset */
    /* skip val->size */
}

/* struct VkSpecializationInfo */

static inline void
vn_decode_VkSpecializationInfo_temp(struct vn_cs_decoder *dec, VkSpecializationInfo *val)
{
    vn_decode_uint32_t(dec, &val->mapEntryCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->mapEntryCount);
        val->pMapEntries = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pMapEntries), iter_count);
        if (!val->pMapEntries) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSpecializationMapEntry_temp(dec, &((VkSpecializationMapEntry *)val->pMapEntries)[i]);
    } else {
        vn_decode_array_size(dec, val->mapEntryCount);
        val->pMapEntries = NULL;
    }
    vn_decode_size_t(dec, &val->dataSize);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->dataSize);
        val->pData = vn_cs_decoder_get_blob_storage(dec, array_size);
        if (!val->pData) return;
        vn_decode_blob_array(dec, (void *)val->pData, array_size);
    } else {
        vn_decode_array_size(dec, val->dataSize);
        val->pData = NULL;
    }
}

static inline void
vn_replace_VkSpecializationInfo_handle(VkSpecializationInfo *val)
{
    /* skip val->mapEntryCount */
    if (val->pMapEntries) {
       for (uint32_t i = 0; i < val->mapEntryCount; i++)
            vn_replace_VkSpecializationMapEntry_handle(&((VkSpecializationMapEntry *)val->pMapEntries)[i]);
    }
    /* skip val->dataSize */
    /* skip val->pData */
}

/* struct VkPipelineShaderStageRequiredSubgroupSizeCreateInfo chain */

static inline void *
vn_decode_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineShaderStageRequiredSubgroupSizeCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->requiredSubgroupSize);
}

static inline void
vn_decode_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineShaderStageRequiredSubgroupSizeCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_handle_self(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->requiredSubgroupSize */
}

static inline void
vn_replace_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_handle(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
            vn_replace_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_handle_self((VkPipelineShaderStageRequiredSubgroupSizeCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineShaderStageCreateInfo chain */

static inline void *
vn_decode_VkPipelineShaderStageCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkShaderModuleCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineShaderStageCreateInfo_pnext_temp(dec);
            vn_decode_VkShaderModuleCreateInfo_self_temp(dec, (VkShaderModuleCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineShaderStageCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_self_temp(dec, (VkPipelineShaderStageRequiredSubgroupSizeCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPipelineShaderStageCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineShaderStageCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkShaderStageFlagBits(dec, &val->stage);
    vn_decode_VkShaderModule_lookup(dec, &val->module);
    if (vn_peek_array_size(dec)) {
        const size_t string_size = vn_decode_array_size_unchecked(dec);
        val->pName = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pName), string_size);
        if (!val->pName) return;
        vn_decode_char_array(dec, (char *)val->pName, string_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pName = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pSpecializationInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSpecializationInfo));
        if (!val->pSpecializationInfo) return;
        vn_decode_VkSpecializationInfo_temp(dec, (VkSpecializationInfo *)val->pSpecializationInfo);
    } else {
        val->pSpecializationInfo = NULL;
    }
}

static inline void
vn_decode_VkPipelineShaderStageCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineShaderStageCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineShaderStageCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineShaderStageCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineShaderStageCreateInfo_handle_self(VkPipelineShaderStageCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->stage */
    vn_replace_VkShaderModule_handle(&val->module);
    /* skip val->pName */
    if (val->pSpecializationInfo)
        vn_replace_VkSpecializationInfo_handle((VkSpecializationInfo *)val->pSpecializationInfo);
}

static inline void
vn_replace_VkPipelineShaderStageCreateInfo_handle(VkPipelineShaderStageCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO:
            vn_replace_VkPipelineShaderStageCreateInfo_handle_self((VkPipelineShaderStageCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
            vn_replace_VkShaderModuleCreateInfo_handle_self((VkShaderModuleCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
            vn_replace_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo_handle_self((VkPipelineShaderStageRequiredSubgroupSizeCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkVertexInputBindingDescription */

static inline void
vn_decode_VkVertexInputBindingDescription_temp(struct vn_cs_decoder *dec, VkVertexInputBindingDescription *val)
{
    vn_decode_uint32_t(dec, &val->binding);
    vn_decode_uint32_t(dec, &val->stride);
    vn_decode_VkVertexInputRate(dec, &val->inputRate);
}

static inline void
vn_replace_VkVertexInputBindingDescription_handle(VkVertexInputBindingDescription *val)
{
    /* skip val->binding */
    /* skip val->stride */
    /* skip val->inputRate */
}

/* struct VkVertexInputAttributeDescription */

static inline void
vn_decode_VkVertexInputAttributeDescription_temp(struct vn_cs_decoder *dec, VkVertexInputAttributeDescription *val)
{
    vn_decode_uint32_t(dec, &val->location);
    vn_decode_uint32_t(dec, &val->binding);
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_uint32_t(dec, &val->offset);
}

static inline void
vn_replace_VkVertexInputAttributeDescription_handle(VkVertexInputAttributeDescription *val)
{
    /* skip val->location */
    /* skip val->binding */
    /* skip val->format */
    /* skip val->offset */
}

/* struct VkVertexInputBindingDivisorDescriptionEXT */

static inline void
vn_decode_VkVertexInputBindingDivisorDescriptionEXT_temp(struct vn_cs_decoder *dec, VkVertexInputBindingDivisorDescriptionEXT *val)
{
    vn_decode_uint32_t(dec, &val->binding);
    vn_decode_uint32_t(dec, &val->divisor);
}

static inline void
vn_replace_VkVertexInputBindingDivisorDescriptionEXT_handle(VkVertexInputBindingDivisorDescriptionEXT *val)
{
    /* skip val->binding */
    /* skip val->divisor */
}

/* struct VkPipelineVertexInputDivisorStateCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineVertexInputDivisorStateCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineVertexInputDivisorStateCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineVertexInputDivisorStateCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->vertexBindingDivisorCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->vertexBindingDivisorCount);
        val->pVertexBindingDivisors = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pVertexBindingDivisors), iter_count);
        if (!val->pVertexBindingDivisors) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkVertexInputBindingDivisorDescriptionEXT_temp(dec, &((VkVertexInputBindingDivisorDescriptionEXT *)val->pVertexBindingDivisors)[i]);
    } else {
        vn_decode_array_size(dec, val->vertexBindingDivisorCount);
        val->pVertexBindingDivisors = NULL;
    }
}

static inline void
vn_decode_VkPipelineVertexInputDivisorStateCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineVertexInputDivisorStateCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineVertexInputDivisorStateCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineVertexInputDivisorStateCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineVertexInputDivisorStateCreateInfoEXT_handle_self(VkPipelineVertexInputDivisorStateCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->vertexBindingDivisorCount */
    if (val->pVertexBindingDivisors) {
       for (uint32_t i = 0; i < val->vertexBindingDivisorCount; i++)
            vn_replace_VkVertexInputBindingDivisorDescriptionEXT_handle(&((VkVertexInputBindingDivisorDescriptionEXT *)val->pVertexBindingDivisors)[i]);
    }
}

static inline void
vn_replace_VkPipelineVertexInputDivisorStateCreateInfoEXT_handle(VkPipelineVertexInputDivisorStateCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineVertexInputDivisorStateCreateInfoEXT_handle_self((VkPipelineVertexInputDivisorStateCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineVertexInputStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineVertexInputStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineVertexInputDivisorStateCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineVertexInputStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineVertexInputDivisorStateCreateInfoEXT_self_temp(dec, (VkPipelineVertexInputDivisorStateCreateInfoEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPipelineVertexInputStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineVertexInputStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->vertexBindingDescriptionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->vertexBindingDescriptionCount);
        val->pVertexBindingDescriptions = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pVertexBindingDescriptions), iter_count);
        if (!val->pVertexBindingDescriptions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkVertexInputBindingDescription_temp(dec, &((VkVertexInputBindingDescription *)val->pVertexBindingDescriptions)[i]);
    } else {
        vn_decode_array_size(dec, val->vertexBindingDescriptionCount);
        val->pVertexBindingDescriptions = NULL;
    }
    vn_decode_uint32_t(dec, &val->vertexAttributeDescriptionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->vertexAttributeDescriptionCount);
        val->pVertexAttributeDescriptions = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pVertexAttributeDescriptions), iter_count);
        if (!val->pVertexAttributeDescriptions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkVertexInputAttributeDescription_temp(dec, &((VkVertexInputAttributeDescription *)val->pVertexAttributeDescriptions)[i]);
    } else {
        vn_decode_array_size(dec, val->vertexAttributeDescriptionCount);
        val->pVertexAttributeDescriptions = NULL;
    }
}

static inline void
vn_decode_VkPipelineVertexInputStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineVertexInputStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineVertexInputStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineVertexInputStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineVertexInputStateCreateInfo_handle_self(VkPipelineVertexInputStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->vertexBindingDescriptionCount */
    if (val->pVertexBindingDescriptions) {
       for (uint32_t i = 0; i < val->vertexBindingDescriptionCount; i++)
            vn_replace_VkVertexInputBindingDescription_handle(&((VkVertexInputBindingDescription *)val->pVertexBindingDescriptions)[i]);
    }
    /* skip val->vertexAttributeDescriptionCount */
    if (val->pVertexAttributeDescriptions) {
       for (uint32_t i = 0; i < val->vertexAttributeDescriptionCount; i++)
            vn_replace_VkVertexInputAttributeDescription_handle(&((VkVertexInputAttributeDescription *)val->pVertexAttributeDescriptions)[i]);
    }
}

static inline void
vn_replace_VkPipelineVertexInputStateCreateInfo_handle(VkPipelineVertexInputStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO:
            vn_replace_VkPipelineVertexInputStateCreateInfo_handle_self((VkPipelineVertexInputStateCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineVertexInputDivisorStateCreateInfoEXT_handle_self((VkPipelineVertexInputDivisorStateCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineInputAssemblyStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineInputAssemblyStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineInputAssemblyStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineInputAssemblyStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkPrimitiveTopology(dec, &val->topology);
    vn_decode_VkBool32(dec, &val->primitiveRestartEnable);
}

static inline void
vn_decode_VkPipelineInputAssemblyStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineInputAssemblyStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineInputAssemblyStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineInputAssemblyStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineInputAssemblyStateCreateInfo_handle_self(VkPipelineInputAssemblyStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->topology */
    /* skip val->primitiveRestartEnable */
}

static inline void
vn_replace_VkPipelineInputAssemblyStateCreateInfo_handle(VkPipelineInputAssemblyStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO:
            vn_replace_VkPipelineInputAssemblyStateCreateInfo_handle_self((VkPipelineInputAssemblyStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineTessellationDomainOriginStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkTessellationDomainOrigin(dec, &val->domainOrigin);
}

static inline void
vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineTessellationDomainOriginStateCreateInfo_handle_self(VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->domainOrigin */
}

static inline void
vn_replace_VkPipelineTessellationDomainOriginStateCreateInfo_handle(VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
            vn_replace_VkPipelineTessellationDomainOriginStateCreateInfo_handle_self((VkPipelineTessellationDomainOriginStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineTessellationStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineTessellationStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineTessellationDomainOriginStateCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineTessellationStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_self_temp(dec, (VkPipelineTessellationDomainOriginStateCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPipelineTessellationStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineTessellationStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->patchControlPoints);
}

static inline void
vn_decode_VkPipelineTessellationStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineTessellationStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineTessellationStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineTessellationStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineTessellationStateCreateInfo_handle_self(VkPipelineTessellationStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->patchControlPoints */
}

static inline void
vn_replace_VkPipelineTessellationStateCreateInfo_handle(VkPipelineTessellationStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO:
            vn_replace_VkPipelineTessellationStateCreateInfo_handle_self((VkPipelineTessellationStateCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
            vn_replace_VkPipelineTessellationDomainOriginStateCreateInfo_handle_self((VkPipelineTessellationDomainOriginStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineViewportDepthClipControlCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineViewportDepthClipControlCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineViewportDepthClipControlCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineViewportDepthClipControlCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->negativeOneToOne);
}

static inline void
vn_decode_VkPipelineViewportDepthClipControlCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineViewportDepthClipControlCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineViewportDepthClipControlCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineViewportDepthClipControlCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineViewportDepthClipControlCreateInfoEXT_handle_self(VkPipelineViewportDepthClipControlCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->negativeOneToOne */
}

static inline void
vn_replace_VkPipelineViewportDepthClipControlCreateInfoEXT_handle(VkPipelineViewportDepthClipControlCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT:
            vn_replace_VkPipelineViewportDepthClipControlCreateInfoEXT_handle_self((VkPipelineViewportDepthClipControlCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineViewportStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineViewportStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineViewportDepthClipControlCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineViewportStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineViewportDepthClipControlCreateInfoEXT_self_temp(dec, (VkPipelineViewportDepthClipControlCreateInfoEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPipelineViewportStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineViewportStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->viewportCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->viewportCount);
        val->pViewports = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pViewports), iter_count);
        if (!val->pViewports) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkViewport_temp(dec, &((VkViewport *)val->pViewports)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pViewports = NULL;
    }
    vn_decode_uint32_t(dec, &val->scissorCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->scissorCount);
        val->pScissors = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pScissors), iter_count);
        if (!val->pScissors) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkRect2D_temp(dec, &((VkRect2D *)val->pScissors)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pScissors = NULL;
    }
}

static inline void
vn_decode_VkPipelineViewportStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineViewportStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineViewportStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineViewportStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineViewportStateCreateInfo_handle_self(VkPipelineViewportStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->viewportCount */
    if (val->pViewports) {
       for (uint32_t i = 0; i < val->viewportCount; i++)
            vn_replace_VkViewport_handle(&((VkViewport *)val->pViewports)[i]);
    }
    /* skip val->scissorCount */
    if (val->pScissors) {
       for (uint32_t i = 0; i < val->scissorCount; i++)
            vn_replace_VkRect2D_handle(&((VkRect2D *)val->pScissors)[i]);
    }
}

static inline void
vn_replace_VkPipelineViewportStateCreateInfo_handle(VkPipelineViewportStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO:
            vn_replace_VkPipelineViewportStateCreateInfo_handle_self((VkPipelineViewportStateCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT:
            vn_replace_VkPipelineViewportDepthClipControlCreateInfoEXT_handle_self((VkPipelineViewportDepthClipControlCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRasterizationConservativeStateCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineRasterizationConservativeStateCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineRasterizationConservativeStateCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationConservativeStateCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkConservativeRasterizationModeEXT(dec, &val->conservativeRasterizationMode);
    vn_decode_float(dec, &val->extraPrimitiveOverestimationSize);
}

static inline void
vn_decode_VkPipelineRasterizationConservativeStateCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationConservativeStateCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRasterizationConservativeStateCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineRasterizationConservativeStateCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRasterizationConservativeStateCreateInfoEXT_handle_self(VkPipelineRasterizationConservativeStateCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->conservativeRasterizationMode */
    /* skip val->extraPrimitiveOverestimationSize */
}

static inline void
vn_replace_VkPipelineRasterizationConservativeStateCreateInfoEXT_handle(VkPipelineRasterizationConservativeStateCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationConservativeStateCreateInfoEXT_handle_self((VkPipelineRasterizationConservativeStateCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRasterizationStateStreamCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->rasterizationStream);
}

static inline void
vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRasterizationStateStreamCreateInfoEXT_handle_self(VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->rasterizationStream */
}

static inline void
vn_replace_VkPipelineRasterizationStateStreamCreateInfoEXT_handle(VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationStateStreamCreateInfoEXT_handle_self((VkPipelineRasterizationStateStreamCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRasterizationDepthClipStateCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineRasterizationDepthClipStateCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineRasterizationDepthClipStateCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationDepthClipStateCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkBool32(dec, &val->depthClipEnable);
}

static inline void
vn_decode_VkPipelineRasterizationDepthClipStateCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationDepthClipStateCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRasterizationDepthClipStateCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineRasterizationDepthClipStateCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRasterizationDepthClipStateCreateInfoEXT_handle_self(VkPipelineRasterizationDepthClipStateCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->depthClipEnable */
}

static inline void
vn_replace_VkPipelineRasterizationDepthClipStateCreateInfoEXT_handle(VkPipelineRasterizationDepthClipStateCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationDepthClipStateCreateInfoEXT_handle_self((VkPipelineRasterizationDepthClipStateCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRasterizationLineStateCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineRasterizationLineStateCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineRasterizationLineStateCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationLineStateCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkLineRasterizationModeEXT(dec, &val->lineRasterizationMode);
    vn_decode_VkBool32(dec, &val->stippledLineEnable);
    vn_decode_uint32_t(dec, &val->lineStippleFactor);
    vn_decode_uint16_t(dec, &val->lineStipplePattern);
}

static inline void
vn_decode_VkPipelineRasterizationLineStateCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationLineStateCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRasterizationLineStateCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineRasterizationLineStateCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRasterizationLineStateCreateInfoEXT_handle_self(VkPipelineRasterizationLineStateCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->lineRasterizationMode */
    /* skip val->stippledLineEnable */
    /* skip val->lineStippleFactor */
    /* skip val->lineStipplePattern */
}

static inline void
vn_replace_VkPipelineRasterizationLineStateCreateInfoEXT_handle(VkPipelineRasterizationLineStateCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationLineStateCreateInfoEXT_handle_self((VkPipelineRasterizationLineStateCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRasterizationProvokingVertexStateCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkProvokingVertexModeEXT(dec, &val->provokingVertexMode);
}

static inline void
vn_decode_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_handle_self(VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->provokingVertexMode */
}

static inline void
vn_replace_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_handle(VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_handle_self((VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRasterizationStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineRasterizationConservativeStateCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineRasterizationConservativeStateCreateInfoEXT_self_temp(dec, (VkPipelineRasterizationConservativeStateCreateInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineRasterizationStateStreamCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_self_temp(dec, (VkPipelineRasterizationStateStreamCreateInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineRasterizationDepthClipStateCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineRasterizationDepthClipStateCreateInfoEXT_self_temp(dec, (VkPipelineRasterizationDepthClipStateCreateInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineRasterizationLineStateCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineRasterizationLineStateCreateInfoEXT_self_temp(dec, (VkPipelineRasterizationLineStateCreateInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineRasterizationProvokingVertexStateCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_self_temp(dec, (VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPipelineRasterizationStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkBool32(dec, &val->depthClampEnable);
    vn_decode_VkBool32(dec, &val->rasterizerDiscardEnable);
    vn_decode_VkPolygonMode(dec, &val->polygonMode);
    vn_decode_VkFlags(dec, &val->cullMode);
    vn_decode_VkFrontFace(dec, &val->frontFace);
    vn_decode_VkBool32(dec, &val->depthBiasEnable);
    vn_decode_float(dec, &val->depthBiasConstantFactor);
    vn_decode_float(dec, &val->depthBiasClamp);
    vn_decode_float(dec, &val->depthBiasSlopeFactor);
    vn_decode_float(dec, &val->lineWidth);
}

static inline void
vn_decode_VkPipelineRasterizationStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineRasterizationStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRasterizationStateCreateInfo_handle_self(VkPipelineRasterizationStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->depthClampEnable */
    /* skip val->rasterizerDiscardEnable */
    /* skip val->polygonMode */
    /* skip val->cullMode */
    /* skip val->frontFace */
    /* skip val->depthBiasEnable */
    /* skip val->depthBiasConstantFactor */
    /* skip val->depthBiasClamp */
    /* skip val->depthBiasSlopeFactor */
    /* skip val->lineWidth */
}

static inline void
vn_replace_VkPipelineRasterizationStateCreateInfo_handle(VkPipelineRasterizationStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO:
            vn_replace_VkPipelineRasterizationStateCreateInfo_handle_self((VkPipelineRasterizationStateCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationConservativeStateCreateInfoEXT_handle_self((VkPipelineRasterizationConservativeStateCreateInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationStateStreamCreateInfoEXT_handle_self((VkPipelineRasterizationStateStreamCreateInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationDepthClipStateCreateInfoEXT_handle_self((VkPipelineRasterizationDepthClipStateCreateInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationLineStateCreateInfoEXT_handle_self((VkPipelineRasterizationLineStateCreateInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT_handle_self((VkPipelineRasterizationProvokingVertexStateCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineMultisampleStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineMultisampleStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineMultisampleStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineMultisampleStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkSampleCountFlagBits(dec, &val->rasterizationSamples);
    vn_decode_VkBool32(dec, &val->sampleShadingEnable);
    vn_decode_float(dec, &val->minSampleShading);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, (val->rasterizationSamples + 31) / 32);
        val->pSampleMask = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pSampleMask), array_size);
        if (!val->pSampleMask) return;
        vn_decode_VkSampleMask_array(dec, (VkSampleMask *)val->pSampleMask, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pSampleMask = NULL;
    }
    vn_decode_VkBool32(dec, &val->alphaToCoverageEnable);
    vn_decode_VkBool32(dec, &val->alphaToOneEnable);
}

static inline void
vn_decode_VkPipelineMultisampleStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineMultisampleStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineMultisampleStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineMultisampleStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineMultisampleStateCreateInfo_handle_self(VkPipelineMultisampleStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->rasterizationSamples */
    /* skip val->sampleShadingEnable */
    /* skip val->minSampleShading */
    /* skip val->pSampleMask */
    /* skip val->alphaToCoverageEnable */
    /* skip val->alphaToOneEnable */
}

static inline void
vn_replace_VkPipelineMultisampleStateCreateInfo_handle(VkPipelineMultisampleStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO:
            vn_replace_VkPipelineMultisampleStateCreateInfo_handle_self((VkPipelineMultisampleStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkStencilOpState */

static inline void
vn_decode_VkStencilOpState_temp(struct vn_cs_decoder *dec, VkStencilOpState *val)
{
    vn_decode_VkStencilOp(dec, &val->failOp);
    vn_decode_VkStencilOp(dec, &val->passOp);
    vn_decode_VkStencilOp(dec, &val->depthFailOp);
    vn_decode_VkCompareOp(dec, &val->compareOp);
    vn_decode_uint32_t(dec, &val->compareMask);
    vn_decode_uint32_t(dec, &val->writeMask);
    vn_decode_uint32_t(dec, &val->reference);
}

static inline void
vn_replace_VkStencilOpState_handle(VkStencilOpState *val)
{
    /* skip val->failOp */
    /* skip val->passOp */
    /* skip val->depthFailOp */
    /* skip val->compareOp */
    /* skip val->compareMask */
    /* skip val->writeMask */
    /* skip val->reference */
}

/* struct VkPipelineDepthStencilStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineDepthStencilStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineDepthStencilStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineDepthStencilStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkBool32(dec, &val->depthTestEnable);
    vn_decode_VkBool32(dec, &val->depthWriteEnable);
    vn_decode_VkCompareOp(dec, &val->depthCompareOp);
    vn_decode_VkBool32(dec, &val->depthBoundsTestEnable);
    vn_decode_VkBool32(dec, &val->stencilTestEnable);
    vn_decode_VkStencilOpState_temp(dec, &val->front);
    vn_decode_VkStencilOpState_temp(dec, &val->back);
    vn_decode_float(dec, &val->minDepthBounds);
    vn_decode_float(dec, &val->maxDepthBounds);
}

static inline void
vn_decode_VkPipelineDepthStencilStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineDepthStencilStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineDepthStencilStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineDepthStencilStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineDepthStencilStateCreateInfo_handle_self(VkPipelineDepthStencilStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->depthTestEnable */
    /* skip val->depthWriteEnable */
    /* skip val->depthCompareOp */
    /* skip val->depthBoundsTestEnable */
    /* skip val->stencilTestEnable */
    vn_replace_VkStencilOpState_handle(&val->front);
    vn_replace_VkStencilOpState_handle(&val->back);
    /* skip val->minDepthBounds */
    /* skip val->maxDepthBounds */
}

static inline void
vn_replace_VkPipelineDepthStencilStateCreateInfo_handle(VkPipelineDepthStencilStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO:
            vn_replace_VkPipelineDepthStencilStateCreateInfo_handle_self((VkPipelineDepthStencilStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineColorBlendAttachmentState */

static inline void
vn_decode_VkPipelineColorBlendAttachmentState_temp(struct vn_cs_decoder *dec, VkPipelineColorBlendAttachmentState *val)
{
    vn_decode_VkBool32(dec, &val->blendEnable);
    vn_decode_VkBlendFactor(dec, &val->srcColorBlendFactor);
    vn_decode_VkBlendFactor(dec, &val->dstColorBlendFactor);
    vn_decode_VkBlendOp(dec, &val->colorBlendOp);
    vn_decode_VkBlendFactor(dec, &val->srcAlphaBlendFactor);
    vn_decode_VkBlendFactor(dec, &val->dstAlphaBlendFactor);
    vn_decode_VkBlendOp(dec, &val->alphaBlendOp);
    vn_decode_VkFlags(dec, &val->colorWriteMask);
}

static inline void
vn_replace_VkPipelineColorBlendAttachmentState_handle(VkPipelineColorBlendAttachmentState *val)
{
    /* skip val->blendEnable */
    /* skip val->srcColorBlendFactor */
    /* skip val->dstColorBlendFactor */
    /* skip val->colorBlendOp */
    /* skip val->srcAlphaBlendFactor */
    /* skip val->dstAlphaBlendFactor */
    /* skip val->alphaBlendOp */
    /* skip val->colorWriteMask */
}

/* struct VkPipelineColorWriteCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineColorWriteCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineColorWriteCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineColorWriteCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->attachmentCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->attachmentCount);
        val->pColorWriteEnables = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pColorWriteEnables), array_size);
        if (!val->pColorWriteEnables) return;
        vn_decode_VkBool32_array(dec, (VkBool32 *)val->pColorWriteEnables, array_size);
    } else {
        vn_decode_array_size(dec, val->attachmentCount);
        val->pColorWriteEnables = NULL;
    }
}

static inline void
vn_decode_VkPipelineColorWriteCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineColorWriteCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineColorWriteCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineColorWriteCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineColorWriteCreateInfoEXT_handle_self(VkPipelineColorWriteCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->attachmentCount */
    /* skip val->pColorWriteEnables */
}

static inline void
vn_replace_VkPipelineColorWriteCreateInfoEXT_handle(VkPipelineColorWriteCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
            vn_replace_VkPipelineColorWriteCreateInfoEXT_handle_self((VkPipelineColorWriteCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineColorBlendStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineColorBlendStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineColorWriteCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineColorBlendStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineColorWriteCreateInfoEXT_self_temp(dec, (VkPipelineColorWriteCreateInfoEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPipelineColorBlendStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineColorBlendStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkBool32(dec, &val->logicOpEnable);
    vn_decode_VkLogicOp(dec, &val->logicOp);
    vn_decode_uint32_t(dec, &val->attachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->attachmentCount);
        val->pAttachments = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pAttachments), iter_count);
        if (!val->pAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPipelineColorBlendAttachmentState_temp(dec, &((VkPipelineColorBlendAttachmentState *)val->pAttachments)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pAttachments = NULL;
    }
    {
        const size_t array_size = vn_decode_array_size(dec, 4);
        vn_decode_float_array(dec, val->blendConstants, array_size);
    }
}

static inline void
vn_decode_VkPipelineColorBlendStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineColorBlendStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineColorBlendStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineColorBlendStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineColorBlendStateCreateInfo_handle_self(VkPipelineColorBlendStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->logicOpEnable */
    /* skip val->logicOp */
    /* skip val->attachmentCount */
    if (val->pAttachments) {
       for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_replace_VkPipelineColorBlendAttachmentState_handle(&((VkPipelineColorBlendAttachmentState *)val->pAttachments)[i]);
    }
    /* skip val->blendConstants */
}

static inline void
vn_replace_VkPipelineColorBlendStateCreateInfo_handle(VkPipelineColorBlendStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO:
            vn_replace_VkPipelineColorBlendStateCreateInfo_handle_self((VkPipelineColorBlendStateCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
            vn_replace_VkPipelineColorWriteCreateInfoEXT_handle_self((VkPipelineColorWriteCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineDynamicStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineDynamicStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineDynamicStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineDynamicStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->dynamicStateCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->dynamicStateCount);
        val->pDynamicStates = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pDynamicStates), array_size);
        if (!val->pDynamicStates) return;
        vn_decode_VkDynamicState_array(dec, (VkDynamicState *)val->pDynamicStates, array_size);
    } else {
        vn_decode_array_size(dec, val->dynamicStateCount);
        val->pDynamicStates = NULL;
    }
}

static inline void
vn_decode_VkPipelineDynamicStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineDynamicStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineDynamicStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineDynamicStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineDynamicStateCreateInfo_handle_self(VkPipelineDynamicStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->dynamicStateCount */
    /* skip val->pDynamicStates */
}

static inline void
vn_replace_VkPipelineDynamicStateCreateInfo_handle(VkPipelineDynamicStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO:
            vn_replace_VkPipelineDynamicStateCreateInfo_handle_self((VkPipelineDynamicStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineCreateFlags2CreateInfoKHR chain */

static inline void *
vn_decode_VkPipelineCreateFlags2CreateInfoKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineCreateFlags2CreateInfoKHR_self_temp(struct vn_cs_decoder *dec, VkPipelineCreateFlags2CreateInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags64(dec, &val->flags);
}

static inline void
vn_decode_VkPipelineCreateFlags2CreateInfoKHR_temp(struct vn_cs_decoder *dec, VkPipelineCreateFlags2CreateInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineCreateFlags2CreateInfoKHR_pnext_temp(dec);
    vn_decode_VkPipelineCreateFlags2CreateInfoKHR_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineCreateFlags2CreateInfoKHR_handle_self(VkPipelineCreateFlags2CreateInfoKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
}

static inline void
vn_replace_VkPipelineCreateFlags2CreateInfoKHR_handle(VkPipelineCreateFlags2CreateInfoKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR:
            vn_replace_VkPipelineCreateFlags2CreateInfoKHR_handle_self((VkPipelineCreateFlags2CreateInfoKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineLibraryCreateInfoKHR chain */

static inline void *
vn_decode_VkPipelineLibraryCreateInfoKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineLibraryCreateInfoKHR_self_temp(struct vn_cs_decoder *dec, VkPipelineLibraryCreateInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->libraryCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->libraryCount);
        val->pLibraries = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pLibraries), iter_count);
        if (!val->pLibraries) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPipeline_lookup(dec, &((VkPipeline *)val->pLibraries)[i]);
    } else {
        vn_decode_array_size(dec, val->libraryCount);
        val->pLibraries = NULL;
    }
}

static inline void
vn_decode_VkPipelineLibraryCreateInfoKHR_temp(struct vn_cs_decoder *dec, VkPipelineLibraryCreateInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineLibraryCreateInfoKHR_pnext_temp(dec);
    vn_decode_VkPipelineLibraryCreateInfoKHR_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineLibraryCreateInfoKHR_handle_self(VkPipelineLibraryCreateInfoKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->libraryCount */
    if (val->pLibraries) {
       for (uint32_t i = 0; i < val->libraryCount; i++)
            vn_replace_VkPipeline_handle(&((VkPipeline *)val->pLibraries)[i]);
    }
}

static inline void
vn_replace_VkPipelineLibraryCreateInfoKHR_handle(VkPipelineLibraryCreateInfoKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR:
            vn_replace_VkPipelineLibraryCreateInfoKHR_handle_self((VkPipelineLibraryCreateInfoKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineCreationFeedback */

static inline void
vn_decode_VkPipelineCreationFeedback_temp(struct vn_cs_decoder *dec, VkPipelineCreationFeedback *val)
{
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint64_t(dec, &val->duration);
}

static inline void
vn_replace_VkPipelineCreationFeedback_handle(VkPipelineCreationFeedback *val)
{
    /* skip val->flags */
    /* skip val->duration */
}

/* struct VkPipelineCreationFeedbackCreateInfo chain */

static inline void *
vn_decode_VkPipelineCreationFeedbackCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineCreationFeedbackCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineCreationFeedbackCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    if (vn_decode_simple_pointer(dec)) {
        val->pPipelineCreationFeedback = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pPipelineCreationFeedback));
        if (!val->pPipelineCreationFeedback) return;
        vn_decode_VkPipelineCreationFeedback_temp(dec, val->pPipelineCreationFeedback);
    } else {
        val->pPipelineCreationFeedback = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    vn_decode_uint32_t(dec, &val->pipelineStageCreationFeedbackCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->pipelineStageCreationFeedbackCount);
        val->pPipelineStageCreationFeedbacks = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pPipelineStageCreationFeedbacks), iter_count);
        if (!val->pPipelineStageCreationFeedbacks) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPipelineCreationFeedback_temp(dec, &val->pPipelineStageCreationFeedbacks[i]);
    } else {
        vn_decode_array_size(dec, val->pipelineStageCreationFeedbackCount);
        val->pPipelineStageCreationFeedbacks = NULL;
    }
}

static inline void
vn_decode_VkPipelineCreationFeedbackCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineCreationFeedbackCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineCreationFeedbackCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineCreationFeedbackCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineCreationFeedbackCreateInfo_handle_self(VkPipelineCreationFeedbackCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    if (val->pPipelineCreationFeedback)
        vn_replace_VkPipelineCreationFeedback_handle(val->pPipelineCreationFeedback);
    /* skip val->pipelineStageCreationFeedbackCount */
    if (val->pPipelineStageCreationFeedbacks) {
       for (uint32_t i = 0; i < val->pipelineStageCreationFeedbackCount; i++)
            vn_replace_VkPipelineCreationFeedback_handle(&val->pPipelineStageCreationFeedbacks[i]);
    }
}

static inline void
vn_replace_VkPipelineCreationFeedbackCreateInfo_handle(VkPipelineCreationFeedbackCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
            vn_replace_VkPipelineCreationFeedbackCreateInfo_handle_self((VkPipelineCreationFeedbackCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineFragmentShadingRateStateCreateInfoKHR chain */

static inline void *
vn_decode_VkPipelineFragmentShadingRateStateCreateInfoKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineFragmentShadingRateStateCreateInfoKHR_self_temp(struct vn_cs_decoder *dec, VkPipelineFragmentShadingRateStateCreateInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExtent2D_temp(dec, &val->fragmentSize);
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_VkFragmentShadingRateCombinerOpKHR_array(dec, val->combinerOps, array_size);
    }
}

static inline void
vn_decode_VkPipelineFragmentShadingRateStateCreateInfoKHR_temp(struct vn_cs_decoder *dec, VkPipelineFragmentShadingRateStateCreateInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineFragmentShadingRateStateCreateInfoKHR_pnext_temp(dec);
    vn_decode_VkPipelineFragmentShadingRateStateCreateInfoKHR_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineFragmentShadingRateStateCreateInfoKHR_handle_self(VkPipelineFragmentShadingRateStateCreateInfoKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkExtent2D_handle(&val->fragmentSize);
    /* skip val->combinerOps */
}

static inline void
vn_replace_VkPipelineFragmentShadingRateStateCreateInfoKHR_handle(VkPipelineFragmentShadingRateStateCreateInfoKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR:
            vn_replace_VkPipelineFragmentShadingRateStateCreateInfoKHR_handle_self((VkPipelineFragmentShadingRateStateCreateInfoKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRenderingCreateInfo chain */

static inline void *
vn_decode_VkPipelineRenderingCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineRenderingCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineRenderingCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->viewMask);
    vn_decode_uint32_t(dec, &val->colorAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachmentFormats = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pColorAttachmentFormats), array_size);
        if (!val->pColorAttachmentFormats) return;
        vn_decode_VkFormat_array(dec, (VkFormat *)val->pColorAttachmentFormats, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pColorAttachmentFormats = NULL;
    }
    vn_decode_VkFormat(dec, &val->depthAttachmentFormat);
    vn_decode_VkFormat(dec, &val->stencilAttachmentFormat);
}

static inline void
vn_decode_VkPipelineRenderingCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineRenderingCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRenderingCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineRenderingCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRenderingCreateInfo_handle_self(VkPipelineRenderingCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->viewMask */
    /* skip val->colorAttachmentCount */
    /* skip val->pColorAttachmentFormats */
    /* skip val->depthAttachmentFormat */
    /* skip val->stencilAttachmentFormat */
}

static inline void
vn_replace_VkPipelineRenderingCreateInfo_handle(VkPipelineRenderingCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
            vn_replace_VkPipelineRenderingCreateInfo_handle_self((VkPipelineRenderingCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkGraphicsPipelineLibraryCreateInfoEXT chain */

static inline void *
vn_decode_VkGraphicsPipelineLibraryCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkGraphicsPipelineLibraryCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkGraphicsPipelineLibraryCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
}

static inline void
vn_decode_VkGraphicsPipelineLibraryCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkGraphicsPipelineLibraryCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkGraphicsPipelineLibraryCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkGraphicsPipelineLibraryCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkGraphicsPipelineLibraryCreateInfoEXT_handle_self(VkGraphicsPipelineLibraryCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
}

static inline void
vn_replace_VkGraphicsPipelineLibraryCreateInfoEXT_handle(VkGraphicsPipelineLibraryCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
            vn_replace_VkGraphicsPipelineLibraryCreateInfoEXT_handle_self((VkGraphicsPipelineLibraryCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkGraphicsPipelineCreateInfo chain */

static inline void *
vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineCreateFlags2CreateInfoKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineCreateFlags2CreateInfoKHR_self_temp(dec, (VkPipelineCreateFlags2CreateInfoKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineLibraryCreateInfoKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineLibraryCreateInfoKHR_self_temp(dec, (VkPipelineLibraryCreateInfoKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineCreationFeedbackCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineCreationFeedbackCreateInfo_self_temp(dec, (VkPipelineCreationFeedbackCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineFragmentShadingRateStateCreateInfoKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineFragmentShadingRateStateCreateInfoKHR_self_temp(dec, (VkPipelineFragmentShadingRateStateCreateInfoKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineRenderingCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineRenderingCreateInfo_self_temp(dec, (VkPipelineRenderingCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkGraphicsPipelineLibraryCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(dec);
            vn_decode_VkGraphicsPipelineLibraryCreateInfoEXT_self_temp(dec, (VkGraphicsPipelineLibraryCreateInfoEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkGraphicsPipelineCreateInfo_self_temp(struct vn_cs_decoder *dec, VkGraphicsPipelineCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->stageCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->stageCount);
        val->pStages = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pStages), iter_count);
        if (!val->pStages) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPipelineShaderStageCreateInfo_temp(dec, &((VkPipelineShaderStageCreateInfo *)val->pStages)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pStages = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pVertexInputState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pVertexInputState));
        if (!val->pVertexInputState) return;
        vn_decode_VkPipelineVertexInputStateCreateInfo_temp(dec, (VkPipelineVertexInputStateCreateInfo *)val->pVertexInputState);
    } else {
        val->pVertexInputState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pInputAssemblyState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pInputAssemblyState));
        if (!val->pInputAssemblyState) return;
        vn_decode_VkPipelineInputAssemblyStateCreateInfo_temp(dec, (VkPipelineInputAssemblyStateCreateInfo *)val->pInputAssemblyState);
    } else {
        val->pInputAssemblyState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pTessellationState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pTessellationState));
        if (!val->pTessellationState) return;
        vn_decode_VkPipelineTessellationStateCreateInfo_temp(dec, (VkPipelineTessellationStateCreateInfo *)val->pTessellationState);
    } else {
        val->pTessellationState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pViewportState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pViewportState));
        if (!val->pViewportState) return;
        vn_decode_VkPipelineViewportStateCreateInfo_temp(dec, (VkPipelineViewportStateCreateInfo *)val->pViewportState);
    } else {
        val->pViewportState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pRasterizationState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pRasterizationState));
        if (!val->pRasterizationState) return;
        vn_decode_VkPipelineRasterizationStateCreateInfo_temp(dec, (VkPipelineRasterizationStateCreateInfo *)val->pRasterizationState);
    } else {
        val->pRasterizationState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pMultisampleState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pMultisampleState));
        if (!val->pMultisampleState) return;
        vn_decode_VkPipelineMultisampleStateCreateInfo_temp(dec, (VkPipelineMultisampleStateCreateInfo *)val->pMultisampleState);
    } else {
        val->pMultisampleState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pDepthStencilState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDepthStencilState));
        if (!val->pDepthStencilState) return;
        vn_decode_VkPipelineDepthStencilStateCreateInfo_temp(dec, (VkPipelineDepthStencilStateCreateInfo *)val->pDepthStencilState);
    } else {
        val->pDepthStencilState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pColorBlendState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pColorBlendState));
        if (!val->pColorBlendState) return;
        vn_decode_VkPipelineColorBlendStateCreateInfo_temp(dec, (VkPipelineColorBlendStateCreateInfo *)val->pColorBlendState);
    } else {
        val->pColorBlendState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pDynamicState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDynamicState));
        if (!val->pDynamicState) return;
        vn_decode_VkPipelineDynamicStateCreateInfo_temp(dec, (VkPipelineDynamicStateCreateInfo *)val->pDynamicState);
    } else {
        val->pDynamicState = NULL;
    }
    vn_decode_VkPipelineLayout_lookup(dec, &val->layout);
    vn_decode_VkRenderPass_lookup(dec, &val->renderPass);
    vn_decode_uint32_t(dec, &val->subpass);
    vn_decode_VkPipeline_lookup(dec, &val->basePipelineHandle);
    vn_decode_int32_t(dec, &val->basePipelineIndex);
}

static inline void
vn_decode_VkGraphicsPipelineCreateInfo_temp(struct vn_cs_decoder *dec, VkGraphicsPipelineCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(dec);
    vn_decode_VkGraphicsPipelineCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkGraphicsPipelineCreateInfo_handle_self(VkGraphicsPipelineCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->stageCount */
    if (val->pStages) {
       for (uint32_t i = 0; i < val->stageCount; i++)
            vn_replace_VkPipelineShaderStageCreateInfo_handle(&((VkPipelineShaderStageCreateInfo *)val->pStages)[i]);
    }
    if (val->pVertexInputState)
        vn_replace_VkPipelineVertexInputStateCreateInfo_handle((VkPipelineVertexInputStateCreateInfo *)val->pVertexInputState);
    if (val->pInputAssemblyState)
        vn_replace_VkPipelineInputAssemblyStateCreateInfo_handle((VkPipelineInputAssemblyStateCreateInfo *)val->pInputAssemblyState);
    if (val->pTessellationState)
        vn_replace_VkPipelineTessellationStateCreateInfo_handle((VkPipelineTessellationStateCreateInfo *)val->pTessellationState);
    if (val->pViewportState)
        vn_replace_VkPipelineViewportStateCreateInfo_handle((VkPipelineViewportStateCreateInfo *)val->pViewportState);
    if (val->pRasterizationState)
        vn_replace_VkPipelineRasterizationStateCreateInfo_handle((VkPipelineRasterizationStateCreateInfo *)val->pRasterizationState);
    if (val->pMultisampleState)
        vn_replace_VkPipelineMultisampleStateCreateInfo_handle((VkPipelineMultisampleStateCreateInfo *)val->pMultisampleState);
    if (val->pDepthStencilState)
        vn_replace_VkPipelineDepthStencilStateCreateInfo_handle((VkPipelineDepthStencilStateCreateInfo *)val->pDepthStencilState);
    if (val->pColorBlendState)
        vn_replace_VkPipelineColorBlendStateCreateInfo_handle((VkPipelineColorBlendStateCreateInfo *)val->pColorBlendState);
    if (val->pDynamicState)
        vn_replace_VkPipelineDynamicStateCreateInfo_handle((VkPipelineDynamicStateCreateInfo *)val->pDynamicState);
    vn_replace_VkPipelineLayout_handle(&val->layout);
    vn_replace_VkRenderPass_handle(&val->renderPass);
    /* skip val->subpass */
    vn_replace_VkPipeline_handle(&val->basePipelineHandle);
    /* skip val->basePipelineIndex */
}

static inline void
vn_replace_VkGraphicsPipelineCreateInfo_handle(VkGraphicsPipelineCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO:
            vn_replace_VkGraphicsPipelineCreateInfo_handle_self((VkGraphicsPipelineCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR:
            vn_replace_VkPipelineCreateFlags2CreateInfoKHR_handle_self((VkPipelineCreateFlags2CreateInfoKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR:
            vn_replace_VkPipelineLibraryCreateInfoKHR_handle_self((VkPipelineLibraryCreateInfoKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
            vn_replace_VkPipelineCreationFeedbackCreateInfo_handle_self((VkPipelineCreationFeedbackCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR:
            vn_replace_VkPipelineFragmentShadingRateStateCreateInfoKHR_handle_self((VkPipelineFragmentShadingRateStateCreateInfoKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
            vn_replace_VkPipelineRenderingCreateInfo_handle_self((VkPipelineRenderingCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
            vn_replace_VkGraphicsPipelineLibraryCreateInfoEXT_handle_self((VkGraphicsPipelineLibraryCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkComputePipelineCreateInfo chain */

static inline void *
vn_decode_VkComputePipelineCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineCreateFlags2CreateInfoKHR));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkComputePipelineCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineCreateFlags2CreateInfoKHR_self_temp(dec, (VkPipelineCreateFlags2CreateInfoKHR *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineCreationFeedbackCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkComputePipelineCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineCreationFeedbackCreateInfo_self_temp(dec, (VkPipelineCreationFeedbackCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkComputePipelineCreateInfo_self_temp(struct vn_cs_decoder *dec, VkComputePipelineCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkPipelineShaderStageCreateInfo_temp(dec, &val->stage);
    vn_decode_VkPipelineLayout_lookup(dec, &val->layout);
    vn_decode_VkPipeline_lookup(dec, &val->basePipelineHandle);
    vn_decode_int32_t(dec, &val->basePipelineIndex);
}

static inline void
vn_decode_VkComputePipelineCreateInfo_temp(struct vn_cs_decoder *dec, VkComputePipelineCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkComputePipelineCreateInfo_pnext_temp(dec);
    vn_decode_VkComputePipelineCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkComputePipelineCreateInfo_handle_self(VkComputePipelineCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    vn_replace_VkPipelineShaderStageCreateInfo_handle(&val->stage);
    vn_replace_VkPipelineLayout_handle(&val->layout);
    vn_replace_VkPipeline_handle(&val->basePipelineHandle);
    /* skip val->basePipelineIndex */
}

static inline void
vn_replace_VkComputePipelineCreateInfo_handle(VkComputePipelineCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO:
            vn_replace_VkComputePipelineCreateInfo_handle_self((VkComputePipelineCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR:
            vn_replace_VkPipelineCreateFlags2CreateInfoKHR_handle_self((VkPipelineCreateFlags2CreateInfoKHR *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
            vn_replace_VkPipelineCreationFeedbackCreateInfo_handle_self((VkPipelineCreationFeedbackCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkCreateGraphicsPipelines_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateGraphicsPipelines *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkPipelineCache_lookup(dec, &args->pipelineCache);
    vn_decode_uint32_t(dec, &args->createInfoCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->createInfoCount);
        args->pCreateInfos = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pCreateInfos), iter_count);
        if (!args->pCreateInfos) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkGraphicsPipelineCreateInfo_temp(dec, &((VkGraphicsPipelineCreateInfo *)args->pCreateInfos)[i]);
    } else {
        vn_decode_array_size(dec, args->createInfoCount);
        args->pCreateInfos = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->createInfoCount);
        args->pPipelines = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pPipelines), iter_count);
        if (!args->pPipelines) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPipeline(dec, &args->pPipelines[i]);
    } else {
        vn_decode_array_size(dec, args->createInfoCount);
        args->pPipelines = NULL;
    }
}

static inline void vn_replace_vkCreateGraphicsPipelines_args_handle(struct vn_command_vkCreateGraphicsPipelines *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkPipelineCache_handle(&args->pipelineCache);
    /* skip args->createInfoCount */
    if (args->pCreateInfos) {
       for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_replace_VkGraphicsPipelineCreateInfo_handle(&((VkGraphicsPipelineCreateInfo *)args->pCreateInfos)[i]);
    }
    /* skip args->pAllocator */
    /* skip args->pPipelines */
}

static inline void vn_encode_vkCreateGraphicsPipelines_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateGraphicsPipelines *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateGraphicsPipelines_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pipelineCache */
    /* skip args->createInfoCount */
    /* skip args->pCreateInfos */
    /* skip args->pAllocator */
    if (args->pPipelines) {
        vn_encode_array_size(enc, args->createInfoCount);
        for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_encode_VkPipeline(enc, &args->pPipelines[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkCreateComputePipelines_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateComputePipelines *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkPipelineCache_lookup(dec, &args->pipelineCache);
    vn_decode_uint32_t(dec, &args->createInfoCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->createInfoCount);
        args->pCreateInfos = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pCreateInfos), iter_count);
        if (!args->pCreateInfos) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkComputePipelineCreateInfo_temp(dec, &((VkComputePipelineCreateInfo *)args->pCreateInfos)[i]);
    } else {
        vn_decode_array_size(dec, args->createInfoCount);
        args->pCreateInfos = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->createInfoCount);
        args->pPipelines = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pPipelines), iter_count);
        if (!args->pPipelines) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPipeline(dec, &args->pPipelines[i]);
    } else {
        vn_decode_array_size(dec, args->createInfoCount);
        args->pPipelines = NULL;
    }
}

static inline void vn_replace_vkCreateComputePipelines_args_handle(struct vn_command_vkCreateComputePipelines *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkPipelineCache_handle(&args->pipelineCache);
    /* skip args->createInfoCount */
    if (args->pCreateInfos) {
       for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_replace_VkComputePipelineCreateInfo_handle(&((VkComputePipelineCreateInfo *)args->pCreateInfos)[i]);
    }
    /* skip args->pAllocator */
    /* skip args->pPipelines */
}

static inline void vn_encode_vkCreateComputePipelines_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateComputePipelines *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateComputePipelines_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pipelineCache */
    /* skip args->createInfoCount */
    /* skip args->pCreateInfos */
    /* skip args->pAllocator */
    if (args->pPipelines) {
        vn_encode_array_size(enc, args->createInfoCount);
        for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_encode_VkPipeline(enc, &args->pPipelines[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkDestroyPipeline_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyPipeline *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkPipeline_lookup(dec, &args->pipeline);
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyPipeline_args_handle(struct vn_command_vkDestroyPipeline *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkPipeline_handle(&args->pipeline);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyPipeline_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyPipeline *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyPipeline_EXT});

    /* skip args->device */
    /* skip args->pipeline */
    /* skip args->pAllocator */
}

static inline void vn_dispatch_vkCreateGraphicsPipelines(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateGraphicsPipelines args;

    if (!ctx->dispatch_vkCreateGraphicsPipelines) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateGraphicsPipelines_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateGraphicsPipelines(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateGraphicsPipelines returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkCreateGraphicsPipelines_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCreateComputePipelines(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateComputePipelines args;

    if (!ctx->dispatch_vkCreateComputePipelines) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateComputePipelines_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateComputePipelines(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateComputePipelines returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkCreateComputePipelines_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyPipeline(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyPipeline args;

    if (!ctx->dispatch_vkDestroyPipeline) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyPipeline_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyPipeline(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkDestroyPipeline_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_PIPELINE_H */
