#include <stddef.h>
#include <stdio.h>

#include <vali.h>

#include "example.h"

int main(int argc, char *argv[]) {
	if (argc != 2) {
		fprintf(stderr, "usage: client <socket>\n");
		return 1;
	}

	struct vali_client *client = vali_client_connect_unix(argv[1]);
	if (client == NULL) {
		perror("Failed to connect");
		return 1;
	}

	struct ftl_CalculateConfiguration_out out = {0};
	ftl_CalculateConfiguration(client, &(struct ftl_CalculateConfiguration_in){
		.current = { .longitude = 0, .latitude = 0, .distance = 0 },
		.target = { .longitude = 0, .latitude = 0, .distance = 0 },
	}, &out, NULL);

	struct ftl_Jump_in jump_in = {
		.configuration = out.configuration,
	};
	ftl_Jump(client, &jump_in, NULL, NULL);

	vali_client_destroy(client);
	return 0;
}
