"""
Functions to translate a scheduling policy into either a string name or an
equivalent integer
"""
import os

SCHED_POLICIES = {
    "SCHED_OTHER": os.SCHED_OTHER,
    "SCHED_FIFO": os.SCHED_FIFO,
    "SCHED_RR": os.SCHED_RR,
    "SCHED_BATCH": os.SCHED_BATCH,
    "SCHED_IDLE": os.SCHED_IDLE,
    "SCHED_DEADLINE": 6
}

def sched_fromstr(policy):
    """ Given a policy as a string, return the equivalent integer """
    try:
        return SCHED_POLICIES[policy]
    except:
        raise OSError()


def sched_str(policy):
    """ Given a policy as an integer, return the equivalent string name """
    for pstr, pnum in SCHED_POLICIES.items():
        if pnum == policy:
            return pstr
    return "UNKNOWN"
