---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, MetaFont
---

# Comment faire faire à MetaFont ce que l'on veut ?

MetaFont vous permet de créer vos propres polices. 
La plupart des utilisateurs de TeX n'auront jamais besoin de l'utiliser : 
les systèmes (La)TeX modernes contiennent peu de polices MetaFont d'importance 
et lorsque la sortie MetaFont est nécessaire, la génération des polices se fait, 
automatiquement, "à la volée".

Si vous avez des besoins particuliers que le système ne satisfait pas, 
vous devez connaître MetaFont plus en détail. MetaFont, contrairement à TeX, 
nécessite une personnalisation pour chaque périphérique de sortie : 
cette personnalisation est conventionnellement conservée dans un "mode" associé au périphérique. 
Les modes sont généralement définis en utilisant la convention `mode_def` 
décrite à la page 94 de *The MetaFontbook* (voir la question 
"[](/1_generalites/documentation/livres/documents_sur_les_fontes)").
Votre distribution devrait fournir un fichier, conventionnellement appelé `local.mf`, 
contenant tous les `mode_def` que vous utiliserez. 
Dans le cas improbable où `local.mf` n'existe pas encore, 
la collection de modes de Karl Berry (`modes.mf`) est un bon point de départ : il peut être
utilisé comme `local.mf` sans modification dans une implémentation moderne de MetaFont. 
Les réglages pour les nouveaux périphériques de sortie sont ajoutés à `modes.mf` 
au fur et à mesure qu'ils sont disponibles.

Maintenant, créez un fichier de base `plain` en utilisant `mf` (en mode "initialisation"), 
`plain.mf`, et `local.mf` :

```console
$ mf -ini
This is METAFONT...
**plain # vous saississez "plain"
(commentaires de Metafont)
*input local # vous saississez ceci
(commentaires de Metafont)
*dump # vous saississez ceci
Beginning to dump on file plain...
(commentaires de Metafont)
```

Cela créera un fichier de base nommé `plain.base` (ou quelque chose de similaire, par exemple, 
`PLAIN.BAS` sur les systèmes MS-DOS). Déplacez le fichier dans le répertoire 
contenant les fichiers de base sur votre système, et exécutez `texhash` si nécessaire. 

Vous devez maintenant vous assurer que MetaFont charge cette nouvelle base au démarrage. 
Si MetaFont charge la base `plain` par défaut sur votre système, 
alors vous êtes prêt à commencer. Sous Unix (en utilisant les distributions par défaut de TeX Live 
(et antérieures), cela se produit effectivement, mais nous pourrions par exemple 
définir une commande `plainmf` qui exécute `mf -base=plain` 
(ou, dans un style plus traditionnel, `mf & lain`) qui charge le fichier de base `plain`.

La manière habituelle de créer une police avec MetaFont (avec un fichier de base approprié chargé) 
est de démarrer la saisie de MetaFont avec la ligne suivante en réponse à l'invite `**` 
ou sur la ligne de commande MetaFont.

```{noedit}
\mode=⟨nom du mode⟩; mag=⟨résolution⟩; input ⟨nom du fichier de fonte⟩
```

Si le `⟨nom du mode⟩` est inconnu ou omis, le mode par défaut est le mode `proof` 
et MetaFont produira un fichier de sortie appelé `⟨nom du fichier de police⟩.2602gf`. 
La `⟨résolution⟩` est un nombre à virgule flottante ou un *magstep*. 
Ces derniers définissent les tailles en indiquant combien de fois vous devez multiplier 
une taille de base par "1,2", donc pour une taille de base de "10", "magstep 1" est "12", 
"magstep 2" est `14.4`. Si `mag=⟨résolution⟩` est omis, alors la valeur par défaut est `1` 
(`magstep 0`). Par exemple, pour générer `cmr10` à `12pt` pour une imprimante Epson, 
vous pouvez taper :

```bash
mf \mode=epson; mag=magstep 1; input cmr10
```

Notez que sous Unix, les caractères `\` et `;` doivent généralement être retraités ou "échappés".
Cela ressemblerait donc généralement à quelque chose comme

```bash
mf "\mode=epson; mag=magstep 1; input cmr10"
```

Si vous avez besoin d'un mode spécial qui n'est pas dans la base, 
vous pouvez mettre ses commandes dans un fichier (par exemple, `ln03.mf`) 
et l'invoquer à la volée avec la commande `\smode`. 
Par exemple, pour créer `cmr10.300gf` pour une imprimante LN03, 
vous voulez utiliser le fichier suivant (où vous pourrez noter 
l'absence des commandes `mode_def` et `enddef`) :

```{noedit}
% This is ln03.mf as of 1990/02/27
% mode_def courtesy of John Sauter
proofing:=0;
fontmaking:=1;
tracingtitles:=0;
pixels_per_inch:=300;
blacker:=0.65;
fillin:=-0.1;
o_correction:=.5;
```

Vous taperiez alors :

```bash
mf \smode="ln03"; input cmr10
```

Cette technique n'est pas celle que vous devriez utiliser régulièrement 
mais elle peut s'avérer utile si vous acquérez une nouvelle imprimante 
et souhaitez expérimenter les paramètres, ou pour une autre raison, 
modifier régulièrement les paramètres que vous utilisez. 
Une fois que vous avez choisi un ensemble de paramètres approprié, 
vous devez les utiliser pour reconstruire le fichier de base que vous utilisez.

D'autres sources d'aide sont abordées à la question 
"[](/1_generalites/documentation/documents/tutoriels/tutoriaux_sur_metafont_et_metapost)".


:::{sources}
[Getting MetaFont to do what you want](faquk:FAQ-useMF)
:::
