# encoding: UTF-8
# api: streamtuner2
# title: radiolist.net
# description: Station list by categories
# url: http://radiolist.net/
# version: 0.7
# type: channel
# category: radio
# priority: optional
# png:
#   iVBORw0KGgoAAAANSUhEUgAAABgAAAAYBAMAAAASWSDLAAAAFVBMVEVKb61qibyDnMegs9S6yeDV4O37/vyx66abAAAAAWJLR0QAiAUdSAAAAAlwSFlzAAALEwAACxMB
#   AJqcGAAAAAd0SU1FB+ECDBAgLJqgZW4AAADoSURBVBjTNdBNj4MgEAbgqdLeZdo9C5NwFmo5Y7Wedauc1y/+/09YdLskkDwJmZl3IOxnON4A8frQhdc/7mG2cv3gx29X
#   rdUfZuVHQ3JHEzZ7GSuNXxFV/FYYwryO6MOiZqEdnQPUC/fsXZaMuxa6MFfOVYN7kIWpHZClyJGLFjbbC617KaRUEJ4r4fU7IqNYrW5f2kgU5gZInG6MZ086eejcyIvO
#   1KwoLayoJjqnuWO5giW8msxVmBQXD5PttSlRm8TG2fDNZS3rRO/opeSCMnPa82xSmNgkfRxJ5yZxlPrPDmLu+7GqX4lERq4G0UEyAAAAAElFTkSuQmCC
# extraction-method: json
#
# ⚠ Requires a [Channel → Reload category tree] after updating.
#
# Radio station list, now categorized. And actually got an API.
# Search would be possible now, but isn't enabled.


import re, json, html
import action
import ahttp
from config import *
from channels import *


# radiolist.net
#
# · Only fetches titles/urls.
#
class radiolist (ChannelPlugin):

    # module attributes
    listformat = "pls"
    has_search = False
    categories = ['russian', 'metalcore', 'mappila', 'sindhi', '10s', 'business', 'deep house', 'indian', 'italian', 'tech house', 'afrikaans', 'bengali', 'kashmiri', 'gujarati', 'alternative rock', 'devotional', 'kannada', 'lain', 'talk pop', 'pop. rock. folk', 'multilingual', 'frace', 'swing jazz', 'tamil pop', 'student radio', '60s 70s 80s 90s 00s', 'paranormal talk', 'newage', 'pop teen', 'Ecology', 'top hits', 'sex education', 'sertaneja religious', 'saundtrack', 'fusion', 'smooth jazz', '00s', 'instrumental', 'reggae', 'minimal', 'information', 'balada', 'progressive rock', 'love songs', 'Dance Hits', 'trop rock', 'u2', 'modern rock', 'Guitar', 'air traffic', 'Poetry &amp; Prose', 'Experimental', 'merenge', 'railroad', 'Europe', 'arabic', 'african', 'islamic', 'chanson', 'r&amp;#39', 'n&amp;#39', 'b', 'politics', 'country', 'classic', 'Nutrition', 'odlies', 'polish', 'hardstyle', 'top40 pop', 'Electro', 'foul', 'zouk', 'acid house', 'Scanner', 'drum&amp;#39', '90s.pop', 'synthpop', 'charts', 'vocal', 'psy trance', 'bluegrass', 'roc', 'hind', 'deep techno', 'electric', 'Chamber Music', 'elvis presley', 'kollywood', 'Italo Disco', 'variaty', 'laika', 'Cinematic', 'raggaeton', 'polotik', 'r &amp;#39', 'Holistic health', 'lifestyle', 'rock\u0431r&amp;#39', 'video game', 'german', 'albanian', 'christianl', 'hits', 'popular', 'dis\u0441o', 'nes', 'entertaintment', 'srorts', 'love song', 'Doo Wop', 'soft pop', 'cuambia', 'games music', 'synth pop', 'trap', 'reggeaton', 'techno. folk', 'comedy', 'new wave', 'classic rock', 'rumba', 'india', 'Southern Rock', 'folk pop rock', 'gits', 'hardr rock', 'n&amp;#34', 'corelli', 'choir', 'instreumental', 'entrtainment', 'pop dance', 'deathcore', 'women', 'Steel Pan', 'Hanukkah', 'Singer-Songwriter', 'Sertanejo', 'vallenato', 'Gabber', 'malayalam', 'electro rock', 'urd', 'pop70s', 'banda', 'groove', 'johnny hallyday', 'frank sinatra', 'electro trance', 'sammy davis', 'dean martin', 'tech', 'Kwaito music', 'progressive trance', 'electro house', 'news', 'retro', '\u30cb\u30e5\u30fc\u30b9 (News)', 'pop', 'top40', 'adult contemporary', 'Adult', 'Contemporary Classical', 'Praise &amp; Worship', 'Public Access', 'Shopping', 'Bandanejo', 'Gay', 'Radio Reading Service', 'vietnamese', 'french', 'filipino', 'regueton', 'nits', 'tropics', 'dance pop', 'rock &amp;amp', 'Cars', 'jazz piano', 'romanian', 'serbian', 'glam', 'rock pop', 'manele', 'chr', 'thrash metal', 'Kpop', 'prayer', 'international', 'latin pop', 'gurbani', 'Flashback', 'Bhakti', 'hot adult contemporary', 'christian talk', 'traffic', 'black metal', 'zen', 'thrash', 'speed', 'drama', 'caribbean', 'motown', 'breakbeat', 'talk.top40', 'indie-pop', 'indie-folk', 'music', 'Postpunk', 'Holidays', 'queen', 'AAA', 'b.oldies', 'led zeppelin', 'rock`n roll', 'eletro', 'public', 'bob marley', 'oldies.top40', 'base', 'drum&amp;amp', 'rock.oldies', 'dark metal', 'gauchesca', 'info trafic', 'malayalam music', 'pop.60s', 'African Gospel', 'Old Time Radio', 'dacnce', 'club', 'trip-hop', 'dancec', 'latin\u043e', 'football', 'croatian', 'ethnic', 'ndian', 'anime', 'weather', 'power rock', 'military', 'eurodance', 'italodance', 'old', 'classik rock', 'tak', 'trip', 'schlagers', 'alternative metal', 'entretainment', 'christian rock', 'clasical rock', 'nature', 'setanejo', 'downtempo', 'spiritual', 'religion', 'soundtrack', 'pop ingles', 'elecreo', 'melodic rock', 'fisco', 'metal core', 'dutch', 'reggateon', 'ekectro', 'rock\u2018n\u2018roll', 'Big Band', 'contemporary jazz', 'talk.adult contemporary', 'mariachi', 'kumbia', 'beethoven', 'mantra', 'Tribute', 'ukrainian', 'talk', 'techno', 'progressive', 'dance', 'Dreampop', 'oldies', 'jazz', 'blues', 'house', 'electronic', 'piraten', 'popo', 'sikh', 'afropop', 'Schlager', 'love sungs', 'world music', 'rockabilly', 'bhangra', 'turkish', 'hip-hop r&amp;#39', 'various', 'cantonese', 'adult contemprory', 'oldis', 'astrology', 'marathi', 'pop-rock', 'kompa', 'movie news', 'bass', 'jungle', 'national news', 'Arabesk', 'death metal', 'folk rock', 'progressive metal', 'power metal', 'fock', 'Ballad', 'Drum and Bass', 'Electronica', 'Breaks', 'adult contemporar', 'konpa', 'interview podcasts', 'Classic Hits', 'reagge', 'Gospel Pop', 'postrock', 'dance l', 'today', 'calypso', 'top0', 'yesterday', 'Financial', 'tropic', 'rock. rock&amp;#39', 'History', 'Krautrock', 'j-metal', 'o dance', 'Konkani', 'Dulpod', 'Masala', 'Mando', 'nu metal', 'mathcore', 'hause', '\u043f\u043e\u043f', 'dsnce', 'disc', 'samba', 'chil out', 'ragga', 'grange', 'classsic', 'dance.trance', 'vocal house', 'bolero', 'soudtrack', 'longe', 'Gumbe', 'Language Learning', 'pagode', '50s', 'new age', 'politic', 'disco', 'relax', 'meditation', 'sertaneja', 'reggaeton', 'tropical', 'easy listening', 'marengue', 'psychill', 'goa', 'religous', 'discofox', 'heavy rock', 'informations', 'britpop', 'aor', 'fox', 'heavy', 'Bongo Flava', 'Standards', 'resque', 'inspirational', 'Laptop Music', 'bossa nova', 'Woman', 'Cartoons', 'hip hp', 'banda.bachata', 'road', 'preaching', 'news.talk', 'reageton', 'golspel', 'poker', 'Kuduro', 'r`n`b', 'countr', 'bach', 'classic metal', 'iindie', 'hard', 'regae', 'traditional', 'chutney', 'korean', 'lgbt', 'tejano', 'cubaton', 'persian', 'iranian', 'nostalgie', 'active rock', 'hawaiian', 'baroque', 'Cabo Love', 'College', 'Native American', 'Movies', 'local news', 'Food', 'spo', 'beatles', 'Pakistani', 'funk. sertanea', 'seraneja', 'dances', 'health', 'soft', '00', 'Positive', 'cat\xf3lica', 'freestyle', '60s 70s 80s', 'enterntainment', 'ska', 'indie', 'opera', 'heavy metal', 'funk', 'punk', 'grunge', 'metal', 'tango', 'schanson', 'indigo', 'slow', 'nu-jazz', 'chill-house', 'economic', 'turkish pop', 'islamik', 'david bowie', 'smooth jazz .lounge . house', 'michael jackson', 'portuguese', 'christian contemporary', 'ambient', 'dj', 'edm', 'roll', 'forr\xf3', 'k-pop', 'rock&amp;#39', 'eletronic', 'j-pop', 'dance rock', 'gothic', 'industrial', 'pink floyd', 'community', 'acoustic', 'asian', 'japanese', 'rawstyle', 'kurdish', 'ebm', 'medieval', 'hands up', 'deutsch', 'handsup', 'tamil', 'spanich', 'pop. news', 'folk. deutsch', 'paranormal', 'mozart', 'smooth rock', 'psytrance', 'hardstep', 'oos', 'kizomba', 'haitian', 'jewish', 'decades', '90s', '80s', 'Swedish', 'Psych', 'entertainment', 'christian', 'trance', 'eclectic', 'folk', 'culture', 'children', 'rock', 'Travel / Tourism', '\u0441hristian', 'Contemporary Christian', 'yoga', 'disco polo', 'crosover', 'crossover. gospel', 'croosover', 'crossover.community', 'reguetoon', 'combia', 'jazz funk', 'c-pop', 'hard core', 'IDM', 'Current Affairs', 'poetry', 'Other', 'Classics', 'hard roock', 'bosnian', 'neo-soul', 'b.hip-hop', 'cabaret', 'amateur radio', 'rail', 'judaism', 'polka', 'Kids', 'Sufi', 'lnew age', 'depeche mode', 'celtic', 'baseball', 'Odia', 'Fashion', 'Mehfil', 'cool jazz', 'latinvariety', 'dance hall', 'pop indie', 'maori', 'Rural', 'pop. 90s', 'Garbage', 'sports \u0431 entertainment', 'Soundtracks', 'Rapso', 'Afrobeat', 'swamp pop', 'travel', 'dub techno', 'doom', 'uplifting trance', 'deep electronic', 'hard-rave', 'tech trance', 'rave', 'japan', 'technology', 'transe', 'danse', 'pop.talk', 'oldies.pop', 'regeaton', 'news. sport', 'c', 'indi', 'disco. oldies', 'movie', 'ppop', 'live shows', 'odies', 'Recommended', '40s', 'brazilian pop', 'moroccan', 'elecrto', 'brazilian', 'classico', 'american', 'hard rock', 'drum\xb4n bass', 'elrctro', 'limp bizkit', 'synthie pop', 'rocknews', 'oldie', 'classsic rock', 'sartanejo', 'jpop', 'jrock', 'varietes', 'rn&amp;#39', 'balcan', 'tubes', 'reggeae', 'soul.r&amp;#39', 'israeli', 'Mediterranean', 'Art', 'Classical', 'Bulgarian', 'cumbia', 'spanish', 'to40', 'romantic', 'armenian', '60s', 'alternative', 'variety', 'azerbaijani', 'latin', 'urban', 'Family', 'http://visiondeselus.com', 'Shoegaze', 'Childrens Family', 'crossover', 'gospel jazz', 'cajun', 'telug', 'punk rock', 'marimba', 'Gaming', 'chill-out', 'lounge', '70s', 'dubstep', 'rap', 'sports', 'gospel', 'garage', 'Ham Radio', 'hip-hop', 'Teen Pop', 'mexican', '20s', 'classic jazz', 'acid jazz', 'l', 'raggae', 'pop.top40', 'Emergency &amp; Public Safety', 'Government', 'Documentaries', 'Tourism/Travel', 'Carnatic', 'Cooking', 'Emo', 'Thai', 'taalk', 'catolic', 'Lite Pop', 'live', 'flamenco', 'beyonce', 'christmas', 'nu-soul', 'symphonic', 'greece', 'italan', 'rok', 'progressive house', 'soul', 'swing', 'education', 'soft rock', 'religious', 'salsa', 'merengue', 'bachata', 'Ghetto', 'underground', 'Ballroom', 'rock news', 'oldies rock', 'chritian', 'reaggaeton', 'post-rock', 'rturkish', 'Fado', 'bolivian', 'new', 'grupera', 'ranchera', 'muslim', 'Youth', 'top-40', 'police', 'hit', 'hits 60s', 'pop.80s', 'spanish rock', 'hits\u0431 80s', 'latin jazz', 'public safety', 'electro-pop', 'irish', 'indie rock', 'urban contemporary', 'local', 'psychedelic', 'Balkan', 'Science', 'Americana', 'japanesse', 'Airport', 'Air Traffic Control', 'Liquid Funk', 'Festival', 'soca', 'Middle Eastern', 'Chillout', 'Catholic', 'colombian', 'reggeton', 'symphonic metal', 'boogie', '50', 'reading', 'Austrian', 'regaeton', 'golpel', 'halloween', 'desi', 'flash back', 'hinduism', 'rescue', 'mix', 'Chansons Fran\xe7aises', 'Slowjam', 'Animation', 'kirtan', 'Hebrew', 'Hindi', 'n\u2019b', 'reggaton', 'catalan', 'Zydeco', 'talk.news', 'valse', 'Seasons', 'smooth', 'milonga', 'Psy', 'southern gospel', 'Gospel Rock', 'General', 'top', 'world', 'Lithuanian', 'Campeira', 'punjabi', 'remix', 'chinese', 'pundjabi', 'christian pop', 'hardcore', 'dancehall', 'emergency', 'bangladeshi', 'party', 'pop.talk.news', 'old school', 'greek', 'roots', 'bollywood', '30s', 'english', 'tribal', 'buddhist', 'Soukous']
    catmap = {'folk rock': '455', 'power metal': '457', 'rok': '426', 'Singer-Songwriter': '5180', 'chinese': '487', 'ragga': '753', 'dance': '246', 'Shoegaze': '1092', 'roc': '447', 'gauchesca': '409', 'foul': '521', 'laika': '906', 'swamp pop': '678', 'n&amp;#39': '275', 'disc': '867', 'asian': '388', 'heavy metal': '311', '50': '721', 'meditation': '327', 'hard roock': '630', 'n&amp;#34': '857', 'children': '254', 'classic rock': '332', 'alternative rock': '349', 'Dreampop': '4624', 'Ballroom': '5125', 'vietnamese': '612', 'regae': '695', '\u043f\u043e\u043f': '862', 'hinduism': '601', 'r &amp;#39': '908', 'dancehall': '482', 'entertaintment': '433', 'rescue': '600', 'marimba': '672', 'Hanukkah': '13162', 'dutch': '929', 'Standards': '1041', 'Air Traffic Control': '7648', 'odlies': '524', 'edm': '365', 'Emergency &amp; Public Safety': '1416', 'Experimental': '1080', 'Kpop': '1578', 'acid house': '523', 'rturkish': '840', 'judaism': '465', 'news.talk': '664', 'Sufi': '7693', 'bob marley': '400', 'r&amp;#39': '274', 'reggeton': '725', 'croatian': '826', 'spiritual': '394', 'deutsch': '782', 'Festival': '1483', 'Language Learning': '1614', 'lgbt': '543', 'lnew age': '461', 'tamil pop': '711', 'raggaeton': '904', 'Konkani': '3881', '10s': '346', 'folk': '256', '90s': '258', 'c-pop': '736', 'telug': '670', 'drum\xb4n bass': '803', 'marathi': '627', 'resque': '686', 'gujarati': '814', 'indian': '341', 'reaggaeton': '843', 'international': '688', 'public': '401', 'nu-soul': '916', 'oldis': '621', 'christian': '253', 'latinvariety': '965', 'oldies': '240', 'reggeae': '767', 'muslim': '484', 'french': '613', 'hip hp': '669', 'sertaneja religious': '424', 'slow': '833', 'baseball': '608', 'saundtrack': '427', 'elvis presley': '902', 'trip-hop': '829', 'golpel': '729', 'classik rock': '700', 'turkish': '515', 'student radio': '710', 'techno': '244', 'rock. rock&amp;#39': '659', 'military': '709', 'Flashback': '1479', 'video game': '645', 'symphonic': '425', 'jazz funk': '508', 'Radio Reading Service': '1174', 'Middle Eastern': '1188', 'clasical rock': '390', 'Big Band': '1650', 'Hindi': '2583', 'Europe': '1125', 'air traffic': '594', 'Balkan': '1032', 'dance hall': '966', 'Mehfil': '6480', 'devotional': '816', 'soul.r&amp;#39': '764', 'chr': '943', 'Psy': '1110', 'music': '493', 'Positive': '2790', 'christian pop': '485', 'today': '652', 'j-metal': '869', 'Cooking': '4206', 'hard core': '739', 'turkish pop': '834', 'relax': '326', 'club': '378', 'halloween': '605', 'rocknews': '807', 'schlagers': '703', 'instrumental': '297', 'crossover. gospel': '730', 'classic jazz': '535', 'world music': '510', 'glam': '944', 'Sertanejo': '1625', 'doom': '879', 'synthie pop': '800', 'women': '822', 'christmas': '423', 'Financial': '1508', 'Americana': '1590', 'Family': '1090', 'pop. news': '788', 'r`n`b': '692', 'oldies rock': '846', 'soul': '309', 'pop.talk.news': '472', 'fock': '595', 'psy trance': '441', 'pop. rock. folk': '717', 'metalcore': '453', 'games music': '335', 'balcan': '760', 'indie': '313', 'top40 pop': '527', 'spo': '414', 'india': '823', 'folk. deutsch': '789', 'drum&amp;#39': '449', 'Schlager': '1699', 'beatles': '415', 'cantonese': '623', 'Soukous': '6232', 'dj': '364', 'dean martin': '556', 'flamenco': '421', 'power rock': '708', 'sikh': '519', 'tak': '701', 'information': '292', 'Chansons Fran\xe7aises': '1163', 'travel': '641', 'poetry': '502', 'lounge': '262', 'Seasons': '2400', 'desi': '604', 'comedy': '330', 'Steel Pan': '8908', 'sammy davis': '557', 'poker': '661', 'jazz': '243', 'interview podcasts': '596', 'b.hip-hop': '634', 'balada': '293', 'pop dance': '858', 'pink floyd': '385', 'soundtrack': '398', 'islamic': '272', 'aor': '772', 'Chillout': '1022', 'ethnic': '375', 'islamik': '838', 'Travel / Tourism': '2569', 'amateur radio': '636', 'psychedelic': '567', 'kashmiri': '813', 'reggaton': '959', 'reagge': '656', 'alternative metal': '393', 'love song': '431', 'greek': '470', 'Gabber': '5227', 'valse': '953', 'jungle': '451', 'african': '271', 'american': '351', 'combia': '734', 'talk': '245', 'bossa nova': '359', 'Catholic': '1187', 'mexican': '537', 'Mando': '3882', 'tropics': '617', 'zen': '459', 'danse': '891', 'national news': '629', 'religious': '304', 'talk.news': '950', 'progressive metal': '456', 'active rock': '545', 'urd': '743', 'japan': '871', 'soudtrack': '889', 'hip-hop': '268', 'astrology': '620', 'rock news': '827', 'Classics': '1035', 'police': '568', 'nostalgie': '544', 'crosover': '731', 'beyonce': '420', 'Documentaries': '1320', 'pop70s': '744', '\u0441hristian': '406', 'polotik': '905', 'IDM': '1033', 'ekectro': '799', 'decades': '574', 'pop teen': '422', 'enterntainment': '319', 'Classic Hits': '978', 'elecrto': '808', 'Youth': '1981', 'eclectic': '251', 'hard-rave': '874', 'top40': '236', 'talk pop': '718', 'hot adult contemporary': '680', 'taalk': '429', 'rock&amp;#39': '361', 'talk.adult contemporary': '587', 'regueton': '611', 'opera': '312', 'top hits': '911', 'choir': '851', 'rawstyle': '784', 'thrash metal': '941', '40s': '357', 'trap': '337', 'rock': '255', 'acoustic': '387', 'heavy': '778', 'salsa': '305', 'grupera': '539', 'house': '249', 'hard': '694', 'punk rock': '671', 'persian': '546', 'dubstep': '260', 'tribal': '478', 'preaching': '665', 'talk.top40': '490', 'piraten': '924', 'blues': '242', 'disco': '321', 'nits': '616', 'metal core': '791', 'gurbani': '687', 'entertainment': '252', 'culture': '257', 'goa': '774', 'health': '412', 'oldies.top40': '933', 'lain': '719', 'Carnatic': '6457', 'Chamber Music': '1545', 'pop. 90s': '935', 'bass': '450', 'led zeppelin': '938', 'dsnce': '865', '70s': '261', 'base': '932', 'Cartoons': '4302', 'Holistic health': '1537', 'odies': '673', 'baroque': '549', 'pop indie': '961', 'punk': '317', 'Current Affairs': '1031', 'spanish rock': '737', '90s.pop': '448', 'Doo Wop': '2616', 'swing': '300', 'hardcore': '462', 'nu metal': '861', 'informations': '770', 'industrial': '384', 'adult contemporar': '971', 'entrtainment': '853', 'tango': '314', 'spanish': '288', 'Praise &amp; Worship': '1193', 'hard rock': '350', 'electronic': '248', 'deathcore': '859', 'chanson': '273', 'hardr rock': '856', 'top': '466', 'k-pop': '360', 'Postpunk': '1832', 'Adult': '1191', 'cuambia': '338', 'acid jazz': '534', 'Old Time Radio': '1958', 'malayalam': '815', 'reggaeton': '325', 'kurdish': '785', 'http://visiondeselus.com': '679', 'Guitar': '1083', 'History': '2620', 'electro-pop': '759', 'christian rock': '391', 'b': '276', 'Classical': '1076', 'mantra': '580', 'death metal': '454', 'vocal': '442', 'kollywood': '821', 'eurodance': '704', 'ndian': '820', 'cat\xf3lica': '418', 'j-pop': '381', 'rock\u2018n\u2018roll': '798', '20s': '536', 'AAA': '1340', 'urban': '286', 'dance.trance': '886', 'crossover': '674', 'hits\u0431 80s': '755', 'Other': '1034', 'indie-pop': '491', 'Electro': '1018', 'Fado': '5082', 'Kwaito music': '3633', 'cool jazz': '907', 'Italo Disco': '4428', 'britpop': '773', 'iindie': '697', 'Food': '7439', 'trance': '250', 'news. sport': '438', 'mix': '603', 'reggeaton': '336', 'dis\u0441o': '435', 'Science': '1596', 'sindhi': '819', 'korean': '542', 'jpop': '768', 'handsup': '783', 'Ghetto': '1936', 'hip-hop r&amp;#39': '514', 'electric': '444', 'ukrainian': '589', 'eletronic': '380', 'multilingual': '714', 'israeli': '765', 'Rural': '1105', 'hands up': '781', 'electro rock': '740', 'Arabesk': '2456', 'indie rock': '564', 'n\u2019b': '635', 'rock`n roll': '403', 'punjabi': '489', 'metal': '315', 'Cabo Love': '5149', 'traditional': '698', 'cumbia': '289', 'tech': '551', 'movie': '646', 'indi': '897', 'Breaks': '972', 'latin jazz': '560', 'bangladeshi': '480', 'psychill': '775', 'boogie': '720', 'Bandanejo': '5929', 'german': '647', 'techno. folk': '331', 'queen': '407', 'popo': '419', 'moroccan': '809', 'love songs': '291', 'black metal': '458', 'japanesse': '738', 'seraneja': '410', 'Drum and Bass': '976', 'pop.talk': '892', 'Bulgarian': '1077', 'Woman': '1687', 'Tourism/Travel': '1329', 'dance rock': '382', 'romanian': '946', 'Southern Rock': '2865', 'trop rock': '590', 'dacnce': '379', 'Dance Hits': '1087', 'deep house': '340', 'Native American': '7563', 'Lite Pop': '1255', 'tropic': '658', 'local': '566', 'post-rock': '841', 'banda.bachata': '668', 'religous': '777', 'pop-rock': '626', 'indie-folk': '492', 'folk pop rock': '854', '60s 70s 80s 90s 00s': '915', 'variaty': '901', 'new': '374', 'breakbeat': '497', 'regaeton': '728', 'chutney': '699', 'afropop': '518', 'Ecology': '2316', 'progressive': '247', 'Hebrew': '1200', 'iranian': '547', 'Mediterranean': '4568', 'nes': '432', 'hardstyle': '526', 'southern gospel': '639', 'elecreo': '797', 'Austrian': '1741', 'instreumental': '852', 'bachata': '307', 'paranormal talk': '606', 'beethoven': '582', 'ebm': '787', 'tech trance': '875', 'uplifting trance': '876', 'new wave': '333', 'Recommended': '1609', 'Bongo Flava': '2972', 'greece': '910', 'croosover': '733', 'Ballad': '1082', '00': '920', 'Gospel Pop': '1503', 'Shopping': '1755', 'tejano': '540', 'crossover.community': '732', 'speed': '499', 'motown': '496', 'Cinematic': '2043', 'various': '516', 'roots': '476', 'Thai': '15023', 'reading': '501', 'entretainment': '392', 'ppop': '436', 'cajun': '677', 'latin': '287', 'nature': '397', 'chill-out': '263', 'zouk': '522', 'Laptop Music': '1341', 'funk. sertanea': '417', 'Liquid Funk': '1025', 'bolivian': '849', 'pagode': '355', 'armenian': '280', 'news': '238', 'Public Access': '2349', 'schanson': '866', 'hits': '241', 'countr': '690', 'reageton': '663', 'Contemporary Classical': '1190', 'country': '278', 'mariachi': '584', 'b.oldies': '405', 'top-40': '745', 'gospel': '265', 'melodic rock': '796', 'disco polo': '939', 'oldie': '806', 'disco. oldies': '899', 'flash back': '372', 'dancec': '828', 'regeaton': '894', 'discofox': '776', 'paranormal': '579', 'pop': '235', 'eletro': '402', 'colombian': '724', 'love sungs': '511', 'ranchera': '538', 'drum&amp;amp': '931', 'rave': '873', 'classic metal': '696', 'easy listening': '329', 'chritian': '844', 'michael jackson': '368', 'frace': '713', 'corelli': '850', 'African Gospel': '1951', 'setanejo': '396', 'Kuduro': '5102', 'reggateon': '416', 'public safety': '561', 'Lithuanian': '1711', 'polka': '464', 'charts': '443', 'konpa': '657', 'johnny hallyday': '747', 'local news': '563', 'pop.top40': '437', 'mappila': '818', 'classsic rock': '805', 'Teen Pop': '1550', 'Emo': '8526', 'c': '896', 'soft rock': '302', 'Soundtracks': '1108', 'Zydeco': '6047', 'tamil': '469', 'funk': '310', 'raggae': '530', 'merengue': '306', 'hits 60s': '751', 'sartanejo': '358', 'General': '1294', 'Animation': '1207', 'College': '1319', 'kirtan': '609', 'sertaneja': '324', 'thrash': '498', 'Childrens Family': '1093', '50s': '322', 'bolero': '569', 'milonga': '954', 'underground': '370', 'rap': '267', 'rock\u0431r&amp;#39': '643', 'bluegrass': '440', 'top0': '650', '00s': '296', 'swing jazz': '712', 'gothic': '383', 'ambient': '367', 'arabic': '270', 'technology': '597', 'neo-soul': '633', 'marengue': '562', 'buddhist': '479', 'electro house': '552', 'synthpop': '345', 'Bhakti': '8769', 'longe': '888', 'azerbaijani': '284', '80s': '259', 'party': '790', 'Contemporary Christian': '1583', 'brazilian pop': '356', 'psytrance': '900', 'kizomba': '577', 'rail': '637', 'yesterday': '651', 'Movies': '2044', 'Airport': '7649', 'rockabilly': '513', '60s 70s 80s': '926', 'christian contemporary': '366', 'o dance': '868', 'celtic': '463', 'Gospel Rock': '1561', 'contemporary jazz': '586', 'sports': '266', 'synth pop': '334', 'Psych': '4635', 'hardstep': '571', 'inspirational': '681', 'english': '475', '\u30cb\u30e5\u30fc\u30b9 (News)': '3064', 'malayalam music': '628', 'rock pop': '945', 'indigo': '832', 'frank sinatra': '555', 'postrock': '654', 'italan': '913', 'world': '591', 'polish': '525', 'alternative': '282', 'christian talk': '683', 'deep techno': '445', 'Gaming': '1152', 'bhangra': '512', 'samba': '354', 'Gay': '1750', 'bollywood': '477', 'heavy rock': '771', 'Holidays': '1834', 'ska': '318', 'emergency': '481', 'Campeira': '8009', 'varietes': '762', 'catalan': '958', 'fusion': '298', 'traffic': '682', 'community': '386', 'tech house': '343', 'tropical': '328', 'info trafic': '934', 'Art': '1079', 'railroad': '598', 'banda': '558', 'symphonic metal': '500', 'manele': '942', 'cubaton': '541', 'calypso': '653', 'Fashion': '5551', 'oos': '570', 'Scanner': '2263', 'jazz piano': '948', 'chil out': '883', 'dances': '411', 'latin pop': '685', 'garage': '264', 'elrctro': '802', 'serbian': '947', 'popular': '434', 'urban contemporary': '565', 'soft': '413', 'italian': '342', 'Swedish': '2194', 'portuguese': '369', 'old': '707', 'electro trance': '554', 'reggae': '294', 'gits': '855', 'bach': '691', 'l': '531', 'japanese': '389', 'economic': '837', 'smooth jazz .lounge . house': '922', 'dark metal': '936', 'nu-jazz': '830', 'Masala': '3883', 'Tribute': '4255', 'progressive rock': '290', 'vallenato': '348', 'rock.oldies': '930', 'movie news': '624', 'caribbean': '495', 'modern rock': '592', 'fox': '779', 'reguetoon': '735', 'transe': '890', 'religion': '399', 'Odia': '6489', 'retro': '239', 'limp bizkit': '801', 'hind': '446', 'minimal': '295', 'sex education': '619', 'medieval': '780', 'business': '347', 'gospel jazz': '676', 'kumbia': '585', 'pop.60s': '758', 'Poetry &amp; Prose': '1081', 'progressive trance': '553', 'deep electronic': '877', 'afrikaans': '810', 'downtempo': '395', 'cabaret': '468', 'classsic': '887', 'lifestyle': '640', 'Ham Radio': '3646', 'filipino': '610', 'classico': '352', 'albanian': '439', 'catolic': '428', 'drama': '494', 'Kids': '1128', 'old school': '473', 'anime': '377', 'Cars': '8799', 'oldies.pop': '893', 'sports \u0431 entertainment': '408', 'road': '667', 'pop.80s': '757', 'rn&amp;#39': '763', '30s': '474', 'smooth jazz': '299', 'Afrobeat': '2637', 'chill-house': '831', 'weather': '376', 'adult contemprory': '622', 'progressive house': '308', 'pop ingles': '895', 'Pakistani': '4609', 'Nutrition': '2546', 'adult contemporary': '237', 'soca': '505', 'depeche mode': '460', 'live': '918', 'u2': '593', 'grange': '880', 'brazilian': '353', 'dub techno': '878', 'newage': '917', 'maori': '968', 'grunge': '316', 'hawaiian': '548', 'jewish': '575', 'bosnian': '632', 'golspel': '662', 'bengali': '812', 'russian': '452', 'haitian': '576', 'italodance': '705', 'romantic': '281', 'jrock': '769', 'kompa': '625', 'smooth': '955', 'rumba': '559', 'Gumbe': '13065', 'politic': '320', 'Slowjam': '4246', 'hause': '863', 'groove': '746', 'irish': '509', 'classic': '279', 'Electronica': '973', 'kannada': '817', 'mathcore': '860', 'prayer': '689', 'politics': '277', 'education': '301', 'trip': '702', 'hit': '752', 'forr\xf3': '363', 'Dulpod': '3880', 'pundjabi': '486', 'yoga': '602', 'variety': '285', 'rock &amp;amp': '615', 'Rapso': '4088', 'new age': '323', 'freestyle': '925', 'to40': '572', 'roll': '362', 'christianl': '649', 'live shows': '648', 'david bowie': '839', '60s': '283', 'spanich': '903', 'Krautrock': '7359', 'football': '373', 'smooth rock': '573', 'vocal house': '885', 'fisco': '795', 'srorts': '430', 'remix': '488', 'Garbage': '8581', 'mozart': '578', 'tubes': '761', 'latin\u043e': '824', 'Government': '1417', 'soft pop': '339', 'dance pop': '614', 'merenge': '599', 'dance l': '655'}
    titles = dict( genre="Genre", title="Station", playing="Location", bitrate="Bitrate", listeners=False )

    # just a static list for now
    def update_categories(self):
        c = []
        rx_sel = re.compile(r"""data-genres='(\{.+?\})'""")
        doc = ahttp.get("https://radiolist.net/radio-stations")
        doc = re.findall(rx_sel, doc)[0]
        try:
            doc = html.unescape(html.unescape(doc))
        except:
            pass
        map = json.loads(doc)
        self.categories = sorted(map.values())
        self.catmap = dict(zip(map.values(), map.keys()))
        print(self.categories)
        print(self.catmap)
        

    # extract stream urls
    def update_streams(self, cat, search=None):
        entries = []
        catid = self.catmap.get(cat, "")
        for i in range(1, int(int(conf.max_streams)/100)+1):
            j = json.loads(ahttp.get(
                "https://radiolist.net/wp-json/wp-radio/v1/station?paginate={}&keyword={}&country=&genre={}&sort=asc&perpage=50&_locale=user".format(i, search or "", catid)
            ))
            for e in j["data"]["items"]:
                entries.append({
                    "id": e["id"],
                    "title": e["title"],
                    "img": e["thumbnail"],
                    "url": e["stream"],
                    "homepage": e["website"],
                    "playing": e["slogan"],
                    "genre": " ".join([g["name"] for g in e["genres"]]),
                    #"country": e["locations"]["country"]["name"],
                })
            if i >= j["data"]["total"]:
                break
        return entries


    