use core:net;
use core:io;
use crypto;
use lang:bs:macro;

Url certUrl() {
	if (url = named{cert}.url)
		return url;
	throw InternalError("Failed to locate the certificate package in the filesystem.");
}

void main() {
	var c = Certificate:loadPEM(certUrl / "cert.pem");
	print(c.toS);

	server(c);
	// client();
	// client(c); // This should not work as certs don't match.
}

// TODO: We could do this with local pipes as well. Sadly, we don't have those yet.
void server(Certificate cert) {
	var key = cert.loadKeyPEM(certUrl / "key.pem");

	ServerContext s(key);
	print(s.toS);

	Pipe toServer;
	Pipe fromServer;

	var x = spawn connect(cert, fromServer.input, toServer.output);
	x.detach();

	try {

		var session = s.connect(toServer.input, fromServer.output);
		print("Got a session in the server!");

		var in = Utf8Input(session.input);
		print(in.readAll);
	} catch (Exception e) {
		// To make the other end of the connection able to wake up.
		toServer.close();
		fromServer.close();
		throw e;
	}
}

void connect(Certificate cert, IStream input, OStream output) {
	try {
		var session = ClientContext:pinnedTo(cert).connect(input, output, "localhost");

		print("Got a session in the client!");

		var out = Utf8Output(session.output);
		out.write("Hello!");
		out.flush();

		print("Sent data!");

		// Shut down so that the other end does not have to wait.
		session.close();
	} catch (Exception e) {
		print("Error in the client: ${e}");
	}
}

void client() {
	var context = ClientContext:systemDefault();
	var stream = connect("storm-lang.org", 443);
	if (stream) {
		var session = context.connect(stream, "storm-lang.org");
		print("Got a session!");

		var in = Utf8Input(session.input);
		var out = Utf8Output(session.output, windowsTextInfo());
		out.autoFlush = false;


		out.write("GET / HTTP/1.0\n"); // To disable "chunked"...
		out.write("Host: storm-lang.org\n");
		out.write("\n\n");
		out.flush();

		print(in.readAll());

		session.close();
		print("Done!");
	} else {
		print("Failed to connect.");
	}
}

void client(Certificate c) {
	var context = ClientContext:pinnedTo(c);
	var stream = connect("storm-lang.org", 443);
	if (stream) {
		var session = context.connect(stream, "storm-lang.org");
		print("Got a session!");

		var in = Utf8Input(session.input);
		var out = Utf8Output(session.output, windowsTextInfo());
		out.autoFlush = false;


		out.write("GET / HTTP/1.0\n"); // To disable "chunked"...
		out.write("Host: storm-lang.org\n");
		out.write("\n\n");
		out.flush();

		print(in.readAll());

		session.close();
		print("Done!");
	} else {
		print("Failed to connect.");
	}
}
