13.2 Live Audio

# Live Audio

The `:sound_in` synth as described in the previous section provides a
very flexible and familiar method for working with input audio. However,
as also discussed it has a few issues when working with a single input
of audio as a single instrument (such as a voice or guitar). By far the
best approach to working with a single continuous stream of audio is to
use `live_audio`.

## A Named Audio Input

`live_audio` shares a couple of core design constraints with `live_loop`
(hence the similar name). Firstly it must have a unique name and
secondly only one `live_audio` stream with that name may exist at any
one time. Let's take a look:

```
live_audio :foo
```

This code will act in a similar fashion to `synth :sound_in` with some
key differences: it runs forever (until you explicitly stop it) and you
can *move* it to new FX contexts dynamically.


## Working with FX

On initial triggering `live_audio` works exactly as you might expect it
to work with FX. For example, to start a live audio stream with added
reverb simply use a `:reverb` FX block:

```
with_fx :reverb do
  live_audio :foo
end
```

However, given that `live_audio` runs forever (at least until you stop
it) it would be pretty limiting if, like typical synths, the live audio
was bound within the `:reverb` FX for its entire existence. Luckily this
is not the case and it was designed to be easy to move between different
FX. Let's try it. Run the code above to hear live audio coming directly
from the first input of your sound card. Note, if you're using a laptop,
this will typically be out of your built-in microphone, so it's
recommended to use headphones to stop feedback.

Now, whilst you're still hearing the audio live from the sound card with
reverb, change the code to the following:

```
with_fx :echo do
  live_audio :foo
end
```

Now, hit Run, and you'll immediately hear the audio played through the
echo FX and no longer through reverb. If you wanted them both, just edit
the code again and hit Run:

```
with_fx :reverb do
  with_fx :echo do
    live_audio :foo
  end
end
```

It's important to point out that you can call `live_audio :foo` from any
thread or live loop and it will move the live audio synth to *that*
thread's current FX context. You could therefore easily have multiple
live loops calling `live_audio :foo` at different times resulting in the
FX context being automatically swapped around for some interesting
results.


## Stopping live audio

Unlike standard synths, as `live_audio` has no envelope, it will
continue running forever (even if you delete the code, just like a
function is still defined in memory if you delete the code in the
editor). To stop it, you need to use the `:stop` arg:

```
live_audio :foo, :stop
```

It can easily be restarted by calling it without the `:stop` arg again:


```
live_audio :foo
```

Additionally all running live audio synths are stopped when you hit the
global Stop button (as with all other running synths and FX).

## Stereo input

With respect to audio channels, by default `live_audio` acts similarly
to the `:sound_in` synth in that it takes a single mono input stream of
audio and converts it to a stereo stream using the specified
panning. However, just like `:sound_in_stereo` it's also possible to
tell `live_audio` to read two consecutive audio inputs and treat them as
the left and right channels directly. This is achieved via the `:stereo`
opt. For example, to treat input 2 as the left signal and input 3 as the
right signal, you need to configure the `input:` opt to 2 and enable
stereo mode as follows:

```
live_audio :foo, stereo: true, input: 2
```

Note that once you have started a live audio stream in stereo mode, you
cannot change it to mono without stopping and starting. Similarly, if
you start it in the default mono mode, you can't switch to stereo
without starting and stopping the stream.
