#ifndef __XSCOM_P10_REGS_H__
#define __XSCOM_P10_REGS_H__

/* Core FIR (Fault Isolation Register) */
#define P10_CORE_FIR		0x440

#define P10_CORE_FIRMASK_OR	0x445

/* Core WOF (Whose On First) */
#define P10_CORE_WOF		0x448

#define P10_MALFUNC_ALERT	0x00090022

#define P10_NX_STATUS_REG	0x02011040 /* NX status register */
#define P10_NX_DMA_ENGINE_FIR	0x02011100 /* DMA & Engine FIR Data Register */
#define P10_NX_PBI_FIR		0x02011080 /* PowerBus Interface FIR Register */

/* pMisc Receive Malfunction Alert Register */
#define P10_MALFUNC_ALERT	0x00090022

#define P10_EC_CORE_THREAD_STATE	0x412 /* XXX P10 is this right? */
#define P10_THREAD_STOPPED(t)		PPC_BIT(56 + (t))

#define P10_EC_THREAD_INFO		0x413
#define P10_THREAD_ACTIVE(t)		PPC_BIT(t)

#define P10_EC_RAS_STATUS		0x454
#define P10_THREAD_MAINT(t)		PPC_BIT(0 + 8*(t))
#define P10_THREAD_QUIESCED(t)		PPC_BIT(1 + 8*(t))
#define P10_THREAD_ICT_EMPTY(t)		PPC_BIT(2 + 8*(t))

#define P10_EC_DIRECT_CONTROLS		0x449
#define P10_THREAD_STOP(t)		PPC_BIT(7 + 8*(t))
#define P10_THREAD_START(t)		PPC_BIT(6 + 8*(t))
#define P10_THREAD_SRESET(t)		PPC_BIT(4 + 8*(t))
#define P10_THREAD_CLEAR_MAINT(t)	PPC_BIT(3 + 8*(t))
#define P10_THREAD_PWR(t)		PPC_BIT(32 + 8*(t))

#define P10_QME_FIR			0x000

#define P10_QME_SPWU_HYP		0x83c
#define P10_SPWU_REQ			PPC_BIT(0)
#define P10_SPWU_DONE			PPC_BIT(4)

#define P10_QME_SSH_HYP			0x82c
#define P10_SSH_CORE_GATED		PPC_BIT(0)
#define P10_SSH_SPWU_DONE		PPC_BIT(1)

#define P10_NCU_STATUS_REG		0x64f
#define P10_NCU_SPEC_BAR		0x650
#define   P10_NCU_SPEC_BAR_ENABLE	PPC_BIT(0)
#define   P10_NCU_SPEC_BAR_256K		PPC_BIT(1)
#define   P10_NCU_SPEC_BAR_ADDRMSK	0x000fffffffffc000ull /* 16k aligned */

#define P10_NCU_DARN_BAR		0x651
#define  P10_NCU_DARN_BAR_EN		PPC_BIT(0)
#define  P10_NCU_DARN_BAR_ADDRMSK	0x000ffffffffff000ull /* 4k aligned */

#define P10_ROOT_CONTROL_7		0x50017

/* PB DLL Configuration Registers */
#define P10_OB_ODL(ob)				(0x18011000 + (ob) * 0x1000000)

#define P10_OB_ODL_PHY_CONFIG(ob)		(P10_OB_ODL(ob) + 0x0C)
#define  P10_OB_ODL_PHY_CONFIG_LINK_SELECT	PPC_BITMASK(56, 57)
#define  P10_OB_ODL_PHY_CONFIG_DL_SELECT	PPC_BITMASK(62, 63)

#define P10_OB_ODL_PERF_MON_CONFIG(ob)		(P10_OB_ODL(ob) + 0x1C)
#define   P10_OB_ODL_PERF_MON_CONFIG_ENABLE	PPC_BITMASK(0, 1)
#define   P10_OB_ODL_PERF_MON_CONFIG_LINK0	0b10
#define   P10_OB_ODL_PERF_MON_CONFIG_LINK1	0b01
#define   P10_OB_ODL_PERF_MON_CONFIG_SIZE	PPC_BITMASK(16, 23)
#define   P10_OB_ODL_PERF_MON_CONFIG_SIZE16	0xFF

#define P10_OB_ODL_PERF_MON_SELECT(ob)		(P10_OB_ODL(ob) + 0x1D)
#define   P10_OB_ODL_PERF_MON_SELECT_COUNTER	PPC_BITMASK(0, 7)
#define   P10_OB_ODL_PERF_MON_SELECT_CRC_ODL	0x44
#define   P10_OB_ODL_PERF_MON_SELECT_CRC_DLX	0x45

#define P10_OB_PERF_COUNTER0(ob)		(P10_OB_ODL(ob) + 0x1E)
#define   P10_OB_PERF_COUNTER0_LOW		PPC_BITMASK(0, 31)
#define   P10_OB_PERF_COUNTER0_HIGH		PPC_BITMASK(32, 63)

#define P10_OB_ODL_CONFIG(ob, brk)		(P10_OB_ODL(ob) + 0x2A + brk)
#define   P10_OB_ODL_CONFIG_RESET		PPC_BIT(0)
#define   P10_OB_ODL_CONFIG_VERSION		PPC_BITMASK(2, 7)
#define   P10_OB_ODL_CONFIG_TRAIN_MODE		PPC_BITMASK(8, 11)
#define   P10_OB_ODL_CONFIG_SUPPORTED_MODES	PPC_BITMASK(12, 15)
#define   P10_OB_ODL_CONFIG_X4_BACKOFF_ENABLE	PPC_BIT(16)
#define   P10_OB_ODL_CONFIG_PHY_CNTR_LIMIT	PPC_BITMASK(20, 23)
#define   P10_OB_ODL_CONFIG_DEBUG_ENABLE	PPC_BIT(33)
#define   P10_OB_ODL_CONFIG_FWD_PROGRESS_TIMER	PPC_BITMASK(40, 43)

#define P10_OB_ODL_STATUS(ob, brk)		(P10_OB_ODL(ob) + 0x2C + brk)
#define   P10_OB_ODL_STATUS_TRAINED_MODE	PPC_BITMASK(0, 3)
#define   P10_OB_ODL_STATUS_RX_TRAINED_LANES	PPC_BITMASK(16, 23)
#define   P10_OB_ODL_STATUS_TX_TRAINED_LANES	PPC_BITMASK(24, 31)
#define   P10_OB_ODL_STATUS_TRAINING_STATE	PPC_BITMASK(49, 51)

#define P10_OB_ODL_TRAIN_STAT(ob, brk)		(P10_OB_ODL(ob) + 0x2E + brk)
#define   P10_OB_ODL_TRAIN_STAT_PATTERN_B	PPC_BITMASK(8, 15)

#define P10_OB_ODL_DLX_INFO(ob, brk)		(P10_OB_ODL(ob) + 0x32 + brk)

#define P10_OB_ODL_LINK_SPEED_STATUS(ob, brk)	(P10_OB_ODL(ob) + 0x34 + brk)

#endif /* __XSCOM_P10_REGS_H__ */
