# Generated by Django 2.0 on 2018-03-05 22:21

from django.conf import settings
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('waffle', '0002_auto_20161201_0958'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='flag',
            options={'verbose_name': 'Flag', 'verbose_name_plural': 'Flags'},
        ),
        migrations.AlterModelOptions(
            name='sample',
            options={'verbose_name': 'Sample', 'verbose_name_plural': 'Samples'},
        ),
        migrations.AlterModelOptions(
            name='switch',
            options={'verbose_name': 'Switch', 'verbose_name_plural': 'Switches'},
        ),
        migrations.AlterField(
            model_name='flag',
            name='authenticated',
            field=models.BooleanField(default=False, help_text='Flag always active for authenticated users?', verbose_name='Authenticated'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='created',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now, help_text='Date when this Flag was created.', verbose_name='Created'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='everyone',
            field=models.NullBooleanField(help_text='Flip this flag on (Yes) or off (No) for everyone, overriding all other settings. Leave as Unknown to use normally.', verbose_name='Everyone'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='Activate this flag for these user groups.', to='auth.Group', verbose_name='Groups'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='languages',
            field=models.TextField(blank=True, default='', help_text='Activate this flag for users with one of these languages (comma-separated list)', verbose_name='Languages'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='modified',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text='Date when this Flag was last modified.', verbose_name='Modified'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='name',
            field=models.CharField(help_text='The human/computer readable name.', max_length=100, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='note',
            field=models.TextField(blank=True, help_text='Note where this Flag is used.', verbose_name='Note'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='percent',
            field=models.DecimalField(blank=True, decimal_places=1, help_text='A number between 0.0 and 99.9 to indicate a percentage of users for whom this flag will be active.', max_digits=3, null=True, verbose_name='Percent'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='rollout',
            field=models.BooleanField(default=False, help_text='Activate roll-out mode?', verbose_name='Rollout'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='staff',
            field=models.BooleanField(default=False, help_text='Flag always active for staff?', verbose_name='Staff'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='superusers',
            field=models.BooleanField(default=True, help_text='Flag always active for superusers?', verbose_name='Superusers'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='testing',
            field=models.BooleanField(default=False, help_text='Allow this flag to be set for a session for user testing', verbose_name='Testing'),
        ),
        migrations.AlterField(
            model_name='flag',
            name='users',
            field=models.ManyToManyField(blank=True, help_text='Activate this flag for these users.', to=settings.AUTH_USER_MODEL, verbose_name='Users'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='created',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now, help_text='Date when this Sample was created.', verbose_name='Created'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='modified',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text='Date when this Sample was last modified.', verbose_name='Modified'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='name',
            field=models.CharField(help_text='The human/computer readable name.', max_length=100, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='note',
            field=models.TextField(blank=True, help_text='Note where this Sample is used.', verbose_name='Note'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='percent',
            field=models.DecimalField(decimal_places=1, help_text='A number between 0.0 and 100.0 to indicate a percentage of the time this sample will be active.', max_digits=4, verbose_name='Percent'),
        ),
        migrations.AlterField(
            model_name='switch',
            name='active',
            field=models.BooleanField(default=False, help_text='Is this switch active?', verbose_name='Active'),
        ),
        migrations.AlterField(
            model_name='switch',
            name='created',
            field=models.DateTimeField(db_index=True, default=django.utils.timezone.now, help_text='Date when this Switch was created.', verbose_name='Created'),
        ),
        migrations.AlterField(
            model_name='switch',
            name='modified',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text='Date when this Switch was last modified.', verbose_name='Modified'),
        ),
        migrations.AlterField(
            model_name='switch',
            name='name',
            field=models.CharField(help_text='The human/computer readable name.', max_length=100, unique=True, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='switch',
            name='note',
            field=models.TextField(blank=True, help_text='Note where this Switch is used.', verbose_name='Note'),
        ),
    ]
