# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class KikChannelProperties(Model):
    """The parameters to provide for the Kik channel.

    All required parameters must be populated in order to send to Azure.

    :param user_name: Required. The Kik user name
    :type user_name: str
    :param api_key: Required. Kik API key. Value only returned through POST to
     the action Channel List API, otherwise empty.
    :type api_key: str
    :param is_validated: Whether this channel is validated for the bot
    :type is_validated: bool
    :param is_enabled: Required. Whether this channel is enabled for the bot
    :type is_enabled: bool
    """

    _validation = {
        'user_name': {'required': True},
        'api_key': {'required': True},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'api_key': {'key': 'apiKey', 'type': 'str'},
        'is_validated': {'key': 'isValidated', 'type': 'bool'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(self, *, user_name: str, api_key: str, is_enabled: bool, is_validated: bool=None, **kwargs) -> None:
        super(KikChannelProperties, self).__init__(**kwargs)
        self.user_name = user_name
        self.api_key = api_key
        self.is_validated = is_validated
        self.is_enabled = is_enabled
