# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AddressDetails(msrest.serialization.Model):
    """Address details.

    All required parameters must be populated in order to send to Azure.

    :param first_name: First name.
    :type first_name: str
    :param last_name: Last name.
    :type last_name: str
    :param company_name: Company name.
    :type company_name: str
    :param address_line1: Required. Address line 1.
    :type address_line1: str
    :param address_line2: Address line 2.
    :type address_line2: str
    :param address_line3: Address line 3.
    :type address_line3: str
    :param city: Address city.
    :type city: str
    :param district: Address district.
    :type district: str
    :param region: Address region.
    :type region: str
    :param country: Required. Country code uses ISO2, 2-digit format.
    :type country: str
    :param postal_code: Postal code.
    :type postal_code: str
    :param email: Email address.
    :type email: str
    :param phone_number: Phone number.
    :type phone_number: str
    """

    _validation = {
        'address_line1': {'required': True},
        'country': {'required': True},
    }

    _attribute_map = {
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
        'company_name': {'key': 'companyName', 'type': 'str'},
        'address_line1': {'key': 'addressLine1', 'type': 'str'},
        'address_line2': {'key': 'addressLine2', 'type': 'str'},
        'address_line3': {'key': 'addressLine3', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'district': {'key': 'district', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'phone_number': {'key': 'phoneNumber', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressDetails, self).__init__(**kwargs)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)
        self.company_name = kwargs.get('company_name', None)
        self.address_line1 = kwargs['address_line1']
        self.address_line2 = kwargs.get('address_line2', None)
        self.address_line3 = kwargs.get('address_line3', None)
        self.city = kwargs.get('city', None)
        self.district = kwargs.get('district', None)
        self.region = kwargs.get('region', None)
        self.country = kwargs['country']
        self.postal_code = kwargs.get('postal_code', None)
        self.email = kwargs.get('email', None)
        self.phone_number = kwargs.get('phone_number', None)


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Agreement(Resource):
    """An agreement.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar agreement_link: The URL to download the agreement.
    :vartype agreement_link: str
    :ivar category: The category of the agreement signed by a customer. Possible values include:
     "MicrosoftCustomerAgreement", "AffiliatePurchaseTerms", "Other".
    :vartype category: str or ~azure.mgmt.billing.models.Category
    :ivar acceptance_mode: The mode of acceptance for an agreement. Possible values include:
     "ClickToAccept", "ESignEmbedded", "ESignOffline".
    :vartype acceptance_mode: str or ~azure.mgmt.billing.models.AcceptanceMode
    :ivar effective_date: The date from which the agreement is effective.
    :vartype effective_date: ~datetime.datetime
    :ivar expiration_date: The date when the agreement expires.
    :vartype expiration_date: ~datetime.datetime
    :param participants: The list of participants that participates in acceptance of an agreement.
    :type participants: list[~azure.mgmt.billing.models.Participants]
    :ivar status: The current status of the agreement.
    :vartype status: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'agreement_link': {'readonly': True},
        'category': {'readonly': True},
        'acceptance_mode': {'readonly': True},
        'effective_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'agreement_link': {'key': 'properties.agreementLink', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'acceptance_mode': {'key': 'properties.acceptanceMode', 'type': 'str'},
        'effective_date': {'key': 'properties.effectiveDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'participants': {'key': 'properties.participants', 'type': '[Participants]'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Agreement, self).__init__(**kwargs)
        self.agreement_link = None
        self.category = None
        self.acceptance_mode = None
        self.effective_date = None
        self.expiration_date = None
        self.participants = kwargs.get('participants', None)
        self.status = None


class AgreementListResult(msrest.serialization.Model):
    """Result of listing agreements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of agreements.
    :vartype value: list[~azure.mgmt.billing.models.Agreement]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Agreement]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgreementListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Amount(msrest.serialization.Model):
    """The amount.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar currency: The currency for the amount value.
    :vartype currency: str
    :param value: Amount value.
    :type value: float
    """

    _validation = {
        'currency': {'readonly': True},
    }

    _attribute_map = {
        'currency': {'key': 'currency', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Amount, self).__init__(**kwargs)
        self.currency = None
        self.value = kwargs.get('value', None)


class AvailableBalance(Resource):
    """The latest Azure credit balance. This is the balance available for pay now.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar amount: Balance amount.
    :vartype amount: ~azure.mgmt.billing.models.Amount
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'amount': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'amount': {'key': 'properties.amount', 'type': 'Amount'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableBalance, self).__init__(**kwargs)
        self.amount = None


class AzurePlan(msrest.serialization.Model):
    """Details of the Azure plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param sku_id: The sku id.
    :type sku_id: str
    :ivar sku_description: The sku description.
    :vartype sku_description: str
    """

    _validation = {
        'sku_description': {'readonly': True},
    }

    _attribute_map = {
        'sku_id': {'key': 'skuId', 'type': 'str'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzurePlan, self).__init__(**kwargs)
        self.sku_id = kwargs.get('sku_id', None)
        self.sku_description = None


class BillingAccount(Resource):
    """A billing account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: The billing account name.
    :type display_name: str
    :param sold_to: The address of the individual or organization that is responsible for the
     billing account.
    :type sold_to: ~azure.mgmt.billing.models.AddressDetails
    :ivar agreement_type: The type of agreement. Possible values include:
     "MicrosoftCustomerAgreement", "EnterpriseAgreement", "MicrosoftOnlineServicesProgram",
     "MicrosoftPartnerAgreement".
    :vartype agreement_type: str or ~azure.mgmt.billing.models.AgreementType
    :ivar account_type: The type of customer. Possible values include: "Enterprise", "Individual",
     "Partner".
    :vartype account_type: str or ~azure.mgmt.billing.models.AccountType
    :ivar account_status: The current status of the billing account. Possible values include:
     "Active", "Deleted", "Disabled", "Expired", "Transferred", "Extended", "Terminated".
    :vartype account_status: str or ~azure.mgmt.billing.models.AccountStatus
    :param billing_profiles: The billing profiles associated with the billing account. By default
     this is not populated, unless it's specified in $expand.
    :type billing_profiles: ~azure.mgmt.billing.models.BillingProfilesOnExpand
    :ivar enrollment_details: The details about the associated legacy enrollment. By default this
     is not populated, unless it's specified in $expand.
    :vartype enrollment_details: ~azure.mgmt.billing.models.Enrollment
    :param departments: The departments associated to the enrollment.
    :type departments: list[~azure.mgmt.billing.models.Department]
    :param enrollment_accounts: The accounts associated to the enrollment.
    :type enrollment_accounts: list[~azure.mgmt.billing.models.EnrollmentAccount]
    :ivar has_read_access: Indicates whether user has read access to the billing account.
    :vartype has_read_access: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'agreement_type': {'readonly': True},
        'account_type': {'readonly': True},
        'account_status': {'readonly': True},
        'enrollment_details': {'readonly': True},
        'has_read_access': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'sold_to': {'key': 'properties.soldTo', 'type': 'AddressDetails'},
        'agreement_type': {'key': 'properties.agreementType', 'type': 'str'},
        'account_type': {'key': 'properties.accountType', 'type': 'str'},
        'account_status': {'key': 'properties.accountStatus', 'type': 'str'},
        'billing_profiles': {'key': 'properties.billingProfiles', 'type': 'BillingProfilesOnExpand'},
        'enrollment_details': {'key': 'properties.enrollmentDetails', 'type': 'Enrollment'},
        'departments': {'key': 'properties.departments', 'type': '[Department]'},
        'enrollment_accounts': {'key': 'properties.enrollmentAccounts', 'type': '[EnrollmentAccount]'},
        'has_read_access': {'key': 'properties.hasReadAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingAccount, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.sold_to = kwargs.get('sold_to', None)
        self.agreement_type = None
        self.account_type = None
        self.account_status = None
        self.billing_profiles = kwargs.get('billing_profiles', None)
        self.enrollment_details = None
        self.departments = kwargs.get('departments', None)
        self.enrollment_accounts = kwargs.get('enrollment_accounts', None)
        self.has_read_access = None


class BillingAccountListResult(msrest.serialization.Model):
    """The list of billing accounts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of billing accounts.
    :vartype value: list[~azure.mgmt.billing.models.BillingAccount]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingAccountListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class BillingAccountUpdateRequest(msrest.serialization.Model):
    """The request properties of the billing account that can be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param display_name: The billing account name.
    :type display_name: str
    :param sold_to: The address of the individual or organization that is responsible for the
     billing account.
    :type sold_to: ~azure.mgmt.billing.models.AddressDetails
    :ivar agreement_type: The type of agreement. Possible values include:
     "MicrosoftCustomerAgreement", "EnterpriseAgreement", "MicrosoftOnlineServicesProgram",
     "MicrosoftPartnerAgreement".
    :vartype agreement_type: str or ~azure.mgmt.billing.models.AgreementType
    :ivar account_type: The type of customer. Possible values include: "Enterprise", "Individual",
     "Partner".
    :vartype account_type: str or ~azure.mgmt.billing.models.AccountType
    :ivar account_status: The current status of the billing account. Possible values include:
     "Active", "Deleted", "Disabled", "Expired", "Transferred", "Extended", "Terminated".
    :vartype account_status: str or ~azure.mgmt.billing.models.AccountStatus
    :param billing_profiles: The billing profiles associated with the billing account. By default
     this is not populated, unless it's specified in $expand.
    :type billing_profiles: ~azure.mgmt.billing.models.BillingProfilesOnExpand
    :ivar enrollment_details: The details about the associated legacy enrollment. By default this
     is not populated, unless it's specified in $expand.
    :vartype enrollment_details: ~azure.mgmt.billing.models.Enrollment
    :param departments: The departments associated to the enrollment.
    :type departments: list[~azure.mgmt.billing.models.Department]
    :param enrollment_accounts: The accounts associated to the enrollment.
    :type enrollment_accounts: list[~azure.mgmt.billing.models.EnrollmentAccount]
    :ivar has_read_access: Indicates whether user has read access to the billing account.
    :vartype has_read_access: bool
    """

    _validation = {
        'agreement_type': {'readonly': True},
        'account_type': {'readonly': True},
        'account_status': {'readonly': True},
        'enrollment_details': {'readonly': True},
        'has_read_access': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'sold_to': {'key': 'properties.soldTo', 'type': 'AddressDetails'},
        'agreement_type': {'key': 'properties.agreementType', 'type': 'str'},
        'account_type': {'key': 'properties.accountType', 'type': 'str'},
        'account_status': {'key': 'properties.accountStatus', 'type': 'str'},
        'billing_profiles': {'key': 'properties.billingProfiles', 'type': 'BillingProfilesOnExpand'},
        'enrollment_details': {'key': 'properties.enrollmentDetails', 'type': 'Enrollment'},
        'departments': {'key': 'properties.departments', 'type': '[Department]'},
        'enrollment_accounts': {'key': 'properties.enrollmentAccounts', 'type': '[EnrollmentAccount]'},
        'has_read_access': {'key': 'properties.hasReadAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingAccountUpdateRequest, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.sold_to = kwargs.get('sold_to', None)
        self.agreement_type = None
        self.account_type = None
        self.account_status = None
        self.billing_profiles = kwargs.get('billing_profiles', None)
        self.enrollment_details = None
        self.departments = kwargs.get('departments', None)
        self.enrollment_accounts = kwargs.get('enrollment_accounts', None)
        self.has_read_access = None


class BillingPeriod(Resource):
    """A billing period resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar billing_period_start_date: The start of the date range covered by the billing period.
    :vartype billing_period_start_date: ~datetime.date
    :ivar billing_period_end_date: The end of the date range covered by the billing period.
    :vartype billing_period_end_date: ~datetime.date
    :ivar invoice_ids: Array of invoice ids that associated with.
    :vartype invoice_ids: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'billing_period_start_date': {'readonly': True},
        'billing_period_end_date': {'readonly': True},
        'invoice_ids': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'billing_period_start_date': {'key': 'properties.billingPeriodStartDate', 'type': 'date'},
        'billing_period_end_date': {'key': 'properties.billingPeriodEndDate', 'type': 'date'},
        'invoice_ids': {'key': 'properties.invoiceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingPeriod, self).__init__(**kwargs)
        self.billing_period_start_date = None
        self.billing_period_end_date = None
        self.invoice_ids = None


class BillingPeriodsListResult(msrest.serialization.Model):
    """Result of listing billing periods. It contains a list of available billing periods in reverse chronological order.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of billing periods.
    :vartype value: list[~azure.mgmt.billing.models.BillingPeriod]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingPeriod]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingPeriodsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class BillingPermissionsListResult(msrest.serialization.Model):
    """Result of list billingPermissions a caller has on a billing account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of billingPermissions a caller has on a billing account.
    :vartype value: list[~azure.mgmt.billing.models.BillingPermissionsProperties]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingPermissionsProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingPermissionsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class BillingPermissionsProperties(msrest.serialization.Model):
    """The set of allowed action and not allowed actions a caller has on a billing account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar actions: The set of actions that the caller is allowed to perform.
    :vartype actions: list[str]
    :ivar not_actions: The set of actions that the caller is not allowed to perform.
    :vartype not_actions: list[str]
    """

    _validation = {
        'actions': {'readonly': True},
        'not_actions': {'readonly': True},
    }

    _attribute_map = {
        'actions': {'key': 'actions', 'type': '[str]'},
        'not_actions': {'key': 'notActions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingPermissionsProperties, self).__init__(**kwargs)
        self.actions = None
        self.not_actions = None


class BillingProfile(Resource):
    """A billing profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: The name of the billing profile.
    :type display_name: str
    :param po_number: The purchase order name that will appear on the invoices generated for the
     billing profile.
    :type po_number: str
    :ivar billing_relationship_type: Identifies which services and purchases are paid by a billing
     profile. Possible values include: "Direct", "IndirectCustomer", "IndirectPartner",
     "CSPPartner".
    :vartype billing_relationship_type: str or ~azure.mgmt.billing.models.BillingRelationshipType
    :param bill_to: Billing address.
    :type bill_to: ~azure.mgmt.billing.models.AddressDetails
    :ivar indirect_relationship_info: Identifies the billing profile that is linked to another
     billing profile in indirect purchase motion.
    :vartype indirect_relationship_info: ~azure.mgmt.billing.models.IndirectRelationshipInfo
    :param invoice_email_opt_in: Flag controlling whether the invoices for the billing profile are
     sent through email.
    :type invoice_email_opt_in: bool
    :ivar invoice_day: The day of the month when the invoice for the billing profile is generated.
    :vartype invoice_day: int
    :ivar currency: The currency in which the charges for the billing profile are billed.
    :vartype currency: str
    :param enabled_azure_plans: Information about the enabled azure plans.
    :type enabled_azure_plans: list[~azure.mgmt.billing.models.AzurePlan]
    :param invoice_sections: The invoice sections associated to the billing profile. By default
     this is not populated, unless it's specified in $expand.
    :type invoice_sections: ~azure.mgmt.billing.models.InvoiceSectionsOnExpand
    :ivar has_read_access: Indicates whether user has read access to the billing profile.
    :vartype has_read_access: bool
    :ivar system_id: The system generated unique identifier for a billing profile.
    :vartype system_id: str
    :ivar status: The status of the billing profile. Possible values include: "Active", "Disabled",
     "Warned".
    :vartype status: str or ~azure.mgmt.billing.models.BillingProfileStatus
    :ivar status_reason_code: Reason for the specified billing profile status. Possible values
     include: "PastDue", "SpendingLimitReached", "SpendingLimitExpired".
    :vartype status_reason_code: str or ~azure.mgmt.billing.models.StatusReasonCode
    :ivar spending_limit: The billing profile spending limit. Possible values include: "Off", "On".
    :vartype spending_limit: str or ~azure.mgmt.billing.models.SpendingLimit
    :ivar target_clouds: Identifies the cloud environments that are associated with a billing
     profile. This is a system managed optional field and gets updated as the billing profile gets
     associated with accounts in various clouds.
    :vartype target_clouds: list[str or ~azure.mgmt.billing.models.TargetCloud]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'billing_relationship_type': {'readonly': True},
        'indirect_relationship_info': {'readonly': True},
        'invoice_day': {'readonly': True},
        'currency': {'readonly': True},
        'has_read_access': {'readonly': True},
        'system_id': {'readonly': True},
        'status': {'readonly': True},
        'status_reason_code': {'readonly': True},
        'spending_limit': {'readonly': True},
        'target_clouds': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'po_number': {'key': 'properties.poNumber', 'type': 'str'},
        'billing_relationship_type': {'key': 'properties.billingRelationshipType', 'type': 'str'},
        'bill_to': {'key': 'properties.billTo', 'type': 'AddressDetails'},
        'indirect_relationship_info': {'key': 'properties.indirectRelationshipInfo', 'type': 'IndirectRelationshipInfo'},
        'invoice_email_opt_in': {'key': 'properties.invoiceEmailOptIn', 'type': 'bool'},
        'invoice_day': {'key': 'properties.invoiceDay', 'type': 'int'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'enabled_azure_plans': {'key': 'properties.enabledAzurePlans', 'type': '[AzurePlan]'},
        'invoice_sections': {'key': 'properties.invoiceSections', 'type': 'InvoiceSectionsOnExpand'},
        'has_read_access': {'key': 'properties.hasReadAccess', 'type': 'bool'},
        'system_id': {'key': 'properties.systemId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_reason_code': {'key': 'properties.statusReasonCode', 'type': 'str'},
        'spending_limit': {'key': 'properties.spendingLimit', 'type': 'str'},
        'target_clouds': {'key': 'properties.targetClouds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingProfile, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.po_number = kwargs.get('po_number', None)
        self.billing_relationship_type = None
        self.bill_to = kwargs.get('bill_to', None)
        self.indirect_relationship_info = None
        self.invoice_email_opt_in = kwargs.get('invoice_email_opt_in', None)
        self.invoice_day = None
        self.currency = None
        self.enabled_azure_plans = kwargs.get('enabled_azure_plans', None)
        self.invoice_sections = kwargs.get('invoice_sections', None)
        self.has_read_access = None
        self.system_id = None
        self.status = None
        self.status_reason_code = None
        self.spending_limit = None
        self.target_clouds = None


class BillingProfileCreationRequest(msrest.serialization.Model):
    """The request parameters for creating a new billing profile.

    :param display_name: The name of the billing profile.
    :type display_name: str
    :param po_number: The purchase order name that will appear on the invoices generated for the
     billing profile.
    :type po_number: str
    :param bill_to: The address of the individual or organization that is responsible for the
     billing profile.
    :type bill_to: ~azure.mgmt.billing.models.AddressDetails
    :param invoice_email_opt_in: Flag controlling whether the invoices for the billing profile are
     sent through email.
    :type invoice_email_opt_in: bool
    :param enabled_azure_plans: Enabled azure plans for the billing profile.
    :type enabled_azure_plans: list[~azure.mgmt.billing.models.AzurePlan]
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'po_number': {'key': 'poNumber', 'type': 'str'},
        'bill_to': {'key': 'billTo', 'type': 'AddressDetails'},
        'invoice_email_opt_in': {'key': 'invoiceEmailOptIn', 'type': 'bool'},
        'enabled_azure_plans': {'key': 'enabledAzurePlans', 'type': '[AzurePlan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingProfileCreationRequest, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.po_number = kwargs.get('po_number', None)
        self.bill_to = kwargs.get('bill_to', None)
        self.invoice_email_opt_in = kwargs.get('invoice_email_opt_in', None)
        self.enabled_azure_plans = kwargs.get('enabled_azure_plans', None)


class BillingProfileListResult(msrest.serialization.Model):
    """The list of billing profiles.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of billing profiles.
    :vartype value: list[~azure.mgmt.billing.models.BillingProfile]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingProfile]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingProfileListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class BillingProfilesOnExpand(msrest.serialization.Model):
    """The billing profiles associated with the billing account. By default this is not populated, unless it's specified in $expand.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar has_more_results: Indicates whether there are more billing profiles than the ones listed
     in this collection. The collection lists a maximum of 50 billing profiles. To get all billing
     profiles, use the list billing profiles API.
    :vartype has_more_results: bool
    :param value: The billing profiles associated with the billing account.
    :type value: list[~azure.mgmt.billing.models.BillingProfile]
    """

    _validation = {
        'has_more_results': {'readonly': True},
    }

    _attribute_map = {
        'has_more_results': {'key': 'hasMoreResults', 'type': 'bool'},
        'value': {'key': 'value', 'type': '[BillingProfile]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingProfilesOnExpand, self).__init__(**kwargs)
        self.has_more_results = None
        self.value = kwargs.get('value', None)


class BillingProperty(Resource):
    """A billing property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar account_admin_notification_email_address: The email address on which the account admin
     gets all Azure notifications.
    :vartype account_admin_notification_email_address: str
    :ivar billing_tenant_id: The Azure AD tenant ID of the billing account for the subscription.
    :vartype billing_tenant_id: str
    :ivar billing_account_id: The ID of the billing account to which the subscription is billed.
    :vartype billing_account_id: str
    :ivar billing_account_display_name: The name of the billing account to which the subscription
     is billed.
    :vartype billing_account_display_name: str
    :ivar billing_profile_id: The ID of the billing profile to which the subscription is billed.
    :vartype billing_profile_id: str
    :ivar billing_profile_display_name: The name of the billing profile to which the subscription
     is billed.
    :vartype billing_profile_display_name: str
    :ivar billing_profile_status: The status of the billing profile. Possible values include:
     "Active", "Disabled", "Warned".
    :vartype billing_profile_status: str or ~azure.mgmt.billing.models.BillingProfileStatus
    :ivar billing_profile_status_reason_code: Reason for the specified billing profile status.
     Possible values include: "PastDue", "SpendingLimitReached", "SpendingLimitExpired".
    :vartype billing_profile_status_reason_code: str or
     ~azure.mgmt.billing.models.BillingProfileStatusReasonCode
    :ivar billing_profile_spending_limit: The billing profile spending limit. Possible values
     include: "Off", "On".
    :vartype billing_profile_spending_limit: str or
     ~azure.mgmt.billing.models.BillingProfileSpendingLimit
    :param cost_center: The cost center applied to the subscription.
    :type cost_center: str
    :ivar invoice_section_id: The ID of the invoice section to which the subscription is billed.
    :vartype invoice_section_id: str
    :ivar invoice_section_display_name: The name of the invoice section to which the subscription
     is billed.
    :vartype invoice_section_display_name: str
    :ivar is_account_admin: Indicates whether user is the account admin.
    :vartype is_account_admin: bool
    :ivar product_id: The product ID of the Azure plan.
    :vartype product_id: str
    :ivar product_name: The product name of the Azure plan.
    :vartype product_name: str
    :ivar sku_id: The sku ID of the Azure plan for the subscription.
    :vartype sku_id: str
    :ivar sku_description: The sku description of the Azure plan for the subscription.
    :vartype sku_description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'account_admin_notification_email_address': {'readonly': True},
        'billing_tenant_id': {'readonly': True},
        'billing_account_id': {'readonly': True},
        'billing_account_display_name': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_display_name': {'readonly': True},
        'billing_profile_status': {'readonly': True},
        'billing_profile_status_reason_code': {'readonly': True},
        'billing_profile_spending_limit': {'readonly': True},
        'invoice_section_id': {'readonly': True},
        'invoice_section_display_name': {'readonly': True},
        'is_account_admin': {'readonly': True},
        'product_id': {'readonly': True},
        'product_name': {'readonly': True},
        'sku_id': {'readonly': True},
        'sku_description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'account_admin_notification_email_address': {'key': 'properties.accountAdminNotificationEmailAddress', 'type': 'str'},
        'billing_tenant_id': {'key': 'properties.billingTenantId', 'type': 'str'},
        'billing_account_id': {'key': 'properties.billingAccountId', 'type': 'str'},
        'billing_account_display_name': {'key': 'properties.billingAccountDisplayName', 'type': 'str'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_display_name': {'key': 'properties.billingProfileDisplayName', 'type': 'str'},
        'billing_profile_status': {'key': 'properties.billingProfileStatus', 'type': 'str'},
        'billing_profile_status_reason_code': {'key': 'properties.billingProfileStatusReasonCode', 'type': 'str'},
        'billing_profile_spending_limit': {'key': 'properties.billingProfileSpendingLimit', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'invoice_section_id': {'key': 'properties.invoiceSectionId', 'type': 'str'},
        'invoice_section_display_name': {'key': 'properties.invoiceSectionDisplayName', 'type': 'str'},
        'is_account_admin': {'key': 'properties.isAccountAdmin', 'type': 'bool'},
        'product_id': {'key': 'properties.productId', 'type': 'str'},
        'product_name': {'key': 'properties.productName', 'type': 'str'},
        'sku_id': {'key': 'properties.skuId', 'type': 'str'},
        'sku_description': {'key': 'properties.skuDescription', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingProperty, self).__init__(**kwargs)
        self.account_admin_notification_email_address = None
        self.billing_tenant_id = None
        self.billing_account_id = None
        self.billing_account_display_name = None
        self.billing_profile_id = None
        self.billing_profile_display_name = None
        self.billing_profile_status = None
        self.billing_profile_status_reason_code = None
        self.billing_profile_spending_limit = None
        self.cost_center = kwargs.get('cost_center', None)
        self.invoice_section_id = None
        self.invoice_section_display_name = None
        self.is_account_admin = None
        self.product_id = None
        self.product_name = None
        self.sku_id = None
        self.sku_description = None


class BillingRoleAssignment(Resource):
    """The role assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar created_on: The date the role assignment was created.
    :vartype created_on: str
    :ivar created_by_principal_tenant_id: The tenant Id of the user who created the role
     assignment.
    :vartype created_by_principal_tenant_id: str
    :ivar created_by_principal_id: The principal Id of the user who created the role assignment.
    :vartype created_by_principal_id: str
    :ivar created_by_user_email_address: The email address of the user who created the role
     assignment.
    :vartype created_by_user_email_address: str
    :param principal_id: The principal id of the user to whom the role was assigned.
    :type principal_id: str
    :param principal_tenant_id: The principal tenant id of the user to whom the role was assigned.
    :type principal_tenant_id: str
    :param role_definition_id: The ID of the role definition.
    :type role_definition_id: str
    :ivar scope: The scope at which the role was assigned.
    :vartype scope: str
    :param user_authentication_type: The authentication type.
    :type user_authentication_type: str
    :param user_email_address: The email address of the user.
    :type user_email_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_on': {'readonly': True},
        'created_by_principal_tenant_id': {'readonly': True},
        'created_by_principal_id': {'readonly': True},
        'created_by_user_email_address': {'readonly': True},
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'str'},
        'created_by_principal_tenant_id': {'key': 'properties.createdByPrincipalTenantId', 'type': 'str'},
        'created_by_principal_id': {'key': 'properties.createdByPrincipalId', 'type': 'str'},
        'created_by_user_email_address': {'key': 'properties.createdByUserEmailAddress', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_tenant_id': {'key': 'properties.principalTenantId', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'user_authentication_type': {'key': 'properties.userAuthenticationType', 'type': 'str'},
        'user_email_address': {'key': 'properties.userEmailAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingRoleAssignment, self).__init__(**kwargs)
        self.created_on = None
        self.created_by_principal_tenant_id = None
        self.created_by_principal_id = None
        self.created_by_user_email_address = None
        self.principal_id = kwargs.get('principal_id', None)
        self.principal_tenant_id = kwargs.get('principal_tenant_id', None)
        self.role_definition_id = kwargs.get('role_definition_id', None)
        self.scope = None
        self.user_authentication_type = kwargs.get('user_authentication_type', None)
        self.user_email_address = kwargs.get('user_email_address', None)


class BillingRoleAssignmentListResult(msrest.serialization.Model):
    """The list of role assignments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of role assignments.
    :vartype value: list[~azure.mgmt.billing.models.BillingRoleAssignment]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingRoleAssignment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingRoleAssignmentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class BillingRoleDefinition(Resource):
    """The properties of a role definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: The role description.
    :vartype description: str
    :param permissions: The billingPermissions the role has.
    :type permissions: list[~azure.mgmt.billing.models.BillingPermissionsProperties]
    :ivar role_name: The name of the role.
    :vartype role_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'role_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'permissions': {'key': 'properties.permissions', 'type': '[BillingPermissionsProperties]'},
        'role_name': {'key': 'properties.roleName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingRoleDefinition, self).__init__(**kwargs)
        self.description = None
        self.permissions = kwargs.get('permissions', None)
        self.role_name = None


class BillingRoleDefinitionListResult(msrest.serialization.Model):
    """The list of role definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The role definitions.
    :vartype value: list[~azure.mgmt.billing.models.BillingRoleDefinition]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingRoleDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingRoleDefinitionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class BillingSubscription(Resource):
    """A billing subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: The name of the subscription.
    :vartype display_name: str
    :ivar subscription_id: The ID of the subscription.
    :vartype subscription_id: str
    :param subscription_billing_status: The current billing status of the subscription. Possible
     values include: "Active", "Inactive", "Abandoned", "Deleted", "Warning".
    :type subscription_billing_status: str or
     ~azure.mgmt.billing.models.BillingSubscriptionStatusType
    :ivar last_month_charges: The last month charges.
    :vartype last_month_charges: ~azure.mgmt.billing.models.Amount
    :ivar month_to_date_charges: The current month to date charges.
    :vartype month_to_date_charges: ~azure.mgmt.billing.models.Amount
    :ivar billing_profile_id: The ID of the billing profile to which the subscription is billed.
    :vartype billing_profile_id: str
    :ivar billing_profile_display_name: The name of the billing profile to which the subscription
     is billed.
    :vartype billing_profile_display_name: str
    :param cost_center: The cost center applied to the subscription.
    :type cost_center: str
    :ivar customer_id: The ID of the customer for whom the subscription was created. The field is
     applicable only for Microsoft Partner Agreement billing account.
    :vartype customer_id: str
    :ivar customer_display_name: The name of the customer for whom the subscription was created.
     The field is applicable only for Microsoft Partner Agreement billing account.
    :vartype customer_display_name: str
    :ivar invoice_section_id: The ID of the invoice section to which the subscription is billed.
    :vartype invoice_section_id: str
    :ivar invoice_section_display_name: The name of the invoice section to which the subscription
     is billed.
    :vartype invoice_section_display_name: str
    :ivar reseller: Reseller for this subscription.
    :vartype reseller: ~azure.mgmt.billing.models.Reseller
    :param sku_id: The sku ID of the Azure plan for the subscription.
    :type sku_id: str
    :ivar sku_description: The sku description of the Azure plan for the subscription.
    :vartype sku_description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'subscription_id': {'readonly': True},
        'last_month_charges': {'readonly': True},
        'month_to_date_charges': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_display_name': {'readonly': True},
        'customer_id': {'readonly': True},
        'customer_display_name': {'readonly': True},
        'invoice_section_id': {'readonly': True},
        'invoice_section_display_name': {'readonly': True},
        'reseller': {'readonly': True},
        'sku_description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'subscription_billing_status': {'key': 'properties.subscriptionBillingStatus', 'type': 'str'},
        'last_month_charges': {'key': 'properties.lastMonthCharges', 'type': 'Amount'},
        'month_to_date_charges': {'key': 'properties.monthToDateCharges', 'type': 'Amount'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_display_name': {'key': 'properties.billingProfileDisplayName', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'customer_display_name': {'key': 'properties.customerDisplayName', 'type': 'str'},
        'invoice_section_id': {'key': 'properties.invoiceSectionId', 'type': 'str'},
        'invoice_section_display_name': {'key': 'properties.invoiceSectionDisplayName', 'type': 'str'},
        'reseller': {'key': 'properties.reseller', 'type': 'Reseller'},
        'sku_id': {'key': 'properties.skuId', 'type': 'str'},
        'sku_description': {'key': 'properties.skuDescription', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingSubscription, self).__init__(**kwargs)
        self.display_name = None
        self.subscription_id = None
        self.subscription_billing_status = kwargs.get('subscription_billing_status', None)
        self.last_month_charges = None
        self.month_to_date_charges = None
        self.billing_profile_id = None
        self.billing_profile_display_name = None
        self.cost_center = kwargs.get('cost_center', None)
        self.customer_id = None
        self.customer_display_name = None
        self.invoice_section_id = None
        self.invoice_section_display_name = None
        self.reseller = None
        self.sku_id = kwargs.get('sku_id', None)
        self.sku_description = None


class BillingSubscriptionsListResult(msrest.serialization.Model):
    """The list of billing subscriptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of billing subscriptions.
    :vartype value: list[~azure.mgmt.billing.models.BillingSubscription]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingSubscription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingSubscriptionsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Customer(Resource):
    """A partner's customer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar billing_profile_id: The ID of the billing profile for the invoice section.
    :vartype billing_profile_id: str
    :ivar billing_profile_display_name: The name of the billing profile for the invoice section.
    :vartype billing_profile_display_name: str
    :param display_name: The name of the customer.
    :type display_name: str
    :param enabled_azure_plans: Azure plans enabled for the customer.
    :type enabled_azure_plans: list[~azure.mgmt.billing.models.AzurePlan]
    :param resellers: The list of resellers for which an Azure plan is enabled for the customer.
    :type resellers: list[~azure.mgmt.billing.models.Reseller]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_display_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_display_name': {'key': 'properties.billingProfileDisplayName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled_azure_plans': {'key': 'properties.enabledAzurePlans', 'type': '[AzurePlan]'},
        'resellers': {'key': 'properties.resellers', 'type': '[Reseller]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Customer, self).__init__(**kwargs)
        self.billing_profile_id = None
        self.billing_profile_display_name = None
        self.display_name = kwargs.get('display_name', None)
        self.enabled_azure_plans = kwargs.get('enabled_azure_plans', None)
        self.resellers = kwargs.get('resellers', None)


class CustomerListResult(msrest.serialization.Model):
    """The list of customers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of customers.
    :vartype value: list[~azure.mgmt.billing.models.Customer]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Customer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomerListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CustomerPolicy(Resource):
    """The customer's Policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param view_charges: The policy that controls whether the users in customer's organization can
     view charges at pay-as-you-go prices. Possible values include: "Allowed", "NotAllowed".
    :type view_charges: str or ~azure.mgmt.billing.models.ViewCharges
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'view_charges': {'key': 'properties.viewCharges', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomerPolicy, self).__init__(**kwargs)
        self.view_charges = kwargs.get('view_charges', None)


class Department(Resource):
    """A department.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param department_name: The name of the department.
    :type department_name: str
    :param cost_center: The cost center associated with the department.
    :type cost_center: str
    :param status: The status of the department.
    :type status: str
    :param enrollment_accounts: Associated enrollment accounts. By default this is not populated,
     unless it's specified in $expand.
    :type enrollment_accounts: list[~azure.mgmt.billing.models.EnrollmentAccount]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'department_name': {'key': 'properties.departmentName', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'enrollment_accounts': {'key': 'properties.enrollmentAccounts', 'type': '[EnrollmentAccount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Department, self).__init__(**kwargs)
        self.department_name = kwargs.get('department_name', None)
        self.cost_center = kwargs.get('cost_center', None)
        self.status = kwargs.get('status', None)
        self.enrollment_accounts = kwargs.get('enrollment_accounts', None)


class Document(msrest.serialization.Model):
    """The properties of a document.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kind: The type of the document. Possible values include: "Invoice", "VoidNote",
     "TaxReceipt", "CreditNote".
    :vartype kind: str or ~azure.mgmt.billing.models.DocumentType
    :ivar url: Document URL.
    :vartype url: str
    :ivar source: The source of the document. ENF for Brazil and DRS for rest of the world.
     Possible values include: "DRS", "ENF".
    :vartype source: str or ~azure.mgmt.billing.models.DocumentSource
    """

    _validation = {
        'kind': {'readonly': True},
        'url': {'readonly': True},
        'source': {'readonly': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Document, self).__init__(**kwargs)
        self.kind = None
        self.url = None
        self.source = None


class DownloadUrl(msrest.serialization.Model):
    """A secure URL that can be used to download a an entity until the URL expires.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiry_time: The time in UTC when the download URL will expire.
    :vartype expiry_time: ~datetime.datetime
    :ivar url: The URL to the PDF file.
    :vartype url: str
    """

    _validation = {
        'expiry_time': {'readonly': True},
        'url': {'readonly': True},
    }

    _attribute_map = {
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DownloadUrl, self).__init__(**kwargs)
        self.expiry_time = None
        self.url = None


class Enrollment(msrest.serialization.Model):
    """The properties of an enrollment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param start_date: The start date of the enrollment.
    :type start_date: ~datetime.datetime
    :param end_date: The end date of the enrollment.
    :type end_date: ~datetime.datetime
    :ivar currency: The billing currency for the enrollment.
    :vartype currency: str
    :ivar channel: The channel type of the enrollment.
    :vartype channel: str
    :ivar policies: The policies for Enterprise Agreement enrollments.
    :vartype policies: ~azure.mgmt.billing.models.EnrollmentPolicies
    :ivar language: The language for the enrollment.
    :vartype language: str
    :ivar country_code: The country code of the enrollment.
    :vartype country_code: str
    :ivar status: The current status of the enrollment.
    :vartype status: str
    :ivar billing_cycle: The billing cycle for the enrollment.
    :vartype billing_cycle: str
    """

    _validation = {
        'currency': {'readonly': True},
        'channel': {'readonly': True},
        'policies': {'readonly': True},
        'language': {'readonly': True},
        'country_code': {'readonly': True},
        'status': {'readonly': True},
        'billing_cycle': {'readonly': True},
    }

    _attribute_map = {
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
        'currency': {'key': 'currency', 'type': 'str'},
        'channel': {'key': 'channel', 'type': 'str'},
        'policies': {'key': 'policies', 'type': 'EnrollmentPolicies'},
        'language': {'key': 'language', 'type': 'str'},
        'country_code': {'key': 'countryCode', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'billing_cycle': {'key': 'billingCycle', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Enrollment, self).__init__(**kwargs)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.currency = None
        self.channel = None
        self.policies = None
        self.language = None
        self.country_code = None
        self.status = None
        self.billing_cycle = None


class EnrollmentAccount(Resource):
    """An enrollment account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param account_name: The name of the enrollment account.
    :type account_name: str
    :param cost_center: The cost center associated with the enrollment account.
    :type cost_center: str
    :param account_owner: The owner of the enrollment account.
    :type account_owner: str
    :param status: The status of the enrollment account.
    :type status: str
    :param start_date: The start date of the enrollment account.
    :type start_date: ~datetime.datetime
    :param end_date: The end date of the enrollment account.
    :type end_date: ~datetime.datetime
    :param department: Associated department. By default this is not populated, unless it's
     specified in $expand.
    :type department: ~azure.mgmt.billing.models.Department
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'account_owner': {'key': 'properties.accountOwner', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date': {'key': 'properties.startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'properties.endDate', 'type': 'iso-8601'},
        'department': {'key': 'properties.department', 'type': 'Department'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrollmentAccount, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.cost_center = kwargs.get('cost_center', None)
        self.account_owner = kwargs.get('account_owner', None)
        self.status = kwargs.get('status', None)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.department = kwargs.get('department', None)


class EnrollmentAccountContext(msrest.serialization.Model):
    """The enrollment account context.

    :param cost_center: The cost center associated with the enrollment account.
    :type cost_center: str
    :param start_date: The start date of the enrollment account.
    :type start_date: ~datetime.datetime
    :param end_date: The end date of the enrollment account.
    :type end_date: ~datetime.datetime
    :param enrollment_account_name: The ID of the enrollment account.
    :type enrollment_account_name: str
    """

    _attribute_map = {
        'cost_center': {'key': 'costCenter', 'type': 'str'},
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
        'enrollment_account_name': {'key': 'enrollmentAccountName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrollmentAccountContext, self).__init__(**kwargs)
        self.cost_center = kwargs.get('cost_center', None)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.enrollment_account_name = kwargs.get('enrollment_account_name', None)


class EnrollmentAccountListResult(msrest.serialization.Model):
    """Result of listing enrollment accounts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of enrollment accounts.
    :vartype value: list[~azure.mgmt.billing.models.EnrollmentAccountSummary]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EnrollmentAccountSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrollmentAccountListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class EnrollmentAccountSummary(Resource):
    """An enrollment account resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar principal_name: The account owner's principal name.
    :vartype principal_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'principal_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'principal_name': {'key': 'properties.principalName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrollmentAccountSummary, self).__init__(**kwargs)
        self.principal_name = None


class EnrollmentPolicies(msrest.serialization.Model):
    """The policies for Enterprise Agreement enrollments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_owner_view_charges: The policy that controls whether Account Owners can view
     charges.
    :vartype account_owner_view_charges: bool
    :ivar department_admin_view_charges: The policy that controls whether Department Administrators
     can view charges.
    :vartype department_admin_view_charges: bool
    :ivar marketplaces_enabled: The policy that controls whether Azure marketplace purchases are
     allowed in the enrollment.
    :vartype marketplaces_enabled: bool
    :ivar reserved_instances_enabled: The policy that controls whether Azure reservation purchases
     are allowed in the enrollment.
    :vartype reserved_instances_enabled: bool
    """

    _validation = {
        'account_owner_view_charges': {'readonly': True},
        'department_admin_view_charges': {'readonly': True},
        'marketplaces_enabled': {'readonly': True},
        'reserved_instances_enabled': {'readonly': True},
    }

    _attribute_map = {
        'account_owner_view_charges': {'key': 'accountOwnerViewCharges', 'type': 'bool'},
        'department_admin_view_charges': {'key': 'departmentAdminViewCharges', 'type': 'bool'},
        'marketplaces_enabled': {'key': 'marketplacesEnabled', 'type': 'bool'},
        'reserved_instances_enabled': {'key': 'reservedInstancesEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrollmentPolicies, self).__init__(**kwargs)
        self.account_owner_view_charges = None
        self.department_admin_view_charges = None
        self.marketplaces_enabled = None
        self.reserved_instances_enabled = None


class ErrorDetails(msrest.serialization.Model):
    """The details of the error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar details: The sub details of the error.
    :vartype details: list[~azure.mgmt.billing.models.ErrorSubDetailsItem]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorSubDetailsItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The reason is provided in the error message.

    :param error: The details of the error.
    :type error: ~azure.mgmt.billing.models.ErrorDetails
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorSubDetailsItem(msrest.serialization.Model):
    """ErrorSubDetailsItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorSubDetailsItem, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class IndirectRelationshipInfo(msrest.serialization.Model):
    """The billing profile details of the partner of the customer for an indirect motion.

    :param billing_account_name: The billing account name of the partner or the customer for an
     indirect motion.
    :type billing_account_name: str
    :param billing_profile_name: The billing profile name of the partner or the customer for an
     indirect motion.
    :type billing_profile_name: str
    :param display_name: The display name of the partner or customer for an indirect motion.
    :type display_name: str
    """

    _attribute_map = {
        'billing_account_name': {'key': 'billingAccountName', 'type': 'str'},
        'billing_profile_name': {'key': 'billingProfileName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndirectRelationshipInfo, self).__init__(**kwargs)
        self.billing_account_name = kwargs.get('billing_account_name', None)
        self.billing_profile_name = kwargs.get('billing_profile_name', None)
        self.display_name = kwargs.get('display_name', None)


class Instruction(Resource):
    """An instruction.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param amount: The amount budgeted for this billing instruction.
    :type amount: float
    :param start_date: The date this billing instruction goes into effect.
    :type start_date: ~datetime.datetime
    :param end_date: The date this billing instruction is no longer in effect.
    :type end_date: ~datetime.datetime
    :param creation_date: The date this billing instruction was created.
    :type creation_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'amount': {'key': 'properties.amount', 'type': 'float'},
        'start_date': {'key': 'properties.startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'properties.endDate', 'type': 'iso-8601'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Instruction, self).__init__(**kwargs)
        self.amount = kwargs.get('amount', None)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.creation_date = kwargs.get('creation_date', None)


class InstructionListResult(msrest.serialization.Model):
    """The list of billing instructions used during invoice generation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of billing instructions used during invoice generation.
    :vartype value: list[~azure.mgmt.billing.models.Instruction]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Instruction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstructionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Invoice(Resource):
    """An invoice.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar due_date: The due date for the invoice.
    :vartype due_date: ~datetime.datetime
    :ivar invoice_date: The date when the invoice was generated.
    :vartype invoice_date: ~datetime.datetime
    :ivar status: The current status of the invoice. Possible values include: "Due", "OverDue",
     "Paid", "Void".
    :vartype status: str or ~azure.mgmt.billing.models.InvoiceStatus
    :ivar amount_due: The amount due as of now.
    :vartype amount_due: ~azure.mgmt.billing.models.Amount
    :ivar azure_prepayment_applied: The amount of Azure prepayment applied to the charges. This
     field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
    :vartype azure_prepayment_applied: ~azure.mgmt.billing.models.Amount
    :ivar billed_amount: The total charges for the invoice billing period.
    :vartype billed_amount: ~azure.mgmt.billing.models.Amount
    :ivar credit_amount: The total refund for returns and cancellations during the invoice billing
     period. This field is applicable to billing accounts with agreement type Microsoft Customer
     Agreement.
    :vartype credit_amount: ~azure.mgmt.billing.models.Amount
    :ivar free_azure_credit_applied: The amount of free Azure credits applied to the charges. This
     field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
    :vartype free_azure_credit_applied: ~azure.mgmt.billing.models.Amount
    :ivar sub_total: The pre-tax amount due. This field is applicable to billing accounts with
     agreement type Microsoft Customer Agreement.
    :vartype sub_total: ~azure.mgmt.billing.models.Amount
    :ivar tax_amount: The amount of tax charged for the billing period. This field is applicable to
     billing accounts with agreement type Microsoft Customer Agreement.
    :vartype tax_amount: ~azure.mgmt.billing.models.Amount
    :ivar total_amount: The amount due when the invoice was generated. This field is applicable to
     billing accounts with agreement type Microsoft Customer Agreement.
    :vartype total_amount: ~azure.mgmt.billing.models.Amount
    :ivar invoice_period_start_date: The start date of the billing period for which the invoice is
     generated.
    :vartype invoice_period_start_date: ~datetime.datetime
    :ivar invoice_period_end_date: The end date of the billing period for which the invoice is
     generated.
    :vartype invoice_period_end_date: ~datetime.datetime
    :ivar invoice_type: Invoice type. Possible values include: "AzureService", "AzureMarketplace",
     "AzureSupport".
    :vartype invoice_type: str or ~azure.mgmt.billing.models.InvoiceType
    :ivar is_monthly_invoice: Specifies if the invoice is generated as part of monthly invoicing
     cycle or not. This field is applicable to billing accounts with agreement type Microsoft
     Customer Agreement.
    :vartype is_monthly_invoice: bool
    :ivar billing_profile_id: The ID of the billing profile for which the invoice is generated.
    :vartype billing_profile_id: str
    :ivar billing_profile_display_name: The name of the billing profile for which the invoice is
     generated.
    :vartype billing_profile_display_name: str
    :ivar purchase_order_number: An optional purchase order number for the invoice.
    :vartype purchase_order_number: str
    :ivar documents: List of documents available to download such as invoice and tax receipt.
    :vartype documents: list[~azure.mgmt.billing.models.Document]
    :ivar payments: List of payments.
    :vartype payments: list[~azure.mgmt.billing.models.PaymentProperties]
    :ivar rebill_details: Rebill details for an invoice.
    :vartype rebill_details: dict[str, ~azure.mgmt.billing.models.RebillDetails]
    :ivar document_type: The type of the document. Possible values include: "Invoice",
     "CreditNote".
    :vartype document_type: str or ~azure.mgmt.billing.models.InvoiceDocumentType
    :ivar billed_document_id: The Id of the active invoice which is originally billed after this
     invoice was voided. This field is applicable to the void invoices only.
    :vartype billed_document_id: str
    :ivar credit_for_document_id: The Id of the invoice which got voided and this credit note was
     issued as a result. This field is applicable to the credit notes only.
    :vartype credit_for_document_id: str
    :ivar subscription_id: The ID of the subscription for which the invoice is generated.
    :vartype subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'due_date': {'readonly': True},
        'invoice_date': {'readonly': True},
        'status': {'readonly': True},
        'amount_due': {'readonly': True},
        'azure_prepayment_applied': {'readonly': True},
        'billed_amount': {'readonly': True},
        'credit_amount': {'readonly': True},
        'free_azure_credit_applied': {'readonly': True},
        'sub_total': {'readonly': True},
        'tax_amount': {'readonly': True},
        'total_amount': {'readonly': True},
        'invoice_period_start_date': {'readonly': True},
        'invoice_period_end_date': {'readonly': True},
        'invoice_type': {'readonly': True},
        'is_monthly_invoice': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_display_name': {'readonly': True},
        'purchase_order_number': {'readonly': True},
        'documents': {'readonly': True},
        'payments': {'readonly': True},
        'rebill_details': {'readonly': True},
        'document_type': {'readonly': True},
        'billed_document_id': {'readonly': True},
        'credit_for_document_id': {'readonly': True},
        'subscription_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'due_date': {'key': 'properties.dueDate', 'type': 'iso-8601'},
        'invoice_date': {'key': 'properties.invoiceDate', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'amount_due': {'key': 'properties.amountDue', 'type': 'Amount'},
        'azure_prepayment_applied': {'key': 'properties.azurePrepaymentApplied', 'type': 'Amount'},
        'billed_amount': {'key': 'properties.billedAmount', 'type': 'Amount'},
        'credit_amount': {'key': 'properties.creditAmount', 'type': 'Amount'},
        'free_azure_credit_applied': {'key': 'properties.freeAzureCreditApplied', 'type': 'Amount'},
        'sub_total': {'key': 'properties.subTotal', 'type': 'Amount'},
        'tax_amount': {'key': 'properties.taxAmount', 'type': 'Amount'},
        'total_amount': {'key': 'properties.totalAmount', 'type': 'Amount'},
        'invoice_period_start_date': {'key': 'properties.invoicePeriodStartDate', 'type': 'iso-8601'},
        'invoice_period_end_date': {'key': 'properties.invoicePeriodEndDate', 'type': 'iso-8601'},
        'invoice_type': {'key': 'properties.invoiceType', 'type': 'str'},
        'is_monthly_invoice': {'key': 'properties.isMonthlyInvoice', 'type': 'bool'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_display_name': {'key': 'properties.billingProfileDisplayName', 'type': 'str'},
        'purchase_order_number': {'key': 'properties.purchaseOrderNumber', 'type': 'str'},
        'documents': {'key': 'properties.documents', 'type': '[Document]'},
        'payments': {'key': 'properties.payments', 'type': '[PaymentProperties]'},
        'rebill_details': {'key': 'properties.rebillDetails', 'type': '{RebillDetails}'},
        'document_type': {'key': 'properties.documentType', 'type': 'str'},
        'billed_document_id': {'key': 'properties.billedDocumentId', 'type': 'str'},
        'credit_for_document_id': {'key': 'properties.creditForDocumentId', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Invoice, self).__init__(**kwargs)
        self.due_date = None
        self.invoice_date = None
        self.status = None
        self.amount_due = None
        self.azure_prepayment_applied = None
        self.billed_amount = None
        self.credit_amount = None
        self.free_azure_credit_applied = None
        self.sub_total = None
        self.tax_amount = None
        self.total_amount = None
        self.invoice_period_start_date = None
        self.invoice_period_end_date = None
        self.invoice_type = None
        self.is_monthly_invoice = None
        self.billing_profile_id = None
        self.billing_profile_display_name = None
        self.purchase_order_number = None
        self.documents = None
        self.payments = None
        self.rebill_details = None
        self.document_type = None
        self.billed_document_id = None
        self.credit_for_document_id = None
        self.subscription_id = None


class InvoiceListResult(msrest.serialization.Model):
    """The list of invoices.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of invoices.
    :vartype value: list[~azure.mgmt.billing.models.Invoice]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Invoice]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InvoiceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class InvoiceSection(Resource):
    """An invoice section.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: The name of the invoice section.
    :type display_name: str
    :param labels: Dictionary of metadata associated with the invoice section.
    :type labels: dict[str, str]
    :ivar state: Identifies the state of an invoice section. Possible values include: "Active",
     "Restricted".
    :vartype state: str or ~azure.mgmt.billing.models.InvoiceSectionState
    :ivar system_id: The system generated unique identifier for an invoice section.
    :vartype system_id: str
    :ivar target_cloud: Identifies the cloud environments that are associated with an invoice
     section. This is a system managed optional field and gets updated as the invoice section gets
     associated with accounts in various clouds. Possible values include: "USGov", "USNat", "USSec".
    :vartype target_cloud: str or ~azure.mgmt.billing.models.TargetCloud
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'system_id': {'readonly': True},
        'target_cloud': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'labels': {'key': 'properties.labels', 'type': '{str}'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'system_id': {'key': 'properties.systemId', 'type': 'str'},
        'target_cloud': {'key': 'properties.targetCloud', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InvoiceSection, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.labels = kwargs.get('labels', None)
        self.state = None
        self.system_id = None
        self.target_cloud = None


class InvoiceSectionCreationRequest(msrest.serialization.Model):
    """The properties of the invoice section.

    :param display_name: The name of the invoice section.
    :type display_name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InvoiceSectionCreationRequest, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)


class InvoiceSectionListResult(msrest.serialization.Model):
    """The list of invoice sections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of invoice sections.
    :vartype value: list[~azure.mgmt.billing.models.InvoiceSection]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InvoiceSection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InvoiceSectionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class InvoiceSectionListWithCreateSubPermissionResult(msrest.serialization.Model):
    """The list of invoice section properties with create subscription permission.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of invoice section properties with create subscription permission.
    :type value: list[~azure.mgmt.billing.models.InvoiceSectionWithCreateSubPermission]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InvoiceSectionWithCreateSubPermission]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InvoiceSectionListWithCreateSubPermissionResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class InvoiceSectionsOnExpand(msrest.serialization.Model):
    """The invoice sections associated to the billing profile. By default this is not populated, unless it's specified in $expand.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar has_more_results: Indicates whether there are more invoice sections than the ones listed
     in this collection. The collection lists a maximum of 50 invoice sections. To get all invoice
     sections, use the list invoice sections API.
    :vartype has_more_results: bool
    :param value: The invoice sections associated to the billing profile.
    :type value: list[~azure.mgmt.billing.models.InvoiceSection]
    """

    _validation = {
        'has_more_results': {'readonly': True},
    }

    _attribute_map = {
        'has_more_results': {'key': 'hasMoreResults', 'type': 'bool'},
        'value': {'key': 'value', 'type': '[InvoiceSection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InvoiceSectionsOnExpand, self).__init__(**kwargs)
        self.has_more_results = None
        self.value = kwargs.get('value', None)


class InvoiceSectionWithCreateSubPermission(msrest.serialization.Model):
    """Invoice section properties with create subscription permission.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar invoice_section_id: The ID of the invoice section.
    :vartype invoice_section_id: str
    :ivar invoice_section_display_name: The name of the invoice section.
    :vartype invoice_section_display_name: str
    :ivar invoice_section_system_id: The system generated unique identifier for an invoice section.
    :vartype invoice_section_system_id: str
    :ivar billing_profile_id: The ID of the billing profile for the invoice section.
    :vartype billing_profile_id: str
    :ivar billing_profile_display_name: The name of the billing profile for the invoice section.
    :vartype billing_profile_display_name: str
    :ivar billing_profile_status: The status of the billing profile. Possible values include:
     "Active", "Disabled", "Warned".
    :vartype billing_profile_status: str or ~azure.mgmt.billing.models.BillingProfileStatus
    :ivar billing_profile_status_reason_code: Reason for the specified billing profile status.
     Possible values include: "PastDue", "SpendingLimitReached", "SpendingLimitExpired".
    :vartype billing_profile_status_reason_code: str or
     ~azure.mgmt.billing.models.StatusReasonCodeForBillingProfile
    :ivar billing_profile_spending_limit: The billing profile spending limit. Possible values
     include: "Off", "On".
    :vartype billing_profile_spending_limit: str or
     ~azure.mgmt.billing.models.SpendingLimitForBillingProfile
    :ivar billing_profile_system_id: The system generated unique identifier for a billing profile.
    :vartype billing_profile_system_id: str
    :param enabled_azure_plans: Enabled azure plans for the associated billing profile.
    :type enabled_azure_plans: list[~azure.mgmt.billing.models.AzurePlan]
    """

    _validation = {
        'invoice_section_id': {'readonly': True},
        'invoice_section_display_name': {'readonly': True},
        'invoice_section_system_id': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_display_name': {'readonly': True},
        'billing_profile_status': {'readonly': True},
        'billing_profile_status_reason_code': {'readonly': True},
        'billing_profile_spending_limit': {'readonly': True},
        'billing_profile_system_id': {'readonly': True},
    }

    _attribute_map = {
        'invoice_section_id': {'key': 'invoiceSectionId', 'type': 'str'},
        'invoice_section_display_name': {'key': 'invoiceSectionDisplayName', 'type': 'str'},
        'invoice_section_system_id': {'key': 'invoiceSectionSystemId', 'type': 'str'},
        'billing_profile_id': {'key': 'billingProfileId', 'type': 'str'},
        'billing_profile_display_name': {'key': 'billingProfileDisplayName', 'type': 'str'},
        'billing_profile_status': {'key': 'billingProfileStatus', 'type': 'str'},
        'billing_profile_status_reason_code': {'key': 'billingProfileStatusReasonCode', 'type': 'str'},
        'billing_profile_spending_limit': {'key': 'billingProfileSpendingLimit', 'type': 'str'},
        'billing_profile_system_id': {'key': 'billingProfileSystemId', 'type': 'str'},
        'enabled_azure_plans': {'key': 'enabledAzurePlans', 'type': '[AzurePlan]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InvoiceSectionWithCreateSubPermission, self).__init__(**kwargs)
        self.invoice_section_id = None
        self.invoice_section_display_name = None
        self.invoice_section_system_id = None
        self.billing_profile_id = None
        self.billing_profile_display_name = None
        self.billing_profile_status = None
        self.billing_profile_status_reason_code = None
        self.billing_profile_spending_limit = None
        self.billing_profile_system_id = None
        self.enabled_azure_plans = kwargs.get('enabled_azure_plans', None)


class Operation(msrest.serialization.Model):
    """A Billing REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.billing.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.Billing.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed such as invoice and billing
     subscription.
    :vartype resource: str
    :ivar operation: Operation type such as read, write and delete.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(msrest.serialization.Model):
    """The list of billing operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of billing operations supported by the Microsoft.Billing resource
     provider.
    :vartype value: list[~azure.mgmt.billing.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Participants(msrest.serialization.Model):
    """The details about a participant.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The acceptance status of the participant.
    :vartype status: str
    :ivar status_date: The date when the status got changed.
    :vartype status_date: ~datetime.datetime
    :ivar email: The email address of the participant.
    :vartype email: str
    """

    _validation = {
        'status': {'readonly': True},
        'status_date': {'readonly': True},
        'email': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'status_date': {'key': 'statusDate', 'type': 'iso-8601'},
        'email': {'key': 'email', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Participants, self).__init__(**kwargs)
        self.status = None
        self.status_date = None
        self.email = None


class PaymentProperties(msrest.serialization.Model):
    """The properties of a payment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar payment_type: The type of payment.
    :vartype payment_type: str
    :ivar amount: The paid amount.
    :vartype amount: ~azure.mgmt.billing.models.Amount
    :ivar date: The date when the payment was made.
    :vartype date: ~datetime.datetime
    :param payment_method_family: The family of payment method. Possible values include: "Credits",
     "CheckWire", "CreditCard", "None".
    :type payment_method_family: str or ~azure.mgmt.billing.models.PaymentMethodFamily
    :ivar payment_method_type: The type of payment method.
    :vartype payment_method_type: str
    """

    _validation = {
        'payment_type': {'readonly': True},
        'amount': {'readonly': True},
        'date': {'readonly': True},
        'payment_method_type': {'readonly': True},
    }

    _attribute_map = {
        'payment_type': {'key': 'paymentType', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'Amount'},
        'date': {'key': 'date', 'type': 'iso-8601'},
        'payment_method_family': {'key': 'paymentMethodFamily', 'type': 'str'},
        'payment_method_type': {'key': 'paymentMethodType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PaymentProperties, self).__init__(**kwargs)
        self.payment_type = None
        self.amount = None
        self.date = None
        self.payment_method_family = kwargs.get('payment_method_family', None)
        self.payment_method_type = None


class Policy(Resource):
    """A policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param marketplace_purchases: The policy that controls whether Azure marketplace purchases are
     allowed for a billing profile. Possible values include: "AllAllowed", "OnlyFreeAllowed",
     "NotAllowed".
    :type marketplace_purchases: str or ~azure.mgmt.billing.models.MarketplacePurchasesPolicy
    :param reservation_purchases: The policy that controls whether Azure reservation purchases are
     allowed for a billing profile. Possible values include: "Allowed", "NotAllowed".
    :type reservation_purchases: str or ~azure.mgmt.billing.models.ReservationPurchasesPolicy
    :param view_charges: The policy that controls whether users with Azure RBAC access to a
     subscription can view its charges. Possible values include: "Allowed", "NotAllowed".
    :type view_charges: str or ~azure.mgmt.billing.models.ViewChargesPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'marketplace_purchases': {'key': 'properties.marketplacePurchases', 'type': 'str'},
        'reservation_purchases': {'key': 'properties.reservationPurchases', 'type': 'str'},
        'view_charges': {'key': 'properties.viewCharges', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Policy, self).__init__(**kwargs)
        self.marketplace_purchases = kwargs.get('marketplace_purchases', None)
        self.reservation_purchases = kwargs.get('reservation_purchases', None)
        self.view_charges = kwargs.get('view_charges', None)


class Product(Resource):
    """A product.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param auto_renew: Indicates whether auto renewal is turned on or off for a product. Possible
     values include: "Off", "On".
    :type auto_renew: str or ~azure.mgmt.billing.models.AutoRenew
    :ivar display_name: The display name of the product.
    :vartype display_name: str
    :ivar purchase_date: The date when the product was purchased.
    :vartype purchase_date: ~datetime.datetime
    :ivar product_type_id: The ID of the type of product.
    :vartype product_type_id: str
    :ivar product_type: The description of the type of product.
    :vartype product_type: str
    :param status: The current status of the product. Possible values include: "Active",
     "Inactive", "PastDue", "Expiring", "Expired", "Disabled", "Cancelled", "AutoRenew".
    :type status: str or ~azure.mgmt.billing.models.ProductStatusType
    :ivar end_date: The date when the product will be renewed or canceled.
    :vartype end_date: ~datetime.datetime
    :param billing_frequency: The frequency at which the product will be billed. Possible values
     include: "OneTime", "Monthly", "UsageBased".
    :type billing_frequency: str or ~azure.mgmt.billing.models.BillingFrequency
    :ivar last_charge: The last month charges.
    :vartype last_charge: ~azure.mgmt.billing.models.Amount
    :ivar last_charge_date: The date of the last charge.
    :vartype last_charge_date: ~datetime.datetime
    :ivar quantity: The quantity purchased for the product.
    :vartype quantity: float
    :ivar sku_id: The sku ID of the product.
    :vartype sku_id: str
    :ivar sku_description: The sku description of the product.
    :vartype sku_description: str
    :ivar tenant_id: The id of the tenant in which the product is used.
    :vartype tenant_id: str
    :ivar availability_id: The availability of the product.
    :vartype availability_id: str
    :ivar invoice_section_id: The ID of the invoice section to which the product is billed.
    :vartype invoice_section_id: str
    :ivar invoice_section_display_name: The name of the invoice section to which the product is
     billed.
    :vartype invoice_section_display_name: str
    :ivar billing_profile_id: The ID of the billing profile to which the product is billed.
    :vartype billing_profile_id: str
    :ivar billing_profile_display_name: The name of the billing profile to which the product is
     billed.
    :vartype billing_profile_display_name: str
    :ivar customer_id: The ID of the customer for whom the product was purchased. The field is
     applicable only for Microsoft Partner Agreement billing account.
    :vartype customer_id: str
    :ivar customer_display_name: The name of the customer for whom the product was purchased. The
     field is applicable only for Microsoft Partner Agreement billing account.
    :vartype customer_display_name: str
    :ivar reseller: Reseller for this product.
    :vartype reseller: ~azure.mgmt.billing.models.Reseller
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'purchase_date': {'readonly': True},
        'product_type_id': {'readonly': True},
        'product_type': {'readonly': True},
        'end_date': {'readonly': True},
        'last_charge': {'readonly': True},
        'last_charge_date': {'readonly': True},
        'quantity': {'readonly': True},
        'sku_id': {'readonly': True},
        'sku_description': {'readonly': True},
        'tenant_id': {'readonly': True},
        'availability_id': {'readonly': True},
        'invoice_section_id': {'readonly': True},
        'invoice_section_display_name': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_display_name': {'readonly': True},
        'customer_id': {'readonly': True},
        'customer_display_name': {'readonly': True},
        'reseller': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'purchase_date': {'key': 'properties.purchaseDate', 'type': 'iso-8601'},
        'product_type_id': {'key': 'properties.productTypeId', 'type': 'str'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'end_date': {'key': 'properties.endDate', 'type': 'iso-8601'},
        'billing_frequency': {'key': 'properties.billingFrequency', 'type': 'str'},
        'last_charge': {'key': 'properties.lastCharge', 'type': 'Amount'},
        'last_charge_date': {'key': 'properties.lastChargeDate', 'type': 'iso-8601'},
        'quantity': {'key': 'properties.quantity', 'type': 'float'},
        'sku_id': {'key': 'properties.skuId', 'type': 'str'},
        'sku_description': {'key': 'properties.skuDescription', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'availability_id': {'key': 'properties.availabilityId', 'type': 'str'},
        'invoice_section_id': {'key': 'properties.invoiceSectionId', 'type': 'str'},
        'invoice_section_display_name': {'key': 'properties.invoiceSectionDisplayName', 'type': 'str'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_display_name': {'key': 'properties.billingProfileDisplayName', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'customer_display_name': {'key': 'properties.customerDisplayName', 'type': 'str'},
        'reseller': {'key': 'properties.reseller', 'type': 'Reseller'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Product, self).__init__(**kwargs)
        self.auto_renew = kwargs.get('auto_renew', None)
        self.display_name = None
        self.purchase_date = None
        self.product_type_id = None
        self.product_type = None
        self.status = kwargs.get('status', None)
        self.end_date = None
        self.billing_frequency = kwargs.get('billing_frequency', None)
        self.last_charge = None
        self.last_charge_date = None
        self.quantity = None
        self.sku_id = None
        self.sku_description = None
        self.tenant_id = None
        self.availability_id = None
        self.invoice_section_id = None
        self.invoice_section_display_name = None
        self.billing_profile_id = None
        self.billing_profile_display_name = None
        self.customer_id = None
        self.customer_display_name = None
        self.reseller = None


class ProductsListResult(msrest.serialization.Model):
    """The list of products. It contains a list of available product summaries in reverse chronological order by purchase date.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of products.
    :vartype value: list[~azure.mgmt.billing.models.Product]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Product]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RebillDetails(msrest.serialization.Model):
    """The rebill details of an invoice.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar credit_note_document_id: The ID of credit note.
    :vartype credit_note_document_id: str
    :ivar invoice_document_id: The ID of invoice.
    :vartype invoice_document_id: str
    :ivar rebill_details: Rebill details for an invoice.
    :vartype rebill_details: dict[str, ~azure.mgmt.billing.models.RebillDetails]
    """

    _validation = {
        'credit_note_document_id': {'readonly': True},
        'invoice_document_id': {'readonly': True},
        'rebill_details': {'readonly': True},
    }

    _attribute_map = {
        'credit_note_document_id': {'key': 'creditNoteDocumentId', 'type': 'str'},
        'invoice_document_id': {'key': 'invoiceDocumentId', 'type': 'str'},
        'rebill_details': {'key': 'rebillDetails', 'type': '{RebillDetails}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RebillDetails, self).__init__(**kwargs)
        self.credit_note_document_id = None
        self.invoice_document_id = None
        self.rebill_details = None


class Reseller(msrest.serialization.Model):
    """Details of the reseller.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar reseller_id: The MPN ID of the reseller.
    :vartype reseller_id: str
    :ivar description: The name of the reseller.
    :vartype description: str
    """

    _validation = {
        'reseller_id': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'reseller_id': {'key': 'resellerId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Reseller, self).__init__(**kwargs)
        self.reseller_id = None
        self.description = None


class Transaction(Resource):
    """A transaction.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param kind: The kind of transaction. Options are all or reservation. Possible values include:
     "all", "reservation".
    :type kind: str or ~azure.mgmt.billing.models.TransactionTypeKind
    :ivar date: The date of transaction.
    :vartype date: ~datetime.datetime
    :ivar invoice: Invoice on which the transaction was billed or 'pending' if the transaction is
     not billed.
    :vartype invoice: str
    :ivar invoice_id: The ID of the invoice on which the transaction was billed. This field is only
     applicable for transactions which are billed.
    :vartype invoice_id: str
    :ivar order_id: The order ID of the reservation. The field is only applicable for transaction
     of kind reservation.
    :vartype order_id: str
    :ivar order_name: The name of the reservation order. The field is only applicable for
     transactions of kind reservation.
    :vartype order_name: str
    :ivar product_family: The family of the product for which the transaction took place.
    :vartype product_family: str
    :ivar product_type_id: The ID of the product type for which the transaction took place.
    :vartype product_type_id: str
    :ivar product_type: The type of the product for which the transaction took place.
    :vartype product_type: str
    :ivar product_description: The description of the product for which the transaction took place.
    :vartype product_description: str
    :param transaction_type: The type of transaction. Possible values include: "Purchase", "Usage
     Charge".
    :type transaction_type: str or ~azure.mgmt.billing.models.ReservationType
    :ivar transaction_amount: The charge associated with the transaction.
    :vartype transaction_amount: ~azure.mgmt.billing.models.Amount
    :ivar quantity: The quantity purchased in the transaction.
    :vartype quantity: int
    :ivar invoice_section_id: The ID of the invoice section which will be billed for the
     transaction.
    :vartype invoice_section_id: str
    :ivar invoice_section_display_name: The name of the invoice section which will be billed for
     the transaction.
    :vartype invoice_section_display_name: str
    :ivar billing_profile_id: The ID of the billing profile which will be billed for the
     transaction.
    :vartype billing_profile_id: str
    :ivar billing_profile_display_name: The name of the billing profile which will be billed for
     the transaction.
    :vartype billing_profile_display_name: str
    :ivar customer_id: The ID of the customer for which the transaction took place. The field is
     applicable only for Microsoft Partner Agreement billing account.
    :vartype customer_id: str
    :ivar customer_display_name: The name of the customer for which the transaction took place. The
     field is applicable only for Microsoft Partner Agreement billing account.
    :vartype customer_display_name: str
    :ivar subscription_id: The ID of the subscription that was used for the transaction. The field
     is only applicable for transaction of kind reservation.
    :vartype subscription_id: str
    :ivar subscription_name: The name of the subscription that was used for the transaction. The
     field is only applicable for transaction of kind reservation.
    :vartype subscription_name: str
    :ivar azure_plan: The type of azure plan of the subscription that was used for the transaction.
    :vartype azure_plan: str
    :ivar azure_credit_applied: The amount of any Azure credits automatically applied to this
     transaction.
    :vartype azure_credit_applied: ~azure.mgmt.billing.models.Amount
    :ivar billing_currency: The ISO 4217 code for the currency in which this transaction is billed.
    :vartype billing_currency: str
    :ivar discount: The percentage discount, if any, applied to this transaction.
    :vartype discount: float
    :ivar effective_price: The price of the product after applying any discounts.
    :vartype effective_price: ~azure.mgmt.billing.models.Amount
    :ivar exchange_rate: The exchange rate used to convert charged amount to billing currency, if
     applicable.
    :vartype exchange_rate: float
    :ivar market_price: The retail price of the product.
    :vartype market_price: ~azure.mgmt.billing.models.Amount
    :ivar pricing_currency: The ISO 4217 code for the currency in which the product is priced.
    :vartype pricing_currency: str
    :ivar service_period_start_date: The date of the purchase of the product, or the start date of
     the month in which usage started.
    :vartype service_period_start_date: ~datetime.datetime
    :ivar service_period_end_date: The end date of the product term, or the end date of the month
     in which usage ended.
    :vartype service_period_end_date: ~datetime.datetime
    :ivar sub_total: The pre-tax charged amount for the transaction.
    :vartype sub_total: ~azure.mgmt.billing.models.Amount
    :ivar tax: The tax amount applied to the transaction.
    :vartype tax: ~azure.mgmt.billing.models.Amount
    :ivar unit_of_measure: The unit of measure used to bill for the product. For example, compute
     services are billed per hour.
    :vartype unit_of_measure: str
    :ivar units: The number of units used for a given product.
    :vartype units: float
    :ivar unit_type: The description for the unit of measure for a given product.
    :vartype unit_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'date': {'readonly': True},
        'invoice': {'readonly': True},
        'invoice_id': {'readonly': True},
        'order_id': {'readonly': True},
        'order_name': {'readonly': True},
        'product_family': {'readonly': True},
        'product_type_id': {'readonly': True},
        'product_type': {'readonly': True},
        'product_description': {'readonly': True},
        'transaction_amount': {'readonly': True},
        'quantity': {'readonly': True},
        'invoice_section_id': {'readonly': True},
        'invoice_section_display_name': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_display_name': {'readonly': True},
        'customer_id': {'readonly': True},
        'customer_display_name': {'readonly': True},
        'subscription_id': {'readonly': True},
        'subscription_name': {'readonly': True},
        'azure_plan': {'readonly': True},
        'azure_credit_applied': {'readonly': True},
        'billing_currency': {'readonly': True},
        'discount': {'readonly': True},
        'effective_price': {'readonly': True},
        'exchange_rate': {'readonly': True},
        'market_price': {'readonly': True},
        'pricing_currency': {'readonly': True},
        'service_period_start_date': {'readonly': True},
        'service_period_end_date': {'readonly': True},
        'sub_total': {'readonly': True},
        'tax': {'readonly': True},
        'unit_of_measure': {'readonly': True},
        'units': {'readonly': True},
        'unit_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'properties.kind', 'type': 'str'},
        'date': {'key': 'properties.date', 'type': 'iso-8601'},
        'invoice': {'key': 'properties.invoice', 'type': 'str'},
        'invoice_id': {'key': 'properties.invoiceId', 'type': 'str'},
        'order_id': {'key': 'properties.orderId', 'type': 'str'},
        'order_name': {'key': 'properties.orderName', 'type': 'str'},
        'product_family': {'key': 'properties.productFamily', 'type': 'str'},
        'product_type_id': {'key': 'properties.productTypeId', 'type': 'str'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'product_description': {'key': 'properties.productDescription', 'type': 'str'},
        'transaction_type': {'key': 'properties.transactionType', 'type': 'str'},
        'transaction_amount': {'key': 'properties.transactionAmount', 'type': 'Amount'},
        'quantity': {'key': 'properties.quantity', 'type': 'int'},
        'invoice_section_id': {'key': 'properties.invoiceSectionId', 'type': 'str'},
        'invoice_section_display_name': {'key': 'properties.invoiceSectionDisplayName', 'type': 'str'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_display_name': {'key': 'properties.billingProfileDisplayName', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'customer_display_name': {'key': 'properties.customerDisplayName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'subscription_name': {'key': 'properties.subscriptionName', 'type': 'str'},
        'azure_plan': {'key': 'properties.azurePlan', 'type': 'str'},
        'azure_credit_applied': {'key': 'properties.azureCreditApplied', 'type': 'Amount'},
        'billing_currency': {'key': 'properties.billingCurrency', 'type': 'str'},
        'discount': {'key': 'properties.discount', 'type': 'float'},
        'effective_price': {'key': 'properties.effectivePrice', 'type': 'Amount'},
        'exchange_rate': {'key': 'properties.exchangeRate', 'type': 'float'},
        'market_price': {'key': 'properties.marketPrice', 'type': 'Amount'},
        'pricing_currency': {'key': 'properties.pricingCurrency', 'type': 'str'},
        'service_period_start_date': {'key': 'properties.servicePeriodStartDate', 'type': 'iso-8601'},
        'service_period_end_date': {'key': 'properties.servicePeriodEndDate', 'type': 'iso-8601'},
        'sub_total': {'key': 'properties.subTotal', 'type': 'Amount'},
        'tax': {'key': 'properties.tax', 'type': 'Amount'},
        'unit_of_measure': {'key': 'properties.unitOfMeasure', 'type': 'str'},
        'units': {'key': 'properties.units', 'type': 'float'},
        'unit_type': {'key': 'properties.unitType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Transaction, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.date = None
        self.invoice = None
        self.invoice_id = None
        self.order_id = None
        self.order_name = None
        self.product_family = None
        self.product_type_id = None
        self.product_type = None
        self.product_description = None
        self.transaction_type = kwargs.get('transaction_type', None)
        self.transaction_amount = None
        self.quantity = None
        self.invoice_section_id = None
        self.invoice_section_display_name = None
        self.billing_profile_id = None
        self.billing_profile_display_name = None
        self.customer_id = None
        self.customer_display_name = None
        self.subscription_id = None
        self.subscription_name = None
        self.azure_plan = None
        self.azure_credit_applied = None
        self.billing_currency = None
        self.discount = None
        self.effective_price = None
        self.exchange_rate = None
        self.market_price = None
        self.pricing_currency = None
        self.service_period_start_date = None
        self.service_period_end_date = None
        self.sub_total = None
        self.tax = None
        self.unit_of_measure = None
        self.units = None
        self.unit_type = None


class TransactionListResult(msrest.serialization.Model):
    """The list of transactions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of transactions.
    :vartype value: list[~azure.mgmt.billing.models.Transaction]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Transaction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransactionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class TransferBillingSubscriptionRequestProperties(msrest.serialization.Model):
    """Request parameters to transfer billing subscription.

    All required parameters must be populated in order to send to Azure.

    :param destination_invoice_section_id: Required. The destination invoice section id.
    :type destination_invoice_section_id: str
    """

    _validation = {
        'destination_invoice_section_id': {'required': True},
    }

    _attribute_map = {
        'destination_invoice_section_id': {'key': 'destinationInvoiceSectionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransferBillingSubscriptionRequestProperties, self).__init__(**kwargs)
        self.destination_invoice_section_id = kwargs['destination_invoice_section_id']


class TransferProductRequestProperties(msrest.serialization.Model):
    """The properties of the product to initiate a transfer.

    :param destination_invoice_section_id: The destination invoice section id.
    :type destination_invoice_section_id: str
    """

    _attribute_map = {
        'destination_invoice_section_id': {'key': 'destinationInvoiceSectionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransferProductRequestProperties, self).__init__(**kwargs)
        self.destination_invoice_section_id = kwargs.get('destination_invoice_section_id', None)


class ValidateAddressResponse(msrest.serialization.Model):
    """Result of the address validation.

    :param status: status of the address validation. Possible values include: "Valid", "Invalid".
    :type status: str or ~azure.mgmt.billing.models.AddressValidationStatus
    :param suggested_addresses: The list of suggested addresses.
    :type suggested_addresses: list[~azure.mgmt.billing.models.AddressDetails]
    :param validation_message: Validation error message.
    :type validation_message: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'suggested_addresses': {'key': 'suggestedAddresses', 'type': '[AddressDetails]'},
        'validation_message': {'key': 'validationMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateAddressResponse, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.suggested_addresses = kwargs.get('suggested_addresses', None)
        self.validation_message = kwargs.get('validation_message', None)


class ValidateProductTransferEligibilityError(msrest.serialization.Model):
    """Error details of the product transfer eligibility validation.

    :param code: Error code for the product transfer validation. Possible values include:
     "InvalidSource", "ProductNotActive", "InsufficientPermissionOnSource",
     "InsufficientPermissionOnDestination", "DestinationBillingProfilePastDue",
     "ProductTypeNotSupported", "CrossBillingAccountNotAllowed", "NotAvailableForDestinationMarket",
     "OneTimePurchaseProductTransferNotAllowed".
    :type code: str or ~azure.mgmt.billing.models.ProductTransferValidationErrorCode
    :param message: The error message.
    :type message: str
    :param details: Detailed error message explaining the error.
    :type details: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateProductTransferEligibilityError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class ValidateProductTransferEligibilityResult(msrest.serialization.Model):
    """Result of the product transfer eligibility validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_move_eligible: Specifies whether the transfer is eligible or not.
    :vartype is_move_eligible: bool
    :param error_details: Validation error details.
    :type error_details: ~azure.mgmt.billing.models.ValidateProductTransferEligibilityError
    """

    _validation = {
        'is_move_eligible': {'readonly': True},
    }

    _attribute_map = {
        'is_move_eligible': {'key': 'isMoveEligible', 'type': 'bool'},
        'error_details': {'key': 'errorDetails', 'type': 'ValidateProductTransferEligibilityError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateProductTransferEligibilityResult, self).__init__(**kwargs)
        self.is_move_eligible = None
        self.error_details = kwargs.get('error_details', None)


class ValidateSubscriptionTransferEligibilityError(msrest.serialization.Model):
    """Error details of the transfer eligibility validation.

    :param code: Error code for the product transfer validation. Possible values include:
     "InvalidSource", "SubscriptionNotActive", "InsufficientPermissionOnSource",
     "InsufficientPermissionOnDestination", "DestinationBillingProfilePastDue",
     "SubscriptionTypeNotSupported", "CrossBillingAccountNotAllowed",
     "NotAvailableForDestinationMarket".
    :type code: str or ~azure.mgmt.billing.models.SubscriptionTransferValidationErrorCode
    :param message: The error message.
    :type message: str
    :param details: Detailed error message explaining the error.
    :type details: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateSubscriptionTransferEligibilityError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class ValidateSubscriptionTransferEligibilityResult(msrest.serialization.Model):
    """Result of the transfer eligibility validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_move_eligible: Specifies whether the subscription is eligible to be transferred.
    :vartype is_move_eligible: bool
    :param error_details: Validation error details.
    :type error_details: ~azure.mgmt.billing.models.ValidateSubscriptionTransferEligibilityError
    """

    _validation = {
        'is_move_eligible': {'readonly': True},
    }

    _attribute_map = {
        'is_move_eligible': {'key': 'isMoveEligible', 'type': 'bool'},
        'error_details': {'key': 'errorDetails', 'type': 'ValidateSubscriptionTransferEligibilityError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateSubscriptionTransferEligibilityResult, self).__init__(**kwargs)
        self.is_move_eligible = None
        self.error_details = kwargs.get('error_details', None)
