/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.util.ArrayList;
import java.util.List;
import smetana.core.UnsupportedC;

public class CArrayOfStar<O>
extends UnsupportedC {
    private final List<O> data;
    private final int offset;

    public String toString() {
        return "*Array offset=" + this.offset + " [" + this.data.size() + "]" + this.data;
    }

    private CArrayOfStar(List<O> data, int offset) {
        this.data = data;
        this.offset = offset;
    }

    public static <O> CArrayOfStar<O> ALLOC(int size, Class cl) {
        CArrayOfStar result = new CArrayOfStar(new ArrayList(), 0);
        result.realloc(size);
        return result;
    }

    public static <O> CArrayOfStar<O> REALLOC(int size, CArrayOfStar<O> old, Class<O> cl) {
        if (old == null) {
            return CArrayOfStar.ALLOC(size, cl);
        }
        old.realloc(size);
        return old;
    }

    public int comparePointer_(CArrayOfStar<O> other) {
        if (this.data != other.data) {
            throw new IllegalArgumentException();
        }
        return this.offset - other.offset;
    }

    public O get_(int i) {
        return this.data.get(i + this.offset);
    }

    public void set_(int i, O value) {
        this.data.set(i + this.offset, value);
    }

    public void realloc(int size) {
        if (this.offset != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < size; ++i) {
            this.data.add(null);
        }
    }

    public CArrayOfStar<O> plus_(int delta) {
        return new CArrayOfStar<O>(this.data, this.offset + delta);
    }

    public void _swap(int i, int j) {
        if (this.offset != 0) {
            throw new IllegalStateException();
        }
        O e1 = this.data.get(i);
        O e2 = this.data.get(j);
        this.data.set(i, e2);
        this.data.set(j, e1);
    }
}

