/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class SpriteColor
implements Sprite {
    private final int width;
    private final int height;
    private final int[][] grey;
    private final int[][] color;

    public SpriteColor(int width, int height) {
        this.width = width;
        this.height = height;
        this.grey = new int[height][width];
        this.color = new int[height][width];
    }

    public void setGrey(int x, int y, int level) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        if (level < 0 || level >= 16) {
            throw new IllegalArgumentException();
        }
        this.grey[y][x] = level;
        this.color[y][x] = -1;
    }

    public void setColor(int x, int y, int col) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        this.grey[y][x] = -1;
        this.color[y][x] = col;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public UImage toUImage(ColorMapper colorMapper, HColor backcolor, HColor forecolor) {
        BufferedImage im = new BufferedImage(this.width, this.height, 1);
        if (backcolor == null) {
            backcolor = HColorUtils.WHITE;
        }
        if (forecolor == null) {
            forecolor = HColorUtils.BLACK;
        }
        HColorGradient gradient = new HColorGradient(backcolor, forecolor, '\u0000');
        for (int col = 0; col < this.width; ++col) {
            for (int line = 0; line < this.height; ++line) {
                int localColor = this.color[line][col];
                if (localColor == -1) {
                    double coef = 1.0 * (double)this.grey[line][col] / 15.0;
                    Color c = gradient.getColor(colorMapper, coef);
                    im.setRGB(col, line, c.getRGB());
                    continue;
                }
                im.setRGB(col, line, localColor);
            }
        }
        return new UImage(new PixelImage(im, AffineTransformType.TYPE_BILINEAR));
    }

    @Override
    public TextBlock asTextBlock(final HColor color, final double scale) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                UImage image = SpriteColor.this.toUImage(ug.getColorMapper(), ug.getParam().getBackcolor(), color);
                ug.draw(image.scale(scale));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble((double)SpriteColor.this.getWidth() * scale, (double)SpriteColor.this.getHeight() * scale);
            }
        };
    }
}

