/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc2.ReadFilter;
import net.sourceforge.plantuml.preproc2.ReadFilterQuoteComment;
import net.sourceforge.plantuml.utils.StartUtils;

public class ReadFilterMergeLines
implements ReadFilter {
    @Override
    public ReadLine applyFilter(final ReadLine source) {
        return new ReadLine(){
            private boolean manageEndingBackslash = true;

            @Override
            public void close() throws IOException {
                source.close();
            }

            @Override
            public StringLocated readLine() throws IOException {
                StringLocated result = source.readLine();
                if (result != null && StartUtils.isArobaseStartDiagram(result.getString()) && this.isDitaa(result.getString())) {
                    this.manageEndingBackslash = false;
                }
                if (result != null && StartUtils.isArobaseEndDiagram(result.getString())) {
                    this.manageEndingBackslash = true;
                }
                ReadLine sourceWithoutComment = null;
                while (result != null && this.manageEndingBackslash && StringUtils.endsWithBackslash(result.getString())) {
                    StringLocated next;
                    if (sourceWithoutComment == null) {
                        sourceWithoutComment = new ReadFilterQuoteComment().applyFilter(source);
                    }
                    if ((next = sourceWithoutComment.readLine()) == null) break;
                    result = result.mergeEndBackslash(next);
                }
                return result;
            }

            private boolean isDitaa(String string) {
                return DiagramType.getTypeFromArobaseStart(StringUtils.trinNoTrace(string)) == DiagramType.DITAA;
            }
        };
    }
}

