/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

class USymbolDatabase
extends USymbol {
    USymbolDatabase() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.DATABASE;
    }

    private void drawDatabase(UGraphic ug, double width, double height, boolean shadowing) {
        UPath shape = new UPath();
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        shape.moveTo(0.0, 10.0);
        shape.cubicTo(0.0, 0.0, width / 2.0, 0.0, width / 2.0, 0.0);
        shape.cubicTo(width / 2.0, 0.0, width, 0.0, width, 10.0);
        shape.lineTo(width, height - 10.0);
        shape.cubicTo(width, height, width / 2.0, height, width / 2.0, height);
        shape.cubicTo(width / 2.0, height, 0.0, height, 0.0, height - 10.0);
        shape.lineTo(0.0, 10.0);
        ug.draw(shape);
        UPath closing = this.getClosingPath(width);
        ug.apply(new HColorNone().bg()).draw(closing);
        if (UseStyle.useBetaStyle()) {
            ug.apply(new UTranslate(width, height)).draw(new UEmpty(10.0, 10.0));
        }
    }

    private UPath getClosingPath(double width) {
        UPath closing = new UPath();
        closing.moveTo(0.0, 10.0);
        closing.cubicTo(0.0, 20.0, width / 2.0, 20.0, width / 2.0, 20.0);
        closing.cubicTo(width / 2.0, 20.0, width, 20.0, width, 10.0);
        return closing;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 24.0, 5.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolDatabase.this.drawDatabase(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolDatabase.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                MyUGraphicDatabase ug2 = new MyUGraphicDatabase(ug, dim.getWidth());
                tb.drawU(ug2.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolDatabase.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolDatabase.this.drawDatabase(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 22.0)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 22.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public int suppHeightBecauseOfShape() {
        return 15;
    }

    class MyUGraphicDatabase
    extends AbstractUGraphicHorizontalLine {
        private final double endingX;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicDatabase(ug, this.endingX);
        }

        public MyUGraphicDatabase(UGraphic ug, double endingX) {
            super(ug);
            this.endingX = endingX;
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            UPath closing = USymbolDatabase.this.getClosingPath(this.endingX);
            ug = ug.apply(translate);
            ug.apply(line.getStroke()).apply(new HColorNone().bg()).apply(UTranslate.dy(-15.0)).draw(closing);
            if (line.isDouble()) {
                ug.apply(line.getStroke()).apply(new HColorNone().bg()).apply(UTranslate.dy(-13.0)).draw(closing);
            }
            line.drawTitleInternal(ug, 0.0, this.endingX, 0.0, true);
        }
    }
}

