/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.legacy;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class StripeCode
implements Stripe,
Atom {
    private final FontConfiguration fontConfiguration;
    private final List<String> raw = new ArrayList<String>();
    private boolean terminated;

    public StripeCode(FontConfiguration fontConfiguration, ISkinSimple skinParam, String line) {
        this.fontConfiguration = fontConfiguration;
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this);
    }

    @Override
    public Atom getLHeader() {
        return null;
    }

    public boolean addAndCheckTermination(String line) {
        if (Parser.isCodeEnd(line)) {
            this.terminated = true;
            return true;
        }
        this.raw.add(line);
        return false;
    }

    public final boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (String s : this.raw) {
            Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s);
            width = Math.max(width, dim.getWidth());
            height += dim.getHeight();
        }
        return new Dimension2DDouble(width, height);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        for (String s : this.raw) {
            UText shape = new UText(s, this.fontConfiguration);
            StringBounder stringBounder = ug.getStringBounder();
            Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s);
            ug.apply(UTranslate.dy((y += dim.getHeight()) - shape.getDescent(stringBounder))).draw(shape);
        }
    }

    @Override
    public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
        throw new UnsupportedOperationException();
    }
}

