/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.descdiagram.command.Labels;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public final class CommandLinkClass
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    private static final String SINGLE = "[.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*";
    private static final String SINGLE_GUILLEMENT = "[%g][.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*[%g]";
    private static final String SINGLE2 = "(?:[.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*|[%g][.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*[%g])";
    private static final String COUPLE = "\\([%s]*((?:[.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*|[%g][.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*[%g]))[%s]*,[%s]*((?:[.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*|[%g][.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*[%g]))[%s]*\\)";

    public CommandLinkClass(UmlDiagramType umlDiagramType) {
        super(CommandLinkClass.getRegexConcat(umlDiagramType));
    }

    private static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return RegexConcat.build(CommandLinkClass.class.getName() + (Object)((Object)umlDiagramType), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("HEADER", "@([\\d.]+)"), RegexLeaf.spaceOneOrMore())), new RegexOr(new RegexLeaf("ENT1", CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE1", COUPLE)), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("FIRST_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexConcat(new RegexLeaf("ARROW_HEAD1", "([%s]+[ox]|[)#\\[<*+^}]|\\<_|\\<\\|[\\:\\|]|[<\\[]\\||\\}o|\\}\\||\\|o|\\|\\|)?"), new RegexLeaf("ARROW_BODY1", "([-=.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexOptional((IRegex)new RegexLeaf("INSIDE", "(0|\\(0\\)|\\(0|0\\))(?=[-=.~])")), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-=.]*)"), new RegexLeaf("ARROW_HEAD2", "([ox][%s]+|:\\>\\>?|_\\>|[(#\\]>*+^\\{]|[\\|\\:]\\|\\>|\\|[>\\]]|o\\{|\\|\\{|o\\||\\|\\|)?")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("SECOND_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("ENT2", CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE2", COUPLE)), RegexLeaf.spaceZeroOrMore(), CommandLinkClass.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LABEL_LINK", "(.+)"))), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private static String getClassIdentifier() {
        return "(" + CommandLinkClass.getSeparator() + "?[%pLN_$]+(?:" + CommandLinkClass.getSeparator() + "[%pLN_$]+)*|[%g][^%g]+[%g])";
    }

    public static String getSeparator() {
        return "(?:\\.|::|\\\\|\\\\\\\\)";
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Code code2;
        String ent1String = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\"");
        String ent2String = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\"");
        if (ent1String == null && ent2String == null) {
            return this.executeArgSpecial3(diagram, arg);
        }
        if (ent1String == null) {
            return this.executeArgSpecial1(diagram, arg);
        }
        if (ent2String == null) {
            return this.executeArgSpecial2(diagram, arg);
        }
        Ident ident1 = diagram.buildLeafIdentSpecial(ent1String);
        Ident ident2 = diagram.buildLeafIdentSpecial(ent2String);
        Ident ident1pure = Ident.empty().add(ent1String, diagram.getNamespaceSeparator());
        Ident ident2pure = Ident.empty().add(ent2String, diagram.getNamespaceSeparator());
        Code code1 = diagram.V1972() ? ident1 : diagram.buildCode(ent1String);
        Code code = code2 = diagram.V1972() ? ident2 : diagram.buildCode(ent2String);
        if (this.isGroupButNotTheCurrentGroup(diagram, code1, ident1) && this.isGroupButNotTheCurrentGroup(diagram, code2, ident2)) {
            return this.executePackageLink(diagram, arg);
        }
        String port1 = null;
        String port2 = null;
        if (diagram.V1972()) {
            if ("::".equals(diagram.getNamespaceSeparator())) {
                if (this.removeMemberPartIdentSpecial(diagram, ident1) != null) {
                    port1 = ident1.getLast();
                    code1 = ident1 = this.removeMemberPartIdentSpecial(diagram, ident1);
                }
                if (this.removeMemberPartIdentSpecial(diagram, ident2) != null) {
                    port2 = ident2.getLast();
                    ident2 = this.removeMemberPartIdentSpecial(diagram, ident2);
                    code2 = ident1;
                }
            } else {
                if (this.removeMemberPartIdent(diagram, ident1) != null) {
                    port1 = ident1.getPortMember();
                    code1 = ident1 = this.removeMemberPartIdent(diagram, ident1);
                }
                if (this.removeMemberPartIdent(diagram, ident2) != null) {
                    port2 = ident2.getPortMember();
                    code2 = ident2 = this.removeMemberPartIdent(diagram, ident2);
                }
            }
        } else {
            if (this.removeMemberPartLegacy1972(diagram, ident1) != null) {
                port1 = ident1.getPortMember();
                code1 = this.removeMemberPartLegacy1972(diagram, ident1);
                ident1 = ident1.removeMemberPart();
            }
            if (this.removeMemberPartLegacy1972(diagram, ident2) != null) {
                port2 = ident2.getPortMember();
                code2 = this.removeMemberPartLegacy1972(diagram, ident2);
                ident2 = ident2.removeMemberPart();
            }
        }
        IEntity cl1 = this.getFoo1(diagram, code1, ident1, ident1pure);
        IEntity cl2 = this.getFoo1(diagram, code2, ident2, ident2pure);
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        int queue = dir == Direction.LEFT || dir == Direction.RIGHT ? 1 : this.getQueueLength(arg);
        Labels labels = new Labels(arg);
        Link link = new Link(cl1, cl2, linkType, labels.getDisplay(), queue, labels.getFirstLabel(), labels.getSecondLabel(), diagram.getLabeldistance(), diagram.getLabelangle(), diagram.getSkinParam().getCurrentStyleBuilder());
        if (arg.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(arg.get("URL", 0));
            link.setUrl(url);
        }
        link.setPortMembers(port1, port2);
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.setLinkArrow(labels.getLinkArrow());
        link.setColors(CommandLinkClass.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet()));
        link.applyStyle(diagram.getSkinParam().getThemeStyle(), arg.getLazzy("ARROW_STYLE", 0));
        link.setCodeLine(location);
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private IEntity getFoo1(AbstractClassOrObjectDiagram diagram, Code code, Ident ident, Ident pure) {
        if (this.isGroupButNotTheCurrentGroup(diagram, code, ident)) {
            if (diagram.V1972()) {
                return diagram.getGroupVerySmart(ident);
            }
            return diagram.getGroup(code);
        }
        if (diagram.V1972()) {
            ILeaf result;
            ILeaf iLeaf = result = pure.size() == 1 ? diagram.getLeafVerySmart(ident) : diagram.getLeafStrict(ident);
            if (result != null) {
                return result;
            }
        }
        return diagram.getOrCreateLeaf(ident, code, null, null);
    }

    private boolean isGroupButNotTheCurrentGroup(AbstractClassOrObjectDiagram diagram, Code code, Ident ident) {
        if (diagram.V1972()) {
            if (diagram.getCurrentGroup().getCodeGetName().equals(code.getName())) {
                return false;
            }
            return diagram.isGroupVerySmart(ident);
        }
        if (diagram.getCurrentGroup().getCodeGetName().equals(code.getName())) {
            return false;
        }
        return diagram.isGroup(code);
    }

    private Ident removeMemberPartIdentSpecial(AbstractClassOrObjectDiagram diagram, Ident ident) {
        if (diagram.leafExistSmart(ident)) {
            return null;
        }
        Ident before = ident.parent();
        if (before == null) {
            return null;
        }
        if (!diagram.leafExistSmart(before)) {
            return null;
        }
        return before;
    }

    private Ident removeMemberPartIdent(AbstractClassOrObjectDiagram diagram, Ident ident) {
        if (diagram.leafExistSmart(ident)) {
            return null;
        }
        Ident before = ident.removeMemberPart();
        if (before == null) {
            return null;
        }
        if (!diagram.leafExistSmart(before)) {
            return null;
        }
        return before;
    }

    private Code removeMemberPartLegacy1972(AbstractClassOrObjectDiagram diagram, Ident ident) {
        if (diagram.leafExist(ident)) {
            return null;
        }
        Ident before = ident.removeMemberPart();
        if (before == null) {
            return null;
        }
        Code code = before.toCode(diagram);
        if (!diagram.leafExist(code)) {
            return null;
        }
        return code;
    }

    private void addLink(AbstractClassOrObjectDiagram diagram, Link link, String weight) {
        diagram.addLink(link);
        if (weight != null) {
            link.setWeight(Double.parseDouble(weight));
        }
    }

    private CommandExecutionResult executePackageLink(AbstractClassOrObjectDiagram diagram, RegexResult arg) throws NoSuchColorException {
        String ent1String = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\"");
        String ent2String = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\"");
        IGroup cl1 = diagram.V1972() ? diagram.getGroupVerySmart(diagram.buildLeafIdent(ent1String)) : diagram.getGroup(diagram.buildCode(ent1String));
        IGroup cl2 = diagram.V1972() ? diagram.getGroupVerySmart(diagram.buildLeafIdent(ent2String)) : diagram.getGroup(diagram.buildCode(ent2String));
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        int queue = dir == Direction.LEFT || dir == Direction.RIGHT ? 1 : this.getQueueLength(arg);
        Display labelLink = Display.getWithNewlines(arg.get("LABEL_LINK", 0));
        String firstLabel = arg.get("FIRST_LABEL", 0);
        String secondLabel = arg.get("SECOND_LABEL", 0);
        Link link = new Link(cl1, cl2, linkType, labelLink, queue, firstLabel, secondLabel, diagram.getLabeldistance(), diagram.getLabelangle(), diagram.getSkinParam().getCurrentStyleBuilder());
        link.setColors(CommandLinkClass.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet()));
        diagram.resetPragmaLabel();
        link.applyStyle(diagram.getSkinParam().getThemeStyle(), arg.getLazzy("ARROW_STYLE", 0));
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        if (diagram.V1972()) {
            return this.executeArgSpecial1972Ident1(diagram, arg);
        }
        String name1A = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE1", 0));
        String name1B = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE1", 1));
        Code clName1A = diagram.buildCode(name1A);
        Code clName1B = diagram.buildCode(name1B);
        if (!diagram.leafExist(clName1A)) {
            return CommandExecutionResult.error("No class " + clName1A);
        }
        if (!diagram.leafExist(clName1B)) {
            return CommandExecutionResult.error("No class " + clName1B);
        }
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\"");
        Code ent2 = diagram.buildCode(idShort);
        IEntity cl2 = diagram.getOrCreateLeaf(diagram.buildLeafIdent(idShort), ent2, null, null);
        boolean result = diagram.associationClass(1, name1A, name1B, cl2, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0)));
        if (!result) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1972Ident1(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        String name1A = arg.get("COUPLE1", 0);
        String name1B = arg.get("COUPLE1", 1);
        Ident ident1A = diagram.buildLeafIdent(name1A);
        Ident ident1B = diagram.buildLeafIdent(name1B);
        if (!diagram.leafExistSmart(ident1A)) {
            return CommandExecutionResult.error("No class " + ident1A.getName());
        }
        if (!diagram.leafExistSmart(ident1B)) {
            return CommandExecutionResult.error("No class " + ident1B.getName());
        }
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\"");
        Ident ident2 = diagram.buildLeafIdent(idShort);
        IEntity cl2 = diagram.getOrCreateLeaf(ident2, ident2, null, null);
        boolean result = diagram.associationClass(1, name1A, name1B, cl2, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0)));
        if (!result) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1972Ident2(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        String name2A = arg.get("COUPLE2", 0);
        String name2B = arg.get("COUPLE2", 1);
        Ident ident2A = diagram.buildLeafIdent(name2A);
        Ident ident2B = diagram.buildLeafIdent(name2B);
        if (!diagram.leafExistSmart(ident2A)) {
            return CommandExecutionResult.error("No class " + ident2A.getName());
        }
        if (!diagram.leafExistSmart(ident2B)) {
            return CommandExecutionResult.error("No class " + ident2B.getName());
        }
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\"");
        Ident ident1 = diagram.buildLeafIdent(idShort);
        IEntity cl1 = diagram.getOrCreateLeaf(ident1, ident1, null, null);
        boolean result = diagram.associationClass(2, name2A, name2B, cl1, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0)));
        if (!result) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1972Ident3(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        String name1A = arg.get("COUPLE1", 0);
        String name1B = arg.get("COUPLE1", 1);
        String name2A = arg.get("COUPLE2", 0);
        String name2B = arg.get("COUPLE2", 1);
        Ident ident1A = diagram.buildLeafIdent(name1A);
        Ident ident1B = diagram.buildLeafIdent(name1B);
        Ident ident2A = diagram.buildLeafIdent(name2A);
        Ident ident2B = diagram.buildLeafIdent(name2B);
        if (!diagram.leafExistSmart(ident1A)) {
            return CommandExecutionResult.error("No class " + ident1A.getName());
        }
        if (!diagram.leafExistSmart(ident1B)) {
            return CommandExecutionResult.error("No class " + ident1B.getName());
        }
        if (!diagram.leafExistSmart(ident2A)) {
            return CommandExecutionResult.error("No class " + ident2A.getName());
        }
        if (!diagram.leafExistSmart(ident2B)) {
            return CommandExecutionResult.error("No class " + ident2B.getName());
        }
        LinkType linkType = this.getLinkType(arg);
        Display label = Display.getWithNewlines(arg.get("LABEL_LINK", 0));
        return diagram.associationClass(name1A, name1B, name2A, name2B, linkType, label);
    }

    private CommandExecutionResult executeArgSpecial3(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        if (diagram.V1972()) {
            return this.executeArgSpecial1972Ident3(diagram, arg);
        }
        String name1A = arg.get("COUPLE1", 0);
        String name1B = arg.get("COUPLE1", 1);
        String name2A = arg.get("COUPLE2", 0);
        String name2B = arg.get("COUPLE2", 1);
        Code clName1A = diagram.buildCode(name1A);
        Code clName1B = diagram.buildCode(name1B);
        Code clName2A = diagram.buildCode(name2A);
        Code clName2B = diagram.buildCode(name2B);
        if (!diagram.leafExist(clName1A)) {
            return CommandExecutionResult.error("No class " + clName1A);
        }
        if (!diagram.leafExist(clName1B)) {
            return CommandExecutionResult.error("No class " + clName1B);
        }
        if (!diagram.leafExist(clName2A)) {
            return CommandExecutionResult.error("No class " + clName2A);
        }
        if (!diagram.leafExist(clName2B)) {
            return CommandExecutionResult.error("No class " + clName2B);
        }
        LinkType linkType = this.getLinkType(arg);
        Display label = Display.getWithNewlines(arg.get("LABEL_LINK", 0));
        return diagram.associationClass(name1A, name1B, name2A, name2B, linkType, label);
    }

    private CommandExecutionResult executeArgSpecial2(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        if (diagram.V1972()) {
            return this.executeArgSpecial1972Ident2(diagram, arg);
        }
        String name2A = arg.get("COUPLE2", 0);
        String name2B = arg.get("COUPLE2", 1);
        Code clName2A = diagram.buildCode(name2A);
        Code clName2B = diagram.buildCode(name2B);
        if (!diagram.leafExist(clName2A)) {
            return CommandExecutionResult.error("No class " + clName2A);
        }
        if (!diagram.leafExist(clName2B)) {
            return CommandExecutionResult.error("No class " + clName2B);
        }
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\"");
        Code ent1 = diagram.buildCode(idShort);
        IEntity cl1 = diagram.getOrCreateLeaf(diagram.buildLeafIdent(idShort), ent1, null, null);
        boolean result = diagram.associationClass(2, name2A, name2B, cl1, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0)));
        if (!result) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private LinkDecor getDecors1(String s) {
        if (s == null) {
            return LinkDecor.NONE;
        }
        if ("<|".equals(s = StringUtils.trin(s))) {
            return LinkDecor.EXTENDS;
        }
        if ("<|:".equals(s)) {
            return LinkDecor.DEFINEDBY;
        }
        if ("<||".equals(s)) {
            return LinkDecor.REDEFINES;
        }
        if ("}".equals(s)) {
            return LinkDecor.CROWFOOT;
        }
        if ("}o".equals(s)) {
            return LinkDecor.CIRCLE_CROWFOOT;
        }
        if ("}|".equals(s)) {
            return LinkDecor.LINE_CROWFOOT;
        }
        if ("|o".equals(s)) {
            return LinkDecor.CIRCLE_LINE;
        }
        if ("||".equals(s)) {
            return LinkDecor.DOUBLE_LINE;
        }
        if ("<".equals(s)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(s)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(s)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(s)) {
            return LinkDecor.AGREGATION;
        }
        if ("x".equals(s)) {
            return LinkDecor.NOT_NAVIGABLE;
        }
        if ("*".equals(s)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(s)) {
            return LinkDecor.SQUARE;
        }
        if (")".equals(s)) {
            return LinkDecor.PARENTHESIS;
        }
        return LinkDecor.NONE;
    }

    private LinkDecor getDecors2(String s) {
        if (s == null) {
            return LinkDecor.NONE;
        }
        if ("|>".equals(s = StringUtils.trin(s))) {
            return LinkDecor.EXTENDS;
        }
        if (":|>".equals(s)) {
            return LinkDecor.DEFINEDBY;
        }
        if ("||>".equals(s)) {
            return LinkDecor.REDEFINES;
        }
        if (">".equals(s)) {
            return LinkDecor.ARROW;
        }
        if ("{".equals(s)) {
            return LinkDecor.CROWFOOT;
        }
        if ("o{".equals(s)) {
            return LinkDecor.CIRCLE_CROWFOOT;
        }
        if ("|{".equals(s)) {
            return LinkDecor.LINE_CROWFOOT;
        }
        if ("o|".equals(s)) {
            return LinkDecor.CIRCLE_LINE;
        }
        if ("||".equals(s)) {
            return LinkDecor.DOUBLE_LINE;
        }
        if ("^".equals(s)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(s)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(s)) {
            return LinkDecor.AGREGATION;
        }
        if ("x".equals(s)) {
            return LinkDecor.NOT_NAVIGABLE;
        }
        if ("*".equals(s)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(s)) {
            return LinkDecor.SQUARE;
        }
        if ("(".equals(s)) {
            return LinkDecor.PARENTHESIS;
        }
        return LinkDecor.NONE;
    }

    private LinkType getLinkType(RegexResult arg) {
        String middle;
        LinkDecor decors1 = this.getDecors1(this.getArrowHead1(arg));
        LinkDecor decors2 = this.getDecors2(this.getArrowHead2(arg));
        LinkType result = new LinkType(decors2, decors1);
        if (arg.get("ARROW_BODY1", 0).contains(".") || arg.get("ARROW_BODY2", 0).contains(".")) {
            result = result.goDashed();
        }
        if ("0".equals(middle = arg.get("INSIDE", 0))) {
            result = result.withMiddleCircle();
        } else if ("0)".equals(middle)) {
            result = result.withMiddleCircleCircled1();
        } else if ("(0".equals(middle)) {
            result = result.withMiddleCircleCircled2();
        } else if ("(0)".equals(middle)) {
            result = result.withMiddleCircleCircled();
        }
        return result;
    }

    private int getQueueLength(RegexResult arg) {
        String s = this.getFullArrow(arg);
        s = s.replaceAll("[^-.=]", "");
        return s.length();
    }

    private Direction getDirection(RegexResult arg) {
        String s = this.getFullArrow(arg);
        if ((s = s.replaceAll("[^-.=\\w]", "")).startsWith("o")) {
            s = s.substring(1);
        }
        if (s.endsWith("o")) {
            s = s.substring(0, s.length() - 1);
        }
        Direction result = StringUtils.getQueueDirection(s);
        return result;
    }

    private String getArrowHead1(RegexResult arg) {
        return this.getArrowHead(arg, "ARROW_HEAD1");
    }

    private String getArrowHead2(RegexResult arg) {
        return this.getArrowHead(arg, "ARROW_HEAD2");
    }

    private String getArrowHead(RegexResult arg, String key) {
        return CommandLinkClass.notNull(arg.get(key, 0));
    }

    private String getFullArrow(RegexResult arg) {
        return this.getArrowHead1(arg) + CommandLinkClass.notNull(arg.get("ARROW_BODY1", 0)) + CommandLinkClass.notNull(arg.get("ARROW_DIRECTION", 0)) + CommandLinkClass.notNull(arg.get("ARROW_BODY2", 0)) + this.getArrowHead2(arg);
    }

    public static String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

