/**************************************************************************
**                                                                      **
** Copyright (C) 2011-2026 Lukas Spies                                  **
** Contact: https://photoqt.org                                         **
**                                                                      **
** This file is part of PhotoQt.                                        **
**                                                                      **
** PhotoQt is free software: you can redistribute it and/or modify      **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation, either version 2 of the License, or    **
** (at your option) any later version.                                  **
**                                                                      **
** PhotoQt is distributed in the hope that it will be useful,           **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      **
**                                                                      **
**************************************************************************/

/**//**//**//**//**//**//**//**//**//**//**//**//**//**//**/
//
// WARNING
// THIS FILE IS AUTO GENERATED BY `misc/pqc_settings.py`.
// ANY CHANGES HERE WILL BE OVERWRITTEN AT SOME POINT!
//
/**//**//**//**//**//**//**//**//**//**//**//**//**//**//**/

#include <QJSValue>
#include <QMessageBox>
#include <qlogging.h>   // needed in this form to compile with Qt 6.2
#include <QApplication>
#include <QtSql/QSqlError>
#include <QtSql/QSqlQuery>
#include <pqc_settings.h>
#include <pqc_settingscpp.h>
#include <pqc_configfiles.h>
#include <pqc_notify_cpp.h>
#include <pqc_extensionshandler.h>

PQCSettings::PQCSettings(bool validateonly) {
    if(validateonly) {
        dbCommitTimer = nullptr;
        qDebug() << "THIS INSTANCE SHOULD ONLY BE USED FOR VALIDATING!";
    } else
        PQCSettings();
}

PQCSettings::PQCSettings() {

    QSqlDatabase dbDefault;

    // create and connect to default database
    if(QSqlDatabase::contains("defaultsettings"))
        dbDefault = QSqlDatabase::database("defaultsettings");
    else {
        if(QSqlDatabase::isDriverAvailable("QSQLITE3"))
            dbDefault = QSqlDatabase::addDatabase("QSQLITE3", "defaultsettings");
        else if(QSqlDatabase::isDriverAvailable("QSQLITE"))
            dbDefault = QSqlDatabase::addDatabase("QSQLITE", "defaultsettings");
    }
    QFile::remove(PQCConfigFiles::get().DEFAULTSETTINGS_DB());
    QFile::copy(":/defaultsettings.db", PQCConfigFiles::get().DEFAULTSETTINGS_DB());
    dbDefault.setDatabaseName(PQCConfigFiles::get().DEFAULTSETTINGS_DB());
    if(!dbDefault.open()) {
        qCritical() << "ERROR opening default database:" << (PQCConfigFiles::get().DEFAULTSETTINGS_DB());
        QMessageBox::critical(0, QApplication::translate("PQSettings", "ERROR opening database with default settings"),
                            QApplication::translate("PQSettings", "I tried hard, but I just cannot open the database of default settings.") + QApplication::translate("PQSettings", "Something went terribly wrong somewhere!"));
        return;
    }

    QSqlDatabase db = QSqlDatabase::database("settings");

    dbtables = QStringList() << "general"
                            << "interface"
                            << "imageview"
                            << "thumbnails"
                            << "mainmenu"
                            << "metadata"
                            << "filetypes"
                            << "filedialog"
                            << "slideshow"
                            << "mapview";

    readonly = false;

    if(!db.open()) {

        qWarning() << "ERROR opening database:" << db.lastError().text();
        qWarning() << "Will load read-only set of default settings";

        readonly = true;

    } else {

        QFileInfo infodb(PQCConfigFiles::get().USERSETTINGS_DB());

        readonly = false;
        if(!infodb.permission(QFileDevice::WriteOwner))
            readonly = true;

    }

    dbIsTransaction = false;
    dbCommitTimer = new QTimer();
    dbCommitTimer->setSingleShot(true);
    dbCommitTimer->setInterval(400);
    connect(dbCommitTimer, &QTimer::timeout, this, [=](){
        QSqlDatabase db = QSqlDatabase::database("settings");
        db.commit();
        PQCSettingsCPP::get().readDB();
        dbIsTransaction = false;
        if(db.lastError().text().trimmed().length())
            qWarning() << "ERROR committing database:" << db.lastError().text();
    });

    /******************************************************/

    // set up with all defaults
    setupFresh();

    /******************************************************/

    // then update with user settings (if applicable)
    QFileInfo info(PQCConfigFiles::get().USERSETTINGS_DB());
    if(!info.exists()) {
        if(!QFile::copy(":/usersettings.db", PQCConfigFiles::get().USERSETTINGS_DB()))
            qWarning() << "Unable to (re-)create default settings database";
        else {
            QFile file(PQCConfigFiles::get().USERSETTINGS_DB());
            file.setPermissions(file.permissions()|QFileDevice::WriteOwner);
        }
    } else
        readDB();

    /******************************************************/
    
    // table: filedialog
    connect(this, &PQCSettings::filedialogDetailsTooltipChanged, this, [=]() { saveChangedValue("filedialogDetailsTooltip", m_filedialogDetailsTooltip); });
    connect(this, &PQCSettings::filedialogDevicesChanged, this, [=]() { saveChangedValue("filedialogDevices", m_filedialogDevices); });
    connect(this, &PQCSettings::filedialogDevicesShowTmpfsChanged, this, [=]() { saveChangedValue("filedialogDevicesShowTmpfs", m_filedialogDevicesShowTmpfs); });
    connect(this, &PQCSettings::filedialogDragDropFileviewGridChanged, this, [=]() { saveChangedValue("filedialogDragDropFileviewGrid", m_filedialogDragDropFileviewGrid); });
    connect(this, &PQCSettings::filedialogDragDropFileviewListChanged, this, [=]() { saveChangedValue("filedialogDragDropFileviewList", m_filedialogDragDropFileviewList); });
    connect(this, &PQCSettings::filedialogDragDropFileviewMasonryChanged, this, [=]() { saveChangedValue("filedialogDragDropFileviewMasonry", m_filedialogDragDropFileviewMasonry); });
    connect(this, &PQCSettings::filedialogDragDropPlacesChanged, this, [=]() { saveChangedValue("filedialogDragDropPlaces", m_filedialogDragDropPlaces); });
    connect(this, &PQCSettings::filedialogElementPaddingChanged, this, [=]() { saveChangedValue("filedialogElementPadding", m_filedialogElementPadding); });
    connect(this, &PQCSettings::filedialogFolderContentThumbnailsChanged, this, [=]() { saveChangedValue("filedialogFolderContentThumbnails", m_filedialogFolderContentThumbnails); });
    connect(this, &PQCSettings::filedialogFolderContentThumbnailsAutoloadChanged, this, [=]() { saveChangedValue("filedialogFolderContentThumbnailsAutoload", m_filedialogFolderContentThumbnailsAutoload); });
    connect(this, &PQCSettings::filedialogFolderContentThumbnailsLoopChanged, this, [=]() { saveChangedValue("filedialogFolderContentThumbnailsLoop", m_filedialogFolderContentThumbnailsLoop); });
    connect(this, &PQCSettings::filedialogFolderContentThumbnailsScaleCropChanged, this, [=]() { saveChangedValue("filedialogFolderContentThumbnailsScaleCrop", m_filedialogFolderContentThumbnailsScaleCrop); });
    connect(this, &PQCSettings::filedialogFolderContentThumbnailsSortAscendingChanged, this, [=]() { saveChangedValue("filedialogFolderContentThumbnailsSortAscending", m_filedialogFolderContentThumbnailsSortAscending); });
    connect(this, &PQCSettings::filedialogFolderContentThumbnailsSortByChanged, this, [=]() { saveChangedValue("filedialogFolderContentThumbnailsSortBy", m_filedialogFolderContentThumbnailsSortBy); });
    connect(this, &PQCSettings::filedialogFolderContentThumbnailsSpeedChanged, this, [=]() { saveChangedValue("filedialogFolderContentThumbnailsSpeed", m_filedialogFolderContentThumbnailsSpeed); });
    connect(this, &PQCSettings::filedialogLabelsShowGridChanged, this, [=]() { saveChangedValue("filedialogLabelsShowGrid", m_filedialogLabelsShowGrid); });
    connect(this, &PQCSettings::filedialogLabelsShowMasonryChanged, this, [=]() { saveChangedValue("filedialogLabelsShowMasonry", m_filedialogLabelsShowMasonry); });
    connect(this, &PQCSettings::filedialogLayoutChanged, this, [=]() { saveChangedValue("filedialogLayout", m_filedialogLayout); });
    connect(this, &PQCSettings::filedialogPlacesChanged, this, [=]() { saveChangedValue("filedialogPlaces", m_filedialogPlaces); });
    connect(this, &PQCSettings::filedialogPlacesWidthChanged, this, [=]() { saveChangedValue("filedialogPlacesWidth", m_filedialogPlacesWidth); });
    connect(this, &PQCSettings::filedialogPreviewChanged, this, [=]() { saveChangedValue("filedialogPreview", m_filedialogPreview); });
    connect(this, &PQCSettings::filedialogPreviewBlurChanged, this, [=]() { saveChangedValue("filedialogPreviewBlur", m_filedialogPreviewBlur); });
    connect(this, &PQCSettings::filedialogPreviewColorIntensityChanged, this, [=]() { saveChangedValue("filedialogPreviewColorIntensity", m_filedialogPreviewColorIntensity); });
    connect(this, &PQCSettings::filedialogPreviewCropToFitChanged, this, [=]() { saveChangedValue("filedialogPreviewCropToFit", m_filedialogPreviewCropToFit); });
    connect(this, &PQCSettings::filedialogPreviewHigherResolutionChanged, this, [=]() { saveChangedValue("filedialogPreviewHigherResolution", m_filedialogPreviewHigherResolution); });
    connect(this, &PQCSettings::filedialogPreviewMutedChanged, this, [=]() { saveChangedValue("filedialogPreviewMuted", m_filedialogPreviewMuted); });
    connect(this, &PQCSettings::filedialogRememberSelectionChanged, this, [=]() { saveChangedValue("filedialogRememberSelection", m_filedialogRememberSelection); });
    connect(this, &PQCSettings::filedialogShowHiddenFilesFoldersChanged, this, [=]() { saveChangedValue("filedialogShowHiddenFilesFolders", m_filedialogShowHiddenFilesFolders); });
    connect(this, &PQCSettings::filedialogSingleClickSelectChanged, this, [=]() { saveChangedValue("filedialogSingleClickSelect", m_filedialogSingleClickSelect); });
    connect(this, &PQCSettings::filedialogStartupRestoreCustomChanged, this, [=]() { saveChangedValue("filedialogStartupRestoreCustom", m_filedialogStartupRestoreCustom); });
    connect(this, &PQCSettings::filedialogStartupRestoreCustomFolderChanged, this, [=]() { saveChangedValue("filedialogStartupRestoreCustomFolder", m_filedialogStartupRestoreCustomFolder); });
    connect(this, &PQCSettings::filedialogStartupRestoreHomeChanged, this, [=]() { saveChangedValue("filedialogStartupRestoreHome", m_filedialogStartupRestoreHome); });
    connect(this, &PQCSettings::filedialogStartupRestorePreviousChanged, this, [=]() { saveChangedValue("filedialogStartupRestorePrevious", m_filedialogStartupRestorePrevious); });
    connect(this, &PQCSettings::filedialogThumbnailsChanged, this, [=]() { saveChangedValue("filedialogThumbnails", m_filedialogThumbnails); });
    connect(this, &PQCSettings::filedialogThumbnailsScaleCropChanged, this, [=]() { saveChangedValue("filedialogThumbnailsScaleCrop", m_filedialogThumbnailsScaleCrop); });
    connect(this, &PQCSettings::filedialogUseNativeFileDialogChanged, this, [=]() { saveChangedValue("filedialogUseNativeFileDialog", m_filedialogUseNativeFileDialog); });
    connect(this, &PQCSettings::filedialogZoomChanged, this, [=]() { saveChangedValue("filedialogZoom", m_filedialogZoom); });
    // table: filetypes
    connect(this, &PQCSettings::filetypesAnimatedControlsChanged, this, [=]() { saveChangedValue("filetypesAnimatedControls", m_filetypesAnimatedControls); });
    connect(this, &PQCSettings::filetypesAnimatedLeftRightChanged, this, [=]() { saveChangedValue("filetypesAnimatedLeftRight", m_filetypesAnimatedLeftRight); });
    connect(this, &PQCSettings::filetypesAnimatedSpacePauseChanged, this, [=]() { saveChangedValue("filetypesAnimatedSpacePause", m_filetypesAnimatedSpacePause); });
    connect(this, &PQCSettings::filetypesArchiveAlwaysEnterAutomaticallyChanged, this, [=]() { saveChangedValue("filetypesArchiveAlwaysEnterAutomatically", m_filetypesArchiveAlwaysEnterAutomatically); });
    connect(this, &PQCSettings::filetypesArchiveControlsChanged, this, [=]() { saveChangedValue("filetypesArchiveControls", m_filetypesArchiveControls); });
    connect(this, &PQCSettings::filetypesArchiveDontLoadMoreFilesThanChanged, this, [=]() { saveChangedValue("filetypesArchiveDontLoadMoreFilesThan", m_filetypesArchiveDontLoadMoreFilesThan); });
    connect(this, &PQCSettings::filetypesArchiveDontLoadMoreFilesThanCountChanged, this, [=]() { saveChangedValue("filetypesArchiveDontLoadMoreFilesThanCount", m_filetypesArchiveDontLoadMoreFilesThanCount); });
    connect(this, &PQCSettings::filetypesArchiveIgnoreLargerThanChanged, this, [=]() { saveChangedValue("filetypesArchiveIgnoreLargerThan", m_filetypesArchiveIgnoreLargerThan); });
    connect(this, &PQCSettings::filetypesArchiveIgnoreLargerThanSizeChanged, this, [=]() { saveChangedValue("filetypesArchiveIgnoreLargerThanSize", m_filetypesArchiveIgnoreLargerThanSize); });
    connect(this, &PQCSettings::filetypesArchiveLeftRightChanged, this, [=]() { saveChangedValue("filetypesArchiveLeftRight", m_filetypesArchiveLeftRight); });
    connect(this, &PQCSettings::filetypesArchiveViewerModeExitButtonChanged, this, [=]() { saveChangedValue("filetypesArchiveViewerModeExitButton", m_filetypesArchiveViewerModeExitButton); });
    connect(this, &PQCSettings::filetypesComicBookAlwaysEnterAutomaticallyChanged, this, [=]() { saveChangedValue("filetypesComicBookAlwaysEnterAutomatically", m_filetypesComicBookAlwaysEnterAutomatically); });
    connect(this, &PQCSettings::filetypesDocumentAlwaysEnterAutomaticallyChanged, this, [=]() { saveChangedValue("filetypesDocumentAlwaysEnterAutomatically", m_filetypesDocumentAlwaysEnterAutomatically); });
    connect(this, &PQCSettings::filetypesDocumentControlsChanged, this, [=]() { saveChangedValue("filetypesDocumentControls", m_filetypesDocumentControls); });
    connect(this, &PQCSettings::filetypesDocumentLeftRightChanged, this, [=]() { saveChangedValue("filetypesDocumentLeftRight", m_filetypesDocumentLeftRight); });
    connect(this, &PQCSettings::filetypesDocumentViewerModeExitButtonChanged, this, [=]() { saveChangedValue("filetypesDocumentViewerModeExitButton", m_filetypesDocumentViewerModeExitButton); });
    connect(this, &PQCSettings::filetypesExternalUnrarChanged, this, [=]() { saveChangedValue("filetypesExternalUnrar", m_filetypesExternalUnrar); });
    connect(this, &PQCSettings::filetypesLoadAppleLivePhotosChanged, this, [=]() { saveChangedValue("filetypesLoadAppleLivePhotos", m_filetypesLoadAppleLivePhotos); });
    connect(this, &PQCSettings::filetypesLoadMotionPhotosChanged, this, [=]() { saveChangedValue("filetypesLoadMotionPhotos", m_filetypesLoadMotionPhotos); });
    connect(this, &PQCSettings::filetypesMotionAutoPlayChanged, this, [=]() { saveChangedValue("filetypesMotionAutoPlay", m_filetypesMotionAutoPlay); });
    connect(this, &PQCSettings::filetypesMotionPhotoPlayPauseChanged, this, [=]() { saveChangedValue("filetypesMotionPhotoPlayPause", m_filetypesMotionPhotoPlayPause); });
    connect(this, &PQCSettings::filetypesMotionSpacePauseChanged, this, [=]() { saveChangedValue("filetypesMotionSpacePause", m_filetypesMotionSpacePause); });
    connect(this, &PQCSettings::filetypesPDFQualityChanged, this, [=]() { saveChangedValue("filetypesPDFQuality", m_filetypesPDFQuality); });
    connect(this, &PQCSettings::filetypesPhotoSphereArrowKeysChanged, this, [=]() { saveChangedValue("filetypesPhotoSphereArrowKeys", m_filetypesPhotoSphereArrowKeys); });
    connect(this, &PQCSettings::filetypesPhotoSphereAutoLoadChanged, this, [=]() { saveChangedValue("filetypesPhotoSphereAutoLoad", m_filetypesPhotoSphereAutoLoad); });
    connect(this, &PQCSettings::filetypesPhotoSphereBigButtonChanged, this, [=]() { saveChangedValue("filetypesPhotoSphereBigButton", m_filetypesPhotoSphereBigButton); });
    connect(this, &PQCSettings::filetypesPhotoSphereControlsChanged, this, [=]() { saveChangedValue("filetypesPhotoSphereControls", m_filetypesPhotoSphereControls); });
    connect(this, &PQCSettings::filetypesPhotoSpherePanOnLoadChanged, this, [=]() { saveChangedValue("filetypesPhotoSpherePanOnLoad", m_filetypesPhotoSpherePanOnLoad); });
    connect(this, &PQCSettings::filetypesRAWUseEmbeddedIfAvailableChanged, this, [=]() { saveChangedValue("filetypesRAWUseEmbeddedIfAvailable", m_filetypesRAWUseEmbeddedIfAvailable); });
    connect(this, &PQCSettings::filetypesVideoAutoplayChanged, this, [=]() { saveChangedValue("filetypesVideoAutoplay", m_filetypesVideoAutoplay); });
    connect(this, &PQCSettings::filetypesVideoLeftRightJumpVideoChanged, this, [=]() { saveChangedValue("filetypesVideoLeftRightJumpVideo", m_filetypesVideoLeftRightJumpVideo); });
    connect(this, &PQCSettings::filetypesVideoLoopChanged, this, [=]() { saveChangedValue("filetypesVideoLoop", m_filetypesVideoLoop); });
    connect(this, &PQCSettings::filetypesVideoPreferLibmpvChanged, this, [=]() { saveChangedValue("filetypesVideoPreferLibmpv", m_filetypesVideoPreferLibmpv); });
    connect(this, &PQCSettings::filetypesVideoSpacePauseChanged, this, [=]() { saveChangedValue("filetypesVideoSpacePause", m_filetypesVideoSpacePause); });
    connect(this, &PQCSettings::filetypesVideoThumbnailerChanged, this, [=]() { saveChangedValue("filetypesVideoThumbnailer", m_filetypesVideoThumbnailer); });
    connect(this, &PQCSettings::filetypesVideoVolumeChanged, this, [=]() { saveChangedValue("filetypesVideoVolume", m_filetypesVideoVolume); });
    // table: general
    connect(this, &PQCSettings::generalAutoSaveSettingsChanged, this, [=]() { saveChangedValue("generalAutoSaveSettings", m_generalAutoSaveSettings); });
    connect(this, &PQCSettings::generalCompactSettingsChanged, this, [=]() { saveChangedValue("generalCompactSettings", m_generalCompactSettings); });
    connect(this, &PQCSettings::generalDisableAllAnimationsChanged, this, [=]() { saveChangedValue("generalDisableAllAnimations", m_generalDisableAllAnimations); });
    connect(this, &PQCSettings::generalExtensionsAllowUntrustedChanged, this, [=]() { saveChangedValue("generalExtensionsAllowUntrusted", m_generalExtensionsAllowUntrusted); });
    connect(this, &PQCSettings::generalExtensionsEnabledChanged, this, [=]() { saveChangedValue("generalExtensionsEnabled", m_generalExtensionsEnabled); });
    connect(this, &PQCSettings::generalExtensionsFloatingSetupChanged, this, [=]() { saveChangedValue("generalExtensionsFloatingSetup", m_generalExtensionsFloatingSetup); });
    connect(this, &PQCSettings::generalInterfaceVariantChanged, this, [=]() { saveChangedValue("generalInterfaceVariant", m_generalInterfaceVariant); });
    connect(this, &PQCSettings::generalVersionChanged, this, [=]() { saveChangedValue("generalVersion", m_generalVersion); });
    // table: imageview
    connect(this, &PQCSettings::imageviewAdvancedSortAscendingChanged, this, [=]() { saveChangedValue("imageviewAdvancedSortAscending", m_imageviewAdvancedSortAscending); });
    connect(this, &PQCSettings::imageviewAdvancedSortCriteriaChanged, this, [=]() { saveChangedValue("imageviewAdvancedSortCriteria", m_imageviewAdvancedSortCriteria); });
    connect(this, &PQCSettings::imageviewAdvancedSortDateCriteriaChanged, this, [=]() { saveChangedValue("imageviewAdvancedSortDateCriteria", m_imageviewAdvancedSortDateCriteria); });
    connect(this, &PQCSettings::imageviewAdvancedSortQualityChanged, this, [=]() { saveChangedValue("imageviewAdvancedSortQuality", m_imageviewAdvancedSortQuality); });
    connect(this, &PQCSettings::imageviewAlwaysActualSizeChanged, this, [=]() { saveChangedValue("imageviewAlwaysActualSize", m_imageviewAlwaysActualSize); });
    connect(this, &PQCSettings::imageviewAnimationDurationChanged, this, [=]() { saveChangedValue("imageviewAnimationDuration", m_imageviewAnimationDuration); });
    connect(this, &PQCSettings::imageviewAnimationTypeChanged, this, [=]() { saveChangedValue("imageviewAnimationType", m_imageviewAnimationType); });
    connect(this, &PQCSettings::imageviewCacheChanged, this, [=]() { saveChangedValue("imageviewCache", m_imageviewCache); });
    connect(this, &PQCSettings::imageviewColorSpaceContextMenuChanged, this, [=]() { saveChangedValue("imageviewColorSpaceContextMenu", m_imageviewColorSpaceContextMenu); });
    connect(this, &PQCSettings::imageviewColorSpaceDefaultChanged, this, [=]() { saveChangedValue("imageviewColorSpaceDefault", m_imageviewColorSpaceDefault); });
    connect(this, &PQCSettings::imageviewColorSpaceEnableChanged, this, [=]() { saveChangedValue("imageviewColorSpaceEnable", m_imageviewColorSpaceEnable); });
    connect(this, &PQCSettings::imageviewColorSpaceLoadEmbeddedChanged, this, [=]() { saveChangedValue("imageviewColorSpaceLoadEmbedded", m_imageviewColorSpaceLoadEmbedded); });
    connect(this, &PQCSettings::imageviewEscapeExitArchiveChanged, this, [=]() { saveChangedValue("imageviewEscapeExitArchive", m_imageviewEscapeExitArchive); });
    connect(this, &PQCSettings::imageviewEscapeExitBarcodesChanged, this, [=]() { saveChangedValue("imageviewEscapeExitBarcodes", m_imageviewEscapeExitBarcodes); });
    connect(this, &PQCSettings::imageviewEscapeExitDocumentChanged, this, [=]() { saveChangedValue("imageviewEscapeExitDocument", m_imageviewEscapeExitDocument); });
    connect(this, &PQCSettings::imageviewEscapeExitFilterChanged, this, [=]() { saveChangedValue("imageviewEscapeExitFilter", m_imageviewEscapeExitFilter); });
    connect(this, &PQCSettings::imageviewEscapeExitSphereChanged, this, [=]() { saveChangedValue("imageviewEscapeExitSphere", m_imageviewEscapeExitSphere); });
    connect(this, &PQCSettings::imageviewFitInWindowChanged, this, [=]() { saveChangedValue("imageviewFitInWindow", m_imageviewFitInWindow); });
    connect(this, &PQCSettings::imageviewHideCursorTimeoutChanged, this, [=]() { saveChangedValue("imageviewHideCursorTimeout", m_imageviewHideCursorTimeout); });
    connect(this, &PQCSettings::imageviewInterpolationDisableForSmallImagesChanged, this, [=]() { saveChangedValue("imageviewInterpolationDisableForSmallImages", m_imageviewInterpolationDisableForSmallImages); });
    connect(this, &PQCSettings::imageviewLoopThroughFolderChanged, this, [=]() { saveChangedValue("imageviewLoopThroughFolder", m_imageviewLoopThroughFolder); });
    connect(this, &PQCSettings::imageviewMarginChanged, this, [=]() { saveChangedValue("imageviewMargin", m_imageviewMargin); });
    connect(this, &PQCSettings::imageviewMinimapSizeLevelChanged, this, [=]() { saveChangedValue("imageviewMinimapSizeLevel", m_imageviewMinimapSizeLevel); });
    connect(this, &PQCSettings::imageviewMirrorAnimateChanged, this, [=]() { saveChangedValue("imageviewMirrorAnimate", m_imageviewMirrorAnimate); });
    connect(this, &PQCSettings::imageviewMouseWheelRepeatDelayChanged, this, [=]() { saveChangedValue("imageviewMouseWheelRepeatDelay", m_imageviewMouseWheelRepeatDelay); });
    connect(this, &PQCSettings::imageviewPreloadInBackgroundChanged, this, [=]() { saveChangedValue("imageviewPreloadInBackground", m_imageviewPreloadInBackground); });
    connect(this, &PQCSettings::imageviewPreserveMirrorChanged, this, [=]() { saveChangedValue("imageviewPreserveMirror", m_imageviewPreserveMirror); });
    connect(this, &PQCSettings::imageviewPreserveRotationChanged, this, [=]() { saveChangedValue("imageviewPreserveRotation", m_imageviewPreserveRotation); });
    connect(this, &PQCSettings::imageviewPreserveZoomChanged, this, [=]() { saveChangedValue("imageviewPreserveZoom", m_imageviewPreserveZoom); });
    connect(this, &PQCSettings::imageviewRememberZoomRotationMirrorChanged, this, [=]() { saveChangedValue("imageviewRememberZoomRotationMirror", m_imageviewRememberZoomRotationMirror); });
    connect(this, &PQCSettings::imageviewResetViewAutoHideTimeoutChanged, this, [=]() { saveChangedValue("imageviewResetViewAutoHideTimeout", m_imageviewResetViewAutoHideTimeout); });
    connect(this, &PQCSettings::imageviewResetViewShowChanged, this, [=]() { saveChangedValue("imageviewResetViewShow", m_imageviewResetViewShow); });
    connect(this, &PQCSettings::imageviewRespectDevicePixelRatioChanged, this, [=]() { saveChangedValue("imageviewRespectDevicePixelRatio", m_imageviewRespectDevicePixelRatio); });
    connect(this, &PQCSettings::imageviewShowMinimapChanged, this, [=]() { saveChangedValue("imageviewShowMinimap", m_imageviewShowMinimap); });
    connect(this, &PQCSettings::imageviewSiblingFileMaxIterationsChanged, this, [=]() { saveChangedValue("imageviewSiblingFileMaxIterations", m_imageviewSiblingFileMaxIterations); });
    connect(this, &PQCSettings::imageviewSiblingFileMaxLevelUpChanged, this, [=]() { saveChangedValue("imageviewSiblingFileMaxLevelUp", m_imageviewSiblingFileMaxLevelUp); });
    connect(this, &PQCSettings::imageviewSiblingFilemaxLevelDownChanged, this, [=]() { saveChangedValue("imageviewSiblingFilemaxLevelDown", m_imageviewSiblingFilemaxLevelDown); });
    connect(this, &PQCSettings::imageviewSortImagesAscendingChanged, this, [=]() { saveChangedValue("imageviewSortImagesAscending", m_imageviewSortImagesAscending); });
    connect(this, &PQCSettings::imageviewSortImagesByChanged, this, [=]() { saveChangedValue("imageviewSortImagesBy", m_imageviewSortImagesBy); });
    connect(this, &PQCSettings::imageviewTransparencyMarkerChanged, this, [=]() { saveChangedValue("imageviewTransparencyMarker", m_imageviewTransparencyMarker); });
    connect(this, &PQCSettings::imageviewUseMouseLeftButtonForImageMoveChanged, this, [=]() { saveChangedValue("imageviewUseMouseLeftButtonForImageMove", m_imageviewUseMouseLeftButtonForImageMove); });
    connect(this, &PQCSettings::imageviewUseMouseWheelForImageMoveChanged, this, [=]() { saveChangedValue("imageviewUseMouseWheelForImageMove", m_imageviewUseMouseWheelForImageMove); });
    connect(this, &PQCSettings::imageviewZoomMaxChanged, this, [=]() { saveChangedValue("imageviewZoomMax", m_imageviewZoomMax); });
    connect(this, &PQCSettings::imageviewZoomMaxEnabledChanged, this, [=]() { saveChangedValue("imageviewZoomMaxEnabled", m_imageviewZoomMaxEnabled); });
    connect(this, &PQCSettings::imageviewZoomMinChanged, this, [=]() { saveChangedValue("imageviewZoomMin", m_imageviewZoomMin); });
    connect(this, &PQCSettings::imageviewZoomMinEnabledChanged, this, [=]() { saveChangedValue("imageviewZoomMinEnabled", m_imageviewZoomMinEnabled); });
    connect(this, &PQCSettings::imageviewZoomSpeedChanged, this, [=]() { saveChangedValue("imageviewZoomSpeed", m_imageviewZoomSpeed); });
    connect(this, &PQCSettings::imageviewZoomSpeedRelativeChanged, this, [=]() { saveChangedValue("imageviewZoomSpeedRelative", m_imageviewZoomSpeedRelative); });
    connect(this, &PQCSettings::imageviewZoomToCenterChanged, this, [=]() { saveChangedValue("imageviewZoomToCenter", m_imageviewZoomToCenter); });
    // table: interface
    connect(this, &PQCSettings::interfaceAccentColorChanged, this, [=]() { saveChangedValue("interfaceAccentColor", m_interfaceAccentColor); });
    connect(this, &PQCSettings::interfaceAllowMultipleInstancesChanged, this, [=]() { saveChangedValue("interfaceAllowMultipleInstances", m_interfaceAllowMultipleInstances); });
    connect(this, &PQCSettings::interfaceBackgroundCustomOverlayChanged, this, [=]() { saveChangedValue("interfaceBackgroundCustomOverlay", m_interfaceBackgroundCustomOverlay); });
    connect(this, &PQCSettings::interfaceBackgroundCustomOverlayColorChanged, this, [=]() { saveChangedValue("interfaceBackgroundCustomOverlayColor", m_interfaceBackgroundCustomOverlayColor); });
    connect(this, &PQCSettings::interfaceBackgroundFullyTransparentChanged, this, [=]() { saveChangedValue("interfaceBackgroundFullyTransparent", m_interfaceBackgroundFullyTransparent); });
    connect(this, &PQCSettings::interfaceBackgroundImageCenterChanged, this, [=]() { saveChangedValue("interfaceBackgroundImageCenter", m_interfaceBackgroundImageCenter); });
    connect(this, &PQCSettings::interfaceBackgroundImagePathChanged, this, [=]() { saveChangedValue("interfaceBackgroundImagePath", m_interfaceBackgroundImagePath); });
    connect(this, &PQCSettings::interfaceBackgroundImageScaleChanged, this, [=]() { saveChangedValue("interfaceBackgroundImageScale", m_interfaceBackgroundImageScale); });
    connect(this, &PQCSettings::interfaceBackgroundImageScaleCropChanged, this, [=]() { saveChangedValue("interfaceBackgroundImageScaleCrop", m_interfaceBackgroundImageScaleCrop); });
    connect(this, &PQCSettings::interfaceBackgroundImageScreenshotChanged, this, [=]() { saveChangedValue("interfaceBackgroundImageScreenshot", m_interfaceBackgroundImageScreenshot); });
    connect(this, &PQCSettings::interfaceBackgroundImageStretchChanged, this, [=]() { saveChangedValue("interfaceBackgroundImageStretch", m_interfaceBackgroundImageStretch); });
    connect(this, &PQCSettings::interfaceBackgroundImageTileChanged, this, [=]() { saveChangedValue("interfaceBackgroundImageTile", m_interfaceBackgroundImageTile); });
    connect(this, &PQCSettings::interfaceBackgroundImageUseChanged, this, [=]() { saveChangedValue("interfaceBackgroundImageUse", m_interfaceBackgroundImageUse); });
    connect(this, &PQCSettings::interfaceBackgroundSolidChanged, this, [=]() { saveChangedValue("interfaceBackgroundSolid", m_interfaceBackgroundSolid); });
    connect(this, &PQCSettings::interfaceBlurElementsInBackgroundChanged, this, [=]() { saveChangedValue("interfaceBlurElementsInBackground", m_interfaceBlurElementsInBackground); });
    connect(this, &PQCSettings::interfaceCloseOnEmptyBackgroundChanged, this, [=]() { saveChangedValue("interfaceCloseOnEmptyBackground", m_interfaceCloseOnEmptyBackground); });
    connect(this, &PQCSettings::interfaceDoubleClickThresholdChanged, this, [=]() { saveChangedValue("interfaceDoubleClickThreshold", m_interfaceDoubleClickThreshold); });
    connect(this, &PQCSettings::interfaceEdgeBottomActionChanged, this, [=]() { saveChangedValue("interfaceEdgeBottomAction", m_interfaceEdgeBottomAction); });
    connect(this, &PQCSettings::interfaceEdgeLeftActionChanged, this, [=]() { saveChangedValue("interfaceEdgeLeftAction", m_interfaceEdgeLeftAction); });
    connect(this, &PQCSettings::interfaceEdgeRightActionChanged, this, [=]() { saveChangedValue("interfaceEdgeRightAction", m_interfaceEdgeRightAction); });
    connect(this, &PQCSettings::interfaceEdgeTopActionChanged, this, [=]() { saveChangedValue("interfaceEdgeTopAction", m_interfaceEdgeTopAction); });
    connect(this, &PQCSettings::interfaceFlickAdjustSpeedChanged, this, [=]() { saveChangedValue("interfaceFlickAdjustSpeed", m_interfaceFlickAdjustSpeed); });
    connect(this, &PQCSettings::interfaceFlickAdjustSpeedSpeedupChanged, this, [=]() { saveChangedValue("interfaceFlickAdjustSpeedSpeedup", m_interfaceFlickAdjustSpeedSpeedup); });
    connect(this, &PQCSettings::interfaceFontBoldWeightChanged, this, [=]() { saveChangedValue("interfaceFontBoldWeight", m_interfaceFontBoldWeight); });
    connect(this, &PQCSettings::interfaceFontNormalWeightChanged, this, [=]() { saveChangedValue("interfaceFontNormalWeight", m_interfaceFontNormalWeight); });
    connect(this, &PQCSettings::interfaceHotEdgeSizeChanged, this, [=]() { saveChangedValue("interfaceHotEdgeSize", m_interfaceHotEdgeSize); });
    connect(this, &PQCSettings::interfaceKeepWindowOnTopChanged, this, [=]() { saveChangedValue("interfaceKeepWindowOnTop", m_interfaceKeepWindowOnTop); });
    connect(this, &PQCSettings::interfaceLanguageChanged, this, [=]() { saveChangedValue("interfaceLanguage", m_interfaceLanguage); });
    connect(this, &PQCSettings::interfaceMinimapPopoutChanged, this, [=]() { saveChangedValue("interfaceMinimapPopout", m_interfaceMinimapPopout); });
    connect(this, &PQCSettings::interfaceNavigateOnEmptyBackgroundChanged, this, [=]() { saveChangedValue("interfaceNavigateOnEmptyBackground", m_interfaceNavigateOnEmptyBackground); });
    connect(this, &PQCSettings::interfaceNavigationFloatingChanged, this, [=]() { saveChangedValue("interfaceNavigationFloating", m_interfaceNavigationFloating); });
    connect(this, &PQCSettings::interfaceNotificationDistanceFromEdgeChanged, this, [=]() { saveChangedValue("interfaceNotificationDistanceFromEdge", m_interfaceNotificationDistanceFromEdge); });
    connect(this, &PQCSettings::interfaceNotificationLocationChanged, this, [=]() { saveChangedValue("interfaceNotificationLocation", m_interfaceNotificationLocation); });
    connect(this, &PQCSettings::interfaceNotificationTryNativeChanged, this, [=]() { saveChangedValue("interfaceNotificationTryNative", m_interfaceNotificationTryNative); });
    connect(this, &PQCSettings::interfacePopoutAboutChanged, this, [=]() { saveChangedValue("interfacePopoutAbout", m_interfacePopoutAbout); });
    connect(this, &PQCSettings::interfacePopoutAdvancedSortChanged, this, [=]() { saveChangedValue("interfacePopoutAdvancedSort", m_interfacePopoutAdvancedSort); });
    connect(this, &PQCSettings::interfacePopoutChromecastChanged, this, [=]() { saveChangedValue("interfacePopoutChromecast", m_interfacePopoutChromecast); });
    connect(this, &PQCSettings::interfacePopoutExportChanged, this, [=]() { saveChangedValue("interfacePopoutExport", m_interfacePopoutExport); });
    connect(this, &PQCSettings::interfacePopoutFileDeleteChanged, this, [=]() { saveChangedValue("interfacePopoutFileDelete", m_interfacePopoutFileDelete); });
    connect(this, &PQCSettings::interfacePopoutFileDialogChanged, this, [=]() { saveChangedValue("interfacePopoutFileDialog", m_interfacePopoutFileDialog); });
    connect(this, &PQCSettings::interfacePopoutFileDialogNonModalChanged, this, [=]() { saveChangedValue("interfacePopoutFileDialogNonModal", m_interfacePopoutFileDialogNonModal); });
    connect(this, &PQCSettings::interfacePopoutFileRenameChanged, this, [=]() { saveChangedValue("interfacePopoutFileRename", m_interfacePopoutFileRename); });
    connect(this, &PQCSettings::interfacePopoutFilterChanged, this, [=]() { saveChangedValue("interfacePopoutFilter", m_interfacePopoutFilter); });
    connect(this, &PQCSettings::interfacePopoutFindChanged, this, [=]() { saveChangedValue("interfacePopoutFind", m_interfacePopoutFind); });
    connect(this, &PQCSettings::interfacePopoutImgurChanged, this, [=]() { saveChangedValue("interfacePopoutImgur", m_interfacePopoutImgur); });
    connect(this, &PQCSettings::interfacePopoutMainMenuChanged, this, [=]() { saveChangedValue("interfacePopoutMainMenu", m_interfacePopoutMainMenu); });
    connect(this, &PQCSettings::interfacePopoutMapExplorerChanged, this, [=]() { saveChangedValue("interfacePopoutMapExplorer", m_interfacePopoutMapExplorer); });
    connect(this, &PQCSettings::interfacePopoutMapExplorerNonModalChanged, this, [=]() { saveChangedValue("interfacePopoutMapExplorerNonModal", m_interfacePopoutMapExplorerNonModal); });
    connect(this, &PQCSettings::interfacePopoutMetadataChanged, this, [=]() { saveChangedValue("interfacePopoutMetadata", m_interfacePopoutMetadata); });
    connect(this, &PQCSettings::interfacePopoutSettingsManagerChanged, this, [=]() { saveChangedValue("interfacePopoutSettingsManager", m_interfacePopoutSettingsManager); });
    connect(this, &PQCSettings::interfacePopoutSettingsManagerNonModalChanged, this, [=]() { saveChangedValue("interfacePopoutSettingsManagerNonModal", m_interfacePopoutSettingsManagerNonModal); });
    connect(this, &PQCSettings::interfacePopoutSlideshowControlsChanged, this, [=]() { saveChangedValue("interfacePopoutSlideshowControls", m_interfacePopoutSlideshowControls); });
    connect(this, &PQCSettings::interfacePopoutSlideshowSetupChanged, this, [=]() { saveChangedValue("interfacePopoutSlideshowSetup", m_interfacePopoutSlideshowSetup); });
    connect(this, &PQCSettings::interfacePopoutWhenWindowIsSmallChanged, this, [=]() { saveChangedValue("interfacePopoutWhenWindowIsSmall", m_interfacePopoutWhenWindowIsSmall); });
    connect(this, &PQCSettings::interfaceQuickActionsChanged, this, [=]() { saveChangedValue("interfaceQuickActions", m_interfaceQuickActions); });
    connect(this, &PQCSettings::interfaceQuickActionsHeightChanged, this, [=]() { saveChangedValue("interfaceQuickActionsHeight", m_interfaceQuickActionsHeight); });
    connect(this, &PQCSettings::interfaceQuickActionsItemsChanged, this, [=]() { saveChangedValue("interfaceQuickActionsItems", m_interfaceQuickActionsItems); });
    connect(this, &PQCSettings::interfaceRememberLastImageChanged, this, [=]() { saveChangedValue("interfaceRememberLastImage", m_interfaceRememberLastImage); });
    connect(this, &PQCSettings::interfaceSaveWindowGeometryChanged, this, [=]() { saveChangedValue("interfaceSaveWindowGeometry", m_interfaceSaveWindowGeometry); });
    connect(this, &PQCSettings::interfaceStatusInfoAutoHideChanged, this, [=]() { saveChangedValue("interfaceStatusInfoAutoHide", m_interfaceStatusInfoAutoHide); });
    connect(this, &PQCSettings::interfaceStatusInfoAutoHideTimeoutChanged, this, [=]() { saveChangedValue("interfaceStatusInfoAutoHideTimeout", m_interfaceStatusInfoAutoHideTimeout); });
    connect(this, &PQCSettings::interfaceStatusInfoAutoHideTopEdgeChanged, this, [=]() { saveChangedValue("interfaceStatusInfoAutoHideTopEdge", m_interfaceStatusInfoAutoHideTopEdge); });
    connect(this, &PQCSettings::interfaceStatusInfoFontSizeChanged, this, [=]() { saveChangedValue("interfaceStatusInfoFontSize", m_interfaceStatusInfoFontSize); });
    connect(this, &PQCSettings::interfaceStatusInfoListChanged, this, [=]() { saveChangedValue("interfaceStatusInfoList", m_interfaceStatusInfoList); });
    connect(this, &PQCSettings::interfaceStatusInfoManageWindowChanged, this, [=]() { saveChangedValue("interfaceStatusInfoManageWindow", m_interfaceStatusInfoManageWindow); });
    connect(this, &PQCSettings::interfaceStatusInfoPositionChanged, this, [=]() { saveChangedValue("interfaceStatusInfoPosition", m_interfaceStatusInfoPosition); });
    connect(this, &PQCSettings::interfaceStatusInfoShowChanged, this, [=]() { saveChangedValue("interfaceStatusInfoShow", m_interfaceStatusInfoShow); });
    connect(this, &PQCSettings::interfaceStatusInfoShowImageChangeChanged, this, [=]() { saveChangedValue("interfaceStatusInfoShowImageChange", m_interfaceStatusInfoShowImageChange); });
    connect(this, &PQCSettings::interfaceTrayIconChanged, this, [=]() { saveChangedValue("interfaceTrayIcon", m_interfaceTrayIcon); });
    connect(this, &PQCSettings::interfaceTrayIconHideResetChanged, this, [=]() { saveChangedValue("interfaceTrayIconHideReset", m_interfaceTrayIconHideReset); });
    connect(this, &PQCSettings::interfaceTrayIconMonochromeChanged, this, [=]() { saveChangedValue("interfaceTrayIconMonochrome", m_interfaceTrayIconMonochrome); });
    connect(this, &PQCSettings::interfaceWindowButtonsAutoHideChanged, this, [=]() { saveChangedValue("interfaceWindowButtonsAutoHide", m_interfaceWindowButtonsAutoHide); });
    connect(this, &PQCSettings::interfaceWindowButtonsAutoHideTimeoutChanged, this, [=]() { saveChangedValue("interfaceWindowButtonsAutoHideTimeout", m_interfaceWindowButtonsAutoHideTimeout); });
    connect(this, &PQCSettings::interfaceWindowButtonsAutoHideTopEdgeChanged, this, [=]() { saveChangedValue("interfaceWindowButtonsAutoHideTopEdge", m_interfaceWindowButtonsAutoHideTopEdge); });
    connect(this, &PQCSettings::interfaceWindowButtonsFollowAccentColorChanged, this, [=]() { saveChangedValue("interfaceWindowButtonsFollowAccentColor", m_interfaceWindowButtonsFollowAccentColor); });
    connect(this, &PQCSettings::interfaceWindowButtonsItemsChanged, this, [=]() { saveChangedValue("interfaceWindowButtonsItems", m_interfaceWindowButtonsItems); });
    connect(this, &PQCSettings::interfaceWindowButtonsShowChanged, this, [=]() { saveChangedValue("interfaceWindowButtonsShow", m_interfaceWindowButtonsShow); });
    connect(this, &PQCSettings::interfaceWindowButtonsSizeChanged, this, [=]() { saveChangedValue("interfaceWindowButtonsSize", m_interfaceWindowButtonsSize); });
    connect(this, &PQCSettings::interfaceWindowDecorationChanged, this, [=]() { saveChangedValue("interfaceWindowDecoration", m_interfaceWindowDecoration); });
    connect(this, &PQCSettings::interfaceWindowDecorationOnEmptyBackgroundChanged, this, [=]() { saveChangedValue("interfaceWindowDecorationOnEmptyBackground", m_interfaceWindowDecorationOnEmptyBackground); });
    connect(this, &PQCSettings::interfaceWindowModeChanged, this, [=]() { saveChangedValue("interfaceWindowMode", m_interfaceWindowMode); });
    // table: mainmenu
    connect(this, &PQCSettings::mainmenuElementHeightDynamicChanged, this, [=]() { saveChangedValue("mainmenuElementHeightDynamic", m_mainmenuElementHeightDynamic); });
    connect(this, &PQCSettings::mainmenuElementPositionChanged, this, [=]() { saveChangedValue("mainmenuElementPosition", m_mainmenuElementPosition); });
    connect(this, &PQCSettings::mainmenuElementSizeChanged, this, [=]() { saveChangedValue("mainmenuElementSize", m_mainmenuElementSize); });
    connect(this, &PQCSettings::mainmenuElementWidthChanged, this, [=]() { saveChangedValue("mainmenuElementWidth", m_mainmenuElementWidth); });
    connect(this, &PQCSettings::mainmenuShowExternalChanged, this, [=]() { saveChangedValue("mainmenuShowExternal", m_mainmenuShowExternal); });
    // table: mapview
    connect(this, &PQCSettings::mapviewCurrentPositionChanged, this, [=]() { saveChangedValue("mapviewCurrentPosition", m_mapviewCurrentPosition); });
    connect(this, &PQCSettings::mapviewCurrentSizeChanged, this, [=]() { saveChangedValue("mapviewCurrentSize", m_mapviewCurrentSize); });
    connect(this, &PQCSettings::mapviewCurrentVisibleChanged, this, [=]() { saveChangedValue("mapviewCurrentVisible", m_mapviewCurrentVisible); });
    connect(this, &PQCSettings::mapviewExplorerThumbnailsScaleCropChanged, this, [=]() { saveChangedValue("mapviewExplorerThumbnailsScaleCrop", m_mapviewExplorerThumbnailsScaleCrop); });
    connect(this, &PQCSettings::mapviewExplorerThumbnailsZoomLevelChanged, this, [=]() { saveChangedValue("mapviewExplorerThumbnailsZoomLevel", m_mapviewExplorerThumbnailsZoomLevel); });
    // table: metadata
    connect(this, &PQCSettings::metadataAutoRotationChanged, this, [=]() { saveChangedValue("metadataAutoRotation", m_metadataAutoRotation); });
    connect(this, &PQCSettings::metadataCopyrightChanged, this, [=]() { saveChangedValue("metadataCopyright", m_metadataCopyright); });
    connect(this, &PQCSettings::metadataDimensionsChanged, this, [=]() { saveChangedValue("metadataDimensions", m_metadataDimensions); });
    connect(this, &PQCSettings::metadataElementFloatingChanged, this, [=]() { saveChangedValue("metadataElementFloating", m_metadataElementFloating); });
    connect(this, &PQCSettings::metadataElementHeightDynamicChanged, this, [=]() { saveChangedValue("metadataElementHeightDynamic", m_metadataElementHeightDynamic); });
    connect(this, &PQCSettings::metadataElementPositionChanged, this, [=]() { saveChangedValue("metadataElementPosition", m_metadataElementPosition); });
    connect(this, &PQCSettings::metadataElementSizeChanged, this, [=]() { saveChangedValue("metadataElementSize", m_metadataElementSize); });
    connect(this, &PQCSettings::metadataElementVisibleChanged, this, [=]() { saveChangedValue("metadataElementVisible", m_metadataElementVisible); });
    connect(this, &PQCSettings::metadataExposureTimeChanged, this, [=]() { saveChangedValue("metadataExposureTime", m_metadataExposureTime); });
    connect(this, &PQCSettings::metadataFLengthChanged, this, [=]() { saveChangedValue("metadataFLength", m_metadataFLength); });
    connect(this, &PQCSettings::metadataFNumberChanged, this, [=]() { saveChangedValue("metadataFNumber", m_metadataFNumber); });
    connect(this, &PQCSettings::metadataFaceTagsBorderChanged, this, [=]() { saveChangedValue("metadataFaceTagsBorder", m_metadataFaceTagsBorder); });
    connect(this, &PQCSettings::metadataFaceTagsBorderColorChanged, this, [=]() { saveChangedValue("metadataFaceTagsBorderColor", m_metadataFaceTagsBorderColor); });
    connect(this, &PQCSettings::metadataFaceTagsBorderWidthChanged, this, [=]() { saveChangedValue("metadataFaceTagsBorderWidth", m_metadataFaceTagsBorderWidth); });
    connect(this, &PQCSettings::metadataFaceTagsEnabledChanged, this, [=]() { saveChangedValue("metadataFaceTagsEnabled", m_metadataFaceTagsEnabled); });
    connect(this, &PQCSettings::metadataFaceTagsFontSizeChanged, this, [=]() { saveChangedValue("metadataFaceTagsFontSize", m_metadataFaceTagsFontSize); });
    connect(this, &PQCSettings::metadataFaceTagsVisibilityChanged, this, [=]() { saveChangedValue("metadataFaceTagsVisibility", m_metadataFaceTagsVisibility); });
    connect(this, &PQCSettings::metadataFileSizeChanged, this, [=]() { saveChangedValue("metadataFileSize", m_metadataFileSize); });
    connect(this, &PQCSettings::metadataFileTypeChanged, this, [=]() { saveChangedValue("metadataFileType", m_metadataFileType); });
    connect(this, &PQCSettings::metadataFilenameChanged, this, [=]() { saveChangedValue("metadataFilename", m_metadataFilename); });
    connect(this, &PQCSettings::metadataFlashChanged, this, [=]() { saveChangedValue("metadataFlash", m_metadataFlash); });
    connect(this, &PQCSettings::metadataGpsChanged, this, [=]() { saveChangedValue("metadataGps", m_metadataGps); });
    connect(this, &PQCSettings::metadataGpsMapChanged, this, [=]() { saveChangedValue("metadataGpsMap", m_metadataGpsMap); });
    connect(this, &PQCSettings::metadataImageNumberChanged, this, [=]() { saveChangedValue("metadataImageNumber", m_metadataImageNumber); });
    connect(this, &PQCSettings::metadataIsoChanged, this, [=]() { saveChangedValue("metadataIso", m_metadataIso); });
    connect(this, &PQCSettings::metadataKeywordsChanged, this, [=]() { saveChangedValue("metadataKeywords", m_metadataKeywords); });
    connect(this, &PQCSettings::metadataLightSourceChanged, this, [=]() { saveChangedValue("metadataLightSource", m_metadataLightSource); });
    connect(this, &PQCSettings::metadataLocationChanged, this, [=]() { saveChangedValue("metadataLocation", m_metadataLocation); });
    connect(this, &PQCSettings::metadataMakeChanged, this, [=]() { saveChangedValue("metadataMake", m_metadataMake); });
    connect(this, &PQCSettings::metadataModelChanged, this, [=]() { saveChangedValue("metadataModel", m_metadataModel); });
    connect(this, &PQCSettings::metadataSceneTypeChanged, this, [=]() { saveChangedValue("metadataSceneType", m_metadataSceneType); });
    connect(this, &PQCSettings::metadataSideBarChanged, this, [=]() { saveChangedValue("metadataSideBar", m_metadataSideBar); });
    connect(this, &PQCSettings::metadataSideBarLocationChanged, this, [=]() { saveChangedValue("metadataSideBarLocation", m_metadataSideBarLocation); });
    connect(this, &PQCSettings::metadataSideBarWidthChanged, this, [=]() { saveChangedValue("metadataSideBarWidth", m_metadataSideBarWidth); });
    connect(this, &PQCSettings::metadataSoftwareChanged, this, [=]() { saveChangedValue("metadataSoftware", m_metadataSoftware); });
    connect(this, &PQCSettings::metadataTimeChanged, this, [=]() { saveChangedValue("metadataTime", m_metadataTime); });
    // table: slideshow
    connect(this, &PQCSettings::slideshowHideLabelsChanged, this, [=]() { saveChangedValue("slideshowHideLabels", m_slideshowHideLabels); });
    connect(this, &PQCSettings::slideshowHideWindowButtonsChanged, this, [=]() { saveChangedValue("slideshowHideWindowButtons", m_slideshowHideWindowButtons); });
    connect(this, &PQCSettings::slideshowImageTransitionChanged, this, [=]() { saveChangedValue("slideshowImageTransition", m_slideshowImageTransition); });
    connect(this, &PQCSettings::slideshowIncludeSubFoldersChanged, this, [=]() { saveChangedValue("slideshowIncludeSubFolders", m_slideshowIncludeSubFolders); });
    connect(this, &PQCSettings::slideshowLoopChanged, this, [=]() { saveChangedValue("slideshowLoop", m_slideshowLoop); });
    connect(this, &PQCSettings::slideshowMusicChanged, this, [=]() { saveChangedValue("slideshowMusic", m_slideshowMusic); });
    connect(this, &PQCSettings::slideshowMusicFileChanged, this, [=]() { saveChangedValue("slideshowMusicFile", m_slideshowMusicFile); });
    connect(this, &PQCSettings::slideshowMusicFilesChanged, this, [=]() { saveChangedValue("slideshowMusicFiles", m_slideshowMusicFiles); });
    connect(this, &PQCSettings::slideshowMusicShuffleChanged, this, [=]() { saveChangedValue("slideshowMusicShuffle", m_slideshowMusicShuffle); });
    connect(this, &PQCSettings::slideshowMusicVolumeVideosChanged, this, [=]() { saveChangedValue("slideshowMusicVolumeVideos", m_slideshowMusicVolumeVideos); });
    connect(this, &PQCSettings::slideshowShuffleChanged, this, [=]() { saveChangedValue("slideshowShuffle", m_slideshowShuffle); });
    connect(this, &PQCSettings::slideshowTimeChanged, this, [=]() { saveChangedValue("slideshowTime", m_slideshowTime); });
    connect(this, &PQCSettings::slideshowTypeAnimationChanged, this, [=]() { saveChangedValue("slideshowTypeAnimation", m_slideshowTypeAnimation); });
    // table: thumbnails
    connect(this, &PQCSettings::thumbnailsCacheChanged, this, [=]() { saveChangedValue("thumbnailsCache", m_thumbnailsCache); });
    connect(this, &PQCSettings::thumbnailsCacheBaseDirDefaultChanged, this, [=]() { saveChangedValue("thumbnailsCacheBaseDirDefault", m_thumbnailsCacheBaseDirDefault); });
    connect(this, &PQCSettings::thumbnailsCacheBaseDirLocationChanged, this, [=]() { saveChangedValue("thumbnailsCacheBaseDirLocation", m_thumbnailsCacheBaseDirLocation); });
    connect(this, &PQCSettings::thumbnailsCenterOnActiveChanged, this, [=]() { saveChangedValue("thumbnailsCenterOnActive", m_thumbnailsCenterOnActive); });
    connect(this, &PQCSettings::thumbnailsCropToFitChanged, this, [=]() { saveChangedValue("thumbnailsCropToFit", m_thumbnailsCropToFit); });
    connect(this, &PQCSettings::thumbnailsDisableChanged, this, [=]() { saveChangedValue("thumbnailsDisable", m_thumbnailsDisable); });
    connect(this, &PQCSettings::thumbnailsExcludeDropBoxChanged, this, [=]() { saveChangedValue("thumbnailsExcludeDropBox", m_thumbnailsExcludeDropBox); });
    connect(this, &PQCSettings::thumbnailsExcludeFoldersChanged, this, [=]() { saveChangedValue("thumbnailsExcludeFolders", m_thumbnailsExcludeFolders); });
    connect(this, &PQCSettings::thumbnailsExcludeNetworkSharesChanged, this, [=]() { saveChangedValue("thumbnailsExcludeNetworkShares", m_thumbnailsExcludeNetworkShares); });
    connect(this, &PQCSettings::thumbnailsExcludeNextcloudChanged, this, [=]() { saveChangedValue("thumbnailsExcludeNextcloud", m_thumbnailsExcludeNextcloud); });
    connect(this, &PQCSettings::thumbnailsExcludeOwnCloudChanged, this, [=]() { saveChangedValue("thumbnailsExcludeOwnCloud", m_thumbnailsExcludeOwnCloud); });
    connect(this, &PQCSettings::thumbnailsFilenameChanged, this, [=]() { saveChangedValue("thumbnailsFilename", m_thumbnailsFilename); });
    connect(this, &PQCSettings::thumbnailsFontSizeChanged, this, [=]() { saveChangedValue("thumbnailsFontSize", m_thumbnailsFontSize); });
    connect(this, &PQCSettings::thumbnailsHighlightAnimationChanged, this, [=]() { saveChangedValue("thumbnailsHighlightAnimation", m_thumbnailsHighlightAnimation); });
    connect(this, &PQCSettings::thumbnailsHighlightAnimationLiftUpChanged, this, [=]() { saveChangedValue("thumbnailsHighlightAnimationLiftUp", m_thumbnailsHighlightAnimationLiftUp); });
    connect(this, &PQCSettings::thumbnailsIconsOnlyChanged, this, [=]() { saveChangedValue("thumbnailsIconsOnly", m_thumbnailsIconsOnly); });
    connect(this, &PQCSettings::thumbnailsInactiveTransparentChanged, this, [=]() { saveChangedValue("thumbnailsInactiveTransparent", m_thumbnailsInactiveTransparent); });
    connect(this, &PQCSettings::thumbnailsMaxNumberThreadsChanged, this, [=]() { saveChangedValue("thumbnailsMaxNumberThreads", m_thumbnailsMaxNumberThreads); });
    connect(this, &PQCSettings::thumbnailsSameHeightVaryWidthChanged, this, [=]() { saveChangedValue("thumbnailsSameHeightVaryWidth", m_thumbnailsSameHeightVaryWidth); });
    connect(this, &PQCSettings::thumbnailsSizeChanged, this, [=]() { saveChangedValue("thumbnailsSize", m_thumbnailsSize); });
    connect(this, &PQCSettings::thumbnailsSmallThumbnailsKeepSmallChanged, this, [=]() { saveChangedValue("thumbnailsSmallThumbnailsKeepSmall", m_thumbnailsSmallThumbnailsKeepSmall); });
    connect(this, &PQCSettings::thumbnailsSpacingChanged, this, [=]() { saveChangedValue("thumbnailsSpacing", m_thumbnailsSpacing); });
    connect(this, &PQCSettings::thumbnailsTooltipChanged, this, [=]() { saveChangedValue("thumbnailsTooltip", m_thumbnailsTooltip); });
    connect(this, &PQCSettings::thumbnailsVisibilityChanged, this, [=]() { saveChangedValue("thumbnailsVisibility", m_thumbnailsVisibility); });

    /******************************************************/

    connect(&PQCNotifyCPP::get(), &PQCNotifyCPP::disableColorSpaceSupport, this, [=]() {{ setImageviewColorSpaceEnable(false); }});

}

PQCSettings::~PQCSettings() {{
    QSqlDatabase::removeDatabase("defaultsettings");
    QSqlDatabase::removeDatabase("settings");
    if(dbCommitTimer != nullptr) {{
        delete dbCommitTimer;
    }}
}}

bool PQCSettings::getFiledialogDetailsTooltip() {
    return m_filedialogDetailsTooltip;
}

void PQCSettings::setFiledialogDetailsTooltip(bool val) {
    if(val != m_filedialogDetailsTooltip) {
        m_filedialogDetailsTooltip = val;
        Q_EMIT filedialogDetailsTooltipChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogDetailsTooltip() {
        return true;
}

void PQCSettings::setDefaultForFiledialogDetailsTooltip() {
    if(true != m_filedialogDetailsTooltip) {
        m_filedialogDetailsTooltip = true;
        Q_EMIT filedialogDetailsTooltipChanged();
    }
}

bool PQCSettings::getFiledialogDevices() {
    return m_filedialogDevices;
}

void PQCSettings::setFiledialogDevices(bool val) {
    if(val != m_filedialogDevices) {
        m_filedialogDevices = val;
        Q_EMIT filedialogDevicesChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogDevices() {
        return false;
}

void PQCSettings::setDefaultForFiledialogDevices() {
    if(false != m_filedialogDevices) {
        m_filedialogDevices = false;
        Q_EMIT filedialogDevicesChanged();
    }
}

bool PQCSettings::getFiledialogDevicesShowTmpfs() {
    return m_filedialogDevicesShowTmpfs;
}

void PQCSettings::setFiledialogDevicesShowTmpfs(bool val) {
    if(val != m_filedialogDevicesShowTmpfs) {
        m_filedialogDevicesShowTmpfs = val;
        Q_EMIT filedialogDevicesShowTmpfsChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogDevicesShowTmpfs() {
        return false;
}

void PQCSettings::setDefaultForFiledialogDevicesShowTmpfs() {
    if(false != m_filedialogDevicesShowTmpfs) {
        m_filedialogDevicesShowTmpfs = false;
        Q_EMIT filedialogDevicesShowTmpfsChanged();
    }
}

bool PQCSettings::getFiledialogDragDropFileviewGrid() {
    return m_filedialogDragDropFileviewGrid;
}

void PQCSettings::setFiledialogDragDropFileviewGrid(bool val) {
    if(val != m_filedialogDragDropFileviewGrid) {
        m_filedialogDragDropFileviewGrid = val;
        Q_EMIT filedialogDragDropFileviewGridChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogDragDropFileviewGrid() {
        return false;
}

void PQCSettings::setDefaultForFiledialogDragDropFileviewGrid() {
    if(false != m_filedialogDragDropFileviewGrid) {
        m_filedialogDragDropFileviewGrid = false;
        Q_EMIT filedialogDragDropFileviewGridChanged();
    }
}

bool PQCSettings::getFiledialogDragDropFileviewList() {
    return m_filedialogDragDropFileviewList;
}

void PQCSettings::setFiledialogDragDropFileviewList(bool val) {
    if(val != m_filedialogDragDropFileviewList) {
        m_filedialogDragDropFileviewList = val;
        Q_EMIT filedialogDragDropFileviewListChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogDragDropFileviewList() {
        return true;
}

void PQCSettings::setDefaultForFiledialogDragDropFileviewList() {
    if(true != m_filedialogDragDropFileviewList) {
        m_filedialogDragDropFileviewList = true;
        Q_EMIT filedialogDragDropFileviewListChanged();
    }
}

bool PQCSettings::getFiledialogDragDropFileviewMasonry() {
    return m_filedialogDragDropFileviewMasonry;
}

void PQCSettings::setFiledialogDragDropFileviewMasonry(bool val) {
    if(val != m_filedialogDragDropFileviewMasonry) {
        m_filedialogDragDropFileviewMasonry = val;
        Q_EMIT filedialogDragDropFileviewMasonryChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogDragDropFileviewMasonry() {
        return false;
}

void PQCSettings::setDefaultForFiledialogDragDropFileviewMasonry() {
    if(false != m_filedialogDragDropFileviewMasonry) {
        m_filedialogDragDropFileviewMasonry = false;
        Q_EMIT filedialogDragDropFileviewMasonryChanged();
    }
}

bool PQCSettings::getFiledialogDragDropPlaces() {
    return m_filedialogDragDropPlaces;
}

void PQCSettings::setFiledialogDragDropPlaces(bool val) {
    if(val != m_filedialogDragDropPlaces) {
        m_filedialogDragDropPlaces = val;
        Q_EMIT filedialogDragDropPlacesChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogDragDropPlaces() {
        return true;
}

void PQCSettings::setDefaultForFiledialogDragDropPlaces() {
    if(true != m_filedialogDragDropPlaces) {
        m_filedialogDragDropPlaces = true;
        Q_EMIT filedialogDragDropPlacesChanged();
    }
}

int PQCSettings::getFiledialogElementPadding() {
    return m_filedialogElementPadding;
}

void PQCSettings::setFiledialogElementPadding(int val) {
    if(val != m_filedialogElementPadding) {
        m_filedialogElementPadding = val;
        Q_EMIT filedialogElementPaddingChanged();
    }
}

const int PQCSettings::getDefaultForFiledialogElementPadding() {
        return 1;
}

void PQCSettings::setDefaultForFiledialogElementPadding() {
    if(1 != m_filedialogElementPadding) {
        m_filedialogElementPadding = 1;
    }
}

bool PQCSettings::getFiledialogFolderContentThumbnails() {
    return m_filedialogFolderContentThumbnails;
}

void PQCSettings::setFiledialogFolderContentThumbnails(bool val) {
    if(val != m_filedialogFolderContentThumbnails) {
        m_filedialogFolderContentThumbnails = val;
        Q_EMIT filedialogFolderContentThumbnailsChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogFolderContentThumbnails() {
        return true;
}

void PQCSettings::setDefaultForFiledialogFolderContentThumbnails() {
    if(true != m_filedialogFolderContentThumbnails) {
        m_filedialogFolderContentThumbnails = true;
        Q_EMIT filedialogFolderContentThumbnailsChanged();
    }
}

bool PQCSettings::getFiledialogFolderContentThumbnailsAutoload() {
    return m_filedialogFolderContentThumbnailsAutoload;
}

void PQCSettings::setFiledialogFolderContentThumbnailsAutoload(bool val) {
    if(val != m_filedialogFolderContentThumbnailsAutoload) {
        m_filedialogFolderContentThumbnailsAutoload = val;
        Q_EMIT filedialogFolderContentThumbnailsAutoloadChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogFolderContentThumbnailsAutoload() {
        return false;
}

void PQCSettings::setDefaultForFiledialogFolderContentThumbnailsAutoload() {
    if(false != m_filedialogFolderContentThumbnailsAutoload) {
        m_filedialogFolderContentThumbnailsAutoload = false;
        Q_EMIT filedialogFolderContentThumbnailsAutoloadChanged();
    }
}

bool PQCSettings::getFiledialogFolderContentThumbnailsLoop() {
    return m_filedialogFolderContentThumbnailsLoop;
}

void PQCSettings::setFiledialogFolderContentThumbnailsLoop(bool val) {
    if(val != m_filedialogFolderContentThumbnailsLoop) {
        m_filedialogFolderContentThumbnailsLoop = val;
        Q_EMIT filedialogFolderContentThumbnailsLoopChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogFolderContentThumbnailsLoop() {
        return true;
}

void PQCSettings::setDefaultForFiledialogFolderContentThumbnailsLoop() {
    if(true != m_filedialogFolderContentThumbnailsLoop) {
        m_filedialogFolderContentThumbnailsLoop = true;
        Q_EMIT filedialogFolderContentThumbnailsLoopChanged();
    }
}

bool PQCSettings::getFiledialogFolderContentThumbnailsScaleCrop() {
    return m_filedialogFolderContentThumbnailsScaleCrop;
}

void PQCSettings::setFiledialogFolderContentThumbnailsScaleCrop(bool val) {
    if(val != m_filedialogFolderContentThumbnailsScaleCrop) {
        m_filedialogFolderContentThumbnailsScaleCrop = val;
        Q_EMIT filedialogFolderContentThumbnailsScaleCropChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogFolderContentThumbnailsScaleCrop() {
        return true;
}

void PQCSettings::setDefaultForFiledialogFolderContentThumbnailsScaleCrop() {
    if(true != m_filedialogFolderContentThumbnailsScaleCrop) {
        m_filedialogFolderContentThumbnailsScaleCrop = true;
        Q_EMIT filedialogFolderContentThumbnailsScaleCropChanged();
    }
}

bool PQCSettings::getFiledialogFolderContentThumbnailsSortAscending() {
    return m_filedialogFolderContentThumbnailsSortAscending;
}

void PQCSettings::setFiledialogFolderContentThumbnailsSortAscending(bool val) {
    if(val != m_filedialogFolderContentThumbnailsSortAscending) {
        m_filedialogFolderContentThumbnailsSortAscending = val;
        Q_EMIT filedialogFolderContentThumbnailsSortAscendingChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogFolderContentThumbnailsSortAscending() {
        return false;
}

void PQCSettings::setDefaultForFiledialogFolderContentThumbnailsSortAscending() {
    if(false != m_filedialogFolderContentThumbnailsSortAscending) {
        m_filedialogFolderContentThumbnailsSortAscending = false;
        Q_EMIT filedialogFolderContentThumbnailsSortAscendingChanged();
    }
}

QString PQCSettings::getFiledialogFolderContentThumbnailsSortBy() {
    return m_filedialogFolderContentThumbnailsSortBy;
}

void PQCSettings::setFiledialogFolderContentThumbnailsSortBy(QString val) {
    if(val != m_filedialogFolderContentThumbnailsSortBy) {
        m_filedialogFolderContentThumbnailsSortBy = val;
        Q_EMIT filedialogFolderContentThumbnailsSortByChanged();
    }
}

const QString PQCSettings::getDefaultForFiledialogFolderContentThumbnailsSortBy() {
        return "default";
}

void PQCSettings::setDefaultForFiledialogFolderContentThumbnailsSortBy() {
    if("default" != m_filedialogFolderContentThumbnailsSortBy) {
        m_filedialogFolderContentThumbnailsSortBy = "default";
        Q_EMIT filedialogFolderContentThumbnailsSortByChanged();
    }
}

int PQCSettings::getFiledialogFolderContentThumbnailsSpeed() {
    return m_filedialogFolderContentThumbnailsSpeed;
}

void PQCSettings::setFiledialogFolderContentThumbnailsSpeed(int val) {
    if(val != m_filedialogFolderContentThumbnailsSpeed) {
        m_filedialogFolderContentThumbnailsSpeed = val;
        Q_EMIT filedialogFolderContentThumbnailsSpeedChanged();
    }
}

const int PQCSettings::getDefaultForFiledialogFolderContentThumbnailsSpeed() {
        return 2;
}

void PQCSettings::setDefaultForFiledialogFolderContentThumbnailsSpeed() {
    if(2 != m_filedialogFolderContentThumbnailsSpeed) {
        m_filedialogFolderContentThumbnailsSpeed = 2;
    }
}

bool PQCSettings::getFiledialogLabelsShowGrid() {
    return m_filedialogLabelsShowGrid;
}

void PQCSettings::setFiledialogLabelsShowGrid(bool val) {
    if(val != m_filedialogLabelsShowGrid) {
        m_filedialogLabelsShowGrid = val;
        Q_EMIT filedialogLabelsShowGridChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogLabelsShowGrid() {
        return true;
}

void PQCSettings::setDefaultForFiledialogLabelsShowGrid() {
    if(true != m_filedialogLabelsShowGrid) {
        m_filedialogLabelsShowGrid = true;
        Q_EMIT filedialogLabelsShowGridChanged();
    }
}

bool PQCSettings::getFiledialogLabelsShowMasonry() {
    return m_filedialogLabelsShowMasonry;
}

void PQCSettings::setFiledialogLabelsShowMasonry(bool val) {
    if(val != m_filedialogLabelsShowMasonry) {
        m_filedialogLabelsShowMasonry = val;
        Q_EMIT filedialogLabelsShowMasonryChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogLabelsShowMasonry() {
        return false;
}

void PQCSettings::setDefaultForFiledialogLabelsShowMasonry() {
    if(false != m_filedialogLabelsShowMasonry) {
        m_filedialogLabelsShowMasonry = false;
        Q_EMIT filedialogLabelsShowMasonryChanged();
    }
}

QString PQCSettings::getFiledialogLayout() {
    return m_filedialogLayout;
}

void PQCSettings::setFiledialogLayout(QString val) {
    if(val != m_filedialogLayout) {
        m_filedialogLayout = val;
        Q_EMIT filedialogLayoutChanged();
    }
}

const QString PQCSettings::getDefaultForFiledialogLayout() {
        return "grid";
}

void PQCSettings::setDefaultForFiledialogLayout() {
    if("grid" != m_filedialogLayout) {
        m_filedialogLayout = "grid";
        Q_EMIT filedialogLayoutChanged();
    }
}

bool PQCSettings::getFiledialogPlaces() {
    return m_filedialogPlaces;
}

void PQCSettings::setFiledialogPlaces(bool val) {
    if(val != m_filedialogPlaces) {
        m_filedialogPlaces = val;
        Q_EMIT filedialogPlacesChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogPlaces() {
        return true;
}

void PQCSettings::setDefaultForFiledialogPlaces() {
    if(true != m_filedialogPlaces) {
        m_filedialogPlaces = true;
        Q_EMIT filedialogPlacesChanged();
    }
}

int PQCSettings::getFiledialogPlacesWidth() {
    return m_filedialogPlacesWidth;
}

void PQCSettings::setFiledialogPlacesWidth(int val) {
    if(val != m_filedialogPlacesWidth) {
        m_filedialogPlacesWidth = val;
        Q_EMIT filedialogPlacesWidthChanged();
    }
}

const int PQCSettings::getDefaultForFiledialogPlacesWidth() {
        return 290;
}

void PQCSettings::setDefaultForFiledialogPlacesWidth() {
    if(290 != m_filedialogPlacesWidth) {
        m_filedialogPlacesWidth = 290;
    }
}

bool PQCSettings::getFiledialogPreview() {
    return m_filedialogPreview;
}

void PQCSettings::setFiledialogPreview(bool val) {
    if(val != m_filedialogPreview) {
        m_filedialogPreview = val;
        Q_EMIT filedialogPreviewChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogPreview() {
        return false;
}

void PQCSettings::setDefaultForFiledialogPreview() {
    if(false != m_filedialogPreview) {
        m_filedialogPreview = false;
        Q_EMIT filedialogPreviewChanged();
    }
}

bool PQCSettings::getFiledialogPreviewBlur() {
    return m_filedialogPreviewBlur;
}

void PQCSettings::setFiledialogPreviewBlur(bool val) {
    if(val != m_filedialogPreviewBlur) {
        m_filedialogPreviewBlur = val;
        Q_EMIT filedialogPreviewBlurChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogPreviewBlur() {
        return false;
}

void PQCSettings::setDefaultForFiledialogPreviewBlur() {
    if(false != m_filedialogPreviewBlur) {
        m_filedialogPreviewBlur = false;
        Q_EMIT filedialogPreviewBlurChanged();
    }
}

int PQCSettings::getFiledialogPreviewColorIntensity() {
    return m_filedialogPreviewColorIntensity;
}

void PQCSettings::setFiledialogPreviewColorIntensity(int val) {
    if(val != m_filedialogPreviewColorIntensity) {
        m_filedialogPreviewColorIntensity = val;
        Q_EMIT filedialogPreviewColorIntensityChanged();
    }
}

const int PQCSettings::getDefaultForFiledialogPreviewColorIntensity() {
        return 50;
}

void PQCSettings::setDefaultForFiledialogPreviewColorIntensity() {
    if(50 != m_filedialogPreviewColorIntensity) {
        m_filedialogPreviewColorIntensity = 50;
    }
}

bool PQCSettings::getFiledialogPreviewCropToFit() {
    return m_filedialogPreviewCropToFit;
}

void PQCSettings::setFiledialogPreviewCropToFit(bool val) {
    if(val != m_filedialogPreviewCropToFit) {
        m_filedialogPreviewCropToFit = val;
        Q_EMIT filedialogPreviewCropToFitChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogPreviewCropToFit() {
        return true;
}

void PQCSettings::setDefaultForFiledialogPreviewCropToFit() {
    if(true != m_filedialogPreviewCropToFit) {
        m_filedialogPreviewCropToFit = true;
        Q_EMIT filedialogPreviewCropToFitChanged();
    }
}

bool PQCSettings::getFiledialogPreviewHigherResolution() {
    return m_filedialogPreviewHigherResolution;
}

void PQCSettings::setFiledialogPreviewHigherResolution(bool val) {
    if(val != m_filedialogPreviewHigherResolution) {
        m_filedialogPreviewHigherResolution = val;
        Q_EMIT filedialogPreviewHigherResolutionChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogPreviewHigherResolution() {
        return false;
}

void PQCSettings::setDefaultForFiledialogPreviewHigherResolution() {
    if(false != m_filedialogPreviewHigherResolution) {
        m_filedialogPreviewHigherResolution = false;
        Q_EMIT filedialogPreviewHigherResolutionChanged();
    }
}

bool PQCSettings::getFiledialogPreviewMuted() {
    return m_filedialogPreviewMuted;
}

void PQCSettings::setFiledialogPreviewMuted(bool val) {
    if(val != m_filedialogPreviewMuted) {
        m_filedialogPreviewMuted = val;
        Q_EMIT filedialogPreviewMutedChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogPreviewMuted() {
        return false;
}

void PQCSettings::setDefaultForFiledialogPreviewMuted() {
    if(false != m_filedialogPreviewMuted) {
        m_filedialogPreviewMuted = false;
        Q_EMIT filedialogPreviewMutedChanged();
    }
}

bool PQCSettings::getFiledialogRememberSelection() {
    return m_filedialogRememberSelection;
}

void PQCSettings::setFiledialogRememberSelection(bool val) {
    if(val != m_filedialogRememberSelection) {
        m_filedialogRememberSelection = val;
        Q_EMIT filedialogRememberSelectionChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogRememberSelection() {
        return false;
}

void PQCSettings::setDefaultForFiledialogRememberSelection() {
    if(false != m_filedialogRememberSelection) {
        m_filedialogRememberSelection = false;
        Q_EMIT filedialogRememberSelectionChanged();
    }
}

bool PQCSettings::getFiledialogShowHiddenFilesFolders() {
    return m_filedialogShowHiddenFilesFolders;
}

void PQCSettings::setFiledialogShowHiddenFilesFolders(bool val) {
    if(val != m_filedialogShowHiddenFilesFolders) {
        m_filedialogShowHiddenFilesFolders = val;
        Q_EMIT filedialogShowHiddenFilesFoldersChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogShowHiddenFilesFolders() {
        return false;
}

void PQCSettings::setDefaultForFiledialogShowHiddenFilesFolders() {
    if(false != m_filedialogShowHiddenFilesFolders) {
        m_filedialogShowHiddenFilesFolders = false;
        Q_EMIT filedialogShowHiddenFilesFoldersChanged();
    }
}

bool PQCSettings::getFiledialogSingleClickSelect() {
    return m_filedialogSingleClickSelect;
}

void PQCSettings::setFiledialogSingleClickSelect(bool val) {
    if(val != m_filedialogSingleClickSelect) {
        m_filedialogSingleClickSelect = val;
        Q_EMIT filedialogSingleClickSelectChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogSingleClickSelect() {
        return false;
}

void PQCSettings::setDefaultForFiledialogSingleClickSelect() {
    if(false != m_filedialogSingleClickSelect) {
        m_filedialogSingleClickSelect = false;
        Q_EMIT filedialogSingleClickSelectChanged();
    }
}

bool PQCSettings::getFiledialogStartupRestoreCustom() {
    return m_filedialogStartupRestoreCustom;
}

void PQCSettings::setFiledialogStartupRestoreCustom(bool val) {
    if(val != m_filedialogStartupRestoreCustom) {
        m_filedialogStartupRestoreCustom = val;
        Q_EMIT filedialogStartupRestoreCustomChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogStartupRestoreCustom() {
        return false;
}

void PQCSettings::setDefaultForFiledialogStartupRestoreCustom() {
    if(false != m_filedialogStartupRestoreCustom) {
        m_filedialogStartupRestoreCustom = false;
        Q_EMIT filedialogStartupRestoreCustomChanged();
    }
}

QString PQCSettings::getFiledialogStartupRestoreCustomFolder() {
    return m_filedialogStartupRestoreCustomFolder;
}

void PQCSettings::setFiledialogStartupRestoreCustomFolder(QString val) {
    if(val != m_filedialogStartupRestoreCustomFolder) {
        m_filedialogStartupRestoreCustomFolder = val;
        Q_EMIT filedialogStartupRestoreCustomFolderChanged();
    }
}

const QString PQCSettings::getDefaultForFiledialogStartupRestoreCustomFolder() {
        return "";
}

void PQCSettings::setDefaultForFiledialogStartupRestoreCustomFolder() {
    if("" != m_filedialogStartupRestoreCustomFolder) {
        m_filedialogStartupRestoreCustomFolder = "";
        Q_EMIT filedialogStartupRestoreCustomFolderChanged();
    }
}

bool PQCSettings::getFiledialogStartupRestoreHome() {
    return m_filedialogStartupRestoreHome;
}

void PQCSettings::setFiledialogStartupRestoreHome(bool val) {
    if(val != m_filedialogStartupRestoreHome) {
        m_filedialogStartupRestoreHome = val;
        Q_EMIT filedialogStartupRestoreHomeChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogStartupRestoreHome() {
        return false;
}

void PQCSettings::setDefaultForFiledialogStartupRestoreHome() {
    if(false != m_filedialogStartupRestoreHome) {
        m_filedialogStartupRestoreHome = false;
        Q_EMIT filedialogStartupRestoreHomeChanged();
    }
}

bool PQCSettings::getFiledialogStartupRestorePrevious() {
    return m_filedialogStartupRestorePrevious;
}

void PQCSettings::setFiledialogStartupRestorePrevious(bool val) {
    if(val != m_filedialogStartupRestorePrevious) {
        m_filedialogStartupRestorePrevious = val;
        Q_EMIT filedialogStartupRestorePreviousChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogStartupRestorePrevious() {
        return true;
}

void PQCSettings::setDefaultForFiledialogStartupRestorePrevious() {
    if(true != m_filedialogStartupRestorePrevious) {
        m_filedialogStartupRestorePrevious = true;
        Q_EMIT filedialogStartupRestorePreviousChanged();
    }
}

bool PQCSettings::getFiledialogThumbnails() {
    return m_filedialogThumbnails;
}

void PQCSettings::setFiledialogThumbnails(bool val) {
    if(val != m_filedialogThumbnails) {
        m_filedialogThumbnails = val;
        Q_EMIT filedialogThumbnailsChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogThumbnails() {
        return true;
}

void PQCSettings::setDefaultForFiledialogThumbnails() {
    if(true != m_filedialogThumbnails) {
        m_filedialogThumbnails = true;
        Q_EMIT filedialogThumbnailsChanged();
    }
}

bool PQCSettings::getFiledialogThumbnailsScaleCrop() {
    return m_filedialogThumbnailsScaleCrop;
}

void PQCSettings::setFiledialogThumbnailsScaleCrop(bool val) {
    if(val != m_filedialogThumbnailsScaleCrop) {
        m_filedialogThumbnailsScaleCrop = val;
        Q_EMIT filedialogThumbnailsScaleCropChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogThumbnailsScaleCrop() {
        return true;
}

void PQCSettings::setDefaultForFiledialogThumbnailsScaleCrop() {
    if(true != m_filedialogThumbnailsScaleCrop) {
        m_filedialogThumbnailsScaleCrop = true;
        Q_EMIT filedialogThumbnailsScaleCropChanged();
    }
}

bool PQCSettings::getFiledialogUseNativeFileDialog() {
    return m_filedialogUseNativeFileDialog;
}

void PQCSettings::setFiledialogUseNativeFileDialog(bool val) {
    if(val != m_filedialogUseNativeFileDialog) {
        m_filedialogUseNativeFileDialog = val;
        Q_EMIT filedialogUseNativeFileDialogChanged();
    }
}

const bool PQCSettings::getDefaultForFiledialogUseNativeFileDialog() {
        return false;
}

void PQCSettings::setDefaultForFiledialogUseNativeFileDialog() {
    if(false != m_filedialogUseNativeFileDialog) {
        m_filedialogUseNativeFileDialog = false;
        Q_EMIT filedialogUseNativeFileDialogChanged();
    }
}

int PQCSettings::getFiledialogZoom() {
    return m_filedialogZoom;
}

void PQCSettings::setFiledialogZoom(int val) {
    if(val != m_filedialogZoom) {
        m_filedialogZoom = val;
        Q_EMIT filedialogZoomChanged();
    }
}

const int PQCSettings::getDefaultForFiledialogZoom() {
        return 40;
}

void PQCSettings::setDefaultForFiledialogZoom() {
    if(40 != m_filedialogZoom) {
        m_filedialogZoom = 40;
    }
}

bool PQCSettings::getFiletypesAnimatedControls() {
    return m_filetypesAnimatedControls;
}

void PQCSettings::setFiletypesAnimatedControls(bool val) {
    if(val != m_filetypesAnimatedControls) {
        m_filetypesAnimatedControls = val;
        Q_EMIT filetypesAnimatedControlsChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesAnimatedControls() {
        return true;
}

void PQCSettings::setDefaultForFiletypesAnimatedControls() {
    if(true != m_filetypesAnimatedControls) {
        m_filetypesAnimatedControls = true;
        Q_EMIT filetypesAnimatedControlsChanged();
    }
}

bool PQCSettings::getFiletypesAnimatedLeftRight() {
    return m_filetypesAnimatedLeftRight;
}

void PQCSettings::setFiletypesAnimatedLeftRight(bool val) {
    if(val != m_filetypesAnimatedLeftRight) {
        m_filetypesAnimatedLeftRight = val;
        Q_EMIT filetypesAnimatedLeftRightChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesAnimatedLeftRight() {
        return false;
}

void PQCSettings::setDefaultForFiletypesAnimatedLeftRight() {
    if(false != m_filetypesAnimatedLeftRight) {
        m_filetypesAnimatedLeftRight = false;
        Q_EMIT filetypesAnimatedLeftRightChanged();
    }
}

bool PQCSettings::getFiletypesAnimatedSpacePause() {
    return m_filetypesAnimatedSpacePause;
}

void PQCSettings::setFiletypesAnimatedSpacePause(bool val) {
    if(val != m_filetypesAnimatedSpacePause) {
        m_filetypesAnimatedSpacePause = val;
        Q_EMIT filetypesAnimatedSpacePauseChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesAnimatedSpacePause() {
        return true;
}

void PQCSettings::setDefaultForFiletypesAnimatedSpacePause() {
    if(true != m_filetypesAnimatedSpacePause) {
        m_filetypesAnimatedSpacePause = true;
        Q_EMIT filetypesAnimatedSpacePauseChanged();
    }
}

bool PQCSettings::getFiletypesArchiveAlwaysEnterAutomatically() {
    return m_filetypesArchiveAlwaysEnterAutomatically;
}

void PQCSettings::setFiletypesArchiveAlwaysEnterAutomatically(bool val) {
    if(val != m_filetypesArchiveAlwaysEnterAutomatically) {
        m_filetypesArchiveAlwaysEnterAutomatically = val;
        Q_EMIT filetypesArchiveAlwaysEnterAutomaticallyChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesArchiveAlwaysEnterAutomatically() {
        return false;
}

void PQCSettings::setDefaultForFiletypesArchiveAlwaysEnterAutomatically() {
    if(false != m_filetypesArchiveAlwaysEnterAutomatically) {
        m_filetypesArchiveAlwaysEnterAutomatically = false;
        Q_EMIT filetypesArchiveAlwaysEnterAutomaticallyChanged();
    }
}

bool PQCSettings::getFiletypesArchiveControls() {
    return m_filetypesArchiveControls;
}

void PQCSettings::setFiletypesArchiveControls(bool val) {
    if(val != m_filetypesArchiveControls) {
        m_filetypesArchiveControls = val;
        Q_EMIT filetypesArchiveControlsChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesArchiveControls() {
        return true;
}

void PQCSettings::setDefaultForFiletypesArchiveControls() {
    if(true != m_filetypesArchiveControls) {
        m_filetypesArchiveControls = true;
        Q_EMIT filetypesArchiveControlsChanged();
    }
}

bool PQCSettings::getFiletypesArchiveDontLoadMoreFilesThan() {
    return m_filetypesArchiveDontLoadMoreFilesThan;
}

void PQCSettings::setFiletypesArchiveDontLoadMoreFilesThan(bool val) {
    if(val != m_filetypesArchiveDontLoadMoreFilesThan) {
        m_filetypesArchiveDontLoadMoreFilesThan = val;
        Q_EMIT filetypesArchiveDontLoadMoreFilesThanChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesArchiveDontLoadMoreFilesThan() {
        return false;
}

void PQCSettings::setDefaultForFiletypesArchiveDontLoadMoreFilesThan() {
    if(false != m_filetypesArchiveDontLoadMoreFilesThan) {
        m_filetypesArchiveDontLoadMoreFilesThan = false;
        Q_EMIT filetypesArchiveDontLoadMoreFilesThanChanged();
    }
}

int PQCSettings::getFiletypesArchiveDontLoadMoreFilesThanCount() {
    return m_filetypesArchiveDontLoadMoreFilesThanCount;
}

void PQCSettings::setFiletypesArchiveDontLoadMoreFilesThanCount(int val) {
    if(val != m_filetypesArchiveDontLoadMoreFilesThanCount) {
        m_filetypesArchiveDontLoadMoreFilesThanCount = val;
        Q_EMIT filetypesArchiveDontLoadMoreFilesThanCountChanged();
    }
}

const int PQCSettings::getDefaultForFiletypesArchiveDontLoadMoreFilesThanCount() {
        return 2000;
}

void PQCSettings::setDefaultForFiletypesArchiveDontLoadMoreFilesThanCount() {
    if(2000 != m_filetypesArchiveDontLoadMoreFilesThanCount) {
        m_filetypesArchiveDontLoadMoreFilesThanCount = 2000;
    }
}

bool PQCSettings::getFiletypesArchiveIgnoreLargerThan() {
    return m_filetypesArchiveIgnoreLargerThan;
}

void PQCSettings::setFiletypesArchiveIgnoreLargerThan(bool val) {
    if(val != m_filetypesArchiveIgnoreLargerThan) {
        m_filetypesArchiveIgnoreLargerThan = val;
        Q_EMIT filetypesArchiveIgnoreLargerThanChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesArchiveIgnoreLargerThan() {
        return false;
}

void PQCSettings::setDefaultForFiletypesArchiveIgnoreLargerThan() {
    if(false != m_filetypesArchiveIgnoreLargerThan) {
        m_filetypesArchiveIgnoreLargerThan = false;
        Q_EMIT filetypesArchiveIgnoreLargerThanChanged();
    }
}

int PQCSettings::getFiletypesArchiveIgnoreLargerThanSize() {
    return m_filetypesArchiveIgnoreLargerThanSize;
}

void PQCSettings::setFiletypesArchiveIgnoreLargerThanSize(int val) {
    if(val != m_filetypesArchiveIgnoreLargerThanSize) {
        m_filetypesArchiveIgnoreLargerThanSize = val;
        Q_EMIT filetypesArchiveIgnoreLargerThanSizeChanged();
    }
}

const int PQCSettings::getDefaultForFiletypesArchiveIgnoreLargerThanSize() {
        return 2048;
}

void PQCSettings::setDefaultForFiletypesArchiveIgnoreLargerThanSize() {
    if(2048 != m_filetypesArchiveIgnoreLargerThanSize) {
        m_filetypesArchiveIgnoreLargerThanSize = 2048;
    }
}

bool PQCSettings::getFiletypesArchiveLeftRight() {
    return m_filetypesArchiveLeftRight;
}

void PQCSettings::setFiletypesArchiveLeftRight(bool val) {
    if(val != m_filetypesArchiveLeftRight) {
        m_filetypesArchiveLeftRight = val;
        Q_EMIT filetypesArchiveLeftRightChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesArchiveLeftRight() {
        return false;
}

void PQCSettings::setDefaultForFiletypesArchiveLeftRight() {
    if(false != m_filetypesArchiveLeftRight) {
        m_filetypesArchiveLeftRight = false;
        Q_EMIT filetypesArchiveLeftRightChanged();
    }
}

bool PQCSettings::getFiletypesArchiveViewerModeExitButton() {
    return m_filetypesArchiveViewerModeExitButton;
}

void PQCSettings::setFiletypesArchiveViewerModeExitButton(bool val) {
    if(val != m_filetypesArchiveViewerModeExitButton) {
        m_filetypesArchiveViewerModeExitButton = val;
        Q_EMIT filetypesArchiveViewerModeExitButtonChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesArchiveViewerModeExitButton() {
        return true;
}

void PQCSettings::setDefaultForFiletypesArchiveViewerModeExitButton() {
    if(true != m_filetypesArchiveViewerModeExitButton) {
        m_filetypesArchiveViewerModeExitButton = true;
        Q_EMIT filetypesArchiveViewerModeExitButtonChanged();
    }
}

bool PQCSettings::getFiletypesComicBookAlwaysEnterAutomatically() {
    return m_filetypesComicBookAlwaysEnterAutomatically;
}

void PQCSettings::setFiletypesComicBookAlwaysEnterAutomatically(bool val) {
    if(val != m_filetypesComicBookAlwaysEnterAutomatically) {
        m_filetypesComicBookAlwaysEnterAutomatically = val;
        Q_EMIT filetypesComicBookAlwaysEnterAutomaticallyChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesComicBookAlwaysEnterAutomatically() {
        return false;
}

void PQCSettings::setDefaultForFiletypesComicBookAlwaysEnterAutomatically() {
    if(false != m_filetypesComicBookAlwaysEnterAutomatically) {
        m_filetypesComicBookAlwaysEnterAutomatically = false;
        Q_EMIT filetypesComicBookAlwaysEnterAutomaticallyChanged();
    }
}

bool PQCSettings::getFiletypesDocumentAlwaysEnterAutomatically() {
    return m_filetypesDocumentAlwaysEnterAutomatically;
}

void PQCSettings::setFiletypesDocumentAlwaysEnterAutomatically(bool val) {
    if(val != m_filetypesDocumentAlwaysEnterAutomatically) {
        m_filetypesDocumentAlwaysEnterAutomatically = val;
        Q_EMIT filetypesDocumentAlwaysEnterAutomaticallyChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesDocumentAlwaysEnterAutomatically() {
        return false;
}

void PQCSettings::setDefaultForFiletypesDocumentAlwaysEnterAutomatically() {
    if(false != m_filetypesDocumentAlwaysEnterAutomatically) {
        m_filetypesDocumentAlwaysEnterAutomatically = false;
        Q_EMIT filetypesDocumentAlwaysEnterAutomaticallyChanged();
    }
}

bool PQCSettings::getFiletypesDocumentControls() {
    return m_filetypesDocumentControls;
}

void PQCSettings::setFiletypesDocumentControls(bool val) {
    if(val != m_filetypesDocumentControls) {
        m_filetypesDocumentControls = val;
        Q_EMIT filetypesDocumentControlsChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesDocumentControls() {
        return true;
}

void PQCSettings::setDefaultForFiletypesDocumentControls() {
    if(true != m_filetypesDocumentControls) {
        m_filetypesDocumentControls = true;
        Q_EMIT filetypesDocumentControlsChanged();
    }
}

bool PQCSettings::getFiletypesDocumentLeftRight() {
    return m_filetypesDocumentLeftRight;
}

void PQCSettings::setFiletypesDocumentLeftRight(bool val) {
    if(val != m_filetypesDocumentLeftRight) {
        m_filetypesDocumentLeftRight = val;
        Q_EMIT filetypesDocumentLeftRightChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesDocumentLeftRight() {
        return false;
}

void PQCSettings::setDefaultForFiletypesDocumentLeftRight() {
    if(false != m_filetypesDocumentLeftRight) {
        m_filetypesDocumentLeftRight = false;
        Q_EMIT filetypesDocumentLeftRightChanged();
    }
}

bool PQCSettings::getFiletypesDocumentViewerModeExitButton() {
    return m_filetypesDocumentViewerModeExitButton;
}

void PQCSettings::setFiletypesDocumentViewerModeExitButton(bool val) {
    if(val != m_filetypesDocumentViewerModeExitButton) {
        m_filetypesDocumentViewerModeExitButton = val;
        Q_EMIT filetypesDocumentViewerModeExitButtonChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesDocumentViewerModeExitButton() {
        return true;
}

void PQCSettings::setDefaultForFiletypesDocumentViewerModeExitButton() {
    if(true != m_filetypesDocumentViewerModeExitButton) {
        m_filetypesDocumentViewerModeExitButton = true;
        Q_EMIT filetypesDocumentViewerModeExitButtonChanged();
    }
}

bool PQCSettings::getFiletypesExternalUnrar() {
    return m_filetypesExternalUnrar;
}

void PQCSettings::setFiletypesExternalUnrar(bool val) {
    if(val != m_filetypesExternalUnrar) {
        m_filetypesExternalUnrar = val;
        Q_EMIT filetypesExternalUnrarChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesExternalUnrar() {
        return false;
}

void PQCSettings::setDefaultForFiletypesExternalUnrar() {
    if(false != m_filetypesExternalUnrar) {
        m_filetypesExternalUnrar = false;
        Q_EMIT filetypesExternalUnrarChanged();
    }
}

bool PQCSettings::getFiletypesLoadAppleLivePhotos() {
    return m_filetypesLoadAppleLivePhotos;
}

void PQCSettings::setFiletypesLoadAppleLivePhotos(bool val) {
    if(val != m_filetypesLoadAppleLivePhotos) {
        m_filetypesLoadAppleLivePhotos = val;
        Q_EMIT filetypesLoadAppleLivePhotosChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesLoadAppleLivePhotos() {
        return true;
}

void PQCSettings::setDefaultForFiletypesLoadAppleLivePhotos() {
    if(true != m_filetypesLoadAppleLivePhotos) {
        m_filetypesLoadAppleLivePhotos = true;
        Q_EMIT filetypesLoadAppleLivePhotosChanged();
    }
}

bool PQCSettings::getFiletypesLoadMotionPhotos() {
    return m_filetypesLoadMotionPhotos;
}

void PQCSettings::setFiletypesLoadMotionPhotos(bool val) {
    if(val != m_filetypesLoadMotionPhotos) {
        m_filetypesLoadMotionPhotos = val;
        Q_EMIT filetypesLoadMotionPhotosChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesLoadMotionPhotos() {
        return true;
}

void PQCSettings::setDefaultForFiletypesLoadMotionPhotos() {
    if(true != m_filetypesLoadMotionPhotos) {
        m_filetypesLoadMotionPhotos = true;
        Q_EMIT filetypesLoadMotionPhotosChanged();
    }
}

bool PQCSettings::getFiletypesMotionAutoPlay() {
    return m_filetypesMotionAutoPlay;
}

void PQCSettings::setFiletypesMotionAutoPlay(bool val) {
    if(val != m_filetypesMotionAutoPlay) {
        m_filetypesMotionAutoPlay = val;
        Q_EMIT filetypesMotionAutoPlayChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesMotionAutoPlay() {
        return true;
}

void PQCSettings::setDefaultForFiletypesMotionAutoPlay() {
    if(true != m_filetypesMotionAutoPlay) {
        m_filetypesMotionAutoPlay = true;
        Q_EMIT filetypesMotionAutoPlayChanged();
    }
}

bool PQCSettings::getFiletypesMotionPhotoPlayPause() {
    return m_filetypesMotionPhotoPlayPause;
}

void PQCSettings::setFiletypesMotionPhotoPlayPause(bool val) {
    if(val != m_filetypesMotionPhotoPlayPause) {
        m_filetypesMotionPhotoPlayPause = val;
        Q_EMIT filetypesMotionPhotoPlayPauseChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesMotionPhotoPlayPause() {
        return true;
}

void PQCSettings::setDefaultForFiletypesMotionPhotoPlayPause() {
    if(true != m_filetypesMotionPhotoPlayPause) {
        m_filetypesMotionPhotoPlayPause = true;
        Q_EMIT filetypesMotionPhotoPlayPauseChanged();
    }
}

bool PQCSettings::getFiletypesMotionSpacePause() {
    return m_filetypesMotionSpacePause;
}

void PQCSettings::setFiletypesMotionSpacePause(bool val) {
    if(val != m_filetypesMotionSpacePause) {
        m_filetypesMotionSpacePause = val;
        Q_EMIT filetypesMotionSpacePauseChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesMotionSpacePause() {
        return true;
}

void PQCSettings::setDefaultForFiletypesMotionSpacePause() {
    if(true != m_filetypesMotionSpacePause) {
        m_filetypesMotionSpacePause = true;
        Q_EMIT filetypesMotionSpacePauseChanged();
    }
}

int PQCSettings::getFiletypesPDFQuality() {
    return m_filetypesPDFQuality;
}

void PQCSettings::setFiletypesPDFQuality(int val) {
    if(val != m_filetypesPDFQuality) {
        m_filetypesPDFQuality = val;
        Q_EMIT filetypesPDFQualityChanged();
    }
}

const int PQCSettings::getDefaultForFiletypesPDFQuality() {
        return 150;
}

void PQCSettings::setDefaultForFiletypesPDFQuality() {
    if(150 != m_filetypesPDFQuality) {
        m_filetypesPDFQuality = 150;
    }
}

bool PQCSettings::getFiletypesPhotoSphereArrowKeys() {
    return m_filetypesPhotoSphereArrowKeys;
}

void PQCSettings::setFiletypesPhotoSphereArrowKeys(bool val) {
    if(val != m_filetypesPhotoSphereArrowKeys) {
        m_filetypesPhotoSphereArrowKeys = val;
        Q_EMIT filetypesPhotoSphereArrowKeysChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesPhotoSphereArrowKeys() {
        return false;
}

void PQCSettings::setDefaultForFiletypesPhotoSphereArrowKeys() {
    if(false != m_filetypesPhotoSphereArrowKeys) {
        m_filetypesPhotoSphereArrowKeys = false;
        Q_EMIT filetypesPhotoSphereArrowKeysChanged();
    }
}

bool PQCSettings::getFiletypesPhotoSphereAutoLoad() {
    return m_filetypesPhotoSphereAutoLoad;
}

void PQCSettings::setFiletypesPhotoSphereAutoLoad(bool val) {
    if(val != m_filetypesPhotoSphereAutoLoad) {
        m_filetypesPhotoSphereAutoLoad = val;
        Q_EMIT filetypesPhotoSphereAutoLoadChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesPhotoSphereAutoLoad() {
        return true;
}

void PQCSettings::setDefaultForFiletypesPhotoSphereAutoLoad() {
    if(true != m_filetypesPhotoSphereAutoLoad) {
        m_filetypesPhotoSphereAutoLoad = true;
        Q_EMIT filetypesPhotoSphereAutoLoadChanged();
    }
}

bool PQCSettings::getFiletypesPhotoSphereBigButton() {
    return m_filetypesPhotoSphereBigButton;
}

void PQCSettings::setFiletypesPhotoSphereBigButton(bool val) {
    if(val != m_filetypesPhotoSphereBigButton) {
        m_filetypesPhotoSphereBigButton = val;
        Q_EMIT filetypesPhotoSphereBigButtonChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesPhotoSphereBigButton() {
        return false;
}

void PQCSettings::setDefaultForFiletypesPhotoSphereBigButton() {
    if(false != m_filetypesPhotoSphereBigButton) {
        m_filetypesPhotoSphereBigButton = false;
        Q_EMIT filetypesPhotoSphereBigButtonChanged();
    }
}

bool PQCSettings::getFiletypesPhotoSphereControls() {
    return m_filetypesPhotoSphereControls;
}

void PQCSettings::setFiletypesPhotoSphereControls(bool val) {
    if(val != m_filetypesPhotoSphereControls) {
        m_filetypesPhotoSphereControls = val;
        Q_EMIT filetypesPhotoSphereControlsChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesPhotoSphereControls() {
        return false;
}

void PQCSettings::setDefaultForFiletypesPhotoSphereControls() {
    if(false != m_filetypesPhotoSphereControls) {
        m_filetypesPhotoSphereControls = false;
        Q_EMIT filetypesPhotoSphereControlsChanged();
    }
}

bool PQCSettings::getFiletypesPhotoSpherePanOnLoad() {
    return m_filetypesPhotoSpherePanOnLoad;
}

void PQCSettings::setFiletypesPhotoSpherePanOnLoad(bool val) {
    if(val != m_filetypesPhotoSpherePanOnLoad) {
        m_filetypesPhotoSpherePanOnLoad = val;
        Q_EMIT filetypesPhotoSpherePanOnLoadChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesPhotoSpherePanOnLoad() {
        return true;
}

void PQCSettings::setDefaultForFiletypesPhotoSpherePanOnLoad() {
    if(true != m_filetypesPhotoSpherePanOnLoad) {
        m_filetypesPhotoSpherePanOnLoad = true;
        Q_EMIT filetypesPhotoSpherePanOnLoadChanged();
    }
}

bool PQCSettings::getFiletypesRAWUseEmbeddedIfAvailable() {
    return m_filetypesRAWUseEmbeddedIfAvailable;
}

void PQCSettings::setFiletypesRAWUseEmbeddedIfAvailable(bool val) {
    if(val != m_filetypesRAWUseEmbeddedIfAvailable) {
        m_filetypesRAWUseEmbeddedIfAvailable = val;
        Q_EMIT filetypesRAWUseEmbeddedIfAvailableChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesRAWUseEmbeddedIfAvailable() {
        return true;
}

void PQCSettings::setDefaultForFiletypesRAWUseEmbeddedIfAvailable() {
    if(true != m_filetypesRAWUseEmbeddedIfAvailable) {
        m_filetypesRAWUseEmbeddedIfAvailable = true;
        Q_EMIT filetypesRAWUseEmbeddedIfAvailableChanged();
    }
}

bool PQCSettings::getFiletypesVideoAutoplay() {
    return m_filetypesVideoAutoplay;
}

void PQCSettings::setFiletypesVideoAutoplay(bool val) {
    if(val != m_filetypesVideoAutoplay) {
        m_filetypesVideoAutoplay = val;
        Q_EMIT filetypesVideoAutoplayChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesVideoAutoplay() {
        return true;
}

void PQCSettings::setDefaultForFiletypesVideoAutoplay() {
    if(true != m_filetypesVideoAutoplay) {
        m_filetypesVideoAutoplay = true;
        Q_EMIT filetypesVideoAutoplayChanged();
    }
}

bool PQCSettings::getFiletypesVideoLeftRightJumpVideo() {
    return m_filetypesVideoLeftRightJumpVideo;
}

void PQCSettings::setFiletypesVideoLeftRightJumpVideo(bool val) {
    if(val != m_filetypesVideoLeftRightJumpVideo) {
        m_filetypesVideoLeftRightJumpVideo = val;
        Q_EMIT filetypesVideoLeftRightJumpVideoChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesVideoLeftRightJumpVideo() {
        return false;
}

void PQCSettings::setDefaultForFiletypesVideoLeftRightJumpVideo() {
    if(false != m_filetypesVideoLeftRightJumpVideo) {
        m_filetypesVideoLeftRightJumpVideo = false;
        Q_EMIT filetypesVideoLeftRightJumpVideoChanged();
    }
}

bool PQCSettings::getFiletypesVideoLoop() {
    return m_filetypesVideoLoop;
}

void PQCSettings::setFiletypesVideoLoop(bool val) {
    if(val != m_filetypesVideoLoop) {
        m_filetypesVideoLoop = val;
        Q_EMIT filetypesVideoLoopChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesVideoLoop() {
        return false;
}

void PQCSettings::setDefaultForFiletypesVideoLoop() {
    if(false != m_filetypesVideoLoop) {
        m_filetypesVideoLoop = false;
        Q_EMIT filetypesVideoLoopChanged();
    }
}

bool PQCSettings::getFiletypesVideoPreferLibmpv() {
    return m_filetypesVideoPreferLibmpv;
}

void PQCSettings::setFiletypesVideoPreferLibmpv(bool val) {
    if(val != m_filetypesVideoPreferLibmpv) {
        m_filetypesVideoPreferLibmpv = val;
        Q_EMIT filetypesVideoPreferLibmpvChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesVideoPreferLibmpv() {
        return true;
}

void PQCSettings::setDefaultForFiletypesVideoPreferLibmpv() {
    if(true != m_filetypesVideoPreferLibmpv) {
        m_filetypesVideoPreferLibmpv = true;
        Q_EMIT filetypesVideoPreferLibmpvChanged();
    }
}

bool PQCSettings::getFiletypesVideoSpacePause() {
    return m_filetypesVideoSpacePause;
}

void PQCSettings::setFiletypesVideoSpacePause(bool val) {
    if(val != m_filetypesVideoSpacePause) {
        m_filetypesVideoSpacePause = val;
        Q_EMIT filetypesVideoSpacePauseChanged();
    }
}

const bool PQCSettings::getDefaultForFiletypesVideoSpacePause() {
        return true;
}

void PQCSettings::setDefaultForFiletypesVideoSpacePause() {
    if(true != m_filetypesVideoSpacePause) {
        m_filetypesVideoSpacePause = true;
        Q_EMIT filetypesVideoSpacePauseChanged();
    }
}

QString PQCSettings::getFiletypesVideoThumbnailer() {
    return m_filetypesVideoThumbnailer;
}

void PQCSettings::setFiletypesVideoThumbnailer(QString val) {
    if(val != m_filetypesVideoThumbnailer) {
        m_filetypesVideoThumbnailer = val;
        Q_EMIT filetypesVideoThumbnailerChanged();
    }
}

const QString PQCSettings::getDefaultForFiletypesVideoThumbnailer() {
        return "ffmpegthumbnailer";
}

void PQCSettings::setDefaultForFiletypesVideoThumbnailer() {
    if("ffmpegthumbnailer" != m_filetypesVideoThumbnailer) {
        m_filetypesVideoThumbnailer = "ffmpegthumbnailer";
        Q_EMIT filetypesVideoThumbnailerChanged();
    }
}

int PQCSettings::getFiletypesVideoVolume() {
    return m_filetypesVideoVolume;
}

void PQCSettings::setFiletypesVideoVolume(int val) {
    if(val != m_filetypesVideoVolume) {
        m_filetypesVideoVolume = val;
        Q_EMIT filetypesVideoVolumeChanged();
    }
}

const int PQCSettings::getDefaultForFiletypesVideoVolume() {
        return 100;
}

void PQCSettings::setDefaultForFiletypesVideoVolume() {
    if(100 != m_filetypesVideoVolume) {
        m_filetypesVideoVolume = 100;
    }
}

bool PQCSettings::getGeneralAutoSaveSettings() {
    return m_generalAutoSaveSettings;
}

void PQCSettings::setGeneralAutoSaveSettings(bool val) {
    if(val != m_generalAutoSaveSettings) {
        m_generalAutoSaveSettings = val;
        Q_EMIT generalAutoSaveSettingsChanged();
    }
}

const bool PQCSettings::getDefaultForGeneralAutoSaveSettings() {
        return false;
}

void PQCSettings::setDefaultForGeneralAutoSaveSettings() {
    if(false != m_generalAutoSaveSettings) {
        m_generalAutoSaveSettings = false;
        Q_EMIT generalAutoSaveSettingsChanged();
    }
}

bool PQCSettings::getGeneralCompactSettings() {
    return m_generalCompactSettings;
}

void PQCSettings::setGeneralCompactSettings(bool val) {
    if(val != m_generalCompactSettings) {
        m_generalCompactSettings = val;
        Q_EMIT generalCompactSettingsChanged();
    }
}

const bool PQCSettings::getDefaultForGeneralCompactSettings() {
        return false;
}

void PQCSettings::setDefaultForGeneralCompactSettings() {
    if(false != m_generalCompactSettings) {
        m_generalCompactSettings = false;
        Q_EMIT generalCompactSettingsChanged();
    }
}

bool PQCSettings::getGeneralDisableAllAnimations() {
    return m_generalDisableAllAnimations;
}

void PQCSettings::setGeneralDisableAllAnimations(bool val) {
    if(val != m_generalDisableAllAnimations) {
        m_generalDisableAllAnimations = val;
        Q_EMIT generalDisableAllAnimationsChanged();
    }
}

const bool PQCSettings::getDefaultForGeneralDisableAllAnimations() {
        return false;
}

void PQCSettings::setDefaultForGeneralDisableAllAnimations() {
    if(false != m_generalDisableAllAnimations) {
        m_generalDisableAllAnimations = false;
        Q_EMIT generalDisableAllAnimationsChanged();
    }
}

QStringList PQCSettings::getGeneralExtensionsAllowUntrusted() {
    return m_generalExtensionsAllowUntrusted;
}

void PQCSettings::setGeneralExtensionsAllowUntrusted(QStringList val) {
    if(val != m_generalExtensionsAllowUntrusted) {
        m_generalExtensionsAllowUntrusted = val;
        Q_EMIT generalExtensionsAllowUntrustedChanged();
    }
}

const QStringList PQCSettings::getDefaultForGeneralExtensionsAllowUntrusted() {
        return QStringList() << "";
}

void PQCSettings::setDefaultForGeneralExtensionsAllowUntrusted() {
    QStringList tmp = QStringList() << "";
    if(tmp != m_generalExtensionsAllowUntrusted) {
        m_generalExtensionsAllowUntrusted = tmp;
        Q_EMIT generalExtensionsAllowUntrustedChanged();
    }
}

QStringList PQCSettings::getGeneralExtensionsEnabled() {
    return m_generalExtensionsEnabled;
}

void PQCSettings::setGeneralExtensionsEnabled(QStringList val) {
    if(val != m_generalExtensionsEnabled) {
        m_generalExtensionsEnabled = val;
        Q_EMIT generalExtensionsEnabledChanged();
    }
}

const QStringList PQCSettings::getDefaultForGeneralExtensionsEnabled() {
        return QStringList() << "CropImage" << "ExportImage" << "FloatingNavigation" << "Histogram" << "ImgurCom" << "MapCurrent" << "QuickActions" << "ScaleImage" << "Wallpaper";
}

void PQCSettings::setDefaultForGeneralExtensionsEnabled() {
    QStringList tmp = QStringList() << "CropImage" << "ExportImage" << "FloatingNavigation" << "Histogram" << "ImgurCom" << "MapCurrent" << "QuickActions" << "ScaleImage" << "Wallpaper";
    if(tmp != m_generalExtensionsEnabled) {
        m_generalExtensionsEnabled = tmp;
        Q_EMIT generalExtensionsEnabledChanged();
    }
}

QStringList PQCSettings::getGeneralExtensionsFloatingSetup() {
    return m_generalExtensionsFloatingSetup;
}

void PQCSettings::setGeneralExtensionsFloatingSetup(QStringList val) {
    if(val != m_generalExtensionsFloatingSetup) {
        m_generalExtensionsFloatingSetup = val;
        Q_EMIT generalExtensionsFloatingSetupChanged();
    }
}

const QStringList PQCSettings::getDefaultForGeneralExtensionsFloatingSetup() {
        return QStringList() << "";
}

void PQCSettings::setDefaultForGeneralExtensionsFloatingSetup() {
    QStringList tmp = QStringList() << "";
    if(tmp != m_generalExtensionsFloatingSetup) {
        m_generalExtensionsFloatingSetup = tmp;
        Q_EMIT generalExtensionsFloatingSetupChanged();
    }
}

QString PQCSettings::getGeneralInterfaceVariant() {
    return m_generalInterfaceVariant;
}

void PQCSettings::setGeneralInterfaceVariant(QString val) {
    if(val != m_generalInterfaceVariant) {
        m_generalInterfaceVariant = val;
        Q_EMIT generalInterfaceVariantChanged();
    }
}

const QString PQCSettings::getDefaultForGeneralInterfaceVariant() {
        return "modern";
}

void PQCSettings::setDefaultForGeneralInterfaceVariant() {
    if("modern" != m_generalInterfaceVariant) {
        m_generalInterfaceVariant = "modern";
        Q_EMIT generalInterfaceVariantChanged();
    }
}

QString PQCSettings::getGeneralVersion() {
    return m_generalVersion;
}

void PQCSettings::setGeneralVersion(QString val) {
    if(val != m_generalVersion) {
        m_generalVersion = val;
        Q_EMIT generalVersionChanged();
    }
}

const QString PQCSettings::getDefaultForGeneralVersion() {
        return "";
}

void PQCSettings::setDefaultForGeneralVersion() {
    if("" != m_generalVersion) {
        m_generalVersion = "";
        Q_EMIT generalVersionChanged();
    }
}

bool PQCSettings::getImageviewAdvancedSortAscending() {
    return m_imageviewAdvancedSortAscending;
}

void PQCSettings::setImageviewAdvancedSortAscending(bool val) {
    if(val != m_imageviewAdvancedSortAscending) {
        m_imageviewAdvancedSortAscending = val;
        Q_EMIT imageviewAdvancedSortAscendingChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewAdvancedSortAscending() {
        return true;
}

void PQCSettings::setDefaultForImageviewAdvancedSortAscending() {
    if(true != m_imageviewAdvancedSortAscending) {
        m_imageviewAdvancedSortAscending = true;
        Q_EMIT imageviewAdvancedSortAscendingChanged();
    }
}

QString PQCSettings::getImageviewAdvancedSortCriteria() {
    return m_imageviewAdvancedSortCriteria;
}

void PQCSettings::setImageviewAdvancedSortCriteria(QString val) {
    if(val != m_imageviewAdvancedSortCriteria) {
        m_imageviewAdvancedSortCriteria = val;
        Q_EMIT imageviewAdvancedSortCriteriaChanged();
    }
}

const QString PQCSettings::getDefaultForImageviewAdvancedSortCriteria() {
        return "resolution";
}

void PQCSettings::setDefaultForImageviewAdvancedSortCriteria() {
    if("resolution" != m_imageviewAdvancedSortCriteria) {
        m_imageviewAdvancedSortCriteria = "resolution";
        Q_EMIT imageviewAdvancedSortCriteriaChanged();
    }
}

QStringList PQCSettings::getImageviewAdvancedSortDateCriteria() {
    return m_imageviewAdvancedSortDateCriteria;
}

void PQCSettings::setImageviewAdvancedSortDateCriteria(QStringList val) {
    if(val != m_imageviewAdvancedSortDateCriteria) {
        m_imageviewAdvancedSortDateCriteria = val;
        Q_EMIT imageviewAdvancedSortDateCriteriaChanged();
    }
}

const QStringList PQCSettings::getDefaultForImageviewAdvancedSortDateCriteria() {
        return QStringList() << "exiforiginal" << "exifdigital" << "filecreation" << "filemodification";
}

void PQCSettings::setDefaultForImageviewAdvancedSortDateCriteria() {
    QStringList tmp = QStringList() << "exiforiginal" << "exifdigital" << "filecreation" << "filemodification";
    if(tmp != m_imageviewAdvancedSortDateCriteria) {
        m_imageviewAdvancedSortDateCriteria = tmp;
        Q_EMIT imageviewAdvancedSortDateCriteriaChanged();
    }
}

QString PQCSettings::getImageviewAdvancedSortQuality() {
    return m_imageviewAdvancedSortQuality;
}

void PQCSettings::setImageviewAdvancedSortQuality(QString val) {
    if(val != m_imageviewAdvancedSortQuality) {
        m_imageviewAdvancedSortQuality = val;
        Q_EMIT imageviewAdvancedSortQualityChanged();
    }
}

const QString PQCSettings::getDefaultForImageviewAdvancedSortQuality() {
        return "medium";
}

void PQCSettings::setDefaultForImageviewAdvancedSortQuality() {
    if("medium" != m_imageviewAdvancedSortQuality) {
        m_imageviewAdvancedSortQuality = "medium";
        Q_EMIT imageviewAdvancedSortQualityChanged();
    }
}

bool PQCSettings::getImageviewAlwaysActualSize() {
    return m_imageviewAlwaysActualSize;
}

void PQCSettings::setImageviewAlwaysActualSize(bool val) {
    if(val != m_imageviewAlwaysActualSize) {
        m_imageviewAlwaysActualSize = val;
        Q_EMIT imageviewAlwaysActualSizeChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewAlwaysActualSize() {
        return false;
}

void PQCSettings::setDefaultForImageviewAlwaysActualSize() {
    if(false != m_imageviewAlwaysActualSize) {
        m_imageviewAlwaysActualSize = false;
        Q_EMIT imageviewAlwaysActualSizeChanged();
    }
}

int PQCSettings::getImageviewAnimationDuration() {
    return m_imageviewAnimationDuration;
}

void PQCSettings::setImageviewAnimationDuration(int val) {
    if(val != m_imageviewAnimationDuration) {
        m_imageviewAnimationDuration = val;
        Q_EMIT imageviewAnimationDurationChanged();
    }
}

const int PQCSettings::getDefaultForImageviewAnimationDuration() {
        return 3;
}

void PQCSettings::setDefaultForImageviewAnimationDuration() {
    if(3 != m_imageviewAnimationDuration) {
        m_imageviewAnimationDuration = 3;
    }
}

QString PQCSettings::getImageviewAnimationType() {
    return m_imageviewAnimationType;
}

void PQCSettings::setImageviewAnimationType(QString val) {
    if(val != m_imageviewAnimationType) {
        m_imageviewAnimationType = val;
        Q_EMIT imageviewAnimationTypeChanged();
    }
}

const QString PQCSettings::getDefaultForImageviewAnimationType() {
        return "opacity";
}

void PQCSettings::setDefaultForImageviewAnimationType() {
    if("opacity" != m_imageviewAnimationType) {
        m_imageviewAnimationType = "opacity";
        Q_EMIT imageviewAnimationTypeChanged();
    }
}

int PQCSettings::getImageviewCache() {
    return m_imageviewCache;
}

void PQCSettings::setImageviewCache(int val) {
    if(val != m_imageviewCache) {
        m_imageviewCache = val;
        Q_EMIT imageviewCacheChanged();
    }
}

const int PQCSettings::getDefaultForImageviewCache() {
        return 512;
}

void PQCSettings::setDefaultForImageviewCache() {
    if(512 != m_imageviewCache) {
        m_imageviewCache = 512;
    }
}

QStringList PQCSettings::getImageviewColorSpaceContextMenu() {
    return m_imageviewColorSpaceContextMenu;
}

void PQCSettings::setImageviewColorSpaceContextMenu(QStringList val) {
    if(val != m_imageviewColorSpaceContextMenu) {
        m_imageviewColorSpaceContextMenu = val;
        Q_EMIT imageviewColorSpaceContextMenuChanged();
    }
}

const QStringList PQCSettings::getDefaultForImageviewColorSpaceContextMenu() {
        return QStringList() << "::0" << "::1" << "::2" << "::3" << "::4";
}

void PQCSettings::setDefaultForImageviewColorSpaceContextMenu() {
    QStringList tmp = QStringList() << "::0" << "::1" << "::2" << "::3" << "::4";
    if(tmp != m_imageviewColorSpaceContextMenu) {
        m_imageviewColorSpaceContextMenu = tmp;
        Q_EMIT imageviewColorSpaceContextMenuChanged();
    }
}

QString PQCSettings::getImageviewColorSpaceDefault() {
    return m_imageviewColorSpaceDefault;
}

void PQCSettings::setImageviewColorSpaceDefault(QString val) {
    if(val != m_imageviewColorSpaceDefault) {
        m_imageviewColorSpaceDefault = val;
        Q_EMIT imageviewColorSpaceDefaultChanged();
    }
}

const QString PQCSettings::getDefaultForImageviewColorSpaceDefault() {
        return "";
}

void PQCSettings::setDefaultForImageviewColorSpaceDefault() {
    if("" != m_imageviewColorSpaceDefault) {
        m_imageviewColorSpaceDefault = "";
        Q_EMIT imageviewColorSpaceDefaultChanged();
    }
}

bool PQCSettings::getImageviewColorSpaceEnable() {
    return m_imageviewColorSpaceEnable;
}

void PQCSettings::setImageviewColorSpaceEnable(bool val) {
    if(val != m_imageviewColorSpaceEnable) {
        m_imageviewColorSpaceEnable = val;
        Q_EMIT imageviewColorSpaceEnableChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewColorSpaceEnable() {
        return true;
}

void PQCSettings::setDefaultForImageviewColorSpaceEnable() {
    if(true != m_imageviewColorSpaceEnable) {
        m_imageviewColorSpaceEnable = true;
        Q_EMIT imageviewColorSpaceEnableChanged();
    }
}

bool PQCSettings::getImageviewColorSpaceLoadEmbedded() {
    return m_imageviewColorSpaceLoadEmbedded;
}

void PQCSettings::setImageviewColorSpaceLoadEmbedded(bool val) {
    if(val != m_imageviewColorSpaceLoadEmbedded) {
        m_imageviewColorSpaceLoadEmbedded = val;
        Q_EMIT imageviewColorSpaceLoadEmbeddedChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewColorSpaceLoadEmbedded() {
        return true;
}

void PQCSettings::setDefaultForImageviewColorSpaceLoadEmbedded() {
    if(true != m_imageviewColorSpaceLoadEmbedded) {
        m_imageviewColorSpaceLoadEmbedded = true;
        Q_EMIT imageviewColorSpaceLoadEmbeddedChanged();
    }
}

bool PQCSettings::getImageviewEscapeExitArchive() {
    return m_imageviewEscapeExitArchive;
}

void PQCSettings::setImageviewEscapeExitArchive(bool val) {
    if(val != m_imageviewEscapeExitArchive) {
        m_imageviewEscapeExitArchive = val;
        Q_EMIT imageviewEscapeExitArchiveChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewEscapeExitArchive() {
        return true;
}

void PQCSettings::setDefaultForImageviewEscapeExitArchive() {
    if(true != m_imageviewEscapeExitArchive) {
        m_imageviewEscapeExitArchive = true;
        Q_EMIT imageviewEscapeExitArchiveChanged();
    }
}

bool PQCSettings::getImageviewEscapeExitBarcodes() {
    return m_imageviewEscapeExitBarcodes;
}

void PQCSettings::setImageviewEscapeExitBarcodes(bool val) {
    if(val != m_imageviewEscapeExitBarcodes) {
        m_imageviewEscapeExitBarcodes = val;
        Q_EMIT imageviewEscapeExitBarcodesChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewEscapeExitBarcodes() {
        return true;
}

void PQCSettings::setDefaultForImageviewEscapeExitBarcodes() {
    if(true != m_imageviewEscapeExitBarcodes) {
        m_imageviewEscapeExitBarcodes = true;
        Q_EMIT imageviewEscapeExitBarcodesChanged();
    }
}

bool PQCSettings::getImageviewEscapeExitDocument() {
    return m_imageviewEscapeExitDocument;
}

void PQCSettings::setImageviewEscapeExitDocument(bool val) {
    if(val != m_imageviewEscapeExitDocument) {
        m_imageviewEscapeExitDocument = val;
        Q_EMIT imageviewEscapeExitDocumentChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewEscapeExitDocument() {
        return true;
}

void PQCSettings::setDefaultForImageviewEscapeExitDocument() {
    if(true != m_imageviewEscapeExitDocument) {
        m_imageviewEscapeExitDocument = true;
        Q_EMIT imageviewEscapeExitDocumentChanged();
    }
}

bool PQCSettings::getImageviewEscapeExitFilter() {
    return m_imageviewEscapeExitFilter;
}

void PQCSettings::setImageviewEscapeExitFilter(bool val) {
    if(val != m_imageviewEscapeExitFilter) {
        m_imageviewEscapeExitFilter = val;
        Q_EMIT imageviewEscapeExitFilterChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewEscapeExitFilter() {
        return true;
}

void PQCSettings::setDefaultForImageviewEscapeExitFilter() {
    if(true != m_imageviewEscapeExitFilter) {
        m_imageviewEscapeExitFilter = true;
        Q_EMIT imageviewEscapeExitFilterChanged();
    }
}

bool PQCSettings::getImageviewEscapeExitSphere() {
    return m_imageviewEscapeExitSphere;
}

void PQCSettings::setImageviewEscapeExitSphere(bool val) {
    if(val != m_imageviewEscapeExitSphere) {
        m_imageviewEscapeExitSphere = val;
        Q_EMIT imageviewEscapeExitSphereChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewEscapeExitSphere() {
        return true;
}

void PQCSettings::setDefaultForImageviewEscapeExitSphere() {
    if(true != m_imageviewEscapeExitSphere) {
        m_imageviewEscapeExitSphere = true;
        Q_EMIT imageviewEscapeExitSphereChanged();
    }
}

bool PQCSettings::getImageviewFitInWindow() {
    return m_imageviewFitInWindow;
}

void PQCSettings::setImageviewFitInWindow(bool val) {
    if(val != m_imageviewFitInWindow) {
        m_imageviewFitInWindow = val;
        Q_EMIT imageviewFitInWindowChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewFitInWindow() {
        return false;
}

void PQCSettings::setDefaultForImageviewFitInWindow() {
    if(false != m_imageviewFitInWindow) {
        m_imageviewFitInWindow = false;
        Q_EMIT imageviewFitInWindowChanged();
    }
}

int PQCSettings::getImageviewHideCursorTimeout() {
    return m_imageviewHideCursorTimeout;
}

void PQCSettings::setImageviewHideCursorTimeout(int val) {
    if(val != m_imageviewHideCursorTimeout) {
        m_imageviewHideCursorTimeout = val;
        Q_EMIT imageviewHideCursorTimeoutChanged();
    }
}

const int PQCSettings::getDefaultForImageviewHideCursorTimeout() {
        return 1;
}

void PQCSettings::setDefaultForImageviewHideCursorTimeout() {
    if(1 != m_imageviewHideCursorTimeout) {
        m_imageviewHideCursorTimeout = 1;
    }
}

bool PQCSettings::getImageviewInterpolationDisableForSmallImages() {
    return m_imageviewInterpolationDisableForSmallImages;
}

void PQCSettings::setImageviewInterpolationDisableForSmallImages(bool val) {
    if(val != m_imageviewInterpolationDisableForSmallImages) {
        m_imageviewInterpolationDisableForSmallImages = val;
        Q_EMIT imageviewInterpolationDisableForSmallImagesChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewInterpolationDisableForSmallImages() {
        return false;
}

void PQCSettings::setDefaultForImageviewInterpolationDisableForSmallImages() {
    if(false != m_imageviewInterpolationDisableForSmallImages) {
        m_imageviewInterpolationDisableForSmallImages = false;
        Q_EMIT imageviewInterpolationDisableForSmallImagesChanged();
    }
}

bool PQCSettings::getImageviewLoopThroughFolder() {
    return m_imageviewLoopThroughFolder;
}

void PQCSettings::setImageviewLoopThroughFolder(bool val) {
    if(val != m_imageviewLoopThroughFolder) {
        m_imageviewLoopThroughFolder = val;
        Q_EMIT imageviewLoopThroughFolderChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewLoopThroughFolder() {
        return true;
}

void PQCSettings::setDefaultForImageviewLoopThroughFolder() {
    if(true != m_imageviewLoopThroughFolder) {
        m_imageviewLoopThroughFolder = true;
        Q_EMIT imageviewLoopThroughFolderChanged();
    }
}

int PQCSettings::getImageviewMargin() {
    return m_imageviewMargin;
}

void PQCSettings::setImageviewMargin(int val) {
    if(val != m_imageviewMargin) {
        m_imageviewMargin = val;
        Q_EMIT imageviewMarginChanged();
    }
}

const int PQCSettings::getDefaultForImageviewMargin() {
        return 5;
}

void PQCSettings::setDefaultForImageviewMargin() {
    if(5 != m_imageviewMargin) {
        m_imageviewMargin = 5;
    }
}

int PQCSettings::getImageviewMinimapSizeLevel() {
    return m_imageviewMinimapSizeLevel;
}

void PQCSettings::setImageviewMinimapSizeLevel(int val) {
    if(val != m_imageviewMinimapSizeLevel) {
        m_imageviewMinimapSizeLevel = val;
        Q_EMIT imageviewMinimapSizeLevelChanged();
    }
}

const int PQCSettings::getDefaultForImageviewMinimapSizeLevel() {
        return 0;
}

void PQCSettings::setDefaultForImageviewMinimapSizeLevel() {
    if(0 != m_imageviewMinimapSizeLevel) {
        m_imageviewMinimapSizeLevel = 0;
    }
}

bool PQCSettings::getImageviewMirrorAnimate() {
    return m_imageviewMirrorAnimate;
}

void PQCSettings::setImageviewMirrorAnimate(bool val) {
    if(val != m_imageviewMirrorAnimate) {
        m_imageviewMirrorAnimate = val;
        Q_EMIT imageviewMirrorAnimateChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewMirrorAnimate() {
        return true;
}

void PQCSettings::setDefaultForImageviewMirrorAnimate() {
    if(true != m_imageviewMirrorAnimate) {
        m_imageviewMirrorAnimate = true;
        Q_EMIT imageviewMirrorAnimateChanged();
    }
}

int PQCSettings::getImageviewMouseWheelRepeatDelay() {
    return m_imageviewMouseWheelRepeatDelay;
}

void PQCSettings::setImageviewMouseWheelRepeatDelay(int val) {
    if(val != m_imageviewMouseWheelRepeatDelay) {
        m_imageviewMouseWheelRepeatDelay = val;
        Q_EMIT imageviewMouseWheelRepeatDelayChanged();
    }
}

const int PQCSettings::getDefaultForImageviewMouseWheelRepeatDelay() {
        return 0;
}

void PQCSettings::setDefaultForImageviewMouseWheelRepeatDelay() {
    if(0 != m_imageviewMouseWheelRepeatDelay) {
        m_imageviewMouseWheelRepeatDelay = 0;
    }
}

int PQCSettings::getImageviewPreloadInBackground() {
    return m_imageviewPreloadInBackground;
}

void PQCSettings::setImageviewPreloadInBackground(int val) {
    if(val != m_imageviewPreloadInBackground) {
        m_imageviewPreloadInBackground = val;
        Q_EMIT imageviewPreloadInBackgroundChanged();
    }
}

const int PQCSettings::getDefaultForImageviewPreloadInBackground() {
        return 1;
}

void PQCSettings::setDefaultForImageviewPreloadInBackground() {
    if(1 != m_imageviewPreloadInBackground) {
        m_imageviewPreloadInBackground = 1;
    }
}

bool PQCSettings::getImageviewPreserveMirror() {
    return m_imageviewPreserveMirror;
}

void PQCSettings::setImageviewPreserveMirror(bool val) {
    if(val != m_imageviewPreserveMirror) {
        m_imageviewPreserveMirror = val;
        Q_EMIT imageviewPreserveMirrorChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewPreserveMirror() {
        return false;
}

void PQCSettings::setDefaultForImageviewPreserveMirror() {
    if(false != m_imageviewPreserveMirror) {
        m_imageviewPreserveMirror = false;
        Q_EMIT imageviewPreserveMirrorChanged();
    }
}

bool PQCSettings::getImageviewPreserveRotation() {
    return m_imageviewPreserveRotation;
}

void PQCSettings::setImageviewPreserveRotation(bool val) {
    if(val != m_imageviewPreserveRotation) {
        m_imageviewPreserveRotation = val;
        Q_EMIT imageviewPreserveRotationChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewPreserveRotation() {
        return false;
}

void PQCSettings::setDefaultForImageviewPreserveRotation() {
    if(false != m_imageviewPreserveRotation) {
        m_imageviewPreserveRotation = false;
        Q_EMIT imageviewPreserveRotationChanged();
    }
}

bool PQCSettings::getImageviewPreserveZoom() {
    return m_imageviewPreserveZoom;
}

void PQCSettings::setImageviewPreserveZoom(bool val) {
    if(val != m_imageviewPreserveZoom) {
        m_imageviewPreserveZoom = val;
        Q_EMIT imageviewPreserveZoomChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewPreserveZoom() {
        return false;
}

void PQCSettings::setDefaultForImageviewPreserveZoom() {
    if(false != m_imageviewPreserveZoom) {
        m_imageviewPreserveZoom = false;
        Q_EMIT imageviewPreserveZoomChanged();
    }
}

bool PQCSettings::getImageviewRememberZoomRotationMirror() {
    return m_imageviewRememberZoomRotationMirror;
}

void PQCSettings::setImageviewRememberZoomRotationMirror(bool val) {
    if(val != m_imageviewRememberZoomRotationMirror) {
        m_imageviewRememberZoomRotationMirror = val;
        Q_EMIT imageviewRememberZoomRotationMirrorChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewRememberZoomRotationMirror() {
        return false;
}

void PQCSettings::setDefaultForImageviewRememberZoomRotationMirror() {
    if(false != m_imageviewRememberZoomRotationMirror) {
        m_imageviewRememberZoomRotationMirror = false;
        Q_EMIT imageviewRememberZoomRotationMirrorChanged();
    }
}

int PQCSettings::getImageviewResetViewAutoHideTimeout() {
    return m_imageviewResetViewAutoHideTimeout;
}

void PQCSettings::setImageviewResetViewAutoHideTimeout(int val) {
    if(val != m_imageviewResetViewAutoHideTimeout) {
        m_imageviewResetViewAutoHideTimeout = val;
        Q_EMIT imageviewResetViewAutoHideTimeoutChanged();
    }
}

const int PQCSettings::getDefaultForImageviewResetViewAutoHideTimeout() {
        return 1000;
}

void PQCSettings::setDefaultForImageviewResetViewAutoHideTimeout() {
    if(1000 != m_imageviewResetViewAutoHideTimeout) {
        m_imageviewResetViewAutoHideTimeout = 1000;
    }
}

bool PQCSettings::getImageviewResetViewShow() {
    return m_imageviewResetViewShow;
}

void PQCSettings::setImageviewResetViewShow(bool val) {
    if(val != m_imageviewResetViewShow) {
        m_imageviewResetViewShow = val;
        Q_EMIT imageviewResetViewShowChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewResetViewShow() {
        return false;
}

void PQCSettings::setDefaultForImageviewResetViewShow() {
    if(false != m_imageviewResetViewShow) {
        m_imageviewResetViewShow = false;
        Q_EMIT imageviewResetViewShowChanged();
    }
}

bool PQCSettings::getImageviewRespectDevicePixelRatio() {
    return m_imageviewRespectDevicePixelRatio;
}

void PQCSettings::setImageviewRespectDevicePixelRatio(bool val) {
    if(val != m_imageviewRespectDevicePixelRatio) {
        m_imageviewRespectDevicePixelRatio = val;
        Q_EMIT imageviewRespectDevicePixelRatioChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewRespectDevicePixelRatio() {
        return true;
}

void PQCSettings::setDefaultForImageviewRespectDevicePixelRatio() {
    if(true != m_imageviewRespectDevicePixelRatio) {
        m_imageviewRespectDevicePixelRatio = true;
        Q_EMIT imageviewRespectDevicePixelRatioChanged();
    }
}

bool PQCSettings::getImageviewShowMinimap() {
    return m_imageviewShowMinimap;
}

void PQCSettings::setImageviewShowMinimap(bool val) {
    if(val != m_imageviewShowMinimap) {
        m_imageviewShowMinimap = val;
        Q_EMIT imageviewShowMinimapChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewShowMinimap() {
        return true;
}

void PQCSettings::setDefaultForImageviewShowMinimap() {
    if(true != m_imageviewShowMinimap) {
        m_imageviewShowMinimap = true;
        Q_EMIT imageviewShowMinimapChanged();
    }
}

int PQCSettings::getImageviewSiblingFileMaxIterations() {
    return m_imageviewSiblingFileMaxIterations;
}

void PQCSettings::setImageviewSiblingFileMaxIterations(int val) {
    if(val != m_imageviewSiblingFileMaxIterations) {
        m_imageviewSiblingFileMaxIterations = val;
        Q_EMIT imageviewSiblingFileMaxIterationsChanged();
    }
}

const int PQCSettings::getDefaultForImageviewSiblingFileMaxIterations() {
        return 100;
}

void PQCSettings::setDefaultForImageviewSiblingFileMaxIterations() {
    if(100 != m_imageviewSiblingFileMaxIterations) {
        m_imageviewSiblingFileMaxIterations = 100;
    }
}

int PQCSettings::getImageviewSiblingFileMaxLevelUp() {
    return m_imageviewSiblingFileMaxLevelUp;
}

void PQCSettings::setImageviewSiblingFileMaxLevelUp(int val) {
    if(val != m_imageviewSiblingFileMaxLevelUp) {
        m_imageviewSiblingFileMaxLevelUp = val;
        Q_EMIT imageviewSiblingFileMaxLevelUpChanged();
    }
}

const int PQCSettings::getDefaultForImageviewSiblingFileMaxLevelUp() {
        return 8;
}

void PQCSettings::setDefaultForImageviewSiblingFileMaxLevelUp() {
    if(8 != m_imageviewSiblingFileMaxLevelUp) {
        m_imageviewSiblingFileMaxLevelUp = 8;
    }
}

int PQCSettings::getImageviewSiblingFilemaxLevelDown() {
    return m_imageviewSiblingFilemaxLevelDown;
}

void PQCSettings::setImageviewSiblingFilemaxLevelDown(int val) {
    if(val != m_imageviewSiblingFilemaxLevelDown) {
        m_imageviewSiblingFilemaxLevelDown = val;
        Q_EMIT imageviewSiblingFilemaxLevelDownChanged();
    }
}

const int PQCSettings::getDefaultForImageviewSiblingFilemaxLevelDown() {
        return 2;
}

void PQCSettings::setDefaultForImageviewSiblingFilemaxLevelDown() {
    if(2 != m_imageviewSiblingFilemaxLevelDown) {
        m_imageviewSiblingFilemaxLevelDown = 2;
    }
}

bool PQCSettings::getImageviewSortImagesAscending() {
    return m_imageviewSortImagesAscending;
}

void PQCSettings::setImageviewSortImagesAscending(bool val) {
    if(val != m_imageviewSortImagesAscending) {
        m_imageviewSortImagesAscending = val;
        Q_EMIT imageviewSortImagesAscendingChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewSortImagesAscending() {
        return true;
}

void PQCSettings::setDefaultForImageviewSortImagesAscending() {
    if(true != m_imageviewSortImagesAscending) {
        m_imageviewSortImagesAscending = true;
        Q_EMIT imageviewSortImagesAscendingChanged();
    }
}

QString PQCSettings::getImageviewSortImagesBy() {
    return m_imageviewSortImagesBy;
}

void PQCSettings::setImageviewSortImagesBy(QString val) {
    if(val != m_imageviewSortImagesBy) {
        m_imageviewSortImagesBy = val;
        Q_EMIT imageviewSortImagesByChanged();
    }
}

const QString PQCSettings::getDefaultForImageviewSortImagesBy() {
        return "naturalname";
}

void PQCSettings::setDefaultForImageviewSortImagesBy() {
    if("naturalname" != m_imageviewSortImagesBy) {
        m_imageviewSortImagesBy = "naturalname";
        Q_EMIT imageviewSortImagesByChanged();
    }
}

bool PQCSettings::getImageviewTransparencyMarker() {
    return m_imageviewTransparencyMarker;
}

void PQCSettings::setImageviewTransparencyMarker(bool val) {
    if(val != m_imageviewTransparencyMarker) {
        m_imageviewTransparencyMarker = val;
        Q_EMIT imageviewTransparencyMarkerChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewTransparencyMarker() {
        return false;
}

void PQCSettings::setDefaultForImageviewTransparencyMarker() {
    if(false != m_imageviewTransparencyMarker) {
        m_imageviewTransparencyMarker = false;
        Q_EMIT imageviewTransparencyMarkerChanged();
    }
}

bool PQCSettings::getImageviewUseMouseLeftButtonForImageMove() {
    return m_imageviewUseMouseLeftButtonForImageMove;
}

void PQCSettings::setImageviewUseMouseLeftButtonForImageMove(bool val) {
    if(val != m_imageviewUseMouseLeftButtonForImageMove) {
        m_imageviewUseMouseLeftButtonForImageMove = val;
        Q_EMIT imageviewUseMouseLeftButtonForImageMoveChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewUseMouseLeftButtonForImageMove() {
        return true;
}

void PQCSettings::setDefaultForImageviewUseMouseLeftButtonForImageMove() {
    if(true != m_imageviewUseMouseLeftButtonForImageMove) {
        m_imageviewUseMouseLeftButtonForImageMove = true;
        Q_EMIT imageviewUseMouseLeftButtonForImageMoveChanged();
    }
}

bool PQCSettings::getImageviewUseMouseWheelForImageMove() {
    return m_imageviewUseMouseWheelForImageMove;
}

void PQCSettings::setImageviewUseMouseWheelForImageMove(bool val) {
    if(val != m_imageviewUseMouseWheelForImageMove) {
        m_imageviewUseMouseWheelForImageMove = val;
        Q_EMIT imageviewUseMouseWheelForImageMoveChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewUseMouseWheelForImageMove() {
        return false;
}

void PQCSettings::setDefaultForImageviewUseMouseWheelForImageMove() {
    if(false != m_imageviewUseMouseWheelForImageMove) {
        m_imageviewUseMouseWheelForImageMove = false;
        Q_EMIT imageviewUseMouseWheelForImageMoveChanged();
    }
}

int PQCSettings::getImageviewZoomMax() {
    return m_imageviewZoomMax;
}

void PQCSettings::setImageviewZoomMax(int val) {
    if(val != m_imageviewZoomMax) {
        m_imageviewZoomMax = val;
        Q_EMIT imageviewZoomMaxChanged();
    }
}

const int PQCSettings::getDefaultForImageviewZoomMax() {
        return 500;
}

void PQCSettings::setDefaultForImageviewZoomMax() {
    if(500 != m_imageviewZoomMax) {
        m_imageviewZoomMax = 500;
    }
}

bool PQCSettings::getImageviewZoomMaxEnabled() {
    return m_imageviewZoomMaxEnabled;
}

void PQCSettings::setImageviewZoomMaxEnabled(bool val) {
    if(val != m_imageviewZoomMaxEnabled) {
        m_imageviewZoomMaxEnabled = val;
        Q_EMIT imageviewZoomMaxEnabledChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewZoomMaxEnabled() {
        return true;
}

void PQCSettings::setDefaultForImageviewZoomMaxEnabled() {
    if(true != m_imageviewZoomMaxEnabled) {
        m_imageviewZoomMaxEnabled = true;
        Q_EMIT imageviewZoomMaxEnabledChanged();
    }
}

int PQCSettings::getImageviewZoomMin() {
    return m_imageviewZoomMin;
}

void PQCSettings::setImageviewZoomMin(int val) {
    if(val != m_imageviewZoomMin) {
        m_imageviewZoomMin = val;
        Q_EMIT imageviewZoomMinChanged();
    }
}

const int PQCSettings::getDefaultForImageviewZoomMin() {
        return 20;
}

void PQCSettings::setDefaultForImageviewZoomMin() {
    if(20 != m_imageviewZoomMin) {
        m_imageviewZoomMin = 20;
    }
}

bool PQCSettings::getImageviewZoomMinEnabled() {
    return m_imageviewZoomMinEnabled;
}

void PQCSettings::setImageviewZoomMinEnabled(bool val) {
    if(val != m_imageviewZoomMinEnabled) {
        m_imageviewZoomMinEnabled = val;
        Q_EMIT imageviewZoomMinEnabledChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewZoomMinEnabled() {
        return true;
}

void PQCSettings::setDefaultForImageviewZoomMinEnabled() {
    if(true != m_imageviewZoomMinEnabled) {
        m_imageviewZoomMinEnabled = true;
        Q_EMIT imageviewZoomMinEnabledChanged();
    }
}

int PQCSettings::getImageviewZoomSpeed() {
    return m_imageviewZoomSpeed;
}

void PQCSettings::setImageviewZoomSpeed(int val) {
    if(val != m_imageviewZoomSpeed) {
        m_imageviewZoomSpeed = val;
        Q_EMIT imageviewZoomSpeedChanged();
    }
}

const int PQCSettings::getDefaultForImageviewZoomSpeed() {
        return 20;
}

void PQCSettings::setDefaultForImageviewZoomSpeed() {
    if(20 != m_imageviewZoomSpeed) {
        m_imageviewZoomSpeed = 20;
    }
}

bool PQCSettings::getImageviewZoomSpeedRelative() {
    return m_imageviewZoomSpeedRelative;
}

void PQCSettings::setImageviewZoomSpeedRelative(bool val) {
    if(val != m_imageviewZoomSpeedRelative) {
        m_imageviewZoomSpeedRelative = val;
        Q_EMIT imageviewZoomSpeedRelativeChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewZoomSpeedRelative() {
        return true;
}

void PQCSettings::setDefaultForImageviewZoomSpeedRelative() {
    if(true != m_imageviewZoomSpeedRelative) {
        m_imageviewZoomSpeedRelative = true;
        Q_EMIT imageviewZoomSpeedRelativeChanged();
    }
}

bool PQCSettings::getImageviewZoomToCenter() {
    return m_imageviewZoomToCenter;
}

void PQCSettings::setImageviewZoomToCenter(bool val) {
    if(val != m_imageviewZoomToCenter) {
        m_imageviewZoomToCenter = val;
        Q_EMIT imageviewZoomToCenterChanged();
    }
}

const bool PQCSettings::getDefaultForImageviewZoomToCenter() {
        return false;
}

void PQCSettings::setDefaultForImageviewZoomToCenter() {
    if(false != m_imageviewZoomToCenter) {
        m_imageviewZoomToCenter = false;
        Q_EMIT imageviewZoomToCenterChanged();
    }
}

QString PQCSettings::getInterfaceAccentColor() {
    return m_interfaceAccentColor;
}

void PQCSettings::setInterfaceAccentColor(QString val) {
    if(val != m_interfaceAccentColor) {
        m_interfaceAccentColor = val;
        Q_EMIT interfaceAccentColorChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceAccentColor() {
        return "#222222";
}

void PQCSettings::setDefaultForInterfaceAccentColor() {
    if("#222222" != m_interfaceAccentColor) {
        m_interfaceAccentColor = "#222222";
        Q_EMIT interfaceAccentColorChanged();
    }
}

bool PQCSettings::getInterfaceAllowMultipleInstances() {
    return m_interfaceAllowMultipleInstances;
}

void PQCSettings::setInterfaceAllowMultipleInstances(bool val) {
    if(val != m_interfaceAllowMultipleInstances) {
        m_interfaceAllowMultipleInstances = val;
        Q_EMIT interfaceAllowMultipleInstancesChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceAllowMultipleInstances() {
        return false;
}

void PQCSettings::setDefaultForInterfaceAllowMultipleInstances() {
    if(false != m_interfaceAllowMultipleInstances) {
        m_interfaceAllowMultipleInstances = false;
        Q_EMIT interfaceAllowMultipleInstancesChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundCustomOverlay() {
    return m_interfaceBackgroundCustomOverlay;
}

void PQCSettings::setInterfaceBackgroundCustomOverlay(bool val) {
    if(val != m_interfaceBackgroundCustomOverlay) {
        m_interfaceBackgroundCustomOverlay = val;
        Q_EMIT interfaceBackgroundCustomOverlayChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundCustomOverlay() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundCustomOverlay() {
    if(false != m_interfaceBackgroundCustomOverlay) {
        m_interfaceBackgroundCustomOverlay = false;
        Q_EMIT interfaceBackgroundCustomOverlayChanged();
    }
}

QString PQCSettings::getInterfaceBackgroundCustomOverlayColor() {
    return m_interfaceBackgroundCustomOverlayColor;
}

void PQCSettings::setInterfaceBackgroundCustomOverlayColor(QString val) {
    if(val != m_interfaceBackgroundCustomOverlayColor) {
        m_interfaceBackgroundCustomOverlayColor = val;
        Q_EMIT interfaceBackgroundCustomOverlayColorChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceBackgroundCustomOverlayColor() {
        return "";
}

void PQCSettings::setDefaultForInterfaceBackgroundCustomOverlayColor() {
    if("" != m_interfaceBackgroundCustomOverlayColor) {
        m_interfaceBackgroundCustomOverlayColor = "";
        Q_EMIT interfaceBackgroundCustomOverlayColorChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundFullyTransparent() {
    return m_interfaceBackgroundFullyTransparent;
}

void PQCSettings::setInterfaceBackgroundFullyTransparent(bool val) {
    if(val != m_interfaceBackgroundFullyTransparent) {
        m_interfaceBackgroundFullyTransparent = val;
        Q_EMIT interfaceBackgroundFullyTransparentChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundFullyTransparent() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundFullyTransparent() {
    if(false != m_interfaceBackgroundFullyTransparent) {
        m_interfaceBackgroundFullyTransparent = false;
        Q_EMIT interfaceBackgroundFullyTransparentChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundImageCenter() {
    return m_interfaceBackgroundImageCenter;
}

void PQCSettings::setInterfaceBackgroundImageCenter(bool val) {
    if(val != m_interfaceBackgroundImageCenter) {
        m_interfaceBackgroundImageCenter = val;
        Q_EMIT interfaceBackgroundImageCenterChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundImageCenter() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundImageCenter() {
    if(false != m_interfaceBackgroundImageCenter) {
        m_interfaceBackgroundImageCenter = false;
        Q_EMIT interfaceBackgroundImageCenterChanged();
    }
}

QString PQCSettings::getInterfaceBackgroundImagePath() {
    return m_interfaceBackgroundImagePath;
}

void PQCSettings::setInterfaceBackgroundImagePath(QString val) {
    if(val != m_interfaceBackgroundImagePath) {
        m_interfaceBackgroundImagePath = val;
        Q_EMIT interfaceBackgroundImagePathChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceBackgroundImagePath() {
        return "";
}

void PQCSettings::setDefaultForInterfaceBackgroundImagePath() {
    if("" != m_interfaceBackgroundImagePath) {
        m_interfaceBackgroundImagePath = "";
        Q_EMIT interfaceBackgroundImagePathChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundImageScale() {
    return m_interfaceBackgroundImageScale;
}

void PQCSettings::setInterfaceBackgroundImageScale(bool val) {
    if(val != m_interfaceBackgroundImageScale) {
        m_interfaceBackgroundImageScale = val;
        Q_EMIT interfaceBackgroundImageScaleChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundImageScale() {
        return true;
}

void PQCSettings::setDefaultForInterfaceBackgroundImageScale() {
    if(true != m_interfaceBackgroundImageScale) {
        m_interfaceBackgroundImageScale = true;
        Q_EMIT interfaceBackgroundImageScaleChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundImageScaleCrop() {
    return m_interfaceBackgroundImageScaleCrop;
}

void PQCSettings::setInterfaceBackgroundImageScaleCrop(bool val) {
    if(val != m_interfaceBackgroundImageScaleCrop) {
        m_interfaceBackgroundImageScaleCrop = val;
        Q_EMIT interfaceBackgroundImageScaleCropChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundImageScaleCrop() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundImageScaleCrop() {
    if(false != m_interfaceBackgroundImageScaleCrop) {
        m_interfaceBackgroundImageScaleCrop = false;
        Q_EMIT interfaceBackgroundImageScaleCropChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundImageScreenshot() {
    return m_interfaceBackgroundImageScreenshot;
}

void PQCSettings::setInterfaceBackgroundImageScreenshot(bool val) {
    if(val != m_interfaceBackgroundImageScreenshot) {
        m_interfaceBackgroundImageScreenshot = val;
        Q_EMIT interfaceBackgroundImageScreenshotChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundImageScreenshot() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundImageScreenshot() {
    if(false != m_interfaceBackgroundImageScreenshot) {
        m_interfaceBackgroundImageScreenshot = false;
        Q_EMIT interfaceBackgroundImageScreenshotChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundImageStretch() {
    return m_interfaceBackgroundImageStretch;
}

void PQCSettings::setInterfaceBackgroundImageStretch(bool val) {
    if(val != m_interfaceBackgroundImageStretch) {
        m_interfaceBackgroundImageStretch = val;
        Q_EMIT interfaceBackgroundImageStretchChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundImageStretch() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundImageStretch() {
    if(false != m_interfaceBackgroundImageStretch) {
        m_interfaceBackgroundImageStretch = false;
        Q_EMIT interfaceBackgroundImageStretchChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundImageTile() {
    return m_interfaceBackgroundImageTile;
}

void PQCSettings::setInterfaceBackgroundImageTile(bool val) {
    if(val != m_interfaceBackgroundImageTile) {
        m_interfaceBackgroundImageTile = val;
        Q_EMIT interfaceBackgroundImageTileChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundImageTile() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundImageTile() {
    if(false != m_interfaceBackgroundImageTile) {
        m_interfaceBackgroundImageTile = false;
        Q_EMIT interfaceBackgroundImageTileChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundImageUse() {
    return m_interfaceBackgroundImageUse;
}

void PQCSettings::setInterfaceBackgroundImageUse(bool val) {
    if(val != m_interfaceBackgroundImageUse) {
        m_interfaceBackgroundImageUse = val;
        Q_EMIT interfaceBackgroundImageUseChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundImageUse() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundImageUse() {
    if(false != m_interfaceBackgroundImageUse) {
        m_interfaceBackgroundImageUse = false;
        Q_EMIT interfaceBackgroundImageUseChanged();
    }
}

bool PQCSettings::getInterfaceBackgroundSolid() {
    return m_interfaceBackgroundSolid;
}

void PQCSettings::setInterfaceBackgroundSolid(bool val) {
    if(val != m_interfaceBackgroundSolid) {
        m_interfaceBackgroundSolid = val;
        Q_EMIT interfaceBackgroundSolidChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBackgroundSolid() {
        return false;
}

void PQCSettings::setDefaultForInterfaceBackgroundSolid() {
    if(false != m_interfaceBackgroundSolid) {
        m_interfaceBackgroundSolid = false;
        Q_EMIT interfaceBackgroundSolidChanged();
    }
}

bool PQCSettings::getInterfaceBlurElementsInBackground() {
    return m_interfaceBlurElementsInBackground;
}

void PQCSettings::setInterfaceBlurElementsInBackground(bool val) {
    if(val != m_interfaceBlurElementsInBackground) {
        m_interfaceBlurElementsInBackground = val;
        Q_EMIT interfaceBlurElementsInBackgroundChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceBlurElementsInBackground() {
        return true;
}

void PQCSettings::setDefaultForInterfaceBlurElementsInBackground() {
    if(true != m_interfaceBlurElementsInBackground) {
        m_interfaceBlurElementsInBackground = true;
        Q_EMIT interfaceBlurElementsInBackgroundChanged();
    }
}

bool PQCSettings::getInterfaceCloseOnEmptyBackground() {
    return m_interfaceCloseOnEmptyBackground;
}

void PQCSettings::setInterfaceCloseOnEmptyBackground(bool val) {
    if(val != m_interfaceCloseOnEmptyBackground) {
        m_interfaceCloseOnEmptyBackground = val;
        Q_EMIT interfaceCloseOnEmptyBackgroundChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceCloseOnEmptyBackground() {
        return false;
}

void PQCSettings::setDefaultForInterfaceCloseOnEmptyBackground() {
    if(false != m_interfaceCloseOnEmptyBackground) {
        m_interfaceCloseOnEmptyBackground = false;
        Q_EMIT interfaceCloseOnEmptyBackgroundChanged();
    }
}

int PQCSettings::getInterfaceDoubleClickThreshold() {
    return m_interfaceDoubleClickThreshold;
}

void PQCSettings::setInterfaceDoubleClickThreshold(int val) {
    if(val != m_interfaceDoubleClickThreshold) {
        m_interfaceDoubleClickThreshold = val;
        Q_EMIT interfaceDoubleClickThresholdChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceDoubleClickThreshold() {
        return 300;
}

void PQCSettings::setDefaultForInterfaceDoubleClickThreshold() {
    if(300 != m_interfaceDoubleClickThreshold) {
        m_interfaceDoubleClickThreshold = 300;
    }
}

QString PQCSettings::getInterfaceEdgeBottomAction() {
    return m_interfaceEdgeBottomAction;
}

void PQCSettings::setInterfaceEdgeBottomAction(QString val) {
    if(val != m_interfaceEdgeBottomAction) {
        m_interfaceEdgeBottomAction = val;
        Q_EMIT interfaceEdgeBottomActionChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceEdgeBottomAction() {
        return "thumbnails";
}

void PQCSettings::setDefaultForInterfaceEdgeBottomAction() {
    if("thumbnails" != m_interfaceEdgeBottomAction) {
        m_interfaceEdgeBottomAction = "thumbnails";
        Q_EMIT interfaceEdgeBottomActionChanged();
    }
}

QString PQCSettings::getInterfaceEdgeLeftAction() {
    return m_interfaceEdgeLeftAction;
}

void PQCSettings::setInterfaceEdgeLeftAction(QString val) {
    if(val != m_interfaceEdgeLeftAction) {
        m_interfaceEdgeLeftAction = val;
        Q_EMIT interfaceEdgeLeftActionChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceEdgeLeftAction() {
        return "metadata";
}

void PQCSettings::setDefaultForInterfaceEdgeLeftAction() {
    if("metadata" != m_interfaceEdgeLeftAction) {
        m_interfaceEdgeLeftAction = "metadata";
        Q_EMIT interfaceEdgeLeftActionChanged();
    }
}

QString PQCSettings::getInterfaceEdgeRightAction() {
    return m_interfaceEdgeRightAction;
}

void PQCSettings::setInterfaceEdgeRightAction(QString val) {
    if(val != m_interfaceEdgeRightAction) {
        m_interfaceEdgeRightAction = val;
        Q_EMIT interfaceEdgeRightActionChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceEdgeRightAction() {
        return "mainmenu";
}

void PQCSettings::setDefaultForInterfaceEdgeRightAction() {
    if("mainmenu" != m_interfaceEdgeRightAction) {
        m_interfaceEdgeRightAction = "mainmenu";
        Q_EMIT interfaceEdgeRightActionChanged();
    }
}

QString PQCSettings::getInterfaceEdgeTopAction() {
    return m_interfaceEdgeTopAction;
}

void PQCSettings::setInterfaceEdgeTopAction(QString val) {
    if(val != m_interfaceEdgeTopAction) {
        m_interfaceEdgeTopAction = val;
        Q_EMIT interfaceEdgeTopActionChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceEdgeTopAction() {
        return "";
}

void PQCSettings::setDefaultForInterfaceEdgeTopAction() {
    if("" != m_interfaceEdgeTopAction) {
        m_interfaceEdgeTopAction = "";
        Q_EMIT interfaceEdgeTopActionChanged();
    }
}

bool PQCSettings::getInterfaceFlickAdjustSpeed() {
    return m_interfaceFlickAdjustSpeed;
}

void PQCSettings::setInterfaceFlickAdjustSpeed(bool val) {
    if(val != m_interfaceFlickAdjustSpeed) {
        m_interfaceFlickAdjustSpeed = val;
        Q_EMIT interfaceFlickAdjustSpeedChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceFlickAdjustSpeed() {
        return true;
}

void PQCSettings::setDefaultForInterfaceFlickAdjustSpeed() {
    if(true != m_interfaceFlickAdjustSpeed) {
        m_interfaceFlickAdjustSpeed = true;
        Q_EMIT interfaceFlickAdjustSpeedChanged();
    }
}

int PQCSettings::getInterfaceFlickAdjustSpeedSpeedup() {
    return m_interfaceFlickAdjustSpeedSpeedup;
}

void PQCSettings::setInterfaceFlickAdjustSpeedSpeedup(int val) {
    if(val != m_interfaceFlickAdjustSpeedSpeedup) {
        m_interfaceFlickAdjustSpeedSpeedup = val;
        Q_EMIT interfaceFlickAdjustSpeedSpeedupChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceFlickAdjustSpeedSpeedup() {
        return 1;
}

void PQCSettings::setDefaultForInterfaceFlickAdjustSpeedSpeedup() {
    if(1 != m_interfaceFlickAdjustSpeedSpeedup) {
        m_interfaceFlickAdjustSpeedSpeedup = 1;
    }
}

int PQCSettings::getInterfaceFontBoldWeight() {
    return m_interfaceFontBoldWeight;
}

void PQCSettings::setInterfaceFontBoldWeight(int val) {
    if(val != m_interfaceFontBoldWeight) {
        m_interfaceFontBoldWeight = val;
        Q_EMIT interfaceFontBoldWeightChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceFontBoldWeight() {
        return 700;
}

void PQCSettings::setDefaultForInterfaceFontBoldWeight() {
    if(700 != m_interfaceFontBoldWeight) {
        m_interfaceFontBoldWeight = 700;
    }
}

int PQCSettings::getInterfaceFontNormalWeight() {
    return m_interfaceFontNormalWeight;
}

void PQCSettings::setInterfaceFontNormalWeight(int val) {
    if(val != m_interfaceFontNormalWeight) {
        m_interfaceFontNormalWeight = val;
        Q_EMIT interfaceFontNormalWeightChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceFontNormalWeight() {
        return 400;
}

void PQCSettings::setDefaultForInterfaceFontNormalWeight() {
    if(400 != m_interfaceFontNormalWeight) {
        m_interfaceFontNormalWeight = 400;
    }
}

int PQCSettings::getInterfaceHotEdgeSize() {
    return m_interfaceHotEdgeSize;
}

void PQCSettings::setInterfaceHotEdgeSize(int val) {
    if(val != m_interfaceHotEdgeSize) {
        m_interfaceHotEdgeSize = val;
        Q_EMIT interfaceHotEdgeSizeChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceHotEdgeSize() {
        return 4;
}

void PQCSettings::setDefaultForInterfaceHotEdgeSize() {
    if(4 != m_interfaceHotEdgeSize) {
        m_interfaceHotEdgeSize = 4;
    }
}

bool PQCSettings::getInterfaceKeepWindowOnTop() {
    return m_interfaceKeepWindowOnTop;
}

void PQCSettings::setInterfaceKeepWindowOnTop(bool val) {
    if(val != m_interfaceKeepWindowOnTop) {
        m_interfaceKeepWindowOnTop = val;
        Q_EMIT interfaceKeepWindowOnTopChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceKeepWindowOnTop() {
        return false;
}

void PQCSettings::setDefaultForInterfaceKeepWindowOnTop() {
    if(false != m_interfaceKeepWindowOnTop) {
        m_interfaceKeepWindowOnTop = false;
        Q_EMIT interfaceKeepWindowOnTopChanged();
    }
}

QString PQCSettings::getInterfaceLanguage() {
    return m_interfaceLanguage;
}

void PQCSettings::setInterfaceLanguage(QString val) {
    if(val != m_interfaceLanguage) {
        m_interfaceLanguage = val;
        Q_EMIT interfaceLanguageChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceLanguage() {
        return "en";
}

void PQCSettings::setDefaultForInterfaceLanguage() {
    if("en" != m_interfaceLanguage) {
        m_interfaceLanguage = "en";
        Q_EMIT interfaceLanguageChanged();
    }
}

bool PQCSettings::getInterfaceMinimapPopout() {
    return m_interfaceMinimapPopout;
}

void PQCSettings::setInterfaceMinimapPopout(bool val) {
    if(val != m_interfaceMinimapPopout) {
        m_interfaceMinimapPopout = val;
        Q_EMIT interfaceMinimapPopoutChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceMinimapPopout() {
        return false;
}

void PQCSettings::setDefaultForInterfaceMinimapPopout() {
    if(false != m_interfaceMinimapPopout) {
        m_interfaceMinimapPopout = false;
        Q_EMIT interfaceMinimapPopoutChanged();
    }
}

bool PQCSettings::getInterfaceNavigateOnEmptyBackground() {
    return m_interfaceNavigateOnEmptyBackground;
}

void PQCSettings::setInterfaceNavigateOnEmptyBackground(bool val) {
    if(val != m_interfaceNavigateOnEmptyBackground) {
        m_interfaceNavigateOnEmptyBackground = val;
        Q_EMIT interfaceNavigateOnEmptyBackgroundChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceNavigateOnEmptyBackground() {
        return false;
}

void PQCSettings::setDefaultForInterfaceNavigateOnEmptyBackground() {
    if(false != m_interfaceNavigateOnEmptyBackground) {
        m_interfaceNavigateOnEmptyBackground = false;
        Q_EMIT interfaceNavigateOnEmptyBackgroundChanged();
    }
}

bool PQCSettings::getInterfaceNavigationFloating() {
    return m_interfaceNavigationFloating;
}

void PQCSettings::setInterfaceNavigationFloating(bool val) {
    if(val != m_interfaceNavigationFloating) {
        m_interfaceNavigationFloating = val;
        Q_EMIT interfaceNavigationFloatingChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceNavigationFloating() {
        return false;
}

void PQCSettings::setDefaultForInterfaceNavigationFloating() {
    if(false != m_interfaceNavigationFloating) {
        m_interfaceNavigationFloating = false;
        Q_EMIT interfaceNavigationFloatingChanged();
    }
}

int PQCSettings::getInterfaceNotificationDistanceFromEdge() {
    return m_interfaceNotificationDistanceFromEdge;
}

void PQCSettings::setInterfaceNotificationDistanceFromEdge(int val) {
    if(val != m_interfaceNotificationDistanceFromEdge) {
        m_interfaceNotificationDistanceFromEdge = val;
        Q_EMIT interfaceNotificationDistanceFromEdgeChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceNotificationDistanceFromEdge() {
        return 40;
}

void PQCSettings::setDefaultForInterfaceNotificationDistanceFromEdge() {
    if(40 != m_interfaceNotificationDistanceFromEdge) {
        m_interfaceNotificationDistanceFromEdge = 40;
    }
}

QString PQCSettings::getInterfaceNotificationLocation() {
    return m_interfaceNotificationLocation;
}

void PQCSettings::setInterfaceNotificationLocation(QString val) {
    if(val != m_interfaceNotificationLocation) {
        m_interfaceNotificationLocation = val;
        Q_EMIT interfaceNotificationLocationChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceNotificationLocation() {
        return "center";
}

void PQCSettings::setDefaultForInterfaceNotificationLocation() {
    if("center" != m_interfaceNotificationLocation) {
        m_interfaceNotificationLocation = "center";
        Q_EMIT interfaceNotificationLocationChanged();
    }
}

bool PQCSettings::getInterfaceNotificationTryNative() {
    return m_interfaceNotificationTryNative;
}

void PQCSettings::setInterfaceNotificationTryNative(bool val) {
    if(val != m_interfaceNotificationTryNative) {
        m_interfaceNotificationTryNative = val;
        Q_EMIT interfaceNotificationTryNativeChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceNotificationTryNative() {
        return true;
}

void PQCSettings::setDefaultForInterfaceNotificationTryNative() {
    if(true != m_interfaceNotificationTryNative) {
        m_interfaceNotificationTryNative = true;
        Q_EMIT interfaceNotificationTryNativeChanged();
    }
}

bool PQCSettings::getInterfacePopoutAbout() {
    return m_interfacePopoutAbout;
}

void PQCSettings::setInterfacePopoutAbout(bool val) {
    if(val != m_interfacePopoutAbout) {
        m_interfacePopoutAbout = val;
        Q_EMIT interfacePopoutAboutChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutAbout() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutAbout() {
    if(false != m_interfacePopoutAbout) {
        m_interfacePopoutAbout = false;
        Q_EMIT interfacePopoutAboutChanged();
    }
}

bool PQCSettings::getInterfacePopoutAdvancedSort() {
    return m_interfacePopoutAdvancedSort;
}

void PQCSettings::setInterfacePopoutAdvancedSort(bool val) {
    if(val != m_interfacePopoutAdvancedSort) {
        m_interfacePopoutAdvancedSort = val;
        Q_EMIT interfacePopoutAdvancedSortChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutAdvancedSort() {
        return true;
}

void PQCSettings::setDefaultForInterfacePopoutAdvancedSort() {
    if(true != m_interfacePopoutAdvancedSort) {
        m_interfacePopoutAdvancedSort = true;
        Q_EMIT interfacePopoutAdvancedSortChanged();
    }
}

bool PQCSettings::getInterfacePopoutChromecast() {
    return m_interfacePopoutChromecast;
}

void PQCSettings::setInterfacePopoutChromecast(bool val) {
    if(val != m_interfacePopoutChromecast) {
        m_interfacePopoutChromecast = val;
        Q_EMIT interfacePopoutChromecastChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutChromecast() {
        return true;
}

void PQCSettings::setDefaultForInterfacePopoutChromecast() {
    if(true != m_interfacePopoutChromecast) {
        m_interfacePopoutChromecast = true;
        Q_EMIT interfacePopoutChromecastChanged();
    }
}

bool PQCSettings::getInterfacePopoutExport() {
    return m_interfacePopoutExport;
}

void PQCSettings::setInterfacePopoutExport(bool val) {
    if(val != m_interfacePopoutExport) {
        m_interfacePopoutExport = val;
        Q_EMIT interfacePopoutExportChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutExport() {
        return true;
}

void PQCSettings::setDefaultForInterfacePopoutExport() {
    if(true != m_interfacePopoutExport) {
        m_interfacePopoutExport = true;
        Q_EMIT interfacePopoutExportChanged();
    }
}

bool PQCSettings::getInterfacePopoutFileDelete() {
    return m_interfacePopoutFileDelete;
}

void PQCSettings::setInterfacePopoutFileDelete(bool val) {
    if(val != m_interfacePopoutFileDelete) {
        m_interfacePopoutFileDelete = val;
        Q_EMIT interfacePopoutFileDeleteChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutFileDelete() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutFileDelete() {
    if(false != m_interfacePopoutFileDelete) {
        m_interfacePopoutFileDelete = false;
        Q_EMIT interfacePopoutFileDeleteChanged();
    }
}

bool PQCSettings::getInterfacePopoutFileDialog() {
    return m_interfacePopoutFileDialog;
}

void PQCSettings::setInterfacePopoutFileDialog(bool val) {
    if(val != m_interfacePopoutFileDialog) {
        m_interfacePopoutFileDialog = val;
        Q_EMIT interfacePopoutFileDialogChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutFileDialog() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutFileDialog() {
    if(false != m_interfacePopoutFileDialog) {
        m_interfacePopoutFileDialog = false;
        Q_EMIT interfacePopoutFileDialogChanged();
    }
}

bool PQCSettings::getInterfacePopoutFileDialogNonModal() {
    return m_interfacePopoutFileDialogNonModal;
}

void PQCSettings::setInterfacePopoutFileDialogNonModal(bool val) {
    if(val != m_interfacePopoutFileDialogNonModal) {
        m_interfacePopoutFileDialogNonModal = val;
        Q_EMIT interfacePopoutFileDialogNonModalChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutFileDialogNonModal() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutFileDialogNonModal() {
    if(false != m_interfacePopoutFileDialogNonModal) {
        m_interfacePopoutFileDialogNonModal = false;
        Q_EMIT interfacePopoutFileDialogNonModalChanged();
    }
}

bool PQCSettings::getInterfacePopoutFileRename() {
    return m_interfacePopoutFileRename;
}

void PQCSettings::setInterfacePopoutFileRename(bool val) {
    if(val != m_interfacePopoutFileRename) {
        m_interfacePopoutFileRename = val;
        Q_EMIT interfacePopoutFileRenameChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutFileRename() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutFileRename() {
    if(false != m_interfacePopoutFileRename) {
        m_interfacePopoutFileRename = false;
        Q_EMIT interfacePopoutFileRenameChanged();
    }
}

bool PQCSettings::getInterfacePopoutFilter() {
    return m_interfacePopoutFilter;
}

void PQCSettings::setInterfacePopoutFilter(bool val) {
    if(val != m_interfacePopoutFilter) {
        m_interfacePopoutFilter = val;
        Q_EMIT interfacePopoutFilterChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutFilter() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutFilter() {
    if(false != m_interfacePopoutFilter) {
        m_interfacePopoutFilter = false;
        Q_EMIT interfacePopoutFilterChanged();
    }
}

bool PQCSettings::getInterfacePopoutFind() {
    return m_interfacePopoutFind;
}

void PQCSettings::setInterfacePopoutFind(bool val) {
    if(val != m_interfacePopoutFind) {
        m_interfacePopoutFind = val;
        Q_EMIT interfacePopoutFindChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutFind() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutFind() {
    if(false != m_interfacePopoutFind) {
        m_interfacePopoutFind = false;
        Q_EMIT interfacePopoutFindChanged();
    }
}

bool PQCSettings::getInterfacePopoutImgur() {
    return m_interfacePopoutImgur;
}

void PQCSettings::setInterfacePopoutImgur(bool val) {
    if(val != m_interfacePopoutImgur) {
        m_interfacePopoutImgur = val;
        Q_EMIT interfacePopoutImgurChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutImgur() {
        return true;
}

void PQCSettings::setDefaultForInterfacePopoutImgur() {
    if(true != m_interfacePopoutImgur) {
        m_interfacePopoutImgur = true;
        Q_EMIT interfacePopoutImgurChanged();
    }
}

bool PQCSettings::getInterfacePopoutMainMenu() {
    return m_interfacePopoutMainMenu;
}

void PQCSettings::setInterfacePopoutMainMenu(bool val) {
    if(val != m_interfacePopoutMainMenu) {
        m_interfacePopoutMainMenu = val;
        Q_EMIT interfacePopoutMainMenuChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutMainMenu() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutMainMenu() {
    if(false != m_interfacePopoutMainMenu) {
        m_interfacePopoutMainMenu = false;
        Q_EMIT interfacePopoutMainMenuChanged();
    }
}

bool PQCSettings::getInterfacePopoutMapExplorer() {
    return m_interfacePopoutMapExplorer;
}

void PQCSettings::setInterfacePopoutMapExplorer(bool val) {
    if(val != m_interfacePopoutMapExplorer) {
        m_interfacePopoutMapExplorer = val;
        Q_EMIT interfacePopoutMapExplorerChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutMapExplorer() {
        return true;
}

void PQCSettings::setDefaultForInterfacePopoutMapExplorer() {
    if(true != m_interfacePopoutMapExplorer) {
        m_interfacePopoutMapExplorer = true;
        Q_EMIT interfacePopoutMapExplorerChanged();
    }
}

bool PQCSettings::getInterfacePopoutMapExplorerNonModal() {
    return m_interfacePopoutMapExplorerNonModal;
}

void PQCSettings::setInterfacePopoutMapExplorerNonModal(bool val) {
    if(val != m_interfacePopoutMapExplorerNonModal) {
        m_interfacePopoutMapExplorerNonModal = val;
        Q_EMIT interfacePopoutMapExplorerNonModalChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutMapExplorerNonModal() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutMapExplorerNonModal() {
    if(false != m_interfacePopoutMapExplorerNonModal) {
        m_interfacePopoutMapExplorerNonModal = false;
        Q_EMIT interfacePopoutMapExplorerNonModalChanged();
    }
}

bool PQCSettings::getInterfacePopoutMetadata() {
    return m_interfacePopoutMetadata;
}

void PQCSettings::setInterfacePopoutMetadata(bool val) {
    if(val != m_interfacePopoutMetadata) {
        m_interfacePopoutMetadata = val;
        Q_EMIT interfacePopoutMetadataChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutMetadata() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutMetadata() {
    if(false != m_interfacePopoutMetadata) {
        m_interfacePopoutMetadata = false;
        Q_EMIT interfacePopoutMetadataChanged();
    }
}

bool PQCSettings::getInterfacePopoutSettingsManager() {
    return m_interfacePopoutSettingsManager;
}

void PQCSettings::setInterfacePopoutSettingsManager(bool val) {
    if(val != m_interfacePopoutSettingsManager) {
        m_interfacePopoutSettingsManager = val;
        Q_EMIT interfacePopoutSettingsManagerChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutSettingsManager() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutSettingsManager() {
    if(false != m_interfacePopoutSettingsManager) {
        m_interfacePopoutSettingsManager = false;
        Q_EMIT interfacePopoutSettingsManagerChanged();
    }
}

bool PQCSettings::getInterfacePopoutSettingsManagerNonModal() {
    return m_interfacePopoutSettingsManagerNonModal;
}

void PQCSettings::setInterfacePopoutSettingsManagerNonModal(bool val) {
    if(val != m_interfacePopoutSettingsManagerNonModal) {
        m_interfacePopoutSettingsManagerNonModal = val;
        Q_EMIT interfacePopoutSettingsManagerNonModalChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutSettingsManagerNonModal() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutSettingsManagerNonModal() {
    if(false != m_interfacePopoutSettingsManagerNonModal) {
        m_interfacePopoutSettingsManagerNonModal = false;
        Q_EMIT interfacePopoutSettingsManagerNonModalChanged();
    }
}

bool PQCSettings::getInterfacePopoutSlideshowControls() {
    return m_interfacePopoutSlideshowControls;
}

void PQCSettings::setInterfacePopoutSlideshowControls(bool val) {
    if(val != m_interfacePopoutSlideshowControls) {
        m_interfacePopoutSlideshowControls = val;
        Q_EMIT interfacePopoutSlideshowControlsChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutSlideshowControls() {
        return false;
}

void PQCSettings::setDefaultForInterfacePopoutSlideshowControls() {
    if(false != m_interfacePopoutSlideshowControls) {
        m_interfacePopoutSlideshowControls = false;
        Q_EMIT interfacePopoutSlideshowControlsChanged();
    }
}

bool PQCSettings::getInterfacePopoutSlideshowSetup() {
    return m_interfacePopoutSlideshowSetup;
}

void PQCSettings::setInterfacePopoutSlideshowSetup(bool val) {
    if(val != m_interfacePopoutSlideshowSetup) {
        m_interfacePopoutSlideshowSetup = val;
        Q_EMIT interfacePopoutSlideshowSetupChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutSlideshowSetup() {
        return true;
}

void PQCSettings::setDefaultForInterfacePopoutSlideshowSetup() {
    if(true != m_interfacePopoutSlideshowSetup) {
        m_interfacePopoutSlideshowSetup = true;
        Q_EMIT interfacePopoutSlideshowSetupChanged();
    }
}

bool PQCSettings::getInterfacePopoutWhenWindowIsSmall() {
    return m_interfacePopoutWhenWindowIsSmall;
}

void PQCSettings::setInterfacePopoutWhenWindowIsSmall(bool val) {
    if(val != m_interfacePopoutWhenWindowIsSmall) {
        m_interfacePopoutWhenWindowIsSmall = val;
        Q_EMIT interfacePopoutWhenWindowIsSmallChanged();
    }
}

const bool PQCSettings::getDefaultForInterfacePopoutWhenWindowIsSmall() {
        return true;
}

void PQCSettings::setDefaultForInterfacePopoutWhenWindowIsSmall() {
    if(true != m_interfacePopoutWhenWindowIsSmall) {
        m_interfacePopoutWhenWindowIsSmall = true;
        Q_EMIT interfacePopoutWhenWindowIsSmallChanged();
    }
}

bool PQCSettings::getInterfaceQuickActions() {
    return m_interfaceQuickActions;
}

void PQCSettings::setInterfaceQuickActions(bool val) {
    if(val != m_interfaceQuickActions) {
        m_interfaceQuickActions = val;
        Q_EMIT interfaceQuickActionsChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceQuickActions() {
        return false;
}

void PQCSettings::setDefaultForInterfaceQuickActions() {
    if(false != m_interfaceQuickActions) {
        m_interfaceQuickActions = false;
        Q_EMIT interfaceQuickActionsChanged();
    }
}

int PQCSettings::getInterfaceQuickActionsHeight() {
    return m_interfaceQuickActionsHeight;
}

void PQCSettings::setInterfaceQuickActionsHeight(int val) {
    if(val != m_interfaceQuickActionsHeight) {
        m_interfaceQuickActionsHeight = val;
        Q_EMIT interfaceQuickActionsHeightChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceQuickActionsHeight() {
        return 40;
}

void PQCSettings::setDefaultForInterfaceQuickActionsHeight() {
    if(40 != m_interfaceQuickActionsHeight) {
        m_interfaceQuickActionsHeight = 40;
    }
}

QStringList PQCSettings::getInterfaceQuickActionsItems() {
    return m_interfaceQuickActionsItems;
}

void PQCSettings::setInterfaceQuickActionsItems(QStringList val) {
    if(val != m_interfaceQuickActionsItems) {
        m_interfaceQuickActionsItems = val;
        Q_EMIT interfaceQuickActionsItemsChanged();
    }
}

const QStringList PQCSettings::getDefaultForInterfaceQuickActionsItems() {
        return QStringList() << "rename" << "delete" << "|" << "rotateleft" << "rotateright" << "mirrorhor" << "mirrorver" << "|" << "crop" << "scale" << "|" << "close";
}

void PQCSettings::setDefaultForInterfaceQuickActionsItems() {
    QStringList tmp = QStringList() << "rename" << "delete" << "|" << "rotateleft" << "rotateright" << "mirrorhor" << "mirrorver" << "|" << "crop" << "scale" << "|" << "close";
    if(tmp != m_interfaceQuickActionsItems) {
        m_interfaceQuickActionsItems = tmp;
        Q_EMIT interfaceQuickActionsItemsChanged();
    }
}

bool PQCSettings::getInterfaceRememberLastImage() {
    return m_interfaceRememberLastImage;
}

void PQCSettings::setInterfaceRememberLastImage(bool val) {
    if(val != m_interfaceRememberLastImage) {
        m_interfaceRememberLastImage = val;
        Q_EMIT interfaceRememberLastImageChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceRememberLastImage() {
        return false;
}

void PQCSettings::setDefaultForInterfaceRememberLastImage() {
    if(false != m_interfaceRememberLastImage) {
        m_interfaceRememberLastImage = false;
        Q_EMIT interfaceRememberLastImageChanged();
    }
}

bool PQCSettings::getInterfaceSaveWindowGeometry() {
    return m_interfaceSaveWindowGeometry;
}

void PQCSettings::setInterfaceSaveWindowGeometry(bool val) {
    if(val != m_interfaceSaveWindowGeometry) {
        m_interfaceSaveWindowGeometry = val;
        Q_EMIT interfaceSaveWindowGeometryChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceSaveWindowGeometry() {
        return false;
}

void PQCSettings::setDefaultForInterfaceSaveWindowGeometry() {
    if(false != m_interfaceSaveWindowGeometry) {
        m_interfaceSaveWindowGeometry = false;
        Q_EMIT interfaceSaveWindowGeometryChanged();
    }
}

bool PQCSettings::getInterfaceStatusInfoAutoHide() {
    return m_interfaceStatusInfoAutoHide;
}

void PQCSettings::setInterfaceStatusInfoAutoHide(bool val) {
    if(val != m_interfaceStatusInfoAutoHide) {
        m_interfaceStatusInfoAutoHide = val;
        Q_EMIT interfaceStatusInfoAutoHideChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceStatusInfoAutoHide() {
        return false;
}

void PQCSettings::setDefaultForInterfaceStatusInfoAutoHide() {
    if(false != m_interfaceStatusInfoAutoHide) {
        m_interfaceStatusInfoAutoHide = false;
        Q_EMIT interfaceStatusInfoAutoHideChanged();
    }
}

int PQCSettings::getInterfaceStatusInfoAutoHideTimeout() {
    return m_interfaceStatusInfoAutoHideTimeout;
}

void PQCSettings::setInterfaceStatusInfoAutoHideTimeout(int val) {
    if(val != m_interfaceStatusInfoAutoHideTimeout) {
        m_interfaceStatusInfoAutoHideTimeout = val;
        Q_EMIT interfaceStatusInfoAutoHideTimeoutChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceStatusInfoAutoHideTimeout() {
        return 1000;
}

void PQCSettings::setDefaultForInterfaceStatusInfoAutoHideTimeout() {
    if(1000 != m_interfaceStatusInfoAutoHideTimeout) {
        m_interfaceStatusInfoAutoHideTimeout = 1000;
    }
}

bool PQCSettings::getInterfaceStatusInfoAutoHideTopEdge() {
    return m_interfaceStatusInfoAutoHideTopEdge;
}

void PQCSettings::setInterfaceStatusInfoAutoHideTopEdge(bool val) {
    if(val != m_interfaceStatusInfoAutoHideTopEdge) {
        m_interfaceStatusInfoAutoHideTopEdge = val;
        Q_EMIT interfaceStatusInfoAutoHideTopEdgeChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceStatusInfoAutoHideTopEdge() {
        return false;
}

void PQCSettings::setDefaultForInterfaceStatusInfoAutoHideTopEdge() {
    if(false != m_interfaceStatusInfoAutoHideTopEdge) {
        m_interfaceStatusInfoAutoHideTopEdge = false;
        Q_EMIT interfaceStatusInfoAutoHideTopEdgeChanged();
    }
}

int PQCSettings::getInterfaceStatusInfoFontSize() {
    return m_interfaceStatusInfoFontSize;
}

void PQCSettings::setInterfaceStatusInfoFontSize(int val) {
    if(val != m_interfaceStatusInfoFontSize) {
        m_interfaceStatusInfoFontSize = val;
        Q_EMIT interfaceStatusInfoFontSizeChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceStatusInfoFontSize() {
        return 10;
}

void PQCSettings::setDefaultForInterfaceStatusInfoFontSize() {
    if(10 != m_interfaceStatusInfoFontSize) {
        m_interfaceStatusInfoFontSize = 10;
    }
}

QStringList PQCSettings::getInterfaceStatusInfoList() {
    return m_interfaceStatusInfoList;
}

void PQCSettings::setInterfaceStatusInfoList(QStringList val) {
    if(val != m_interfaceStatusInfoList) {
        m_interfaceStatusInfoList = val;
        Q_EMIT interfaceStatusInfoListChanged();
    }
}

const QStringList PQCSettings::getDefaultForInterfaceStatusInfoList() {
        return QStringList() << "counter" << "filename" << "zoom" << "rotation";
}

void PQCSettings::setDefaultForInterfaceStatusInfoList() {
    QStringList tmp = QStringList() << "counter" << "filename" << "zoom" << "rotation";
    if(tmp != m_interfaceStatusInfoList) {
        m_interfaceStatusInfoList = tmp;
        Q_EMIT interfaceStatusInfoListChanged();
    }
}

bool PQCSettings::getInterfaceStatusInfoManageWindow() {
    return m_interfaceStatusInfoManageWindow;
}

void PQCSettings::setInterfaceStatusInfoManageWindow(bool val) {
    if(val != m_interfaceStatusInfoManageWindow) {
        m_interfaceStatusInfoManageWindow = val;
        Q_EMIT interfaceStatusInfoManageWindowChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceStatusInfoManageWindow() {
        return false;
}

void PQCSettings::setDefaultForInterfaceStatusInfoManageWindow() {
    if(false != m_interfaceStatusInfoManageWindow) {
        m_interfaceStatusInfoManageWindow = false;
        Q_EMIT interfaceStatusInfoManageWindowChanged();
    }
}

QString PQCSettings::getInterfaceStatusInfoPosition() {
    return m_interfaceStatusInfoPosition;
}

void PQCSettings::setInterfaceStatusInfoPosition(QString val) {
    if(val != m_interfaceStatusInfoPosition) {
        m_interfaceStatusInfoPosition = val;
        Q_EMIT interfaceStatusInfoPositionChanged();
    }
}

const QString PQCSettings::getDefaultForInterfaceStatusInfoPosition() {
        return "left";
}

void PQCSettings::setDefaultForInterfaceStatusInfoPosition() {
    if("left" != m_interfaceStatusInfoPosition) {
        m_interfaceStatusInfoPosition = "left";
        Q_EMIT interfaceStatusInfoPositionChanged();
    }
}

bool PQCSettings::getInterfaceStatusInfoShow() {
    return m_interfaceStatusInfoShow;
}

void PQCSettings::setInterfaceStatusInfoShow(bool val) {
    if(val != m_interfaceStatusInfoShow) {
        m_interfaceStatusInfoShow = val;
        Q_EMIT interfaceStatusInfoShowChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceStatusInfoShow() {
        return true;
}

void PQCSettings::setDefaultForInterfaceStatusInfoShow() {
    if(true != m_interfaceStatusInfoShow) {
        m_interfaceStatusInfoShow = true;
        Q_EMIT interfaceStatusInfoShowChanged();
    }
}

bool PQCSettings::getInterfaceStatusInfoShowImageChange() {
    return m_interfaceStatusInfoShowImageChange;
}

void PQCSettings::setInterfaceStatusInfoShowImageChange(bool val) {
    if(val != m_interfaceStatusInfoShowImageChange) {
        m_interfaceStatusInfoShowImageChange = val;
        Q_EMIT interfaceStatusInfoShowImageChangeChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceStatusInfoShowImageChange() {
        return true;
}

void PQCSettings::setDefaultForInterfaceStatusInfoShowImageChange() {
    if(true != m_interfaceStatusInfoShowImageChange) {
        m_interfaceStatusInfoShowImageChange = true;
        Q_EMIT interfaceStatusInfoShowImageChangeChanged();
    }
}

int PQCSettings::getInterfaceTrayIcon() {
    return m_interfaceTrayIcon;
}

void PQCSettings::setInterfaceTrayIcon(int val) {
    if(val != m_interfaceTrayIcon) {
        m_interfaceTrayIcon = val;
        Q_EMIT interfaceTrayIconChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceTrayIcon() {
        return 0;
}

void PQCSettings::setDefaultForInterfaceTrayIcon() {
    if(0 != m_interfaceTrayIcon) {
        m_interfaceTrayIcon = 0;
    }
}

bool PQCSettings::getInterfaceTrayIconHideReset() {
    return m_interfaceTrayIconHideReset;
}

void PQCSettings::setInterfaceTrayIconHideReset(bool val) {
    if(val != m_interfaceTrayIconHideReset) {
        m_interfaceTrayIconHideReset = val;
        Q_EMIT interfaceTrayIconHideResetChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceTrayIconHideReset() {
        return false;
}

void PQCSettings::setDefaultForInterfaceTrayIconHideReset() {
    if(false != m_interfaceTrayIconHideReset) {
        m_interfaceTrayIconHideReset = false;
        Q_EMIT interfaceTrayIconHideResetChanged();
    }
}

bool PQCSettings::getInterfaceTrayIconMonochrome() {
    return m_interfaceTrayIconMonochrome;
}

void PQCSettings::setInterfaceTrayIconMonochrome(bool val) {
    if(val != m_interfaceTrayIconMonochrome) {
        m_interfaceTrayIconMonochrome = val;
        Q_EMIT interfaceTrayIconMonochromeChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceTrayIconMonochrome() {
        return true;
}

void PQCSettings::setDefaultForInterfaceTrayIconMonochrome() {
    if(true != m_interfaceTrayIconMonochrome) {
        m_interfaceTrayIconMonochrome = true;
        Q_EMIT interfaceTrayIconMonochromeChanged();
    }
}

bool PQCSettings::getInterfaceWindowButtonsAutoHide() {
    return m_interfaceWindowButtonsAutoHide;
}

void PQCSettings::setInterfaceWindowButtonsAutoHide(bool val) {
    if(val != m_interfaceWindowButtonsAutoHide) {
        m_interfaceWindowButtonsAutoHide = val;
        Q_EMIT interfaceWindowButtonsAutoHideChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceWindowButtonsAutoHide() {
        return false;
}

void PQCSettings::setDefaultForInterfaceWindowButtonsAutoHide() {
    if(false != m_interfaceWindowButtonsAutoHide) {
        m_interfaceWindowButtonsAutoHide = false;
        Q_EMIT interfaceWindowButtonsAutoHideChanged();
    }
}

int PQCSettings::getInterfaceWindowButtonsAutoHideTimeout() {
    return m_interfaceWindowButtonsAutoHideTimeout;
}

void PQCSettings::setInterfaceWindowButtonsAutoHideTimeout(int val) {
    if(val != m_interfaceWindowButtonsAutoHideTimeout) {
        m_interfaceWindowButtonsAutoHideTimeout = val;
        Q_EMIT interfaceWindowButtonsAutoHideTimeoutChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceWindowButtonsAutoHideTimeout() {
        return 1000;
}

void PQCSettings::setDefaultForInterfaceWindowButtonsAutoHideTimeout() {
    if(1000 != m_interfaceWindowButtonsAutoHideTimeout) {
        m_interfaceWindowButtonsAutoHideTimeout = 1000;
    }
}

bool PQCSettings::getInterfaceWindowButtonsAutoHideTopEdge() {
    return m_interfaceWindowButtonsAutoHideTopEdge;
}

void PQCSettings::setInterfaceWindowButtonsAutoHideTopEdge(bool val) {
    if(val != m_interfaceWindowButtonsAutoHideTopEdge) {
        m_interfaceWindowButtonsAutoHideTopEdge = val;
        Q_EMIT interfaceWindowButtonsAutoHideTopEdgeChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceWindowButtonsAutoHideTopEdge() {
        return false;
}

void PQCSettings::setDefaultForInterfaceWindowButtonsAutoHideTopEdge() {
    if(false != m_interfaceWindowButtonsAutoHideTopEdge) {
        m_interfaceWindowButtonsAutoHideTopEdge = false;
        Q_EMIT interfaceWindowButtonsAutoHideTopEdgeChanged();
    }
}

bool PQCSettings::getInterfaceWindowButtonsFollowAccentColor() {
    return m_interfaceWindowButtonsFollowAccentColor;
}

void PQCSettings::setInterfaceWindowButtonsFollowAccentColor(bool val) {
    if(val != m_interfaceWindowButtonsFollowAccentColor) {
        m_interfaceWindowButtonsFollowAccentColor = val;
        Q_EMIT interfaceWindowButtonsFollowAccentColorChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceWindowButtonsFollowAccentColor() {
        return false;
}

void PQCSettings::setDefaultForInterfaceWindowButtonsFollowAccentColor() {
    if(false != m_interfaceWindowButtonsFollowAccentColor) {
        m_interfaceWindowButtonsFollowAccentColor = false;
        Q_EMIT interfaceWindowButtonsFollowAccentColorChanged();
    }
}

QStringList PQCSettings::getInterfaceWindowButtonsItems() {
    return m_interfaceWindowButtonsItems;
}

void PQCSettings::setInterfaceWindowButtonsItems(QStringList val) {
    if(val != m_interfaceWindowButtonsItems) {
        m_interfaceWindowButtonsItems = val;
        Q_EMIT interfaceWindowButtonsItemsChanged();
    }
}

const QStringList PQCSettings::getDefaultForInterfaceWindowButtonsItems() {
        return QStringList() << "left_0|0|0" << "right_0|0|0" << "menu_0|0|0" << "ontop_0|1|1" << "fullscreen_0|0|1";
}

void PQCSettings::setDefaultForInterfaceWindowButtonsItems() {
    QStringList tmp = QStringList() << "left_0|0|0" << "right_0|0|0" << "menu_0|0|0" << "ontop_0|1|1" << "fullscreen_0|0|1";
    if(tmp != m_interfaceWindowButtonsItems) {
        m_interfaceWindowButtonsItems = tmp;
        Q_EMIT interfaceWindowButtonsItemsChanged();
    }
}

bool PQCSettings::getInterfaceWindowButtonsShow() {
    return m_interfaceWindowButtonsShow;
}

void PQCSettings::setInterfaceWindowButtonsShow(bool val) {
    if(val != m_interfaceWindowButtonsShow) {
        m_interfaceWindowButtonsShow = val;
        Q_EMIT interfaceWindowButtonsShowChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceWindowButtonsShow() {
        return true;
}

void PQCSettings::setDefaultForInterfaceWindowButtonsShow() {
    if(true != m_interfaceWindowButtonsShow) {
        m_interfaceWindowButtonsShow = true;
        Q_EMIT interfaceWindowButtonsShowChanged();
    }
}

int PQCSettings::getInterfaceWindowButtonsSize() {
    return m_interfaceWindowButtonsSize;
}

void PQCSettings::setInterfaceWindowButtonsSize(int val) {
    if(val != m_interfaceWindowButtonsSize) {
        m_interfaceWindowButtonsSize = val;
        Q_EMIT interfaceWindowButtonsSizeChanged();
    }
}

const int PQCSettings::getDefaultForInterfaceWindowButtonsSize() {
        return 10;
}

void PQCSettings::setDefaultForInterfaceWindowButtonsSize() {
    if(10 != m_interfaceWindowButtonsSize) {
        m_interfaceWindowButtonsSize = 10;
    }
}

bool PQCSettings::getInterfaceWindowDecoration() {
    return m_interfaceWindowDecoration;
}

void PQCSettings::setInterfaceWindowDecoration(bool val) {
    if(val != m_interfaceWindowDecoration) {
        m_interfaceWindowDecoration = val;
        Q_EMIT interfaceWindowDecorationChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceWindowDecoration() {
        return true;
}

void PQCSettings::setDefaultForInterfaceWindowDecoration() {
    if(true != m_interfaceWindowDecoration) {
        m_interfaceWindowDecoration = true;
        Q_EMIT interfaceWindowDecorationChanged();
    }
}

bool PQCSettings::getInterfaceWindowDecorationOnEmptyBackground() {
    return m_interfaceWindowDecorationOnEmptyBackground;
}

void PQCSettings::setInterfaceWindowDecorationOnEmptyBackground(bool val) {
    if(val != m_interfaceWindowDecorationOnEmptyBackground) {
        m_interfaceWindowDecorationOnEmptyBackground = val;
        Q_EMIT interfaceWindowDecorationOnEmptyBackgroundChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceWindowDecorationOnEmptyBackground() {
        return false;
}

void PQCSettings::setDefaultForInterfaceWindowDecorationOnEmptyBackground() {
    if(false != m_interfaceWindowDecorationOnEmptyBackground) {
        m_interfaceWindowDecorationOnEmptyBackground = false;
        Q_EMIT interfaceWindowDecorationOnEmptyBackgroundChanged();
    }
}

bool PQCSettings::getInterfaceWindowMode() {
    return m_interfaceWindowMode;
}

void PQCSettings::setInterfaceWindowMode(bool val) {
    if(val != m_interfaceWindowMode) {
        m_interfaceWindowMode = val;
        Q_EMIT interfaceWindowModeChanged();
    }
}

const bool PQCSettings::getDefaultForInterfaceWindowMode() {
        return true;
}

void PQCSettings::setDefaultForInterfaceWindowMode() {
    if(true != m_interfaceWindowMode) {
        m_interfaceWindowMode = true;
        Q_EMIT interfaceWindowModeChanged();
    }
}

bool PQCSettings::getMainmenuElementHeightDynamic() {
    return m_mainmenuElementHeightDynamic;
}

void PQCSettings::setMainmenuElementHeightDynamic(bool val) {
    if(val != m_mainmenuElementHeightDynamic) {
        m_mainmenuElementHeightDynamic = val;
        Q_EMIT mainmenuElementHeightDynamicChanged();
    }
}

const bool PQCSettings::getDefaultForMainmenuElementHeightDynamic() {
        return true;
}

void PQCSettings::setDefaultForMainmenuElementHeightDynamic() {
    if(true != m_mainmenuElementHeightDynamic) {
        m_mainmenuElementHeightDynamic = true;
        Q_EMIT mainmenuElementHeightDynamicChanged();
    }
}

QPoint PQCSettings::getMainmenuElementPosition() {
    return m_mainmenuElementPosition;
}

void PQCSettings::setMainmenuElementPosition(QPoint val) {
    if(val != m_mainmenuElementPosition) {
        m_mainmenuElementPosition = val;
        Q_EMIT mainmenuElementPositionChanged();
    }
}

const QPoint PQCSettings::getDefaultForMainmenuElementPosition() {
        return QPoint(100, 100);
}

void PQCSettings::setDefaultForMainmenuElementPosition() {
    if(QPoint(100, 100) != m_mainmenuElementPosition) {
        m_mainmenuElementPosition = QPoint(100, 100);
        Q_EMIT mainmenuElementPositionChanged();
    }
}

QSize PQCSettings::getMainmenuElementSize() {
    return m_mainmenuElementSize;
}

void PQCSettings::setMainmenuElementSize(QSize val) {
    if(val != m_mainmenuElementSize) {
        m_mainmenuElementSize = val;
        Q_EMIT mainmenuElementSizeChanged();
    }
}

const QSize PQCSettings::getDefaultForMainmenuElementSize() {
        return QSize(450, 900);
}

void PQCSettings::setDefaultForMainmenuElementSize() {
    if(QSize(450, 900) != m_mainmenuElementSize) {
        m_mainmenuElementSize = QSize(450, 900);
        Q_EMIT mainmenuElementSizeChanged();
    }
}

int PQCSettings::getMainmenuElementWidth() {
    return m_mainmenuElementWidth;
}

void PQCSettings::setMainmenuElementWidth(int val) {
    if(val != m_mainmenuElementWidth) {
        m_mainmenuElementWidth = val;
        Q_EMIT mainmenuElementWidthChanged();
    }
}

const int PQCSettings::getDefaultForMainmenuElementWidth() {
        return 450;
}

void PQCSettings::setDefaultForMainmenuElementWidth() {
    if(450 != m_mainmenuElementWidth) {
        m_mainmenuElementWidth = 450;
    }
}

bool PQCSettings::getMainmenuShowExternal() {
    return m_mainmenuShowExternal;
}

void PQCSettings::setMainmenuShowExternal(bool val) {
    if(val != m_mainmenuShowExternal) {
        m_mainmenuShowExternal = val;
        Q_EMIT mainmenuShowExternalChanged();
    }
}

const bool PQCSettings::getDefaultForMainmenuShowExternal() {
        return false;
}

void PQCSettings::setDefaultForMainmenuShowExternal() {
    if(false != m_mainmenuShowExternal) {
        m_mainmenuShowExternal = false;
        Q_EMIT mainmenuShowExternalChanged();
    }
}

QPoint PQCSettings::getMapviewCurrentPosition() {
    return m_mapviewCurrentPosition;
}

void PQCSettings::setMapviewCurrentPosition(QPoint val) {
    if(val != m_mapviewCurrentPosition) {
        m_mapviewCurrentPosition = val;
        Q_EMIT mapviewCurrentPositionChanged();
    }
}

const QPoint PQCSettings::getDefaultForMapviewCurrentPosition() {
        return QPoint(200, 200);
}

void PQCSettings::setDefaultForMapviewCurrentPosition() {
    if(QPoint(200, 200) != m_mapviewCurrentPosition) {
        m_mapviewCurrentPosition = QPoint(200, 200);
        Q_EMIT mapviewCurrentPositionChanged();
    }
}

QSize PQCSettings::getMapviewCurrentSize() {
    return m_mapviewCurrentSize;
}

void PQCSettings::setMapviewCurrentSize(QSize val) {
    if(val != m_mapviewCurrentSize) {
        m_mapviewCurrentSize = val;
        Q_EMIT mapviewCurrentSizeChanged();
    }
}

const QSize PQCSettings::getDefaultForMapviewCurrentSize() {
        return QSize(400, 300);
}

void PQCSettings::setDefaultForMapviewCurrentSize() {
    if(QSize(400, 300) != m_mapviewCurrentSize) {
        m_mapviewCurrentSize = QSize(400, 300);
        Q_EMIT mapviewCurrentSizeChanged();
    }
}

bool PQCSettings::getMapviewCurrentVisible() {
    return m_mapviewCurrentVisible;
}

void PQCSettings::setMapviewCurrentVisible(bool val) {
    if(val != m_mapviewCurrentVisible) {
        m_mapviewCurrentVisible = val;
        Q_EMIT mapviewCurrentVisibleChanged();
    }
}

const bool PQCSettings::getDefaultForMapviewCurrentVisible() {
        return false;
}

void PQCSettings::setDefaultForMapviewCurrentVisible() {
    if(false != m_mapviewCurrentVisible) {
        m_mapviewCurrentVisible = false;
        Q_EMIT mapviewCurrentVisibleChanged();
    }
}

bool PQCSettings::getMapviewExplorerThumbnailsScaleCrop() {
    return m_mapviewExplorerThumbnailsScaleCrop;
}

void PQCSettings::setMapviewExplorerThumbnailsScaleCrop(bool val) {
    if(val != m_mapviewExplorerThumbnailsScaleCrop) {
        m_mapviewExplorerThumbnailsScaleCrop = val;
        Q_EMIT mapviewExplorerThumbnailsScaleCropChanged();
    }
}

const bool PQCSettings::getDefaultForMapviewExplorerThumbnailsScaleCrop() {
        return true;
}

void PQCSettings::setDefaultForMapviewExplorerThumbnailsScaleCrop() {
    if(true != m_mapviewExplorerThumbnailsScaleCrop) {
        m_mapviewExplorerThumbnailsScaleCrop = true;
        Q_EMIT mapviewExplorerThumbnailsScaleCropChanged();
    }
}

int PQCSettings::getMapviewExplorerThumbnailsZoomLevel() {
    return m_mapviewExplorerThumbnailsZoomLevel;
}

void PQCSettings::setMapviewExplorerThumbnailsZoomLevel(int val) {
    if(val != m_mapviewExplorerThumbnailsZoomLevel) {
        m_mapviewExplorerThumbnailsZoomLevel = val;
        Q_EMIT mapviewExplorerThumbnailsZoomLevelChanged();
    }
}

const int PQCSettings::getDefaultForMapviewExplorerThumbnailsZoomLevel() {
        return 20;
}

void PQCSettings::setDefaultForMapviewExplorerThumbnailsZoomLevel() {
    if(20 != m_mapviewExplorerThumbnailsZoomLevel) {
        m_mapviewExplorerThumbnailsZoomLevel = 20;
    }
}

bool PQCSettings::getMetadataAutoRotation() {
    return m_metadataAutoRotation;
}

void PQCSettings::setMetadataAutoRotation(bool val) {
    if(val != m_metadataAutoRotation) {
        m_metadataAutoRotation = val;
        Q_EMIT metadataAutoRotationChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataAutoRotation() {
        return true;
}

void PQCSettings::setDefaultForMetadataAutoRotation() {
    if(true != m_metadataAutoRotation) {
        m_metadataAutoRotation = true;
        Q_EMIT metadataAutoRotationChanged();
    }
}

bool PQCSettings::getMetadataCopyright() {
    return m_metadataCopyright;
}

void PQCSettings::setMetadataCopyright(bool val) {
    if(val != m_metadataCopyright) {
        m_metadataCopyright = val;
        Q_EMIT metadataCopyrightChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataCopyright() {
        return false;
}

void PQCSettings::setDefaultForMetadataCopyright() {
    if(false != m_metadataCopyright) {
        m_metadataCopyright = false;
        Q_EMIT metadataCopyrightChanged();
    }
}

bool PQCSettings::getMetadataDimensions() {
    return m_metadataDimensions;
}

void PQCSettings::setMetadataDimensions(bool val) {
    if(val != m_metadataDimensions) {
        m_metadataDimensions = val;
        Q_EMIT metadataDimensionsChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataDimensions() {
        return true;
}

void PQCSettings::setDefaultForMetadataDimensions() {
    if(true != m_metadataDimensions) {
        m_metadataDimensions = true;
        Q_EMIT metadataDimensionsChanged();
    }
}

bool PQCSettings::getMetadataElementFloating() {
    return m_metadataElementFloating;
}

void PQCSettings::setMetadataElementFloating(bool val) {
    if(val != m_metadataElementFloating) {
        m_metadataElementFloating = val;
        Q_EMIT metadataElementFloatingChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataElementFloating() {
        return false;
}

void PQCSettings::setDefaultForMetadataElementFloating() {
    if(false != m_metadataElementFloating) {
        m_metadataElementFloating = false;
        Q_EMIT metadataElementFloatingChanged();
    }
}

bool PQCSettings::getMetadataElementHeightDynamic() {
    return m_metadataElementHeightDynamic;
}

void PQCSettings::setMetadataElementHeightDynamic(bool val) {
    if(val != m_metadataElementHeightDynamic) {
        m_metadataElementHeightDynamic = val;
        Q_EMIT metadataElementHeightDynamicChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataElementHeightDynamic() {
        return true;
}

void PQCSettings::setDefaultForMetadataElementHeightDynamic() {
    if(true != m_metadataElementHeightDynamic) {
        m_metadataElementHeightDynamic = true;
        Q_EMIT metadataElementHeightDynamicChanged();
    }
}

QPoint PQCSettings::getMetadataElementPosition() {
    return m_metadataElementPosition;
}

void PQCSettings::setMetadataElementPosition(QPoint val) {
    if(val != m_metadataElementPosition) {
        m_metadataElementPosition = val;
        Q_EMIT metadataElementPositionChanged();
    }
}

const QPoint PQCSettings::getDefaultForMetadataElementPosition() {
        return QPoint(100, 100);
}

void PQCSettings::setDefaultForMetadataElementPosition() {
    if(QPoint(100, 100) != m_metadataElementPosition) {
        m_metadataElementPosition = QPoint(100, 100);
        Q_EMIT metadataElementPositionChanged();
    }
}

QSize PQCSettings::getMetadataElementSize() {
    return m_metadataElementSize;
}

void PQCSettings::setMetadataElementSize(QSize val) {
    if(val != m_metadataElementSize) {
        m_metadataElementSize = val;
        Q_EMIT metadataElementSizeChanged();
    }
}

const QSize PQCSettings::getDefaultForMetadataElementSize() {
        return QSize(400, 700);
}

void PQCSettings::setDefaultForMetadataElementSize() {
    if(QSize(400, 700) != m_metadataElementSize) {
        m_metadataElementSize = QSize(400, 700);
        Q_EMIT metadataElementSizeChanged();
    }
}

bool PQCSettings::getMetadataElementVisible() {
    return m_metadataElementVisible;
}

void PQCSettings::setMetadataElementVisible(bool val) {
    if(val != m_metadataElementVisible) {
        m_metadataElementVisible = val;
        Q_EMIT metadataElementVisibleChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataElementVisible() {
        return false;
}

void PQCSettings::setDefaultForMetadataElementVisible() {
    if(false != m_metadataElementVisible) {
        m_metadataElementVisible = false;
        Q_EMIT metadataElementVisibleChanged();
    }
}

bool PQCSettings::getMetadataExposureTime() {
    return m_metadataExposureTime;
}

void PQCSettings::setMetadataExposureTime(bool val) {
    if(val != m_metadataExposureTime) {
        m_metadataExposureTime = val;
        Q_EMIT metadataExposureTimeChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataExposureTime() {
        return true;
}

void PQCSettings::setDefaultForMetadataExposureTime() {
    if(true != m_metadataExposureTime) {
        m_metadataExposureTime = true;
        Q_EMIT metadataExposureTimeChanged();
    }
}

bool PQCSettings::getMetadataFLength() {
    return m_metadataFLength;
}

void PQCSettings::setMetadataFLength(bool val) {
    if(val != m_metadataFLength) {
        m_metadataFLength = val;
        Q_EMIT metadataFLengthChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataFLength() {
        return true;
}

void PQCSettings::setDefaultForMetadataFLength() {
    if(true != m_metadataFLength) {
        m_metadataFLength = true;
        Q_EMIT metadataFLengthChanged();
    }
}

bool PQCSettings::getMetadataFNumber() {
    return m_metadataFNumber;
}

void PQCSettings::setMetadataFNumber(bool val) {
    if(val != m_metadataFNumber) {
        m_metadataFNumber = val;
        Q_EMIT metadataFNumberChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataFNumber() {
        return true;
}

void PQCSettings::setDefaultForMetadataFNumber() {
    if(true != m_metadataFNumber) {
        m_metadataFNumber = true;
        Q_EMIT metadataFNumberChanged();
    }
}

bool PQCSettings::getMetadataFaceTagsBorder() {
    return m_metadataFaceTagsBorder;
}

void PQCSettings::setMetadataFaceTagsBorder(bool val) {
    if(val != m_metadataFaceTagsBorder) {
        m_metadataFaceTagsBorder = val;
        Q_EMIT metadataFaceTagsBorderChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataFaceTagsBorder() {
        return false;
}

void PQCSettings::setDefaultForMetadataFaceTagsBorder() {
    if(false != m_metadataFaceTagsBorder) {
        m_metadataFaceTagsBorder = false;
        Q_EMIT metadataFaceTagsBorderChanged();
    }
}

QString PQCSettings::getMetadataFaceTagsBorderColor() {
    return m_metadataFaceTagsBorderColor;
}

void PQCSettings::setMetadataFaceTagsBorderColor(QString val) {
    if(val != m_metadataFaceTagsBorderColor) {
        m_metadataFaceTagsBorderColor = val;
        Q_EMIT metadataFaceTagsBorderColorChanged();
    }
}

const QString PQCSettings::getDefaultForMetadataFaceTagsBorderColor() {
        return "#44ff0000";
}

void PQCSettings::setDefaultForMetadataFaceTagsBorderColor() {
    if("#44ff0000" != m_metadataFaceTagsBorderColor) {
        m_metadataFaceTagsBorderColor = "#44ff0000";
        Q_EMIT metadataFaceTagsBorderColorChanged();
    }
}

int PQCSettings::getMetadataFaceTagsBorderWidth() {
    return m_metadataFaceTagsBorderWidth;
}

void PQCSettings::setMetadataFaceTagsBorderWidth(int val) {
    if(val != m_metadataFaceTagsBorderWidth) {
        m_metadataFaceTagsBorderWidth = val;
        Q_EMIT metadataFaceTagsBorderWidthChanged();
    }
}

const int PQCSettings::getDefaultForMetadataFaceTagsBorderWidth() {
        return 3;
}

void PQCSettings::setDefaultForMetadataFaceTagsBorderWidth() {
    if(3 != m_metadataFaceTagsBorderWidth) {
        m_metadataFaceTagsBorderWidth = 3;
    }
}

bool PQCSettings::getMetadataFaceTagsEnabled() {
    return m_metadataFaceTagsEnabled;
}

void PQCSettings::setMetadataFaceTagsEnabled(bool val) {
    if(val != m_metadataFaceTagsEnabled) {
        m_metadataFaceTagsEnabled = val;
        Q_EMIT metadataFaceTagsEnabledChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataFaceTagsEnabled() {
        return true;
}

void PQCSettings::setDefaultForMetadataFaceTagsEnabled() {
    if(true != m_metadataFaceTagsEnabled) {
        m_metadataFaceTagsEnabled = true;
        Q_EMIT metadataFaceTagsEnabledChanged();
    }
}

int PQCSettings::getMetadataFaceTagsFontSize() {
    return m_metadataFaceTagsFontSize;
}

void PQCSettings::setMetadataFaceTagsFontSize(int val) {
    if(val != m_metadataFaceTagsFontSize) {
        m_metadataFaceTagsFontSize = val;
        Q_EMIT metadataFaceTagsFontSizeChanged();
    }
}

const int PQCSettings::getDefaultForMetadataFaceTagsFontSize() {
        return 10;
}

void PQCSettings::setDefaultForMetadataFaceTagsFontSize() {
    if(10 != m_metadataFaceTagsFontSize) {
        m_metadataFaceTagsFontSize = 10;
    }
}

int PQCSettings::getMetadataFaceTagsVisibility() {
    return m_metadataFaceTagsVisibility;
}

void PQCSettings::setMetadataFaceTagsVisibility(int val) {
    if(val != m_metadataFaceTagsVisibility) {
        m_metadataFaceTagsVisibility = val;
        Q_EMIT metadataFaceTagsVisibilityChanged();
    }
}

const int PQCSettings::getDefaultForMetadataFaceTagsVisibility() {
        return 1;
}

void PQCSettings::setDefaultForMetadataFaceTagsVisibility() {
    if(1 != m_metadataFaceTagsVisibility) {
        m_metadataFaceTagsVisibility = 1;
    }
}

bool PQCSettings::getMetadataFileSize() {
    return m_metadataFileSize;
}

void PQCSettings::setMetadataFileSize(bool val) {
    if(val != m_metadataFileSize) {
        m_metadataFileSize = val;
        Q_EMIT metadataFileSizeChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataFileSize() {
        return true;
}

void PQCSettings::setDefaultForMetadataFileSize() {
    if(true != m_metadataFileSize) {
        m_metadataFileSize = true;
        Q_EMIT metadataFileSizeChanged();
    }
}

bool PQCSettings::getMetadataFileType() {
    return m_metadataFileType;
}

void PQCSettings::setMetadataFileType(bool val) {
    if(val != m_metadataFileType) {
        m_metadataFileType = val;
        Q_EMIT metadataFileTypeChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataFileType() {
        return true;
}

void PQCSettings::setDefaultForMetadataFileType() {
    if(true != m_metadataFileType) {
        m_metadataFileType = true;
        Q_EMIT metadataFileTypeChanged();
    }
}

bool PQCSettings::getMetadataFilename() {
    return m_metadataFilename;
}

void PQCSettings::setMetadataFilename(bool val) {
    if(val != m_metadataFilename) {
        m_metadataFilename = val;
        Q_EMIT metadataFilenameChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataFilename() {
        return true;
}

void PQCSettings::setDefaultForMetadataFilename() {
    if(true != m_metadataFilename) {
        m_metadataFilename = true;
        Q_EMIT metadataFilenameChanged();
    }
}

bool PQCSettings::getMetadataFlash() {
    return m_metadataFlash;
}

void PQCSettings::setMetadataFlash(bool val) {
    if(val != m_metadataFlash) {
        m_metadataFlash = val;
        Q_EMIT metadataFlashChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataFlash() {
        return true;
}

void PQCSettings::setDefaultForMetadataFlash() {
    if(true != m_metadataFlash) {
        m_metadataFlash = true;
        Q_EMIT metadataFlashChanged();
    }
}

bool PQCSettings::getMetadataGps() {
    return m_metadataGps;
}

void PQCSettings::setMetadataGps(bool val) {
    if(val != m_metadataGps) {
        m_metadataGps = val;
        Q_EMIT metadataGpsChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataGps() {
        return true;
}

void PQCSettings::setDefaultForMetadataGps() {
    if(true != m_metadataGps) {
        m_metadataGps = true;
        Q_EMIT metadataGpsChanged();
    }
}

QString PQCSettings::getMetadataGpsMap() {
    return m_metadataGpsMap;
}

void PQCSettings::setMetadataGpsMap(QString val) {
    if(val != m_metadataGpsMap) {
        m_metadataGpsMap = val;
        Q_EMIT metadataGpsMapChanged();
    }
}

const QString PQCSettings::getDefaultForMetadataGpsMap() {
        return "openstreetmap.org";
}

void PQCSettings::setDefaultForMetadataGpsMap() {
    if("openstreetmap.org" != m_metadataGpsMap) {
        m_metadataGpsMap = "openstreetmap.org";
        Q_EMIT metadataGpsMapChanged();
    }
}

bool PQCSettings::getMetadataImageNumber() {
    return m_metadataImageNumber;
}

void PQCSettings::setMetadataImageNumber(bool val) {
    if(val != m_metadataImageNumber) {
        m_metadataImageNumber = val;
        Q_EMIT metadataImageNumberChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataImageNumber() {
        return true;
}

void PQCSettings::setDefaultForMetadataImageNumber() {
    if(true != m_metadataImageNumber) {
        m_metadataImageNumber = true;
        Q_EMIT metadataImageNumberChanged();
    }
}

bool PQCSettings::getMetadataIso() {
    return m_metadataIso;
}

void PQCSettings::setMetadataIso(bool val) {
    if(val != m_metadataIso) {
        m_metadataIso = val;
        Q_EMIT metadataIsoChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataIso() {
        return true;
}

void PQCSettings::setDefaultForMetadataIso() {
    if(true != m_metadataIso) {
        m_metadataIso = true;
        Q_EMIT metadataIsoChanged();
    }
}

bool PQCSettings::getMetadataKeywords() {
    return m_metadataKeywords;
}

void PQCSettings::setMetadataKeywords(bool val) {
    if(val != m_metadataKeywords) {
        m_metadataKeywords = val;
        Q_EMIT metadataKeywordsChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataKeywords() {
        return false;
}

void PQCSettings::setDefaultForMetadataKeywords() {
    if(false != m_metadataKeywords) {
        m_metadataKeywords = false;
        Q_EMIT metadataKeywordsChanged();
    }
}

bool PQCSettings::getMetadataLightSource() {
    return m_metadataLightSource;
}

void PQCSettings::setMetadataLightSource(bool val) {
    if(val != m_metadataLightSource) {
        m_metadataLightSource = val;
        Q_EMIT metadataLightSourceChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataLightSource() {
        return false;
}

void PQCSettings::setDefaultForMetadataLightSource() {
    if(false != m_metadataLightSource) {
        m_metadataLightSource = false;
        Q_EMIT metadataLightSourceChanged();
    }
}

bool PQCSettings::getMetadataLocation() {
    return m_metadataLocation;
}

void PQCSettings::setMetadataLocation(bool val) {
    if(val != m_metadataLocation) {
        m_metadataLocation = val;
        Q_EMIT metadataLocationChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataLocation() {
        return false;
}

void PQCSettings::setDefaultForMetadataLocation() {
    if(false != m_metadataLocation) {
        m_metadataLocation = false;
        Q_EMIT metadataLocationChanged();
    }
}

bool PQCSettings::getMetadataMake() {
    return m_metadataMake;
}

void PQCSettings::setMetadataMake(bool val) {
    if(val != m_metadataMake) {
        m_metadataMake = val;
        Q_EMIT metadataMakeChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataMake() {
        return true;
}

void PQCSettings::setDefaultForMetadataMake() {
    if(true != m_metadataMake) {
        m_metadataMake = true;
        Q_EMIT metadataMakeChanged();
    }
}

bool PQCSettings::getMetadataModel() {
    return m_metadataModel;
}

void PQCSettings::setMetadataModel(bool val) {
    if(val != m_metadataModel) {
        m_metadataModel = val;
        Q_EMIT metadataModelChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataModel() {
        return true;
}

void PQCSettings::setDefaultForMetadataModel() {
    if(true != m_metadataModel) {
        m_metadataModel = true;
        Q_EMIT metadataModelChanged();
    }
}

bool PQCSettings::getMetadataSceneType() {
    return m_metadataSceneType;
}

void PQCSettings::setMetadataSceneType(bool val) {
    if(val != m_metadataSceneType) {
        m_metadataSceneType = val;
        Q_EMIT metadataSceneTypeChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataSceneType() {
        return true;
}

void PQCSettings::setDefaultForMetadataSceneType() {
    if(true != m_metadataSceneType) {
        m_metadataSceneType = true;
        Q_EMIT metadataSceneTypeChanged();
    }
}

bool PQCSettings::getMetadataSideBar() {
    return m_metadataSideBar;
}

void PQCSettings::setMetadataSideBar(bool val) {
    if(val != m_metadataSideBar) {
        m_metadataSideBar = val;
        Q_EMIT metadataSideBarChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataSideBar() {
        return true;
}

void PQCSettings::setDefaultForMetadataSideBar() {
    if(true != m_metadataSideBar) {
        m_metadataSideBar = true;
        Q_EMIT metadataSideBarChanged();
    }
}

QString PQCSettings::getMetadataSideBarLocation() {
    return m_metadataSideBarLocation;
}

void PQCSettings::setMetadataSideBarLocation(QString val) {
    if(val != m_metadataSideBarLocation) {
        m_metadataSideBarLocation = val;
        Q_EMIT metadataSideBarLocationChanged();
    }
}

const QString PQCSettings::getDefaultForMetadataSideBarLocation() {
        return "right";
}

void PQCSettings::setDefaultForMetadataSideBarLocation() {
    if("right" != m_metadataSideBarLocation) {
        m_metadataSideBarLocation = "right";
        Q_EMIT metadataSideBarLocationChanged();
    }
}

int PQCSettings::getMetadataSideBarWidth() {
    return m_metadataSideBarWidth;
}

void PQCSettings::setMetadataSideBarWidth(int val) {
    if(val != m_metadataSideBarWidth) {
        m_metadataSideBarWidth = val;
        Q_EMIT metadataSideBarWidthChanged();
    }
}

const int PQCSettings::getDefaultForMetadataSideBarWidth() {
        return 300;
}

void PQCSettings::setDefaultForMetadataSideBarWidth() {
    if(300 != m_metadataSideBarWidth) {
        m_metadataSideBarWidth = 300;
    }
}

bool PQCSettings::getMetadataSoftware() {
    return m_metadataSoftware;
}

void PQCSettings::setMetadataSoftware(bool val) {
    if(val != m_metadataSoftware) {
        m_metadataSoftware = val;
        Q_EMIT metadataSoftwareChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataSoftware() {
        return true;
}

void PQCSettings::setDefaultForMetadataSoftware() {
    if(true != m_metadataSoftware) {
        m_metadataSoftware = true;
        Q_EMIT metadataSoftwareChanged();
    }
}

bool PQCSettings::getMetadataTime() {
    return m_metadataTime;
}

void PQCSettings::setMetadataTime(bool val) {
    if(val != m_metadataTime) {
        m_metadataTime = val;
        Q_EMIT metadataTimeChanged();
    }
}

const bool PQCSettings::getDefaultForMetadataTime() {
        return true;
}

void PQCSettings::setDefaultForMetadataTime() {
    if(true != m_metadataTime) {
        m_metadataTime = true;
        Q_EMIT metadataTimeChanged();
    }
}

bool PQCSettings::getSlideshowHideLabels() {
    return m_slideshowHideLabels;
}

void PQCSettings::setSlideshowHideLabels(bool val) {
    if(val != m_slideshowHideLabels) {
        m_slideshowHideLabels = val;
        Q_EMIT slideshowHideLabelsChanged();
    }
}

const bool PQCSettings::getDefaultForSlideshowHideLabels() {
        return true;
}

void PQCSettings::setDefaultForSlideshowHideLabels() {
    if(true != m_slideshowHideLabels) {
        m_slideshowHideLabels = true;
        Q_EMIT slideshowHideLabelsChanged();
    }
}

bool PQCSettings::getSlideshowHideWindowButtons() {
    return m_slideshowHideWindowButtons;
}

void PQCSettings::setSlideshowHideWindowButtons(bool val) {
    if(val != m_slideshowHideWindowButtons) {
        m_slideshowHideWindowButtons = val;
        Q_EMIT slideshowHideWindowButtonsChanged();
    }
}

const bool PQCSettings::getDefaultForSlideshowHideWindowButtons() {
        return false;
}

void PQCSettings::setDefaultForSlideshowHideWindowButtons() {
    if(false != m_slideshowHideWindowButtons) {
        m_slideshowHideWindowButtons = false;
        Q_EMIT slideshowHideWindowButtonsChanged();
    }
}

int PQCSettings::getSlideshowImageTransition() {
    return m_slideshowImageTransition;
}

void PQCSettings::setSlideshowImageTransition(int val) {
    if(val != m_slideshowImageTransition) {
        m_slideshowImageTransition = val;
        Q_EMIT slideshowImageTransitionChanged();
    }
}

const int PQCSettings::getDefaultForSlideshowImageTransition() {
        return 4;
}

void PQCSettings::setDefaultForSlideshowImageTransition() {
    if(4 != m_slideshowImageTransition) {
        m_slideshowImageTransition = 4;
    }
}

bool PQCSettings::getSlideshowIncludeSubFolders() {
    return m_slideshowIncludeSubFolders;
}

void PQCSettings::setSlideshowIncludeSubFolders(bool val) {
    if(val != m_slideshowIncludeSubFolders) {
        m_slideshowIncludeSubFolders = val;
        Q_EMIT slideshowIncludeSubFoldersChanged();
    }
}

const bool PQCSettings::getDefaultForSlideshowIncludeSubFolders() {
        return false;
}

void PQCSettings::setDefaultForSlideshowIncludeSubFolders() {
    if(false != m_slideshowIncludeSubFolders) {
        m_slideshowIncludeSubFolders = false;
        Q_EMIT slideshowIncludeSubFoldersChanged();
    }
}

bool PQCSettings::getSlideshowLoop() {
    return m_slideshowLoop;
}

void PQCSettings::setSlideshowLoop(bool val) {
    if(val != m_slideshowLoop) {
        m_slideshowLoop = val;
        Q_EMIT slideshowLoopChanged();
    }
}

const bool PQCSettings::getDefaultForSlideshowLoop() {
        return true;
}

void PQCSettings::setDefaultForSlideshowLoop() {
    if(true != m_slideshowLoop) {
        m_slideshowLoop = true;
        Q_EMIT slideshowLoopChanged();
    }
}

bool PQCSettings::getSlideshowMusic() {
    return m_slideshowMusic;
}

void PQCSettings::setSlideshowMusic(bool val) {
    if(val != m_slideshowMusic) {
        m_slideshowMusic = val;
        Q_EMIT slideshowMusicChanged();
    }
}

const bool PQCSettings::getDefaultForSlideshowMusic() {
        return false;
}

void PQCSettings::setDefaultForSlideshowMusic() {
    if(false != m_slideshowMusic) {
        m_slideshowMusic = false;
        Q_EMIT slideshowMusicChanged();
    }
}

QString PQCSettings::getSlideshowMusicFile() {
    return m_slideshowMusicFile;
}

void PQCSettings::setSlideshowMusicFile(QString val) {
    if(val != m_slideshowMusicFile) {
        m_slideshowMusicFile = val;
        Q_EMIT slideshowMusicFileChanged();
    }
}

const QString PQCSettings::getDefaultForSlideshowMusicFile() {
        return "";
}

void PQCSettings::setDefaultForSlideshowMusicFile() {
    if("" != m_slideshowMusicFile) {
        m_slideshowMusicFile = "";
        Q_EMIT slideshowMusicFileChanged();
    }
}

QStringList PQCSettings::getSlideshowMusicFiles() {
    return m_slideshowMusicFiles;
}

void PQCSettings::setSlideshowMusicFiles(QStringList val) {
    if(val != m_slideshowMusicFiles) {
        m_slideshowMusicFiles = val;
        Q_EMIT slideshowMusicFilesChanged();
    }
}

const QStringList PQCSettings::getDefaultForSlideshowMusicFiles() {
        return QStringList() << "";
}

void PQCSettings::setDefaultForSlideshowMusicFiles() {
    QStringList tmp = QStringList() << "";
    if(tmp != m_slideshowMusicFiles) {
        m_slideshowMusicFiles = tmp;
        Q_EMIT slideshowMusicFilesChanged();
    }
}

bool PQCSettings::getSlideshowMusicShuffle() {
    return m_slideshowMusicShuffle;
}

void PQCSettings::setSlideshowMusicShuffle(bool val) {
    if(val != m_slideshowMusicShuffle) {
        m_slideshowMusicShuffle = val;
        Q_EMIT slideshowMusicShuffleChanged();
    }
}

const bool PQCSettings::getDefaultForSlideshowMusicShuffle() {
        return false;
}

void PQCSettings::setDefaultForSlideshowMusicShuffle() {
    if(false != m_slideshowMusicShuffle) {
        m_slideshowMusicShuffle = false;
        Q_EMIT slideshowMusicShuffleChanged();
    }
}

int PQCSettings::getSlideshowMusicVolumeVideos() {
    return m_slideshowMusicVolumeVideos;
}

void PQCSettings::setSlideshowMusicVolumeVideos(int val) {
    if(val != m_slideshowMusicVolumeVideos) {
        m_slideshowMusicVolumeVideos = val;
        Q_EMIT slideshowMusicVolumeVideosChanged();
    }
}

const int PQCSettings::getDefaultForSlideshowMusicVolumeVideos() {
        return 1;
}

void PQCSettings::setDefaultForSlideshowMusicVolumeVideos() {
    if(1 != m_slideshowMusicVolumeVideos) {
        m_slideshowMusicVolumeVideos = 1;
    }
}

bool PQCSettings::getSlideshowShuffle() {
    return m_slideshowShuffle;
}

void PQCSettings::setSlideshowShuffle(bool val) {
    if(val != m_slideshowShuffle) {
        m_slideshowShuffle = val;
        Q_EMIT slideshowShuffleChanged();
    }
}

const bool PQCSettings::getDefaultForSlideshowShuffle() {
        return false;
}

void PQCSettings::setDefaultForSlideshowShuffle() {
    if(false != m_slideshowShuffle) {
        m_slideshowShuffle = false;
        Q_EMIT slideshowShuffleChanged();
    }
}

int PQCSettings::getSlideshowTime() {
    return m_slideshowTime;
}

void PQCSettings::setSlideshowTime(int val) {
    if(val != m_slideshowTime) {
        m_slideshowTime = val;
        Q_EMIT slideshowTimeChanged();
    }
}

const int PQCSettings::getDefaultForSlideshowTime() {
        return 5;
}

void PQCSettings::setDefaultForSlideshowTime() {
    if(5 != m_slideshowTime) {
        m_slideshowTime = 5;
    }
}

QString PQCSettings::getSlideshowTypeAnimation() {
    return m_slideshowTypeAnimation;
}

void PQCSettings::setSlideshowTypeAnimation(QString val) {
    if(val != m_slideshowTypeAnimation) {
        m_slideshowTypeAnimation = val;
        Q_EMIT slideshowTypeAnimationChanged();
    }
}

const QString PQCSettings::getDefaultForSlideshowTypeAnimation() {
        return "opacity";
}

void PQCSettings::setDefaultForSlideshowTypeAnimation() {
    if("opacity" != m_slideshowTypeAnimation) {
        m_slideshowTypeAnimation = "opacity";
        Q_EMIT slideshowTypeAnimationChanged();
    }
}

bool PQCSettings::getThumbnailsCache() {
    return m_thumbnailsCache;
}

void PQCSettings::setThumbnailsCache(bool val) {
    if(val != m_thumbnailsCache) {
        m_thumbnailsCache = val;
        Q_EMIT thumbnailsCacheChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsCache() {
        return true;
}

void PQCSettings::setDefaultForThumbnailsCache() {
    if(true != m_thumbnailsCache) {
        m_thumbnailsCache = true;
        Q_EMIT thumbnailsCacheChanged();
    }
}

bool PQCSettings::getThumbnailsCacheBaseDirDefault() {
    return m_thumbnailsCacheBaseDirDefault;
}

void PQCSettings::setThumbnailsCacheBaseDirDefault(bool val) {
    if(val != m_thumbnailsCacheBaseDirDefault) {
        m_thumbnailsCacheBaseDirDefault = val;
        Q_EMIT thumbnailsCacheBaseDirDefaultChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsCacheBaseDirDefault() {
        return true;
}

void PQCSettings::setDefaultForThumbnailsCacheBaseDirDefault() {
    if(true != m_thumbnailsCacheBaseDirDefault) {
        m_thumbnailsCacheBaseDirDefault = true;
        Q_EMIT thumbnailsCacheBaseDirDefaultChanged();
    }
}

QString PQCSettings::getThumbnailsCacheBaseDirLocation() {
    return m_thumbnailsCacheBaseDirLocation;
}

void PQCSettings::setThumbnailsCacheBaseDirLocation(QString val) {
    if(val != m_thumbnailsCacheBaseDirLocation) {
        m_thumbnailsCacheBaseDirLocation = val;
        Q_EMIT thumbnailsCacheBaseDirLocationChanged();
    }
}

const QString PQCSettings::getDefaultForThumbnailsCacheBaseDirLocation() {
        return "";
}

void PQCSettings::setDefaultForThumbnailsCacheBaseDirLocation() {
    if("" != m_thumbnailsCacheBaseDirLocation) {
        m_thumbnailsCacheBaseDirLocation = "";
        Q_EMIT thumbnailsCacheBaseDirLocationChanged();
    }
}

bool PQCSettings::getThumbnailsCenterOnActive() {
    return m_thumbnailsCenterOnActive;
}

void PQCSettings::setThumbnailsCenterOnActive(bool val) {
    if(val != m_thumbnailsCenterOnActive) {
        m_thumbnailsCenterOnActive = val;
        Q_EMIT thumbnailsCenterOnActiveChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsCenterOnActive() {
        return false;
}

void PQCSettings::setDefaultForThumbnailsCenterOnActive() {
    if(false != m_thumbnailsCenterOnActive) {
        m_thumbnailsCenterOnActive = false;
        Q_EMIT thumbnailsCenterOnActiveChanged();
    }
}

bool PQCSettings::getThumbnailsCropToFit() {
    return m_thumbnailsCropToFit;
}

void PQCSettings::setThumbnailsCropToFit(bool val) {
    if(val != m_thumbnailsCropToFit) {
        m_thumbnailsCropToFit = val;
        Q_EMIT thumbnailsCropToFitChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsCropToFit() {
        return true;
}

void PQCSettings::setDefaultForThumbnailsCropToFit() {
    if(true != m_thumbnailsCropToFit) {
        m_thumbnailsCropToFit = true;
        Q_EMIT thumbnailsCropToFitChanged();
    }
}

bool PQCSettings::getThumbnailsDisable() {
    return m_thumbnailsDisable;
}

void PQCSettings::setThumbnailsDisable(bool val) {
    if(val != m_thumbnailsDisable) {
        m_thumbnailsDisable = val;
        Q_EMIT thumbnailsDisableChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsDisable() {
        return false;
}

void PQCSettings::setDefaultForThumbnailsDisable() {
    if(false != m_thumbnailsDisable) {
        m_thumbnailsDisable = false;
        Q_EMIT thumbnailsDisableChanged();
    }
}

QString PQCSettings::getThumbnailsExcludeDropBox() {
    return m_thumbnailsExcludeDropBox;
}

void PQCSettings::setThumbnailsExcludeDropBox(QString val) {
    if(val != m_thumbnailsExcludeDropBox) {
        m_thumbnailsExcludeDropBox = val;
        Q_EMIT thumbnailsExcludeDropBoxChanged();
    }
}

const QString PQCSettings::getDefaultForThumbnailsExcludeDropBox() {
        return "";
}

void PQCSettings::setDefaultForThumbnailsExcludeDropBox() {
    if("" != m_thumbnailsExcludeDropBox) {
        m_thumbnailsExcludeDropBox = "";
        Q_EMIT thumbnailsExcludeDropBoxChanged();
    }
}

QStringList PQCSettings::getThumbnailsExcludeFolders() {
    return m_thumbnailsExcludeFolders;
}

void PQCSettings::setThumbnailsExcludeFolders(QStringList val) {
    if(val != m_thumbnailsExcludeFolders) {
        m_thumbnailsExcludeFolders = val;
        Q_EMIT thumbnailsExcludeFoldersChanged();
    }
}

const QStringList PQCSettings::getDefaultForThumbnailsExcludeFolders() {
        return QStringList() << "";
}

void PQCSettings::setDefaultForThumbnailsExcludeFolders() {
    QStringList tmp = QStringList() << "";
    if(tmp != m_thumbnailsExcludeFolders) {
        m_thumbnailsExcludeFolders = tmp;
        Q_EMIT thumbnailsExcludeFoldersChanged();
    }
}

bool PQCSettings::getThumbnailsExcludeNetworkShares() {
    return m_thumbnailsExcludeNetworkShares;
}

void PQCSettings::setThumbnailsExcludeNetworkShares(bool val) {
    if(val != m_thumbnailsExcludeNetworkShares) {
        m_thumbnailsExcludeNetworkShares = val;
        Q_EMIT thumbnailsExcludeNetworkSharesChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsExcludeNetworkShares() {
        return true;
}

void PQCSettings::setDefaultForThumbnailsExcludeNetworkShares() {
    if(true != m_thumbnailsExcludeNetworkShares) {
        m_thumbnailsExcludeNetworkShares = true;
        Q_EMIT thumbnailsExcludeNetworkSharesChanged();
    }
}

QString PQCSettings::getThumbnailsExcludeNextcloud() {
    return m_thumbnailsExcludeNextcloud;
}

void PQCSettings::setThumbnailsExcludeNextcloud(QString val) {
    if(val != m_thumbnailsExcludeNextcloud) {
        m_thumbnailsExcludeNextcloud = val;
        Q_EMIT thumbnailsExcludeNextcloudChanged();
    }
}

const QString PQCSettings::getDefaultForThumbnailsExcludeNextcloud() {
        return "";
}

void PQCSettings::setDefaultForThumbnailsExcludeNextcloud() {
    if("" != m_thumbnailsExcludeNextcloud) {
        m_thumbnailsExcludeNextcloud = "";
        Q_EMIT thumbnailsExcludeNextcloudChanged();
    }
}

QString PQCSettings::getThumbnailsExcludeOwnCloud() {
    return m_thumbnailsExcludeOwnCloud;
}

void PQCSettings::setThumbnailsExcludeOwnCloud(QString val) {
    if(val != m_thumbnailsExcludeOwnCloud) {
        m_thumbnailsExcludeOwnCloud = val;
        Q_EMIT thumbnailsExcludeOwnCloudChanged();
    }
}

const QString PQCSettings::getDefaultForThumbnailsExcludeOwnCloud() {
        return "";
}

void PQCSettings::setDefaultForThumbnailsExcludeOwnCloud() {
    if("" != m_thumbnailsExcludeOwnCloud) {
        m_thumbnailsExcludeOwnCloud = "";
        Q_EMIT thumbnailsExcludeOwnCloudChanged();
    }
}

bool PQCSettings::getThumbnailsFilename() {
    return m_thumbnailsFilename;
}

void PQCSettings::setThumbnailsFilename(bool val) {
    if(val != m_thumbnailsFilename) {
        m_thumbnailsFilename = val;
        Q_EMIT thumbnailsFilenameChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsFilename() {
        return true;
}

void PQCSettings::setDefaultForThumbnailsFilename() {
    if(true != m_thumbnailsFilename) {
        m_thumbnailsFilename = true;
        Q_EMIT thumbnailsFilenameChanged();
    }
}

int PQCSettings::getThumbnailsFontSize() {
    return m_thumbnailsFontSize;
}

void PQCSettings::setThumbnailsFontSize(int val) {
    if(val != m_thumbnailsFontSize) {
        m_thumbnailsFontSize = val;
        Q_EMIT thumbnailsFontSizeChanged();
    }
}

const int PQCSettings::getDefaultForThumbnailsFontSize() {
        return 7;
}

void PQCSettings::setDefaultForThumbnailsFontSize() {
    if(7 != m_thumbnailsFontSize) {
        m_thumbnailsFontSize = 7;
    }
}

QStringList PQCSettings::getThumbnailsHighlightAnimation() {
    return m_thumbnailsHighlightAnimation;
}

void PQCSettings::setThumbnailsHighlightAnimation(QStringList val) {
    if(val != m_thumbnailsHighlightAnimation) {
        m_thumbnailsHighlightAnimation = val;
        Q_EMIT thumbnailsHighlightAnimationChanged();
    }
}

const QStringList PQCSettings::getDefaultForThumbnailsHighlightAnimation() {
        return QStringList() << "liftup";
}

void PQCSettings::setDefaultForThumbnailsHighlightAnimation() {
    QStringList tmp = QStringList() << "liftup";
    if(tmp != m_thumbnailsHighlightAnimation) {
        m_thumbnailsHighlightAnimation = tmp;
        Q_EMIT thumbnailsHighlightAnimationChanged();
    }
}

int PQCSettings::getThumbnailsHighlightAnimationLiftUp() {
    return m_thumbnailsHighlightAnimationLiftUp;
}

void PQCSettings::setThumbnailsHighlightAnimationLiftUp(int val) {
    if(val != m_thumbnailsHighlightAnimationLiftUp) {
        m_thumbnailsHighlightAnimationLiftUp = val;
        Q_EMIT thumbnailsHighlightAnimationLiftUpChanged();
    }
}

const int PQCSettings::getDefaultForThumbnailsHighlightAnimationLiftUp() {
        return 15;
}

void PQCSettings::setDefaultForThumbnailsHighlightAnimationLiftUp() {
    if(15 != m_thumbnailsHighlightAnimationLiftUp) {
        m_thumbnailsHighlightAnimationLiftUp = 15;
    }
}

bool PQCSettings::getThumbnailsIconsOnly() {
    return m_thumbnailsIconsOnly;
}

void PQCSettings::setThumbnailsIconsOnly(bool val) {
    if(val != m_thumbnailsIconsOnly) {
        m_thumbnailsIconsOnly = val;
        Q_EMIT thumbnailsIconsOnlyChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsIconsOnly() {
        return false;
}

void PQCSettings::setDefaultForThumbnailsIconsOnly() {
    if(false != m_thumbnailsIconsOnly) {
        m_thumbnailsIconsOnly = false;
        Q_EMIT thumbnailsIconsOnlyChanged();
    }
}

bool PQCSettings::getThumbnailsInactiveTransparent() {
    return m_thumbnailsInactiveTransparent;
}

void PQCSettings::setThumbnailsInactiveTransparent(bool val) {
    if(val != m_thumbnailsInactiveTransparent) {
        m_thumbnailsInactiveTransparent = val;
        Q_EMIT thumbnailsInactiveTransparentChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsInactiveTransparent() {
        return true;
}

void PQCSettings::setDefaultForThumbnailsInactiveTransparent() {
    if(true != m_thumbnailsInactiveTransparent) {
        m_thumbnailsInactiveTransparent = true;
        Q_EMIT thumbnailsInactiveTransparentChanged();
    }
}

int PQCSettings::getThumbnailsMaxNumberThreads() {
    return m_thumbnailsMaxNumberThreads;
}

void PQCSettings::setThumbnailsMaxNumberThreads(int val) {
    if(val != m_thumbnailsMaxNumberThreads) {
        m_thumbnailsMaxNumberThreads = val;
        Q_EMIT thumbnailsMaxNumberThreadsChanged();
    }
}

const int PQCSettings::getDefaultForThumbnailsMaxNumberThreads() {
        return 4;
}

void PQCSettings::setDefaultForThumbnailsMaxNumberThreads() {
    if(4 != m_thumbnailsMaxNumberThreads) {
        m_thumbnailsMaxNumberThreads = 4;
    }
}

bool PQCSettings::getThumbnailsSameHeightVaryWidth() {
    return m_thumbnailsSameHeightVaryWidth;
}

void PQCSettings::setThumbnailsSameHeightVaryWidth(bool val) {
    if(val != m_thumbnailsSameHeightVaryWidth) {
        m_thumbnailsSameHeightVaryWidth = val;
        Q_EMIT thumbnailsSameHeightVaryWidthChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsSameHeightVaryWidth() {
        return false;
}

void PQCSettings::setDefaultForThumbnailsSameHeightVaryWidth() {
    if(false != m_thumbnailsSameHeightVaryWidth) {
        m_thumbnailsSameHeightVaryWidth = false;
        Q_EMIT thumbnailsSameHeightVaryWidthChanged();
    }
}

int PQCSettings::getThumbnailsSize() {
    return m_thumbnailsSize;
}

void PQCSettings::setThumbnailsSize(int val) {
    if(val != m_thumbnailsSize) {
        m_thumbnailsSize = val;
        Q_EMIT thumbnailsSizeChanged();
    }
}

const int PQCSettings::getDefaultForThumbnailsSize() {
        return 120;
}

void PQCSettings::setDefaultForThumbnailsSize() {
    if(120 != m_thumbnailsSize) {
        m_thumbnailsSize = 120;
    }
}

bool PQCSettings::getThumbnailsSmallThumbnailsKeepSmall() {
    return m_thumbnailsSmallThumbnailsKeepSmall;
}

void PQCSettings::setThumbnailsSmallThumbnailsKeepSmall(bool val) {
    if(val != m_thumbnailsSmallThumbnailsKeepSmall) {
        m_thumbnailsSmallThumbnailsKeepSmall = val;
        Q_EMIT thumbnailsSmallThumbnailsKeepSmallChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsSmallThumbnailsKeepSmall() {
        return true;
}

void PQCSettings::setDefaultForThumbnailsSmallThumbnailsKeepSmall() {
    if(true != m_thumbnailsSmallThumbnailsKeepSmall) {
        m_thumbnailsSmallThumbnailsKeepSmall = true;
        Q_EMIT thumbnailsSmallThumbnailsKeepSmallChanged();
    }
}

int PQCSettings::getThumbnailsSpacing() {
    return m_thumbnailsSpacing;
}

void PQCSettings::setThumbnailsSpacing(int val) {
    if(val != m_thumbnailsSpacing) {
        m_thumbnailsSpacing = val;
        Q_EMIT thumbnailsSpacingChanged();
    }
}

const int PQCSettings::getDefaultForThumbnailsSpacing() {
        return 2;
}

void PQCSettings::setDefaultForThumbnailsSpacing() {
    if(2 != m_thumbnailsSpacing) {
        m_thumbnailsSpacing = 2;
    }
}

bool PQCSettings::getThumbnailsTooltip() {
    return m_thumbnailsTooltip;
}

void PQCSettings::setThumbnailsTooltip(bool val) {
    if(val != m_thumbnailsTooltip) {
        m_thumbnailsTooltip = val;
        Q_EMIT thumbnailsTooltipChanged();
    }
}

const bool PQCSettings::getDefaultForThumbnailsTooltip() {
        return true;
}

void PQCSettings::setDefaultForThumbnailsTooltip() {
    if(true != m_thumbnailsTooltip) {
        m_thumbnailsTooltip = true;
        Q_EMIT thumbnailsTooltipChanged();
    }
}

int PQCSettings::getThumbnailsVisibility() {
    return m_thumbnailsVisibility;
}

void PQCSettings::setThumbnailsVisibility(int val) {
    if(val != m_thumbnailsVisibility) {
        m_thumbnailsVisibility = val;
        Q_EMIT thumbnailsVisibilityChanged();
    }
}

const int PQCSettings::getDefaultForThumbnailsVisibility() {
        return 0;
}

void PQCSettings::setDefaultForThumbnailsVisibility() {
    if(0 != m_thumbnailsVisibility) {
        m_thumbnailsVisibility = 0;
    }
}

void PQCSettings::readDB() {

    qDebug() << "";

    QSqlDatabase db = QSqlDatabase::database("settings");

    if(!db.isOpen()) return;

    for(const auto &table : std::as_const(dbtables)) {

        QSqlQuery query(db);
        query.prepare(QString("SELECT `name`,`value` FROM '%1'").arg(table));
        if(!query.exec())
            qCritical() << QString("SQL Query error (%1):").arg(table) << query.lastError().text();

        while(query.next()) {

            QString name = query.value(0).toString();
            QVariant value = query.value(1).toString();
        
            // table: filedialog
            if(table == "filedialog") {
                if(name == "DetailsTooltip") {
                    m_filedialogDetailsTooltip = value.toInt();
                } else if(name == "Devices") {
                    m_filedialogDevices = value.toInt();
                } else if(name == "DevicesShowTmpfs") {
                    m_filedialogDevicesShowTmpfs = value.toInt();
                } else if(name == "DragDropFileviewGrid") {
                    m_filedialogDragDropFileviewGrid = value.toInt();
                } else if(name == "DragDropFileviewList") {
                    m_filedialogDragDropFileviewList = value.toInt();
                } else if(name == "DragDropFileviewMasonry") {
                    m_filedialogDragDropFileviewMasonry = value.toInt();
                } else if(name == "DragDropPlaces") {
                    m_filedialogDragDropPlaces = value.toInt();
                } else if(name == "ElementPadding") {
                    m_filedialogElementPadding = value.toInt();
                } else if(name == "FolderContentThumbnails") {
                    m_filedialogFolderContentThumbnails = value.toInt();
                } else if(name == "FolderContentThumbnailsAutoload") {
                    m_filedialogFolderContentThumbnailsAutoload = value.toInt();
                } else if(name == "FolderContentThumbnailsLoop") {
                    m_filedialogFolderContentThumbnailsLoop = value.toInt();
                } else if(name == "FolderContentThumbnailsScaleCrop") {
                    m_filedialogFolderContentThumbnailsScaleCrop = value.toInt();
                } else if(name == "FolderContentThumbnailsSortAscending") {
                    m_filedialogFolderContentThumbnailsSortAscending = value.toInt();
                } else if(name == "FolderContentThumbnailsSortBy") {
                    m_filedialogFolderContentThumbnailsSortBy = value.toString();
                } else if(name == "FolderContentThumbnailsSpeed") {
                    m_filedialogFolderContentThumbnailsSpeed = value.toInt();
                } else if(name == "LabelsShowGrid") {
                    m_filedialogLabelsShowGrid = value.toInt();
                } else if(name == "LabelsShowMasonry") {
                    m_filedialogLabelsShowMasonry = value.toInt();
                } else if(name == "Layout") {
                    m_filedialogLayout = value.toString();
                } else if(name == "Places") {
                    m_filedialogPlaces = value.toInt();
                } else if(name == "PlacesWidth") {
                    m_filedialogPlacesWidth = value.toInt();
                } else if(name == "Preview") {
                    m_filedialogPreview = value.toInt();
                } else if(name == "PreviewBlur") {
                    m_filedialogPreviewBlur = value.toInt();
                } else if(name == "PreviewColorIntensity") {
                    m_filedialogPreviewColorIntensity = value.toInt();
                } else if(name == "PreviewCropToFit") {
                    m_filedialogPreviewCropToFit = value.toInt();
                } else if(name == "PreviewHigherResolution") {
                    m_filedialogPreviewHigherResolution = value.toInt();
                } else if(name == "PreviewMuted") {
                    m_filedialogPreviewMuted = value.toInt();
                } else if(name == "RememberSelection") {
                    m_filedialogRememberSelection = value.toInt();
                } else if(name == "ShowHiddenFilesFolders") {
                    m_filedialogShowHiddenFilesFolders = value.toInt();
                } else if(name == "SingleClickSelect") {
                    m_filedialogSingleClickSelect = value.toInt();
                } else if(name == "StartupRestoreCustom") {
                    m_filedialogStartupRestoreCustom = value.toInt();
                } else if(name == "StartupRestoreCustomFolder") {
                    m_filedialogStartupRestoreCustomFolder = value.toString();
                } else if(name == "StartupRestoreHome") {
                    m_filedialogStartupRestoreHome = value.toInt();
                } else if(name == "StartupRestorePrevious") {
                    m_filedialogStartupRestorePrevious = value.toInt();
                } else if(name == "Thumbnails") {
                    m_filedialogThumbnails = value.toInt();
                } else if(name == "ThumbnailsScaleCrop") {
                    m_filedialogThumbnailsScaleCrop = value.toInt();
                } else if(name == "UseNativeFileDialog") {
                    m_filedialogUseNativeFileDialog = value.toInt();
                } else if(name == "Zoom") {
                    m_filedialogZoom = value.toInt();
                }
            // table: filetypes
            } else if(table == "filetypes") {
                if(name == "AnimatedControls") {
                    m_filetypesAnimatedControls = value.toInt();
                } else if(name == "AnimatedLeftRight") {
                    m_filetypesAnimatedLeftRight = value.toInt();
                } else if(name == "AnimatedSpacePause") {
                    m_filetypesAnimatedSpacePause = value.toInt();
                } else if(name == "ArchiveAlwaysEnterAutomatically") {
                    m_filetypesArchiveAlwaysEnterAutomatically = value.toInt();
                } else if(name == "ArchiveControls") {
                    m_filetypesArchiveControls = value.toInt();
                } else if(name == "ArchiveDontLoadMoreFilesThan") {
                    m_filetypesArchiveDontLoadMoreFilesThan = value.toInt();
                } else if(name == "ArchiveDontLoadMoreFilesThanCount") {
                    m_filetypesArchiveDontLoadMoreFilesThanCount = value.toInt();
                } else if(name == "ArchiveIgnoreLargerThan") {
                    m_filetypesArchiveIgnoreLargerThan = value.toInt();
                } else if(name == "ArchiveIgnoreLargerThanSize") {
                    m_filetypesArchiveIgnoreLargerThanSize = value.toInt();
                } else if(name == "ArchiveLeftRight") {
                    m_filetypesArchiveLeftRight = value.toInt();
                } else if(name == "ArchiveViewerModeExitButton") {
                    m_filetypesArchiveViewerModeExitButton = value.toInt();
                } else if(name == "ComicBookAlwaysEnterAutomatically") {
                    m_filetypesComicBookAlwaysEnterAutomatically = value.toInt();
                } else if(name == "DocumentAlwaysEnterAutomatically") {
                    m_filetypesDocumentAlwaysEnterAutomatically = value.toInt();
                } else if(name == "DocumentControls") {
                    m_filetypesDocumentControls = value.toInt();
                } else if(name == "DocumentLeftRight") {
                    m_filetypesDocumentLeftRight = value.toInt();
                } else if(name == "DocumentViewerModeExitButton") {
                    m_filetypesDocumentViewerModeExitButton = value.toInt();
                } else if(name == "ExternalUnrar") {
                    m_filetypesExternalUnrar = value.toInt();
                } else if(name == "LoadAppleLivePhotos") {
                    m_filetypesLoadAppleLivePhotos = value.toInt();
                } else if(name == "LoadMotionPhotos") {
                    m_filetypesLoadMotionPhotos = value.toInt();
                } else if(name == "MotionAutoPlay") {
                    m_filetypesMotionAutoPlay = value.toInt();
                } else if(name == "MotionPhotoPlayPause") {
                    m_filetypesMotionPhotoPlayPause = value.toInt();
                } else if(name == "MotionSpacePause") {
                    m_filetypesMotionSpacePause = value.toInt();
                } else if(name == "PDFQuality") {
                    m_filetypesPDFQuality = value.toInt();
                } else if(name == "PhotoSphereArrowKeys") {
                    m_filetypesPhotoSphereArrowKeys = value.toInt();
                } else if(name == "PhotoSphereAutoLoad") {
                    m_filetypesPhotoSphereAutoLoad = value.toInt();
                } else if(name == "PhotoSphereBigButton") {
                    m_filetypesPhotoSphereBigButton = value.toInt();
                } else if(name == "PhotoSphereControls") {
                    m_filetypesPhotoSphereControls = value.toInt();
                } else if(name == "PhotoSpherePanOnLoad") {
                    m_filetypesPhotoSpherePanOnLoad = value.toInt();
                } else if(name == "RAWUseEmbeddedIfAvailable") {
                    m_filetypesRAWUseEmbeddedIfAvailable = value.toInt();
                } else if(name == "VideoAutoplay") {
                    m_filetypesVideoAutoplay = value.toInt();
                } else if(name == "VideoLeftRightJumpVideo") {
                    m_filetypesVideoLeftRightJumpVideo = value.toInt();
                } else if(name == "VideoLoop") {
                    m_filetypesVideoLoop = value.toInt();
                } else if(name == "VideoPreferLibmpv") {
                    m_filetypesVideoPreferLibmpv = value.toInt();
                } else if(name == "VideoSpacePause") {
                    m_filetypesVideoSpacePause = value.toInt();
                } else if(name == "VideoThumbnailer") {
                    m_filetypesVideoThumbnailer = value.toString();
                } else if(name == "VideoVolume") {
                    m_filetypesVideoVolume = value.toInt();
                }
            // table: general
            } else if(table == "general") {
                if(name == "AutoSaveSettings") {
                    m_generalAutoSaveSettings = value.toInt();
                } else if(name == "CompactSettings") {
                    m_generalCompactSettings = value.toInt();
                } else if(name == "DisableAllAnimations") {
                    m_generalDisableAllAnimations = value.toInt();
                } else if(name == "ExtensionsAllowUntrusted") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_generalExtensionsAllowUntrusted = val.split(":://::");
                    else if(val != "")
                        m_generalExtensionsAllowUntrusted = QStringList() << val;
                    else
                        m_generalExtensionsAllowUntrusted = QStringList();
                } else if(name == "ExtensionsEnabled") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_generalExtensionsEnabled = val.split(":://::");
                    else if(val != "")
                        m_generalExtensionsEnabled = QStringList() << val;
                    else
                        m_generalExtensionsEnabled = QStringList();
                } else if(name == "ExtensionsFloatingSetup") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_generalExtensionsFloatingSetup = val.split(":://::");
                    else if(val != "")
                        m_generalExtensionsFloatingSetup = QStringList() << val;
                    else
                        m_generalExtensionsFloatingSetup = QStringList();
                } else if(name == "InterfaceVariant") {
                    m_generalInterfaceVariant = value.toString();
                } else if(name == "Version") {
                    m_generalVersion = value.toString();
                }
            // table: imageview
            } else if(table == "imageview") {
                if(name == "AdvancedSortAscending") {
                    m_imageviewAdvancedSortAscending = value.toInt();
                } else if(name == "AdvancedSortCriteria") {
                    m_imageviewAdvancedSortCriteria = value.toString();
                } else if(name == "AdvancedSortDateCriteria") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_imageviewAdvancedSortDateCriteria = val.split(":://::");
                    else if(val != "")
                        m_imageviewAdvancedSortDateCriteria = QStringList() << val;
                    else
                        m_imageviewAdvancedSortDateCriteria = QStringList();
                } else if(name == "AdvancedSortQuality") {
                    m_imageviewAdvancedSortQuality = value.toString();
                } else if(name == "AlwaysActualSize") {
                    m_imageviewAlwaysActualSize = value.toInt();
                } else if(name == "AnimationDuration") {
                    m_imageviewAnimationDuration = value.toInt();
                } else if(name == "AnimationType") {
                    m_imageviewAnimationType = value.toString();
                } else if(name == "Cache") {
                    m_imageviewCache = value.toInt();
                } else if(name == "ColorSpaceContextMenu") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_imageviewColorSpaceContextMenu = val.split(":://::");
                    else if(val != "")
                        m_imageviewColorSpaceContextMenu = QStringList() << val;
                    else
                        m_imageviewColorSpaceContextMenu = QStringList();
                } else if(name == "ColorSpaceDefault") {
                    m_imageviewColorSpaceDefault = value.toString();
                } else if(name == "ColorSpaceEnable") {
                    m_imageviewColorSpaceEnable = value.toInt();
                } else if(name == "ColorSpaceLoadEmbedded") {
                    m_imageviewColorSpaceLoadEmbedded = value.toInt();
                } else if(name == "EscapeExitArchive") {
                    m_imageviewEscapeExitArchive = value.toInt();
                } else if(name == "EscapeExitBarcodes") {
                    m_imageviewEscapeExitBarcodes = value.toInt();
                } else if(name == "EscapeExitDocument") {
                    m_imageviewEscapeExitDocument = value.toInt();
                } else if(name == "EscapeExitFilter") {
                    m_imageviewEscapeExitFilter = value.toInt();
                } else if(name == "EscapeExitSphere") {
                    m_imageviewEscapeExitSphere = value.toInt();
                } else if(name == "FitInWindow") {
                    m_imageviewFitInWindow = value.toInt();
                } else if(name == "HideCursorTimeout") {
                    m_imageviewHideCursorTimeout = value.toInt();
                } else if(name == "InterpolationDisableForSmallImages") {
                    m_imageviewInterpolationDisableForSmallImages = value.toInt();
                } else if(name == "LoopThroughFolder") {
                    m_imageviewLoopThroughFolder = value.toInt();
                } else if(name == "Margin") {
                    m_imageviewMargin = value.toInt();
                } else if(name == "MinimapSizeLevel") {
                    m_imageviewMinimapSizeLevel = value.toInt();
                } else if(name == "MirrorAnimate") {
                    m_imageviewMirrorAnimate = value.toInt();
                } else if(name == "MouseWheelRepeatDelay") {
                    m_imageviewMouseWheelRepeatDelay = value.toInt();
                } else if(name == "PreloadInBackground") {
                    m_imageviewPreloadInBackground = value.toInt();
                } else if(name == "PreserveMirror") {
                    m_imageviewPreserveMirror = value.toInt();
                } else if(name == "PreserveRotation") {
                    m_imageviewPreserveRotation = value.toInt();
                } else if(name == "PreserveZoom") {
                    m_imageviewPreserveZoom = value.toInt();
                } else if(name == "RememberZoomRotationMirror") {
                    m_imageviewRememberZoomRotationMirror = value.toInt();
                } else if(name == "ResetViewAutoHideTimeout") {
                    m_imageviewResetViewAutoHideTimeout = value.toInt();
                } else if(name == "ResetViewShow") {
                    m_imageviewResetViewShow = value.toInt();
                } else if(name == "RespectDevicePixelRatio") {
                    m_imageviewRespectDevicePixelRatio = value.toInt();
                } else if(name == "ShowMinimap") {
                    m_imageviewShowMinimap = value.toInt();
                } else if(name == "SiblingFileMaxIterations") {
                    m_imageviewSiblingFileMaxIterations = value.toInt();
                } else if(name == "SiblingFileMaxLevelUp") {
                    m_imageviewSiblingFileMaxLevelUp = value.toInt();
                } else if(name == "SiblingFilemaxLevelDown") {
                    m_imageviewSiblingFilemaxLevelDown = value.toInt();
                } else if(name == "SortImagesAscending") {
                    m_imageviewSortImagesAscending = value.toInt();
                } else if(name == "SortImagesBy") {
                    m_imageviewSortImagesBy = value.toString();
                } else if(name == "TransparencyMarker") {
                    m_imageviewTransparencyMarker = value.toInt();
                } else if(name == "UseMouseLeftButtonForImageMove") {
                    m_imageviewUseMouseLeftButtonForImageMove = value.toInt();
                } else if(name == "UseMouseWheelForImageMove") {
                    m_imageviewUseMouseWheelForImageMove = value.toInt();
                } else if(name == "ZoomMax") {
                    m_imageviewZoomMax = value.toInt();
                } else if(name == "ZoomMaxEnabled") {
                    m_imageviewZoomMaxEnabled = value.toInt();
                } else if(name == "ZoomMin") {
                    m_imageviewZoomMin = value.toInt();
                } else if(name == "ZoomMinEnabled") {
                    m_imageviewZoomMinEnabled = value.toInt();
                } else if(name == "ZoomSpeed") {
                    m_imageviewZoomSpeed = value.toInt();
                } else if(name == "ZoomSpeedRelative") {
                    m_imageviewZoomSpeedRelative = value.toInt();
                } else if(name == "ZoomToCenter") {
                    m_imageviewZoomToCenter = value.toInt();
                }
            // table: interface
            } else if(table == "interface") {
                if(name == "AccentColor") {
                    m_interfaceAccentColor = value.toString();
                } else if(name == "AllowMultipleInstances") {
                    m_interfaceAllowMultipleInstances = value.toInt();
                } else if(name == "BackgroundCustomOverlay") {
                    m_interfaceBackgroundCustomOverlay = value.toInt();
                } else if(name == "BackgroundCustomOverlayColor") {
                    m_interfaceBackgroundCustomOverlayColor = value.toString();
                } else if(name == "BackgroundFullyTransparent") {
                    m_interfaceBackgroundFullyTransparent = value.toInt();
                } else if(name == "BackgroundImageCenter") {
                    m_interfaceBackgroundImageCenter = value.toInt();
                } else if(name == "BackgroundImagePath") {
                    m_interfaceBackgroundImagePath = value.toString();
                } else if(name == "BackgroundImageScale") {
                    m_interfaceBackgroundImageScale = value.toInt();
                } else if(name == "BackgroundImageScaleCrop") {
                    m_interfaceBackgroundImageScaleCrop = value.toInt();
                } else if(name == "BackgroundImageScreenshot") {
                    m_interfaceBackgroundImageScreenshot = value.toInt();
                } else if(name == "BackgroundImageStretch") {
                    m_interfaceBackgroundImageStretch = value.toInt();
                } else if(name == "BackgroundImageTile") {
                    m_interfaceBackgroundImageTile = value.toInt();
                } else if(name == "BackgroundImageUse") {
                    m_interfaceBackgroundImageUse = value.toInt();
                } else if(name == "BackgroundSolid") {
                    m_interfaceBackgroundSolid = value.toInt();
                } else if(name == "BlurElementsInBackground") {
                    m_interfaceBlurElementsInBackground = value.toInt();
                } else if(name == "CloseOnEmptyBackground") {
                    m_interfaceCloseOnEmptyBackground = value.toInt();
                } else if(name == "DoubleClickThreshold") {
                    m_interfaceDoubleClickThreshold = value.toInt();
                } else if(name == "EdgeBottomAction") {
                    m_interfaceEdgeBottomAction = value.toString();
                } else if(name == "EdgeLeftAction") {
                    m_interfaceEdgeLeftAction = value.toString();
                } else if(name == "EdgeRightAction") {
                    m_interfaceEdgeRightAction = value.toString();
                } else if(name == "EdgeTopAction") {
                    m_interfaceEdgeTopAction = value.toString();
                } else if(name == "FlickAdjustSpeed") {
                    m_interfaceFlickAdjustSpeed = value.toInt();
                } else if(name == "FlickAdjustSpeedSpeedup") {
                    m_interfaceFlickAdjustSpeedSpeedup = value.toInt();
                } else if(name == "FontBoldWeight") {
                    m_interfaceFontBoldWeight = value.toInt();
                } else if(name == "FontNormalWeight") {
                    m_interfaceFontNormalWeight = value.toInt();
                } else if(name == "HotEdgeSize") {
                    m_interfaceHotEdgeSize = value.toInt();
                } else if(name == "KeepWindowOnTop") {
                    m_interfaceKeepWindowOnTop = value.toInt();
                } else if(name == "Language") {
                    m_interfaceLanguage = value.toString();
                } else if(name == "MinimapPopout") {
                    m_interfaceMinimapPopout = value.toInt();
                } else if(name == "NavigateOnEmptyBackground") {
                    m_interfaceNavigateOnEmptyBackground = value.toInt();
                } else if(name == "NavigationFloating") {
                    m_interfaceNavigationFloating = value.toInt();
                } else if(name == "NotificationDistanceFromEdge") {
                    m_interfaceNotificationDistanceFromEdge = value.toInt();
                } else if(name == "NotificationLocation") {
                    m_interfaceNotificationLocation = value.toString();
                } else if(name == "NotificationTryNative") {
                    m_interfaceNotificationTryNative = value.toInt();
                } else if(name == "PopoutAbout") {
                    m_interfacePopoutAbout = value.toInt();
                } else if(name == "PopoutAdvancedSort") {
                    m_interfacePopoutAdvancedSort = value.toInt();
                } else if(name == "PopoutChromecast") {
                    m_interfacePopoutChromecast = value.toInt();
                } else if(name == "PopoutExport") {
                    m_interfacePopoutExport = value.toInt();
                } else if(name == "PopoutFileDelete") {
                    m_interfacePopoutFileDelete = value.toInt();
                } else if(name == "PopoutFileDialog") {
                    m_interfacePopoutFileDialog = value.toInt();
                } else if(name == "PopoutFileDialogNonModal") {
                    m_interfacePopoutFileDialogNonModal = value.toInt();
                } else if(name == "PopoutFileRename") {
                    m_interfacePopoutFileRename = value.toInt();
                } else if(name == "PopoutFilter") {
                    m_interfacePopoutFilter = value.toInt();
                } else if(name == "PopoutFind") {
                    m_interfacePopoutFind = value.toInt();
                } else if(name == "PopoutImgur") {
                    m_interfacePopoutImgur = value.toInt();
                } else if(name == "PopoutMainMenu") {
                    m_interfacePopoutMainMenu = value.toInt();
                } else if(name == "PopoutMapExplorer") {
                    m_interfacePopoutMapExplorer = value.toInt();
                } else if(name == "PopoutMapExplorerNonModal") {
                    m_interfacePopoutMapExplorerNonModal = value.toInt();
                } else if(name == "PopoutMetadata") {
                    m_interfacePopoutMetadata = value.toInt();
                } else if(name == "PopoutSettingsManager") {
                    m_interfacePopoutSettingsManager = value.toInt();
                } else if(name == "PopoutSettingsManagerNonModal") {
                    m_interfacePopoutSettingsManagerNonModal = value.toInt();
                } else if(name == "PopoutSlideshowControls") {
                    m_interfacePopoutSlideshowControls = value.toInt();
                } else if(name == "PopoutSlideshowSetup") {
                    m_interfacePopoutSlideshowSetup = value.toInt();
                } else if(name == "PopoutWhenWindowIsSmall") {
                    m_interfacePopoutWhenWindowIsSmall = value.toInt();
                } else if(name == "QuickActions") {
                    m_interfaceQuickActions = value.toInt();
                } else if(name == "QuickActionsHeight") {
                    m_interfaceQuickActionsHeight = value.toInt();
                } else if(name == "QuickActionsItems") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_interfaceQuickActionsItems = val.split(":://::");
                    else if(val != "")
                        m_interfaceQuickActionsItems = QStringList() << val;
                    else
                        m_interfaceQuickActionsItems = QStringList();
                } else if(name == "RememberLastImage") {
                    m_interfaceRememberLastImage = value.toInt();
                } else if(name == "SaveWindowGeometry") {
                    m_interfaceSaveWindowGeometry = value.toInt();
                } else if(name == "StatusInfoAutoHide") {
                    m_interfaceStatusInfoAutoHide = value.toInt();
                } else if(name == "StatusInfoAutoHideTimeout") {
                    m_interfaceStatusInfoAutoHideTimeout = value.toInt();
                } else if(name == "StatusInfoAutoHideTopEdge") {
                    m_interfaceStatusInfoAutoHideTopEdge = value.toInt();
                } else if(name == "StatusInfoFontSize") {
                    m_interfaceStatusInfoFontSize = value.toInt();
                } else if(name == "StatusInfoList") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_interfaceStatusInfoList = val.split(":://::");
                    else if(val != "")
                        m_interfaceStatusInfoList = QStringList() << val;
                    else
                        m_interfaceStatusInfoList = QStringList();
                } else if(name == "StatusInfoManageWindow") {
                    m_interfaceStatusInfoManageWindow = value.toInt();
                } else if(name == "StatusInfoPosition") {
                    m_interfaceStatusInfoPosition = value.toString();
                } else if(name == "StatusInfoShow") {
                    m_interfaceStatusInfoShow = value.toInt();
                } else if(name == "StatusInfoShowImageChange") {
                    m_interfaceStatusInfoShowImageChange = value.toInt();
                } else if(name == "TrayIcon") {
                    m_interfaceTrayIcon = value.toInt();
                } else if(name == "TrayIconHideReset") {
                    m_interfaceTrayIconHideReset = value.toInt();
                } else if(name == "TrayIconMonochrome") {
                    m_interfaceTrayIconMonochrome = value.toInt();
                } else if(name == "WindowButtonsAutoHide") {
                    m_interfaceWindowButtonsAutoHide = value.toInt();
                } else if(name == "WindowButtonsAutoHideTimeout") {
                    m_interfaceWindowButtonsAutoHideTimeout = value.toInt();
                } else if(name == "WindowButtonsAutoHideTopEdge") {
                    m_interfaceWindowButtonsAutoHideTopEdge = value.toInt();
                } else if(name == "WindowButtonsFollowAccentColor") {
                    m_interfaceWindowButtonsFollowAccentColor = value.toInt();
                } else if(name == "WindowButtonsItems") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_interfaceWindowButtonsItems = val.split(":://::");
                    else if(val != "")
                        m_interfaceWindowButtonsItems = QStringList() << val;
                    else
                        m_interfaceWindowButtonsItems = QStringList();
                } else if(name == "WindowButtonsShow") {
                    m_interfaceWindowButtonsShow = value.toInt();
                } else if(name == "WindowButtonsSize") {
                    m_interfaceWindowButtonsSize = value.toInt();
                } else if(name == "WindowDecoration") {
                    m_interfaceWindowDecoration = value.toInt();
                } else if(name == "WindowDecorationOnEmptyBackground") {
                    m_interfaceWindowDecorationOnEmptyBackground = value.toInt();
                } else if(name == "WindowMode") {
                    m_interfaceWindowMode = value.toInt();
                }
            // table: mainmenu
            } else if(table == "mainmenu") {
                if(name == "ElementHeightDynamic") {
                    m_mainmenuElementHeightDynamic = value.toInt();
                } else if(name == "ElementPosition") {
                    const QStringList parts = value.toString().split(",");
                    if(parts.length() == 2)
                        m_mainmenuElementPosition = QPoint(parts[0].toDouble(), parts[1].toDouble());
                    else
                        m_mainmenuElementPosition = QPoint(0,0);
                } else if(name == "ElementSize") {
                    const QStringList parts = value.toString().split(",");
                    if(parts.length() == 2)
                        m_mainmenuElementSize = QSize(parts[0].toDouble(), parts[1].toDouble());
                    else
                        m_mainmenuElementSize = QSize(0,0);
                } else if(name == "ElementWidth") {
                    m_mainmenuElementWidth = value.toInt();
                } else if(name == "ShowExternal") {
                    m_mainmenuShowExternal = value.toInt();
                }
            // table: mapview
            } else if(table == "mapview") {
                if(name == "CurrentPosition") {
                    const QStringList parts = value.toString().split(",");
                    if(parts.length() == 2)
                        m_mapviewCurrentPosition = QPoint(parts[0].toDouble(), parts[1].toDouble());
                    else
                        m_mapviewCurrentPosition = QPoint(0,0);
                } else if(name == "CurrentSize") {
                    const QStringList parts = value.toString().split(",");
                    if(parts.length() == 2)
                        m_mapviewCurrentSize = QSize(parts[0].toDouble(), parts[1].toDouble());
                    else
                        m_mapviewCurrentSize = QSize(0,0);
                } else if(name == "CurrentVisible") {
                    m_mapviewCurrentVisible = value.toInt();
                } else if(name == "ExplorerThumbnailsScaleCrop") {
                    m_mapviewExplorerThumbnailsScaleCrop = value.toInt();
                } else if(name == "ExplorerThumbnailsZoomLevel") {
                    m_mapviewExplorerThumbnailsZoomLevel = value.toInt();
                }
            // table: metadata
            } else if(table == "metadata") {
                if(name == "AutoRotation") {
                    m_metadataAutoRotation = value.toInt();
                } else if(name == "Copyright") {
                    m_metadataCopyright = value.toInt();
                } else if(name == "Dimensions") {
                    m_metadataDimensions = value.toInt();
                } else if(name == "ElementFloating") {
                    m_metadataElementFloating = value.toInt();
                } else if(name == "ElementHeightDynamic") {
                    m_metadataElementHeightDynamic = value.toInt();
                } else if(name == "ElementPosition") {
                    const QStringList parts = value.toString().split(",");
                    if(parts.length() == 2)
                        m_metadataElementPosition = QPoint(parts[0].toDouble(), parts[1].toDouble());
                    else
                        m_metadataElementPosition = QPoint(0,0);
                } else if(name == "ElementSize") {
                    const QStringList parts = value.toString().split(",");
                    if(parts.length() == 2)
                        m_metadataElementSize = QSize(parts[0].toDouble(), parts[1].toDouble());
                    else
                        m_metadataElementSize = QSize(0,0);
                } else if(name == "ElementVisible") {
                    m_metadataElementVisible = value.toInt();
                } else if(name == "ExposureTime") {
                    m_metadataExposureTime = value.toInt();
                } else if(name == "FLength") {
                    m_metadataFLength = value.toInt();
                } else if(name == "FNumber") {
                    m_metadataFNumber = value.toInt();
                } else if(name == "FaceTagsBorder") {
                    m_metadataFaceTagsBorder = value.toInt();
                } else if(name == "FaceTagsBorderColor") {
                    m_metadataFaceTagsBorderColor = value.toString();
                } else if(name == "FaceTagsBorderWidth") {
                    m_metadataFaceTagsBorderWidth = value.toInt();
                } else if(name == "FaceTagsEnabled") {
                    m_metadataFaceTagsEnabled = value.toInt();
                } else if(name == "FaceTagsFontSize") {
                    m_metadataFaceTagsFontSize = value.toInt();
                } else if(name == "FaceTagsVisibility") {
                    m_metadataFaceTagsVisibility = value.toInt();
                } else if(name == "FileSize") {
                    m_metadataFileSize = value.toInt();
                } else if(name == "FileType") {
                    m_metadataFileType = value.toInt();
                } else if(name == "Filename") {
                    m_metadataFilename = value.toInt();
                } else if(name == "Flash") {
                    m_metadataFlash = value.toInt();
                } else if(name == "Gps") {
                    m_metadataGps = value.toInt();
                } else if(name == "GpsMap") {
                    m_metadataGpsMap = value.toString();
                } else if(name == "ImageNumber") {
                    m_metadataImageNumber = value.toInt();
                } else if(name == "Iso") {
                    m_metadataIso = value.toInt();
                } else if(name == "Keywords") {
                    m_metadataKeywords = value.toInt();
                } else if(name == "LightSource") {
                    m_metadataLightSource = value.toInt();
                } else if(name == "Location") {
                    m_metadataLocation = value.toInt();
                } else if(name == "Make") {
                    m_metadataMake = value.toInt();
                } else if(name == "Model") {
                    m_metadataModel = value.toInt();
                } else if(name == "SceneType") {
                    m_metadataSceneType = value.toInt();
                } else if(name == "SideBar") {
                    m_metadataSideBar = value.toInt();
                } else if(name == "SideBarLocation") {
                    m_metadataSideBarLocation = value.toString();
                } else if(name == "SideBarWidth") {
                    m_metadataSideBarWidth = value.toInt();
                } else if(name == "Software") {
                    m_metadataSoftware = value.toInt();
                } else if(name == "Time") {
                    m_metadataTime = value.toInt();
                }
            // table: slideshow
            } else if(table == "slideshow") {
                if(name == "HideLabels") {
                    m_slideshowHideLabels = value.toInt();
                } else if(name == "HideWindowButtons") {
                    m_slideshowHideWindowButtons = value.toInt();
                } else if(name == "ImageTransition") {
                    m_slideshowImageTransition = value.toInt();
                } else if(name == "IncludeSubFolders") {
                    m_slideshowIncludeSubFolders = value.toInt();
                } else if(name == "Loop") {
                    m_slideshowLoop = value.toInt();
                } else if(name == "Music") {
                    m_slideshowMusic = value.toInt();
                } else if(name == "MusicFile") {
                    m_slideshowMusicFile = value.toString();
                } else if(name == "MusicFiles") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_slideshowMusicFiles = val.split(":://::");
                    else if(val != "")
                        m_slideshowMusicFiles = QStringList() << val;
                    else
                        m_slideshowMusicFiles = QStringList();
                } else if(name == "MusicShuffle") {
                    m_slideshowMusicShuffle = value.toInt();
                } else if(name == "MusicVolumeVideos") {
                    m_slideshowMusicVolumeVideos = value.toInt();
                } else if(name == "Shuffle") {
                    m_slideshowShuffle = value.toInt();
                } else if(name == "Time") {
                    m_slideshowTime = value.toInt();
                } else if(name == "TypeAnimation") {
                    m_slideshowTypeAnimation = value.toString();
                }
            // table: thumbnails
            } else if(table == "thumbnails") {
                if(name == "Cache") {
                    m_thumbnailsCache = value.toInt();
                } else if(name == "CacheBaseDirDefault") {
                    m_thumbnailsCacheBaseDirDefault = value.toInt();
                } else if(name == "CacheBaseDirLocation") {
                    m_thumbnailsCacheBaseDirLocation = value.toString();
                } else if(name == "CenterOnActive") {
                    m_thumbnailsCenterOnActive = value.toInt();
                } else if(name == "CropToFit") {
                    m_thumbnailsCropToFit = value.toInt();
                } else if(name == "Disable") {
                    m_thumbnailsDisable = value.toInt();
                } else if(name == "ExcludeDropBox") {
                    m_thumbnailsExcludeDropBox = value.toString();
                } else if(name == "ExcludeFolders") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_thumbnailsExcludeFolders = val.split(":://::");
                    else if(val != "")
                        m_thumbnailsExcludeFolders = QStringList() << val;
                    else
                        m_thumbnailsExcludeFolders = QStringList();
                } else if(name == "ExcludeNetworkShares") {
                    m_thumbnailsExcludeNetworkShares = value.toInt();
                } else if(name == "ExcludeNextcloud") {
                    m_thumbnailsExcludeNextcloud = value.toString();
                } else if(name == "ExcludeOwnCloud") {
                    m_thumbnailsExcludeOwnCloud = value.toString();
                } else if(name == "Filename") {
                    m_thumbnailsFilename = value.toInt();
                } else if(name == "FontSize") {
                    m_thumbnailsFontSize = value.toInt();
                } else if(name == "HighlightAnimation") {
                    QString val = value.toString();
                    if(val.contains(":://::"))
                        m_thumbnailsHighlightAnimation = val.split(":://::");
                    else if(val != "")
                        m_thumbnailsHighlightAnimation = QStringList() << val;
                    else
                        m_thumbnailsHighlightAnimation = QStringList();
                } else if(name == "HighlightAnimationLiftUp") {
                    m_thumbnailsHighlightAnimationLiftUp = value.toInt();
                } else if(name == "IconsOnly") {
                    m_thumbnailsIconsOnly = value.toInt();
                } else if(name == "InactiveTransparent") {
                    m_thumbnailsInactiveTransparent = value.toInt();
                } else if(name == "MaxNumberThreads") {
                    m_thumbnailsMaxNumberThreads = value.toInt();
                } else if(name == "SameHeightVaryWidth") {
                    m_thumbnailsSameHeightVaryWidth = value.toInt();
                } else if(name == "Size") {
                    m_thumbnailsSize = value.toInt();
                } else if(name == "SmallThumbnailsKeepSmall") {
                    m_thumbnailsSmallThumbnailsKeepSmall = value.toInt();
                } else if(name == "Spacing") {
                    m_thumbnailsSpacing = value.toInt();
                } else if(name == "Tooltip") {
                    m_thumbnailsTooltip = value.toInt();
                } else if(name == "Visibility") {
                    m_thumbnailsVisibility = value.toInt();
                }
            }
        }

    }

    // make sure in the integrated interface the thumbnails are either shown top or bottom and not the sides
    if(m_generalInterfaceVariant == "integrated") {
        if(m_interfaceEdgeLeftAction == "thumbnails") {
            if(m_interfaceEdgeBottomAction == "")
                m_interfaceEdgeBottomAction = "thumbnails";
            else if(m_interfaceEdgeTopAction == "")
                m_interfaceEdgeTopAction = "thumbnails";
            m_interfaceEdgeLeftAction = "";
        }
        if(m_interfaceEdgeRightAction == "thumbnails") {
            if(m_interfaceEdgeBottomAction == "")
                m_interfaceEdgeBottomAction = "thumbnails";
            else if(m_interfaceEdgeTopAction == "")
                m_interfaceEdgeTopAction = "thumbnails";
            m_interfaceEdgeRightAction = "";
        }
    }

    // we make sure that the version is written to the user database
    // this is important in order to always be able to detect updates
    QSqlQuery query(db);
    if(!dbIsTransaction) {
        db.transaction();
        dbIsTransaction = true;
    }
    query.prepare("INSERT INTO 'general' (`name`,`value`,`datatype`) VALUES ('Version', :val, 'string') ON CONFLICT (`name`) DO UPDATE SET `value`=:valupdate");
    query.bindValue(":val", m_generalVersion);
    query.bindValue(":valupdate", m_generalVersion);
    if(!query.exec()) {
        qWarning() << "SQL Error:" << query.lastError().text();
        qWarning() << "Unable to write version to database";
        qWarning() << "Executed query:" << query.lastQuery();
    }
    dbCommitTimer->start();


}

bool PQCSettings::backupDatabase() {

    // make sure all changes are written to db
    if(dbIsTransaction) {
        QSqlDatabase db = QSqlDatabase::database("settings");
        dbCommitTimer->stop();
        db.commit();
        PQCSettingsCPP::get().readDB();
        dbIsTransaction = false;
        if(db.lastError().text().trimmed().length())
            qWarning() << "ERROR committing database:" << db.lastError().text();
    }

    // backup file
    if(QFile::exists(QString("%1.bak").arg(PQCConfigFiles::get().USERSETTINGS_DB())))
        QFile::remove(QString("%1.bak").arg(PQCConfigFiles::get().USERSETTINGS_DB()));
    QFile file(PQCConfigFiles::get().USERSETTINGS_DB());
    return file.copy(QString("%1.bak").arg(PQCConfigFiles::get().USERSETTINGS_DB()));

}

void PQCSettings::saveChangedValue(const QString &_key, const QVariant &value) {

    qDebug() << "args: key =" << _key;
    qDebug() << "args: value =" << value;
    qDebug() << "readonly =" << readonly;

    if(readonly) return;

    QSqlDatabase db = QSqlDatabase::database("settings");

    dbCommitTimer->stop();

    QString key = _key;
    QString category = "";

    for(const auto &table : std::as_const(dbtables)) {
        if(key.startsWith(table)) {
            category = table;
            key = key.remove(0, table.length());
            break;
        }
    }

    if(category == "") {
        qWarning() << "ERROR: invalid category received:" << key;
        return;
    }

    QSqlQuery query(db);

    if(!dbIsTransaction) {
        db.transaction();
        dbIsTransaction = true;
    }

    // Using a placeholder also for table name causes an sqlite 'parameter count mismatch' error
    // the 'on conflict' cause performs an update if the value already exists and the insert thus failed
    query.prepare(QString("INSERT INTO '%1' (`name`,`value`,`datatype`) VALUES (:nme, :val, :dat) ON CONFLICT (`name`) DO UPDATE SET `value`=:valupdate").arg(category));

    query.bindValue(":nme", key);

    // we convert the value to a string
    QString val = "";
    if(value.typeId() == QMetaType::Bool) {
        val = QString::number(value.toInt());
        query.bindValue(":dat", "bool");
    } else if(value.typeId() == QMetaType::Int) {
        val = QString::number(value.toInt());
        query.bindValue(":dat", "int");
    } else if(value.typeId() == QMetaType::Double) {
        val = QString::number(value.toDouble());
        query.bindValue(":dat", "double");
    } else if(value.typeId() == QMetaType::QStringList) {
        val = value.toStringList().join(":://::");
        query.bindValue(":dat", "list");
    } else if(value.typeId() == QMetaType::QPoint) {
        val = QString("%1,%2").arg(value.toPoint().x()).arg(value.toPoint().y());
        query.bindValue(":dat", "point");
    } else if(value.typeId() == QMetaType::QPointF) {
        val = QString("%1,%2").arg(value.toPointF().x()).arg(value.toPointF().y());
        query.bindValue(":dat", "point");
    } else if(value.typeId() == QMetaType::QSize) {
        val = QString("%1,%2").arg(value.toSize().width()).arg(value.toSize().height());
        query.bindValue(":dat", "size");
    } else if(value.typeId() == QMetaType::QSizeF) {
        val = QString("%1,%2").arg(value.toSizeF().width()).arg(value.toSizeF().height());
        query.bindValue(":dat", "size");
    } else if(value.canConvert<QJSValue>() && value.value<QJSValue>().isArray()) {
        QStringList ret;
        QJSValue _val = value.value<QJSValue>();
        const int length = _val.property("length").toInt();
        for(int i = 0; i < length; ++i)
            ret << _val.property(i).toString();
        val = ret.join(":://::");
        query.bindValue(":dat", "list");
    } else {
        val = value.toString();
        query.bindValue(":dat", "string");
    }

    query.bindValue(":val", val);
    query.bindValue(":valupdate", val);

    // and update database
    if(!query.exec()) {
        qWarning() << "SQL Error:" << query.lastError().text();
        qWarning() << "Category =" << category << "- value =" << value;
        qWarning() << "Executed query:" << query.lastQuery();
    }

    dbCommitTimer->start();

}

void PQCSettings::setDefault() {

    qDebug() << "readonly =" << readonly;

    if(readonly) return;

    QSqlDatabase db = QSqlDatabase::database("settings");

    backupDatabase();

    dbCommitTimer->stop();
    if(!dbIsTransaction) {
        db.transaction();
        dbIsTransaction = true;
    }

    for(const auto &table : std::as_const(dbtables)) {

        QSqlQuery query(db);
        if(!query.exec(QString("DELETE FROM '%1'").arg(table)))
            qWarning() << "SQL Error:" << query.lastError().text();

    }

    setupFresh();

}
void PQCSettings::closeDatabase() {

    qDebug() << "";

    QSqlDatabase db = QSqlDatabase::database("settings");

    dbCommitTimer->stop();

    if(dbIsTransaction) {
        db.commit();
        PQCSettingsCPP::get().readDB();
        dbIsTransaction = false;
        if(db.lastError().text().trimmed().length())
            qWarning() << "ERROR committing database:" << db.lastError().text();
    }

    db.close();

}

void PQCSettings::reopenDatabase() {

    qDebug() << "";

    if(!QSqlDatabase::database("settings").open())
        qWarning() << "Unable to reopen database";

}

QString PQCSettings::verifyNameAndGetType(QString name) {

    QString tablename = "";
    QString settingname = "";

    for(auto &t : std::as_const(dbtables)) {

        if(name.startsWith(t)) {
            tablename = t;
            break;
        }

    }

    // invalid table name
    if(tablename == "")
        return "";

    settingname = name.last(name.size()-tablename.size());

    QSqlQuery query(QSqlDatabase::database("defaultsettings"));
    query.prepare(QString("SELECT datatype FROM `%1` WHERE `name`=:nme").arg(tablename));
    query.bindValue(":nme", settingname);
    if(!query.exec()) {
        qWarning() << "ERROR checking datatype for setting" << settingname;
        return "";
    }

    // invalid setting name
    if(!query.next())
        return "";

    QString ret = query.value(0).toString();
    query.clear();

    return ret;

}

void PQCSettings::setupFresh() {

    qDebug() << "";

    // table: filedialog
    m_filedialogDetailsTooltip = true;
    m_filedialogDevices = false;
    m_filedialogDevicesShowTmpfs = false;
    m_filedialogDragDropFileviewGrid = false;
    m_filedialogDragDropFileviewList = true;
    m_filedialogDragDropFileviewMasonry = false;
    m_filedialogDragDropPlaces = true;
    m_filedialogElementPadding = 1;
    m_filedialogFolderContentThumbnails = true;
    m_filedialogFolderContentThumbnailsAutoload = false;
    m_filedialogFolderContentThumbnailsLoop = true;
    m_filedialogFolderContentThumbnailsScaleCrop = true;
    m_filedialogFolderContentThumbnailsSortAscending = true;
    m_filedialogFolderContentThumbnailsSortBy = "default";
    m_filedialogFolderContentThumbnailsSpeed = 2;
    m_filedialogLabelsShowGrid = true;
    m_filedialogLabelsShowMasonry = false;
    m_filedialogLayout = "grid";
    m_filedialogPlaces = true;
    m_filedialogPlacesWidth = 290;
    m_filedialogPreview = false;
    m_filedialogPreviewBlur = false;
    m_filedialogPreviewColorIntensity = 50;
    m_filedialogPreviewCropToFit = true;
    m_filedialogPreviewHigherResolution = false;
    m_filedialogPreviewMuted = false;
    m_filedialogRememberSelection = false;
    m_filedialogShowHiddenFilesFolders = false;
    m_filedialogSingleClickSelect = false;
    m_filedialogStartupRestoreCustom = false;
    m_filedialogStartupRestoreCustomFolder = "";
    m_filedialogStartupRestoreHome = false;
    m_filedialogStartupRestorePrevious = true;
    m_filedialogThumbnails = true;
    m_filedialogThumbnailsScaleCrop = true;
    m_filedialogUseNativeFileDialog = false;
    m_filedialogZoom = 40;

    // table: filetypes
    m_filetypesAnimatedControls = true;
    m_filetypesAnimatedLeftRight = false;
    m_filetypesAnimatedSpacePause = true;
    m_filetypesArchiveAlwaysEnterAutomatically = false;
    m_filetypesArchiveControls = true;
    m_filetypesArchiveDontLoadMoreFilesThan = false;
    m_filetypesArchiveDontLoadMoreFilesThanCount = 2000;
    m_filetypesArchiveIgnoreLargerThan = false;
    m_filetypesArchiveIgnoreLargerThanSize = 2048;
    m_filetypesArchiveLeftRight = false;
    m_filetypesArchiveViewerModeExitButton = true;
    m_filetypesComicBookAlwaysEnterAutomatically = false;
    m_filetypesDocumentAlwaysEnterAutomatically = false;
    m_filetypesDocumentControls = true;
    m_filetypesDocumentLeftRight = false;
    m_filetypesDocumentViewerModeExitButton = true;
    m_filetypesExternalUnrar = false;
    m_filetypesLoadAppleLivePhotos = true;
    m_filetypesLoadMotionPhotos = true;
    m_filetypesMotionAutoPlay = true;
    m_filetypesMotionPhotoPlayPause = true;
    m_filetypesMotionSpacePause = true;
    m_filetypesPDFQuality = 150;
    m_filetypesPhotoSphereArrowKeys = false;
    m_filetypesPhotoSphereAutoLoad = true;
    m_filetypesPhotoSphereBigButton = false;
    m_filetypesPhotoSphereControls = false;
    m_filetypesPhotoSpherePanOnLoad = true;
    m_filetypesRAWUseEmbeddedIfAvailable = true;
    m_filetypesVideoAutoplay = true;
    m_filetypesVideoLeftRightJumpVideo = false;
    m_filetypesVideoLoop = false;
    m_filetypesVideoPreferLibmpv = true;
    m_filetypesVideoSpacePause = true;
    m_filetypesVideoThumbnailer = "ffmpegthumbnailer";
    m_filetypesVideoVolume = 100;

    // table: general
    m_generalAutoSaveSettings = false;
    m_generalCompactSettings = false;
    m_generalDisableAllAnimations = false;
    m_generalExtensionsAllowUntrusted = QStringList();
    m_generalExtensionsEnabled = QStringList() << "CropImage" << "ExportImage" << "FloatingNavigation" << "Histogram" << "ImgurCom" << "MapCurrent" << "QuickActions" << "ScaleImage" << "Wallpaper";
    m_generalExtensionsFloatingSetup = QStringList();
    m_generalInterfaceVariant = "modern";
    m_generalVersion = PQMVERSION;

    // table: imageview
    m_imageviewAdvancedSortAscending = true;
    m_imageviewAdvancedSortCriteria = "resolution";
    m_imageviewAdvancedSortDateCriteria = QStringList() << "exiforiginal" << "exifdigital" << "filecreation" << "filemodification";
    m_imageviewAdvancedSortQuality = "medium";
    m_imageviewAlwaysActualSize = false;
    m_imageviewAnimationDuration = 3;
    m_imageviewAnimationType = "opacity";
    m_imageviewCache = 512;
    m_imageviewColorSpaceContextMenu = QStringList() << "::0" << "::1" << "::2" << "::3" << "::4";
    m_imageviewColorSpaceDefault = "";
    m_imageviewColorSpaceEnable = true;
    m_imageviewColorSpaceLoadEmbedded = true;
    m_imageviewEscapeExitArchive = true;
    m_imageviewEscapeExitBarcodes = true;
    m_imageviewEscapeExitDocument = true;
    m_imageviewEscapeExitFilter = true;
    m_imageviewEscapeExitSphere = true;
    m_imageviewFitInWindow = false;
    m_imageviewHideCursorTimeout = 1;
    m_imageviewInterpolationDisableForSmallImages = false;
    m_imageviewLoopThroughFolder = true;
    m_imageviewMargin = 5;
    m_imageviewMinimapSizeLevel = 0;
    m_imageviewMirrorAnimate = true;
    m_imageviewMouseWheelRepeatDelay = 0;
    m_imageviewPreloadInBackground = 1;
    m_imageviewPreserveMirror = false;
    m_imageviewPreserveRotation = false;
    m_imageviewPreserveZoom = false;
    m_imageviewRememberZoomRotationMirror = false;
    m_imageviewResetViewAutoHideTimeout = 1000;
    m_imageviewResetViewShow = false;
    m_imageviewRespectDevicePixelRatio = true;
    m_imageviewShowMinimap = true;
    m_imageviewSiblingFileMaxIterations = 100;
    m_imageviewSiblingFileMaxLevelUp = 8;
    m_imageviewSiblingFilemaxLevelDown = 2;
    m_imageviewSortImagesAscending = true;
    m_imageviewSortImagesBy = "naturalname";
    m_imageviewTransparencyMarker = false;
    m_imageviewUseMouseLeftButtonForImageMove = true;
    m_imageviewUseMouseWheelForImageMove = false;
    m_imageviewZoomMax = 500;
    m_imageviewZoomMaxEnabled = true;
    m_imageviewZoomMin = 20;
    m_imageviewZoomMinEnabled = true;
    m_imageviewZoomSpeed = 20;
    m_imageviewZoomSpeedRelative = true;
    m_imageviewZoomToCenter = false;

    // table: interface
    m_interfaceAccentColor = "#222222";
    m_interfaceAllowMultipleInstances = false;
    m_interfaceBackgroundCustomOverlay = false;
    m_interfaceBackgroundCustomOverlayColor = "";
    m_interfaceBackgroundFullyTransparent = false;
    m_interfaceBackgroundImageCenter = false;
    m_interfaceBackgroundImagePath = "";
    m_interfaceBackgroundImageScale = true;
    m_interfaceBackgroundImageScaleCrop = false;
    m_interfaceBackgroundImageScreenshot = false;
    m_interfaceBackgroundImageStretch = false;
    m_interfaceBackgroundImageTile = false;
    m_interfaceBackgroundImageUse = false;
    m_interfaceBackgroundSolid = false;
    m_interfaceBlurElementsInBackground = true;
    m_interfaceCloseOnEmptyBackground = false;
    m_interfaceDoubleClickThreshold = 300;
    m_interfaceEdgeBottomAction = "thumbnails";
    m_interfaceEdgeLeftAction = "metadata";
    m_interfaceEdgeRightAction = "mainmenu";
    m_interfaceEdgeTopAction = "";
    m_interfaceFlickAdjustSpeed = true;
    m_interfaceFlickAdjustSpeedSpeedup = 1;
    m_interfaceFontBoldWeight = 700;
    m_interfaceFontNormalWeight = 400;
    m_interfaceHotEdgeSize = 4;
    m_interfaceKeepWindowOnTop = false;
    m_interfaceLanguage = "en";
    m_interfaceMinimapPopout = false;
    m_interfaceNavigateOnEmptyBackground = false;
    m_interfaceNavigationFloating = false;
    m_interfaceNotificationDistanceFromEdge = 40;
    m_interfaceNotificationLocation = "center";
    m_interfaceNotificationTryNative = true;
    m_interfacePopoutAbout = false;
    m_interfacePopoutAdvancedSort = true;
    m_interfacePopoutChromecast = true;
    m_interfacePopoutExport = true;
    m_interfacePopoutFileDelete = false;
    m_interfacePopoutFileDialog = false;
    m_interfacePopoutFileDialogNonModal = false;
    m_interfacePopoutFileRename = false;
    m_interfacePopoutFilter = false;
    m_interfacePopoutFind = false;
    m_interfacePopoutImgur = true;
    m_interfacePopoutMainMenu = false;
    m_interfacePopoutMapExplorer = true;
    m_interfacePopoutMapExplorerNonModal = false;
    m_interfacePopoutMetadata = false;
    m_interfacePopoutSettingsManager = false;
    m_interfacePopoutSettingsManagerNonModal = false;
    m_interfacePopoutSlideshowControls = false;
    m_interfacePopoutSlideshowSetup = true;
    m_interfacePopoutWhenWindowIsSmall = true;
    m_interfaceQuickActions = true;
    m_interfaceQuickActionsHeight = 40;
    m_interfaceQuickActionsItems = QStringList() << "rename" << "delete" << "|" << "rotateleft" << "rotateright" << "mirrorhor" << "mirrorver" << "|" << "crop" << "scale" << "|" << "close";
    m_interfaceRememberLastImage = false;
    m_interfaceSaveWindowGeometry = false;
    m_interfaceStatusInfoAutoHide = false;
    m_interfaceStatusInfoAutoHideTimeout = 1000;
    m_interfaceStatusInfoAutoHideTopEdge = false;
    m_interfaceStatusInfoFontSize = 10;
    m_interfaceStatusInfoList = QStringList() << "counter" << "filename" << "zoom" << "rotation";
    m_interfaceStatusInfoManageWindow = false;
    m_interfaceStatusInfoPosition = "left";
    m_interfaceStatusInfoShow = true;
    m_interfaceStatusInfoShowImageChange = true;
    m_interfaceTrayIcon = 0;
    m_interfaceTrayIconHideReset = false;
    m_interfaceTrayIconMonochrome = true;
    m_interfaceWindowButtonsAutoHide = false;
    m_interfaceWindowButtonsAutoHideTimeout = 1000;
    m_interfaceWindowButtonsAutoHideTopEdge = false;
    m_interfaceWindowButtonsFollowAccentColor = false;
    m_interfaceWindowButtonsItems = QStringList() << "left_0|0|0" << "right_0|0|0" << "menu_0|0|0" << "ontop_0|1|1" << "fullscreen_0|0|1";
    m_interfaceWindowButtonsShow = true;
    m_interfaceWindowButtonsSize = 10;
    m_interfaceWindowDecoration = true;
    m_interfaceWindowDecorationOnEmptyBackground = false;
    m_interfaceWindowMode = true;

    // table: mainmenu
    m_mainmenuElementHeightDynamic = true;
    m_mainmenuElementPosition = QPoint(100, 100);
    m_mainmenuElementSize = QSize(450, 900);
    m_mainmenuElementWidth = 450;
    m_mainmenuShowExternal = false;

    // table: mapview
    m_mapviewCurrentPosition = QPoint(200, 200);
    m_mapviewCurrentSize = QSize(400, 300);
    m_mapviewCurrentVisible = false;
    m_mapviewExplorerThumbnailsScaleCrop = true;
    m_mapviewExplorerThumbnailsZoomLevel = 20;

    // table: metadata
    m_metadataAutoRotation = true;
    m_metadataCopyright = false;
    m_metadataDimensions = true;
    m_metadataElementFloating = false;
    m_metadataElementHeightDynamic = true;
    m_metadataElementPosition = QPoint(100, 100);
    m_metadataElementSize = QSize(400, 700);
    m_metadataElementVisible = false;
    m_metadataExposureTime = true;
    m_metadataFLength = true;
    m_metadataFNumber = true;
    m_metadataFaceTagsBorder = false;
    m_metadataFaceTagsBorderColor = "#44ff0000";
    m_metadataFaceTagsBorderWidth = 3;
    m_metadataFaceTagsEnabled = true;
    m_metadataFaceTagsFontSize = 10;
    m_metadataFaceTagsVisibility = 1;
    m_metadataFileSize = true;
    m_metadataFileType = true;
    m_metadataFilename = true;
    m_metadataFlash = true;
    m_metadataGps = true;
    m_metadataGpsMap = "openstreetmap.org";
    m_metadataImageNumber = true;
    m_metadataIso = true;
    m_metadataKeywords = false;
    m_metadataLightSource = false;
    m_metadataLocation = false;
    m_metadataMake = true;
    m_metadataModel = true;
    m_metadataSceneType = true;
    m_metadataSideBar = true;
    m_metadataSideBarLocation = "right";
    m_metadataSideBarWidth = 300;
    m_metadataSoftware = true;
    m_metadataTime = true;

    // table: slideshow
    m_slideshowHideLabels = true;
    m_slideshowHideWindowButtons = false;
    m_slideshowImageTransition = 4;
    m_slideshowIncludeSubFolders = false;
    m_slideshowLoop = true;
    m_slideshowMusic = false;
    m_slideshowMusicFile = "";
    m_slideshowMusicFiles = QStringList();
    m_slideshowMusicShuffle = false;
    m_slideshowMusicVolumeVideos = 1;
    m_slideshowShuffle = false;
    m_slideshowTime = 5;
    m_slideshowTypeAnimation = "opacity";

    // table: thumbnails
    m_thumbnailsCache = true;
    m_thumbnailsCacheBaseDirDefault = true;
    m_thumbnailsCacheBaseDirLocation = "";
    m_thumbnailsCenterOnActive = false;
    m_thumbnailsCropToFit = true;
    m_thumbnailsDisable = false;
    m_thumbnailsExcludeDropBox = "";
    m_thumbnailsExcludeFolders = QStringList();
    m_thumbnailsExcludeNetworkShares = true;
    m_thumbnailsExcludeNextcloud = "";
    m_thumbnailsExcludeOwnCloud = "";
    m_thumbnailsFilename = true;
    m_thumbnailsFontSize = 7;
    m_thumbnailsHighlightAnimation = QStringList() << "liftup";
    m_thumbnailsHighlightAnimationLiftUp = 15;
    m_thumbnailsIconsOnly = false;
    m_thumbnailsInactiveTransparent = true;
    m_thumbnailsMaxNumberThreads = 4;
    m_thumbnailsSameHeightVaryWidth = false;
    m_thumbnailsSize = 120;
    m_thumbnailsSmallThumbnailsKeepSmall = true;
    m_thumbnailsSpacing = 2;
    m_thumbnailsTooltip = true;
    m_thumbnailsVisibility = 0;

#ifdef Q_OS_WIN
    // these defaults are different on Windows as on Linux
    m_filedialogDevices = true;
#endif

    // the window decoration on Gnome is a bit weird
    // that's why we disable it by default
    if(qgetenv("XDG_CURRENT_DESKTOP").contains("GNOME"))
        m_interfaceWindowDecoration = false;

}


void PQCSettings::resetToDefault() {

    // table: filedialog
    setDefaultForFiledialogDetailsTooltip();
    setDefaultForFiledialogDevices();
    setDefaultForFiledialogDevicesShowTmpfs();
    setDefaultForFiledialogDragDropFileviewGrid();
    setDefaultForFiledialogDragDropFileviewList();
    setDefaultForFiledialogDragDropFileviewMasonry();
    setDefaultForFiledialogDragDropPlaces();
    setDefaultForFiledialogElementPadding();
    setDefaultForFiledialogFolderContentThumbnails();
    setDefaultForFiledialogFolderContentThumbnailsAutoload();
    setDefaultForFiledialogFolderContentThumbnailsLoop();
    setDefaultForFiledialogFolderContentThumbnailsScaleCrop();
    setDefaultForFiledialogFolderContentThumbnailsSortAscending();
    setDefaultForFiledialogFolderContentThumbnailsSortBy();
    setDefaultForFiledialogFolderContentThumbnailsSpeed();
    setDefaultForFiledialogLabelsShowGrid();
    setDefaultForFiledialogLabelsShowMasonry();
    setDefaultForFiledialogLayout();
    setDefaultForFiledialogPlaces();
    setDefaultForFiledialogPlacesWidth();
    setDefaultForFiledialogPreview();
    setDefaultForFiledialogPreviewBlur();
    setDefaultForFiledialogPreviewColorIntensity();
    setDefaultForFiledialogPreviewCropToFit();
    setDefaultForFiledialogPreviewHigherResolution();
    setDefaultForFiledialogPreviewMuted();
    setDefaultForFiledialogRememberSelection();
    setDefaultForFiledialogShowHiddenFilesFolders();
    setDefaultForFiledialogSingleClickSelect();
    setDefaultForFiledialogStartupRestoreCustom();
    setDefaultForFiledialogStartupRestoreCustomFolder();
    setDefaultForFiledialogStartupRestoreHome();
    setDefaultForFiledialogStartupRestorePrevious();
    setDefaultForFiledialogThumbnails();
    setDefaultForFiledialogThumbnailsScaleCrop();
    setDefaultForFiledialogUseNativeFileDialog();
    setDefaultForFiledialogZoom();

    // table: filetypes
    setDefaultForFiletypesAnimatedControls();
    setDefaultForFiletypesAnimatedLeftRight();
    setDefaultForFiletypesAnimatedSpacePause();
    setDefaultForFiletypesArchiveAlwaysEnterAutomatically();
    setDefaultForFiletypesArchiveControls();
    setDefaultForFiletypesArchiveDontLoadMoreFilesThan();
    setDefaultForFiletypesArchiveDontLoadMoreFilesThanCount();
    setDefaultForFiletypesArchiveIgnoreLargerThan();
    setDefaultForFiletypesArchiveIgnoreLargerThanSize();
    setDefaultForFiletypesArchiveLeftRight();
    setDefaultForFiletypesArchiveViewerModeExitButton();
    setDefaultForFiletypesComicBookAlwaysEnterAutomatically();
    setDefaultForFiletypesDocumentAlwaysEnterAutomatically();
    setDefaultForFiletypesDocumentControls();
    setDefaultForFiletypesDocumentLeftRight();
    setDefaultForFiletypesDocumentViewerModeExitButton();
    setDefaultForFiletypesExternalUnrar();
    setDefaultForFiletypesLoadAppleLivePhotos();
    setDefaultForFiletypesLoadMotionPhotos();
    setDefaultForFiletypesMotionAutoPlay();
    setDefaultForFiletypesMotionPhotoPlayPause();
    setDefaultForFiletypesMotionSpacePause();
    setDefaultForFiletypesPDFQuality();
    setDefaultForFiletypesPhotoSphereArrowKeys();
    setDefaultForFiletypesPhotoSphereAutoLoad();
    setDefaultForFiletypesPhotoSphereBigButton();
    setDefaultForFiletypesPhotoSphereControls();
    setDefaultForFiletypesPhotoSpherePanOnLoad();
    setDefaultForFiletypesRAWUseEmbeddedIfAvailable();
    setDefaultForFiletypesVideoAutoplay();
    setDefaultForFiletypesVideoLeftRightJumpVideo();
    setDefaultForFiletypesVideoLoop();
    setDefaultForFiletypesVideoPreferLibmpv();
    setDefaultForFiletypesVideoSpacePause();
    setDefaultForFiletypesVideoThumbnailer();
    setDefaultForFiletypesVideoVolume();

    // table: general
    setDefaultForGeneralAutoSaveSettings();
    setDefaultForGeneralCompactSettings();
    setDefaultForGeneralDisableAllAnimations();
    setDefaultForGeneralExtensionsAllowUntrusted();
    setDefaultForGeneralExtensionsEnabled();
    setDefaultForGeneralExtensionsFloatingSetup();
    setDefaultForGeneralInterfaceVariant();
    setDefaultForGeneralVersion();

    // table: imageview
    setDefaultForImageviewAdvancedSortAscending();
    setDefaultForImageviewAdvancedSortCriteria();
    setDefaultForImageviewAdvancedSortDateCriteria();
    setDefaultForImageviewAdvancedSortQuality();
    setDefaultForImageviewAlwaysActualSize();
    setDefaultForImageviewAnimationDuration();
    setDefaultForImageviewAnimationType();
    setDefaultForImageviewCache();
    setDefaultForImageviewColorSpaceContextMenu();
    setDefaultForImageviewColorSpaceDefault();
    setDefaultForImageviewColorSpaceEnable();
    setDefaultForImageviewColorSpaceLoadEmbedded();
    setDefaultForImageviewEscapeExitArchive();
    setDefaultForImageviewEscapeExitBarcodes();
    setDefaultForImageviewEscapeExitDocument();
    setDefaultForImageviewEscapeExitFilter();
    setDefaultForImageviewEscapeExitSphere();
    setDefaultForImageviewFitInWindow();
    setDefaultForImageviewHideCursorTimeout();
    setDefaultForImageviewInterpolationDisableForSmallImages();
    setDefaultForImageviewLoopThroughFolder();
    setDefaultForImageviewMargin();
    setDefaultForImageviewMinimapSizeLevel();
    setDefaultForImageviewMirrorAnimate();
    setDefaultForImageviewMouseWheelRepeatDelay();
    setDefaultForImageviewPreloadInBackground();
    setDefaultForImageviewPreserveMirror();
    setDefaultForImageviewPreserveRotation();
    setDefaultForImageviewPreserveZoom();
    setDefaultForImageviewRememberZoomRotationMirror();
    setDefaultForImageviewResetViewAutoHideTimeout();
    setDefaultForImageviewResetViewShow();
    setDefaultForImageviewRespectDevicePixelRatio();
    setDefaultForImageviewShowMinimap();
    setDefaultForImageviewSiblingFileMaxIterations();
    setDefaultForImageviewSiblingFileMaxLevelUp();
    setDefaultForImageviewSiblingFilemaxLevelDown();
    setDefaultForImageviewSortImagesAscending();
    setDefaultForImageviewSortImagesBy();
    setDefaultForImageviewTransparencyMarker();
    setDefaultForImageviewUseMouseLeftButtonForImageMove();
    setDefaultForImageviewUseMouseWheelForImageMove();
    setDefaultForImageviewZoomMax();
    setDefaultForImageviewZoomMaxEnabled();
    setDefaultForImageviewZoomMin();
    setDefaultForImageviewZoomMinEnabled();
    setDefaultForImageviewZoomSpeed();
    setDefaultForImageviewZoomSpeedRelative();
    setDefaultForImageviewZoomToCenter();

    // table: interface
    setDefaultForInterfaceAccentColor();
    setDefaultForInterfaceAllowMultipleInstances();
    setDefaultForInterfaceBackgroundCustomOverlay();
    setDefaultForInterfaceBackgroundCustomOverlayColor();
    setDefaultForInterfaceBackgroundFullyTransparent();
    setDefaultForInterfaceBackgroundImageCenter();
    setDefaultForInterfaceBackgroundImagePath();
    setDefaultForInterfaceBackgroundImageScale();
    setDefaultForInterfaceBackgroundImageScaleCrop();
    setDefaultForInterfaceBackgroundImageScreenshot();
    setDefaultForInterfaceBackgroundImageStretch();
    setDefaultForInterfaceBackgroundImageTile();
    setDefaultForInterfaceBackgroundImageUse();
    setDefaultForInterfaceBackgroundSolid();
    setDefaultForInterfaceBlurElementsInBackground();
    setDefaultForInterfaceCloseOnEmptyBackground();
    setDefaultForInterfaceDoubleClickThreshold();
    setDefaultForInterfaceEdgeBottomAction();
    setDefaultForInterfaceEdgeLeftAction();
    setDefaultForInterfaceEdgeRightAction();
    setDefaultForInterfaceEdgeTopAction();
    setDefaultForInterfaceFlickAdjustSpeed();
    setDefaultForInterfaceFlickAdjustSpeedSpeedup();
    setDefaultForInterfaceFontBoldWeight();
    setDefaultForInterfaceFontNormalWeight();
    setDefaultForInterfaceHotEdgeSize();
    setDefaultForInterfaceKeepWindowOnTop();
    setDefaultForInterfaceLanguage();
    setDefaultForInterfaceMinimapPopout();
    setDefaultForInterfaceNavigateOnEmptyBackground();
    setDefaultForInterfaceNavigationFloating();
    setDefaultForInterfaceNotificationDistanceFromEdge();
    setDefaultForInterfaceNotificationLocation();
    setDefaultForInterfaceNotificationTryNative();
    setDefaultForInterfacePopoutAbout();
    setDefaultForInterfacePopoutAdvancedSort();
    setDefaultForInterfacePopoutChromecast();
    setDefaultForInterfacePopoutExport();
    setDefaultForInterfacePopoutFileDelete();
    setDefaultForInterfacePopoutFileDialog();
    setDefaultForInterfacePopoutFileDialogNonModal();
    setDefaultForInterfacePopoutFileRename();
    setDefaultForInterfacePopoutFilter();
    setDefaultForInterfacePopoutFind();
    setDefaultForInterfacePopoutImgur();
    setDefaultForInterfacePopoutMainMenu();
    setDefaultForInterfacePopoutMapExplorer();
    setDefaultForInterfacePopoutMapExplorerNonModal();
    setDefaultForInterfacePopoutMetadata();
    setDefaultForInterfacePopoutSettingsManager();
    setDefaultForInterfacePopoutSettingsManagerNonModal();
    setDefaultForInterfacePopoutSlideshowControls();
    setDefaultForInterfacePopoutSlideshowSetup();
    setDefaultForInterfacePopoutWhenWindowIsSmall();
    setDefaultForInterfaceQuickActions();
    setDefaultForInterfaceQuickActionsHeight();
    setDefaultForInterfaceQuickActionsItems();
    setDefaultForInterfaceRememberLastImage();
    setDefaultForInterfaceSaveWindowGeometry();
    setDefaultForInterfaceStatusInfoAutoHide();
    setDefaultForInterfaceStatusInfoAutoHideTimeout();
    setDefaultForInterfaceStatusInfoAutoHideTopEdge();
    setDefaultForInterfaceStatusInfoFontSize();
    setDefaultForInterfaceStatusInfoList();
    setDefaultForInterfaceStatusInfoManageWindow();
    setDefaultForInterfaceStatusInfoPosition();
    setDefaultForInterfaceStatusInfoShow();
    setDefaultForInterfaceStatusInfoShowImageChange();
    setDefaultForInterfaceTrayIcon();
    setDefaultForInterfaceTrayIconHideReset();
    setDefaultForInterfaceTrayIconMonochrome();
    setDefaultForInterfaceWindowButtonsAutoHide();
    setDefaultForInterfaceWindowButtonsAutoHideTimeout();
    setDefaultForInterfaceWindowButtonsAutoHideTopEdge();
    setDefaultForInterfaceWindowButtonsFollowAccentColor();
    setDefaultForInterfaceWindowButtonsItems();
    setDefaultForInterfaceWindowButtonsShow();
    setDefaultForInterfaceWindowButtonsSize();
    setDefaultForInterfaceWindowDecoration();
    setDefaultForInterfaceWindowDecorationOnEmptyBackground();
    setDefaultForInterfaceWindowMode();

    // table: mainmenu
    setDefaultForMainmenuElementHeightDynamic();
    setDefaultForMainmenuElementPosition();
    setDefaultForMainmenuElementSize();
    setDefaultForMainmenuElementWidth();
    setDefaultForMainmenuShowExternal();

    // table: mapview
    setDefaultForMapviewCurrentPosition();
    setDefaultForMapviewCurrentSize();
    setDefaultForMapviewCurrentVisible();
    setDefaultForMapviewExplorerThumbnailsScaleCrop();
    setDefaultForMapviewExplorerThumbnailsZoomLevel();

    // table: metadata
    setDefaultForMetadataAutoRotation();
    setDefaultForMetadataCopyright();
    setDefaultForMetadataDimensions();
    setDefaultForMetadataElementFloating();
    setDefaultForMetadataElementHeightDynamic();
    setDefaultForMetadataElementPosition();
    setDefaultForMetadataElementSize();
    setDefaultForMetadataElementVisible();
    setDefaultForMetadataExposureTime();
    setDefaultForMetadataFLength();
    setDefaultForMetadataFNumber();
    setDefaultForMetadataFaceTagsBorder();
    setDefaultForMetadataFaceTagsBorderColor();
    setDefaultForMetadataFaceTagsBorderWidth();
    setDefaultForMetadataFaceTagsEnabled();
    setDefaultForMetadataFaceTagsFontSize();
    setDefaultForMetadataFaceTagsVisibility();
    setDefaultForMetadataFileSize();
    setDefaultForMetadataFileType();
    setDefaultForMetadataFilename();
    setDefaultForMetadataFlash();
    setDefaultForMetadataGps();
    setDefaultForMetadataGpsMap();
    setDefaultForMetadataImageNumber();
    setDefaultForMetadataIso();
    setDefaultForMetadataKeywords();
    setDefaultForMetadataLightSource();
    setDefaultForMetadataLocation();
    setDefaultForMetadataMake();
    setDefaultForMetadataModel();
    setDefaultForMetadataSceneType();
    setDefaultForMetadataSideBar();
    setDefaultForMetadataSideBarLocation();
    setDefaultForMetadataSideBarWidth();
    setDefaultForMetadataSoftware();
    setDefaultForMetadataTime();

    // table: slideshow
    setDefaultForSlideshowHideLabels();
    setDefaultForSlideshowHideWindowButtons();
    setDefaultForSlideshowImageTransition();
    setDefaultForSlideshowIncludeSubFolders();
    setDefaultForSlideshowLoop();
    setDefaultForSlideshowMusic();
    setDefaultForSlideshowMusicFile();
    setDefaultForSlideshowMusicFiles();
    setDefaultForSlideshowMusicShuffle();
    setDefaultForSlideshowMusicVolumeVideos();
    setDefaultForSlideshowShuffle();
    setDefaultForSlideshowTime();
    setDefaultForSlideshowTypeAnimation();

    // table: thumbnails
    setDefaultForThumbnailsCache();
    setDefaultForThumbnailsCacheBaseDirDefault();
    setDefaultForThumbnailsCacheBaseDirLocation();
    setDefaultForThumbnailsCenterOnActive();
    setDefaultForThumbnailsCropToFit();
    setDefaultForThumbnailsDisable();
    setDefaultForThumbnailsExcludeDropBox();
    setDefaultForThumbnailsExcludeFolders();
    setDefaultForThumbnailsExcludeNetworkShares();
    setDefaultForThumbnailsExcludeNextcloud();
    setDefaultForThumbnailsExcludeOwnCloud();
    setDefaultForThumbnailsFilename();
    setDefaultForThumbnailsFontSize();
    setDefaultForThumbnailsHighlightAnimation();
    setDefaultForThumbnailsHighlightAnimationLiftUp();
    setDefaultForThumbnailsIconsOnly();
    setDefaultForThumbnailsInactiveTransparent();
    setDefaultForThumbnailsMaxNumberThreads();
    setDefaultForThumbnailsSameHeightVaryWidth();
    setDefaultForThumbnailsSize();
    setDefaultForThumbnailsSmallThumbnailsKeepSmall();
    setDefaultForThumbnailsSpacing();
    setDefaultForThumbnailsTooltip();
    setDefaultForThumbnailsVisibility();

}

QStringList PQCSettings::updateFromCommandLine() {

    const QStringList update = PQCNotifyCPP::get().getSettingUpdate();
    qDebug() << "update =" << update;

    if(update.length()%2 != 0)
        return {};

    // these might need some action in qml afterwards
    QStringList ret;

    const QString key = update[0];
    const QString val = update[1];

    if(key == "filedialogDetailsTooltip") {
        m_filedialogDetailsTooltip = (val.toInt()==1);
        Q_EMIT filedialogDetailsTooltipChanged();
    }
    if(key == "filedialogDevices") {
        m_filedialogDevices = (val.toInt()==1);
        Q_EMIT filedialogDevicesChanged();
    }
    if(key == "filedialogDevicesShowTmpfs") {
        m_filedialogDevicesShowTmpfs = (val.toInt()==1);
        Q_EMIT filedialogDevicesShowTmpfsChanged();
    }
    if(key == "filedialogDragDropFileviewGrid") {
        m_filedialogDragDropFileviewGrid = (val.toInt()==1);
        Q_EMIT filedialogDragDropFileviewGridChanged();
    }
    if(key == "filedialogDragDropFileviewList") {
        m_filedialogDragDropFileviewList = (val.toInt()==1);
        Q_EMIT filedialogDragDropFileviewListChanged();
    }
    if(key == "filedialogDragDropFileviewMasonry") {
        m_filedialogDragDropFileviewMasonry = (val.toInt()==1);
        Q_EMIT filedialogDragDropFileviewMasonryChanged();
    }
    if(key == "filedialogDragDropPlaces") {
        m_filedialogDragDropPlaces = (val.toInt()==1);
        Q_EMIT filedialogDragDropPlacesChanged();
    }
    if(key == "filedialogElementPadding") {
        m_filedialogElementPadding = val.toInt();
        Q_EMIT filedialogElementPaddingChanged();
    }
    if(key == "filedialogFolderContentThumbnails") {
        m_filedialogFolderContentThumbnails = (val.toInt()==1);
        Q_EMIT filedialogFolderContentThumbnailsChanged();
    }
    if(key == "filedialogFolderContentThumbnailsAutoload") {
        m_filedialogFolderContentThumbnailsAutoload = (val.toInt()==1);
        Q_EMIT filedialogFolderContentThumbnailsAutoloadChanged();
    }
    if(key == "filedialogFolderContentThumbnailsLoop") {
        m_filedialogFolderContentThumbnailsLoop = (val.toInt()==1);
        Q_EMIT filedialogFolderContentThumbnailsLoopChanged();
    }
    if(key == "filedialogFolderContentThumbnailsScaleCrop") {
        m_filedialogFolderContentThumbnailsScaleCrop = (val.toInt()==1);
        Q_EMIT filedialogFolderContentThumbnailsScaleCropChanged();
    }
    if(key == "filedialogFolderContentThumbnailsSortAscending") {
        m_filedialogFolderContentThumbnailsSortAscending = (val.toInt()==1);
        Q_EMIT filedialogFolderContentThumbnailsSortAscendingChanged();
    }
    if(key == "filedialogFolderContentThumbnailsSortBy") {
        m_filedialogFolderContentThumbnailsSortBy = val;
        Q_EMIT filedialogFolderContentThumbnailsSortByChanged();
    }
    if(key == "filedialogFolderContentThumbnailsSpeed") {
        m_filedialogFolderContentThumbnailsSpeed = val.toInt();
        Q_EMIT filedialogFolderContentThumbnailsSpeedChanged();
    }
    if(key == "filedialogLabelsShowGrid") {
        m_filedialogLabelsShowGrid = (val.toInt()==1);
        Q_EMIT filedialogLabelsShowGridChanged();
    }
    if(key == "filedialogLabelsShowMasonry") {
        m_filedialogLabelsShowMasonry = (val.toInt()==1);
        Q_EMIT filedialogLabelsShowMasonryChanged();
    }
    if(key == "filedialogLayout") {
        m_filedialogLayout = val;
        Q_EMIT filedialogLayoutChanged();
    }
    if(key == "filedialogPlaces") {
        m_filedialogPlaces = (val.toInt()==1);
        Q_EMIT filedialogPlacesChanged();
    }
    if(key == "filedialogPlacesWidth") {
        m_filedialogPlacesWidth = val.toInt();
        Q_EMIT filedialogPlacesWidthChanged();
    }
    if(key == "filedialogPreview") {
        m_filedialogPreview = (val.toInt()==1);
        Q_EMIT filedialogPreviewChanged();
    }
    if(key == "filedialogPreviewBlur") {
        m_filedialogPreviewBlur = (val.toInt()==1);
        Q_EMIT filedialogPreviewBlurChanged();
    }
    if(key == "filedialogPreviewColorIntensity") {
        m_filedialogPreviewColorIntensity = val.toInt();
        Q_EMIT filedialogPreviewColorIntensityChanged();
    }
    if(key == "filedialogPreviewCropToFit") {
        m_filedialogPreviewCropToFit = (val.toInt()==1);
        Q_EMIT filedialogPreviewCropToFitChanged();
    }
    if(key == "filedialogPreviewHigherResolution") {
        m_filedialogPreviewHigherResolution = (val.toInt()==1);
        Q_EMIT filedialogPreviewHigherResolutionChanged();
    }
    if(key == "filedialogPreviewMuted") {
        m_filedialogPreviewMuted = (val.toInt()==1);
        Q_EMIT filedialogPreviewMutedChanged();
    }
    if(key == "filedialogRememberSelection") {
        m_filedialogRememberSelection = (val.toInt()==1);
        Q_EMIT filedialogRememberSelectionChanged();
    }
    if(key == "filedialogShowHiddenFilesFolders") {
        m_filedialogShowHiddenFilesFolders = (val.toInt()==1);
        Q_EMIT filedialogShowHiddenFilesFoldersChanged();
    }
    if(key == "filedialogSingleClickSelect") {
        m_filedialogSingleClickSelect = (val.toInt()==1);
        Q_EMIT filedialogSingleClickSelectChanged();
    }
    if(key == "filedialogStartupRestoreCustom") {
        m_filedialogStartupRestoreCustom = (val.toInt()==1);
        Q_EMIT filedialogStartupRestoreCustomChanged();
    }
    if(key == "filedialogStartupRestoreCustomFolder") {
        m_filedialogStartupRestoreCustomFolder = val;
        Q_EMIT filedialogStartupRestoreCustomFolderChanged();
    }
    if(key == "filedialogStartupRestoreHome") {
        m_filedialogStartupRestoreHome = (val.toInt()==1);
        Q_EMIT filedialogStartupRestoreHomeChanged();
    }
    if(key == "filedialogStartupRestorePrevious") {
        m_filedialogStartupRestorePrevious = (val.toInt()==1);
        Q_EMIT filedialogStartupRestorePreviousChanged();
    }
    if(key == "filedialogThumbnails") {
        m_filedialogThumbnails = (val.toInt()==1);
        Q_EMIT filedialogThumbnailsChanged();
    }
    if(key == "filedialogThumbnailsScaleCrop") {
        m_filedialogThumbnailsScaleCrop = (val.toInt()==1);
        Q_EMIT filedialogThumbnailsScaleCropChanged();
    }
    if(key == "filedialogUseNativeFileDialog") {
        m_filedialogUseNativeFileDialog = (val.toInt()==1);
        Q_EMIT filedialogUseNativeFileDialogChanged();
    }
    if(key == "filedialogZoom") {
        m_filedialogZoom = val.toInt();
        Q_EMIT filedialogZoomChanged();
    }
    if(key == "filetypesAnimatedControls") {
        m_filetypesAnimatedControls = (val.toInt()==1);
        Q_EMIT filetypesAnimatedControlsChanged();
    }
    if(key == "filetypesAnimatedLeftRight") {
        m_filetypesAnimatedLeftRight = (val.toInt()==1);
        Q_EMIT filetypesAnimatedLeftRightChanged();
    }
    if(key == "filetypesAnimatedSpacePause") {
        m_filetypesAnimatedSpacePause = (val.toInt()==1);
        Q_EMIT filetypesAnimatedSpacePauseChanged();
    }
    if(key == "filetypesArchiveAlwaysEnterAutomatically") {
        m_filetypesArchiveAlwaysEnterAutomatically = (val.toInt()==1);
        Q_EMIT filetypesArchiveAlwaysEnterAutomaticallyChanged();
    }
    if(key == "filetypesArchiveControls") {
        m_filetypesArchiveControls = (val.toInt()==1);
        Q_EMIT filetypesArchiveControlsChanged();
    }
    if(key == "filetypesArchiveDontLoadMoreFilesThan") {
        m_filetypesArchiveDontLoadMoreFilesThan = (val.toInt()==1);
        Q_EMIT filetypesArchiveDontLoadMoreFilesThanChanged();
    }
    if(key == "filetypesArchiveDontLoadMoreFilesThanCount") {
        m_filetypesArchiveDontLoadMoreFilesThanCount = val.toInt();
        Q_EMIT filetypesArchiveDontLoadMoreFilesThanCountChanged();
    }
    if(key == "filetypesArchiveIgnoreLargerThan") {
        m_filetypesArchiveIgnoreLargerThan = (val.toInt()==1);
        Q_EMIT filetypesArchiveIgnoreLargerThanChanged();
    }
    if(key == "filetypesArchiveIgnoreLargerThanSize") {
        m_filetypesArchiveIgnoreLargerThanSize = val.toInt();
        Q_EMIT filetypesArchiveIgnoreLargerThanSizeChanged();
    }
    if(key == "filetypesArchiveLeftRight") {
        m_filetypesArchiveLeftRight = (val.toInt()==1);
        Q_EMIT filetypesArchiveLeftRightChanged();
    }
    if(key == "filetypesArchiveViewerModeExitButton") {
        m_filetypesArchiveViewerModeExitButton = (val.toInt()==1);
        Q_EMIT filetypesArchiveViewerModeExitButtonChanged();
    }
    if(key == "filetypesComicBookAlwaysEnterAutomatically") {
        m_filetypesComicBookAlwaysEnterAutomatically = (val.toInt()==1);
        Q_EMIT filetypesComicBookAlwaysEnterAutomaticallyChanged();
    }
    if(key == "filetypesDocumentAlwaysEnterAutomatically") {
        m_filetypesDocumentAlwaysEnterAutomatically = (val.toInt()==1);
        Q_EMIT filetypesDocumentAlwaysEnterAutomaticallyChanged();
    }
    if(key == "filetypesDocumentControls") {
        m_filetypesDocumentControls = (val.toInt()==1);
        Q_EMIT filetypesDocumentControlsChanged();
    }
    if(key == "filetypesDocumentLeftRight") {
        m_filetypesDocumentLeftRight = (val.toInt()==1);
        Q_EMIT filetypesDocumentLeftRightChanged();
    }
    if(key == "filetypesDocumentViewerModeExitButton") {
        m_filetypesDocumentViewerModeExitButton = (val.toInt()==1);
        Q_EMIT filetypesDocumentViewerModeExitButtonChanged();
    }
    if(key == "filetypesExternalUnrar") {
        m_filetypesExternalUnrar = (val.toInt()==1);
        Q_EMIT filetypesExternalUnrarChanged();
    }
    if(key == "filetypesLoadAppleLivePhotos") {
        m_filetypesLoadAppleLivePhotos = (val.toInt()==1);
        Q_EMIT filetypesLoadAppleLivePhotosChanged();
    }
    if(key == "filetypesLoadMotionPhotos") {
        m_filetypesLoadMotionPhotos = (val.toInt()==1);
        Q_EMIT filetypesLoadMotionPhotosChanged();
    }
    if(key == "filetypesMotionAutoPlay") {
        m_filetypesMotionAutoPlay = (val.toInt()==1);
        Q_EMIT filetypesMotionAutoPlayChanged();
    }
    if(key == "filetypesMotionPhotoPlayPause") {
        m_filetypesMotionPhotoPlayPause = (val.toInt()==1);
        Q_EMIT filetypesMotionPhotoPlayPauseChanged();
    }
    if(key == "filetypesMotionSpacePause") {
        m_filetypesMotionSpacePause = (val.toInt()==1);
        Q_EMIT filetypesMotionSpacePauseChanged();
    }
    if(key == "filetypesPDFQuality") {
        m_filetypesPDFQuality = val.toInt();
        Q_EMIT filetypesPDFQualityChanged();
    }
    if(key == "filetypesPhotoSphereArrowKeys") {
        m_filetypesPhotoSphereArrowKeys = (val.toInt()==1);
        Q_EMIT filetypesPhotoSphereArrowKeysChanged();
    }
    if(key == "filetypesPhotoSphereAutoLoad") {
        m_filetypesPhotoSphereAutoLoad = (val.toInt()==1);
        Q_EMIT filetypesPhotoSphereAutoLoadChanged();
    }
    if(key == "filetypesPhotoSphereBigButton") {
        m_filetypesPhotoSphereBigButton = (val.toInt()==1);
        Q_EMIT filetypesPhotoSphereBigButtonChanged();
    }
    if(key == "filetypesPhotoSphereControls") {
        m_filetypesPhotoSphereControls = (val.toInt()==1);
        Q_EMIT filetypesPhotoSphereControlsChanged();
    }
    if(key == "filetypesPhotoSpherePanOnLoad") {
        m_filetypesPhotoSpherePanOnLoad = (val.toInt()==1);
        Q_EMIT filetypesPhotoSpherePanOnLoadChanged();
    }
    if(key == "filetypesRAWUseEmbeddedIfAvailable") {
        m_filetypesRAWUseEmbeddedIfAvailable = (val.toInt()==1);
        Q_EMIT filetypesRAWUseEmbeddedIfAvailableChanged();
    }
    if(key == "filetypesVideoAutoplay") {
        m_filetypesVideoAutoplay = (val.toInt()==1);
        Q_EMIT filetypesVideoAutoplayChanged();
    }
    if(key == "filetypesVideoLeftRightJumpVideo") {
        m_filetypesVideoLeftRightJumpVideo = (val.toInt()==1);
        Q_EMIT filetypesVideoLeftRightJumpVideoChanged();
    }
    if(key == "filetypesVideoLoop") {
        m_filetypesVideoLoop = (val.toInt()==1);
        Q_EMIT filetypesVideoLoopChanged();
    }
    if(key == "filetypesVideoPreferLibmpv") {
        m_filetypesVideoPreferLibmpv = (val.toInt()==1);
        Q_EMIT filetypesVideoPreferLibmpvChanged();
    }
    if(key == "filetypesVideoSpacePause") {
        m_filetypesVideoSpacePause = (val.toInt()==1);
        Q_EMIT filetypesVideoSpacePauseChanged();
    }
    if(key == "filetypesVideoThumbnailer") {
        m_filetypesVideoThumbnailer = val;
        Q_EMIT filetypesVideoThumbnailerChanged();
    }
    if(key == "filetypesVideoVolume") {
        m_filetypesVideoVolume = val.toInt();
        Q_EMIT filetypesVideoVolumeChanged();
    }
    if(key == "generalAutoSaveSettings") {
        m_generalAutoSaveSettings = (val.toInt()==1);
        Q_EMIT generalAutoSaveSettingsChanged();
    }
    if(key == "generalCompactSettings") {
        m_generalCompactSettings = (val.toInt()==1);
        Q_EMIT generalCompactSettingsChanged();
    }
    if(key == "generalDisableAllAnimations") {
        m_generalDisableAllAnimations = (val.toInt()==1);
        Q_EMIT generalDisableAllAnimationsChanged();
    }
    if(key == "generalExtensionsAllowUntrusted") {
        m_generalExtensionsAllowUntrusted = val.split(":://::");
        Q_EMIT generalExtensionsAllowUntrustedChanged();
    }
    if(key == "generalExtensionsEnabled") {
        m_generalExtensionsEnabled = val.split(":://::");
        Q_EMIT generalExtensionsEnabledChanged();
    }
    if(key == "generalExtensionsFloatingSetup") {
        m_generalExtensionsFloatingSetup = val.split(":://::");
        Q_EMIT generalExtensionsFloatingSetupChanged();
    }
    if(key == "generalInterfaceVariant") {
        m_generalInterfaceVariant = val;
        Q_EMIT generalInterfaceVariantChanged();
    }
    if(key == "generalVersion") {
        m_generalVersion = val;
        Q_EMIT generalVersionChanged();
    }
    if(key == "imageviewAdvancedSortAscending") {
        m_imageviewAdvancedSortAscending = (val.toInt()==1);
        Q_EMIT imageviewAdvancedSortAscendingChanged();
    }
    if(key == "imageviewAdvancedSortCriteria") {
        m_imageviewAdvancedSortCriteria = val;
        Q_EMIT imageviewAdvancedSortCriteriaChanged();
    }
    if(key == "imageviewAdvancedSortDateCriteria") {
        m_imageviewAdvancedSortDateCriteria = val.split(":://::");
        Q_EMIT imageviewAdvancedSortDateCriteriaChanged();
    }
    if(key == "imageviewAdvancedSortQuality") {
        m_imageviewAdvancedSortQuality = val;
        Q_EMIT imageviewAdvancedSortQualityChanged();
    }
    if(key == "imageviewAlwaysActualSize") {
        m_imageviewAlwaysActualSize = (val.toInt()==1);
        Q_EMIT imageviewAlwaysActualSizeChanged();
    }
    if(key == "imageviewAnimationDuration") {
        m_imageviewAnimationDuration = val.toInt();
        Q_EMIT imageviewAnimationDurationChanged();
    }
    if(key == "imageviewAnimationType") {
        m_imageviewAnimationType = val;
        Q_EMIT imageviewAnimationTypeChanged();
    }
    if(key == "imageviewCache") {
        m_imageviewCache = val.toInt();
        Q_EMIT imageviewCacheChanged();
    }
    if(key == "imageviewColorSpaceContextMenu") {
        m_imageviewColorSpaceContextMenu = val.split(":://::");
        Q_EMIT imageviewColorSpaceContextMenuChanged();
    }
    if(key == "imageviewColorSpaceDefault") {
        m_imageviewColorSpaceDefault = val;
        Q_EMIT imageviewColorSpaceDefaultChanged();
    }
    if(key == "imageviewColorSpaceEnable") {
        m_imageviewColorSpaceEnable = (val.toInt()==1);
        Q_EMIT imageviewColorSpaceEnableChanged();
    }
    if(key == "imageviewColorSpaceLoadEmbedded") {
        m_imageviewColorSpaceLoadEmbedded = (val.toInt()==1);
        Q_EMIT imageviewColorSpaceLoadEmbeddedChanged();
    }
    if(key == "imageviewEscapeExitArchive") {
        m_imageviewEscapeExitArchive = (val.toInt()==1);
        Q_EMIT imageviewEscapeExitArchiveChanged();
    }
    if(key == "imageviewEscapeExitBarcodes") {
        m_imageviewEscapeExitBarcodes = (val.toInt()==1);
        Q_EMIT imageviewEscapeExitBarcodesChanged();
    }
    if(key == "imageviewEscapeExitDocument") {
        m_imageviewEscapeExitDocument = (val.toInt()==1);
        Q_EMIT imageviewEscapeExitDocumentChanged();
    }
    if(key == "imageviewEscapeExitFilter") {
        m_imageviewEscapeExitFilter = (val.toInt()==1);
        Q_EMIT imageviewEscapeExitFilterChanged();
    }
    if(key == "imageviewEscapeExitSphere") {
        m_imageviewEscapeExitSphere = (val.toInt()==1);
        Q_EMIT imageviewEscapeExitSphereChanged();
    }
    if(key == "imageviewFitInWindow") {
        m_imageviewFitInWindow = (val.toInt()==1);
        Q_EMIT imageviewFitInWindowChanged();
    }
    if(key == "imageviewHideCursorTimeout") {
        m_imageviewHideCursorTimeout = val.toInt();
        Q_EMIT imageviewHideCursorTimeoutChanged();
    }
    if(key == "imageviewInterpolationDisableForSmallImages") {
        m_imageviewInterpolationDisableForSmallImages = (val.toInt()==1);
        Q_EMIT imageviewInterpolationDisableForSmallImagesChanged();
    }
    if(key == "imageviewLoopThroughFolder") {
        m_imageviewLoopThroughFolder = (val.toInt()==1);
        Q_EMIT imageviewLoopThroughFolderChanged();
    }
    if(key == "imageviewMargin") {
        m_imageviewMargin = val.toInt();
        Q_EMIT imageviewMarginChanged();
    }
    if(key == "imageviewMinimapSizeLevel") {
        m_imageviewMinimapSizeLevel = val.toInt();
        Q_EMIT imageviewMinimapSizeLevelChanged();
    }
    if(key == "imageviewMirrorAnimate") {
        m_imageviewMirrorAnimate = (val.toInt()==1);
        Q_EMIT imageviewMirrorAnimateChanged();
    }
    if(key == "imageviewMouseWheelRepeatDelay") {
        m_imageviewMouseWheelRepeatDelay = val.toInt();
        Q_EMIT imageviewMouseWheelRepeatDelayChanged();
    }
    if(key == "imageviewPreloadInBackground") {
        m_imageviewPreloadInBackground = val.toInt();
        Q_EMIT imageviewPreloadInBackgroundChanged();
    }
    if(key == "imageviewPreserveMirror") {
        m_imageviewPreserveMirror = (val.toInt()==1);
        Q_EMIT imageviewPreserveMirrorChanged();
    }
    if(key == "imageviewPreserveRotation") {
        m_imageviewPreserveRotation = (val.toInt()==1);
        Q_EMIT imageviewPreserveRotationChanged();
    }
    if(key == "imageviewPreserveZoom") {
        m_imageviewPreserveZoom = (val.toInt()==1);
        Q_EMIT imageviewPreserveZoomChanged();
    }
    if(key == "imageviewRememberZoomRotationMirror") {
        m_imageviewRememberZoomRotationMirror = (val.toInt()==1);
        Q_EMIT imageviewRememberZoomRotationMirrorChanged();
    }
    if(key == "imageviewResetViewAutoHideTimeout") {
        m_imageviewResetViewAutoHideTimeout = val.toInt();
        Q_EMIT imageviewResetViewAutoHideTimeoutChanged();
    }
    if(key == "imageviewResetViewShow") {
        m_imageviewResetViewShow = (val.toInt()==1);
        Q_EMIT imageviewResetViewShowChanged();
    }
    if(key == "imageviewRespectDevicePixelRatio") {
        m_imageviewRespectDevicePixelRatio = (val.toInt()==1);
        Q_EMIT imageviewRespectDevicePixelRatioChanged();
    }
    if(key == "imageviewShowMinimap") {
        m_imageviewShowMinimap = (val.toInt()==1);
        Q_EMIT imageviewShowMinimapChanged();
    }
    if(key == "imageviewSiblingFileMaxIterations") {
        m_imageviewSiblingFileMaxIterations = val.toInt();
        Q_EMIT imageviewSiblingFileMaxIterationsChanged();
    }
    if(key == "imageviewSiblingFileMaxLevelUp") {
        m_imageviewSiblingFileMaxLevelUp = val.toInt();
        Q_EMIT imageviewSiblingFileMaxLevelUpChanged();
    }
    if(key == "imageviewSiblingFilemaxLevelDown") {
        m_imageviewSiblingFilemaxLevelDown = val.toInt();
        Q_EMIT imageviewSiblingFilemaxLevelDownChanged();
    }
    if(key == "imageviewSortImagesAscending") {
        m_imageviewSortImagesAscending = (val.toInt()==1);
        Q_EMIT imageviewSortImagesAscendingChanged();
    }
    if(key == "imageviewSortImagesBy") {
        m_imageviewSortImagesBy = val;
        Q_EMIT imageviewSortImagesByChanged();
    }
    if(key == "imageviewTransparencyMarker") {
        m_imageviewTransparencyMarker = (val.toInt()==1);
        Q_EMIT imageviewTransparencyMarkerChanged();
    }
    if(key == "imageviewUseMouseLeftButtonForImageMove") {
        m_imageviewUseMouseLeftButtonForImageMove = (val.toInt()==1);
        Q_EMIT imageviewUseMouseLeftButtonForImageMoveChanged();
    }
    if(key == "imageviewUseMouseWheelForImageMove") {
        m_imageviewUseMouseWheelForImageMove = (val.toInt()==1);
        Q_EMIT imageviewUseMouseWheelForImageMoveChanged();
    }
    if(key == "imageviewZoomMax") {
        m_imageviewZoomMax = val.toInt();
        Q_EMIT imageviewZoomMaxChanged();
    }
    if(key == "imageviewZoomMaxEnabled") {
        m_imageviewZoomMaxEnabled = (val.toInt()==1);
        Q_EMIT imageviewZoomMaxEnabledChanged();
    }
    if(key == "imageviewZoomMin") {
        m_imageviewZoomMin = val.toInt();
        Q_EMIT imageviewZoomMinChanged();
    }
    if(key == "imageviewZoomMinEnabled") {
        m_imageviewZoomMinEnabled = (val.toInt()==1);
        Q_EMIT imageviewZoomMinEnabledChanged();
    }
    if(key == "imageviewZoomSpeed") {
        m_imageviewZoomSpeed = val.toInt();
        Q_EMIT imageviewZoomSpeedChanged();
    }
    if(key == "imageviewZoomSpeedRelative") {
        m_imageviewZoomSpeedRelative = (val.toInt()==1);
        Q_EMIT imageviewZoomSpeedRelativeChanged();
    }
    if(key == "imageviewZoomToCenter") {
        m_imageviewZoomToCenter = (val.toInt()==1);
        Q_EMIT imageviewZoomToCenterChanged();
    }
    if(key == "interfaceAccentColor") {
        m_interfaceAccentColor = val;
        Q_EMIT interfaceAccentColorChanged();
    }
    if(key == "interfaceAllowMultipleInstances") {
        m_interfaceAllowMultipleInstances = (val.toInt()==1);
        Q_EMIT interfaceAllowMultipleInstancesChanged();
    }
    if(key == "interfaceBackgroundCustomOverlay") {
        m_interfaceBackgroundCustomOverlay = (val.toInt()==1);
        Q_EMIT interfaceBackgroundCustomOverlayChanged();
    }
    if(key == "interfaceBackgroundCustomOverlayColor") {
        m_interfaceBackgroundCustomOverlayColor = val;
        Q_EMIT interfaceBackgroundCustomOverlayColorChanged();
    }
    if(key == "interfaceBackgroundFullyTransparent") {
        m_interfaceBackgroundFullyTransparent = (val.toInt()==1);
        Q_EMIT interfaceBackgroundFullyTransparentChanged();
    }
    if(key == "interfaceBackgroundImageCenter") {
        m_interfaceBackgroundImageCenter = (val.toInt()==1);
        Q_EMIT interfaceBackgroundImageCenterChanged();
    }
    if(key == "interfaceBackgroundImagePath") {
        m_interfaceBackgroundImagePath = val;
        Q_EMIT interfaceBackgroundImagePathChanged();
    }
    if(key == "interfaceBackgroundImageScale") {
        m_interfaceBackgroundImageScale = (val.toInt()==1);
        Q_EMIT interfaceBackgroundImageScaleChanged();
    }
    if(key == "interfaceBackgroundImageScaleCrop") {
        m_interfaceBackgroundImageScaleCrop = (val.toInt()==1);
        Q_EMIT interfaceBackgroundImageScaleCropChanged();
    }
    if(key == "interfaceBackgroundImageScreenshot") {
        m_interfaceBackgroundImageScreenshot = (val.toInt()==1);
        Q_EMIT interfaceBackgroundImageScreenshotChanged();
    }
    if(key == "interfaceBackgroundImageStretch") {
        m_interfaceBackgroundImageStretch = (val.toInt()==1);
        Q_EMIT interfaceBackgroundImageStretchChanged();
    }
    if(key == "interfaceBackgroundImageTile") {
        m_interfaceBackgroundImageTile = (val.toInt()==1);
        Q_EMIT interfaceBackgroundImageTileChanged();
    }
    if(key == "interfaceBackgroundImageUse") {
        m_interfaceBackgroundImageUse = (val.toInt()==1);
        Q_EMIT interfaceBackgroundImageUseChanged();
    }
    if(key == "interfaceBackgroundSolid") {
        m_interfaceBackgroundSolid = (val.toInt()==1);
        Q_EMIT interfaceBackgroundSolidChanged();
    }
    if(key == "interfaceBlurElementsInBackground") {
        m_interfaceBlurElementsInBackground = (val.toInt()==1);
        Q_EMIT interfaceBlurElementsInBackgroundChanged();
    }
    if(key == "interfaceCloseOnEmptyBackground") {
        m_interfaceCloseOnEmptyBackground = (val.toInt()==1);
        Q_EMIT interfaceCloseOnEmptyBackgroundChanged();
    }
    if(key == "interfaceDoubleClickThreshold") {
        m_interfaceDoubleClickThreshold = val.toInt();
        Q_EMIT interfaceDoubleClickThresholdChanged();
    }
    if(key == "interfaceEdgeBottomAction") {
        m_interfaceEdgeBottomAction = val;
        Q_EMIT interfaceEdgeBottomActionChanged();
    }
    if(key == "interfaceEdgeLeftAction") {
        m_interfaceEdgeLeftAction = val;
        Q_EMIT interfaceEdgeLeftActionChanged();
    }
    if(key == "interfaceEdgeRightAction") {
        m_interfaceEdgeRightAction = val;
        Q_EMIT interfaceEdgeRightActionChanged();
    }
    if(key == "interfaceEdgeTopAction") {
        m_interfaceEdgeTopAction = val;
        Q_EMIT interfaceEdgeTopActionChanged();
    }
    if(key == "interfaceFlickAdjustSpeed") {
        m_interfaceFlickAdjustSpeed = (val.toInt()==1);
        Q_EMIT interfaceFlickAdjustSpeedChanged();
    }
    if(key == "interfaceFlickAdjustSpeedSpeedup") {
        m_interfaceFlickAdjustSpeedSpeedup = val.toInt();
        Q_EMIT interfaceFlickAdjustSpeedSpeedupChanged();
    }
    if(key == "interfaceFontBoldWeight") {
        m_interfaceFontBoldWeight = val.toInt();
        Q_EMIT interfaceFontBoldWeightChanged();
    }
    if(key == "interfaceFontNormalWeight") {
        m_interfaceFontNormalWeight = val.toInt();
        Q_EMIT interfaceFontNormalWeightChanged();
    }
    if(key == "interfaceHotEdgeSize") {
        m_interfaceHotEdgeSize = val.toInt();
        Q_EMIT interfaceHotEdgeSizeChanged();
    }
    if(key == "interfaceKeepWindowOnTop") {
        m_interfaceKeepWindowOnTop = (val.toInt()==1);
        Q_EMIT interfaceKeepWindowOnTopChanged();
    }
    if(key == "interfaceLanguage") {
        m_interfaceLanguage = val;
        Q_EMIT interfaceLanguageChanged();
        ret.append("interfaceLanguage");
    }
    if(key == "interfaceMinimapPopout") {
        m_interfaceMinimapPopout = (val.toInt()==1);
        Q_EMIT interfaceMinimapPopoutChanged();
    }
    if(key == "interfaceNavigateOnEmptyBackground") {
        m_interfaceNavigateOnEmptyBackground = (val.toInt()==1);
        Q_EMIT interfaceNavigateOnEmptyBackgroundChanged();
    }
    if(key == "interfaceNavigationFloating") {
        m_interfaceNavigationFloating = (val.toInt()==1);
        Q_EMIT interfaceNavigationFloatingChanged();
    }
    if(key == "interfaceNotificationDistanceFromEdge") {
        m_interfaceNotificationDistanceFromEdge = val.toInt();
        Q_EMIT interfaceNotificationDistanceFromEdgeChanged();
    }
    if(key == "interfaceNotificationLocation") {
        m_interfaceNotificationLocation = val;
        Q_EMIT interfaceNotificationLocationChanged();
    }
    if(key == "interfaceNotificationTryNative") {
        m_interfaceNotificationTryNative = (val.toInt()==1);
        Q_EMIT interfaceNotificationTryNativeChanged();
    }
    if(key == "interfacePopoutAbout") {
        m_interfacePopoutAbout = (val.toInt()==1);
        Q_EMIT interfacePopoutAboutChanged();
    }
    if(key == "interfacePopoutAdvancedSort") {
        m_interfacePopoutAdvancedSort = (val.toInt()==1);
        Q_EMIT interfacePopoutAdvancedSortChanged();
    }
    if(key == "interfacePopoutChromecast") {
        m_interfacePopoutChromecast = (val.toInt()==1);
        Q_EMIT interfacePopoutChromecastChanged();
    }
    if(key == "interfacePopoutExport") {
        m_interfacePopoutExport = (val.toInt()==1);
        Q_EMIT interfacePopoutExportChanged();
    }
    if(key == "interfacePopoutFileDelete") {
        m_interfacePopoutFileDelete = (val.toInt()==1);
        Q_EMIT interfacePopoutFileDeleteChanged();
    }
    if(key == "interfacePopoutFileDialog") {
        m_interfacePopoutFileDialog = (val.toInt()==1);
        Q_EMIT interfacePopoutFileDialogChanged();
    }
    if(key == "interfacePopoutFileDialogNonModal") {
        m_interfacePopoutFileDialogNonModal = (val.toInt()==1);
        Q_EMIT interfacePopoutFileDialogNonModalChanged();
    }
    if(key == "interfacePopoutFileRename") {
        m_interfacePopoutFileRename = (val.toInt()==1);
        Q_EMIT interfacePopoutFileRenameChanged();
    }
    if(key == "interfacePopoutFilter") {
        m_interfacePopoutFilter = (val.toInt()==1);
        Q_EMIT interfacePopoutFilterChanged();
    }
    if(key == "interfacePopoutFind") {
        m_interfacePopoutFind = (val.toInt()==1);
        Q_EMIT interfacePopoutFindChanged();
    }
    if(key == "interfacePopoutImgur") {
        m_interfacePopoutImgur = (val.toInt()==1);
        Q_EMIT interfacePopoutImgurChanged();
    }
    if(key == "interfacePopoutMainMenu") {
        m_interfacePopoutMainMenu = (val.toInt()==1);
        Q_EMIT interfacePopoutMainMenuChanged();
    }
    if(key == "interfacePopoutMapExplorer") {
        m_interfacePopoutMapExplorer = (val.toInt()==1);
        Q_EMIT interfacePopoutMapExplorerChanged();
    }
    if(key == "interfacePopoutMapExplorerNonModal") {
        m_interfacePopoutMapExplorerNonModal = (val.toInt()==1);
        Q_EMIT interfacePopoutMapExplorerNonModalChanged();
    }
    if(key == "interfacePopoutMetadata") {
        m_interfacePopoutMetadata = (val.toInt()==1);
        Q_EMIT interfacePopoutMetadataChanged();
    }
    if(key == "interfacePopoutSettingsManager") {
        m_interfacePopoutSettingsManager = (val.toInt()==1);
        Q_EMIT interfacePopoutSettingsManagerChanged();
    }
    if(key == "interfacePopoutSettingsManagerNonModal") {
        m_interfacePopoutSettingsManagerNonModal = (val.toInt()==1);
        Q_EMIT interfacePopoutSettingsManagerNonModalChanged();
    }
    if(key == "interfacePopoutSlideshowControls") {
        m_interfacePopoutSlideshowControls = (val.toInt()==1);
        Q_EMIT interfacePopoutSlideshowControlsChanged();
    }
    if(key == "interfacePopoutSlideshowSetup") {
        m_interfacePopoutSlideshowSetup = (val.toInt()==1);
        Q_EMIT interfacePopoutSlideshowSetupChanged();
    }
    if(key == "interfacePopoutWhenWindowIsSmall") {
        m_interfacePopoutWhenWindowIsSmall = (val.toInt()==1);
        Q_EMIT interfacePopoutWhenWindowIsSmallChanged();
    }
    if(key == "interfaceQuickActions") {
        m_interfaceQuickActions = (val.toInt()==1);
        Q_EMIT interfaceQuickActionsChanged();
    }
    if(key == "interfaceQuickActionsHeight") {
        m_interfaceQuickActionsHeight = val.toInt();
        Q_EMIT interfaceQuickActionsHeightChanged();
    }
    if(key == "interfaceQuickActionsItems") {
        m_interfaceQuickActionsItems = val.split(":://::");
        Q_EMIT interfaceQuickActionsItemsChanged();
    }
    if(key == "interfaceRememberLastImage") {
        m_interfaceRememberLastImage = (val.toInt()==1);
        Q_EMIT interfaceRememberLastImageChanged();
    }
    if(key == "interfaceSaveWindowGeometry") {
        m_interfaceSaveWindowGeometry = (val.toInt()==1);
        Q_EMIT interfaceSaveWindowGeometryChanged();
    }
    if(key == "interfaceStatusInfoAutoHide") {
        m_interfaceStatusInfoAutoHide = (val.toInt()==1);
        Q_EMIT interfaceStatusInfoAutoHideChanged();
    }
    if(key == "interfaceStatusInfoAutoHideTimeout") {
        m_interfaceStatusInfoAutoHideTimeout = val.toInt();
        Q_EMIT interfaceStatusInfoAutoHideTimeoutChanged();
    }
    if(key == "interfaceStatusInfoAutoHideTopEdge") {
        m_interfaceStatusInfoAutoHideTopEdge = (val.toInt()==1);
        Q_EMIT interfaceStatusInfoAutoHideTopEdgeChanged();
    }
    if(key == "interfaceStatusInfoFontSize") {
        m_interfaceStatusInfoFontSize = val.toInt();
        Q_EMIT interfaceStatusInfoFontSizeChanged();
    }
    if(key == "interfaceStatusInfoList") {
        m_interfaceStatusInfoList = val.split(":://::");
        Q_EMIT interfaceStatusInfoListChanged();
    }
    if(key == "interfaceStatusInfoManageWindow") {
        m_interfaceStatusInfoManageWindow = (val.toInt()==1);
        Q_EMIT interfaceStatusInfoManageWindowChanged();
    }
    if(key == "interfaceStatusInfoPosition") {
        m_interfaceStatusInfoPosition = val;
        Q_EMIT interfaceStatusInfoPositionChanged();
    }
    if(key == "interfaceStatusInfoShow") {
        m_interfaceStatusInfoShow = (val.toInt()==1);
        Q_EMIT interfaceStatusInfoShowChanged();
    }
    if(key == "interfaceStatusInfoShowImageChange") {
        m_interfaceStatusInfoShowImageChange = (val.toInt()==1);
        Q_EMIT interfaceStatusInfoShowImageChangeChanged();
    }
    if(key == "interfaceTrayIcon") {
        m_interfaceTrayIcon = val.toInt();
        Q_EMIT interfaceTrayIconChanged();
    }
    if(key == "interfaceTrayIconHideReset") {
        m_interfaceTrayIconHideReset = (val.toInt()==1);
        Q_EMIT interfaceTrayIconHideResetChanged();
    }
    if(key == "interfaceTrayIconMonochrome") {
        m_interfaceTrayIconMonochrome = (val.toInt()==1);
        Q_EMIT interfaceTrayIconMonochromeChanged();
    }
    if(key == "interfaceWindowButtonsAutoHide") {
        m_interfaceWindowButtonsAutoHide = (val.toInt()==1);
        Q_EMIT interfaceWindowButtonsAutoHideChanged();
    }
    if(key == "interfaceWindowButtonsAutoHideTimeout") {
        m_interfaceWindowButtonsAutoHideTimeout = val.toInt();
        Q_EMIT interfaceWindowButtonsAutoHideTimeoutChanged();
    }
    if(key == "interfaceWindowButtonsAutoHideTopEdge") {
        m_interfaceWindowButtonsAutoHideTopEdge = (val.toInt()==1);
        Q_EMIT interfaceWindowButtonsAutoHideTopEdgeChanged();
    }
    if(key == "interfaceWindowButtonsFollowAccentColor") {
        m_interfaceWindowButtonsFollowAccentColor = (val.toInt()==1);
        Q_EMIT interfaceWindowButtonsFollowAccentColorChanged();
    }
    if(key == "interfaceWindowButtonsItems") {
        m_interfaceWindowButtonsItems = val.split(":://::");
        Q_EMIT interfaceWindowButtonsItemsChanged();
    }
    if(key == "interfaceWindowButtonsShow") {
        m_interfaceWindowButtonsShow = (val.toInt()==1);
        Q_EMIT interfaceWindowButtonsShowChanged();
    }
    if(key == "interfaceWindowButtonsSize") {
        m_interfaceWindowButtonsSize = val.toInt();
        Q_EMIT interfaceWindowButtonsSizeChanged();
    }
    if(key == "interfaceWindowDecoration") {
        m_interfaceWindowDecoration = (val.toInt()==1);
        Q_EMIT interfaceWindowDecorationChanged();
    }
    if(key == "interfaceWindowDecorationOnEmptyBackground") {
        m_interfaceWindowDecorationOnEmptyBackground = (val.toInt()==1);
        Q_EMIT interfaceWindowDecorationOnEmptyBackgroundChanged();
    }
    if(key == "interfaceWindowMode") {
        m_interfaceWindowMode = (val.toInt()==1);
        Q_EMIT interfaceWindowModeChanged();
    }
    if(key == "mainmenuElementHeightDynamic") {
        m_mainmenuElementHeightDynamic = (val.toInt()==1);
        Q_EMIT mainmenuElementHeightDynamicChanged();
    }
    if(key == "mainmenuElementPosition") {
        QStringList parts = val.split(",");
        if(parts.length() != 2)
            return ret;
        m_mainmenuElementPosition = QPoint(parts[0].toInt(), parts[1].toInt());
        Q_EMIT mainmenuElementPositionChanged();
    }
    if(key == "mainmenuElementSize") {
        QStringList parts = val.split(",");
        if(parts.length() != 2)
            return ret;
        m_mainmenuElementSize = QSize(parts[0].toInt(), parts[1].toInt());
        Q_EMIT mainmenuElementSizeChanged();
    }
    if(key == "mainmenuElementWidth") {
        m_mainmenuElementWidth = val.toInt();
        Q_EMIT mainmenuElementWidthChanged();
    }
    if(key == "mainmenuShowExternal") {
        m_mainmenuShowExternal = (val.toInt()==1);
        Q_EMIT mainmenuShowExternalChanged();
    }
    if(key == "mapviewCurrentPosition") {
        QStringList parts = val.split(",");
        if(parts.length() != 2)
            return ret;
        m_mapviewCurrentPosition = QPoint(parts[0].toInt(), parts[1].toInt());
        Q_EMIT mapviewCurrentPositionChanged();
    }
    if(key == "mapviewCurrentSize") {
        QStringList parts = val.split(",");
        if(parts.length() != 2)
            return ret;
        m_mapviewCurrentSize = QSize(parts[0].toInt(), parts[1].toInt());
        Q_EMIT mapviewCurrentSizeChanged();
    }
    if(key == "mapviewCurrentVisible") {
        m_mapviewCurrentVisible = (val.toInt()==1);
        Q_EMIT mapviewCurrentVisibleChanged();
    }
    if(key == "mapviewExplorerThumbnailsScaleCrop") {
        m_mapviewExplorerThumbnailsScaleCrop = (val.toInt()==1);
        Q_EMIT mapviewExplorerThumbnailsScaleCropChanged();
    }
    if(key == "mapviewExplorerThumbnailsZoomLevel") {
        m_mapviewExplorerThumbnailsZoomLevel = val.toInt();
        Q_EMIT mapviewExplorerThumbnailsZoomLevelChanged();
    }
    if(key == "metadataAutoRotation") {
        m_metadataAutoRotation = (val.toInt()==1);
        Q_EMIT metadataAutoRotationChanged();
    }
    if(key == "metadataCopyright") {
        m_metadataCopyright = (val.toInt()==1);
        Q_EMIT metadataCopyrightChanged();
    }
    if(key == "metadataDimensions") {
        m_metadataDimensions = (val.toInt()==1);
        Q_EMIT metadataDimensionsChanged();
    }
    if(key == "metadataElementFloating") {
        m_metadataElementFloating = (val.toInt()==1);
        Q_EMIT metadataElementFloatingChanged();
    }
    if(key == "metadataElementHeightDynamic") {
        m_metadataElementHeightDynamic = (val.toInt()==1);
        Q_EMIT metadataElementHeightDynamicChanged();
    }
    if(key == "metadataElementPosition") {
        QStringList parts = val.split(",");
        if(parts.length() != 2)
            return ret;
        m_metadataElementPosition = QPoint(parts[0].toInt(), parts[1].toInt());
        Q_EMIT metadataElementPositionChanged();
    }
    if(key == "metadataElementSize") {
        QStringList parts = val.split(",");
        if(parts.length() != 2)
            return ret;
        m_metadataElementSize = QSize(parts[0].toInt(), parts[1].toInt());
        Q_EMIT metadataElementSizeChanged();
    }
    if(key == "metadataElementVisible") {
        m_metadataElementVisible = (val.toInt()==1);
        Q_EMIT metadataElementVisibleChanged();
    }
    if(key == "metadataExposureTime") {
        m_metadataExposureTime = (val.toInt()==1);
        Q_EMIT metadataExposureTimeChanged();
    }
    if(key == "metadataFLength") {
        m_metadataFLength = (val.toInt()==1);
        Q_EMIT metadataFLengthChanged();
    }
    if(key == "metadataFNumber") {
        m_metadataFNumber = (val.toInt()==1);
        Q_EMIT metadataFNumberChanged();
    }
    if(key == "metadataFaceTagsBorder") {
        m_metadataFaceTagsBorder = (val.toInt()==1);
        Q_EMIT metadataFaceTagsBorderChanged();
    }
    if(key == "metadataFaceTagsBorderColor") {
        m_metadataFaceTagsBorderColor = val;
        Q_EMIT metadataFaceTagsBorderColorChanged();
    }
    if(key == "metadataFaceTagsBorderWidth") {
        m_metadataFaceTagsBorderWidth = val.toInt();
        Q_EMIT metadataFaceTagsBorderWidthChanged();
    }
    if(key == "metadataFaceTagsEnabled") {
        m_metadataFaceTagsEnabled = (val.toInt()==1);
        Q_EMIT metadataFaceTagsEnabledChanged();
    }
    if(key == "metadataFaceTagsFontSize") {
        m_metadataFaceTagsFontSize = val.toInt();
        Q_EMIT metadataFaceTagsFontSizeChanged();
    }
    if(key == "metadataFaceTagsVisibility") {
        m_metadataFaceTagsVisibility = val.toInt();
        Q_EMIT metadataFaceTagsVisibilityChanged();
    }
    if(key == "metadataFileSize") {
        m_metadataFileSize = (val.toInt()==1);
        Q_EMIT metadataFileSizeChanged();
    }
    if(key == "metadataFileType") {
        m_metadataFileType = (val.toInt()==1);
        Q_EMIT metadataFileTypeChanged();
    }
    if(key == "metadataFilename") {
        m_metadataFilename = (val.toInt()==1);
        Q_EMIT metadataFilenameChanged();
    }
    if(key == "metadataFlash") {
        m_metadataFlash = (val.toInt()==1);
        Q_EMIT metadataFlashChanged();
    }
    if(key == "metadataGps") {
        m_metadataGps = (val.toInt()==1);
        Q_EMIT metadataGpsChanged();
    }
    if(key == "metadataGpsMap") {
        m_metadataGpsMap = val;
        Q_EMIT metadataGpsMapChanged();
    }
    if(key == "metadataImageNumber") {
        m_metadataImageNumber = (val.toInt()==1);
        Q_EMIT metadataImageNumberChanged();
    }
    if(key == "metadataIso") {
        m_metadataIso = (val.toInt()==1);
        Q_EMIT metadataIsoChanged();
    }
    if(key == "metadataKeywords") {
        m_metadataKeywords = (val.toInt()==1);
        Q_EMIT metadataKeywordsChanged();
    }
    if(key == "metadataLightSource") {
        m_metadataLightSource = (val.toInt()==1);
        Q_EMIT metadataLightSourceChanged();
    }
    if(key == "metadataLocation") {
        m_metadataLocation = (val.toInt()==1);
        Q_EMIT metadataLocationChanged();
    }
    if(key == "metadataMake") {
        m_metadataMake = (val.toInt()==1);
        Q_EMIT metadataMakeChanged();
    }
    if(key == "metadataModel") {
        m_metadataModel = (val.toInt()==1);
        Q_EMIT metadataModelChanged();
    }
    if(key == "metadataSceneType") {
        m_metadataSceneType = (val.toInt()==1);
        Q_EMIT metadataSceneTypeChanged();
    }
    if(key == "metadataSideBar") {
        m_metadataSideBar = (val.toInt()==1);
        Q_EMIT metadataSideBarChanged();
    }
    if(key == "metadataSideBarLocation") {
        m_metadataSideBarLocation = val;
        Q_EMIT metadataSideBarLocationChanged();
    }
    if(key == "metadataSideBarWidth") {
        m_metadataSideBarWidth = val.toInt();
        Q_EMIT metadataSideBarWidthChanged();
    }
    if(key == "metadataSoftware") {
        m_metadataSoftware = (val.toInt()==1);
        Q_EMIT metadataSoftwareChanged();
    }
    if(key == "metadataTime") {
        m_metadataTime = (val.toInt()==1);
        Q_EMIT metadataTimeChanged();
    }
    if(key == "slideshowHideLabels") {
        m_slideshowHideLabels = (val.toInt()==1);
        Q_EMIT slideshowHideLabelsChanged();
    }
    if(key == "slideshowHideWindowButtons") {
        m_slideshowHideWindowButtons = (val.toInt()==1);
        Q_EMIT slideshowHideWindowButtonsChanged();
    }
    if(key == "slideshowImageTransition") {
        m_slideshowImageTransition = val.toInt();
        Q_EMIT slideshowImageTransitionChanged();
    }
    if(key == "slideshowIncludeSubFolders") {
        m_slideshowIncludeSubFolders = (val.toInt()==1);
        Q_EMIT slideshowIncludeSubFoldersChanged();
    }
    if(key == "slideshowLoop") {
        m_slideshowLoop = (val.toInt()==1);
        Q_EMIT slideshowLoopChanged();
    }
    if(key == "slideshowMusic") {
        m_slideshowMusic = (val.toInt()==1);
        Q_EMIT slideshowMusicChanged();
    }
    if(key == "slideshowMusicFile") {
        m_slideshowMusicFile = val;
        Q_EMIT slideshowMusicFileChanged();
    }
    if(key == "slideshowMusicFiles") {
        m_slideshowMusicFiles = val.split(":://::");
        Q_EMIT slideshowMusicFilesChanged();
    }
    if(key == "slideshowMusicShuffle") {
        m_slideshowMusicShuffle = (val.toInt()==1);
        Q_EMIT slideshowMusicShuffleChanged();
    }
    if(key == "slideshowMusicVolumeVideos") {
        m_slideshowMusicVolumeVideos = val.toInt();
        Q_EMIT slideshowMusicVolumeVideosChanged();
    }
    if(key == "slideshowShuffle") {
        m_slideshowShuffle = (val.toInt()==1);
        Q_EMIT slideshowShuffleChanged();
    }
    if(key == "slideshowTime") {
        m_slideshowTime = val.toInt();
        Q_EMIT slideshowTimeChanged();
    }
    if(key == "slideshowTypeAnimation") {
        m_slideshowTypeAnimation = val;
        Q_EMIT slideshowTypeAnimationChanged();
    }
    if(key == "thumbnailsCache") {
        m_thumbnailsCache = (val.toInt()==1);
        Q_EMIT thumbnailsCacheChanged();
    }
    if(key == "thumbnailsCacheBaseDirDefault") {
        m_thumbnailsCacheBaseDirDefault = (val.toInt()==1);
        Q_EMIT thumbnailsCacheBaseDirDefaultChanged();
    }
    if(key == "thumbnailsCacheBaseDirLocation") {
        m_thumbnailsCacheBaseDirLocation = val;
        Q_EMIT thumbnailsCacheBaseDirLocationChanged();
    }
    if(key == "thumbnailsCenterOnActive") {
        m_thumbnailsCenterOnActive = (val.toInt()==1);
        Q_EMIT thumbnailsCenterOnActiveChanged();
    }
    if(key == "thumbnailsCropToFit") {
        m_thumbnailsCropToFit = (val.toInt()==1);
        Q_EMIT thumbnailsCropToFitChanged();
    }
    if(key == "thumbnailsDisable") {
        m_thumbnailsDisable = (val.toInt()==1);
        Q_EMIT thumbnailsDisableChanged();
    }
    if(key == "thumbnailsExcludeDropBox") {
        m_thumbnailsExcludeDropBox = val;
        Q_EMIT thumbnailsExcludeDropBoxChanged();
    }
    if(key == "thumbnailsExcludeFolders") {
        m_thumbnailsExcludeFolders = val.split(":://::");
        Q_EMIT thumbnailsExcludeFoldersChanged();
    }
    if(key == "thumbnailsExcludeNetworkShares") {
        m_thumbnailsExcludeNetworkShares = (val.toInt()==1);
        Q_EMIT thumbnailsExcludeNetworkSharesChanged();
    }
    if(key == "thumbnailsExcludeNextcloud") {
        m_thumbnailsExcludeNextcloud = val;
        Q_EMIT thumbnailsExcludeNextcloudChanged();
    }
    if(key == "thumbnailsExcludeOwnCloud") {
        m_thumbnailsExcludeOwnCloud = val;
        Q_EMIT thumbnailsExcludeOwnCloudChanged();
    }
    if(key == "thumbnailsFilename") {
        m_thumbnailsFilename = (val.toInt()==1);
        Q_EMIT thumbnailsFilenameChanged();
    }
    if(key == "thumbnailsFontSize") {
        m_thumbnailsFontSize = val.toInt();
        Q_EMIT thumbnailsFontSizeChanged();
    }
    if(key == "thumbnailsHighlightAnimation") {
        m_thumbnailsHighlightAnimation = val.split(":://::");
        Q_EMIT thumbnailsHighlightAnimationChanged();
    }
    if(key == "thumbnailsHighlightAnimationLiftUp") {
        m_thumbnailsHighlightAnimationLiftUp = val.toInt();
        Q_EMIT thumbnailsHighlightAnimationLiftUpChanged();
    }
    if(key == "thumbnailsIconsOnly") {
        m_thumbnailsIconsOnly = (val.toInt()==1);
        Q_EMIT thumbnailsIconsOnlyChanged();
    }
    if(key == "thumbnailsInactiveTransparent") {
        m_thumbnailsInactiveTransparent = (val.toInt()==1);
        Q_EMIT thumbnailsInactiveTransparentChanged();
    }
    if(key == "thumbnailsMaxNumberThreads") {
        m_thumbnailsMaxNumberThreads = val.toInt();
        Q_EMIT thumbnailsMaxNumberThreadsChanged();
    }
    if(key == "thumbnailsSameHeightVaryWidth") {
        m_thumbnailsSameHeightVaryWidth = (val.toInt()==1);
        Q_EMIT thumbnailsSameHeightVaryWidthChanged();
    }
    if(key == "thumbnailsSize") {
        m_thumbnailsSize = val.toInt();
        Q_EMIT thumbnailsSizeChanged();
    }
    if(key == "thumbnailsSmallThumbnailsKeepSmall") {
        m_thumbnailsSmallThumbnailsKeepSmall = (val.toInt()==1);
        Q_EMIT thumbnailsSmallThumbnailsKeepSmallChanged();
    }
    if(key == "thumbnailsSpacing") {
        m_thumbnailsSpacing = val.toInt();
        Q_EMIT thumbnailsSpacingChanged();
    }
    if(key == "thumbnailsTooltip") {
        m_thumbnailsTooltip = (val.toInt()==1);
        Q_EMIT thumbnailsTooltipChanged();
    }
    if(key == "thumbnailsVisibility") {
        m_thumbnailsVisibility = val.toInt();
        Q_EMIT thumbnailsVisibilityChanged();
    }

    return ret;

}
