%feature("docstring") PERSALYS::FunctionalChaosAnalysis
"Create a Functional chaos analysis.

See `Functional chaos <http://openturns.github.io/openturns/latest/theory/meta_modeling/functional_chaos.html>`_

Parameters
----------
name : str
    Name
designOfExperiment : :class:`~persalys.DesignOfExperiment`
    Design of experiments

Examples
--------
>>> import openturns as ot
>>> import persalys

Create the model:

>>> from math import pi
>>> ot.RandomGenerator.SetSeed(0)
>>> xi1 = persalys.Input('xi1', ot.Uniform(-pi, pi))
>>> xi2 = persalys.Input('xi2', ot.Uniform(-pi, pi))
>>> xi3 = persalys.Input('xi3', ot.Uniform(-pi, pi))
>>> y0 = persalys.Output('y0')
>>> myPhysicalModel = persalys.SymbolicPhysicalModel('myPhysicalModel', [xi1, xi2, xi3], [y0], ['sin(xi1) + 7. * (sin(xi2)) ^ 2 + 0.1 * xi3^4 * sin(xi1)'])

Create the design of experiments:

>>> aDesign = persalys.FixedDesignOfExperiment('aDesign', myPhysicalModel)
>>> inputSample = ot.LHSExperiment(myPhysicalModel.getDistribution(), 250).generate()
>>> aDesign.setOriginalInputSample(inputSample)
>>> aDesign.run()

Create the Functional Chaos Analysis:

>>> chaos = persalys.FunctionalChaosAnalysis('chaos', aDesign)
>>> chaos.setChaosDegree(6)
>>> chaos.setSparseChaos(False)
>>> chaos.setLeaveOneOutValidation(False)
>>> chaos.run()

Get the result:

>>> chaosResult = chaos.getResult()
>>> sobolResult = chaosResult.getSobolResult()"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FunctionalChaosAnalysis::getChaosDegree
"Chaos degree accessor.

Returns
-------
degree : int
    Chaos degree. It is set by default to 2"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FunctionalChaosAnalysis::setChaosDegree
"Chaos degree accessor.

Parameters
----------
degree : int
    Chaos degree"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FunctionalChaosAnalysis::getSparseChaos
"Whether it is sparse.

Returns
-------
isSparse : bool
    Whether it is sparse. By default, the chaos is not sparse"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FunctionalChaosAnalysis::setSparseChaos
"Whether it is sparse.

Parameters
----------
isSparse : bool
    Whether it is sparse"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FunctionalChaosAnalysis::getResult
"Results accessor.

Returns
-------
result : :class:`~persalys.FunctionalChaosAnalysisResult`
    Results"
