"use strict";

var helpers = require("../../helpers/helpers");

exports["Canada/Newfoundland"] = {

	"guess:by:offset" : helpers.makeTestGuess("Canada/Newfoundland", { offset: true, expect: "America/St_Johns" }),

	"guess:by:abbr" : helpers.makeTestGuess("Canada/Newfoundland", { abbr: true, expect: "America/St_Johns" }),

	"1884" : helpers.makeTestYear("Canada/Newfoundland", [
		["1884-01-01T03:30:52+00:00", "00:00:00", "NST", 12652 / 60]
	]),

	"1917" : helpers.makeTestYear("Canada/Newfoundland", [
		["1917-04-08T05:30:51+00:00", "01:59:59", "NST", 12652 / 60],
		["1917-04-08T05:30:52+00:00", "03:00:00", "NDT", 9052 / 60],
		["1917-09-17T04:30:51+00:00", "01:59:59", "NDT", 9052 / 60],
		["1917-09-17T04:30:52+00:00", "01:00:00", "NST", 12652 / 60]
	]),

	"1918" : helpers.makeTestYear("Canada/Newfoundland", [
		["1918-04-14T05:30:51+00:00", "01:59:59", "NST", 12652 / 60],
		["1918-04-14T05:30:52+00:00", "03:00:00", "NDT", 9052 / 60],
		["1918-10-27T04:30:51+00:00", "01:59:59", "NDT", 9052 / 60],
		["1918-10-27T04:30:52+00:00", "01:00:00", "NST", 12652 / 60]
	]),

	"1919" : helpers.makeTestYear("Canada/Newfoundland", [
		["1919-05-06T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1919-05-06T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1919-08-13T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1919-08-13T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1920" : helpers.makeTestYear("Canada/Newfoundland", [
		["1920-05-03T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1920-05-03T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1920-11-01T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1920-11-01T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1921" : helpers.makeTestYear("Canada/Newfoundland", [
		["1921-05-02T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1921-05-02T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1921-10-31T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1921-10-31T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1922" : helpers.makeTestYear("Canada/Newfoundland", [
		["1922-05-08T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1922-05-08T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1922-10-30T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1922-10-30T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1923" : helpers.makeTestYear("Canada/Newfoundland", [
		["1923-05-07T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1923-05-07T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1923-10-29T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1923-10-29T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1924" : helpers.makeTestYear("Canada/Newfoundland", [
		["1924-05-05T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1924-05-05T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1924-10-27T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1924-10-27T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1925" : helpers.makeTestYear("Canada/Newfoundland", [
		["1925-05-04T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1925-05-04T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1925-10-26T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1925-10-26T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1926" : helpers.makeTestYear("Canada/Newfoundland", [
		["1926-05-03T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1926-05-03T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1926-11-01T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1926-11-01T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1927" : helpers.makeTestYear("Canada/Newfoundland", [
		["1927-05-02T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1927-05-02T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1927-10-31T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1927-10-31T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1928" : helpers.makeTestYear("Canada/Newfoundland", [
		["1928-05-07T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1928-05-07T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1928-10-29T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1928-10-29T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1929" : helpers.makeTestYear("Canada/Newfoundland", [
		["1929-05-06T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1929-05-06T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1929-10-28T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1929-10-28T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1930" : helpers.makeTestYear("Canada/Newfoundland", [
		["1930-05-05T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1930-05-05T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1930-10-27T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1930-10-27T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1931" : helpers.makeTestYear("Canada/Newfoundland", [
		["1931-05-04T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1931-05-04T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1931-10-26T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1931-10-26T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1932" : helpers.makeTestYear("Canada/Newfoundland", [
		["1932-05-02T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1932-05-02T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1932-10-31T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1932-10-31T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1933" : helpers.makeTestYear("Canada/Newfoundland", [
		["1933-05-08T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1933-05-08T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1933-10-30T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1933-10-30T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1934" : helpers.makeTestYear("Canada/Newfoundland", [
		["1934-05-07T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1934-05-07T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1934-10-29T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1934-10-29T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1935" : helpers.makeTestYear("Canada/Newfoundland", [
		["1935-03-30T03:30:51+00:00", "23:59:59", "NST", 12652 / 60],
		["1935-03-30T03:30:52+00:00", "00:00:52", "NST", 210],
		["1935-05-06T02:29:59+00:00", "22:59:59", "NST", 210],
		["1935-05-06T02:30:00+00:00", "00:00:00", "NDT", 150],
		["1935-10-28T01:29:59+00:00", "22:59:59", "NDT", 150],
		["1935-10-28T01:30:00+00:00", "22:00:00", "NST", 210]
	]),

	"1936" : helpers.makeTestYear("Canada/Newfoundland", [
		["1936-05-11T03:29:59+00:00", "23:59:59", "NST", 210],
		["1936-05-11T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1936-10-05T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1936-10-05T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1937" : helpers.makeTestYear("Canada/Newfoundland", [
		["1937-05-10T03:29:59+00:00", "23:59:59", "NST", 210],
		["1937-05-10T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1937-10-04T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1937-10-04T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1938" : helpers.makeTestYear("Canada/Newfoundland", [
		["1938-05-09T03:29:59+00:00", "23:59:59", "NST", 210],
		["1938-05-09T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1938-10-03T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1938-10-03T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1939" : helpers.makeTestYear("Canada/Newfoundland", [
		["1939-05-15T03:29:59+00:00", "23:59:59", "NST", 210],
		["1939-05-15T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1939-10-02T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1939-10-02T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1940" : helpers.makeTestYear("Canada/Newfoundland", [
		["1940-05-13T03:29:59+00:00", "23:59:59", "NST", 210],
		["1940-05-13T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1940-10-07T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1940-10-07T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1941" : helpers.makeTestYear("Canada/Newfoundland", [
		["1941-05-12T03:29:59+00:00", "23:59:59", "NST", 210],
		["1941-05-12T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1941-10-06T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1941-10-06T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1942" : helpers.makeTestYear("Canada/Newfoundland", [
		["1942-05-11T03:29:59+00:00", "23:59:59", "NST", 210],
		["1942-05-11T03:30:00+00:00", "01:00:00", "NWT", 150]
	]),

	"1945" : helpers.makeTestYear("Canada/Newfoundland", [
		["1945-08-14T22:59:59+00:00", "20:29:59", "NWT", 150],
		["1945-08-14T23:00:00+00:00", "20:30:00", "NPT", 150],
		["1945-09-30T04:29:59+00:00", "01:59:59", "NPT", 150],
		["1945-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1946" : helpers.makeTestYear("Canada/Newfoundland", [
		["1946-05-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["1946-05-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1946-10-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1946-10-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1947" : helpers.makeTestYear("Canada/Newfoundland", [
		["1947-05-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["1947-05-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1947-10-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1947-10-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1948" : helpers.makeTestYear("Canada/Newfoundland", [
		["1948-05-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["1948-05-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1948-10-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1948-10-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1949" : helpers.makeTestYear("Canada/Newfoundland", [
		["1949-05-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["1949-05-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1949-10-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1949-10-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1950" : helpers.makeTestYear("Canada/Newfoundland", [
		["1950-05-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["1950-05-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1950-10-08T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1950-10-08T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1951" : helpers.makeTestYear("Canada/Newfoundland", [
		["1951-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1951-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1951-09-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1951-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1952" : helpers.makeTestYear("Canada/Newfoundland", [
		["1952-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1952-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1952-09-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1952-09-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1953" : helpers.makeTestYear("Canada/Newfoundland", [
		["1953-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1953-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1953-09-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1953-09-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1954" : helpers.makeTestYear("Canada/Newfoundland", [
		["1954-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1954-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1954-09-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1954-09-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1955" : helpers.makeTestYear("Canada/Newfoundland", [
		["1955-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1955-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1955-09-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1955-09-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1956" : helpers.makeTestYear("Canada/Newfoundland", [
		["1956-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1956-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1956-09-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1956-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1957" : helpers.makeTestYear("Canada/Newfoundland", [
		["1957-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1957-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1957-09-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1957-09-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1958" : helpers.makeTestYear("Canada/Newfoundland", [
		["1958-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1958-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1958-09-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1958-09-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1959" : helpers.makeTestYear("Canada/Newfoundland", [
		["1959-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1959-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1959-09-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1959-09-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1960" : helpers.makeTestYear("Canada/Newfoundland", [
		["1960-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1960-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1960-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1960-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1961" : helpers.makeTestYear("Canada/Newfoundland", [
		["1961-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1961-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1961-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1961-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1962" : helpers.makeTestYear("Canada/Newfoundland", [
		["1962-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1962-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1962-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1962-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1963" : helpers.makeTestYear("Canada/Newfoundland", [
		["1963-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1963-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1963-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1963-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1964" : helpers.makeTestYear("Canada/Newfoundland", [
		["1964-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1964-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1964-10-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1964-10-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1965" : helpers.makeTestYear("Canada/Newfoundland", [
		["1965-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1965-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1965-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1965-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1966" : helpers.makeTestYear("Canada/Newfoundland", [
		["1966-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1966-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1966-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1966-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1967" : helpers.makeTestYear("Canada/Newfoundland", [
		["1967-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1967-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1967-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1967-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1968" : helpers.makeTestYear("Canada/Newfoundland", [
		["1968-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1968-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1968-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1968-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1969" : helpers.makeTestYear("Canada/Newfoundland", [
		["1969-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1969-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1969-10-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1969-10-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1970" : helpers.makeTestYear("Canada/Newfoundland", [
		["1970-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1970-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1970-10-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1970-10-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1971" : helpers.makeTestYear("Canada/Newfoundland", [
		["1971-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1971-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1971-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1971-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1972" : helpers.makeTestYear("Canada/Newfoundland", [
		["1972-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1972-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1972-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1972-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1973" : helpers.makeTestYear("Canada/Newfoundland", [
		["1973-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1973-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1973-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1973-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1974" : helpers.makeTestYear("Canada/Newfoundland", [
		["1974-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1974-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1974-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1974-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1975" : helpers.makeTestYear("Canada/Newfoundland", [
		["1975-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1975-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1975-10-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1975-10-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1976" : helpers.makeTestYear("Canada/Newfoundland", [
		["1976-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1976-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1976-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1976-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1977" : helpers.makeTestYear("Canada/Newfoundland", [
		["1977-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1977-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1977-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1977-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1978" : helpers.makeTestYear("Canada/Newfoundland", [
		["1978-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1978-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1978-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1978-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1979" : helpers.makeTestYear("Canada/Newfoundland", [
		["1979-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1979-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1979-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1979-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1980" : helpers.makeTestYear("Canada/Newfoundland", [
		["1980-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1980-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1980-10-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1980-10-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1981" : helpers.makeTestYear("Canada/Newfoundland", [
		["1981-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1981-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1981-10-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1981-10-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1982" : helpers.makeTestYear("Canada/Newfoundland", [
		["1982-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1982-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1982-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1982-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1983" : helpers.makeTestYear("Canada/Newfoundland", [
		["1983-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1983-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1983-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1983-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1984" : helpers.makeTestYear("Canada/Newfoundland", [
		["1984-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1984-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1984-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1984-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1985" : helpers.makeTestYear("Canada/Newfoundland", [
		["1985-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1985-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1985-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1985-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1986" : helpers.makeTestYear("Canada/Newfoundland", [
		["1986-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1986-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1986-10-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1986-10-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1987" : helpers.makeTestYear("Canada/Newfoundland", [
		["1987-04-05T03:30:59+00:00", "00:00:59", "NST", 210],
		["1987-04-05T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1987-10-25T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1987-10-25T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1988" : helpers.makeTestYear("Canada/Newfoundland", [
		["1988-04-03T03:30:59+00:00", "00:00:59", "NST", 210],
		["1988-04-03T03:31:00+00:00", "02:01:00", "NDDT", 90],
		["1988-10-30T01:30:59+00:00", "00:00:59", "NDDT", 90],
		["1988-10-30T01:31:00+00:00", "22:01:00", "NST", 210]
	]),

	"1989" : helpers.makeTestYear("Canada/Newfoundland", [
		["1989-04-02T03:30:59+00:00", "00:00:59", "NST", 210],
		["1989-04-02T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1989-10-29T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1989-10-29T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1990" : helpers.makeTestYear("Canada/Newfoundland", [
		["1990-04-01T03:30:59+00:00", "00:00:59", "NST", 210],
		["1990-04-01T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1990-10-28T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1990-10-28T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1991" : helpers.makeTestYear("Canada/Newfoundland", [
		["1991-04-07T03:30:59+00:00", "00:00:59", "NST", 210],
		["1991-04-07T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1991-10-27T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1991-10-27T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1992" : helpers.makeTestYear("Canada/Newfoundland", [
		["1992-04-05T03:30:59+00:00", "00:00:59", "NST", 210],
		["1992-04-05T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1992-10-25T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1992-10-25T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1993" : helpers.makeTestYear("Canada/Newfoundland", [
		["1993-04-04T03:30:59+00:00", "00:00:59", "NST", 210],
		["1993-04-04T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1993-10-31T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1993-10-31T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1994" : helpers.makeTestYear("Canada/Newfoundland", [
		["1994-04-03T03:30:59+00:00", "00:00:59", "NST", 210],
		["1994-04-03T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1994-10-30T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1994-10-30T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1995" : helpers.makeTestYear("Canada/Newfoundland", [
		["1995-04-02T03:30:59+00:00", "00:00:59", "NST", 210],
		["1995-04-02T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1995-10-29T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1995-10-29T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1996" : helpers.makeTestYear("Canada/Newfoundland", [
		["1996-04-07T03:30:59+00:00", "00:00:59", "NST", 210],
		["1996-04-07T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1996-10-27T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1996-10-27T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1997" : helpers.makeTestYear("Canada/Newfoundland", [
		["1997-04-06T03:30:59+00:00", "00:00:59", "NST", 210],
		["1997-04-06T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1997-10-26T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1997-10-26T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1998" : helpers.makeTestYear("Canada/Newfoundland", [
		["1998-04-05T03:30:59+00:00", "00:00:59", "NST", 210],
		["1998-04-05T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1998-10-25T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1998-10-25T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1999" : helpers.makeTestYear("Canada/Newfoundland", [
		["1999-04-04T03:30:59+00:00", "00:00:59", "NST", 210],
		["1999-04-04T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1999-10-31T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1999-10-31T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2000" : helpers.makeTestYear("Canada/Newfoundland", [
		["2000-04-02T03:30:59+00:00", "00:00:59", "NST", 210],
		["2000-04-02T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2000-10-29T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2000-10-29T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2001" : helpers.makeTestYear("Canada/Newfoundland", [
		["2001-04-01T03:30:59+00:00", "00:00:59", "NST", 210],
		["2001-04-01T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2001-10-28T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2001-10-28T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2002" : helpers.makeTestYear("Canada/Newfoundland", [
		["2002-04-07T03:30:59+00:00", "00:00:59", "NST", 210],
		["2002-04-07T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2002-10-27T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2002-10-27T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2003" : helpers.makeTestYear("Canada/Newfoundland", [
		["2003-04-06T03:30:59+00:00", "00:00:59", "NST", 210],
		["2003-04-06T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2003-10-26T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2003-10-26T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2004" : helpers.makeTestYear("Canada/Newfoundland", [
		["2004-04-04T03:30:59+00:00", "00:00:59", "NST", 210],
		["2004-04-04T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2004-10-31T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2004-10-31T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2005" : helpers.makeTestYear("Canada/Newfoundland", [
		["2005-04-03T03:30:59+00:00", "00:00:59", "NST", 210],
		["2005-04-03T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2005-10-30T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2005-10-30T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2006" : helpers.makeTestYear("Canada/Newfoundland", [
		["2006-04-02T03:30:59+00:00", "00:00:59", "NST", 210],
		["2006-04-02T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2006-10-29T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2006-10-29T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2007" : helpers.makeTestYear("Canada/Newfoundland", [
		["2007-03-11T03:30:59+00:00", "00:00:59", "NST", 210],
		["2007-03-11T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2007-11-04T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2007-11-04T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2008" : helpers.makeTestYear("Canada/Newfoundland", [
		["2008-03-09T03:30:59+00:00", "00:00:59", "NST", 210],
		["2008-03-09T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2008-11-02T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2008-11-02T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2009" : helpers.makeTestYear("Canada/Newfoundland", [
		["2009-03-08T03:30:59+00:00", "00:00:59", "NST", 210],
		["2009-03-08T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2009-11-01T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2009-11-01T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2010" : helpers.makeTestYear("Canada/Newfoundland", [
		["2010-03-14T03:30:59+00:00", "00:00:59", "NST", 210],
		["2010-03-14T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2010-11-07T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2010-11-07T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2011" : helpers.makeTestYear("Canada/Newfoundland", [
		["2011-03-13T03:30:59+00:00", "00:00:59", "NST", 210],
		["2011-03-13T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2011-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2011-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2012" : helpers.makeTestYear("Canada/Newfoundland", [
		["2012-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2012-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2012-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2012-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2013" : helpers.makeTestYear("Canada/Newfoundland", [
		["2013-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2013-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2013-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2013-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2014" : helpers.makeTestYear("Canada/Newfoundland", [
		["2014-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2014-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2014-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2014-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2015" : helpers.makeTestYear("Canada/Newfoundland", [
		["2015-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2015-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2015-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2015-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2016" : helpers.makeTestYear("Canada/Newfoundland", [
		["2016-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2016-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2016-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2016-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2017" : helpers.makeTestYear("Canada/Newfoundland", [
		["2017-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2017-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2017-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2017-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2018" : helpers.makeTestYear("Canada/Newfoundland", [
		["2018-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2018-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2018-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2018-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2019" : helpers.makeTestYear("Canada/Newfoundland", [
		["2019-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2019-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2019-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2019-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2020" : helpers.makeTestYear("Canada/Newfoundland", [
		["2020-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2020-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2020-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2020-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2021" : helpers.makeTestYear("Canada/Newfoundland", [
		["2021-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2021-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2021-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2021-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2022" : helpers.makeTestYear("Canada/Newfoundland", [
		["2022-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2022-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2022-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2022-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2023" : helpers.makeTestYear("Canada/Newfoundland", [
		["2023-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2023-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2023-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2023-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2024" : helpers.makeTestYear("Canada/Newfoundland", [
		["2024-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2024-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2024-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2024-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2025" : helpers.makeTestYear("Canada/Newfoundland", [
		["2025-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2025-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2025-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2025-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2026" : helpers.makeTestYear("Canada/Newfoundland", [
		["2026-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2026-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2026-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2026-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2027" : helpers.makeTestYear("Canada/Newfoundland", [
		["2027-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2027-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2027-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2027-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2028" : helpers.makeTestYear("Canada/Newfoundland", [
		["2028-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2028-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2028-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2028-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2029" : helpers.makeTestYear("Canada/Newfoundland", [
		["2029-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2029-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2029-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2029-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2030" : helpers.makeTestYear("Canada/Newfoundland", [
		["2030-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2030-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2030-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2030-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2031" : helpers.makeTestYear("Canada/Newfoundland", [
		["2031-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2031-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2031-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2031-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2032" : helpers.makeTestYear("Canada/Newfoundland", [
		["2032-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2032-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2032-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2032-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2033" : helpers.makeTestYear("Canada/Newfoundland", [
		["2033-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2033-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2033-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2033-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2034" : helpers.makeTestYear("Canada/Newfoundland", [
		["2034-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2034-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2034-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2034-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2035" : helpers.makeTestYear("Canada/Newfoundland", [
		["2035-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2035-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2035-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2035-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2036" : helpers.makeTestYear("Canada/Newfoundland", [
		["2036-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2036-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2036-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2036-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2037" : helpers.makeTestYear("Canada/Newfoundland", [
		["2037-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2037-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2037-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2037-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2038" : helpers.makeTestYear("Canada/Newfoundland", [
		["2038-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2038-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2038-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2038-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2039" : helpers.makeTestYear("Canada/Newfoundland", [
		["2039-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2039-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2039-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2039-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2040" : helpers.makeTestYear("Canada/Newfoundland", [
		["2040-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2040-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2040-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2040-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2041" : helpers.makeTestYear("Canada/Newfoundland", [
		["2041-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2041-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2041-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2041-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2042" : helpers.makeTestYear("Canada/Newfoundland", [
		["2042-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2042-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2042-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2042-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2043" : helpers.makeTestYear("Canada/Newfoundland", [
		["2043-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2043-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2043-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2043-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2044" : helpers.makeTestYear("Canada/Newfoundland", [
		["2044-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2044-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2044-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2044-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2045" : helpers.makeTestYear("Canada/Newfoundland", [
		["2045-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2045-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2045-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2045-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2046" : helpers.makeTestYear("Canada/Newfoundland", [
		["2046-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2046-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2046-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2046-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2047" : helpers.makeTestYear("Canada/Newfoundland", [
		["2047-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2047-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2047-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2047-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2048" : helpers.makeTestYear("Canada/Newfoundland", [
		["2048-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2048-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2048-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2048-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2049" : helpers.makeTestYear("Canada/Newfoundland", [
		["2049-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2049-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2049-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2049-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2050" : helpers.makeTestYear("Canada/Newfoundland", [
		["2050-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2050-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2050-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2050-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2051" : helpers.makeTestYear("Canada/Newfoundland", [
		["2051-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2051-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2051-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2051-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2052" : helpers.makeTestYear("Canada/Newfoundland", [
		["2052-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2052-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2052-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2052-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2053" : helpers.makeTestYear("Canada/Newfoundland", [
		["2053-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2053-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2053-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2053-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2054" : helpers.makeTestYear("Canada/Newfoundland", [
		["2054-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2054-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2054-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2054-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2055" : helpers.makeTestYear("Canada/Newfoundland", [
		["2055-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2055-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2055-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2055-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2056" : helpers.makeTestYear("Canada/Newfoundland", [
		["2056-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2056-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2056-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2056-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2057" : helpers.makeTestYear("Canada/Newfoundland", [
		["2057-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2057-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2057-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2057-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2058" : helpers.makeTestYear("Canada/Newfoundland", [
		["2058-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2058-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2058-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2058-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2059" : helpers.makeTestYear("Canada/Newfoundland", [
		["2059-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2059-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2059-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2059-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2060" : helpers.makeTestYear("Canada/Newfoundland", [
		["2060-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2060-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2060-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2060-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2061" : helpers.makeTestYear("Canada/Newfoundland", [
		["2061-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2061-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2061-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2061-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2062" : helpers.makeTestYear("Canada/Newfoundland", [
		["2062-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2062-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2062-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2062-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2063" : helpers.makeTestYear("Canada/Newfoundland", [
		["2063-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2063-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2063-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2063-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2064" : helpers.makeTestYear("Canada/Newfoundland", [
		["2064-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2064-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2064-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2064-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2065" : helpers.makeTestYear("Canada/Newfoundland", [
		["2065-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2065-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2065-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2065-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2066" : helpers.makeTestYear("Canada/Newfoundland", [
		["2066-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2066-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2066-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2066-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2067" : helpers.makeTestYear("Canada/Newfoundland", [
		["2067-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2067-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2067-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2067-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2068" : helpers.makeTestYear("Canada/Newfoundland", [
		["2068-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2068-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2068-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2068-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2069" : helpers.makeTestYear("Canada/Newfoundland", [
		["2069-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2069-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2069-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2069-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2070" : helpers.makeTestYear("Canada/Newfoundland", [
		["2070-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2070-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2070-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2070-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2071" : helpers.makeTestYear("Canada/Newfoundland", [
		["2071-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2071-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2071-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2071-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2072" : helpers.makeTestYear("Canada/Newfoundland", [
		["2072-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2072-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2072-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2072-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2073" : helpers.makeTestYear("Canada/Newfoundland", [
		["2073-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2073-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2073-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2073-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2074" : helpers.makeTestYear("Canada/Newfoundland", [
		["2074-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2074-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2074-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2074-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2075" : helpers.makeTestYear("Canada/Newfoundland", [
		["2075-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2075-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2075-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2075-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2076" : helpers.makeTestYear("Canada/Newfoundland", [
		["2076-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2076-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2076-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2076-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2077" : helpers.makeTestYear("Canada/Newfoundland", [
		["2077-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2077-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2077-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2077-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2078" : helpers.makeTestYear("Canada/Newfoundland", [
		["2078-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2078-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2078-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2078-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2079" : helpers.makeTestYear("Canada/Newfoundland", [
		["2079-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2079-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2079-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2079-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2080" : helpers.makeTestYear("Canada/Newfoundland", [
		["2080-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2080-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2080-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2080-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2081" : helpers.makeTestYear("Canada/Newfoundland", [
		["2081-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2081-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2081-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2081-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2082" : helpers.makeTestYear("Canada/Newfoundland", [
		["2082-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2082-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2082-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2082-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2083" : helpers.makeTestYear("Canada/Newfoundland", [
		["2083-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2083-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2083-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2083-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2084" : helpers.makeTestYear("Canada/Newfoundland", [
		["2084-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2084-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2084-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2084-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2085" : helpers.makeTestYear("Canada/Newfoundland", [
		["2085-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2085-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2085-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2085-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2086" : helpers.makeTestYear("Canada/Newfoundland", [
		["2086-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2086-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2086-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2086-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2087" : helpers.makeTestYear("Canada/Newfoundland", [
		["2087-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2087-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2087-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2087-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2088" : helpers.makeTestYear("Canada/Newfoundland", [
		["2088-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2088-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2088-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2088-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2089" : helpers.makeTestYear("Canada/Newfoundland", [
		["2089-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2089-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2089-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2089-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2090" : helpers.makeTestYear("Canada/Newfoundland", [
		["2090-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2090-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2090-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2090-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2091" : helpers.makeTestYear("Canada/Newfoundland", [
		["2091-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2091-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2091-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2091-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2092" : helpers.makeTestYear("Canada/Newfoundland", [
		["2092-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2092-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2092-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2092-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2093" : helpers.makeTestYear("Canada/Newfoundland", [
		["2093-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2093-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2093-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2093-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2094" : helpers.makeTestYear("Canada/Newfoundland", [
		["2094-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2094-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2094-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2094-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2095" : helpers.makeTestYear("Canada/Newfoundland", [
		["2095-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2095-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2095-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2095-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2096" : helpers.makeTestYear("Canada/Newfoundland", [
		["2096-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2096-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2096-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2096-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2097" : helpers.makeTestYear("Canada/Newfoundland", [
		["2097-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2097-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2097-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2097-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2098" : helpers.makeTestYear("Canada/Newfoundland", [
		["2098-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2098-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2098-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2098-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2099" : helpers.makeTestYear("Canada/Newfoundland", [
		["2099-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2099-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2099-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2099-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2100" : helpers.makeTestYear("Canada/Newfoundland", [
		["2100-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2100-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2100-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2100-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2101" : helpers.makeTestYear("Canada/Newfoundland", [
		["2101-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2101-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2101-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2101-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2102" : helpers.makeTestYear("Canada/Newfoundland", [
		["2102-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2102-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2102-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2102-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2103" : helpers.makeTestYear("Canada/Newfoundland", [
		["2103-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2103-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2103-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2103-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2104" : helpers.makeTestYear("Canada/Newfoundland", [
		["2104-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2104-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2104-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2104-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2105" : helpers.makeTestYear("Canada/Newfoundland", [
		["2105-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2105-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2105-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2105-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2106" : helpers.makeTestYear("Canada/Newfoundland", [
		["2106-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2106-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2106-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2106-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2107" : helpers.makeTestYear("Canada/Newfoundland", [
		["2107-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2107-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2107-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2107-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2108" : helpers.makeTestYear("Canada/Newfoundland", [
		["2108-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2108-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2108-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2108-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2109" : helpers.makeTestYear("Canada/Newfoundland", [
		["2109-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2109-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2109-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2109-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2110" : helpers.makeTestYear("Canada/Newfoundland", [
		["2110-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2110-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2110-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2110-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2111" : helpers.makeTestYear("Canada/Newfoundland", [
		["2111-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2111-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2111-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2111-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2112" : helpers.makeTestYear("Canada/Newfoundland", [
		["2112-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2112-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2112-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2112-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2113" : helpers.makeTestYear("Canada/Newfoundland", [
		["2113-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2113-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2113-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2113-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2114" : helpers.makeTestYear("Canada/Newfoundland", [
		["2114-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2114-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2114-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2114-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2115" : helpers.makeTestYear("Canada/Newfoundland", [
		["2115-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2115-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2115-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2115-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2116" : helpers.makeTestYear("Canada/Newfoundland", [
		["2116-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2116-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2116-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2116-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2117" : helpers.makeTestYear("Canada/Newfoundland", [
		["2117-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2117-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2117-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2117-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2118" : helpers.makeTestYear("Canada/Newfoundland", [
		["2118-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2118-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2118-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2118-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2119" : helpers.makeTestYear("Canada/Newfoundland", [
		["2119-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2119-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2119-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2119-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2120" : helpers.makeTestYear("Canada/Newfoundland", [
		["2120-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2120-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2120-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2120-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2121" : helpers.makeTestYear("Canada/Newfoundland", [
		["2121-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2121-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2121-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2121-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2122" : helpers.makeTestYear("Canada/Newfoundland", [
		["2122-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2122-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2122-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2122-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2123" : helpers.makeTestYear("Canada/Newfoundland", [
		["2123-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2123-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2123-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2123-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2124" : helpers.makeTestYear("Canada/Newfoundland", [
		["2124-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2124-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2124-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2124-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2125" : helpers.makeTestYear("Canada/Newfoundland", [
		["2125-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2125-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2125-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2125-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2126" : helpers.makeTestYear("Canada/Newfoundland", [
		["2126-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2126-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2126-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2126-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2127" : helpers.makeTestYear("Canada/Newfoundland", [
		["2127-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2127-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2127-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2127-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2128" : helpers.makeTestYear("Canada/Newfoundland", [
		["2128-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2128-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2128-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2128-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2129" : helpers.makeTestYear("Canada/Newfoundland", [
		["2129-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2129-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2129-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2129-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2130" : helpers.makeTestYear("Canada/Newfoundland", [
		["2130-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2130-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2130-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2130-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2131" : helpers.makeTestYear("Canada/Newfoundland", [
		["2131-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2131-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2131-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2131-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2132" : helpers.makeTestYear("Canada/Newfoundland", [
		["2132-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2132-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2132-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2132-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2133" : helpers.makeTestYear("Canada/Newfoundland", [
		["2133-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2133-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2133-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2133-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2134" : helpers.makeTestYear("Canada/Newfoundland", [
		["2134-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2134-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2134-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2134-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2135" : helpers.makeTestYear("Canada/Newfoundland", [
		["2135-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2135-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2135-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2135-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2136" : helpers.makeTestYear("Canada/Newfoundland", [
		["2136-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2136-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2136-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2136-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2137" : helpers.makeTestYear("Canada/Newfoundland", [
		["2137-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2137-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2137-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2137-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2138" : helpers.makeTestYear("Canada/Newfoundland", [
		["2138-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2138-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2138-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2138-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2139" : helpers.makeTestYear("Canada/Newfoundland", [
		["2139-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2139-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2139-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2139-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2140" : helpers.makeTestYear("Canada/Newfoundland", [
		["2140-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2140-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2140-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2140-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2141" : helpers.makeTestYear("Canada/Newfoundland", [
		["2141-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2141-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2141-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2141-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2142" : helpers.makeTestYear("Canada/Newfoundland", [
		["2142-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2142-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2142-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2142-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2143" : helpers.makeTestYear("Canada/Newfoundland", [
		["2143-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2143-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2143-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2143-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2144" : helpers.makeTestYear("Canada/Newfoundland", [
		["2144-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2144-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2144-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2144-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2145" : helpers.makeTestYear("Canada/Newfoundland", [
		["2145-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2145-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2145-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2145-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2146" : helpers.makeTestYear("Canada/Newfoundland", [
		["2146-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2146-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2146-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2146-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2147" : helpers.makeTestYear("Canada/Newfoundland", [
		["2147-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2147-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2147-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2147-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2148" : helpers.makeTestYear("Canada/Newfoundland", [
		["2148-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2148-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2148-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2148-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2149" : helpers.makeTestYear("Canada/Newfoundland", [
		["2149-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2149-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2149-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2149-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2150" : helpers.makeTestYear("Canada/Newfoundland", [
		["2150-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2150-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2150-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2150-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2151" : helpers.makeTestYear("Canada/Newfoundland", [
		["2151-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2151-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2151-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2151-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2152" : helpers.makeTestYear("Canada/Newfoundland", [
		["2152-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2152-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2152-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2152-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2153" : helpers.makeTestYear("Canada/Newfoundland", [
		["2153-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2153-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2153-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2153-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2154" : helpers.makeTestYear("Canada/Newfoundland", [
		["2154-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2154-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2154-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2154-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2155" : helpers.makeTestYear("Canada/Newfoundland", [
		["2155-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2155-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2155-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2155-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2156" : helpers.makeTestYear("Canada/Newfoundland", [
		["2156-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2156-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2156-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2156-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2157" : helpers.makeTestYear("Canada/Newfoundland", [
		["2157-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2157-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2157-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2157-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2158" : helpers.makeTestYear("Canada/Newfoundland", [
		["2158-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2158-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2158-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2158-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2159" : helpers.makeTestYear("Canada/Newfoundland", [
		["2159-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2159-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2159-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2159-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2160" : helpers.makeTestYear("Canada/Newfoundland", [
		["2160-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2160-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2160-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2160-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2161" : helpers.makeTestYear("Canada/Newfoundland", [
		["2161-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2161-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2161-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2161-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2162" : helpers.makeTestYear("Canada/Newfoundland", [
		["2162-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2162-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2162-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2162-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2163" : helpers.makeTestYear("Canada/Newfoundland", [
		["2163-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2163-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2163-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2163-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2164" : helpers.makeTestYear("Canada/Newfoundland", [
		["2164-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2164-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2164-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2164-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2165" : helpers.makeTestYear("Canada/Newfoundland", [
		["2165-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2165-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2165-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2165-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2166" : helpers.makeTestYear("Canada/Newfoundland", [
		["2166-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2166-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2166-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2166-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2167" : helpers.makeTestYear("Canada/Newfoundland", [
		["2167-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2167-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2167-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2167-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2168" : helpers.makeTestYear("Canada/Newfoundland", [
		["2168-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2168-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2168-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2168-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2169" : helpers.makeTestYear("Canada/Newfoundland", [
		["2169-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2169-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2169-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2169-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2170" : helpers.makeTestYear("Canada/Newfoundland", [
		["2170-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2170-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2170-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2170-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2171" : helpers.makeTestYear("Canada/Newfoundland", [
		["2171-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2171-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2171-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2171-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2172" : helpers.makeTestYear("Canada/Newfoundland", [
		["2172-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2172-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2172-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2172-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2173" : helpers.makeTestYear("Canada/Newfoundland", [
		["2173-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2173-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2173-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2173-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2174" : helpers.makeTestYear("Canada/Newfoundland", [
		["2174-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2174-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2174-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2174-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2175" : helpers.makeTestYear("Canada/Newfoundland", [
		["2175-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2175-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2175-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2175-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2176" : helpers.makeTestYear("Canada/Newfoundland", [
		["2176-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2176-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2176-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2176-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2177" : helpers.makeTestYear("Canada/Newfoundland", [
		["2177-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2177-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2177-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2177-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2178" : helpers.makeTestYear("Canada/Newfoundland", [
		["2178-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2178-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2178-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2178-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2179" : helpers.makeTestYear("Canada/Newfoundland", [
		["2179-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2179-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2179-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2179-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2180" : helpers.makeTestYear("Canada/Newfoundland", [
		["2180-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2180-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2180-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2180-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2181" : helpers.makeTestYear("Canada/Newfoundland", [
		["2181-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2181-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2181-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2181-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2182" : helpers.makeTestYear("Canada/Newfoundland", [
		["2182-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2182-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2182-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2182-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2183" : helpers.makeTestYear("Canada/Newfoundland", [
		["2183-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2183-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2183-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2183-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2184" : helpers.makeTestYear("Canada/Newfoundland", [
		["2184-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2184-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2184-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2184-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2185" : helpers.makeTestYear("Canada/Newfoundland", [
		["2185-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2185-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2185-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2185-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2186" : helpers.makeTestYear("Canada/Newfoundland", [
		["2186-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2186-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2186-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2186-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2187" : helpers.makeTestYear("Canada/Newfoundland", [
		["2187-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2187-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2187-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2187-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2188" : helpers.makeTestYear("Canada/Newfoundland", [
		["2188-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2188-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2188-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2188-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2189" : helpers.makeTestYear("Canada/Newfoundland", [
		["2189-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2189-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2189-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2189-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2190" : helpers.makeTestYear("Canada/Newfoundland", [
		["2190-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2190-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2190-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2190-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2191" : helpers.makeTestYear("Canada/Newfoundland", [
		["2191-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2191-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2191-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2191-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2192" : helpers.makeTestYear("Canada/Newfoundland", [
		["2192-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2192-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2192-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2192-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2193" : helpers.makeTestYear("Canada/Newfoundland", [
		["2193-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2193-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2193-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2193-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2194" : helpers.makeTestYear("Canada/Newfoundland", [
		["2194-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2194-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2194-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2194-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2195" : helpers.makeTestYear("Canada/Newfoundland", [
		["2195-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2195-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2195-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2195-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2196" : helpers.makeTestYear("Canada/Newfoundland", [
		["2196-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2196-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2196-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2196-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2197" : helpers.makeTestYear("Canada/Newfoundland", [
		["2197-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2197-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2197-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2197-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2198" : helpers.makeTestYear("Canada/Newfoundland", [
		["2198-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2198-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2198-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2198-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2199" : helpers.makeTestYear("Canada/Newfoundland", [
		["2199-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2199-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2199-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2199-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2200" : helpers.makeTestYear("Canada/Newfoundland", [
		["2200-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2200-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2200-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2200-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2201" : helpers.makeTestYear("Canada/Newfoundland", [
		["2201-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2201-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2201-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2201-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2202" : helpers.makeTestYear("Canada/Newfoundland", [
		["2202-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2202-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2202-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2202-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2203" : helpers.makeTestYear("Canada/Newfoundland", [
		["2203-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2203-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2203-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2203-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2204" : helpers.makeTestYear("Canada/Newfoundland", [
		["2204-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2204-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2204-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2204-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2205" : helpers.makeTestYear("Canada/Newfoundland", [
		["2205-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2205-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2205-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2205-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2206" : helpers.makeTestYear("Canada/Newfoundland", [
		["2206-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2206-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2206-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2206-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2207" : helpers.makeTestYear("Canada/Newfoundland", [
		["2207-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2207-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2207-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2207-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2208" : helpers.makeTestYear("Canada/Newfoundland", [
		["2208-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2208-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2208-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2208-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2209" : helpers.makeTestYear("Canada/Newfoundland", [
		["2209-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2209-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2209-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2209-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2210" : helpers.makeTestYear("Canada/Newfoundland", [
		["2210-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2210-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2210-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2210-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2211" : helpers.makeTestYear("Canada/Newfoundland", [
		["2211-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2211-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2211-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2211-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2212" : helpers.makeTestYear("Canada/Newfoundland", [
		["2212-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2212-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2212-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2212-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2213" : helpers.makeTestYear("Canada/Newfoundland", [
		["2213-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2213-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2213-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2213-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2214" : helpers.makeTestYear("Canada/Newfoundland", [
		["2214-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2214-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2214-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2214-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2215" : helpers.makeTestYear("Canada/Newfoundland", [
		["2215-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2215-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2215-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2215-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2216" : helpers.makeTestYear("Canada/Newfoundland", [
		["2216-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2216-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2216-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2216-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2217" : helpers.makeTestYear("Canada/Newfoundland", [
		["2217-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2217-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2217-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2217-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2218" : helpers.makeTestYear("Canada/Newfoundland", [
		["2218-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2218-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2218-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2218-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2219" : helpers.makeTestYear("Canada/Newfoundland", [
		["2219-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2219-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2219-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2219-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2220" : helpers.makeTestYear("Canada/Newfoundland", [
		["2220-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2220-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2220-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2220-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2221" : helpers.makeTestYear("Canada/Newfoundland", [
		["2221-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2221-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2221-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2221-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2222" : helpers.makeTestYear("Canada/Newfoundland", [
		["2222-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2222-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2222-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2222-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2223" : helpers.makeTestYear("Canada/Newfoundland", [
		["2223-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2223-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2223-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2223-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2224" : helpers.makeTestYear("Canada/Newfoundland", [
		["2224-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2224-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2224-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2224-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2225" : helpers.makeTestYear("Canada/Newfoundland", [
		["2225-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2225-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2225-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2225-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2226" : helpers.makeTestYear("Canada/Newfoundland", [
		["2226-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2226-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2226-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2226-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2227" : helpers.makeTestYear("Canada/Newfoundland", [
		["2227-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2227-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2227-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2227-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2228" : helpers.makeTestYear("Canada/Newfoundland", [
		["2228-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2228-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2228-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2228-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2229" : helpers.makeTestYear("Canada/Newfoundland", [
		["2229-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2229-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2229-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2229-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2230" : helpers.makeTestYear("Canada/Newfoundland", [
		["2230-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2230-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2230-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2230-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2231" : helpers.makeTestYear("Canada/Newfoundland", [
		["2231-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2231-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2231-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2231-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2232" : helpers.makeTestYear("Canada/Newfoundland", [
		["2232-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2232-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2232-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2232-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2233" : helpers.makeTestYear("Canada/Newfoundland", [
		["2233-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2233-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2233-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2233-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2234" : helpers.makeTestYear("Canada/Newfoundland", [
		["2234-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2234-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2234-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2234-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2235" : helpers.makeTestYear("Canada/Newfoundland", [
		["2235-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2235-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2235-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2235-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2236" : helpers.makeTestYear("Canada/Newfoundland", [
		["2236-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2236-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2236-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2236-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2237" : helpers.makeTestYear("Canada/Newfoundland", [
		["2237-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2237-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2237-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2237-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2238" : helpers.makeTestYear("Canada/Newfoundland", [
		["2238-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2238-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2238-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2238-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2239" : helpers.makeTestYear("Canada/Newfoundland", [
		["2239-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2239-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2239-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2239-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2240" : helpers.makeTestYear("Canada/Newfoundland", [
		["2240-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2240-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2240-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2240-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2241" : helpers.makeTestYear("Canada/Newfoundland", [
		["2241-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2241-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2241-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2241-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2242" : helpers.makeTestYear("Canada/Newfoundland", [
		["2242-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2242-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2242-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2242-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2243" : helpers.makeTestYear("Canada/Newfoundland", [
		["2243-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2243-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2243-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2243-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2244" : helpers.makeTestYear("Canada/Newfoundland", [
		["2244-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2244-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2244-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2244-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2245" : helpers.makeTestYear("Canada/Newfoundland", [
		["2245-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2245-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2245-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2245-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2246" : helpers.makeTestYear("Canada/Newfoundland", [
		["2246-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2246-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2246-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2246-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2247" : helpers.makeTestYear("Canada/Newfoundland", [
		["2247-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2247-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2247-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2247-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2248" : helpers.makeTestYear("Canada/Newfoundland", [
		["2248-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2248-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2248-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2248-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2249" : helpers.makeTestYear("Canada/Newfoundland", [
		["2249-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2249-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2249-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2249-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2250" : helpers.makeTestYear("Canada/Newfoundland", [
		["2250-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2250-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2250-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2250-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2251" : helpers.makeTestYear("Canada/Newfoundland", [
		["2251-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2251-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2251-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2251-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2252" : helpers.makeTestYear("Canada/Newfoundland", [
		["2252-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2252-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2252-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2252-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2253" : helpers.makeTestYear("Canada/Newfoundland", [
		["2253-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2253-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2253-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2253-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2254" : helpers.makeTestYear("Canada/Newfoundland", [
		["2254-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2254-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2254-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2254-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2255" : helpers.makeTestYear("Canada/Newfoundland", [
		["2255-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2255-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2255-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2255-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2256" : helpers.makeTestYear("Canada/Newfoundland", [
		["2256-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2256-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2256-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2256-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2257" : helpers.makeTestYear("Canada/Newfoundland", [
		["2257-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2257-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2257-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2257-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2258" : helpers.makeTestYear("Canada/Newfoundland", [
		["2258-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2258-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2258-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2258-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2259" : helpers.makeTestYear("Canada/Newfoundland", [
		["2259-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2259-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2259-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2259-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2260" : helpers.makeTestYear("Canada/Newfoundland", [
		["2260-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2260-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2260-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2260-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2261" : helpers.makeTestYear("Canada/Newfoundland", [
		["2261-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2261-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2261-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2261-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2262" : helpers.makeTestYear("Canada/Newfoundland", [
		["2262-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2262-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2262-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2262-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2263" : helpers.makeTestYear("Canada/Newfoundland", [
		["2263-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2263-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2263-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2263-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2264" : helpers.makeTestYear("Canada/Newfoundland", [
		["2264-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2264-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2264-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2264-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2265" : helpers.makeTestYear("Canada/Newfoundland", [
		["2265-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2265-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2265-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2265-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2266" : helpers.makeTestYear("Canada/Newfoundland", [
		["2266-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2266-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2266-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2266-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2267" : helpers.makeTestYear("Canada/Newfoundland", [
		["2267-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2267-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2267-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2267-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2268" : helpers.makeTestYear("Canada/Newfoundland", [
		["2268-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2268-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2268-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2268-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2269" : helpers.makeTestYear("Canada/Newfoundland", [
		["2269-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2269-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2269-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2269-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2270" : helpers.makeTestYear("Canada/Newfoundland", [
		["2270-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2270-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2270-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2270-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2271" : helpers.makeTestYear("Canada/Newfoundland", [
		["2271-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2271-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2271-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2271-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2272" : helpers.makeTestYear("Canada/Newfoundland", [
		["2272-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2272-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2272-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2272-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2273" : helpers.makeTestYear("Canada/Newfoundland", [
		["2273-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2273-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2273-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2273-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2274" : helpers.makeTestYear("Canada/Newfoundland", [
		["2274-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2274-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2274-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2274-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2275" : helpers.makeTestYear("Canada/Newfoundland", [
		["2275-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2275-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2275-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2275-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2276" : helpers.makeTestYear("Canada/Newfoundland", [
		["2276-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2276-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2276-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2276-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2277" : helpers.makeTestYear("Canada/Newfoundland", [
		["2277-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2277-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2277-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2277-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2278" : helpers.makeTestYear("Canada/Newfoundland", [
		["2278-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2278-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2278-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2278-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2279" : helpers.makeTestYear("Canada/Newfoundland", [
		["2279-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2279-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2279-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2279-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2280" : helpers.makeTestYear("Canada/Newfoundland", [
		["2280-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2280-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2280-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2280-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2281" : helpers.makeTestYear("Canada/Newfoundland", [
		["2281-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2281-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2281-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2281-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2282" : helpers.makeTestYear("Canada/Newfoundland", [
		["2282-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2282-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2282-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2282-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2283" : helpers.makeTestYear("Canada/Newfoundland", [
		["2283-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2283-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2283-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2283-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2284" : helpers.makeTestYear("Canada/Newfoundland", [
		["2284-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2284-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2284-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2284-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2285" : helpers.makeTestYear("Canada/Newfoundland", [
		["2285-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2285-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2285-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2285-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2286" : helpers.makeTestYear("Canada/Newfoundland", [
		["2286-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2286-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2286-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2286-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2287" : helpers.makeTestYear("Canada/Newfoundland", [
		["2287-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2287-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2287-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2287-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2288" : helpers.makeTestYear("Canada/Newfoundland", [
		["2288-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2288-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2288-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2288-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2289" : helpers.makeTestYear("Canada/Newfoundland", [
		["2289-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2289-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2289-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2289-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2290" : helpers.makeTestYear("Canada/Newfoundland", [
		["2290-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2290-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2290-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2290-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2291" : helpers.makeTestYear("Canada/Newfoundland", [
		["2291-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2291-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2291-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2291-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2292" : helpers.makeTestYear("Canada/Newfoundland", [
		["2292-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2292-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2292-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2292-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2293" : helpers.makeTestYear("Canada/Newfoundland", [
		["2293-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2293-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2293-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2293-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2294" : helpers.makeTestYear("Canada/Newfoundland", [
		["2294-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2294-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2294-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2294-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2295" : helpers.makeTestYear("Canada/Newfoundland", [
		["2295-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2295-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2295-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2295-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2296" : helpers.makeTestYear("Canada/Newfoundland", [
		["2296-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2296-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2296-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2296-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2297" : helpers.makeTestYear("Canada/Newfoundland", [
		["2297-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2297-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2297-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2297-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2298" : helpers.makeTestYear("Canada/Newfoundland", [
		["2298-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2298-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2298-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2298-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2299" : helpers.makeTestYear("Canada/Newfoundland", [
		["2299-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2299-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2299-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2299-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2300" : helpers.makeTestYear("Canada/Newfoundland", [
		["2300-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2300-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2300-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2300-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2301" : helpers.makeTestYear("Canada/Newfoundland", [
		["2301-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2301-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2301-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2301-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2302" : helpers.makeTestYear("Canada/Newfoundland", [
		["2302-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2302-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2302-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2302-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2303" : helpers.makeTestYear("Canada/Newfoundland", [
		["2303-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2303-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2303-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2303-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2304" : helpers.makeTestYear("Canada/Newfoundland", [
		["2304-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2304-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2304-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2304-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2305" : helpers.makeTestYear("Canada/Newfoundland", [
		["2305-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2305-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2305-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2305-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2306" : helpers.makeTestYear("Canada/Newfoundland", [
		["2306-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2306-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2306-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2306-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2307" : helpers.makeTestYear("Canada/Newfoundland", [
		["2307-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2307-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2307-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2307-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2308" : helpers.makeTestYear("Canada/Newfoundland", [
		["2308-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2308-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2308-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2308-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2309" : helpers.makeTestYear("Canada/Newfoundland", [
		["2309-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2309-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2309-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2309-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2310" : helpers.makeTestYear("Canada/Newfoundland", [
		["2310-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2310-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2310-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2310-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2311" : helpers.makeTestYear("Canada/Newfoundland", [
		["2311-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2311-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2311-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2311-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2312" : helpers.makeTestYear("Canada/Newfoundland", [
		["2312-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2312-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2312-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2312-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2313" : helpers.makeTestYear("Canada/Newfoundland", [
		["2313-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2313-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2313-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2313-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2314" : helpers.makeTestYear("Canada/Newfoundland", [
		["2314-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2314-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2314-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2314-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2315" : helpers.makeTestYear("Canada/Newfoundland", [
		["2315-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2315-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2315-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2315-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2316" : helpers.makeTestYear("Canada/Newfoundland", [
		["2316-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2316-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2316-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2316-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2317" : helpers.makeTestYear("Canada/Newfoundland", [
		["2317-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2317-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2317-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2317-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2318" : helpers.makeTestYear("Canada/Newfoundland", [
		["2318-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2318-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2318-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2318-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2319" : helpers.makeTestYear("Canada/Newfoundland", [
		["2319-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2319-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2319-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2319-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2320" : helpers.makeTestYear("Canada/Newfoundland", [
		["2320-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2320-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2320-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2320-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2321" : helpers.makeTestYear("Canada/Newfoundland", [
		["2321-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2321-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2321-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2321-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2322" : helpers.makeTestYear("Canada/Newfoundland", [
		["2322-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2322-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2322-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2322-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2323" : helpers.makeTestYear("Canada/Newfoundland", [
		["2323-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2323-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2323-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2323-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2324" : helpers.makeTestYear("Canada/Newfoundland", [
		["2324-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2324-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2324-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2324-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2325" : helpers.makeTestYear("Canada/Newfoundland", [
		["2325-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2325-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2325-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2325-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2326" : helpers.makeTestYear("Canada/Newfoundland", [
		["2326-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2326-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2326-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2326-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2327" : helpers.makeTestYear("Canada/Newfoundland", [
		["2327-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2327-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2327-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2327-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2328" : helpers.makeTestYear("Canada/Newfoundland", [
		["2328-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2328-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2328-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2328-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2329" : helpers.makeTestYear("Canada/Newfoundland", [
		["2329-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2329-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2329-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2329-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2330" : helpers.makeTestYear("Canada/Newfoundland", [
		["2330-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2330-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2330-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2330-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2331" : helpers.makeTestYear("Canada/Newfoundland", [
		["2331-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2331-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2331-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2331-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2332" : helpers.makeTestYear("Canada/Newfoundland", [
		["2332-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2332-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2332-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2332-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2333" : helpers.makeTestYear("Canada/Newfoundland", [
		["2333-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2333-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2333-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2333-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2334" : helpers.makeTestYear("Canada/Newfoundland", [
		["2334-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2334-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2334-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2334-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2335" : helpers.makeTestYear("Canada/Newfoundland", [
		["2335-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2335-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2335-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2335-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2336" : helpers.makeTestYear("Canada/Newfoundland", [
		["2336-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2336-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2336-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2336-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2337" : helpers.makeTestYear("Canada/Newfoundland", [
		["2337-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2337-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2337-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2337-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2338" : helpers.makeTestYear("Canada/Newfoundland", [
		["2338-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2338-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2338-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2338-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2339" : helpers.makeTestYear("Canada/Newfoundland", [
		["2339-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2339-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2339-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2339-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2340" : helpers.makeTestYear("Canada/Newfoundland", [
		["2340-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2340-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2340-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2340-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2341" : helpers.makeTestYear("Canada/Newfoundland", [
		["2341-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2341-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2341-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2341-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2342" : helpers.makeTestYear("Canada/Newfoundland", [
		["2342-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2342-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2342-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2342-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2343" : helpers.makeTestYear("Canada/Newfoundland", [
		["2343-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2343-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2343-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2343-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2344" : helpers.makeTestYear("Canada/Newfoundland", [
		["2344-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2344-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2344-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2344-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2345" : helpers.makeTestYear("Canada/Newfoundland", [
		["2345-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2345-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2345-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2345-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2346" : helpers.makeTestYear("Canada/Newfoundland", [
		["2346-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2346-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2346-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2346-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2347" : helpers.makeTestYear("Canada/Newfoundland", [
		["2347-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2347-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2347-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2347-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2348" : helpers.makeTestYear("Canada/Newfoundland", [
		["2348-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2348-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2348-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2348-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2349" : helpers.makeTestYear("Canada/Newfoundland", [
		["2349-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2349-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2349-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2349-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2350" : helpers.makeTestYear("Canada/Newfoundland", [
		["2350-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2350-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2350-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2350-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2351" : helpers.makeTestYear("Canada/Newfoundland", [
		["2351-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2351-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2351-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2351-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2352" : helpers.makeTestYear("Canada/Newfoundland", [
		["2352-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2352-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2352-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2352-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2353" : helpers.makeTestYear("Canada/Newfoundland", [
		["2353-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2353-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2353-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2353-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2354" : helpers.makeTestYear("Canada/Newfoundland", [
		["2354-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2354-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2354-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2354-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2355" : helpers.makeTestYear("Canada/Newfoundland", [
		["2355-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2355-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2355-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2355-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2356" : helpers.makeTestYear("Canada/Newfoundland", [
		["2356-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2356-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2356-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2356-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2357" : helpers.makeTestYear("Canada/Newfoundland", [
		["2357-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2357-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2357-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2357-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2358" : helpers.makeTestYear("Canada/Newfoundland", [
		["2358-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2358-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2358-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2358-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2359" : helpers.makeTestYear("Canada/Newfoundland", [
		["2359-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2359-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2359-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2359-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2360" : helpers.makeTestYear("Canada/Newfoundland", [
		["2360-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2360-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2360-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2360-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2361" : helpers.makeTestYear("Canada/Newfoundland", [
		["2361-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2361-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2361-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2361-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2362" : helpers.makeTestYear("Canada/Newfoundland", [
		["2362-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2362-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2362-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2362-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2363" : helpers.makeTestYear("Canada/Newfoundland", [
		["2363-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2363-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2363-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2363-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2364" : helpers.makeTestYear("Canada/Newfoundland", [
		["2364-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2364-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2364-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2364-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2365" : helpers.makeTestYear("Canada/Newfoundland", [
		["2365-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2365-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2365-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2365-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2366" : helpers.makeTestYear("Canada/Newfoundland", [
		["2366-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2366-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2366-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2366-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2367" : helpers.makeTestYear("Canada/Newfoundland", [
		["2367-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2367-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2367-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2367-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2368" : helpers.makeTestYear("Canada/Newfoundland", [
		["2368-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2368-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2368-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2368-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2369" : helpers.makeTestYear("Canada/Newfoundland", [
		["2369-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2369-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2369-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2369-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2370" : helpers.makeTestYear("Canada/Newfoundland", [
		["2370-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2370-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2370-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2370-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2371" : helpers.makeTestYear("Canada/Newfoundland", [
		["2371-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2371-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2371-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2371-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2372" : helpers.makeTestYear("Canada/Newfoundland", [
		["2372-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2372-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2372-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2372-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2373" : helpers.makeTestYear("Canada/Newfoundland", [
		["2373-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2373-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2373-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2373-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2374" : helpers.makeTestYear("Canada/Newfoundland", [
		["2374-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2374-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2374-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2374-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2375" : helpers.makeTestYear("Canada/Newfoundland", [
		["2375-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2375-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2375-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2375-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2376" : helpers.makeTestYear("Canada/Newfoundland", [
		["2376-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2376-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2376-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2376-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2377" : helpers.makeTestYear("Canada/Newfoundland", [
		["2377-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2377-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2377-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2377-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2378" : helpers.makeTestYear("Canada/Newfoundland", [
		["2378-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2378-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2378-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2378-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2379" : helpers.makeTestYear("Canada/Newfoundland", [
		["2379-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2379-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2379-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2379-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2380" : helpers.makeTestYear("Canada/Newfoundland", [
		["2380-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2380-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2380-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2380-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2381" : helpers.makeTestYear("Canada/Newfoundland", [
		["2381-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2381-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2381-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2381-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2382" : helpers.makeTestYear("Canada/Newfoundland", [
		["2382-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2382-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2382-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2382-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2383" : helpers.makeTestYear("Canada/Newfoundland", [
		["2383-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2383-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2383-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2383-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2384" : helpers.makeTestYear("Canada/Newfoundland", [
		["2384-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2384-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2384-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2384-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2385" : helpers.makeTestYear("Canada/Newfoundland", [
		["2385-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2385-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2385-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2385-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2386" : helpers.makeTestYear("Canada/Newfoundland", [
		["2386-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2386-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2386-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2386-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2387" : helpers.makeTestYear("Canada/Newfoundland", [
		["2387-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2387-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2387-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2387-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2388" : helpers.makeTestYear("Canada/Newfoundland", [
		["2388-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2388-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2388-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2388-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2389" : helpers.makeTestYear("Canada/Newfoundland", [
		["2389-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2389-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2389-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2389-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2390" : helpers.makeTestYear("Canada/Newfoundland", [
		["2390-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2390-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2390-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2390-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2391" : helpers.makeTestYear("Canada/Newfoundland", [
		["2391-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2391-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2391-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2391-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2392" : helpers.makeTestYear("Canada/Newfoundland", [
		["2392-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2392-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2392-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2392-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2393" : helpers.makeTestYear("Canada/Newfoundland", [
		["2393-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2393-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2393-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2393-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2394" : helpers.makeTestYear("Canada/Newfoundland", [
		["2394-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2394-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2394-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2394-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2395" : helpers.makeTestYear("Canada/Newfoundland", [
		["2395-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2395-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2395-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2395-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2396" : helpers.makeTestYear("Canada/Newfoundland", [
		["2396-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2396-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2396-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2396-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2397" : helpers.makeTestYear("Canada/Newfoundland", [
		["2397-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2397-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2397-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2397-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2398" : helpers.makeTestYear("Canada/Newfoundland", [
		["2398-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2398-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2398-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2398-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2399" : helpers.makeTestYear("Canada/Newfoundland", [
		["2399-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2399-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2399-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2399-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2400" : helpers.makeTestYear("Canada/Newfoundland", [
		["2400-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2400-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2400-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2400-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2401" : helpers.makeTestYear("Canada/Newfoundland", [
		["2401-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2401-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2401-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2401-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2402" : helpers.makeTestYear("Canada/Newfoundland", [
		["2402-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2402-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2402-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2402-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2403" : helpers.makeTestYear("Canada/Newfoundland", [
		["2403-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2403-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2403-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2403-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2404" : helpers.makeTestYear("Canada/Newfoundland", [
		["2404-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2404-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2404-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2404-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2405" : helpers.makeTestYear("Canada/Newfoundland", [
		["2405-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2405-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2405-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2405-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2406" : helpers.makeTestYear("Canada/Newfoundland", [
		["2406-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2406-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2406-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2406-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2407" : helpers.makeTestYear("Canada/Newfoundland", [
		["2407-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2407-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2407-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2407-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2408" : helpers.makeTestYear("Canada/Newfoundland", [
		["2408-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2408-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2408-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2408-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2409" : helpers.makeTestYear("Canada/Newfoundland", [
		["2409-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2409-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2409-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2409-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2410" : helpers.makeTestYear("Canada/Newfoundland", [
		["2410-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2410-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2410-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2410-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2411" : helpers.makeTestYear("Canada/Newfoundland", [
		["2411-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2411-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2411-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2411-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2412" : helpers.makeTestYear("Canada/Newfoundland", [
		["2412-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2412-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2412-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2412-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2413" : helpers.makeTestYear("Canada/Newfoundland", [
		["2413-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2413-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2413-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2413-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2414" : helpers.makeTestYear("Canada/Newfoundland", [
		["2414-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2414-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2414-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2414-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2415" : helpers.makeTestYear("Canada/Newfoundland", [
		["2415-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2415-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2415-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2415-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2416" : helpers.makeTestYear("Canada/Newfoundland", [
		["2416-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2416-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2416-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2416-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2417" : helpers.makeTestYear("Canada/Newfoundland", [
		["2417-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2417-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2417-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2417-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2418" : helpers.makeTestYear("Canada/Newfoundland", [
		["2418-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2418-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2418-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2418-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2419" : helpers.makeTestYear("Canada/Newfoundland", [
		["2419-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2419-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2419-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2419-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2420" : helpers.makeTestYear("Canada/Newfoundland", [
		["2420-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2420-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2420-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2420-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2421" : helpers.makeTestYear("Canada/Newfoundland", [
		["2421-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2421-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2421-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2421-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2422" : helpers.makeTestYear("Canada/Newfoundland", [
		["2422-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2422-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2422-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2422-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2423" : helpers.makeTestYear("Canada/Newfoundland", [
		["2423-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2423-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2423-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2423-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2424" : helpers.makeTestYear("Canada/Newfoundland", [
		["2424-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2424-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2424-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2424-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2425" : helpers.makeTestYear("Canada/Newfoundland", [
		["2425-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2425-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2425-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2425-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2426" : helpers.makeTestYear("Canada/Newfoundland", [
		["2426-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2426-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2426-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2426-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2427" : helpers.makeTestYear("Canada/Newfoundland", [
		["2427-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2427-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2427-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2427-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2428" : helpers.makeTestYear("Canada/Newfoundland", [
		["2428-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2428-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2428-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2428-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2429" : helpers.makeTestYear("Canada/Newfoundland", [
		["2429-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2429-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2429-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2429-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2430" : helpers.makeTestYear("Canada/Newfoundland", [
		["2430-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2430-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2430-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2430-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2431" : helpers.makeTestYear("Canada/Newfoundland", [
		["2431-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2431-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2431-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2431-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2432" : helpers.makeTestYear("Canada/Newfoundland", [
		["2432-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2432-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2432-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2432-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2433" : helpers.makeTestYear("Canada/Newfoundland", [
		["2433-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2433-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2433-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2433-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2434" : helpers.makeTestYear("Canada/Newfoundland", [
		["2434-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2434-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2434-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2434-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2435" : helpers.makeTestYear("Canada/Newfoundland", [
		["2435-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2435-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2435-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2435-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2436" : helpers.makeTestYear("Canada/Newfoundland", [
		["2436-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2436-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2436-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2436-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2437" : helpers.makeTestYear("Canada/Newfoundland", [
		["2437-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2437-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2437-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2437-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2438" : helpers.makeTestYear("Canada/Newfoundland", [
		["2438-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2438-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2438-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2438-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2439" : helpers.makeTestYear("Canada/Newfoundland", [
		["2439-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2439-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2439-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2439-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2440" : helpers.makeTestYear("Canada/Newfoundland", [
		["2440-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2440-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2440-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2440-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2441" : helpers.makeTestYear("Canada/Newfoundland", [
		["2441-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2441-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2441-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2441-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2442" : helpers.makeTestYear("Canada/Newfoundland", [
		["2442-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2442-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2442-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2442-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2443" : helpers.makeTestYear("Canada/Newfoundland", [
		["2443-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2443-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2443-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2443-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2444" : helpers.makeTestYear("Canada/Newfoundland", [
		["2444-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2444-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2444-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2444-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2445" : helpers.makeTestYear("Canada/Newfoundland", [
		["2445-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2445-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2445-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2445-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2446" : helpers.makeTestYear("Canada/Newfoundland", [
		["2446-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2446-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2446-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2446-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2447" : helpers.makeTestYear("Canada/Newfoundland", [
		["2447-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2447-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2447-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2447-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2448" : helpers.makeTestYear("Canada/Newfoundland", [
		["2448-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2448-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2448-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2448-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2449" : helpers.makeTestYear("Canada/Newfoundland", [
		["2449-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2449-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2449-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2449-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2450" : helpers.makeTestYear("Canada/Newfoundland", [
		["2450-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2450-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2450-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2450-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2451" : helpers.makeTestYear("Canada/Newfoundland", [
		["2451-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2451-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2451-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2451-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2452" : helpers.makeTestYear("Canada/Newfoundland", [
		["2452-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2452-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2452-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2452-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2453" : helpers.makeTestYear("Canada/Newfoundland", [
		["2453-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2453-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2453-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2453-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2454" : helpers.makeTestYear("Canada/Newfoundland", [
		["2454-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2454-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2454-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2454-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2455" : helpers.makeTestYear("Canada/Newfoundland", [
		["2455-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2455-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2455-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2455-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2456" : helpers.makeTestYear("Canada/Newfoundland", [
		["2456-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2456-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2456-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2456-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2457" : helpers.makeTestYear("Canada/Newfoundland", [
		["2457-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2457-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2457-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2457-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2458" : helpers.makeTestYear("Canada/Newfoundland", [
		["2458-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2458-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2458-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2458-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2459" : helpers.makeTestYear("Canada/Newfoundland", [
		["2459-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2459-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2459-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2459-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2460" : helpers.makeTestYear("Canada/Newfoundland", [
		["2460-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2460-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2460-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2460-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2461" : helpers.makeTestYear("Canada/Newfoundland", [
		["2461-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2461-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2461-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2461-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2462" : helpers.makeTestYear("Canada/Newfoundland", [
		["2462-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2462-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2462-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2462-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2463" : helpers.makeTestYear("Canada/Newfoundland", [
		["2463-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2463-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2463-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2463-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2464" : helpers.makeTestYear("Canada/Newfoundland", [
		["2464-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2464-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2464-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2464-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2465" : helpers.makeTestYear("Canada/Newfoundland", [
		["2465-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2465-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2465-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2465-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2466" : helpers.makeTestYear("Canada/Newfoundland", [
		["2466-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2466-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2466-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2466-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2467" : helpers.makeTestYear("Canada/Newfoundland", [
		["2467-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2467-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2467-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2467-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2468" : helpers.makeTestYear("Canada/Newfoundland", [
		["2468-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2468-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2468-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2468-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2469" : helpers.makeTestYear("Canada/Newfoundland", [
		["2469-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2469-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2469-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2469-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2470" : helpers.makeTestYear("Canada/Newfoundland", [
		["2470-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2470-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2470-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2470-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2471" : helpers.makeTestYear("Canada/Newfoundland", [
		["2471-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2471-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2471-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2471-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2472" : helpers.makeTestYear("Canada/Newfoundland", [
		["2472-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2472-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2472-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2472-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2473" : helpers.makeTestYear("Canada/Newfoundland", [
		["2473-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2473-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2473-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2473-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2474" : helpers.makeTestYear("Canada/Newfoundland", [
		["2474-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2474-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2474-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2474-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2475" : helpers.makeTestYear("Canada/Newfoundland", [
		["2475-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2475-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2475-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2475-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2476" : helpers.makeTestYear("Canada/Newfoundland", [
		["2476-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2476-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2476-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2476-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2477" : helpers.makeTestYear("Canada/Newfoundland", [
		["2477-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2477-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2477-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2477-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2478" : helpers.makeTestYear("Canada/Newfoundland", [
		["2478-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2478-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2478-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2478-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2479" : helpers.makeTestYear("Canada/Newfoundland", [
		["2479-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2479-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2479-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2479-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2480" : helpers.makeTestYear("Canada/Newfoundland", [
		["2480-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2480-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2480-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2480-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2481" : helpers.makeTestYear("Canada/Newfoundland", [
		["2481-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2481-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2481-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2481-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2482" : helpers.makeTestYear("Canada/Newfoundland", [
		["2482-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2482-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2482-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2482-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2483" : helpers.makeTestYear("Canada/Newfoundland", [
		["2483-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2483-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2483-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2483-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2484" : helpers.makeTestYear("Canada/Newfoundland", [
		["2484-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2484-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2484-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2484-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2485" : helpers.makeTestYear("Canada/Newfoundland", [
		["2485-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2485-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2485-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2485-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2486" : helpers.makeTestYear("Canada/Newfoundland", [
		["2486-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2486-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2486-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2486-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2487" : helpers.makeTestYear("Canada/Newfoundland", [
		["2487-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2487-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2487-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2487-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2488" : helpers.makeTestYear("Canada/Newfoundland", [
		["2488-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2488-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2488-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2488-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2489" : helpers.makeTestYear("Canada/Newfoundland", [
		["2489-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2489-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2489-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2489-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2490" : helpers.makeTestYear("Canada/Newfoundland", [
		["2490-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2490-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2490-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2490-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2491" : helpers.makeTestYear("Canada/Newfoundland", [
		["2491-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2491-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2491-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2491-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2492" : helpers.makeTestYear("Canada/Newfoundland", [
		["2492-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2492-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2492-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2492-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2493" : helpers.makeTestYear("Canada/Newfoundland", [
		["2493-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2493-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2493-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2493-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2494" : helpers.makeTestYear("Canada/Newfoundland", [
		["2494-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2494-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2494-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2494-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2495" : helpers.makeTestYear("Canada/Newfoundland", [
		["2495-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2495-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2495-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2495-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2496" : helpers.makeTestYear("Canada/Newfoundland", [
		["2496-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2496-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2496-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2496-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2497" : helpers.makeTestYear("Canada/Newfoundland", [
		["2497-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2497-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2497-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2497-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2498" : helpers.makeTestYear("Canada/Newfoundland", [
		["2498-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2498-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2498-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2498-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2499" : helpers.makeTestYear("Canada/Newfoundland", [
		["2499-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2499-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2499-11-01T04:29:59+00:00", "01:59:59", "NDT", 150]
	])
};