/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Qt includes
#include <QString>


namespace MsXpS
{
namespace MassXpert
{


enum class ModifCompositing
{
  OPAQUE = 0,
  TRANSPARENT
};


class ModifSpec
{
  public:
  ModifSpec();

  void setName(const QString &);
  const QString &getName() const;

  void setCompositing(ModifCompositing modif_compositing);
  ModifCompositing getCompositing() const;

  void setRaster(const QString &);
  const QString &getRaster() const;

  void setVector(const QString &);
  const QString &getVector() const;

  void setSound(const QString &);
  const QString &getSound() const;

  static bool parseFile(const QString &file_path,
                        std::vector<ModifSpec> &modif_specs);

  protected:
  QString m_name                 = QString();
  ModifCompositing m_compositing = ModifCompositing::OPAQUE;
  QString m_raster               = QString();
  QString m_vector               = QString();
  QString m_sound                = QString();
};


} // namespace MassXpert
} // namespace MsXpS
