// Set of symbolic markings -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "ExpressionMSet.h"
#include "Marking.h"
#include "Constant.h"
#include "CardType.h"
#include "LeafValue.h"
#include "Net.h"

/** @file ExpressionMSet.C
 * Multi-set of expressions (transient storage for quantification)
 */

/* Copyright  2000-2003 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

class Marking*
ExpressionMSet::toMarking (const class Place* place)
{
  class Marking* m = NULL;
  for (iterator i = begin (); i != end (); i++) {
    assert (i->second > 0);
    class Expression* mult = i->second != 1
      ? (new class Constant (*new class LeafValue
			     (Net::getCardType (), i->second)))->cse ()
      : NULL;
    class Expression* expr = i->first;
    class Marking* mm;
    if (expr->getKind () == Expression::eMarking) {
      mm = static_cast<class Marking*>(expr);
      assert (mm->getPlace () == place);
      if (mm->getNext () || (mult && mm->getMultiplicity ()))
	(mm = new class Marking (place, mm))->setMultiplicity (mult);
      else if (mult)
	mm->setMultiplicity (mult);
    }
    else {
      mm = new class Marking (place);
      mm->setToken (expr);
      mm->setMultiplicity (mult);
    }
    if (m)
      m->append (*mm);
    else
      m = mm;
  }
  return static_cast<class Marking*>(m->cse ());
}
