'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetKeyTypes __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetKeyTypes \- Obtain the list of available key types in the server's
keyboard mapping
.SH SYNOPSIS
.HP
.B Status XkbGetKeyTypes
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int " "first" "\^,"
.BI "unsigned int " "num" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I dpy
connection to X server
.TP
.I first
index to first type to get, 0 => 1st type
.TP
.I num
number of key types to be returned
.TP
.I xkb
keyboard description containing client map to update
.SH DESCRIPTION
.LP
.I XkbGetKeyTypes
queries the server for the desired types, waits for a reply, and returns the
desired types in the
.I xkb->map->types.
If successful, it returns Success.

.I XkbGetKeyTypes
returns BadAccess if the Xkb extension has not been properly initialized and
BadValue if the combination of
.I first
and
.I num
results in numbers out of valid range.

.B NOTE:
.I XkbGetKeyTypes
is used to obtain descriptions of the key types themselves, not the key types
bound to individual keys. To obtain the key types bound to an individual key,
refer to the
.I key_sym_map
field of the client map.
.SH DIAGNOSTICS
.TP 15
.B BadAccess
The Xkb extension has not been properly initialized
.TP 15
.B BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbKeyKeyType (__libmansuffix__),
.BR XkbKeyKeyTypeIndex (__libmansuffix__)

