package Lingua::StopWords::RU;

use strict;
use warnings;

use Exporter;
our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw( getStopWords ) ] ); 
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our $VERSION = 0.08;

sub getStopWords {
    if ( @_ and $_[0] eq 'UTF-8' ) {
        # adding U0 causes the result to be flagged as UTF-8
        my %stoplist = map { ( pack("U0a*", $_), 1 ) } qw( 
            É × ×Ï ÎÅ ÞÔÏ ÏÎ ÎÁ Ñ Ó ÓÏ ËÁË Á ÔÏ
            ×ÓÅ ÏÎÁ ÔÁË ÅÇÏ ÎÏ ÄÁ ÔÙ Ë Õ ÖÅ ×Ù ÚÁ
            ÂÙ ÐÏ ÔÏÌØËÏ ÅÅ ÍÎÅ ÂÙÌÏ ×ÏÔ ÏÔ
            ÍÅÎÑ ÅÝÅ ÎÅÔ Ï ÉÚ ÅÍÕ ÔÅÐÅÒØ ËÏÇÄÁ
            ÄÁÖÅ ÎÕ ×ÄÒÕÇ ÌÉ ÅÓÌÉ ÕÖÅ ÉÌÉ ÎÉ
            ÂÙÔØ ÂÙÌ ÎÅÇÏ ÄÏ ×ÁÓ ÎÉÂÕÄØ ÏÐÑÔØ
            ÕÖ ×ÁÍ ÓËÁÚÁÌ ×ÅÄØ ÔÁÍ ÐÏÔÏÍ ÓÅÂÑ
            ÎÉÞÅÇÏ ÅÊ ÍÏÖÅÔ ÏÎÉ ÔÕÔ ÇÄÅ ÅÓÔØ
            ÎÁÄÏ ÎÅÊ ÄÌÑ ÍÙ ÔÅÂÑ ÉÈ ÞÅÍ ÂÙÌÁ
            ÓÁÍ ÞÔÏÂ ÂÅÚ ÂÕÄÔÏ ÞÅÌÏ×ÅË ÞÅÇÏ
            ÒÁÚ ÔÏÖÅ ÓÅÂÅ ÐÏÄ ÖÉÚÎØ ÂÕÄÅÔ Ö
            ÔÏÇÄÁ ËÔÏ ÜÔÏÔ ÇÏ×ÏÒÉÌ ÔÏÇÏ ÐÏÔÏÍÕ
            ÜÔÏÇÏ ËÁËÏÊ ÓÏ×ÓÅÍ ÎÉÍ ÚÄÅÓØ ÜÔÏÍ
            ÏÄÉÎ ÐÏÞÔÉ ÍÏÊ ÔÅÍ ÞÔÏÂÙ ÎÅÅ
            ËÁÖÅÔÓÑ ÓÅÊÞÁÓ ÂÙÌÉ ËÕÄÁ ÚÁÞÅÍ
            ÓËÁÚÁÔØ ×ÓÅÈ ÎÉËÏÇÄÁ ÓÅÇÏÄÎÑ
            ÍÏÖÎÏ ÐÒÉ ÎÁËÏÎÅÃ Ä×Á ÏÂ ÄÒÕÇÏÊ
            ÈÏÔØ ÐÏÓÌÅ ÎÁÄ ÂÏÌØÛÅ ÔÏÔ ÞÅÒÅÚ
            ÜÔÉ ÎÁÓ ÐÒÏ ×ÓÅÇÏ ÎÉÈ ËÁËÁÑ ÍÎÏÇÏ
            ÒÁÚ×Å ÓËÁÚÁÌÁ ÔÒÉ ÜÔÕ ÍÏÑ ×ÐÒÏÞÅÍ
            ÈÏÒÏÛÏ Ó×ÏÀ ÜÔÏÊ ÐÅÒÅÄ ÉÎÏÇÄÁ
            ÌÕÞÛÅ ÞÕÔØ ÔÏÍ ÎÅÌØÚÑ ÔÁËÏÊ ÉÍ
            ÂÏÌÅÅ ×ÓÅÇÄÁ ËÏÎÅÞÎÏ ×ÓÀ ÍÅÖÄÕ 
        );
        return \%stoplist;
    }
    else {
        my %stoplist = map { ( $_, 1 ) } qw( 
                                
                            
                         
                        
                         
                       
                      
                      
                     
                       
                      
                     
               
        );
        return \%stoplist;
    }
}

1;
