; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S -o - %s | FileCheck %s

; Issue #54856

; ((X u< 0x8000000) & ((X & 0x60000000) != 0x60000000)) -> X u< 0x60000000
define i1 @icmp_power2_and_icmp_shifted_mask_2147483648_1610612736(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_2147483648_1610612736(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 1610612736
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 2147483648
  %t2 = and i32 %x, 1610612736
  %t3 = icmp ne i32 %t2, 1610612736
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_2147483648_1610612736(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_2147483648_1610612736(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 1610612736
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 2147483648
  %t2 = and i32 %x, 1610612736
  %t3 = icmp ne i32 %t2, 1610612736
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 0x8000000) & ((X & 0x7FFFFFFF) != 0x7FFFFFFF)) -> X u< 0x7FFFFFFF
define i1 @icmp_power2_and_icmp_shifted_mask_2147483648_2147483647(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_2147483648_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 2147483647
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 2147483648
  %t2 = and i32 %x, 2147483647
  %t3 = icmp ne i32 %t2, 2147483647
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_2147483648_2147483647(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_2147483648_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 2147483647
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 2147483648
  %t2 = and i32 %x, 2147483647
  %t3 = icmp ne i32 %t2, 2147483647
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 0x4000000) & ((X & 0x30000000) != 0x30000000)) -> X u< 0x30000000
define i1 @icmp_power2_and_icmp_shifted_mask_2147483648_805306368(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_2147483648_805306368(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 805306368
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 1073741824
  %t2 = and i32 %x, 805306368
  %t3 = icmp ne i32 %t2, 805306368
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_2147483648_805306368(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_2147483648_805306368(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 805306368
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 1073741824
  %t2 = and i32 %x, 805306368
  %t3 = icmp ne i32 %t2, 805306368
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 0x40000000) & ((X & 0x3FFFFFFF) != 0x3FFFFFFF)) -> X u< 0x3FFFFFFF
define i1 @icmp_power2_and_icmp_shifted_mask_1073741824_1073741823(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_1073741824_1073741823(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 1073741823
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 1073741824
  %t2 = and i32 %x, 1073741823
  %t3 = icmp ne i32 %t2, 1073741823
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_1073741824_1073741823(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_1073741824_1073741823(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 1073741823
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 1073741824
  %t2 = and i32 %x, 1073741823
  %t3 = icmp ne i32 %t2, 1073741823
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 8) & ((X & 7) != 7)) -> X u< 7
define i1 @icmp_power2_and_icmp_shifted_mask_8_7(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_8_7(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 7
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 7
  %t3 = icmp ne i32 %t2, 7
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_8_7(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_8_7(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 7
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 7
  %t3 = icmp ne i32 %t2, 7
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 8) & ((X & 6) != 6)) -> X u< 6
define i1 @icmp_power2_and_icmp_shifted_mask_8_6(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_8_6(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 6
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 6
  %t3 = icmp ne i32 %t2, 6
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_8_6(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_8_6(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult i32 [[X:%.*]], 6
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 6
  %t3 = icmp ne i32 %t2, 6
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 8) & ((X & 5) != 5)) -> no change
define i1 @icmp_power2_and_icmp_shifted_mask_8_5_gap_in_mask_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_8_5_gap_in_mask_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 5
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 5
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T1]], [[T3]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 5
  %t3 = icmp ne i32 %t2, 5
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_8_5_gap_in_mask_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_8_5_gap_in_mask_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 5
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 5
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T3]], [[T1]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 5
  %t3 = icmp ne i32 %t2, 5
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 8) & ((X & 3) != 3)) -> no change
define i1 @icmp_power2_and_icmp_shifted_mask_8_3_gap_between_masks_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_8_3_gap_between_masks_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 3
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T1]], [[T3]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 3
  %t3 = icmp ne i32 %t2, 3
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_8_3_gap_between_masks_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_8_3_gap_between_masks_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 3
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 3
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T3]], [[T1]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 3
  %t3 = icmp ne i32 %t2, 3
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 0x100) & ((X & 0x0EF) != 0x0EF)) -> no change
define i1 @icmp_power2_and_icmp_shifted_mask_256_239_gap_in_mask_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_256_239_gap_in_mask_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 256
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 239
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 239
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T1]], [[T3]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 256
  %t2 = and i32 %x, 239
  %t3 = icmp ne i32 %t2, 239
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_256_239_gap_in_mask_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_256_239_gap_in_mask_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 256
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 239
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 239
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T3]], [[T1]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 256
  %t2 = and i32 %x, 239
  %t3 = icmp ne i32 %t2, 239
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 0x08) & ((X & 0x70) != 0x70)) -> no change
define i1 @icmp_power2_and_icmp_shifted_mask_8_112_mask_to_left_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_8_112_mask_to_left_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 112
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 112
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T1]], [[T3]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 112
  %t3 = icmp ne i32 %t2, 112
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_8_112_mask_to_left_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_8_112_mask_to_left_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 112
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 112
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T3]], [[T1]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 112
  %t3 = icmp ne i32 %t2, 112
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 0x08) & ((X & 0x38) != 0x38))) -> no change
define i1 @icmp_power2_and_icmp_shifted_mask_8_56_mask_overlap_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_8_56_mask_overlap_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 56
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 56
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T1]], [[T3]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 56
  %t3 = icmp ne i32 %t2, 56
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_8_56_mask_overlap_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_8_56_mask_overlap_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 56
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 56
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T3]], [[T1]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 56
  %t3 = icmp ne i32 %t2, 56
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 0x08) & ((X & 0x18) != 0x18)) -> no change
define i1 @icmp_power2_and_icmp_shifted_mask_8_24_mask_overlap_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_8_24_mask_overlap_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 24
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 24
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T1]], [[T3]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 24
  %t3 = icmp ne i32 %t2, 24
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_8_24_mask_overlap_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_8_24_mask_overlap_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 24
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 24
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T3]], [[T1]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 24
  %t3 = icmp ne i32 %t2, 24
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; ((X u< 0x8) & ((X & 0xC) != 0xC)) -> no change
define i1 @icmp_power2_and_icmp_shifted_mask_8_12_mask_overlap_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_8_12_mask_overlap_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 12
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 12
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T1]], [[T3]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 12
  %t3 = icmp ne i32 %t2, 12
  %t4 = and i1 %t1, %t3
  ret i1 %t4
}

define i1 @icmp_power2_and_icmp_shifted_mask_swapped_8_12_mask_overlap_fail(i32 %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_swapped_8_12_mask_overlap_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp ult i32 [[X:%.*]], 8
; CHECK-NEXT:    [[T2:%.*]] = and i32 [[X]], 12
; CHECK-NEXT:    [[T3:%.*]] = icmp ne i32 [[T2]], 12
; CHECK-NEXT:    [[T4:%.*]] = and i1 [[T3]], [[T1]]
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t1 = icmp ult i32 %x, 8
  %t2 = and i32 %x, 12
  %t3 = icmp ne i32 %t2, 12
  %t4 = and i1 %t3, %t1
  ret i1 %t4
}

; Vector of 1 reduction
define <1 x i1> @icmp_power2_and_icmp_shifted_mask_vector_2147483648_2147483647(<1 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_2147483648_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <1 x i32> [[X:%.*]], <i32 2147483647>
; CHECK-NEXT:    ret <1 x i1> [[T4]]
;
  %t1 = icmp ult <1 x i32> %x, <i32 2147483648>
  %t2 = and <1 x i32> %x, <i32 2147483647>
  %t3 = icmp ne <1 x i32> %t2, <i32 2147483647>
  %t4 = and <1 x i1> %t1, %t3
  ret <1 x i1> %t4
}

define <1 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_2147483648_2147483647(<1 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_2147483648_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <1 x i32> [[X:%.*]], <i32 2147483647>
; CHECK-NEXT:    ret <1 x i1> [[T4]]
;
  %t1 = icmp ult <1 x i32> %x, <i32 2147483648>
  %t2 = and <1 x i32> %x, <i32 2147483647>
  %t3 = icmp ne <1 x i32> %t2, <i32 2147483647>
  %t4 = and <1 x i1> %t3, %t1
  ret <1 x i1> %t4
}

; Vector of 2 reduction
define <2 x i1> @icmp_power2_and_icmp_shifted_mask_vector_2147483648_1610612736_2147483647(<2 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_2147483648_1610612736_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <2 x i32> [[X:%.*]], <i32 1610612736, i32 2147483647>
; CHECK-NEXT:    ret <2 x i1> [[T4]]
;
  %t1 = icmp ult <2 x i32> %x, <i32 2147483648, i32 2147483648>
  %t2 = and <2 x i32> %x, <i32 1610612736, i32 2147483647>
  %t3 = icmp ne <2 x i32> %t2, <i32 1610612736, i32 2147483647>
  %t4 = and <2 x i1> %t1, %t3
  ret <2 x i1> %t4
}

define <2 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_2147483648_1610612736_2147483647(<2 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_2147483648_1610612736_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <2 x i32> [[X:%.*]], <i32 1610612736, i32 2147483647>
; CHECK-NEXT:    ret <2 x i1> [[T4]]
;
  %t1 = icmp ult <2 x i32> %x, <i32 2147483648, i32 2147483648>
  %t2 = and <2 x i32> %x, <i32 1610612736, i32 2147483647>
  %t3 = icmp ne <2 x i32> %t2, <i32 1610612736, i32 2147483647>
  %t4 = and <2 x i1> %t3, %t1
  ret <2 x i1> %t4
}

; Vector of 2 reduction with splat containing poison
define <2 x i1> @icmp_power2_and_icmp_shifted_mask_vector_splat_poison_2147483648_1610612736_2147483647(<2 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_splat_poison_2147483648_1610612736_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <2 x i32> [[X:%.*]], <i32 1610612736, i32 2147483647>
; CHECK-NEXT:    ret <2 x i1> [[T4]]
;
  %t1 = icmp ult <2 x i32> %x, <i32 2147483648, i32 poison>
  %t2 = and <2 x i32> %x, <i32 1610612736, i32 2147483647>
  %t3 = icmp ne <2 x i32> %t2, <i32 1610612736, i32 2147483647>
  %t4 = and <2 x i1> %t1, %t3
  ret <2 x i1> %t4
}

define <2 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_splat_poison_2147483648_1610612736_2147483647(<2 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_splat_poison_2147483648_1610612736_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <2 x i32> [[X:%.*]], <i32 1610612736, i32 2147483647>
; CHECK-NEXT:    ret <2 x i1> [[T4]]
;
  %t1 = icmp ult <2 x i32> %x, <i32 2147483648, i32 poison>
  %t2 = and <2 x i32> %x, <i32 1610612736, i32 2147483647>
  %t3 = icmp ne <2 x i32> %t2, <i32 1610612736, i32 2147483647>
  %t4 = and <2 x i1> %t3, %t1
  ret <2 x i1> %t4
}

; Vector of 2 reduction with splat containing undef
define <2 x i1> @icmp_power2_and_icmp_shifted_mask_vector_splat_undef_2147483648_1610612736_2147483647(<2 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_splat_undef_2147483648_1610612736_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <2 x i32> [[X:%.*]], <i32 1610612736, i32 2147483647>
; CHECK-NEXT:    ret <2 x i1> [[T4]]
;
  %t1 = icmp ult <2 x i32> %x, <i32 2147483648, i32 undef>
  %t2 = and <2 x i32> %x, <i32 1610612736, i32 2147483647>
  %t3 = icmp ne <2 x i32> %t2, <i32 1610612736, i32 2147483647>
  %t4 = and <2 x i1> %t1, %t3
  ret <2 x i1> %t4
}

define <2 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_splat_undef_2147483648_1610612736_2147483647(<2 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_splat_undef_2147483648_1610612736_2147483647(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <2 x i32> [[X:%.*]], <i32 1610612736, i32 2147483647>
; CHECK-NEXT:    ret <2 x i1> [[T4]]
;
  %t1 = icmp ult <2 x i32> %x, <i32 2147483648, i32 undef>
  %t2 = and <2 x i32> %x, <i32 1610612736, i32 2147483647>
  %t3 = icmp ne <2 x i32> %t2, <i32 1610612736, i32 2147483647>
  %t4 = and <2 x i1> %t3, %t1
  ret <2 x i1> %t4
}

; Vector of 7 reduction
define <7 x i1> @icmp_power2_and_icmp_shifted_mask_vector_128_others(<7 x i8> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_128_others(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <7 x i8> [[X:%.*]], <i8 127, i8 126, i8 124, i8 120, i8 112, i8 96, i8 64>
; CHECK-NEXT:    ret <7 x i1> [[T4]]
;
  %t1 = icmp ult <7 x i8> %x, <i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128>
  %t2 = and <7 x i8> %x, <i8 127, i8 126, i8 124, i8 120, i8 112, i8 96, i8 64>
  %t3 = icmp ne <7 x i8> %t2, <i8 127, i8 126, i8 124, i8 120, i8 112, i8 96, i8 64>
  %t4 = and <7 x i1> %t1, %t3
  ret <7 x i1> %t4
}

define <7 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_128_others(<7 x i8> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_128_others(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <7 x i8> [[X:%.*]], <i8 127, i8 126, i8 124, i8 120, i8 112, i8 96, i8 64>
; CHECK-NEXT:    ret <7 x i1> [[T4]]
;
  %t1 = icmp ult <7 x i8> %x, <i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128>
  %t2 = and <7 x i8> %x, <i8 127, i8 126, i8 124, i8 120, i8 112, i8 96, i8 64>
  %t3 = icmp ne <7 x i8> %t2, <i8 127, i8 126, i8 124, i8 120, i8 112, i8 96, i8 64>
  %t4 = and <7 x i1> %t3, %t1
  ret <7 x i1> %t4
}

; Vector of 6 reduction
define <6 x i1> @icmp_power2_and_icmp_shifted_mask_vector_64_others(<6 x i8> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_64_others(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <6 x i8> [[X:%.*]], <i8 63, i8 62, i8 60, i8 56, i8 48, i8 32>
; CHECK-NEXT:    ret <6 x i1> [[T4]]
;
  %t1 = icmp ult <6 x i8> %x, <i8 64, i8 64, i8 64, i8 64, i8 64, i8 64>
  %t2 = and <6 x i8> %x, <i8 63, i8 62, i8 60, i8 56, i8 48, i8 32>
  %t3 = icmp ne <6 x i8> %t2, <i8 63, i8 62, i8 60, i8 56, i8 48, i8 32>
  %t4 = and <6 x i1> %t1, %t3
  ret <6 x i1> %t4
}

define <6 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_64_others(<6 x i8> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_64_others(
; CHECK-NEXT:    [[T4:%.*]] = icmp ult <6 x i8> [[X:%.*]], <i8 63, i8 62, i8 60, i8 56, i8 48, i8 32>
; CHECK-NEXT:    ret <6 x i1> [[T4]]
;
  %t1 = icmp ult <6 x i8> %x, <i8 64, i8 64, i8 64, i8 64, i8 64, i8 64>
  %t2 = and <6 x i8> %x, <i8 63, i8 62, i8 60, i8 56, i8 48, i8 32>
  %t3 = icmp ne <6 x i8> %t2, <i8 63, i8 62, i8 60, i8 56, i8 48, i8 32>
  %t4 = and <6 x i1> %t1, %t3
  ret <6 x i1> %t4
}

; Vector of 0 of 1 compatible, no change
define <1 x i1> @icmp_power2_and_icmp_shifted_mask_vector_2147483648_2147482647_gap_in_mask_fail(<1 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_2147483648_2147482647_gap_in_mask_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp sgt <1 x i32> [[X:%.*]], <i32 -1>
; CHECK-NEXT:    [[T2:%.*]] = and <1 x i32> [[X]], <i32 2147482647>
; CHECK-NEXT:    [[T3:%.*]] = icmp ne <1 x i32> [[T2]], <i32 2147482647>
; CHECK-NEXT:    [[T4:%.*]] = and <1 x i1> [[T1]], [[T3]]
; CHECK-NEXT:    ret <1 x i1> [[T4]]
;
  %t1 = icmp ult <1 x i32> %x, <i32 2147483648>
  %t2 = and <1 x i32> %x, <i32 2147482647>
  %t3 = icmp ne <1 x i32> %t2, <i32 2147482647>
  %t4 = and <1 x i1> %t1, %t3
  ret <1 x i1> %t4
}

define <1 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_2147483648_2147482647_gap_in_mask_fail(<1 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_2147483648_2147482647_gap_in_mask_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp sgt <1 x i32> [[X:%.*]], <i32 -1>
; CHECK-NEXT:    [[T2:%.*]] = and <1 x i32> [[X]], <i32 2147482647>
; CHECK-NEXT:    [[T3:%.*]] = icmp ne <1 x i32> [[T2]], <i32 2147482647>
; CHECK-NEXT:    [[T4:%.*]] = and <1 x i1> [[T3]], [[T1]]
; CHECK-NEXT:    ret <1 x i1> [[T4]]
;
  %t1 = icmp ult <1 x i32> %x, <i32 2147483648>
  %t2 = and <1 x i32> %x, <i32 2147482647>
  %t3 = icmp ne <1 x i32> %t2, <i32 2147482647>
  %t4 = and <1 x i1> %t3, %t1
  ret <1 x i1> %t4
}

; Vector 1 of 2 compatible, no change
define <2 x i1> @icmp_power2_and_icmp_shifted_mask_vector_2147483648_1073741823_gap_between_masks_fail(<2 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_2147483648_1073741823_gap_between_masks_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp sgt <2 x i32> [[X:%.*]], <i32 -1, i32 -1>
; CHECK-NEXT:    [[T2:%.*]] = and <2 x i32> [[X]], <i32 1610612736, i32 1073741823>
; CHECK-NEXT:    [[T3:%.*]] = icmp ne <2 x i32> [[T2]], <i32 1610612736, i32 1073741823>
; CHECK-NEXT:    [[T4:%.*]] = and <2 x i1> [[T1]], [[T3]]
; CHECK-NEXT:    ret <2 x i1> [[T4]]
;
  %t1 = icmp ult <2 x i32> %x, <i32 2147483648, i32 2147483648>
  %t2 = and <2 x i32> %x, <i32 1610612736, i32 1073741823>
  %t3 = icmp ne <2 x i32> %t2, <i32 1610612736, i32 1073741823>
  %t4 = and <2 x i1> %t1, %t3
  ret <2 x i1> %t4
}

define <2 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_2147483648_1073741823_gap_between_masks_fail(<2 x i32> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_2147483648_1073741823_gap_between_masks_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp sgt <2 x i32> [[X:%.*]], <i32 -1, i32 -1>
; CHECK-NEXT:    [[T2:%.*]] = and <2 x i32> [[X]], <i32 1610612736, i32 1073741823>
; CHECK-NEXT:    [[T3:%.*]] = icmp ne <2 x i32> [[T2]], <i32 1610612736, i32 1073741823>
; CHECK-NEXT:    [[T4:%.*]] = and <2 x i1> [[T3]], [[T1]]
; CHECK-NEXT:    ret <2 x i1> [[T4]]
;
  %t1 = icmp ult <2 x i32> %x, <i32 2147483648, i32 2147483648>
  %t2 = and <2 x i32> %x, <i32 1610612736, i32 1073741823>
  %t3 = icmp ne <2 x i32> %t2, <i32 1610612736, i32 1073741823>
  %t4 = and <2 x i1> %t3, %t1
  ret <2 x i1> %t4
}

; Vector 1 of 7 compatible, no change
define <7 x i1> @icmp_power2_and_icmp_shifted_mask_vector_128_1_of_7_fail(<7 x i8> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_128_1_of_7_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp sgt <7 x i8> [[X:%.*]], <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
; CHECK-NEXT:    [[T2:%.*]] = and <7 x i8> [[X]], <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32, i8 64>
; CHECK-NEXT:    [[T3:%.*]] = icmp ne <7 x i8> [[T2]], <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32, i8 64>
; CHECK-NEXT:    [[T4:%.*]] = and <7 x i1> [[T1]], [[T3]]
; CHECK-NEXT:    ret <7 x i1> [[T4]]
;
  %t1 = icmp ult <7 x i8> %x, <i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128>
  %t2 = and <7 x i8> %x, <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32, i8 64>
  %t3 = icmp ne <7 x i8> %t2, <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32, i8 64>
  %t4 = and <7 x i1> %t1, %t3
  ret <7 x i1> %t4
}

define <7 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_128_1_of_7_fail(<7 x i8> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_128_1_of_7_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp sgt <7 x i8> [[X:%.*]], <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
; CHECK-NEXT:    [[T2:%.*]] = and <7 x i8> [[X]], <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32, i8 64>
; CHECK-NEXT:    [[T3:%.*]] = icmp ne <7 x i8> [[T2]], <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32, i8 64>
; CHECK-NEXT:    [[T4:%.*]] = and <7 x i1> [[T3]], [[T1]]
; CHECK-NEXT:    ret <7 x i1> [[T4]]
;
  %t1 = icmp ult <7 x i8> %x, <i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128>
  %t2 = and <7 x i8> %x, <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32, i8 64>
  %t3 = icmp ne <7 x i8> %t2, <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32, i8 64>
  %t4 = and <7 x i1> %t3, %t1
  ret <7 x i1> %t4
}

; Vector 0 of 6 compatible, no change
define <6 x i1> @icmp_power2_and_icmp_shifted_mask_vector_128_0_of_6_fail(<6 x i8> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_128_0_of_6_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp sgt <6 x i8> [[X:%.*]], <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
; CHECK-NEXT:    [[T2:%.*]] = and <6 x i8> [[X]], <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32>
; CHECK-NEXT:    [[T3:%.*]] = icmp ne <6 x i8> [[T2]], <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32>
; CHECK-NEXT:    [[T4:%.*]] = and <6 x i1> [[T1]], [[T3]]
; CHECK-NEXT:    ret <6 x i1> [[T4]]
;
  %t1 = icmp ult <6 x i8> %x, <i8 128, i8 128, i8 128, i8 128, i8 128, i8 128>
  %t2 = and <6 x i8> %x, <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32>
  %t3 = icmp ne <6 x i8> %t2, <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32>
  %t4 = and <6 x i1> %t1, %t3
  ret <6 x i1> %t4
}

define <6 x i1> @icmp_power2_and_icmp_shifted_mask_vector_swapped_128_0_of_6_fail(<6 x i8> %x) {
; CHECK-LABEL: @icmp_power2_and_icmp_shifted_mask_vector_swapped_128_0_of_6_fail(
; CHECK-NEXT:    [[T1:%.*]] = icmp sgt <6 x i8> [[X:%.*]], <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
; CHECK-NEXT:    [[T2:%.*]] = and <6 x i8> [[X]], <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32>
; CHECK-NEXT:    [[T3:%.*]] = icmp ne <6 x i8> [[T2]], <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32>
; CHECK-NEXT:    [[T4:%.*]] = and <6 x i1> [[T3]], [[T1]]
; CHECK-NEXT:    ret <6 x i1> [[T4]]
;
  %t1 = icmp ult <6 x i8> %x, <i8 128, i8 128, i8 128, i8 128, i8 128, i8 128>
  %t2 = and <6 x i8> %x, <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32>
  %t3 = icmp ne <6 x i8> %t2, <i8 125, i8 122, i8 116, i8 104, i8 80, i8 32>
  %t4 = and <6 x i1> %t3, %t1
  ret <6 x i1> %t4
}
