; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:   FileCheck %s

; These test cases aim to test the vector string isolate builtins on Power10.

declare <16 x i8> @llvm.ppc.altivec.vclrlb(<16 x i8>, i32)
declare <16 x i8> @llvm.ppc.altivec.vclrrb(<16 x i8>, i32)

define <16 x i8> @test_vclrlb(<16 x i8> %a, i32 %n) {
; CHECK-LABEL: test_vclrlb:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vclrlb v2, v2, r5
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <16 x i8> @llvm.ppc.altivec.vclrlb(<16 x i8> %a, i32 %n)
  ret <16 x i8> %tmp
}

define <16 x i8> @test_vclrrb(<16 x i8> %a, i32 %n) {
; CHECK-LABEL: test_vclrrb:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vclrrb v2, v2, r5
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <16 x i8> @llvm.ppc.altivec.vclrrb(<16 x i8> %a, i32 %n)
  ret <16 x i8> %tmp
}
