// a silly quotation utitility

/*
   This code was written by Lars Doelle <lars.doelle@on-line.de>.
   This code is in the public domain.
*/

#include <stdio.h>
#include <strings.h>

int skip = 0;
int empty = 1;

void pchr(int c, int indent)
{
    if (skip) {
        skip = (c != '\n');
        return;
    }
    switch (c) {
    case '\n':
        if (!empty)
            printf("\\n\"\n%*s\"", indent, "");
        empty = 1;
        break;
    case '#':
        skip = 1;
        break;
    case '"':
    case '\\':
        printf("\\");
        // fallthrough
    default:
        printf("%c", c);
        empty = 0;
        break;
    }
}

#define INDENT 2

int main(int argc, char *argv[])
{
    int cc;
    FILE *sysin;
    if (argc < 2) {
        fprintf(stderr, "usage: %s filename\n", argv[0]);
        return 1;
    }
    sysin = fopen(argv[1], "r");
    if (!sysin) {
        fprintf(stderr, "cannot open %s\n", argv[1]);
        perror("reason: ");
        return 1;
    }
    printf("%*s/* generated by '%s %s' */\n\n", INDENT, "", argv[0], argv[1]);
    printf("%*s\"", INDENT, "");
    while ((cc = fgetc(sysin)) > 0) {
        pchr(cc, INDENT);
    }
    printf("\"\n");
    fclose(sysin);
}
