// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/kata-containers/kata-containers/src/agent/protocols/protos/agent.proto

package grpc

import (
	context "context"
	fmt "fmt"
	github_com_containerd_ttrpc "github.com/containerd/ttrpc"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	protocols "github.com/kata-containers/kata-containers/src/runtime/virtcontainers/pkg/agent/protocols"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type CreateContainerRequest struct {
	ContainerId string      `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	ExecId      string      `protobuf:"bytes,2,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	StringUser  *StringUser `protobuf:"bytes,3,opt,name=string_user,json=stringUser,proto3" json:"string_user,omitempty"`
	Devices     []*Device   `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	Storages    []*Storage  `protobuf:"bytes,5,rep,name=storages,proto3" json:"storages,omitempty"`
	OCI         *Spec       `protobuf:"bytes,6,opt,name=OCI,proto3" json:"OCI,omitempty"`
	// This field is used to indicate if the container needs to join
	// sandbox shared pid ns or create a new namespace. This field is
	// meant to override the NEWPID config settings in the OCI spec.
	// The agent would receive an OCI spec with PID namespace cleared
	// out altogether and not just the pid ns path.
	SandboxPidns         bool     `protobuf:"varint,7,opt,name=sandbox_pidns,json=sandboxPidns,proto3" json:"sandbox_pidns,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateContainerRequest) Reset()      { *m = CreateContainerRequest{} }
func (*CreateContainerRequest) ProtoMessage() {}
func (*CreateContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{0}
}
func (m *CreateContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateContainerRequest.Merge(m, src)
}
func (m *CreateContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreateContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateContainerRequest proto.InternalMessageInfo

type StartContainerRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartContainerRequest) Reset()      { *m = StartContainerRequest{} }
func (*StartContainerRequest) ProtoMessage() {}
func (*StartContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{1}
}
func (m *StartContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StartContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StartContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StartContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartContainerRequest.Merge(m, src)
}
func (m *StartContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *StartContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartContainerRequest proto.InternalMessageInfo

type RemoveContainerRequest struct {
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// RemoveContainer will return an error if
	// it could not kill some container processes
	// after timeout seconds.
	// Setting timeout to 0 means RemoveContainer will
	// wait for ever.
	Timeout              uint32   `protobuf:"varint,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveContainerRequest) Reset()      { *m = RemoveContainerRequest{} }
func (*RemoveContainerRequest) ProtoMessage() {}
func (*RemoveContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{2}
}
func (m *RemoveContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveContainerRequest.Merge(m, src)
}
func (m *RemoveContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveContainerRequest proto.InternalMessageInfo

type ExecProcessRequest struct {
	ContainerId          string      `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	ExecId               string      `protobuf:"bytes,2,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	StringUser           *StringUser `protobuf:"bytes,3,opt,name=string_user,json=stringUser,proto3" json:"string_user,omitempty"`
	Process              *Process    `protobuf:"bytes,4,opt,name=process,proto3" json:"process,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ExecProcessRequest) Reset()      { *m = ExecProcessRequest{} }
func (*ExecProcessRequest) ProtoMessage() {}
func (*ExecProcessRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{3}
}
func (m *ExecProcessRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecProcessRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecProcessRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecProcessRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecProcessRequest.Merge(m, src)
}
func (m *ExecProcessRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExecProcessRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecProcessRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecProcessRequest proto.InternalMessageInfo

type SignalProcessRequest struct {
	ContainerId string `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	// Special case for SignalProcess(): exec_id can be empty(""),
	// which means to send the signal to all the processes including their descendants.
	// Other APIs with exec_id should treat empty exec_id as an invalid request.
	ExecId               string   `protobuf:"bytes,2,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	Signal               uint32   `protobuf:"varint,3,opt,name=signal,proto3" json:"signal,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SignalProcessRequest) Reset()      { *m = SignalProcessRequest{} }
func (*SignalProcessRequest) ProtoMessage() {}
func (*SignalProcessRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{4}
}
func (m *SignalProcessRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SignalProcessRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SignalProcessRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SignalProcessRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignalProcessRequest.Merge(m, src)
}
func (m *SignalProcessRequest) XXX_Size() int {
	return m.Size()
}
func (m *SignalProcessRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SignalProcessRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SignalProcessRequest proto.InternalMessageInfo

type WaitProcessRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	ExecId               string   `protobuf:"bytes,2,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WaitProcessRequest) Reset()      { *m = WaitProcessRequest{} }
func (*WaitProcessRequest) ProtoMessage() {}
func (*WaitProcessRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{5}
}
func (m *WaitProcessRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WaitProcessRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WaitProcessRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WaitProcessRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WaitProcessRequest.Merge(m, src)
}
func (m *WaitProcessRequest) XXX_Size() int {
	return m.Size()
}
func (m *WaitProcessRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WaitProcessRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WaitProcessRequest proto.InternalMessageInfo

type WaitProcessResponse struct {
	Status               int32    `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WaitProcessResponse) Reset()      { *m = WaitProcessResponse{} }
func (*WaitProcessResponse) ProtoMessage() {}
func (*WaitProcessResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{6}
}
func (m *WaitProcessResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WaitProcessResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WaitProcessResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WaitProcessResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WaitProcessResponse.Merge(m, src)
}
func (m *WaitProcessResponse) XXX_Size() int {
	return m.Size()
}
func (m *WaitProcessResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WaitProcessResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WaitProcessResponse proto.InternalMessageInfo

type UpdateContainerRequest struct {
	ContainerId          string          `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	Resources            *LinuxResources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *UpdateContainerRequest) Reset()      { *m = UpdateContainerRequest{} }
func (*UpdateContainerRequest) ProtoMessage() {}
func (*UpdateContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{7}
}
func (m *UpdateContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateContainerRequest.Merge(m, src)
}
func (m *UpdateContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateContainerRequest proto.InternalMessageInfo

type StatsContainerRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StatsContainerRequest) Reset()      { *m = StatsContainerRequest{} }
func (*StatsContainerRequest) ProtoMessage() {}
func (*StatsContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{8}
}
func (m *StatsContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatsContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatsContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatsContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatsContainerRequest.Merge(m, src)
}
func (m *StatsContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *StatsContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StatsContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StatsContainerRequest proto.InternalMessageInfo

type PauseContainerRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PauseContainerRequest) Reset()      { *m = PauseContainerRequest{} }
func (*PauseContainerRequest) ProtoMessage() {}
func (*PauseContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{9}
}
func (m *PauseContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PauseContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PauseContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PauseContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PauseContainerRequest.Merge(m, src)
}
func (m *PauseContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *PauseContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PauseContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PauseContainerRequest proto.InternalMessageInfo

type ResumeContainerRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResumeContainerRequest) Reset()      { *m = ResumeContainerRequest{} }
func (*ResumeContainerRequest) ProtoMessage() {}
func (*ResumeContainerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{10}
}
func (m *ResumeContainerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResumeContainerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResumeContainerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResumeContainerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResumeContainerRequest.Merge(m, src)
}
func (m *ResumeContainerRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResumeContainerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResumeContainerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResumeContainerRequest proto.InternalMessageInfo

type CpuUsage struct {
	TotalUsage           uint64   `protobuf:"varint,1,opt,name=total_usage,json=totalUsage,proto3" json:"total_usage,omitempty"`
	PercpuUsage          []uint64 `protobuf:"varint,2,rep,packed,name=percpu_usage,json=percpuUsage,proto3" json:"percpu_usage,omitempty"`
	UsageInKernelmode    uint64   `protobuf:"varint,3,opt,name=usage_in_kernelmode,json=usageInKernelmode,proto3" json:"usage_in_kernelmode,omitempty"`
	UsageInUsermode      uint64   `protobuf:"varint,4,opt,name=usage_in_usermode,json=usageInUsermode,proto3" json:"usage_in_usermode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CpuUsage) Reset()      { *m = CpuUsage{} }
func (*CpuUsage) ProtoMessage() {}
func (*CpuUsage) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{11}
}
func (m *CpuUsage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CpuUsage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CpuUsage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CpuUsage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CpuUsage.Merge(m, src)
}
func (m *CpuUsage) XXX_Size() int {
	return m.Size()
}
func (m *CpuUsage) XXX_DiscardUnknown() {
	xxx_messageInfo_CpuUsage.DiscardUnknown(m)
}

var xxx_messageInfo_CpuUsage proto.InternalMessageInfo

type ThrottlingData struct {
	Periods              uint64   `protobuf:"varint,1,opt,name=periods,proto3" json:"periods,omitempty"`
	ThrottledPeriods     uint64   `protobuf:"varint,2,opt,name=throttled_periods,json=throttledPeriods,proto3" json:"throttled_periods,omitempty"`
	ThrottledTime        uint64   `protobuf:"varint,3,opt,name=throttled_time,json=throttledTime,proto3" json:"throttled_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ThrottlingData) Reset()      { *m = ThrottlingData{} }
func (*ThrottlingData) ProtoMessage() {}
func (*ThrottlingData) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{12}
}
func (m *ThrottlingData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ThrottlingData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ThrottlingData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ThrottlingData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThrottlingData.Merge(m, src)
}
func (m *ThrottlingData) XXX_Size() int {
	return m.Size()
}
func (m *ThrottlingData) XXX_DiscardUnknown() {
	xxx_messageInfo_ThrottlingData.DiscardUnknown(m)
}

var xxx_messageInfo_ThrottlingData proto.InternalMessageInfo

type CpuStats struct {
	CpuUsage             *CpuUsage       `protobuf:"bytes,1,opt,name=cpu_usage,json=cpuUsage,proto3" json:"cpu_usage,omitempty"`
	ThrottlingData       *ThrottlingData `protobuf:"bytes,2,opt,name=throttling_data,json=throttlingData,proto3" json:"throttling_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CpuStats) Reset()      { *m = CpuStats{} }
func (*CpuStats) ProtoMessage() {}
func (*CpuStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{13}
}
func (m *CpuStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CpuStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CpuStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CpuStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CpuStats.Merge(m, src)
}
func (m *CpuStats) XXX_Size() int {
	return m.Size()
}
func (m *CpuStats) XXX_DiscardUnknown() {
	xxx_messageInfo_CpuStats.DiscardUnknown(m)
}

var xxx_messageInfo_CpuStats proto.InternalMessageInfo

type PidsStats struct {
	Current              uint64   `protobuf:"varint,1,opt,name=current,proto3" json:"current,omitempty"`
	Limit                uint64   `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PidsStats) Reset()      { *m = PidsStats{} }
func (*PidsStats) ProtoMessage() {}
func (*PidsStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{14}
}
func (m *PidsStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PidsStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PidsStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PidsStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PidsStats.Merge(m, src)
}
func (m *PidsStats) XXX_Size() int {
	return m.Size()
}
func (m *PidsStats) XXX_DiscardUnknown() {
	xxx_messageInfo_PidsStats.DiscardUnknown(m)
}

var xxx_messageInfo_PidsStats proto.InternalMessageInfo

type MemoryData struct {
	Usage                uint64   `protobuf:"varint,1,opt,name=usage,proto3" json:"usage,omitempty"`
	MaxUsage             uint64   `protobuf:"varint,2,opt,name=max_usage,json=maxUsage,proto3" json:"max_usage,omitempty"`
	Failcnt              uint64   `protobuf:"varint,3,opt,name=failcnt,proto3" json:"failcnt,omitempty"`
	Limit                uint64   `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MemoryData) Reset()      { *m = MemoryData{} }
func (*MemoryData) ProtoMessage() {}
func (*MemoryData) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{15}
}
func (m *MemoryData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemoryData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemoryData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemoryData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemoryData.Merge(m, src)
}
func (m *MemoryData) XXX_Size() int {
	return m.Size()
}
func (m *MemoryData) XXX_DiscardUnknown() {
	xxx_messageInfo_MemoryData.DiscardUnknown(m)
}

var xxx_messageInfo_MemoryData proto.InternalMessageInfo

type MemoryStats struct {
	Cache                uint64            `protobuf:"varint,1,opt,name=cache,proto3" json:"cache,omitempty"`
	Usage                *MemoryData       `protobuf:"bytes,2,opt,name=usage,proto3" json:"usage,omitempty"`
	SwapUsage            *MemoryData       `protobuf:"bytes,3,opt,name=swap_usage,json=swapUsage,proto3" json:"swap_usage,omitempty"`
	KernelUsage          *MemoryData       `protobuf:"bytes,4,opt,name=kernel_usage,json=kernelUsage,proto3" json:"kernel_usage,omitempty"`
	UseHierarchy         bool              `protobuf:"varint,5,opt,name=use_hierarchy,json=useHierarchy,proto3" json:"use_hierarchy,omitempty"`
	Stats                map[string]uint64 `protobuf:"bytes,6,rep,name=stats,proto3" json:"stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MemoryStats) Reset()      { *m = MemoryStats{} }
func (*MemoryStats) ProtoMessage() {}
func (*MemoryStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{16}
}
func (m *MemoryStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemoryStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemoryStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemoryStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemoryStats.Merge(m, src)
}
func (m *MemoryStats) XXX_Size() int {
	return m.Size()
}
func (m *MemoryStats) XXX_DiscardUnknown() {
	xxx_messageInfo_MemoryStats.DiscardUnknown(m)
}

var xxx_messageInfo_MemoryStats proto.InternalMessageInfo

type BlkioStatsEntry struct {
	Major                uint64   `protobuf:"varint,1,opt,name=major,proto3" json:"major,omitempty"`
	Minor                uint64   `protobuf:"varint,2,opt,name=minor,proto3" json:"minor,omitempty"`
	Op                   string   `protobuf:"bytes,3,opt,name=op,proto3" json:"op,omitempty"`
	Value                uint64   `protobuf:"varint,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BlkioStatsEntry) Reset()      { *m = BlkioStatsEntry{} }
func (*BlkioStatsEntry) ProtoMessage() {}
func (*BlkioStatsEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{17}
}
func (m *BlkioStatsEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BlkioStatsEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BlkioStatsEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BlkioStatsEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlkioStatsEntry.Merge(m, src)
}
func (m *BlkioStatsEntry) XXX_Size() int {
	return m.Size()
}
func (m *BlkioStatsEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_BlkioStatsEntry.DiscardUnknown(m)
}

var xxx_messageInfo_BlkioStatsEntry proto.InternalMessageInfo

type BlkioStats struct {
	IoServiceBytesRecursive []*BlkioStatsEntry `protobuf:"bytes,1,rep,name=io_service_bytes_recursive,json=ioServiceBytesRecursive,proto3" json:"io_service_bytes_recursive,omitempty"`
	IoServicedRecursive     []*BlkioStatsEntry `protobuf:"bytes,2,rep,name=io_serviced_recursive,json=ioServicedRecursive,proto3" json:"io_serviced_recursive,omitempty"`
	IoQueuedRecursive       []*BlkioStatsEntry `protobuf:"bytes,3,rep,name=io_queued_recursive,json=ioQueuedRecursive,proto3" json:"io_queued_recursive,omitempty"`
	IoServiceTimeRecursive  []*BlkioStatsEntry `protobuf:"bytes,4,rep,name=io_service_time_recursive,json=ioServiceTimeRecursive,proto3" json:"io_service_time_recursive,omitempty"`
	IoWaitTimeRecursive     []*BlkioStatsEntry `protobuf:"bytes,5,rep,name=io_wait_time_recursive,json=ioWaitTimeRecursive,proto3" json:"io_wait_time_recursive,omitempty"`
	IoMergedRecursive       []*BlkioStatsEntry `protobuf:"bytes,6,rep,name=io_merged_recursive,json=ioMergedRecursive,proto3" json:"io_merged_recursive,omitempty"`
	IoTimeRecursive         []*BlkioStatsEntry `protobuf:"bytes,7,rep,name=io_time_recursive,json=ioTimeRecursive,proto3" json:"io_time_recursive,omitempty"`
	SectorsRecursive        []*BlkioStatsEntry `protobuf:"bytes,8,rep,name=sectors_recursive,json=sectorsRecursive,proto3" json:"sectors_recursive,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}           `json:"-"`
	XXX_unrecognized        []byte             `json:"-"`
	XXX_sizecache           int32              `json:"-"`
}

func (m *BlkioStats) Reset()      { *m = BlkioStats{} }
func (*BlkioStats) ProtoMessage() {}
func (*BlkioStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{18}
}
func (m *BlkioStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BlkioStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BlkioStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BlkioStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BlkioStats.Merge(m, src)
}
func (m *BlkioStats) XXX_Size() int {
	return m.Size()
}
func (m *BlkioStats) XXX_DiscardUnknown() {
	xxx_messageInfo_BlkioStats.DiscardUnknown(m)
}

var xxx_messageInfo_BlkioStats proto.InternalMessageInfo

type HugetlbStats struct {
	Usage                uint64   `protobuf:"varint,1,opt,name=usage,proto3" json:"usage,omitempty"`
	MaxUsage             uint64   `protobuf:"varint,2,opt,name=max_usage,json=maxUsage,proto3" json:"max_usage,omitempty"`
	Failcnt              uint64   `protobuf:"varint,3,opt,name=failcnt,proto3" json:"failcnt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HugetlbStats) Reset()      { *m = HugetlbStats{} }
func (*HugetlbStats) ProtoMessage() {}
func (*HugetlbStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{19}
}
func (m *HugetlbStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HugetlbStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HugetlbStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HugetlbStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HugetlbStats.Merge(m, src)
}
func (m *HugetlbStats) XXX_Size() int {
	return m.Size()
}
func (m *HugetlbStats) XXX_DiscardUnknown() {
	xxx_messageInfo_HugetlbStats.DiscardUnknown(m)
}

var xxx_messageInfo_HugetlbStats proto.InternalMessageInfo

type CgroupStats struct {
	CpuStats             *CpuStats                `protobuf:"bytes,1,opt,name=cpu_stats,json=cpuStats,proto3" json:"cpu_stats,omitempty"`
	MemoryStats          *MemoryStats             `protobuf:"bytes,2,opt,name=memory_stats,json=memoryStats,proto3" json:"memory_stats,omitempty"`
	PidsStats            *PidsStats               `protobuf:"bytes,3,opt,name=pids_stats,json=pidsStats,proto3" json:"pids_stats,omitempty"`
	BlkioStats           *BlkioStats              `protobuf:"bytes,4,opt,name=blkio_stats,json=blkioStats,proto3" json:"blkio_stats,omitempty"`
	HugetlbStats         map[string]*HugetlbStats `protobuf:"bytes,5,rep,name=hugetlb_stats,json=hugetlbStats,proto3" json:"hugetlb_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CgroupStats) Reset()      { *m = CgroupStats{} }
func (*CgroupStats) ProtoMessage() {}
func (*CgroupStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{20}
}
func (m *CgroupStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CgroupStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CgroupStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CgroupStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CgroupStats.Merge(m, src)
}
func (m *CgroupStats) XXX_Size() int {
	return m.Size()
}
func (m *CgroupStats) XXX_DiscardUnknown() {
	xxx_messageInfo_CgroupStats.DiscardUnknown(m)
}

var xxx_messageInfo_CgroupStats proto.InternalMessageInfo

type NetworkStats struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	RxBytes              uint64   `protobuf:"varint,2,opt,name=rx_bytes,json=rxBytes,proto3" json:"rx_bytes,omitempty"`
	RxPackets            uint64   `protobuf:"varint,3,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	RxErrors             uint64   `protobuf:"varint,4,opt,name=rx_errors,json=rxErrors,proto3" json:"rx_errors,omitempty"`
	RxDropped            uint64   `protobuf:"varint,5,opt,name=rx_dropped,json=rxDropped,proto3" json:"rx_dropped,omitempty"`
	TxBytes              uint64   `protobuf:"varint,6,opt,name=tx_bytes,json=txBytes,proto3" json:"tx_bytes,omitempty"`
	TxPackets            uint64   `protobuf:"varint,7,opt,name=tx_packets,json=txPackets,proto3" json:"tx_packets,omitempty"`
	TxErrors             uint64   `protobuf:"varint,8,opt,name=tx_errors,json=txErrors,proto3" json:"tx_errors,omitempty"`
	TxDropped            uint64   `protobuf:"varint,9,opt,name=tx_dropped,json=txDropped,proto3" json:"tx_dropped,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkStats) Reset()      { *m = NetworkStats{} }
func (*NetworkStats) ProtoMessage() {}
func (*NetworkStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{21}
}
func (m *NetworkStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkStats.Merge(m, src)
}
func (m *NetworkStats) XXX_Size() int {
	return m.Size()
}
func (m *NetworkStats) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkStats.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkStats proto.InternalMessageInfo

type StatsContainerResponse struct {
	CgroupStats          *CgroupStats    `protobuf:"bytes,1,opt,name=cgroup_stats,json=cgroupStats,proto3" json:"cgroup_stats,omitempty"`
	NetworkStats         []*NetworkStats `protobuf:"bytes,2,rep,name=network_stats,json=networkStats,proto3" json:"network_stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StatsContainerResponse) Reset()      { *m = StatsContainerResponse{} }
func (*StatsContainerResponse) ProtoMessage() {}
func (*StatsContainerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{22}
}
func (m *StatsContainerResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatsContainerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StatsContainerResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StatsContainerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatsContainerResponse.Merge(m, src)
}
func (m *StatsContainerResponse) XXX_Size() int {
	return m.Size()
}
func (m *StatsContainerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StatsContainerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StatsContainerResponse proto.InternalMessageInfo

type WriteStreamRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	ExecId               string   `protobuf:"bytes,2,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteStreamRequest) Reset()      { *m = WriteStreamRequest{} }
func (*WriteStreamRequest) ProtoMessage() {}
func (*WriteStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{23}
}
func (m *WriteStreamRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteStreamRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteStreamRequest.Merge(m, src)
}
func (m *WriteStreamRequest) XXX_Size() int {
	return m.Size()
}
func (m *WriteStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteStreamRequest proto.InternalMessageInfo

type WriteStreamResponse struct {
	Len                  uint32   `protobuf:"varint,1,opt,name=len,proto3" json:"len,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteStreamResponse) Reset()      { *m = WriteStreamResponse{} }
func (*WriteStreamResponse) ProtoMessage() {}
func (*WriteStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{24}
}
func (m *WriteStreamResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteStreamResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteStreamResponse.Merge(m, src)
}
func (m *WriteStreamResponse) XXX_Size() int {
	return m.Size()
}
func (m *WriteStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WriteStreamResponse proto.InternalMessageInfo

type ReadStreamRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	ExecId               string   `protobuf:"bytes,2,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	Len                  uint32   `protobuf:"varint,3,opt,name=len,proto3" json:"len,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadStreamRequest) Reset()      { *m = ReadStreamRequest{} }
func (*ReadStreamRequest) ProtoMessage() {}
func (*ReadStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{25}
}
func (m *ReadStreamRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadStreamRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReadStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadStreamRequest.Merge(m, src)
}
func (m *ReadStreamRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReadStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadStreamRequest proto.InternalMessageInfo

type ReadStreamResponse struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadStreamResponse) Reset()      { *m = ReadStreamResponse{} }
func (*ReadStreamResponse) ProtoMessage() {}
func (*ReadStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{26}
}
func (m *ReadStreamResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadStreamResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReadStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadStreamResponse.Merge(m, src)
}
func (m *ReadStreamResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReadStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReadStreamResponse proto.InternalMessageInfo

type CloseStdinRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	ExecId               string   `protobuf:"bytes,2,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloseStdinRequest) Reset()      { *m = CloseStdinRequest{} }
func (*CloseStdinRequest) ProtoMessage() {}
func (*CloseStdinRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{27}
}
func (m *CloseStdinRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloseStdinRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloseStdinRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloseStdinRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseStdinRequest.Merge(m, src)
}
func (m *CloseStdinRequest) XXX_Size() int {
	return m.Size()
}
func (m *CloseStdinRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseStdinRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloseStdinRequest proto.InternalMessageInfo

type TtyWinResizeRequest struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	ExecId               string   `protobuf:"bytes,2,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	Row                  uint32   `protobuf:"varint,3,opt,name=row,proto3" json:"row,omitempty"`
	Column               uint32   `protobuf:"varint,4,opt,name=column,proto3" json:"column,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TtyWinResizeRequest) Reset()      { *m = TtyWinResizeRequest{} }
func (*TtyWinResizeRequest) ProtoMessage() {}
func (*TtyWinResizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{28}
}
func (m *TtyWinResizeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TtyWinResizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TtyWinResizeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TtyWinResizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TtyWinResizeRequest.Merge(m, src)
}
func (m *TtyWinResizeRequest) XXX_Size() int {
	return m.Size()
}
func (m *TtyWinResizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TtyWinResizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TtyWinResizeRequest proto.InternalMessageInfo

type KernelModule struct {
	// This field is the name of the kernel module.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field are the parameters for the kernel module which are
	// whitespace-delimited key=value pairs passed to modprobe(8).
	Parameters           []string `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KernelModule) Reset()      { *m = KernelModule{} }
func (*KernelModule) ProtoMessage() {}
func (*KernelModule) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{29}
}
func (m *KernelModule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KernelModule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KernelModule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KernelModule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KernelModule.Merge(m, src)
}
func (m *KernelModule) XXX_Size() int {
	return m.Size()
}
func (m *KernelModule) XXX_DiscardUnknown() {
	xxx_messageInfo_KernelModule.DiscardUnknown(m)
}

var xxx_messageInfo_KernelModule proto.InternalMessageInfo

type CreateSandboxRequest struct {
	Hostname string     `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	Dns      []string   `protobuf:"bytes,2,rep,name=dns,proto3" json:"dns,omitempty"`
	Storages []*Storage `protobuf:"bytes,3,rep,name=storages,proto3" json:"storages,omitempty"`
	// This field means that a pause process needs to be created by the
	// agent. This pid namespace of the pause process will be treated as
	// a shared pid namespace. All containers created will join this shared
	// pid namespace.
	SandboxPidns bool `protobuf:"varint,4,opt,name=sandbox_pidns,json=sandboxPidns,proto3" json:"sandbox_pidns,omitempty"`
	// SandboxId identifies which sandbox is using the agent. We allow only
	// one sandbox per agent and implicitly require that CreateSandbox is
	// called before other sandbox/network calls.
	SandboxId string `protobuf:"bytes,5,opt,name=sandbox_id,json=sandboxId,proto3" json:"sandbox_id,omitempty"`
	// This field, if non-empty, designates an absolute path to a directory
	// that the agent will search for OCI hooks to run within the guest.
	GuestHookPath string `protobuf:"bytes,6,opt,name=guest_hook_path,json=guestHookPath,proto3" json:"guest_hook_path,omitempty"`
	// This field is the list of kernel modules to be loaded in the guest kernel.
	KernelModules        []*KernelModule `protobuf:"bytes,7,rep,name=kernel_modules,json=kernelModules,proto3" json:"kernel_modules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CreateSandboxRequest) Reset()      { *m = CreateSandboxRequest{} }
func (*CreateSandboxRequest) ProtoMessage() {}
func (*CreateSandboxRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{30}
}
func (m *CreateSandboxRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateSandboxRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateSandboxRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateSandboxRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSandboxRequest.Merge(m, src)
}
func (m *CreateSandboxRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreateSandboxRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSandboxRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSandboxRequest proto.InternalMessageInfo

type DestroySandboxRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DestroySandboxRequest) Reset()      { *m = DestroySandboxRequest{} }
func (*DestroySandboxRequest) ProtoMessage() {}
func (*DestroySandboxRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{31}
}
func (m *DestroySandboxRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DestroySandboxRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DestroySandboxRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DestroySandboxRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestroySandboxRequest.Merge(m, src)
}
func (m *DestroySandboxRequest) XXX_Size() int {
	return m.Size()
}
func (m *DestroySandboxRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DestroySandboxRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DestroySandboxRequest proto.InternalMessageInfo

type Interfaces struct {
	Interfaces           []*protocols.Interface `protobuf:"bytes,1,rep,name=Interfaces,proto3" json:"Interfaces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Interfaces) Reset()      { *m = Interfaces{} }
func (*Interfaces) ProtoMessage() {}
func (*Interfaces) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{32}
}
func (m *Interfaces) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Interfaces) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Interfaces.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Interfaces) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Interfaces.Merge(m, src)
}
func (m *Interfaces) XXX_Size() int {
	return m.Size()
}
func (m *Interfaces) XXX_DiscardUnknown() {
	xxx_messageInfo_Interfaces.DiscardUnknown(m)
}

var xxx_messageInfo_Interfaces proto.InternalMessageInfo

type Routes struct {
	Routes               []*protocols.Route `protobuf:"bytes,1,rep,name=Routes,proto3" json:"Routes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Routes) Reset()      { *m = Routes{} }
func (*Routes) ProtoMessage() {}
func (*Routes) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{33}
}
func (m *Routes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Routes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Routes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Routes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Routes.Merge(m, src)
}
func (m *Routes) XXX_Size() int {
	return m.Size()
}
func (m *Routes) XXX_DiscardUnknown() {
	xxx_messageInfo_Routes.DiscardUnknown(m)
}

var xxx_messageInfo_Routes proto.InternalMessageInfo

type UpdateInterfaceRequest struct {
	Interface            *protocols.Interface `protobuf:"bytes,1,opt,name=interface,proto3" json:"interface,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateInterfaceRequest) Reset()      { *m = UpdateInterfaceRequest{} }
func (*UpdateInterfaceRequest) ProtoMessage() {}
func (*UpdateInterfaceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{34}
}
func (m *UpdateInterfaceRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateInterfaceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateInterfaceRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateInterfaceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInterfaceRequest.Merge(m, src)
}
func (m *UpdateInterfaceRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateInterfaceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInterfaceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInterfaceRequest proto.InternalMessageInfo

type UpdateRoutesRequest struct {
	Routes               *Routes  `protobuf:"bytes,1,opt,name=routes,proto3" json:"routes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateRoutesRequest) Reset()      { *m = UpdateRoutesRequest{} }
func (*UpdateRoutesRequest) ProtoMessage() {}
func (*UpdateRoutesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{35}
}
func (m *UpdateRoutesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateRoutesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateRoutesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateRoutesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRoutesRequest.Merge(m, src)
}
func (m *UpdateRoutesRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateRoutesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRoutesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRoutesRequest proto.InternalMessageInfo

type ListInterfacesRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInterfacesRequest) Reset()      { *m = ListInterfacesRequest{} }
func (*ListInterfacesRequest) ProtoMessage() {}
func (*ListInterfacesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{36}
}
func (m *ListInterfacesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListInterfacesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListInterfacesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListInterfacesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInterfacesRequest.Merge(m, src)
}
func (m *ListInterfacesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListInterfacesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInterfacesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInterfacesRequest proto.InternalMessageInfo

type ListRoutesRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRoutesRequest) Reset()      { *m = ListRoutesRequest{} }
func (*ListRoutesRequest) ProtoMessage() {}
func (*ListRoutesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{37}
}
func (m *ListRoutesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListRoutesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListRoutesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListRoutesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRoutesRequest.Merge(m, src)
}
func (m *ListRoutesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListRoutesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRoutesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRoutesRequest proto.InternalMessageInfo

type ARPNeighbors struct {
	ARPNeighbors         []*protocols.ARPNeighbor `protobuf:"bytes,1,rep,name=ARPNeighbors,proto3" json:"ARPNeighbors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ARPNeighbors) Reset()      { *m = ARPNeighbors{} }
func (*ARPNeighbors) ProtoMessage() {}
func (*ARPNeighbors) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{38}
}
func (m *ARPNeighbors) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ARPNeighbors) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ARPNeighbors.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ARPNeighbors) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ARPNeighbors.Merge(m, src)
}
func (m *ARPNeighbors) XXX_Size() int {
	return m.Size()
}
func (m *ARPNeighbors) XXX_DiscardUnknown() {
	xxx_messageInfo_ARPNeighbors.DiscardUnknown(m)
}

var xxx_messageInfo_ARPNeighbors proto.InternalMessageInfo

type AddARPNeighborsRequest struct {
	Neighbors            *ARPNeighbors `protobuf:"bytes,1,opt,name=neighbors,proto3" json:"neighbors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AddARPNeighborsRequest) Reset()      { *m = AddARPNeighborsRequest{} }
func (*AddARPNeighborsRequest) ProtoMessage() {}
func (*AddARPNeighborsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{39}
}
func (m *AddARPNeighborsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddARPNeighborsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddARPNeighborsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddARPNeighborsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddARPNeighborsRequest.Merge(m, src)
}
func (m *AddARPNeighborsRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddARPNeighborsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddARPNeighborsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddARPNeighborsRequest proto.InternalMessageInfo

type OnlineCPUMemRequest struct {
	// Wait specifies if the caller waits for the agent to online all resources.
	// If true the agent returns once all resources have been connected, otherwise all
	// resources are connected asynchronously and the agent returns immediately.
	Wait bool `protobuf:"varint,1,opt,name=wait,proto3" json:"wait,omitempty"`
	// NbCpus specifies the number of CPUs that were added and the agent has to online.
	NbCpus uint32 `protobuf:"varint,2,opt,name=nb_cpus,json=nbCpus,proto3" json:"nb_cpus,omitempty"`
	// CpuOnly specifies whether only online CPU or not.
	CpuOnly              bool     `protobuf:"varint,3,opt,name=cpu_only,json=cpuOnly,proto3" json:"cpu_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OnlineCPUMemRequest) Reset()      { *m = OnlineCPUMemRequest{} }
func (*OnlineCPUMemRequest) ProtoMessage() {}
func (*OnlineCPUMemRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{40}
}
func (m *OnlineCPUMemRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OnlineCPUMemRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OnlineCPUMemRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OnlineCPUMemRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OnlineCPUMemRequest.Merge(m, src)
}
func (m *OnlineCPUMemRequest) XXX_Size() int {
	return m.Size()
}
func (m *OnlineCPUMemRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OnlineCPUMemRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OnlineCPUMemRequest proto.InternalMessageInfo

type ReseedRandomDevRequest struct {
	// Data specifies the random data used to reseed the guest crng.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReseedRandomDevRequest) Reset()      { *m = ReseedRandomDevRequest{} }
func (*ReseedRandomDevRequest) ProtoMessage() {}
func (*ReseedRandomDevRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{41}
}
func (m *ReseedRandomDevRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReseedRandomDevRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReseedRandomDevRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReseedRandomDevRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReseedRandomDevRequest.Merge(m, src)
}
func (m *ReseedRandomDevRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReseedRandomDevRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReseedRandomDevRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReseedRandomDevRequest proto.InternalMessageInfo

// AgentDetails provides information to the client about the running agent.
type AgentDetails struct {
	// Semantic version of agent (see https://semver.org).
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Set if the agent is running as PID 1.
	InitDaemon bool `protobuf:"varint,2,opt,name=init_daemon,json=initDaemon,proto3" json:"init_daemon,omitempty"`
	// List of available device handlers.
	DeviceHandlers []string `protobuf:"bytes,3,rep,name=device_handlers,json=deviceHandlers,proto3" json:"device_handlers,omitempty"`
	// List of available storage handlers.
	StorageHandlers []string `protobuf:"bytes,4,rep,name=storage_handlers,json=storageHandlers,proto3" json:"storage_handlers,omitempty"`
	// Set only if the agent is built with seccomp support and the guest
	// environment supports seccomp.
	SupportsSeccomp      bool     `protobuf:"varint,5,opt,name=supports_seccomp,json=supportsSeccomp,proto3" json:"supports_seccomp,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AgentDetails) Reset()      { *m = AgentDetails{} }
func (*AgentDetails) ProtoMessage() {}
func (*AgentDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{42}
}
func (m *AgentDetails) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AgentDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AgentDetails.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AgentDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgentDetails.Merge(m, src)
}
func (m *AgentDetails) XXX_Size() int {
	return m.Size()
}
func (m *AgentDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_AgentDetails.DiscardUnknown(m)
}

var xxx_messageInfo_AgentDetails proto.InternalMessageInfo

type GuestDetailsRequest struct {
	// MemBlockSize asks server to return the system memory block size that can be used
	// for memory hotplug alignment. Typically the server returns what's in
	// /sys/devices/system/memory/block_size_bytes.
	MemBlockSize bool `protobuf:"varint,1,opt,name=mem_block_size,json=memBlockSize,proto3" json:"mem_block_size,omitempty"`
	// MemoryHotplugProbe asks server to return whether guest kernel supports memory hotplug
	// via probeinterface. Typically the server will check if the path
	// /sys/devices/system/memory/probe exists.
	MemHotplugProbe      bool     `protobuf:"varint,2,opt,name=mem_hotplug_probe,json=memHotplugProbe,proto3" json:"mem_hotplug_probe,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GuestDetailsRequest) Reset()      { *m = GuestDetailsRequest{} }
func (*GuestDetailsRequest) ProtoMessage() {}
func (*GuestDetailsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{43}
}
func (m *GuestDetailsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GuestDetailsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GuestDetailsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GuestDetailsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GuestDetailsRequest.Merge(m, src)
}
func (m *GuestDetailsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GuestDetailsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GuestDetailsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GuestDetailsRequest proto.InternalMessageInfo

type GuestDetailsResponse struct {
	// MemBlockSizeBytes returns the system memory block size in bytes.
	MemBlockSizeBytes      uint64        `protobuf:"varint,1,opt,name=mem_block_size_bytes,json=memBlockSizeBytes,proto3" json:"mem_block_size_bytes,omitempty"`
	AgentDetails           *AgentDetails `protobuf:"bytes,2,opt,name=agent_details,json=agentDetails,proto3" json:"agent_details,omitempty"`
	SupportMemHotplugProbe bool          `protobuf:"varint,3,opt,name=support_mem_hotplug_probe,json=supportMemHotplugProbe,proto3" json:"support_mem_hotplug_probe,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}      `json:"-"`
	XXX_unrecognized       []byte        `json:"-"`
	XXX_sizecache          int32         `json:"-"`
}

func (m *GuestDetailsResponse) Reset()      { *m = GuestDetailsResponse{} }
func (*GuestDetailsResponse) ProtoMessage() {}
func (*GuestDetailsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{44}
}
func (m *GuestDetailsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GuestDetailsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GuestDetailsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GuestDetailsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GuestDetailsResponse.Merge(m, src)
}
func (m *GuestDetailsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GuestDetailsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GuestDetailsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GuestDetailsResponse proto.InternalMessageInfo

type MemHotplugByProbeRequest struct {
	// server needs to send the value of memHotplugProbeAddr into file /sys/devices/system/memory/probe,
	// in order to notify the guest kernel about hot-add memory event
	MemHotplugProbeAddr  []uint64 `protobuf:"varint,1,rep,packed,name=memHotplugProbeAddr,proto3" json:"memHotplugProbeAddr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MemHotplugByProbeRequest) Reset()      { *m = MemHotplugByProbeRequest{} }
func (*MemHotplugByProbeRequest) ProtoMessage() {}
func (*MemHotplugByProbeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{45}
}
func (m *MemHotplugByProbeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemHotplugByProbeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemHotplugByProbeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemHotplugByProbeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemHotplugByProbeRequest.Merge(m, src)
}
func (m *MemHotplugByProbeRequest) XXX_Size() int {
	return m.Size()
}
func (m *MemHotplugByProbeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MemHotplugByProbeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MemHotplugByProbeRequest proto.InternalMessageInfo

type SetGuestDateTimeRequest struct {
	// Sec the second since the Epoch.
	Sec int64 `protobuf:"varint,1,opt,name=Sec,proto3" json:"Sec,omitempty"`
	// Usec the microseconds portion of time since the Epoch.
	Usec                 int64    `protobuf:"varint,2,opt,name=Usec,proto3" json:"Usec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetGuestDateTimeRequest) Reset()      { *m = SetGuestDateTimeRequest{} }
func (*SetGuestDateTimeRequest) ProtoMessage() {}
func (*SetGuestDateTimeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{46}
}
func (m *SetGuestDateTimeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SetGuestDateTimeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SetGuestDateTimeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SetGuestDateTimeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetGuestDateTimeRequest.Merge(m, src)
}
func (m *SetGuestDateTimeRequest) XXX_Size() int {
	return m.Size()
}
func (m *SetGuestDateTimeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetGuestDateTimeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetGuestDateTimeRequest proto.InternalMessageInfo

// Storage represents both the rootfs of the container, and any volume that
// could have been defined through the Mount list of the OCI specification.
type Storage struct {
	// Driver is used to define the way the storage is passed through the
	// virtual machine. It can be "9p", "blk", or something else, but for
	// all cases, this will define if some extra steps are required before
	// this storage gets mounted into the container.
	Driver string `protobuf:"bytes,1,opt,name=driver,proto3" json:"driver,omitempty"`
	// DriverOptions allows the caller to define a list of options such
	// as block sizes, numbers of luns, ... which are very specific to
	// every device and cannot be generalized through extra fields.
	DriverOptions []string `protobuf:"bytes,2,rep,name=driver_options,json=driverOptions,proto3" json:"driver_options,omitempty"`
	// Source can be anything representing the source of the storage. This
	// will be handled by the proper handler based on the Driver used.
	// For instance, it can be a very simple path if the caller knows the
	// name of device inside the VM, or it can be some sort of identifier
	// to let the agent find the device inside the VM.
	Source string `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// Fstype represents the filesystem that needs to be used to mount the
	// storage inside the VM. For instance, it could be "xfs" for block
	// device, "9p" for shared filesystem, or "tmpfs" for shared /dev/shm.
	Fstype string `protobuf:"bytes,4,opt,name=fstype,proto3" json:"fstype,omitempty"`
	// Options describes the additional options that might be needed to
	// mount properly the storage filesytem.
	Options []string `protobuf:"bytes,5,rep,name=options,proto3" json:"options,omitempty"`
	// MountPoint refers to the path where the storage should be mounted
	// inside the VM.
	MountPoint           string   `protobuf:"bytes,6,opt,name=mount_point,json=mountPoint,proto3" json:"mount_point,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Storage) Reset()      { *m = Storage{} }
func (*Storage) ProtoMessage() {}
func (*Storage) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{47}
}
func (m *Storage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Storage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Storage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Storage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Storage.Merge(m, src)
}
func (m *Storage) XXX_Size() int {
	return m.Size()
}
func (m *Storage) XXX_DiscardUnknown() {
	xxx_messageInfo_Storage.DiscardUnknown(m)
}

var xxx_messageInfo_Storage proto.InternalMessageInfo

// Device represents only the devices that could have been defined through the
// Linux Device list of the OCI specification.
type Device struct {
	// Id can be used to identify the device inside the VM. Some devices
	// might not need it to be identified on the VM, and will rely on the
	// provided VmPath instead.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Type defines the type of device described. This can be "blk",
	// "scsi", "vfio", ...
	// Particularly, this should be used to trigger the use of the
	// appropriate device handler.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// VmPath can be used by the caller to provide directly the path of
	// the device as it will appear inside the VM. For some devices, the
	// device id or the list of options passed might not be enough to find
	// the device. In those cases, the caller should predict and provide
	// this vm_path.
	VmPath string `protobuf:"bytes,3,opt,name=vm_path,json=vmPath,proto3" json:"vm_path,omitempty"`
	// ContainerPath defines the path where the device should be found inside
	// the container. This path should match the path of the device from
	// the device list listed inside the OCI spec. This is used in order
	// to identify the right device in the spec and update it with the
	// right options such as major/minor numbers as they appear inside
	// the VM for instance. Note that an empty ctr_path should be used
	// to make sure the device handler inside the agent is called, but
	// no spec update needs to be performed. This has to happen for the
	// case of rootfs, when a device has to be waited for after it has
	// been hotplugged. An equivalent Storage entry should be defined if
	// any mount needs to be performed afterwards.
	ContainerPath string `protobuf:"bytes,4,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Options allows the caller to define a list of options such as block
	// sizes, numbers of luns, ... which are very specific to every device
	// and cannot be generalized through extra fields.
	Options              []string `protobuf:"bytes,5,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Device) Reset()      { *m = Device{} }
func (*Device) ProtoMessage() {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{48}
}
func (m *Device) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Device.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return m.Size()
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

type StringUser struct {
	Uid                  string   `protobuf:"bytes,1,opt,name=uid,proto3" json:"uid,omitempty"`
	Gid                  string   `protobuf:"bytes,2,opt,name=gid,proto3" json:"gid,omitempty"`
	AdditionalGids       []string `protobuf:"bytes,3,rep,name=additionalGids,proto3" json:"additionalGids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StringUser) Reset()      { *m = StringUser{} }
func (*StringUser) ProtoMessage() {}
func (*StringUser) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{49}
}
func (m *StringUser) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringUser) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringUser.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringUser) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringUser.Merge(m, src)
}
func (m *StringUser) XXX_Size() int {
	return m.Size()
}
func (m *StringUser) XXX_DiscardUnknown() {
	xxx_messageInfo_StringUser.DiscardUnknown(m)
}

var xxx_messageInfo_StringUser proto.InternalMessageInfo

type CopyFileRequest struct {
	// Path is the destination file in the guest. It must be absolute,
	// canonical and below /run.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// FileSize is the expected file size, for security reasons write operations
	// are made in a temporary file, once it has the expected size, it's moved
	// to the destination path.
	FileSize int64 `protobuf:"varint,2,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	// FileMode is the file mode.
	FileMode uint32 `protobuf:"varint,3,opt,name=file_mode,json=fileMode,proto3" json:"file_mode,omitempty"`
	// DirMode is the mode for the parent directories of destination path.
	DirMode uint32 `protobuf:"varint,4,opt,name=dir_mode,json=dirMode,proto3" json:"dir_mode,omitempty"`
	// Uid is the numeric user id.
	Uid int32 `protobuf:"varint,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// Gid is the numeric group id.
	Gid int32 `protobuf:"varint,6,opt,name=gid,proto3" json:"gid,omitempty"`
	// Offset for the next write operation.
	Offset int64 `protobuf:"varint,7,opt,name=offset,proto3" json:"offset,omitempty"`
	// Data to write in the destination file.
	Data                 []byte   `protobuf:"bytes,8,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CopyFileRequest) Reset()      { *m = CopyFileRequest{} }
func (*CopyFileRequest) ProtoMessage() {}
func (*CopyFileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{50}
}
func (m *CopyFileRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CopyFileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CopyFileRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CopyFileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CopyFileRequest.Merge(m, src)
}
func (m *CopyFileRequest) XXX_Size() int {
	return m.Size()
}
func (m *CopyFileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CopyFileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CopyFileRequest proto.InternalMessageInfo

type GetOOMEventRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOOMEventRequest) Reset()      { *m = GetOOMEventRequest{} }
func (*GetOOMEventRequest) ProtoMessage() {}
func (*GetOOMEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{51}
}
func (m *GetOOMEventRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetOOMEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetOOMEventRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetOOMEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOOMEventRequest.Merge(m, src)
}
func (m *GetOOMEventRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetOOMEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOOMEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOOMEventRequest proto.InternalMessageInfo

type OOMEvent struct {
	ContainerId          string   `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OOMEvent) Reset()      { *m = OOMEvent{} }
func (*OOMEvent) ProtoMessage() {}
func (*OOMEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{52}
}
func (m *OOMEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OOMEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OOMEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OOMEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OOMEvent.Merge(m, src)
}
func (m *OOMEvent) XXX_Size() int {
	return m.Size()
}
func (m *OOMEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_OOMEvent.DiscardUnknown(m)
}

var xxx_messageInfo_OOMEvent proto.InternalMessageInfo

type AddSwapRequest struct {
	PCIPath              []uint32 `protobuf:"varint,1,rep,packed,name=PCIPath,proto3" json:"PCIPath,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddSwapRequest) Reset()      { *m = AddSwapRequest{} }
func (*AddSwapRequest) ProtoMessage() {}
func (*AddSwapRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{53}
}
func (m *AddSwapRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSwapRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddSwapRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddSwapRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSwapRequest.Merge(m, src)
}
func (m *AddSwapRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddSwapRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSwapRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddSwapRequest proto.InternalMessageInfo

type GetMetricsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMetricsRequest) Reset()      { *m = GetMetricsRequest{} }
func (*GetMetricsRequest) ProtoMessage() {}
func (*GetMetricsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{54}
}
func (m *GetMetricsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetMetricsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetMetricsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetMetricsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMetricsRequest.Merge(m, src)
}
func (m *GetMetricsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetMetricsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMetricsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMetricsRequest proto.InternalMessageInfo

type Metrics struct {
	Metrics              string   `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics) Reset()      { *m = Metrics{} }
func (*Metrics) ProtoMessage() {}
func (*Metrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1460208c38ccf5e, []int{55}
}
func (m *Metrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Metrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics.Merge(m, src)
}
func (m *Metrics) XXX_Size() int {
	return m.Size()
}
func (m *Metrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics proto.InternalMessageInfo

func init() {
	proto.RegisterType((*CreateContainerRequest)(nil), "grpc.CreateContainerRequest")
	proto.RegisterType((*StartContainerRequest)(nil), "grpc.StartContainerRequest")
	proto.RegisterType((*RemoveContainerRequest)(nil), "grpc.RemoveContainerRequest")
	proto.RegisterType((*ExecProcessRequest)(nil), "grpc.ExecProcessRequest")
	proto.RegisterType((*SignalProcessRequest)(nil), "grpc.SignalProcessRequest")
	proto.RegisterType((*WaitProcessRequest)(nil), "grpc.WaitProcessRequest")
	proto.RegisterType((*WaitProcessResponse)(nil), "grpc.WaitProcessResponse")
	proto.RegisterType((*UpdateContainerRequest)(nil), "grpc.UpdateContainerRequest")
	proto.RegisterType((*StatsContainerRequest)(nil), "grpc.StatsContainerRequest")
	proto.RegisterType((*PauseContainerRequest)(nil), "grpc.PauseContainerRequest")
	proto.RegisterType((*ResumeContainerRequest)(nil), "grpc.ResumeContainerRequest")
	proto.RegisterType((*CpuUsage)(nil), "grpc.CpuUsage")
	proto.RegisterType((*ThrottlingData)(nil), "grpc.ThrottlingData")
	proto.RegisterType((*CpuStats)(nil), "grpc.CpuStats")
	proto.RegisterType((*PidsStats)(nil), "grpc.PidsStats")
	proto.RegisterType((*MemoryData)(nil), "grpc.MemoryData")
	proto.RegisterType((*MemoryStats)(nil), "grpc.MemoryStats")
	proto.RegisterMapType((map[string]uint64)(nil), "grpc.MemoryStats.StatsEntry")
	proto.RegisterType((*BlkioStatsEntry)(nil), "grpc.BlkioStatsEntry")
	proto.RegisterType((*BlkioStats)(nil), "grpc.BlkioStats")
	proto.RegisterType((*HugetlbStats)(nil), "grpc.HugetlbStats")
	proto.RegisterType((*CgroupStats)(nil), "grpc.CgroupStats")
	proto.RegisterMapType((map[string]*HugetlbStats)(nil), "grpc.CgroupStats.HugetlbStatsEntry")
	proto.RegisterType((*NetworkStats)(nil), "grpc.NetworkStats")
	proto.RegisterType((*StatsContainerResponse)(nil), "grpc.StatsContainerResponse")
	proto.RegisterType((*WriteStreamRequest)(nil), "grpc.WriteStreamRequest")
	proto.RegisterType((*WriteStreamResponse)(nil), "grpc.WriteStreamResponse")
	proto.RegisterType((*ReadStreamRequest)(nil), "grpc.ReadStreamRequest")
	proto.RegisterType((*ReadStreamResponse)(nil), "grpc.ReadStreamResponse")
	proto.RegisterType((*CloseStdinRequest)(nil), "grpc.CloseStdinRequest")
	proto.RegisterType((*TtyWinResizeRequest)(nil), "grpc.TtyWinResizeRequest")
	proto.RegisterType((*KernelModule)(nil), "grpc.KernelModule")
	proto.RegisterType((*CreateSandboxRequest)(nil), "grpc.CreateSandboxRequest")
	proto.RegisterType((*DestroySandboxRequest)(nil), "grpc.DestroySandboxRequest")
	proto.RegisterType((*Interfaces)(nil), "grpc.Interfaces")
	proto.RegisterType((*Routes)(nil), "grpc.Routes")
	proto.RegisterType((*UpdateInterfaceRequest)(nil), "grpc.UpdateInterfaceRequest")
	proto.RegisterType((*UpdateRoutesRequest)(nil), "grpc.UpdateRoutesRequest")
	proto.RegisterType((*ListInterfacesRequest)(nil), "grpc.ListInterfacesRequest")
	proto.RegisterType((*ListRoutesRequest)(nil), "grpc.ListRoutesRequest")
	proto.RegisterType((*ARPNeighbors)(nil), "grpc.ARPNeighbors")
	proto.RegisterType((*AddARPNeighborsRequest)(nil), "grpc.AddARPNeighborsRequest")
	proto.RegisterType((*OnlineCPUMemRequest)(nil), "grpc.OnlineCPUMemRequest")
	proto.RegisterType((*ReseedRandomDevRequest)(nil), "grpc.ReseedRandomDevRequest")
	proto.RegisterType((*AgentDetails)(nil), "grpc.AgentDetails")
	proto.RegisterType((*GuestDetailsRequest)(nil), "grpc.GuestDetailsRequest")
	proto.RegisterType((*GuestDetailsResponse)(nil), "grpc.GuestDetailsResponse")
	proto.RegisterType((*MemHotplugByProbeRequest)(nil), "grpc.MemHotplugByProbeRequest")
	proto.RegisterType((*SetGuestDateTimeRequest)(nil), "grpc.SetGuestDateTimeRequest")
	proto.RegisterType((*Storage)(nil), "grpc.Storage")
	proto.RegisterType((*Device)(nil), "grpc.Device")
	proto.RegisterType((*StringUser)(nil), "grpc.StringUser")
	proto.RegisterType((*CopyFileRequest)(nil), "grpc.CopyFileRequest")
	proto.RegisterType((*GetOOMEventRequest)(nil), "grpc.GetOOMEventRequest")
	proto.RegisterType((*OOMEvent)(nil), "grpc.OOMEvent")
	proto.RegisterType((*AddSwapRequest)(nil), "grpc.AddSwapRequest")
	proto.RegisterType((*GetMetricsRequest)(nil), "grpc.GetMetricsRequest")
	proto.RegisterType((*Metrics)(nil), "grpc.Metrics")
}

func init() {
	proto.RegisterFile("github.com/kata-containers/kata-containers/src/agent/protocols/protos/agent.proto", fileDescriptor_c1460208c38ccf5e)
}

var fileDescriptor_c1460208c38ccf5e = []byte{
	// 2973 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x3a, 0x4b, 0x6f, 0x23, 0xc7,
	0xd1, 0xe6, 0x43, 0x22, 0x59, 0x7c, 0x89, 0x23, 0xad, 0x96, 0x4b, 0xdb, 0xfa, 0xd6, 0xb3, 0xf6,
	0x7a, 0x6d, 0x7f, 0xe6, 0xda, 0x6b, 0xe3, 0x5b, 0x3f, 0xe0, 0x6f, 0xa1, 0x97, 0x25, 0xd9, 0x96,
	0x45, 0x8f, 0x2c, 0xf8, 0xc3, 0x17, 0x24, 0x83, 0xd1, 0x4c, 0x8b, 0x6c, 0x8b, 0x33, 0x3d, 0xee,
	0xe9, 0xd1, 0x8a, 0x0e, 0x10, 0xe4, 0x94, 0xdc, 0x72, 0xcc, 0x2d, 0x7f, 0x20, 0xc8, 0x2d, 0x40,
	0x2e, 0xb9, 0xe6, 0x60, 0xe4, 0x94, 0x63, 0x4e, 0x41, 0xbc, 0x3f, 0x21, 0xbf, 0x20, 0xe8, 0xd7,
	0x3c, 0xf8, 0x90, 0x13, 0x41, 0x40, 0x2e, 0x44, 0x57, 0x75, 0x75, 0xbd, 0xba, 0xab, 0xba, 0xaa,
	0x87, 0xf0, 0xc5, 0x10, 0xb3, 0x51, 0x7c, 0xda, 0x77, 0x89, 0xff, 0xf0, 0xdc, 0x61, 0xce, 0x9b,
	0x2e, 0x09, 0x98, 0x83, 0x03, 0x44, 0xa3, 0x19, 0x38, 0xa2, 0xee, 0x43, 0x67, 0x88, 0x02, 0xf6,
	0x30, 0xa4, 0x84, 0x11, 0x97, 0x8c, 0x23, 0x39, 0x8a, 0x24, 0xba, 0x2f, 0x00, 0xa3, 0x3c, 0xa4,
	0xa1, 0xdb, 0xab, 0x11, 0x17, 0x4b, 0x44, 0xaf, 0xce, 0x26, 0x21, 0x8a, 0x14, 0xf0, 0xfc, 0x90,
	0x90, 0xe1, 0x18, 0xc9, 0x85, 0xa7, 0xf1, 0xd9, 0x43, 0xe4, 0x87, 0x6c, 0x22, 0x27, 0xcd, 0xdf,
	0x14, 0x61, 0x7d, 0x9b, 0x22, 0x87, 0xa1, 0x6d, 0x2d, 0xd6, 0x42, 0xdf, 0xc4, 0x28, 0x62, 0xc6,
	0x4b, 0xd0, 0x48, 0x54, 0xb1, 0xb1, 0xd7, 0x2d, 0xdc, 0x2d, 0x3c, 0xa8, 0x59, 0xf5, 0x04, 0x77,
	0xe0, 0x19, 0xb7, 0xa1, 0x82, 0x2e, 0x91, 0xcb, 0x67, 0x8b, 0x62, 0x76, 0x99, 0x83, 0x07, 0x9e,
	0xf1, 0x36, 0xd4, 0x23, 0x46, 0x71, 0x30, 0xb4, 0xe3, 0x08, 0xd1, 0x6e, 0xe9, 0x6e, 0xe1, 0x41,
	0xfd, 0xd1, 0x4a, 0x9f, 0xeb, 0xd9, 0x3f, 0x16, 0x13, 0x27, 0x11, 0xa2, 0x16, 0x44, 0xc9, 0xd8,
	0xb8, 0x0f, 0x15, 0x0f, 0x5d, 0x60, 0x17, 0x45, 0xdd, 0xf2, 0xdd, 0xd2, 0x83, 0xfa, 0xa3, 0x86,
	0x24, 0xdf, 0x11, 0x48, 0x4b, 0x4f, 0x1a, 0xaf, 0x41, 0x35, 0x62, 0x84, 0x3a, 0x43, 0x14, 0x75,
	0x97, 0x04, 0x61, 0x53, 0xf3, 0x15, 0x58, 0x2b, 0x99, 0x36, 0x5e, 0x80, 0xd2, 0xd1, 0xf6, 0x41,
	0x77, 0x59, 0x48, 0x07, 0x45, 0x15, 0x22, 0xd7, 0xe2, 0x68, 0xe3, 0x1e, 0x34, 0x23, 0x27, 0xf0,
	0x4e, 0xc9, 0xa5, 0x1d, 0x62, 0x2f, 0x88, 0xba, 0x95, 0xbb, 0x85, 0x07, 0x55, 0xab, 0xa1, 0x90,
	0x03, 0x8e, 0x33, 0x3f, 0x80, 0x5b, 0xc7, 0xcc, 0xa1, 0xec, 0x1a, 0xde, 0x31, 0x4f, 0x60, 0xdd,
	0x42, 0x3e, 0xb9, 0xb8, 0x96, 0x6b, 0xbb, 0x50, 0x61, 0xd8, 0x47, 0x24, 0x66, 0xc2, 0xb5, 0x4d,
	0x4b, 0x83, 0xe6, 0xef, 0x0a, 0x60, 0xec, 0x5e, 0x22, 0x77, 0x40, 0x89, 0x8b, 0xa2, 0xe8, 0x3f,
	0xb4, 0x5d, 0xaf, 0x42, 0x25, 0x94, 0x0a, 0x74, 0xcb, 0x82, 0x5c, 0xed, 0x82, 0xd6, 0x4a, 0xcf,
	0x9a, 0x5f, 0xc3, 0xda, 0x31, 0x1e, 0x06, 0xce, 0xf8, 0x06, 0xf5, 0x5d, 0x87, 0xe5, 0x48, 0xf0,
	0x14, 0xaa, 0x36, 0x2d, 0x05, 0x99, 0x03, 0x30, 0xbe, 0x72, 0x30, 0xbb, 0x39, 0x49, 0xe6, 0x9b,
	0xb0, 0x9a, 0xe3, 0x18, 0x85, 0x24, 0x88, 0x90, 0x50, 0x80, 0x39, 0x2c, 0x8e, 0x04, 0xb3, 0x25,
	0x4b, 0x41, 0x26, 0x81, 0xf5, 0x93, 0xd0, 0xbb, 0x66, 0x34, 0x3d, 0x82, 0x1a, 0x45, 0x11, 0x89,
	0x29, 0x8f, 0x81, 0xa2, 0x70, 0xea, 0x9a, 0x74, 0xea, 0x67, 0x38, 0x88, 0x2f, 0x2d, 0x3d, 0x67,
	0xa5, 0x64, 0xea, 0x7c, 0xb2, 0xe8, 0x3a, 0xe7, 0xf3, 0x03, 0xb8, 0x35, 0x70, 0xe2, 0xe8, 0x3a,
	0xba, 0x9a, 0x1f, 0xf2, 0xb3, 0x1d, 0xc5, 0xfe, 0xb5, 0x16, 0xff, 0xb6, 0x00, 0xd5, 0xed, 0x30,
	0x3e, 0x89, 0x9c, 0x21, 0x32, 0xfe, 0x0b, 0xea, 0x8c, 0x30, 0x67, 0x6c, 0xc7, 0x1c, 0x14, 0xe4,
	0x65, 0x0b, 0x04, 0x4a, 0x12, 0xbc, 0x04, 0x8d, 0x10, 0x51, 0x37, 0x8c, 0x15, 0x45, 0xf1, 0x6e,
	0xe9, 0x41, 0xd9, 0xaa, 0x4b, 0x9c, 0x24, 0xe9, 0xc3, 0xaa, 0x98, 0xb3, 0x71, 0x60, 0x9f, 0x23,
	0x1a, 0xa0, 0xb1, 0x4f, 0x3c, 0x24, 0x0e, 0x47, 0xd9, 0xea, 0x88, 0xa9, 0x83, 0xe0, 0xd3, 0x64,
	0xc2, 0x78, 0x1d, 0x3a, 0x09, 0x3d, 0x3f, 0xf1, 0x82, 0xba, 0x2c, 0xa8, 0xdb, 0x8a, 0xfa, 0x44,
	0xa1, 0xcd, 0x9f, 0x41, 0xeb, 0xcb, 0x11, 0x25, 0x8c, 0x8d, 0x71, 0x30, 0xdc, 0x71, 0x98, 0xc3,
	0x43, 0x33, 0x44, 0x14, 0x13, 0x2f, 0x52, 0xda, 0x6a, 0xd0, 0x78, 0x03, 0x3a, 0x4c, 0xd2, 0x22,
	0xcf, 0xd6, 0x34, 0x45, 0x41, 0xb3, 0x92, 0x4c, 0x0c, 0x14, 0xf1, 0x2b, 0xd0, 0x4a, 0x89, 0x79,
	0x70, 0x2b, 0x7d, 0x9b, 0x09, 0xf6, 0x4b, 0xec, 0x23, 0xf3, 0x42, 0xf8, 0x4a, 0x6c, 0xb2, 0xf1,
	0x06, 0xd4, 0x52, 0x3f, 0x14, 0xc4, 0x09, 0x69, 0xc9, 0x13, 0xa2, 0xdd, 0x69, 0x55, 0x13, 0xa7,
	0x7c, 0x04, 0x6d, 0x96, 0x28, 0x6e, 0x7b, 0x0e, 0x73, 0xf2, 0x87, 0x2a, 0x6f, 0x95, 0xd5, 0x62,
	0x39, 0xd8, 0xfc, 0x10, 0x6a, 0x03, 0xec, 0x45, 0x52, 0x70, 0x17, 0x2a, 0x6e, 0x4c, 0x29, 0x0a,
	0x98, 0x36, 0x59, 0x81, 0xc6, 0x1a, 0x2c, 0x8d, 0xb1, 0x8f, 0x99, 0x32, 0x53, 0x02, 0x26, 0x01,
	0x38, 0x44, 0x3e, 0xa1, 0x13, 0xe1, 0xb0, 0x35, 0x58, 0xca, 0x6e, 0xae, 0x04, 0x8c, 0xe7, 0xa1,
	0xe6, 0x3b, 0x97, 0xc9, 0xa6, 0xf2, 0x99, 0xaa, 0xef, 0x5c, 0x4a, 0xe5, 0xbb, 0x50, 0x39, 0x73,
	0xf0, 0xd8, 0x0d, 0x98, 0xf2, 0x8a, 0x06, 0x53, 0x81, 0xe5, 0xac, 0xc0, 0x3f, 0x15, 0xa1, 0x2e,
	0x25, 0x4a, 0x85, 0xd7, 0x60, 0xc9, 0x75, 0xdc, 0x51, 0x22, 0x52, 0x00, 0xc6, 0x7d, 0xad, 0x48,
	0x31, 0x9b, 0xe1, 0x52, 0x4d, 0xb5, 0x6a, 0x0f, 0x01, 0xa2, 0xa7, 0x4e, 0xa8, 0x74, 0x2b, 0x2d,
	0x20, 0xae, 0x71, 0x1a, 0xa9, 0xee, 0x3b, 0xd0, 0x90, 0xe7, 0x4e, 0x2d, 0x29, 0x2f, 0x58, 0x52,
	0x97, 0x54, 0x72, 0xd1, 0x3d, 0x68, 0xc6, 0x11, 0xb2, 0x47, 0x18, 0x51, 0x87, 0xba, 0xa3, 0x49,
	0x77, 0x49, 0x5e, 0x40, 0x71, 0x84, 0xf6, 0x35, 0xce, 0x78, 0x04, 0x4b, 0x3c, 0xb7, 0x44, 0xdd,
	0x65, 0x71, 0xd7, 0xbd, 0x90, 0x65, 0x29, 0x4c, 0xed, 0x8b, 0xdf, 0xdd, 0x80, 0xd1, 0x89, 0x25,
	0x49, 0x7b, 0xef, 0x01, 0xa4, 0x48, 0x63, 0x05, 0x4a, 0xe7, 0x68, 0xa2, 0xe2, 0x90, 0x0f, 0xb9,
	0x73, 0x2e, 0x9c, 0x71, 0xac, 0xbd, 0x2e, 0x81, 0x0f, 0x8a, 0xef, 0x15, 0x4c, 0x17, 0xda, 0x5b,
	0xe3, 0x73, 0x4c, 0x32, 0xcb, 0xd7, 0x60, 0xc9, 0x77, 0xbe, 0x26, 0x54, 0x7b, 0x52, 0x00, 0x02,
	0x8b, 0x03, 0x42, 0x35, 0x0b, 0x01, 0x18, 0x2d, 0x28, 0x92, 0x50, 0xf8, 0xab, 0x66, 0x15, 0x49,
	0x98, 0x0a, 0x2a, 0x67, 0x04, 0x99, 0x7f, 0x2b, 0x03, 0xa4, 0x52, 0x0c, 0x0b, 0x7a, 0x98, 0xd8,
	0x11, 0xa2, 0xfc, 0x7e, 0xb7, 0x4f, 0x27, 0x0c, 0x45, 0x36, 0x45, 0x6e, 0x4c, 0x23, 0x7c, 0xc1,
	0xf7, 0x8f, 0x9b, 0x7d, 0x4b, 0x9a, 0x3d, 0xa5, 0x9b, 0x75, 0x1b, 0x93, 0x63, 0xb9, 0x6e, 0x8b,
	0x2f, 0xb3, 0xf4, 0x2a, 0xe3, 0x00, 0x6e, 0xa5, 0x3c, 0xbd, 0x0c, 0xbb, 0xe2, 0x55, 0xec, 0x56,
	0x13, 0x76, 0x5e, 0xca, 0x6a, 0x17, 0x56, 0x31, 0xb1, 0xbf, 0x89, 0x51, 0x9c, 0x63, 0x54, 0xba,
	0x8a, 0x51, 0x07, 0x93, 0x2f, 0xc4, 0x82, 0x94, 0xcd, 0x00, 0xee, 0x64, 0xac, 0xe4, 0xe1, 0x9e,
	0x61, 0x56, 0xbe, 0x8a, 0xd9, 0x7a, 0xa2, 0x15, 0xcf, 0x07, 0x29, 0xc7, 0x4f, 0x60, 0x1d, 0x13,
	0xfb, 0xa9, 0x83, 0xd9, 0x34, 0xbb, 0xa5, 0x1f, 0x30, 0x92, 0xdf, 0x68, 0x79, 0x5e, 0xd2, 0x48,
	0x1f, 0xd1, 0x61, 0xce, 0xc8, 0xe5, 0x1f, 0x30, 0xf2, 0x50, 0x2c, 0x48, 0xd9, 0x6c, 0x42, 0x07,
	0x93, 0x69, 0x6d, 0x2a, 0x57, 0x31, 0x69, 0x63, 0x92, 0xd7, 0x64, 0x0b, 0x3a, 0x11, 0x72, 0x19,
	0xa1, 0xd9, 0x43, 0x50, 0xbd, 0x8a, 0xc5, 0x8a, 0xa2, 0x4f, 0x78, 0x98, 0x3f, 0x82, 0xc6, 0x7e,
	0x3c, 0x44, 0x6c, 0x7c, 0x9a, 0x24, 0x83, 0x1b, 0xcb, 0x3f, 0xe6, 0x3f, 0x8a, 0x50, 0xdf, 0x1e,
	0x52, 0x12, 0x87, 0xb9, 0x9c, 0x2c, 0x83, 0x74, 0x3a, 0x27, 0x0b, 0x12, 0x91, 0x93, 0x25, 0xf1,
	0xbb, 0xd0, 0xf0, 0x45, 0xe8, 0x2a, 0x7a, 0x99, 0x87, 0x3a, 0x33, 0x41, 0x6d, 0xd5, 0xfd, 0x4c,
	0x32, 0xeb, 0x03, 0x84, 0xd8, 0x8b, 0xd4, 0x1a, 0x99, 0x8e, 0xda, 0xaa, 0xdc, 0xd2, 0x29, 0xda,
	0xaa, 0x85, 0x49, 0xb6, 0x7e, 0x1b, 0xea, 0xa7, 0xdc, 0x49, 0x6a, 0x41, 0x2e, 0x19, 0xa5, 0xde,
	0xb3, 0xe0, 0x34, 0x0d, 0xc2, 0x7d, 0x68, 0x8e, 0xa4, 0xcb, 0xd4, 0x22, 0x79, 0x86, 0xee, 0x29,
	0x4b, 0x52, 0x7b, 0xfb, 0x59, 0xcf, 0xca, 0x0d, 0x68, 0x8c, 0x32, 0xa8, 0xde, 0x31, 0x74, 0x66,
	0x48, 0xe6, 0xe4, 0xa0, 0x07, 0xd9, 0x1c, 0x54, 0x7f, 0x64, 0x48, 0x41, 0xd9, 0x95, 0xd9, 0xbc,
	0xf4, 0xab, 0x22, 0x34, 0x3e, 0x47, 0xec, 0x29, 0xa1, 0xe7, 0x52, 0x5f, 0x03, 0xca, 0x81, 0xe3,
	0x23, 0xc5, 0x51, 0x8c, 0x8d, 0x3b, 0x50, 0xa5, 0x97, 0x32, 0x81, 0xa8, 0xfd, 0xac, 0xd0, 0x4b,
	0x91, 0x18, 0x8c, 0x17, 0x01, 0xe8, 0xa5, 0x1d, 0x3a, 0xee, 0x39, 0x52, 0x1e, 0x2c, 0x5b, 0x35,
	0x7a, 0x39, 0x90, 0x08, 0x7e, 0x14, 0xe8, 0xa5, 0x8d, 0x28, 0x25, 0x34, 0x52, 0xb9, 0xaa, 0x4a,
	0x2f, 0x77, 0x05, 0xac, 0xd6, 0x7a, 0x94, 0x84, 0x21, 0xf2, 0x44, 0x8e, 0x16, 0x6b, 0x77, 0x24,
	0x82, 0x4b, 0x65, 0x5a, 0xea, 0xb2, 0x94, 0xca, 0x52, 0xa9, 0x2c, 0x95, 0x5a, 0x91, 0x2b, 0x59,
	0x56, 0x2a, 0x4b, 0xa4, 0x56, 0xa5, 0x54, 0x96, 0x91, 0xca, 0x52, 0xa9, 0x35, 0xbd, 0x56, 0x49,
	0x35, 0x7f, 0x59, 0x80, 0xf5, 0xe9, 0xc2, 0x4f, 0xd5, 0xa6, 0xef, 0x42, 0xc3, 0x15, 0xfb, 0x95,
	0x3b, 0x93, 0x9d, 0x99, 0x9d, 0xb4, 0xea, 0x6e, 0xe6, 0x18, 0x3f, 0x86, 0x66, 0x20, 0x1d, 0x9c,
	0x1c, 0xcd, 0x52, 0xba, 0x2f, 0x59, 0xdf, 0x5b, 0x8d, 0x20, 0x03, 0x99, 0x1e, 0x18, 0x5f, 0x51,
	0xcc, 0xd0, 0x31, 0xa3, 0xc8, 0xf1, 0x6f, 0xa2, 0xba, 0x37, 0xa0, 0x2c, 0xaa, 0x15, 0xbe, 0x4d,
	0x0d, 0x4b, 0x8c, 0xcd, 0x57, 0x61, 0x35, 0x27, 0x45, 0xd9, 0xba, 0x02, 0xa5, 0x31, 0x0a, 0x04,
	0xf7, 0xa6, 0xc5, 0x87, 0xa6, 0x03, 0x1d, 0x0b, 0x39, 0xde, 0xcd, 0x69, 0xa3, 0x44, 0x94, 0x52,
	0x11, 0x0f, 0xc0, 0xc8, 0x8a, 0x50, 0xaa, 0x68, 0xad, 0x0b, 0x19, 0xad, 0x8f, 0xa0, 0xb3, 0x3d,
	0x26, 0x11, 0x3a, 0x66, 0x1e, 0x0e, 0x6e, 0xa2, 0x1d, 0xf9, 0x29, 0xac, 0x7e, 0xc9, 0x26, 0x5f,
	0x71, 0x66, 0x11, 0xfe, 0x16, 0xdd, 0x90, 0x7d, 0x94, 0x3c, 0xd5, 0xf6, 0x51, 0xf2, 0x94, 0x37,
	0x37, 0x2e, 0x19, 0xc7, 0x7e, 0x20, 0x42, 0xa1, 0x69, 0x29, 0xc8, 0xdc, 0x82, 0x86, 0xac, 0xa1,
	0x0f, 0x89, 0x17, 0x8f, 0xd1, 0xdc, 0x18, 0xdc, 0x00, 0x08, 0x1d, 0xea, 0xf8, 0x88, 0x21, 0x2a,
	0xcf, 0x50, 0xcd, 0xca, 0x60, 0xcc, 0x5f, 0x17, 0x61, 0x4d, 0xbe, 0x37, 0x1c, 0xcb, 0x36, 0x5b,
	0x9b, 0xd0, 0x83, 0xea, 0x88, 0x44, 0x2c, 0xc3, 0x30, 0x81, 0xb9, 0x8a, 0xbc, 0x3f, 0x97, 0xdc,
	0xf8, 0x30, 0xf7, 0x08, 0x50, 0xba, 0xfa, 0x11, 0x60, 0xa6, 0xcd, 0x2f, 0xcf, 0xb6, 0xf9, 0x3c,
	0xda, 0x34, 0x11, 0x96, 0x31, 0x5e, 0xb3, 0x6a, 0x0a, 0x73, 0xe0, 0x19, 0xf7, 0xa1, 0x3d, 0xe4,
	0x5a, 0xda, 0x23, 0x42, 0xce, 0xed, 0xd0, 0x61, 0x23, 0x11, 0xea, 0x35, 0xab, 0x29, 0xd0, 0xfb,
	0x84, 0x9c, 0x0f, 0x1c, 0x36, 0x32, 0xde, 0x87, 0x96, 0x2a, 0x03, 0x7d, 0xe1, 0xa2, 0x48, 0x5d,
	0x7e, 0x2a, 0x8a, 0xb2, 0xde, 0xb3, 0x9a, 0xe7, 0x19, 0x28, 0x32, 0x6f, 0xc3, 0xad, 0x1d, 0x14,
	0x31, 0x4a, 0x26, 0x79, 0xc7, 0x98, 0xff, 0x0b, 0x70, 0x10, 0x30, 0x44, 0xcf, 0x1c, 0x17, 0x45,
	0xc6, 0x5b, 0x59, 0x48, 0x15, 0x47, 0x2b, 0x7d, 0xf9, 0xdc, 0x93, 0x4c, 0x58, 0x19, 0x1a, 0xb3,
	0x0f, 0xcb, 0x16, 0x89, 0x79, 0x3a, 0x7a, 0x59, 0x8f, 0xd4, 0xba, 0x86, 0x5a, 0x27, 0x90, 0x96,
	0x9a, 0x33, 0xf7, 0x75, 0x0b, 0x9b, 0xb2, 0x53, 0x5b, 0xd4, 0x87, 0x1a, 0xd6, 0x38, 0x95, 0x55,
	0x66, 0x45, 0xa7, 0x24, 0xe6, 0x87, 0xb0, 0x2a, 0x39, 0x49, 0xce, 0x9a, 0xcd, 0xcb, 0xb0, 0x4c,
	0xb5, 0x1a, 0x85, 0xf4, 0x9d, 0x47, 0x11, 0xa9, 0x39, 0xee, 0x8f, 0xcf, 0x70, 0xc4, 0x52, 0x43,
	0xb4, 0x3f, 0x56, 0xa1, 0xc3, 0x27, 0x72, 0x3c, 0xcd, 0x8f, 0xa1, 0xb1, 0x69, 0x0d, 0x3e, 0x47,
	0x78, 0x38, 0x3a, 0xe5, 0xd9, 0xf3, 0x7f, 0xf2, 0xb0, 0x32, 0xd8, 0x50, 0xda, 0x66, 0xa6, 0xac,
	0x1c, 0x9d, 0xf9, 0x09, 0xac, 0x6f, 0x7a, 0x5e, 0x16, 0xa5, 0xb5, 0x7e, 0x0b, 0x6a, 0x41, 0x86,
	0x5d, 0xe6, 0xce, 0xca, 0x51, 0xa7, 0x44, 0xe6, 0x8f, 0x61, 0xf5, 0x28, 0x18, 0xe3, 0x00, 0x6d,
	0x0f, 0x4e, 0x0e, 0x51, 0x92, 0x8b, 0x0c, 0x28, 0xf3, 0x9a, 0x4d, 0xf0, 0xa8, 0x5a, 0x62, 0xcc,
	0x83, 0x33, 0x38, 0xb5, 0xdd, 0x30, 0x8e, 0xd4, 0x63, 0xcf, 0x72, 0x70, 0xba, 0x1d, 0xc6, 0x11,
	0xbf, 0x5c, 0x78, 0x71, 0x41, 0x82, 0xf1, 0x44, 0x44, 0x68, 0xd5, 0xaa, 0xb8, 0x61, 0x7c, 0x14,
	0x8c, 0x27, 0xe6, 0x7f, 0x8b, 0x0e, 0x1c, 0x21, 0xcf, 0x72, 0x02, 0x8f, 0xf8, 0x3b, 0xe8, 0x22,
	0x23, 0x21, 0xe9, 0xf6, 0x74, 0x26, 0xfa, 0xae, 0x00, 0x8d, 0xcd, 0x21, 0x0a, 0xd8, 0x0e, 0x62,
	0x0e, 0x1e, 0x8b, 0x8e, 0xee, 0x02, 0xd1, 0x08, 0x93, 0x40, 0x85, 0x9b, 0x06, 0x79, 0x43, 0x8e,
	0x03, 0xcc, 0x6c, 0xcf, 0x41, 0x3e, 0x09, 0x04, 0x97, 0xaa, 0x05, 0x1c, 0xb5, 0x23, 0x30, 0xc6,
	0xab, 0xd0, 0x96, 0x8f, 0x71, 0xf6, 0xc8, 0x09, 0xbc, 0x31, 0x0f, 0xf4, 0x92, 0x08, 0xcd, 0x96,
	0x44, 0xef, 0x2b, 0xac, 0xf1, 0x1a, 0xac, 0xa8, 0x30, 0x4c, 0x29, 0xcb, 0x82, 0xb2, 0xad, 0xf0,
	0x39, 0xd2, 0x38, 0x0c, 0x09, 0x65, 0x91, 0x1d, 0x21, 0xd7, 0x25, 0x7e, 0xa8, 0xda, 0xa1, 0xb6,
	0xc6, 0x1f, 0x4b, 0xb4, 0x39, 0x84, 0xd5, 0x3d, 0x6e, 0xa7, 0xb2, 0x24, 0x3d, 0x56, 0x2d, 0x1f,
	0xf9, 0xf6, 0xe9, 0x98, 0xb8, 0xe7, 0x36, 0x4f, 0x8e, 0xca, 0xc3, 0xbc, 0xe0, 0xda, 0xe2, 0xc8,
	0x63, 0xfc, 0xad, 0xe8, 0xfc, 0x39, 0xd5, 0x88, 0xb0, 0x70, 0x1c, 0x0f, 0xed, 0x90, 0x92, 0x53,
	0xa4, 0x4c, 0x6c, 0xfb, 0xc8, 0xdf, 0x97, 0xf8, 0x01, 0x47, 0x9b, 0x7f, 0x2c, 0xc0, 0x5a, 0x5e,
	0x92, 0x4a, 0xf5, 0x0f, 0x61, 0x2d, 0x2f, 0x4a, 0x5d, 0xff, 0xb2, 0xbc, 0xec, 0x64, 0x05, 0xca,
	0x42, 0xe0, 0x31, 0x34, 0xc5, 0x7b, 0xad, 0xed, 0x49, 0x4e, 0xf9, 0xa2, 0x27, 0xbb, 0x2f, 0x56,
	0xc3, 0xc9, 0xee, 0xd2, 0xfb, 0x70, 0x47, 0x99, 0x6f, 0xcf, 0xaa, 0x2d, 0x0f, 0xc4, 0xba, 0x22,
	0x38, 0x9c, 0xd2, 0xfe, 0x33, 0xe8, 0xa6, 0xa8, 0xad, 0x89, 0x40, 0xa6, 0x87, 0x79, 0x75, 0xca,
	0xd8, 0x4d, 0xcf, 0xa3, 0x22, 0x4a, 0xca, 0xd6, 0xbc, 0x29, 0xf3, 0x09, 0xdc, 0x3e, 0x46, 0x4c,
	0x7a, 0xc3, 0x61, 0xaa, 0x13, 0x91, 0xcc, 0x56, 0xa0, 0x74, 0x8c, 0x5c, 0x61, 0x7c, 0xc9, 0xe2,
	0x43, 0x7e, 0x00, 0x4f, 0x22, 0xe4, 0x0a, 0x2b, 0x4b, 0x96, 0x18, 0x9b, 0xbf, 0x2f, 0x40, 0x45,
	0x25, 0x67, 0x7e, 0xc1, 0x78, 0x14, 0x5f, 0x20, 0xaa, 0x8e, 0x9e, 0x82, 0x8c, 0x57, 0xa0, 0x25,
	0x47, 0x36, 0x09, 0x19, 0x26, 0x49, 0xca, 0x6f, 0x4a, 0xec, 0x91, 0x44, 0x8a, 0xc7, 0x37, 0xf1,
	0xfc, 0xa5, 0x3a, 0x4d, 0x05, 0x71, 0xfc, 0x59, 0xc4, 0x23, 0x5c, 0xa4, 0xf8, 0x9a, 0xa5, 0x20,
	0x7e, 0xd4, 0x35, 0xbf, 0x25, 0xc1, 0x4f, 0x83, 0xfc, 0xa8, 0xfb, 0x24, 0x0e, 0x98, 0x1d, 0x12,
	0x1c, 0x30, 0x95, 0xd3, 0x41, 0xa0, 0x06, 0x1c, 0x63, 0xfe, 0xa2, 0x00, 0xcb, 0xf2, 0x01, 0x9a,
	0xf7, 0xb6, 0xc9, 0xcd, 0x5a, 0xc4, 0xa2, 0x4a, 0x11, 0xb2, 0xe4, 0x6d, 0x2a, 0xc6, 0x3c, 0x8e,
	0x2f, 0x7c, 0x79, 0x3f, 0x28, 0xd5, 0x2e, 0x7c, 0x71, 0x31, 0xbc, 0x02, 0xad, 0xf4, 0x82, 0x16,
	0xf3, 0x52, 0xc5, 0x66, 0x82, 0x15, 0x64, 0x0b, 0x35, 0x35, 0xff, 0x8f, 0xb7, 0xf4, 0xc9, 0xe3,
	0xeb, 0x0a, 0x94, 0xe2, 0x44, 0x19, 0x3e, 0xe4, 0x98, 0x61, 0x72, 0xb5, 0xf3, 0xa1, 0x71, 0x1f,
	0x5a, 0x8e, 0xe7, 0x61, 0xbe, 0xdc, 0x19, 0xef, 0x61, 0x2f, 0x09, 0xd2, 0x3c, 0xd6, 0xfc, 0x73,
	0x01, 0xda, 0xdb, 0x24, 0x9c, 0x7c, 0x8c, 0xc7, 0x28, 0x93, 0x41, 0x84, 0x92, 0xea, 0x66, 0xe7,
	0x63, 0x5e, 0xad, 0x9e, 0xe1, 0x31, 0x92, 0xa1, 0x25, 0x77, 0xb6, 0xca, 0x11, 0x22, 0xac, 0xf4,
	0x64, 0xf2, 0xec, 0xd6, 0x94, 0x93, 0x87, 0xc4, 0x13, 0x75, 0xb9, 0x87, 0xa9, 0x9d, 0x3c, 0xb2,
	0x35, 0xad, 0x8a, 0x87, 0xa9, 0x98, 0x52, 0x86, 0x2c, 0x89, 0x47, 0xd4, 0xac, 0x21, 0xcb, 0x12,
	0xc3, 0x0d, 0x59, 0x87, 0x65, 0x72, 0x76, 0x16, 0x21, 0x26, 0x2a, 0xe8, 0x92, 0xa5, 0xa0, 0x24,
	0xcd, 0x55, 0x33, 0x69, 0x6e, 0x0d, 0x8c, 0x3d, 0xc4, 0x8e, 0x8e, 0x0e, 0x77, 0x2f, 0x50, 0xc0,
	0xf4, 0xed, 0xf0, 0x26, 0x54, 0x35, 0xea, 0x5f, 0x79, 0x9e, 0x7c, 0x1d, 0x5a, 0x9b, 0x9e, 0x77,
	0xfc, 0xd4, 0x09, 0xb5, 0x3f, 0xba, 0x50, 0x19, 0x6c, 0x1f, 0x0c, 0xa4, 0x4b, 0x4a, 0xdc, 0x00,
	0x05, 0xf2, 0xdb, 0x68, 0x0f, 0xb1, 0x43, 0xc4, 0x28, 0x76, 0x93, 0xdb, 0xe8, 0x1e, 0x54, 0x14,
	0x86, 0xaf, 0xf4, 0xe5, 0x50, 0xa7, 0x59, 0x05, 0x3e, 0xfa, 0xc3, 0x8a, 0xca, 0xc8, 0xaa, 0xb9,
	0x37, 0xf6, 0xa0, 0x3d, 0xf5, 0x25, 0xc6, 0x50, 0xaf, 0x3d, 0xf3, 0x3f, 0xd0, 0xf4, 0xd6, 0xfb,
	0xf2, 0xcb, 0x4e, 0x5f, 0x7f, 0xd9, 0xe9, 0xef, 0xfa, 0x21, 0x9b, 0x18, 0xbb, 0xd0, 0xca, 0x7f,
	0xb3, 0x30, 0x9e, 0xd7, 0xc5, 0xd1, 0x9c, 0x2f, 0x19, 0x0b, 0xd9, 0xec, 0x41, 0x7b, 0xea, 0xf3,
	0x85, 0xd6, 0x67, 0xfe, 0x57, 0x8d, 0x85, 0x8c, 0x9e, 0x40, 0x3d, 0xf3, 0xbd, 0xc2, 0xe8, 0x4a,
	0x26, 0xb3, 0x9f, 0x30, 0x16, 0x32, 0xd8, 0x86, 0x66, 0xee, 0x13, 0x82, 0xd1, 0x53, 0xf6, 0xcc,
	0xf9, 0xae, 0xb0, 0x90, 0xc9, 0x16, 0xd4, 0x33, 0x2f, 0xf9, 0x5a, 0x8b, 0xd9, 0xcf, 0x05, 0xbd,
	0x3b, 0x73, 0x66, 0x54, 0xe2, 0xdf, 0x83, 0xf6, 0xd4, 0xf3, 0xbe, 0x76, 0xc9, 0xfc, 0x57, 0xff,
	0x85, 0xca, 0x7c, 0x2a, 0xb6, 0x28, 0xd3, 0xbd, 0x65, 0xb6, 0x68, 0xf6, 0x31, 0xbf, 0xf7, 0xc2,
	0xfc, 0x49, 0xa5, 0xd5, 0x2e, 0xb4, 0xf2, 0xef, 0xf8, 0x9a, 0xd9, 0xdc, 0xd7, 0xfd, 0xab, 0xf7,
	0x3b, 0xf7, 0xa4, 0x9f, 0xee, 0xf7, 0xbc, 0x97, 0xfe, 0x85, 0x8c, 0x36, 0x01, 0x54, 0xaf, 0xe6,
	0xe1, 0x20, 0x71, 0xf4, 0x4c, 0x8f, 0x98, 0x38, 0x7a, 0x4e, 0x5f, 0xf7, 0x04, 0x40, 0xb6, 0x58,
	0x1e, 0x89, 0x99, 0x71, 0x5b, 0xab, 0x31, 0xd5, 0xd7, 0xf5, 0xba, 0xb3, 0x13, 0x33, 0x0c, 0x10,
	0xa5, 0xd7, 0x61, 0xf0, 0x11, 0x40, 0xda, 0xba, 0x69, 0x06, 0x33, 0xcd, 0xdc, 0x15, 0x3e, 0x68,
	0x64, 0x1b, 0x35, 0x43, 0xd9, 0x3a, 0xa7, 0x79, 0xbb, 0x82, 0x45, 0x7b, 0xaa, 0x10, 0xcf, 0x1f,
	0xb6, 0xe9, 0xfa, 0xbc, 0x37, 0x53, 0x8c, 0x1b, 0x8f, 0xa1, 0x91, 0xad, 0xc0, 0xb5, 0x16, 0x73,
	0xaa, 0xf2, 0x5e, 0xae, 0x0a, 0x37, 0x9e, 0x40, 0x2b, 0x5f, 0x7d, 0xeb, 0x23, 0x35, 0xb7, 0x26,
	0xef, 0xa9, 0xb7, 0xa5, 0x0c, 0xf9, 0x3b, 0x00, 0x69, 0x95, 0xae, 0xdd, 0x37, 0x53, 0xb7, 0x4f,
	0x49, 0xdd, 0x83, 0xf6, 0x54, 0xf5, 0xad, 0x2d, 0x9e, 0x5f, 0x94, 0x2f, 0x74, 0xdd, 0xbb, 0x00,
	0x69, 0x56, 0xd6, 0xd2, 0x67, 0xf2, 0x74, 0xaf, 0xa9, 0xdf, 0xdd, 0x24, 0xdd, 0x36, 0x34, 0x73,
	0xad, 0xa9, 0x4e, 0x33, 0xf3, 0xfa, 0xd5, 0xab, 0x92, 0x6f, 0xbe, 0x8f, 0xd3, 0x9e, 0x9b, 0xdb,
	0xdd, 0x5d, 0x75, 0x7e, 0xb2, 0xcd, 0x83, 0xde, 0xb9, 0x39, 0x0d, 0xc5, 0x0f, 0xc4, 0x73, 0xb6,
	0x41, 0xc8, 0xc4, 0xf3, 0x9c, 0xbe, 0x61, 0x21, 0xa3, 0x7d, 0x68, 0xef, 0xe9, 0xda, 0x4f, 0xd5,
	0xa5, 0x4a, 0x9d, 0x39, 0x75, 0x78, 0xaf, 0x37, 0x6f, 0x4a, 0x05, 0xd5, 0xa7, 0xd0, 0x99, 0xa9,
	0x49, 0x8d, 0x8d, 0xe4, 0xf5, 0x73, 0x6e, 0xb1, 0xba, 0x50, 0xad, 0x03, 0x58, 0x99, 0x2e, 0x49,
	0x8d, 0x17, 0x55, 0xa2, 0x9c, 0x5f, 0xaa, 0x2e, 0x64, 0xf5, 0x3e, 0x54, 0x75, 0x09, 0x64, 0xa8,
	0x57, 0xe6, 0xa9, 0x92, 0x68, 0xe1, 0xd2, 0xc7, 0x50, 0xcf, 0x54, 0x1c, 0x3a, 0xdb, 0xcd, 0x16,
	0x21, 0x3d, 0xf5, 0x28, 0x9c, 0x50, 0x3e, 0x86, 0x8a, 0xaa, 0x32, 0x8c, 0xb5, 0xe4, 0x90, 0x67,
	0x8a, 0x8e, 0x45, 0x12, 0xb7, 0x2e, 0xbf, 0xfb, 0x7e, 0xe3, 0xb9, 0xbf, 0x7e, 0xbf, 0xf1, 0xdc,
	0xcf, 0x9f, 0x6d, 0x14, 0xbe, 0x7b, 0xb6, 0x51, 0xf8, 0xcb, 0xb3, 0x8d, 0xc2, 0xdf, 0x9f, 0x6d,
	0x14, 0xfe, 0xff, 0x27, 0xff, 0xe6, 0x5f, 0x4b, 0x68, 0x1c, 0x30, 0xec, 0xa3, 0x87, 0x17, 0x98,
	0xb2, 0xcc, 0x54, 0x78, 0x3e, 0x9c, 0xf9, 0xd7, 0x09, 0x57, 0xf0, 0x74, 0x59, 0xc0, 0xef, 0xfc,
	0x33, 0x00, 0x00, 0xff, 0xff, 0xcc, 0x41, 0xae, 0xa1, 0xc3, 0x22, 0x00, 0x00,
}

func (m *CreateContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SandboxPidns {
		i--
		if m.SandboxPidns {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.OCI != nil {
		{
			size, err := m.OCI.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.Storages) > 0 {
		for iNdEx := len(m.Storages) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Storages[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Devices) > 0 {
		for iNdEx := len(m.Devices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Devices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.StringUser != nil {
		{
			size, err := m.StringUser.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ExecId) > 0 {
		i -= len(m.ExecId)
		copy(dAtA[i:], m.ExecId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StartContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StartContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Timeout != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExecProcessRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecProcessRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecProcessRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Process != nil {
		{
			size, err := m.Process.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.StringUser != nil {
		{
			size, err := m.StringUser.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ExecId) > 0 {
		i -= len(m.ExecId)
		copy(dAtA[i:], m.ExecId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SignalProcessRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SignalProcessRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SignalProcessRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Signal != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Signal))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ExecId) > 0 {
		i -= len(m.ExecId)
		copy(dAtA[i:], m.ExecId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WaitProcessRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WaitProcessRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WaitProcessRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExecId) > 0 {
		i -= len(m.ExecId)
		copy(dAtA[i:], m.ExecId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WaitProcessResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WaitProcessResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WaitProcessResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Status != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *UpdateContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Resources != nil {
		{
			size, err := m.Resources.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StatsContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatsContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatsContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PauseContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PauseContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PauseContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResumeContainerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResumeContainerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResumeContainerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CpuUsage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CpuUsage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CpuUsage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UsageInUsermode != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.UsageInUsermode))
		i--
		dAtA[i] = 0x20
	}
	if m.UsageInKernelmode != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.UsageInKernelmode))
		i--
		dAtA[i] = 0x18
	}
	if len(m.PercpuUsage) > 0 {
		dAtA7 := make([]byte, len(m.PercpuUsage)*10)
		var j6 int
		for _, num := range m.PercpuUsage {
			for num >= 1<<7 {
				dAtA7[j6] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j6++
			}
			dAtA7[j6] = uint8(num)
			j6++
		}
		i -= j6
		copy(dAtA[i:], dAtA7[:j6])
		i = encodeVarintAgent(dAtA, i, uint64(j6))
		i--
		dAtA[i] = 0x12
	}
	if m.TotalUsage != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TotalUsage))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ThrottlingData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ThrottlingData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ThrottlingData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ThrottledTime != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ThrottledTime))
		i--
		dAtA[i] = 0x18
	}
	if m.ThrottledPeriods != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.ThrottledPeriods))
		i--
		dAtA[i] = 0x10
	}
	if m.Periods != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Periods))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CpuStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CpuStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CpuStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ThrottlingData != nil {
		{
			size, err := m.ThrottlingData.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.CpuUsage != nil {
		{
			size, err := m.CpuUsage.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PidsStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PidsStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PidsStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Limit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x10
	}
	if m.Current != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Current))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MemoryData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemoryData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemoryData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Limit != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x20
	}
	if m.Failcnt != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Failcnt))
		i--
		dAtA[i] = 0x18
	}
	if m.MaxUsage != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MaxUsage))
		i--
		dAtA[i] = 0x10
	}
	if m.Usage != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Usage))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MemoryStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemoryStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemoryStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Stats) > 0 {
		for k := range m.Stats {
			v := m.Stats[k]
			baseI := i
			i = encodeVarintAgent(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if m.UseHierarchy {
		i--
		if m.UseHierarchy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.KernelUsage != nil {
		{
			size, err := m.KernelUsage.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.SwapUsage != nil {
		{
			size, err := m.SwapUsage.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Usage != nil {
		{
			size, err := m.Usage.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Cache != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Cache))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BlkioStatsEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BlkioStatsEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BlkioStatsEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Op) > 0 {
		i -= len(m.Op)
		copy(dAtA[i:], m.Op)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Op)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Minor != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Minor))
		i--
		dAtA[i] = 0x10
	}
	if m.Major != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Major))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BlkioStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BlkioStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BlkioStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SectorsRecursive) > 0 {
		for iNdEx := len(m.SectorsRecursive) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SectorsRecursive[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.IoTimeRecursive) > 0 {
		for iNdEx := len(m.IoTimeRecursive) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IoTimeRecursive[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.IoMergedRecursive) > 0 {
		for iNdEx := len(m.IoMergedRecursive) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IoMergedRecursive[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.IoWaitTimeRecursive) > 0 {
		for iNdEx := len(m.IoWaitTimeRecursive) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IoWaitTimeRecursive[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.IoServiceTimeRecursive) > 0 {
		for iNdEx := len(m.IoServiceTimeRecursive) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IoServiceTimeRecursive[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.IoQueuedRecursive) > 0 {
		for iNdEx := len(m.IoQueuedRecursive) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IoQueuedRecursive[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.IoServicedRecursive) > 0 {
		for iNdEx := len(m.IoServicedRecursive) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IoServicedRecursive[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.IoServiceBytesRecursive) > 0 {
		for iNdEx := len(m.IoServiceBytesRecursive) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IoServiceBytesRecursive[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HugetlbStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HugetlbStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HugetlbStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Failcnt != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Failcnt))
		i--
		dAtA[i] = 0x18
	}
	if m.MaxUsage != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MaxUsage))
		i--
		dAtA[i] = 0x10
	}
	if m.Usage != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Usage))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CgroupStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CgroupStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CgroupStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.HugetlbStats) > 0 {
		for k := range m.HugetlbStats {
			v := m.HugetlbStats[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintAgent(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAgent(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAgent(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.BlkioStats != nil {
		{
			size, err := m.BlkioStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.PidsStats != nil {
		{
			size, err := m.PidsStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.MemoryStats != nil {
		{
			size, err := m.MemoryStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.CpuStats != nil {
		{
			size, err := m.CpuStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TxDropped != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TxDropped))
		i--
		dAtA[i] = 0x48
	}
	if m.TxErrors != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TxErrors))
		i--
		dAtA[i] = 0x40
	}
	if m.TxPackets != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TxPackets))
		i--
		dAtA[i] = 0x38
	}
	if m.TxBytes != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.TxBytes))
		i--
		dAtA[i] = 0x30
	}
	if m.RxDropped != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RxDropped))
		i--
		dAtA[i] = 0x28
	}
	if m.RxErrors != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RxErrors))
		i--
		dAtA[i] = 0x20
	}
	if m.RxPackets != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RxPackets))
		i--
		dAtA[i] = 0x18
	}
	if m.RxBytes != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.RxBytes))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StatsContainerResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatsContainerResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StatsContainerResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NetworkStats) > 0 {
		for iNdEx := len(m.NetworkStats) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NetworkStats[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.CgroupStats != nil {
		{
			size, err := m.CgroupStats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WriteStreamRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteStreamRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteStreamRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ExecId) > 0 {
		i -= len(m.ExecId)
		copy(dAtA[i:], m.ExecId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WriteStreamResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteStreamResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteStreamResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Len != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Len))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ReadStreamRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadStreamRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadStreamRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Len != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Len))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ExecId) > 0 {
		i -= len(m.ExecId)
		copy(dAtA[i:], m.ExecId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReadStreamResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadStreamResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadStreamResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CloseStdinRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloseStdinRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloseStdinRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExecId) > 0 {
		i -= len(m.ExecId)
		copy(dAtA[i:], m.ExecId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TtyWinResizeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TtyWinResizeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TtyWinResizeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Column != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Column))
		i--
		dAtA[i] = 0x20
	}
	if m.Row != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Row))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ExecId) > 0 {
		i -= len(m.ExecId)
		copy(dAtA[i:], m.ExecId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *KernelModule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KernelModule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KernelModule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Parameters) > 0 {
		for iNdEx := len(m.Parameters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Parameters[iNdEx])
			copy(dAtA[i:], m.Parameters[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Parameters[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CreateSandboxRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateSandboxRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateSandboxRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.KernelModules) > 0 {
		for iNdEx := len(m.KernelModules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.KernelModules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.GuestHookPath) > 0 {
		i -= len(m.GuestHookPath)
		copy(dAtA[i:], m.GuestHookPath)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.GuestHookPath)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.SandboxId) > 0 {
		i -= len(m.SandboxId)
		copy(dAtA[i:], m.SandboxId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.SandboxId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.SandboxPidns {
		i--
		if m.SandboxPidns {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Storages) > 0 {
		for iNdEx := len(m.Storages) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Storages[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Dns) > 0 {
		for iNdEx := len(m.Dns) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Dns[iNdEx])
			copy(dAtA[i:], m.Dns[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Dns[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Hostname) > 0 {
		i -= len(m.Hostname)
		copy(dAtA[i:], m.Hostname)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Hostname)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DestroySandboxRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DestroySandboxRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DestroySandboxRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *Interfaces) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Interfaces) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Interfaces) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Interfaces) > 0 {
		for iNdEx := len(m.Interfaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Interfaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Routes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Routes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Routes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Routes) > 0 {
		for iNdEx := len(m.Routes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Routes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *UpdateInterfaceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateInterfaceRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateInterfaceRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Interface != nil {
		{
			size, err := m.Interface.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateRoutesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateRoutesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateRoutesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Routes != nil {
		{
			size, err := m.Routes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListInterfacesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListInterfacesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListInterfacesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ListRoutesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListRoutesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListRoutesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ARPNeighbors) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ARPNeighbors) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ARPNeighbors) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ARPNeighbors) > 0 {
		for iNdEx := len(m.ARPNeighbors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ARPNeighbors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAgent(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AddARPNeighborsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddARPNeighborsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddARPNeighborsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Neighbors != nil {
		{
			size, err := m.Neighbors.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OnlineCPUMemRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OnlineCPUMemRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OnlineCPUMemRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CpuOnly {
		i--
		if m.CpuOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.NbCpus != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.NbCpus))
		i--
		dAtA[i] = 0x10
	}
	if m.Wait {
		i--
		if m.Wait {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ReseedRandomDevRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReseedRandomDevRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReseedRandomDevRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *AgentDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AgentDetails) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AgentDetails) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SupportsSeccomp {
		i--
		if m.SupportsSeccomp {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.StorageHandlers) > 0 {
		for iNdEx := len(m.StorageHandlers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.StorageHandlers[iNdEx])
			copy(dAtA[i:], m.StorageHandlers[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.StorageHandlers[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.DeviceHandlers) > 0 {
		for iNdEx := len(m.DeviceHandlers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DeviceHandlers[iNdEx])
			copy(dAtA[i:], m.DeviceHandlers[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.DeviceHandlers[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.InitDaemon {
		i--
		if m.InitDaemon {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GuestDetailsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GuestDetailsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GuestDetailsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MemHotplugProbe {
		i--
		if m.MemHotplugProbe {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.MemBlockSize {
		i--
		if m.MemBlockSize {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GuestDetailsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GuestDetailsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GuestDetailsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SupportMemHotplugProbe {
		i--
		if m.SupportMemHotplugProbe {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.AgentDetails != nil {
		{
			size, err := m.AgentDetails.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAgent(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.MemBlockSizeBytes != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.MemBlockSizeBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MemHotplugByProbeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemHotplugByProbeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemHotplugByProbeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.MemHotplugProbeAddr) > 0 {
		dAtA24 := make([]byte, len(m.MemHotplugProbeAddr)*10)
		var j23 int
		for _, num := range m.MemHotplugProbeAddr {
			for num >= 1<<7 {
				dAtA24[j23] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j23++
			}
			dAtA24[j23] = uint8(num)
			j23++
		}
		i -= j23
		copy(dAtA[i:], dAtA24[:j23])
		i = encodeVarintAgent(dAtA, i, uint64(j23))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SetGuestDateTimeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetGuestDateTimeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SetGuestDateTimeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Usec != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Usec))
		i--
		dAtA[i] = 0x10
	}
	if m.Sec != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Sec))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Storage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Storage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Storage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.MountPoint) > 0 {
		i -= len(m.MountPoint)
		copy(dAtA[i:], m.MountPoint)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.MountPoint)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Options) > 0 {
		for iNdEx := len(m.Options) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Options[iNdEx])
			copy(dAtA[i:], m.Options[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Options[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Fstype) > 0 {
		i -= len(m.Fstype)
		copy(dAtA[i:], m.Fstype)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Fstype)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DriverOptions) > 0 {
		for iNdEx := len(m.DriverOptions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DriverOptions[iNdEx])
			copy(dAtA[i:], m.DriverOptions[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.DriverOptions[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Driver) > 0 {
		i -= len(m.Driver)
		copy(dAtA[i:], m.Driver)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Driver)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Device) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Device) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Device) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Options) > 0 {
		for iNdEx := len(m.Options) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Options[iNdEx])
			copy(dAtA[i:], m.Options[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.Options[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.ContainerPath) > 0 {
		i -= len(m.ContainerPath)
		copy(dAtA[i:], m.ContainerPath)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerPath)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.VmPath) > 0 {
		i -= len(m.VmPath)
		copy(dAtA[i:], m.VmPath)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.VmPath)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StringUser) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringUser) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringUser) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AdditionalGids) > 0 {
		for iNdEx := len(m.AdditionalGids) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AdditionalGids[iNdEx])
			copy(dAtA[i:], m.AdditionalGids[iNdEx])
			i = encodeVarintAgent(dAtA, i, uint64(len(m.AdditionalGids[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Gid) > 0 {
		i -= len(m.Gid)
		copy(dAtA[i:], m.Gid)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Gid)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Uid) > 0 {
		i -= len(m.Uid)
		copy(dAtA[i:], m.Uid)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Uid)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CopyFileRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CopyFileRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CopyFileRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x42
	}
	if m.Offset != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Offset))
		i--
		dAtA[i] = 0x38
	}
	if m.Gid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Gid))
		i--
		dAtA[i] = 0x30
	}
	if m.Uid != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.Uid))
		i--
		dAtA[i] = 0x28
	}
	if m.DirMode != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.DirMode))
		i--
		dAtA[i] = 0x20
	}
	if m.FileMode != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.FileMode))
		i--
		dAtA[i] = 0x18
	}
	if m.FileSize != 0 {
		i = encodeVarintAgent(dAtA, i, uint64(m.FileSize))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetOOMEventRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetOOMEventRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetOOMEventRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *OOMEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OOMEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OOMEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddSwapRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSwapRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddSwapRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PCIPath) > 0 {
		dAtA26 := make([]byte, len(m.PCIPath)*10)
		var j25 int
		for _, num := range m.PCIPath {
			for num >= 1<<7 {
				dAtA26[j25] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j25++
			}
			dAtA26[j25] = uint8(num)
			j25++
		}
		i -= j25
		copy(dAtA[i:], dAtA26[:j25])
		i = encodeVarintAgent(dAtA, i, uint64(j25))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetMetricsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetMetricsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetMetricsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *Metrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Metrics) > 0 {
		i -= len(m.Metrics)
		copy(dAtA[i:], m.Metrics)
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Metrics)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAgent(dAtA []byte, offset int, v uint64) int {
	offset -= sovAgent(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CreateContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ExecId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.StringUser != nil {
		l = m.StringUser.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Devices) > 0 {
		for _, e := range m.Devices {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Storages) > 0 {
		for _, e := range m.Storages {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.OCI != nil {
		l = m.OCI.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.SandboxPidns {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StartContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RemoveContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Timeout != 0 {
		n += 1 + sovAgent(uint64(m.Timeout))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecProcessRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ExecId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.StringUser != nil {
		l = m.StringUser.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Process != nil {
		l = m.Process.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SignalProcessRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ExecId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Signal != 0 {
		n += 1 + sovAgent(uint64(m.Signal))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WaitProcessRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ExecId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WaitProcessResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovAgent(uint64(m.Status))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Resources != nil {
		l = m.Resources.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StatsContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PauseContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResumeContainerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CpuUsage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalUsage != 0 {
		n += 1 + sovAgent(uint64(m.TotalUsage))
	}
	if len(m.PercpuUsage) > 0 {
		l = 0
		for _, e := range m.PercpuUsage {
			l += sovAgent(uint64(e))
		}
		n += 1 + sovAgent(uint64(l)) + l
	}
	if m.UsageInKernelmode != 0 {
		n += 1 + sovAgent(uint64(m.UsageInKernelmode))
	}
	if m.UsageInUsermode != 0 {
		n += 1 + sovAgent(uint64(m.UsageInUsermode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ThrottlingData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Periods != 0 {
		n += 1 + sovAgent(uint64(m.Periods))
	}
	if m.ThrottledPeriods != 0 {
		n += 1 + sovAgent(uint64(m.ThrottledPeriods))
	}
	if m.ThrottledTime != 0 {
		n += 1 + sovAgent(uint64(m.ThrottledTime))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CpuStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CpuUsage != nil {
		l = m.CpuUsage.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ThrottlingData != nil {
		l = m.ThrottlingData.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PidsStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Current != 0 {
		n += 1 + sovAgent(uint64(m.Current))
	}
	if m.Limit != 0 {
		n += 1 + sovAgent(uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MemoryData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Usage != 0 {
		n += 1 + sovAgent(uint64(m.Usage))
	}
	if m.MaxUsage != 0 {
		n += 1 + sovAgent(uint64(m.MaxUsage))
	}
	if m.Failcnt != 0 {
		n += 1 + sovAgent(uint64(m.Failcnt))
	}
	if m.Limit != 0 {
		n += 1 + sovAgent(uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MemoryStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cache != 0 {
		n += 1 + sovAgent(uint64(m.Cache))
	}
	if m.Usage != nil {
		l = m.Usage.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.SwapUsage != nil {
		l = m.SwapUsage.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.KernelUsage != nil {
		l = m.KernelUsage.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.UseHierarchy {
		n += 2
	}
	if len(m.Stats) > 0 {
		for k, v := range m.Stats {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + 1 + sovAgent(uint64(v))
			n += mapEntrySize + 1 + sovAgent(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BlkioStatsEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Major != 0 {
		n += 1 + sovAgent(uint64(m.Major))
	}
	if m.Minor != 0 {
		n += 1 + sovAgent(uint64(m.Minor))
	}
	l = len(m.Op)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Value != 0 {
		n += 1 + sovAgent(uint64(m.Value))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BlkioStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.IoServiceBytesRecursive) > 0 {
		for _, e := range m.IoServiceBytesRecursive {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.IoServicedRecursive) > 0 {
		for _, e := range m.IoServicedRecursive {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.IoQueuedRecursive) > 0 {
		for _, e := range m.IoQueuedRecursive {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.IoServiceTimeRecursive) > 0 {
		for _, e := range m.IoServiceTimeRecursive {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.IoWaitTimeRecursive) > 0 {
		for _, e := range m.IoWaitTimeRecursive {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.IoMergedRecursive) > 0 {
		for _, e := range m.IoMergedRecursive {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.IoTimeRecursive) > 0 {
		for _, e := range m.IoTimeRecursive {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.SectorsRecursive) > 0 {
		for _, e := range m.SectorsRecursive {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HugetlbStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Usage != 0 {
		n += 1 + sovAgent(uint64(m.Usage))
	}
	if m.MaxUsage != 0 {
		n += 1 + sovAgent(uint64(m.MaxUsage))
	}
	if m.Failcnt != 0 {
		n += 1 + sovAgent(uint64(m.Failcnt))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CgroupStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CpuStats != nil {
		l = m.CpuStats.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.MemoryStats != nil {
		l = m.MemoryStats.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.PidsStats != nil {
		l = m.PidsStats.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.BlkioStats != nil {
		l = m.BlkioStats.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.HugetlbStats) > 0 {
		for k, v := range m.HugetlbStats {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovAgent(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovAgent(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovAgent(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.RxBytes != 0 {
		n += 1 + sovAgent(uint64(m.RxBytes))
	}
	if m.RxPackets != 0 {
		n += 1 + sovAgent(uint64(m.RxPackets))
	}
	if m.RxErrors != 0 {
		n += 1 + sovAgent(uint64(m.RxErrors))
	}
	if m.RxDropped != 0 {
		n += 1 + sovAgent(uint64(m.RxDropped))
	}
	if m.TxBytes != 0 {
		n += 1 + sovAgent(uint64(m.TxBytes))
	}
	if m.TxPackets != 0 {
		n += 1 + sovAgent(uint64(m.TxPackets))
	}
	if m.TxErrors != 0 {
		n += 1 + sovAgent(uint64(m.TxErrors))
	}
	if m.TxDropped != 0 {
		n += 1 + sovAgent(uint64(m.TxDropped))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StatsContainerResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CgroupStats != nil {
		l = m.CgroupStats.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.NetworkStats) > 0 {
		for _, e := range m.NetworkStats {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WriteStreamRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ExecId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WriteStreamResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Len != 0 {
		n += 1 + sovAgent(uint64(m.Len))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReadStreamRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ExecId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Len != 0 {
		n += 1 + sovAgent(uint64(m.Len))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReadStreamResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CloseStdinRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ExecId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TtyWinResizeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ExecId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Row != 0 {
		n += 1 + sovAgent(uint64(m.Row))
	}
	if m.Column != 0 {
		n += 1 + sovAgent(uint64(m.Column))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KernelModule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Parameters) > 0 {
		for _, s := range m.Parameters {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CreateSandboxRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Dns) > 0 {
		for _, s := range m.Dns {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.Storages) > 0 {
		for _, e := range m.Storages {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.SandboxPidns {
		n += 2
	}
	l = len(m.SandboxId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.GuestHookPath)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.KernelModules) > 0 {
		for _, e := range m.KernelModules {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DestroySandboxRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Interfaces) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Interfaces) > 0 {
		for _, e := range m.Interfaces {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Routes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateInterfaceRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Interface != nil {
		l = m.Interface.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateRoutesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Routes != nil {
		l = m.Routes.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListInterfacesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListRoutesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ARPNeighbors) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ARPNeighbors) > 0 {
		for _, e := range m.ARPNeighbors {
			l = e.Size()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AddARPNeighborsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Neighbors != nil {
		l = m.Neighbors.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OnlineCPUMemRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Wait {
		n += 2
	}
	if m.NbCpus != 0 {
		n += 1 + sovAgent(uint64(m.NbCpus))
	}
	if m.CpuOnly {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReseedRandomDevRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AgentDetails) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.InitDaemon {
		n += 2
	}
	if len(m.DeviceHandlers) > 0 {
		for _, s := range m.DeviceHandlers {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.StorageHandlers) > 0 {
		for _, s := range m.StorageHandlers {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.SupportsSeccomp {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GuestDetailsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MemBlockSize {
		n += 2
	}
	if m.MemHotplugProbe {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GuestDetailsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MemBlockSizeBytes != 0 {
		n += 1 + sovAgent(uint64(m.MemBlockSizeBytes))
	}
	if m.AgentDetails != nil {
		l = m.AgentDetails.Size()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.SupportMemHotplugProbe {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MemHotplugByProbeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.MemHotplugProbeAddr) > 0 {
		l = 0
		for _, e := range m.MemHotplugProbeAddr {
			l += sovAgent(uint64(e))
		}
		n += 1 + sovAgent(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SetGuestDateTimeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Sec != 0 {
		n += 1 + sovAgent(uint64(m.Sec))
	}
	if m.Usec != 0 {
		n += 1 + sovAgent(uint64(m.Usec))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Storage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Driver)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.DriverOptions) > 0 {
		for _, s := range m.DriverOptions {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Fstype)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	l = len(m.MountPoint)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Device) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.VmPath)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.ContainerPath)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StringUser) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Uid)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	l = len(m.Gid)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if len(m.AdditionalGids) > 0 {
		for _, s := range m.AdditionalGids {
			l = len(s)
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CopyFileRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.FileSize != 0 {
		n += 1 + sovAgent(uint64(m.FileSize))
	}
	if m.FileMode != 0 {
		n += 1 + sovAgent(uint64(m.FileMode))
	}
	if m.DirMode != 0 {
		n += 1 + sovAgent(uint64(m.DirMode))
	}
	if m.Uid != 0 {
		n += 1 + sovAgent(uint64(m.Uid))
	}
	if m.Gid != 0 {
		n += 1 + sovAgent(uint64(m.Gid))
	}
	if m.Offset != 0 {
		n += 1 + sovAgent(uint64(m.Offset))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetOOMEventRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OOMEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AddSwapRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PCIPath) > 0 {
		l = 0
		for _, e := range m.PCIPath {
			l += sovAgent(uint64(e))
		}
		n += 1 + sovAgent(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetMetricsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Metrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Metrics)
	if l > 0 {
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAgent(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAgent(x uint64) (n int) {
	return sovAgent(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *CreateContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForDevices := "[]*Device{"
	for _, f := range this.Devices {
		repeatedStringForDevices += strings.Replace(f.String(), "Device", "Device", 1) + ","
	}
	repeatedStringForDevices += "}"
	repeatedStringForStorages := "[]*Storage{"
	for _, f := range this.Storages {
		repeatedStringForStorages += strings.Replace(f.String(), "Storage", "Storage", 1) + ","
	}
	repeatedStringForStorages += "}"
	s := strings.Join([]string{`&CreateContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ExecId:` + fmt.Sprintf("%v", this.ExecId) + `,`,
		`StringUser:` + strings.Replace(this.StringUser.String(), "StringUser", "StringUser", 1) + `,`,
		`Devices:` + repeatedStringForDevices + `,`,
		`Storages:` + repeatedStringForStorages + `,`,
		`OCI:` + strings.Replace(fmt.Sprintf("%v", this.OCI), "Spec", "Spec", 1) + `,`,
		`SandboxPidns:` + fmt.Sprintf("%v", this.SandboxPidns) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StartContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StartContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RemoveContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RemoveContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Timeout:` + fmt.Sprintf("%v", this.Timeout) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecProcessRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecProcessRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ExecId:` + fmt.Sprintf("%v", this.ExecId) + `,`,
		`StringUser:` + strings.Replace(this.StringUser.String(), "StringUser", "StringUser", 1) + `,`,
		`Process:` + strings.Replace(fmt.Sprintf("%v", this.Process), "Process", "Process", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SignalProcessRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SignalProcessRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ExecId:` + fmt.Sprintf("%v", this.ExecId) + `,`,
		`Signal:` + fmt.Sprintf("%v", this.Signal) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WaitProcessRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WaitProcessRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ExecId:` + fmt.Sprintf("%v", this.ExecId) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WaitProcessResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WaitProcessResponse{`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "LinuxResources", "LinuxResources", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StatsContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StatsContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PauseContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PauseContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResumeContainerRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResumeContainerRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CpuUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CpuUsage{`,
		`TotalUsage:` + fmt.Sprintf("%v", this.TotalUsage) + `,`,
		`PercpuUsage:` + fmt.Sprintf("%v", this.PercpuUsage) + `,`,
		`UsageInKernelmode:` + fmt.Sprintf("%v", this.UsageInKernelmode) + `,`,
		`UsageInUsermode:` + fmt.Sprintf("%v", this.UsageInUsermode) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ThrottlingData) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ThrottlingData{`,
		`Periods:` + fmt.Sprintf("%v", this.Periods) + `,`,
		`ThrottledPeriods:` + fmt.Sprintf("%v", this.ThrottledPeriods) + `,`,
		`ThrottledTime:` + fmt.Sprintf("%v", this.ThrottledTime) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CpuStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CpuStats{`,
		`CpuUsage:` + strings.Replace(this.CpuUsage.String(), "CpuUsage", "CpuUsage", 1) + `,`,
		`ThrottlingData:` + strings.Replace(this.ThrottlingData.String(), "ThrottlingData", "ThrottlingData", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PidsStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PidsStats{`,
		`Current:` + fmt.Sprintf("%v", this.Current) + `,`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemoryData) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MemoryData{`,
		`Usage:` + fmt.Sprintf("%v", this.Usage) + `,`,
		`MaxUsage:` + fmt.Sprintf("%v", this.MaxUsage) + `,`,
		`Failcnt:` + fmt.Sprintf("%v", this.Failcnt) + `,`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemoryStats) String() string {
	if this == nil {
		return "nil"
	}
	keysForStats := make([]string, 0, len(this.Stats))
	for k, _ := range this.Stats {
		keysForStats = append(keysForStats, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForStats)
	mapStringForStats := "map[string]uint64{"
	for _, k := range keysForStats {
		mapStringForStats += fmt.Sprintf("%v: %v,", k, this.Stats[k])
	}
	mapStringForStats += "}"
	s := strings.Join([]string{`&MemoryStats{`,
		`Cache:` + fmt.Sprintf("%v", this.Cache) + `,`,
		`Usage:` + strings.Replace(this.Usage.String(), "MemoryData", "MemoryData", 1) + `,`,
		`SwapUsage:` + strings.Replace(this.SwapUsage.String(), "MemoryData", "MemoryData", 1) + `,`,
		`KernelUsage:` + strings.Replace(this.KernelUsage.String(), "MemoryData", "MemoryData", 1) + `,`,
		`UseHierarchy:` + fmt.Sprintf("%v", this.UseHierarchy) + `,`,
		`Stats:` + mapStringForStats + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BlkioStatsEntry) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&BlkioStatsEntry{`,
		`Major:` + fmt.Sprintf("%v", this.Major) + `,`,
		`Minor:` + fmt.Sprintf("%v", this.Minor) + `,`,
		`Op:` + fmt.Sprintf("%v", this.Op) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BlkioStats) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForIoServiceBytesRecursive := "[]*BlkioStatsEntry{"
	for _, f := range this.IoServiceBytesRecursive {
		repeatedStringForIoServiceBytesRecursive += strings.Replace(f.String(), "BlkioStatsEntry", "BlkioStatsEntry", 1) + ","
	}
	repeatedStringForIoServiceBytesRecursive += "}"
	repeatedStringForIoServicedRecursive := "[]*BlkioStatsEntry{"
	for _, f := range this.IoServicedRecursive {
		repeatedStringForIoServicedRecursive += strings.Replace(f.String(), "BlkioStatsEntry", "BlkioStatsEntry", 1) + ","
	}
	repeatedStringForIoServicedRecursive += "}"
	repeatedStringForIoQueuedRecursive := "[]*BlkioStatsEntry{"
	for _, f := range this.IoQueuedRecursive {
		repeatedStringForIoQueuedRecursive += strings.Replace(f.String(), "BlkioStatsEntry", "BlkioStatsEntry", 1) + ","
	}
	repeatedStringForIoQueuedRecursive += "}"
	repeatedStringForIoServiceTimeRecursive := "[]*BlkioStatsEntry{"
	for _, f := range this.IoServiceTimeRecursive {
		repeatedStringForIoServiceTimeRecursive += strings.Replace(f.String(), "BlkioStatsEntry", "BlkioStatsEntry", 1) + ","
	}
	repeatedStringForIoServiceTimeRecursive += "}"
	repeatedStringForIoWaitTimeRecursive := "[]*BlkioStatsEntry{"
	for _, f := range this.IoWaitTimeRecursive {
		repeatedStringForIoWaitTimeRecursive += strings.Replace(f.String(), "BlkioStatsEntry", "BlkioStatsEntry", 1) + ","
	}
	repeatedStringForIoWaitTimeRecursive += "}"
	repeatedStringForIoMergedRecursive := "[]*BlkioStatsEntry{"
	for _, f := range this.IoMergedRecursive {
		repeatedStringForIoMergedRecursive += strings.Replace(f.String(), "BlkioStatsEntry", "BlkioStatsEntry", 1) + ","
	}
	repeatedStringForIoMergedRecursive += "}"
	repeatedStringForIoTimeRecursive := "[]*BlkioStatsEntry{"
	for _, f := range this.IoTimeRecursive {
		repeatedStringForIoTimeRecursive += strings.Replace(f.String(), "BlkioStatsEntry", "BlkioStatsEntry", 1) + ","
	}
	repeatedStringForIoTimeRecursive += "}"
	repeatedStringForSectorsRecursive := "[]*BlkioStatsEntry{"
	for _, f := range this.SectorsRecursive {
		repeatedStringForSectorsRecursive += strings.Replace(f.String(), "BlkioStatsEntry", "BlkioStatsEntry", 1) + ","
	}
	repeatedStringForSectorsRecursive += "}"
	s := strings.Join([]string{`&BlkioStats{`,
		`IoServiceBytesRecursive:` + repeatedStringForIoServiceBytesRecursive + `,`,
		`IoServicedRecursive:` + repeatedStringForIoServicedRecursive + `,`,
		`IoQueuedRecursive:` + repeatedStringForIoQueuedRecursive + `,`,
		`IoServiceTimeRecursive:` + repeatedStringForIoServiceTimeRecursive + `,`,
		`IoWaitTimeRecursive:` + repeatedStringForIoWaitTimeRecursive + `,`,
		`IoMergedRecursive:` + repeatedStringForIoMergedRecursive + `,`,
		`IoTimeRecursive:` + repeatedStringForIoTimeRecursive + `,`,
		`SectorsRecursive:` + repeatedStringForSectorsRecursive + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HugetlbStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HugetlbStats{`,
		`Usage:` + fmt.Sprintf("%v", this.Usage) + `,`,
		`MaxUsage:` + fmt.Sprintf("%v", this.MaxUsage) + `,`,
		`Failcnt:` + fmt.Sprintf("%v", this.Failcnt) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CgroupStats) String() string {
	if this == nil {
		return "nil"
	}
	keysForHugetlbStats := make([]string, 0, len(this.HugetlbStats))
	for k, _ := range this.HugetlbStats {
		keysForHugetlbStats = append(keysForHugetlbStats, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForHugetlbStats)
	mapStringForHugetlbStats := "map[string]*HugetlbStats{"
	for _, k := range keysForHugetlbStats {
		mapStringForHugetlbStats += fmt.Sprintf("%v: %v,", k, this.HugetlbStats[k])
	}
	mapStringForHugetlbStats += "}"
	s := strings.Join([]string{`&CgroupStats{`,
		`CpuStats:` + strings.Replace(this.CpuStats.String(), "CpuStats", "CpuStats", 1) + `,`,
		`MemoryStats:` + strings.Replace(this.MemoryStats.String(), "MemoryStats", "MemoryStats", 1) + `,`,
		`PidsStats:` + strings.Replace(this.PidsStats.String(), "PidsStats", "PidsStats", 1) + `,`,
		`BlkioStats:` + strings.Replace(this.BlkioStats.String(), "BlkioStats", "BlkioStats", 1) + `,`,
		`HugetlbStats:` + mapStringForHugetlbStats + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkStats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkStats{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`RxBytes:` + fmt.Sprintf("%v", this.RxBytes) + `,`,
		`RxPackets:` + fmt.Sprintf("%v", this.RxPackets) + `,`,
		`RxErrors:` + fmt.Sprintf("%v", this.RxErrors) + `,`,
		`RxDropped:` + fmt.Sprintf("%v", this.RxDropped) + `,`,
		`TxBytes:` + fmt.Sprintf("%v", this.TxBytes) + `,`,
		`TxPackets:` + fmt.Sprintf("%v", this.TxPackets) + `,`,
		`TxErrors:` + fmt.Sprintf("%v", this.TxErrors) + `,`,
		`TxDropped:` + fmt.Sprintf("%v", this.TxDropped) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StatsContainerResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForNetworkStats := "[]*NetworkStats{"
	for _, f := range this.NetworkStats {
		repeatedStringForNetworkStats += strings.Replace(f.String(), "NetworkStats", "NetworkStats", 1) + ","
	}
	repeatedStringForNetworkStats += "}"
	s := strings.Join([]string{`&StatsContainerResponse{`,
		`CgroupStats:` + strings.Replace(this.CgroupStats.String(), "CgroupStats", "CgroupStats", 1) + `,`,
		`NetworkStats:` + repeatedStringForNetworkStats + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WriteStreamRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WriteStreamRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ExecId:` + fmt.Sprintf("%v", this.ExecId) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WriteStreamResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WriteStreamResponse{`,
		`Len:` + fmt.Sprintf("%v", this.Len) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReadStreamRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReadStreamRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ExecId:` + fmt.Sprintf("%v", this.ExecId) + `,`,
		`Len:` + fmt.Sprintf("%v", this.Len) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReadStreamResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReadStreamResponse{`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CloseStdinRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CloseStdinRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ExecId:` + fmt.Sprintf("%v", this.ExecId) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TtyWinResizeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TtyWinResizeRequest{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`ExecId:` + fmt.Sprintf("%v", this.ExecId) + `,`,
		`Row:` + fmt.Sprintf("%v", this.Row) + `,`,
		`Column:` + fmt.Sprintf("%v", this.Column) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *KernelModule) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&KernelModule{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Parameters:` + fmt.Sprintf("%v", this.Parameters) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CreateSandboxRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForStorages := "[]*Storage{"
	for _, f := range this.Storages {
		repeatedStringForStorages += strings.Replace(f.String(), "Storage", "Storage", 1) + ","
	}
	repeatedStringForStorages += "}"
	repeatedStringForKernelModules := "[]*KernelModule{"
	for _, f := range this.KernelModules {
		repeatedStringForKernelModules += strings.Replace(f.String(), "KernelModule", "KernelModule", 1) + ","
	}
	repeatedStringForKernelModules += "}"
	s := strings.Join([]string{`&CreateSandboxRequest{`,
		`Hostname:` + fmt.Sprintf("%v", this.Hostname) + `,`,
		`Dns:` + fmt.Sprintf("%v", this.Dns) + `,`,
		`Storages:` + repeatedStringForStorages + `,`,
		`SandboxPidns:` + fmt.Sprintf("%v", this.SandboxPidns) + `,`,
		`SandboxId:` + fmt.Sprintf("%v", this.SandboxId) + `,`,
		`GuestHookPath:` + fmt.Sprintf("%v", this.GuestHookPath) + `,`,
		`KernelModules:` + repeatedStringForKernelModules + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DestroySandboxRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DestroySandboxRequest{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Interfaces) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInterfaces := "[]*Interface{"
	for _, f := range this.Interfaces {
		repeatedStringForInterfaces += strings.Replace(fmt.Sprintf("%v", f), "Interface", "protocols.Interface", 1) + ","
	}
	repeatedStringForInterfaces += "}"
	s := strings.Join([]string{`&Interfaces{`,
		`Interfaces:` + repeatedStringForInterfaces + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Routes) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForRoutes := "[]*Route{"
	for _, f := range this.Routes {
		repeatedStringForRoutes += strings.Replace(fmt.Sprintf("%v", f), "Route", "protocols.Route", 1) + ","
	}
	repeatedStringForRoutes += "}"
	s := strings.Join([]string{`&Routes{`,
		`Routes:` + repeatedStringForRoutes + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateInterfaceRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateInterfaceRequest{`,
		`Interface:` + strings.Replace(fmt.Sprintf("%v", this.Interface), "Interface", "protocols.Interface", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateRoutesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateRoutesRequest{`,
		`Routes:` + strings.Replace(this.Routes.String(), "Routes", "Routes", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListInterfacesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListInterfacesRequest{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ListRoutesRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ListRoutesRequest{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ARPNeighbors) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForARPNeighbors := "[]*ARPNeighbor{"
	for _, f := range this.ARPNeighbors {
		repeatedStringForARPNeighbors += strings.Replace(fmt.Sprintf("%v", f), "ARPNeighbor", "protocols.ARPNeighbor", 1) + ","
	}
	repeatedStringForARPNeighbors += "}"
	s := strings.Join([]string{`&ARPNeighbors{`,
		`ARPNeighbors:` + repeatedStringForARPNeighbors + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddARPNeighborsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddARPNeighborsRequest{`,
		`Neighbors:` + strings.Replace(this.Neighbors.String(), "ARPNeighbors", "ARPNeighbors", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OnlineCPUMemRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OnlineCPUMemRequest{`,
		`Wait:` + fmt.Sprintf("%v", this.Wait) + `,`,
		`NbCpus:` + fmt.Sprintf("%v", this.NbCpus) + `,`,
		`CpuOnly:` + fmt.Sprintf("%v", this.CpuOnly) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReseedRandomDevRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReseedRandomDevRequest{`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AgentDetails) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AgentDetails{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`InitDaemon:` + fmt.Sprintf("%v", this.InitDaemon) + `,`,
		`DeviceHandlers:` + fmt.Sprintf("%v", this.DeviceHandlers) + `,`,
		`StorageHandlers:` + fmt.Sprintf("%v", this.StorageHandlers) + `,`,
		`SupportsSeccomp:` + fmt.Sprintf("%v", this.SupportsSeccomp) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GuestDetailsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GuestDetailsRequest{`,
		`MemBlockSize:` + fmt.Sprintf("%v", this.MemBlockSize) + `,`,
		`MemHotplugProbe:` + fmt.Sprintf("%v", this.MemHotplugProbe) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GuestDetailsResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GuestDetailsResponse{`,
		`MemBlockSizeBytes:` + fmt.Sprintf("%v", this.MemBlockSizeBytes) + `,`,
		`AgentDetails:` + strings.Replace(this.AgentDetails.String(), "AgentDetails", "AgentDetails", 1) + `,`,
		`SupportMemHotplugProbe:` + fmt.Sprintf("%v", this.SupportMemHotplugProbe) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MemHotplugByProbeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MemHotplugByProbeRequest{`,
		`MemHotplugProbeAddr:` + fmt.Sprintf("%v", this.MemHotplugProbeAddr) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SetGuestDateTimeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SetGuestDateTimeRequest{`,
		`Sec:` + fmt.Sprintf("%v", this.Sec) + `,`,
		`Usec:` + fmt.Sprintf("%v", this.Usec) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Storage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Storage{`,
		`Driver:` + fmt.Sprintf("%v", this.Driver) + `,`,
		`DriverOptions:` + fmt.Sprintf("%v", this.DriverOptions) + `,`,
		`Source:` + fmt.Sprintf("%v", this.Source) + `,`,
		`Fstype:` + fmt.Sprintf("%v", this.Fstype) + `,`,
		`Options:` + fmt.Sprintf("%v", this.Options) + `,`,
		`MountPoint:` + fmt.Sprintf("%v", this.MountPoint) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Device) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Device{`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`VmPath:` + fmt.Sprintf("%v", this.VmPath) + `,`,
		`ContainerPath:` + fmt.Sprintf("%v", this.ContainerPath) + `,`,
		`Options:` + fmt.Sprintf("%v", this.Options) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringUser) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringUser{`,
		`Uid:` + fmt.Sprintf("%v", this.Uid) + `,`,
		`Gid:` + fmt.Sprintf("%v", this.Gid) + `,`,
		`AdditionalGids:` + fmt.Sprintf("%v", this.AdditionalGids) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CopyFileRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CopyFileRequest{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`FileSize:` + fmt.Sprintf("%v", this.FileSize) + `,`,
		`FileMode:` + fmt.Sprintf("%v", this.FileMode) + `,`,
		`DirMode:` + fmt.Sprintf("%v", this.DirMode) + `,`,
		`Uid:` + fmt.Sprintf("%v", this.Uid) + `,`,
		`Gid:` + fmt.Sprintf("%v", this.Gid) + `,`,
		`Offset:` + fmt.Sprintf("%v", this.Offset) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetOOMEventRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetOOMEventRequest{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OOMEvent) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OOMEvent{`,
		`ContainerId:` + fmt.Sprintf("%v", this.ContainerId) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AddSwapRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AddSwapRequest{`,
		`PCIPath:` + fmt.Sprintf("%v", this.PCIPath) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetMetricsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetMetricsRequest{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Metrics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Metrics{`,
		`Metrics:` + fmt.Sprintf("%v", this.Metrics) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringAgent(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}

type AgentServiceService interface {
	CreateContainer(ctx context.Context, req *CreateContainerRequest) (*types.Empty, error)
	StartContainer(ctx context.Context, req *StartContainerRequest) (*types.Empty, error)
	RemoveContainer(ctx context.Context, req *RemoveContainerRequest) (*types.Empty, error)
	ExecProcess(ctx context.Context, req *ExecProcessRequest) (*types.Empty, error)
	SignalProcess(ctx context.Context, req *SignalProcessRequest) (*types.Empty, error)
	WaitProcess(ctx context.Context, req *WaitProcessRequest) (*WaitProcessResponse, error)
	UpdateContainer(ctx context.Context, req *UpdateContainerRequest) (*types.Empty, error)
	StatsContainer(ctx context.Context, req *StatsContainerRequest) (*StatsContainerResponse, error)
	PauseContainer(ctx context.Context, req *PauseContainerRequest) (*types.Empty, error)
	ResumeContainer(ctx context.Context, req *ResumeContainerRequest) (*types.Empty, error)
	WriteStdin(ctx context.Context, req *WriteStreamRequest) (*WriteStreamResponse, error)
	ReadStdout(ctx context.Context, req *ReadStreamRequest) (*ReadStreamResponse, error)
	ReadStderr(ctx context.Context, req *ReadStreamRequest) (*ReadStreamResponse, error)
	CloseStdin(ctx context.Context, req *CloseStdinRequest) (*types.Empty, error)
	TtyWinResize(ctx context.Context, req *TtyWinResizeRequest) (*types.Empty, error)
	UpdateInterface(ctx context.Context, req *UpdateInterfaceRequest) (*protocols.Interface, error)
	UpdateRoutes(ctx context.Context, req *UpdateRoutesRequest) (*Routes, error)
	ListInterfaces(ctx context.Context, req *ListInterfacesRequest) (*Interfaces, error)
	ListRoutes(ctx context.Context, req *ListRoutesRequest) (*Routes, error)
	AddARPNeighbors(ctx context.Context, req *AddARPNeighborsRequest) (*types.Empty, error)
	GetMetrics(ctx context.Context, req *GetMetricsRequest) (*Metrics, error)
	CreateSandbox(ctx context.Context, req *CreateSandboxRequest) (*types.Empty, error)
	DestroySandbox(ctx context.Context, req *DestroySandboxRequest) (*types.Empty, error)
	OnlineCPUMem(ctx context.Context, req *OnlineCPUMemRequest) (*types.Empty, error)
	ReseedRandomDev(ctx context.Context, req *ReseedRandomDevRequest) (*types.Empty, error)
	GetGuestDetails(ctx context.Context, req *GuestDetailsRequest) (*GuestDetailsResponse, error)
	MemHotplugByProbe(ctx context.Context, req *MemHotplugByProbeRequest) (*types.Empty, error)
	SetGuestDateTime(ctx context.Context, req *SetGuestDateTimeRequest) (*types.Empty, error)
	CopyFile(ctx context.Context, req *CopyFileRequest) (*types.Empty, error)
	GetOOMEvent(ctx context.Context, req *GetOOMEventRequest) (*OOMEvent, error)
	AddSwap(ctx context.Context, req *AddSwapRequest) (*types.Empty, error)
}

func RegisterAgentServiceService(srv *github_com_containerd_ttrpc.Server, svc AgentServiceService) {
	srv.Register("grpc.AgentService", map[string]github_com_containerd_ttrpc.Method{
		"CreateContainer": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req CreateContainerRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.CreateContainer(ctx, &req)
		},
		"StartContainer": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req StartContainerRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.StartContainer(ctx, &req)
		},
		"RemoveContainer": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req RemoveContainerRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.RemoveContainer(ctx, &req)
		},
		"ExecProcess": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req ExecProcessRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.ExecProcess(ctx, &req)
		},
		"SignalProcess": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req SignalProcessRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.SignalProcess(ctx, &req)
		},
		"WaitProcess": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req WaitProcessRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.WaitProcess(ctx, &req)
		},
		"UpdateContainer": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req UpdateContainerRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.UpdateContainer(ctx, &req)
		},
		"StatsContainer": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req StatsContainerRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.StatsContainer(ctx, &req)
		},
		"PauseContainer": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req PauseContainerRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.PauseContainer(ctx, &req)
		},
		"ResumeContainer": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req ResumeContainerRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.ResumeContainer(ctx, &req)
		},
		"WriteStdin": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req WriteStreamRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.WriteStdin(ctx, &req)
		},
		"ReadStdout": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req ReadStreamRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.ReadStdout(ctx, &req)
		},
		"ReadStderr": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req ReadStreamRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.ReadStderr(ctx, &req)
		},
		"CloseStdin": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req CloseStdinRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.CloseStdin(ctx, &req)
		},
		"TtyWinResize": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req TtyWinResizeRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.TtyWinResize(ctx, &req)
		},
		"UpdateInterface": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req UpdateInterfaceRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.UpdateInterface(ctx, &req)
		},
		"UpdateRoutes": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req UpdateRoutesRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.UpdateRoutes(ctx, &req)
		},
		"ListInterfaces": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req ListInterfacesRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.ListInterfaces(ctx, &req)
		},
		"ListRoutes": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req ListRoutesRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.ListRoutes(ctx, &req)
		},
		"AddARPNeighbors": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req AddARPNeighborsRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.AddARPNeighbors(ctx, &req)
		},
		"GetMetrics": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req GetMetricsRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.GetMetrics(ctx, &req)
		},
		"CreateSandbox": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req CreateSandboxRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.CreateSandbox(ctx, &req)
		},
		"DestroySandbox": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req DestroySandboxRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.DestroySandbox(ctx, &req)
		},
		"OnlineCPUMem": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req OnlineCPUMemRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.OnlineCPUMem(ctx, &req)
		},
		"ReseedRandomDev": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req ReseedRandomDevRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.ReseedRandomDev(ctx, &req)
		},
		"GetGuestDetails": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req GuestDetailsRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.GetGuestDetails(ctx, &req)
		},
		"MemHotplugByProbe": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req MemHotplugByProbeRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.MemHotplugByProbe(ctx, &req)
		},
		"SetGuestDateTime": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req SetGuestDateTimeRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.SetGuestDateTime(ctx, &req)
		},
		"CopyFile": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req CopyFileRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.CopyFile(ctx, &req)
		},
		"GetOOMEvent": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req GetOOMEventRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.GetOOMEvent(ctx, &req)
		},
		"AddSwap": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
			var req AddSwapRequest
			if err := unmarshal(&req); err != nil {
				return nil, err
			}
			return svc.AddSwap(ctx, &req)
		},
	})
}

type agentServiceClient struct {
	client *github_com_containerd_ttrpc.Client
}

func NewAgentServiceClient(client *github_com_containerd_ttrpc.Client) AgentServiceService {
	return &agentServiceClient{
		client: client,
	}
}

func (c *agentServiceClient) CreateContainer(ctx context.Context, req *CreateContainerRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "CreateContainer", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) StartContainer(ctx context.Context, req *StartContainerRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "StartContainer", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) RemoveContainer(ctx context.Context, req *RemoveContainerRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "RemoveContainer", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) ExecProcess(ctx context.Context, req *ExecProcessRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "ExecProcess", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) SignalProcess(ctx context.Context, req *SignalProcessRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "SignalProcess", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) WaitProcess(ctx context.Context, req *WaitProcessRequest) (*WaitProcessResponse, error) {
	var resp WaitProcessResponse
	if err := c.client.Call(ctx, "grpc.AgentService", "WaitProcess", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) UpdateContainer(ctx context.Context, req *UpdateContainerRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "UpdateContainer", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) StatsContainer(ctx context.Context, req *StatsContainerRequest) (*StatsContainerResponse, error) {
	var resp StatsContainerResponse
	if err := c.client.Call(ctx, "grpc.AgentService", "StatsContainer", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) PauseContainer(ctx context.Context, req *PauseContainerRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "PauseContainer", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) ResumeContainer(ctx context.Context, req *ResumeContainerRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "ResumeContainer", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) WriteStdin(ctx context.Context, req *WriteStreamRequest) (*WriteStreamResponse, error) {
	var resp WriteStreamResponse
	if err := c.client.Call(ctx, "grpc.AgentService", "WriteStdin", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) ReadStdout(ctx context.Context, req *ReadStreamRequest) (*ReadStreamResponse, error) {
	var resp ReadStreamResponse
	if err := c.client.Call(ctx, "grpc.AgentService", "ReadStdout", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) ReadStderr(ctx context.Context, req *ReadStreamRequest) (*ReadStreamResponse, error) {
	var resp ReadStreamResponse
	if err := c.client.Call(ctx, "grpc.AgentService", "ReadStderr", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) CloseStdin(ctx context.Context, req *CloseStdinRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "CloseStdin", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) TtyWinResize(ctx context.Context, req *TtyWinResizeRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "TtyWinResize", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) UpdateInterface(ctx context.Context, req *UpdateInterfaceRequest) (*protocols.Interface, error) {
	var resp protocols.Interface
	if err := c.client.Call(ctx, "grpc.AgentService", "UpdateInterface", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) UpdateRoutes(ctx context.Context, req *UpdateRoutesRequest) (*Routes, error) {
	var resp Routes
	if err := c.client.Call(ctx, "grpc.AgentService", "UpdateRoutes", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) ListInterfaces(ctx context.Context, req *ListInterfacesRequest) (*Interfaces, error) {
	var resp Interfaces
	if err := c.client.Call(ctx, "grpc.AgentService", "ListInterfaces", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) ListRoutes(ctx context.Context, req *ListRoutesRequest) (*Routes, error) {
	var resp Routes
	if err := c.client.Call(ctx, "grpc.AgentService", "ListRoutes", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) AddARPNeighbors(ctx context.Context, req *AddARPNeighborsRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "AddARPNeighbors", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) GetMetrics(ctx context.Context, req *GetMetricsRequest) (*Metrics, error) {
	var resp Metrics
	if err := c.client.Call(ctx, "grpc.AgentService", "GetMetrics", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) CreateSandbox(ctx context.Context, req *CreateSandboxRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "CreateSandbox", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) DestroySandbox(ctx context.Context, req *DestroySandboxRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "DestroySandbox", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) OnlineCPUMem(ctx context.Context, req *OnlineCPUMemRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "OnlineCPUMem", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) ReseedRandomDev(ctx context.Context, req *ReseedRandomDevRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "ReseedRandomDev", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) GetGuestDetails(ctx context.Context, req *GuestDetailsRequest) (*GuestDetailsResponse, error) {
	var resp GuestDetailsResponse
	if err := c.client.Call(ctx, "grpc.AgentService", "GetGuestDetails", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) MemHotplugByProbe(ctx context.Context, req *MemHotplugByProbeRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "MemHotplugByProbe", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) SetGuestDateTime(ctx context.Context, req *SetGuestDateTimeRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "SetGuestDateTime", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) CopyFile(ctx context.Context, req *CopyFileRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "CopyFile", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) GetOOMEvent(ctx context.Context, req *GetOOMEventRequest) (*OOMEvent, error) {
	var resp OOMEvent
	if err := c.client.Call(ctx, "grpc.AgentService", "GetOOMEvent", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *agentServiceClient) AddSwap(ctx context.Context, req *AddSwapRequest) (*types.Empty, error) {
	var resp types.Empty
	if err := c.client.Call(ctx, "grpc.AgentService", "AddSwap", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}
func (m *CreateContainerRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateContainerRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateContainerRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringUser", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StringUser == nil {
				m.StringUser = &StringUser{}
			}
			if err := m.StringUser.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Devices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Devices = append(m.Devices, &Device{})
			if err := m.Devices[len(m.Devices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Storages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Storages = append(m.Storages, &Storage{})
			if err := m.Storages[len(m.Storages)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OCI", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OCI == nil {
				m.OCI = &Spec{}
			}
			if err := m.OCI.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SandboxPidns", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SandboxPidns = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StartContainerRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartContainerRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartContainerRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveContainerRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveContainerRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveContainerRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecProcessRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecProcessRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecProcessRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringUser", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StringUser == nil {
				m.StringUser = &StringUser{}
			}
			if err := m.StringUser.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Process", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Process == nil {
				m.Process = &Process{}
			}
			if err := m.Process.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SignalProcessRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SignalProcessRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SignalProcessRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signal", wireType)
			}
			m.Signal = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Signal |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WaitProcessRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WaitProcessRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WaitProcessRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WaitProcessResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WaitProcessResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WaitProcessResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateContainerRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateContainerRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateContainerRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resources == nil {
				m.Resources = &LinuxResources{}
			}
			if err := m.Resources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatsContainerRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatsContainerRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatsContainerRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PauseContainerRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PauseContainerRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PauseContainerRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResumeContainerRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResumeContainerRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResumeContainerRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CpuUsage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CpuUsage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CpuUsage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalUsage", wireType)
			}
			m.TotalUsage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalUsage |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PercpuUsage = append(m.PercpuUsage, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAgent
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthAgent
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.PercpuUsage) == 0 {
					m.PercpuUsage = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PercpuUsage = append(m.PercpuUsage, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PercpuUsage", wireType)
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsageInKernelmode", wireType)
			}
			m.UsageInKernelmode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UsageInKernelmode |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsageInUsermode", wireType)
			}
			m.UsageInUsermode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UsageInUsermode |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ThrottlingData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ThrottlingData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ThrottlingData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Periods", wireType)
			}
			m.Periods = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Periods |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThrottledPeriods", wireType)
			}
			m.ThrottledPeriods = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ThrottledPeriods |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThrottledTime", wireType)
			}
			m.ThrottledTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ThrottledTime |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CpuStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CpuStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CpuStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuUsage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CpuUsage == nil {
				m.CpuUsage = &CpuUsage{}
			}
			if err := m.CpuUsage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThrottlingData", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ThrottlingData == nil {
				m.ThrottlingData = &ThrottlingData{}
			}
			if err := m.ThrottlingData.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PidsStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PidsStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PidsStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Current", wireType)
			}
			m.Current = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Current |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemoryData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemoryData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemoryData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Usage", wireType)
			}
			m.Usage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Usage |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxUsage", wireType)
			}
			m.MaxUsage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxUsage |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failcnt", wireType)
			}
			m.Failcnt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Failcnt |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemoryStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemoryStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemoryStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cache", wireType)
			}
			m.Cache = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Cache |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Usage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Usage == nil {
				m.Usage = &MemoryData{}
			}
			if err := m.Usage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SwapUsage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SwapUsage == nil {
				m.SwapUsage = &MemoryData{}
			}
			if err := m.SwapUsage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelUsage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KernelUsage == nil {
				m.KernelUsage = &MemoryData{}
			}
			if err := m.KernelUsage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseHierarchy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseHierarchy = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = make(map[string]uint64)
			}
			var mapkey string
			var mapvalue uint64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAgent
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAgent
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAgent(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthAgent
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Stats[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BlkioStatsEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BlkioStatsEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BlkioStatsEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Major", wireType)
			}
			m.Major = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Major |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Minor", wireType)
			}
			m.Minor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Minor |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Op = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BlkioStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BlkioStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BlkioStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoServiceBytesRecursive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IoServiceBytesRecursive = append(m.IoServiceBytesRecursive, &BlkioStatsEntry{})
			if err := m.IoServiceBytesRecursive[len(m.IoServiceBytesRecursive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoServicedRecursive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IoServicedRecursive = append(m.IoServicedRecursive, &BlkioStatsEntry{})
			if err := m.IoServicedRecursive[len(m.IoServicedRecursive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoQueuedRecursive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IoQueuedRecursive = append(m.IoQueuedRecursive, &BlkioStatsEntry{})
			if err := m.IoQueuedRecursive[len(m.IoQueuedRecursive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoServiceTimeRecursive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IoServiceTimeRecursive = append(m.IoServiceTimeRecursive, &BlkioStatsEntry{})
			if err := m.IoServiceTimeRecursive[len(m.IoServiceTimeRecursive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoWaitTimeRecursive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IoWaitTimeRecursive = append(m.IoWaitTimeRecursive, &BlkioStatsEntry{})
			if err := m.IoWaitTimeRecursive[len(m.IoWaitTimeRecursive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoMergedRecursive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IoMergedRecursive = append(m.IoMergedRecursive, &BlkioStatsEntry{})
			if err := m.IoMergedRecursive[len(m.IoMergedRecursive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoTimeRecursive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IoTimeRecursive = append(m.IoTimeRecursive, &BlkioStatsEntry{})
			if err := m.IoTimeRecursive[len(m.IoTimeRecursive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SectorsRecursive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SectorsRecursive = append(m.SectorsRecursive, &BlkioStatsEntry{})
			if err := m.SectorsRecursive[len(m.SectorsRecursive)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HugetlbStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HugetlbStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HugetlbStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Usage", wireType)
			}
			m.Usage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Usage |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxUsage", wireType)
			}
			m.MaxUsage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxUsage |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failcnt", wireType)
			}
			m.Failcnt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Failcnt |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CgroupStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CgroupStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CgroupStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CpuStats == nil {
				m.CpuStats = &CpuStats{}
			}
			if err := m.CpuStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MemoryStats == nil {
				m.MemoryStats = &MemoryStats{}
			}
			if err := m.MemoryStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PidsStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PidsStats == nil {
				m.PidsStats = &PidsStats{}
			}
			if err := m.PidsStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlkioStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BlkioStats == nil {
				m.BlkioStats = &BlkioStats{}
			}
			if err := m.BlkioStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HugetlbStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HugetlbStats == nil {
				m.HugetlbStats = make(map[string]*HugetlbStats)
			}
			var mapkey string
			var mapvalue *HugetlbStats
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAgent
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAgent
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAgent
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthAgent
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &HugetlbStats{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAgent(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthAgent
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.HugetlbStats[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RxBytes", wireType)
			}
			m.RxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RxBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RxPackets", wireType)
			}
			m.RxPackets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RxPackets |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RxErrors", wireType)
			}
			m.RxErrors = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RxErrors |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RxDropped", wireType)
			}
			m.RxDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RxDropped |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxBytes", wireType)
			}
			m.TxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxPackets", wireType)
			}
			m.TxPackets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxPackets |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxErrors", wireType)
			}
			m.TxErrors = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxErrors |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxDropped", wireType)
			}
			m.TxDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxDropped |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatsContainerResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatsContainerResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatsContainerResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CgroupStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CgroupStats == nil {
				m.CgroupStats = &CgroupStats{}
			}
			if err := m.CgroupStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkStats = append(m.NetworkStats, &NetworkStats{})
			if err := m.NetworkStats[len(m.NetworkStats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteStreamRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteStreamRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteStreamRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteStreamResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteStreamResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteStreamResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Len", wireType)
			}
			m.Len = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Len |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadStreamRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadStreamRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadStreamRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Len", wireType)
			}
			m.Len = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Len |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadStreamResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadStreamResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadStreamResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloseStdinRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloseStdinRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloseStdinRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TtyWinResizeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TtyWinResizeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TtyWinResizeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Row", wireType)
			}
			m.Row = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Row |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			m.Column = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Column |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KernelModule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KernelModule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KernelModule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parameters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Parameters = append(m.Parameters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateSandboxRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateSandboxRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateSandboxRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dns", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dns = append(m.Dns, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Storages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Storages = append(m.Storages, &Storage{})
			if err := m.Storages[len(m.Storages)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SandboxPidns", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SandboxPidns = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SandboxId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SandboxId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GuestHookPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GuestHookPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelModules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KernelModules = append(m.KernelModules, &KernelModule{})
			if err := m.KernelModules[len(m.KernelModules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DestroySandboxRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DestroySandboxRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DestroySandboxRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Interfaces) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Interfaces: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Interfaces: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interfaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Interfaces = append(m.Interfaces, &protocols.Interface{})
			if err := m.Interfaces[len(m.Interfaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Routes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Routes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Routes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, &protocols.Route{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateInterfaceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateInterfaceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateInterfaceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interface", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interface == nil {
				m.Interface = &protocols.Interface{}
			}
			if err := m.Interface.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateRoutesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateRoutesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateRoutesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Routes == nil {
				m.Routes = &Routes{}
			}
			if err := m.Routes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListInterfacesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListInterfacesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListInterfacesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListRoutesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListRoutesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListRoutesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ARPNeighbors) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ARPNeighbors: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ARPNeighbors: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ARPNeighbors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ARPNeighbors = append(m.ARPNeighbors, &protocols.ARPNeighbor{})
			if err := m.ARPNeighbors[len(m.ARPNeighbors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddARPNeighborsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddARPNeighborsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddARPNeighborsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Neighbors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Neighbors == nil {
				m.Neighbors = &ARPNeighbors{}
			}
			if err := m.Neighbors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OnlineCPUMemRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OnlineCPUMemRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OnlineCPUMemRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Wait", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Wait = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NbCpus", wireType)
			}
			m.NbCpus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NbCpus |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CpuOnly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReseedRandomDevRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReseedRandomDevRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReseedRandomDevRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AgentDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AgentDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AgentDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitDaemon", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InitDaemon = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeviceHandlers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeviceHandlers = append(m.DeviceHandlers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageHandlers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageHandlers = append(m.StorageHandlers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportsSeccomp", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SupportsSeccomp = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GuestDetailsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GuestDetailsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GuestDetailsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemBlockSize", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemBlockSize = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemHotplugProbe", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemHotplugProbe = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GuestDetailsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GuestDetailsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GuestDetailsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemBlockSizeBytes", wireType)
			}
			m.MemBlockSizeBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemBlockSizeBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentDetails", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentDetails == nil {
				m.AgentDetails = &AgentDetails{}
			}
			if err := m.AgentDetails.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportMemHotplugProbe", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SupportMemHotplugProbe = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemHotplugByProbeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemHotplugByProbeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemHotplugByProbeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.MemHotplugProbeAddr = append(m.MemHotplugProbeAddr, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAgent
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthAgent
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.MemHotplugProbeAddr) == 0 {
					m.MemHotplugProbeAddr = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.MemHotplugProbeAddr = append(m.MemHotplugProbeAddr, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field MemHotplugProbeAddr", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetGuestDateTimeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetGuestDateTimeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetGuestDateTimeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sec", wireType)
			}
			m.Sec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sec |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Usec", wireType)
			}
			m.Usec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Usec |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Storage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Storage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Storage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Driver", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Driver = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverOptions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DriverOptions = append(m.DriverOptions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fstype", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Fstype = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MountPoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MountPoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Device) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Device: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Device: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VmPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VmPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringUser) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringUser: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringUser: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalGids", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalGids = append(m.AdditionalGids, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CopyFileRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CopyFileRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CopyFileRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileSize", wireType)
			}
			m.FileSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileMode", wireType)
			}
			m.FileMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileMode |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DirMode", wireType)
			}
			m.DirMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DirMode |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			m.Uid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Uid |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gid", wireType)
			}
			m.Gid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Gid |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetOOMEventRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetOOMEventRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetOOMEventRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OOMEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OOMEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OOMEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSwapRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSwapRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSwapRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PCIPath = append(m.PCIPath, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAgent
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthAgent
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.PCIPath) == 0 {
					m.PCIPath = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAgent
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PCIPath = append(m.PCIPath, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PCIPath", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetMetricsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMetricsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMetricsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAgent
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAgent(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAgent
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAgent
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAgent
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAgent        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAgent          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAgent = fmt.Errorf("proto: unexpected end of group")
)
