package net.sf.jabref.logic.layout.format;

import net.sf.jabref.logic.layout.LayoutFormatter;

/**
 * Uses as input the fields (author or editor) in the LastFirst format.
 * 
 * This formater enables to abbreviate the authors name in the following way:
 * 
 * Ex: Someone, Van Something will be abbreviated as Someone, V.S.
 */
public class AuthorLastFirstAbbreviator implements LayoutFormatter {

    /**
     * @see net.sf.jabref.logic.layout.LayoutFormatter#format(java.lang.String)
     */
    @Override
    public String format(String fieldText) {

        /**
         * This formatter is a duplicate of AuthorAbbreviator, so we simply
         * call that one.
         */
        return new AuthorAbbreviator().format(fieldText);

    }
}
