#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "No Description found"

    def run(self):
        self.env["runtime"]["OutputManager"].present_text(
            _("screen {0}").format(self.env["screen"]["newTTY"]),
            sound_icon="ChangeTTY",
            interrupt=True,
            flush=False,
        )
        self.env["runtime"]["OutputManager"].present_text(
            self.env["screen"]["new_content_text"],
            interrupt=False,
            flush=False,
        )

    def set_callback(self, callback):
        pass
