/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains the {@link org.eclipse.collections.api.tuple.Pair} and {@link org.eclipse.collections.api.tuple.Twin} interfaces.
 * <p>
 *      A tuple is a container used to hold two related objects.
 * <p>
 *      This package contains 4 interfaces:
 * <ul>
 *   <li>
 *       {@link org.eclipse.collections.api.tuple.Pair} - a container that holds two related objects.
 *   </li>
 *   <li>
 *       {@link org.eclipse.collections.api.tuple.Twin} - a Pair that has the same type for both items.
 *   </li>
 *   <li>
 *       {@link org.eclipse.collections.api.tuple.Triple} - a container that holds three related objects.
 *   </li>
 *   <li>
 *       {@link org.eclipse.collections.api.tuple.Triplet} - a Triple that has the same type for all three items.
 *   </li>
 * </ul>
 */
package org.eclipse.collections.api.tuple;
