struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 841,
		.content =
			"processor\t: 0\n"
			"Processor\t: AArch64 Processor rev 1 (aarch64)\n"
			"model name\t: AArch64 Processor rev 1 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd04\n"
			"CPU revision\t: 1\n"
			"\n"
			"processor\t: 1\n"
			"Processor\t: AArch64 Processor rev 1 (aarch64)\n"
			"model name\t: AArch64 Processor rev 1 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd04\n"
			"CPU revision\t: 1\n"
			"\n"
			"processor\t: 2\n"
			"Processor\t: AArch64 Processor rev 1 (aarch64)\n"
			"model name\t: AArch64 Processor rev 1 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd04\n"
			"CPU revision\t: 1\n"
			"\n"
			"Hardware\t: MT8167B\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 1138,
		.content =
			"processor\t: 0\n"
			"model name\t: ARMv8 Processor rev 1 (v8l)\n"
			"Processor\t: AArch64 Processor rev 1 (aarch64)\n"
			"model name\t: AArch64 Processor rev 1 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt lpae evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd04\n"
			"CPU revision\t: 1\n"
			"\n"
			"processor\t: 1\n"
			"model name\t: ARMv8 Processor rev 1 (v8l)\n"
			"Processor\t: AArch64 Processor rev 1 (aarch64)\n"
			"model name\t: AArch64 Processor rev 1 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt lpae evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd04\n"
			"CPU revision\t: 1\n"
			"\n"
			"processor\t: 2\n"
			"model name\t: ARMv8 Processor rev 1 (v8l)\n"
			"Processor\t: AArch64 Processor rev 1 (aarch64)\n"
			"model name\t: AArch64 Processor rev 1 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt lpae evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd04\n"
			"CPU revision\t: 1\n"
			"\n"
			"Hardware\t: MT8167B\n",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 6925,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=NRD90M\n"
			"ro.build.version.incremental=1496325358\n"
			"ro.build.version.sdk=24\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=7.0\n"
			"ro.build.version.security_patch=2017-06-05\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Thu Jun  1 21:55:57 HKT 2017\n"
			"ro.build.date.utc=1496325357\n"
			"ro.build.type=user\n"
			"ro.build.user=zuotao\n"
			"ro.build.host=server22\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=full_neostra8167_tb_n-user\n"
			"ro.product.model=B3-A40\n"
			"ro.product.brand=acer\n"
			"ro.product.board=B3-A40\n"
			"ro.product.name=B3-A40_ww_gen1\n"
			"ro.product.device=acer_asgard\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=Acer\n"
			"ro.product.locale=en-US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=mt8167\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=acer_asgard\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=full_neostra8167_tb_n-user 7.0 NRD90M 1496325358 release-keys\n"
			"ro.build.fingerprint=acer/B3-A40_ww_gen1/acer_asgard:7.0/NRD90M/1496325358:user/release-keys\n"
			"ro.build.characteristics=tablet\n"
			"# end build properties\n"
			"ro.acer.iafw_version = F9.E1\n"
			"ro.acer.android_version = AV0N0\n"
			"ro.build.pandora.id = Acer_AV0N0_B3-A40_RV02RC01_WW_GEN1\n"
			"ro.build.display.id = Acer_AV0N0_B3-A40_2.001.00_WW_GEN1\n"
			"ro.build.img_pn.id = FM.NVZA0.00G\n"
			"ro.acer.product_sku = WIFI\n"
			"ro.acer.device_info_version = 1.0\n"
			"ro.acer.touch_fw_version= Goodix FW:1070 & CFG:71\n"
			"ro.acer.manufacturer = Acer\n"
			"ro.acer.modelid = B3-A40\n"
			"ro.acer.cpu_vendor = MTK\n"
			"ro.acer.cpu_speed = 1.3GHz\n"
			"ro.acer.cpu_version = MT 8167\n"
			"ro.acer.cpu_core = Quad cores\n"
			"ro.acer.rom_size = 16GB\n"
			"ro.acer.ram_size = 2GB\n"
			"ro.acer.horizontal_pixels = 1280\n"
			"ro.acer.vertical_pixels = 800\n"
			"ro.build.sku= WW_GEN1\n"
			"ro.acer.nidus_server = 1\n"
			"#\n"
			"# from device/neostra/neostra8167_tb_n/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for generic sdk\n"
			"#\n"
			"\n"
			"rild.libpath=mtk-ril.so\n"
			"rild.libargs=-d /dev/ttyC0\n"
			"\n"
			"\n"
			"# MTK, Infinity, 20090720 {\n"
			"wifi.interface=wlan0\n"
			"# MTK, Infinity, 20090720 }\n"
			"\n"
			"# MTK, mtk03034, 20101210 {\n"
			"ro.mediatek.wlan.wsc=1\n"
			"# MTK, mtk03034 20101210}\n"
			"# MTK, mtk03034, 20110318 {\n"
			"ro.mediatek.wlan.p2p=1\n"
			"# MTK, mtk03034 20110318}\n"
			"\n"
			"# MTK, mtk03034, 20101213 {\n"
			"mediatek.wlan.ctia=0\n"
			"# MTK, mtk03034 20101213}\n"
			"\n"
			"\n"
			"#\n"
			"wifi.tethering.interface=ap0\n"
			"#\n"
			"\n"
			"ro.opengles.version=196610\n"
			"\n"
			"wifi.direct.interface=p2p0\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=256m\n"
			"\n"
			"# USB MTP WHQL\n"
			"ro.sys.usb.mtp.whql.enable=0\n"
			"\n"
			"# Power off opt in IPO\n"
			"sys.ipo.pwrdncap=2\n"
			"\n"
			"ro.sys.usb.storage.type=mtp\n"
			"\n"
			"# USB BICR function\n"
			"ro.sys.usb.bicr=no\n"
			"\n"
			"# USB Charge only function\n"
			"ro.sys.usb.charging.only=yes\n"
			"\n"
			"# audio\n"
			"ro.camera.sound.forced=0\n"
			"ro.audio.silent=0\n"
			"\n"
			"ro.zygote.preload.enable=0\n"
			"\n"
			"# temporary enables NAV bar (soft keys)\n"
			"qemu.hw.mainkeys=0\n"
			"\n"
			"ro.kernel.zio=38,108,105,16\n"
			"#ro.kernel.qemu=1\n"
			"#ro.kernel.qemu.gles=0\n"
			"ro.boot.selinux=disable\n"
			"\n"
			"# Disable dirty region for Mali\n"
			"debug.hwui.render_dirty_regions=false\n"
			"\n"
			"ro.sf.lcd_density=160\n"
			"\n"
			"# disable ipo for development\n"
			"sys.ipo.disable=1\n"
			"\n"
			"#for mali\n"
			"#ro.hardware.gralloc=mt8167.mali\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.config.ringtone=Ring_Synth_04.ogg\n"
			"ro.config.notification_sound=pixiedust.ogg\n"
			"ro.carrier=unknown\n"
			"ro.config.alarm_alert=Alarm_Classic.ogg\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=256m\n"
			"ro.mediatek.chip_ver=S01\n"
			"ro.mediatek.platform=MT8167\n"
			"ro.telephony.sim.count=2\n"
			"persist.radio.default.sim=0\n"
			"persist.radio.multisim.config=ss\n"
			"ro.mtk_key_manager_kb_path=4\n"
			"ril.specific.sm_cause=0\n"
			"bgw.current3gband=0\n"
			"ril.external.md=0\n"
			"ro.btstack=blueangel\n"
			"ro.sf.hwrotation=0\n"
			"persist.mtk.wcn.combo.chipid=-1\n"
			"service.wcn.driver.ready=no\n"
			"drm.service.enabled=true\n"
			"mtk_in_house_tee_support=true\n"
			"fmradio.driver.enable=0\n"
			"ril.first.md=1\n"
			"ril.flightmode.poweroffMD=1\n"
			"ril.telephony.mode=0\n"
			"dalvik.vm.mtk-stack-trace-file=/data/anr/mtk_traces.txt\n"
			"mediatek.wlan.chip=CONSYS_MT6630\n"
			"mediatek.wlan.module.postfix=_consys_mt6630\n"
			"ril.radiooff.poweroffMD=0\n"
			"ro.frp.pst=/dev/block/platform/bootdevice/by-name/frp\n"
			"ro.mtk_protocol1_rat_config=no\n"
			"ro.mtk_support_mp2_playback=1\n"
			"ro.mtk_audio_alac_support=1\n"
			"ro.mediatek.version.branch=alps-mp-n0.mp13\n"
			"ro.mediatek.version.release=alps-mp-n0.mp13-V1_neostra8167.tb.n_P27\n"
			"ro.mediatek.version.sdk=4\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=7.0_r7\n"
			"ro.com.google.clientidbase=android-acer\n"
			"ro.com.google.clientidbase.ms=android-acer\n"
			"ro.com.google.clientidbase.yt=android-acer\n"
			"ro.com.google.clientidbase.am=android-acer\n"
			"ro.com.google.clientidbase.gmm=android-acer\n"
			"ro.mtk_audenh_support=1\n"
			"ro.mtk_besloudness_support=1\n"
			"ro.mtk_bt_support=1\n"
			"ro.mtk_wappush_support=1\n"
			"ro.mtk_audio_tuning_tool_ver=V2.2\n"
			"ro.mtk_wlan_support=1\n"
			"ro.mtk_gps_support=1\n"
			"ro.mtk_search_db_support=1\n"
			"ro.mtk_dialer_search_support=1\n"
			"ro.mtk_dhcpv6c_wifi=1\n"
			"ro.have_aacencode_feature=1\n"
			"ro.mtk_oma_drm_support=1\n"
			"ro.mtk_cta_drm_support=1\n"
			"ro.mtk_widevine_drm_l3_support=1\n"
			"ro.mtk_audio_ape_support=1\n"
			"ro.mtk_wmv_playback_support=1\n"
			"ro.mtk_send_rr_support=1\n"
			"ro.mtk_emmc_support=1\n"
			"ro.mtk_tetheringipv6_support=1\n"
			"ro.telephony.default_network=0\n"
			"ro.mtk_shared_sdcard=1\n"
			"ro.mtk_flight_mode_power_off_md=1\n"
			"ro.mtk_aal_support=1\n"
			"ro.mtk_pq_support=2\n"
			"ro.mtk_pq_color_mode=1\n"
			"ro.mtk_miravision_support=1\n"
			"ro.mtk_blulight_def_support=1\n"
			"ro.mtk_wifi_mcc_support=1\n"
			"ro.mtk_bip_scws=1\n"
			"ro.mtk_wfd_hdcp_tx_support=1\n"
			"ro.mtk_wfd_hdcp_rx_support=1\n"
			"ro.mtk_world_phone_policy=0\n"
			"ro.mtk_perfservice_support=1\n"
			"ro.mtk_owner_sdcard_support=1\n"
			"ro.mtk_owner_sim_support=1\n"
			"ro.mtk_cta_set=1\n"
			"ro.mtk_multi_patition=1\n"
			"ro.mtk_key_manager_support=1\n"
			"ro.mtk_cam_mfb_support=0\n"
			"ro.mtk_cam_cfb=1\n"
			"ro.mtk_external_sim_only_slots=0\n"
			"ro.mtk_bg_power_saving_support=1\n"
			"ro.mtk_bg_power_saving_ui=1\n"
			"ro.have_aee_feature=1\n"
			"ro.sim_me_lock_mode=0\n"
			"ro.ap_info_monitor=0\n"
			"ro.mtk_dual_mic_support=0\n"
			"ro.mtk_is_tablet=1\n"
			"persist.mtk_nlp_switch_support=1\n"
			"wfd.dummy.enable=1\n"
			"wfd.iframesize.level=0\n"
			"ro.mediatek.project.path=device/neostra/neostra8167_tb_n\n"
			"ro.mtk_sec_video_path_support=1\n"
			"persist.mtk.wcn.patch.version=-1\n"
			"persist.mtk.wcn.dynamic.dump=0\n"
			"service.wcn.coredump.mode=0\n"
			"persist.mtk.connsys.poweron.ctl=0\n"
			"ro.com.android.mobiledata=true\n"
			"persist.radio.mobile.data=0,0\n"
			"persist.meta.dumpdata=0\n"
			"ro.mtk_deinterlace_support=1\n"
			"persist.radio.mtk_ps2_rat=G\n"
			"persist.log.tag.DCT=D\n"
			"ro.boot.opt_using_default=1\n"
			"mtk.vdec.waitkeyframeforplay=1\n"
			"ro.sys.sdcardfs=1\n"
			"ro.ksc5601_write=0\n"
			"ro.email_support_ucs2=0\n"
			"ro.ussd_ksc5601=0\n"
			"persist.log.tag.CdmaMoSms=I\n"
			"persist.log.tag.CdmaMtSms=I\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.variant=cortex-a53\n"
			"dalvik.vm.isa.arm64.features=default\n"
			"dalvik.vm.isa.arm.variant=cortex-a53\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.expect.recovery_id=0x5813e2fd866f7283168398ebe58e4bd58e8d5413000000000000000000000000\n",
	},
	{
		.path = "/sys/devices/system/cpu/isolated",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 66,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 4,
		.content = "2-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 18,
		.content = "mt81xx_v2_cpuidle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 13,
		.content = "mtk_governor\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/cpus_per_cluster",
		.size = 12,
		.content = "cluster0: f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/glbinfo",
		.size = 58,
		.content =
			"big/little arch: no\n"
			"nr_cups: 4\n"
			"nr_clusters: 1\n"
			"cluster0: f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_big_little",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_multi_cluster",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/nr_clusters",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 39,
		.content = "598000 747500 1040000 1196000 1300000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 12,
		.content = "mtk-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 60,
		.content =
			"598000 2118\n"
			"747500 263\n"
			"1040000 619\n"
			"1196000 458\n"
			"1300000 5963\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "213\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/trans_table",
		.size = 389,
		.content =
			"   From  :    To\n"
			"         :    598000    747500   1040000   1196000   1300000 \n"
			"   598000:         0        14         0         0        38 \n"
			"   747500:         5         0        14         0         9 \n"
			"  1040000:         6         3         0        12        11 \n"
			"  1196000:         3         1         1         0        19 \n"
			"  1300000:        39        10        16        12         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 39,
		.content = "598000 747500 1040000 1196000 1300000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 12,
		.content = "mtk-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 60,
		.content =
			"598000 2359\n"
			"747500 263\n"
			"1040000 619\n"
			"1196000 458\n"
			"1300000 5963\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "213\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/trans_table",
		.size = 389,
		.content =
			"   From  :    To\n"
			"         :    598000    747500   1040000   1196000   1300000 \n"
			"   598000:         0        14         0         0        38 \n"
			"   747500:         5         0        14         0         9 \n"
			"  1040000:         6         3         0        12        11 \n"
			"  1196000:         3         1         1         0        19 \n"
			"  1300000:        39        10        16        12         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 39,
		.content = "598000 747500 1040000 1196000 1300000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 12,
		.content = "mtk-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 60,
		.content =
			"598000 2600\n"
			"747500 263\n"
			"1040000 619\n"
			"1196000 458\n"
			"1300000 5963\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 4,
		.content = "213\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/trans_table",
		.size = 389,
		.content =
			"   From  :    To\n"
			"         :    598000    747500   1040000   1196000   1300000 \n"
			"   598000:         0        14         0         0        38 \n"
			"   747500:         5         0        14         0         9 \n"
			"  1040000:         6         3         0        12        11 \n"
			"  1196000:         3         1         1         0        19 \n"
			"  1300000:        39        10        16        12         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 39,
		.content = "598000 747500 1040000 1196000 1300000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 12,
		.content = "mtk-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "598000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 60,
		.content =
			"598000 2821\n"
			"747500 263\n"
			"1040000 619\n"
			"1196000 458\n"
			"1300000 5963\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 4,
		.content = "213\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/trans_table",
		.size = 389,
		.content =
			"   From  :    To\n"
			"         :    598000    747500   1040000   1196000   1300000 \n"
			"   598000:         0        14         0         0        38 \n"
			"   747500:         5         0        14         0         9 \n"
			"  1040000:         6         3         0        12        11 \n"
			"  1196000:         3         1         1         0        19 \n"
			"  1300000:        39        10        16        12         0 \n",
	},
	{ NULL },
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.music.outputid",
		.value = "2",
	},
	{
		.key = "bgw.current3gband",
		.value = "0",
	},
	{
		.key = "camera.disable_zsl_mode",
		.value = "1",
	},
	{
		.key = "dalvik.vm.appimageformat",
		.value = "lz4",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm64.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.mtk-stack-trace-file",
		.value = "/data/anr/mtk_traces.txt",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "dalvik.vm.usejit",
		.value = "true",
	},
	{
		.key = "dalvik.vm.usejitprofiles",
		.value = "true",
	},
	{
		.key = "debug.MB.running",
		.value = "0",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwc.bq_count",
		.value = "3",
	},
	{
		.key = "debug.hwc.compose_level",
		.value = "0",
	},
	{
		.key = "debug.hwui.render_dirty_regions",
		.value = "false",
	},
	{
		.key = "debug.mtk.aee.status",
		.value = "free",
	},
	{
		.key = "debug.mtk.aee.status64",
		.value = "free",
	},
	{
		.key = "debug.mtklog.netlog.Running",
		.value = "0",
	},
	{
		.key = "debug.pq.dshp.en",
		.value = "2",
	},
	{
		.key = "debug.pq.shp.en",
		.value = "2",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "fmradio.driver.enable",
		.value = "0",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.state",
		.value = "NOT_READY",
	},
	{
		.key = "init.svc.DMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.MtkCodecService",
		.value = "running",
	},
	{
		.key = "init.svc.NvRAMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.XoSetCap",
		.value = "stopped",
	},
	{
		.key = "init.svc.aal",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.audioserver",
		.value = "running",
	},
	{
		.key = "init.svc.batterywarning",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootlogoupdater",
		.value = "stopped",
	},
	{
		.key = "init.svc.cameraserver",
		.value = "running",
	},
	{
		.key = "init.svc.clear-bcb",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.enableswap",
		.value = "stopped",
	},
	{
		.key = "init.svc.epdg_wod",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.ged_srv",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.kisd",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mediacodec",
		.value = "running",
	},
	{
		.key = "init.svc.mediadrm",
		.value = "running",
	},
	{
		.key = "init.svc.mediaextractor",
		.value = "running",
	},
	{
		.key = "init.svc.mnld",
		.value = "running",
	},
	{
		.key = "init.svc.mobile_log_d",
		.value = "running",
	},
	{
		.key = "init.svc.msensord",
		.value = "stopped",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netdiag",
		.value = "running",
	},
	{
		.key = "init.svc.nvram_daemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.pq",
		.value = "running",
	},
	{
		.key = "init.svc.program_binary",
		.value = "running",
	},
	{
		.key = "init.svc.rpmb_svc",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.slpd",
		.value = "running",
	},
	{
		.key = "init.svc.sn",
		.value = "running",
	},
	{
		.key = "init.svc.start_modem",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.thermal",
		.value = "running",
	},
	{
		.key = "init.svc.thermal_manager",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermald",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.watchdogd",
		.value = "running",
	},
	{
		.key = "init.svc.wifi2agps",
		.value = "running",
	},
	{
		.key = "init.svc.wmt_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.wmt_loader",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "log.tag",
		.value = "E",
	},
	{
		.key = "media.wfd.portrait",
		.value = "0",
	},
	{
		.key = "mediatek.wlan.chip",
		.value = "CONSYS_MT6630",
	},
	{
		.key = "mediatek.wlan.ctia",
		.value = "0",
	},
	{
		.key = "mediatek.wlan.module.postfix",
		.value = "_consys_mt6630",
	},
	{
		.key = "mtk.vdec.waitkeyframeforplay",
		.value = "1",
	},
	{
		.key = "mtk_in_house_tee_support",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-15799008cda65100",
	},
	{
		.key = "net.nsiot_pending",
		.value = "false",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "persist.dm.lock",
		.value = "false",
	},
	{
		.key = "persist.log.tag.CdmaMoSms",
		.value = "I",
	},
	{
		.key = "persist.log.tag.CdmaMtSms",
		.value = "I",
	},
	{
		.key = "persist.log.tag.DCT",
		.value = "D",
	},
	{
		.key = "persist.logd.size",
		.value = "",
	},
	{
		.key = "persist.meta.dumpdata",
		.value = "0",
	},
	{
		.key = "persist.mtk.connsys.poweron.ctl",
		.value = "0",
	},
	{
		.key = "persist.mtk.wcn.combo.chipid",
		.value = "0x6630",
	},
	{
		.key = "persist.mtk.wcn.dynamic.dump",
		.value = "0",
	},
	{
		.key = "persist.mtk.wcn.patch.version",
		.value = "20170312130517a",
	},
	{
		.key = "persist.mtk_nlp_switch_support",
		.value = "1",
	},
	{
		.key = "persist.radio.data.iccid",
		.value = "",
	},
	{
		.key = "persist.radio.default.sim",
		.value = "0",
	},
	{
		.key = "persist.radio.mobile.data",
		.value = "0,0",
	},
	{
		.key = "persist.radio.mtk_ps2_rat",
		.value = "G",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "ss",
	},
	{
		.key = "persist.radio.reset_on_switch",
		.value = "true",
	},
	{
		.key = "persist.service.acm.enable",
		.value = "0",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "22:22:89:d4:b6:78",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.first_time_boot",
		.value = "false",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.mute.state",
		.value = "2",
	},
	{
		.key = "persist.sys.pq.adl.idx",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.hdr.en",
		.value = "1",
	},
	{
		.key = "persist.sys.pq.iso.shp.en",
		.value = "1",
	},
	{
		.key = "persist.sys.pq.log.en",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.mdp.color.dbg",
		.value = "1",
	},
	{
		.key = "persist.sys.pq.mdp.color.idx",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.shp.idx",
		.value = "2",
	},
	{
		.key = "persist.sys.pq.ultrares.en",
		.value = "1",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.sd.defaultpath",
		.value = "/storage/emulated/0",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/New_York",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.webview.vmsize",
		.value = "112775696",
	},
	{
		.key = "pm.dexopt.ab-ota",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.bg-dexopt",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.boot",
		.value = "verify-profile",
	},
	{
		.key = "pm.dexopt.core-app",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.first-boot",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.forced-dexopt",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.install",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.nsys-library",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.shared-apk",
		.value = "speed",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "0",
	},
	{
		.key = "ril.external.md",
		.value = "0",
	},
	{
		.key = "ril.first.md",
		.value = "1",
	},
	{
		.key = "ril.flightmode.poweroffMD",
		.value = "1",
	},
	{
		.key = "ril.imsi.status.sim1",
		.value = "0",
	},
	{
		.key = "ril.radiooff.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.specific.sm_cause",
		.value = "0",
	},
	{
		.key = "ril.telephony.mode",
		.value = "0",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/ttyC0",
	},
	{
		.key = "rild.libpath",
		.value = "mtk-ril.so",
	},
	{
		.key = "rild.mark_switchuser",
		.value = "0",
	},
	{
		.key = "ro.acer.android_version",
		.value = "AV0N0",
	},
	{
		.key = "ro.acer.cpu_core",
		.value = "Quad cores",
	},
	{
		.key = "ro.acer.cpu_speed",
		.value = "1.3GHz",
	},
	{
		.key = "ro.acer.cpu_vendor",
		.value = "MTK",
	},
	{
		.key = "ro.acer.cpu_version",
		.value = "MT 8167",
	},
	{
		.key = "ro.acer.device_info_version",
		.value = "1.0",
	},
	{
		.key = "ro.acer.horizontal_pixels",
		.value = "1280",
	},
	{
		.key = "ro.acer.iafw_version",
		.value = "F9.E1",
	},
	{
		.key = "ro.acer.manufacturer",
		.value = "Acer",
	},
	{
		.key = "ro.acer.modelid",
		.value = "B3-A40",
	},
	{
		.key = "ro.acer.nidus_server",
		.value = "1",
	},
	{
		.key = "ro.acer.product_sku",
		.value = "WIFI",
	},
	{
		.key = "ro.acer.ram_size",
		.value = "2GB",
	},
	{
		.key = "ro.acer.rom_size",
		.value = "16GB",
	},
	{
		.key = "ro.acer.touch_fw_version",
		.value = "Goodix FW:1070 & CFG:71",
	},
	{
		.key = "ro.acer.vertical_pixels",
		.value = "800",
	},
	{
		.key = "ro.aceruuid",
		.value = "00000000000000068b35e3793c1",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.aee.enperf",
		.value = "off",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.ap_info_monitor",
		.value = "0",
	},
	{
		.key = "ro.audio.silent",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "mt8167",
	},
	{
		.key = "ro.boot.bootreason",
		.value = "power_key",
	},
	{
		.key = "ro.boot.flash.locked",
		.value = "1",
	},
	{
		.key = "ro.boot.hardware",
		.value = "mt8167",
	},
	{
		.key = "ro.boot.opt_using_default",
		.value = "1",
	},
	{
		.key = "ro.boot.selinux",
		.value = "disable",
	},
	{
		.key = "ro.boot.serialno",
		.value = "721000442815",
	},
	{
		.key = "ro.boot.verifiedbootstate",
		.value = "green",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Thu Jun 1 21:55:57 HKT 2017",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1496325357",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "acer/B3-A40_ww_gen1/acer_asgard:7.0/NRD90M/1496325358:user/release-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.btstack",
		.value = "blueangel",
	},
	{
		.key = "ro.build.characteristics",
		.value = "tablet",
	},
	{
		.key = "ro.build.date",
		.value = "Thu Jun  1 21:55:57 HKT 2017",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1496325357",
	},
	{
		.key = "ro.build.description",
		.value = "full_neostra8167_tb_n-user 7.0 NRD90M 1496325358 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "Acer_AV0N0_B3-A40_2.001.00_WW_GEN1",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "acer/B3-A40_ww_gen1/acer_asgard:7.0/NRD90M/1496325358:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "full_neostra8167_tb_n-user",
	},
	{
		.key = "ro.build.host",
		.value = "server22",
	},
	{
		.key = "ro.build.id",
		.value = "NRD90M",
	},
	{
		.key = "ro.build.img_pn.id",
		.value = "FM.NVZA0.00G",
	},
	{
		.key = "ro.build.pandora.id",
		.value = "Acer_AV0N0_B3-A40_RV02RC01_WW_GEN1",
	},
	{
		.key = "ro.build.product",
		.value = "acer_asgard",
	},
	{
		.key = "ro.build.sku",
		.value = "WW_GEN1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "zuotao",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "1496325358",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "7.0",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "24",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-06-05",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "0",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.mobiledata",
		.value = "true",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-acer",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-acer",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-acer",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-acer",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-acer",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "7.0_r7",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Alarm_Classic.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "pixiedust.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Ring_Synth_04.ogg",
	},
	{
		.key = "ro.countrycode",
		.value = "5553",
	},
	{
		.key = "ro.crypto.fs_crypto_blkdev",
		.value = "/dev/block/dm-1",
	},
	{
		.key = "ro.crypto.state",
		.value = "encrypted",
	},
	{
		.key = "ro.crypto.type",
		.value = "block",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.device.sn",
		.value = "NTLDNAA001721001BA8F00",
	},
	{
		.key = "ro.email_support_ucs2",
		.value = "0",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x5813e2fd866f7283168398ebe58e4bd58e8d5413000000000000000000000000",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/platform/bootdevice/by-name/frp",
	},
	{
		.key = "ro.hardware",
		.value = "mt8167",
	},
	{
		.key = "ro.have_aacencode_feature",
		.value = "1",
	},
	{
		.key = "ro.have_aee_feature",
		.value = "1",
	},
	{
		.key = "ro.kernel.zio",
		.value = "38,108,105,16",
	},
	{
		.key = "ro.ksc5601_write",
		.value = "0",
	},
	{
		.key = "ro.mediatek.chip_ver",
		.value = "S01",
	},
	{
		.key = "ro.mediatek.platform",
		.value = "MT8167",
	},
	{
		.key = "ro.mediatek.project.path",
		.value = "device/neostra/neostra8167_tb_n",
	},
	{
		.key = "ro.mediatek.version.branch",
		.value = "alps-mp-n0.mp13",
	},
	{
		.key = "ro.mediatek.version.release",
		.value = "alps-mp-n0.mp13-V1_neostra8167.tb.n_P27",
	},
	{
		.key = "ro.mediatek.version.sdk",
		.value = "4",
	},
	{
		.key = "ro.mediatek.wlan.p2p",
		.value = "1",
	},
	{
		.key = "ro.mediatek.wlan.wsc",
		.value = "1",
	},
	{
		.key = "ro.mount.fs",
		.value = "EXT4",
	},
	{
		.key = "ro.mtk_aal_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audenh_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_alac_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_ape_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_tuning_tool_ver",
		.value = "V2.2",
	},
	{
		.key = "ro.mtk_besloudness_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_ui",
		.value = "1",
	},
	{
		.key = "ro.mtk_bip_scws",
		.value = "1",
	},
	{
		.key = "ro.mtk_blulight_def_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bt_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_cfb",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_mfb_support",
		.value = "0",
	},
	{
		.key = "ro.mtk_cta_drm_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cta_set",
		.value = "1",
	},
	{
		.key = "ro.mtk_deinterlace_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_dhcpv6c_wifi",
		.value = "1",
	},
	{
		.key = "ro.mtk_dialer_search_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_dual_mic_support",
		.value = "0",
	},
	{
		.key = "ro.mtk_emmc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_external_sim_only_slots",
		.value = "0",
	},
	{
		.key = "ro.mtk_flight_mode_power_off_md",
		.value = "1",
	},
	{
		.key = "ro.mtk_gps_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_is_tablet",
		.value = "1",
	},
	{
		.key = "ro.mtk_key_manager_kb_path",
		.value = "4",
	},
	{
		.key = "ro.mtk_key_manager_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_miravision_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_multi_patition",
		.value = "1",
	},
	{
		.key = "ro.mtk_oma_drm_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_owner_sdcard_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_owner_sim_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_perfservice_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_pq_color_mode",
		.value = "1",
	},
	{
		.key = "ro.mtk_pq_support",
		.value = "2",
	},
	{
		.key = "ro.mtk_protocol1_rat_config",
		.value = "no",
	},
	{
		.key = "ro.mtk_search_db_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_sec_video_path_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_send_rr_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_shared_sdcard",
		.value = "1",
	},
	{
		.key = "ro.mtk_support_mp2_playback",
		.value = "1",
	},
	{
		.key = "ro.mtk_tetheringipv6_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wappush_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_hdcp_rx_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_hdcp_tx_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_widevine_drm_l3_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wifi_mcc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wlan_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wmv_playback_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_world_phone_policy",
		.value = "0",
	},
	{
		.key = "ro.oem_unlock_supported",
		.value = "1",
	},
	{
		.key = "ro.opengles.version",
		.value = "196610",
	},
	{
		.key = "ro.product.board",
		.value = "B3-A40",
	},
	{
		.key = "ro.product.brand",
		.value = "acer",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.device",
		.value = "acer_asgard",
	},
	{
		.key = "ro.product.locale",
		.value = "en-US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "Acer",
	},
	{
		.key = "ro.product.model",
		.value = "B3-A40",
	},
	{
		.key = "ro.product.name",
		.value = "B3-A40_ww_gen1",
	},
	{
		.key = "ro.recovery_id",
		.value = "0x5813e2fd866f7283168398ebe58e4bd58e8d5413000000000000000000000000",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1492435106903",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "721000442815",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.hwrotation",
		.value = "0",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "160",
	},
	{
		.key = "ro.sim_me_lock_mode",
		.value = "0",
	},
	{
		.key = "ro.sys.sdcardfs",
		.value = "1",
	},
	{
		.key = "ro.sys.usb.bicr",
		.value = "no",
	},
	{
		.key = "ro.sys.usb.charging.only",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.mtp.whql.enable",
		.value = "0",
	},
	{
		.key = "ro.sys.usb.storage.type",
		.value = "mtp",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "0",
	},
	{
		.key = "ro.telephony.sim.count",
		.value = "2",
	},
	{
		.key = "ro.ussd_ksc5601",
		.value = "0",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.wlan.mtk.wifi.5g",
		.value = "1",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "ro.zygote.preload.enable",
		.value = "0",
	},
	{
		.key = "security.perf_harden",
		.value = "1",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "service.nvram_init",
		.value = "Ready",
	},
	{
		.key = "service.wcn.coredump.mode",
		.value = "0",
	},
	{
		.key = "service.wcn.driver.ready",
		.value = "yes",
	},
	{
		.key = "sys.acer.AcceptKey",
		.value = "0",
	},
	{
		.key = "sys.acer.EnableEZSnap",
		.value = "1",
	},
	{
		.key = "sys.acer.libezgesture_path",
		.value = "/system/vendor/lib64/libezgesture.so",
	},
	{
		.key = "sys.boot.reason",
		.value = "0",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.ezu.verify_password",
		.value = "1",
	},
	{
		.key = "sys.ipo.disable",
		.value = "1",
	},
	{
		.key = "sys.ipo.pwrdncap",
		.value = "2",
	},
	{
		.key = "sys.ipowin.done",
		.value = "1",
	},
	{
		.key = "sys.lowstorage_flag",
		.value = "0",
	},
	{
		.key = "sys.oem_unlock_allowed",
		.value = "0",
	},
	{
		.key = "sys.phonewindowmanager.Ready",
		.value = "1",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "12000",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.configfs",
		.value = "0",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.vid",
		.value = "0502",
	},
	{
		.key = "vold.btaddr",
		.value = "68b35e3793c1",
	},
	{
		.key = "vold.decrypt",
		.value = "trigger_restart_framework",
	},
	{
		.key = "vold.emmc_size",
		.value = "15636365312",
	},
	{
		.key = "vold.has_adoptable",
		.value = "1",
	},
	{
		.key = "vold.path.internal_storage",
		.value = "/storage/emulated/0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "vold.support_external_sd",
		.value = "0",
	},
	{
		.key = "wfd.dummy.enable",
		.value = "1",
	},
	{
		.key = "wfd.iframesize.level",
		.value = "0",
	},
	{
		.key = "wifi.direct.interface",
		.value = "p2p0",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wifi.tethering.interface",
		.value = "ap0",
	},
	{
		.key = "wlan.driver.status",
		.value = "unloaded",
	},
	{
		.key = "wlan.wfd.security.image",
		.value = "1",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
