   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.30  08/16/14            */
   /*                                                     */
   /*         DEFGLOBAL BASIC COMMANDS HEADER FILE        */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*      Brian L. Dantes                                      */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.23: Correction for FalseSymbol/TrueSymbol. DR0859  */
/*                                                           */
/*            Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*            Changed name of variable log to logName        */
/*            because of Unix compiler warnings of shadowed  */
/*            definitions.                                   */
/*                                                           */
/*      6.24: Renamed BOOLEAN macro type to intBool.         */
/*                                                           */
/*      6.30: Removed conditional code for unsupported       */
/*            compilers/operating systems (IBM_MCW,          */
/*            MAC_MCW, and IBM_TBC).                         */
/*                                                           */
/*            Added const qualifiers to remove C++           */
/*            deprecation warnings.                          */
/*                                                           */
/*            Moved WatchGlobals global to defglobalData.    */
/*                                                           */
/*            Converted API macros to function calls.        */
/*                                                           */
/*************************************************************/

#ifndef _H_globlbsc
#define _H_globlbsc

#ifndef _H_evaluatn
#include "evaluatn.h"
#endif

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _GLOBLBSC_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

   LOCALE void                           DefglobalBasicCommands(void *);
   LOCALE void                           UndefglobalCommand(void *);
   LOCALE intBool                        EnvUndefglobal(void *,void *);
   LOCALE void                           GetDefglobalListFunction(void *,DATA_OBJECT_PTR);
   LOCALE void                           EnvGetDefglobalList(void *,DATA_OBJECT_PTR,void *);
   LOCALE void                          *DefglobalModuleFunction(void *);
   LOCALE void                           PPDefglobalCommand(void *);
   LOCALE int                            PPDefglobal(void *,const char *,const char *);
   LOCALE void                           ListDefglobalsCommand(void *);
#if DEBUGGING_FUNCTIONS
   LOCALE unsigned                       EnvGetDefglobalWatch(void *,void *);
   LOCALE void                           EnvListDefglobals(void *,const char *,void *);
   LOCALE void                           EnvSetDefglobalWatch(void *,unsigned,void *);
#endif
   LOCALE void                           ResetDefglobals(void *);

#if ALLOW_ENVIRONMENT_GLOBALS

   LOCALE void                           GetDefglobalList(DATA_OBJECT_PTR,void *);
#if DEBUGGING_FUNCTIONS
   LOCALE unsigned                       GetDefglobalWatch(void *);
   LOCALE void                           ListDefglobals(const char *,void *);
   LOCALE void                           SetDefglobalWatch(unsigned,void *);
#endif
   LOCALE intBool                        Undefglobal(void *);
   
#endif /* ALLOW_ENVIRONMENT_GLOBALS */

#endif /* _H_globlbsc */


