{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetBack: TAbstractTexture2DNode;
    procedure SetBack(const Value: TAbstractTexture2DNode);
    function GetBottom: TAbstractTexture2DNode;
    procedure SetBottom(const Value: TAbstractTexture2DNode);
    function GetFront: TAbstractTexture2DNode;
    procedure SetFront(const Value: TAbstractTexture2DNode);
    function GetLeft: TAbstractTexture2DNode;
    procedure SetLeft(const Value: TAbstractTexture2DNode);
    function GetRight: TAbstractTexture2DNode;
    procedure SetRight(const Value: TAbstractTexture2DNode);
    function GetTop: TAbstractTexture2DNode;
    procedure SetTop(const Value: TAbstractTexture2DNode);
    function GetTextureProperties: TTexturePropertiesNode;
    procedure SetTextureProperties(const Value: TTexturePropertiesNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdBack: TSFNode;
    { Internal wrapper for property @code(Back). This wrapper API may change, we advise to access simpler @code(Back) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBack: TSFNode read FFdBack;
    {  }
    property Back: TAbstractTexture2DNode read GetBack write SetBack;

    strict private FFdBottom: TSFNode;
    { Internal wrapper for property @code(Bottom). This wrapper API may change, we advise to access simpler @code(Bottom) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBottom: TSFNode read FFdBottom;
    {  }
    property Bottom: TAbstractTexture2DNode read GetBottom write SetBottom;

    strict private FFdFront: TSFNode;
    { Internal wrapper for property @code(Front). This wrapper API may change, we advise to access simpler @code(Front) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFront: TSFNode read FFdFront;
    {  }
    property Front: TAbstractTexture2DNode read GetFront write SetFront;

    strict private FFdLeft: TSFNode;
    { Internal wrapper for property @code(Left). This wrapper API may change, we advise to access simpler @code(Left) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLeft: TSFNode read FFdLeft;
    {  }
    property Left: TAbstractTexture2DNode read GetLeft write SetLeft;

    strict private FFdRight: TSFNode;
    { Internal wrapper for property @code(Right). This wrapper API may change, we advise to access simpler @code(Right) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRight: TSFNode read FFdRight;
    {  }
    property Right: TAbstractTexture2DNode read GetRight write SetRight;

    strict private FFdTop: TSFNode;
    { Internal wrapper for property @code(Top). This wrapper API may change, we advise to access simpler @code(Top) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTop: TSFNode read FFdTop;
    {  }
    property Top: TAbstractTexture2DNode read GetTop write SetTop;

    strict private FFdTextureProperties: TSFNode;
    { Internal wrapper for property @code(TextureProperties). This wrapper API may change, we advise to access simpler @code(TextureProperties) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTextureProperties: TSFNode read FFdTextureProperties;
    {  }
    property TextureProperties: TTexturePropertiesNode read GetTextureProperties write SetTextureProperties;

{$endif read_interface}

{$ifdef read_implementation}

{ TComposedCubeMapTextureNode ----------------------------------------------- }

function TComposedCubeMapTextureNode.GetBack: TAbstractTexture2DNode;
begin
  if FdBack.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdBack.Value)
  else
    Result := nil;
end;

procedure TComposedCubeMapTextureNode.SetBack(const Value: TAbstractTexture2DNode);
begin
  FdBack.Send(Value);
end;

function TComposedCubeMapTextureNode.GetBottom: TAbstractTexture2DNode;
begin
  if FdBottom.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdBottom.Value)
  else
    Result := nil;
end;

procedure TComposedCubeMapTextureNode.SetBottom(const Value: TAbstractTexture2DNode);
begin
  FdBottom.Send(Value);
end;

function TComposedCubeMapTextureNode.GetFront: TAbstractTexture2DNode;
begin
  if FdFront.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdFront.Value)
  else
    Result := nil;
end;

procedure TComposedCubeMapTextureNode.SetFront(const Value: TAbstractTexture2DNode);
begin
  FdFront.Send(Value);
end;

function TComposedCubeMapTextureNode.GetLeft: TAbstractTexture2DNode;
begin
  if FdLeft.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdLeft.Value)
  else
    Result := nil;
end;

procedure TComposedCubeMapTextureNode.SetLeft(const Value: TAbstractTexture2DNode);
begin
  FdLeft.Send(Value);
end;

function TComposedCubeMapTextureNode.GetRight: TAbstractTexture2DNode;
begin
  if FdRight.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdRight.Value)
  else
    Result := nil;
end;

procedure TComposedCubeMapTextureNode.SetRight(const Value: TAbstractTexture2DNode);
begin
  FdRight.Send(Value);
end;

function TComposedCubeMapTextureNode.GetTop: TAbstractTexture2DNode;
begin
  if FdTop.Value is TAbstractTexture2DNode then
    Result := TAbstractTexture2DNode(FdTop.Value)
  else
    Result := nil;
end;

procedure TComposedCubeMapTextureNode.SetTop(const Value: TAbstractTexture2DNode);
begin
  FdTop.Send(Value);
end;

function TComposedCubeMapTextureNode.GetTextureProperties: TTexturePropertiesNode;
begin
  if FdTextureProperties.Value is TTexturePropertiesNode then
    Result := TTexturePropertiesNode(FdTextureProperties.Value)
  else
    Result := nil;
end;

procedure TComposedCubeMapTextureNode.SetTextureProperties(const Value: TTexturePropertiesNode);
begin
  FdTextureProperties.Send(Value);
end;

class function TComposedCubeMapTextureNode.ClassX3DType: String;
begin
  Result := 'ComposedCubeMapTexture';
end;

procedure TComposedCubeMapTextureNode.CreateNode;
begin
  inherited;

  FFdBack := TSFNode.Create(Self, True, 'back', [TAbstractTexture2DNode]);
   FdBack.ChangeAlways := chTextureRendererProperties;
  AddField(FFdBack);

  FFdBottom := TSFNode.Create(Self, True, 'bottom', [TAbstractTexture2DNode]);
   FdBottom.ChangeAlways := chTextureRendererProperties;
  AddField(FFdBottom);

  FFdFront := TSFNode.Create(Self, True, 'front', [TAbstractTexture2DNode]);
   FdFront.ChangeAlways := chTextureRendererProperties;
  AddField(FFdFront);

  FFdLeft := TSFNode.Create(Self, True, 'left', [TAbstractTexture2DNode]);
   FdLeft.ChangeAlways := chTextureRendererProperties;
  AddField(FFdLeft);

  FFdRight := TSFNode.Create(Self, True, 'right', [TAbstractTexture2DNode]);
   FdRight.ChangeAlways := chTextureRendererProperties;
  AddField(FFdRight);

  FFdTop := TSFNode.Create(Self, True, 'top', [TAbstractTexture2DNode]);
   FdTop.ChangeAlways := chTextureRendererProperties;
  AddField(FFdTop);

  FFdTextureProperties := TSFNode.Create(Self, False, 'textureProperties', [TTexturePropertiesNode]);
   FdTextureProperties.ChangeAlways := chTextureRendererProperties;
  AddField(FFdTextureProperties);
end;

{$endif read_implementation}
