{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetBeginCap: Boolean;
    procedure SetBeginCap(const Value: Boolean);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
    function GetConvex: Boolean;
    procedure SetConvex(const Value: Boolean);
    function GetCreaseAngle: Single;
    procedure SetCreaseAngle(const Value: Single);
    function GetEndCap: Boolean;
    procedure SetEndCap(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventSet_crossSection: TMFVec2fEvent;
    {  }
    public property EventSet_crossSection: TMFVec2fEvent read FEventSet_crossSection;

    strict private FEventSet_orientation: TMFRotationEvent;
    {  }
    public property EventSet_orientation: TMFRotationEvent read FEventSet_orientation;

    strict private FEventSet_scale: TMFVec2fEvent;
    {  }
    public property EventSet_scale: TMFVec2fEvent read FEventSet_scale;

    strict private FEventSet_spine: TMFVec3fEvent;
    {  }
    public property EventSet_spine: TMFVec3fEvent read FEventSet_spine;

    strict private FFdBeginCap: TSFBool;
    { Internal wrapper for property @link(BeginCap). This wrapper API may change, we advise to access simpler @link(BeginCap) instead. }
    public property FdBeginCap: TSFBool read FFdBeginCap;
    {  }
    property BeginCap: Boolean read GetBeginCap write SetBeginCap;

    strict private FFdCcw: TSFBool;
    { Internal wrapper for property @link(Ccw). This wrapper API may change, we advise to access simpler @link(Ccw) instead. }
    public property FdCcw: TSFBool read FFdCcw;
    {  }
    property Ccw: Boolean read GetCcw write SetCcw;

    strict private FFdConvex: TSFBool;
    { Internal wrapper for property @link(Convex). This wrapper API may change, we advise to access simpler @link(Convex) instead. }
    public property FdConvex: TSFBool read FFdConvex;
    {  }
    property Convex: Boolean read GetConvex write SetConvex;

    strict private FFdCreaseAngle: TSFFloat;
    { Internal wrapper for property @link(CreaseAngle). This wrapper API may change, we advise to access simpler @link(CreaseAngle) instead. }
    public property FdCreaseAngle: TSFFloat read FFdCreaseAngle;
    {  }
    property CreaseAngle: Single read GetCreaseAngle write SetCreaseAngle;

    strict private FFdCrossSection: TMFVec2f;
    { Internal wrapper for property @link(CrossSection). This wrapper API may change, we advise to access simpler @link(CrossSection) instead. }
    public property FdCrossSection: TMFVec2f read FFdCrossSection;
    {  }
    procedure SetCrossSection(const Value: array of TVector2); overload;
    {  }
    procedure SetCrossSection(const Value: TVector2List); overload;

    strict private FFdEndCap: TSFBool;
    { Internal wrapper for property @link(EndCap). This wrapper API may change, we advise to access simpler @link(EndCap) instead. }
    public property FdEndCap: TSFBool read FFdEndCap;
    {  }
    property EndCap: Boolean read GetEndCap write SetEndCap;

    strict private FFdOrientation: TMFRotation;
    { Internal wrapper for property @link(Orientation). This wrapper API may change, we advise to access simpler @link(Orientation) instead. }
    public property FdOrientation: TMFRotation read FFdOrientation;
    {  }
    procedure SetOrientation(const Value: array of TVector4); overload;
    {  }
    procedure SetOrientation(const Value: TVector4List); overload;

    strict private FFdScale: TMFVec2f;
    { Internal wrapper for property @link(Scale). This wrapper API may change, we advise to access simpler @link(Scale) instead. }
    public property FdScale: TMFVec2f read FFdScale;
    {  }
    procedure SetScale(const Value: array of TVector2); overload;
    {  }
    procedure SetScale(const Value: TVector2List); overload;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @link(Solid). This wrapper API may change, we advise to access simpler @link(Solid) instead. }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdSpine: TMFVec3f;
    { Internal wrapper for property @link(Spine). This wrapper API may change, we advise to access simpler @link(Spine) instead. }
    public property FdSpine: TMFVec3f read FFdSpine;
    {  }
    procedure SetSpine(const Value: array of TVector3); overload;
    {  }
    procedure SetSpine(const Value: TVector3List); overload;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @link(TexCoord). This wrapper API may change, we advise to access simpler @link(TexCoord) instead. }
    public property FdTexCoord: TSFNode read FFdTexCoord;

{$endif read_interface}

{$ifdef read_implementation}

{ TExtrusionNode ----------------------------------------------- }

function TExtrusionNode.GetBeginCap: Boolean;
begin
  Result := FdBeginCap.Value;
end;

procedure TExtrusionNode.SetBeginCap(const Value: Boolean);
begin
  FdBeginCap.Send(Value);
end;

function TExtrusionNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TExtrusionNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

function TExtrusionNode.GetConvex: Boolean;
begin
  Result := FdConvex.Value;
end;

procedure TExtrusionNode.SetConvex(const Value: Boolean);
begin
  FdConvex.Send(Value);
end;

function TExtrusionNode.GetCreaseAngle: Single;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TExtrusionNode.SetCreaseAngle(const Value: Single);
begin
  FdCreaseAngle.Send(Value);
end;

procedure TExtrusionNode.SetCrossSection(const Value: array of TVector2);
begin
  FdCrossSection.Send(Value);
end;

procedure TExtrusionNode.SetCrossSection(const Value: TVector2List);
begin
  FdCrossSection.Send(Value);
end;

function TExtrusionNode.GetEndCap: Boolean;
begin
  Result := FdEndCap.Value;
end;

procedure TExtrusionNode.SetEndCap(const Value: Boolean);
begin
  FdEndCap.Send(Value);
end;

procedure TExtrusionNode.SetOrientation(const Value: array of TVector4);
begin
  FdOrientation.Send(Value);
end;

procedure TExtrusionNode.SetOrientation(const Value: TVector4List);
begin
  FdOrientation.Send(Value);
end;

procedure TExtrusionNode.SetScale(const Value: array of TVector2);
begin
  FdScale.Send(Value);
end;

procedure TExtrusionNode.SetScale(const Value: TVector2List);
begin
  FdScale.Send(Value);
end;

procedure TExtrusionNode.SetSpine(const Value: array of TVector3);
begin
  FdSpine.Send(Value);
end;

procedure TExtrusionNode.SetSpine(const Value: TVector3List);
begin
  FdSpine.Send(Value);
end;

class function TExtrusionNode.ClassX3DType: String;
begin
  Result := 'Extrusion';
end;

procedure TExtrusionNode.CreateNode;
begin
  inherited;

  FEventSet_crossSection := TMFVec2fEvent.Create(Self, 'set_crossSection', true);
  AddEvent(FEventSet_crossSection);

  FEventSet_orientation := TMFRotationEvent.Create(Self, 'set_orientation', true);
  AddEvent(FEventSet_orientation);

  FEventSet_scale := TMFVec2fEvent.Create(Self, 'set_scale', true);
  AddEvent(FEventSet_scale);

  FEventSet_spine := TMFVec3fEvent.Create(Self, 'set_spine', true);
  AddEvent(FEventSet_spine);

  FFdBeginCap := TSFBool.Create(Self, False, 'beginCap', true);
   FdBeginCap.ChangeAlways := chGeometry;
  AddField(FFdBeginCap);

  FFdCcw := TSFBool.Create(Self, False, 'ccw', true);
   FdCcw.ChangeAlways := chGeometry;
  AddField(FFdCcw);

  FFdConvex := TSFBool.Create(Self, False, 'convex', true);
   FdConvex.ChangeAlways := chGeometry;
  AddField(FFdConvex);

  FFdCreaseAngle := TSFFloat.Create(Self, False, 'creaseAngle', 0);
   FdCreaseAngle.ChangeAlways := chGeometry;
   FdCreaseAngle.Angle := true;
   FdCreaseAngle.MustBeNonnegative := true;
  AddField(FFdCreaseAngle);

  FFdCrossSection := TMFVec2f.Create(Self, False, 'crossSection', [ Vector2(1, 1), Vector2(1, -1), Vector2(-1, -1), Vector2(-1, 1), Vector2(1, 1) ]);
   FdCrossSection.ChangeAlways := chGeometry;
  AddField(FFdCrossSection);

  FFdEndCap := TSFBool.Create(Self, False, 'endCap', true);
   FdEndCap.ChangeAlways := chGeometry;
  AddField(FFdEndCap);

  FFdOrientation := TMFRotation.Create(Self, False, 'orientation', [ Vector4(0, 0, 1, 0) ]);
   FdOrientation.ChangeAlways := chGeometry;
  AddField(FFdOrientation);

  FFdScale := TMFVec2f.Create(Self, False, 'scale', [ Vector2(1, 1) ]);
   FdScale.ChangeAlways := chGeometry;
  AddField(FFdScale);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdSpine := TMFVec3f.Create(Self, False, 'spine', [ Vector3(0, 0, 0), Vector3(0, 1, 0) ]);
   FdSpine.ChangeAlways := chGeometry;
  AddField(FFdSpine);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TTextureCoordinateGeneratorNode, TProjectedTextureCoordinateNode, TMultiGeneratedTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chGeometry;
  AddField(FFdTexCoord);
end;

{$endif read_implementation}
