#!/bin/sh

SEP="<@@@@>"
SEPH="<@@H@@>"

compile()
{
	awk -v "SEP=$SEP" -v "SEPH=$SEPH" '
	BEGIN {
		q="\""
		SEP="^" SEP
		SEPH="^" SEPH
	}

	function strip(s) {
		sub("^[ \t]*", "", s)
		sub("[ \t]*$", "", s)
		return s
	}

	function read_tag(tag,    tmp1,tmp2) {
		getline tmp1
		getline tmp2
		if (tmp2 ~ "</" tag)
			return tmp1
		print "Error: expected closing tag " tag " in line " NR " of " current > "/dev/stderr"
		exit(1)
	}

	function notav(s) {
		if (s == "") return "n/a"
		return s
	}

	function end_act()
	{
		if (current != "")
			print "</dd></dl>"
		currrent = ""
	}

	($0 ~ SEP) {
		end_act()
		action = ""
		$1=""
		current=tolower(strip($0))
		sub("^.*/", "", current)
		sub(".html$", "", current)

		if (current in ANAME)
			aname = ANAME[current]
		else
			aname = current

		print ""
		print "<h2 id=" q current q ">" aname "</h2>"
		print "<dl><dd>"
		print "<p>"
		print "<table border=0 cellspacing=10 class=actsum>"
		print "<tr><th align=right class=actsum>Syntax summary:<td align=left class=actsum>" notav(SYNTAX[current])
		print "<tr><th align=right class=actsum>Help text:<td align=left class=actsum>"      notav(HELP[current])
		print "<tr><th align=right class=actsum>Registered&nbsp;by:<td align=left class=actsum>"  notav(COOKIE[current])
		print "</table>"
		print "<p>"
		next
	}


	($0 ~ SEPH) {
		end_act()
		action = ""
		$1=""
		print "<h1>" $0 "</h1>"
		aname=""
		next
	}

	(current == "") && (/^A/) {
		# reading the action list: new action
		action=strip($0)
		sub("^A", "", action)
		aname= action
		action = tolower(action)
# avoid saving duplicates at the main action node
		if (action in SEEN)
			action = action "_dup"
		else
			ANAME[action] = aname
		SEEN[action] = 1
		next
	}


	(current == "") && (/^D/) {
		# reading the action list: help line
		tmp = $0
		sub("^D", "", tmp)
		HELP[action]=HELP[action] "\n" tmp
		next
	}

	(current == "") && (/^S/) {
		# reading the action list: syntax line
		tmp = $0
		sub("^S", "", tmp)
		SYNTAX[action]=SYNTAX[action] "\n" tmp
		next
	}

	(current == "") && (/^C/) {
		# reading the action list: cookie line
		tmp = $0
		sub("^C", "", tmp)
		COOKIE[action]=COOKIE[action] "\n" tmp
		next
	}

	/^<arg>/ {
		arg = read_tag("arg")
		print "<i>" arg "</i>"
		next
	}

	/^<example>/ {
		ex = read_tag("example")
		print "Example:", ex, "<br>"
		next
	}

	/^<act>/ {
		act = tolower(read_tag("act"))
		print "<a href=" q "#" act q ">" act "</a>"
		next
	}

	{
		print
	}

	END {
		end_act()
	}
	'
}

echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<!-- AUTOGENERATED FILE, DO NOT EDIT ; generator is action_compiler.sh (run make) -->
<html>
<head>
	<title> camv-rnd user manual - action details </title>
	<meta http-equiv="Content-Type" content="text/html;charset=us-ascii">
	<link rel="stylesheet" type="text/css" href=" ../default.css">
</head>
<body>
<h1> camv-rnd actions (details) </h1>
'

(
	(
		cd ../../../../src
		./camv-rnd --dump-actions 2>/dev/null
	)
	for fn in "$@"
	do
		if test "$fn" = "LIBRND"
		then
			echo ""
			echo "$SEPH librnd actions (common to Ringdove)"
		else
			echo ""
			echo "$SEP $fn"
			tr "\n\r\t" "   " < $fn | sed "s@<@\n<@g;s@>@>\n@g;"
		fi
	done
) |  compile

echo '
</body>
</html>
'
