/*
* Comba Multiplication and Squaring
*
* This file was automatically generated by ./src/scripts/dev_tools/gen_mp_comba.py on 2024-06-27
*
* Botan is released under the Simplified BSD License (see license.txt)
*/

#include <botan/internal/mp_core.h>

namespace Botan {

/*
* Comba 4x4 Squaring
*/
void bigint_comba_sqr4(word z[8], const word x[4]) {
   word3<word> accum;

   accum.mul(x[0], x[0]);
   z[0] = accum.extract();
   accum.mul_x2(x[0], x[1]);
   z[1] = accum.extract();
   accum.mul_x2(x[0], x[2]);
   accum.mul(x[1], x[1]);
   z[2] = accum.extract();
   accum.mul_x2(x[0], x[3]);
   accum.mul_x2(x[1], x[2]);
   z[3] = accum.extract();
   accum.mul_x2(x[1], x[3]);
   accum.mul(x[2], x[2]);
   z[4] = accum.extract();
   accum.mul_x2(x[2], x[3]);
   z[5] = accum.extract();
   accum.mul(x[3], x[3]);
   z[6] = accum.extract();
   z[7] = accum.extract();
}

/*
* Comba 4x4 Multiplication
*/
void bigint_comba_mul4(word z[8], const word x[4], const word y[4]) {
   word3<word> accum;

   accum.mul(x[0], y[0]);
   z[0] = accum.extract();
   accum.mul(x[0], y[1]);
   accum.mul(x[1], y[0]);
   z[1] = accum.extract();
   accum.mul(x[0], y[2]);
   accum.mul(x[1], y[1]);
   accum.mul(x[2], y[0]);
   z[2] = accum.extract();
   accum.mul(x[0], y[3]);
   accum.mul(x[1], y[2]);
   accum.mul(x[2], y[1]);
   accum.mul(x[3], y[0]);
   z[3] = accum.extract();
   accum.mul(x[1], y[3]);
   accum.mul(x[2], y[2]);
   accum.mul(x[3], y[1]);
   z[4] = accum.extract();
   accum.mul(x[2], y[3]);
   accum.mul(x[3], y[2]);
   z[5] = accum.extract();
   accum.mul(x[3], y[3]);
   z[6] = accum.extract();
   z[7] = accum.extract();
}

/*
* Comba 6x6 Squaring
*/
void bigint_comba_sqr6(word z[12], const word x[6]) {
   word3<word> accum;

   accum.mul(x[0], x[0]);
   z[0] = accum.extract();
   accum.mul_x2(x[0], x[1]);
   z[1] = accum.extract();
   accum.mul_x2(x[0], x[2]);
   accum.mul(x[1], x[1]);
   z[2] = accum.extract();
   accum.mul_x2(x[0], x[3]);
   accum.mul_x2(x[1], x[2]);
   z[3] = accum.extract();
   accum.mul_x2(x[0], x[4]);
   accum.mul_x2(x[1], x[3]);
   accum.mul(x[2], x[2]);
   z[4] = accum.extract();
   accum.mul_x2(x[0], x[5]);
   accum.mul_x2(x[1], x[4]);
   accum.mul_x2(x[2], x[3]);
   z[5] = accum.extract();
   accum.mul_x2(x[1], x[5]);
   accum.mul_x2(x[2], x[4]);
   accum.mul(x[3], x[3]);
   z[6] = accum.extract();
   accum.mul_x2(x[2], x[5]);
   accum.mul_x2(x[3], x[4]);
   z[7] = accum.extract();
   accum.mul_x2(x[3], x[5]);
   accum.mul(x[4], x[4]);
   z[8] = accum.extract();
   accum.mul_x2(x[4], x[5]);
   z[9] = accum.extract();
   accum.mul(x[5], x[5]);
   z[10] = accum.extract();
   z[11] = accum.extract();
}

/*
* Comba 6x6 Multiplication
*/
void bigint_comba_mul6(word z[12], const word x[6], const word y[6]) {
   word3<word> accum;

   accum.mul(x[0], y[0]);
   z[0] = accum.extract();
   accum.mul(x[0], y[1]);
   accum.mul(x[1], y[0]);
   z[1] = accum.extract();
   accum.mul(x[0], y[2]);
   accum.mul(x[1], y[1]);
   accum.mul(x[2], y[0]);
   z[2] = accum.extract();
   accum.mul(x[0], y[3]);
   accum.mul(x[1], y[2]);
   accum.mul(x[2], y[1]);
   accum.mul(x[3], y[0]);
   z[3] = accum.extract();
   accum.mul(x[0], y[4]);
   accum.mul(x[1], y[3]);
   accum.mul(x[2], y[2]);
   accum.mul(x[3], y[1]);
   accum.mul(x[4], y[0]);
   z[4] = accum.extract();
   accum.mul(x[0], y[5]);
   accum.mul(x[1], y[4]);
   accum.mul(x[2], y[3]);
   accum.mul(x[3], y[2]);
   accum.mul(x[4], y[1]);
   accum.mul(x[5], y[0]);
   z[5] = accum.extract();
   accum.mul(x[1], y[5]);
   accum.mul(x[2], y[4]);
   accum.mul(x[3], y[3]);
   accum.mul(x[4], y[2]);
   accum.mul(x[5], y[1]);
   z[6] = accum.extract();
   accum.mul(x[2], y[5]);
   accum.mul(x[3], y[4]);
   accum.mul(x[4], y[3]);
   accum.mul(x[5], y[2]);
   z[7] = accum.extract();
   accum.mul(x[3], y[5]);
   accum.mul(x[4], y[4]);
   accum.mul(x[5], y[3]);
   z[8] = accum.extract();
   accum.mul(x[4], y[5]);
   accum.mul(x[5], y[4]);
   z[9] = accum.extract();
   accum.mul(x[5], y[5]);
   z[10] = accum.extract();
   z[11] = accum.extract();
}

/*
* Comba 7x7 Squaring
*/
void bigint_comba_sqr7(word z[14], const word x[7]) {
   word3<word> accum;

   accum.mul(x[0], x[0]);
   z[0] = accum.extract();
   accum.mul_x2(x[0], x[1]);
   z[1] = accum.extract();
   accum.mul_x2(x[0], x[2]);
   accum.mul(x[1], x[1]);
   z[2] = accum.extract();
   accum.mul_x2(x[0], x[3]);
   accum.mul_x2(x[1], x[2]);
   z[3] = accum.extract();
   accum.mul_x2(x[0], x[4]);
   accum.mul_x2(x[1], x[3]);
   accum.mul(x[2], x[2]);
   z[4] = accum.extract();
   accum.mul_x2(x[0], x[5]);
   accum.mul_x2(x[1], x[4]);
   accum.mul_x2(x[2], x[3]);
   z[5] = accum.extract();
   accum.mul_x2(x[0], x[6]);
   accum.mul_x2(x[1], x[5]);
   accum.mul_x2(x[2], x[4]);
   accum.mul(x[3], x[3]);
   z[6] = accum.extract();
   accum.mul_x2(x[1], x[6]);
   accum.mul_x2(x[2], x[5]);
   accum.mul_x2(x[3], x[4]);
   z[7] = accum.extract();
   accum.mul_x2(x[2], x[6]);
   accum.mul_x2(x[3], x[5]);
   accum.mul(x[4], x[4]);
   z[8] = accum.extract();
   accum.mul_x2(x[3], x[6]);
   accum.mul_x2(x[4], x[5]);
   z[9] = accum.extract();
   accum.mul_x2(x[4], x[6]);
   accum.mul(x[5], x[5]);
   z[10] = accum.extract();
   accum.mul_x2(x[5], x[6]);
   z[11] = accum.extract();
   accum.mul(x[6], x[6]);
   z[12] = accum.extract();
   z[13] = accum.extract();
}

/*
* Comba 7x7 Multiplication
*/
void bigint_comba_mul7(word z[14], const word x[7], const word y[7]) {
   word3<word> accum;

   accum.mul(x[0], y[0]);
   z[0] = accum.extract();
   accum.mul(x[0], y[1]);
   accum.mul(x[1], y[0]);
   z[1] = accum.extract();
   accum.mul(x[0], y[2]);
   accum.mul(x[1], y[1]);
   accum.mul(x[2], y[0]);
   z[2] = accum.extract();
   accum.mul(x[0], y[3]);
   accum.mul(x[1], y[2]);
   accum.mul(x[2], y[1]);
   accum.mul(x[3], y[0]);
   z[3] = accum.extract();
   accum.mul(x[0], y[4]);
   accum.mul(x[1], y[3]);
   accum.mul(x[2], y[2]);
   accum.mul(x[3], y[1]);
   accum.mul(x[4], y[0]);
   z[4] = accum.extract();
   accum.mul(x[0], y[5]);
   accum.mul(x[1], y[4]);
   accum.mul(x[2], y[3]);
   accum.mul(x[3], y[2]);
   accum.mul(x[4], y[1]);
   accum.mul(x[5], y[0]);
   z[5] = accum.extract();
   accum.mul(x[0], y[6]);
   accum.mul(x[1], y[5]);
   accum.mul(x[2], y[4]);
   accum.mul(x[3], y[3]);
   accum.mul(x[4], y[2]);
   accum.mul(x[5], y[1]);
   accum.mul(x[6], y[0]);
   z[6] = accum.extract();
   accum.mul(x[1], y[6]);
   accum.mul(x[2], y[5]);
   accum.mul(x[3], y[4]);
   accum.mul(x[4], y[3]);
   accum.mul(x[5], y[2]);
   accum.mul(x[6], y[1]);
   z[7] = accum.extract();
   accum.mul(x[2], y[6]);
   accum.mul(x[3], y[5]);
   accum.mul(x[4], y[4]);
   accum.mul(x[5], y[3]);
   accum.mul(x[6], y[2]);
   z[8] = accum.extract();
   accum.mul(x[3], y[6]);
   accum.mul(x[4], y[5]);
   accum.mul(x[5], y[4]);
   accum.mul(x[6], y[3]);
   z[9] = accum.extract();
   accum.mul(x[4], y[6]);
   accum.mul(x[5], y[5]);
   accum.mul(x[6], y[4]);
   z[10] = accum.extract();
   accum.mul(x[5], y[6]);
   accum.mul(x[6], y[5]);
   z[11] = accum.extract();
   accum.mul(x[6], y[6]);
   z[12] = accum.extract();
   z[13] = accum.extract();
}

/*
* Comba 8x8 Squaring
*/
void bigint_comba_sqr8(word z[16], const word x[8]) {
   word3<word> accum;

   accum.mul(x[0], x[0]);
   z[0] = accum.extract();
   accum.mul_x2(x[0], x[1]);
   z[1] = accum.extract();
   accum.mul_x2(x[0], x[2]);
   accum.mul(x[1], x[1]);
   z[2] = accum.extract();
   accum.mul_x2(x[0], x[3]);
   accum.mul_x2(x[1], x[2]);
   z[3] = accum.extract();
   accum.mul_x2(x[0], x[4]);
   accum.mul_x2(x[1], x[3]);
   accum.mul(x[2], x[2]);
   z[4] = accum.extract();
   accum.mul_x2(x[0], x[5]);
   accum.mul_x2(x[1], x[4]);
   accum.mul_x2(x[2], x[3]);
   z[5] = accum.extract();
   accum.mul_x2(x[0], x[6]);
   accum.mul_x2(x[1], x[5]);
   accum.mul_x2(x[2], x[4]);
   accum.mul(x[3], x[3]);
   z[6] = accum.extract();
   accum.mul_x2(x[0], x[7]);
   accum.mul_x2(x[1], x[6]);
   accum.mul_x2(x[2], x[5]);
   accum.mul_x2(x[3], x[4]);
   z[7] = accum.extract();
   accum.mul_x2(x[1], x[7]);
   accum.mul_x2(x[2], x[6]);
   accum.mul_x2(x[3], x[5]);
   accum.mul(x[4], x[4]);
   z[8] = accum.extract();
   accum.mul_x2(x[2], x[7]);
   accum.mul_x2(x[3], x[6]);
   accum.mul_x2(x[4], x[5]);
   z[9] = accum.extract();
   accum.mul_x2(x[3], x[7]);
   accum.mul_x2(x[4], x[6]);
   accum.mul(x[5], x[5]);
   z[10] = accum.extract();
   accum.mul_x2(x[4], x[7]);
   accum.mul_x2(x[5], x[6]);
   z[11] = accum.extract();
   accum.mul_x2(x[5], x[7]);
   accum.mul(x[6], x[6]);
   z[12] = accum.extract();
   accum.mul_x2(x[6], x[7]);
   z[13] = accum.extract();
   accum.mul(x[7], x[7]);
   z[14] = accum.extract();
   z[15] = accum.extract();
}

/*
* Comba 8x8 Multiplication
*/
void bigint_comba_mul8(word z[16], const word x[8], const word y[8]) {
   word3<word> accum;

   accum.mul(x[0], y[0]);
   z[0] = accum.extract();
   accum.mul(x[0], y[1]);
   accum.mul(x[1], y[0]);
   z[1] = accum.extract();
   accum.mul(x[0], y[2]);
   accum.mul(x[1], y[1]);
   accum.mul(x[2], y[0]);
   z[2] = accum.extract();
   accum.mul(x[0], y[3]);
   accum.mul(x[1], y[2]);
   accum.mul(x[2], y[1]);
   accum.mul(x[3], y[0]);
   z[3] = accum.extract();
   accum.mul(x[0], y[4]);
   accum.mul(x[1], y[3]);
   accum.mul(x[2], y[2]);
   accum.mul(x[3], y[1]);
   accum.mul(x[4], y[0]);
   z[4] = accum.extract();
   accum.mul(x[0], y[5]);
   accum.mul(x[1], y[4]);
   accum.mul(x[2], y[3]);
   accum.mul(x[3], y[2]);
   accum.mul(x[4], y[1]);
   accum.mul(x[5], y[0]);
   z[5] = accum.extract();
   accum.mul(x[0], y[6]);
   accum.mul(x[1], y[5]);
   accum.mul(x[2], y[4]);
   accum.mul(x[3], y[3]);
   accum.mul(x[4], y[2]);
   accum.mul(x[5], y[1]);
   accum.mul(x[6], y[0]);
   z[6] = accum.extract();
   accum.mul(x[0], y[7]);
   accum.mul(x[1], y[6]);
   accum.mul(x[2], y[5]);
   accum.mul(x[3], y[4]);
   accum.mul(x[4], y[3]);
   accum.mul(x[5], y[2]);
   accum.mul(x[6], y[1]);
   accum.mul(x[7], y[0]);
   z[7] = accum.extract();
   accum.mul(x[1], y[7]);
   accum.mul(x[2], y[6]);
   accum.mul(x[3], y[5]);
   accum.mul(x[4], y[4]);
   accum.mul(x[5], y[3]);
   accum.mul(x[6], y[2]);
   accum.mul(x[7], y[1]);
   z[8] = accum.extract();
   accum.mul(x[2], y[7]);
   accum.mul(x[3], y[6]);
   accum.mul(x[4], y[5]);
   accum.mul(x[5], y[4]);
   accum.mul(x[6], y[3]);
   accum.mul(x[7], y[2]);
   z[9] = accum.extract();
   accum.mul(x[3], y[7]);
   accum.mul(x[4], y[6]);
   accum.mul(x[5], y[5]);
   accum.mul(x[6], y[4]);
   accum.mul(x[7], y[3]);
   z[10] = accum.extract();
   accum.mul(x[4], y[7]);
   accum.mul(x[5], y[6]);
   accum.mul(x[6], y[5]);
   accum.mul(x[7], y[4]);
   z[11] = accum.extract();
   accum.mul(x[5], y[7]);
   accum.mul(x[6], y[6]);
   accum.mul(x[7], y[5]);
   z[12] = accum.extract();
   accum.mul(x[6], y[7]);
   accum.mul(x[7], y[6]);
   z[13] = accum.extract();
   accum.mul(x[7], y[7]);
   z[14] = accum.extract();
   z[15] = accum.extract();
}

/*
* Comba 9x9 Squaring
*/
void bigint_comba_sqr9(word z[18], const word x[9]) {
   word3<word> accum;

   accum.mul(x[0], x[0]);
   z[0] = accum.extract();
   accum.mul_x2(x[0], x[1]);
   z[1] = accum.extract();
   accum.mul_x2(x[0], x[2]);
   accum.mul(x[1], x[1]);
   z[2] = accum.extract();
   accum.mul_x2(x[0], x[3]);
   accum.mul_x2(x[1], x[2]);
   z[3] = accum.extract();
   accum.mul_x2(x[0], x[4]);
   accum.mul_x2(x[1], x[3]);
   accum.mul(x[2], x[2]);
   z[4] = accum.extract();
   accum.mul_x2(x[0], x[5]);
   accum.mul_x2(x[1], x[4]);
   accum.mul_x2(x[2], x[3]);
   z[5] = accum.extract();
   accum.mul_x2(x[0], x[6]);
   accum.mul_x2(x[1], x[5]);
   accum.mul_x2(x[2], x[4]);
   accum.mul(x[3], x[3]);
   z[6] = accum.extract();
   accum.mul_x2(x[0], x[7]);
   accum.mul_x2(x[1], x[6]);
   accum.mul_x2(x[2], x[5]);
   accum.mul_x2(x[3], x[4]);
   z[7] = accum.extract();
   accum.mul_x2(x[0], x[8]);
   accum.mul_x2(x[1], x[7]);
   accum.mul_x2(x[2], x[6]);
   accum.mul_x2(x[3], x[5]);
   accum.mul(x[4], x[4]);
   z[8] = accum.extract();
   accum.mul_x2(x[1], x[8]);
   accum.mul_x2(x[2], x[7]);
   accum.mul_x2(x[3], x[6]);
   accum.mul_x2(x[4], x[5]);
   z[9] = accum.extract();
   accum.mul_x2(x[2], x[8]);
   accum.mul_x2(x[3], x[7]);
   accum.mul_x2(x[4], x[6]);
   accum.mul(x[5], x[5]);
   z[10] = accum.extract();
   accum.mul_x2(x[3], x[8]);
   accum.mul_x2(x[4], x[7]);
   accum.mul_x2(x[5], x[6]);
   z[11] = accum.extract();
   accum.mul_x2(x[4], x[8]);
   accum.mul_x2(x[5], x[7]);
   accum.mul(x[6], x[6]);
   z[12] = accum.extract();
   accum.mul_x2(x[5], x[8]);
   accum.mul_x2(x[6], x[7]);
   z[13] = accum.extract();
   accum.mul_x2(x[6], x[8]);
   accum.mul(x[7], x[7]);
   z[14] = accum.extract();
   accum.mul_x2(x[7], x[8]);
   z[15] = accum.extract();
   accum.mul(x[8], x[8]);
   z[16] = accum.extract();
   z[17] = accum.extract();
}

/*
* Comba 9x9 Multiplication
*/
void bigint_comba_mul9(word z[18], const word x[9], const word y[9]) {
   word3<word> accum;

   accum.mul(x[0], y[0]);
   z[0] = accum.extract();
   accum.mul(x[0], y[1]);
   accum.mul(x[1], y[0]);
   z[1] = accum.extract();
   accum.mul(x[0], y[2]);
   accum.mul(x[1], y[1]);
   accum.mul(x[2], y[0]);
   z[2] = accum.extract();
   accum.mul(x[0], y[3]);
   accum.mul(x[1], y[2]);
   accum.mul(x[2], y[1]);
   accum.mul(x[3], y[0]);
   z[3] = accum.extract();
   accum.mul(x[0], y[4]);
   accum.mul(x[1], y[3]);
   accum.mul(x[2], y[2]);
   accum.mul(x[3], y[1]);
   accum.mul(x[4], y[0]);
   z[4] = accum.extract();
   accum.mul(x[0], y[5]);
   accum.mul(x[1], y[4]);
   accum.mul(x[2], y[3]);
   accum.mul(x[3], y[2]);
   accum.mul(x[4], y[1]);
   accum.mul(x[5], y[0]);
   z[5] = accum.extract();
   accum.mul(x[0], y[6]);
   accum.mul(x[1], y[5]);
   accum.mul(x[2], y[4]);
   accum.mul(x[3], y[3]);
   accum.mul(x[4], y[2]);
   accum.mul(x[5], y[1]);
   accum.mul(x[6], y[0]);
   z[6] = accum.extract();
   accum.mul(x[0], y[7]);
   accum.mul(x[1], y[6]);
   accum.mul(x[2], y[5]);
   accum.mul(x[3], y[4]);
   accum.mul(x[4], y[3]);
   accum.mul(x[5], y[2]);
   accum.mul(x[6], y[1]);
   accum.mul(x[7], y[0]);
   z[7] = accum.extract();
   accum.mul(x[0], y[8]);
   accum.mul(x[1], y[7]);
   accum.mul(x[2], y[6]);
   accum.mul(x[3], y[5]);
   accum.mul(x[4], y[4]);
   accum.mul(x[5], y[3]);
   accum.mul(x[6], y[2]);
   accum.mul(x[7], y[1]);
   accum.mul(x[8], y[0]);
   z[8] = accum.extract();
   accum.mul(x[1], y[8]);
   accum.mul(x[2], y[7]);
   accum.mul(x[3], y[6]);
   accum.mul(x[4], y[5]);
   accum.mul(x[5], y[4]);
   accum.mul(x[6], y[3]);
   accum.mul(x[7], y[2]);
   accum.mul(x[8], y[1]);
   z[9] = accum.extract();
   accum.mul(x[2], y[8]);
   accum.mul(x[3], y[7]);
   accum.mul(x[4], y[6]);
   accum.mul(x[5], y[5]);
   accum.mul(x[6], y[4]);
   accum.mul(x[7], y[3]);
   accum.mul(x[8], y[2]);
   z[10] = accum.extract();
   accum.mul(x[3], y[8]);
   accum.mul(x[4], y[7]);
   accum.mul(x[5], y[6]);
   accum.mul(x[6], y[5]);
   accum.mul(x[7], y[4]);
   accum.mul(x[8], y[3]);
   z[11] = accum.extract();
   accum.mul(x[4], y[8]);
   accum.mul(x[5], y[7]);
   accum.mul(x[6], y[6]);
   accum.mul(x[7], y[5]);
   accum.mul(x[8], y[4]);
   z[12] = accum.extract();
   accum.mul(x[5], y[8]);
   accum.mul(x[6], y[7]);
   accum.mul(x[7], y[6]);
   accum.mul(x[8], y[5]);
   z[13] = accum.extract();
   accum.mul(x[6], y[8]);
   accum.mul(x[7], y[7]);
   accum.mul(x[8], y[6]);
   z[14] = accum.extract();
   accum.mul(x[7], y[8]);
   accum.mul(x[8], y[7]);
   z[15] = accum.extract();
   accum.mul(x[8], y[8]);
   z[16] = accum.extract();
   z[17] = accum.extract();
}

/*
* Comba 16x16 Squaring
*/
void bigint_comba_sqr16(word z[32], const word x[16]) {
   word3<word> accum;

   accum.mul(x[0], x[0]);
   z[0] = accum.extract();
   accum.mul_x2(x[0], x[1]);
   z[1] = accum.extract();
   accum.mul_x2(x[0], x[2]);
   accum.mul(x[1], x[1]);
   z[2] = accum.extract();
   accum.mul_x2(x[0], x[3]);
   accum.mul_x2(x[1], x[2]);
   z[3] = accum.extract();
   accum.mul_x2(x[0], x[4]);
   accum.mul_x2(x[1], x[3]);
   accum.mul(x[2], x[2]);
   z[4] = accum.extract();
   accum.mul_x2(x[0], x[5]);
   accum.mul_x2(x[1], x[4]);
   accum.mul_x2(x[2], x[3]);
   z[5] = accum.extract();
   accum.mul_x2(x[0], x[6]);
   accum.mul_x2(x[1], x[5]);
   accum.mul_x2(x[2], x[4]);
   accum.mul(x[3], x[3]);
   z[6] = accum.extract();
   accum.mul_x2(x[0], x[7]);
   accum.mul_x2(x[1], x[6]);
   accum.mul_x2(x[2], x[5]);
   accum.mul_x2(x[3], x[4]);
   z[7] = accum.extract();
   accum.mul_x2(x[0], x[8]);
   accum.mul_x2(x[1], x[7]);
   accum.mul_x2(x[2], x[6]);
   accum.mul_x2(x[3], x[5]);
   accum.mul(x[4], x[4]);
   z[8] = accum.extract();
   accum.mul_x2(x[0], x[9]);
   accum.mul_x2(x[1], x[8]);
   accum.mul_x2(x[2], x[7]);
   accum.mul_x2(x[3], x[6]);
   accum.mul_x2(x[4], x[5]);
   z[9] = accum.extract();
   accum.mul_x2(x[0], x[10]);
   accum.mul_x2(x[1], x[9]);
   accum.mul_x2(x[2], x[8]);
   accum.mul_x2(x[3], x[7]);
   accum.mul_x2(x[4], x[6]);
   accum.mul(x[5], x[5]);
   z[10] = accum.extract();
   accum.mul_x2(x[0], x[11]);
   accum.mul_x2(x[1], x[10]);
   accum.mul_x2(x[2], x[9]);
   accum.mul_x2(x[3], x[8]);
   accum.mul_x2(x[4], x[7]);
   accum.mul_x2(x[5], x[6]);
   z[11] = accum.extract();
   accum.mul_x2(x[0], x[12]);
   accum.mul_x2(x[1], x[11]);
   accum.mul_x2(x[2], x[10]);
   accum.mul_x2(x[3], x[9]);
   accum.mul_x2(x[4], x[8]);
   accum.mul_x2(x[5], x[7]);
   accum.mul(x[6], x[6]);
   z[12] = accum.extract();
   accum.mul_x2(x[0], x[13]);
   accum.mul_x2(x[1], x[12]);
   accum.mul_x2(x[2], x[11]);
   accum.mul_x2(x[3], x[10]);
   accum.mul_x2(x[4], x[9]);
   accum.mul_x2(x[5], x[8]);
   accum.mul_x2(x[6], x[7]);
   z[13] = accum.extract();
   accum.mul_x2(x[0], x[14]);
   accum.mul_x2(x[1], x[13]);
   accum.mul_x2(x[2], x[12]);
   accum.mul_x2(x[3], x[11]);
   accum.mul_x2(x[4], x[10]);
   accum.mul_x2(x[5], x[9]);
   accum.mul_x2(x[6], x[8]);
   accum.mul(x[7], x[7]);
   z[14] = accum.extract();
   accum.mul_x2(x[0], x[15]);
   accum.mul_x2(x[1], x[14]);
   accum.mul_x2(x[2], x[13]);
   accum.mul_x2(x[3], x[12]);
   accum.mul_x2(x[4], x[11]);
   accum.mul_x2(x[5], x[10]);
   accum.mul_x2(x[6], x[9]);
   accum.mul_x2(x[7], x[8]);
   z[15] = accum.extract();
   accum.mul_x2(x[1], x[15]);
   accum.mul_x2(x[2], x[14]);
   accum.mul_x2(x[3], x[13]);
   accum.mul_x2(x[4], x[12]);
   accum.mul_x2(x[5], x[11]);
   accum.mul_x2(x[6], x[10]);
   accum.mul_x2(x[7], x[9]);
   accum.mul(x[8], x[8]);
   z[16] = accum.extract();
   accum.mul_x2(x[2], x[15]);
   accum.mul_x2(x[3], x[14]);
   accum.mul_x2(x[4], x[13]);
   accum.mul_x2(x[5], x[12]);
   accum.mul_x2(x[6], x[11]);
   accum.mul_x2(x[7], x[10]);
   accum.mul_x2(x[8], x[9]);
   z[17] = accum.extract();
   accum.mul_x2(x[3], x[15]);
   accum.mul_x2(x[4], x[14]);
   accum.mul_x2(x[5], x[13]);
   accum.mul_x2(x[6], x[12]);
   accum.mul_x2(x[7], x[11]);
   accum.mul_x2(x[8], x[10]);
   accum.mul(x[9], x[9]);
   z[18] = accum.extract();
   accum.mul_x2(x[4], x[15]);
   accum.mul_x2(x[5], x[14]);
   accum.mul_x2(x[6], x[13]);
   accum.mul_x2(x[7], x[12]);
   accum.mul_x2(x[8], x[11]);
   accum.mul_x2(x[9], x[10]);
   z[19] = accum.extract();
   accum.mul_x2(x[5], x[15]);
   accum.mul_x2(x[6], x[14]);
   accum.mul_x2(x[7], x[13]);
   accum.mul_x2(x[8], x[12]);
   accum.mul_x2(x[9], x[11]);
   accum.mul(x[10], x[10]);
   z[20] = accum.extract();
   accum.mul_x2(x[6], x[15]);
   accum.mul_x2(x[7], x[14]);
   accum.mul_x2(x[8], x[13]);
   accum.mul_x2(x[9], x[12]);
   accum.mul_x2(x[10], x[11]);
   z[21] = accum.extract();
   accum.mul_x2(x[7], x[15]);
   accum.mul_x2(x[8], x[14]);
   accum.mul_x2(x[9], x[13]);
   accum.mul_x2(x[10], x[12]);
   accum.mul(x[11], x[11]);
   z[22] = accum.extract();
   accum.mul_x2(x[8], x[15]);
   accum.mul_x2(x[9], x[14]);
   accum.mul_x2(x[10], x[13]);
   accum.mul_x2(x[11], x[12]);
   z[23] = accum.extract();
   accum.mul_x2(x[9], x[15]);
   accum.mul_x2(x[10], x[14]);
   accum.mul_x2(x[11], x[13]);
   accum.mul(x[12], x[12]);
   z[24] = accum.extract();
   accum.mul_x2(x[10], x[15]);
   accum.mul_x2(x[11], x[14]);
   accum.mul_x2(x[12], x[13]);
   z[25] = accum.extract();
   accum.mul_x2(x[11], x[15]);
   accum.mul_x2(x[12], x[14]);
   accum.mul(x[13], x[13]);
   z[26] = accum.extract();
   accum.mul_x2(x[12], x[15]);
   accum.mul_x2(x[13], x[14]);
   z[27] = accum.extract();
   accum.mul_x2(x[13], x[15]);
   accum.mul(x[14], x[14]);
   z[28] = accum.extract();
   accum.mul_x2(x[14], x[15]);
   z[29] = accum.extract();
   accum.mul(x[15], x[15]);
   z[30] = accum.extract();
   z[31] = accum.extract();
}

/*
* Comba 16x16 Multiplication
*/
void bigint_comba_mul16(word z[32], const word x[16], const word y[16]) {
   word3<word> accum;

   accum.mul(x[0], y[0]);
   z[0] = accum.extract();
   accum.mul(x[0], y[1]);
   accum.mul(x[1], y[0]);
   z[1] = accum.extract();
   accum.mul(x[0], y[2]);
   accum.mul(x[1], y[1]);
   accum.mul(x[2], y[0]);
   z[2] = accum.extract();
   accum.mul(x[0], y[3]);
   accum.mul(x[1], y[2]);
   accum.mul(x[2], y[1]);
   accum.mul(x[3], y[0]);
   z[3] = accum.extract();
   accum.mul(x[0], y[4]);
   accum.mul(x[1], y[3]);
   accum.mul(x[2], y[2]);
   accum.mul(x[3], y[1]);
   accum.mul(x[4], y[0]);
   z[4] = accum.extract();
   accum.mul(x[0], y[5]);
   accum.mul(x[1], y[4]);
   accum.mul(x[2], y[3]);
   accum.mul(x[3], y[2]);
   accum.mul(x[4], y[1]);
   accum.mul(x[5], y[0]);
   z[5] = accum.extract();
   accum.mul(x[0], y[6]);
   accum.mul(x[1], y[5]);
   accum.mul(x[2], y[4]);
   accum.mul(x[3], y[3]);
   accum.mul(x[4], y[2]);
   accum.mul(x[5], y[1]);
   accum.mul(x[6], y[0]);
   z[6] = accum.extract();
   accum.mul(x[0], y[7]);
   accum.mul(x[1], y[6]);
   accum.mul(x[2], y[5]);
   accum.mul(x[3], y[4]);
   accum.mul(x[4], y[3]);
   accum.mul(x[5], y[2]);
   accum.mul(x[6], y[1]);
   accum.mul(x[7], y[0]);
   z[7] = accum.extract();
   accum.mul(x[0], y[8]);
   accum.mul(x[1], y[7]);
   accum.mul(x[2], y[6]);
   accum.mul(x[3], y[5]);
   accum.mul(x[4], y[4]);
   accum.mul(x[5], y[3]);
   accum.mul(x[6], y[2]);
   accum.mul(x[7], y[1]);
   accum.mul(x[8], y[0]);
   z[8] = accum.extract();
   accum.mul(x[0], y[9]);
   accum.mul(x[1], y[8]);
   accum.mul(x[2], y[7]);
   accum.mul(x[3], y[6]);
   accum.mul(x[4], y[5]);
   accum.mul(x[5], y[4]);
   accum.mul(x[6], y[3]);
   accum.mul(x[7], y[2]);
   accum.mul(x[8], y[1]);
   accum.mul(x[9], y[0]);
   z[9] = accum.extract();
   accum.mul(x[0], y[10]);
   accum.mul(x[1], y[9]);
   accum.mul(x[2], y[8]);
   accum.mul(x[3], y[7]);
   accum.mul(x[4], y[6]);
   accum.mul(x[5], y[5]);
   accum.mul(x[6], y[4]);
   accum.mul(x[7], y[3]);
   accum.mul(x[8], y[2]);
   accum.mul(x[9], y[1]);
   accum.mul(x[10], y[0]);
   z[10] = accum.extract();
   accum.mul(x[0], y[11]);
   accum.mul(x[1], y[10]);
   accum.mul(x[2], y[9]);
   accum.mul(x[3], y[8]);
   accum.mul(x[4], y[7]);
   accum.mul(x[5], y[6]);
   accum.mul(x[6], y[5]);
   accum.mul(x[7], y[4]);
   accum.mul(x[8], y[3]);
   accum.mul(x[9], y[2]);
   accum.mul(x[10], y[1]);
   accum.mul(x[11], y[0]);
   z[11] = accum.extract();
   accum.mul(x[0], y[12]);
   accum.mul(x[1], y[11]);
   accum.mul(x[2], y[10]);
   accum.mul(x[3], y[9]);
   accum.mul(x[4], y[8]);
   accum.mul(x[5], y[7]);
   accum.mul(x[6], y[6]);
   accum.mul(x[7], y[5]);
   accum.mul(x[8], y[4]);
   accum.mul(x[9], y[3]);
   accum.mul(x[10], y[2]);
   accum.mul(x[11], y[1]);
   accum.mul(x[12], y[0]);
   z[12] = accum.extract();
   accum.mul(x[0], y[13]);
   accum.mul(x[1], y[12]);
   accum.mul(x[2], y[11]);
   accum.mul(x[3], y[10]);
   accum.mul(x[4], y[9]);
   accum.mul(x[5], y[8]);
   accum.mul(x[6], y[7]);
   accum.mul(x[7], y[6]);
   accum.mul(x[8], y[5]);
   accum.mul(x[9], y[4]);
   accum.mul(x[10], y[3]);
   accum.mul(x[11], y[2]);
   accum.mul(x[12], y[1]);
   accum.mul(x[13], y[0]);
   z[13] = accum.extract();
   accum.mul(x[0], y[14]);
   accum.mul(x[1], y[13]);
   accum.mul(x[2], y[12]);
   accum.mul(x[3], y[11]);
   accum.mul(x[4], y[10]);
   accum.mul(x[5], y[9]);
   accum.mul(x[6], y[8]);
   accum.mul(x[7], y[7]);
   accum.mul(x[8], y[6]);
   accum.mul(x[9], y[5]);
   accum.mul(x[10], y[4]);
   accum.mul(x[11], y[3]);
   accum.mul(x[12], y[2]);
   accum.mul(x[13], y[1]);
   accum.mul(x[14], y[0]);
   z[14] = accum.extract();
   accum.mul(x[0], y[15]);
   accum.mul(x[1], y[14]);
   accum.mul(x[2], y[13]);
   accum.mul(x[3], y[12]);
   accum.mul(x[4], y[11]);
   accum.mul(x[5], y[10]);
   accum.mul(x[6], y[9]);
   accum.mul(x[7], y[8]);
   accum.mul(x[8], y[7]);
   accum.mul(x[9], y[6]);
   accum.mul(x[10], y[5]);
   accum.mul(x[11], y[4]);
   accum.mul(x[12], y[3]);
   accum.mul(x[13], y[2]);
   accum.mul(x[14], y[1]);
   accum.mul(x[15], y[0]);
   z[15] = accum.extract();
   accum.mul(x[1], y[15]);
   accum.mul(x[2], y[14]);
   accum.mul(x[3], y[13]);
   accum.mul(x[4], y[12]);
   accum.mul(x[5], y[11]);
   accum.mul(x[6], y[10]);
   accum.mul(x[7], y[9]);
   accum.mul(x[8], y[8]);
   accum.mul(x[9], y[7]);
   accum.mul(x[10], y[6]);
   accum.mul(x[11], y[5]);
   accum.mul(x[12], y[4]);
   accum.mul(x[13], y[3]);
   accum.mul(x[14], y[2]);
   accum.mul(x[15], y[1]);
   z[16] = accum.extract();
   accum.mul(x[2], y[15]);
   accum.mul(x[3], y[14]);
   accum.mul(x[4], y[13]);
   accum.mul(x[5], y[12]);
   accum.mul(x[6], y[11]);
   accum.mul(x[7], y[10]);
   accum.mul(x[8], y[9]);
   accum.mul(x[9], y[8]);
   accum.mul(x[10], y[7]);
   accum.mul(x[11], y[6]);
   accum.mul(x[12], y[5]);
   accum.mul(x[13], y[4]);
   accum.mul(x[14], y[3]);
   accum.mul(x[15], y[2]);
   z[17] = accum.extract();
   accum.mul(x[3], y[15]);
   accum.mul(x[4], y[14]);
   accum.mul(x[5], y[13]);
   accum.mul(x[6], y[12]);
   accum.mul(x[7], y[11]);
   accum.mul(x[8], y[10]);
   accum.mul(x[9], y[9]);
   accum.mul(x[10], y[8]);
   accum.mul(x[11], y[7]);
   accum.mul(x[12], y[6]);
   accum.mul(x[13], y[5]);
   accum.mul(x[14], y[4]);
   accum.mul(x[15], y[3]);
   z[18] = accum.extract();
   accum.mul(x[4], y[15]);
   accum.mul(x[5], y[14]);
   accum.mul(x[6], y[13]);
   accum.mul(x[7], y[12]);
   accum.mul(x[8], y[11]);
   accum.mul(x[9], y[10]);
   accum.mul(x[10], y[9]);
   accum.mul(x[11], y[8]);
   accum.mul(x[12], y[7]);
   accum.mul(x[13], y[6]);
   accum.mul(x[14], y[5]);
   accum.mul(x[15], y[4]);
   z[19] = accum.extract();
   accum.mul(x[5], y[15]);
   accum.mul(x[6], y[14]);
   accum.mul(x[7], y[13]);
   accum.mul(x[8], y[12]);
   accum.mul(x[9], y[11]);
   accum.mul(x[10], y[10]);
   accum.mul(x[11], y[9]);
   accum.mul(x[12], y[8]);
   accum.mul(x[13], y[7]);
   accum.mul(x[14], y[6]);
   accum.mul(x[15], y[5]);
   z[20] = accum.extract();
   accum.mul(x[6], y[15]);
   accum.mul(x[7], y[14]);
   accum.mul(x[8], y[13]);
   accum.mul(x[9], y[12]);
   accum.mul(x[10], y[11]);
   accum.mul(x[11], y[10]);
   accum.mul(x[12], y[9]);
   accum.mul(x[13], y[8]);
   accum.mul(x[14], y[7]);
   accum.mul(x[15], y[6]);
   z[21] = accum.extract();
   accum.mul(x[7], y[15]);
   accum.mul(x[8], y[14]);
   accum.mul(x[9], y[13]);
   accum.mul(x[10], y[12]);
   accum.mul(x[11], y[11]);
   accum.mul(x[12], y[10]);
   accum.mul(x[13], y[9]);
   accum.mul(x[14], y[8]);
   accum.mul(x[15], y[7]);
   z[22] = accum.extract();
   accum.mul(x[8], y[15]);
   accum.mul(x[9], y[14]);
   accum.mul(x[10], y[13]);
   accum.mul(x[11], y[12]);
   accum.mul(x[12], y[11]);
   accum.mul(x[13], y[10]);
   accum.mul(x[14], y[9]);
   accum.mul(x[15], y[8]);
   z[23] = accum.extract();
   accum.mul(x[9], y[15]);
   accum.mul(x[10], y[14]);
   accum.mul(x[11], y[13]);
   accum.mul(x[12], y[12]);
   accum.mul(x[13], y[11]);
   accum.mul(x[14], y[10]);
   accum.mul(x[15], y[9]);
   z[24] = accum.extract();
   accum.mul(x[10], y[15]);
   accum.mul(x[11], y[14]);
   accum.mul(x[12], y[13]);
   accum.mul(x[13], y[12]);
   accum.mul(x[14], y[11]);
   accum.mul(x[15], y[10]);
   z[25] = accum.extract();
   accum.mul(x[11], y[15]);
   accum.mul(x[12], y[14]);
   accum.mul(x[13], y[13]);
   accum.mul(x[14], y[12]);
   accum.mul(x[15], y[11]);
   z[26] = accum.extract();
   accum.mul(x[12], y[15]);
   accum.mul(x[13], y[14]);
   accum.mul(x[14], y[13]);
   accum.mul(x[15], y[12]);
   z[27] = accum.extract();
   accum.mul(x[13], y[15]);
   accum.mul(x[14], y[14]);
   accum.mul(x[15], y[13]);
   z[28] = accum.extract();
   accum.mul(x[14], y[15]);
   accum.mul(x[15], y[14]);
   z[29] = accum.extract();
   accum.mul(x[15], y[15]);
   z[30] = accum.extract();
   z[31] = accum.extract();
}

/*
* Comba 24x24 Squaring
*/
void bigint_comba_sqr24(word z[48], const word x[24]) {
   word3<word> accum;

   accum.mul(x[0], x[0]);
   z[0] = accum.extract();
   accum.mul_x2(x[0], x[1]);
   z[1] = accum.extract();
   accum.mul_x2(x[0], x[2]);
   accum.mul(x[1], x[1]);
   z[2] = accum.extract();
   accum.mul_x2(x[0], x[3]);
   accum.mul_x2(x[1], x[2]);
   z[3] = accum.extract();
   accum.mul_x2(x[0], x[4]);
   accum.mul_x2(x[1], x[3]);
   accum.mul(x[2], x[2]);
   z[4] = accum.extract();
   accum.mul_x2(x[0], x[5]);
   accum.mul_x2(x[1], x[4]);
   accum.mul_x2(x[2], x[3]);
   z[5] = accum.extract();
   accum.mul_x2(x[0], x[6]);
   accum.mul_x2(x[1], x[5]);
   accum.mul_x2(x[2], x[4]);
   accum.mul(x[3], x[3]);
   z[6] = accum.extract();
   accum.mul_x2(x[0], x[7]);
   accum.mul_x2(x[1], x[6]);
   accum.mul_x2(x[2], x[5]);
   accum.mul_x2(x[3], x[4]);
   z[7] = accum.extract();
   accum.mul_x2(x[0], x[8]);
   accum.mul_x2(x[1], x[7]);
   accum.mul_x2(x[2], x[6]);
   accum.mul_x2(x[3], x[5]);
   accum.mul(x[4], x[4]);
   z[8] = accum.extract();
   accum.mul_x2(x[0], x[9]);
   accum.mul_x2(x[1], x[8]);
   accum.mul_x2(x[2], x[7]);
   accum.mul_x2(x[3], x[6]);
   accum.mul_x2(x[4], x[5]);
   z[9] = accum.extract();
   accum.mul_x2(x[0], x[10]);
   accum.mul_x2(x[1], x[9]);
   accum.mul_x2(x[2], x[8]);
   accum.mul_x2(x[3], x[7]);
   accum.mul_x2(x[4], x[6]);
   accum.mul(x[5], x[5]);
   z[10] = accum.extract();
   accum.mul_x2(x[0], x[11]);
   accum.mul_x2(x[1], x[10]);
   accum.mul_x2(x[2], x[9]);
   accum.mul_x2(x[3], x[8]);
   accum.mul_x2(x[4], x[7]);
   accum.mul_x2(x[5], x[6]);
   z[11] = accum.extract();
   accum.mul_x2(x[0], x[12]);
   accum.mul_x2(x[1], x[11]);
   accum.mul_x2(x[2], x[10]);
   accum.mul_x2(x[3], x[9]);
   accum.mul_x2(x[4], x[8]);
   accum.mul_x2(x[5], x[7]);
   accum.mul(x[6], x[6]);
   z[12] = accum.extract();
   accum.mul_x2(x[0], x[13]);
   accum.mul_x2(x[1], x[12]);
   accum.mul_x2(x[2], x[11]);
   accum.mul_x2(x[3], x[10]);
   accum.mul_x2(x[4], x[9]);
   accum.mul_x2(x[5], x[8]);
   accum.mul_x2(x[6], x[7]);
   z[13] = accum.extract();
   accum.mul_x2(x[0], x[14]);
   accum.mul_x2(x[1], x[13]);
   accum.mul_x2(x[2], x[12]);
   accum.mul_x2(x[3], x[11]);
   accum.mul_x2(x[4], x[10]);
   accum.mul_x2(x[5], x[9]);
   accum.mul_x2(x[6], x[8]);
   accum.mul(x[7], x[7]);
   z[14] = accum.extract();
   accum.mul_x2(x[0], x[15]);
   accum.mul_x2(x[1], x[14]);
   accum.mul_x2(x[2], x[13]);
   accum.mul_x2(x[3], x[12]);
   accum.mul_x2(x[4], x[11]);
   accum.mul_x2(x[5], x[10]);
   accum.mul_x2(x[6], x[9]);
   accum.mul_x2(x[7], x[8]);
   z[15] = accum.extract();
   accum.mul_x2(x[0], x[16]);
   accum.mul_x2(x[1], x[15]);
   accum.mul_x2(x[2], x[14]);
   accum.mul_x2(x[3], x[13]);
   accum.mul_x2(x[4], x[12]);
   accum.mul_x2(x[5], x[11]);
   accum.mul_x2(x[6], x[10]);
   accum.mul_x2(x[7], x[9]);
   accum.mul(x[8], x[8]);
   z[16] = accum.extract();
   accum.mul_x2(x[0], x[17]);
   accum.mul_x2(x[1], x[16]);
   accum.mul_x2(x[2], x[15]);
   accum.mul_x2(x[3], x[14]);
   accum.mul_x2(x[4], x[13]);
   accum.mul_x2(x[5], x[12]);
   accum.mul_x2(x[6], x[11]);
   accum.mul_x2(x[7], x[10]);
   accum.mul_x2(x[8], x[9]);
   z[17] = accum.extract();
   accum.mul_x2(x[0], x[18]);
   accum.mul_x2(x[1], x[17]);
   accum.mul_x2(x[2], x[16]);
   accum.mul_x2(x[3], x[15]);
   accum.mul_x2(x[4], x[14]);
   accum.mul_x2(x[5], x[13]);
   accum.mul_x2(x[6], x[12]);
   accum.mul_x2(x[7], x[11]);
   accum.mul_x2(x[8], x[10]);
   accum.mul(x[9], x[9]);
   z[18] = accum.extract();
   accum.mul_x2(x[0], x[19]);
   accum.mul_x2(x[1], x[18]);
   accum.mul_x2(x[2], x[17]);
   accum.mul_x2(x[3], x[16]);
   accum.mul_x2(x[4], x[15]);
   accum.mul_x2(x[5], x[14]);
   accum.mul_x2(x[6], x[13]);
   accum.mul_x2(x[7], x[12]);
   accum.mul_x2(x[8], x[11]);
   accum.mul_x2(x[9], x[10]);
   z[19] = accum.extract();
   accum.mul_x2(x[0], x[20]);
   accum.mul_x2(x[1], x[19]);
   accum.mul_x2(x[2], x[18]);
   accum.mul_x2(x[3], x[17]);
   accum.mul_x2(x[4], x[16]);
   accum.mul_x2(x[5], x[15]);
   accum.mul_x2(x[6], x[14]);
   accum.mul_x2(x[7], x[13]);
   accum.mul_x2(x[8], x[12]);
   accum.mul_x2(x[9], x[11]);
   accum.mul(x[10], x[10]);
   z[20] = accum.extract();
   accum.mul_x2(x[0], x[21]);
   accum.mul_x2(x[1], x[20]);
   accum.mul_x2(x[2], x[19]);
   accum.mul_x2(x[3], x[18]);
   accum.mul_x2(x[4], x[17]);
   accum.mul_x2(x[5], x[16]);
   accum.mul_x2(x[6], x[15]);
   accum.mul_x2(x[7], x[14]);
   accum.mul_x2(x[8], x[13]);
   accum.mul_x2(x[9], x[12]);
   accum.mul_x2(x[10], x[11]);
   z[21] = accum.extract();
   accum.mul_x2(x[0], x[22]);
   accum.mul_x2(x[1], x[21]);
   accum.mul_x2(x[2], x[20]);
   accum.mul_x2(x[3], x[19]);
   accum.mul_x2(x[4], x[18]);
   accum.mul_x2(x[5], x[17]);
   accum.mul_x2(x[6], x[16]);
   accum.mul_x2(x[7], x[15]);
   accum.mul_x2(x[8], x[14]);
   accum.mul_x2(x[9], x[13]);
   accum.mul_x2(x[10], x[12]);
   accum.mul(x[11], x[11]);
   z[22] = accum.extract();
   accum.mul_x2(x[0], x[23]);
   accum.mul_x2(x[1], x[22]);
   accum.mul_x2(x[2], x[21]);
   accum.mul_x2(x[3], x[20]);
   accum.mul_x2(x[4], x[19]);
   accum.mul_x2(x[5], x[18]);
   accum.mul_x2(x[6], x[17]);
   accum.mul_x2(x[7], x[16]);
   accum.mul_x2(x[8], x[15]);
   accum.mul_x2(x[9], x[14]);
   accum.mul_x2(x[10], x[13]);
   accum.mul_x2(x[11], x[12]);
   z[23] = accum.extract();
   accum.mul_x2(x[1], x[23]);
   accum.mul_x2(x[2], x[22]);
   accum.mul_x2(x[3], x[21]);
   accum.mul_x2(x[4], x[20]);
   accum.mul_x2(x[5], x[19]);
   accum.mul_x2(x[6], x[18]);
   accum.mul_x2(x[7], x[17]);
   accum.mul_x2(x[8], x[16]);
   accum.mul_x2(x[9], x[15]);
   accum.mul_x2(x[10], x[14]);
   accum.mul_x2(x[11], x[13]);
   accum.mul(x[12], x[12]);
   z[24] = accum.extract();
   accum.mul_x2(x[2], x[23]);
   accum.mul_x2(x[3], x[22]);
   accum.mul_x2(x[4], x[21]);
   accum.mul_x2(x[5], x[20]);
   accum.mul_x2(x[6], x[19]);
   accum.mul_x2(x[7], x[18]);
   accum.mul_x2(x[8], x[17]);
   accum.mul_x2(x[9], x[16]);
   accum.mul_x2(x[10], x[15]);
   accum.mul_x2(x[11], x[14]);
   accum.mul_x2(x[12], x[13]);
   z[25] = accum.extract();
   accum.mul_x2(x[3], x[23]);
   accum.mul_x2(x[4], x[22]);
   accum.mul_x2(x[5], x[21]);
   accum.mul_x2(x[6], x[20]);
   accum.mul_x2(x[7], x[19]);
   accum.mul_x2(x[8], x[18]);
   accum.mul_x2(x[9], x[17]);
   accum.mul_x2(x[10], x[16]);
   accum.mul_x2(x[11], x[15]);
   accum.mul_x2(x[12], x[14]);
   accum.mul(x[13], x[13]);
   z[26] = accum.extract();
   accum.mul_x2(x[4], x[23]);
   accum.mul_x2(x[5], x[22]);
   accum.mul_x2(x[6], x[21]);
   accum.mul_x2(x[7], x[20]);
   accum.mul_x2(x[8], x[19]);
   accum.mul_x2(x[9], x[18]);
   accum.mul_x2(x[10], x[17]);
   accum.mul_x2(x[11], x[16]);
   accum.mul_x2(x[12], x[15]);
   accum.mul_x2(x[13], x[14]);
   z[27] = accum.extract();
   accum.mul_x2(x[5], x[23]);
   accum.mul_x2(x[6], x[22]);
   accum.mul_x2(x[7], x[21]);
   accum.mul_x2(x[8], x[20]);
   accum.mul_x2(x[9], x[19]);
   accum.mul_x2(x[10], x[18]);
   accum.mul_x2(x[11], x[17]);
   accum.mul_x2(x[12], x[16]);
   accum.mul_x2(x[13], x[15]);
   accum.mul(x[14], x[14]);
   z[28] = accum.extract();
   accum.mul_x2(x[6], x[23]);
   accum.mul_x2(x[7], x[22]);
   accum.mul_x2(x[8], x[21]);
   accum.mul_x2(x[9], x[20]);
   accum.mul_x2(x[10], x[19]);
   accum.mul_x2(x[11], x[18]);
   accum.mul_x2(x[12], x[17]);
   accum.mul_x2(x[13], x[16]);
   accum.mul_x2(x[14], x[15]);
   z[29] = accum.extract();
   accum.mul_x2(x[7], x[23]);
   accum.mul_x2(x[8], x[22]);
   accum.mul_x2(x[9], x[21]);
   accum.mul_x2(x[10], x[20]);
   accum.mul_x2(x[11], x[19]);
   accum.mul_x2(x[12], x[18]);
   accum.mul_x2(x[13], x[17]);
   accum.mul_x2(x[14], x[16]);
   accum.mul(x[15], x[15]);
   z[30] = accum.extract();
   accum.mul_x2(x[8], x[23]);
   accum.mul_x2(x[9], x[22]);
   accum.mul_x2(x[10], x[21]);
   accum.mul_x2(x[11], x[20]);
   accum.mul_x2(x[12], x[19]);
   accum.mul_x2(x[13], x[18]);
   accum.mul_x2(x[14], x[17]);
   accum.mul_x2(x[15], x[16]);
   z[31] = accum.extract();
   accum.mul_x2(x[9], x[23]);
   accum.mul_x2(x[10], x[22]);
   accum.mul_x2(x[11], x[21]);
   accum.mul_x2(x[12], x[20]);
   accum.mul_x2(x[13], x[19]);
   accum.mul_x2(x[14], x[18]);
   accum.mul_x2(x[15], x[17]);
   accum.mul(x[16], x[16]);
   z[32] = accum.extract();
   accum.mul_x2(x[10], x[23]);
   accum.mul_x2(x[11], x[22]);
   accum.mul_x2(x[12], x[21]);
   accum.mul_x2(x[13], x[20]);
   accum.mul_x2(x[14], x[19]);
   accum.mul_x2(x[15], x[18]);
   accum.mul_x2(x[16], x[17]);
   z[33] = accum.extract();
   accum.mul_x2(x[11], x[23]);
   accum.mul_x2(x[12], x[22]);
   accum.mul_x2(x[13], x[21]);
   accum.mul_x2(x[14], x[20]);
   accum.mul_x2(x[15], x[19]);
   accum.mul_x2(x[16], x[18]);
   accum.mul(x[17], x[17]);
   z[34] = accum.extract();
   accum.mul_x2(x[12], x[23]);
   accum.mul_x2(x[13], x[22]);
   accum.mul_x2(x[14], x[21]);
   accum.mul_x2(x[15], x[20]);
   accum.mul_x2(x[16], x[19]);
   accum.mul_x2(x[17], x[18]);
   z[35] = accum.extract();
   accum.mul_x2(x[13], x[23]);
   accum.mul_x2(x[14], x[22]);
   accum.mul_x2(x[15], x[21]);
   accum.mul_x2(x[16], x[20]);
   accum.mul_x2(x[17], x[19]);
   accum.mul(x[18], x[18]);
   z[36] = accum.extract();
   accum.mul_x2(x[14], x[23]);
   accum.mul_x2(x[15], x[22]);
   accum.mul_x2(x[16], x[21]);
   accum.mul_x2(x[17], x[20]);
   accum.mul_x2(x[18], x[19]);
   z[37] = accum.extract();
   accum.mul_x2(x[15], x[23]);
   accum.mul_x2(x[16], x[22]);
   accum.mul_x2(x[17], x[21]);
   accum.mul_x2(x[18], x[20]);
   accum.mul(x[19], x[19]);
   z[38] = accum.extract();
   accum.mul_x2(x[16], x[23]);
   accum.mul_x2(x[17], x[22]);
   accum.mul_x2(x[18], x[21]);
   accum.mul_x2(x[19], x[20]);
   z[39] = accum.extract();
   accum.mul_x2(x[17], x[23]);
   accum.mul_x2(x[18], x[22]);
   accum.mul_x2(x[19], x[21]);
   accum.mul(x[20], x[20]);
   z[40] = accum.extract();
   accum.mul_x2(x[18], x[23]);
   accum.mul_x2(x[19], x[22]);
   accum.mul_x2(x[20], x[21]);
   z[41] = accum.extract();
   accum.mul_x2(x[19], x[23]);
   accum.mul_x2(x[20], x[22]);
   accum.mul(x[21], x[21]);
   z[42] = accum.extract();
   accum.mul_x2(x[20], x[23]);
   accum.mul_x2(x[21], x[22]);
   z[43] = accum.extract();
   accum.mul_x2(x[21], x[23]);
   accum.mul(x[22], x[22]);
   z[44] = accum.extract();
   accum.mul_x2(x[22], x[23]);
   z[45] = accum.extract();
   accum.mul(x[23], x[23]);
   z[46] = accum.extract();
   z[47] = accum.extract();
}

/*
* Comba 24x24 Multiplication
*/
void bigint_comba_mul24(word z[48], const word x[24], const word y[24]) {
   word3<word> accum;

   accum.mul(x[0], y[0]);
   z[0] = accum.extract();
   accum.mul(x[0], y[1]);
   accum.mul(x[1], y[0]);
   z[1] = accum.extract();
   accum.mul(x[0], y[2]);
   accum.mul(x[1], y[1]);
   accum.mul(x[2], y[0]);
   z[2] = accum.extract();
   accum.mul(x[0], y[3]);
   accum.mul(x[1], y[2]);
   accum.mul(x[2], y[1]);
   accum.mul(x[3], y[0]);
   z[3] = accum.extract();
   accum.mul(x[0], y[4]);
   accum.mul(x[1], y[3]);
   accum.mul(x[2], y[2]);
   accum.mul(x[3], y[1]);
   accum.mul(x[4], y[0]);
   z[4] = accum.extract();
   accum.mul(x[0], y[5]);
   accum.mul(x[1], y[4]);
   accum.mul(x[2], y[3]);
   accum.mul(x[3], y[2]);
   accum.mul(x[4], y[1]);
   accum.mul(x[5], y[0]);
   z[5] = accum.extract();
   accum.mul(x[0], y[6]);
   accum.mul(x[1], y[5]);
   accum.mul(x[2], y[4]);
   accum.mul(x[3], y[3]);
   accum.mul(x[4], y[2]);
   accum.mul(x[5], y[1]);
   accum.mul(x[6], y[0]);
   z[6] = accum.extract();
   accum.mul(x[0], y[7]);
   accum.mul(x[1], y[6]);
   accum.mul(x[2], y[5]);
   accum.mul(x[3], y[4]);
   accum.mul(x[4], y[3]);
   accum.mul(x[5], y[2]);
   accum.mul(x[6], y[1]);
   accum.mul(x[7], y[0]);
   z[7] = accum.extract();
   accum.mul(x[0], y[8]);
   accum.mul(x[1], y[7]);
   accum.mul(x[2], y[6]);
   accum.mul(x[3], y[5]);
   accum.mul(x[4], y[4]);
   accum.mul(x[5], y[3]);
   accum.mul(x[6], y[2]);
   accum.mul(x[7], y[1]);
   accum.mul(x[8], y[0]);
   z[8] = accum.extract();
   accum.mul(x[0], y[9]);
   accum.mul(x[1], y[8]);
   accum.mul(x[2], y[7]);
   accum.mul(x[3], y[6]);
   accum.mul(x[4], y[5]);
   accum.mul(x[5], y[4]);
   accum.mul(x[6], y[3]);
   accum.mul(x[7], y[2]);
   accum.mul(x[8], y[1]);
   accum.mul(x[9], y[0]);
   z[9] = accum.extract();
   accum.mul(x[0], y[10]);
   accum.mul(x[1], y[9]);
   accum.mul(x[2], y[8]);
   accum.mul(x[3], y[7]);
   accum.mul(x[4], y[6]);
   accum.mul(x[5], y[5]);
   accum.mul(x[6], y[4]);
   accum.mul(x[7], y[3]);
   accum.mul(x[8], y[2]);
   accum.mul(x[9], y[1]);
   accum.mul(x[10], y[0]);
   z[10] = accum.extract();
   accum.mul(x[0], y[11]);
   accum.mul(x[1], y[10]);
   accum.mul(x[2], y[9]);
   accum.mul(x[3], y[8]);
   accum.mul(x[4], y[7]);
   accum.mul(x[5], y[6]);
   accum.mul(x[6], y[5]);
   accum.mul(x[7], y[4]);
   accum.mul(x[8], y[3]);
   accum.mul(x[9], y[2]);
   accum.mul(x[10], y[1]);
   accum.mul(x[11], y[0]);
   z[11] = accum.extract();
   accum.mul(x[0], y[12]);
   accum.mul(x[1], y[11]);
   accum.mul(x[2], y[10]);
   accum.mul(x[3], y[9]);
   accum.mul(x[4], y[8]);
   accum.mul(x[5], y[7]);
   accum.mul(x[6], y[6]);
   accum.mul(x[7], y[5]);
   accum.mul(x[8], y[4]);
   accum.mul(x[9], y[3]);
   accum.mul(x[10], y[2]);
   accum.mul(x[11], y[1]);
   accum.mul(x[12], y[0]);
   z[12] = accum.extract();
   accum.mul(x[0], y[13]);
   accum.mul(x[1], y[12]);
   accum.mul(x[2], y[11]);
   accum.mul(x[3], y[10]);
   accum.mul(x[4], y[9]);
   accum.mul(x[5], y[8]);
   accum.mul(x[6], y[7]);
   accum.mul(x[7], y[6]);
   accum.mul(x[8], y[5]);
   accum.mul(x[9], y[4]);
   accum.mul(x[10], y[3]);
   accum.mul(x[11], y[2]);
   accum.mul(x[12], y[1]);
   accum.mul(x[13], y[0]);
   z[13] = accum.extract();
   accum.mul(x[0], y[14]);
   accum.mul(x[1], y[13]);
   accum.mul(x[2], y[12]);
   accum.mul(x[3], y[11]);
   accum.mul(x[4], y[10]);
   accum.mul(x[5], y[9]);
   accum.mul(x[6], y[8]);
   accum.mul(x[7], y[7]);
   accum.mul(x[8], y[6]);
   accum.mul(x[9], y[5]);
   accum.mul(x[10], y[4]);
   accum.mul(x[11], y[3]);
   accum.mul(x[12], y[2]);
   accum.mul(x[13], y[1]);
   accum.mul(x[14], y[0]);
   z[14] = accum.extract();
   accum.mul(x[0], y[15]);
   accum.mul(x[1], y[14]);
   accum.mul(x[2], y[13]);
   accum.mul(x[3], y[12]);
   accum.mul(x[4], y[11]);
   accum.mul(x[5], y[10]);
   accum.mul(x[6], y[9]);
   accum.mul(x[7], y[8]);
   accum.mul(x[8], y[7]);
   accum.mul(x[9], y[6]);
   accum.mul(x[10], y[5]);
   accum.mul(x[11], y[4]);
   accum.mul(x[12], y[3]);
   accum.mul(x[13], y[2]);
   accum.mul(x[14], y[1]);
   accum.mul(x[15], y[0]);
   z[15] = accum.extract();
   accum.mul(x[0], y[16]);
   accum.mul(x[1], y[15]);
   accum.mul(x[2], y[14]);
   accum.mul(x[3], y[13]);
   accum.mul(x[4], y[12]);
   accum.mul(x[5], y[11]);
   accum.mul(x[6], y[10]);
   accum.mul(x[7], y[9]);
   accum.mul(x[8], y[8]);
   accum.mul(x[9], y[7]);
   accum.mul(x[10], y[6]);
   accum.mul(x[11], y[5]);
   accum.mul(x[12], y[4]);
   accum.mul(x[13], y[3]);
   accum.mul(x[14], y[2]);
   accum.mul(x[15], y[1]);
   accum.mul(x[16], y[0]);
   z[16] = accum.extract();
   accum.mul(x[0], y[17]);
   accum.mul(x[1], y[16]);
   accum.mul(x[2], y[15]);
   accum.mul(x[3], y[14]);
   accum.mul(x[4], y[13]);
   accum.mul(x[5], y[12]);
   accum.mul(x[6], y[11]);
   accum.mul(x[7], y[10]);
   accum.mul(x[8], y[9]);
   accum.mul(x[9], y[8]);
   accum.mul(x[10], y[7]);
   accum.mul(x[11], y[6]);
   accum.mul(x[12], y[5]);
   accum.mul(x[13], y[4]);
   accum.mul(x[14], y[3]);
   accum.mul(x[15], y[2]);
   accum.mul(x[16], y[1]);
   accum.mul(x[17], y[0]);
   z[17] = accum.extract();
   accum.mul(x[0], y[18]);
   accum.mul(x[1], y[17]);
   accum.mul(x[2], y[16]);
   accum.mul(x[3], y[15]);
   accum.mul(x[4], y[14]);
   accum.mul(x[5], y[13]);
   accum.mul(x[6], y[12]);
   accum.mul(x[7], y[11]);
   accum.mul(x[8], y[10]);
   accum.mul(x[9], y[9]);
   accum.mul(x[10], y[8]);
   accum.mul(x[11], y[7]);
   accum.mul(x[12], y[6]);
   accum.mul(x[13], y[5]);
   accum.mul(x[14], y[4]);
   accum.mul(x[15], y[3]);
   accum.mul(x[16], y[2]);
   accum.mul(x[17], y[1]);
   accum.mul(x[18], y[0]);
   z[18] = accum.extract();
   accum.mul(x[0], y[19]);
   accum.mul(x[1], y[18]);
   accum.mul(x[2], y[17]);
   accum.mul(x[3], y[16]);
   accum.mul(x[4], y[15]);
   accum.mul(x[5], y[14]);
   accum.mul(x[6], y[13]);
   accum.mul(x[7], y[12]);
   accum.mul(x[8], y[11]);
   accum.mul(x[9], y[10]);
   accum.mul(x[10], y[9]);
   accum.mul(x[11], y[8]);
   accum.mul(x[12], y[7]);
   accum.mul(x[13], y[6]);
   accum.mul(x[14], y[5]);
   accum.mul(x[15], y[4]);
   accum.mul(x[16], y[3]);
   accum.mul(x[17], y[2]);
   accum.mul(x[18], y[1]);
   accum.mul(x[19], y[0]);
   z[19] = accum.extract();
   accum.mul(x[0], y[20]);
   accum.mul(x[1], y[19]);
   accum.mul(x[2], y[18]);
   accum.mul(x[3], y[17]);
   accum.mul(x[4], y[16]);
   accum.mul(x[5], y[15]);
   accum.mul(x[6], y[14]);
   accum.mul(x[7], y[13]);
   accum.mul(x[8], y[12]);
   accum.mul(x[9], y[11]);
   accum.mul(x[10], y[10]);
   accum.mul(x[11], y[9]);
   accum.mul(x[12], y[8]);
   accum.mul(x[13], y[7]);
   accum.mul(x[14], y[6]);
   accum.mul(x[15], y[5]);
   accum.mul(x[16], y[4]);
   accum.mul(x[17], y[3]);
   accum.mul(x[18], y[2]);
   accum.mul(x[19], y[1]);
   accum.mul(x[20], y[0]);
   z[20] = accum.extract();
   accum.mul(x[0], y[21]);
   accum.mul(x[1], y[20]);
   accum.mul(x[2], y[19]);
   accum.mul(x[3], y[18]);
   accum.mul(x[4], y[17]);
   accum.mul(x[5], y[16]);
   accum.mul(x[6], y[15]);
   accum.mul(x[7], y[14]);
   accum.mul(x[8], y[13]);
   accum.mul(x[9], y[12]);
   accum.mul(x[10], y[11]);
   accum.mul(x[11], y[10]);
   accum.mul(x[12], y[9]);
   accum.mul(x[13], y[8]);
   accum.mul(x[14], y[7]);
   accum.mul(x[15], y[6]);
   accum.mul(x[16], y[5]);
   accum.mul(x[17], y[4]);
   accum.mul(x[18], y[3]);
   accum.mul(x[19], y[2]);
   accum.mul(x[20], y[1]);
   accum.mul(x[21], y[0]);
   z[21] = accum.extract();
   accum.mul(x[0], y[22]);
   accum.mul(x[1], y[21]);
   accum.mul(x[2], y[20]);
   accum.mul(x[3], y[19]);
   accum.mul(x[4], y[18]);
   accum.mul(x[5], y[17]);
   accum.mul(x[6], y[16]);
   accum.mul(x[7], y[15]);
   accum.mul(x[8], y[14]);
   accum.mul(x[9], y[13]);
   accum.mul(x[10], y[12]);
   accum.mul(x[11], y[11]);
   accum.mul(x[12], y[10]);
   accum.mul(x[13], y[9]);
   accum.mul(x[14], y[8]);
   accum.mul(x[15], y[7]);
   accum.mul(x[16], y[6]);
   accum.mul(x[17], y[5]);
   accum.mul(x[18], y[4]);
   accum.mul(x[19], y[3]);
   accum.mul(x[20], y[2]);
   accum.mul(x[21], y[1]);
   accum.mul(x[22], y[0]);
   z[22] = accum.extract();
   accum.mul(x[0], y[23]);
   accum.mul(x[1], y[22]);
   accum.mul(x[2], y[21]);
   accum.mul(x[3], y[20]);
   accum.mul(x[4], y[19]);
   accum.mul(x[5], y[18]);
   accum.mul(x[6], y[17]);
   accum.mul(x[7], y[16]);
   accum.mul(x[8], y[15]);
   accum.mul(x[9], y[14]);
   accum.mul(x[10], y[13]);
   accum.mul(x[11], y[12]);
   accum.mul(x[12], y[11]);
   accum.mul(x[13], y[10]);
   accum.mul(x[14], y[9]);
   accum.mul(x[15], y[8]);
   accum.mul(x[16], y[7]);
   accum.mul(x[17], y[6]);
   accum.mul(x[18], y[5]);
   accum.mul(x[19], y[4]);
   accum.mul(x[20], y[3]);
   accum.mul(x[21], y[2]);
   accum.mul(x[22], y[1]);
   accum.mul(x[23], y[0]);
   z[23] = accum.extract();
   accum.mul(x[1], y[23]);
   accum.mul(x[2], y[22]);
   accum.mul(x[3], y[21]);
   accum.mul(x[4], y[20]);
   accum.mul(x[5], y[19]);
   accum.mul(x[6], y[18]);
   accum.mul(x[7], y[17]);
   accum.mul(x[8], y[16]);
   accum.mul(x[9], y[15]);
   accum.mul(x[10], y[14]);
   accum.mul(x[11], y[13]);
   accum.mul(x[12], y[12]);
   accum.mul(x[13], y[11]);
   accum.mul(x[14], y[10]);
   accum.mul(x[15], y[9]);
   accum.mul(x[16], y[8]);
   accum.mul(x[17], y[7]);
   accum.mul(x[18], y[6]);
   accum.mul(x[19], y[5]);
   accum.mul(x[20], y[4]);
   accum.mul(x[21], y[3]);
   accum.mul(x[22], y[2]);
   accum.mul(x[23], y[1]);
   z[24] = accum.extract();
   accum.mul(x[2], y[23]);
   accum.mul(x[3], y[22]);
   accum.mul(x[4], y[21]);
   accum.mul(x[5], y[20]);
   accum.mul(x[6], y[19]);
   accum.mul(x[7], y[18]);
   accum.mul(x[8], y[17]);
   accum.mul(x[9], y[16]);
   accum.mul(x[10], y[15]);
   accum.mul(x[11], y[14]);
   accum.mul(x[12], y[13]);
   accum.mul(x[13], y[12]);
   accum.mul(x[14], y[11]);
   accum.mul(x[15], y[10]);
   accum.mul(x[16], y[9]);
   accum.mul(x[17], y[8]);
   accum.mul(x[18], y[7]);
   accum.mul(x[19], y[6]);
   accum.mul(x[20], y[5]);
   accum.mul(x[21], y[4]);
   accum.mul(x[22], y[3]);
   accum.mul(x[23], y[2]);
   z[25] = accum.extract();
   accum.mul(x[3], y[23]);
   accum.mul(x[4], y[22]);
   accum.mul(x[5], y[21]);
   accum.mul(x[6], y[20]);
   accum.mul(x[7], y[19]);
   accum.mul(x[8], y[18]);
   accum.mul(x[9], y[17]);
   accum.mul(x[10], y[16]);
   accum.mul(x[11], y[15]);
   accum.mul(x[12], y[14]);
   accum.mul(x[13], y[13]);
   accum.mul(x[14], y[12]);
   accum.mul(x[15], y[11]);
   accum.mul(x[16], y[10]);
   accum.mul(x[17], y[9]);
   accum.mul(x[18], y[8]);
   accum.mul(x[19], y[7]);
   accum.mul(x[20], y[6]);
   accum.mul(x[21], y[5]);
   accum.mul(x[22], y[4]);
   accum.mul(x[23], y[3]);
   z[26] = accum.extract();
   accum.mul(x[4], y[23]);
   accum.mul(x[5], y[22]);
   accum.mul(x[6], y[21]);
   accum.mul(x[7], y[20]);
   accum.mul(x[8], y[19]);
   accum.mul(x[9], y[18]);
   accum.mul(x[10], y[17]);
   accum.mul(x[11], y[16]);
   accum.mul(x[12], y[15]);
   accum.mul(x[13], y[14]);
   accum.mul(x[14], y[13]);
   accum.mul(x[15], y[12]);
   accum.mul(x[16], y[11]);
   accum.mul(x[17], y[10]);
   accum.mul(x[18], y[9]);
   accum.mul(x[19], y[8]);
   accum.mul(x[20], y[7]);
   accum.mul(x[21], y[6]);
   accum.mul(x[22], y[5]);
   accum.mul(x[23], y[4]);
   z[27] = accum.extract();
   accum.mul(x[5], y[23]);
   accum.mul(x[6], y[22]);
   accum.mul(x[7], y[21]);
   accum.mul(x[8], y[20]);
   accum.mul(x[9], y[19]);
   accum.mul(x[10], y[18]);
   accum.mul(x[11], y[17]);
   accum.mul(x[12], y[16]);
   accum.mul(x[13], y[15]);
   accum.mul(x[14], y[14]);
   accum.mul(x[15], y[13]);
   accum.mul(x[16], y[12]);
   accum.mul(x[17], y[11]);
   accum.mul(x[18], y[10]);
   accum.mul(x[19], y[9]);
   accum.mul(x[20], y[8]);
   accum.mul(x[21], y[7]);
   accum.mul(x[22], y[6]);
   accum.mul(x[23], y[5]);
   z[28] = accum.extract();
   accum.mul(x[6], y[23]);
   accum.mul(x[7], y[22]);
   accum.mul(x[8], y[21]);
   accum.mul(x[9], y[20]);
   accum.mul(x[10], y[19]);
   accum.mul(x[11], y[18]);
   accum.mul(x[12], y[17]);
   accum.mul(x[13], y[16]);
   accum.mul(x[14], y[15]);
   accum.mul(x[15], y[14]);
   accum.mul(x[16], y[13]);
   accum.mul(x[17], y[12]);
   accum.mul(x[18], y[11]);
   accum.mul(x[19], y[10]);
   accum.mul(x[20], y[9]);
   accum.mul(x[21], y[8]);
   accum.mul(x[22], y[7]);
   accum.mul(x[23], y[6]);
   z[29] = accum.extract();
   accum.mul(x[7], y[23]);
   accum.mul(x[8], y[22]);
   accum.mul(x[9], y[21]);
   accum.mul(x[10], y[20]);
   accum.mul(x[11], y[19]);
   accum.mul(x[12], y[18]);
   accum.mul(x[13], y[17]);
   accum.mul(x[14], y[16]);
   accum.mul(x[15], y[15]);
   accum.mul(x[16], y[14]);
   accum.mul(x[17], y[13]);
   accum.mul(x[18], y[12]);
   accum.mul(x[19], y[11]);
   accum.mul(x[20], y[10]);
   accum.mul(x[21], y[9]);
   accum.mul(x[22], y[8]);
   accum.mul(x[23], y[7]);
   z[30] = accum.extract();
   accum.mul(x[8], y[23]);
   accum.mul(x[9], y[22]);
   accum.mul(x[10], y[21]);
   accum.mul(x[11], y[20]);
   accum.mul(x[12], y[19]);
   accum.mul(x[13], y[18]);
   accum.mul(x[14], y[17]);
   accum.mul(x[15], y[16]);
   accum.mul(x[16], y[15]);
   accum.mul(x[17], y[14]);
   accum.mul(x[18], y[13]);
   accum.mul(x[19], y[12]);
   accum.mul(x[20], y[11]);
   accum.mul(x[21], y[10]);
   accum.mul(x[22], y[9]);
   accum.mul(x[23], y[8]);
   z[31] = accum.extract();
   accum.mul(x[9], y[23]);
   accum.mul(x[10], y[22]);
   accum.mul(x[11], y[21]);
   accum.mul(x[12], y[20]);
   accum.mul(x[13], y[19]);
   accum.mul(x[14], y[18]);
   accum.mul(x[15], y[17]);
   accum.mul(x[16], y[16]);
   accum.mul(x[17], y[15]);
   accum.mul(x[18], y[14]);
   accum.mul(x[19], y[13]);
   accum.mul(x[20], y[12]);
   accum.mul(x[21], y[11]);
   accum.mul(x[22], y[10]);
   accum.mul(x[23], y[9]);
   z[32] = accum.extract();
   accum.mul(x[10], y[23]);
   accum.mul(x[11], y[22]);
   accum.mul(x[12], y[21]);
   accum.mul(x[13], y[20]);
   accum.mul(x[14], y[19]);
   accum.mul(x[15], y[18]);
   accum.mul(x[16], y[17]);
   accum.mul(x[17], y[16]);
   accum.mul(x[18], y[15]);
   accum.mul(x[19], y[14]);
   accum.mul(x[20], y[13]);
   accum.mul(x[21], y[12]);
   accum.mul(x[22], y[11]);
   accum.mul(x[23], y[10]);
   z[33] = accum.extract();
   accum.mul(x[11], y[23]);
   accum.mul(x[12], y[22]);
   accum.mul(x[13], y[21]);
   accum.mul(x[14], y[20]);
   accum.mul(x[15], y[19]);
   accum.mul(x[16], y[18]);
   accum.mul(x[17], y[17]);
   accum.mul(x[18], y[16]);
   accum.mul(x[19], y[15]);
   accum.mul(x[20], y[14]);
   accum.mul(x[21], y[13]);
   accum.mul(x[22], y[12]);
   accum.mul(x[23], y[11]);
   z[34] = accum.extract();
   accum.mul(x[12], y[23]);
   accum.mul(x[13], y[22]);
   accum.mul(x[14], y[21]);
   accum.mul(x[15], y[20]);
   accum.mul(x[16], y[19]);
   accum.mul(x[17], y[18]);
   accum.mul(x[18], y[17]);
   accum.mul(x[19], y[16]);
   accum.mul(x[20], y[15]);
   accum.mul(x[21], y[14]);
   accum.mul(x[22], y[13]);
   accum.mul(x[23], y[12]);
   z[35] = accum.extract();
   accum.mul(x[13], y[23]);
   accum.mul(x[14], y[22]);
   accum.mul(x[15], y[21]);
   accum.mul(x[16], y[20]);
   accum.mul(x[17], y[19]);
   accum.mul(x[18], y[18]);
   accum.mul(x[19], y[17]);
   accum.mul(x[20], y[16]);
   accum.mul(x[21], y[15]);
   accum.mul(x[22], y[14]);
   accum.mul(x[23], y[13]);
   z[36] = accum.extract();
   accum.mul(x[14], y[23]);
   accum.mul(x[15], y[22]);
   accum.mul(x[16], y[21]);
   accum.mul(x[17], y[20]);
   accum.mul(x[18], y[19]);
   accum.mul(x[19], y[18]);
   accum.mul(x[20], y[17]);
   accum.mul(x[21], y[16]);
   accum.mul(x[22], y[15]);
   accum.mul(x[23], y[14]);
   z[37] = accum.extract();
   accum.mul(x[15], y[23]);
   accum.mul(x[16], y[22]);
   accum.mul(x[17], y[21]);
   accum.mul(x[18], y[20]);
   accum.mul(x[19], y[19]);
   accum.mul(x[20], y[18]);
   accum.mul(x[21], y[17]);
   accum.mul(x[22], y[16]);
   accum.mul(x[23], y[15]);
   z[38] = accum.extract();
   accum.mul(x[16], y[23]);
   accum.mul(x[17], y[22]);
   accum.mul(x[18], y[21]);
   accum.mul(x[19], y[20]);
   accum.mul(x[20], y[19]);
   accum.mul(x[21], y[18]);
   accum.mul(x[22], y[17]);
   accum.mul(x[23], y[16]);
   z[39] = accum.extract();
   accum.mul(x[17], y[23]);
   accum.mul(x[18], y[22]);
   accum.mul(x[19], y[21]);
   accum.mul(x[20], y[20]);
   accum.mul(x[21], y[19]);
   accum.mul(x[22], y[18]);
   accum.mul(x[23], y[17]);
   z[40] = accum.extract();
   accum.mul(x[18], y[23]);
   accum.mul(x[19], y[22]);
   accum.mul(x[20], y[21]);
   accum.mul(x[21], y[20]);
   accum.mul(x[22], y[19]);
   accum.mul(x[23], y[18]);
   z[41] = accum.extract();
   accum.mul(x[19], y[23]);
   accum.mul(x[20], y[22]);
   accum.mul(x[21], y[21]);
   accum.mul(x[22], y[20]);
   accum.mul(x[23], y[19]);
   z[42] = accum.extract();
   accum.mul(x[20], y[23]);
   accum.mul(x[21], y[22]);
   accum.mul(x[22], y[21]);
   accum.mul(x[23], y[20]);
   z[43] = accum.extract();
   accum.mul(x[21], y[23]);
   accum.mul(x[22], y[22]);
   accum.mul(x[23], y[21]);
   z[44] = accum.extract();
   accum.mul(x[22], y[23]);
   accum.mul(x[23], y[22]);
   z[45] = accum.extract();
   accum.mul(x[23], y[23]);
   z[46] = accum.extract();
   z[47] = accum.extract();
}

}  // namespace Botan
