---
title: The v3 format
---

# The v3 format

## Overview
The v3 format is a nonlinear timeline file format. It supports multiple overlapping video and audio layers. The v3 format is a subset of [JSON](https://www.json.org/), and the proper extension is `.json`.

Auto-Editor can generate v3 timelines from media files (instructed with `--edit`),
```
auto-editor example.mp4 --export timeline:api=3 -o input-v3.json
```

render media files from the v3 format,
```
auto-editor input-v3.json -o output.mkv
```

and translate other timeline formats to v3:
```
auto-editor input-fcp7.xml --export timeline:api=3 -o output-v3.json
```

## Stability
This format is considered partially-stable. Breaking changes can be made to feature level changes, but not patch level changes.

## The Header
shown using TypeScript notation, the keys can be set to the following values.
```ts
type Integer = number; // An integer floating-point value.
type Natural = number; // An integer floating-point value that is >= 0.
type Source = string; // A path to a media file, must be valid for the given platform.
type SupportedSpeed = float; // Between 0.0 exclusive and 99999.0 exclusive.

interface v3 {
  version: "3";       // Must always be set as "3".
  resolution: [number, number];  // width and height. Must both be natural numbers.
  timebase: string;   // The timebase. Must be a rational number.
                      // Typical values are: "24/1", 30/1", "30000/1001"
                      // Values with a decimal ("29.97") should be rejected.

  samplerate: number; // The overall samplerate, must be a natural number.

  background: string; // A web RGB color value for the background. Relevant in cases
                      // like when a video has a different aspect ratio than the..
                      // global resolution. Must be in the format "#000" or "#000000".
   v: Video[][];
   a: Audio[][];
}
```

## Video and Audio Layers
The elements in the `v` and `a` keys are a tagged union with `name` as the discriminant.

```ts
interface Video {
  name: "video";
  src: Source;
  start: Natural;   // Where in this timeline to start this clip. In terms of timebase.
  dur: Natural;     // The duration of the clip. In terms of timebase.
  offset: Natural;  // Where from the source to start playing at. In terms of timebase.
  speed: SupportedSpeed;
  stream: Natural;  // Which video stream from the source to use.
                    // Usually stream 0.
}

interface Audio {
  name: "audio";
  src: Source;
  start: Natural;
  dur: Natural;
  offset: Natural;
  volume: float;    // A float between 0.0 and 1.0. Changes the audio loudness.
  stream: Natural;  // Which audio stream from the source to use.
}
```

The v3 format looks something like this:
```json
{
  "version": "3",
  "resolution": [1280, 720],
  "timebase": "30/1",
  "samplerate": 48000,
  "background": "#000",
  "v": [
    [
      {
        "name": "video",
        "src": "example.mp4",
        "start": 0,
        "dur": 26,
        "offset": 0,
        "speed": 1.0,
        "stream": 0
      },
      {
        "name": "video",
        "src": "example.mp4",
        "start": 26,
        "dur": 362,
        "offset": 34,
        "speed": 1.0,
        "stream": 0
      },
      ...
    ]
  ],
  "a": [
    [
      {
        "name": "audio",
        "src": "example.mp4",
        "start": 0,
        "dur": 26,
        "offset": 0,
        "speed": 1.0,
        "volume": 1,
        "stream": 0
      },
      {
        "name": "audio",
        "src": "example.mp4",
        "start": 26,
        "dur": 362,
        "offset": 34,
        "speed": 1.0,
        "volume": 1,
        "stream": 0
      },
      ...
    ]
  ]
}
```

There are two additional video elements:

```ts
// Draw an image
interface Image {
  name: "image";
  src: Source;
  start: Natural;   // Where in this timeline to start this clip. In terms of timebase.
  dur: Natural;     // The duration of the clip. In terms of timebase.
  x: Integer;
  y: Integer;
  width: Natural;
  opacity: float;
}

// Draw a rectangle with a solid color
interface Rect {
  name: "rect";
  start: Natural;
  dur: Natural;
  x: Integer;
  y: Integer;
  width: Natural;
  height: Natural;
  fill: string;
}
```
