APBS ion pmf test case
======================

This is the two-ion test case for force evaluation from the Im et al. *Comput. Phys. Commun.* **111**, 59--75 (1998) paper. The output of these run(s) are solvation energies for ion pairs (convert to total energy by adding Coulombic forces) and solvation force components. Molecule 0 is fixed (at x=-3) and molecule 1 was moved.

To run this test case, simply type `./runme.sh`, making sure that the apbs binary is in your path.

Here's the output you can look for (all forces in kJ/mol/Å):

sasa - Solvent-accessible surface area force (scaled by the surface tension,    gamma). **NOTE THAT THIS FORCE HAS CHANGED!** We're now using SASA forces instead of the spline-surface square gradient forces used in previous examples (and by Im et al).

qf - Reaction field force

db - Dielectric boundary force

ib - Ionic boundary force (osmotic pressure)

Here are the force results visually estimated from the Im et al paper (see above) with forces in kJ/mol/Å with one ion fixed at x = -3.0 Å.

Mol 1 location|QF||DB||IB||
---|---|---|---|---|---|---
||Mol 0|Mol 1|Mol 0|Mol 1|Mol 0|Mol 1
-3.00|0.0E+00|0.0E+00|0.0E+00|0.0E+00|0|0
-2.50|8.4E+00|-1.3E+01|1.1E+02|-1.1E+02|0|0
-2.00|3.8E+01|-3.4E+01|8.2E+01|-8.2E+01|0|0
-1.50|6.3E+01|-5.5E+01|4.2E+01|-4.0E+01|0|0
-1.00|8.8E+01|8.8E+01|4.2E+00|-4.2E+01|0|0
-0.50|1.0E+02|-1.0E+02|-1.2E+01|1.6E+01|0|0
0.00|1.1E+02|0|-2.1E+01|2.1E+01|0|0
0.50|9.6E+01|-9.8E+01|-1.1E+01|4.2E+00|0|0
1.00|8.4E+01|-8.8E+01|4.2E+00|0.0E+00|0|0
1.50|6.7E+01|-6.5E+01|6.3E+00|4.2E+00|0|0
2.00|5.3E+01|-5.3E+01|6.3E+01|6.3E+01|0|0
2.50|4.6E+01|-4.8E+01|6.3E+01|-2.1E+01|0|0
3.00|3.8E+01|-3.8E+01|6.3E+00|-6.3E+00|0|0

Here are the results from APBS 3.0

    polarforces
     qf  0  8.398642197666E+01  -1.324564548552E-05  -1.613435632529E-05
     ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
     db  0  6.148357059184E+00  -2.667517425897E-05  -5.378919678211E-05
     tot 0  9.013477903584E+01  -3.992081974449E-05  -6.992355310740E-05
     qf  1  -8.466423642736E+01  -1.836748045969E-05  -3.062224428458E-05
     ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
     db  1  2.882739230548E+00  -3.149946357588E-05  -6.291495506459E-05
     tot 1  -8.178149719681E+01  -4.986694403557E-05  -9.353719934917E-05
     tot all 8.353281839029E+00  -8.978776378007E-05  -1.634607524566E-04

    apolarforces
     sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
     sav   0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
     wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
     tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
     sasa  1  1.111862435589E+01  0.000000000000E+00  0.000000000000E+00
     sav   1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
     wca   1  5.826560767576E-01  -2.767485007141E-05  -2.767485007183E-05
     tot   1  1.170128043265E+01  -2.767485007141E-05  -2.767485007183E-05
     tot all  1.208529806779E-01  -5.534155522943E-05  -5.534155523021E-05

Here are the results from APBS 1.5

    x = 1.000

    polarforces
     qf  0  8.398642197666E+01  -1.324564548552E-05  -1.613435632529E-05
     ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
     db  0  6.148357059184E+00  -2.667517425897E-05  -5.378919678211E-05
     tot 0  9.013477903584E+01  -3.992081974449E-05  -6.992355310740E-05
     qf  1  -8.466423642736E+01  -1.836748045969E-05  -3.062224428458E-05
     ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
     db  1  2.882739230548E+00  -3.149946357588E-05  -6.291495506459E-05
     tot 1  -8.178149719681E+01  -4.986694403557E-05  -9.353719934917E-05
     tot all 8.353281839029E+00  -8.978776378007E-05  -1.634607524566E-04

    apolarforces
     sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
     sav   0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
     wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
     tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
     sasa  1  1.111862435589E+01  0.000000000000E+00  0.000000000000E+00
     sav   1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
     wca   1  5.826560767576E-01  -2.767485007141E-05  -2.767485007183E-05
     tot   1  1.170128043265E+01  -2.767485007141E-05  -2.767485007183E-05
     tot all  1.208529806779E-01  -5.534155522943E-05  -5.534155523021E-05

Here are the results from APBS 1.4.2:

    x = 1.000

    polarforces
      qf  0  8.398642197666E+01  -1.324564548552E-05  -1.613435632529E-05
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  0  6.148357059184E+00  -2.667517425897E-05  -5.378919678211E-05
      tot 0  9.013477903584E+01  -3.992081974449E-05  -6.992355310740E-05
      qf  1  -8.466423642736E+01  -1.836748045969E-05  -3.062224428458E-05
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  1  2.882739230548E+00  -3.149946357588E-05  -6.291495506459E-05
      tot 1  -8.178149719681E+01  -4.986694403557E-05  -9.353719934917E-05
      tot all 8.353281839029E+00  -8.978776378007E-05  -1.634607524566E-04

    apolarforces
      sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
      sav   0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
      tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
      sasa  1  1.111862435589E+01  0.000000000000E+00  0.000000000000E+00
      sav   1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   1  5.826560767576E-01  -2.767485007141E-05  -2.767485007183E-05
      tot   1  1.170128043265E+01  -2.767485007141E-05  -2.767485007183E-05
      tot all  1.208529806779E-01  -5.534155522943E-05  -5.534155523021E-05

Here are the results from APBS 1.4.1-binary:

    x = 1.000

    polarforces
      qf  0  8.398642197665E+01  -1.324563987321E-05  -1.613435751204E-05
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  0  6.148357059184E+00  -2.667517427189E-05  -5.378919673813E-05
      tot 0  9.013477903583E+01  -3.992081414510E-05  -6.992355425017E-05
      qf  1  -8.466423642736E+01  -1.836748529478E-05  -3.062224653038E-05
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  1  2.882739230548E+00  -3.149946357422E-05  -6.291495504390E-05
      tot 1  -8.178149719681E+01  -4.986694886900E-05  -9.353720157428E-05
      tot all 8.353281839026E+00  -8.978776301409E-05  -1.634607558245E-04

    apolarforces
      sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
      sav   0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
      tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
      sasa  1  1.111862435589E+01  0.000000000000E+00  0.000000000000E+00
      sav   1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   1  5.826560767576E-01  -2.767485007143E-05  -2.767485007183E-05
      tot   1  1.170128043265E+01  -2.767485007143E-05  -2.767485007183E-05
      tot all  1.208529806779E-01  -5.534155522944E-05  -5.534155523021E-05

      Global net ELEC energy = -1.125191605614E+03 kJ/mol
      Global net APOL energy = -1.365308087297E+01 kJ/mol

Here are the results from APBS 1.4:

    x = 1.000

    polarforces
      qf  0   8.398642197666E+01  -1.324564266726E-05  -1.613435892778E-05
      ib  0   0.000000000000E+00   0.000000000000E+00   0.000000000000E+00
      db  0   6.148357059184E+00  -2.667517424343E-05  -5.378919673334E-05
      tot 0   9.013477903584E+01  -3.992081691068E-05  -6.992355566112E-05
      qf  1  -8.466423642735E+01  -1.836748431279E-05  -3.062224860445E-05
      ib  1   0.000000000000E+00   0.000000000000E+00   0.000000000000E+00
      db  1   2.882739230548E+00  -3.149946358193E-05  -6.291495505310E-05
      tot 1  -8.178149719681E+01  -4.986694789471E-05  -9.353720365755E-05
      tot all 8.353281839034E+00  -8.978776480540E-05  -1.634607593187E-04

    apolarforces
      sasa  0  -1.099776974333E+01   0.000000000000E+00   0.000000000000E+00
      sav   0   0.000000000000E+00   0.000000000000E+00   0.000000000000E+00
      wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
      tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
      sasa  1   1.111862435589E+01   0.000000000000E+00   0.000000000000E+00
      sav   1   0.000000000000E+00   0.000000000000E+00   0.000000000000E+00
      wca   1   5.826560767576E-01  -2.767485007143E-05  -2.767485007183E-05
      tot   1   1.170128043265E+01  -2.767485007143E-05  -2.767485007183E-05
      tot all   1.208529806779E-01  -5.534155522944E-05  -5.534155523021E-05

      Global net ELEC energy = -1.125191605614E+03 kJ/mol

Here are the results from APBS 1.3:

    x = 1.000

    polarforces
      qf  0  8.398640174378E+01  9.818388346045E-06  9.795992548983E-06
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  0  6.148361411050E+00  2.004819537885E-05  3.920937677211E-05
      tot 0  9.013476315483E+01  2.986658372490E-05  4.900536932109E-05
      qf  1  -8.466424236101E+01 -9.207441185028E-06 -2.534007494961E-05
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  1  2.882747163943E+00  1.731862478386E-05  3.267273837455E-05
      tot 1  -8.178149519706E+01 8.111183598834E-06  7.332663424942E-06
      tot all 8.353267957769E+00 3.797776732373E-05  5.633803274603E-05

    apolarforces
      sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
      sav   0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
      tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
      sasa  1  1.111862435589E+01  0.000000000000E+00  0.000000000000E+00
      sav   1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   1  5.826560767576E-01  -2.767485007141E-05  -2.767485007183E-05
      tot   1  1.170128043265E+01  -2.767485007141E-05  -2.767485007183E-05
      tot all  1.208529806779E-01  -5.534155522943E-05  -5.534155523021E-05

      Global net ELEC energy = -1.125191531404E+03 kJ/mol

Here are the results from APBS 1.2.1:

    x = 1.000

    polarforces
      qf  0  8.398640174377E+01  9.818386932509E-06  9.795992245139E-06
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  0  6.148361411050E+00  2.004819530432E-05  3.920937680245E-05
      tot 0  9.013476315482E+01  2.986658223683E-05  4.900536904759E-05
      qf  1  -8.466424236099E+01 -9.207442514897E-06 -2.534008066980E-05
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  1  2.882747163943E+00  1.731862480409E-05  3.267273838847E-05
      tot 1  -8.178149519705E+01 8.111182289197E-06  7.332657718672E-06
      tot all 8.353267957774E+00 3.797776452602E-05  5.633802676626E-05

    apolarforces
      sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
      sav   0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
      tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
      sasa  1  1.111862435589E+01  0.000000000000E+00  0.000000000000E+00
      sav   1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   1  5.826560767576E-01  -2.767485007143E-05  -2.767485007183E-05
      tot   1  1.170128043265E+01  -2.767485007143E-05  -2.767485007183E-05
      tot all  1.208529806779E-01  -5.534155522944E-05  -5.534155523021E-05

      Global net ELEC energy = -1.125191531404E+03 kJ/mol

Here are the results from APBS 1.2:

    x = 1.000

    polarforces
      qf  0  8.398640174377E+01  9.818386932509E-06  9.795992245139E-06
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  0  6.148361411050E+00  2.004819530432E-05  3.920937680245E-05
      tot 0  9.013476315482E+01  2.986658223683E-05  4.900536904759E-05
      qf  1  -8.466424236099E+01 -9.207442514897E-06 -2.534008066980E-05
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  1  2.882747163943E+00  1.731862480409E-05  3.267273838847E-05
      tot 1  -8.178149519705E+01 8.111182289197E-06  7.332657718672E-06
      tot all 8.353267957774E+00 3.797776452602E-05  5.633802676626E-05

    apolarforces
      sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
      sav   0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
      tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
      sasa  1  1.111862435589E+01  0.000000000000E+00  0.000000000000E+00
      sav   1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   1  5.826560767576E-01  -2.767485007143E-05  -2.767485007183E-05
      tot   1  1.170128043265E+01  -2.767485007143E-05  -2.767485007183E-05
      tot all  1.208529806779E-01  -5.534155522944E-05  -5.534155523021E-05

      Global net ELEC energy = -1.125191531404E+03 kJ/mol

Here are the results from APBS 1.1.0:

    x = 1.000

    polarforces
      qf  0  8.398636786524E+01  3.277928951109E-05  2.248755327954E-05
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  0  6.148315264050E+00  6.212090029364E-05  9.765261473306E-05
      tot 0  9.013468312929E+01  9.490018980473E-05  1.201401680126E-04
      qf  1  -8.466453877446E+01  1.260694683844E-05  -2.688056989348E-05
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      db  1  2.882714236549E+00  9.382342500375E-05  1.225207937768E-04
      tot 1  -8.178182453791E+01  1.064303718422E-04  9.564022388330E-05
      tot all 8.352858591379E+00  2.013305616469E-04  2.157803918959E-04

    apolarforces
      sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
      sav   0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   0  -5.826577086437E-01  -2.766670515801E-05  -2.766670515838E-05
      tot   0  -1.158042745197E+01  -2.766670515801E-05  -2.766670515838E-05
      sasa  1  1.111862435589E+01  0.000000000000E+00  0.000000000000E+00
      sav   1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      wca   1  5.826560767576E-01  -2.767485007143E-05  -2.767485007183E-05
      tot   1  1.170128043265E+01  -2.767485007143E-05  -2.767485007183E-05
      tot all  1.208529806779E-01  -5.534155522944E-05  -5.534155523021E-05

      Global net ELEC energy = -1.125192402906E+03 kJ/mol

Here are the results from APBS 0.5.0:

    x = -3.000
      sasa 0 2.014e-01 0.000e+00 0.000e+00
      sasa 1 2.014e-01 0.000e+00 0.000e+00
      sasa  0  2.014243542734E-01  0.000000000000E+00  0.000000000000E+00
      qf  0  2.402694548782E-01  1.193684463475E-04  9.707135192876E-05
      qf  1  2.402694548782E-01  1.193684463475E-04  9.707135192876E-05
      db  0  -1.040061396733E+00  5.059871689052E-05  1.004179762749E-04
      db  1  -1.040061396733E+00  5.059871689052E-05  1.004179762749E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.494109084160E+03 kJ/mol
      Global net APOL energy = 1.073537020853E-01 kJ/mol
    x = -2.500
      sasa 0 -1.047e+01 0.000e+00 0.000e+00
      sasa 1 1.088e+01 0.000e+00 0.000e+00
      sasa  0  -1.047406642222E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  9.670776686682E+00  3.067299706303E-05  8.525779585775E-06
      qf  1  -9.776393142038E+00  1.160701475502E-04  9.737743502613E-05
      db  0  1.128766544950E+02  4.216378707828E-05  1.156092840465E-04
      db  1  -1.018562119621E+02  1.332582044569E-04  2.007546725043E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.453172513724E+03 kJ/mol
      Global net APOL energy = 1.127544530116E-01 kJ/mol
    x = -2.000
      sasa 0 -1.088e+01 0.000e+00 0.000e+00
      sasa 1 1.092e+01 0.000e+00 0.000e+00
      sasa  0  -1.087691513076E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  3.600129707630E+01  1.673257382577E-05  -3.172493445854E-06
      qf  1  -3.698431978276E+01  1.362593318370E-04  1.348136933229E-04
      db  0  7.641808295612E+01  8.426812747154E-05  1.501550525155E-04
      db  1  -7.630995607470E+01  1.930747292853E-04  2.577078768374E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.395864905308E+03 kJ/mol
      Global net APOL energy = 1.202783777713E-01 kJ/mol
    x = -1.50
      sasa 0 -1.055e+01 0.000e+00 0.000e+00
      sasa 1 1.064e+01 0.000e+00 0.000e+00
      sasa  0  -1.055463616393E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  6.263390243427E+01  -1.039272251661E-05  -3.653632695350E-05
      qf  1  -6.274351718559E+01  6.171199346571E-05  3.641783990404E-05
      db  0  4.141531409141E+01  8.939020846417E-05  1.464873997274E-04
      db  1  -3.980350645690E+01  1.618242786613E-04  2.096874862673E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.343413508063E+03 kJ/mol
      Global net APOL energy = 1.278197055953E-01 kJ/mol
    x = -1.00
      sasa 0 -1.104e+01 0.000e+00 0.000e+00
      sasa 1 1.080e+01 0.000e+00 0.000e+00
      sasa  0  -1.103805461418E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  8.602515079485E+01  1.679958402518E-05  -1.286070388760E-06
      qf  1  -8.589474499290E+01  4.904393981795E-05  2.948346215562E-05
      db  0  5.146620466700E+00  1.263326043428E-04  1.972642536915E-04
      db  1  -2.462461594184E+00  1.419028113702E-04  2.025478366045E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.297718358292E+03 kJ/mol
      Global net APOL energy = 1.354538497618E-01 kJ/mol
    x = -0.500
      sasa 0 -1.088e+01 0.000e+00 0.000e+00
      sasa 1 1.080e+01 0.000e+00 0.000e+00
      sasa  0  -1.087691513076E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  1.011157426881E+02  3.495539842345E-05  2.650020071179E-05
      qf  1  -1.018411965567E+02  2.379958570171E-05  7.021000073448E-06
      db  0  -1.147809320720E+01  1.908780322530E-04  2.832722451268E-04
      db  1  2.221256509495E+01  1.621554833141E-04  2.462408961005E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.253921668205E+03 kJ/mol
      Global net APOL energy = 1.431402031209E-01 kJ/mol
    x = 0.000
      sasa 0 -1.047e+01 0.000e+00 0.000e+00
      sasa 1 1.055e+01 0.000e+00 0.000e+00
      sasa  0  -1.047406642222E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  1.076485044405E+02  4.150254188932E-05  2.584327997210E-05
      qf  1  -1.076452387179E+02  1.116736665075E-05  -1.918731685710E-05
      db  0  -2.164756414609E+01  1.200915665417E-04  1.684440777983E-04
      db  1  2.928788039760E+01  1.264642983339E-04  1.736212475138E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.211966318316E+03 kJ/mol
      Global net APOL energy = 1.508265564799E-01 kJ/mol
    x = 0.500
      sasa 0 -1.072e+01 0.000e+00 0.000e+00
      sasa 1 1.059e+01 0.000e+00 0.000e+00
      sasa  0  -1.071577564735E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  1.027354991386E+02  2.555484206199E-05  1.063932308940E-05
      qf  1  -1.027864740990E+02  4.081203889223E-05  2.562624208050E-05
      db  0  -1.024263914547E+01  6.237801032056E-05  9.677805192977E-05
      db  1  4.694564975253E+00  7.269351372102E-05  1.062464666717E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.169410509835E+03 kJ/mol
      Global net APOL energy = 1.585419149460E-01 kJ/mol
    x = 1.000
      sasa 0 -1.100e+01 0.000e+00 0.000e+00
      sasa 1 1.112e+01 0.000e+00 0.000e+00
      sasa  0  -1.099776974333E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  8.398636786523E+01  3.277928825388E-05  2.248755650954E-05
      qf  1  -8.466453877447E+01  1.260694492290E-05  -2.688056972615E-05
      db  0  6.148315264050E+00  6.212090033654E-05  9.765261477356E-05
      db  1  2.882714236549E+00  9.382342501820E-05  1.225207938255E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.125192402906E+03 kJ/mol
      Global net APOL energy = 1.661992631981E-01 kJ/mol
    x = 1.500
      sasa 0 -1.068e+01 0.000e+00 0.000e+00
      sasa 1 1.072e+01 0.000e+00 0.000e+00
      sasa  0  -1.067549077649E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  6.661368503641E+01  3.283120005903E-05  2.336264942404E-05
      qf  1  -6.687857770544E+01  3.794378201242E-07  -4.537653753875E-05
      db  0  7.100467586189E+00  6.377840082367E-05  1.004771191938E-04
      db  1  3.082008432733E+00  1.019851332113E-04  1.318438583362E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.087409226682E+03 kJ/mol
      Global net APOL energy = 1.739378257498E-01 kJ/mol
    x = 2.000
      sasa 0 -1.092e+01 0.000e+00 0.000e+00
      sasa 1 1.096e+01 0.000e+00 0.000e+00
      sasa  0  -1.091720000162E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  5.395122212118E+01  3.402365136823E-05  2.463252404579E-05
      qf  1  -5.435238595073E+01  2.345850272885E-05  5.498720638168E-06
      db  0  7.099496363901E+00  6.338076881104E-05  9.960971260094E-05
      db  1  1.822551374452E+00  7.422787937764E-05  1.097869885768E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.056724540553E+03 kJ/mol
      Global net APOL energy = 1.814733525524E-01 kJ/mol
    x = 2.500
      sasa 0 -1.072e+01 0.000e+00 0.000e+00
      sasa 1 1.068e+01 0.000e+00 0.000e+00
      sasa  0  -1.071577564735E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  4.454222472665E+01  3.558462567387E-05  2.660491501258E-05
      qf  1  -4.504040092314E+01  -1.044092908553E-05  -3.622045970037E-05
      db  0  7.053724444849E+00  6.155505900578E-05  9.694085460358E-05
      db  1  -2.309382970894E+00  6.271891825021E-05  9.531078126617E-05
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.032072744366E+03 kJ/mol
      Global net APOL energy = 1.893047314465E-01 kJ/mol
    x = 3.000
      sasa 0 -1.092e+01 0.000e+00 0.000e+00
      sasa 1 1.051e+01 0.000e+00 0.000e+00
      sasa  0  -1.091720000162E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  3.737527031761E+01  3.343902445084E-05  2.403559379423E-05
      qf  1  -3.737539015853E+01  4.414820479892E-05  3.441749305654E-05
      db  0  7.008341960925E+00  6.385969683875E-05  1.003016820956E-04
      db  1  -7.008312180867E+00  7.315905619890E-05  1.101572582696E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -1.011312542835E+03 kJ/mol
      Global net APOL energy = 1.969446766344E-01 kJ/mol
    x = 3.500
      sasa 0 -1.064e+01 0.000e+00 0.000e+00
      sasa 1 1.068e+01 0.000e+00 0.000e+00
      sasa  0  -1.063520590564E+01  0.000000000000E+00  0.000000000000E+00
      qf  0  3.179181222228E+01  3.472564738899E-05  2.566914250463E-05
      qf  1  -3.259379322155E+01  1.216664204331E-05  -2.497181119826E-05
      db  0  6.969782295514E+00  6.257908926389E-05  9.840967875397E-05
      db  1  7.904107869827E+00  8.728726024045E-05  1.158752820808E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -9.936580311110E+02 kJ/mol
      Global net APOL energy = 2.046252289721E-01 kJ/mol
    x = 4.000
      sasa 0 0.000e+00 0.000e+00 0.000e+00
      sasa 1 0.000e+00 0.000e+00 0.000e+00
      sasa  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      qf  0  2.736006693935E+01  3.271235623929E-05  2.341325695619E-05
      qf  1  -2.776033811952E+01  8.396915386866E-06  -3.668786316582E-05
      db  0  6.937279812724E+00  6.412225118915E-05  1.008451446546E-04
      db  1  1.489454481196E+00  1.060308624524E-04  1.379944549983E-04
      ib  0  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      ib  1  0.000000000000E+00  0.000000000000E+00  0.000000000000E+00
      Global net ELEC energy = -9.786249660218E+02 kJ/mol
      Global net APOL energy = 2.091848317949E-01 kJ/mol
