# Why does the Makhnovist movement show there is an alternative to Bolshevism?

The key Leninist defence of the actions of the Bolsheviks in the Russian
revolution is that they had no other choice. Complaints against the Bolshevik
attacks on the gains of the revolution and the pro-revolutionary Left in
Russia are met with a mantra involving the white terror, the primitive state
of Russia and the reactionary peasantry, the invading imperialist armies
(although the actual number can, and does, vary depending on who you are
talking to) and other such _"forces of nature"_ which we are to believe could
only be met by a centralised authoritarian regime that would flinch at nothing
in order to survive.

However, this is not the case. This is for three reasons.

Firstly, there is the slight problem that many of the attacks on the
revolution (disbanding soviets, undermining the factory committees, repressing
socialists and anarchists, and so on) started **before** the start of the
civil war. As such, its difficult to blame the degeneration of the revolution
on an event which had yet to happen (see [ section 3](append43.md#app3) of
the appendix [ "What caused the degeneration of the Russian
Revolution?"](append43.md) for details).

Secondly, Leninists like to portray their ideology as "realistic," that it
recognises the problems facing a revolution and can provide the necessary
solutions. Some even claim, flying in the face of the facts, that anarchists
think the ruling class will just _"disappear"_ (see [section
H.2.1](secH2.md#sech21) ) or that we think _"full-blown"_ communism will
appear _"overnight"_ (see [section H.2.5](secH2.md#sech25)). Only
Bolshevism, it is claimed, recognises that civil war is inevitable during a
revolution and only it provides the necessary solution, namely a _"workers
state."_ Lenin himself argued that _"[n]ot a single great revolution in
history has escaped civil war. No one who does not live in a shell could
imagine that civil war is conceivable without exceptionally complicated
circumstances."_ [ **Will the Bolsheviks Maintain Power?** , p. 81] As such,
its incredulous that modern day followers of Lenin blame the degeneration of
the Russian Revolution on the very factors (civil war and exceptional
circumstances) that they claim to recognise an inevitable!

Thirdly, and even more embarrassingly for the Leninists, numerous examples
exist both from revolutionary Russia at the time and from earlier and later
revolutions that suggest far from Bolshevik tactics being the most efficient
way of defending the revolution other methods existed which looked to the
massive creative energies of the working masses unleashed by the revolution.

During the Russian Revolution the biggest example of this is found in South-
Eastern Ukraine. For much of the Civil War this area operated without a
centralised state apparatus of the Bolshevik type and was, instead, based on
the anarchist idea of Free Soviets. There _"the insurgents raised the black
flag of anarchism and set forth on the anti-authoritarian road of the free
organisation of the workers."_ [Arshinov, **The History of the Makhnovist
Movement** , p. 50] The space in which this happened was created by a partisan
force that instead of using the _"efficiency"_ of executions for desertion,
tsarist officers appointed over the rank and file soldiers' wishes and
saluting so loved by the Bolsheviks instead operated as a volunteer army with
elected officers and voluntary discipline. This movement was the Makhnovists,
named after its leader, the Ukrainian anarchist Nestor Makhno. The Black Flag
which floated over the lead wagon of the Insurgent Army was inscribed with the
slogans **_"Liberty or Death"_** and **_"The Land to the Peasants, the
Factories to the Workers."_** These slogans summarised what the Makhnovist
were fighting for -- a libertarian socialist society. At its height in the
autumn of 1919, the Maknovists numbered around 40,000 and its extended area of
influence corresponded to nearly one third of the Ukrainian Soviet Republic,
comprising a population of over seven million.

It is this that explains the importance of the Makhnovists. As historian
Christopher Reed notes, the _"Bolsheviks' main claim to legitimacy rested on
the argument that they were the only ones capable of preventing a similar
disaster [counter-revolution] for the workers and peasants of Russia and that
their harsh methods were necessary in the face of a ruthless and unrelenting
enemy."_ However, Reed argues that _"the Makhno movement in the Ukraine
suggests that there was more than one way to fight against the counter-
revolution."_ [ **From Tsar to Soviets** , pp. 258-9] This is why the
Makhnovist movement is so important, why it shows that there was, and is, an
alternative to the ideas of Bolshevism. Here we have a mass movement operating
in the same _"exceptional circumstances"_ as the Bolsheviks which did **not**
implement the same policies. Indeed, rather than suppress soviet, workplace
and military democracy in favour of centralised, top-down party power and
modify their political line to justify their implementation of party
dictatorship, the Makhnovists did all they could to implement and encourage
working-class self-government.

As such, it is difficult to blame the development of Bolshevik policies
towards state-capitalist and party-dictatorship directions on the problems
caused during the revolution when the Makhnovists, facing similar conditions,
did all they could to protect working- class autonomy and freedom. Indeed, it
could be argued that the problems facing the Makhnovists were greater in many
ways. The Ukraine probably saw more fighting in the Russian Civil War then any
other area. Unlike the Bolsheviks, the Makhnovists lost the centre of their
movement and had to re-liberate it. To do so they fought the Austrian and
German armies, Ukrainian Nationalists, Bolsheviks and the White Armies of
Denikin and then Wrangel. There were smaller skirmishes involving Cossacks
returning to the Don and independent _"Green"_ bands. The anarchists fought
all these various armies over the four years their movement was in existence.
This war was not only bloody but saw constant shifts of fronts, advances and
retreats and changes from near conventional war to mobile partisan war. The
consequences of this was that no area of the territory was a safe _"rear"_
area for any period of time and so little constructive activity was possible.
[Section 4](append46.md#app4) presents a summary of the military campaigns
of these years. A brief idea of the depth of fighting in these years can be
seen by considering the town at the centre of the Makhnovists, Hulyai Pole
which changed hands no less then 16 times in the period from 1917-1921.

Clearly, in terms of conflict (and the resulting disruption caused by it), the
Makhnovists did not have the relative peace the Bolsheviks had (who never once
lost their main bases of Petrograd or Moscow, although they came close). As
such, the problems used to justify the repressive and dictatorial policies of
the Bolsheviks also apply to the Makhnovists. Despite this, the activity of
the Makhnovists in the Ukraine demonstrated that an alternative to the
supposedly necessary methods of the Bolsheviks did exist. Where the Bolsheviks
suppressed freedom of speech, assembly and press, the Makhnovists encouraged
it. Where the Bolsheviks turned the soviets into mere cyphers of their
government and undermined soviet power, the Makhnovists encouraged working-
class participation and free soviets. As we discuss in [section
7](append46.md#app7), the Makhnovists applied their ideas of working class
self-management whenever and wherever they could.

Sadly, the Makhnovist movement is a relatively unknown event during the
revolution. There are few non-anarchist accounts of it and the few histories
which do mention it often simply slander it. However, as the Cohn-Bendit
brothers correctly argue, the movement, _"better perhaps than any other
movement, shows that the Russian Revolution could have been a great liberating
force."_ Equally, the reason why it has been almost totally ignored (or
slandered, when mentioned) by Stalinist and Trotskyist writers is simple: _"It
shows the Bolsheviks stifling workers and peasants with lies and calumnies,
and then crushing them in a bloody massacre."_ [Daniel and Gabriel Cohn-
Bendit, **Obsolete Communism: The Left-Wing Alternative** , p. 200]

This section of our FAQ will indicate the nature and history of this important
social movement. As we will prove, _"the Makhnovshchina . . . was a true
popular movement of peasants and workers, and . . . its essential goal was to
establish the freedom of workers by means of revolutionary self-activity on
the part of the masses."_ [Arshinov, **The History of the Makhnovist
Movement** , p. 209] They achieved this goal in extremely difficult
circumstances and resisted all attempts to limit the freedom of the working
class, no matter where it came from. As Makhno himself once noted:

> _"Our practice in the Ukraine showed clearly that the peasant problem had
> very different solutions from those imposed by Bolshevism. If our experience
> had spread to the rest of Russia, a pernicious division between country and
> city would not have been created. Years of famine would have been avoided
> and useless struggles between peasant and workers. And what is more
> important, the revolution would have grown and developed along very
> different lines . . . We were all fighters and workers. The popular assembly
> made the decisions. In military life it was the War Committee composed of
> delegates of all the guerrilla detachments which acted. To sum up, everyone
> took part in the collective work, to prevent the birth of a managing class
> which would monopolise power. And we were successful. Because we had
> succeeded and gave lie to Bolshevik bureaucratic practices, Trotsky,
> betraying the treaty between the Ukraine and the Bolshevik authorities, sent
> the Red Army to fight us. Bolshevism triumphed militarily over the Ukraine
> and at Kronstadt, but revolutionary history will acclaim us one day and
> condemn the victors as counter-revolutionary grave-diggers of the Russian
> Revolution."_ [quoted by Abel Paz, **Durruti: The People Armed** , p. 88-9]

Two distinct aspects of the anarchist movement existed in the Ukraine at this
time, a political and non-military structure called the Nabat (Alarm)
federation which operated through the soviets and collectives and a military
command structure usually known after is commander Nestor Makhno as the
**_Makhnovshchina_** (which means the _"Makhno movement"_ ) although its
proper name was the **_Revolutionary Insurgent Army of the Ukraine_**. This
section of the FAQ will cover both, although the Makhnovshchina will be the
main focus.

For more information on the Makhnovist movement, consult the following books.
Anarchist accounts of the movement can be found in Peter Arshinov's excellent
**The History of the Makhnovist Movement** and Voline's **The Unknown
Revolution** (Voline's work is based on extensive quotes from Arshinov's work,
but does contain useful additional material). For non-anarchist accounts,
Michael Malet's **Nestor Makhno in the Russian Revolution** is essential
reading as it contains useful information on both the history of the movement,
its social basis and political ideas. Malet considers his work as a supplement
to Michael Palij's **The Anarchism of Nestor Makhno, 1918-1921** which is
primarily a military account of the movement but which does cover some of its
social and political aspects. Unfortunately, both books are rare. Paul
Avrich's **The Russian Anarchists** contains a short account of the movement
and his **Anarchist Portraits** has a chapter on Nestor Makhno. Makhnovist
source material is included in Avrich's **The Anarchists in the Russian
Revolution**. Daniel Guerin includes a section on Makhno and the Makhnovist
Movement in volume 2 of **No Gods, No Masters**. As well as extracts from
Arshinov's book, it has various manifestos from the movement as well as
Makhno's account of his meeting with Lenin. Christopher Read's **From Tsar to
Soviets** has an excellent section on the Makhnovists. Serge Cipko presents an
excellent overview of works on the Makhnovists in his _"Nestor Makhno: A Mini-
Historiography of the Anarchist Revolution in Ukraine, 1917-1921"_ ( **The
Raven** , no. 13). Alexander Skirda presents an overview of perestroika soviet
accounts of Makhno in his essay _"The Rehabilitation of Makhno"_ ( **The
Raven** , no. 8). Skirda's biography **Nestor Makhno: Le Cosaque de
l'anarchie** is by far the best account of the movement available.

Lastly, a few words on names. There is a large variation on the spelling of
names within the source material. For example, Makhno's home town has been
translated as Gulyai Pole, Gulyai Polye Huliai-Pole and Hulyai Pole.
Similarly, with other place names. The bandit Grigor'ev has been also
translated as Hryhor'iv and Hryhoriyiv. We generally take Michael Malet's
translations of names as a basis (i.e. we use Hulyai Pole and Hryhoriyiv, for
example).

## 1 Who was Nestor Makhno?

The Makhnovist movement was named after Nestor Makhno, a Ukrainian anarchist
who played a key role in the movement from the start. Indeed, Makhnoshchina
literally means _"Makhno movement"_ and his name is forever linked with the
revolution in the South-East of the Ukraine. So who was Makhno?

Nestor Ivanovich Makhno was born on the 27th of October, 1889 in Hulyai Pole,
which is situated in Katerynoslav province, in the south east of the Ukraine
between the Dnieper River and the Sea of Azov. While it seems to be
conventional for many historians to call Hulyai Pole a "village," it was in
fact a town with a population of about 30,000 and boasted several factories
and schools.

Makhno was the son of a poor peasant family. His father died when he was ten
months old, leaving him and his four brothers in the care of their mother. Due
to the extreme poverty of his family, he had to start work as a shepherd at
the age of seven. At eight he started to attend the Second Hulyai Pole primary
school in winter and worked for local landlords during the summer. He left
school when he was twelve and took up full-time employment as a farmhand on
the estates of nobles and on the farms of the German colonist **kulaks.** At
the age of seventeen, he started to work in Hulyai Pole itself, first as an
apprentice painter, then as an unskilled worker in a local iron foundry and,
finally, as a founder in the same establishment.

It was when he was working in the iron foundry that he became involved in
revolutionary politics. In the stormy years following the 1905 revolution,
Makhno got involved in revolutionary politics. This decision was based on his
experiences of injustice at work and seeing the terror of the Russian regime
during the 1905 events (in Hulyai Pole there had been no serious disorder, yet
the regime sent a detachment of mounted police to suppress gatherings and
meetings in the town, terrorising the population by whipping those caught in
the streets and beating prisoners with rifle butts). In 1906, Makhno decided
to join the anarchist group in Hulyai Pole (which had been formed the previous
year and consisted mainly of sons of poorer peasants).

At the end of 1906 and in 1907, Makhno was arrested and accused of political
assassinations, but was released due to lack of evidence. In 1908, due to the
denunciation of a police spy within the anarchist group, he was arrested and
put in jail. In March, 1910, Makhno and thirteen others were tried by a
military court and sentenced to death by hanging. Due to his youth and the
efforts of his mother, the death penalty was commuted to life imprisonment
with hard labour. He served his time at the Butyrki prison in Moscow,
resisting the prison authorities by every means available to him. Due to this
resistance, he spent much of his time in chains or in damp and freezing
confinement. This experience ensured that Makhno developed an intense hatred
of prisons (later, during the revolution, his first act in entering a town or
city was to release all prisoners and destroy the prison).

It was during his time in Butykri that Makhno met Peter Arshinov, a fellow
anarchist prisoner and later activist and historian of the Makhnovist
movement. Arshinov was born in 1887 in the Ukrainian industrial town of
Katerinoslav. His father was a factory worker and he was a metal worker.
Originally a Bolshevik, he had become an anarchist in 1906, taking a leading
part in organising factory workers and actions against the regime. In 1907 he
was arrested and sentenced to death, escaping to Western Europe. In 1909, he
returned to Russia and was again arrested and again escaped. In 1910, he was
arrested and placed in the Butykri prison where he met Makhno. The two
anarchists established a close personal and political friendship, with
Arshinov helping Makhno develop and deepen his anarchist ideas.

On March 2nd, 1917, after eight years and eight months in prison, Makhno was
released along with all other political prisoners as a result of the February
Revolution. After spending three weeks in Moscow with the Moscow anarchists,
Makhno returned to Hulyai Pole. As the only political prisoner who was
returned to his family by the revolution, Makhno became very well-respected in
his home town. After years of imprisonment, suffering but learning, Makhno was
no longer an inexperienced young activist, but a tested anarchist militant
with both a powerful will and strong ideas about social conflict and
revolutionary politics. Ideas which he immediately set about applying.

Once home in Hulyai Pole, Makhno immediately devoted himself to revolutionary
work. Unsurprisingly, the remaining members of the anarchist group, as well as
many peasants, came to visit him. After discussing ideas with them, Makhno
proposed beginning organisational work immediately in order to strengthen
links between the peasants in Hulyai Pole and its region with the anarchist
group. On March 28-29, a Peasant Union was created with Makhno as its
chairman. Subsequently, he organised similar unions in other villages and
towns in the area. Makhno also played a large part in a successful strike by
wood and metal workers at a factory owned by his old boss (this defeat led to
the other bosses capitulating to the workers as well). At the same time,
peasants refused to pay their rent to the landlords. [Michael Malet, **Nestor
Makhno in the Russian Civil War** , p. 4] Regional assemblies of peasants were
called, both at Hulyai Pole and elsewhere, and on August 5-7, the provincial
congress at Katerinoslav decided to reorganise the Peasant Unions into Soviets
of Peasants' and Workers' Deputies.

In this way, _"Makhno and his associates brought socio-political issues into
the daily life of the people, who in turn supported his efforts, hoping to
expedite the expropriation of large estates."_ [Michael Palij, **The Anarchism
of Nestor Makhno** , p. 71] In Hulyai Pole, the revolution was moving faster
than elsewhere (for example, while the Aleksandrovsk soviet supported the
actions of the Provisional Government during the July days in Petrograd, a
meeting in Hulyai Pole saluted the rebellious soldiers and workers). Peasants
were drawn to Hulyai Pole for advice and help from the neighbouring
**volosts** (administrative districts). The peasantry wanted to seize the land
of the large landowners and the kulaks (rich peasants). Makhno presented this
demand at the first sessions of the regional Soviet, which were held in Hulyai
Pole. In August, Makhno called all the local landlords and rich peasants
(kulaks) together and all documents concerning ownership (of land, livestock
and equipment) were taken from them. An inventory of this property was taken
and reported to the session of the local soviet and then at a regional
meeting. It was agreed that all land, livestock and equipment was to be
divided equally, the division to include the former owners. This was the core
of the agrarian program of the movement, namely the liquidation of the
property of the landowners and kulaks. No-one could own more land than they
could work with their own labour. All this was in flat defiance to the
Provisional Government which was insisting that all such questions be left to
the Constituent Assembly. Free communes were also created on ex-landlord
estates.

Unsurprisingly, the implementation of these decisions was delayed because of
the opposition of the landlords and kulaks, who organised themselves and
appealed to the provisional authorities. When General Kornilov tried to march
on Petrograd and take power, the Hulyai Pole soviet took the initiative and
formed a local _"Committee for the Salvation of the Revolution"_ headed by
Makhno. The real aim was to disarm the potential local enemy -- the landlords,
bourgeoisie, and kulaks -- as well as to expropriate their ownership of the
people's wealth: the land, factories, plants, printing shops, theatres and so
on. On 25 September a volost congress of Soviets and peasant organisations in
Hulyai Pole proclaimed the confiscation of the landowners' land and its
transformation into social property. Raids on the estates of landlords and
rich peasants, including German colonists, began and the expropriation of the
expropriators began.

Makhno's activities came to a halt the following spring when Lenin's
government signed the Treaty of Brest-Litovsk. This treaty gave sizeable parts
of the Russian Empire, including the Ukraine, to Germany and Austria in return
for peace. The Treaty also saw the invasion of the Ukraine by large numbers of
German and Austrian troops, who conquered the entire country in less than
three months. Makhno succeeded in forming several military units, consisting
of 1700 men, but could not stop Hulyai Pole being taken. After an anarchist
congress at the end of April in Taganrog, it was decided to organise small
combat units of five to ten peasants and workers, to collect arms from the
enemy and to prepare for a general peasant uprising against the Austro-German
troops and, finally, to send a small group to Soviet Russia to see at first
hand what was happening there to both the revolution and to the anarchists
under Bolshevik rule. Makhno was part of that group.

By June, Makhno had arrived in Moscow. He immediately visited a number of
Russian anarchists (including his old friend Peter Arshinov). The anarchist
movement in Moscow was cowed, due to a Cheka raid in April which broke the
backbone of the movement, so ending a political threat to the Bolsheviks from
the left. To Makhno, coming from an area where freedom of speech and
organisation was taken for granted, the low level of activity came as a shock.
He regarded Moscow as the capital of the _"paper revolution,"_ whose red tape
and meaninglessness had affected even the anarchists. Makhno also visited
Peter Kropotkin, asking his advice on revolutionary work and the situation in
the Ukraine. To Makhno, _"Moscow appeared as 'the capital of the Paper
Revolution,' a vast factory turning out empty resolutions and slogans while
one political party, by means of force and fraud, elevated itself into the
position of a ruling class."_ [David Footman, **Op. Cit.** , p. 252]

While in Moscow, Makhno met with Lenin. This meeting came about by chance.
Visiting the Kremlin to obtain a permit for free board and lodging, he met the
chairman of the All-Russian Central Executive Committee of the Soviets, Jakov
M. Sverdlov, who arranged for Makhno to meet Lenin. Lenin asked Makhno, _"How
did the peasants of your region understand the slogan ALL POWER TO THE SOVIETS
IN THE VILLAGES?"_ Makhno states that Lenin _"was astonished"_ at his reply:

> _"The peasants understood this slogan in their own way. According to their
> interpretation, all power, in all areas of life, must be identified with the
> consciousness and will of the working people. The peasants understand that
> the soviets of workers and peasants of village, country and district are
> neither more nor less than the means of revolutionary organisation and
> economic self-management of working people in the struggle against the
> bourgeoisie and its lackeys, the Right socialists and their coalition
> government."_

To this Lenin replied: _"Well, then, the peasants of your region are infected
with anarchism!"_ [Nestor Makhno, **My Visit to the Kremlin** , p. 18] Later
in the interview, Lenin stated: _"Do the anarchists ever recognise their lack
of realism in present-day life? Why, they don't even think of it."_ Makhno
replied:

> _"But I must tell you, comrade Lenin, that your assertion that the
> anarchists don't understand 'the present' realistically, that they have no
> real connection with it and so forth, is fundamentally mistaken. The
> anarchist-communists in the Ukraine . . . the anarchist-communists, I say,
> have already given many proofs that they are firmly planted in 'the
> present.' The whole struggle of the revolutionary Ukrainian countryside
> against the Central Rada has been carried out under the ideological guidance
> of the anarchist-communists and also in part by the Socialist
> Revolutionaries . . . Your Bolsheviks have scarcely any presence in our
> villages. Where they have penetrated, their influence is minimal. Almost all
> the communes or peasant associations in the Ukraine were formed at the
> instigation of the anarchist-communists. The armed struggle of the working
> people against the counter-revolution in general and the Austro-German
> invasion in particular has been undertaken with the ideological and organic
> guidance of the anarchist-communists exclusively._
>
> _"Certainly it is not in your party's interest to give us credit for all
> this, but these are the facts and you can't dispute them. You know perfectly
> well, I assume, the effective force and the fighting capacity of the free,
> revolutionary forces of the Ukraine. It is not without reason that you have
> evoked the courage with which they have heroically defended the common
> revolutionary conquests. Among them, at least one half have fought under the
> anarchist banner. . ._
>
> _"All this shows how mistaken you are, comrade Lenin, in alleging that we,
> the anarchist-communists, don't have our feet on the ground, that our
> attitude towards 'the present' is deplorable and that we are too fond of
> dreaming about the future. What I have said to you in the course of this
> interview cannot be questioned because it is the truth. The account which I
> have made to you contradicts the conclusions you expressed about us.
> Everyone can see we are firmly planted in 'the present,' that we are working
> and searching for the means to bring about the future we desire, and that we
> are in fact dealing very seriously with this problem."_

Lenin replied: _"Perhaps I am mistaken."_ [Makhno, **Op. Cit.** , pp. 24-5]

The Bolsheviks helped Makhno to return to the Ukraine. The trip was
accomplished with great difficulty. Once Makhno was almost killed. He was
arrested by Austro-German troops and was carrying libertarian pamphlets at the
time. A Jewish inhabitant of Hulyai Pole, who had know Makhno for some time,
succeeded in saving him by paying a considerable sum of money for his
liberation. Once back in Hulyai-Pole, he started to organise resistance to the
occupying forces of the Austro-Germans and their puppet regime led by Hetman
Skoropadsky. With the resistance, the Makhno movement can be said to have
arisen (see [section 3](append46.md#app3) on way it was named after Makhno).
From July 1918 to August 1921, Makhno led the struggle for working class
freedom against all oppressors, whether Bolshevik, White or Nationalist.
During the course of this struggle, he proved himself to be _"a guerrilla
leader of quite outstanding ability."_ [David Footman, **Civil War in Russia**
, p. 245] The military history of this movement is discussed in [section
4](append46.md#app4), while other aspects of the movement are discussed in
other sections.

After the defeat of the Makhnovist movement in 1921, Makhno was exiled in
Western Europe. In 1925 he ended up in Paris, where he lived for the rest of
his life. While there, he remained active in the anarchist movement, with the
pen replacing the sabre (to use Alexander Skirda's colourful expression).
Makhno contributed articles to various anarchist journals and in particular to
**Delo Truda** , an anarchist-communist paper started in Paris by Peter
Arshinov (many of these articles have been published in the book **The
Struggle Against the State and Other Essays** ). He remained active in the
anarchist movement to the end.

In Paris, Makhno met the famous Spanish anarchists Buenaventura Durruti and
Francisco Ascaso in 1927. He argued that in Spain _"conditions for a
revolution with a strong anarchist content are better than in Russia"_ because
not only was there _"a proletariat and a peasantry with a revolutionary
tradition whose political maturity is shown in its reactions,"_ the Spanish
anarchists had _"a sense of organisation which we lacked in Russia. It is
organisation which assures the success in depth of all revolutions."_ Makhno
recounted the activities of the Hulyai Pole anarchist group and the events in
revolutionary Ukraine:

> _"Our agrarian commune was at once the economic and political vital centre
> of our social system. These communities were not based on individual egoism
> but rested on principles of communal, local and regional solidarity. In the
> same way that the members of a community felt solidarity among themselves,
> the communities were federated with each other . . . It is said against our
> system that in the Ukraine, that it was able to last because it was based
> only on peasant foundations. It isn't true. Our communities were mixed,
> agricultural-industrial, and, even, some of them were only industrial. We
> were all fighters and workers. The popular assembly made the decisions. In
> military life it was the War Committee composed of delegates of all the
> guerrilla detachments which acted. To sum up, everyone took part in the
> collective work, to prevent the birth of a managing class which would
> monopolise power. And we were successful."_ [quoted by Abel Paz, **Durruti:
> The People Armed** , p. 88-9]

As can be seen from the social revolution in Aragon, Durruti took Makhno's
advice seriously (see [section I.8](secI8.md) for more on the Spanish
Revolution). Unsurprisingly, in 1936 a number of veterans of Makhno's
Insurgent Army went to fight in the Durruti column. Sadly, Makhno's death in
1934 prevented his own concluding statement to the two Spaniards: _"Makhno has
never refused to fight. If I am alive when you start your struggle, I will be
with you."_ [quoted by Paz, **Op. Cit.** , p. 90]

Makhno's most famous activity in exile was his association with, and defence
of, the **Organisational Platform of the Libertarian Communists** (known as
the _"Platform"_ ). As discussed in [section J.3.3](secJ3.md#secj33), the
Platform was an attempt to analyse what had gone wrong in the Russian
Revolution and suggested a much tighter anarchist organisation in future. This
idea provoked intense debate after its publication, with the majority of
anarchists rejecting it (for Makhno's discussion with Malatesta on this issue,
see **The Anarchist Revolution** published by Freedom Press). This debate
often resulted in bitter polemics and left Makhno somewhat isolated as some of
his friends, like Voline, opposed the Platform. However, he remained an
anarchist to his death in 1934.

Makhno died on the morning of July 25th and was cremated three days later and
his ashes placed in an urn within Pere Lachaise, the cemetery of the Paris
Commune. Five hundred Russian, French, Spanish and Italian comrades attended
the funeral, at which the French anarchist Benar and Voline spoke (Voline used
the occasion to refute Bolshevik allegations of anti-Semitism). Makhno's wife,
Halyna, was too overcome to speak.

So ended the life of one great fighters for working-class freedom. Little
wonder Durruti's words to Makhno:

> _"We have come to salute you, the symbol of all those revolutionaries who
> struggled for the realisation of Anarchist ideas in Russia. We also come to
> pay our respects to the rich experience of the Ukraine."_ [quoted by Abel
> Paz, **Op. Cit.** , p. 88]

For fuller details of Makhno's life, see the accounts by Peter Arshinov (
**The History of the Makhnovist Movement** ), Paul Avrich ( _"Nestor Makhno:
The Man and the Myth,"_ in **Anarchist Portraits** ), Michael Palij, ( **The
Anarchism of Nestor Makhno** ) and Michael Malet ( **Nestor Makhno in the
Russian Revolution** ).

## 2 Why was the movement named after Makhno?

Officially, the Makhnovist movement was called the **Revolutionary
Insurrectionary Army of the Ukraine**. In practice, it was usually called the
_"Makhno movement"_ ( ** _"Makhnovshchina"_** in Russian) or the Makhnovists.
Unsurprisingly, Trotsky placed great significance on this:

> _"The anti-popular character of the Makhno movement is most clearly revealed
> in the fact that the army of Hulyai Pole is actually called 'Makhno's Army'.
> **There, armed men are united not around a programme, not around an
> ideological banner, but around a man.** "_ [ **The Makhno Movement** ]

Ignoring the irony of a self-proclaimed Marxist (and later Leninist and
founder of Trotskyism!) making such a comment, we can only indicate why the
Makhnovists called themselves by that name:

> _"Because, first, in the terrible days of reaction in the Ukraine, we saw in
> our ranks an unfailing friend and leader, MAKHNO, whose voice of protest
> against any kind of coercion of the working people rang out in all the
> Ukraine, calling for a battle against all oppressors, pillagers and
> political charlatans who betray us; and who is now marching together with us
> in our common ranks unwavering toward the final goal: liberation of the
> working people from any kind of oppression."_ [contained in Arshinov, **Op.
> Cit.** , p. 272]

The two of the anarchists who took part in the movement and later wrote its
history concur. Voline argues that the reason why the movement was known as
the _"Makhnovist movement"_ was because the _"most important role in this work
of unification [of the peasant masses] and in the general development of the
revolutionary insurrection in the southern Ukraine was performed by the
detachment of partisans guided by a peasant native to the region: Nestor
Makhno."_ [ **The Unknown Revolution** , p. 551] _"From the first days of the
movement,"_ Arshinov notes, _"up to its culminating point, when the peasants
vanquished the landowners, Makhno played a preponderant and central role to
such an extent that the whole insurgent region and the most heroic moments of
the struggle are linked to his name. Later, when the insurrection had
triumphed completely over the Skoropadsky counter-revolution and the region
was threatened by Denikin, Makhno became the rallying point for millions of
peasants in several regions."_ [ **Op. Cit.** , p. 50]

It must be stressed that Nestor Mahkno was not the boss of the Mahknovista. He
was not their ruler or general. As such, the fact that the Makhnovists were
(unofficially) named after Makhno does not imply that it was his personal
fiefdom, nor that those involved followed him as an individual. Rather, the
movement was named after him because he was universally respected within it as
a leading militant. This fact also explains why Makhno was nicknamed _"Batko"_
(see [next section](append46.md#app3)).

This can be seen from how the movement was organised and was run. As we
discuss in [section 5](append46.md#app5), it was organised in a
fundamentally democratic way, by means of mass assemblies of insurgents,
elected officers, regular insurgent, peasant and worker congresses and an
elected _"Revolutionary Military Soviet."_ The driving force in the Makhnovist
movement was not, therefore, Makhno but rather the anarchist ideas of self-
management. As Trotsky himself was aware, the Makhnovists were influenced by
anarchist ideas:

> _"Makhno and his companions-in-arms are not non-party people at all. They
> are all of the Anarchist persuasion, and send out circulars and letters
> summoning Anarchists to Hulyai Pole so as to organise their own Anarchist
> power there."_ [Trotsky, **Op. Cit.** ]

As part of this support for anarchist theory, the Makhnovists organised
insurgent, peasant and worker conferences to discuss key issues in the
revolution and the activities of the Makhno movement itself. Three such
conferences had been before Trotsky wrote his diatribe **The Makhno Movement**
on June 2nd, 1919. A fourth one was called for June 15th, which Trotsky
promptly banned (on pain of death) on June 4th (see [section
13](append46.md#app13) for full details). Unlike the Bolshevik dictatorship,
the Makhnovists took every possibility of ensuring the participation of the
working people they were fighting for in the revolution. The calling of
congresses by the Makhnovists shows clearly that the movement did not, as
Trotsky asserted, follow a man, but rather ideas.

As Voline argued, _"the movement would have existed without Makhno, since the
living forces, the living masses who created and developed the movement, and
who brought Makhno forward merely as their talented military leader, would
have existed without Makhno."_ Ultimately, the term _"Makhnovshchina"_ is used
_"to describe a unique, completely original and independent revolutionary
movement of the working class which gradually becomes conscious of itself and
steps out on the broad arena of historical activity."_ [ _"preface,"_
Arshinov, **Op. Cit.** , p. 19]

## 3 Why was Makhno called _"Batko"_?

Nestor Makhno was often called in the movement _"Batko"_ , which is Ukrainian
for _"father."_ Peter Arshinov explains how and in what circumstances Makhno
was given this name:

> _"It was . . . in September 1918, that Makhno received the nickname
> **Batko** \-- general leader of the revolutionary insurrection in the
> Ukraine. This took place in the following circumstances. Local
> **pomeshchiks** [landed gentry] in the major centres, the **kulaks** [rich
> peasants], and the German authorities [the Ukraine being occupied by them at
> the time], decided to eliminate Makhno and his detachment [of partisans] at
> any cost. The **pomeshchiks** created a special volunteer detachment
> consisting of their own sons and those of **kulaks** for the decisive
> struggle against Makhno. On the 30th of September this detachment, with the
> help of the Austro-Germans, corned Makhno in the region of Bol'shaya
> Mihhailovka, setting up strong military posts on all roads. At this time
> Makhno found himself with only 30 partisans and one machine gun. He was
> forced to make a fighting retreat, manoeuvring in the midst of numerous
> enemy forces. Arriving in the forest of Dibrivki, Makhno found himself in an
> extremely difficult situation. The paths of retreat were occupied by the
> enemy. It was impossible for the detachment to break through, and escaping
> individually was beneath their revolutionary dignity. No-one in the
> detachment would agree to abandon their leader so as to save himself. After
> some reflection, two days later, Makhno decided to return to the village of
> Bol'shaya Mikhailovka (Dibrivki). Leaving the forest the partisans met
> peasants who came to warn them that there were large enemy forces in
> Dibrivki and that they should make haste to go elsewhere. This information
> did not stop Makhno and his partisans . . . [and] they set out for Bol'shaya
> Mikhailovka. They approached the village guardedly. Makhno himself and a few
> of his comrades went on reconnaissance and saw a large enemy camp on the
> church square, dozens of machine guns, hundreds of saddle horses, and groups
> of cavalry. Peasants informed them that a battalion of Austrians and a
> special **pomeshchik** detachment were in the village. Retreat was
> impossible. Then Makhno, with his usual stubbornness and determination, said
> to his companions: 'Well, my friends! We should all be ready to die on this
> spot . . .' The movement was ominous, the men were firm and full of
> enthusiasm. All 30 saw only one path before them -- the path toward the
> enemy, who had about a thousand well-armed men, and they all realised that
> this meant certain death for them. All were moved, but none lost courage. _
>
> _"It was at this movement that one of the partisans, Shchus', turned to
> Makhno and said:_
>
> _"'From now on you will be **Batko** to all of us, and we vow to die with
> you in the ranks of the insurgents.' _
>
> _"Then the whole detachment swore never to abandon the insurgent ranks, and
> to consider Makhno the general **Batko** of the entire revolutionary
> insurrection. Then they prepared to attack. Shchus' with five to seven men
> was assigned to attack the flank of the enemy. Makhno with the others
> attacked from the front. With a ferocious 'Hurrah!' the partisans threw
> themselves headlong against the enemy, smiting the very centre with sabres,
> rifles and revolvers. The attack had a shattering effect. The enemy, who
> were expecting nothing of the kind, were bowled over and began to flee in
> panic, saving themselves in groups and individually, abandoning arms,
> machine guns and horses. Without leaving them time to come to themselves, to
> become aware of the number of attacking forces, and to pass to a counter-
> attack, the insurgents chased them in separate groups, cutting them down in
> full gallop. A part of the **pomeshchik** detachment fled to the Volchya
> River, where they were drowned by peasants who had joined the battle. The
> enemy's defeat was complete. _
>
> _"Local peasants and detachments of revolutionary insurgents came from all
> directions to triumphantly acclaim the heroes. They unanimously agreed to
> consider Makhno as **Batko** of the entire revolutionary insurrection in the
> Urkaine."_ [Arshinov, **Op. Cit.** , pp. 59-60]

This was how Makhno acquired the nickname _"Batko,"_ which stuck to him
thereafter.

It should be stressed that _"Batko"_ was a nickname and did not signify any
form of autocratic or hierarchical position within the movement:

> _"During the civil war, it signified the leadership and control of a
> specific area and its population in both civil and military fields. The
> central point of the use of the word, rather than 'leader' or 'dictator' is
> that the leadership is usually based on respect, as in Makhno's case, and
> always on intimate knowledge of the home territory."_ [Michael Malet, **Op.
> Cit.** , p. 17]

That this was a nickname can be seen from the fact that _"[a]fter 1920 he was
usually called 'Malyi' ('Shorty'), a nickname referring to his short stature,
which was introduced by chance by one of the insurgents."_ [Peter Arshinov,
**Op. Cit.** , p. 226] To attach significance to the fact that the peasants
called Makhno _"Batko"_ (as the Bolsheviks did) simply signifies an ignorance
of the Makhnovist movement and its social environment.

## 4 Can you give a short overview of the Makhnovist movement?

This section of the FAQ gives a short overview of the Makhnovists from July
1918 (when Makhno returned to the Ukraine) and August 1921, when it was
finally defeated by Bolshevik armed force. It will be primarily a military
history, with the socio-political aspects of the movement discussed in
sections [6](append46.md#app6) (its theory) and [7](append46.md#app7) (its
practice). For details of the rise of influence of Makhno after his release
from prison in 1917, see [section 1](append46.md#app1).

The history of the Makhno movement can be broken up into roughly four periods
-- from July 1918 to February 1919, then the rest of 1919, then January to
October 1920 and, finally, from October 1920 to August 1921. This section will
give an overview of each period in turn.

By the time Makhno arrived back in the Ukraine in July, 1918, opposition to
the German-backed Hetman's regime was mounting and was frequently met with
brutal repression, including reprisal executions. Makhno was forced to live
underground and on the move, secretly meeting with others, with the Austrians
always close behind. Voline recounts Makhno's activities at this time:

> _"Back in Hulyai Pole, Makhno came to the decision to die or obtain victory
> for the peasants . . . He did not delay starting his mission openly among
> the great masses of peasants, speaking at improvised meetings, writing and
> distributing letters and tracts. By pen and mouth, he called on the peasants
> for a decisive struggle against the power of Skoropadsky and the landlords.
> He declared tirelessly that the workers should now take their fates into
> their own hands and not let their freedom to act be taken from them . . ._
>
> _"Besides his appeals, Makhno proceeded immediately to direct action. His
> first concern was to form a revolutionary military unit, sufficiently strong
> to guarantee freedom of propaganda and action in the villages and towns and
> at the same time to begin guerrilla operations. This unit was quickly
> organised .. . ._
>
> _"His first unit undertook two urgent tasks, namely, pursuing energetically
> the work of propaganda and organisation among the peasants and carrying out
> a stubborn armed struggle against all their enemies. The guiding principle
> of this merciless struggle was as follows. No lord who persecuted the
> peasants, no policeman of the Hetman, no Russian or German officer who was
> an implacable enemy of the peasants, deserved any pity; he must be
> destroyed. All who participated in the oppression of the poor peasants and
> workers, all who sought to suppress their rights, to exploit their labour,
> should be executed._
>
> _"Within two or three weeks, the unit had already become the terror, not
> only of the local bourgeoisie, but also of the Austro-German authorities."_
> [ **The Unknown Revolution** , p. 558]

The night of 26 September saw Hulyai Pole briefly liberated from Hetman and
Austrian troops by the actions of Makhno's troops in association with local
people. On the retreat from this Makhno's small band grew when he met the
partisan troops headed by Schus. When the Austrians cornered them, they
launched a surprise counter attack and routed the opposition. This became
known as the battle of Dibrivki and it is from this date, 5 October 1918 that
Makhno is given the nickname 'Batko', meaning _"father"_ (see [section
3](append46.md#app3) for details). For the next two months already- existing
partisan groups sought out and joined the growing army.

In this period, Makhno, with portable printing equipment, was raiding the
occupying garrisons and troop trains in the Southern Ukraine. Normal practice
was to execute the officers and free the troops. In this period the moral of
the occupying troops had crumbled and revolutionary propaganda had made
inroads into many units. This was also affecting the nationalist troops and on
20 November the first nationalist unit defected to the Makhnovists. This
encouraged them to return to Hulyai Pole on 27 December and there the
insurrectionary Staff was formed, this body was to lead the army in the coming
years and consisted initially of four old and trusted friends and three
political comrades. The Makhnovist presence allowed the setting up of a local
soviet and the re-opening of the anarchist clubs. German forces started
pulling back to the major cities and on December 14 the Hetman fled Kiyiv. In
the resulting vacuum, the Makhnovists rapidly expanded taking in most of the
South East Ukraine and setting up fronts against local whites. The Ukrainian
nationalists had taken power in the rest of the Ukraine under Petliura and on
the 15th December the Makhnovists agreed to make common cause with them
against the Whites. In return for arms and ammunition they allowed the
nationalists to mobilise in the Makhnovist area (while engaging in propaganda
directed at the mobilised troops on their way by train to Katerynoslav).

This was a temporary and pragmatic arrangement directed against the greater
enemy of the Whites. However, the nationalists were no friends of working-
class autonomy. The nationalists banned elections to the Katerynoslav soviet
on 6th of December and the provincial soviet at Kharkiv meet with a similar
fate on the 22nd. [Malet, **Op. Cit.** , p. 22] At the same time as their
agreement with the nationalists, the Makhnovista had set up links with
Bolshevik partisans to the south and before dawn on the 26th the Bolshevik and
Makhnovista forces launched a joint attack on the nationalists at
Katerynoslav. The city was taken but held only briefly when a nationalist
attack on the 29th drove out all the insurgent forces with heavy losses. In
the south, White reinforcements led to the insurgents being pushed North and
losing Hulyai Pole.

1919 opened with the Makhnovists organising a congress of front- unit
delegates to discuss the progress of the struggle. Over forty delegates
attended and a committee of five was elected, along with an operational staff
to take charge of the southern front and its rear. It was agreed that local
soviets were to be supported in every way, with no military violence directed
towards them permitted. [Malet, **Op. Cit.** , p. 25]

By the end of January, white reinforcements were landing in the ports of the
south. On January 22nd, a worker, peasant and insurgent congress was held at
Velyka Mykhailivka. A resolution was passed urging an end to conflict between
Makhnovists, Nationalists and Bolsheviks. An alliance was signed between the
Makhnovists and the Bolsheviks in early February. This agreement ensured that
the Partisan units entered the Red Army as distinct formations, with their
internal organisation (including the election of commanders) intact, and the
Red Army in the area formed a brigade to be known as _"the third Transdnieper
Batko Makhno brigade"_ with Makhno as commander. The Whites were repulsed and
Hulyai Pole retaken and the front pushed some distance eastwards.

Thus the military situation had improved by the time of the second worker,
peasant and insurgent congress held at Hulyai Pole on February 12th. This
congress set up a _"Revolutionary Military Soviet"_ to co-ordinate civilian
affairs and execute its decisions. The congress resolved that _"the land
belongs to nobody"_ and should be cultivated without the use of hired labour.
It also accepted a resolution opposing anti-Jewish pogroms. Also passed was a
resolution which sharply attacked the Bolsheviks, caused by their behaviour
since their arrival in the Ukraine. [Palij, **Op. Cit.** , pp. 154-5] A report
by the commander of the 2nd Red Army, Skatchco, indicates the nature of this
behaviour:

> _"Little local Chekas are undertaking a relentless campaign against the
> Makhnovists, even when they are shedding their blood at the front. They are
> hunting them down from the rear and persecuting them solely for belonging to
> the Makhnovist movement . . . It cannot continue like this: the activity of
> the local Chekas is deliberately ruining the front, reducing all military
> successes to nothing, and contributing to the creation of a counter-
> revolution that neither Denikin nor Krasnov [Hetman of the Don Cossacks]
> could have achieved. . ."_ [quoted by Alexander Skirda, **The Rehabilitation
> of Makhno** , p. 346]

Unsurprisingly, the peasants reacted strongly to the Bolshevik regime. Their
_"agricultural policy and terrorism"_ ensured that _"by the middle of 1919,
all peasants, rich and poor, distrusted the Bolsheviks."_ [Palij, **Op. Cit.**
, p. 156] In April alone, there were 93 separate armed rebellions against the
Bolsheviks in the Ukraine. The _"more oppressive the Bolshevik policy, the
more the peasants supported Makhno. Consequently, the Bolsheviks began to
organise more systematically against the Makhno movement, both as an ideology
and as a social movement."_ [Palij, **Op. Cit.** , p. 157]

In mid-March the Red Army attacked eastwards. In the course of this Dybenko,
commander of the Trandneiper division, recommended one of Makhno's commanders
for a medal. Then the Makhnovists attacked the Donbas (east) to relieve the
pressure on the Soviet 8th Army caused by a White advance. They took Mariupol
following a White incursion at the beginning of April. A White counter-
offensive resulted in the Red 9th division panicking, allowing the Whites into
Makhno's rear. Red Commander Dybenko refused orders to come to the Makhnovists
aid as he was more interested in the Crimea (south). [Malet, **Op. Cit.** , p.
31]

This period saw the most sustained freedom for the region around Hulyai Pole.
It had been free of enemy occupation since January, allowing constructive
activity to restart. The inhabitants of the free region _"created new forms of
social organisation: free workers' communes and Soviets."_ [Voline, **Op.
Cit.** , p. 574] The Revolutionary Military Soviet (RMS) called a third
regional worker, peasant and insurgent congresses had on April 10th to review
progress and to look forward. This was the largest congress to date, with
delegates from 72 volosts containing two million people. The Bolshevik
military commander Dybenko tried to ban it. The Makhnovists, needless to say,
ignored him and the RMS made a famous reply to his arrogance (see [section
13](append46.md#app13) for more details).

It was during this period (late 1918 and early 1919), that the **_Nabat_**
anarchist federation was organised. _"Anarchist influence was reported from
Aleksandrovsk and other centres,"_ notes David Footman, _"Anarchists were
holding a conference in Kursk at about the same time and in one of their
resolutions it was stated that 'the Ukrainian Revolution will have great
chances of rapidly becoming Anarchist in its ideas.' The position called for
renewed Bolshevik measures against the Anarchists. **Nabat** , the main
Anarchist newspaper in the Ukraine, was suppressed, and its editorial board
dispersed under threat of arrest."_ [ **Op. Cit.** , p. 270] Daniel Guerin has
reproduced two documents from the Nabat federation in volume II of his **No
Gods, No Masters**.

The anarchist influence in and around Hulyai Pole also worried the Bolsheviks.
They started a slander campaign against the Makhnovists, to the alarm of
Antonov, the overall front commander, who replied in response to an article in
Kharkiv Izvestiya:

> _"The article is the most perverted fiction and does not in the least
> correspond to the existing situation. The insurgents fighting the whites are
> on a level with the Red Army men, but are in a far worse condition for
> supplies."_ [quoted by Malet, **Op. Cit.** , p. 33]

In a postscript, Antonov added that the press campaign had certainly helped
turn Makhno anti-Soviet (i.e. anti-Bolshevik, as Makhno supported free
soviets).

At the beginning of May, another partisan commander, Hryhoriyiv, revolted
against the Bolsheviks in the central Ukraine. Hryhoriyiv, like the
Makhnovists, had joined with the Bolsheviks when they had re-entered the
Ukraine, however his social and political background was totally different.
Hryhoriyiv was a former Tsarist officer, who had commanded numerous troops
under the Petliurist authority and joined the Bolsheviks once that that
regime's armed forces had disintegrated. Arshinov notes that he had _"never
been a revolutionary"_ and that there had been a _"great deal of adventurism
in his joining the ranks of the Petliurists and then the ranks of the Red
Army."_ His temperament was mixed, consisting of _"a certain amount of
sympathy for oppressed peasants, authoritarianism, the extravagance of a
Cossack chieftain, nationalist sentiments and anti-Semitism."_ [ **Op. Cit.**
, p. 110]

Hryhoriyov started his revolt by issuing a Universal, or declaration to the
Ukrainian people, which contained a virulent attack on the Bolsheviks as well
as one explicit anti-Semitic reference, but without mention of Makhno. The
height of the revolt was his appearance in the suburbs of Katerynoslav, which
he was stopped from taking. He started a pogrom in Yelyzavethrad which claimed
three thousand victims.

Once the Makhnovists had been informed of this rebellion, an enlarged staff
and RMS meeting was held. A telegram was sent to the soldiers at the front
urging them to hold the front and another to the Bolsheviks with a similar
message. A few days latter, when more information had been received, a
proclamation was issued against Hyyhoriyiv attacking him for seeking to impose
a new authority on the working class, for encouraging toiling people to attack
each other, and for inciting pogroms. [Arshinov, **Op. Cit.** , p. 112 and pp.
114-7]

While it took a fortnight for Red forces to contain Hryhoriyiv without
trouble, this involved using all available reverses of all three Ukrainian
armies. This left none for Makhno's hard-pressed forces at the front. In
addition, Dybenko withdrew a front-line regiment from Makhno for use against
the revolt and diverted reinforcements from the Crimea which were intended for
Makhno. Despite this Makhnos forces (now numbering 20,000) were ordered to
resume the attack on the whites. This was due to _"unremitting pressure from
Moscow to take Taganrog and Rostov."_ [Malet, **Op. Cit.** , p. 36] The
Makhnovist advance stopped due to the non-fulfilment of an urgent order for
ammunition.

On the 19th of May, a White counter-attack not only stopped the advance of the
Red Army, it forced the 9th division (and then the Makhnovists) to retreat. On
the 29th, the Whites launched a further offensive against the northern
Donblas, opening a gap between the 13th and 8th Red Armies. Due to the gravity
of the situation, the RSV summoned a fourth congress for June 15th. Trotsky
not only banned this congress but took the lead in slandering the Makhnovists
and calling for their elimination (see [section 13](append46.md#app13) for
details). As well as _"this deliberately false agitational campaign, the
[Bolshevik] blockade of the region was carried to the limit . . . The
provisioning of shells, cartridges and other indispensable equipment which was
used by daily at the front, ceased completely."_ [Arshinov, **Op. Cit.** , p.
118] Palij confirms this, noting that _"the supplies of arms and other war
material to Makhno was stopped, thus weakening the Makhno forces vis-a-vis the
Denikin troops."_ [ **Op. Cit.** , p. 175] David Footman also notes that the
Bolshevik _"hold-back of supplies for the Insurgents developed into a blockade
of the area. Makhnovite units at the front ran short of ammunition."_ He also
mentions that _"[i]n the latter part of May the **Cheka** sent over two agents
to assassinate Makhno."_ [ **Civil War in Russia** , p. 271]

Needless to say, Trotsky blamed this White success to the Makhnovists, arguing
it was retreating constantly before even the slightest attack by the Whites.
However, this was not the case. Analysing these events in July 1919, Antonov
(the commander of the Southern Front before Trotsky replaced him) wrote:

> _"Above all, the facts witness that the affirmations about the weakness of
> the most contaminated region -- that from Hulyai Pole to Berdiansk -- are
> without foundation . . . It is not because we ourselves have been better
> organised militarily, but because those troops were directly defending their
> native place . . . Makhno stayed at the front, in spite of the flight of the
> neighbouring 9th division, following by the whole of the 13th army . . . The
> reasons for the defeat on the southern front do not rest at all in the
> existence of 'Ukrainian partisans' . . . above all it must be attributed to
> the machinery of the southern front, in not keeping its fighting spirit and
> reinforcing its revolutionary discipline."_ [quoted by Alexander Skirda,
> **The Rehabilitation of Makhno** , p. 348]

This, incidentally, tallies with Arshinov's account that _"hordes of Cossacks
had overrun the region, **not through the insurrectionary front but from the
left flank where the Red Army was stationed.** "_ [ **Op. Cit.** , p. 126] For
what it is worth, General Denikin himself concurs with this account of events,
noting that by the 4th of June his forces _"repulsed the routed and
demoralised contingents of the Eight and Thirteenth Soviet Armies . . . The
resistance of the Thirteenth Army being completely broken."_ He notes that an
attempt by the Fourteenth Army (which Makhno's troops were part of) to attack
on the flank came to nothing. He only mentions Makhno when he recounts that
_"General Shkuro's division routed Makhno at Hulyai Pole."_ [ **The White
Armies** , p. 272] With Whites broken through on their flank and with limited
ammunition and other supplies (thanks to the Bolsheviks), the Makhnovists had
no choice but to retreat.

It was around this time that Trotsky, in a public meeting in Kharkov,
_"announced that it were better to permit the Whites to remain in the Ukraine
than to suffer Makhno. The presence of the Whites, he said, would influence
the Ukrainian peasantry in favour of the Soviet Government, whereas Makhno and
his **povstantsi** , would never make peace with the Bolsheviki; they would
attempt to possess themselves of some territory and to practise their ideas,
which would be a constant menace to the Communist Government."_ [Emma Goldman,
**My Disillusionment in Russia** , p. 63]

Due to this Bolshevik betrayal, the Makhnovist sector was in very grave
danger. At Hulyai Pole, a peasant regiment was scraped together in 24 hours in
an attempt to save the town. It encountered White Cossacks ten miles away from
the town and was mown down. The Whites entered Hulyai Pole the next day (June
6th) and gave it a good going over. On the same day, the Bolsheviks issued an
order for Makhno's arrest. Makhno was warned and put in his resignation,
arguing that it was _"an inviolable right of the workers and peasants, a right
won by the revolution, to call congresses on their own account, to discuss
their affairs."_ Combined with the _"hostile attitude"_ of the Bolshevik
authorities towards him, which would lead _"unavoidably to the creation of a
special internal front,"_ Makhno believed it was his duty to do what he could
to avert it, and so he left his post. [quoted by Arshinov, **Op. Cit.** , p.
129] While Makhno escaped, his staff was not so lucky. Five of them were
arrested the same day and shot as a result of Trotsky's order to ban the
fourth congress.

Leaving his troops in the frontline, Makhno left with a small cavalry
detachment. While leaving the rest under Red command, Makhno made a secret
agreement with his regimental commanders to await a message from him to leave
the Red Army and join up against with the partisans. On the 9th and 10th of
June, Hulyai Pole was retaken by Bolshevik forces, who took the opportunity to
attack and sack the Makhnovist communes. [Arshinov, **Op. Cit.** , p. 86f]

After intense fighting, the Whites finally split the Southern Front into three
on June 21st. Needless to say, Trotsky and the Bolsheviks blamed this on the
partisan forces (even stating that they had _"opened the front"_ to the
Whites). This was nonsense, as noted above.

After leaving the front, Makhno took refuge in the Chorno-Znamenski forest
before continuing the retreat north and skirmishing with Red Army units. This
brought him into the territory held by Hryhoriyiv and this, in turn, meant
they had to proceed carefully. While the Makhnovists had made a public
denunciation of Hryhoriyiv, Makhno was approaching the centre of Hryhoriyov's
remaining influence. Surrounded by enemies, Makhno had little choice but to
begin discussions with Hryhoriyiv. This was problematic to say the least.
Hryhoriyiv's revolt had been tinged with anti-Semitism and had seen at least
one major pogrom. Being faced with Hryhoriyov's anti-Semitism and his proposal
for an alliance with the Whites against the Reds led the Makhnovists to plot
his downfall at a meeting planned for the 27th July.

This meeting had originally been called to discuss the current tasks of the
insurgents in the Ukraine and was attended by nearly 20,000 insurgents and
local peasants. Hryhoriyiv spoke first, arguing that the most urgent task was
to chase out the Bolsheviks and that they should ally themselves with any
anti-Red forces available (a clear reference to the Whites under Denikin). The
Makhnovist Chubenko spoke next, declaring that the _"struggle against the
Bolsheviks could be revolutionary only if it were carried out in the name of
the social revolution. An alliance with the worst enemies of the people --
with generals -- could only be a counter-revolutionary and criminal
adventure."_ Following him, Makhno _"demanded before the entire congress"_
that Hryhoriyiv _"immediately answer for the appalling pogrom of Jews he had
organised in Elisavetgrad in May, 1919, as well as other anti-Semitic
actions."_ [Arshinov, **Op. Cit.** , p. 136]

Seeing that things were going badly, Hryhoriyiv went for his revolver, but was
shot by a Makhnovist. Makhno finished him off. Makhnovist guards disarmed the
leading Hryhoriyivists. Then Makhno, Chubenko and others justified the killing
before the mass meeting, which approved the act passing a resolution that
stated that Hryhoriyiv's death was _"an historical and necessary fact, for his
policy, acts and aims were counter-revolutionary and mainly directed to
helping Denikin and other counter-revolutionaries, as is proved by his Jewish
pogroms."_ [quoted by Malet, **Op. Cit.** , p. 42] The troops under Hryhoriyiv
became part of the general Insurrectionary Army.

At the end of July, Makhno recalled the troops he had earlier left in the Red
Army and by mid-August the forces met up, becoming an army of some 15,000. At
Mykolaiv, the Red Army units were defecting to Makhno in large numbers due in
part to the feeling that the Red Army were abandoning the defence of the
Ukraine. This was the start of Denikin's massive push north and Petliura's
push east. By the end of August, Makhno felt strong enough to go on the
offensive against the Whites. Superior White forces pushed the Makhnovists
further and further west, away from their home region. _"Denikin,"_ in
Voline's words, _"not only made war on the army as such, but also on the whole
peasant population. In addition to the usual persecutions and beatings, the
villages he occupied were burnt and wrecked. The greater part of the peasants'
dwellings were looted and wrecked. Hundreds of peasants were shot. The women
maltreated, and nearly all the Jewish women . . . were raped."_ This
repression _"obliged the inhabitants of the villages threatened by the
approach of the Denikinists to abandon their hearths and flee. Thus the
Makhnovist army was joined and followed in their retreat by thousands of
peaant families in flight from their homes with their livestock and
belongings. It was a veritable migration. An enormous mass of men, women and
children trailed after the army in its slow retreat towards the west, a
retreat which gradually extended over hundreds of kilometres."_ [ **Op. Cit.**
, p. 607]

Meeting the Nationalists in mid-September, it was agreed on both sides that
fighting would only aid the Whites and so the Makhnovists entered a non-
aggression pact with Petliura. This enabled them to offload over 1,000
wounded. The Makhnovists continued their propaganda campaign against the
Nationalists, however. By the 24th of September, intelligence reports
suggested that White forces had appeared to the west of their current position
(i.e. where the Nationalists where). The Makhnovists concluded that the only
way this could have happened was if the Nationalists had allowed the Whites to
cross their territory (the Nationalists disputed this, pointing to the
fighting that had started two days before between them and the Whites).

This meant that the Makhnovists were forced to fight the numerically superior
Whites. After two days of desperate fighting, the Whites were routed and two
regiments were destroyed at the battle of Peregonovka village. Makhno's forces
then conducted an incredibly rapid advance in three directions helped by their
mobile cart-transported infantry, in three days smashing three reserve
regiments and at the greatest point advancing 235 miles east. On the 6th
October a drive to the south started which took key White ports and captured a
huge quantity of equipment including 600 trucks of British-supplied ammunition
and an aeroplane. This was disastrous for Denikin whose forces had reached the
northernmost point on their advance on Moscow, for these ports were key for
his supply routes. The advance continued, cutting the railway route and so
stopping all shells reaching Denikin's Moscow front.

Denikin was forced to send some of his best troops from the Moscow front to
drive back the Makhnovists and British boats were sent to towns on the coast
where Makhno might retreat through. The key city of Katerinoslav was taken
with the aid of a workers' uprising on November 9th and held for a month
before the advancing Whites and a typhoid epidemic which was to devastate the
Makhnovista ranks by the end of the year forced them out of the city. In
December, the Red Army advance made possible by Makhno's devastation of
Denikin's supply lines continued.

Thus Voline:

> _"It is necessary to emphasise here the historic fact that the honour of
> having annihilated the Denikinist counter-revolution in the autumn of 1919,
> belongs entirely to the Makhnovist Insurrectionary Army. If the insurgents
> had not won the decisive victory of Peregonovka, and had not continued to
> sap the bases in Denikin's rear, destroying his supply service for
> artillery, food and ammunition, the Whites would probably have entered
> Moscow in December 1919 at the latest."_ [ **Op. Cit.** , p. 625]

In December the Red Army advance made possible by Makhno's devastation of
Denikin's supply lines continued. By early January the Reds had split White
forces into three and their troops had reached Katerynoslav. The attitude of
the Bolsheviks to the Makhnovists had already been decided. On December 12th,
1919, Trotsky stated that when the two forces met, the Bolsheviks had _"an
order . . . from which we must not retreat one single step."_ While we discuss
this secret order in more depth in [section 13](append46.md#app13), we will
note here that it gave partisans the option of becoming _"fully subordinate to
[Bolshevik] command"_ or _"be subjected to ruthless punishment."_ [ **How the
Revolution Armed** , vol. II., pp. 110-1 and p. 442] Another secret order to
the 45th division issued on January 4th instructed them to _"annihilate
Makhnovist bands"_ and _"disarm the population."_ The 41st was sent _"into
reserve"_ to the Hulyai Pole region. This was _"five days before Makhno was
outlawed, and shows that the Bolshevik command had a clear view of Makhno's
future, even if the latter did not."_ [Malet, **Op. Cit.** , p. 54]

Unaware of this, the Makhnovista put out propaganda leaflets directed at the
Red Army rank and file, appealing to them as comrades. At Aleksandrovsk on
December 5th talks occurred between a representative of the Makhnovists and
the commander of the 45th division's 1st brigade. These broke down when Makhno
was ordered to the Polish front, which the Makhnovists refused. On January
9th, Yegorov, commander of the Red Army southern front, used this pretext to
outlaw Makhno. This outlawing was engineered deliberately by the Bolsheviks:

> _"The author of the order realised at that time there was no real war
> between the Poles and the Bolsheviks at that time and he also knew that
> Makhno would not abandon his region .. . . Uborevich [the author] explained
> that 'an appropriate reaction by Makhno to this order would give us the
> chance to have accurate grounds for our next steps' . . . [He] concluded:
> 'The order is a certain political manoeuvre and, at the very least, we
> expect positive results from Makhno's realisation of this.'"_ [Palij, **Op.
> Cit.** , p. 210]

In addition, war with Poland did not break out until the end of April, over
three months later.

Needless to say, the Makhnovists **did** realise the political motivations
behind the order. As Arshinov notes, _"[s]ending the insurrectionary army to
the Polish front meant removing from the Ukraine the main nerve centre of the
revolutionary insurrection. This was precisely what the Bolsheviks wanted:
they would then be absolute masters of the rebellious region, and the
Makhnovists were perfectly aware of this."_ Moreover, the Makhnovists
considered the move _"physically impossible"_ as _"half the men, the entire
staff and the commander himself were in hospital with typhus."_ [ **Op. Cit.**
, p. 163]

This was the signal for nine months of bitter fighting between the Red Army
and the Makhnovists. Military events in this period are confused, with the Red
Army claiming victory again and again, only for the Makhnovists to appear
somewhere else. Hulyai Pole changed hands on a couple of occasions. The
Bolsheviks did not use local troops in this campaign, due to fear of
fraternisation. In addition, they used _"new tactics,"_ and _"attacked not
only Makhno's partisans, but also the villages and towns in which the
population was sympathetic toward Makhno. They shot ordinary soldiers as well
as their commanders, destroying their houses, confiscating their properties
and persecuting their families. Moreover the Bolsheviks conducted mass arrests
of innocent peasants who were suspected of collaborating in some way with the
partisans. It is impossible to determine the casualties involved."_ They also
set up _"Committees of the Poor"_ as part of the Bolshevik administrative
apparatus, which acted as _"informers helping the Bolshevik secret police in
its persecution of the partisans, their families and supporters, even to the
extent of hunting down and executing wounded partisans."_ [Palij, **Op. Cit.**
, pp. 212-3]

In addition to this suffering, the Bolshevik decision to attack Makhno rather
than push into the Crimea was also to prolong the civil war by nine more
months. The Whites re-organised themselves under General Wrangel, who began a
limited offensive in June. Indeed, the Bolshevik _"policy of terror and
exploitation turned almost all segments of Ukrainian society against the
Bolsheviks, substantially strengthened the Makhno movement, and consequently
facilitated the advance of the reorganised anti-Bolshevik force of General
Wrangel from the Crimea into South Ukraine, the Makhno region."_ [Palij, **Op.
Cit.** , p. 214]

It was widely believed on the White side that Makhno was ready to co-operate
with them and, desperate for men, Wrangel decided to appeal to the Makhnovists
for an alliance. Their response was simple and direct, they decided to
immediately execute his delegate and publish both his letter and a response in
the Makhnovist paper _"The Road to Freedom."_ [Malet, **Op. Cit.** , p. 60] Of
course, this did not stop the Bolsheviks later claiming such an alliance
existed!

Ironically enough, at a general assembly of insurgents, it was decided that
_"the destruction of Wrangel"_ would _"eliminate a threat to the revolution"_
and so free _"all of Russia"_ from _"the counter-revolutionary barrage."_ The
mass of workers and peasants _"urgently needed an end to all those wars"_ and
so they proposed _"to the Communists that hostilities between them and the
Makhnovists be suspended in order that they might wipe out Wrangel. In July
and August, 1920, telegrams to this effect were sent to Moscow and Kharkov."_
There was no reply and the Bolsheviks _"continued their war against the
Makhnovists, and they also continued their previous campaign of lies and
calumnies against them."_ [Arshinov, **Op. Cit.** , p. 176]

In July and August the Makhnovists went on the offensive, raiding the
Bolsheviks in three provinces and attacking the Red Army infrastructure.
Wrangel began another offensive in September, driving the Red Army back again
and again and threatening the Makhnovist area. Faced with Wrangel's success,
the Bolsheviks started to rethink their position on Makhno, although on the
24th of September the Bolshevik commander-in-chief Kamenev was still declaring
the need for _"the final liquidation of the Makhno band."_ [Malet, **Op.
Cit.** , p. 62] A few days later, the Bolsheviks changed their mind and
negotiations began.

So, by October 1920, the success of the Wrangel offensive was again forcing
the Bolsheviks and Makhnovists to put aside their differences and take on the
common enemy. A deal was reached and on October 2nd, Frunze, the new Red Army
commander of the Southern Front, ordered a cessation of hostilities against
the Makhnovists. A statement from the Soviet of the Revolutionary Insurgent
Army of the Ukraine (Makhnovists) explained the treaty as necessitated by the
White offensive but also representing a victory over the _"high-handed
communists and commissars"_ in forcing them to recognise the _"free
insurrection."_ [Malet, **Op. Cit.** , p. 64]

The agreement was signed between October 10th and 15th. It consisted of two
parts, a Political and a Military agreement (see [section
13](append46.md#app13) for full details). The Political agreement simply
gave the Makhnovists and anarchists the rights they should have had according
to the Soviet Constitution. The Military agreement resulted in the Makhnovists
becoming part of the Red Army, keeping their established internal structure
and, significantly, stopped them from accepting into their ranks any Red Army
detachments or deserters therefrom. According to Bolshevik sources, _"there
was never the slightest intention on the Bolshevik side of keeping to the
agreement once its military value had passed."_ [David Footman, **Op. Cit.** ,
p. 296]

Even before the agreement came into effect, the Makhnovists were fighting
alongside the Bolsheviks and between October 4 and 17, Hulyai Pole was retaken
by the Aleksandrovsk group, which included 10,000 Makhnovista. On October 22,
Aleksandrovsk was taken with 4,000 white prisoners and from then to early
November the Makhnovists cut through Wrangel's rear, hoping to cut off his
retreat by seizing the Crimean passes. The Whites fought a skilful rearguard
which together with the new White fortifications on the peninsula held up the
advance. But by the 11th, his hold in the Crimea gone, Wrangel had no choice
but to order a general retreat to the ports and an evacuation. Even the
Bolsheviks had to acknowledge that the _"Makhnovist units fulfilled their
military tasks with no less heroism than the Red Army units."_ [quoted by
Malet, **Op. Cit.** , p. 69]

On hearing this success on 16th November, the reaction of the Makhnovista
still at Hulyai Pole was cynical but realistic: _"It's the end of the
agreement. I'll bet you anything that the Bolsheviks will be on us within the
week."_ [quoted by Malet, **Op. Cit.** , p. 70] They were not wrong. Already
Frunze, the Red Army commander, had ordered two entire cavalry armies to
concentrate near Hulyai Pole at the same time as he ordered the Makhnovist
forces to the Caucasus Front! By 24th November Frunze was preparing for the
treachery to come, in Order 00149 (which was not sent to the Makhnovist units)
saying if they had not departed to the Caucasus front by the 26th _"the Red
regiments of the front, who have now finished with Wrangel, will start
speaking a different language to these Makhnovist youths."_ [quoted by Malet,
**Op. Cit.** , p. 71]

Of course this treachery went right to the top, just before the 26th
_"deadline"_ (which Makhno, not having seen the orders, was unaware of), Lenin
urged Rakovski, head of the Ukrainian government to _"[k]eep a close watch on
all anarchists and prepare documents of a criminal nature as soon as possible,
on the basis of which charges can be preferred against them."_ [quoted by
Malet, **Op. Cit.** , p. 71] Indeed, it later appeared the treachery had been
prepared from at least 14th or 16th November, as prisoners captured later
stated they had received undated anti-Makhnovist proclamations on that date.
[Malet, **Ibid.** ]

At 3am on the 26th the attacks on the Makhnovists started. Alongside this one
of the Makhnovist commanders was lured to a meeting by the Bolsheviks, seized
and shot. Some Makhnovist forces managed to break through the encircling
Bolsheviks but only after taking heavy losses -- of the 2,000-4,000 cavalry at
Simferopol, only 250 escaped. By the 1st December, Rakovsi reported the
imminent demise of the Makhnovists to the Kharkiv soviet only to have to eat
his words when Makhno routed the 42nd division on the 6th, retaking Hulyai
Pole and 6,000 prisoners, of whom 2,000 joined his forces. [Malet, **Op.
Cit.** , p. 72] Simultaneously with the attack on the Makhnovists, the
Bolsheviks rounded up all known anarchists in the Ukraine (many of whom were
in Kharkiv waiting for a legally organised **Nabat** conference to begin).

In the resulting struggle between the two forces, as Palij notes, the
_"support of the population was a significant advantage to Makhno, for they
supplied the partisans with needed material, including horses and food, while
the Red troops operated among a foreign and hostile people."_ The Bolsheviks
found that the peasants not only refused to supply them with goods, they also
refused to answer their questions or, at best, gave answers which were vague
and confusing. _"In contrast to the Bolsheviks, Makhno partisans received
detailed, accurate information from the population at all times."_ [Palij,
**Op. Cit.** , pp. 236-7]

Frunze brought in extra forces and ordered both the _"annihilation of the
Makhnovists"_ and total disarming of the region. Plagued by desertions, it was
also ordered that all Makhnovist prisoners were to be shot, to discourage the
local population and Red Army soldiers thinking of joining them. There is also
evidence of unrest in the Azov fleet, with acts of sabotage being carried out
by sailors to prevent their weapons being used against the Makhnovists.
[Malet, **Op. Cit.** , p. 73] While it was common practice for the Bolsheviks
to shoot all Makhnovist prisoners, the _"existence of roundup detachments at
the end of 1920, whose task was to re-collect prisoners freed by the
Makhnovists"_ shows that the Makhnovists did not reciprocate in kind. [Malet
**Op. Cit.** , p. 129]

At the end of 1920, the Makhnovists had ten to fifteen thousand troops and the
_"growing strength of the Makhno army and its successes caused serious concern
in the Bolshevik regime, so it was decided to increase the number of troops
opposing Makhno."_ [Palij, **Op. Cit.** , p. 237] All the pressure exerted by
the Bolsheviks was paying off. Although Makhno repeatedly broke through
numerous mass encirclements and picked up deserters from the Red Army, his
forces were being eroded by the far greater numbers employed against them. In
addition, _"the Red command worked out new plans to fight Makhno by stationing
whole regiments, primarily cavalry, in the occupied villages, to terrorise the
peasants and prevent them from supporting Makhno. . . Also the Cheka punitive
units were constantly trailing the partisans, executing Makhno's sympathisers
and the partisans' families."_ [Palij, **Op. Cit.** , p. 238] In spite of the
difficult conditions, Makhno was still able to attract some Red Army soldiers
and even whole units to his side. For example, _"when the partisans were
fighting Budenny's Fourth Cavalry Division, their First Brigade, commanded by
Maslak, joined Makhno."_ [Palij, **Op. Cit.** , p. 239]

Makhno was forced to leave his home areas of operations and flee east, then
west again. By early January his forces had fought 24 battles in 24 days. This
pattern continued throughout March and April into May. In June, the Bolsheviks
changed their strategy to one of predicting where Makhno was heading and
garrisoning troops in that area. In one battle on 15 June, Frunze himself was
almost captured. Despite this, the insurgents were very weak and their peasant
base was exhausted by years of war and civil war. In the most sympathetic
areas, Red Army troops were garrisoned on the peasants. Thus Palij:

> _"[T]hrough combat losses, hardship, and sickness, the number of Makhno
> partisans was diminishing and they were cut off from their main sources of
> recruits and supplies. The Ukrainian peasants were tried of the endless
> terror caused by successive occupation of village after village by the Red
> troops and the Cheka. The continuous fighting and requisitions were leaving
> the peasants with little food and horses for the partisans. They could not
> live in a state of permanent revolution. Moreover, there was extreme drought
> and consequently a bad harvest in Ukraine, especially in the region of the
> Makhno movement."_ [ **Op. Cit.** , pp. 240-1]

The state terrorism and the summer drought caused Makhno to give up the
struggle in mid-August and instead fight his way to the Dniester with the last
of his forces and cross into Romania on August 26. Some of his forces which
stayed behind were still active for a short time. In November 1921 the Cheka
seized 20 machine guns and 2,833 rifles in the new Zaporizhya province alone.

For more details of the history of the movement, Michael Malet's **Nestor
Makhno in the Russian Revolution** is an excellent summary. Michael Palij's
**The Anarchism of Nestor Makhno** is also worth consulting, as are the
anarchist histories of Voline and Arshinov.

## 5 How were the Makhnovists organised?

Being influenced by anarchist ideas, the Makhnovists were organised along
libertarian lines. This meant that in both civilian and military areas, self-
management was practised. This section discusses the military organisation,
while the next discusses the social aspect of the movement.

By practising self-management, the Makhnovists offered a completely different
model of military organisation to that of both the Red Army and traditional
military forces. While the army structure changed depending on its
circumstances, the core ideas remained. These were as follows:

> _"The Makhnovist insurrectionary army was organised according to three
> fundamental principles: voluntary enlistment, the electoral principle, and
> self-discipline._
>
> _" **Voluntary enlistment** meant that the army was composed only of
> revolutionary fighters who entered it of their own free will. _
>
> _" **The electoral principle** meant that the commanders of all units of the
> army, including the staff, as well as all the men who held other positions
> in the army, were either elected or accepted by the insurgents of the unit
> in question or by the whole army. _
>
> _" **Self-discipline** meant that all the rules of discipline were drawn up
> by commissions of insurgents, then approved by general assemblies of the
> various units; once approved, they were rigorously observed on the
> individual responsibility of each insurgent and each commander."_ [ **Op.
> Cit.** , p. 96]

Voline paints a similar picture. He also notes that the electoral principle
was sometimes violated and commanders appointed _"in urgent situations by the
commander himself,"_ although such people had to be _"accepted without
reservation"_ by _"the insurgents of the unit in question or by the whole
army."_ [ **Op. Cit.** , p. 584]

Thus the Makhnovist army, bar some deviation provoked by circumstances, was a
fundamentally democratic organisation. The guerrillas elected the officers of
their detachments, and, at mass assemblies and congresses, decided policy and
discipline for the army. In the words of historian Michael Palij:

> _"As the Makhno army gradually grew, it assumed a more regular army
> organisation. Each tactical unit was composed of three subordinate units: a
> division consisted of three brigades; a brigade, of three regiments; a
> regiment, of three battalions. Theoretically commanders were elected; in
> practice, however, the top commanders were usually carefully selected by
> Makhno from among his close friends. As a rule, they were all equal and if
> several units fought together the top commanders commanded jointly. The army
> was nominally headed by a Revolutionary Military Council of about ten to
> twenty members . . . Like the commanders, the council members were elected,
> but some were appointed by Makhno .. . . There also was an elected cultural
> section in the army. Its aim was to conduct political and ideological
> propaganda among the partisans and peasants."_ [Palij, **Op. Cit.** , pp.
> 108-9]

The Revolutionary Military Council was elected and directly accountable to the
regional workers, peasants and insurgent congresses. It was designed to co-
ordinate the local soviets and execute the decisions of the regional
congresses.

Hence Voline:

> _"This council embraced the whole free region. It was supposed to carry out
> all the economic, political, social and military decisions made at the
> congress. It was thus, in a certain sense, the supreme executive of the
> whole movement. **But it was not at all an authoritarian organ.** Only
> strictly executive functions were assigned to it. It confined itself to
> carrying out the instructions and decisions of the congress. At any moment,
> it could be dissolved by the congress and cease to exist."_ [ **Op. Cit.** ,
> p. 577]

As such, when Palij notes that this council _"had no decisive voice in the
army's actions,"_ he misses the point of the council. [Palij, **Ibid.** ] It
did not determine the military affairs of the army, but rather the interaction
of the military and civilians and made sure that the decisions of congresses
were executed. Thus the whole army was nominally under the control of the
regional congresses of workers, peasants and insurgents. At these congresses,
delegates of the toiling people decided upon the policy to be pursued by the
Makhnovist Army. The Revolutionary Military Soviet existed to oversee that
decisions were implemented, not to determine the military activities of the
troops.

It should also be noted that women not only supported the Makhnovists, they
also _"fought alongside the men."_ [Arshinov, **Op. Cit.** , p. 145] However,
_"the participation of women in the movement (by all accounts, quite
substantial)"_ needs _"further investigation."_ [Serge Cipko, _"Nestor Makhno:
A Mini-Historiography of the Anarchist Revolution in Ukraine, 1917-1921,"_ pp.
57-75, **The Raven** , no. 13, p. 75]

At its height, the army was made up of infantry, cavalry, artillery, machine-
gun units, and special branches, including an intelligence service. As the
success of partisan warfare depends upon mobility, the army gradually mounted
its infantry in light carts (called _"tachanka"_ ) during 1918-19. As Michael
Malet notes, this was a _"novel tactic"_ and Makhno _"could be described as
the inventor of the motorised division before the car came into general use."_
[ **Op. Cit.** , p. 85] The tachanka was used to transport as many troops as
possible, giving the Makhnovists mobile infantry which could keep up with the
cavalry. In addition, a machine-gun was sometimes mounted in the rear (in
autumn 1919, the 1st machine-gun regiment consisted of 120 guns, all mounted
on tachanki).

For the most part the Makhnovist army was a volunteer army, unlike all others
operating in the Russian Civil War. However, at times of crisis attempts were
made to mobilise troops. For example, the Second regional congress agreed that
a _"general voluntary and equalitarian mobilisation"_ should take place. This
meant that this appeal, _"sanctioned by the moral authority of the congress,
emphasised the need for fresh troops in the insurrectionary army, no-one was
compelled to enlist."_ [Voline, **Op. Cit.** , p. 577] The Congress itself
passed a resolution after a long and passionate debate that stated it
_"rejected 'compulsory' mobilisation, opting for an 'obligatory' one; that is,
each peasant who is able to carry arms, should recognise his obligation to
enlist in the ranks of the partisans and to defend the interests of the entire
toiling people of Ukraine."_ [quoted by Palij, **Op. Cit.** , p. 155] There
were far more volunteers than arms, the opposite of what occurred to both the
Reds and Whites during the Civil War. [Malet, **Op. Cit.** , p. 106]

The third Congress decided to conduct a voluntary mobilisation all those born
between 1889 and 1898. This congress told them to assemble at certain points,
organise themselves and elect their officers. Another mobilisation decided at
the Aleksandrovsk congress never took place. How far the Makhnovists were
forced to conscript troops is still a matter of debate. Paul Avrich, for
example, states that _"voluntary mobilisation"_ in reality _"meant outright
conscription, as all able-bodied men were required to serve."_ [ **Op. Cit.**
, p. 114] On the other side, surviving leaflets from 1920 _"are in the nature
of appeals to join up, not instructions."_ [Malet, **Op. Cit.** , p. 105]
Trotsky, ironically, noted that _"Makhno does not have general mobilisations,
and indeed these would be impossible, as he lacks the necessary apparatus."_
[quoted by Malet, **Op. Cit.** , p. 106] It is probably right to say that the
Congresses desired that every able-bodied man join the Makhnovist army, but
they simply did not have the means to enforce that desire and that the
Makhnovists tried their best to avoid conscription by appealing to the
peasants' revolutionary conscience, with some success.

As well as the military organisation, there was also an explicitly anarchist
federation operating in the Ukraine at the same time. The first conference to
organise a _"Confederation of Anarchist Organisations of the Ukraine"_ was
held between November 12th to 16th, 1918. The new federation was named
_"Nabat"_ (Alarm) and had a six-person Secretariat. Kharkiv was chosen as its
headquarters, while it had groups in other major Ukrainian cities (including
Kyiv, Odessa and Katerynoslav). The final organisation of the Nabat was
accomplished at a conference held in April 2-7, 1919. The federation aimed to
form a _"united anarchism"_ and guaranteed a substantial degree of autonomy
for every participating group and individual. A number of newspapers appeared
in a Ukrainian towns and cities (mostly entitled **Nabat** ), as did leaflets
and pamphlets. There was a main weekly paper (called **Nabat** ) which was
concerned largely with anarchist theory. This completed the Makhnovist papers
**Road to Freedom** (which was often daily, sometimes weekly and dealt with
libertarian ideas, everyday problems and information on partisan activities)
and **The Makhnovist Voice** (which dealt primarily with the interests,
problems, and tasks of the Makhnovist movement and its army). The Nabat
organisation was also published a pamphlet dealing with the Makhnovist
movement's problems, the economic organisation of the region, the free
soviets, the social basis of the society that was to be built, and the problem
of defence.

Unsurprisingly, the Nabat federation and the Makhnovists worked together
closely, with Nabat members worked in the army (particularly its cultural
section). Some of its members were also elected to the Makhnovist
Revolutionary Military Soviet. It should be noted that the Nabat federation
gained a number of experienced anarchists from Soviet Russia, who fled to the
Ukraine to escape Bolshevik repression. The Nabat shared the fortunes of the
Makhno movement. It carried on its work freely as long as the region was
controlled by the Makhnovist Army, but when Bolshevik or White forces
prevailed, the anarchists were forced underground. The movement was finally
crushed in November 1920, when the Bolsheviks betrayed the Makhnovists.

As can be seen, the Makhnovists implemented to a large degree the anarchist
idea of self-managed, horizontally federated associations (when possible, of
course). Both the two major organisational layers to the Makhnovist structure
(the army and the congresses) were federated horizontally and the "top"
structure was essentially a mass peasant, worker and guerrilla decision-making
coalition. In other words, the masses took decisions at the "top" level that
the Revolutionary Military Soviet and the Makhnovist army were bound to
follow. The army was answerable to the local Soviets and to the congresses of
soviets and, as we discuss in [section 7](append46.md#app7), the Makhnovists
called working-people and insurgent congresses whenever they could.

The Makhnovist movement was, fundamentally, a working class movement. It was
_"one of the very few revolutionary movements to be led and controlled
throughout by members of 'the toiling masses.'"_ [David Footman, **Op. Cit.**
, p. 245] It applied its principles of working class autonomy and self-
organisation as far as it could. Unlike the Red Army, it was predominantly
organised from the bottom up, rejecting the use of Tsarist officers, appointed
commanders, and other "top-down" ways of the Red Army (see [section
14](append46.md#app14) for further discussion of the differences between the
two forces).

The Makhnovist army was not by any means a perfect model of anarchist military
organisation. However, compared to the Red Army, its violations of principle
are small and hardly detract from their accomplishment of applying anarchist
ideas in often extremely difficult circumstances.

## 6 Did the Makhnovists have a constructive social programme?

Yes, they did. The Makhnovists spent a great deal of energy and effort in
developing, propagating and explaining their ideas on how a free society
should be created and run. As Michael Malet noted, the _"leading Makhnovists
had definite ideas about the ideal form of social organisation."_ [ **Nestor
Makhno in the Russian Civil War** , p. 107] Moreover, as we discuss in the
[next section](append46.md#app7), they also successfully applied these ideas
when and where they could.

So what was their social programme? Being anarchists, it comprised two parts,
namely political and economic aspects. The Makhnovists aimed for a true social
revolution in which the working classes (both urban and rural) could actively
manage their own affairs and society. As such, their social programme
reflected the fact that oppression has its roots in both political and
economic power and so aimed at eliminating both the state and private
property. As the core of their social ideas was the simple principle of
working-class autonomy, the idea that the liberation of working-class people
must be the task of the working-class people themselves. This vision is at the
heart of anarchism and was expressed most elegantly by Makhno:

> _"Conquer or die -- such is the dilemma that faces the Ukrainian peasants
> and workers at this historic moment . . . But we will not conquer in order
> to repeat the errors of the past years, the error of putting our fate into
> the hands of new masters; we will conquer in order to take our destinies
> into our own hands, to conduct our lives according to our own will and our
> own conception of the truth."_ [quoted by Peter Arshinov, **The History of
> the Makhnovist Movement** , p. 58]

As such, the Makhnovists were extremely hostile to the idea of state power,
recognising it simply as a means by which the majority are ruled by the few.
Equally, they were opposed to wage slavery (to private or state bosses),
recognising that as long as the workers do not manage their own work, they can
never be free. As they put it, their goals could only be achieved by an
_"implacable revolution and consistent struggle against all lies,
arbitrariness and coercion, wherever they come from, a struggle to the death,
a struggle for free speech, for the righteous cause, a struggle with weapons
in hand. Only through the abolition of all rulers, through the destruction of
the whole foundation of their lies, in state affairs as well as in political
and economic affairs. And only through the social revolution can the genuine
Worker-Peasant soviet system be realised and can we arrive at SOCIALISM."_
[contained in Arshinov, **Op. Cit.** , p. 273] They, like other anarchists and
the Kronstadt rebels, termed this programme of working class self-management
the **_"third revolution."_**

We will discuss the political aspect of the Makhnovist programme first, then
its economic one. However, the Maknovists considered (correctly) that both
aspects could not be separated. As they put it: _"We will not lay down our
arms until we have wiped out once and for all every political and economic
oppression and until genuine equality and brotherhood is established in the
land."_ [contained in Arshinov, **Op. Cit.** , p. 281] We split the aspects
simply to aid the presentation of their ideas.

At the core of their ideas was what they termed the _**"Free Soviet System"**_
(or **_"free soviets"_** for short). It was this system which would allow the
working class to create and run a new society. As they put it:

> _"[The] Makhnovists realise that the working people are no longer a flock of
> sheep to be ordered about by anyone. We consider the working people capable
> of building, on their own and without parties, commissars or generals, their
> own FREE SOVIET SYSTEM, in which those who are elected to the Soviet will
> not, as now [under the Bolsheviks], command and order us, but on the
> contrary, will be only the executors of the decisions made in our own
> workers' gatherings and conferences."_ [contained in Peter Arshinov, **Op.
> Cit.** , pp. 280-1]

Thus the key idea advocated by the leading Makhnovista for social organisation
and decision-making was the _"free toilers' soviet of peasant and worker
organisations."_ This meant they were to be independent of all central
authority and composed of those who worked, and not political parties. They
were to federate on a local, then regional and then national level, and power
within the federation was to be horizontal and not vertical. [Michael Malet,
**Op. Cit.** , p. 107] Such a system was in opposition to the Bolshevik
practice of Soviets defined and dominated by political parties with a vertical
decision- making structure that reached its highest point in the Bolshevik
Central Committee.

Thus, for the Makhnovists, the soviet system would be a "bottom-up" system,
one designed not to empower a few party leaders at the centre but rather a
means by which working people could manage their own affairs. As the put it,
the _"soviet system is not the power of the social-democratic Communist-
Bolsheviks who now call themselves a soviet power; rather it is the supreme
form of non-authoritarian anti-state socialism, which expresses itself in the
organisation of a free, happy and independent system of social life for the
working people."_ This would be based on the _"principles of solidarity,
friendship and equality."_ This meant that in the Makhnovist system of free
soviets, the _"working people themselves must freely choose their own soviets,
which will carry out the will and desires of the working people themselvs,
that is to say, ADMINISTRATIVE, not ruling soviets."_ [contained in Arshinov,
**Op. Cit.** , pp. 272-3]

As David Footman summarises, Makhno's _"ultimate aims were simple. All
instruments of government were to be destroyed. All political parties were to
be opposed, as all of them were working for some or other form of new
government in which the party members would assume the role of a ruling class.
All social and economic affairs were to be settled in friendly discussion
between freely elected representatives of the toiling masses."_ [ **Op. Cit.**
, p. 247]

Hence the Makhnovist social organisation was a federation of self-managed
workers' and peasants' councils (soviets), which would _"be only the executors
of the decisions made in our workers' gatherings and conferences."_ [contained
in Arshinov, **Op. Cit.** , p. 281] In other words, an anarchist system based
on mass assemblies and decision-making from the bottom up.

Economically, as is to be expected, the Makhnovists opposed private property,
capitalism and wage-slavery. Their economic ideas were summarised in a
Makhnovist declaration as follows:

> _"The lands of the service gentry, of the monasteries, of the princes and
> other enemies of the toiling masses, with all their livestock and goods, are
> passed on to the use of those peasants who support themselves solely through
> their own labour. This transfer will be carried out in an orderly fashion
> determined in common at peasant assemblies, which must remember in this
> matter not only each of their own personal interests, but also bear in mind
> the common interest of all the oppressed, working peasantry._
>
> _"Factories, workshops, mines and other tools and means of production become
> the property of the working class as a whole, which will run all enterprises
> themselves, through their trade unions, getting production under way and
> striving to tie together all industry in the country in a single, unitary
> organisation."_ [contained in Arshinov, **Op. Cit.** , p. 266]

They continually stressed that the _"land, the factories, the workshops, the
mines, the railroads and the other wealth of the people must belong to the
working people themselves, to those who work in them, that is to say, they
must be socialised."_ This meant a system of use-rights, as _"the land, the
mines, the factories, the workshops, the railroads, and so on, will belong
neither to individuals nor to the government, but solely to those who work
with them."_ [ **Op. Cit.** , p. 273 and p. 281]

In industry, such a system clearly implied a system of worker's self-
management within a system of federated factory committees or union branches.
On the land, it meant the end of landlordism, with peasants being entitled to
as much land and equipment as they could cultivate without the use of hired
labour. As a Makhnovist congress in 1919 resolved:

> _"The land question should be decided on a Ukraine-wide scale at an all-
> Ukrainian congress of peasants on the following basis: in the interests of
> socialism and the struggle against the bourgeoisie, all land should be
> transferred to the hands of the toiling peasants. According to the principle
> that 'the land belongs to nobody' and can be used only by those who care
> about it, who cultivate it, the land should be transferred to the toiling
> peasantry of Ukraine for their use without pay according to the norm of
> equal distribution."_ [quoted by Palij, **Op. Cit.** , p. 155]

In addition to advocating the abolition of private property in land and the
end of wage labour by distributing land to those who worked it, the
Makhnovists also supported the forming of _"free"_ or _"working"_ communes.
Like their policy of land distribution, it also aimed to benefit the poorer
peasants and rural wage labourers. The _"free commune"_ was a voluntary
association of rural workers who took over an expropriated estate and managed
the land in common. The commune was managed by a general meeting of all its
members and based on the liberty, equality and solidarity of its members.

Clearly, in terms of their economic policies, the Makhnovists proposed a clear
and viable alternative to both rural and urban capitalism, namely workers'
self-management. Industry and land would be socialised, with the actual
management of production resting in the hands of the workers themselves and
co-ordinated by federated workers' organisations. On the land, they proposed
the creation of voluntary communes which would enable the benefits of co-
operative labour to be applied. Like their political ideas, their economic
ideas were designed to ensure the freedom of working people and the end of
hierarchy in all aspects of society.

In summary, the Makhnovist had a constructive social ideas which aimed to
ensure the total economic and political emancipation of the working people.
Their vision of a free society was based on a federation of free, self-managed
soviets, the socialisation of the means of life and workers' self-management
of production by a federation of labour unions or factory committees. As the
black flags they carried into battle read, _"liberty or death"_ and _"the land
to the peasants, the factories to the workers."_

## 7 Did they apply their ideas in practice?

Yes, the Makhnovists consistently applied their political and social ideas
when they had the opportunity to do so. Unlike the Bolsheviks, who quickly
turned away from their stated aims of soviet democracy and workers' control in
favour of dictatorship by the Bolshevik party, the Makhnovists did all in
their power to encourage, create and defend working-class freedom and self-
management (see [section 14](append46.md#app14) for further discussion). In
the words of historian Christopher Reed:

> _"there can be no question that the anarchists did everything they could to
> free the peasants and workers and give them the opportunity to develop their
> own forms of collective control over land and factories . . . [T]he
> Ukrainian anarchists fought under the slogan of land to the peasants,
> factories to the workers and power to the soviets. Wherever they had
> influence they supported the setting up of communes and soviets. They
> introduced safeguards intended to protect direct self-government from
> organised interference . . . They conducted relentless class war against
> landlords, officers, factory owners and the commercial classes could expect
> short shrift from Makhno and his men, especially if they had taken up arms
> against the people or, like the Whites . . ., had been responsible for
> looting, pogroms and vicious reprisals against unarmed peasants on a
> colossal scale."_ [ **From Tsar to Soviets** , p. 263]

As we discussed in the [last section](append46.md#app6), the core ideas
which inspired the Makhnovists were working-class self-determination and self-
management. They aimed at the creation of a _"free soviet system"_ and the end
of capitalism by rural and industrial self-management. It is to the credit of
the Makhnovists that they applied these ideas in practice rather than talking
about high principles and doing the exact opposite.

In practice, of course, the war left little room for much construction work.
As Voline pointed out, one of the key disadvantages of the movement was the
_"almost continual necessity of fighting and defending itself against all
kinds of enemies, without being able to concentrate on peaceful and truly
positive works."_ [ **The Unknown Revolution** , p. 571] However, in the
disruption of the Civil War the Makhnovists applied their ideas when and where
they could.

Within the army, as we discussed in [section 5](append46.md#app5), the
insurgent troops elected their own commanders and had regular mass assemblies
to discuss policy and the agreed norms of conduct within it. In civilian
matters, the Makhnovists **from the start** encouraged working-class self-
organisation and self-government. By late 1917, in the area around Hulyai Pole
_"the toiling masses proceeded . . . to consolidate their revolution. The
little factories functioned . . . under the control of the workers. The
estates were split up . . . among the peasants . . . a certain number of
agricultural communes were formed."_ [David Footman, **Op. Cit.** , p. 248]

The aim of the Makhnovists was to _"transfer all the lands owned by the
gentry, monasteries, and the state into the hands of peasants or to organise,
if they wished, peasant communes."_ [Palij, **Op. Cit.** , p. 70] This policy
was introduced from the start, and by the autumn of 1917, all land, equipment
and livestock around Hulyai Pole had been expropriated from the gentry and
kulaks and placed in the hands of working peasants. Land reform had been
achieved by the direct action of the peasantry.

However, _"many of the peasants understood that the task was not finished,
that it was not enough to appropriate a plot of land and be content with it.
From the hardships of their lives they learned that enemies were watching from
all sides, and that they must stick together. In several places there were
attempts to organise social life communally."_ [Arshinov, **Op. Cit.** , p.
86]

In line with social anarchist theory, the Makhnovists also tried to introduce
collective forms of farming. These experiments in collective working and
living were called _"free communes."_ Despite the difficult military situation
communes were established, principally near Hulyai Pole, in the autumn of
1917. This activity was resumed in February to March of 1918. They re-appeared
in early 1919, once the threat of counter-revolution had been (temporarily)
defeated.

There were four of these communes within five miles of Hulyai Pole itself and
many more further afield. According to Makhno, these agricultural communes
_"were in most cases organised by peasants, though sometimes their composition
was a mixture of peasants and workmen [sic!]. Their organisation was based on
equality and solidarity of the members. All members of these communes -- both
men and women -- applied themselves willingly to their tasks, whether in the
field or the household."_ Unlike many communes, people were given the personal
space they desired, so _"any members of the commune who wanted to cook
separately for themselves and their children, or to take food from the
communal kitchens and eat it in their own quarters, met with no objection from
the other members."_ The management of each commune _"was conducted by a
general meeting of all its members."_ In addition, the communes decided to
introducing anarchist schooling based on the ideas of Franciso Ferrer (see
[section J.5.13](secJ5.md#secj513) for details). Makhno himself worked on
one for two days a week for a period. [Makhno, quoted by Paul Avrich,
**Anarchists in the Russian Revolution** , pp. 131]

They were set up on the former estates of landlords, and consisted of around
10 families or 100 to 300 people and although each had peasant anarchist
members not all the members were anarchists. Makhno worked on Commune No. 1,
which was on the estate of former landlord Klassen. When re-founded in 1919
this commune was named after Rosa Luxemburg, the Marxist revolutionary who had
recently been murdered in the German revolution. It was a success, for by the
spring sowing it had grown from nine families to 285 members working 340 acres
of land. The communes represented a way that poor and middle peasants could
pool resources to work estates that they could not have worked otherwise and,
as Michael Malet points out, _"they were organised from the bottom up, not the
top down."_ [ **Op. Cit.** , p. 121]

However, as Makhno himself acknowledged, while the _"majority of the toiling
population saw in the organisation of rural communes the healthy germ of a new
social life"_ which could provide a _"model of a free and communal form of
life,"_ the _"mass of people did not go over to it."_ They cited as their
reasons _"the advance of the German and Austrian armies, their own lack of
organisation, and their inability to defend this order against the new
'revolutionary' [Bolshevik] and counter-revolutionary authorities. For this
reason the toiling population of the district limited their revolutionary
activity to supporting in every way those bold springs."_ [Makhno, quoted by
Avrich, **Op. Cit.** , p. 132] Given that the communes were finally destroyed
by White and Red forces in June 1919, their caution was justified. After this,
peace did not return long enough for the experiment to be restarted.

As Michael Malet argues:

> _"Very few peasant movements in history have been able to show in practice
> the sort of society and type of landholding they would like to see. The
> Makhnovist movement is proof that peasant revolutionaries can put forward
> positive, practical ideas."_ [ **Op. Cit.** , p. 121]

The Makhnovist experiments, it should be noted, have strong similarities to
the rural revolution during the Spanish Revolution of 1936 (see sections
[I.8.5](secI8.md#seci85) and [I.8.6](secI8.md#seci86) for more details).

As well as implementing their economic ideas on workers' self-management, land
reform and free communes, the Makhnovists also organised regional congresses
as well as local soviets. Most of the activity happened in and around Hulyai
Pole, the focal point of the movement.This was in accord with their vision of
a _"free soviet system."_ Needless to say, the congresses could only be called
during periods of relative calm (i.e. the Makhnovist home area was not
occupied by hostile forces) and so congresses of insurgents, peasants and
workers were called in early 1919 and another in October of that year. The
actual dates of the regional congresses were:

> 23 January 1919 at Velyka Mykhailivka
>
> 12 February 1919 at Hulyai Pole
>
> 10 April 1919 at Hulyai Pole
>
> 20 October 1919 at Aleksandrovsk

A congress for the fifteenth of June 1919 never met because Trotsky
unilaterally banned it, under pain of death to anyone even **discussing** it,
never mind calling for it or attending as a delegate. Unlike the third
congress, which ignored a similar ban by Dybenko, the fourth congress could
not go ahead due to the treacherous attack by the Red Army that preceded it.
Four Makhnovist commanders were executed by the Red Army for advertising this
congress. Another congress planned for Aleksandrovsk in November 1920 was also
prevented by Bolshevik betrayal, namely the attack after Wrangel had been
defeated. [Malet, **Op. Cit.** , p. 108] See [section 13](append46.md#app13)
for further details.

The reason for these regional congresses was simple, to co-ordinate the
revolution. _"It was indispensable,"_ Arshinov notes, _"to establish
institutions which unified first a district composed of various villages, and
then the districts and departments which composed the liberated region. It was
indispensable to find general solutions for problems common to the entire
region. It was indispensable to create organs suitable for these tasks. And
the peasants did not fail to create them. These organs were the regional
congresses of peasants and workers."_ [ **Op. Cit.** , pp. 87-8] These
congresses _"were composed of delegates of peasants, workers and of the
insurgent army, and were intended to clarify and record the decisions of the
toiling masses and to be regarded as the supreme authority for the liberated
area."_ [David Footman, **Op. Cit.** , p. 266]

The first congress, which was the smallest, discussed the strengthening of the
front, the adoption of a common nomenclature for popular organisations
(soviets and the like) and to send a delegation to convince the draftees in
the Nationalist forces to return home. It was also decided to organise a
second congress. The second congress was larger, having 245 delegates from 350
districts. This congress _"was strongly anti-Bolshevik and favoured a
democratic socio-political way of life."_ [Palij, **Op. Cit.** , p. 153] One
delegate made the issue clear:

> _"No party has a right to usurp governmental power into its own hands . . .
> We want life, all problems, to be decided locally, not by order from any
> authority above; and all peasants and workers should decide their own fate,
> while those elected should only carry out the toilers' wish."_ [quoted by
> Palij, **Op. Cit.** , p. 154]

A general resolution was passed, which acknowledged the fact that the
Bolshevik party was _"demanding a monopoly of the Revolution."_ It also
stated:

> _"With deep regret the Congress must also declare that apart from external
> enemies a perhaps even greater danger, arising from its internal
> shortcomings, threatens the Revolution of the Russian and Ukrainian peasants
> and workers. The Soviet Governments of Russia and of the Ukraine, by their
> orders and decrees, are making efforts to deprive local soviets of peasants
> and workers' deputies of their freedom and autonomy."_ [quoted by Footman,
> **Op. Cit.** , p. 267]

As noted in [section 5](append46.md#app5), the congress also decided to
issue an _"obligatory"_ mobilisation to gather troops for the Army. It also
accepted a resolution on land reform, stating that the land _"belongs to
nobody"_ and could be used by anyone as long as they did not use wage labour
(see [section 6](append46.md#app6) for the full resolution). The congress
accepted a resolution against plunder, violence, and anti-Jewish pogroms,
recognising it as an attempt by the Tsarist government to _"turn the attention
of all toiling people away from the real reason for their poverty,"_ namely
the Tsarist regime's oppression. [quoted by Palij, **Op. Cit.** , p. 155]

The second congress also elected the Revolutionary Military Soviet of
Peasants, Workers and Insurgents, which had _"no powers to initiate policy but
designed merely to implement the decisions of the periodic congresses."_
[Footman, **Op. Cit.** , p. 267]

The third congress was the largest and most representative, with delegates
from 72 volosts (in which two million people lived). This congress aimed to
_"clarify the situation and to consider the prospects for the future of the
region."_ It decided to conduct a voluntary mobilisation of men to fight the
Whites and _"rejected, with the approval of both rich and poor peasants, the
Bolshevik expropriations."_ [Palij, **Op. Cit.** , p. 158] Toward the end of
the congress, it received a telegram from the Bolshevik commander Dybenko
calling it _"counter-revolutionary,"_ its organisers _"outlaws"_ and
dissolving it by his order. The congress immediately voted an indignant
resolution in rely. This corrected Dybenko's factual mistakes on who called
it, informed him why it was called, gave him a history lesson on the
Makhnovist region and asked him:

> _"Can there exist laws made by a few people who call themselves
> revolutionaries which permit them to outlaw a whole people who are more
> revolutionary than they are themselves? . . ._
>
> _"Is it permissible, is it admissible, that they should come to the country
> to establish laws of violence, to subjugate a people who have just
> overthrown all lawmakers and all laws?_
>
> _"Does there exist a law according to which a revolutionary has the right to
> apply the most severe penalties to a revolutionary mass, of which he calls
> himself the defender, simply because this mass has taken the good things
> which the revolution promised them, freedom and equality, without his
> permission?_
>
> _"Should the mass of revolutionary people perhaps be silent when such a
> revolutionary takes away the freedom which they have just conquered?_
>
> _"Do the laws of the revolution order the shooting of a delegate because he
> believes he ought to carry out the mandate given him by the revolutionary
> mass which elected him?_
>
> _"Whose interests should the revolutionary defend; those of the Party or
> those of the people who set the revolution in motion with their blood?"_
> [quoted by Arshinov, **Op. Cit.** , p. 103]

As we discuss in [section 13](append46.md#app13), Trotsky's order to ban the
fourth congress indicates that such laws do exist, with the _"entire peasant
and labouring population are declared guilty of high treason if they dare
participate in their own free congress."_ [Arshinov, **Op. Cit.** , p. 123]

The last congress was held between 20th and 26th of October in Aleksandrovsk.
One delegate was to be elected per 3000 people and one delegate per military
unit. This gave 270 mostly peasant delegates. Only 18 were workers, of which 6
were Mensheviks, who walked out after Makhno called them _"lapdogs of the
bourgeoisie"_ during the discussion on _"free socio-economic organisations"_!
[Malet, **Op. Cit.** , p. 109] The congress passed a number of resolutions,
concentrating on the care of the wounded and the poorest part of the
population, a voluntary mobilisation, voluntary peasant contributions to feed
the army and forced levies on the bourgeoisie.

According to Voline, the chairman, Makhnovist ideas were freely discussed:

> _"The idea of free Soviets, genuinely functioning in the interests of the
> working population; the question of direct relationships between peasants
> and city workers, based on mutual exchange of the products of their labour;
> the launching of a libertarian and egalitarian social organisation in the
> cities and the country; all these question were seriously and closely
> studied by the delegates themselves, with the assistance and co-operation of
> qualified comrades."_ [ **Op. Cit.** , p. 640]

He notes that the congress _"decided that the workers, without any authority,
would organise their economic, political and administrative life for
themselves, by means of their own abilities, and through their own direct
organs, united on a federative basis."_ [ **Op. Cit.** , p. 641]

It is significant to note that the congress also discussed the activities of
the Makhnovists within the city itself. One delegate raised the issue of the
activities of the Kontrrazvedka, the Makhnovist _"counter-intelligence"_
section. As noted in [section 5](append46.md#app5), the Makhnovists, like
all the armies in the Russian Civil War, had its intelligence service. It
combined a number of functions, such as military reconnaissance, arrest and
holding of prisoners, counter-insurgency ( _"Originally it had a punitive
function, but because of improper treatment of prisoners of war, it was
deprived of its punitive function."_ [Palij, **Op. Cit.** , p. 300]). The
delegate stated that this _"counter-espionage service"_ was engaged in
_"arbitrary acts and uncontrolled actions -- of which some are very serious,
rather like the Bolshevik Cheka."_ [quoted by Voline, **Op. Cit.** , p. 643]
Immediately a commission of several delegates was created to investigate the
situation. Voline argues that _"[s]uch an initiative on the part of workers'
delegates would not have been possible under the Bolshevik regime. It was by
activity of this kind that the congress gave a preview of the way in which a
society should function from the beginning if it is based on a desire for
progress and self-realisation."_ [Voline, **Ibid.** ] Sadly, the commission
could not complete its work due to the city being evacuated soon after the
congress.

Another incident shows that under the Makhnovists the civilian population was
in control. A delegate noted that Klein, the Makhnovist military commander in
the city, had become publicly and riotously drunk after issuing proclamations
against drunkenness. Klein was called before the congress, which accepted his
apology and his request to be sent to the front, away from the boredom of desk
work which had driven him to drink! This, according to Voline, showed that the
workers and their congress were the masters and the army its servant. [Voline,
**Op. Cit.** , pp. 645-7]

Outside of the congresses the work of local Soviets was to be co-ordinated
through the Revolutionary Military Soviet (RMS), the first RMS was set up by
the 2nd congress and consisted of one delegate for each of the 32 volsts the
Makhnovista had liberated. The RMS was to be answerable to the congresses and
limited to implementing their decisions but the difficult military situation
meant this seldom happened. When it did (the 3rd Congress) the Congress had no
problems with its actions in the previous period. After the Aleksandrovsk
congress, the RMS consisted of 22 delegates including three known Bolsheviks
and four known Makhnovists, the Bolsheviks considered the remaining delegates
_"anarchists or anarchist sympathisers"._

The military chaos of 1920 saw the RMS dissolved and replaced by the Soviet of
Revolutionary Insurgents of the Ukraine, which consisted of seven members
elected by the insurgent army. Its secretary was a left Socialist
Revolutionary. The RMS in addition to making decisions between Congresses
carried out propaganda work including the editing of the Makhnovist paper
_"The Road to Freedom"_ and collected and distributed money.

Lastly, we must discuss what happened when the Makhnovists applied their ideas
in any cities they liberated as this gives a clear idea of the way they
applied their ideas in practice. Anarchist participant Yossif the Emigrant
stated that it was _"Makhno's custom upon taking a city or town to call the
people together and announce to them that henceforth they are free to organise
their lives as they think best for themselves. He always proclaims complete
freedom of speech and press; he does not fill the prisons or begin executions,
as the Communists do."_ He stressed it was _"the expression of the toilers
themselves"_ and _"the first great mass movement that by its own efforts seeks
to free itself from government and establish economic self-determination. In
that sense it is thoroughly Anarchistic."_ [Alexander Berkman, **The Bolshevik
Myth** , pp. 193-5]

Arshinov paints a similar picture:

> _"As soon as they entered a city, they declared that they did not represent
> any kind of authority, that their armed forces obliged no one to any sort of
> obligation and had no other aim than to protect the freedom of the working
> people. The freedom of the peasants and the workers, said the Makhnovists,
> resides in the peasants and workers themselves and may not be restricted. In
> all fields of their lives it is up to the workers and peasants themselves to
> construct whatever they consider necessary. As for the Makhnovists -- they
> can only assist them with advice, by putting at their disposal the
> intellectual or military forces they need, but under no circumstances can
> the Makhnovists prescribe for them in any manner."_ [Arshinov, **Op. Cit.**
> , p. 148]

In addition, the Makhnovists _"fully applied the revolutionary principles of
freedom of speech, of thought, of the press, and of political association. In
all cities and towns occupied by the Makhnovists, they began by lifting all
the prohibitions and repealing all the restrictions imposed on the press and
on political organisations by one or another power."_ Indeed, the _"only
restriction that the Makhnovists considered necessary to impose on the
Bolsheviks, the left Socialist-Revolutionaries and other statists was a
prohibition on the formation of those 'revolutionary committees' which sought
to impose a dictatorship over the people."_ They also took the opportunity to
destroy every prison they got their hands on, believing that free people
_"have no use for prisons"_ which are _"always built only to subjugate the
people, the workers and peasants."_ [ **Op. Cit.** , p. 153, p. 154 and p.
153]

The Makhnovists encouraged self-management. Looking at Aleksandrovsk:

> _"They immediately invited the working population to participate in a
> general conference of the workers of the city. When the conference met, a
> detailed report was given on the military situation in the region and it was
> proposed that the workers organise the life of the city and the functioning
> of the factories with their own forces and their own organisations, basing
> themselves on the principles of labour and equality. The workers
> enthusiastically acclaimed all these suggestions; but they hesitated to
> carry them out, troubled by their novelty, and troubled mainly by the
> nearness of the front, which made them fear that the situation of the town
> was uncertain and unstable. The first conference was followed by a second.
> The problems of organising life according to principles of self-management
> by workers were examined and discussed with animation by the masses of
> workers, who all welcomed these ideas with the greatest enthusiasm, but who
> only with difficulty succeeded in giving them concrete forms. Railroad
> workers took the first step in this direction. They formed a committee
> charged with organising the railway network of the region . . . From this
> point, the proletariat of Aleksandrovsk began to turn systematically to the
> problem of creating organs of self-management."_ [ **Op. Cit.** , p. 149]

Unfortunately, the Makhnovists occupied only two cities (Alexandrovsk for four
weeks and Katerinoslav for two periods of one and five weeks respectively). As
a rule the Makhnovist rank and file had little or no experience of life in the
cities and this placed severe limits on their ability to understand the
specific problems of the workers there. In addition, the cities did not have a
large anarchist movement, meaning that the Mensheviks and Bolsheviks had more
support then they did. Both parties were, at best, neutral to the Makhnovists
and anarchists, so making it likely that they would influence the city workers
against the movement. As Voline noted, the _"absence of a vigorous organised
workers' movement which could support the peasant insurgents"_ was a
disadvantage. [ **Op. Cit.** , p. 571]

There were minor successes in both cities. In Alexandrovsk, some trains were
got running and a few factories reopened. In Katerinoslav (where the city was
under a state of siege and constant bombardment by the Whites), the tobacco
workers won a collective agreement that had long been refused and the bakers
set themselves to preparing the socialisation of their industry and drawing up
plans to feed both the army and the civilian population. Unsurprisingly, the
bakers had long been under anarcho-syndicalist influence. [Malet, **Op. Cit.**
, p. 124]

Clearly, whenever they could, the Makhnovists practised their stated goals of
working-class self-management and supported the organisational structures to
ensure the control of and participation in the social revolution by the
toiling masses. Equally, when they liberated towns and cities they did not
impose their own power upon the working-class population but rather urged it
to organise itself by setting up soviets, unions and other forms of working-
class power. They urged workers to organise self-management of industry. True
to the anarchist vision of a free society, they advocated and practised
freedom of assembly, speech and organisation. In the words of historian
Christopher Reed:

> _"Makhno's Insurgent Army . . . was the quintessence of a self-administered,
> people's revolutionary army. It arose from the peasants, it was composed of
> peasants, it handed power to the peasants. It encouraged the growth of
> communes, co-operatives and soviets but distrusted all permanent elites
> attempting to take hold within them. It would be foolish to think that
> Makhno was supported by every peasant or that he and his followers could
> not, on occasions, direct their cruelty towards dissidents within their own
> ranks, but, on the whole, the movement perhaps erred on the side of being
> too self-effacing, of handing too much authority to the population at key
> moments."_ [ **From Tsar to Soviets** , p. 260]

As such, Makhnovist practice matched its theory. This can be said of few
social movements and it is to their credit that this is the case.

## 8 Weren't the Makhnovists just Kulaks?

According to Trotsky (and, of course, repeated by his followers), _"Makhno
created a cavalry of peasants who supplied their own horses. These were not
the downtrodden village poor whom the October revolution first awakened, but
the strong and well-fed peasants who were afraid of losing what they had. The
anarchist ideas of Makhno (ignoring of the state, non-recognition of the
central power) corresponded to the spirit of this kulak cavalry as nothing
else could."_ He argued that the Makhnovist struggle was not the anarchist
struggle against the state and capitalism, but rather _"a struggle of the
infuriated petty property owner against the proletarian dictatorship."_ The
Makhno movement, he stressed, was just an example of the _"convulsions of the
peasant petty bourgeoisie which desired, of course, to liberate itself from
capital but at the same time did not consent to subordinate itself to the
dictatorship of the proletariat."_ [Lenin and Trotsky, **Kronstadt** , p. 80,
p. 89 and pp. 89-90]

Unfortunately for those who use this kind of argument against the Makhnovists,
it fails to stand up to any kind of scrutiny. Ignoring the sophistry of
equating the Bolshevik party's dictatorship with the "dictatorship of the
proletariat," we can easily refute Trotsky's somewhat spurious argument
concerning the background of the Makhnovists.

Firstly, however, we should clarify what is meant by the term _"kulak."_
According to one set of Trotskyist editors, it was _"popularly used to refer
to well-to-do peasants who owned land and hired poor peasants to work it."_ [
_"glossary,"_ Lenin and Trotsky, **Kronstadt** , p. 146] The term itself
derives from the Russian for _"fist,"_ with appropriate overtones of grasping
and meanness. In other words, a rural small-scale capitalist (employer of wage
labour and often the renter of land and loaner of money as well) rather than a
well-off peasant as such. Trotsky, however, muddies the water considerably by
talking about the _"peasant petty bourgeoisie"_ as well. Given that a peasant
**is** _"petty"_ (i.e. petit) bourgeois (i.e. own and use their own means of
production), Trotsky is blurring the lines between rural capitalist (kulak)
and the middle peasantry, as occurred so often under Bolshevik rule.

Secondly, we could just point to the eyewitness accounts of the anarchists
Arshinov and Voline. Both stress that the Makhno movement was a mass
revolutionary movement of the peasant and working poor in the Southern
Ukraine. Arshinov states that after Denikin's troops had been broken in 1919,
the Makhnovists _"literally swept through villages, towns and cities like an
enormous broom"_ and the _"returned **pomeshchiks** [landlords], the
**kulaks** , the police, the priests"_ were destroyed, so refuting the _"the
myth spread by the Bolsheviks about the so-called **kulak** character of the
Makhnovshchina."_ Ironically, he states that _"wherever the Makhnovist
movement developed, the **kulaks** sought the protection of the Soviet
authorities, and found it there."_ [ **Op. Cit.** , p. 145] Yossif the
Emigrant, another anarchist active in the movement, told anarchist Alexander
Berkman that while there was a _"kulak"_ element within it, _"the great
majority are not of that type."_ [quoted by Berkman, **The Bolshevik Myth** ,
p. 187] According to Gallina Makhno (Makhno's wife), when entering a town or
village it was _"always Makhno's practice to compel the rich peasants, the
**kulaki** , to give up their surplus wealth, which was then divided among the
poor, Makhno keeping a share for his army. Then he would call a meeting of the
villagers, address them on the purposes of the **povstantsi** [partisan]
movement, and distribute his literature."_ [Emma Goldman, **My Disillusionment
in Russia** , p. 149]

However, this would be replying to Trotsky's assertions with testimony which
was obviously pro-Makhnovist. As such, we need to do more than this, we need
to refute Trotsky's assertions in depth, drawing on as many non-anarchist
sources and facts as possible.

The key to refuting Trotsky's argument that the Makhnovists were just kulaks
is to understand the nature of rural life before and during 1917. Michael
Malet estimates that in 1917, the peasantry could be divided into three broad
categories. About 40 percent could no longer make a living off their land or
had none, another 40 per cent who could make ends meet, except in a bad year,
and 20 per cent who were relatively well off, with a fraction at the very top
who were very well off. [ **Op. Cit.** , p. 117] Assuming that _"kulak"_
simply meant _"rich"_ or _"well-off"_ peasant, then Trotsky is arguing that
the Makhnovist movement represented and was based on this top 20 per cent.
However, if we take the term _"kulak"_ to mean _"small rural capitalist"_
(i.e. employer of wage labour) then this figure would be substantially smaller
as few within this group would employ hired labour or rent land. In fact, the
percentage of peasant households in Russia employing permanent wage-labour was
3.3% in 1917, falling to 1% in 1920. [Teodor Shanin, **The Awkward Class** ,
p. 171]

In 1917, the peasants all across the Russian Empire took back the land stolen
by the landlords. This lead to two developments. Firstly, there was a
_"powerful levelling effect"_ in rural life. [Shanin, **Op. Cit.** , p. 159]
Secondly, the peasants would only support those who supported their
aspirations for land reform (which was why the Bolsheviks effectively stole
the Socialist-Revolutionary land policy in 1917). The Ukraine was no
different. In 1917 the class structure in the countryside changed when the
Hulyai Pole peasants were amongst the first to seize the landlords' land. In
August 1917 Makhno assembled all the landed gentry ( _" **pomeshchiks** "_) of
the region _"and made them give him all the documents relating to lands and
buildings."_ After making an exact inventory of all this property and
presenting a report to the local and then district congress of soviets, he
_"proceeded to equalise the rights of the **pomeshchiks** and **kulaks** with
those of the poor peasant labourers in regard to the use of the land . . . the
congress decided to let the **pomeshchiks** and **kulaks** have a share of the
land, as well as tools and livestock, equal to that of the labourers."_
Several other peasant congresses nearby followed this example and adopted the
same measure. [Peter Arshinov, **Op. Cit.** , pp. 53-4]

Most of this land, tools and livestock was distributed to poor peasants, the
rest was used to set up voluntary communes where the peasants themselves (and
not the state) self-managed the land. Thus the peasants' _"economic conditions
in the region of the Makhno movement were greatly improved at the expense of
the landlords, the church, monasteries, and the richest peasants."_ [Palij,
**Op. Cit.** , p. 214] This redistribution was based on the principle that
every peasant was entitled to as much land as their family could cultivate
without the use of hired labour. The abolition of wage labour in the
countryside was also the method the anarchists were to use in Spain to divide
up the land some 20 years later.

We should also note that the Makhnovist policy of land reform based on the
abolition of wage labour was, as we noted in [section 7](append46.md#app7),
the position agreed at the second regional congress called in 1919. The
Makhnovists specifically argued with regards to the kulaks:

> _"We are sure that . . . the kulak elements of the village will be pushed to
> one side by the very course of events. The toiling peasantry will itself
> turn effortlessly on the kulaks, first by adopting the kulak's surplus land
> for general use, then naturally drawing the kulak elements into the social
> organisation."_ [cited by Michael Malet, **Op. Cit.** , pp. 118-9]

As such, when Trotsky talks about the _"downtrodden village poor whom the
October revolution first awakened,"_ he is wrong. In the area around Hulyai
Pole it was **not** the October revolution which _"first awakened"_ them into
action, it was the activities of Makhno and the anarchists during the summer
and autumn of 1917 which had done that (or, more correctly, it was their
activities which aided this process as the poor peasants and landless workers
needed no encouragement to expropriate the landlords).

Needless to say, this land redistribution reinforced Makhno's popularity with
the people and was essential for the army's later popularity and its ability
to depend on the peasants for support. However, the landlords and richer
kulaks did not appreciate it and, unsurprisingly, tried to crush the movement
when they could. Once the Austro-Germans invaded, the local rich took the
opportunity to roll back the social revolution and the local **pomeshchiks**
and **kulaks** formed a _"special volunteer detachment"_ to fight Makhno once
he had returned from exile in July 1918. [Arshinov, **Op. Cit.** , p. 59]

This system of land reform did not seek to divide the village. Indeed, the
Makhnovist approach is sometimes called the _"united village"_ theory. Rather
than provoke unnecessary and damaging conflict behind the frontlines, land
reform would be placed in the hands of the village community, which would
ensure that even the kulaks would have a fair stake in the post-revolutionary
society as everyone would have as much land as they could till without using
hired labour. The Bolshevik policy, as we will see, aimed at artificially
imposing "class conflict" upon the villages from without and was a disaster as
it was totally alien to the actual socio-economic situation. Unsurprisingly,
peasant communities **as a whole** rose up against the Bolsheviks all across
Russia.

As such, the claim that the Makhnovists were simply _"kulaks"_ is false as it
fails to, firstly, acknowledge the actual pre-revolutionary composition of the
peasantry and, secondly, to understand the social-revolution that had happened
in the region of Hulyai Pole in 1917 and, thirdly, totally ignores the actual
Makhnovist position on land reform. As Michael Malet argues, the Bolsheviks
_"totally misconstrued the nature of the Makhno movement. It was not a
movement of kulaks, but of the broad mass of the peasants, especially the poor
and middle peasants."_ [ **Op. Cit.** , p. 122]

This was sometimes acknowledged by Bolsheviks themselves. IAkovlev
acknowledged in 1920 that in 1919 Makhno _"was a real peasant idol, an
expression of all peasant spontaneity against . . . Communists in the cities
and simultaneously against city capitalists and landowners. In the Makhno
movement it is difficult to distinguish where the poor peasant begins [and]
the 'kulak' ends. It was a spontaneous peasant movement .. . . In the village
we had no foothold, there was not one element with which we could join that
would be our ally in the struggle against the bandits [sic!]."_ [quoted by
Palij, **Op. Cit.** , p. 157]

According to a Soviet author present at the Makhnovist regional congresses on
January 23 and February 12: _"In 1919 when I asked the chairman of the two
Congresses (a Jewish farmer) whether the 'kulaks' were allowed to participate
in the Congress, he angrily responded: 'When will you finally stop talking
about kulaks? Now we have no kulaks among us: everybody is tilling as much
land as he wishes and as much as he can.'"_ [quoted by Palij, **Op. Cit.** ,
p. 293]

According to Christian Rakovskii, the Bolshevik ruler of Ukraine, _"three-
fourths of the membership of the [partisan] bands were poor peasants."_ He
presented a highly original and inventive explanation of this fact by arguing
that _"rich peasants stayed in the village and paid poor ones to fight. Poor
peasants were the hired army of the kulaks."_ [Vladimir N. Brovkin, **Behind
the Front the Lines of the Civil War** , p. 112 and p. 328]

Even Trotsky (himself the son of a rich peasant!) let the cat out of the bag
in 1919:

> _"The liquidation of Makhno does not mean the end of the Makhnovschyna,
> which has its roots in the ignorant popular masses."_ [quoted by Malet,
> **Op. Cit.** , p. 122]

Ultimately, all sources (including Bolshevik ones) accept that in the autumn
of 1919 (at the very least) Makhno's support was overwhelming and came from
all sections of the population.

Even ignoring the fact there was a social revolution and the eye-witness
Bolshevik accounts (including Trotsky's!) which contradict Trotsky's
assertions, Trotsky can be faulted for other reasons.

The most important issue is simply that the Makhnovist movement could not have
survived four years if (at best) 20 per cent of the population supported it.
As Christopher Reed notes, when the Makhnovists were _"in retreat they would
abandon their weapons and merge with the local population. The fact that they
were able to succeed shows how closely they were linked with the ordinary
peasants because such tactics made Makhno's men very vulnerable to informers.
There were very few examples of betrayal."_ [ **Op. Cit.** , p. 260] If
Makhno's social base was as weak as claimed there would have been no need for
the Bolsheviks to enter into alliances with him, particularly in the autumn of
1920 when the Makhnovists held no significant liberated area. Even after the
defeat of Wrangel and the subsequent Bolshevik betrayal and repression,
Makhno's mass base allowed him to remain active for months. Indeed, it was
only when the peasants themselves had become exhausted in 1921 due to
worsening economic conditions and state repression, were the Makhnovists
finally forced into exile.

In the attempt to _"eradicate his influence in the countryside"_ the
Bolsheviks _"by weight of numbers and consistent ruthlessness they achieved a
partial success."_ This was achieved by state terrorism:

> _"On the occupation of a village by the Red Army the **Cheka** would hunt
> out and hang all active Makhnovist supporters; an amenable Soviet would be
> set up; officials would be appointed or imported to organise the poor
> peasants . . . and three or four Red militia men left as armed support for
> the new village bosses."_ [David Footman, **Op. Cit.** , p. 292]

Moreover, in these _"military operations the Bolsheviks shot all prisoners.
The Makhnovists shot all captured officers unless the Red rank and file
strongly interceded for them. The rank and file were usually sent home, though
a number volunteered for service with the Insurgents. Red Army reports
complain of poor morale . . . The Reds used a number of Lettish and Chinese
troops to decrease the risk of fraternisation."_ [Footman, **Op. Cit.** , p.
293] If the Makhnovists were made up of kulaks, why would the Bolsheviks fear
fraternisation? Equally, if the Makhnovists were "kulaks" then how could they
have such an impact on Red Army troops (who were mostly poor peasants)? After
all, Trotsky had been complaining that "Makhnovism" had been infecting nearby
Red Army troops and in August 1919 was arguing that it was _"still a poison
which has infected backward units in the Ukrainian army."_ In December 1919,
he noted that _"disintegration takes place in unstable units of our army when
they came into contact with Makhno's forces."_ It seems unlikely that a
movement made up of "kulaks" could have such an impact. Moreover, as Trotsky
noted, not all Makhnovists were anarchists, _"some of them wrongly regard
themselves as Communists."_ Again, why would people who regarded themselves as
Communists join a movement of "kulaks"? [ **How the Revolution Armed** , vol.
II, p. 367, p. 110 and p. 137]

In addition, it seems highly unlikely (to say the least!) that a movement
which is alleged to be either made up of or supported by the kulaks could have
had a land policy which emphasised and implemented an equal share for the
poorest peasantry, not just of land but also of live and dead stock as well as
opposing the hiring of labour. This fact is reinforced when we look at the
peasant reaction to the Bolshevik (and, presumably, anti-kulak and
pro-"downtrodden village poor") land policy. Simply put, their policies
resulted in massive peasant unrest directed against the Bolsheviks.

The Bolshevik land decrees of the 5th and 11th of February, 1919, stated that
large landlord holdings would become state farms and all stock was to be taken
over by the Ministry of Agriculture, with only between one third and one half
of the land being reserved for poor peasants. This was _"largely irrelevant,
since the peasantry had expected, and in some cases already controlled, all of
it. To them, the government was taking away their land, and not seizing it
from the landlords, then keeping some of it and handing the rest over to its
rightful owners."_ [Malet, **Op. Cit.** , p. 134] Thus the land was to
expropriated by the state, **not** by the peasants. The result of this policy
soon became clear:

> _"The Bolsheviks expropriation policy was countervailed by the peasants'
> resistance based upon their assumption that 'the land belongs to nobody . .
> . it can be used only by those who care about it, who cultivate it.' Thus
> the peasants maintained that all the property of the former landlords was
> now by right their own. This attitude was shared not only by the rich and
> middle peasants but also the poor and landless, for they all wished to be
> independent farmers. The poorer the areas, the more dissatisfied were the
> peasants with the Bolshevik decrees._
>
> _"Thus Communist agricultural policy and terrorism brought about a strong
> reaction against the new Bolshevik regime. By the middle of 1919, all
> peasants, rich and poor, distrusted the Bolsheviks."_ [Palij, **Op. Cit.** ,
> p. 156]

The Bolshevik inspired Poor Peasant Committees were _"associated with this
disastrous policy, were discredited, and their reintroduction would need the
aid of troops."_ [Malet, **Op. Cit.** , p. 135] The Makhnovists, in contrast,
did not impose themselves onto the villages, nor did they attempt to tell the
peasants what to do and how to divide the land. Rather they advocated the
formation of Free Soviets through which these decisions could be made. This,
along with their support for land reform, helped win them mass support.

After evacuating the Ukraine in mid-1919 due to the success of Denikin's
counter-revolution, the Ukrainian Communists took time to mull over what had
happened. The Central Committee's November 1919 resolution on the Ukraine
_"gave top priority to the middle peasant -- so often and so conveniently
lumped in together with the kulak and dealt with accordingly -- the transfer
of landlord land to the poor peasants with only minimum exceptions for state
farms."_ These points were the basis of the new Ukrainian land law of 5th of
February, 1920. [Malet, **Op. Cit.** , p. 135] This new law reflected long
standing Makhnovist theory **and** practice. Therefore, the changing nature of
Bolshevik land policy in the Ukraine indicates that Trotsky's claims are
false. The very fact that the Bolsheviks had to adjust their policies in line
with Makhnovist theory indicates that the later appealed to the middle and
poor peasants.

Equally, it seems strange that the _"kulaks"_ who apparently dominated the
movement should have let themselves be led by poor peasants and workers.
Voline presents a list of some of the participants of the movement and the
vast majority are either peasants or workers. [ **Op. Cit.** , pp. 688-91] As
historian Michael Palij notes, _"[a]lmost to a man, they [the Makhnovist
leadership] were of poor peasant origin, with little formal education."_ [
**Op. Cit.** , p. 254] Exceptions to the general rule were usually workers.
Most were Anarchists or Socialist-Revolutionaries. [Palij, **Op. Cit.** , pp.
254-62]

Of course, it can be argued that the leadership of a movement need not come
from the class which it claims to lead. The leadership of the Bolsheviks, for
example, had very few actual proletarians within it. However, it seems
unlikely that a class would select as its leaders members of the population it
oppressed! Equally, it seems as unlikely that poor peasants and workers would
let themselves lead a movement of kulaks, whose aims would be alien to theirs.
After all, poor peasants would seek land reform while kulaks would view this
as a threat to their social position. As can be seen from the Makhnovist land
policy, they argued for (and implemented) radical land reform, placing the
land into the hands of peasants who worked the land without hiring labour (see
[section 7](append46.md#app7))

As regards Trotsky's argument that the Makhnovists had to be kulaks because
they originally formed a cavalry unit, it is easy to refute. Makhno himself
was the son of poor peasants, an agricultural labourer and a worker in a
factory. He was able to ride a horse, so why could other poor peasants not do
so? Ultimately, it simply shows that Trotsky knew very little of Ukrainian
peasant life and society.

Given that the Bolshevik government was meant to be a "worker-peasant" power,
it seems strange that Trotsky dismisses the concerns of the peasantry so. He
should have remembered that peasant uprisings against the Bolshevik government
occurred constantly under the Bolsheviks, forcing them (eventually) to, first,
recognise the false nature of their peasant policies in 1919 and, second, to
introduce the NEP in 1921. As such, it seems somewhat ironic for Trotsky to
attack the Makhnovists for not following flawed Bolshevik ideology as regards
the peasantry!

The Bolsheviks, as Marxists, saw the peasants as "petit bourgeoisie" and
uninterested in the revolution except as a means to grab their own plot of
land. Their idea of land collectivisation was limited to state ownership. The
initial Bolshevik land strategy can be summed up as mobilising the poor
peasantry against the rest on the one hand and mobilising the city worker
against the peasants (through forced grain confiscation on the other). The
lack of knowledge of peasant life was the basis of this policy, which was
abandoned in 1919 when it was soon proven to be totally wrong. Rather than see
wealth extremes rise, the 1917 revolution saw a general levelling.

As regards the peasantry, here as elsewhere the Bolsheviks claimed their
strategy was the objectively necessary (only possible) one in the
circumstances. And here again the Makhnovists demonstrate this to be false, as
the Bolsheviks themselves acknowledged in practice by changing their
agricultural policies and bringing them closer to the Makhnovist position.

Clearly, both factually and logically, Trotsky's arguments are false.
Ultimately, like most Bolsheviks, Trotsky uses the term _"kulak"_ as a
meaningless term of abuse, with no relation to the actual class structure of
peasant life. It simply means a peasant opposed to the Bolsheviks rather than
an actual social strata. Essentially, he is using the standard Leninist
technique of specifying a person's class (or ideas) based on whether they
subscribe to (or simply follow without question) Leninist ideology (see
[section H.2.12](secH2.md#sech212) for further discussion of this). This
explains why the Makhnovists went from being heroic revolutionaries to kulak
bandits (and back again!) depending on whether their activity coincided with
the needs of Bolshevik power or not. Expediency is not a sound base to build a
critique, particularly one based simply on assertions like Trotsky's.

## 9 Were the Makhnovists anti-Semitic and pogromists?

No, they were not. Anyone who claims that the Mahnovist movement was anti-
Semitic or conducted pogroms against Jews simply shows ignorance or a desire
to deceive. As we will show, the Makhnovists were both theoretically and
practically opposed to anti-Semitism and progroms.

Unsurprisingly, many Leninists slander the Makhnovists on this score. Trotsky,
for example, asserted in 1937 that Makhno's followers expressed _"a militant
anti-Semitism."_ [Lenin and Trotsky, **Kronstadt** , p. 80] Needless to say,
the Trotskyist editors of the book in question did not indicate that Trotsky
was wrong in the accusation. In this way a slander goes unchecked and becomes
"accepted" as being true. As the charge of _"militant anti-Semitism"_ is a
serious one, so it is essential that we (unlike Trotsky) provide evidence to
refute it.

To do so we will present a chronological overview of the evidence against it.
This will, to some degree, result in some duplication as well as lengthy
quotations, however it is unavoidable. We are sorry to labour this point, but
this allegation is sadly commonplace and it is essential to refute it fully.

Unsurprisingly, Arshinov's 1923 account of the movement takes on the
allegations that the Makhnovists were anti-Semitic. He presents extensive
evidence to show that the Makhnovists opposed anti-Semitism and pogroms. It is
worth quoting him at length:

> _"In the Russian press as well as abroad, the Makhnovshchina was often
> pictured as a very restricted guerrilla movement, foreign to ideas of
> brotherhood and international solidarity, and even tainted with anti-
> Semitism. Nothing could be more criminal than such slanders. In order to
> shed light on this question, we will cite here certain documented facts
> which relate to this subject._
>
> _"An important role was played in the Makhnovist army by revolutionaries of
> Jewish origin, many of whom had been sentenced to forced labour for
> participation in the 1905 revolution, or else had been obliged to emigrate
> to Western Europe or America. Among others, we can mention:_
>
> _" **Kogan** \-- vice-president of the central organ of the movement, the
> Regional Revolutionary Military Council of Hulyai Pole. Kogan was a worker
> who, for reasons of principle, had left his factory well before the
> revolution of 1917, and had gone to do agricultural work in a poor Jewish
> agricultural colony. Wounded at the battle of Peregonovka, near Uman,
> against the Denikinists, he was seized by them at the hospital at Uman where
> he was being treated, and, according to witnesses, the Denikinists killed
> him with sabres. _
>
> _" **L. Zin'kovsky (Zadov)** \-- head of the army's counter espionage
> section, and later commander of a special cavalry regiment. A worker who
> before the 1917 revolution was condemned to ten years of forced labour for
> political activities. One of the most active militants of the revolutionary
> insurrection. _
>
> _" **Elena Keller** \-- secretary of the army's cultural and educational
> section. A worker who took part in the syndicalist movement in America. One
> of the organisers of the 'Nabat' Confederation. _
>
> _" **Iosif Emigrant (Gotman)** \-- Member of the army's cultural and
> educational section. A worker who took an active part in the Ukrainian
> anarchist movement. One of the organisers of the 'Nabat' Confederation, and
> later a member of its secretariat. _
>
> _" **Ya. Alyi (Sukhovol'sky)** \-- worker, and member of the army's cultural
> and educational section. In the Tsarist period he was condemned to forced
> labor for political activity. One of the organisers of the 'Nabat'
> Confederation and a member of its secretariat. _
>
> _"We could add many more names to the long list of Jewish revolutionaries
> who took part in different areas of the Makhnovist movement, but we will not
> do this, because it would endanger their security._
>
> _"At the heart of the revolutionary insurrection, the Jewish working
> population was among brothers. The Jewish agricultural colonies scattered
> throughout the districts of Mariupol, Berdyansk, Aleksandrovsk and
> elsewhere, actively participated in the regional assemblies of peasants,
> workers and insurgents; they sent delegates there, and also to the regional
> Revolutionary Military Council._
>
> _"Following certain anti-Semitic incidents which occurred in the region in
> February, 1919, Makhno proposed to all the Jewish colonies that they
> organise their self-defence and he furnished the necessary guns and
> ammunition to all these colonies. At the same time Makhno organised a series
> of meetings in the region where he appealed to the masses to struggle
> against anti-Semitism._
>
> _"The Jewish working population, in turn, expressed profound solidarity and
> revolutionary brotherhood toward the revolutionary insurrection. In answer
> to the call made by the Revolutionary Military Council to furnish voluntary
> combatants to the Makhnovist insurgent army, the Jewish colonies sent from
> their midst a large number of volunteers._
>
> _"In the army of the Makhnovist insurgents there was an exclusively Jewish
> artillery battery which was covered by an infantry detachment, also made up
> of Jews. This battery, commanded by the Jewish insurgent Shneider,
> heroically defended Hulyai Pole from Denikin's troops in June, 1919, and the
> entire battery perished there, down to the last man and the last shell._
>
> _"In the extremely rapid succession of events after the uprising of 1918-19,
> there were obviously individuals who were hostile to Jews, but these
> individuals were not the products of the insurrection; they were products of
> Russian life. These individuals did not have any importance in the movement
> as a whole. If people of this type took part in acts directed against Jews,
> they were quickly and severely punished by the revolutionary insurgents._
>
> _"We described earlier the speed and determination with which the
> Makhnovists executed Hryhoriyiv and his staff, and we mentioned that one of
> the main reasons for this execution was their participation in pogroms of
> Jews._
>
> _"We can mention other events of this nature with which we are familiar._
>
> _"On May 12, 1919, several Jewish families - 20 people in all - were killed
> in the Jewish agricultural colony of Gor'kaya, near Aleksandrovsk. The
> Makhnovist staff immediately set up a special commission to investigate this
> event. This commission discovered that the murders had been committed by
> seven peasants of the neighbouring village of Uspenovka. These peasants were
> not part of the insurrectionary army. However, the Makhnovists felt it was
> impossible to leave this crime unpunished, and they shot the murderers. It
> was later established that this event and other attempts of this nature had
> been carried out at the instigation of Denikin's agents, who had managed to
> infiltrate the region and had sought by these means to prepare an atmosphere
> favourable for the entry of Denikin's troops into the Ukraine._
>
> _"On May 4th or 5th, 1919, Makhno and a few commanders hurriedly left the
> front and went to Hulyai Pole, where they were awaited by the Extraordinary
> Plenipotentiary of the Republic, L. Kamenev, who had arrived from Khar'kov
> with other representatives of the Soviet government. At the Verkhnii Tokmak
> station, Makhno saw a poster with the words: 'Death to Jews, Save the
> Revolution, Long Live Batko Makhno.'_
>
> _"'Who put up that poster?' Makhno asked._
>
> _"He learned that the poster had been put up by an insurgent whom Makhno
> knew personally, a soldier who had taken part in the battle against
> Denikin's troops, a person who was in general decent. He presented himself
> immediately and was shot on the spot._
>
> _"Makhno continued the journey to Hulyai Pole. During the rest of the day
> and during his negotiations with the Plenipotentiary of the Republic, he
> could not free himself from the influence of this event. He realised that
> the insurgent had been cruelly dealt with, but he also knew that in
> conditions of war and in view of Denikin's advance, such posters could
> represent an enormous danger for the Jewish population and for the entire
> revolution if one did not oppose them quickly and resolutely._
>
> _"When the insurrectionary army retreated toward Uman in the summer of 1919,
> there were several cases when insurgents plundered Jewish homes. When the
> insurrectionary army examined these cases, it was learned that one group of
> four or five men was involved in all these incidents -- men who had earlier
> belonged to Hryhoriyiv's detachments and who had been incorporated into the
> Makhnovist army after Hryhoriyiv was shot. This group was disarmed and
> discharged immediately. Following this, all the combatants who had served
> under Hryhoriyiv were discharged from the Makhnovist army as an unreliable
> element whose re-education was not possible in view of the unfavorable
> conditions and the lack of time. Thus we see how the Makhnovists viewed
> anti-Semitism. Outbursts of anti-Semitism in various parts of the Ukraine
> had no relation to the Makhnovshchina._
>
> _"Wherever the Jewish population was in contact with the Makhnovists, it
> found in them its best protectors against anti-Semitic incidents. The Jewish
> population of Hulyai Pole, Aleksandrovsk, Berdyansk, Mariupol, as well as
> all the Jewish agricultural colonies scattered throughout the Donets region,
> can themselves corroborate the fact that they always found the Makhnovists
> to be true revolutionary friends, and that due to the severe and decisive
> measures of the Makhno visits, the anti-Semitic leanings of the counter-
> revolutionary forces in this region were promptly squashed._
>
> _"Anti-Semitism exists in Russia as well as in many other countries. In
> Russia, and to some extent in the Ukraine, it is not a result of the
> revolutionary epoch or of the insurrectionary movement, but is on the
> contrary a vestige of the past. The Makhnovists always fought it resolutely
> in words as well as deeds. During the entire period of the movement, they
> issued numerous publications calling on the masses to struggle against this
> evil. It can firmly be stated that in the struggle against anti-Semitism in
> the Ukraine and beyond its borders, their accomplishment was enormous."_
> [Arshinov, **Op. Cit.** , pp. 211-215]

Arshinov then goes on to quote an appeal published by Makhnovists together
with anarchists referring to an anti-Semitic incident which took place in the
spring of 1919. It is called **WORKERS, PEASANTS AND INSURGENTS FOR THE
OPPRESSED, AGAINST THE OPPRESSORS -- ALWAYS!** :

> _"During the painful days of reaction, when the situation of the Ukrainian
> peasants was especially difficult and seemed hopeless, you were the first to
> rise as fearless and unconquerable fighters for the great cause of the
> liberation of the working masses. . . This was the most beautiful and joyful
> moment in the history of our revolution. You marched against the enemy with
> weapons in your hands as conscious revolutionaries, guided by the great idea
> of freedom and equality. . . But harmful and criminal elements succeeded in
> insinuating themselves into your ranks. And the revolutionary songs, songs
> of brotherhood and of the approaching liberation of the workers, began to be
> disrupted by the harrowing cries of poor Jews who were being tormented to
> death. . . On the clear and splendid foundation of the revolution appeared
> indelible dark blots caused by the parched blood of poor Jewish martyrs who
> now, as before, continue to be innocent victims of the criminal reaction, of
> the class struggle . . . Shameful acts are being carried out. Anti-Semitic
> pogroms are taking place._
>
> _"Peasants, workers and insurgents! You know that the workers of all
> nationalities -- Russians, Jews, Poles, Germans, Armenians, etc. -- are
> equally imprisoned in the abyss of poverty. You know that thousands of
> Jewish girls, daughters of the people, are sold and dishonoured by capital,
> the same as women of other nationalities. You know how many honest and
> valiant revolutionary Jewish fighters have given their lives for freedom in
> Russia during our whole liberation movement. . . The revolution and the
> honour of workers obliges all of us to declare as loudly as possible that we
> make war on the same enemies: on capital and authority, which oppress all
> workers equally, whether they be Russian, Polish, Jewish, etc. We must
> proclaim everywhere that our enemies are exploiters and oppressors of
> various nationalities: the Russian manufacturer, the German iron magnate,
> the Jewish banker, the Polish aristocrat .. . . The bourgeoisie of all
> countries and all nationalities is united in a bitter struggle against the
> revolution, against the labouring masses of the whole world and of all
> nationalities._
>
> _"Peasants, workers and insurgents! At this moment when the international
> enemy -- the bourgeoisie of all countries -- hurries to the Russian
> revolution to create nationalist hatred among the mass of workers in order
> to distort the revolution and to shake the very foundation of our class
> struggle - the solidarity and unity of all workers -- you must move against
> conscious and unconscious counter-revolutionaries who endanger the
> emancipation of the working people from capital and authority. Your
> revolutionary duty is to stifle all nationalist persecution by dealing
> ruthlessly with all instigators of anti-Semitic pogroms._
>
> _"The path toward the emancipation of the workers can be reached by the
> union of all the workers of the world."_ [quoted by Arshinov, **Op. Cit.** ,
> 215-7]

Arshinov also quotes an order issued by Makhno to _"all revolutionary
insurgents without exception"_ which states, in part, that the _"goal of our
revolutionary army, and of every insurgent participating in it, is an
honourable struggle for the full liberation of the Ukrainian workers from all
oppression."_ This was _"why every insurgent should constantly keep in mind
that there is no place among us for those who, under the cover of the
revolutionary insurrection, seek to satisfy their desires for personal profit,
violence and plunder at the expense of the peaceful Jewish population."_
[quoted by Arshinov, **Op. Cit.** , pp. 217-8]

Unsurprisingly, as an anarchist, Makhno presents a class analysis of the
problem of racism, arguing as follows:

> _"Every revolutionary insurgent should remember that his personal enemies as
> well as the enemies of all the people are the rich bourgeoisie, regardless
> of whether they be Russian, or Jewish, or Ukrainian. The enemies of the
> working people are also those who protect the unjust bourgeois regime, i.e.,
> the Soviet Commissars, the members of repressive expeditionary corps, the
> Extraordinary Commissions which go through the cities and villages torturing
> the working people who refuse to submit to their arbitrary dictatorship.
> Every insurgent should arrest and send to the army staff all representatives
> of such expeditionary corps, Extraordinary Commissions and other
> institutions which oppress and subjugate the people; if they resist, they
> should be shot on the spot. As for any violence done to peaceful workers of
> whatever nationality - such acts are unworthy of any revolutionary
> insurgent, and the perpetrator of such acts will be punished by death."_
> [quoted by Arshinov, **Op. Cit.** , p. 218]

It should also be noted that the chairmen of three Makhnovist regional
congresses were Jewish. The first and second congresses had a Jewish chairman
[Palij, **Op. Cit.** , p. 293], while Voline was the chair for the fourth one
held at Aleksandrovsk. Similarly, one of the heads of the army's counter-
espionage section was Jewish. [Arshinov, **Op. Cit.** , p. 212] Little wonder
both Arshinov and Voline stress that an important role was played by Jews
within the movement.

The Jewish American anarchists Alexander Berkman and Emma Goldman were also in
Russia and the Ukraine during the revolution. Between 1920 and 1921, they were
in contact with anarchists involved with the Makhnovists and were concerned to
verify what they had heard about the movement from Bolshevik and other
sources. Berkman recounts meeting the Jewish anarchist Yossif the Emigrant
(shot by the Bolsheviks in late 1920). Yossif stated that _"Nestor is
merciless toward those guilty of Jew-baiting. Most of you have read his
numerous proclamations against pogroms, and you know how severely he punishes
such things."_ He stressed that any stories of atrocities and pogroms
committed by the Makhnovists were _"lies wilfully spread by the Bolsheviks"_
who _"hate Nestor worse than they do Wrangel."_ For Yossif, _"Makhno
represents the real spirit of October."_ [quoted by Berkman, **Op. Cit.** ,
pp. 187-9] He also notes that Gallina Makhno, Nestor's wife, would _"slightly
raise her voice in indignation when reports of Jew-baiting by **povstantsi**
[partisans] were mentioned. These stories were deliberately spread by the
Bolsheviki, she averred. No-one could be more severe in punishing such
excesses than Nestor. Some of his best comrades are Jews; there are a number
of them in the Revolutionary Soviet and in other branches of the army. Few men
are so loved and respected by the **povstantsi** as Yossif the Emigrant, who
is a Jew, and Makhno's best friend."_ [Berkman, **Op. Cit.** , pp. 238-9] Both
Goldman and Berkman became friends with Makhno during his exile in Paris.

After his exile, Makhno himself spent time refuting allegations of anti-
Semitism. Two articles on this subject are contained in **The Struggle Against
the State and other Essays** , a collection of Makhno's exile writings. In the
article _"The Makhnovshchina and Anti-Semitism"_ he recounts various examples
of the _"uncompromising line on the anti-Semitism of pogromists"_ which the
Makhnovists took _"throughout its entire existence."_ This was _"because it
was a genuinely revolutionary toilers' movement in the Ukraine."_ He stressed
that _"[a]t no time did the movement make it its business to carry out pogroms
against Jews nor did it ever encourage any."_ [ **The Struggle Against the
State and Other Essays** , p. 38 and p. 34] He wrote another article (called
_"To the Jews of All Countries"_ ):

> _"In my first 'Appeal to Jews, published in the French libertarian
> newspaper, **Le Libertaire** , I asked Jews in general, which is to say the
> bourgeois and the socialist ones as well as the 'anarchist' ones like
> Yanovsky, who have all spoken of me as a pogromist against Jews and labelled
> as anti-Semitic the liberation movement of the Ukrainian peasants and
> workers of which I was the leader, to detail to me the specific facts
> instead of blathering vacuously away: just where and just when did I or the
> aforementioned movement perpetrate such acts? . . . Thus far, no such
> evidence advanced by Jews has come to my attention. The only thing that has
> appeared thus far in the press generally, certain Jewish anarchist organs
> included, regarding myself and the insurgent movement I led, has been the
> product of the most shameless lies and of the vulgarity of certain political
> mavericks and their hirelings."_ [ **Op. Cit.** , p. 28]

It should be noted that Yanovsky, editor of the Yiddish language anarchist
paper **Freie Arbeiter Stimme** later admitted that Makhno was right. Yanovsky
originally believed the charges of anti-Semitism made against Makhno, going so
far as ignoring Makhno's appeal to him out of hand. However, by the time of
Makhno's death in 1934, Yanovsky had learned the truth:

> _"So strongly biased was I against him [Makhno] at that time I did not think
> it necessary to find out whether my serious accusation was founded on any
> real facts during the period of his great fight for real freedom in Russia.
> Now I know that my accusations of anti-Semitism against Makhno were built
> entirely on the lies of the Bolsheviks and to the rest of their crimes must
> be added this great crime of killing his greatness and the purity of this
> fighter for freedom."_

Due to this, he could not forgive himself for _"so misjudg[ing] a man merely
on the basis of calumny by his bitter enemies who more than once shamefully
betrayed him, and against whom he fought so heroically."_ He also notes that
it had _"become known to me that a great many Jewish comrades were heart and
soul with Makhno and the whole Makhno movement. Amongst them was one whom I
knew well personally, Joseph Zutman of Detroit, and I know that he would not
have had anything to do with persons, or a movement, which possessed the
slightest leaning towards anti-Semitism."_ [ _"appendix,"_ **My Visit to the
Kremlin** , pp. 36-7]

However, by far the best source to refute claims of anti-Semitism the work of
the Jewish anarchist Voline. He summarises the extensive evidence against such
claims:

> _"We could cover dozens of pages with extensive and irrefutable proofs of
> the falseness of these assertions. We could mention articles and
> proclamations by Makhno and the Council of Revolutionary Insurgents
> denouncing anti-Semitism. We could tell of spontaneous acts by Makhno
> himself and other insurgents against the slightest manifestation of the
> anti-Semitic spirit on the part of a few isolated and misguided unfortunates
> in the army and the population. . . One of the reasons for the execution of
> Grigoriev by the Makhnovists was his anti-Semitism and the immense pogrom he
> organised at Elizabethgrad . . ._
>
> _"We could cite a whole series of similar facts, but we do not find it
> necessary . . . and will content ourselves with mentioning briefly the
> following essential facts:_
>
> _"1. A fairly important part in the Makhnovist movement was played by
> revolutionists of Jewish origin._
>
> _"2. Several members of the Education and Propaganda Commission were
> Jewish._
>
> _"3. Besides many Jewish combatants in various units of the army, there was
> a battery composed entirely of Jewish artillery men and a Jewish infantry
> unit._
>
> _"4. Jewish colonies in the Ukraine furnished many volunteers to the
> Insurrectionary Army._
>
> _"5. In general the Jewish population, which was very numerous in the
> Ukraine, took an active part in all the activities of the movement. The
> Jewish agricultural colonies which were scattered throughout the districts
> of Mariupol, Berdiansk, Alexandrovsk, etc., participated in the regional
> assemblies of workers, peasants and partisans; they sent their delegates to
> the regional Revolutionary Military Council._
>
> _"6. Rich and reactionary Jews certainly had to suffer from the Makhnovist
> army, not as Jews, but just in the same way as non-Jewish counter-
> revolutionaries."_ [ **The Unknown Revolution** , pp. 967-8]

However, it could be claimed that these accounts are from anarchists and so
are biased. Ignoring the question of why so many Jewish anarchists should
defend Makhno if he was, in fact, a pogromist or anti-Semite, we can turn to
non-anarchist sources for confirmation of the fact that Makhno and the
Makhnovist movement were not anti-Semites.

First, we turn to Voline, who quotes the eminent Jewish writer and historian
M. Tcherikover about the question of the Makhnovists and anti-Semitism.
Tcherikover had, for a number of years, had specialised in research on the
persecutions of the Jews in Russia. The Jewish historian states _"with
certainty that, on the whole, the behaviour of Makhno's army cannot be
compared with that of the other armies which were operating in Russian during
the events 1917-21. Two facts I can certify absolutely explicitly._

_"1. It is undeniable that, of all these armies, including the Red Army, the
Makhnovists behaved best with regard the civil population in general and the
Jewish population in particular. I have numerous testimonies to this. The
proportion of **justified** complaints against the Makhnovist army, in
comparison with the others, is negligible. _

_"2. Do not speak of pogroms alleged to have been organised by Makhno himself.
That is a slander or an error. Nothing of the sort occurred. As for the
Makhnovist Army, I have had hints and precise denunciations on this subject.
But, up to the present, every time I have tried to check the facts, I have
been obliged to declare that on the day in question no Makhnovist unit could
have been at the place indicated, the whole army being far away from there.
Upon examining the evidence closely, I established this fact, every time, with
absolute certainty, at the place and on the date of the pogrom, no
**Makhnovist** unit was operating or even located in the vicinity. **Not
once** have I been able to prove the existence of a Makhnovist unit at the
place a pogrom against the Jews took place. Consequently, the pogroms in
question could not have been the work of the Makhnovists."_ [quoted by Voline,
**Op. Cit.** , p. 699]

This conclusion is confirmed by later historians. Paul Avrich notes that
_"[c]harges of Jew-baiting and of anti-Jewish pogroms have come from every
quarter, left, right, and centre. Without exception, however, they are based
on hearsay, rumour, or intentional slander, and remain undocumented and
unproved."_ He adds that the _"Soviet propaganda machine was at particular
pains to malign Makhno as a bandit and pogromist."_ Wishing to verify the
conclusions of Tcherikover proved by Voline, Avrich examined several hundred
photographs in the Tcherikover Collection, housed in the YIVO Library in New
York and depicting anti-Jewish atrocities in the Ukraine during the Civil War.
He found that _"only one [was] labelled as being the work of the Makhnovists,
though even here neither Makhno himself nor any of his recognisable
subordinates are to be seen, nor is there any indication that Makhno had
authorised the raid or, indeed, that the band involved was in fact affiliated
with his Insurgent Army."_ Avrich then states that _"there is evidence that
Makhno did all in his power to counteract anti-Semitic tendencies among his
followers"_ and that _"a considerable number of Jews took part in the
Makhnovist movement."_ He also points out that the Jewish anarchists Alexander
Berkman, Emma Goldman, Sholem Schwartzbard, Voline, Senya Fleshin, and Mollie
Steimer did not criticise Makhno as an anti-Semite, they also _"defended him
against the campaign of slander that persisted from all sides."_ [ **Anarchist
Portraits** , pp. 122-3] It should be noted that Schwartzbard assassinated the
Nationalist leader Petliura in 1926 because he considered him responsible for
pogroms conducted by Nationalist troops during the civil war. He shot Petliura
the day after he, Makhno and Berkman had seen him at a Russian restaurant in
Paris. [Malet, **Op. Cit.** , p. 189]

Michael Malet, in his account of the Makhnovists, states that _"there is
overwhelming evidence that Makhno himself was not anti-Semitic."_ [ **Op.
Cit.** , p. 168] He indicates that in the period January to September 1919,
the Central Committee of Zionist Organisations in Russia listed the
Nationalists as creating 15,000 victims of pogroms, then the Denikinists with
9,500 followed by Hryhoriyiv, Sokolovsky, Struk, Yatsenko and Soviet troops
(500 victims). Makhno is not mentioned. Of the pogroms listed, almost all took
place on the western Ukraine, where the local otamany (warlords) and the
Nationalists were strong. Very few took place where Makhno's influence
predominated, the nearest being in Katerinoslav town and Kherson province;
none in the provinces of Katerinoslav or Tavria. It should also be noted that
the period of January to June of that year was one of stability within the
Makhnovist region, so allowing them the space to apply their ideas. Malet
summarises:

> _"Even granted the lower level of Jewish involvement in left-bank trade, the
> almost total lack of anti-Semitic manifestations would show that Makhno's
> appeals, at a time when anti-Semitism was fast becoming fashionable, did not
> go unheeded by the population. There were a number of Jewish colonies in the
> south-east Ukraine."_ [ **Op. Cit.** , p. 169]

Unsurprisingly, Malet notes that apart from certain personal considerations
(such as his friendship with a number of Jews, including Voline and Yossif the
Emigrant), _"the basis of Makhno's hostility to anti-Semitism was his
anarchism. Anarchism has always been an international creed, explicitly
condemning all forms of racial hatred as incompatible with the freedom of
individuals and the society of equals."_ And like other serious historians, he
points to _"the continual participation in the movement of both intellectual
Jews from outside, and Jews from the local colonies"_ as _"further proof . . .
of the low level of anti-Semitism within the Makhnovshchina."_ [ **Op. Cit.**
, p. 171 and pp. 171-2]

Anarchist Serge Cipko summarises the literature by stating that the
_"scholarly literature that discusses Makhno's relationships with the Jewish
population is of the same opinion [that the Makhnovists were not anti-Semitic]
and concur that unlike the Whites, Bolsheviks and other competing groups in
Ukraine during the Revolution, the Makhnovists did not engage in pogroms."_ [
_"Nestor Makhno: A Mini-Historiography of the Anarchist Revolution in Ukraine,
1917-1921,"_ pp. 57-75, **The Raven** , no. 13, p. 62]

Historian Christopher Reed concurs, noting that _"Makhno actively opposed
anti-Semitism . . . Not surprisingly, many Jews held prominent positions in
the Insurgent movement and Jewish farmers and villagers staunchly supported
Makhno in the face of the unrestrained anti-Semitism of Ukrainian nationalists
like Grigoriev and of the Great Russian chauvinists like the Whites."_ [ **Op.
Cit.** , pp. 263-4] Arthur E. Adams states that _"Makhno protected Jews and in
fact had many serving on his own staff."_ [ **Bolsheviks in the Urkaine** , p.
402]

We apologise again for labouring this point, but the lie that Makhno and the
Makhnovists were anti-Semitic is relatively commonplace and needs to be
refuted. As noted, Trotskyists repeat Trotsky's false assertions without
correction. Other repeat the lie from other sources. It was essential,
therefore, to spend time making the facts available and to nail the lie of
Makhnovist anti- Semitism once and for all!

## 10 Did the Makhnovists hate the city and city workers?

For some reason the Makhnovists have been portrayed as being against the city
and even history as such. This assertion is false, although sometimes made.
For example, historian Bruce Lincoln states that Makhno _"had studied the
anarchist writings of Bakunin, whose condemnation of cities and large-scale
industries fit so well with the anti-urban, anti-industrial feelings of the
Ukrainian peasants, and his program was precisely the sort that struck
responsive chords in peasant hearts."_ [ **Red Victory** , p. 325] Lincoln
fails to present any evidence for this claim. This is unsurprising as it is
doubtful that Makhno read such condemnations in Bakunin as they do not, in
fact, exist. Similarly, the Makhnovist _"program"_ (like anarchism in general)
was not _"anti-urban"_ or _"anti-industrial."_

However, Lincoln's inventions are mild compared to Trotsky's. According to
Trotsky, _"the followers of Makhno"_ were marked by _"hatred for the city and
the city worker."_ He later gives some more concrete examples of this
_"hostility to the city"_ which, as with the general peasant revolt, also
_"nourished the movement of Makhno, who seized and looted trains marked for
the factories, the plants, and the Red Army; tore up railway tracks, shot
Communists, etc."_ [Lenin and Trotsky, **Kronstadt** , p. 80 and p. 89]

Unsurprisingly, Trotsky simply shows his ignorance of the Makhno movement by
these statements. To refute Trotsky's claim we can simply point to how the
Makhnovists acted once they occupied a city. As we discuss in [section
7](append46.md#app7), the first thing the Makhnovists did was to call a
conference of workers and urge them to organise their own affairs directly,
using their own class organs of self-management (soviets, unions, etc.).
Hardly the activity of a group of people who allegedly _"hated"_ city workers!

We can also point to the fact that the Makhnovists arranged direct exchanges
of goods between the towns and country. In early 1918, for example, corn was
shipped directly to a Moscow factory in return for textiles (without state
interference). In 1919, 1500 tons of grain (and a small amount of coal) was
sent by train to Petrograd and Moscow where the commander of the train was to
exchange it again for textiles. The initiative in both cases came from the
Hulyai Pole peasants. Again, hardly the work of city-hating peasants.

Peter Arshinov indicates the underlying theory behind the Makhnovists as
regards the relations between city and country:

> _"The Makhnovshchina . . . understands that the victory and consolidation of
> the revolution . . . cannot be realised without a close alliance between the
> working classes of the cities and those of the countryside. The peasants
> understand that without urban workers and powerful industrial enterprises
> they will be deprived of most of the benefits which the social revolution
> makes possible. Furthermore, they consider the urban workers to be their
> brothers, members of the same family of workers._
>
> _"There can be no doubt that, at the moment of the victory of the social
> revolution, the peasants will give their entire support to the workers. This
> will be voluntary and truly revolutionary support given directly to the
> urban proletariat. In the present-day situation [under the Bolsheviks], the
> bread taken by force from the peasants nourishes mainly the enormous
> governmental machine. The peasants see and understand perfectly that this
> expensive bureaucratic machine is not in any way needed by them or by the
> workers, and that in relation to the workers it plays the same role as that
> of a prison administration toward the inmates. This is why the peasants do
> not have the slightest desire to give their bread voluntarily to the State.
> This is why they are so hostile in their relations with the contemporary tax
> collectors -- the commissars and the various supply organs of the State._
>
> _"But the peasants always try to enter into **direct** relations with the
> urban workers. The question was raised more than once at peasant congresses,
> and the peasants always resolved it in a revolutionary and positive
> manner."_ [ **Op. Cit.** , p. 258]

Simply put, Trotsky misinterprets hostility to the repressive policies of the
Bolshevik dictatorship with hostility to the city.

Moreover, ignoring the **actual** relationships of the Makhnovists with the
city workers, we can fault Trotsky's arguments without resource to such minor
things as facts. This is because every one of his "examples" of _"hatred for
the city and the city worker"_ can be explained by more common sense
arguments.

As regards the destruction of trains and railway tracks, a far simpler and
more plausible explanation can be found than Trotsky's _"hostility to the
city."_ This is the fact that a civil war was taking place. Both the Reds and
Whites used armoured trains to move troops and as bases of operations. To
destroy the means by which your enemy attacks you is common sense! Equally, in
the chaotic times of the war, resources were often in low supply and in order
to survive the Makhnovists had to _"loot"_ trains (needless to say, Trotsky
does not explain how the Makhnovists knew the trains were _"marked for the
factories."_ ). It should be noted that the Bolsheviks _"looted"_ the
countryside, can we surmise that the Bolsheviks simply expressed _"hostility
to the village"_?

As regards the shooting of Communists, a far simpler and more plausible
explanation also exists. Rather than show _"hostility to the city,"_ it shows
_"hostility"_ to the Communist Party, its policies and its authoritarian
ideas. Given that the Bolsheviks had betrayed the Makhnovists on _**three**_
occasions (see [section 13](append46.md#app13)) and attacked them,
_"hostility"_ to Communists seems a sensible position to take! Equally, the
first Bolshevik attack on the Makhnovists occurred in mid-1919, when the
Bolsheviks began justifying their party dictatorship as essential for the
success of the revolution. The other two occurred in 1920, when the Bolsheviks
were announcing to the whole world at the Communist International (to quote
Zinoviev) that _"the dictatorship of the proletariat is at the same time the
dictatorship of the Communist Party."_ [ **Proceedings and Documents of the
Second Congress 1920** , vol. 1, p. 152] Given this, perhaps the fact that the
Makhnovists shot Communists can be explained in terms of defence against
Bolshevik betrayal and opposition to the dictatorship of the Communist Party
rather than _"hostility to the city."_ Needless to say, the Communists shot
Makhnovists and anarchists. What does that suggest a _"hostility"_ to by the
Bolsheviks? Working-class autonomy and freedom?

Clearly, Trotsky was clutching at straws in his smearing of the Makhnovist
movement as haters of the city worker. The _"hostility"_ Trotsky speaks of can
be far more easily explained in terms of the necessities imposed upon the
Makhnovists by the civil war and the betrayals of the Bolsheviks. As such, it
would be fairer to state that the Makhnovists showed _"hostility"_ or
_"hatred"_ to the city or city workers only if you equate both with the
Bolshevik party dictatorship. In other words, the Makhnovists showed
_"hostility"_ to the new ruling class of the Communist Party hierarchy.

All this does not mean that there were not misunderstandings between the
Makhno movement, a predominantly rural movement, and the workers in the
cities. Far from it. Equally, it can be said that the Makhnovists did not
understand the workings of an urban economy and society as well as they
understood their own. However, they made no attempt to **impose** their world-
view on the city workers (unlike the Bolsheviks, who did so on both urban and
rural workers). However, ignorance of the city and its resulting
misunderstandings do not constitute _"hostility"_ or _"hatred."_

Moreover, where these misunderstandings developed show that the claims that
the Makhnovists hated the city workers are simply false. Simply put, the
misunderstanding occurred when the Makhnovists had liberated cities from the
Whites. As we discussed in [section 7](append46.md#app7), the first thing
the Makhnovists did was to call a conference of workers' delegates to discuss
the current situation and to urge them to form soviets, unions and co-
operatives in order to manage their own affairs. This hardly shows _"hatred"_
of the city worker. In contrast, the first thing the Bolsheviks did in taking
a city was to form a _"revolutionary committee"_ to govern the town and
implement Bolshevik policy.

This, needless to say, shows a distinct _"hostility"_ to the city workers on
the part of the Bolsheviks. Equally, the Bolshevik advocacy of party
dictatorship to overcome the _"wavering"_ of the working class. In the words
of Trotsky himself (in 1921):

> _"The Workers' Opposition has come out with dangerous slogans, making a
> fetish of democratic principles! They place the workers' right to elect
> representatives above the Party, as if the party were not entitled to assert
> its dictatorship even if that dictatorship temporarily clashed with the
> passing moods of the workers' democracy. It is necessary to create amongst
> us the awareness of the revolutionary birthright of the party. which is
> obliged to maintain its dictatorship, regardless of temporary wavering even
> in the working classes. This awareness is for us the indispensable element.
> The dictatorship does not base itself at every given moment on the formal
> principle of a workers' democracy."_ [quoted by Samuel Farber, **Before
> Stalinism** , p. 209]

Opposing workers' democracy because working people could make decisions that
the party thought were wrong shows a deep _"hostility"_ to the **real** city
workers and their liberty and equality. Equally, Bolshevik repression of
workers' strikes, freedom of speech, assembly, organisation and self-
determination shows far more _"hostility"_ to the city worker than a few
Makhnovist misunderstandings!

All in all, any claim that the Makhnovists _"hated"_ city workers is simply
false. While some Makhnovists may not have liked the city nor really
understood the complexities of an urban economy, they did recognise the
importance of encouraging working-class autonomy and self-organisation within
them and building links between the rural and urban toilers. While the lack of
a large-scale anarcho-syndicalist movement hindered any positive construction,
the Makhnovists at least tried to promote urban self-management. Given
Bolshevik authoritarianism and its various rationalisations, it would be
fairer to say that it was the Bolsheviks who expressed _"hostility"_ to the
city workers by imposing their dictatorship upon them rather than supporting
working-class self-management as the Makhnovists did!

## 11 Were the Makhnovists nationalists?

Some books on the Makhnovist movement try to present the Makhnovists as being
Ukrainian nationalists. A few discuss the matter in order, perhaps, to
increase the respectability of the Makhnovist movement by associating it with
a more _"serious"_ and _"respectable"_ political theory than anarchism, namely
_"Nationalism."_ Those who seriously investigate the issue come to the same
conclusion, namely that neither Makhno nor the Makhnovist movement was
nationalist (see, for example, Frank Sysyn's essay **Nestor Makhno and the
Ukrainian Revolution** which discusses this issue).

Therefore, any claims that the Makhnovists were nationalists are incorrect.
The Makhnovist movement was first and foremost an internationalist movement of
working people. This is to be expected as anarchists have long argued that
nationalism is a cross-class movement which aims to maintain the existing
class system but without foreign domination (see [section D.6](secD6.md) for
details). As such, the Makhnovists were well aware that nationalism could not
solve the social question and would simply replace a Russian ruling class and
state with a Ukrainian one.

This meant that the aims of the Makhnovists went further than simply national
liberation or self-determination. Anarchists, rather, aim for working-class
self-liberation and self-determination, both as individuals and as groups, as
well as politically, economically and socially. To quote Makhno's wire to
Lenin in December 1918, the Makhnovist _"aims are known and clear to all. They
are fighting against the authority of all political governments and for
liberty and independence of the working people."_ [quoted by Palij, **Op.
Cit.** , p. 80]

From this class and anti-hierarchical perspective, it is not unsurprising that
the Makhnovists were not nationalists. They did not seek Ukrainian
independence but rather working- class autonomy. This, of necessity, meant
they opposed all those who aimed to govern and/or exploit the working class.
Hence Arshinov:

> _"Composed of the poorest peasants, who were united by the fact that they
> all worked with their own hands, the Makhnovist movement was founded on the
> deep feeling of fraternity which characterises only the most oppressed.
> During its entire history it did not for an instant appeal to national
> sentiments. The whole struggle of the Makhnovists against the Bolsheviks was
> conducted solely in the name of the rights and interests of the workers.
> Denikin's troops, the Austro-Germans, Petliura, the French troops in
> Berdyansk, Wrangel -- were all treated by the Makhnovists as enemies of the
> workers. Each one of these invasions represented for them essentially a
> threat to the workers, and the Makhnovists had no interest in the national
> flag under which they marched."_ [ **Op. Cit.** , p. 210]

He stressed that _"national prejudices had no place in the Makhnovshchina.
There was also no place in the movement for religious prejudices . . . Among
modern social movements, the Makhnovshchina was one of the few in which an
individual had absolutely no interest in his own or his neighbour's religion
or nationality, in which he respected only the labour and the freedom of the
worker."_ [ **Op. Cit.** , p. 211]

The Makhnovists made their position on nationalism clear in the 'Declaration'
published by the Revolutionary Military Council of the army in October, 1919:

> _"When speaking of Ukrainian independence, we do not mean national
> independence in Petliura's sense but the social independence of workers and
> peasants. We declare that Ukrainian, and all other, working people have the
> right to self-determination not as an 'independent nation' but as
> 'independent workers'"_ [quoted by Arshinov, **Op. Cit.** , p. 210]

In other words, the Makhnovists _"declared, that in their option
**Petlurovtchina** [the Petliura movement, Petliura being the leader of the
Nationalists] was a bourgeois nationalist movement whose road was entirely
different from that of the revolutionary peasants, that the Ukraine should be
organised on a basis of free labour and the independence of the peasants and
the workers . . . and that nothing but struggle was possible between the
**Makhnovitchina** , the movement of the workers, and the **Petlurovtchina** ,
the movement of the bourgeoisie."_ [Voline, **Op. Cit.** , p. 572]

This does not mean that anarchists are indifferent to cultural and national
domination and oppression. Far from it! As we discussed in sections
[D.6](secD6.md) and [D.7](secD7.md), anarchists are against foreign
domination and cultural imperialism, believing that every community or
national group has the right to be itself and develop as it sees fit. This
means that anarchists seek to transform national liberation struggles into
**human** liberation struggles, turning any struggle against foreign
oppression and domination into a struggle against **all** forms of oppression
and domination.

This means that the Makhnovists, like anarchists in general, seek to encourage
local culture and language while opposed nationalism. As Frank Sysyn argues,
it _"would be a mistake . . . to label the Makhnivtsi as 'anti-Ukrainian.'
Although they opposed the political goals of most 'svidomi ukraintsi'
(nationally conscious Ukrainians), they accepted the existence of a Ukrainian
nation and used the terms 'Ukraine' and 'Ukrainian.'"_ [ **Nestor Makhno and
the Ukrainian Revolution** , p. 288] It should be noted that opponents of
Ukrainian independence generally called it the _"south of Russia"_ or _"Little
Russia."_

Thus an opposition to nationalism did not imply a rejection or blindness to
foreign domination and free cultural expression. On the question of the
language to be taught in schools, the Cultural-Educational Section of the
Makhnovist Insurgent Army wrote the following in October, 1919:

> _"The cultural-educational section of the Makhnovist army constantly
> receives questions from school teachers asking about the language in which
> instruction should be given in the schools, now that Denikin's troops have
> been expelled._
>
> _"The revolutionary insurgents, holding to the principles of true socialism,
> cannot in any field or by any measure do violence to the natural desires and
> needs of the Ukrainian people. This is why the question of the language to
> be taught in the schools cannot be solved by our army, but can only be
> decided by the people themselves, by parents, teachers and students_
>
> _"It goes without saying that all the orders of Denikin's so-called 'Special
> Bureau' as well as General Mai-Maevsky's order No. 22, which forbids the use
> of the mother tongue in the schools, are null and void, having been forcibly
> imposed on the schools._
>
> _"In the interest of the greatest intellectual development of the people,
> the language of instruction should be that toward which the local population
> naturally tends, and this is why the population, the students, the teachers
> and the parents, and not authorities or the army, should freely and
> independently resolve this question."_ [quoted by Arshinov, **Op. Cit.** ,
> pp. 210-1]

They also printed a Ukrainian version of their paper ( _"The Road to Freedom"_
).

Clearly their opposition to Ukrainian nationalism did not mean that the
Makhnovists were indifferent to imperialism and foreign political or cultural
domination. This explains why Makhno criticised his enemies for anti-Ukrainian
actions and language. Michael Malet summarises, for the Makhnovists
_"Ukrainian culture was welcome, but political nationalism was highly
suspect."_ [ **Op. Cit.** , p. 143]

Given anarchist support for federal organisation from below upwards, working-
class self-determination and autonomy, plus a healthy respect for local
culture, it is easy to see why some historians have fostered a nationalist
perspective onto the Makhnovists where none existed. This means that when they
agitated with the slogan _"All to whom freedom and independence are dear
should stay in the Ukraine and fight the Denikinists,"_ it should be noted
that _"[n]owhere .. . . nationalism openly advocated, and the line of argument
put forward can more easily be interpreted as libertarian and, above all,
anti-White."_ [Malet, **Op. Cit.** , p. 146]

In 1928, Makhno wrote a rebuttal to a Soviet historian's claim that Makhno
became a Ukrainian Nationalist during the 1920-21 period. He _"totally
dismissed the charges"_ and argued that the historian _"distorted anarchism's
espousal of local autonomy so as to create trumped-up charges of
nationalism."_ As Sysyn argues, while Makhno _"never became a nationalist, he
did to a degree become a Ukrainian anarchist."_ [ **Op. Cit.** , p. 292 and p.
303]

Thus while neither Makhno nor the movement were nationalists, they were not
blind to national and cultural oppression. They considered nationalism as too
narrow a goal to satisfy the **social** aspirations of the working classes. As
Makhno argued in exile, the Ukrainian toilers had _"asserted their rights to
use their own language and their entitlement to their own culture, which had
been regarded before the revolution as anathema. They also asserted their
right to conform in their lives to their own way of life and specific
customs."_ However, _"[i]n the aim of building an independent Ukrainian State,
certain statist gentlemen would dearly love to arrogate to themselves all
natural manifestations of Ukrainian reality."_ Yet the _"healthy instincts of
the Ukrainian toilers and their baleful life under the Bolshevik yoke has not
made them oblivious of the State danger in general"_ and so they _"shun the
chauvinist trend and do not mix it up with their social aspirations, rather
seeking their own road to emancipation."_ [ **The Struggle Against the State
and Other Essays** , pp. 24-5]

In summary, the Makhnovists were opposed to nationalism but supported culture
diversity and self-determination within a free federation of toilers communes
and councils. They did not limit their aims to national liberation, but rather
sought the self-liberation of the working classes from every oppression --
foreign or domestic, economic or political, cultural or social.

## 12 Did the Makhnovists support the Whites?

No, they did not. However, black propaganda by the Bolsheviks stated they did.
Victor Serge wrote about the _"strenuous calumnies put out by the Communist
Party"_ against him _"which went so far as to accuse him of signing pacts with
the Whites at the very moment when he was engaged in a life-and-death struggle
against them."_ [ **Memoirs of a Revolutionary** , p. 122]

According to Arshinov, _"Soviet newspapers spread the false news of an
alliance between Makhno and Wrangel"_ and in the summer of 1920, a
representative of the Kharkov government _"declared at the Plenary Session of
the Ekaterinoslav Soviet, that Soviet authorities had written proof of the
alliance between Makhno and Wrangel. This was obviously an intentional lie."_
Wrangel, perhaps believing these lies had some basis, sent a messenger to
Makhno in July, 1920. _"Wrangel's messenger was immediately executed"_ and the
_"entire incident was reported in the Makhnovist press. All this was perfectly
clear to the Bolsheviks. They nevertheless continued to trumpet the alliance
between Makhno and Wrangel. It was only after a military-political agreement
had been concluded between the Makhnovists and the Soviet power that the
Soviet Commissariat of War announced that there had never been an alliance
between Makhno and Wrangel, that earlier Soviet assertions to this effect were
an error."_ [ **Op. Cit.** , pp. 173-5]

Needless to say, while the Bolsheviks spread the rumour to discredit Makhno,
the Whites spread it to win the confidence of the peasants. Thus when Trotsky
stated that Wrangel had _"united with the Ukrainian partisan Makhno,"_ he was
aiding the efforts of Wrangel to learn from previous White mistakes and build
some kind of popular base. [quoted by Palij, **Op. Cit.** , p. 220] By
October, Trotsky had retracted this statement:

> _"Wrangel really tried to come into direct contact with Makhno's men and
> dispatched to Makhno's headquarters two representatives for negotiations . .
> . [However] Makhno's men not only did not enter into negotiations with the
> representatives of Wrangel, but publicly hanged them as soon as they arrived
> at the headquarters."_ [quoted by Palij, **Ibid.** ]

Trotsky, of course, still tried to blacken the Makhnovists. In the same
article he argued that _"[u]ndoubtedly Makhno actually co-operated with
Wrangel, and also with the Polish **szlachta** , as he fought with them
against the Red Army. However, there was no formal alliance between them. All
the documents mentioning a formal alliance were fabricated by Wrangel . . .
All this fabrication was made to deceive the protectors of Makhno, the French,
and other imperialists."_ [quoted by Palij, **Op. Cit.** , p. 225]

It is hard to know where to start in this amazing piece of political story-
telling. As we discuss in more detail in [section 13](append46.md#app13),
the Makhnovists were fighting the Red Army from January to September 1920
because the Bolsheviks had engineered their outlawing! As historian David
Footman points out, the attempt by the Bolsheviks to transfer Makhno to Polish
front was done for political reasons:

> _"it is admitted on the Soviet side that this order was primarily 'dictated
> by the necessity' of liquidating **Makhnovshchina** as an independent
> movement. Only when he was far removed from his home country would it be
> possible to counteract his influence"_ [ **Op. Cit.** , p. 291]

Indeed, it could be argued that by attacking Makhno in January helped the
Whites to regroup under Wrangel and return later in the year. Equally, it
seems like a bad joke for Trotsky to blame the victim of Bolshevik intrigues
for defending themselves. And the idea that Makhno had _"protectors"_ in any
imperialist nation is a joke, which deserves only laughter as a response!

It should be noted that it is _"agreed that the initiative for joint action
against Wrangel came from the Makhnovites."_ This was ignored by the
Bolsheviks until after _"Wrangel started his big offensive"_ in September 1920
[Footman, **Op. Cit.** , p. 294 and p. 295]

So while the Bolsheviks claimed that the Makhnovists had made a pact with
General Wrangel, the facts are that Makhnovists fought the Whites with all
their energy. Indeed, they considered the Whites so great a threat to the
revolution they even agreed to pursue a pact with the Bolsheviks, who had
betrayed them twice already and had subjected both them and the peasantry to
repression. As such, it could be argued that the Bolsheviks were the only
counter-revolutionaries the Makhnovists can be accurately accused of
collaborating with.

Every historian who has studied the movement has refuted claims that the
Makhnovist movement made any alliance with the counter-revolutionary White
forces. For example, Michael Palij notes that Denikin _"was the main enemy
that Makhno fought, stubbornly and uncompromising, from the end of 1918 to the
end of 1919. Its social and anti-Ukrainian policies greatly antagonised all
segments of Ukrainian society. The result of this was an increased resistance
to the Volunteer Army and its regime and a substantial strengthening of the
Makhno movement."_ He also notes that after several months of _"hard
fighting"_ Denikin's troops _"came to regard Makhno's army as their most
formidable enemy."_ Makhno's conflict with Wrangel was equally as fierce and
_"[a]lthough Makhno had fought both the Bolsheviks and Wrangel, his
contribution to the final defeat of the latter was essential, as is proved by
the efforts of both sides to have him as an ally."_ [ **Op. Cit.** , p. 177,
p. 202 and p. 228] According to Footman, Makhno _"remained to the end the
implacable enemy of the Whites."_ [ **Op. Cit.** , p. 295] Malet just states
the obvious: _"The Makhnovists were totally opposed to the Whites."_ [ **Op.
Cit.** , p. 140]

We will leave the last word to the considered judgement of the White General
Denikin who, in exile, stated that the Makhno movement was _"the most
antagonistic to the idea of the White movement."_ [quoted by Malet, **Op.
Cit.** , p. 140]

In summary, the Makhnovists fought the White counter-revolution with all their
might, playing a key role in the struggle and defeat of both Denikin and
Wrangel. Anyone who claims that they worked with the Whites is either ignorant
or a liar.

## 13 What was the relationship of the Bolsheviks to the movement?

The Makhnovists worked with the Bolsheviks in three periods. The first (and
longest) was against Denikin after the Red Army had entered the Ukraine after
the withdrawal of the Austro-Germans. The second was an informal agreement for
a short period after Denikin had been defeated. The third was a formal
political and military agreement between October and November 1920 in the
struggle against Wrangel. Each period of co-operation ended with Bolshevik
betrayal and conflict between the two forces.

As such, the relationship of the Bolsheviks to the Makhnovists was one of, at
best, hostile co-operation against a common enemy. Usually, it was one of
conflict. This was due, fundamentally, to two different concepts of social
revolution. While the Makhnovists, as anarchists, believed in working-class
self-management and autonomy, the Bolsheviks believed that only a centralised
state structure (headed by themselves) could ensure the success of the
revolution. By equating working-class power with Bolshevik party government
(and from 1919 onwards, with the dictatorship of the Bolshevik party), they
could not help viewing the Makhnovist movement as a threat to their power (see
[section 14](append46.md#app14) for a discussion of the political
differences and the evolving nature of the Bolshevik's conception of party
rule).

Such a perspective ensured that they could only co-operate during periods when
the White threat seemed most dangerous. As soon as the threat was defeated or
they felt strong enough, the Bolsheviks turned on their former allies
instantly. This section discusses each of the Bolshevik betrayals and the
subsequent conflicts. As such, it is naturally broken up into three parts,
reflecting each of the betrayals and their aftermath.

Michael Malet sums up the usual Bolshevik-Makhnovist relationship by arguing
that it _"will be apparent that the aim of the Soviet government from the
spring of 1919 onwards was to destroy the Makhnovists as an independent force,
preferably killing Makhno himself in the process . . . Given the disastrous
nature of Bolshevik land policy . . . this was not only unsurprisingly, it was
inevitable."_ He also adds that the _"fact that Makhno had a socio-political
philosophy to back up his arguments only made the Bolsheviks more determined
to break his hold over the south-east Ukraine, as soon as they realised that
Nestor would not surrender that hold voluntarily."_ [ **Op. Cit.** , p. 128
and p. 129]

The first betrayal occurred in June 1919. The Makhnovists had been integrated
with the Red Army in late January 1919, retaining their internal organisation
(including the election of commanders) and their black flags. With the Red
Army they fought against Denikin's Volunteer Army. Before the arrival of Red
forces in their region and the subsequent pact, the Makhnovists had organised
a successful regional insurgent, peasant and worker congress which had agreed
to call a second for February 12th. This second congress set up a
Revolutionary Military Soviet to implement the decisions of this and following
congresses. This congress (see [section 7](append46.md#app7)) passed an
anti-Bolshevik resolution, which urged _"the peasants and workers to watch
vigilantly the actions of the Bolshevik regime that cause a real danger to the
worker-peasant revolution."_ Such actions included the monopolisation of the
revolution, centralising power and overriding local soviets, repressing
anarchists and Left Socialist Revolutionaries and _"stifling any manifestation
of revolutionary expression."_ [quoted by Palij, **Op. Cit.** , p. 154]

This change from the recent welcome was simply the behaviour of the Bolsheviks
since their arrival. The (unelected) Ukrainian Bolshevik government had tried
to apply the same tactics as its Russian equivalent, particularly as regards
the peasants. In addition, the Bolshevik land policy (as indicated in [section
8](append46.md#app8)) was a complete disaster, alien to the ideas and needs
of the peasants and, combined with grain requisitioning, alienating them.

The third congress was held on the 10th of April. By this time, Communist
agricultural policy and terrorism had alienated all the peasantry, who _"rich
and poor alike"_ were _"united in their opposition"_ to the Bolsheviks.
[Footman, **Op. Cit.** , p. 269] Indeed, the _"poorer the areas, the more
dissatisfied were the peasants with the Bolshevik decrees."_ [Palij, **Op.
Cit.** , p. 156] As we indicated in [section 7](append46.md#app7), the third
congress was informed that it was _"counter-revolutionary"_ and banned by the
Bolshevik commander Dybenko, provoking a famous reply which stressed the right
of a revolutionary people to apply the gains of that revolution when they see
fit. It is worth re-quoting the relevant section:

> _"Can there exist laws made by a few people who call themselves
> revolutionaries which permit them to outlaw a whole people who are more
> revolutionary than they are themselves? . . ._
>
> _"Is it permissible, is it admissible, that they should come to the country
> to establish laws of violence, to subjugate a people who have just
> overthrown all lawmakers and all laws?_
>
> _"Does there exist a law according to which a revolutionary has the right to
> apply the most severe penalties to a revolutionary mass, of which he calls
> himself the defender, simply because this mass has taken the good things
> which the revolution promised them, freedom and equality, without his
> permission?_
>
> _"Should the mass of revolutionary people perhaps be silent when such a
> revolutionary takes away the freedom which they have just conquered?_
>
> _"Do the laws of the revolution order the shooting of a delegate because he
> believes he ought to carry out the mandate given him by the revolutionary
> mass which elected him?_
>
> _"Whose interests should the revolutionary defend; those of the Party or
> those of the people who set the revolution in motion with their blood?"_
> [quoted by Arshinov, **Op. Cit.** , p. 103]

After the 3rd congress, the Bolsheviks started to turn against Makhno:

> _"It was now that favourable mention of Makhno ceased to appear in the
> Soviet Press; an increasingly critical note became apparent. Supplies failed
> to get through to Makhnovite units and areas."_ [Footman, **Op. Cit.** , p.
> 271]

Lenin himself advised local Bolshevik leaders on Makhno, stating in early May
that _"temporarily, while Rostov is not yet captured, it is necessary to be
diplomatic."_ [quoted by Arthur E. Adams, **Bolsheviks in the Ukraine** , pp.
352-3] Thus, as long as the Bolsheviks needed cannon fodder, Makhno was to be
tolerated. Things changed when Trotsky arrived. On May 17th he promised a
_"radical and merciless liquidation of partisanshchina [the partisan
movement], independence, hooliganism, and leftism."_ [quoted by Adams, **Op.
Cit.** , p. 360] According to one historian, Trotsky _"favoured a thorough-
going annihilation of the partisan's ideological leaders as well as men like
Hryhoriyov who wielded political power."_ [Adams, **Op. Cit.** , p. 360]
Unsurprisingly, given Trotsky's stated mission, Bolshevik hostility towards
the Makhnovists became more than mere words. It took the form of both direct
and indirect aggression. _"In the latter part of May,"_ states Footman, _"the
**Cheka** sent over two agents to assassinate Makhno."_ Around the same time,
the Red _"hold-back of supplies for the Insurgents developed into a blockade
of the area. Makhnovite units at the front ran short of ammunition."_ [ **Op.
Cit.** , p. 271 and p. 272] This, obviously, had a negative impact the
Makhnovists' ability to fight the Whites.

Due to the gravity of the military and political situations both at and behind
the front, the Makhnovist Revolutionary Military Soviet decided to call an
extraordinary congress of peasants, workers, insurgents and Red soldiers. This
congress was to determine the immediate tasks and the practical measures to be
taken by the workers to remedy the mortal danger represented by the Whites. On
May 31st, a call was sent out which stated, in part, _"that only the working
masses themselves can find a solution [to the current problem], and not
individuals or parties."_ The congress would be based as follows: _"elections
of delegates of peasants and workers will take place at general assemblies of
villages, towns, factories and workshops."_ [quoted by Arshinov, **Op. Cit.**
, p. 121]

The Bolshevik reply came quickly, with Trotsky issuing his infamous Order no.
1824 on June 4th:

> _"This Congress is directed squarely against the Soviet Power in the Ukraine
> and against the organisation of the southern front, where Makhno's brigade
> is stationed. This congress can have no other result then to excite some new
> disgraceful revolt like that of Grigor'ev, and to open the front to the
> Whites, before whom Makhno's brigade can only retreat incessantly on account
> of the incompetence, criminal designs and treason of its commanders._
>
> _"1. By the present order this congress is forbidden, and will in no
> circumstances be allowed to take place._
>
> _"2. All the peasant and working class population shall be warned. orally
> and in writing, that participation in the said congress will be considered
> an act of high treason against the Soviet Republic and the Soviet front._
>
> _"3. All delegates to the said Congress shall be arrested immediately and
> bought before the Revolutionary Military Tribunal of the 14th, formerly 2nd,
> Army of the Ukraine._
>
> _"4. The persons spreading the call of Makhno and the Hulyai Pole Executive
> Committee to the Congress shall likewise be arrested._
>
> _"5. The present order shall have the force of law as soon as it is
> telegraphed. It should be widely distributed, displayed in all public
> places, and sent to the representatives of the executive committees of towns
> and villages, as well as to all the representatives of Soviet authority, and
> to commanders and commissars of military units."_ [quoted by Arshinov, **Op.
> Cit.** , pp. 122-3]

Arshinov argues that this _"document is truly classic"_ and _"[w]hoever
studies the Russian revolution should learn it by heart."_ He compares
Trotsky's order to the reply the Makhnovists had sent to the Bolsheviks'
attempt to ban the third congress. Clearly, Order No. 1824 shows that laws did
exist _"made by a a few people who call themselves revolutionaries which
permit them to outlaw a whole people who are more revolutionary than they are
themselves"_! Equally, the order shows that _"a revolutionary has the right to
apply the most severe penalties to a revolutionary mass . . . simply because
this mass has taken the good things which the revolution has promised them,
freedom and equality, without his permission"_! Little wonder Arshinov states
that this order meant that the _"entire peasant and labouring population are
declared guilty of high treason if they dare to participate in their own free
congress."_ [ **Op. Cit.** , p. 123]

According to Voline, in Alexandrovsk _"all workers meetings planned for the
purpose of discussing the call of the Council and the agenda of the Congress
were forbidden under pain of death. Those which were organised in ignorance of
the order were dispersed by armed force. In other cities and towns, the
Bolsheviks acted in the same way. As for the peasants in the villages, they
were treated with still less ceremony; in many places militants and even
peasants 'suspected of acting in favour of the insurgents and the Congress'
were seized and executed after a semblance of a trial. Many peasants carrying
the call were arrested, 'tried' and shot, before they could even find out
about Order No. 1824."_ [ **Op. Cit.** , pp. 599-600]

As Arshinov summarises:

> _"This entire document represents such a crying usurpation of the rights of
> the workers that it is pointless to comment further on it."_ [ **Op. Cit.**
> , p. 124]

Trotsky continued his usurpation of the rights of the workers in a later order
on the congress. In this, Trotsky called this openly announced workers,
peasant and insurgent congress a _"conspiracy against Soviet power"_ and a
_"congress of Anarchist-kulaks delegates for struggle against the Red Army and
the Soviet power"_ (which explains why the congress organisers had asked that
hotbed of kulakism, the Red Army troops, to send delegates!). Trotsky
indicated the fate of those workers and peasants who dared participate in
their own revolution: _"There can be only one penalty for these individuals:
shooting."_ [ **How the Revolution Armed** , vol. II, p. 293]

Trotsky also ordered the arrest of Makhno, who escaped but who ordered his
troops to remain under Bolshevik command to ensure that the front against
Denikin was maintained. However, five members of his staff were shot for
having distributed literature concerning the banned fourth congress. This
order was the first step in the Bolshevik attempt to _"liquidate the
Makhnovist movement."_ This campaign saw Bolshevik regiments invade the
insurgent area, shooting militants on the spot and destroying the free
communes and other Makhnovist organisations. [Arshinov, **Op. Cit.** , p. 121]
It should be noted that during the Spanish Revolution, the Stalinists acted in
the same way, attacking rural collectives while the anarchist troops fought
against Franco at the front.

Thus the participating event for the break between the Makhnovists and
Bolsheviks was Trotsky's banning of the fourth regional congress. However,
this was preceded by an intense press campaign against the Makhnovists as well
as holding back of essential supplies from the frontline troops. Clearly the
Bolsheviks considered that the soviet system was threatened if soviet
conferences were called and that the "dictatorship of the proletariat" was
undermined if the proletariat took part in the revolutionary process!

With the Makhnovist front weakened, they could not hold against Denikin's
attacks, particularly when Red Army troops retreated on their flank. Thus, the
front which the Makhnovists themselves had formed and held for more than six
months was finally broken. [Arshinov, **Op. Cit.** , p. 124] The Red Army was
split into three and the Whites entered the Ukraine, which the Bolsheviks
promptly abandoned to its fate. The Makhnovists, drawing stray Red Army and
other forces to it, continued to fight the Whites, ultimately inflicting a
decisive defeat on them at Peregonovka, subsequently destroying their supply
lines and ensuring Denikin's defeat (see [section 4](append46.md#app4)).

The Red Army re-entered the Ukraine at the end of 1919. Bolshevik plans with
regard to the Makhnovists had already been decided in a secret order written
by Trotsky on December 11th. Red Army troops had to _"be protected against
infection by guerrilla-ism and Makhnovism"_ by various means, including
_"extensive agitation"_ which used _"examples from the past to show the
treacherous role played by the Makhnovites."_ A _"considerable number of
agents"_ would be sent _"ahead"_ of the main forces to _"join the guerrilla
detachments"_ and would agitate against _"guerrilla-ism."_ Once partisan
forces meet with Red Army troops, the former _"ceases to be a military unit
after it has appeared on our side of the line . . . From that moment it
becomes merely material for processing, and for that purpose is to be sent to
our rear."_ To _"secure complete subordination of the detachments,"_ the Red
forces _"must make use of the agents previously set to these detachments."_
The aim, simply put, was to ensure that the partisans became _"fully
subordinate to our command."_ If the partisans who had been fighting for
revolution and against the Whites opposed becoming _"material for processing"_
(i.e cannon fodder), _"refuses to submit to orders, displays unruliness and
self-will,"_ then it _"must be subjected to ruthless punishment."_ Recognising
the organic links the partisans had with the peasants, Trotsky argues that
_"in the Ukraine, guerrilla detachments appear and disappear with ease,
dissolving themselves into the mass of the armed peasant population"_ and so
_"a fundamental condition for the success against guerrilla-ism is
**unconditional disarmament of the rural population, without exception.** "_
[Trotsky, **How the Revolution Armed** , vol. II, pp. 440-2] As events would
show, the Bolsheviks implemented Trotsky's order to the letter.

On December 24th, Makhno's troops met with the Bolshevik 14th army and its
commander _"admitted Makhno's service in defeating Denikin."_ However, while
_"the Bolsheviks fraternised with the Makhno troops . . . they distrusted
Makhno, fearing the popularity he had gained as a result of his successful
fighting against Denikin."_ The Bolsheviks had _"no intention of tolerating
Makhno's independent policy, but hoped first to destroy his army by removing
it from its own base. With this in mind, on January 8th, 1920, the
Revolutionary Military Council of the Fourteenth Army ordered Makhno to move
to the Polish Front . . . The author of the order realised that there was no
real war between the Poles and the Bolsheviks at the time and he also knew
that Makhno would not abandon his region. .. . . Uborevich [the author]
explained that 'an appropriate reaction by Makhno to this order would give us
the chance to have accurate grounds for our next steps' . . . [He] concluded:
'The order is a certain political manoeuvre and, at the very least, we expect
positive results from Makhno's realisation of this.'"_ [Palij, **Op. Cit.** ,
p. 209 and p. 210] As can be seen, these actions fit perfectly with Trotsky's
secret order and with Bolshevik desire for a monopoly of power for itself (see
[next section](append46.md#app14)).

As expected, the Makhnovists refused to leave their territory. They realised
the political motivations behind the order. As Arshinov notes, _"[s]ending the
insurrectionary army to the Polish front meant removing from the Ukraine the
main nerve centre of the revolutionary insurrection. This was precisely what
the Bolsheviks wanted: they would then be absolute masters of the rebellious
region, and the Makhnovists were perfectly aware of this."_ [ **Op. Cit.** ,
p. 163] As well as political objections, the Makhnovists listed practical
reasons for not going. Firstly, _"the Insurrectionary Army was subordinate
neither to the 14th Corps nor to any other unit of the Red Army. The Red
commander had no authority to give orders to the Insurrectionary Army."_
Secondly, _"it was materially impossible to carry it out, since half the men,
as well as nearly all the commanders and staff, and Makhno himself, were sick
[with typhus]."_ Thirdly, _"the fighting qualities and revolutionary
usefulness of the Insurrectionary Army were certainly much greater on their
own ground."_ [Voline, **Op. Cit.** , pp. 650-1]

The Bolsheviks refused to discuss the issue and on the 14th of January, they
declared the Makhnovists outlawed. They then _"made a great effort to
destroy"_ Makhno. [Palij, **Op. Cit.** , p. 210] In summary, the Bolsheviks
**started** the conflict in order to eliminate opposition to their power. This
led to nine months of bitter fighting between the Red Army and the
Makhnovists. To prevent fraternisation, the Bolsheviks did not use local
troops and instead imported Latvian, Estonian and Chinese troops. They also
used other _"new tactics,"_ and _"attacked not only Makhno's partisans, but
also the villages and towns in which the population was sympathetic toward
Makhno. They shot ordinary soldiers as well as their commanders, destroying
their houses, confiscating their properties and persecuting their families.
Moreover the Bolsheviks conducted mass arrests of innocent peasants who were
suspected of collaborating in some way with the partisans. It is impossible to
determine the casualties involved."_ They also set up _"Committees of the
Poor"_ as part of the Bolshevik administrative apparatus, which acted as
_"informers helping the Bolshevik secret police in its persecution of the
partisans, their families and supporters, even to the extent of hunting down
and executing wounded partisans."_ [Palij, **Op. Cit.** , pp. 212-3]

This conflict undoubtedly gave time for the Whites to reorganise themselves
and encouraged the Poles to invade the Ukraine, so prolonging the Civil War.
The Makhnovists were threatened by both the Bolsheviks **and** Wrangel. By
mid-1920, Wrangel appeared to be gaining the upper hand and the Makhnovists
_"could not remain indifferent to Wrangel's advance . . . Everything done to
destroy him would in the last analysis benefit the revolution."_ This lead the
Makhnovists to consider allying with the Bolsheviks as _"the difference
between the Communists and Wrangel was that the Communists had the support of
the masses with faith in the revolution. It is true that these masses were
cynically misled by the Communists, who exploited the revolutionary enthusiasm
of the workers in the interests of Bolshevik power."_ With this in mind, the
Makhnovists agreed at a mass assembly to make an alliance with the Bolsheviks
against Wrangel as this would eliminate the White threat and end the civil
war. [Arshinov, **Op. Cit.** , p. 176]

The Bolsheviks ignored the Makhnovist offer using mid-September, when
_"Wrangel's success caused the Bolsheviks leaders to reconsider."_ [Palij,
**Op. Cit.** , p. 223] Sometime between the 10th and 15th of October the final
agreement was signed:

> _"Part I -- Political Agreement._
>
> _"1. Immediate release of all Makhnovists and anarchists imprisoned or in
> exile in the territories of the Soviet Republic; cessation of all
> persecutions of Makhnovists or anarchists, except those who carry on armed
> conflict against the Soviet Government._
>
> _"2. Complete freedom in all forms of public expression and propaganda for
> all Makhnovists and anarchists, for their principles and ideas, in speech
> and the press, with the exception of anything that might call for the
> violent overthrow of the Soviet Government, and on condition that the
> requirements of military censorship be respected. For all kinds of
> publications, the Makhnovists and anarchists, as revolutionary organisations
> recognised by the Soviet Government may make use of the technical apparatus
> of the Soviet State, while naturally submitting to the technical rules for
> publication._
>
> _"3. Free participation in elections to the Soviets; and the right of
> Makhnovists and anarchists to be elected thereto. Free participation in the
> organisation of the forthcoming Fifth Pan-Ukrainian Congress of Soviets . .
> ._
>
> _"Part II -- Military Agreement._
>
> _"1. The Ukrainian Revolutionary Insurrectionary Army (Makhnovist) will join
> the armed forces of the Republic as a partisan army, subordinate, in regard
> to operations, to the supreme command of the Red Army; it will retain its
> established internal structure, and does not have to adopt the bases and
> principles of the regular Red Army._
>
> _"2. When crossing Soviet territory at the front, or going between fronts,
> the Insurrectionary Army will not accept into its ranks neither any
> detachments of, nor deserters from, the Red Army . . ._
>
> _"3. For the purpose of destroying the common enemy -- the White Army -- the
> Ukrainian Revolutionary Insurrectionary Army (Makhnovists) will inform the
> working masses that collaborate with it the agreement that has been
> concluded; it will call upon the people to cease all military actions
> hostile to the Soviet power; and for its part, the Soviet power will
> immediately publish the clauses of the agreement._
>
> _"4. The families of combatants of the Makhnovist Revolutionary
> Insurrectionary Army living in the territory of the Soviet Republic shall
> enjoy the same rights as those of soldiers of the Red Army . . ."_ [quoted
> by Arshinov, **Op. Cit.** , p. 178]

This agreement was agreed by both sides, although the Bolsheviks immediately
broke it by publishing the military agreement first, followed by the political
agreement a week later, so obscuring the real meaning of the pact. As it
stands, the political clause simply gave anarchists and Makhnovists the rights
they should have already had, according to the constitution of the Soviet
state. This shows how far the Bolsheviks had applied that constitution.

The agreement is highly significant as in itself it disproves many of the
Bolsheviks slanders about the Makhnovists and it proves the suppression of the
anarchist press to have been on political grounds.

However, the Makhnovists desired to add a fourth clause to the Political
Agreement:

> _"Since one of the essential principles of the Makhnovist movement is the
> struggle for the self-management of the workers, the Insurrectionary Army
> (Makhnovist) believes it should insist on the following fourth point of the
> political agreement: in the region where the Makhnovist Army is operating,
> the population of workers and peasants will create its own institutions of
> economic and political self-management; these institutions will be
> autonomous and joined in federation, by means of agreement, with the
> government organs of the Soviet Republic,"_ [quoted by Arshinov, **Op.
> Cit.** , pp. 179-80]

Unsurprisingly, the Bolsheviks refused to ratify this clause. As one Bolshevik
historian pointed out, the _"fourth point was fundamental to both sides, it
meant the system of free Soviets, which was in total opposition to the idea of
the dictatorship of the proletariat."_ [quoted by Malet, **Op. Cit.** , p.
108] As we discuss in the [next section](append46.md#app14), the Bolsheviks
had equated the _"dictatorship of the proletariat"_ with the dictatorship of
their party and so working-class self-management could not be allowed. It
should be noted that this fourth clause was the cause of Lenin and Trotsky's
toying with the idea of allowing the Makhnovists south-eastern Ukraine as an
anarchist experiment (as mentioned by both Victor Serge and Trotsky in later
years).

Once Wrangel had been defeated by Makhnovist and Red Army units, the
Bolsheviks turned on the movement. Makhno had _"assumed that the coming
conflict with the Bolsheviks could be limited to the realm of ideas, feeling
that the strong revolutionary ideas and feelings of the peasants, together
with their distrust of the foreign invaders, were the best guarantees for the
movement's territory. Moreover, Makhno believed that the Bolsheviks would not
attack his movement immediately. A respite of some three months would have
allowed him to consolidate his power [sic!] and to win over much of the
Bolshevik rank and file."_ [Palij, **Op. Cit.** , p. 231] From the wording of
the second clause of the military agreement (namely, to refuse Red Army
deserters or units), it is clear that the Bolsheviks were aware of the appeal
of Makhnovist politics on the Red Army soldiers. As soon as Wrangel was
defeated, the Red Army attacked. Makhnovist commanders were invited to
meetings, arrested and then shot. The Red Army surrounded Makhnovist units and
attacked them. At the same time, anarchists were arrested all across the
Ukraine. Hulyai Pole itself was attacked (Makhno, despite overwhelming odds,
broke out). [Malet, **Op. Cit.** , pp. 71-2]

In the words of Makhno:

> _"In this difficult and responsible revolutionary position the Makhno
> movement made one great mistake: alliance with the Bolsheviks against a
> common enemy, Wrangel and the Entente. In the period of this alliance that
> was morally right and of practical value for the revolution, the Makhno
> movement mistook Bolshevik revolutionism and failed to secure itself in
> advance against betrayal. The Bolsheviks and their experts treacherously
> circumvented it."_ [quoted by Palij, **Op. Cit.** , p. 234]

While the Bolsheviks continuously proclaimed the final defeat of the
Makhnovists, they held out for nearly a year before being forced to leave the
Ukraine in August 1921. Indeed, by the end of 1920 his troops number ten to
fifteen thousand men and the _"growing strength of the Makhno army and its
successes caused serious concern in the Bolshevik regime."_ More Red troops
were deployed, _"stationing whole regiments, primarily cavalry, in the
occupied villages to terrorise the peasants and prevent them from supporting
Makhno. . . Cheka punitive units were constantly trailing the partisans,
executing Makhno's sympathisers and the partisans' families."_ [Palij, **Op.
Cit.** , p. 237 and p. 238] Combined with this state terrorism, economic
conditions in the villages got worse. The countryside was exhausted and 1921
was a famine year. With his rural base itself barely surviving, the
Makhnovists could not survive long.

It should be noted that during the periods after the Bolsheviks had turned on
the Makhnovists, the latter appealed to rank-and-file Red Army troops not to
attack them. As one of their leaflets put it: _"Down with fratricidal war
among the working people!"_ They urged the Red Army troops (with some success)
to rebel against the commissars and appointed officers and join with the
Makhnovists, who would _"greet [them] as our own brothers and together we will
create a free and just life for workers and peasants and will struggle against
all tyrants and oppressors of the working people."_ [contained in Arshinov,
**Op. Cit.** , p. 276 and p. 283]

Even after the defeat of the Makhnovists, the Bolsheviks did not stop their
campaign of lies. For example, Trotsky reported to the Ninth Congress of
Soviets on December 26th, 1921, that the Makhnovists were _"in Romania,"_
where Makhno had _"received a friendly welcome"_ and was _"liv[ing]
comfortably in Bucharest."_ The Makhnovists had picked Romania because it was,
like Poland, _"a country where they . . . felt secure"_ due to the way they
treated _"Russian counter-revolutionary bands."_ [ **How the Revolution
Armed** , vol. IV, p. 404] In reality, the _"Romanian authorities put Makhno,
his wife, and his followers in an internment camp."_ The Bolsheviks were not
unaware of this, as they _"sent a series of sharp diplomatic notes demanding
Makhno's extradiction."_ They expelled Makhno and his wife to Poland on April
11, 1922. The Poles also interned them and, again, the Bolsheviks demanded
Makhno's extradition _"on the ground that he was a criminal and not entitled
to political asylum."_ [Palij, **Op. Cit.** , p. 242] Trotsky's lies come as
no surprise, given his and his party's track record on slandering anarchists.

As can be seen, the relationship of the Makhnovists to the Bolsheviks was one
of constant betrayal of the former by the latter. Moreover, the Bolsheviks
took every opportunity to slander the Makhnovists, with Trotsky going so far
as to report Makhno was living well while he was rotting in a capitalist
prison. This is to be expected, as the aims of the two groups were at such
odds. As we discuss in the [next section](append46.md#app14), while the
Makhnovists did whatever they could to encourage working-class self-management
and freedom, the Bolsheviks had evolved from advocating the government of
their party as the expression of "the dictatorship of the proletariat" to
stating that only the dictatorship of their party could ensure the success of
a social revolution and so **was** "the dictatorship of the proletariat." As
the Makhnovist movement shows, if need be, the party would happily exercise
its dictatorship **over** the proletariat (and peasantry) if that was needed
to retain its power.

## 14 How did the Makhnovists and Bolsheviks differ?

Like chalk and cheese.

Whereas the Bolsheviks talked about soviet democracy while exercising a party
dictatorship, the Makhnovists not only talked about _"free soviets,"_ they
also encouraged them with all their ability. Similarly, while Lenin stated
that free speech was _"a bourgeois notion"_ and that there could be _"no free
speech in a revolutionary period,"_ the Makhnovists proclaimed free speech for
working people. [Lenin quoted by Goldman, **My Disillusionment in Russia** ,
p. 33] While the Bolsheviks ended up arguing for the necessity of party
dictatorship during a revolution, the Makhnovists introduced free soviets and
organised peasant, worker and insurgent congresses to conduct the revolution.

We have discussed the Makhnovist ideas in both theory and practice in sections
[5](append46.md#app5), [6](append46.md#app6) and [7](append46.md#app7).
In spite of the chaos and difficulties imposed upon the movement by having to
fight the counter-revolution, the Makhnovists applied their ideals constantly.
The Makhnovists were a mass movement and its constructive efforts showed that
there was an alternative route the Russian revolution could have followed
other than the authoritarian dictatorship that Leninists, then and now,
claimed was inevitable if the revolution was to be saved.

To see why, we must compare Bolshevik ideology and practice to that of the
Makhnovists in three key areas. Firstly, on how a revolution should be
defended. Secondly, on the role of the soviets and party in the revolution.
Thirdly, on the question of working-class freedom.

Early in 1918, after the signing of the Brest-Litovsk Treaty the Bolsheviks
re-introduced Tsarist officers into the army alongside bourgeois military
discipline. As Maurice Brinton correctly summarises:

> _"Trotsky, appointed Commissar of Military Affairs after Brest-Litovsk, had
> rapidly been reorganising the Red Army. The death penalty for disobedience
> under fire had been restored. So, more gradually, had saluting, special
> forms of address, separate living quarters and other privileges for
> officers. Democratic forms of organisation, including the election of
> officers, had been quickly dispensed with."_ [ **The Bolsheviks and Workers'
> Control** , p. 37]

Officers were appointed rather then elected. They argued this had to be done
to win the war. The _"principle of election,"_ stated Trotsky, _"is
politically purposeless and technically inexpedient and has been, in practice,
abolished by decree."_ Thus the election of officers and the creation of
soldiers' committees was abolished from the top, replaced by appointed
officers. Trotsky's rationale for this was simply that _"political power is in
the hands of the same working class from whose ranks the Army is recruited."_
In other words, the Bolshevik Party held power as power was actually held by
it, **not** the working class. Trotsky tried to answer the obvious objection:

> _"Once we have established the Soviet regime, that is a system under which
> the government is headed by persons who have been directly elected by the
> Soviets of Workers', Peasants' and Soldiers' Deputies, there can be no
> antagonism between the government and the mass of the workers, just as there
> is no antagonism between the administration of the union and the general
> assembly of its members, and, therefore, there cannot be any grounds for
> fearing the **appointment** of members of the commanding staff by the organs
> of the Soviet Power."_ [ **Work, Discipline, Order** ]

He repeated this argument in his 1919 diatribe against the Makhnovists:

> _"The Makhnovites shout raucously: 'Down with appointed commanders!' This
> they do only so as to delude the ignorant element among their own soldiers.
> One can speak of 'appointed' persons only under the bourgeois order, when
> Tsarist officials or bourgeois ministers appointed at their own discretion
> commanders who kept the soldier masses subject to the bourgeois classes.
> Today there is no authority in Russia but that which is elected by the whole
> working class and working peasantry. It follows that commanders appointed by
> the central Soviet Government are installed in their positions by the will
> of the working millions. But the Makhnovite commanders reflect the interests
> of a minute group of Anarchists who rely on the kulaks and the ignorant."_ [
> **The Makhno Movement** ]

Of course, most workers are well aware that the administration of a trade
union usually works against them during periods of struggle. Indeed, so are
most Trotskyists as they often denounce the betrayals by that administration.
Thus Trotsky's own analogy indicates the fallacy of his argument. Equally, it
was not _"the will of the working millions"_ which appointed anyone, it was a
handful of leaders of the Bolshevik party (which had manipulated the soviets
to remain in power). Needless to say, this was a vast change from Lenin's
comments in **State and Revolution** opposing appointment and calling for
election of **all** officials!

Moreover, the explanation that _"the ignorant"_ were to blame for Makhnovist
opposition to appointed officers had a long legacy with Trotsky. In April
1918, when justifying Bolshevik introduction of appointed officers, he had
argued that the _"Soviet government is the same as the committee of a trade
union. It is elected by the workers and peasants and you can at the All-
Russian Congress of Soviets, at any moment you like, dismiss that government
and appoint another. But once you have appointed it, you must give it the
right to choose the technical specialists."_ He stressed that this applied
_"in military affairs, in particular."_ Using the trade union analogy, he
argued that the workers had _"entrusted us [the Bolshevik leaders] with the
direction of the union"_ and this meant that the Bolshevik leaders, not the
workers, should decide things as _"we are better able to judge in the matter"_
than them! The workers role was stated clearly: _"if our way of conducting the
business is bad, then throw us out and elect another committee!"_ [ **Leon
Trotsky Speaks** , p. 113] In other words, like any bureaucrat, for Trotsky
working-class participation in the affairs of the revolution was seen as
irrelevant: the masses had voted and their role was now that of obeying those
who _"are better able to judge."_

Using an argument the Tsar could have been proud of, Trotsky defended the
elimination of soldier democracy:

> _"How could soldiers who have just entered the army choose the chiefs! Have
> they any vote to go by? They have none. And therefore elections are
> impossible."_ [ **Ibid.** ]

Equally, how could workers and peasants who have just entered political or
economic struggle in 1917 choose the chiefs? Had they any vote to go by? They
had none. And therefore political and workplace elections are impossible.
Unsurprisingly, Trotsky soon ended up applying this logic to politics as well,
defending (like all the leaders of Bolshevism) the dictatorship of the party
**over** working class. How could the _"ignorant"_ workers be expected to
elect the best _"chiefs"_ never mind manage their own affairs!

Ironically, in 1936 the Stalinist Communist Party in Spain was to make very
similar arguments about the need for a regular army and army discipline to win
the war. As Aileen O'Carroll in her essay _"Freedom and Revolution"_ argues:

> _"The conventional army structure evolved when feudal kings or capitalist
> governments required the working class to fight its wars for them. These had
> to be authoritarian institutions, because although propaganda and jingoism
> can play a part initially in encouraging enlistment, the horrors of war soon
> expose the futility of nationalism. A large part of military organisation is
> aimed at ensuring that soldiers remain fighting for causes they do not
> necessarily believe in. Military discipline attempts to create an
> unthinking, unquestioning body of soldiers, as fearful of their own side as
> of the other."_ [ **Red & Black Revolution**, no. 1]

In short in both Russia and Spain the Bolsheviks wanted an army that would
obey them regardless of whether the individual soldiers felt they were doing
the correct thing, indeed who would obey through fear of their officers even
when they knew what they were doing was wrong. Such a body would be essential
for enforcing minority rule over the wishes of the workers. Would a self-
managed army be inclined to repress workers' and peasants' strikes and
protests? Of course not.

The Makhnovists show that another kind of revolutionary army was possible in
the Russian Revolution and that the _"ignorant"_ masses could choose their own
officers. In other words, the latter-day justifications of the followers of
Bolshevism are wrong when they assert that the creation of the top-down,
hierarchical Red Army was a result of the _"contradiction between the
political consciousness and circumstantial coercion"_ and _"a retreat"_
because _"officers were appointed and not elected,"_ it was a conscript army
and _"severe military discipline."_ [John Rees, _"In Defence of October"_ ,
**International Socialism** , no. 52, pp. 3-82, p. 46] As can be seen, Trotsky
did not consider it as a _"retreat"_ or caused by _"circumstances."_ Equally,
the Makhnovists managed to organise themselves relatively democratically in
the circumstances created by the same civil war.

As such, the differences between the Makhnovists and the Bolsheviks as regards
the internal organisation of a revolutionary army are clear. The Bolsheviks
applied top-down, bourgeois methods of internal organisation and discipline.
The Makhnovists applied democratic internal organisation and discipline as far
as possible.

From our discussion of the Bolshevik justifications for its system of
appointed officers in the Red Army, it will come as no surprise that as
regards the relationship of the soviets to the revolutionary organisation
(party) the Makhnovists and Bolsheviks were (again) miles apart. While we
discuss this in greater detail in [section 14](append41.md#app14) of the
appendix ["What happened during the Russian Revolution?"](append41.md), we
will give a flavour of Bolshevik ideology on this subject here.

From the start, Lenin identified soviet (or working class) power with the
power of their own party. In October 1917, Lenin was equating party and class:
_"the power of the Bolsheviks -- that is, the power of the proletariat."_ [
**Will the Bolsheviks Maintain Power?** , p. 102] After the October
Revolution, the Bolsheviks were clear that the soviets would not have _"all
power."_ Rather, the first act of soviet sovereignty was to alienate it into
the hands of a Bolshevik government. In response to a few leading Bolsheviks
who called for a coalition government, the Bolshevik Central Committee stated
that it was _"impossible to refuse a purely Bolshevik government without
treason to the slogan of the power of the Soviets, since a majority at the
Second All-Russian Congress of Soviets . . . handed power over to this
government."_ [quoted by Robery V. Daniels, **A Documentary History of
Communism** , vol. 1, pp. 127-8] How can the _"power of the Soviets"_ exist
when said soviets immediately _"handed power"_ over to another body? Thus the
only _"power"_ the soviets had was simply the _"power"_ to determine who
actually held political power.

The question of who held power, the soviets or the party, came into focus when
the soviet elections resulted in non-Bolshevik majorities being elected. After
the initial honeymoon period, soviet elections started to go badly for the
Bolsheviks. Ever since taking power in 1917, the Bolsheviks had become
increasingly alienated from the working class. The spring and summer of 1918
saw _"great Bolshevik losses in the soviet elections"_ in all provincial city
elections that data is available for. The Mensheviks were the main
beneficiaries of these election swings (Socialist Revolutionaries also gained)
The Bolsheviks forcibly disbanded such soviets. They continually postponed
elections and _"pack[ed] local soviets once they could no longer count on an
electoral majority"_ by giving representation to the organisations they
dominated which made workplace elections meaningless. [Samuel Farber, **Before
Stalinism** , pp. 22-4 and p. 33] In Petrograd, such packing swamped the
actual number of workplace delegates, transforming the soviets and making
elections irrelevant. Of the 700-plus deputies to the "new" soviet, over half
were elected by Bolshevik dominated organisations so ensuring a solid
Bolshevik majority even before the factory voting began.

Thus, the regime remained "soviet" in name only. Faced with a defeat in the
soviets, the Bolsheviks simply abolished them or changed them to ensure their
position. This process, it should be noted, started **before** the outbreak of
Civil War in late May 1918, implying that Bolshevik authoritarianism cannot be
explained as reactions to difficult objective circumstances.

Unsurprisingly, Bolshevik ideology started to adjust to the position the party
found itself in. As Samuel Farber argues, in the _"period of March to June
1918, Lenin began to make frequent distinctions **within** the working class,
singling out workers who could still be trusted, denouncing workers whom he
accused of abandoning the working class and deserting to the side of the
bourgeoisie, and complaining about how the working class had become 'infected
with the disease of petty-bourgeois disintegration.'"_ [ **Op. Cit.** , p. 25]
Combined with the vision of "working-class" or "soviet" power expressed by the
power of his party, this laid the foundations for what came next. In 1919
Lenin fully and explicitly argued that the "dictatorship of the proletariat"
was, in fact, the dictatorship of the Bolshevik party:

> _"we are reproached with having established a dictatorship of one party . .
> . we say, 'Yes, it is a dictatorship of one party! This is what we stand for
> and we shall not shift from that position . . . '"_ [ **Collected Works** ,
> vol. 29, p. 535]

This quickly become Bolshevik orthodoxy. Trotsky argued in his infamous work
**Terrorism and Communism** that there was _"no substitution at all"_ when
_"the power of the party"_ replaces _"the power of the working class."_
Zinoviev argued this point at the Second Congress of the Communist
International. As he put it:

> _"Today, people like Kautsky come along and say that in Russia you do not
> have the dictatorship of the working class but the dictatorship of the
> party. They think this is a reproach against us. Not in the least! We have a
> dictatorship of the working class and that is precisely why we also have a
> dictatorship of the Communist Party. The dictatorship of the Communist Party
> is only a function, an attribute, an expression of the dictatorship of the
> working class . . . [T]he dictatorship of the proletariat is at the same
> time the dictatorship of the Communist Party."_ [ **Proceedings and
> Documents of the Second Congress, 1920** , vol. 1, pp. 151-2]

Neither Lenin nor Trotsky disagreed. By the end of the civil war, Lenin was
arguing that _"the dictatorship of the proletariat cannot be exercised through
an organisation embracing the whole of the class, because in all capitalist
countries (and not only over here, in one of the most backward) the
proletariat is still so divided, so degraded, and so corrupted in parts . . .
that an organisation taking in the whole proletariat cannot directly exercise
proletarian dictatorship. It can be exercised only by a vanguard . . . the
dictatorship of the proletariat cannot be exercised by a mass proletarian
organisation."_ [ **Collected Works** , vol. 32, p. 21]

This places the Bolshevik betrayals of the Makhnovists in 1919 and 1920 into
**political** context. It also explains the Bolshevik opposition to the
proposed fourth clause of the 1920 political and military agreement (see [last
section](append46.md#app13)). Simply put, at the time (and long afterwards)
the Bolsheviks equated the revolution with their own power. As such,
Makhnovist calls for soviet self-management threatened the "dictatorship of
the proletariat" (i.e. dictatorship of the party) by encouraging working
people to participate in the revolution and giving the radically false idea
that working-class power could be exercised by working people and their own
class organisations.

Lenin, Trotsky and Zinoviev held this position until their deaths. Trotsky,
for example, was arguing in 1923 that _"[i]f there is one question which
basically not only does not require revision but does not so much as admit the
thought of revision, it is the question of the dictatorship of the Party, and
its leadership in all spheres of our work."_ [ **Leon Trotsky Speaks** , p.
158] Even after the rise of Stalinism, he was still arguing for the
_"objective necessity"_ of the _"revolutionary dictatorship of a proletarian
party"_ in 1937. He stressed that the _"revolutionary party (vanguard) which
renounces its own dictatorship surrenders the masses to the counter-revolution
. . . Abstractly speaking, it would be very well if the party dictatorship
could be replaced by the 'dictatorship' of the whole toiling people without
any party, but this presupposes such a high level of political development
among the masses that it can never be achieved under capitalist conditions."_
[Trotsky, **Writings 1936-37** , pp. 513-4]

This suggests that the later Trotskyist argument that the Bolsheviks were
forced by _"objective factors"_ to replace the dictatorship of the proletariat
by that of the party is false. At the time, and afterwards, the Bolsheviks did
not argue in these terms. The end of soviet democracy was not considered a
problem or a retreat for the revolution. The opposite was the case, with the
elimination of democracy being raised to an ideological truism to be applied
everywhere. Equally, the fact that the Makhnovists did all they could to
promote soviet self-management and actually called regional congresses of
workers, peasants and insurgents suggests that _"objective factors"_ simply
cannot explain Bolshevik actions. Simply put, like the Bolshevik betrayals of
the Makhnovists, the Bolshevik elimination of soviet democracy by party
dictatorship can only be fully understood by looking at Bolshevik ideology.

Little wonder the Makhnovists argued as followed:

> _"Since the arrival of the Bolsheviks the dictatorship of their party has
> been established here. As a party of statists, the Bolshevik Party
> everywhere has set up state organs for the purpose of governing the
> revolutionary people. Everything has to be submitted to their authority and
> take place under their vigilant eye. All opposition, protest, or even
> independent initiative has been stifled by their Extraordinary Commissions
> [the secret police, the Cheka]. Furthermore, all these institutions are
> composed of people who are removed from labour and from revolution. In other
> words, what has been created is a situation in which the labouring and
> revolutionary people have fallen under the surveillance and rule of people
> who are alien to the working classes, people who are inclined to exercise
> arbitrariness and violence over the workers. Such is the dictatorship of the
> Bolshevik-Communist Party . . ._
>
> _"We again remind the working people that they will liberate themselves from
> oppression, misery and violence only through their own efforts. No change in
> power will help them in this. Only by means of their own free worker-peasant
> organisations can the workers reach the summit of the social revolution --
> complete freedom and real equality."_ [quoted by Arshinov, **Op. Cit.** pp.
> 116-7]

Which brings us to the next issue, namely working-class freedom. For
anarchists, the key point of a revolution is to increase working-class
freedom. It means the end of hierarchy and the direct participation in the
revolution by the working classes themselves. As Bakunin put it, _"revolution
is only sincere, honest and real in the hands of the masses, and that when it
is concentrated in those of a few ruling individuals it inevitably and
immediately becomes reaction."_ [ **Michael Bakunin: Selected Writings** , p.
237] For this reason, the Makhnovists (like Bakunin) argued for a
revolutionary society based on free federations of worker and peasant
organisations (free soviets).

This means that actions which consolidated rule by a few cannot be
revolutionary, even if the few are made up of the most revolutionary of the
revolutionaries. Thus working class power cannot be equated to the power of a
political party, no matter how _"socialist"_ or _"revolutionary"_ its ideas or
rhetoric. This means that Bolshevik restrictions on working class freedom (of
speech, assembly, press, organisation) struck at the heart of the revolution.
It did not signify the defence of the revolution, but rather its defeat.
Ultimately, as Emma Goldman quickly recognised, what the Bolsheviks called
_"defence of the Revolution"_ was _"really only the defence of [the] party in
power."_ [ **My Disillusionment in Russia** , p. 57]

Anarchists had long argued that, to quote Goldman again, there is _"no greater
fallacy than the belief that aims and purposes are one thing, while methods
and tactics are another. This conception is a potent menace to social
regeneration. All human experience teaches that methods and means cannot be
separated from the ultimate aim. The means employed become, through individual
practice, part and parcel of the final purpose; they influence it, modify it,
and presently the aims and means become identical."_ [ **Op. Cit.** , p. 260]
The evolution of Bolshevik practice and theory reinforces this argument. The
means used had an impact on the course of events, which in turn shaped the
next set of means and the ideology used to justify it.

This explains the Makhnovist and Bolshevik differences in relationship to
working-class freedom. For anarchists, only freedom or the struggle for
freedom can teach people to be free (and so is genuinely revolutionary). This
explains why the Makhnovists not only proclaimed freedom of election, speech,
press, assembly and organisation for working people, which was an essential
revolutionary position, they also implemented it (see [section
7](append46.md#app7)). The Bolsheviks did the reverse, clamping down on the
opposition at every occasion (including workers' strikes and protests). For
the Makhnovists, working-class freedom was the key gain of the revolution, and
so had to be introduced, practised and defended. Hence Makhno:

> _"I consider it an inviolable right of the workers and peasants, a right won
> by the revolution, to call congresses on their own account, to discuss their
> affairs. That is why the prohibitions of such congresses, and the
> declaration proclaiming them illegal . . . , represent a direct and insolent
> violation of the rights of the workers."_ [quoted by Arshinov, **Op. Cit.**
> , p. 129]

For the Bolsheviks, working-class freedom was something to fear. Back in 1903,
Lenin laid the groundwork for this by arguing that the _" **spontaneous**
development of the labour movement leads to it being subordinated to bourgeois
ideology."_ He stressed that _"the working class, exclusively by their own
effort, is able to develop only trade union consciousness . . . the
theoretical doctrine of Social-Democracy arose quite independently of the
spontaneous growth of the labour movement; it arose as a natural and
inevitable outcome of ideas among the revolutionary socialist
intelligentsia."_ This meant that _"Social Democratic [i.e. socialist]
consciousness . . . could only be brought to them from without."_ [
**Essential Works of Lenin** , p. 82 and pp. 74-5] Clearly, if the workers
turned against the party, then the workers were _"being subordinated to
bourgeois ideology."_ It was in their own interests, therefore, for the party
to subordinate the workers and so soviet democracy became not an expression of
working-class power but rather something which undermined it!

This perspective can be seen when the Makhnovists liberated cities. In
Alexandrovsk and Katerinoslav, the Bolsheviks proposed to the Makhnovists
spheres of action - their **Revkom** (Revolutionary Committee) would handle
political affairs and the Makhnovists military ones. Makhno advised them _"to
go and take up some honest trade instead of seeking to impose their will on
the workers."_ Instead, the Makhnovists called upon _"the working population
to participate in a general conference .. . . and it was proposed that the
workers organise the life of the city and the functioning of the factories
with their own forced and their organisations."_ [Arshinov **Op. Cit.** , p.
154 and p. 149] The differences between the Bolsheviks and Makhnovists could
not be clearer.

Lastly, we should note that while Lenin and the leading Bolsheviks
wholeheartedly opposed working-class economic self-management by factory
committees and instead urged "efficient" top-down one-man management, the
Makhnovists supported working-class self-management of production. Under the
Bolsheviks, as Arshinov argued, the _"nationalisation of industry, [while]
removing the workers from the hands of individual capitalists, delivered them
to the yet more rapacious hands of a single, ever-present capitalist boss, the
State. The relations between the workers and this new boss are the same as
earlier relations between labour and capital, with the sole difference that
the Communist boss, the State, not only exploits the workers, but also
punishes them himself . . . Wage labour has remained what it was before,
except that it has taken on the character of an obligation to the State . . .
It is clear that in all this we are dealing with a simple substitution of
State capitalism for private capitalism."_ [ **Op. Cit.** , p. 71] The
Makhnovist propaganda, in contrast, stressed the need for workers to socialise
the means of production and place it under their direct management by their
own class organs. In other words, the abolition of wage slavery by workers'
self-management of production.

Unsurprisingly, the Makhnovists supported the Kronstadt rebellion (see the
appendix ["What was the Kronstadt uprising?"](append42.md) for more on
Kronstadt). Indeed, there is significant overlap between the Kronstadt demands
and the ideas of the Makhnovist movement. For example, the Makhnovist idea of
free soviets is almost identical to the first three points of the Kronstadt
programme and their land policy the same as point 11 of the Kronstadt demands.
The Kronstadt rebels also raised the idea of _"free soviets"_ and the _"third
revolution,"_ common Makhnovist slogans (see [section 3](append42.md#app3)
of the appendix ["What was the Kronstadt uprising?"](append42.md) for
details). As one Bolshevik writer notes, it is _"characteristic that the
anarchist-Makhnovists in the Ukraine reprinted the appeal of the Kronstadters,
and in general did not hide their sympathy for them."_ [quoted by Malet, **Op.
Cit.** , p. 108] Voline also noted that the _"ideas and activities of the
Makhnovist peasants were similar in all respects to those of the Kronstadt
rebels in 1921."_ [ **Op. Cit.** , p. 575]

In summary, the major difference between the Makhnovists and the Bolsheviks is
that the former stuck by and introduced their stated aims of _"soviet power"_
and working-class freedom while the latter rejected them once they clashed
with Bolshevik party policies.

## 15 How do the modern followers of Bolshevism slander the Makhnovists?

Many modern-day supporters of Bolshevism, on the rare occasions when they do
mention the Makhnovist movement, simply repeat the old Bolshevik (and
Stalinist) slanders against them.

For example, this is what Joseph Seymour of the U.S. **Spartacus League** did.
Their newspaper **Workers Vanguard** ran a series entitled _"Marxism vs.
Anarchism"_ and in part 7, during his discussion of the Russian Revolution,
Seymour claimed:

> _"The most significant counter-revolutionary force under the banner of
> anarchism was the Ukrainian peasant-based army of Nestor Makhno, which
> carried out pogroms against Jewish communities and collaborated with White
> armies against the Bolsheviks."_ [ **Workers Vanguard** , 8/30/1996, p. 7]

Seymour, needless to say, made these accusations without providing any
documentation, and with good reason, for outside of Stalinist hagiographies,
no evidence exists to support his claims. As we indicated in [section
9](append46.md#app9), the Makhnovists opposed anti-Semitism and did **not**
conduct pogroms. Equally, [section 12](append46.md#app12) proves that the
Makhnovists did **not** collaborate with the Whites in any way (although this
did not stop the Bolshevik press deliberately spreading the lie that they
had).

More recently, the UK Leninist **Revolutionary Communist Group** asserted in
their paper that the Makhnovists _"joined with counter-revolutionary White and
imperialist armies against socialist Russia. This band of brigands also
carried out pogroms against Jewish communities in the Ukraine."_ [ **Fight
Racism! Fight Imperialism!** , issue no. 174, p. 12] No evidence for such a
claim was presented in the original review article. When an anarchist pointed
out their assertion was _"falling back on a long tradition of Stalinist lies"_
and asked for _"any historical references"_ to support it, the paper replied
by stating that while there were _"several"_ references, it would give two:
_"E.H. Carr refers to it in his history of the civil war. Also the anarchist
historian Paul Avrich mentions it in his work **The anarchists in the Russian
Revolution**."_ [ **Op. Cit.** , no. 175, p. 15]

In reality, neither work says any such thing. Looking at the first (unnamed)
one, assuming it is E.H. Carr's **The Bolshevik Revolution** there is no
reference to pogroms carried out by the Makhnovists (looking in the index for
"Makhno"). Which, perhaps, explains why the paper refused to provide a book
title and page number. As far as the second reference goes, Avrich made no
such claim in **The Anarchists in the Russian Revolution**. He **did** address
the issue in his **Anarchist Portraits** , concluding such charges are false.

And the name of the original article? Ironically, it was entitled _"The
anarchist school of falsification"_!

However, more sophisticated slanders, lies and distortions have been levelled
at the Makhnovists by the supporters of Bolshevism. This is to be expected, as
the experience of the Makhnovists effectively refute the claim that the
Bolsheviks had no choice but to act as they did. It is hard to maintain a
position that "objective conditions" made the Bolsheviks act as they did when
another mass revolutionary army, operating in the same environment, did not
act in the same way. This means that the Makhnovists are strong evidence that
Bolshevik politics played a key role in the degeneration of the Russian
Revolution. Clearly such a conclusion is dangerous to Bolshevism and so the
Maknovist movement must be attacked, regardless of the facts.

A recent example of this is John Rees' essay _"In Defence of October"_ (
**International Socialism** , no. 52, pp. 3-82). Rees, a member of the UK
Socialist Workers' Party (SWP) is at pains to downplay the role of Bolshevik
ideology in the degeneration of the Russian Revolution. He argues that
"objective factors" ensured that the Bolsheviks acted as they did. The
_"subjective factor"_ was simply a choice between defeat and defence against
the Whites: _"Within these limits Bolshevik policy was decisive."_ [ **Op.
Cit.** , p. 30] This explains his attack on the Makhnovist movement. Faced
with the same _"objective factors"_ as the Bolsheviks, the Makhnovists did not
act in the same way. As such, the _"subjective factor"_ amounts to more than
Rees' stark choice and so objective conditions cannot explain everything.

Clearly, then, the Makhnovists undermine his basic thesis. As such, we would
expect a less than honest account of the movement and Rees does not
disappoint. He talks about the _"muddled anarchism"_ of Makhno, dismissing the
whole movement as offering no alternative to Bolshevism and being without _"an
articulated political programme."_ Ultimately, for Rees, Makhno's _"anarchism
was a thin veneer on peasant rebellion"_ and while _"on paper"_ the
Makhnovists _"appeared to have a more democratic programme"_ there were
_"frauds."_ [p. 57, p. 58, p. 61 and p. 70]

The reality of the situation is totally different. Ignoring the obvious
contradiction (i.e. how can the Makhnovists have the appearance of a
_"democratic programme"_ and, simultaneously, not articulate it?) we shall
analyse his account of the Makhnovist movement in order to show exactly how
low the supporters of Bolshevism will go to distort the historical record for
their own aims (see the appendix ["What was the Kronstadt
uprising?"](append42.md) for Rees's distortions about the Kronstadt revolt).
Once the selective and edited quotations provided by Rees are corrected, the
picture that clearly emerges is that rather than the Makhnovists being
_"frauds,"_ it is Rees' account which is the fraud (along with the political
tradition which inspired it).

Rees presents two aspects of his critique of the Makhnovists. The first is a
history of the movement and its relationships (or lack of them) with the
Bolsheviks. The second is a discussion of the ideas which the Makhnovists
tried to put into practice. Both aspects of his critique are extremely flawed.
Indeed, the errors in his history of the movement are so fundamental (and,
indeed, so at odds with his references) that it suggests that ideology
overcame objectivity (to be polite). The best that can be said of his account
is that at least he does not raise the totally discredited accusation that the
Makhnovists were anti-Semitic or _"kulaks."_ However, he more than makes up
for this by distorting the facts and references he uses (it would be no
exaggeration to argue that the only information Rees gets correct about his
sources is the page number).

Rees starts by setting the tone, stating that the _"methods used by Makhno and
Antonov [a leader of the "Greens" in Tambov] in their fight against the Red
Army often mirrored those used by the Whites."_ [ **Op. Cit.** , p. 57]
Strangely enough, while he lists some for Antonov, he fails to specify any
against Makhno. However, the scene is set. His strongest piece of evidence as
regards Makhno's _"methods"_ against the Red Army come from mid-1920 after, it
should be noted, the Bolsheviks had engineered the outlawing of the Makhnovist
movement and needlessly started the very conflict Rees uses as evidence
against Makhno. In other words, he is attacking the Makhnovists for defending
themselves against Bolshevik aggression!

He quotes reports from the Ukrainian Front to blacken the Makhnovists, using
them to confirm the picture he extracts from _"the diary of Makhno's wife."_
These entries, from early 1920, he claims _"betray the nature of the
movement"_ (i.e. after, as we shall see, the Bolsheviks had engineered the
outlawing of the Makhnovists). [ **Op. Cit.** , p. 58] The major problem for
Rees' case is the fact that this diary is a fake and has been known to be a
fake since Arshinov wrote his classic account of the Makhnovists in 1923:

> _"After 1920, the Bolsheviks wrote a great deal about the personal defects
> of Makhno, basing their information on the diary of his so-called wife, a
> certain Fedora Gaenko .. . . But Makhno's wife is Galina Andreevna
> Kuz'menko. She has lived with him since 1918. She **never** kept, and
> therefore never lost, a diary. Thus the documentation of the Soviet
> authorities is based on a fabrication, and the picture these authorities
> draw from such a diary is an ordinary lie."_ [Arshinov, **History of the
> Makhnovist Movement** , p. 226f]

Ironically enough, Rees implicitly acknowledges this by lamely admitting (in
an end note) that _"Makhno seems to have had two 'wives'"_ [ **Op. Cit.** , p.
78] And we should note that the source Rees uses for the fake diary entries
(W.H. Chamberlin's **The Russian Revolution** ) uses as **his** source the
very Bolshevik documentation that Arshinov quite correctly denounced over 70
years before Rees put pen to paper. Little wonder Michael Palij, in his
detailed account of the movement ( **The Anarchism of Nestor Makhno,
1918-1921** ), fails to use it. So, in summary, a major part of his account is
based on falsehoods, falsehoods exposed as such decades ago. This indicates
well the quality of his case against the Makhnovist movement.

As regards the "evidence" he extracts from this fake diary and Red Army
reports, it simply shows that Bolsheviks were shot by Makhno's troops and Red
Army troops died in combat. This went both ways, of course. In _"military
operations the Bolsheviks shot all prisoners. The Makhnovists shot all
captured officers unless the Red rank and file strongly interceded for them.
The rank and file were usually sent home, though a number volunteered for
service with the Insurgents."_ Equally, _"[o]n the occupation of a village by
the Red Army the Cheka would hunt out and hang all active Makhnovite
supporters; an amenable Soviet would be set up; officials would be appointed
or imported to organise the poor peasants . . . and three or four Red militia
men left as armed support for the new village bosses."_ [David Footman, **Op.
Cit.** , pp. 292-3] As such, Rees' account of Makhnovist "terror" against the
Bolsheviks seems somewhat hypocritical. We can equally surmise that the
methods used by the Bolsheviks against the Makhnovists also _"often mirrored
those used by the Whites"_! And Rees lambastes socialist Samuel Farber for
mentioning the _"Red Terror, but not the Green Terror"_ in Farber's discussion
of the Tambov revolt! All in all, pretty pathetic.

Rees' concern for the truth can be seen from the fact that he asserts that
Makhno's _"rebellion"_ was _"smaller"_ than the Tambov uprising and
distinguished from it _"only by the muddled anarchism of its leader."_ [ **Op.
Cit.** , p. 58] In fact, the Makhnovist movement was the bigger of the two. As
Michael Malet notes:

> _"The differences between them explain why the Makhnovshchina lasted over
> four years, the Antonovshchina less than one year. The initial area of the
> Makhno movement was larger, and later expanded, whereas the Antonov region
> was restricted to the southern half of one province throughout its
> existence. The Makhno movement became established earlier, and was well-
> known before its break with the soviet regime. A crucial factor was the
> period of peace between the Bolsheviks and Makhno during the first half of
> 1919, something Antonov never had. It allowed for political and social
> development as well as military build-up. It followed from this that Makhno
> attracted much more support, which was increased and deepened by the
> positive ideology of Makhno and the anarchists who came to help him. This
> was not a matter of being anti-State and anti-town -- all the Greens,
> including Antonov, shared this view in a less sophisticated form -- but a
> positive land policy and a realisation of the need to link up with the towns
> on a federal basis in the post-revolutionary society."_ [ **Op. Cit.** , p.
> 155]

Even in terms of troops, the Makhno movement was larger. The Antonov rebellion
had _"a peak of around 20,000"_ troops. [Read, **Op. Cit.** , p. 268] Makhno,
in comparison, had a peak of about 40,000 in late 1919 [Palij, **Op. Cit.** ,
p. 112] (Read states a peak of around 30,000 [ **Op. Cit.** , p. 264]). Even
by the end of 1920, a few months into the Tambov rebellion (it started in
August of that year), the Makhnovists still had 10 to 15 thousand troops.
[Palij, **Op. Cit.** , p. 237]

In summary, the movement which lasted longer, covered a larger area and
involved more troops is classed by Rees as the smaller of the two! Incredible
-- but it does give a flavour of the scholarship involved in his essay.
Perhaps by _"smaller"_ Rees simply meant that Makhno was physically shorter
than Antonov?

After getting such minor details as size wrong, Rees turns to the actual
history of the movement. He looks at the relations between the Makhnovists and
the Bolsheviks, accurately stating that they _"were chequered."_ However, he
is wrong when he tries to explain what happened by stating they _"reflect[ed]
the fast changing military situation in the Ukraine throughout the civil
war."_ [ **Op. Cit.** , p. 58] In fact, as we will prove, the relationships
between the two forces reflected the military situation refracted through the
ideology and needs of Bolshevik power. To ignore the ideological factor in the
Makhnovist-Bolshevik relationships cannot be justified as the military
situation does **not** fully explain what happened.

The Makhnovists co-operated with the Red Army three times. Only two of these
periods were formal alliances (the first and last). Discussing the first two
pacts, Rees alleges that the Makhnovists broke with the Bolsheviks. The truth
is the opposite -- the Bolsheviks turned on the Makhnovists and betrayed them
in order to consolidate their power. These facts are hardly unknown to Rees as
they are contained in the very books he quotes from as evidence for his
rewritten history.

The first pact between the Makhnovists and the Red Army ended June 1918.
According to Rees, _"[c]o-operation continued until June 1919 when the
Insurgent Army broke from the Red Army"_ and quotes Michael Palij's book **The
Anarchism of Nestor Makhno** as follows: _"as soon as Makhno left the front he
and his associates began to organise new partisan detachments in the
Bolsheviks' rear, which subsequently attacked strongholds, troops, police,
trains and food collectors."_ [ **Op. Cit.** , p. 58] Rees is clearly implying
that Makhno attacked the Bolsheviks, apparently for no reason. The truth is
totally different. It is easy to show this -- all we need to do is look at the
book he uses as evidence.

Rees quotes Palij on page 177. This page is from chapter 16, which is called
_"The Bolsheviks Break with Makhno."_ As this was not enough of a clue, Palij
presents some necessary background for this Bolshevik break. He notes that
before the break, _"the Bolsheviks renewed their anti-Makhno propaganda.
Trotsky, in particular, led a violent campaign against the Makhno movement."_
He also mentions that _"[a]t the same time, the supplies of arms and other war
materials to Makhno were stopped, thus weakening the Makhno forces vis-a-vis
the Denikin troops."_ In this context, the Makhnovists Revolutionary Military
Council _"decided to call a fourth congress of peasants, workers, and
partisans"_ for June 15th, 1919, which Trotsky promptly banned, warning the
population that _"participation in the Congress shall be considered an act of
state treason against the Soviet Republic and the front."_ [ **Op. Cit.** , p.
175 and p. 176]

The Bolsheviks had, of course, tried to ban the third congress in April but
had been ignored. This time, they made sure that they were not. Makhno and his
staff were not informed of Trotsky's dictatorial order and learned of it three
days later. On June 9th, Makhno sent a telegram informing the Bolsheviks that
he was leaving his post as leader of the Makhnovists. He _"handed over his
command and left the front with a few of his close associates and a cavalry
detachment"_ while calling upon the partisans to _"remain at the front to hold
off Denikin's forces."_ Trotsky ordered his arrest, but Makhno was warned in
advance and escaped. On June 15-16th, members of Makhno's staff _"were
captured and executed the next day."_ **Now** Palij recounts how _"[a]s soon
as Makhno left the front he and his associates began to organise new partisan
detachments in the Bolsheviks' rear, which subsequently attacked strongholds,
troops, police, trains and food collectors."_ [ **Op. Cit.** , p. 177]

Palij _"subsequently"_ refers to Makhno after Denikin's breakthrough and his
occupation of the Ukraine. _"The oppressive policy of the Denikin regime,"_ he
notes, _"convinced the population that it was as bad as the Bolshevik regime,
and brought a strong reaction that led able young men . . . to leave their
homes and join Makhno and other partisan groups."_ [ **Op. Cit.** , p. 190] As
Makhno put it, _"[w]hen the Red Army in south Ukraine began to retreat . . .
as if to straighten the front line, but in reality to evacuate Ukraine . . .
only then did my staff and I decide to act."_ [quoted by Palij, **Op. Cit.** ,
p. 190] After trying to fight Denikin's troops, Makhno retreated and called
upon his troops to leave the Red Army and rejoin the fight against Denikin. He
_"sent agents amongst the Red troops"_ to carry out propaganda urging them to
stay and fight Denikin with the Makhnovists, which they did in large numbers.
This propaganda was _"combined with sabotage."_ Between these two events,
Makhno had entered the territory of pogromist warlord Hryhoryiv (which did
**not** contain Red troops as they were in conflict) and assassinated him. [
**Op. Cit.** , p. 191 and p. 173]

It should also be noted that Palij states that it was the Whites who _"were
the main enemy that Makhno fought, stubbornly and uncompromisingly, from the
end of 1918 to the end of 1919."_ [ **Op. Cit.** , p. 177]

Clearly, Rees's summary leaves a lot to be desired! Rather than Makhno
attacking the Bolsheviks, it was they who broke with him -- as Palij, Rees's
source, makes clear. Indeed, Makhno made no attempt to undermine the Red
Army's campaign against Denikin (after all, that would have placed his troops
and region in danger). Rather, he waited until the Bolsheviks showed that they
would not defend the Ukraine against the Whites before he acted. As such, Rees
misuses his source material and used Palij as evidence for a viewpoint which
is the exact opposite of the one he recounts. The dishonesty is obvious. But,
then again, it is understandable, as Trotsky banning a worker, peasant and
partisan congress would hardly fit into Rees' attempt to portray the
Bolsheviks as democratic socialists overcome by objective circumstances! Given
that the Makhnovists had successfully held three such congresses to discuss
the war against reaction, how could objective circumstances be blamed for the
dictatorial actions of Trotsky and other leading Red Army officers in the
Ukraine? Better not to mention this and instead rewrite history by making
Makhno break with the Bolsheviks and attack them for no reason!

Rees moves onto the period of co-operation between the insurgents and the
Bolsheviks. His version of what happened is that _"Denikin's advance against
Makhno's territory in autumn 1919 quickly forced a renewal of the treaty with
the Bolsheviks. Makhno harassed Denikin's troops from the rear, making their
advance more difficult."_ [ **Op. Cit.** , p. 58]

A more accurate account of what happened would be that Makhno reorganised his
troops after the Bolsheviks had retreated and evacuated the Ukraine. These
troops included those that had been left in the Red Army in June, who now left
to rejoin him (and brought a few Red Army units along too). After conducting
quick and demoralising raids against Denikin's forces, the Makhnovists were
forced to retreat to the West (followed by White forces). In late September,
near Peregonovka, Makhno inflicted a major defeat against the following Whites
and allowed the Makhnovists to attack across Denikin's supply lines (which
stopped his attack on Moscow thus, ironically, saving the Bolshevik regime).
Makhno's swift attack on the rear of the Whites ensured their defeat. As the
correspondent of **Le Temps** observed:

> _"There is no doubt that Denikin's defeat is explained more by the uprising
> of the peasants who brandished Makhno's black flag, then by the success of
> Trotsky's regular army. The partisan bands of 'Batko' tipped the scales in
> favour of the Reds."_ [quoted by Palij, **Op. Cit.** , p. 208]

Palij argues that it was the _"rapidly changing military situation [which]
soon caused a change in the Bolsheviks' attitude toward Makhno."_ The two
forces meet up on December 24th, 1919. However, _"[a]lthough the Bolsheviks
fraternised with the Makhno troops and the commander even offered co-
operation, they distrusted Makhno, fearing the popularity he had gained as a
result of his successful fight against Denikin."_ [ **Op. Cit.** , p. 209] It
should also be stressed that **no** formal treaty was signed.

Clearly, Rees' summary leaves a lot to be desired!

This is not the end of it. Rees even attempts to blame the Makhnovists for the
attack of General Wrangel. He argues that _"by the end of 1919 the immediate
White threat was removed. Makhno refused to move his troops to the Polish
front to meet the imminent invasion and hostilities with the Red Army began
again on an even more widespread scale."_ [ **Op. Cit.** , p. 58]

This, needless to say, is a total distortion of the facts. Firstly, it should
be noted that the _"imminent"_ invasion by Poland Rees mentions did not, in
fact, occur until _"the end of April"_ (the 26th, to be precise). The break
with Makhno occurred as a result of an order issued in early January (the 8th,
to be precise). [Michael Palij, **Op. Cit.** , p. 219 and p. 210] Clearly, the
excuse of _"imminent"_ invasion was a cover, as recognised by a source Rees
himself uses, namely Palij's work:

> _"The author of the order realised at that time there was no real war
> between the Poles and the Bolsheviks at that time and he also knew that
> Makhno would not abandon his region .. . . Uborevich [the author] explained
> that 'an appropriate reaction by Makhno to this order would give us the
> chance to have accurate grounds for our next steps' . . . [He] concluded:
> 'The order is a certain political manoeuvre and, at the very least, we
> expect positive results from Makhno's realisation of this.'"_ [Palij, **Op.
> Cit.** , p. 210]

This is confirmed by Rees' other references. David Footman, whom Rees also
uses for evidence against the Makhnovist movement, notes that while it was
_"true there were military reasons for reinforcing"_ the Polish frontier
(although he also notes the significant fact that the war _"was not to break
out for another four months"_ ), it was _"admitted on the Soviet side that
this order was primarily 'dictated by the necessity' of liquidating
**Makhnovshchina** as an independent movement. Only when he was far removed
from his home country would it be possible to counteract his influence, and to
split up and integrate his partisans into various Red Army formations."_ He
notes that there were _"other occasions (notably in Siberia) of the Soviet
authorities solving the problem of difficult partisan leaders by sending them
off to fight on distant fronts"_ and, of course, that _"Makhno and his staff .
. . were perfectly aware of the underlying Soviet motives."_ Footman recounts
how the Makhnovist staff sent a _"reasoned reply"_ to the Bolsheviks, that
there _"was no immediate response"_ from them and in _"mid-January the Central
Committee of the Ukrainian Communist Party declared Makhno and his force to be
outside the law, and the Red Army attacked."_ [ **The Russian Civil War** ,
pp. 290-1]

In other words, according to the sources Rees himself selects, the Bolsheviks
**started** the conflict in order to eliminate opposition to their power!

Needless to say, the Makhnovists **did** realise the political motivations
behind the order. As Arshinov notes, _"[s]ending the insurrectionary army to
the Polish front meant removing from the Ukraine the main nerve centre of the
revolutionary insurrection. This was precisely what the Bolsheviks wanted:
they would then be absolute masters of the rebellious region, and the
Makhnovists were perfectly aware of this."_ In addition, _"neither the 14th
Corps nor any other unit of the Red Army had any ties with the Makhnovist
army; least of all were they in a position to give orders to the
insurrectionary army."_ Nor does Rees mention that the Makhnovists considered
the move _"physically impossible"_ as _"half the men, the entire staff and the
commander himself were in hospital with typhus."_ [ **Op. Cit.** , p. 163]

Consider what Rees is (distortedly) accounting. The beginning of 1920 was a
time of peace. The Civil War looked like it was over. The White Generals had
been defeated. Now the Bolsheviks turn on their allies after issuing an
ultimatum which they knew would never be obeyed. Under the circumstances, a
stupider decision cannot be easily found! Moreover, the very logic of the
order was a joke. Would be it wise to leave the Ukraine undefended? Of course
not and if Red Army units were to stay to defend the region, why not the
Makhnovists who actually came from the area in question? Why provoke a
conflict when it was possible to transfer Red Army units to the Polish front?
Simply put, Rees presents a distorted picture of what was happening in the
Ukraine at the time simply so he can whitewash the Bolshevik regime and
blacken the Makhnovists. As he himself later notes, the Bolshevik-Makhnovist
conflict gave the White General Wrangel the space required to restart the
Civil War. Thus the Bolshevik decision to attack the Makhnovists helped
prolong the Civil War -- the very factor Rees blames the degeneration of the
Russian Revolution and Bolshevik ideology and practice on!

It is **now** that Rees presents his evidence of Makhnovist violence against
the Bolsheviks (the Red Army reports and entries from the fake diary of
Makhno's wife). Arguing that the entries from the fake diary _"betray the
nature of the movement in this period,"_ he tries to link them with Makhnovist
theory. _"These actions,"_ he argues, _"were consistent with an earlier
resolution of the Insurgent Army which declared that it was 'the actions of
the Bolshevik regime which cause a real danger to the worker-peasant
revolution."_ [ **Op. Cit.** , p. 59]

Firstly, given a true account of the second break between the Makhnovists and
Bolsheviks, it would be fair to conclude that the resolution was, in fact,
correct! However, such facts are not mentioned by Rees, so the reader is left
in ignorance.

Secondly, to correct another of Rees' causal mistakes, it should be noted that
this resolution was **not** passed by the Insurgent Army. Rather it was passed
at the Second Regional Congress of Peasants, Workers and Insurgents held at
Hulyai Pole on February 12th, 1919. This congress had 245 delegates,
representing 350 districts and was one of four organised by the Makhnovists.
Unsurprisingly, these regional congresses are not even mentioned by Rees in
his account. This is for obvious reasons -- if the Makhnovists could organise
congresses of workers, peasants and insurgents to discuss the progress of the
revolution, then why could the Bolsheviks not manage it? Equally, to mention
them would also mean mentioning that the Bolsheviks tried to ban one and
succeeded in banning another.

Thirdly, the tone of the congress was anti-Bolshevik simply because the
Ukraine had had a taste of Bolshevik rule. As Rees himself acknowledges in a
roundabout way, the Bolsheviks had managed to alienate the peasantry by their
agricultural policies.

Fourthly, the Bolsheviks had engineered the outlawing of the Makhnovists. Thus
the actions of the Makhnovists were **not** _"consistent"_ with the earlier
resolution. They were, in fact, _"consistent"_ with self-defence against a
repressive state which had attacked them first!

Looking at the congress where the resolution was passed, we find that the list
of _"real dangers"_ was, quite simply, sensible and, in fact, in line with
Leninist rhetoric. The resolution acknowledged the fact that the Bolshevik
party was _"demanding a monopoly of the Revolution."_ As we discussed in
[section 14](append46.md#app14), it was during this period that the
Bolsheviks explicitly started to argue that the "dictatorship of the party"
**was** the "dictatorship of the proletariat." The resolution also stated:

> _"With deep regret the Congress must also declare that apart from external
> enemies a perhaps even greater danger, arising from its internal
> shortcomings, threatens the Revolution of the Russian and Ukrainian peasants
> and workers. The Soviet Governments of Russia and of the Ukraine, by their
> orders and decrees, are making efforts to deprive local soviets of peasants
> and workers' deputies of their freedom and autonomy."_ [quoted by Footman,
> **Op. Cit.** , p. 267]

It also stated:

> _"the political commissars are watching each step of the local soviets and
> dealing ruthlessly with those friends of peasants and workers who act in
> defence of peoples' freedom from the agency of the central government . . .
> The Bolshevik regime arrested left Socialist Revolutionaries and anarchists,
> closing their newspapers, stifling any manifestation of revolutionary
> expression."_

Delegates also complained that the Bolshevik government had not been elected,
that it was _"imposing upon us its party dictatorship"_ and _"attempting to
introduce its Bolshevik monopoly over the soviets."_ [quoted by Palij, [ **Op.
Cit.** , p. 154]

The resolution noted that the current situation was _"characterised by the
seizure of power by the political party of Communists-Bolsheviks who do not
balk at anything in order to preserve and consolidate their political power by
armed force acting from the centre. The party is conducting a criminal policy
in regard to the social revolution and in regard to the labouring masses."_ To
top it off, point number three read:

> _"We protest against the reactionary habits of Bolshevik rulers, commissars,
> and agents of the Cheka, who are shooting workers, peasants, and rebels,
> inventing all kinds of excuses . . . The Cheka which were supposed to
> struggle with counterrevolution . . . have turned in the Bolsheviks' hands
> into an instrument for the suppression of the will of the people. They have
> grown in some cases into detachments of several hundred armed men with a
> variety of arms. We demand that all these forces be dispatched to the
> front."_ [quoted by Vladimir N. Brovkin, **Behind the Front Lines of the
> Civil War** , pp. 109-10]

We should also point out that Rees selectively quotes the resolution to
distort its meaning. The resolution, in fact, _"urges the peasants and workers
to watch vigilantly the actions of the Bolshevik regime that cause a real
danger to the worker-peasant revolution."_ [quoted by Palij, **Op. Cit.** , p.
154] We have listed some of the actions of the Bolsheviks that the congress
considered as a _"real danger."_ Considering the truth of these complaints,
only someone blinded by Bolshevik ideology would consider it strange that
worker and peasant delegates should agree to _"watch vigilantly"_ those
actions of the Bolsheviks which were a _"real danger"_ to their revolution!

Lenin (before taking power, of course) had argued that elections and recall to
soviets were essential to ensure that the workers control the "workers' state"
and that socialism required the elimination of _"special bodies of armed men"_
by an armed population. To this day, his followers parrot his claims (while,
simultaneously, justifying the exact opposite in Lenin's Russia). Now, is Rees
**really** arguing that the Bolshevik monopoly of power, the creation of a
secret police and the clamping down on working people's freedom were **not**
dangers to the Russian Revolution and should not be watched _"vigilantly"_? If
so, then his conception of revolution includes the strange notion that
dictatorship by a party does not threaten a revolution! Then again, neither
did the Bolsheviks (indeed, they thought calling worker, peasant and partisan
congresses to discuss the development of the revolution as the real danger to
it!). If not, then he cannot fault the regional congress resolution for
pointing out the obvious. As such, Rees' misquoting of the resolution
backfires on him.

Significantly, Rees fails to mention that during this period (the first half
of 1920), the Bolsheviks _"shot ordinary soldiers as well as their commanders,
destroying their houses, confiscating their properties, and persecuting their
families. Moreover the Bolsheviks conducted mass arrests of innocent peasants
who were suspected of collaborating in some way with the partisans. It is
impossible to determine the casualties involved."_ The hypocrisy is clear.
While Rees presents information (some of it, we stress, from a fake source) on
Makhnovist attacks against the Bolshevik dictatorship, he remains silent on
the Bolshevik tactics, violence and state terrorism. Given that the Bolsheviks
had attacked the Makhnovists, it seems strange that that Rees ignores the
_"merciless methods"_ of the Bolsheviks (to use Palij's phrase) and
concentrates instead on the acts of self-defence forced onto the Makhnovists.
Perhaps this is because it would provide too strong a _"flavour"_ of the
Bolshevik regime? [ **Op. Cit.** , pp. 212-3 and p. 213]

Rees makes great play of the fact that White forces took advantage of the
conflict between the Makhnovists and the Bolsheviks, as would be expected.
However, it seems like an act of ideological faith to blame the victims of
this conflict for it! In his attempts to demonise the Makhnovists, he argues
that _"[i]n fact it was Makhno's actions against the Red Army which made 'a
brief return of the Whites possible.'"_ In defence of his claims, Rees quotes
from W. Bruce Lincoln's **Red Victory**. However, looking at Lincoln's work we
discover that Lincoln is well aware who is to blame for the return of the
Whites. Unsurprisingly, it is **not** the Makhnovists:

> _"Once Trotsky's Red Army had crushed Iudenich and Kolchak and driven
> Deniken's forces back upon their bases in the Crimea and the Kuban, it
> turned upon Makhno's partisan forces with a vengeance . . . [I]n mid-January
> 1920, after a typhus epidemic had decimated his forces, a re-established
> Central Committee of the Ukrainian Communist Party declared Makhno an
> outlaw. Yet the Bolsheviks could not free themselves from Makhno's grasp so
> easily, and it became one of the supreme ironies of the Russian Civil War
> that his attacks against the rear of the Red Army made it possible for the
> resurrected White armies . . . to return briefly to the southern Ukraine in
> 1920."_ [ **Red Victory** , p. 327]

Ignoring the fact that Rees does not bother to give the correct quote (a
problem that re-occurs frequently in his essay), it can be seen that he does
paraphrase the last sentence of Lincoln's work correctly. Strange, then, that
he ignores the rest of his account which clearly indicates that the Bolsheviks
_"turned upon"_ the Makhnovists and _"declared Makhno an outlaw."_ Obviously
such trivial facts as the initial Bolshevik attacks against the Makhnovists
are unimportant to understanding what actually happened in this period.
Informing his readers that it was the Bolsheviks' betrayal of the Makhnovists
which provoked the resistance that _"made it possible for . . . the White
armies . . . to return briefly"_ would confuse them with facts and so it goes
unmentioned.

Lincoln, it must be stressed, concurs with Rees's other main sources (Palij
and Footman) on the fact that the Bolsheviks betrayed the Makhnovists!
Clearly, Rees has rewritten history and distorted **all** of his main
references on the Makhnovist movement. After reading the same fact in three
different sources, you would think that the Bolshevik betrayal of the
Makhnovists which provoked their resistance against them would warrant
**some** mention, but no! In true Stalinist fashion, Rees managed to turn a
Bolshevik betrayal of the Makhnovists into a stick with which to beat them
with! Truly amazing.

Simply put, if the Bolsheviks had not wanted to impose their rule over the
Ukraine, then the conflict with the Makhnovists need not have taken place and
Wrangel would not have been in a position to invade the Ukraine. Why did the
Bolsheviks act in this way? There was no _"objective factor"_ for this action
and so we must turn to Bolshevik ideology.

As we proved in [section 14](append46.md#app14), Bolshevik ideology by this
time identified Bolshevik party dictatorship as the only expression of "the
dictatorship of the proletariat." Does Rees **really** believe that such
perspectives had no impact on how the Bolsheviks acted during the Revolution?
The betrayal of the Makhnovists can only be understood in terms of the
_"subjective factor"_ Rees seeks to ignore. If you think, as the Bolsheviks
clearly did, that the dictatorship of the proletariat equalled the
dictatorship of the party (and vice versa) then anything which threatened the
rule of the party had to be destroyed. Whether this was soviet democracy or
the Makhnovists did not matter. The Makhnovist idea of worker and peasant
self-management, like soviet democracy, could not be reconciled with the
Bolshevik ideology. As such, Bolshevik policy explains the betrayals of the
Makhnovists.

Not satisfied with distorting his source material to present the Makhnovists
as the guilty party in the return of Wrangel, he decides to blame the initial
success of Wrangel on them as well. He quotes Michael Palij as follows: _"As
Wrangel advanced . . . Makhno retreated north . . . leaving behind small
partisan units in the villages and towns to carry out covert destruction of
the Bolshevik administrative apparatus and supply bases."_ [ **Op. Cit.** , p.
59] He again sources Palij's work on the _"effective"_ nature of these groups,
stating that White Colonel Noga reported to headquarters that Makhno was
critical to Wrangel's advance.

As regards the claims that Makhno was _"critical"_ to Wrangel's advance,
Colonal Noga actually states that it was _"peasant uprisings under Makhno and
many other partisan detachments"_ which gave _"the Reds no rest."_ [quoted by
Palij, **Op. Cit.** , p. 214] However, what Rees fails to mention is that
Palij argues that it was the Bolshevik _"policy of terror and exploitation"_
which had _"turned almost all segments of Ukrainian society against the
Bolsheviks, substantially strengthened the Makhno movement, and consequently
facilitated the advance of the reorganised anti-Bolshevik force of General
Wrangel from the Crimea into South Ukraine, the Makhno region."_ [Palij, **Op.
Cit.** , p. 214] Again, Makhno is blamed for the inevitable results of
Bolshevik policies and actions!

It should also be reported that Noga's comments are dated 25th March 1920,
while Palij's summary of Makhno's activities retreating from Wrangel was about
June 1920 -- 2 months later! As regards this advance by Wrangel, Palij argues
that it was the _"outbreak of the Polish-Bolshevik war at the end of April"_
which _"benefited Wrangel"_ and _"enabled him to launch an offensive against
the Bolsheviks in Tavriia on June 6th."_ Indeed, it was after a _"series of
battles"_ that Wrangel _"penetrated north, forcing a general Bolshevik
retreat."_ Now, _"[a]s Wrangel advanced deeper into the Left Bank, Makhno
retreated north to the Kharkiv region, leaving behind small partisan units in
the villages and towns to carry on covert destruction of the Bolshevik
administrative apparatus and supply bases."_ [ **Op. Cit.** , p. 219] Again,
Rees' account has little bearing to reality or the source material he uses.

Rees continues to re-write history by arguing that _"Makhno did not fight with
the Reds again until October 1920 when Wrangel advanced on Makhno's base."_ [
**Op. Cit.** , p. 59] In fact, it was the **Makhnovists** who contacted the
Bolsheviks in July and August in 1920 with a view to suspending hostilities
and co-operating in the fight against Wrangel. This decision was made at a
mass assembly of insurgents. Sadly, the Bolsheviks made no response. Only in
September, after Wrangel had occupied many towns, did the Bolsheviks enter
into negotiations. [Arshinov, **Op. Cit.** , pp. 176-7] This is confirmed by
Footman, who states that it is _"agreed that the initiative for joint action
against Wrangel came from the Makhnovists"_ [ **Op. Cit.** , p. 294], as well
as by Palij, who notes that _"Makhno was compelled to seek an understanding
with the Bolsheviks"_ but _"no reply was received."_ It was _"Wrangel's
success [which] caused the Bolshevik leaders to reconsider Makhno's earlier
proposal."_ [ **Op. Cit.** , pp. 222-3] Obviously indicating that the
Makhnovists placed the struggle against the White counter-revolution above
their own politics would place the Bolsheviks in a bad light, and so Rees
fails to give the details behind the agreement of joint action against
Wrangel.

As regards this third and final break, Rees states that it was (
_"unsurprisingly"_ ) a _"treaty of convenience on the part of both sides and
as soon as Wrangel was defeated at the end of the year the Red Army fought
Makhno until he have up the struggle."_ [ **Op. Cit.** , p. 59] Which, as far
as it goes, is true. Makhno, however, _"assumed [that] the forthcoming
conflict with the Bolsheviks could be limited to the realm of ideas"_ and that
they _"would not attack his movement immediately."_ [Palij, **Op. Cit.** , p.
231] He was wrong. Instead the Bolsheviks attacked the Makhnovists without
warning and, unlike the other breaks, without pretext (although leaflets
handed out to the Red Army stated that **Makhno** had _"violat[ed] the
agreement"_! [Palij, **Op. Cit.** , p. 236]).

It would be a good idea to reproduce the agreement which the Bolsheviks ripped
up. There were two parts, a military and a political one. The military one is
pretty straight forward (although the clause on the Makhnovists refusing to
accept Red Army detachments or deserters suggests that the Makhnovists'
democratic army was seen by many Red Army soldiers as a better alternative to
Trotsky's autocratic structure). The political agreement was as follows:

> _"1. Immediate release, and an end to the persecution of all Makhno men and
> anarchists in the territories of the Soviet Republics, except those who
> carry on armed resistance against Soviet authorities._
>
> _"2. Makhno men and anarchists were to have complete freedom of expression
> of their ideas and principles, by speech and the press, provided that
> nothing was expressed that tended to a violent overthrow of Soviet
> government, and on condition that military censorship be respected. . ._
>
> _"3. Makhno men and anarchists were to enjoy full rights of participation in
> elections to the soviets, including the right to be elected, and free
> participation in the organisation of the forthcoming Fifth All-Ukrainian
> Congress of Soviets . . ."_ [cited by Palij, **Op. Cit.** , p. 224]

Needless to say, the Bolsheviks delayed the publication of the political
agreement several until several days after the military one was published --
_"thus blurring its real meaning."_ [Palij, **Op. Cit.** , p. 225] Clearly, as
it stands, the agreement just gave the Makhnovists and anarchists the rights
they should have had according to the Soviet Constitution! Little wonder the
Bolsheviks ignored it -- they also ignored their own constitution. However, it
is the fourth point of the political agreement which gives the best insight
into the nature of Bolshevism. This last point was never ratified by the
Bolsheviks as it was _"absolutely unacceptable to the dictatorship of the
proletariat."_ [quoted by Palij, **Ibid.** ] This clause was:

> _"One of the basic principles of the Makhno movement being the struggle for
> the self-administration of the toilers, the Partisan Army brings up a fourth
> point: in the region of the Makhno movement, the worker and peasant
> population is to organise and maintain its own free institutions for
> economic and political self-administration; this region is subsequently
> federated with Soviet republics by means of agreements freely negotiated
> with the appropriate Soviet governmental organ."_ [quoted by Palij, **Op.
> Cit.** , p. 224]

Clearly, this idea of worker and peasant self-management, like soviet
democracy, could not be reconciled with the Bolshevik support for party
dictatorship as the expression of _"the dictatorship of the proletariat"_
which had become a Bolshevik ideological truism by that time. Little wonder
the Bolsheviks failed to ratify the fourth clause and violated the other
agreements. Simply put, a libertarian alternative to Bolshevism would give the
Russian and Ukrainian working masses hope of freedom and make them harder to
control. It is unsurprising that Rees fails to discuss the treaty -- it would,
yet again, undermine his case that the Bolsheviks were forced by objective
circumstances to be dictatorial.

And, of course, let us not forget the circumstances in which this betrayal
took place. The country was, as Rees reminds us, in a state of economic
disruption and collapse. Indeed, Rees blames the anti-working class and
dictatorial actions and policies of the Bolsheviks on the chaos caused by the
civil war. Yet here are the Bolsheviks prolonging this very Civil War by
turning (yet again!) on their allies. After the defeat of the Whites, the
Bolsheviks preferred to attack the Makhnovists rather than allow them the
freedom they had been fighting for. Resources which could have been used to
aid the economic rebuilding of Russia and the Ukraine were used to attack
their former allies. The talents and energy of the Makhnovists were either
killed or wasted in a pointless conflict. Should we be surprised? After all,
the Bolsheviks had preferred to compound their foes during the Civil War (and,
indirectly, aid the very Whites they were fighting) by betraying their
Makhnovist allies on two previous occasions (once, because the Makhnovists had
dared call a conference of working people to discuss the civil war being
fought in their name). Clearly, Bolshevik politics and ideology played a key
role in all these decisions. They were **not** driven by terrible objective
circumstances (indeed, they made them worse).

Rees obviously distorted the truth about the first two agreements between the
Makhnovists and the Bolsheviks. He portrayed the Makhnovists as the guilty
party, "breaking" with the Bolsheviks when in fact it was (in both cases) the
Bolsheviks who broke with and betrayed the Makhnovists. That explains why he
fails to present any information on **why** the first break happened and why
he distorts the events of the second. It cannot be said that he was unaware of
these facts -- they are in the very books he himself references! As such, we
have a clear and intended desire to deceive the reader. As regards the third
agreement, while he makes no pretence that the Makhnovists were the guilty
party however, he implies that the Bolsheviks had to act as they did before
the Makhnovists turned on them. Little wonder, then, that he does not provide
the details of the agreement made between the Bolsheviks and Makhnovists -- to
do so would have been to expose the authoritarianism of the Bolsheviks. Simply
put, Rees'distortions of the source material he uses comes as no surprise. It
undermines his basic argument and so cannot be used in its original form.
Hence the cherry-picking of quotations to support his case.

After distorting Makhnovist relations with the Bolsheviks, Rees moves on to
distorting the socio-political ideas and practice of the Makhnovists. As would
be expected from his hatchet-job on the military history of the movement, his
account of its social ideas leaves much to be desired. However, both aspects
of his critique have much in common. His account of its theoretical ideas and
its attempts to apply them again abuse the source material in disgraceful
ways.

For example, Rees states that under the Makhnovists _"[p]apers could be
published, but the Bolshevik and Left Socialist Revolutionary press were not
allowed to call for revolution"_ and references Michael Palij's book. [ **Op.
Cit.** , p. 60] Looking at the page in question, we discover a somewhat
different account. According to Palij's work, what the Makhnovists
**actually** _"prohibited"_ was that these parties should _"propagate armed
uprisings against the Makhnovist movement."_ A clear rewriting of the source
material and an indication of how low Leninists will sink. Significantly,
Palij also notes that this _"freedom of speech, press, assembly and
association"_ was implemented _"[i]n contrast to the Bolshevik regime"_ and
its policy of crushing such liberties. [ **Op. Cit.** pp. 152-3] Ironically,
the military-political agreement of late 1920 between the Reds and Makhnovists
included a similar clause, banning expression that _"tended to a violent
overthrow of the Soviet government."_ [quoted by Palij, **OP. Cit.** , p. 224]
Which means, to use Rees' distorted terminology, that the Bolsheviks banned
calls for revolution!

However, this distortion of the source material **does** give us an insight
into the mentality of Leninism. After all, according to Palij, when the
Makhnovists entered a city or town they _"immediately announced to the
population that the army did not intend to exercise political authority."_ The
workers and peasants were to set up soviets _"that would carry out the will
and orders of their constituents"_ as well as _"organis[e] their own self-
defence force against counter-revolution and banditry."_ These political
changes were matched in the economic sphere as well, as the _"holdings of the
landlords, the monasteries and the state, including all livestocks and goods,
were to be transferred to the peasants"_ and _"all factories, plants, mines,
and other means of production were to become property of all the workers under
control of their professional unions."_ [ **Op. Cit.** , p. 151]

In such an environment, a call for _"revolution"_ (or, more correctly, _"armed
uprisings against the Makhno movement"_ ) could only mean a Bolshevik coup to
install a Bolshevik party dictatorship. As the Makhnovists were clearly
defending working- class and peasant self-government, then a Bolshevik call
for _"armed uprisings"_ against them also meant the end of such free soviets
and their replacement with party dictatorship. Little wonder Rees distorts his
source! Arshinov makes the situation clear:

> _"The only restriction that the Makhnovists considered necessary to impose
> on the Bolsheviks, the left Socialist Revolutionaries and other statists was
> a prohibition on the formation of those 'revolutionary committees' which
> sought to impose a dictatorship over the people. In Aleksandrovsk and
> Ekaterinoslav, right after the occupation of these cities by the
> Makhnovists, the Bolsheviks hastened to organise **Revkoms** (
> **Revolutionary Committees** ) seeking to organise their political power and
> govern the population . . . Makhno advised them to go and take up some
> honest trade instead of seeking to impose their will on the workers . . . In
> this context the Makhnovists' attitude was completely justified and
> consistent. To protect the full freedom of speech, press, and organisation,
> they had to take measures against formations which sought to stifle this
> freedom, to suppress other organisations, and to impose their will and
> dictatorial authority on the workers."_ [ **Op. Cit.** , p. 154]

Little wonder Rees distorts the issues and transforms a policy to defend the
**real** revolution into one which banned a _"call for revolution"_! We should
be grateful that he distorted the Makhnovist message for it allows us to
indicate the dictatorial nature of the regime and politics Rees is defending.

All of which disproves Rees' assertion that _"the movement never had any real
support from the working class. Neither was it particularly interested in
developing a programme which would appeal to the workers."_ [ **Op. Cit.** ,
p. 59] Now, Rees had obviously read Palij's summary of Makhnovist ideas. Is he
claiming that workers' self-management and the socialisation of the means of
production do not _"appeal"_ to workers? After all, most Leninists pay lip-
service to these ideas. Is Rees arguing that the Bolshevik policies of the
time (namely one-man management and the militarisation of labour) _"appealed"_
to the workers more than workers' self-management of production? Equally, the
Makhnovists argued that the workers should form their own free soviets which
would _"carry out the will and orders of their constituents."_ [Palij, **Op.
Cit.** , p. 151] Is Rees **really** arguing that the Bolshevik policy of party
dictatorship _"appealed"_ to the workers more than soviet democracy? If so,
then heaven help us if the SWP ever get into power!

Luckily, as Jonathan Aves' book **Workers Against Lenin** proves, this was not
the case. Working-class resistance to Bolshevik policies was extremely
widespread and was expressed by strikes. It should be noted that the wave of
strikes all across Russia which preceded the Kronstadt revolt also raised the
demand for soviet democracy. The call for _"free soviets"_ was raised by the
Kronstadt revolt itself and during the "mini-Kronstadt" in Katerinoslav in
June 1921 where the demands of the workers _"were very similar in content with
the resolutions of the Kronstadt rebels"_ and telegraph operators sent
_"messages throughout the Soviet Republic calling for 'free soviets.'"_
[Jonathan Aves, **Workers Against Lenin** , p. 172 and p. 173]

Clearly, the Makhnovists **did** create a _"programme that would appeal to the
workers."_ However, it is true that the Makhnovists did fail win over more
than a minority of workers. This may have been due to the fact that the
Makhnovists only freed two cities, both for short periods of time. As Paul
Avrich notes, "he found little time to implement his economic programs." [
**Anarchist Portraits** , p. 121] Given how Rees bends over backwards to
justify Bolshevik policies in terms of _"objective factors,"_ it is
significant that in his discussion of the Makhnovists such _"objective
factors"_ as time fail to get a mention!

Thus Rees's attempt to paint the Makhnovists as anti-working class fails.
While this is the core of his dismissal of them as a possible _"libertarian
alternative to the Bolsheviks,"_ the facts do not support his assertions. He
gives the example of Makhno's advice to railway workers in Aleksandrovsk _"who
had not been paid for many weeks"_ that they should _"simply charge passengers
a fair price and so generate their own wages."_ He states that this _"advice
aimed at reproducing the petit-bourgeois patterns of the countryside."_ [
**Op. Cit.** , p. 59] Two points can be raised to this argument.

Firstly, we should highlight the Bolshevik (and so, presumably,
_"proletarian"_ ) patterns imposed on the railway workers. Trotsky simply
_"plac[ed] the railwaymen and the personnel of the repair workshops under
martial law"_ and _"summarily ousted"_ the leaders of the railwaymen's trade
union when they objected." The Central Administrative Body of Railways
(Tsektran) he created was run by him _"along strictly military and
bureaucratic lines."_ In other words, he applied his ideas on the
_"militarisation of labour"_ in full. [M. Brinton, **The Bolsheviks and
Workers' Control** , p. 67] Compared to the Bolshevik pattern, only an
ideologue could suggest that Makhno's advice (and it was advice, not a decree
imposed from above, as was Trotsky's) can be considered worse. Indeed, by
being based on workers' self-management it was infinitely more socialist than
the militarised Bolshevik state capitalist system.

Secondly, Rees fails to understand the nature of anarchism. Anarchism argues
that it is up to working class people to organise their own activities. This
meant that, ultimately, it was up to the railway workers **themselves** (in
association with other workers) to organise their own work and industry.
Rather than being imposed by a few leaders, **real** socialism can only come
from below, built by working people, through their own efforts and own class
organisations. Anarchists can suggest ideas and solutions, but ultimately its
up to workers (and peasants) to organise their own affairs. Thus, rather than
being a source of condemnation, Makhno's comments should be considered as
praiseworthy as they were made in a spirit of equality and were based on
encouraging workers' self-management.

Ultimately, the best reply to Rees is simply the fact that after holding a
_"general conference of the workers of the city"_ at which it was _"proposed
that the workers organise the life of the city and the functioning of the
factories with their own forces and their own organisations"_ based on _"the
principles of self-management,"_ the _"[r]ailroad workers took the first step
in this direction"_ by _"form[ing] a committee charged with organising the
railway network of the region."_ [Arshinov, **Op. Cit.** , p. 149]

Even more amazing (if that is possible) is Rees' account of the revolution in
the countryside. Rees argues that the _"real basis of Makhno's support was not
his anarchism, but his opposition to grain requisitioning and his
determination not to disturb the peasant economy"_ [ **Op. Cit.** , p. 59] and
quotes Palij as follows:

> _"Makhno had not put an end to the agricultural inequalities. His aim was to
> avoid conflicts with the villages and to maintain a sort of united front of
> the entire peasantry."_ [M. Palij, **Op. Cit.** , p. 214]

However, here is the actual context of the (corrected) quote:

> _"Peasants' economic conditions in the region of the Makhno movement were
> greatly improved at the expense of the estates of the landlords, the church,
> monasteries, and the richest peasants, but Makhno had not put an end to the
> agricultural inequalities. His aim was to avoid conflicts within the
> villages and to maintain a sort of united front of the entire peasantry."_
> [M. Palij, **Op. Cit.** , p. 214]

Clearly, Rees has distorted the source material, conveniently missing out the
information that Makhno had most definitely "disturbed" the peasant economy at
the expense of the rich! And, we are sure that Rees would have a fit if it
were suggested that the real basis of Bolshevik support was not their
socialism, but their opposition to the war and the Whites!

Amazingly, Rees also somehow manages to forget to mention the peasant
revolution which had started in 1917 in his attack against Makhno:

> _"Makhno and his associates brought socio-political issues into the daily
> life of the people, who in turn supported the expropriation of large estates
> . . . On the eve of open conflict [in late 1917], Makhno assembled all the
> landowners and rich peasants (kulaks) of the area and took from them all
> official documents relating to their land, livestock, and equipment.
> Subsequently an inventory of this property was taken and reported to the
> people at the session of the local soviet, and then at the regional meeting,
> It was decided to allow the landlords to share the land, livestock, and
> tools equally with the peasants."_ [Palij, **Op. Cit.** , p. 71]

Obviously, Rees considers the expropriating of the landlords and kulaks as an
act which _"did not disturb the age-old class structure of the countryside"_!

Let us not forget that the official Makhnovist position was that the
_"holdings of the landlords, the monasteries, and the state, including all
livestock and goods, were to be transferred to the peasants."_ [Palij, **Op.
Cit.** , p. 151] At the second congress of workers, peasants and insurgents
held in February, 1919, it was resolved that _"all land be transferred to the
hands of toiling peasants . . . according to the norm of equal distribution."_
[quoted by Palij, **Op. Cit.** , p. 155] This meant that every peasant family
had as much land as they could cultivate without the use of hired labour. The
Makhnovists argued with regards to the kulaks:

> _"We are sure that . . . the kulak elements of the village will be pushed to
> one side by the very course of events. The toiling peasantry will itself
> turn effortlessly on the kulaks, first by adopting the kulak's surplus land
> for general use, then naturally drawing the kulak elements into the social
> organisation."_ [cited by Michael Malet, **Op. Cit.** , pp. 118-9]

Thus, just to stress the point, the Makhnovists **did** _"disturb"_ the _"age-
old class structure of the countryside."_

Clearly, Rees is simply taking nonsense. When he states that Makhnovist land
policies _"did not disturb the age-old class structure of the countryside,"_
he is simply showing his utter and total disregard for the truth. As the
Bolsheviks themselves found out, no mass movement could possibly exist among
the peasants without having a positive and levelling land policy. The
Makhnovists were no exception.

Rees then states that _"[i]n 1919 the local Bolshevik authorities made
mistakes which played into Makhno's hands."_ Unsurprisingly enough, he argues
that this was because they _"tried to carry through the socialisation of the
land, rather than handing it over to the peasants."_ [ **Op. Cit.** , p. 60]
In fact, the Bolsheviks did **not** try to implement the _"socialisation"_ of
land. Rather, they tried to **nationalise** the land and place it under state
control -- a radically different concept. Indeed, it was the Makhnovists who
argued that the _"land, the factories, the workshops, the mines, the railroads
and the other wealth of the people must belong to the working people
themselves, to those who work in them, that is to say, they must be
socialised."_ [contained in Arshinov, **Op. Cit.** , p. 273] The Bolsheviks,
in contrast, initially _"decreed that all lands formerly belonging to the
landlords should be expropriated and transformed into state farms."_ [Palij,
**Op. Cit.** , p. 156] The peasants quite rightly thought that this just
replaced one set of landlords with another, stealing the land which rightfully
belonged to them.

After distorting the source material by selective quoting, Rees does it again
when he argues that _"by the spring of 1920 they [the Bolsheviks] had reversed
the policy towards the peasants and instituted Committees of Poor Peasants,
these 'hurt Makhno . . . his heart hardened and he sometimes ordered
executions.' This policy helped the Bolshevik ascendancy."_ [ **Op. Cit.** ,
p. 60]

Rees quotes Palij as evidence. To refute his argument we need simply quote the
same pages:

> _"Although they [the Bolsheviks] modified their agricultural policy by
> introducing on February 5, 1920, a new land law, distributing the former
> landlords', state and church lands among the peasants, they did not succeed
> in placating them because of the requisitions, which the peasants considered
> outright robbery . . . Subsequently the Bolsheviks decided to introduce
> class warfare into the villages. A decree was issued on May 19, 1920,
> establishing 'Committees of the Poor' . . . Authority in the villages was
> delegated to the committees, which assisted the Bolsheviks in seizing the
> surplus grain . . . The establishment of Committees of the Poor was painful
> to Makhno because they became not only part of the Bolshevik administrative
> apparatus the peasants opposed, but also informers helping the Bolshevik
> secret police in its persecution of the partisans, their families and
> supporters, even to the extent of hunting down and executing wounded
> partisans . . . Consequently, Makhno's 'heart hardened and he sometimes
> ordered executions where some generosity would have bestowed more credit
> upon him and his movement. That the Bolsheviks preceded him with the bad
> example was no excuse. For he claimed to be fighting for a better cause.'
> Although the committees in time gave the Bolsheviks a hold on every village,
> their abuse of power disorganised and slowed down agricultural life . . .
> This policy of terror and exploitation turned almost all segments of
> Ukrainian society against the Bolsheviks, substantially strengthened the
> Makhno movement, and consequently facilitated the advance of the reorganised
> anti-Bolshevik force of General Wrangel from the Crimea into South Ukraine,
> the Makhno region."_ [M. Palij, **Op. Cit.** , pp. 213-4]

Amazing what a _". . ."_ can hide, is it not! Rees turns an account which
clearly shows the Bolshevik policy was based on informers, secret police and
the murder of rebels as well as being a total disaster into a victory.
Moreover, he also transforms it so that the victims are portrayed as the
villains. Words cannot do this re-writing of history justice. Yes, indeed, an
organisation of informers to the secret police in every village can aid the
_"ascendancy"_ of a one-party dictatorship (aided, of course, by overwhelming
military force), but it cannot aid the ascendancy of freedom, equality and
socialism.

Given the actual record of the Bolsheviks' attempts to break up what they
considered the _"age-old class structure"_ of the villages with the
_"Committees of the Poor,"_ it is clear why Rees distorts his source.

It does seem ironic that Rees attacks the Makhnovists for not pursuing
Bolshevik peasant policies. Considering the absolute **failure** of those
policies, the fact that Makhno did not follow them is hardly cause for
condemnation! Indeed, given the numerous anti-Bolshevik uprisings and large-
scale state repression they provoked, attacking the Makhnovists for not
pursuing such insane policies is equally insane. After all, who, in the middle
of a Civil War, makes matters worse for themselves by creating more enemies?
Only the insane -- or the Bolsheviks!

That Makhnovist land policy was correct and the Bolshevik one wrong can be
seen from the fact that the latter changed their policies and brought them
into line with the Makhnovist ones. As Palij notes, the Bolsheviks _"modified
their agricultural policy by introducing on February 5, 1920, a new land law,
distributing the formers landlords', state, and church lands among the
peasants."_ This, of course, was a vindication of Makhnovist policy (which
dated from 1917!). Makhno _"initiated the peasants' movement, confiscating and
distributing landlords' land and goods"_ (and, unlike the Bolsheviks,
_"encouraging the workers to take over factories and workshops"_ ). As regards
the Bolsheviks attempts to break up what they considered the _"age- old class
structure"_ of the villages with the _"Committees of the Poor,"_ it was, as
noted above, a complete disaster and counter-productive. [ **Op. Cit.** , p.
213 and p. 250] All in all, the Makhnovist policies were clearly the most
successful as regards the peasantry. They broke up the class system in the
countryside by expropriating the ruling class and did not create new conflicts
by artificially imposing themselves onto the villages.

Lastly, we must also wonder just how sensible it is to _"disturb"_ the economy
that produces the food you eat. Given that Rees, in part, blames Bolshevik
tyranny on the disruption of the economy, it seems incredible that he faults
Makhno for not adding to the chaos by failing to _"disrupt the peasant
economy"_! However, why let logic get in the way of a good rant!

As well as ignoring the wealth of information on Makhnovist land policy, Rees
turns to their attempts to form free agrarian communes. He argues that
Makhno's attempts _"to go beyond the traditional peasant economy were doomed"_
and quotes Makhno's memoirs which state _"the mass of the people did not go
over"_ to his peasant communes, which only involved a few hundred families. [
**Op. Cit.** , p. 59]

Looking at Makhno's memoirs a somewhat different picture appears. Firstly,
Makhno states that there were _"four such agricultural communes within a
three- or four-mile radius of Hulyai-Pole,"_ but in the whole district _"there
were many"_ in 1918 (the period being discussed in his memoirs). Makhno
recounts how each _"commune consisted of ten families of peasants and workers,
totalling a hundred, two hundred or three hundred members"_ and the
_"management of each commune was conducted by a general meeting of all its
members."_ He does state that _"the mass of people did not go over to it"_
but, significantly, he argues that this was because of _"the advance of the
German and Austrian armies, their own lack of organisation, and their
inability to defend this order against the new 'revolutionary' and counter-
revolutionary authorities. For this reason the toiling population of the
district limited their real revolutionary activity to supporting in every way
those bold spirits among them who had settled on the old estates [of the
landlords] and organised their personal and economic life on free communal
lines."_ [quoted by Paul Avrich, **The Anarchists in the Russian Revolution**
, pp. 130-2]

Of course, failing to mention the time period Makhno was recounting does
distort the success of the communes. The Bolsheviks were evacuating the
Ukraine as part of their treaty with German and Austrian Imperialism when the
communes were being set up. This left them in a dangerous position, needless
to say. By July, 1918, the area was occupied by Austrian troops and it was
early 1919 before the situation was stable enough to allow their
reintroduction. One commune was named _"Rosa Luxemburg"_ (after the Marxist
revolutionary martyr) and was mostly destroyed by the Bolsheviks in June 1919
and completely destroyed by the Whites a few days later. In such
circumstances, can it be surprising that only a minority of peasants got
involved in them? Rather than praise the Makhnovists for positive social
experimentation in difficult circumstances, Rees shows his ignorance of the
objective conditions facing the revolution. Perhaps if the peasants did not
have to worry about the Bolsheviks as well as the Whites, they would have had
more members?

All in all, Rees account of Makhnovist ideas on the peasant economy are, to
put it mildly, incorrect. They paint a radically different picture of the
reality of both Makhnovist ideas and practice as regards the peasantry.
Ironically, the soundness of Makhnovist policy in this area can be seen from
the fact that the Bolsheviks changed their land policy to bring it into line
with it. Not, of course, that you would know that from Rees' account. Nor
would you know what the facts of the Bolsheviks' land policy were either.
Indeed, Rees uses Michael Palij's book to create a picture of events which is
the exact opposite of that contained in it! Very impressive!

Intent on driving the final nail into the coffin, he tries to apply "class
analysis" to the Makhnovists. Rees actually states that _"given this social
base [i.e the Makhnovists' peasant base] . . . much of Makhno's libertarianism
amounted to little more than paper decrees."_ [ **Op. Cit.** , p. 60]

Ironically enough, the list of _"paper decrees"_ Rees presents (when not false
or distorted) are also failings associated with the Bolsheviks (and taken to
even more extreme measures by the Bolsheviks)! As such, his lambasting of the
Makhnovists seems deeply hypocritical. Moreover, his attempt to ground the few
deviations that exist between Makhnovist practice and Makhnovist theory in the
peasant base of the army seems an abuse of class analysis. After all, these
deviations were also shared by the Bolsheviks. As such, how can Rees justify
the Bolshevik deviations from socialist theory in terms of _"objective
factors"_ yet blame Makhnovist ones on their _"social base"_? Do _"objective
factors"_ only afflict Leninists?

Take for example his first _"paper"_ decree, namely the election of
commanders. He states that _"in practice the most senior commanders were
appointed by Makhno."_ In other words, the Makhnovists applied this principle
extensively but not completely. The Bolsheviks abolished it by decree (and did
not blame it on _"exceptional circumstances"_ nor consider it as a _"retreat"_
, as Rees asserts). Now, if Rees' "class analysis" of the limitations of the
Makhnovists were true, does this mean that an army of a regime with a
proletarian base (as he considers the Bolshevik regime) cannot have elected
commanders? This is the logical conclusion of his argument.

Equally, his attempt to _"give a flavour of the movement"_ by quoting one of
the resolutions adopted by a mass meeting of partisans also backfires (namely,
_"to obey the orders of the commanders if the commanders are sober enough to
give them"_ ). Firstly, it should be noted that this was, originally, from a
Red Army source. Secondly, drunkenness was a big problem during the civil war
(as in any war). It was one of the easiest ways of forgetting reality at a
time when life was often unpleasant and sometimes short. As such, the
_"objective factor"_ of civil war explains this resolution rather than the
social base of the movement! Thirdly, Rees himself quotes a Central Committee
member's comment to the Eighth Party Congress that there were so many
_"horrifying facts about drunkenness, debauchery, corruption, robbery and
irresponsible behaviour of many party members that one's hair stands on end."_
[ **Op. Cit.** , p. 66] The Eighth Congress was in 1919. Does this comment
give a _"flavour"_ of the Bolshevik regime under Lenin? Obviously not, as Rees
defends it and blames this list of horrors on the objective factors facing the
Bolsheviks. Why does the drunkenness of the Makhnovists come from their
_"social base"_ while that of the Bolsheviks from _"objective factors"_?
Simply put, Rees is insulting the intelligence of his readers.

The Makhnovist resolution was passed by a mass assembly of partisans,
suggesting a fundamentally democratic organisation. Rees argues that the civil
war resulted in the Bolshevik vices becoming institutionalised in the power of
the bureaucracy. However, as can be seen, the Makhnovists practised democracy
during the civil war, suggesting that the objective factors Rees tries to
blame for the Bolshevik vices simply cannot explain everything. As such, his
own example (yet again) backfires on his argument.

Rees claims that _"Makhno held elections, but no parties were allowed to
participate in them."_ [ **Op. Cit.** , p. 60] This is probably derived from
Palij's comment that the free soviets would _"carry out the will and orders of
their constituents"_ and _"[o]nly working people, not representatives of
political parties, might join the soviets."_ [ **Op. Cit.** , p. 151] This, in
turn, derives from a Makhnovist proclamation from January 1920 which stated:

> _"Only labourers who are contributing work necessary to the social economy
> should participate in the soviets. Representatives of political
> organisations have no place in worker-peasant soviets, since their
> participation in a workers' soviet will transform the latter into deputies
> of the party and can lead to the downfall of the soviet system."_ [contained
> in Peter Arshinov's **History of the Makhnovist Movement** , p. 266]

Rees' comments indicate that he is not familiar with the make-up of the
Russian Soviets of 1917. Unlike the soviets from the 1905 revolution, those in
1917 allowed _"various parties and other organisations to acquire voting
representation in the soviet executive committees."_ Indeed, this was _"often
how high party leaders became voting delegates to"_ such bodies. It should
_"be underlined that these party delegates were selected by the leadership of
each political organisation, and not by the soviet assembly itself. In other
words, these executive committee members were not directly elected by the
representatives of the producers"_ (never mind by the producers themselves).
[Samuel Farber, **Before Stalinism** , p. 31]

In addition, Russian Anarchists had often attacked the use of _"party lists"_
in soviet elections, which turned the soviets from working-class organs into
talking-shops. [Paul Avrich, **The Russian Anarchists** , p. 190] This use of
party lists meant that soviet delegates could be anyone. For example, the
leading left-wing Menshevik Martov recounts that in early 1920 a chemical
factory _"put up Lenin against me as a candidate [to the Moscow soviet]. I
received seventy-six votes he-eight (in an open vote)."_ [quoted by Israel
Getzler, **Martov** , p. 202] How would either of these two intellectuals
actually know and reflect the concerns and interests of the workers they would
be "delegates" of? If the soviets were meant to be the delegates of working
people, then why should non-working class members of political parties be
elected to a soviet?

Given that the people elected to the free soviets would be **delegates** and
**not** representatives, this would mean that they would reflect the wishes of
their workmates rather than the decisions of the party's central committee. As
such, if a worker who was a member of a political party could convince their
workmates of their ideas, the delegate would reflect the decisions of the mass
assembly. As such, the input of political parties would not be undermined in
any way (although their domination would be!).

As such, the Makhnovist ideas on soviets did not, in fact, mean that workers
and peasants could **not** elect or send delegates who were members of
political parties. They had no problems as such with delegates who happened to
be working- class party members. They did have problems with delegates
representing only political parties, delegates who were not workers and
soviets being mere ciphers covering party rule.

That this was the case can be seen from a few facts. Firstly, the February
1919 congress resolution _"was written by the anarchists, left Socialist
Revolutionaries, and the chairman."_ [Palij, **Op. Cit.** , p. 155] Similarly,
the Makhnovist Revolutionary Military Soviet created at the Aleksandrovsk
congress in late 1919 had three Communists elected to it. There were 18
delegates from workers at that congress, six were Mensheviks and the remaining
12 included Communists [Malet, **Op. Cit.** , p. 111, p. 124] Clearly, members
of political parties were elected to both the congresses and the Revolutionary
Military Soviet. As such, the idea that free soviets excluded members of
political parties is false -- they simply were not dominated by them (for
example, having executives made up of members of a single party or delegating
their power to a government as per the national soviet in Russia). This could,
of course, change. In the words of the Makhnovist reply to Bolshevik attempts
to ban one of their congresses:

> _"The Revolutionary Military Council . . . holds itself above the pressure
> and influence of all parties and only recognises the people who elected it.
> Its duty is to accomplish what the people have instructed it to do, and to
> create no obstacles to any left socialist party in the propagation of ideas.
> Consequently, if one day the Bolshevik idea succeeds among the workers, the
> Revolutionary Military Council . . . will necessarily be replaced by another
> organisation, 'more revolutionary' and more Bolshevik."_ [quoted by
> Arshinov, **Op. Cit.** , pp. 103-4]

As such, the Makhnovists supported the right of working- class self-
determination, as expressed by one delegate to Hulyai Pole conference in
February 1919:

> _"No party has a right to usurp governmental power into its hands . . . We
> want life, all problems, to be decided locally, not by order from any
> authority above; and all peasants and workers should decide their own fate,
> while those elected should only carry out the toilers' wish."_ [quoted by
> Palij, **Op. Cit.** , p. 154]

Thus, Rees fails to present an accurate account of Makhnovist theory and
practice as regards _"free soviets."_ Rather than oppose party participation
within their soviets and congresses, the Makhnovists opposed the domination of
soviets and congresses by political parties, a radically different concept.
Like the Kronstadt rebels, they argued for all power to the soviets and not to
parties.

Lastly, Rees attacks the Makhnovists for having two security forces, the
Cheka-like **razvedka** and the Punitive Commission. How this is an expression
of the Makhnovist _"social base"_ is hard to explain, as both the Bolsheviks
and Whites also had their security forces and counter-intelligence agencies.

While Rees quotes Footman's statement that _"we can safely assume [!] these
services were responsible for frequent injustices and atrocities,"_ he fails
to mention that Footman does not provide any examples (hence his comment that
we can _"assume"_ they occurred!). Footman himself notes that _"[o]f the
Makhnovite security services . . . we know very little."_ [David Footman,
**Op. Cit.** , p. 288] Rees himself only lists one, namely the summary
shooting of a Bolshevik cell discovered in the Army. Given the bloody record
of the Bolshevik Cheka (which, again, Rees defends as necessary to defend
against the Whites!), this suggests that the crimes of the Makhnovist counter-
intelligence pale in comparison.

Rees also quotes the historian Chamberlin that _"Makhno's private Cheka . . .
quickly disposed of anyone who was suspected of plotting against his life."_ [
**Op. Cit.** , 60] Strangely enough, Rees fails to mention the Bolshevik
attempts to assassinate Makhno, including the one in the latter part of May
1919 when, it should be noted, the Makhnovists and Bolsheviks were meant to be
in alliance. Nor does he mention that the Cheka _"would hunt out and hang all
active Makhnovites."_ [David Footman, **Civil War in Russia** , p. 271 and p.
293]

As regards the last conflict with the Red Army, it should be noted that while
_"generalised accusations of Makhnovist atrocities are common"_ the facts are
it was _"the Makhnovists who stood to gain by liberating prisoners, the
Bolsheviks by shooting them."_ This was because _"the Red Army soldiers had
been conscripted from elsewhere to do work they neither liked nor understood"_
and the _"insurgents had their own homes to defend."_ [Malet, **Op. Cit.** ,
p. 130] Thus, while Rees quotes Footman's opinion that _"Makhno's later
campaigns [were] among the most bloody and vindictive,"_ these facts suggest
that we **cannot** _"safely assume that these [security] services were
responsible for frequent injustices and atrocities."_ Clearly, if the
Makhnovists were releasing Red Army prisoners (and many of whom were joining
Makhno), the picture of an atrocity inflicting army can hardly be a valid
picture.

And it should be stressed that Bolshevik terror and violence against the
Makhnovists is strangely absent from Rees's account.

Rees presents just **one** concrete example of Makhnovist _"Cheka-like"_
violence, namely, the execution of a Bolshevik cell in December, 1919. It
should be noted that the Bolsheviks had been explicitly arguing for Party
dictatorship for some time by then. The reason why the Bolsheviks had been
_"denied an open trial"_ was because they had already been shot.
Unfortunately, Makhno gave two contradictory reasons why the Bolsheviks had
been killed. This led to the Makhnovist Revolutionary Military Soviet setting
up a commission of three to investigate the issue. Perhaps unsurprisingly, the
commission exonerated Makhno although Voline, out of the members, seemed to
have been genuinely embarrassed by the affair. [Malet, **Op. Cit.** , pp.
51-2] Needless to say, Rees fails to comment on the Bolshevik summary killing
of Makhnovist staff in June 1919 or, indeed, any other summary executions
conducted by the Bolsheviks against the Makhnovists (including the shooting of
prisoners).

Given the summary justice handed out by the Bolshevik Cheka, it seems strange
that Rees dismisses the Makhnovist movement on assumptions and one event, yet
he does. Obviously, the large-scale and continuous Bolshevik killings of
political enemies (including Makhnovists) is irrelevant compared to this one
event.

All in all, Rees' attempts to blame the few deviations the Makhnovists had
from anarchist theory on the _"social base"_ of the movement are a joke. While
justifying the far more extreme deviations of Bolshevik theory and practice in
terms of _"objective factors,"_ he refuses to consider this possibility for
the Makhnovists. The hypocrisy is clear, if not unexpected.

One last point. Taking Rees' "class analysis" of the Makhnovists seriously,
the logical conclusion of his argument is clear. For Rees, a movement which
compromises slightly with its principles in the face of extreme _"objective
factors"_ is _"petty bourgeois."_ However, a movement which compromises
totally (indeed introduces and justifies the exact opposite of its original
claims) in face of the same _"objective factors"_ is _"proletarian."_ As such,
his pathetic attempt at "class analysis" of the Makhnovists simply shows up
the dictatorial nature of the Bolsheviks. If trying to live up to
libertarian/democratic ideals but not totally succeeding signifies being
_"petty-bourgeois"_ while dismissing those ideals totally in favour of top-
down, autocratic hierarchies is _"proletarian"_ then sane people would happily
be labelled _"petty-bourgeois"_!

And Rees states that _"[n]either Makhno's social programme nor his political
regime could provide an alternative to the Bolsheviks"_! [ **Op. Cit.** , p.
60] Little wonder he distorts that social programme and political regime -- an
honest account of both would see that Rees is wrong. The Makhnovist movement
clearly shows that not only did Bolshevik policies have a decisive impact on
the development of the Russian Revolution, there was a clear alternative to
Bolshevik authoritarianism and party dictatorship.

In summary, Rees' attack on the Makhnovists fails. It can be faulted on both
factual and logical grounds. His article is so riddled with errors, selective
quoting and downright lies that it is factually unreliable. Similarly, his
attempt to attack the Makhnovist political theory and practice is equally
factually incorrect. His attempt to explain the deviations of Makhnovist
practice from its theory in terms of the _"social base"_ is simply an insult
to the intelligence of the reader and an abuse of class analysis.

A far more compelling analysis would recognise that the Makhnovists were not a
perfect social movement but that the deviations of its practice from its
theory can be explained by the objective factors it faced. Equally, the
example of the Makhnovists shows the weakness of Rees' main argument, namely
that the objective factors that Bolshevism faced can solely explain its
authoritarian politics. That the Makhnovists, facing the same objective
factors, did not act in the same manner as the Bolsheviks shows that Bolshevik
ideology played a key role in the failure of the revolution. This explains
Rees' clumsy attempts to rewrite the history and theory of the Makhnovshchina.

## 16 What lessons can be learned from the Makhnovists?

The Makhnovist movement was one of the most important events of the Russian
Revolution. It was a mass movement of working people who tried and succeeded
to implement libertarian ideas in extremely difficult circumstances.

As such, the most important lesson gained from the experience of the Makhno
movement is simply that _"objective factors"_ cannot and do not explain the
degeneration of the Russian Revolution or Bolshevik authoritarianism. Here was
a movement which faced the same terrible circumstances as the Bolsheviks faced
(White counter-revolution, economic disruption, and so on) and yet did not act
in the same manner as the Bolsheviks. Where the Bolsheviks completely
abolished army democracy, the Makhnovists extensively applied it. Where the
Bolsheviks implemented party dictatorship **over** the soviets, the
Makhnovists encouraged and practised soviet self-management. While the
Bolsheviks eliminated freedom of speech, press, assembly, the Makhnovists
defended and implemented them. The list is endless (see [section
14](append46.md#app14)).

This means that one of the key defences of the Bolshevik Myth, namely that the
Bolsheviks had no choice but to act as they did due to _"objective factors"_
or _"circumstances"_ is totally undermined. As such, it points to the obvious
conclusion: Bolshevik ideology influenced the practice of the party, as did
their position within the _"workers' state,"_ and so influenced the outcome of
the Revolution. This means that to play down Bolshevik ideology or practice in
favour of _"objective factors"_ , one fails to understand that the actions and
ideas generated during the revolution were not "objectively" determined but
were **themselves** important and sometimes decisive factors in the outcome.

Take, for example, the Bolshevik decision to betray the Makhnovists in 1920.
Neither betrayal was "objectively determined" before- hand. However, it did
make perfect sense from a perspective which equated the revolution with the
_"dictatorship of the party."_ That the first betrayal undoubtedly extended
the length of the Civil War by allowing the Whites the space to reorganise
under Wrangel also had its impact on Bolshevik theory and practice as well as
the _"objective factors"_ it had to face.

As such, the Makhnovists give a counter-example to the common pro-Bolshevik
argument that the horrors of the Civil War were responsible for the
degeneration of the Bolshevik Party and the revolution. In the words of one
historian:

> _"[The] Insurgent Army . . . was organised on a voluntary basis and
> respected the principle of election of commanders and staff. The regulations
> governing conduct were drawn up by commissions of soldiers and approved by
> general meetings of the units concerned. In other words, it embodied the
> principles of the soldiers' movement of 1917, principles rejected by the
> Bolsheviks when they set up the Red Army, supposedly because of their
> harmful effects on fighting efficiency, a characteristic of them discovered
> by the Bolsheviks only after they had come to power on the basis of
> promoting them. But the Insurgent Army, given its size and equipment, was
> very effective. Some have even credited it with greater responsibility than
> the Red Army for the defeat of Denikin. It took enormous efforts by the
> Bolsheviks, including the arrest or shooting of thousands of people, in
> order to pacify the region . . . even after the Insurgent Army was
> militarily broken, it took six months to mop up the remnants. . . Within its
> area of operations, which consisted of only two to three per cent of the
> total population of European Russia, the Insurgent Army was undoubtedly
> highly effective. While one can never know how history might have turned out
> had things been different, the Insurgent Army gives plenty of grounds for
> thinking that a people's revolutionary war of the kind it represented might
> have been at least as effective on a national scale with nationwide
> resources at its disposal as Trotsky and the Red Army's ruthless
> centralisation. It would not, however, have been compatible with the
> imposition from above of the Bolshevik leadership's vision of revolution.
> When the Insurgent Army drove the enemy out of an area they encouraged the
> local population to solve their own problems. Where the Red Army took over,
> the Cheka quickly followed. The Bolsheviks themselves were energetically
> snuffing out the ideals of 1917._
>
> _"Given such considerations it may be, though it cannot be logically proven
> one way or the other, that the Bolsheviks' deeply rooted authoritarianism
> rather than the civil war itself led to the construction of a highly
> centralised system that aimed at 'complete control' over political and many
> other aspects of social life. It could even be argued, though it is equally
> unprovable, that the tendency to authoritarianism, far from ensuring
> victory, nearly led to catastrophe. For one thing, it helped alienate many
> workers who felt cheated by the outcome of the revolution, and support for
> the regime was . . . far from even in this core group . . . [It] may,
> indeed, have been becoming more alienated as a result of Bolshevik measures
> depriving it of the means of expression of its growing catalogue of
> grievances. . . Far from being 'necessary' or even functional, the Bolshevik
> leadership's obsession with externally imposed discipline and authority
> might even have made the task of victory in the war more difficult and more
> costly. If the counter-example of Makhno is anything to go by then it
> certainly did."_ [Christopher Read, **From Tsar to Soviets** , pp. 264-5]

As such, another key lesson to be learned from the Makhno movement is the
importance of practising during a revolution the ideas you preach before it.
Means and ends are linked, with the means shaping the ends and the ends
inspiring the means. As such, if you argue for working-class power and
freedom, you cannot dump these aims during a revolution without ensuring that
they are never applied after it. As the Makhnovist movement showed, even the
most difficult situations need not hinder the application of revolutionary
ideas.

The importance of encouraging working-class autonomy also shines through the
Makhnovist experience. The problems facing a social revolution are many, as
are the problems involved in constructing a new society. The solutions to
these problems cannot be found without the active and full participation of
the working class. As the Makhnovist congresses and soviets show, free debate
and meaningful meetings are the only means, firstly, to ensure that working-
class people are _"the masters of their own lives,"_ that _"they themselves
are making the revolution,"_ that they _"have gained freedom."_ _"Take that
faith away,"_ stressed Alexander Berkman, _"deprive the people of power by
setting up some authority over them, be it a political party or military
organisation, and you have dealt a fatal blow to the revolution. You will have
robbed it of its main source of strength, the masses."_ [ **ABC of Anarchism**
, p. 82]

Secondly, it allows the participation of all in solving the problems of the
revolution and of constructing the new society. Without this input, **real**
socialism cannot be created and, at best, some form of oppressive state
capitalist regime would be created (as Bolshevism shows). A new society needs
the freedom of experimentation, to adapt freely to the problems it faces, to
adjust to the needs and hopes of those making it. Without working-class
freedom and autonomy, public life becomes impoverished, miserable and rigid as
the affairs of all are handed over to a few leaders at the top of a social
hierarchy, who cannot possibility understand, let alone solve, the problems
affecting society. Freedom allows the working class to take an active part in
the revolution. Restricting working-class freedom means the bureaucratisation
of the revolution as a few party leaders cannot hope to direct and rule the
lives of millions without a strong state apparatus. Simply put, the
emancipation of the working class is the task of the working class itself.
Either working class people create socialism (and that needs workers' autonomy
and freedom as its basis), or some clique will and the result will not be a
socialist society.

As the experience of the Makhnovist movement shows, working- class freedom can
be applied during a revolution and when it is faced with the danger of
counter-revolution.

Another key lesson from the Makhnovist movement is that of the need for
effective anarchist organisation. The Makhnovists did not become anarchist-
influenced by chance. The hard effort by the local anarchists in Hulyai Pole
before and during 1917 paid off in terms of political influence afterwards.
Therefore, anarchists need to take a leading role in the struggles of working
people (as we indicated in [section I.8.2](secI8.md#seci82), this was how
the Spanish anarchists gained influence as well). As Voline noted, one of the
advantages the Makhnovist movement had was _"the activity of . . . libertarian
elements in the region . . . [and the] rapidity with which the peasant masses
and the insurgents, despite unfavourable circumstances, became acquainted with
libertarian ideas and sought to apply them."_ [ **Op. Cit.** , p. 570]

Arshinov expands on this issue in a chapter of his history ( _"The
Makhnovshchina and Anarchism"_ ), arguing that many Russian anarchists
_"suffered from the disease of disorganisation,"_ which led to _"impoverished
ideas and futile practice."_ Moreover, most did not join the Makhnovist
movement, _"remained in their circles and **slept through** a mass movement of
paramount importance."_ [ **Op. Cit.** , p. 244 and p. 242]

Indeed, it was only in May 1919 that the _"Nabat"_ Ukrainian anarchist
confederation was organised. This federation worked closely with the
Makhnovists and gained influence in the villages, towns and cities within and
around the Makhnovist region. In such circumstances, the anarchists were at a
disadvantage compared to the Bolsheviks, Mensheviks and Socialist-
Revolutionaries, who had been organised far longer and so had more influence
within the urban workers.

While many anarchists did participate effectively and organisationally within
many areas of Russia and the Ukraine (gaining influence in Moscow and
Petrograd, for example), they were much weaker than the Bolsheviks. This meant
that the Bolshevik idea of revolution gained influence (by, it should be
noted, appropriating anarchist slogans and tactics). Once in power, the
Bolsheviks turned against their rivals, using state repression to effectively
destroy the anarchist movement in Russia in April 1918 (see [section
24](append41.md#app24) of the appendix ["What happened during the Russian
Revolution?"](append41.md) for details). This, incidentally, led to many
anarchists coming to the Ukraine to escape repression and many joined the
Makhnovists. As Arshinov notes, the Bolsheviks _"knew perfectly well that . .
. anarchism in Russia, lacking any contact with a mass movement as important
as the Makhnovshchina, did not have a base and could not threaten nor endanger
them."_ [ **Op. Cit.** , p. 248] Waiting till **after** a revolution starts to
build such a base is a dangerous tactic, as the experience of the Russian
anarchists shows. As the experience of the Moscow anarchists active in the
bakers' union shows, organised working-class support can be an effective
deterrent to state repression (the Moscow bakers' union continued to have
anarchists active in it until 1921).

It should be noted that this lesson was recognised by the main anarchists
associated with the Makhnovists. In exile, Voline argued for the need to build
a _"synthesis"_ anarchist federation (see [section J.3.2](secJ3.md#secj32))
while Arshinov and Makhno both associated themselves with the Platform (see
[section J.3.3](secJ3.md#secj33)).

Another key lesson is the need to combine rural and urban organisation. As
Voline argued, the _"absence of a vigorous organised workers' movement which
could support that of the peasant insurgents"_ was a major disadvantage for
the Makhno movement. [Voline, **Op. Cit.** , p. 571] If there had been a
workers' movement influenced by anarchist or syndicalist ideas within the
Ukrainian towns during the Russian Revolution, the possibilities of
constructive work would have been increased immensely. Take the example of
when the Makhnovists liberated Aleksandrovsk and organised two workers'
conferences. It was only at the insurgents' insistence that the unions agreed
to send delegates, but for information only. This was undoubtedly due to the
fact that Mensheviks had some influence in the unions and Bolshevik influence
was increasing. Both parties may have preferred the Makhnovists to the Whites,
but neither accepted anarchist ideas of workers' self-management and so
constructive work was limited to the railway workers. In contrast, when
Katerinoslav was liberated, the bakers set themselves to preparing the
socialisation of their industry and drawing up plans to feed both the army and
the civilian population. Unsurprisingly, the bakers had long been under
anarcho-syndicalist influence. [Malet, **Op. Cit.** , p. 123 and p. 124]

As the Makhnovists themselves realised, their movement had to be complemented
by urban working-class self-activity and self-organisations. While they did
all they could to encourage it, they lacked a base within the workers'
movement and so their ideas had to overcome the twin barriers of workers'
unfamiliarity with both them and their ideas and Marxist influence. With a
strong working- class movement influenced by anarchist ideas, the
possibilities for constructive work between city and village would have been
helped immensely (this can be seen from the example of the Spanish Revolution
of 1936, where rural and urban collectives and unions made direct links with
each other).

Lastly, there is the lesson to be gained from Makhnovist co-operation with the
Bolsheviks. Simply put, the experience shows the importance of being wary
towards Bolshevism. As Voline put it, another disadvantage of the Makhnovists
was a _"certain casualness, a lack of necessary distrust, towards the
Communists."_ [ **Op. Cit.** , p. 571] The Makhnovists were betrayed three
times by the Bolsheviks, who continually placed maintaining their own power
above the needs of the revolution. The anarchists were simply used as cannon
fodder against the Whites and once their utility had ended, the Bolsheviks
turned their guns on them.

Thus a lesson to be learned is that co-operation between anarchists and
Bolsheviks is fraught with danger. As many activists are aware, modern-day
supporters of Bolshevism constantly urge everyone to unite _"against the
common enemy"_ and not to be _"sectarian"_ (although, somehow this appeal to
non-sectarianism does not stop them printing lying accounts of anarchism!).
The Makhnovists took them at their word in early 1919 and soon found out that
_"unity"_ meant _"follow our orders."_ When the Makhnovists continued to apply
their ideas of working-class self-management, the Bolsheviks turned on them.
Similarly, in early 1920 the Bolsheviks outlawed the Makhnovists in order to
break their influence in the Ukraine. The Makhnovist contribution to the
defeat of Denikin (the common enemy) was ignored. Lastly, in mid-1920 the
Makhnovists placed the need of the revolution first and suggested an alliance
to defeat the common enemy of Wrangel. Once Wrangel had been defeated, the
Bolsheviks ripped up the agreement they had signed and, yet again, turned on
the Makhnovists. Simply put, the Bolsheviks continually placed their own
interests before that of the revolution and their allies. This is to be
expected from an ideology based on vanguardism (see [section H.5](secH5.md)
for further discussion).

This does not mean that anarchists and Leninists should not work together. In
some circumstances and in some social movements, this may be essential.
However, it would be wise to learn from history and not ignore it and, as
such, modern activists should be wary when conducting such co-operation.
Ultimately, for Leninists, social movements are simply a means to their end
(the seizing of state power by them on behalf of the working class) and
anarchists should never forget it.

Thus the lessons of the Makhnovist movement are exceedingly rich. Simply put,
the Makhnovshchina show that anarchism is a viable form of revolutionary ideas
and can be applied successfully in extremely difficult circumstances. They
show that social revolutions need not consist of changing one set of bosses
for another. The Makhnovist movement clearly shows that libertarian ideas can
be successfully applied in a revolutionary situation.

[‹ Were any of the Bolshevik oppositions a real alternative?](append45.md
"Go to previous page") [up](append4.md "Go to parent page") [Appendix :
Anarchism and "anarcho"-capitalism ›](append1.md "Go to next page")

