// ToACME - converts other source codes to ACME format.
// Copyright (C) 1999-2006 Marco Baye
// Have a look at "main.c" for further info
//
// assembler mnemonics

// mnemonics of legal 6502 instructions
const char	MnemonicADC[]	= "adc",
		MnemonicAND[]	= "and",
		MnemonicASL[]	= "asl",
		MnemonicBCC[]	= "bcc",
		MnemonicBCS[]	= "bcs",
		MnemonicBEQ[]	= "beq",
		MnemonicBIT[]	= "bit",
		MnemonicBMI[]	= "bmi",
		MnemonicBNE[]	= "bne",
		MnemonicBPL[]	= "bpl",
		MnemonicBRK[]	= "brk",
		MnemonicBVC[]	= "bvc",
		MnemonicBVS[]	= "bvs",
		MnemonicCLC[]	= "clc",
		MnemonicCLD[]	= "cld",
		MnemonicCLI[]	= "cli",
		MnemonicCLV[]	= "clv",
		MnemonicCMP[]	= "cmp",
		MnemonicCPX[]	= "cpx",
		MnemonicCPY[]	= "cpy",
		MnemonicDEC[]	= "dec",
		MnemonicDEX[]	= "dex",
		MnemonicDEY[]	= "dey",
		MnemonicEOR[]	= "eor",
		MnemonicINC[]	= "inc",
		MnemonicINX[]	= "inx",
		MnemonicINY[]	= "iny",
		MnemonicJMP[]	= "jmp",
		MnemonicJSR[]	= "jsr",
		MnemonicLDA[]	= "lda",
		MnemonicLDX[]	= "ldx",
		MnemonicLDY[]	= "ldy",
		MnemonicLSR[]	= "lsr",
		MnemonicNOP[]	= "nop",
		MnemonicORA[]	= "ora",
		MnemonicPHA[]	= "pha",
		MnemonicPHP[]	= "php",
		MnemonicPLA[]	= "pla",
		MnemonicPLP[]	= "plp",
		MnemonicROL[]	= "rol",
		MnemonicROR[]	= "ror",
		MnemonicRTI[]	= "rti",
		MnemonicRTS[]	= "rts",
		MnemonicSBC[]	= "sbc",
		MnemonicSEC[]	= "sec",
		MnemonicSED[]	= "sed",
		MnemonicSEI[]	= "sei",
		MnemonicSTA[]	= "sta",
		MnemonicSTX[]	= "stx",
		MnemonicSTY[]	= "sty",
		MnemonicTAX[]	= "tax",
		MnemonicTAY[]	= "tay",
		MnemonicTSX[]	= "tsx",
		MnemonicTXA[]	= "txa",
		MnemonicTXS[]	= "txs",
		MnemonicTYA[]	= "tya";


// mnemonics of undocumented ("illegal") 6502 instructions
const char	MnemonicSLO[]	= " SLO",
		MnemonicRLA[]	= " RLA",
		MnemonicSRE[]	= " SRE",
		MnemonicRRA[]	= " RRA",
		MnemonicSAX[]	= " SAX",
		MnemonicLAX[]	= " LAX",
		MnemonicDCP[]	= " DCP",
		MnemonicISC[]	= " ISC",
		MnemonicANC[]	= " ANC",
		MnemonicARR[]	= " ARR",
		MnemonicASR[]	= " ASR",
		MnemonicSBX[]	= " SBX",
		MnemonicDOP[]	= " DOP",
		MnemonicTOP[]	= " TOP",
		MnemonicSHX[]	= " SHX",
		MnemonicJAM[]	= " JAM";

// mnemonics of 65c02 instructions
const char	MnemonicBRA[]	= "bra",
		MnemonicPHX[]	= "phx",
		MnemonicPHY[]	= "phy",
		MnemonicPLX[]	= "plx",
		MnemonicPLY[]	= "ply",
		MnemonicSTZ[]	= "stz",
		MnemonicTRB[]	= "trb",
		MnemonicTSB[]	= "tsb";

// mnemonics of 65816 instructions
const char	MnemonicJML[]	= "jml",
		MnemonicJSL[]	= "jsl",
		MnemonicMVN[]	= "mvn",
		MnemonicMVP[]	= "mvp",
		MnemonicPEI[]	= "pei",
		MnemonicBRL[]	= "brl",
		MnemonicPER[]	= "per",
		MnemonicCOP[]	= "cop",
		MnemonicPEA[]	= "pea",
		MnemonicREP[]	= "rep",
		MnemonicSEP[]	= "sep",
		MnemonicPHB[]	= "phb",
		MnemonicPHD[]	= "phd",
		MnemonicPHK[]	= "phk",
		MnemonicPLB[]	= "plb",
		MnemonicPLD[]	= "pld",
		MnemonicRTL[]	= "rtl",
		MnemonicSTP[]	= "stp",
		MnemonicTCD[]	= "tcd",
		MnemonicTCS[]	= "tcs",
		MnemonicTDC[]	= "tdc",
		MnemonicTSC[]	= "tsc",
		MnemonicTXY[]	= "txy",
		MnemonicTYX[]	= "tyx",
		MnemonicWAI[]	= "wai",
		MnemonicWDM[]	= "wdm",
		MnemonicXBA[]	= "xba",
		MnemonicXCE[]	= "xce";
