---
title: 'GEOGRAM: a programming library with geometric algorithms'
tags:
  - geometry
  - mesh generation
  - 3D modelling
authors:
  - name: Bruno Lévy
    orcid: 0000-0002-7007-3219
    equal-contrib: false
    affiliation: "1, 2, 3"
affiliations:
 - name: INRIA Saclay, France
   index: 1
 - name: Université Paris-Saclay, France
   index: 2
 - name: Laboratoire de Mathématiques d'Orsay, France
   index: 3
date: 4 February 2025
bibliography: geogram.bib
---

# Summary

Geogram is a programming library with geometric algorithms. It has
geometry-processing functionalities (reconstruction, parameterization,
remeshing, boolean operations...). It also has lower-level algorithm
(Delaunay/Voronoi, geometric search, solving linear systems...).

Geogram received the [Symposium on Geometry Processing Software Award](http://awards.geometryprocessing.org/)
in 2023.

Geogram contains the main results in Geometry Processing from the former
ALICE Inria project, that is, more than [30 research articles](https://github.com/BrunoLevy/geogram/wiki/Publications)
published in ACM SIGGRAPH, ACM Transactions on Graphics, Symposium on Geometry
Processing and Eurographics. It was supported by two grants from the
European Research Council (ERC): GOODSHAPE and VORPALINE.

# Statement of need

# High-level Functionalities

## Pointset pre-processing

## Surface reconstruction

![Poisson and Co3Ne reconstruction.\label{fig:recon}](https://github.com/BrunoLevy/geogram/wiki/tutorials/Recon_arma_compare.png)

Tagada Tugudu Pouet Pouet

## Remeshing

Tagada Tugudu Pouet Pouet

## Parameterization and Texturing

Tagada Tugudu Pouet Pouet

## Intersection, boolean operations and CSG

# Low-level functionalities

## Exact numbers, exact predicates

## Delaunay triangulations in 2D

## Delaunay triangulations in 3D

## Mesh data structure

## Geometric search

## Spectral mesh processing

## Linear solver

## GLUP: OpenGL without the agonizing pain

# Acknowledgements

Tagada Tugudu Pouet Pouet

# References
